
<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class update_app extends CI_Controller {
	
	function index(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		if($this->session->userdata('idgroup')>1){
			show_404();
		}
		$data['page_title'] = 'UPDATE APLIKASI SIPP';
		$data['main_body'] = 'update/update';
		$data['app_ver'] = $this->session->userdata('app_version');
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}

	function importFile(){
		$url =base_url('resources/db_file/noteV2.sql');
		$sql = file_get_contents($url);
		$sqls = explode(';', $sql);
		array_pop($sqls);
		foreach($sqls as $statement){
			$statment = $statement . ";";
			$this->db->query($statement); 
		}
	}

	function check_progress(){
		echo $this->nativesession->get('update_progress');
	}
	function validateUpdate(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('idgroup')>1){
			echo json_encode(array('st'=>0,'msg'=>'Anda Tidak Memiliki Kewenangan Untuk Mengakses Halaman Ini.'));
			return;
		}

		$this->load->model('update/update','patching');

		$this->nativesession->set('update_progress', 2);
		$this->nativesession->set('counter', 0);

		//$this->patching->exe_script('SET GLOBAL log_bin=0;');
		$this->patching->exe_script('SET FOREIGN_KEY_CHECKS=0;');
		$data = array(
			'id' => 7,
			'nama' => 'Kong Hu Cu',
			'aktif' => 'Y'
			);
		$this->patching->replace_data('agama',$data);

		$data = array(
			'id' => 0,
			'nama' => 'Tidak Ditahan',
			'aktif' => 'Y'
			);
		$this->patching->replace_data('jenis_tahanan',$data);

		$data = array(
			'id' => 81,
			'category' => 'site',
			'name' => 'IDPN'
			);
		$this->patching->replace_data('sys_config',$data);

		$data = array(
			'id' => 82,
			'category' => 'site',
			'name' => 'kode_satker'
			);
		$this->patching->replace_data('sys_config',$data);

		$this->patching->exe_script("UPDATE sys_groups SET parent_id = 10, LEVEL = 5 WHERE groupid =702;");
		$sql = 'CREATE OR REPLACE VIEW v_sum_perkara_biaya AS SELECT perkara_id, tahapan_id, SUM(CASE WHEN jenis_transaksi = 1 THEN jumlah ELSE 0 END ) AS pemasukan, 
					SUM( CASE WHEN jenis_transaksi = -1 THEN jumlah ELSE 0 END) AS pengeluaran
					FROM perkara_biaya
					GROUP BY perkara_id, tahapan_id;';
		$this->patching->exe_script($sql);

		$isThere = $this->patching->isColumnExist('jurusita','jabatan');
		if(empty($isThere)){
			$this->patching->exe_script("ALTER TABLE jurusita 
					ADD jabatan CHAR(1) NOT NULL DEFAULT 2 COMMENT '1.Jurusita;2.Jurusita Pengganti' AFTER nama_gelar;");
		}
		
		$this->patching->exe_script("ALTER IGNORE TABLE proses_alur_perkara
			ADD UNIQUE INDEX (alur_perkara_id, tahapan_id, proses_id);");
		
		$isThere = $this->patching->isColumnExist('alur_perkara','jenis_pengadilan');
		if(empty($isThere)){
			$sql = "ALTER TABLE alur_perkara   
					ADD COLUMN jenis_pengadilan CHAR(1) NULL AFTER urutan,
					DROP INDEX kode,
					DROP INDEX nama;";
			$this->patching->exe_script($sql);
		}
		$this->load->dbforge();
		$isThere = $this->patching->isColumnExist('sys_menus','language');
		if(!empty($isThere)){
			$this->patching->exe_script("ALTER TABLE sys_menus 
										DROP COLUMN language,
										DROP COLUMN target, 
										DROP COLUMN access, 
										DROP COLUMN img, 
										DROP COLUMN home, 
										DROP COLUMN lock_by, 
										DROP COLUMN lock_on, 
										DROP COLUMN created_by, 
										DROP COLUMN created_on, 
										DROP COLUMN modified_by, 
										DROP COLUMN modified_on, 
										DROP COLUMN lft,  
  										CHANGE link link VARCHAR(255) NOT NULL,
  										CHANGE params params VARCHAR(255) NULL,
										DROP COLUMN rgt;");
		}
		$this->patching->exe_script("UPDATE status_pihak
			SET nama = REPLACE(nama, 'Penasehat', 'Penasihat')
			WHERE nama LIKE '%penasehat%';");

		
		$this->patching->exe_script("DROP TABLE IF EXISTS perkara_matra;");
		$this->patching->exe_script("CREATE TABLE perkara_matra (
			perkara_id BIGINT(20) unsigned NOT NULL,
			matra CHAR(4) DEFAULT NULL,
			berkas_dari VARCHAR(100) DEFAULT NULL,
			tanggal_kejadian VARCHAR(500) NULL,
			tempat_kejadian TEXT DEFAULT NULL,
			tanggal_skeppera DATE DEFAULT NULL,
			nomor_skeppera VARCHAR(50) DEFAULT NULL,
			pejabat_skeppera VARCHAR(50) NULL,
			tanggal_surat_dakwaan DATE DEFAULT NULL,
			nomor_surat_dakwaan VARCHAR(50) DEFAULT NULL,
			penyidik_mil VARCHAR(100) NULL,
			no_bap_penyidik_mil VARCHAR(100) NULL,
			tgl_penyidik_mil DATE NULL,
			diedit_oleh VARCHAR(30) DEFAULT NULL,
			diedit_tanggal DATETIME DEFAULT NULL,
			diinput_oleh VARCHAR(30) DEFAULT NULL,
			diinput_tanggal DATETIME DEFAULT NULL,
			diperbaharui_oleh VARCHAR(30) DEFAULT NULL,
			diperbaharui_tanggal DATETIME DEFAULT NULL,
			PRIMARY KEY (perkara_id),
			CONSTRAINT perkara_id_fk FOREIGN KEY (perkara_id) REFERENCES perkara (perkara_id) ON DELETE CASCADE
		) ENGINE=InnoDB;");


		$this->patching->exe_script("DROP TABLE IF EXISTS template_dokumen_agenda;");
		$this->patching->exe_script("CREATE TABLE template_dokumen_agenda (
			  id SMALLINT(6) NOT NULL,
			  jenis_agenda_id SMALLINT(6) DEFAULT NULL,
			  section CHAR(8) DEFAULT NULL,
			  konten_dokumen TEXT,
			  preview VARCHAR(150) DEFAULT NULL,
			  urutan SMALLINT(6) DEFAULT NULL,
			  type VARCHAR(50) DEFAULT NULL,
			  PRIMARY KEY (id)
			) ENGINE=InnoDB;");
		$this->patching->exe_script("REPLACE INTO template_dokumen_agenda (id, jenis_agenda_id, section, konten_dokumen, preview, urutan, type)
				VALUES
					(0,NULL,NULL,NULL,'Oditur Tidak Hadir',NULL,NULL),
					(1,0,'pembuka','#nama_pengadilan# melaksanakan sidang secara terbuka untuk umum yang  mengadili perkara pidana pada tingkat pertama menurut acara pemeriksaan biasa pada hari #hari_sidang#  tanggal #tanggal_sidang# di #nama_kota# dalam perkara #para/terdakwa#: \\\par \\\par #identitas_terdakwa# \\\par \\\par \\\ltrpar\\\qc \\\li0\\\\ri0\\\nowidctlpar\\\wrapdefault\\\\rin0\\\lin0\\\itap0\\\pararsid15693245 \\\\rtlch\\\\fcs1\\\alang1033 \\\ul \\\ltrch\\\\fcs0\\\lang1033\\\langfe1033\\\cgrid\\\langnp1033\\\langfenp1033\\\ul\\\b SUSUNAN MAJELIS SIDANG \\\b0 \\\ul0 \\\par \\\par\\\pard \\\ltrpar\\\qj \\\\fi855\\\li0 #susunan_majelis# \\\par \\\par #tunggal/ketua# membuka sidang pada pukul #jam_sidang# dan menyatakan bahwa sidang terbuka untuk umum diikuti ketukan palu 3 (tiga) kali. Selanjutnya #tunggal/ketua# memerintahkan #jaksa# untuk menghadapkan #para/terdakwa# masuk ke ruang sidang. \\\par \\\par#para/terdakwa# dibawa masuk dengan pengawalan tetapi dalam keadaan bebas. Atas pertanyaan #tunggal/ketua#, #para/terdakwa# menerangkan bahwa ia adalah: \\\par \\\par#identitas_terdakwa_second# \\\line \\\line selanjutnya #tunggal/ketua# menanyakan kepada #para/terdakwa#,  apakah #para/terdakwa# dalam keadaan sehat dan dijawab oleh #para/terdakwa# dalam keadaaan sehat. \\\par \\\par#tunggal/ketua# menanyakan apakah #para/terdakwa# perlu didampingi Penasihat Hukum dan dijawab oleh #para/terdakwa# bahwa ia #tidak/didampingi# Penasihat Hukum. \\\par \\\par\\\par \\\par Setelah itu #tunggal/ketua# menanyakan apakah #para/terdakwa# pernah ditahan dan dijawab #para/terdakwa# #pernah/tidak# ditahan.','Segment Pembuka Sidang Pertama',1,NULL),
					(2,0,'pembuka','#nama_pengadilan# yang melaksanakan sidang lanjutan secara terbuka untuk umum yang mengadili perkara pidana pada tingkat pertama menurut acara pemeriksaan biasa pada hari #hari_sidang# tanggal #tanggal_sidang# di #nama_kota# dalam perkara #para/terdakwa#: \\\par \\\par #identitas_terdakwa# \\\par \\\par Susunan Majelis sama dengan susunan persidangan sebelumnya. \\\par \\\par #tunggal/ketua# membuka sidang pada pukul #jam_sidang# dan menyatakan bahwa sidang terbuka untuk umum diikuti ketukan palu 1 (satu) kali. Selanjutnya #tunggal/ketua# memerintahkan #jaksa# untuk menghadapkan #para/terdakwa# masuk ke ruang sidang, #para/terdakwa# dibawa masuk dengan pengawasan tetapi dalam keadaan bebas, selanjutnya #tunggal/ketua# menayakan tentang keadaan kesehatan #para/terdakwa# dan dijawab sehat dan siap pemeriksaannya dilanjutkan. ','Segment Pembuka Sidang Lanjutan',2,NULL),
					(5,1,'isi','#tunggal/ketua# menanyakan kepada #para/terdakwa# apakah ia sudah mengerti benar akan isi dakwaan tersebut, yang dijawab bahwa ia sudah mengerti. \\\par','Terdakwa mengerti pada isi dakwaan',1,'dropdown'),
					(6,1,'isi','#tunggal/ketua# menanyakan kepada #para/terdakwa# apakah ia sudah mengerti benar akan isi dakwaan tersebut, yang dijawab bahwa ia kurang mengerti. \\\line Selanjutnya #tunggal/ketua# memerintahkan kepada #jaksa# agar memberikan penjelasan perbuatan yang didakwakan sampai #para/terdakwa# mengerti. \\\par ','Terdakwa kurang mengerti pada isi dakwaan',2,'dropdown'),
					(7,2,'isi','Atas pertanyaan #tunggal/ketua#, #para/terdakwa# menerangkan bahwa ia tidak mengajukan keberatan. \\\par ','Terdakwa tidak mengajukan eksepsi',1,'dropdown'),
					(8,2,'isi','Atas pertanyaan #tunggal/ketua#, #para/terdakwa# menerangkan bahwa ia akan mengajukan keberatan, akan tetapi #para/terdakwa# menyatakan belum siap dengan keberatannya dan mohon waktu. \\\par #tunggal/ketua# memberi kesempatan kepada #para/terdakwa# untuk mempersiapkan keberatannya tanggal _____.\\\par ','Terdakwa mengajukan eksepsi (belum siap)',2,'dropdown'),
					(9,2,'isi','Atas pertanyaan #tunggal/ketua#, #para/terdakwa# menerangkan bahwa ia akan mengajukan keberatan, selanjutnya #tunggal/ketua# mempersilahkan Terdakwa/Penasihat Hukum untuk menyampaikan keberatan kemudian Terdakwa/Penasihat Hukum membaca keberatan yang pada pokoknya sebagai berikut: \\\par \\\par #isian# \\\par ','Terdakwa mengajukan eksepsi (sudah siap)',3,'dropdown;input_text'),
					(10,3,'isi','Setelah #tunggal/ketua# memberikan kesempatan kepada #jaksa# untuk mengemukakan pendapatnya tentang Keberatan tersebut, #jaksa# membacakan tanggapan atas keberatan, yang pada pokoknya sebagai berikut: \\\par \\\par #isian# \\\par ','Tanggapan oditur atas eksepsi',1,'dropdown;input_text'),
					(11,3,'isi','Setelah #tunggal/ketua# memberikan kesempatan kepada #jaksa# untuk mengemukakan pendapatnya tentang Keberatan tersebut, #jaksa# menyatakan belum siap dengan tanggapannya. \\\par ','Tanggapan oditur atas eksepsi (belum siap)',2,'dropdown'),
					(12,4,'isi',NULL,'Pilih',1,'dropdown'),
					(13,4,'isi','Kemudian #tunggal/ketua# membacakan Putusan Sela yang amarnya adalah sebagai berikut: \\\par \\\par #isian_putusan_sela# \\\par ','Pembacaan Putusan Sela',2,'dropdown;'),
					(14,5,'isi',NULL,'Pilih',1,'dropdown'),
					(15,5,'isi','Setelah #tunggal/ketua# memberikan kesempatan kepada #Terdakwa/PenasihatHukum# untuk mengemukakan perlawanan, #Terdakwa/PenasihatHukum# membacakan perlawanan yang pada pokoknya sebagai berikut: \\\par \\\par #isian# \\\par ','Isi Perlawanan',2,'dropdown;input_text'),
					(16,6,'isi','Atas pertanyaan #tunggal/ketua#, #jaksa# menerangkan bahwa ia telah memanggil Saksi-saksi dalam perkara ini. #tunggal/ketua# memperingatkan agar Saksi-saksi tidak saling berhubungan satu dengan yang lain terutama membicarakan mengenai perkara yang akan diperiksa sebelum memberi keterangan dalam sidang. \\\par \\\par #tunggal/ketua# memerintahkan agar #para/terdakwa# pindah dari kursi pemeriksaan ketempat duduk #para/terdakwa# di #tempat yang telah disediakan/samping kanan Penasihat Hukum#, kemudian setelah mendengar pendapat #jaksa# dan #Terdakwa/PenasihatHukum# tentang urutan pemeriksaan para Saksi, #tunggal/ketua# memerintahkan agar Saksi Nomor urut satu dipanggil masuk ke dalam ruang sidang. \\\par \\\par #looping_saksi# \\\par \\\par Atas pertanyaan Hakim Ketua, baik Oditur maupun Terdakwa tidak mengajukan saksi tambahan. \\\par ','pemeriksaan saksi',1,'dropdown;tanya_jawab'),
					(17,7,'isi','Setelah pemeriksaan terhadap saksi/para saksi #tunggal/ketua# memerintahkan kepada #para/terdakwa# untuk  duduk  kembali  di kursi   pemeriksaan, \n#looping_pemeriksaan_terdakwa#\nSetelah pemeriksaan terhadap Terdakwa selesai, kemudian #tunggal/ketua memperlihatkan barang bukti kepada #para/terdakwa# dan saksi/para saksi serta menanyakan  sangkut paut barang bukti tersebut dengan perkara #para/terdakwa#. Setelah pemeriksaan terhadap saksi/para saksi, #para/terdakwa# dan barang bukti dianggap cukup, #tunggal/ketua# menyatakan pemeriksaan selesai. \\\par \\\par (Selanjutnya dalam perkara susila /rahasia militer, Hakim Ketua menyatakan  sidang terbuka untuk umum dengan diikuti ketukan palu  satu kali). \\\par ','pemeriksaan terdakwa',1,'dropdown;tanya_jawab'),
					(18,9,'isi','Setelah #tunggal/ketua# menyatakan sidang dibuka kembali dan dinyatakan tetap terbuka untuk umum, yang diikuti dengan ketukan palu 1 (satu)  kali, #tunggal/ketua# memerintahkan #jaksa# untuk membawa #para/terdakwa#  masuk ke ruang sidang. #tunggal/ketua# menanyakan tentang keadaan kesehatan #para/terdakwa#, dan dijawab sehat, selanjutnya #tunggal/ketua# memerintahkan kepada #para/terdakwa# untuk berdiri dan mendengarkan pembacaan tuntutan #jaksa#. Setelah dipersilahkan oleh #tunggal/ketua#, #jaksa# membacakan tuntutannya yang pada akhirnya menuntut supaya #para/terdakwa# \\\par \\\par #isian_penuntutan# \\\par','Pembacaan tuntutan',1,'dropdown'),
					(19,10,'isi','Sesudah membacakan tuntutannya, #jaksa# menyerahkan tuntutannya kepada #tunggal/ketua#. Atas tuntutan #jaksa# tersebut #para/terdakwa# menyatakan: \\\par \\\par Bahwa ia hendak mengajukan pembelaan sendiri. \\\par \\\par Setelah diberi kesempatan oleh #tunggal/ketua#, #Terdakwa/PenasihatHukum# membacakan pembelaannya yang isinya pada pokoknya sebagai berikut: \\\line \\\line #isian# \\\par ','Terdakwa Mengajukan Pembelaan Sendiri',1,'dropdown;input_text'),
					(20,10,'isi','Sesudah membacakan tuntutannya, #jaksa# menyerahkan tuntutannya kepada #tunggal/ketua#. Atas tuntutan #jaksa# tersebut #para/terdakwa# menyatakan: \\\par \\\par Bahwa ia menyerahkan pembelaannya kepada Penasihat Hukum \\\par \\\par Setelah diberi kesempatan oleh #tunggal/ketua#, #Terdakwa/PenasihatHukum# membacakan pembelaannya yang isinya pada pokoknya sebagai berikut: \\\line \\\line #isian# \\\par ','Terdakwa Mengajukan Pembelaan kepada Penasihat Hukum',2,'dropdown;input_text'),
					(21,10,'isi','Bahwa ia tidak mengajukan pembelaan tetapi menyatakan penyesalannya dan berjanji tidak akan melakukan tindak pidana lagi serta memohon agar dijatuhi pidana seringan-ringannya. \\\par ','Terdakwa tidak mengajukan pembelaan',3,'dropdown'),
					(22,11,'isi',NULL,'Pilih',1,'dropdown'),
					(23,11,'isi','Atas pembelaan tersebut #tunggal/ketua# memberikan kesempatan kepada #jaksa# untuk mengajukan jawaban (replik) terhadap pembelaan dari #Terdakwa/Penasihat Hukum#. \\\par \\\par #tunggal/ketua# memberikan kesempatan kepada #Terdakwa/Penasihat Hukum# untuk menyampaikan jawaban atas replik dari #jaksa# yang pada pokoknya sebagai berikut: \\\line \\\line  #isian# \\\par ','Replik (isian)',2,'dropdown;input_text'),
					(24,12,'isi',NULL,'Pilih',1,'dropdown'),
					(25,12,'isi','#tunggal/ketua# memberikan kesempatan kepada #Terdakwa/PenasihatHukum# untuk menyampaikan jawaban atas replik dari #jaksa# yang pada pokoknya sebagai berikut: \\\line \\\line #isian# \\\par \\\par Setelah itu #tunggal/ketua# menyatakan bahwa pemeriksaan dinyatakan ditutup, selanjutnya #tunggal/ketua# menunda sidang untuk mengadakan musyawarah Majelis Hakim guna mengambil putusan dengan diikuti ketukan palu 1 (satu) kali. \\\par ','Duplik (isian)',2,'dropdown;input_text'),
					(26,13,'isi','Kemudian setelah sidang dibuka kembali dan dinyatakan tetap terbuka untuk umum, dengan diikuti ketukan palu 1 (satu) kali, #tunggal/ketua# memerintahkan kepada #para/terdakwa# untuk berdiri dan mendengarkan putusan Pengadilan. #tunggal/ketua# mengucapkan putusan pengadilan yang amarnya berbunyi sebagai berikut: \\\par \\\par #amar_putusan#. \\\par \\\par Setelah membacakan putusan Pengadilan, #tunggal/ketua# memberitahukan kepada #para/terdakwa# akan hak-haknya : \\\line 1. Hak segera menerima atau segera menolak putusan. \\\line 2. Hak mempelajari putusan sebelum menyatakan menerima atau menolak putusan dalam tenggang waktu yang ditentukan oleh UU.Nomor.31 Tahun 1997 yaitu 7 hari. \\\line 3. Hak untuk mengajukan grasi apabila menerima putusan dalam hal Terdakwa dijatuhi pidana mati, pidana penjara seumur hidup atau pidana penjara paling rendah 2 tahun. \\\line 4. Hak minta diperiksa perkaranya dalam tingkat banding dalam tenggang waktu 7 hari. \\\line 5. Hak mencabut pernyataan menerima atau menolak dalam tenggang waktu 7 hari setelah putusan diucapkan. \\\par \\\par Atas pemberitahuan akan hak-haknya tersebut, Terdakwa menyatakan sikap #sikap_terdakwa_putusan#. \\\par \\\par #jaksa# menyatakan #sikap_jaksa_putusan# \\\par ','Pembacaan putusan',1,'dropdown'),
					(27,-1,'penutup','Setelah #hakim/majelis# bermusyawarah selanjutnya #tunggal/ketua# memberitahukan bahwa sidang akan ditunda untuk #tundaan_sidang# dan sidang akan ditunda hari #hari_tundaan_sidang# tanggal #tanggal_tundaan_sidang#, #tunggal/ketua# memerintahkan #jaksa# untuk membawa #para/terdakwa# keluar ruang sidang pukul #jam_selesai_sidang# #tunggal/ketua# menyatakan menunda sidang guna #tundaan_sidang#, diikuti ketukan palu 1 (satu) kali. \\\par \\\par nDemikian Berita Acara Sidang ini dibuat dengan sebenarnya, yang ditanda tangani oleh #tunggal/ketua# dan Panitera tersebut di atas dengan mengingat sumpah jabatan dan ditutup pada hari dan tanggal tersebut diatas. \\\par ','Penutup Opsi 1',1,'penutup'),
					(28,-1,'penutup','Setelah Majelis bermusyawarah selanjutnya #tunggal/ketua# memberitahukan bahwa sidang akan ditunda untuk memberi kesempatan kepada #jaksa# untuk menghadirkan kembali Terdakwa ________________ yang tidak hadir dan sidang akan ditunda hari #hari_tundaan_sidang# tanggal #tanggal_tundaan_sidang#, #tunggal/ketua#  memerintahkan  #jaksa# untuk membawa #para/terdakwa# keluar ruang sidang pukul #jam_selesai_sidang# #tunggal/ketua# menyatakan menunda sidang guna memberi kesempatan kepada #jaksa# untuk menghadirkan kembali Terdakwa yang tidak hadir, diikuti ketukan palu 1 (satu) kali. \\\par \\\par Demikian Berita Acara Sidang ini dibuat dengan sebenarnya, yang ditanda tangani oleh #tunggal/ketua# dan Panitera tersebut di atas dengan mengingat sumpah jabatan dan ditutup pada hari dan tanggal tersebut diatas. \\\par ','Terdakwa Tidak Hadir',2,'penutup'),
					(29,-1,'penutup','#tunggal/ketua# memberitahukan bahwa sidang akan ditunda guna memberikan kesempatan kepada #para/terdakwa# untuk menyusun eksepsi, dan sidang akan dilanjutkan pada hari #hari_tundaan_sidang# tanggal #tanggal_tundaan_sidang#. Kemudian #tunggal/ketua# memerintahkan #jaksa#  untuk membawa #para/terdakwa# keluar ruang sidang. #tunggal/ketua# menyatakan sidang ditunda guna memberi kesempatan kepada Terdakwa  menyusun eksepsinya dan akan dibuka kembali hari #tanggal_tundaan_sidang#, dengan diikuti ketukan palu 1(satu) kali. \\\par \\\par Demikian Berita Acara Sidang ini dibuat dengan sebenarnya, yang ditanda tangani oleh #tunggal/ketua# dan Panitera tersebut di atas dengan mengingat sumpah jabatan dan ditutup pada hari dan tanggal tersebut diatas. \\\par ','Menyusun eksepsi',3,'penutup'),
					(30,-1,'penutup','#tunggal/ketua# memberitahukan bahwa sidang akan ditunda guna memberikan kesempatan kepada #jaksa# untuk menyusun tanggapan atas keberatan #para/terdakwa#, dan sidang akan dilanjutkan pada hari #hari_tundaan_sidang# tanggal #tanggal_tundaan_sidang#. Kemudian #tunggal/ketua# memerintahkan #jaksa#  untuk membawa #para/terdakwa# keluar ruang sidang. #tunggal/ketua# menyatakan sidang ditunda guna memberi kesempatan kepada Oditur Militer  menyusun tanggapannya atas eksepsi Terdakwa dan akan dibuka kembali hari #tanggal_tundaan_sidang#, dengan diikuti ketukan palu 1(satu) kali. \\\par \\\par Demikian Berita Acara Sidang ini dibuat dengan sebenarnya, yang ditanda tangani oleh #tunggal/ketua# dan Panitera tersebut di atas dengan mengingat sumpah jabatan dan ditutup pada hari dan tanggal tersebut diatas.  \\\par ','Menyusun tanggapan eksepsi',4,'penutup'),
					(31,-1,'penutup','Setelah Majelis bermusyawarah selanjutnya #tunggal/ketua# memberitahukan bahwa sidang akan ditunda untuk memberi kesempatan kepada #jaksa# untuk memanggil kembali Saksi ________________ yang tidak hadir dan sidang akan ditunda hari #hari_tundaan_sidang# tanggal #tanggal_tundaan_sidang#, #tunggal/ketua#  memerintahkan  #jaksa# untuk membawa #para/terdakwa# keluar ruang sidang pukul #jam_selesai_sidang# #tunggal/ketua# menyatakan menunda sidang guna memberi kesempatan kepada #jaksa# untuk memanggil kembali Saksi yang tidak hadir, diikuti ketukan palu 1 (satu) kali. \\\par \\\par Demikian Berita Acara Sidang ini dibuat dengan sebenarnya, yang ditanda tangani oleh #tunggal/ketua# dan Panitera tersebut di atas dengan mengingat sumpah jabatan dan ditutup pada hari dan tanggal tersebut diatas. \\\par ','Saksi tidak hadir',5,'penutup'),
					(32,-1,'penutup',NULL,'Menghadirkan Saksi Tambahan',6,'penutup'),
					(33,-1,'penutup','#tunggal/ketua# memberitahukan bahwa sidang akan ditunda guna pemeriksaan barang bukti, dan sidang akan dilanjutkan pada hari #hari_tundaan_sidang# tanggal #tanggal_tundaan_sidang#. Kemudian #tunggal/ketua# memerintahkan #jaksa#  untuk membawa #para/terdakwa# keluar ruang sidang. #tunggal/ketua# menyatakan menunda sidang guna pemeriksaan barang bukti dan akan dibuka kembali hari #tanggal_tundaan_sidang#, dengan diikuti ketukan palu 1(satu) kali. \\\par \\\par Demikian Berita Acara Sidang ini dibuat dengan sebenarnya, yang ditanda tangani oleh #tunggal/ketua# dan Panitera tersebut di atas dengan mengingat sumpah jabatan dan ditutup pada hari dan tanggal tersebut diatas. \\\par ','Pemeriksaan Barang Bukti',7,'penutup'),
					(34,-1,'penutup','#tunggal/ketua# memberitahukan bahwa sidang akan ditunda guna pembacaan tuntutan, dan sidang akan dilanjutkan pada hari #hari_tundaan_sidang# tanggal #tanggal_tundaan_sidang#. Kemudian #tunggal/ketua# memerintahkan #jaksa#  untuk membawa #para/terdakwa# keluar ruang sidang. #tunggal/ketua# menyatakan menunda sidang guna pembacaan tuntutan dan akan dibuka kembali hari #tanggal_tundaan_sidang#, dengan diikuti ketukan palu 1(satu) kali. \\\par \\\par Demikian Berita Acara Sidang ini dibuat dengan sebenarnya, yang ditanda tangani oleh #tunggal/ketua# dan Panitera tersebut di atas dengan mengingat sumpah jabatan dan ditutup pada hari dan tanggal tersebut diatas. \\\par ','Tuntutan',8,'penutup'),
					(35,-1,'penutup','#tunggal/ketua# memberitahukan bahwa sidang akan ditunda guna memberikan kesempatan kepada #terdakwa/PenasihatHukum# untuk menyusun pembelaan, dan sidang akan dilanjutkan pada hari #hari_tundaan_sidang# tanggal #tanggal_tundaan_sidang#. Kemudian #tunggal/ketua# memerintahkan #jaksa#  untuk membawa #para/terdakwa# keluar ruang sidang. #tunggal/ketua# menyatakan menunda sidang guna memberi kesempatan kepada #jaksa#  menyusun pembelaannya (pledoi) dan akan dibuka kembali hari #tanggal_tundaan_sidang#, dengan diikuti ketukan palu 1(satu) kali. \\\par \\\par Demikian Berita Acara Sidang ini dibuat dengan sebenarnya, yang ditanda tangani oleh #tunggal/ketua# dan Panitera tersebut di atas dengan mengingat sumpah jabatan dan ditutup pada hari dan tanggal tersebut diatas. \\\par ','Pembelaan',9,'penutup'),
					(36,-1,'penutupp','#tunggal/ketua# memberitahukan bahwa sidang akan ditunda guna memberikan kesempatan kepada #jaksa# untuk menyusun replik, dan sidang akan dilanjutkan pada hari #hari_tundaan_sidang# tanggal #tanggal_tundaan_sidang#. Kemudian #tunggal/ketua# memerintahkan #jaksa#  untuk membawa #para/terdakwa# keluar ruang sidang. #tunggal/ketua# menyatakan menunda sidang guna memberi kesempatan kepada #jaksa#  menyusun replik dan akan dibuka kembali hari #tanggal_tundaan_sidang#, dengan diikuti ketukan palu 1(satu) kali. \\\par \\\par Demikian Berita Acara Sidang ini dibuat dengan sebenarnya, yang ditanda tangani oleh #tunggal/ketua# dan Panitera tersebut di atas dengan mengingat sumpah jabatan dan ditutup pada hari dan tanggal tersebut diatas. \\\par ','Replik',10,'penutup'),
					(37,-1,'penutup','#tunggal/ketua# memberitahukan bahwa sidang akan ditunda guna memberikan kesempatan kepada #terdakwa/PenasihatHukum# untuk menyusun duplik, dan sidang akan dilanjutkan pada hari #hari_tundaan_sidang# tanggal #tanggal_tundaan_sidang#. Kemudian #tunggal/ketua# memerintahkan #jaksa#  untuk membawa #para/terdakwa# keluar ruang sidang. #tunggal/ketua# menyatakan menunda sidang guna memberi kesempatan kepada #terdakwa/PenasihatHukum#  menyusun duplik dan akan dibuka kembali hari #tanggal_tundaan_sidang#, dengan diikuti ketukan palu 1(satu) kali. \\\par \\\par Demikian Berita Acara Sidang ini dibuat dengan sebenarnya, yang ditanda tangani oleh #tunggal/ketua# dan Panitera tersebut di atas dengan mengingat sumpah jabatan dan ditutup pada hari dan tanggal tersebut diatas. \\\par ','Duplik',11,'penutup'),
					(38,-1,'penutup',NULL,'Putusan Sela',12,'penutup'),
					(39,-1,'penutup','Setelah #hakim/majelis# bermusyawarah selanjutnya #tunggal/ketua# memberitahukan bahwa sidang akan ditunda guna pembacaan putusan dan sidang akan ditunda hari #hari_tundaan_sidang# tanggal #tanggal_tundaan_sidang#, #tunggal/ketua# memerintahkan #jaksa# untuk membawa #para/terdakwa# keluar ruang sidang pukul #jam_selesai_sidang# #tunggal/ketua# menyatakan menunda sidang guna pembacaan putusan, diikuti ketukan palu 1 (satu) kali. \\\par \\\par Demikian Berita Acara Sidang ini dibuat dengan sebenarnya, yang ditanda tangani oleh #tunggal/ketua# dan Panitera tersebut di atas dengan mengingat sumpah jabatan dan ditutup pada hari dan tanggal tersebut diatas. \\\par ','Putusan',13,'penutup'),
					(40,14,'isi','#isian#','Skorsing',1,'dropdown;input_text'),
					(1000,100,'pembuka','Persidangan #nama_pengadilan# yang memeriksa, memutus dan menyelesaikan sengketa tata usaha negara pada peradilan tingkat pertama dengan acara biasa yang dilangsungkan di gedung #nama_pengadilan# di #nama_kota# pada hari #hari_sidang#, tanggal #tanggal_sidang# jam #jam_sidang#, dalam sengketa antara: \\\par #looping_penggugat# \\\line\\\par \\\qc\\\li0\\\\fi0 \\\b M e l a w a n : \\\b0\\\line \\\par \\\ql #looping_tergugat#\\\line \\\par\\\\fi0\\\b Susunan Persidangan : \\\b0\\\par #susunan_majelis# \\\par \\\par \\\\fi709 Setelah persidangan dibuka oleh #tunggal/ketua# Sidang dan dinyatakan terbuka untuk umum, maka kedua belah pihak dipanggil masuk ke ruang sidang: \\\par #kehadiran_sidang# \\\par \\\pard ','Segment pembuka sidang',1,NULL),
					(1001,101,'isi','Selanjutnya #tunggal/ketua# Sidang membacakan gugatan yang atas pertanyaan #tunggal/ketua# Sidang, Penggugat menyatakan tetap pada isi gugatannya; \\\par ','Penggugat tetap pada isi gugatannya',1,'dropdown'),
					(1003,102,'isi','Atas pertanyaan #tunggal/ketua# Sidang, #kuasa/tergugat# menyerahkan Jawabannya tertanggal #tanggal_sidang#, terlampir sebagai berikut:\\\par \\\par \\\par \\\par \\\par \\\par\\\par \\\par \\\par \\\par \\\par \\\par ( ISI JAWABAN )\\\par \\\par \\\par \\\par \\\par \\\par \n\\\par \\\par \\\par \\\par \\\par \\\par Kemudian Salinan Jawaban diserahkan kepada #kuasa/penggugat# guna dipelajari untuk menyusun Replik; \\\par','Pembacaan Jawaban',1,'dropdown'),
					(1004,103,'isi','Selanjutnya atas pertanyaan #tunggal/ketua# Sidang, #para/penggugat# menyerahkan Replik tertanggal #tanggal_sidang# terlampir sebagai berikut: \\\par\\\par\\\par\\\par\\\par\\\par \n\\\par\\\par\\\par\\\par\\\par\\\par \n( ISI REPLIK ) \\\par\\\par\\\par\\\par\\\par\\\par \n\\\par\\\par\\\par\\\par\\\par\\\par Kemudian #tunggal/ketua# Sidang menyerahkan salinannya kepada #tergugat/kuasa# guna dipelajari untuk menyusun Duplik;','Replik',1,'dropdown'),
					(1005,104,'isi','Selanjutnya atas pertanyaan #tunggal/ketua# Sidang, #tergugat/kuasa# menyerahkan Duplik tertanggal #tanggal_sidang# terlampir sebagai berikut :\\\par\\\par\\\par\\\par\\\par\\\par \n\\\par\\\par\\\par\\\par\\\par\\\par ( ISI DUPLIK ) \n\\\par\\\par\\\par\\\par\\\par\\\par \n\\\par\\\par\\\par\\\par\\\par\\\par Kemudian #tunggal/ketua# Sidang menyerahkan salinannya kepada #penggugat/kuasa#; ','Duplik',1,'dropdown'),
					(1006,105,'isi','Atas pertanyaan #tunggal/ketua# Sidang, #penggugat/kuasa# menyerahkan Bukti Surat berupa fotokopi yang telah dilegalisir dan bermeterai cukup diberi tanda P - 1 sampai dengan P ?\\\highlight7 ___\\\highlight0, setelah dicocokan dengan aslinya ternyata sesuai dengan aslinya, terinci sebagai berikut: \\\par \n#isian# \\\par \nKemudian oleh #tunggal/ketua# Sidang, bukti surat tersebut dicocokkan dengan aslinya / foto copynya dan diperlihatkan kepada Pihak #tergugat/kuasa#, kemudian dimasukkan kedalam berkas perkara; \\\par ','Pemeriksaan Bukti Penggugat',1,'dropdown;input_text'),
					(1007,106,'isi','Atas pertanyaan #tunggal/ketua# Sidang, #tergugat/kuasa# menyerahkan Bukti Surat berupa fotokopi yang telah dilegalisir dan bermeterai cukup diberi tanda T - 1 sampai dengan T -\\\highlight7 ___\\\highlight0, setelah dicocokan dengan aslinya ternyata sesuai dengan aslinya, terinci sebagai berikut: \\\par \n#isian# \\\par \nKemudian oleh #tunggal/ketua# Sidang, bukti surat tersebut dicocokkan dengan aslinya / foto copynya dan diperlihatkan kepada Pihak #penggugat/kuasa#, kemudian dimasukkan kedalam berkas perkara; \\\par ','Pemeriksaan Bukti Tergugat',1,'dropdown;input_text'),
					(1008,107,'isi','Atas pertanyaan #tunggal/ketua# Sidang, #penggugat/kuasa# menyatakan siap mengajukan saksi \\\highlight7 ___\\\highlight0  orang yang akan menerangkan tentang \\\highlight7 ___\\\highlight0 ;','Pemeriksaan Saksi Penggugat',1,'dropdown;'),
					(1009,108,'isi','Atas pertanyaan #tunggal/ketua# Sidang, #tergugat/kuasa# menyatakan siap mengajukan saksi \\\highlight7 ___\\\highlight0  orang yang akan menerangkan tentang \\\highlight7 ___\\\highlight0 ;','Pemeriksaan Saksi Tergugat',1,'dropdown;'),
					(1010,109,'isi','Atas pertanyaan #tunggal/ketua# Sidang, #penggugat/kuasa# dan #tergugat/kuasa# masing-masing menyerahkan Kesimpulan, terlampir sebagai berikut : \\\par \\\par \\\par\\\par\\\par\\\par\\\par\\\par ( ISI KESIMPULAN ) \\\par\\\par\\\par\\\par\\\par\\\par Kemudian #tunggal/ketua# Sidang menyerahkan salinannya kepada #penggugat/kuasa#; \\\par ','Kesimpulan',1,'dropdown;'),
					(1011,110,'isi','Kemudian #tunggal/ketua# Sidang membacakan Putusan yang amarnya sebagai berikut: \\\par \\\par\n#amar_putusan# \\\par ','Pembacaan Putusan',1,'dropdown;'),
					(1500,-100,'penutup','Oleh karena tidak ada lagi hal-hal yang akan disampaikan oleh Para Pihak, kemudian #tunggal/ketua# Sidang menyatakan persidangan sudah cukup dan ditunda, serta menetapkan persidangan berikutnya pada: \\\par #detail_tunda_sidang# \\\line serta memberitahukan penundaan tersebut kepada kedua belah pihak yang berperkara di persidangan agar mereka hadir pada hari sidang yang telah ditetapkan itu dengan tidak dipanggil lagi karena pemberitahuan ini merupakan panggilan resmi; \\\par Setelah Hakim Ketua mengumumkan penundaan persidangan, lalu sidang ditutup; \\\par Demikian Berita Acara Persidangan dibuat dengan ditandatangani oleh Hakim Ketua Sidang dan Panitera Pengganti. \\\par ','Segment penutup sidang',NULL,NULL),
					(2000,200,'pembuka','\\\\fi720\\\\ri-1 #nama_pa# yang memeriksa dan mengadili perkara tertentu pada tingkat pertama yang dilangsungkan di ruang sidang #JENIS_SATKER# tersebut, pada hari #HARI_SIDANG# tanggal #TGL_SIDANG# dalam perkara Nomor #NOMOR_PERKARA# antara: \\\par #loopingpenggugat#\\\par\\\qc\\\\fi0 melawan \\\par\\\ql\\\\fi720 #loopingtergugat#\\\par Susunan majelis yang bersidang: \\\par \\\\fi-284\\\li284\\\tx284\\\tx4395 #susunan_majelis# \\\li0\\\\fi720 Setelah sidang dibuka dan dinyatakan terbuka untuk umum oleh Ketua Majelis, #SEBAGAI_P# dan #SEBAGAI_T# dipanggil menghadap ke  persidangan; \\\par #kehadiran_sidang# ','Segment pembuka sidang pertama',1,NULL),
					(2002,201,'isi','\\\\ri-1\\\qj Sebelum pemeriksaan lebih lanjut Pemohon/Penggugat menerangkan bahwa Pemohon/Penggugat keberatan terhadap Ketua Majelis/ Hakim Anggota yang bersidang dalam perkara ini dan Pemohon/Penggugat mempunyai bukti bahwa Ketua Majelis/ Hakim Anggota tersebut mempunyai hubungan \\\highlight7 ............\\\highlight0  (hubungan darah/semenda dengan Termohon/Tergugat atau ada kepentingan langsung atau tidak langsung dengan perkara yang sedang diperiksa);\\\par ','Penolakan Hakim',1,'dropdown;'),
					(2003,201,'isi','\\\\ri-1\\\qj Sebelum pemeriksaan lebih lanjut Pemohon/Penggugat menerangkan bahwa Pemohon/Penggugat keberatan terhadap Panitera Pengganti yang bersidang dalam perkara ini dan Pemohon/Penggugat mempunyai bukti bahwa Panitera Pengganti tersebut mempunyai hubungan \\\highlight7 ............\\\highlight0       (hubungan darah/semenda dengan Termohon/Tergugat atau ada kepentingan langsung atau tidak langsung dengan perkara yang sedang diperiksa);\\\par ','Penolakan Panitera Pengganti',2,'dropdown'),
					(2004,202,'isi','#SEBAGAI_P# dan #SEBAGAI_T#, sepakat memilih Saudara/i. #NAMA_MEDIATOR# sebagai mediator, dan atas dasar itu #tunggal/ketua# menetapkan mediator tersebut dengan penetapan sebagai berikut:  \\\par\\\par\\\par\\\par\\\par\\\par\\\par \\\par\\\par\\\par\\\par\\\par\\\par ( LAMPIRAN PENETAPAN MEDIATOR) \\\par\\\par\\\par\\\par\\\par\\\par \\\par\\\par\\\par\\\par\\\par\\\par ','Sepakat Mediasi',1,'dropdown;'),
					(2005,202,'isi','#SEBAGAI_P# dan #SEBAGAI_T#, tidak sepakat memilih mediator, dan atas dasar itu #tunggal/ketua# menunjuk Saudara/i. #NAMA_MEDIATOR# sebagai mediator dengan penetapan sebagai berikut:  \\\par\\\par\\\par\\\par\\\par\\\par\\\par \\\par\\\par\\\par\\\par\\\par\\\par ( LAMPIRAN PENETAPAN MEDIATOR) \\\par\\\par\\\par\\\par\\\par\\\par \\\par\\\par\\\par\\\par\\\par\\\par ','Tidak Sepakat Mediasi',2,'dropdown;'),
					(2006,203,'isi','Ini baru diset\\par\n#isian# \\\par ','Tergugat Mengajukan Eksepsi (sudah siap)',2,'dropdown;input_text'),
					(2007,203,'isi','Redaksi Eksepsi Tergugat Belum Siap','Tergugat mengajukan Eksepsi (belum siap)',3,'dropdown;'),
					(2008,204,'isi','Redaksi Pemeriksaan Barang Bukti','Pemeriksaan Barang Bukti',1,'dropdown'),
					(2009,205,'isi','Redaksi Pemeriksaan Saksi','Pemeriksaan Saksi',1,'dropdown'),
					(2010,206,'isi',NULL,NULL,1,'dropdown'),
					(2011,207,'isi',NULL,NULL,1,'dropdown'),
					(2012,208,'isi',NULL,NULL,1,'dropdown'),
					(2013,209,'isi',NULL,NULL,1,'dropdown'),
					(2014,210,'isi',NULL,NULL,1,'dropdown'),
					(2015,211,'isi',NULL,NULL,1,'dropdown'),
					(2500,-200,'penutup','Penutup BAS ','penutupan',1,'penutup'),
					(2501,-200,'penutup','\\\qj \\\\fi720\\\li0\\\\ri-1 #SEBAGAI_T# tidak menghadap ke persidangan sekalipun menurut relaas Nomor #NOMOR_PERKARA#, tanggal \\\highlight7 #TGL_SIDANG_TUNDA#\\\highlight0  yang dibacakan di  persidangan, #SEBAGAI_T# telah dipanggil secara resmi dan patut untuk menghadap ke persidangan; \\\par\\\qj\\\\fi720\\\li0\\\\ri-1 Selanjutnya #tunggal/ketua# menunda sidang sampai dengan hari #HARI_SIDANG_TUNDA#  tanggal #TGL_SIDANG_TUNDA#, pukul 09.00 #ZONA#, untuk memanggil #SEBAGAI_T# dan memerintahkan \\\highlight7 Jurusita/Jurusita Pengganti \\\highlight0  memanggil kembali #SEBAGAI_T# untuk menghadap ke persidangan pada hari dan tanggal yang telah ditetapkan di atas serta memberitahu #SEBAGAI_P# untuk hadir kembali  pada hari dan tanggal tersebut tanpa dipanggil lagi; \\\par\\\qj\\\\fi720\\\li0\\\\ri-1 Setelah penundaan sidang tersebut diumumkan, selanjutnya #tunggal/ketua# menyatakan sidang ditutup; \\\par\\\qj\\\\fi720\\\li0\\\\ri-1 Demikian berita acara sidang ini dibuat dan ditandatangani oleh #tunggal/ketua# serta Panitera Pengganti;','Tergugat Tidak Hadir',2,'penutup'),
					(2502,-200,'penutup','Redaksi Penutup Pihak P tidak hadir','Penggugat Tidak Hadir',3,'penutup'),
					(2503,-200,'penutup','Setelah pembacaan putusan tersebut, #tunggal/ketua# menyatakan sidang selesai dan ditutup;\\\par Demikian berita acara sidang ini dibuat dan ditandatangani oleh #tunggal/ketua# serta Panitera Pengganti.','Putusan Akhir',4,'penutup');");
		
		$this->patching->exe_script("DROP TABLE IF EXISTS template_dokumen;");
		$this->patching->exe_script("CREATE TABLE template_dokumen (
			  	id int (11),
				alur_perkara_id int (11),
				tahapan_id int (11),
				proses_id int (11),
				nomor int (11),
				kode varchar (150),
				nama varchar (600),
			  PRIMARY KEY (id),
			  UNIQUE KEY kode (kode)
			) ENGINE=InnoDB;");
		$this->patching->exe_script("INSERT INTO template_dokumen (id, alur_perkara_id, tahapan_id, proses_id, nomor, kode, nama)
				VALUES
					('142','1','15','210','1','PDT_1_15_210_1','Putusan Perdata Kabul'),
					('143','1','15','210','2','PDT_1_15_210_2','Putusan Perdata Tolak Gugatan'),
					('144','1','15','210','3','PDT_1_15_210_3','Putusan Perdata Gugatan'),
					('145','1','15','210','4','PDT_1_15_210_4','Putusan Perdata (Format Gugur)'),
					('146','1','15','210','5','PDT_1_15_210_5','Putusan Perdata (Format Verstek)'),
					('147','1','15','210','6','PDT_1_15_210_6','Putusan Perdata (Format Verzet-Kabul Perlawanan)'),
					('148','1','15','210','7','PDT_1_15_210_7','Putusan Perdata (Format Rekonvensi)'),
					('149','1','15','210','8','PDT_1_15_210_8','Putusan Perdata (Format Rekonvensi Tidak Ada Hubungan)'),
					('150','1','15','210','9','PDT_1_15_210_9','Putusan Perdata (Format Intervensi Vrijwaring)'),
					('151','1','15','210','10','PDT_1_15_210_10','Putusan Perdata (Format Intervensi Tussenkomst)'),
					('152','1','15','210','11','PDT_1_15_210_11','Putusan Perdata (Format Intervensi Voeging)'),
					('153','1','15','210','12','PDT_1_15_210_12','Putusan Perdata (Format Putusan Provisi)'),
					('154','1','15','210','13','PDT_1_15_210_13','Putusan Perdata (Format Putusan Sela tentang Eksepsi Kewenangan Dikabulkan)'),
					('155','1','15','210','14','PDT_1_15_210_14','Putusan Perdata - Berita Acara (Format Putusan Sela tentang Eksepsi Kewenangan Ditolak)'),
					('156','1','15','210','15','PDT_1_15_210_15','Putusan Perdata - Berita Acara (Format Putusan Sela Tentang Sumpah Discoir)'),
					('157','1','15','210','16','PDT_1_15_210_16','Putusan Perdata - Berita Acara (Format Putusan Sela Tentang Sumpah Supletoir)'),
					('158','1','15','210','17','PDT_1_15_210_17','Putusan Perdata (Denden Verzet)'),
					('159','1','15','210','18','PDT_1_15_210_18','Berita Acara (Permohonan Pasal 225HIR - 295RBg)'),
					('160','1','15','210','19','PDT_1_15_210_19','Putusan Perdata (Permohonan Pasal 225HIR - 295RBg)'),
					('161','111','15','210','1','PID_111_15_210_1','Putusan Pidana (Format Biasa Bebas)'),
					('162','118','15','210','2',NULL,'Putusan Pidana Anak (Format Biasa Bebas)'),
					('163','111','15','210','3','PID_111_15_210_3','Putusan Pidana (Format Biasa Terbukti)'),
					('164','118','15','210','4','PID_118_15_210_4','Putusan Pidana Anak (Format Biasa Terbukti)'),
					('165','111','15','210','5','PID_111_15_210_5','Putusan Pidana (Format Biasa Lepas)'),
					('166','118','15','210','6',NULL,'Putusan Pidana Anak (Format Biasa Lepas)'),
					('167','111','15','210','7','PID_111_15_210_7','Putusan Sela - Keberatan diputus bersama Putusan Akhir'),
					('168','111','15','210','8','PID_111_15_210_8','Putusan Sela - Keberatan Diterima'),
					('169','111','15','210','9','PID_111_15_210_9','Putusan Sela - Keberatan Tidak Diterima'),
					('170','111','15','210','10','PID_111_15_210_10','Putusan (Format Penuntutan Penuntut Umum tidak dapat diterima)'),
					('171','115','15','210','13',NULL,'Putusan Pidana Khusus Tipikor - Format Biasa Bebas'),
					('172','1','14','200','101','PDT_1_14_200_101','Relaas Panggilan Pertama Kepada Penggugat'),
					('173','1','14','200','103','PDT_1_14_200_103','Relaas Panggilan Pertama Kepada Penggugat Meninggal Dunia Bertemu Ahli Waris'),
					('174','1','14','200','109','PDT_1_14_200_109','Relaas Panggilan Kepada Kuasa Penggugat'),
					('175','1','14','200','113','PDT_1_14_200_113','Relaas Panggilan Kepada Ahli Waris Penggugat Bertemu'),
					('176','1','14','200','150','PDT_1_14_200_150','Relaas Panggilan Kepada Saksi'),
					('177','1','14','200','151','PDT_1_14_200_151','Relaas Panggilan Kepada Ahli'),
					('178','1','14','200','152','PDT_1_14_200_152','Relaas Panggilan Kepada Juru Bahasa'),
					('179','1','14','200','153','PDT_1_14_200_153','Relaas Panggilan Kepada Penerjemah'),
					('201','1','15','230','201',NULL,'Relaas Pemberitahuan Putusan Kepada Tergugat dan Verstek'),
					('202','1','15','230','240',NULL,'Relaas Pemberitahuan Putusan Kepada Kuasa Penggugat All'),
					('203','1','15','230','241',NULL,'Relaas Pemberitahuan Putusan Kepada Kuasa Tergugat All'),
					('205','1','14','200','115','PDT_1_14_200_115','Relaas Panggilan Pertama Kepada Tergugat Bertemu'),
					('206','1','14','200','117','PDT_1_14_200_117','Relaas Panggilan Pertama Kepada Tergugat Meninggal Bertemu Ahli Waris'),
					('209','1','14','200','135','PDT_1_14_200_135','Relaas Panggilan Selanjutnya Kepada Kuasa Tergugat Bertemu'),
					('211','1','14','200','143','PDT_1_14_200_143','Relaas Panggilan Kepada Tergugat Tempat Tinggal Tidak Ditemukan'),
					('212','1','14','200','144','PDT_1_14_200_144','Relaas Panggilan Kepada Tergugat Cerai Tempat Tinggal Tidak Ditemukan'),
					('213','111','20','300','251','PID_111_20_300_251','Relaas Pemberitahuan Pernyataan Banding Kepada Penuntut Umum'),
					('214','111','20','300','252','PID_111_20_300_252','Relaas Pemberitahuan Pernyataan Banding Kepada Terdakwa'),
					('215','111','20','340','255','PID_111_20_340_255','Relaas Penyerahan Kontra Memori Banding Kepada Terdakwa'),
					('216','111','20','340','256','PID_111_20_340_256','Relaas Penyerahan Kontra Memori Banding Kepada Penuntut Umum'),
					('217','111','30','420','263','PID_111_30_420_263','Relas Pemberitahuan Permohonan Kasasi Kepada Penuntut Umum'),
					('218','111','30','420','264','PID_111_30_420_264','Relas Pemberitahuan Permohonan Kasasi Kepada Terdakwa'),
					('219','111','30','460','267','PID_111_30_460_267','Relaas Penyerahan Kontra Memori Kasasi Kepada Penuntut Umum'),
					('220','111','30','460','268','PID_111_30_460_268','Relaas Penyerahan Kontra Memori Kasasi Kepada Terdakwa'),
					('221','111','40','200','275',NULL,'Relaas Panggilan Sidang Peninjauan Kembali Terdakwa'),
					('222','111','40','200','276',NULL,'Relaas Panggilan Sidang Peninjauan Kembali JPU'),
					('301','111','14','200','301','PID_111_14_200_301','Berita Acara Persidangan Pidana Biasa'),
					('302','112','14','200','312','PID_112_14_200_312','Berita Acara Persidangan Pidana Singkat'),
					('303','113','14','200','322','PID_113_14_200_322','Berita Acara Persidangan Pidana Cepat'),
					('304','111','40','510','323','PID_111_30_410_323','Berita Acara Persidangan Peninjauan Kembali'),
					('305','111','30','410','326','PID_111_30_410_326','Berita Acara Pendapat Peninjauan Kembali'),
					('306','1','14','200','350','PDT_1_14_200_350','Berita Acara Persidangan Perdata Gugatan'),
					('307','1','14','200','360','PDT_1_14_200_360','Berita Acara Persidangan Mediasi Gugur'),
					('308','1','14','200','362','PDT_1_14_200_362','Berita Acara Persidangan Mediasi Berhasil'),
					('309','1','14','200','364','PDT_1_14_200_364','Berita Acara Persidangan Tergugat Tidak Hadir'),
					('310','1','14','200','365','PDT_1_14_200_365','Berita Acara Persidangan Putusan Sela Terima Tolak'),
					('311','1','14','200','369','PDT_1_14_200_369','Berita Acara Persidangan Putusan Verstek'),
					('312','1','14','200','373','PDT_1_14_200_373','Berita Acara Sita Revindicatoir'),
					('313','5','14','200','301','PDT_5_14_200_301','Berita Acara atas Hak Kekayaan Intelektual'),
					('314','6','14','200','301','PDT_6_14_200_301','Berita Acara Persidangan Pengadilan Hubungan Industrial - Verstek '),
					('315','3','14','200','301','PDT_3_14_200_301','Berita Acara Persidangan Pailit'),
					('316','6','14','200','304','PDT_6_14_200_304','Berita Acara Persidangan Pengadilan Hubungan Industrial'),
					('317','3','14','200','307','PDT_3_14_200_307','Berita Acara Persidangan Renvoi Prosedur'),
					('318','4','14','200','301','PDT_4_14_200_301','Berita Acara Persidangan PKPU Debitor'),
					('319','4','14','200','304','PDT_4_14_200_304','Berita Acara Persidangan PKPU Kreditor'),
					('320','4','14','200','309','PDT_4_14_200_309','Berita Acara Persidangan PKPU'),
					('321','3','14','200','2','PDT_3_14_200_2','Berita Acara Persidangan Actio Pauliana'),
					('322','111','12','200','9','PID_111_12_200_9','Penetapan Penolakan Perpanjangan Tahanan Penyidik oleh Ketua Pengadilan Negeri'),
					('323','111','12','200','10','PID_111_12_200_10','Penetapan Penolakan Perpanjangan Tahanan Penuntut oleh Ketua Pengadilan Negeri'),
					('324','111','12','200','11','PID_111_12_200_11','Penetapan Perpanjangan Tahanan Hakim oleh Ketua Pengadilan Negeri'),
					('325','111','12','200','12','PID_111_12_200_12','Penetapan Perpanjangan Tahanan Penyidik oleh Ketua Pengadilan Negeri Pasal 25 ayat 1'),
					('326','111','12','200','13','PID_111_12_200_13','Penetapan Perpanjangan Tahanan Penyidik oleh Ketua Pengadilan Negeri Pasal 29 ayat 2'),
					('327','111','12','200','14','PID_111_12_200_14','Penetapan Perpanjangan Tahanan Penuntut Umum oleh Ketua Pengadilan Negeri Pasal 25'),
					('328','111','12','200','15','PID_111_12_200_15','Penetapan Perpanjangan Tahanan PU oleh Ketua Pengadilan Negeri Pasal 29 ayat 1'),
					('329','111','12','200','16','PID_111_12_200_16','Penetapan Perpanjangan Tahanan PU oleh Ketua Pengadilan Negeri Pasal 29 ayat 2'),
					('330','111','12','200','17','PID_111_12_200_17','Penetapan Perpanjangan Tahanan Hakim oleh Ketua Pengadilan Tinggi Pasal 29 ayat 1'),
					('331','111','12','200','18','PID_111_12_200_18','Penetapan Perpanjangan Tahanan Hakim oleh Ketua Pengadilan Tinggi Pasal 29 ayat 2'),
					('333','111','12','20','1','PID_111_12_20_1','Penetapan Penunjukan Majelis Hakim atau Hakim Tunggal'),
					('334','111','12','30','1','PID_111_12_30_1','Penunjukan Panitera Pengganti'),
					('335','111','12','80','1','PID_111_12_80_1','Penetapan Hari Sidang Pertama Pidana'),
					('336','111','12','80','2',NULL,'Penetapan Hari Sidang Pertama PU Tidak Hadir'),
					('337','111','12','200','2','PID_111_12_200_2','Penetapan Penahanan Hakim Pengadilan Negeri'),
					('338','111','12','200','3','PID_111_12_200_3','Penetapan Penahanan Terdakwa Hakim PN Sidang Berjalan'),
					('339','111','12','200','1','PID_111_12_200_1','Penetapan Pembantaran Penahanan'),
					('340','111','12','200','5','PID_111_12_200_5','Penetapan Penangguhan Penahanan Dengan Jaminan Orang'),
					('341','111','12','200','4','PID_111_12_200_4','Penetapan Penangguhan Penahanan Dengan Jaminan Uang'),
					('342','111','12','200','6','PID_111_12_200_6','Penetapan Penangguhan Penahanan Tanpa Jaminan'),
					('343','111','12','200','7','PID_111_12_200_7','Penetapan Pengalihan Penahanan Dengan Permohonan'),
					('344','111','12','200','8','PID_111_12_200_8','Penetapan Pengalihan Penahanan Tanpa Permohonan'),
					('345','113','12','20','1','PID_113_12_20_1','Penetapan Hakim Tunggal Perkara Cepat'),
					('350','111','20','290','601','PID_111_20_290_601','Akta Permintaan Banding Oleh Terdakwa'),
					('351','111','20','290','602','PID_111_20_290_602','Akta Permintaan Banding Oleh Terdakwa Tidak Menghadap'),
					('352','111','20','290','603','PID_111_20_290_603','Akta Permintaan Banding Oleh Penasihat Hukum'),
					('353','111','20','290','604','PID_111_20_290_604','Akta Permintaan Banding Oleh Penuntut Umum'),
					('354','111','20','290','605','PID_111_20_290_605','Akta Pencabutan Banding Oleh Terdakwa'),
					('355','111','20','290','606','PID_111_20_290_606','Akta Pencabutan Banding Oleh Terdakwa Tidak Menghadap'),
					('356','111','20','290','607','PID_111_20_290_607','Akta Pencabutan Banding Oleh Penasihat Hukum'),
					('357','111','20','290','608','PID_111_20_290_608','Akta Pencabutan Banding Oleh Penuntut Umum'),
					('358','111','20','340','257','PID_111_20_340_257','Relaas Penyerahan Kontra Memori Banding Kepada Pemohon Banding'),
					('359','111','20','340','258',NULL,'Relaas Penyerahan Kontra Memori Banding Kepada Pemohon Banding Delegasi'),
					('360','111','20','360','259','PID_111_20_360_259','Relaas Pemberitahuan Inzage Kepada Penuntut Umum'),
					('361','111','20','360','260','PID_111_20_360_260','Relaas Pemberitahuan Inzage Kepada Terdakwa'),
					('362','111','20','320','253','PID_111_20_320_253','Relaas Penyerahan Memori Banding Kepada Terdakwa'),
					('363','111','20','320','254','PID_111_20_320_254','Relaas Penyerahan Memori Banding Kepada Penuntut Umum'),
					('364','111','20','400','261','PID_111_20_400_261','Relaas Pemberitahuan Putusan Banding Kepada Penuntut Umum'),
					('365','111','20','400','262','PID_111_20_400_262','Relaas Pemberitahuan Putusan Banding Kepada Terdakwa'),
					('366','111','30','460','269','PID_111_30_460_269','Relaas Penyerahan Kontra Memori Kasasi Kepada Pemohon Kasasi'),
					('367','111','30','460','270',NULL,'Relaas Penyerahan Kontra Memori Kasasi Kepada Pemohon Kasasi Delegasi'),
					('368','111','30','440','265','PID_111_30_440_265','Relaas Penyerahan Memori Kasasi Kepada Terdakwa'),
					('369','111','30','440','266','PID_111_30_440_266','Relaas Penyerahan Memori Kasasi Kepada Penuntut Umum'),
					('370','111','30','500','271','PID_111_30_500_271','Relaas Pemberitahuan Putusan Kasasi Kepada Penuntut Umum'),
					('371','111','30','500','272','PID_111_30_500_272','Relaas Pemberitahuan Putusan Kasasi Kepada Terdakwa'),
					('376','111','40','510','637','PID_111_40_510_637','Akta Pencabutan Peninjauan Kembali Oleh Terdakwa'),
					('377','111','30','410','641','PID_111_30_410_641','Akta Tidak / Terlambat Mengajukan Kasasi'),
					('379','111','30','430','4','PID_111_30_430_4','Akta Penerimaan Memori Kasasi Terdakwa Tidak Menghadap'),
					('380','111','30','430','5','PID_111_30_430_5','Akta Penerimaan Memori Kasasi Penasihat Hukum'),
					('381','111','30','430','6','PID_111_30_430_6','Akta Penerimaan Memori Kasasi Penuntut Umum'),
					('382','111','40','510','638','PID_111_40_510_638','Akta Pencabutan Peninjauan Kembali Oleh Ahli Waris'),
					('405','111','40','510','636','PID_111_40_510_636','Akta Permintaan Peninjauan Kembali Oleh Penuntut Umum'),
					('406','111','40','510','635','PID_111_40_510_635','Akta Permintaan Peninjauan Kembali Oleh Kuasa Hukum Terpidana'),
					('407','111','40','510','634','PID_111_40_510_634','Akta Permintaan Peninjauan Kembali Oleh Ahli Waris'),
					('408','111','40','510','633','PID_111_40_510_633','Akta Permintaan Peninjauan Kembali Oleh Terpidana'),
					('409','111','30','410','999','PID_111_30_410_999','Akta Pencabutan Permohonan Kasasi Oleh Penuntut Umum'),
					('410','111','30','410','998','PID_111_30_410_998','Akta Pencabutan Permohonan Kasasi Oleh Kuasa Hukum'),
					('411','111','30','410','997','PID_111_30_410_997','Akta Pencabutan Permohonan Kasasi Terdakwa Tidak Hadir'),
					('412','111','30','410','996','PID_111_30_410_996','Akta Pencabutan Permohonan Kasasi Oleh Terdakwa'),
					('413','111','30','410','995','PID_111_30_410_995','Akta Permohonan Kasasi Oleh Penuntut Umum'),
					('414','111','30','410','994','PID_111_30_410_994','Akta Permohonan Kasasi Oleh Penasihat Hukum'),
					('415','111','30','410','993','PID_111_30_410_993','Akta Permohonan Kasasi Terdakwa Tidak Menghadap'),
					('416','111','30','410','992','PID_111_30_410_992','Akta Permohonan Kasasi Oleh Terdakwa'),
					('417','111','40','571','277','PID_111_40_571_277','Relaas Pemberitahuan Putusan Peninjauan Kembali Kepada Penuntut Umum'),
					('418','111','40','571','278','PID_111_40_571_278','Relaas Pemberitahuan Putusan Peninjauan Kembali Kepada Terpidana'),
					('420','111','30','430','3','PID_111_30_430_3','Akta Penerimaan Memori Kasasi Terdakwa'),
					('422','111','10','10','10','PID_111_10_10_10','Penetapan KPN Perkara Tidak Termasuk Wewenangnya'),
					('423','111','20','310','609','PID_111_20_310_609','Akta Penerimaan Memori Banding Oleh Terdakwa'),
					('424','111','20','310','610','PID_111_20_310_610','Akta Penerimaan Memori Banding Oleh Terdakwa Tidak Menghadap'),
					('425','111','20','310','611','PID_111_20_310_611','Akta Penerimaan Memori Banding Oleh Penasihat Hukum'),
					('426','111','20','310','612','PID_111_20_310_612','Akta Penerimaan Memori Banding Oleh Penuntut Umum'),
					('427','111','20','330','613','PID_111_20_330_613','Akta Penerimaan Kontra Memori Banding Oleh Terdakwa'),
					('428','111','20','330','614','PID_111_20_330_614','Akta Penerimaan Kontra Memori Banding Oleh Terdakwa Tidak Menghadap'),
					('429','111','20','330','615','PID_111_20_330_615','Akta Penerimaan Kontra Memori Banding Oleh Penasihat Hukum'),
					('430','111','20','330','616','PID_111_20_330_616','Akta Penerimaan Kontra Memori Banding Oleh Penuntut Umum'),
					('431','111','30','10','1',NULL,'Penetapan Kasasi Tidak Dapat Diterima'),
					('432','111','30','10','2',NULL,'Penetapan Terlambat Mengajukan Kasasi'),
					('433','111','30','10','3',NULL,'Penetapan Permohonan Kasasi Tidak Memenuhi Syarat Formal'),
					('434','111','12','200','19','PID_111_12_200_19','Penetapan Ijin Meninggalkan Atau Keluar Tahanan'),
					('435','111','15','230','279',NULL,'Pemberitahuan Putusan Tk. I Kepada Terdakwa'),
					('436','4','14','200','314','PDT_4_14_200_314','Berita Acara Counter Pailit'),
					('437','3','14','200','311',NULL,'Berita Rapat Kreditur Pertama'),
					('438','4','14','200','316',NULL,'Berita Rapat Kreditur Pertama'),
					('439','115','15','210','17',NULL,'Putusan Pidana Khusus Tipikor - Format Biasa Terbukti'),
					('440','115','15','210','21',NULL,'Putusan Pidana Khusus Tipikor - Format Biasa Lepas'),
					('441','117','15','210','12',NULL,'Putusan Pidana HAM - Format Biasa Bebas'),
					('442','117','15','210','16',NULL,'Putusan Pidana HAM - Format Biasa Terbukti'),
					('443','117','15','210','20',NULL,'Putusan Pidana HAM - Format Biasa Lepas'),
					('444','3','15','210','20','PDT_3_15_210_20','Putusan Perdata Pailit - Kabul'),
					('445','3','15','210','21','PDT_3_15_210_21','Putusan Perdata Pailit - Tolak'),
					('446','3','15','210','22','PDT_3_15_210_22','Putusan Perdata Pailit Voluntair - Kabul'),
					('447','3','15','210','23','PDT_3_15_210_23','Putusan Perdata Pailit Voluntair - Tolak'),
					('448','3','15','210','24',NULL,'Putusan Pembatalan Perdamaian - Kabul'),
					('449','3','15','210','25',NULL,'Putusan Pembatalan Perdamaian - Tolak'),
					('450','3','15','210','26','PDT_3_15_210_26','Putusan Perdata Pencabutan Kepailitan '),
					('451','3','15','210','27','PDT_3_15_210_27','Putusan Perdata Pengakhiran Kepailitan'),
					('452','4','15','210','28','PDT_4_15_210_28','Putusan Perdata PKPU Konter Pailit'),
					('453','4','15','210','29','PDT_4_15_210_29','Putusan Perdata PKPU Menjadi Pailit'),
					('454','4','15','210','30','PDT_4_15_210_30','Putusan Perdata PKPU Tetap - Kabul'),
					('455','4','15','210','31','PDT_4_15_210_31','Putusan Perdata PKPU Yang Diajukan Debitor - Kabul'),
					('456','4','15','210','32','PDT_4_15_210_32','Putusan Perdata PKPU Yang Diajukan Debitor - Tolak'),
					('457','4','15','210','33','PDT_4_15_210_33','Putusan Perdata PKPU Yang Diajukan Kreditor - Kabul'),
					('458','4','15','210','34','PDT_4_15_210_34','Putusan Perdata PKPU - Actio Pauliana'),
					('459','4','15','210','35','PDT_4_15_210_35','Putusan Perdata PKPU - Homologasi'),
					('460','4','15','210','36','PDT_4_15_210_36','Putusan Perdata PKPU - Rehabilitasi'),
					('461','4','15','210','37',NULL,'Putusan Perdata PKPU - Renvoi Prosedur'),
					('462','116','15','210','14',NULL,'Putusan Pidana Perikanan - Format Biasa Bebas'),
					('463','116','15','210','18',NULL,'Putusan Pidana Perikanan - Format Biasa Terbukti'),
					('464','116','15','210','22',NULL,'Putusan Pidana Perikanan - Format Biasa Lepas'),
					('466','6','15','210','45','PDT_6_15_210_45','Putusan Perdata PHI - Kabul'),
					('467','6','15','210','46','PDT_6_15_210_46','Putusan Perdata PHI - Tolak'),
					('468','6','15','210','47','PDT_6_15_210_47','Putusan Perdata PHI - Gugur'),
					('469','111','30','450','1','PID_111_30_450_1','Akta Penerimaan Kontra Memori Kasasi Terdakwa'),
					('470','111','30','450','2','PID_111_30_450_2','Akta Penerimaan Kontra Memori Kasasi Terdakwa Tidak Menghadap'),
					('471','111','30','450','3','PID_111_30_450_3','Akta Penerimaan Kontra Memori Kasasi Penasihat Hukum'),
					('472','111','30','450','4','PID_111_30_450_4','Akta Penerimaan Kontra Memori Kasasi Penuntut Umum'),
					('473','1','12','20','1','PDT_1_12_20_1','Penetapan Penunjukan Hakim atau Majelis Hakim'),
					('474','1','12','80','1','PDT_1_12_80_1','Penetapan Hari Sidang Pertama'),
					('475','1','15','230','250',NULL,'Penetapan Konsinyasi'),
					('476','111','30','410','642','PID_111_30_410_642','Surat Keterangan Terlambat Mengajukan Memori Kasasi'),
					('484','1','12','30','1','PDT_1_12_30_1','Penetapan Penunjukan Panitera Pengganti'),
					('485','6','15','210','48','PDT_6_15_210_48','Putusan Perdata PHI - Verstek'),
					('486','6','15','210','49','PDT_6_15_210_49','Putusan Perdata PHI - Verzet Kabul'),
					('487','6','15','210','50','PDT_6_15_210_50','Putusan Perdata PHI - Verzet Tolak'),
					('488','6','15','210','51','PDT_6_15_210_51','Putusan Perdata PHI - Kewenangan Absolut Eksepsi Kabul'),
					('489','6','15','210','52','PDT_6_15_210_52','Putusan Perdata PHI - Kewenangan Absolut Tolak'),
					('490','3','14','200','325','PDT_3_14_200_325','Berita Acara Permohonan Pailit dari Kreditur Diajukan PKPU oleh Debitur'),
					('491','4','14','200','319','PDT_4_14_200_319','Berita Acara Permohonan PKPU diajukan Debitor Dalam Permohonan Pailit'),
					('492','4','14','200','320','PDT_4_14_200_320','Berita Acara Permohonan PKPU diajukan Kreditor Tidak Terbantah'),
					('493','4','14','200','323',NULL,'Berita Acara Permohonan PKPU Diajukan Kreditor Termohon Tidak Hadir'),
					('494','6','15','210','53','PDT_6_15_210_53','Putusan Perdata PHI - Kewenangan Absolut Karena Jabatan (ambtshalve)'),
					('495','6','15','210','54','PDT_6_15_210_54','Putusan Perdata PHI - Kewenangan Relatif Kabul'),
					('496','6','15','210','55','PDT_6_15_210_55','Putusan Perdata PHI - Kewenangan Relatif Tolak'),
					('497','6','15','210','56','PDT_6_15_210_56','Putusan Perdata PHI - Konvensi dan Rekonvensi'),
					('498','5','15','210','30',NULL,'Putusan Perdata Hak Kekayaan Intelektual (HAKI)'),
					('499','5','14','200','999','PDT_5_14_200_999','Berita Acara Putusan HKI Eksepsi Tolak'),
					('500','111','15','230','280',NULL,'Pemberitahuan Putusan Tk. I Kepada Penuntut Umum'),
					('503','1','13','110','1',NULL,'Penetapan Hakim Mediator'),
					('504','1','15','640','4',NULL,'Penetapan Sita Jaminan (Conservatoir Beslag)'),
					('505','1','15','640','5',NULL,'Penetapan Sita Tahan Milik (Revindicatoir Beslag)'),
					('506','1','50','640','6',NULL,'Penetapan Sita Eksekusi (Eksecutorial Beslag)'),
					('507','1','50','640','7',NULL,'Penetapan Eksekusi Pengosongan'),
					('508','1','50','640','8',NULL,'Penetapan Eksekusi Riil Tanpa Didahului Sita Eksekusi'),
					('509','1','50','640','9',NULL,'Penetapan Eksekusi Riil Dengan Didahului Sita Eksekusi'),
					('510','1','50','640','10',NULL,'Penetapan Eksekusi Hak Tanggungan'),
					('511','1','50','640','11',NULL,'Penetapan Eksekusi Pengosongan oleh Pemenang Lelang'),
					('563','8','15','214','1','PDT_8_15_214_1','Penetapan Perkara Dismissal'),
					('564','8','15','212','1','PDT_8_15_212_1','Penetapan Perkara Gugur'),
					('565','8','15','210','1','PDT_8_15_210_1','Putusan Perdata Gugatan Sederhana (Format Hakim Tunggal)'),
					('566','8','15','210','2','PDT_8_15_210_2','Putusan Perdata Gugatan Sederhana (Format Majelis Hakim)'),
					('567','8','17','281','1','PDT_8_17_281_1','Akta Penerimaan Memori Keberatan Oleh Pemohon'),
					('568','8','17','281','2','PDT_8_17_281_2','Akta Penerimaan Kontra Memori Keberatan Oleh Termohon'),
					('569','2','12','20','1',NULL,'Penetapan Penunjukan Hakim atau Majelis Hakim'),
					('1436','119','14','200','998','PID_119_14_200_998','Berita Acara Persidangan Pra Peradilan'),
					('1437','1','14','200','102','PDT_1_14_200_102','Relaas Panggilan Pertama Kepada Penggugat Tidak Bertemu'),
					('1438','1','14','200','104','PDT_1_14_200_104','Relaas Panggilan Pertama Kepada Penggugat Meninggal Tidak Bertemu Ahli Waris'),
					('1439','1','14','200','105','PDT_1_14_200_105','Relaas Penggilan Selanjutnya Kepada Penggugat Bertemu'),
					('1440','1','14','200','106','PDT_1_14_200_106','Relaas Panggilan Selanjutnya Kepada Penggugat Tidak Bertemu'),
					('1441','1','14','200','107','PDT_1_14_200_107','Relaas Panggilan Selanjutnya Kepada Penggugat Meninggal Bertemu Ahli Waris'),
					('1442','1','14','200','108','PDT_1_14_200_108','Relaas Panggilan Selanjutnya Kepada Penggugat Meninggal Tidak Bertemu Ahli Waris'),
					('1443','1','14','200','110','PDT_1_14_200_110','Relaas Panggilan Pertama Kepada Kuasa Penggugat Tidak Bertemu'),
					('1444','1','14','200','111','PDT_1_14_200_111','Relaas Panggilan Pertama Kepada Kuasa Penggugat Meninggal Bertemu Penggugat'),
					('1445','1','14','200','112','PDT_1_14_200_112','Relaas Panggilan Pertama Kepada Kuasa Penggugat Meninggal Tidak Bertemu Penggugat'),
					('1446','1','14','200','114','PDT_1_14_200_114','Relaas Panggilan Kepada Ahli Waris Penggugat Tidak Bertemu'),
					('1447','1','14','200','116','PDT_1_14_200_116','Relaas Panggilan Pertama Kepada Tergugat Tidak Bertemu'),
					('1448','1','14','200','118','PDT_1_14_200_118','Relaas Panggilan Pertama Kepada Tergugat Meninggal Tidak Bertemu Ahli Waris'),
					('1449','1','14','200','119','PDT_1_14_200_119','Relaas Panggilan Selanjutnya Kepada Tergugat Bertemu'),
					('1450','1','14','200','120','PDT_1_14_200_120','Relaas Panggilan Selanjutnya Kepada Tergugat Tidak Bertemu'),
					('1451','1','14','200','121','PDT_1_14_200_121','Relaas Panggilan Selanjutnya Kepada Tergugat Meninggal Bertemu Ahli Waris'),
					('1452','1','14','200','122','PDT_1_14_200_122','Relaas Panggilan Selanjutnya Kepada Tergugat Meninggal Tidak Bertemu Ahli Waris'),
					('1453','1','14','200','131','PDT_1_14_200_131','Relaas Panggilan Selanjutnya Kepada Ahli Waris Tergugat Bertemu'),
					('1454','1','14','200','132','PDT_1_14_200_132','Relaas Panggilan Selanjutnya Kepada Ahli Waris Tergugat Tidak Bertemu'),
					('1455','1','14','200','136','PDT_1_14_200_136','Relaas Panggilan Selanjutnya Kepada Kuasa Tergugat Tidak Bertemu'),
					('1456','1','14','200','137','PDT_1_14_200_137','Relaas Panggilan Selanjutnya Kepada Kuasa Tergugat Meninggal Bertemu Tergugat'),
					('1457','1','14','200','138','PDT_1_14_200_138','Relaas Selanjutnya Kepada Kuasa Tergugat Meninggal Tidak Bertemu Tergugat'),
					('1458','1','15','230','1','PDT_1_15_230_1','Relaas Pemberitahuan Putusan Kepada Penggugat'),
					('1459','1','15','230','202','PDT_1_15_230_202','Relaas Pemberitahuan Putusan Kepada Penggugat Meninggal'),
					('1460','1','15','230','203','PDT_1_15_230_203','Relaas Pemberitahuan Putusan Kepada Kuasa Penggugat'),
					('1461','1','15','230','204','PDT_1_15_230_204','Relaas pemberitahuan Putusan Kepada Kuasa Penggugat Meninggal'),
					('1462','1','15','230','205','PDT_1_15_230_205','Relaas Pemberitahuan Putusan Kepada Ahli Waris Penggugat'),
					('1463','1','15','230','220','PDT_1_15_230_220','Relaas Pemberitahuan Putusan Kepada Tergugat'),
					('1464','1','15','230','221','PDT_1_15_230_221','Relaas Pemberitahuan Putusan Kepada Tergugat Meninggal'),
					('1465','1','15','230','222','PDT_1_15_230_222','Relaas Pemberitahuan Putusan Kepada Kuasa Tergugat'),
					('1466','1','15','230','223','PDT_1_15_230_223','Relaas Pemberitahuan Putusan Kepada Tergugat Tempat Tinggal Tidak Ditemukan'),
					('1467','1','15','230','224',NULL,'Relaas pemberitahuan Putusan Kepada Kuasa Tergugat Meninggal'),
					('1468','1','15','230','225','PDT_1_15_230_225','Relaas Pemberitahuan Putusan Kepada Ahli Waris Tergugat Meninggal'),
					('1469','1','15','230','230','PDT_1_15_230_230','Relaas Pemberitahuan Putusan Verstek Kepada Tergugat Bertemu Atau Tidak Bertemu'),
					('1470','1','15','230','231','PDT_1_15_230_231','Relaas Pemberitahuan Putusan Verstek Kepada Tergugat Prinsipal Meninggal'),
					('1471','1','15','230','232','PDT_1_15_230_232','Relaas Pemberitahuan Putusan Verstek Kepada Ahli Waris Tergugat Meninggal'),
					('1472','1','15','230','233','PDT_1_15_230_233','Relaas Pemberitahuan Putusan Verstek Kepada Tergugat Tempat Tinggal Tidak Ditemukan'),
					('1473','1','15','230','234','PDT_1_15_230_234','Relaas Pemberitahuan Putusan Verstek Kepada Tergugat Cerai Tempat Tinggal Tidak Ditemukan'),
					('1474','5','15','210','38','PDT_5_15_210_38','Putusan Perdata HKI Kabul'),
					('1475','5','15','210','39','PDT_5_15_210_39','Putusan Perdata HKI Tolak'),
					('1476','5','15','210','40','PDT_5_15_210_40','Putusan Perdata HKI NO'),
					('1477','111','40','510','639','PID_111_40_510_639','Akta Pencabutan Peninjauan Kembali Oleh Penasihat Hukum'),
					('1478','111','40','510','640','PID_111_40_510_640','Akta Pencabutan Peninjauan Kembali Oleh Penuntut Umum'),
					('1479','119','12','20','1','PID_119_12_20_1','Penetapan Penunjukan Majelis Hakim atau Hakim Tunggal Tanpa Kuasa'),
					('1480','119','12','30','1','PID_119_12_30_1','Penetapan Hari Sidang Pertama'),
					('1481','119','14','200','1','PID_119_14_200_1','Relaas Panggilan Kepada Pemohon'),
					('1482','119','14','200','2','PID_119_14_200_2','Relaas Panggilan Kepada Pemohon Tidak Bertemu'),
					('1483','119','14','200','3','PID_119_14_200_3','Relaas Panggilan Kepada Termohon'),
					('1484','119','15','210','1','PID_119_15_210_1','Putusan Praperadilan (Format Gugur)'),
					('1485','119','15','210','2','PID_119_15_210_2','Putusan Praperadilan (Format Kabul/Tolak)'),
					('1486','119','15','212','1','PID_119_15_212_1','Putusan Praperadilan (Format Penetapan Gugur)'),
					('1487','120','10','10','1','K_120_10_10_1','Penetapan Pengembalian Berkas Perkara'),
					('1489','120','10','10','3','K_120_10_10_3','Penetapan Pengembalian Berkas Perkara (BAP Tidak Lengkap)'),
					('1490','120','12','20','1','K_120_12_20_1','Penetapan Penunjukan Majelis Hakim '),
					('1491','120','12','20','2','K_120_12_20_2','Penunjukan Hakim Tunggal'),
					('1492','120','12','30','1','K_120_12_30_1','Penetapan Penunjukan Panitera'),
					('1493','120','12','80','1','K_120_12_80_1','Penetapan Hari Sidang'),
					('1494','120','12','200','1','K_120_12_200_1','Penetapan Terdakwa Tidak Mau Didampingi Penasihat Hukum'),
					('1495','120','14','200','1','K_120_14_200_1','Berita Acara Penolakan Didampingi Penasihat Hukum'),
					('1496','120','12','200','2','K_120_12_200_2','Penetapan Penahanan Oleh Hakim Ketua'),
					('1497','120','12','200','3','K_120_12_200_3','Penetapan Perpanjangan Penahanan Oleh Kadilmil'),
					('1498','120','12','200','4','K_120_12_200_4','Penetapan Pembebasan dari Tahanan Oleh Hakim Ketua'),
					('1499','120','12','200','5','K_120_12_200_5','Penetapan Pembebasan dari Tahanan Oleh Kadilmil'),
					('1500','120','12','200','6','K_120_12_200_6','Penetapan Menjalani Pidana'),
					('1501','120','10','10','4','K_120_10_10_4','Berita Acara Perubahan Surat Dakwaan'),
					('1502','120','10','10','5','K_120_10_10_5','Akta Penerimaan Perubahan Surat Dakwaan'),
					('1503','120','15','210','1','K_120_15_210_1','Putusan Sela'),
					('1504','120','16','240','1','K_120_16_240_1','Akta Permohonan Perlawanan'),
					('1505','120','16','240','2','K_120_16_240_2','Akta Pemberitahuan Permohonan Perlawanan'),
					('1506','120','16','240','3','K_120_16_240_3','Akta Penerimaan Memori Perlawanan'),
					('1507','120','16','240','4','K_120_16_240_4','Akta Pemberitahuan Isi Putusan Perlawanan Kepada Terdakwa'),
					('1508','120','16','240','5','K_120_16_240_5','Akta Pemberitahuan Isi Putusan Perlawanan Kepada Oditur'),
					('1509','120','15','210','2','K_120_15_210_2','Putusan (Terdakwa Tidak Hadir)'),
					('1510','120','10','10','6','K_120_10_10_6','Penetapan Penggabungan Perkara Gugatan Ganti Rugi'),
					('1511','120','14','200','2','K_120_14_200_2','Berita Acara Sidang'),
					('1512','120','14','200','3','K_120_14_200_3','Berita Acara Sidang Lanjutan'),
					('1513','120','14','200','4','K_120_14_200_4','Berita Acara Sidang Majelis'),
					('1514','121','15','210','1','P_121_15_210_1','Putusan (Pelanggaran)'),
					('1515','120','15','210','3','K_120_15_210_3','Putusan N.O.'),
					('1516','120','15','210','4','K_120_15_210_4','Putusan (Terdakwa Meninggal Dunia)'),
					('1517','120','15','210','5','K_120_15_210_5','Putusan (Susunan Dakwaan Komulatif / Variatif)'),
					('1518','120','15','210','6','K_120_15_210_6','Putusan'),
					('1519','120','15','210','7','K_120_15_210_7','Petikan Putusan'),
					('1520','120','15','210','8','K_120_15_210_8','Putusan Perbedaan Pendapat'),
					('1521','120','16','240','6','K_120_16_240_6','Akta Menerima Putusan Oleh Terdakwa'),
					('1522','120','16','240','7','K_120_16_240_7','Akta Menerima Putusan Oleh Oditur'),
					('1523','120','16','240','8','K_120_16_240_8','Akta Putusan Telah Memperoleh Kekuatan Hukum Tetap'),
					('1524','120','16','240','9','K_120_16_240_9','Akta Putusan Telah Memperoleh Kekuatan Hukum Tetap (Putusan Bebas)'),
					('1525','120','20','400','1','K_120_20_400_1','Akta Pemberitahuan Isi Putusan Banding Kepada Terdakwa'),
					('1526','120','20','400','2','K_120_20_400_2','Akta Pemberitahuan Isi Putusan Banding Kepada Oditur'),
					('1527','120','20','400','3','K_120_20_400_3','Pengumuman Pertama'),
					('1528','120','20','400','4','K_120_20_400_4','Pengumuman Terakhir'),
					('1529','120','14','200','5','K_120_14_200_5','Berita Acara Pengumuman Putusan'),
					('1530','120','20','290','1','K_120_20_290_1','Akta Permohonan Banding Oleh Terdakwa'),
					('1531','120','20','290','2','K_120_20_290_2','Akta Permohonan Banding Oleh Oditur'),
					('1532','120','20','300','1','K_120_20_300_1','Akta Pemberitahuan Permohonan Banding Untuk Oditur'),
					('1533','120','20','300','2','K_120_20_300_2','Akta Pemberitahuan Permohonan Banding Untuk Terdakwa'),
					('1534','120','20','290','3','K_120_20_290_3','Akta Pencabutan Permohonan Banding Untuk Terdakwa'),
					('1535','120','20','290','4','K_120_20_290_4','Akta Pencabutan Permohonan Banding Untuk Oditur'),
					('1536','120','20','300','3','K_120_20_300_3','Akta Pemberitahuan Pencabutan Permohonan Banding Untuk Terdakwa'),
					('1537','120','20','300','4','K_120_20_300_4','Akta Pemberitahuan Pencabutan Permohonan Banding Untuk Oditur'),
					('1538','120','20','310','1','K_120_20_310_1','Akta Penerimaan Memori Banding Untuk Terdakwa'),
					('1539','120','20','310','2','K_120_20_310_2','Akta Penerimaan Memori Banding Untuk Oditur'),
					('1540','120','20','330','1','K_120_20_330_1','Akta Penerimaan Kontra Memori Banding Untuk Terdakwa'),
					('1541','120','20','330','2','K_120_20_330_2','Akta Penerimaan Kontra Memori Banding Untuk Oditur'),
					('1542','120','20','290','5','K_120_20_290_5','Akta Penolakan Permohonan Banding Untuk Terdakwa'),
					('1543','120','20','290','6','K_120_20_290_6','Akta Penolakan Permohonan Banding Untuk Oditur'),
					('1544','120','20','340','1','K_120_20_340_1','Akta Pemberitahuan Kontra Memori Banding Untuk Terdakwa'),
					('1545','120','20','340','2','K_120_20_340_2','Akta Pemberitahuan Kontra Memori Banding Untuk Oditur '),
					('1546','120','20','350','1','K_120_20_350_1','Akta Telah Mempelajari Berkas Perkara Banding Untuk Terdakwa'),
					('1547','120','20','350','2','K_120_20_350_2','Akta Telah Mempelajari Berkas Perkara Banding Untuk Oditur'),
					('1548','120','20','350','3','K_120_20_350_3','Akta Meneliti Keaslian Berkas Perkara'),
					('1549','120','30','500','1','K_120_30_500_1','Akta Pemberitahuan Isi Putusan Kasasi Untuk Terdakwa'),
					('1550','120','30','500','2','K_120_30_500_2','Akta Pemberitahuan Isi Putusan Kasasi Untuk Oditur'),
					('1551','120','30','500','4','K_120_30_500_4','Akta Berkekuatan Hukum Tetap Untuk Terdakwa (Kasasi)'),
					('1552','120','30','410','1','K_120_30_410_1','Akta Permohonan Kasasi Untuk Terdakwa'),
					('1553','120','30','410','2','K_120_30_410_2','Akta Permohonan Kasasi Untuk Oditur'),
					('1554','120','30','420','1','K_120_30_420_1','Akta Pemberitahuan Permohonan Kasasi Untuk Terdakwa'),
					('1555','120','30','420','2','K_120_30_420_2','Akta Pemberitahuan Permohonan Kasasi Untuk Oditur'),
					('1556','120','30','410','3','K_120_30_410_3','Akta Pencabutan Permohonan Kasasi Untuk Terdakwa'),
					('1557','120','30','410','4','K_120_30_410_4','Akta Pencabutan Permohonan Kasasi Untuk Oditur'),
					('1558','120','30','500','3','K_120_30_500_3','Berita Acara Menolak Menandatangani Akta Pemberitahuan Isi Putusan Kasasi'),
					('1559','120','30','420','3','K_120_30_420_3','Akta Pemberitahuan Pencabutan Permohonan Kasasi Untuk Terdakwa'),
					('1560','120','30','420','4','K_120_30_420_4','Akta Pemberitahuan Pencabutan Permohonan Kasasi Untuk Oditur'),
					('1561','120','30','430','1','K_120_30_430_1','Akta Penerimaan Memori Kasasi Untuk Terdakwa'),
					('1562','120','30','430','2','K_120_30_430_2','Akta Penerimaan Memori Kasasi Untuk Oditur'),
					('1563','120','30','450','1','K_120_30_450_1','Akta Penerimaan Kontra Memori Kasasi Untuk Terdakwa'),
					('1564','120','30','450','2','K_120_30_450_2','Akta Penerimaan Kontra Memori Kasasi Untuk Oditur'),
					('1565','120','30','460','1','K_120_30_460_1','Akta Pemberitahuan Kontra Memori Kasasi Untuk Terdakwa'),
					('1566','120','30','460','2','K_120_30_460_2','Akta Pemberitahuan Kontra Memori Kasasi Untuk Oditur'),
					('1567','120','30','430','5','K_120_30_430_5','Akta Penerimaan Risalah Kasasi'),
					('1568','120','30','410','5','K_120_30_410_5','Akta Terlambat Mengajukan Permohonan Kasasi Untuk Terdakwa'),
					('1569','120','30','410','6','K_120_30_410_6','Akta Terlambat Mengajukan Permohonan Kasasi Untuk Oditur'),
					('1570','120','30','430','3','K_120_30_430_3','Akta Tidak Menyerahkan Memori Kasasi Untuk Terdakwa'),
					('1571','120','30','410','7','K_120_30_410_7','Penetapan Permohonan Kasasi Tidak Dapat Diterima'),
					('1572','120','30','460','3','K_120_30_460_3','Akta Tidak Menyerahkan Kontra Memori Kasasi Untuk Terdakwa'),
					('1573','120','30','430','4','K_120_30_430_4','Akta Terlambat Penyerahan Memori Kasasi Untuk Terdakwa'),
					('1574','120','40','510','1','K_120_40_510_1','Akta Permohonan Peninjauan Kembali'),
					('1575','120','40','510','2','K_120_40_510_2','Penetapan Pelimpahan Pemeriksaan Pemeriksaan Perkara Peninjauan Kembali'),
					('1576','120','40','520','1','K_120_40_520_1','Akta Pemberitahuan Peninjauan Kembali'),
					('1577','120','40','510','3','K_120_40_510_3','Penetapan Penunjukan Hakim Untuk Memeriksa Permohonan Peninjauan Kembali'),
					('1578','120','40','510','4','K_120_40_510_4','Penetapan Hari Sidang Untuk Memeriksa Permohonan Peninjauan Kembali'),
					('1579','120','40','520','3','K_120_40_520_3','Berita Acara Pemeriksaan Peninjauan Kembali'),
					('1580','120','40','520','2','K_120_40_520_2','Berita Acara Pendapat Peninjauan Kembali'),
					('1581','120','20','320','1','K_120_20_320_1','Akta Pemberitahuan Memori Banding Untuk Terdakwa'),
					('1582','120','20','320','2','K_120_20_320_2','Akta Pemberitahuan Memori Banding Untuk Oditur'),
					('1583','9','13','114','1','G_9_13_114_1','Penetapan Sidang Pertama Perlawanan'),
					('1585','9','10','10','1','G_9_10_10_1','Resume Gugatan (Meja I)'),
					('1590','9','10','10','2','G_9_10_10_2','Penetapan Permohonan Acara Cepat dikabulkan/Pen. Majelis Hakim Tunggal'),
					('1591','9','10','10','3','G_9_10_10_3','Penetapan Permohonan Acara Cepat ditolak/Pen. Majelis Hakim Acara Biasa'),
					('1594','9','10','10','8','G_9_10_10_8','Penetapan Penundaan Keputusan TUN dikabulkan oleh Ketua'),
					('1595','9','12','16','1','G_9_12_16_1','Penetapan Lolos Dismissal'),
					('1596','9','12','16','2','G_9_12_16_2','Penetapan Dismissal'),
					('1597','9','12','15','1','G_9_12_15_1','Surat Panggilan Proses Dissmisal kepada Penggugat'),
					('1598','9','12','15','2','G_9_12_15_2','Surat Panggilan Proses Dissmisal kepada Tergugat'),
					('1601','9','10','16','5','G_9_10_16_5','Berita Acara Proses Dismissal Tunda'),
					('1602','9','10','16','6','G_9_10_16_6','Berita Acara Proses Dismissal Pembacaan Penetapan'),
					('1603','9','10','16','7','G_9_10_16_7','Penetapan Penunjukan Majelis Hakim Acara Singkat (perlawanan)'),
					('1604','9','10','16','8','G_9_10_16_8','Surat Penunjukan Panitera/Panitera Pengganti Acara Singkat'),
					('1605','9','10','16','9','G_9_10_16_9','Surat Penunjukan Juru Sita/ Juru Sita Pengganti Acara Singkat'),
					('1606','9','13','112','1','G_9_13_112_1','Surat Penunjukan Panitera Pengganti Perlawanan'),
					('1612','9','14','115','1','G_9_14_115_1','Berita Acara Sidang Perlawanan 1 (Acara Singkat) Tunda'),
					('1613','9','14','115','2','G_9_14_115_2','Berita Acara Sidang Perlawanan 2 (Acara Singkat) Tunda'),
					('1614','9','14','115','3','G_9_14_115_3','Berita Acara Sidang Perlawanan 3 (Acara Singkat) Putusan'),
					('1615','9','15','219','1','G_9_15_219_1','Putusan Perlawanan Diterima'),
					('1616','9','15','219','1','G_9_15_219_2','Putusan Perlawanan Ditolak'),
					('1617','9','15','231','1','G_9_15_231_1','Surat Pemberitahuan Putusan Perlawanan kepada Penggugat'),
					('1618','9','15','232','1','G_9_15_232_1','Surat Pemberitahuan Putusan Perlawanan kepada Tergugat'),
					('1620','9','12','30','1','G_9_12_30_1','Surat Penunjukan Panitera/Panitera Pengganti Acara Cepat'),
					('1621','9','12','30','2','G_9_12_30_2','Surat Penunjukan Juru Sita/ Juru Sita Pengganti Acara Cepat'),
					('1622','9','14','200','1','G_9_14_200_27','BAP Acara Cepat 1 Tunda'),
					('1623','9','14','200','2','G_9_14_200_28','BAP Acara Cepat 2 Tunda'),
					('1624','9','14','200','3','G_9_14_200_29','BAP Acara Cepat 3 Putusan'),
					('1625','9','15','210','1','G_9_15_210_1','Putusan Acara Cepat'),
					('1626','9','12','20','1','G_9_12_20_1','Penetapan Majelis Hakim'),
					('1627','9','12','16','3','G_9_12_16_3','Pemberitahuan Penetapan Dismissal Untuk Penggugat'),
					('1628','9','12','16','4','G_9_12_16_4','Pemberitahuan Penetapan Dismissal Untuk Tergugat'),
					('1631','9','12','30','3','G_9_12_30_3','Surat Penunjukan Panitera/Panitera Pengganti'),
					('1632','9','12','40','1','G_9_12_40_1','Surat Penunjukan Juru Sita/Juru Sita Pengganti'),
					('1633','9','12','42','1','G_9_12_42_1','Penetapan Hari Pemeriksaan Persiapan'),
					('1640','9','12','42','2','G_9_12_42_2','Surat Panggilan Pemeriksaan Persiapan kepada Penggugat'),
					('1641','9','12','42','3','G_9_12_42_3','Surat Panggilan Pemeriksaan Persiapan kepada Tergugat'),
					('1646','9','14','200','4','G_9_14_200_30','Berita Acara Pemeriksaan Persiapan I'),
					('1647','9','14','200','5','G_9_14_200_31','Berita Acara Pemeriksaan Persiapan II'),
					('1648','9','14','200','6','G_9_14_200_6','Berita Acara Pemeriksaan Persiapan III'),
					('1649','9','14','200','7','G_9_14_200_7','Berita Acara Pemeriksaan Persiapan IV '),
					('1650','9','14','200','8','G_9_14_200_8','Berita Acara Pemeriksaan Persiapan V (Pembacaan Putusan Tidak Dapat Diterima) '),
					('1652','9','15','210','2','G_9_15_210_2','Putusan Sela Tidak Dapat Diterima'),
					('1653','9','14','80','2','G_9_14_80_2','Penetapan Hari Persidangan Pertama'),
					('1654','9','14','200','1','G_9_14_200_1','Surat Panggilan Sidang kepada Penggugat'),
					('1655','9','14','200','2','G_9_14_200_2','Surat Panggilan Sidang kepada Tergugat'),
					('1656','9','14','200','3','G_9_14_200_3','Surat Panggilan Sidang kepada Intervensi'),
					('1657','9','14','200','4','G_9_14_200_4','Surat Panggilan Saksi'),
					('1658','9','14','200','5','G_9_14_200_5','Surat Panggilan Ahli'),
					('1659','9','14','200','9','G_9_14_200_9','BAP  Pembacaan Gugatan'),
					('1660','9','14','200','10','G_9_14_200_10','BAP  Pembacaan Jawaban'),
					('1665','9','14','200','11','G_9_14_200_11','BAP Putusan Sela Penetapan Pihak Intervensi'),
					('1666','9','14','200','12','G_9_14_200_12','BAP Putusan Sela Penetapan Penundaan KTUN'),
					('1667','9','14','200','13','G_9_14_200_13','BAP Penyerahan Replik'),
					('1668','9','14','200','14','G_9_14_200_14','BAP Penyerahan Duplik'),
					('1669','9','14','200','15','G_9_14_200_15','BAP Pencabutan Gugatan'),
					('1670','9','12','211','1','G_9_12_211_1','Putusan Sela Penetapan Pencabutan Gugatan Dikabulkan'),
					('1671','9','14','200','16','G_9_14_200_16','BAP Penyerahan Bukti P'),
					('1672','9','14','200','17','G_9_14_200_17','BAP Penyerahan Bukti T'),
					('1673','9','14','200','18','G_9_14_200_18','BAP Penyerahan Bukti TII Intervensi'),
					('1674','9','14','200','19','G_9_14_200_19','BAP Penyerahan Bukti P dan Bukti T'),
					('1675','9','14','200','20','G_9_14_200_20','BAP Penyerahan Bukti P, Bukti T dan Bukti TII Intervensi'),
					('1676','9','14','200','21','G_9_14_200_21','BAP Pemeriksaan Saksi P'),
					('1677','9','14','200','22','G_9_14_200_22','BAP Pemeriksaan Saksi T'),
					('1678','9','14','200','23','G_9_14_200_23','BAP Pemeriksaan Saksi P dan Saksi T'),
					('1679','9','14','200','24','G_9_14_200_24','BAP Pemeriksaan Saksi P, Saksi T dan Saksi TII Intervensi'),
					('1680','9','14','200','25','G_9_14_200_25','BAP Kesimpulan'),
					('1681','9','14','200','26','G_9_14_200_26','BAP Putusan'),
					('1682','9','15','210','3','G_9_15_210_3','Putusan Dikabulkan'),
					('1683','9','15','210','4','G_9_15_210_4','Putusan Ditolak'),
					('1684','9','15','210','5','G_9_15_210_5','Putusan Gugur'),
					('1685','9','15','218','1','G_9_15_218_1','Surat Pemberitahuan Amar Putusan kepada Penggugat'),
					('1686','9','15','218','2','G_9_15_218_2','Surat Pemberitahuan Amar Putusan kepada Tergugat'),
					('1687','9','15','233','1','G_9_15_233_1','Surat Pemberitahuan Amar Putusan kepada Tergugat II Intervensi'),
					('1688','9','20','290','1','G_9_20_290_1','Surat keterangan lewat waktu banding'),
					('1689','9','20','290','2','G_9_20_290_2','Akta Permohonan Banding oleh Penggugat'),
					('1690','9','20','290','3','G_9_20_290_3','Akta Permohonan Banding oleh Kuasa Penggugat'),
					('1691','9','20','290','4','G_9_20_290_4','Akta Permohonan Banding oleh Tergugat'),
					('1692','9','20','290','5','G_9_20_290_5','Akta Permohonan Banding oleh Kuasa Tergugat'),
					('1693','9','20','300','1','G_9_20_300_1','Surat pemberitahuan pernyataan banding kepada penggugat/Terbanding'),
					('1694','9','20','300','2','G_9_20_300_2','Surat pemberitahuan pernyataan banding kepada kuasa penggugat'),
					('1695','9','20','300','3','G_9_20_300_3','Surat pemberitahuan pernyataan banding kepada Tergugat'),
					('1696','9','20','300','4','G_9_20_300_4','Surat pemberitahuan pernyataan banding kepada Kuasa Tergugat atau Tergugat II Intervensi'),
					('1697','9','20','320','1','G_9_20_320_1','Surat pemberitahuan memori banding kepada penggugat'),
					('1698','9','20','320','2','G_9_20_320_2','Surat pemberitahuan memori banding kepada kuasa penggugat'),
					('1699','9','20','320','3','G_9_20_320_3','Surat pemberitahuan memori banding kepada tergugat atau tergugat II intervensi'),
					('1700','9','20','320','4','G_9_20_320_4','Surat pemberitahuan memori banding kepada kuasa tergugat atau tergugat II intervensi'),
					('1703','9','20','340','1','G_9_20_340_1','Surat pemberitahuan kontra memori banding kepada penggugat'),
					('1704','9','20','340','2','G_9_20_340_2','Surat pemberitahuan kontra memori banding kepada kuasa penggugat'),
					('1711','9','20','340','3','G_9_20_340_3','Surat pemberitahuan kontra memori banding kepada tergugat atau tergugat II intervensi'),
					('1712','9','20','340','4','G_9_20_340_4','Surat pemberitahuan kontra memori banding kepada kuasa tergugat atau tergugat II intervensi'),
					('1713','9','20','360','1','G_9_20_360_1','Surat pemberitahuan melihat berkas perkara kepada penggugat'),
					('1714','9','20','360','2','G_9_20_360_2','Surat pemberitahuan melihat berkas perkara kepada kuasa penggugat'),
					('1715','9','20','360','3','G_9_20_360_3','Surat pemberitahuan melihat berkas perkara kepada tergugat atau tergugat II intervensi'),
					('1716','9','20','360','4','G_9_20_360_4','Surat pemberitahuan melihat berkas perkara kepada kuasa tergugat atau tergugat II intervensi'),
					('1717','9','13','111','1','G_9_13_111_1','Penetapan Majelis Hakim Perlawanan'),
					('1718','9','12','80','1','G_9_12_80_1','Penetapan Hari Sidang Pertama'),
					('1720','9','12','20','2','G_9_12_20_2','Penetapan Penunjukan Hakim Tunggal'),
					('1722','9','12','21','1','G_9_12_21_1','Penetapan Kembali Majelis Hakim'),
					('1723','9','20','400','1','G_9_20_400_1','Surat pemberitahuan putusan banding kepada penggugat'),
					('1724','9','20','400','2','G_9_20_400_2','Surat pemberitahuan putusan banding kepada kuasa penggugat'),
					('1725','9','20','400','3','G_9_20_400_3','Surat pemberitahuan putusan banding kepada tergugat atau atau Tergugat II Intervensi'),
					('1726','9','20','400','4','G_9_20_400_4','Surat pemberitahuan putusan banding kepada kuasa tergugat atau atau Tergugat II Intervensi'),
					('1727','9','30','410','1','G_9_30_410_1','Akta permohonan kasasi oleh penggugat'),
					('1728','9','30','410','2','G_9_30_410_2','Akta permohonan kasasi oleh kuasa penggugat'),
					('1729','9','30','410','3','G_9_30_410_3','Akta permohonan kasasi oleh Tergugat'),
					('1730','9','30','410','4','G_9_30_410_4','Akta permohonan kasasi oleh kuasa Tergugat'),
					('1739','9','30','420','1','G_9_30_420_1','Surat pemberitahuan pernyataan kasasi Kepada penggugat'),
					('1740','9','30','420','2','G_9_30_420_2','Surat pemberitahuan pernyataan kasasi Kepada kuasa penggugat'),
					('1741','9','30','420','3','G_9_30_420_3','Surat pemberitahuan pernyataan kasasi Kepada Tergugat'),
					('1742','9','30','420','4','G_9_30_420_4','Surat pemberitahuan pernyataan kasasi Kepada kuasa Tergugat'),
					('1747','9','30','410','5','G_9_30_410_5','Penetapan Tidak Memenuhi syarat Formil karena terlambat mengajukan permohonan kasasi'),
					('1748','9','30','410','6','G_9_30_410_6','Penetapan Tidak Memenuhi syarat Formil karena tidak atau terlambat mengajukan memori kasasi'),
					('1749','9','30','410','7','G_9_30_410_7','Penetapan Pasal 45'),
					('1750','9','30','430','1','G_9_30_430_1','Surat pemberitahuan dan penyerahan memori kasasi kepada penggugat'),
					('1754','9','30','430','2','G_9_30_430_2','Surat pemberitahuan dan penyerahan memori kasasi kepada kuasa penggugat'),
					('1755','9','30','430','3','G_9_30_430_3','Surat pemberitahuan dan penyerahan memori kasasi kepada tergugat atau tergugat intervensi'),
					('1756','9','30','430','4','G_9_30_430_4','Surat pemberitahuan dan penyerahan memori kasasi kepada kuasa tergugat atau tergugat intervensi'),
					('1759','9','30','460','1','G_9_30_460_1','Surat pemberitahuan dan penyerahan kontra memori kasasi kepada penggugat'),
					('1760','9','30','460','2','G_9_30_460_2','Surat pemberitahuan dan penyerahan kontra memori kasasi kepada kuasa penggugat'),
					('1761','9','30','460','3','G_9_30_460_3','Surat pemberitahuan dan penyerahan kontra memori kasasi kepada tergugat atau tergugat intervensi'),
					('1762','9','30','460','4','G_9_30_460_4','Surat pemberitahuan dan penyerahan kontra memori kasasi kepada kuasa tergugat atau tergugat intervensi'),
					('1763','9','30','500','1','G_9_30_500_1','Surat pemberitahuan putusan kasasi kepada penggugat'),
					('1764','9','30','500','2','G_9_30_500_2','Surat pemberitahuan putusan kasasi kepada kuasa penggugat'),
					('1765','9','30','500','3','G_9_30_500_3','Surat pemberitahuan putusan kasasi kepada tergugat atau tergugat intervensi'),
					('1766','9','30','500','4','G_9_30_500_4','Surat pemberitahuan putusan kasasi kepada kuasa tergugat atau tergugat intervensi'),
					('1767','9','40','510','1','G_9_40_510_1','Akta Permohonan Peninjauan Kembali Penggugat'),
					('1768','9','40','520','1','G_9_40_520_1','Surat Pemberitahuan dan Penyerahan Memori PK Kepada Penggugat'),
					('1769','9','40','540','1','G_9_40_540_1','Surat Pemberitahuan dan Penyerahan Kontra Memori PK Kepada Penggugat'),
					('1770','9','40','510','6','G_9_40_510_6','Akta pencabutan permohonan  PK Penggugat'),
					('1775','9','40','510','9','G_9_40_510_9','Surat pemberitahuan pencabutan permohonan PK'),
					('1776','9','40','571','1','G_9_40_571_1','Surat Pemberitahuan Putusan PK Kepada Penggugat'),
					('1777','9','50','600','1','G_9_50_600_1','Surat panggilan eksekusi'),
					('1779','9','50','600','2','G_9_50_600_2','Surat pengumuman eksekusi di media '),
					('1780','9','12','20','3','G_9_12_20_3','Penetapan Majelis Hakim Penolakan Acara Singkat'),
					('1782','9','10','10','7','G_9_10_10_7','Surat pemberitahuan perkara KIP'),
					('1814','9','12','200','2','G_9_12_200_2','Surat Teguran Pelaksanaan  Penundaan Keputusan TUN'),
					('1815','9','10','10','6','G_9_10_10_6','Penetapan izin kuasa insidentil'),
					('1817','9','50','600','3','G_9_50_600_3','Penetapan Permohonan Eksekusi'),
					('1818','9','50','610','1','G_9_50_610_1','Surat Eksekusi otomatis (Pengawasan Pelaksanaan eksekusi)'),
					('1819','9','50','610','2','G_9_50_610_2','Surat meminta penjelasan (Pengawasan Pelaksanaan eksekusi)'),
					('1820','9','50','610','3','G_9_50_610_3','Surat teguran (Pengawasan Pelaksanaan eksekusi)'),
					('1821','9','50','610','4','G_9_50_610_4','Surat ke Presiden  (Pengawasan Pelaksanaan eksekusi)'),
					('1822','9','50','610','5','G_9_50_610_5','Surat ke DPR  (Pengawasan Pelaksanaan eksekusi)'),
					('1825','9','12','31','1','G_9_12_31_1','Surat Pergantian Penunjukkan Panitera Pengganti'),
					('1826','9','10','16','10','G_9_10_16_10','Berita Acara Proses Dismisal Tunda 2'),
					('1828','9','50','615','1','G_9_50_615_1','Penetapan Eksekusi'),
					('1829','9','20','290','6','G_9_20_290_6','Akta Permohonan Banding oleh Intervensi'),
					('1830','9','20','290','7','G_9_20_290_7','Akta Permohonan Banding oleh Kuasa Intervensi'),
					('1834','9','30','420','5','G_9_30_420_5','Surat pemberitahuan pernyataan kasasi Kepada Intervensi'),
					('1835','9','40','510','2','G_9_40_510_2','Akta Permohonan Peninjauan Kembali Kuasa Penggugat'),
					('1836','9','40','510','3','G_9_40_510_3','Akta Permohonan Peninjauan Kembali Tergugat'),
					('1837','9','40','510','4','G_9_40_510_4','Akta Permohonan Peninjauan Kembali Kuasa Tergugat'),
					('1838','9','40','520','2','G_9_40_520_2','Surat Pemberitahuan dan Penyerahan Memori PK Kepada Kuasa Penggugat'),
					('1839','9','40','520','3','G_9_40_520_3','Surat Pemberitahuan dan Penyerahan Memori PK Kepada Tergugat'),
					('1840','9','40','520','4','G_9_40_520_4','Surat Pemberitahuan dan Penyerahan Memori PK Kepada Kuasa Tergugat'),
					('1841','9','40','540','2','G_9_40_540_2','Surat Pemberitahuan dan Penyerahan Kontra Memori PK Kepada Kuasa Penggugat'),
					('1842','9','40','540','3','G_9_40_540_3','Surat Pemberitahuan dan Penyerahan Kontra Memori PK Kepada Tergugat'),
					('1843','9','40','540','4','G_9_40_540_4','Surat Pemberitahuan dan Penyerahan Kontra Memori PK Kepada Kuasa Tergugat'),
					('1844','9','40','571','2','G_9_40_571_2','Surat Pemberitahuan Putusan PK Kepada Kuasa Penggugat'),
					('1845','9','40','571','3','G_9_40_571_3','Surat Pemberitahuan Putusan PK Kepada Tegugat'),
					('1846','9','40','571','4','G_9_40_571_4','Surat Pemberitahuan Putusan PK Kepada Kuasa Tergugat'),
					('1847','9','40','510','5','G_9_40_510_5','Akta Permohonan Peninjauan Kembali Intervensi'),
					('1848','9','40','520','5','G_9_40_520_5','Surat Pemberitahuan dan Penyerahan Memori PK Kepada Pihak Intervensi'),
					('1849','9','20','290','8','G_9_20_290_8','Akta Pencabutan Permohonan Banding Penggugat'),
					('1850','9','20','290','9','G_9_20_290_9','Akta Pencabutan Permohonan Banding Kuasa Penggugat'),
					('1851','9','20','290','10','G_9_20_290_10','Akta Pencabutan Permohonan Banding Tergugat'),
					('1852','9','20','290','11','G_9_20_290_11','Akta Pencabutan Permohonan Banding Kuasa Tergugat'),
					('1853','9','20','290','12','G_9_20_290_12','Akta Pencabutan Permohonan Banding Intervensi'),
					('1854','9','30','461','1','G_9_30_461_1','Surat pemberitahuan melihat berkas perkara kepada Penggugat'),
					('1855','9','30','461','2','G_9_30_461_2','Surat pemberitahuan melihat berkas perkara kepada Kuasa Penggugat'),
					('1856','9','30','461','3','G_9_30_461_3','Surat pemberitahuan melihat berkas perkara kepada Tergugat'),
					('1857','9','30','461','4','G_9_30_461_4','Surat pemberitahuan melihat berkas perkara kepada Kuasa Penggugat'),
					('1858','9','30','461','5','G_9_30_260_5','Surat pemberitahuan melihat berkas perkara kepada Intervensi'),
					('1859','9','10','10','9','G_9_10_10_9','Penetapan Penundaan Pelaksanaan Keputusan TUN Ditolak oleh Ketua'),
					('1860','9','12','211','2','G_9_12_211_2','Putusan Sela Penetapan Pencabutan Gugatan Ditolak'),
					('1861','9','12','211','3','G_9_12_211_3','Putusan Sela Penetapan Penundaan Pelaksanaan KTUN Dikabulkan oleh Majelis Hakim'),
					('1862','9','12','211','4','G_9_12_211_4','Putusan Sela Penetapan Penundaan Pelaksanaan KTUN Ditolak oleh Majelis Hakim'),
					('1863','9','12','211','5','G_9_12_211_5','Putusan Sela Penetapan Pihak Intervensi dikabulkan'),
					('1864','9','12','211','6','G_9_12_211_6','Putusan Sela Penetapan Pihak Intervensi ditolak'),
					('1865','9','30','410','8','G_9_30_410_8','Akta Pencabutan Permohonan Kasasi oleh Penggugat'),
					('1866','9','30','410','9','G_9_30_410_9','Akta Pencabutan Permohonan Kasasi oleh  Kuasa Penggugat'),
					('1867','9','30','410','10','G_9_30_410_10','Akta Pencabutan Permohonan Kasasi oleh  Tergugat'),
					('1868','9','30','410','11','G_9_30_410_11','Akta Pencabutan Permohonan Kasasi oleh  Kuasa Penggugat'),
					('1869','9','30','410','12','G_9_30_410_12','Akta Pencabutan Permohonan Kasasi oleh  Intervensi'),
					('1870','9','30','500','5','G_9_30_500_5','Surat Pemberitahuan Putusan Kasasi kepada Intervensi'),
					('1871','9','30','430','5','G_9_30_430_5','Surat pemberitahuan dan penyerahan memori kasasi kepda Intervensi'),
					('1872','9','30','460','5','G_9_30_460_5','Surat pemberitahuan dan penyerahan kontra memori kasasi kepada Intervensi'),
					('1873','9','40','540','5','G_9_40_540_5','Surat Pemberitahuan dan Penyerahan Kontra Memori PK Kepada Intervensi'),
					('1874','9','40','571','5','G_9_40_571_5','Surat Pemberitahuan Putusan PK Kepada Intervensi'),
					('1877','120','30','430','6','K_120_30_430_6','Akta Terlambat Penyerahan Memori Kasasi Untuk Oditur'),
					('1878','120','30','430','7','K_120_30_430_7','Akta Tidak Menyerahkan Memori Kasasi Untuk Oditur'),
					('1879','120','30','460','4','K_120_30_460_4','Akta Tidak Menyerahkan Kontra Memori Kasasi Untuk Oditur'),
					('1880','120','60','650','1','K_120_60_650_1','Akta Permohonan Grasi'),
					('1881','120','60','662','1','K_120_60_662_1','Akta Penerimaan Salinan Permohonan Grasi'),
					('1882','120','60','650','2','K_120_60_650_2','Akta Penolakan Permohonan Grasi'),
					('1883','120','60','690','1','K_120_60_690_1','Akta Pemberitahuan Isi Putusan Grasi Untuk Terpidana'),
					('1884','120','60','690','2','K_120_60_690_2','Akta Pemberitahuan Isi Putusan Grasi Untuk Oditur');");

		$this->patching->exe_script("DROP TABLE IF EXISTS template_dokumen_jenis_agenda;");
		$this->patching->exe_script("CREATE TABLE template_dokumen_jenis_agenda (
			  id smallint(6) NOT NULL AUTO_INCREMENT,
			  varlist varchar(250) DEFAULT NULL,
			  alur_perkara_id int(11) DEFAULT NULL,
			  nama varchar(100) DEFAULT NULL,
			  konten_dokumen text,
			  PRIMARY KEY (id)
			) ENGINE=InnoDB;");
		$this->patching->exe_script("INSERT INTO template_dokumen_jenis_agenda (id, varlist, alur_perkara_id, nama, konten_dokumen)
				VALUES
					(1,'2',120,'Pembacaan Dakwaan','Kemudian #tunggal/ketua# menjelaskan bahwa acara sidang hari ini adalah Pembacaan Dakwaan.\\\par \\\par Setelah #tunggal/ketua# memperingatkan kepada #para/terdakwa# supaya memperhatikan segala sesuatu yang didengar dan dilihatnya didalam sidang dan supaya memberikan keterangan yang benar, selanjutnya #tunggal/ketua# memberikan kesempatan kepada #jaksa# untuk membacakan Surat Dakwaan dan memerintahkan kepada #para/terdakwa# supaya  berdiri dengan sikap sempurna guna mendengarkan pembacaan surat dakwaan. #jaksa# dengan sikap berdiri membaca Surat Dakwaan  Nomor : #nomor_dakwaan# tanggal #tanggal_dakwaan#, yang isinya sebagai berikut: \\\par \\\par #isi_dakwaan# \\\par '),
					(2,'2',120,'Eksepsi','Kemudian #tunggal/ketua# menjelaskan bahwa acara sidang hari ini adalah Eksepsi.\\\par \\\par '),
					(3,'2',120,'Tanggapan Atas eksepsi','Kemudian #tunggal/ketua# menjelaskan bahwa acara sidang hari ini adalah Tanggapan Atas Eksepsi.\\\par \\\par '),
					(4,'2',120,'Putusan Sela','Kemudian #tunggal/ketua# menjelaskan bahwa acara sidang hari ini adalah Pembacaan Putusan Sela.\\\par \\\par '),
					(5,'2',120,'Perlawanan','Kemudian #tunggal/ketua# menjelaskan bahwa acara sidang hari ini adalah Perlawanan.\\\par \\\par '),
					(6,'2',120,'Pemeriksaan Saksi','Kemudian #tunggal/ketua# menjelaskan bahwa acara sidang hari ini adalah Pemeriksaan Saksi.\\\par \\\par Atas pertanyaan #tunggal/ketua#, #jaksa# menerangkan bahwa ia telah memanggil Saksi-saksi dalam perkara ini. #tunggal/ketua#  memperingatkan agar Saksi-saksi tidak saling berhubungan satu dengan yang lain terutama membicarakan mengenai perkara yang akan diperiksa sebelum memberi keterangan dalam sidang. \\\par \\\par '),
					(7,'2',120,'Pemeriksaan Terdakwa','Kemudian #tunggal/ketua# menjelaskan bahwa acara sidang hari ini adalah Pemeriksaan Terdakwa.\\\par \\\par '),
					(8,'2',120,'Pemeriksaan Barang Bukti','Kemudian #tunggal/ketua# menjelaskan bahwa acara sidang hari ini adalah Pemeriksaan Barang Bukti.\\\par \\\par '),
					(9,'2',120,'Pembacaan Tuntutan',''),
					(10,'2',120,'Pembelaan','Kemudian #tunggal/ketua# menjelaskan bahwa acara sidang hari ini adalah Pembelaan Terdakwa.\\\par \\\par '),
					(11,'2',120,'Replik','Kemudian #tunggal/ketua# menjelaskan bahwa acara sidang hari ini adalah Replik.\\\par \\\par '),
					(12,'2',120,'Duplik','Kemudian #tunggal/ketua# menjelaskan bahwa acara sidang hari ini adalah Duplik.\\\par \\\par '),
					(13,'2',120,'Putusan','Kemudian #tunggal/ketua# menjelaskan bahwa acara sidang hari ini adalah Pembacaan Putusan.\\\par \\\par '),
					(14,'2',120,'Skorsing',NULL),
					(101,'3',9,'Pembacaan Gugatan','Kemudian #tunggal/ketua# Sidang menjelaskan bahwa acara sidang hari ini adalah Pembacaan Gugatan; \\\par \\\par'),
					(102,'3',9,'Pembacaan Jawaban','Kemudian #tunggal/ketua# Sidang menjelaskan bahwa acara sidang hari ini adalah Pembacaan Jawaban; \\\par \\\par'),
					(103,'3',9,'Pembacaan Replik','Kemudian #tunggal/ketua# Majelis menjelaskan kepada Para Pihak bahwa acara persidangan hari ini adalah Penyerahan Replik; \\\par \\\par'),
					(104,'3',9,'Pembacaan Duplik','Kemudian #tunggal/ketua# Sidang menjelaskan bahwa acara sidang hari ini adalah Pembacaan Duplik; \\\par \\\par'),
					(105,'3',9,'Pemeriksaan Bukti Penggugat','Kemudian #tunggal/ketua# Sidang menjelaskan bahwa acara sidang hari ini adalah Penyampaian Bukti Surat Para Pihak; \\\par \\\par'),
					(106,'3',9,'Pemeriksaan Bukti Tergugat','Kemudian #tunggal/ketua# Sidang menjelaskan bahwa acara sidang hari ini adalah Penyampaian Bukti Surat Para Pihak; \\\par \\\par'),
					(107,'3',9,'Pemeriksaan Saksi Penggugat','Kemudian #tunggal/ketua# Sidang menjelaskan bahwa acara sidang hari ini adalah Penyampaian Saksi dari Pihak Penggugat; \\\par \\\par'),
					(108,'3',9,'Pemeriksaan Saksi Tergugat','Kemudian #tunggal/ketua# Sidang menjelaskan bahwa acara sidang hari ini adalah Penyampaian Saksi dari Pihak Tergugat; \\\par \\\par'),
					(109,'3',9,'Pembacaan Kesimpulan','Kemudian #tunggal/ketua# Sidang menjelaskan bahwa acara sidang hari ini adalah Penyampaian Kesimpulan para pihak; \\\par \\\par'),
					(110,'3',9,'Pembacaan Putusan','Kemudian #tunggal/ketua# Sidang menjelaskan bahwa acara sidang hari ini adalah pembacaan Putusan; \\\par \\\par'),
					(201,'4',15,'Penolakan',''),
					(202,'4',15,'Mediasi','\\\\fi720\\\\ri-1 Kemudian #tunggal/ketua# mendamaikan #SEBAGAI_P# dan #SEBAGAI_T#, namun tidak berhasil. Selanjutnya #tunggal/ketua# menjelaskan bahwa #SEBAGAI_P# dan #SEBAGAI_T#, harus menempuh proses mediasi sesuai dengan PERMA No. 1 Tahun 2008 Tentang Prosedur Mediasi di Pengadilan. Setelah itu #tunggal/ketua# menjelaskan tatacara mediasi, lalu #tunggal/ketua# memberikan kesempatan kepada #SEBAGAI_P# dan #SEBAGAI_T#, untuk berunding  guna memilih mediator yang terdaftar di #JENIS_SATKER# #nama_pa#; \\\par'),
					(203,'4',15,'Pembacaan Gugatan','Redaksi Pembacaan Gugatan'),
					(204,'4',15,'Pemeriksaan Bukti','Redaksi Pemeriksaan Barang Bukti'),
					(205,'4',15,'Pemeriksaan Saksi','Redaksi Pemeriksaan Saksi'),
					(206,'4',15,'Pemeriksaan Saksi Penggugat','Pemeriksaan Saksi Penggugat'),
					(207,'4',15,'Pemeriksaan Saksi Tergugat','Pemeriksaan Saksi Tergugat'),
					(208,'4',15,'Pembacaan Replik','Pembacaan Replik'),
					(209,'4',15,'Pembacaan Duplik','Duplik'),
					(210,'4',15,'Putusan','Isisiii Putusan #amar_putusan# '),
					(211,'4',15,'Lain-lain',NULL);");


		$this->patching->exe_script("DROP TABLE IF EXISTS template_perkara_bas;");
		$this->patching->exe_script("CREATE TABLE template_perkara_bas (
					perkara_id bigint(20) unsigned NOT NULL,
					sidang_id bigint(20) NOT NULL,
					jenis_agenda_id smallint(6) NOT NULL,
					nama_agenda varchar(100) DEFAULT NULL,
					agenda_id smallint(6) DEFAULT NULL,
					urutan smallint(6) DEFAULT NULL,
					redaksi text,
					isian text,
					diedit_oleh varchar(30) DEFAULT NULL,
					diedit_tanggal datetime DEFAULT NULL,
					diinput_oleh varchar(30) DEFAULT NULL,
					diinput_tanggal datetime DEFAULT NULL,
					PRIMARY KEY (perkara_id,sidang_id,jenis_agenda_id),
					CONSTRAINT fk_perkara_template FOREIGN KEY (perkara_id) REFERENCES perkara (perkara_id) ON DELETE CASCADE
				) ENGINE=InnoDB;");

		$this->patching->exe_script("DROP TABLE IF EXISTS template_perkara_bas_detil_tanya_jawab;");
		$this->patching->exe_script("CREATE TABLE template_perkara_bas_detil_tanya_jawab (
					id bigint(20) unsigned NOT NULL AUTO_INCREMENT,
					perkara_id bigint(20) unsigned NOT NULL,
					sidang_id bigint(20) NOT NULL,
					jenis_agenda_id smallint(6) NOT NULL,
					urutan_sumber tinyint(1) DEFAULT NULL,
					urutan_penanya tinyint(1) DEFAULT NULL,
					urutan_pertanyaan tinyint(4) DEFAULT NULL,
					sumber_id bigint(20) NOT NULL,
					tabel_asal_sumber varchar(17) DEFAULT NULL,
					pihak_ke tinyint(4) NOT NULL,
					penanya_t varchar(16) NOT NULL,
					pertanyaan_t text NOT NULL,
					jawaban_t text NOT NULL,
					kenal varchar(11) DEFAULT NULL,
					tanggapan_terdakwa varchar(20) DEFAULT NULL,
					diedit_oleh varchar(30) DEFAULT NULL,
					diedit_tanggal datetime DEFAULT NULL,
					diinput_oleh varchar(30) DEFAULT NULL,
					diinput_tanggal datetime DEFAULT NULL,
					PRIMARY KEY (id),
					KEY fk_perkara (perkara_id),
					CONSTRAINT fk_perkara FOREIGN KEY (perkara_id) REFERENCES perkara (perkara_id)
				) ENGINE=InnoDB;");

		$this->patching->exe_script("DROP TABLE IF EXISTS template_perkara_bas_penutup;");
		$this->patching->exe_script("CREATE TABLE template_perkara_bas_penutup (
					perkara_id bigint(20) unsigned NOT NULL,
					sidang_id bigint(20) NOT NULL,
					agenda_id smallint(6) DEFAULT NULL,
					redaksi text,
					diinput_tanggal date DEFAULT NULL,
					diinput_oleh varchar(30) DEFAULT NULL,
					PRIMARY KEY (perkara_id,sidang_id),
					CONSTRAINT fk_perkara_bas FOREIGN KEY (perkara_id) REFERENCES perkara (perkara_id) ON DELETE CASCADE
				) ENGINE=InnoDB;");

		
		$sql = "ALTER TABLE proses_alur_perkara   
				CHANGE id id INT(11) NULL,
				CHANGE alur_perkara_id alur_perkara_id INT(11) UNSIGNED NOT NULL  COMMENT 'Jenis proses: merujuk ke tabel jenis_proses kolom id',
				CHANGE proses_id proses_id INT(11) UNSIGNED NOT NULL  COMMENT 'id Proses: merujuk ke tabel proses kolom id', 
				DROP PRIMARY KEY,
				ADD PRIMARY KEY (alur_perkara_id, tahapan_id, proses_id);";
		$this->patching->exe_script($sql);

		$isThere = $this->patching->isColumnExist('perkara_pengacara','tempat_lahir');
		if(!empty($isThere)){
			#$this->dbforge->drop_column('perkara_pengacara', 'tempat_lahir');
			$sql = 'ALTER TABLE perkara_pengacara
						DROP COLUMN tempat_lahir, 
						DROP COLUMN tanggal_lahir, 
						DROP COLUMN umur, 
						DROP COLUMN dewasa, 
						DROP COLUMN jenis_kelamin, 
						DROP COLUMN status_kawin, 
						DROP COLUMN agama_id, 
						DROP COLUMN agama_nama, 
						DROP COLUMN pekerjaan, 
						DROP COLUMN pendidikan_id, 
						DROP COLUMN pendidikan, 
						DROP COLUMN warga_negara_id, 
						DROP COLUMN warga_negara;';
			$this->patching->exe_script($sql);
		}

		$sql = "UPDATE perkara_putusan_pemberitahuan_putusan SET tanggal_pemberitahuan_putusan = NULL WHERE tanggal_pemberitahuan_putusan = '0000-00-00';";
		$this->patching->exe_script($sql);

		$sql = "UPDATE perkara_putusan_pemberitahuan_putusan SET tanggal_menerima_putusan = NULL WHERE tanggal_menerima_putusan = '0000-00-00';";
		$this->patching->exe_script($sql);

		$sql = "UPDATE perkara_putusan_pemberitahuan_putusan SET tanggal_kirim_salinan_putusan = NULL WHERE tanggal_kirim_salinan_putusan = '0000-00-00';";
		$this->patching->exe_script($sql);

		$sql = "UPDATE  sys_groups SET lft = '8', rgt = '9' WHERE groupid = '702';";
		$this->patching->exe_script($sql);
		$sql = "UPDATE  sys_groups SET lft = '10', rgt = '18' WHERE groupid = '410';";
		$this->patching->exe_script($sql);
		$sql = "UPDATE  sys_groups SET lft = '11' ,rgt = '12' WHERE groupid = '411';";
		$this->patching->exe_script($sql);
		$sql = "UPDATE  sys_groups SET lft = '13' ,rgt = '14' WHERE groupid = '412';";
		$this->patching->exe_script($sql);
		$sql = "UPDATE  sys_groups SET lft = '15' ,rgt = '16' WHERE groupid = '413';";
		$this->patching->exe_script($sql);
		$sql = "UPDATE  sys_groups SET lft = '17' ,rgt = '18' WHERE groupid = '414';";
		$this->patching->exe_script($sql);
		$sql = "UPDATE  sys_groups SET lft = '19' WHERE groupid = '420';";
		$this->patching->exe_script($sql);
		$sql = "UPDATE  sys_groups SET lft = '20' ,rgt = '21' WHERE groupid = '421';";
		$this->patching->exe_script($sql);
		$sql = "UPDATE  sys_groups SET lft = '22' ,rgt = '23' WHERE groupid = '422';";
		$this->patching->exe_script($sql);
		$sql = "UPDATE  sys_groups SET lft = '24' ,rgt = '25' WHERE groupid = '423';";
		$this->patching->exe_script($sql);

		$this->patching->exe_script("UPDATE sys_groups SET description = 'Panitera/Wakil Panitera' WHERE groupid = 30;");
		
		$isThere = $this->patching->isColumnExist('status_putusan','satuan');
		if(empty($isThere)){
			$sql = "ALTER TABLE status_putusan
						ADD COLUMN satuan TINYINT NULL  COMMENT '1.Time/Hari,2.Nominal/Rupiah,3.checkbox,4.Uraian;' AFTER urutan;";
			$this->patching->exe_script($sql);
		}
		$isThere = $this->patching->isColumnExist('perkara_grasi','pemohon_pangkat');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_grasi 
						ADD COLUMN pemohon_pangkat VARCHAR(100) NULL AFTER pemohon_nama, ADD COLUMN pemohon_nrp VARCHAR(50) NULL AFTER pemohon_pangkat, ADD COLUMN pemohon_jabatan VARCHAR(100) NULL AFTER pemohon_nrp, ADD COLUMN pemohon_kesatuan VARCHAR(100) NULL AFTER pemohon_jabatan;";
			$this->patching->exe_script($sql);
		}

		$sql = "UPDATE status_putusan SET satuan = 1 WHERE id IN (24,23,13,14);";
		$this->patching->exe_script($sql);
		$sql = "UPDATE status_putusan SET satuan = 2 WHERE id IN (16,25);";
		$this->patching->exe_script($sql);
		$sql = "UPDATE status_putusan SET satuan = 3 WHERE id IN (26,22,21,20,19,18,15,12,11,1);";
		$this->patching->exe_script($sql);
		$sql = "UPDATE status_putusan SET satuan = 4 WHERE id IN (27,17);";
		$this->patching->exe_script($sql);

		$sql = "DELETE FROM perkara_putusan_terdakwa WHERE status_putusan_id IS NULL;";
		$this->patching->exe_script($sql);

		$sql = "DELETE FROM perkara_putusan_terdakwa WHERE pihak_id IS NULL;";
		$this->patching->exe_script($sql);

		
		$isThere = $this->patching->isTableExist('perkara_putusan_terdakwa_copy');
		if(empty($isThere)){
			$sql = "CREATE TABLE perkara_putusan_terdakwa_copy LIKE perkara_putusan_terdakwa;";
			$this->patching->exe_script($sql);
			$sql = "REPLACE INTO perkara_putusan_terdakwa_copy SELECT * FROM perkara_putusan_terdakwa;";
			$this->patching->exe_script($sql);
			$sql = "DROP TABLE IF EXISTS perkara_putusan_terdakwa_tmp;";
			$this->patching->exe_script($sql);

			$sql = "CREATE TABLE perkara_putusan_terdakwa_tmp (
						pihak2_id bigint(20) unsigned NOT NULL,
						perkara_id bigint(20) unsigned NOT NULL,
						pihak_id bigint(20) unsigned NOT NULL,
						tanggal_putusan date DEFAULT NULL,
						status_putusan_id tinyint(4) NOT NULL,
						status_putusan_text varchar(75) DEFAULT NULL,
						durasi_nominal TEXT DEFAULT NULL,
						satuan tinyint(4) DEFAULT NULL,
						keterangan_putusan varchar(1000) DEFAULT NULL,
						diinput_oleh varchar(30) DEFAULT NULL,
						diinput_tanggal datetime DEFAULT NULL,
						diperbaharui_oleh varchar(30) DEFAULT NULL,
						diperbaharui_tanggal datetime DEFAULT NULL,
						PRIMARY KEY (pihak2_id,perkara_id,status_putusan_id),
						KEY perkara_id (perkara_id),
						KEY pihak_id (pihak_id),
						KEY status_putusan_id (status_putusan_id)
					) ENGINE=InnoDB;";
			$this->patching->exe_script($sql);

			$sql = "REPLACE INTO perkara_putusan_terdakwa_tmp
					SELECT pihak2_id, perkara_id, pihak_id,tanggal_putusan, status_putusan, s.nama AS status_putusan_text, 
					CASE
						WHEN status_putusan=13 THEN (pidana_penjara_waktu_tertentu_tahun*12*30)+(pidana_penjara_waktu_tertentu_bulan*30)+pidana_penjara_waktu_tertentu_hari
						WHEN status_putusan=14 THEN (pidana_kurungan_tahun*12*30)+(pidana_kurungan_bulan*30)+pidana_kurungan_hari
						WHEN status_putusan=16 THEN pidana_denda_nominal
						WHEN status_putusan=17 THEN CONCAT(
						 IF(pidana_tambahan_tahun=0,'',concat(pidana_tambahan_tahun, ' Tahun, ')),
						 IF(pidana_tambahan_bulan=0,'',concat(pidana_tambahan_bulan, ' Bulan  ')),
						 IF(pidana_tambahan_hari=0,'',concat(pidana_tambahan_hari, ' Hari ')))
						WHEN status_putusan=23 THEN (subsider_penjara_tahun*12*30)+(subsider_penjara_bulan*30)+subsider_penjara_hari
						WHEN status_putusan=24 THEN (subsider_kurungan_tahun*12*30)+(subsider_kurungan_bulan*30)+subsider_kurungan_hari
						WHEN status_putusan=25 THEN subsider_denda_nominal
						ELSE 0
					END
						AS durasi_nominal,
					s.satuan, keterangan_putusan, put.diinput_oleh, put.diinput_tanggal, put.diperbaharui_oleh, put.diperbaharui_tanggal
						FROM (
							SELECT SUBSTRING_INDEX(SUBSTRING_INDEX(e.status_putusan_id, ',', n.n), ',', -1) AS status_putusan, e.*
								FROM perkara_putusan_terdakwa AS e CROSS JOIN (
										SELECT a.N + b.N * 10 + 1 n
										FROM 
											(SELECT 0 AS N UNION ALL SELECT 1 UNION ALL SELECT 2 UNION ALL SELECT 3 UNION ALL SELECT 4 UNION ALL SELECT 5 UNION ALL SELECT 6 UNION ALL SELECT 7           UNION ALL SELECT 8 UNION ALL SELECT 9) a,
											(SELECT 0 AS N UNION ALL SELECT 1 UNION ALL SELECT 2 UNION ALL SELECT 3 UNION ALL SELECT 4 UNION ALL SELECT 5 UNION ALL SELECT 6 UNION ALL SELECT 7
											UNION ALL SELECT 8 UNION ALL SELECT 9) b
											ORDER BY n) n
									GROUP BY status_putusan, pihak2_id,perkara_id
							ORDER BY e.pihak2_id, e.status_putusan_id ASC) AS put
							LEFT JOIN
								status_putusan AS s
								ON s.id = put.status_putusan;";
			$this->patching->exe_script($sql);
			$this->dbforge->drop_table('perkara_putusan_terdakwa',TRUE);
			$this->dbforge->rename_table('perkara_putusan_terdakwa_tmp', 'perkara_putusan_terdakwa');
		}else{
			$sql = "DROP TABLE IF EXISTS perkara_putusan_terdakwa_tmp;";
			$this->patching->exe_script($sql);

			$sql = "CREATE TABLE perkara_putusan_terdakwa_tmp (
						pihak2_id bigint(20) unsigned NOT NULL,
						perkara_id bigint(20) unsigned NOT NULL,
						pihak_id bigint(20) unsigned NOT NULL,
						tanggal_putusan date DEFAULT NULL,
						status_putusan_id tinyint(4) NOT NULL,
						status_putusan_text varchar(75) DEFAULT NULL,
						durasi_nominal TEXT DEFAULT NULL,
						satuan tinyint(4) DEFAULT NULL,
						keterangan_putusan varchar(1000) DEFAULT NULL,
						diinput_oleh varchar(30) DEFAULT NULL,
						diinput_tanggal datetime DEFAULT NULL,
						diperbaharui_oleh varchar(30) DEFAULT NULL,
						diperbaharui_tanggal datetime DEFAULT NULL,
						PRIMARY KEY (pihak2_id,perkara_id,status_putusan_id),
						KEY perkara_id (perkara_id),
						KEY pihak_id (pihak_id),
						KEY status_putusan_id (status_putusan_id)
					) ENGINE=InnoDB;";
			$this->patching->exe_script($sql);
			$sql = "REPLACE INTO perkara_putusan_terdakwa_tmp
					SELECT pihak2_id, perkara_id, pihak_id,tanggal_putusan, status_putusan, s.nama AS status_putusan_text, 
					CASE
						WHEN status_putusan=13 THEN (pidana_penjara_waktu_tertentu_tahun*12*30)+(pidana_penjara_waktu_tertentu_bulan*30)+pidana_penjara_waktu_tertentu_hari
						WHEN status_putusan=14 THEN (pidana_kurungan_tahun*12*30)+(pidana_kurungan_bulan*30)+pidana_kurungan_hari
						WHEN status_putusan=16 THEN pidana_denda_nominal
						WHEN status_putusan=17 THEN CONCAT(
						 IF(pidana_tambahan_tahun=0,'',concat(pidana_tambahan_tahun, ' Tahun, ')),
						 IF(pidana_tambahan_bulan=0,'',concat(pidana_tambahan_bulan, ' Bulan  ')),
						 IF(pidana_tambahan_hari=0,'',concat(pidana_tambahan_hari, ' Hari ')))
						WHEN status_putusan=23 THEN (subsider_penjara_tahun*12*30)+(subsider_penjara_bulan*30)+subsider_penjara_hari
						WHEN status_putusan=24 THEN (subsider_kurungan_tahun*12*30)+(subsider_kurungan_bulan*30)+subsider_kurungan_hari
						WHEN status_putusan=25 THEN subsider_denda_nominal
						ELSE 0
					END
						AS durasi_nominal,
					s.satuan, keterangan_putusan, put.diinput_oleh, put.diinput_tanggal, put.diperbaharui_oleh, put.diperbaharui_tanggal
						FROM (
							SELECT SUBSTRING_INDEX(SUBSTRING_INDEX(e.status_putusan_id, ',', n.n), ',', -1) AS status_putusan, e.*
								FROM perkara_putusan_terdakwa_copy AS e CROSS JOIN (
										SELECT a.N + b.N * 10 + 1 n
										FROM 
											(SELECT 0 AS N UNION ALL SELECT 1 UNION ALL SELECT 2 UNION ALL SELECT 3 UNION ALL SELECT 4 UNION ALL SELECT 5 UNION ALL SELECT 6 UNION ALL SELECT 7           UNION ALL SELECT 8 UNION ALL SELECT 9) a,
											(SELECT 0 AS N UNION ALL SELECT 1 UNION ALL SELECT 2 UNION ALL SELECT 3 UNION ALL SELECT 4 UNION ALL SELECT 5 UNION ALL SELECT 6 UNION ALL SELECT 7
											UNION ALL SELECT 8 UNION ALL SELECT 9) b
											ORDER BY n) n
									GROUP BY status_putusan, pihak2_id,perkara_id
							ORDER BY e.pihak2_id, e.status_putusan_id ASC) AS put
							LEFT JOIN
								status_putusan AS s
								ON s.id = put.status_putusan;";
			$this->patching->exe_script($sql);
			$this->dbforge->drop_table('perkara_putusan_terdakwa',TRUE);
			$this->dbforge->rename_table('perkara_putusan_terdakwa_tmp', 'perkara_putusan_terdakwa');
		}

		
		$isThere = $this->patching->isColumnExist('perkara_putusan','hakim_pengawas_nama');
		if(!empty($isThere)){
			$sql = "UPDATE perkara_putusan SET tanggal_putusan = '0000-00-00' WHERE tanggal_putusan IS NULL;";
			$this->patching->exe_script($sql);
			$sql = 'ALTER TABLE perkara_putusan
						CHANGE amar_putusan amar_putusan MEDIUMTEXT NULL,
						CHANGE tanggal_putusan tanggal_putusan DATE NOT NULL, 
						DROP PRIMARY KEY,
						ADD PRIMARY KEY (perkara_id, tanggal_putusan),
						DROP COLUMN hakim_pengawas_nama, 
						DROP COLUMN pengurus_nama, 
						DROP COLUMN kurator_nama;';
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('kurator','tempat_lahir');
		if(!empty($isThere)){
			$sql = 'ALTER TABLE kurator   
						DROP COLUMN tempat_lahir, 
						DROP COLUMN tanggal_lahir, 
						DROP COLUMN jenis_kelamin, 
						DROP COLUMN golongan_darah, 
						DROP COLUMN alamat, 
						DROP COLUMN rtrw, 
						DROP COLUMN kelurahan, 
						DROP COLUMN kecamatan, 
						DROP COLUMN kabupaten_id, 
						DROP COLUMN kabupaten, 
						DROP COLUMN propinsi_id, 
						DROP COLUMN propinsi, 
						DROP COLUMN telepon, 
						DROP COLUMN fax, 
						DROP COLUMN email, 
						DROP COLUMN agama_id, 
						DROP COLUMN agama_nama, 
						DROP COLUMN status_kawin, 
						DROP COLUMN pekerjaan, 
						DROP COLUMN pendidikan_id, 
						DROP COLUMN pendidikan, 
						DROP COLUMN warga_negara_id, 
						DROP COLUMN warga_negara;';
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_penyegelan','pelaksanaan_pengangakatan_sita');
		if(!empty($isThere)){
			$sql = 'ALTER TABLE perkara_penyegelan CHANGE pelaksanaan_pengangakatan_sita pelaksanaan_pengangakatan_penyegelan DATE NULL;';
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_harta_pailit','alur_perkara_id');
		if(!empty($isThere)){
			$sql = 'ALTER TABLE perkara_harta_pailit   
						DROP COLUMN alur_perkara_id, 
						DROP COLUMN nomor_perkara, 
						DROP COLUMN para_pihak, 
						DROP COLUMN putusan_id, 
						DROP COLUMN tanggal_putusan, 
						DROP COLUMN nomor_putusan, 
						DROP COLUMN penetapan_hakim_pengawas, 
						DROP COLUMN nomor_penetapan_hakim_pengawas, 
						DROP COLUMN panitera_nama, 
						DROP COLUMN jurusita_nama, 
						CHANGE hakim_pengawas hakim_pengawas_id BIGINT NULL, 
						DROP INDEX nomor_perkara;';
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_harta_pailit','tanggal_penetapan_hakim_pengawas');
		if(empty($isThere)){
			$sql = 'ALTER TABLE perkara_harta_pailit ADD COLUMN tanggal_penetapan_hakim_pengawas DATE NULL  COMMENT "Tanggal Penetapan Hakim Pengawas" AFTER tanggal_pendaftaran;';
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_harta_pailit','kurator_id');
		if(empty($isThere)){
			$sql = 'ALTER TABLE perkara_harta_pailit ADD COLUMN kurator_id BIGINT(20) NULL DEFAULT NULL AFTER hakim_pengawas_id;';
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_actio_pauliana','tanggal_pendaftaran');
		if(!empty($isThere)){
			$sql = 'ALTER TABLE perkara_actio_pauliana   
						DROP COLUMN tanggal_pendaftaran, 
						DROP COLUMN nomor_perkara, 
						DROP COLUMN nomor_indeks, 
						DROP COLUMN pemohon_nama, 
						DROP COLUMN pemohon_pekerjaan, 
						DROP COLUMN pemohon_alamat, 
						DROP COLUMN pemohon_actio, 
						DROP COLUMN petitum, 
						DROP COLUMN petitum_dok, 
						DROP COLUMN penetapan_majelis_hakim, 
						DROP COLUMN majelis_hakim_id, 
						DROP COLUMN majelis_hakim_kode, 
						DROP COLUMN majelis_hakim_nama, 
						DROP COLUMN majelis_hakim_text, 
						DROP COLUMN penetapan_panitera_pengganti, 
						DROP COLUMN panitera_pengganti_id, 
						DROP COLUMN panitera_pengganti_text, 
						DROP COLUMN penetapan_hari_sidang, 
						DROP COLUMN sidang_pertama, 
						DROP COLUMN tanggal_putusan, 
						DROP COLUMN amar_putusan, 
						DROP COLUMN tanggal_minutasi;';
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_pihak2','tempat_lahir');
		if(!empty($isThere)){
			$sql = 'ALTER TABLE perkara_pihak2   
						DROP COLUMN tempat_lahir, 
						DROP COLUMN tanggal_lahir, 
						DROP COLUMN umur, 
						DROP COLUMN dewasa, 
						DROP COLUMN jenis_kelamin, 
						DROP COLUMN status_kawin, 
						DROP COLUMN agama_id, 
						DROP COLUMN agama_nama, 
						DROP COLUMN pekerjaan, 
						DROP COLUMN pendidikan_id, 
						DROP COLUMN pendidikan, 
						DROP COLUMN warga_negara_id, 
						DROP COLUMN warga_negara,
						CHANGE alamat alamat VARCHAR(500) NULL;;';
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_pihak1','tempat_lahir');
		if(!empty($isThere)){
			$sql = 'ALTER TABLE perkara_pihak1   
						DROP COLUMN tempat_lahir, 
						DROP COLUMN tanggal_lahir, 
						DROP COLUMN umur, 
						DROP COLUMN dewasa, 
						DROP COLUMN jenis_kelamin, 
						DROP COLUMN status_kawin, 
						DROP COLUMN agama_id, 
						DROP COLUMN agama_nama, 
						DROP COLUMN pekerjaan, 
						DROP COLUMN pendidikan_id, 
						DROP COLUMN pendidikan, 
						DROP COLUMN warga_negara_id, 
						DROP COLUMN warga_negara,
						CHANGE alamat alamat VARCHAR(500) NULL;';
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_pihak3','tempat_lahir');
		if(!empty($isThere)){
			$sql = 'ALTER TABLE perkara_pihak3   
						DROP COLUMN tempat_lahir, 
						DROP COLUMN tanggal_lahir, 
						DROP COLUMN umur, 
						DROP COLUMN dewasa, 
						DROP COLUMN jenis_kelamin, 
						DROP COLUMN status_kawin, 
						DROP COLUMN agama_id, 
						DROP COLUMN agama_nama, 
						DROP COLUMN pekerjaan, 
						DROP COLUMN pendidikan_id, 
						DROP COLUMN pendidikan, 
						DROP COLUMN warga_negara_id, 
						DROP COLUMN warga_negara,
						CHANGE alamat alamat VARCHAR(500) NULL;';
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_pihak4','tempat_lahir');
		if(!empty($isThere)){
			$sql = 'ALTER TABLE perkara_pihak4   
						DROP COLUMN tempat_lahir, 
						DROP COLUMN tanggal_lahir, 
						DROP COLUMN umur, 
						DROP COLUMN dewasa, 
						DROP COLUMN jenis_kelamin, 
						DROP COLUMN status_kawin, 
						DROP COLUMN agama_id, 
						DROP COLUMN agama_nama, 
						DROP COLUMN pekerjaan, 
						DROP COLUMN pendidikan_id, 
						DROP COLUMN pendidikan, 
						DROP COLUMN warga_negara_id, 
						DROP COLUMN warga_negara,
						CHANGE alamat alamat VARCHAR(500) NULL;';
			$this->patching->exe_script($sql);
		}

		$sql = 'DROP VIEW IF EXISTS v_lalulintas;';
		$this->patching->exe_script($sql);
		$sql = 'DROP VIEW IF EXISTS v_perkara_pihak1;';
		$this->patching->exe_script($sql);
		$sql = 'DROP VIEW IF EXISTS v_perkara_pihak2;';
		$this->patching->exe_script($sql);
		$sql = 'DROP VIEW IF EXISTS v_penahanan;';
		$this->patching->exe_script($sql);
		$sql = 'DROP VIEW IF EXISTS v_perkara_detil;';
		$this->patching->exe_script($sql);
		$sql = 'DROP VIEW IF EXISTS v_putusan_terdakwa;';
		$this->patching->exe_script($sql);
		$data = array(
			'id' => 7,
			'kode' => 'Pdt.Bth',
			'nama' => 'Perlawanan/Bantahan (derden verzet)',
			'keterangan' => 'Perdata Perlawanan/Bantahan',
			'aktif' => 'Y',
			'urutan' => 7,
			);
		$this->patching->replace_data('alur_perkara',$data);

		$data = array(
			'id' => 8,
			'kode' => 'Pdt.G.S',
			'nama' => 'Gugatan Sederhana',
			'keterangan' => 'Gugatan Sederhana',
			'aktif' => 'Y',
			'urutan' => 9,
			);
		$this->patching->replace_data('alur_perkara',$data);

		$data = array(
			'id' => 119,
			'kode' => 'Pid.Pra',
			'nama' => 'Pidana Praperadilan',
			'keterangan' => 'Pidana Praperadilan',
			'aktif' => 'Y',
			'urutan' => 9,
			);
		$this->patching->replace_data('alur_perkara',$data);

		$this->patching->exe_script("REPLACE INTO alur_perkara(id,kode,nama,keterangan,urutan,jenis_pengadilan)
			VALUES (15,'Pdt.G','Perdata Gugatan','Perdata Gugatan Pengadilan Agama',1,4),
				   (16,'Pdt.P','Perdata Permohonan','Perdata Permohonan Pengadilan Agama',2,4);");


		$sql = 'REPLACE INTO biaya_perkara (alur_perkara_id,jenis_biaya_id,jumlah) SELECT 7,jenis_biaya_id,jumlah FROM biaya_perkara WHERE alur_perkara_id=1;';
		$this->patching->exe_script($sql);

		$sql = 'REPLACE INTO jenis_alur_perkara (alur_perkara_id, jenis_perkara_id) SELECT 7, jenis_perkara_id FROM jenis_alur_perkara WHERE alur_perkara_id=1;';
		$this->patching->exe_script($sql);

		$sql = "UPDATE status_pihak SET nama='Anak Berhadapan dengan Hukum' WHERE alur_perkara_id=118 AND tahapan_id=10 AND pihak_ke=2;";
		$this->patching->exe_script($sql);

		$sql = "UPDATE status_pihak SET nama='Penuntut Umum' WHERE tahapan_id=10 AND pihak_ke=1 AND alur_perkara_id>100;";
		$this->patching->exe_script($sql);

		$sql = "UPDATE status_pihak SET nama = 'Pelanggar' WHERE alur_perkara_id = 114 AND tahapan_id = 10 AND pihak_ke = 2;";
		$this->patching->exe_script($sql);

		$sql = "UPDATE status_pihak SET nama = 'Turut Termohon' WHERE alur_perkara_id = 3 AND tahapan_id = 10 AND pihak_ke = 4;";
		$this->patching->exe_script($sql);

		$sql = "UPDATE status_pihak SET nama = 'Turut Termohon' WHERE alur_perkara_id = 4 AND tahapan_id = 10 AND pihak_ke = 4;";
		$this->patching->exe_script($sql);

		$sql = "REPLACE INTO status_pihak (alur_perkara_id, tahapan_id, pihak_ke, nama, aktif, urutan) 
				VALUES(7,10,1,'Penggugat','Y',1)
				,(7,10,2,'Tergugat','Y',2)
				,(7,10,3,'Intervensi','Y','3')
				,(7,10,4,'Turut Tergugat','Y','4')
				,(7,20,1,'Pembanding','Y','1')
				,(7,20,2,'Pembanding/Terbanding','Y','2')
				,(7,20,3,'Turut Terbanding','Y','3')
				,(7,20,4,'Terbanding','Y','4')
				,(7,20,5,'Terbanding/Pembanding','Y','5')
				,(7,30,1,'Pemohon','Y','1')
				,(7,30,2,'Pemohon/Termohon Kasasi','Y','2')
				,(7,30,3,'Turut Termohon Kasasi','Y','3')
				,(7,30,4,'Termohon Kasasi','Y','4')
				,(7,30,5,'Termohon/Pemohon Kasasi','Y','5')
				,(7,40,1,'Pemohon PK','Y','1')
				,(7,40,2,'Pemohon/Termohon PK','Y','2')
				,(7,40,3,'Tutur Termohon PK','Y','3')
				,(7,40,4,'Termohon PK','Y','4')
				,(7,40,5,'Termohon/Pemohon PK','Y','5')
				,(7,50,1,'Pemohon','Y','1')
				,(7,50,2,'Termohon','Y','2')
				,(118,10,6,'Anak Korban','Y',6)
				,(113,10,1,'Penyidik Atas Kuasa PU','Y',1)
				,(119,10,1,'Pemohon','Y','1')
				,(119,10,2,'Termohon','Y','2')
				,(119,20,1,'Pembanding','Y','1')
				,(119,20,2,'Pembanding/Terbanding','Y','2')
				,(119,20,3,'Turut Terbanding','Y','3')
				,(119,20,4,'Terbanding','Y','4')
				,(119,20,5,'Terbanding/Pembanding','Y','5')
				,(119,30,1,'Pemohon','Y','1')
				,(119,30,2,'Pemohon/Termohon Kasasi','Y','2')
				,(119,30,3,'Turut Termohon Kasasi','Y','3')
				,(119,30,4,'Termohon Kasasi','Y','4')
				,(119,30,5,'Termohon/Pemohon Kasasi','Y','5')
				,(119,40,1,'Pemohon PK','Y','1')
				,(119,40,2,'Pemohon/Termohon PK','Y','2')
				,(119,40,3,'Turut Termohon PK','Y','5')
				,(119,40,4,'Termohon PK','Y','3')
				,(119,40,5,'Termohon/Pemohon PK','Y','4')
				,(119,50,1,'Pemohon','Y','1')
				,(119,50,2,'Termohon','Y','2')
				,(8,10,1,'Penggugat','Y','1')
				,(8,10,2,'Tergugat','Y','2')
				,(8,10,4,'Turut Tergugat','Y','4')
				,(8,20,1,'Pemohon','Y','1')
				,(8,20,2,'Pemohon/Termohon','Y','2')
				,(8,20,3,'Turut Termohon','Y','3')
				,(8,20,4,'Termohon','Y','4')
				,(8,20,5,'Termohon/Pemohon','Y','5')
				,(1,10,4,'Turut Tergugat','Y',4)
				,(3,10,4,'Turut Tergugat','Y',4)
				,(4,10,4,'Turut Tergugat','Y',4)
				,(5,10,4,'Turut Tergugat','Y',4)
				,(6,10,4,'Turut Tergugat','Y',4);";
		$this->patching->exe_script($sql);

		$sql = 'DROP VIEW IF EXISTS v_penahanan;';
		$this->patching->exe_script($sql);

		
		$isThere = $this->patching->isColumnExist('perkara_diversi','tgl_laporan_hakim');
		if(empty($isThere)){
			$sql = 'ALTER TABLE perkara_diversi ADD COLUMN tgl_laporan_hakim DATE AFTER isi_singkat_diversi;';
			$this->patching->exe_script($sql);
		}

		$this->patching->exe_script("DROP TABLE IF EXISTS perkara_data_pernikahan;");
		$this->patching->exe_script("CREATE TABLE perkara_data_pernikahan (
				perkara_id bigint(20) unsigned NOT NULL,
				tgl_nikah date NOT NULL,
				tgl_kutipan_akta_nikah date NOT NULL,
				no_kutipan_akta_nikah varchar(100) NULL DEFAULT NULL,
				kua_tempat_nikah varchar(255) NULL DEFAULT NULL,
				diedit_oleh varchar(30) DEFAULT NULL,
				diedit_tanggal datetime DEFAULT NULL,
				diinput_oleh varchar(30) DEFAULT NULL,
				diinput_tanggal datetime DEFAULT NULL,
				diperbaharui_oleh varchar(30) DEFAULT NULL,
				diperbaharui_tanggal datetime DEFAULT NULL,  
				PRIMARY KEY (perkara_id),
				CONSTRAINT perkara_data_pernikahan_fk FOREIGN KEY (perkara_id) REFERENCES perkara(perkara_id) ON DELETE CASCADE
				) ENGINE=InnoDB;");

		$sql = "REPLACE INTO jenis_perkara (id, parent_id, kode, nama, nama_lengkap, format_nomor, keterangan, tipe_level, aktif, urutan, level, lft, rgt, diedit_oleh, diedit_tanggal, diinput_oleh, diinput_tanggal, diperbaharui_oleh, diperbaharui_tanggal) 
				VALUES
				('248','157',NULL,'Perlindungan Anak','Pidana Umum/Perlindungan Anak','#nomor_urut_perkara#/Pid.Sus/#tahun#/PN #kode_pn#','Perlindungan Anak','1','Y','71','2','435','436',NULL,NULL,'admin','2014-06-17 12:27:39',NULL,'2014-06-17 12:27:39')
				,('247','168',NULL,'Pelanggaran Pramuwisata','Pelanggaran/Pelanggaran Pramuwisata','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PN #kode_pn#',NULL,'1','Y','10','3','296','297',NULL,NULL,'admin','2012-12-12 08:00:39',NULL,'2012-12-12 08:00:39')
				,('249','158','PRA','Praperadilan','Pidana Praperadilan','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PN #kode_pn#','Pidana PraPeradilan','1','Y','4','2','445','446',NULL,NULL,'admin','2015-05-24 07:07:46',NULL,'2015-05-24 07:07:46')
				,('250','158',NULL,'Sah atau tidaknya penangkapan','Pidana Praperadilan/Sah atau tidaknya penangkapan','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PN #kode_pn#',NULL,'1','Y','4','2','447','448',NULL,NULL,'admin','2015-05-24 07:11:21',NULL,'2015-05-24 07:11:21')
				,('251','158',NULL,'Sah atau tidaknya penahanan','Pidana Praperadilan/Sah atau tidaknya penahanan','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PN #kode_pn#',NULL,'1','Y','4','2','449','450',NULL,NULL,NULL,NULL,NULL,NULL)
				,('252','158',NULL,'Sah atau tidaknya penghentian penyidikan','Pidana Praperadilan/Sah atau tidaknya penghentian penyidikan','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PN #kode_pn#',NULL,'1','Y','4','2','451','452',NULL,NULL,NULL,NULL,NULL,NULL)
				,('253','158',NULL,'Sah atau tidaknya penghentian penuntutan','Pidana Praperadilan/Sah atau tidaknya penghentian penuntutan','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PN #kode_pn#',NULL,'1','Y','4','2','453','454',NULL,NULL,NULL,NULL,NULL,NULL)
				,('254','158',NULL,'Ganti kerugian dan rehabilitasi','Pidana Praperadilan/Ganti kerugian dan rehabilitasi','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PN #kode_pn#',NULL,'1','Y','4','2','455','456',NULL,NULL,NULL,NULL,NULL,NULL)
				,('255','158',NULL,'Ganti kerugian','Pidana Praperadilan/Ganti kerugian','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PN #kode_pn#',NULL,'1','Y','4','2','457','458',NULL,NULL,NULL,NULL,NULL,NULL)
				,('256','158',NULL,'Rehabilitasi','Pidana Praperadilan/Rehabilitasi','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PN #kode_pn#',NULL,'1','Y','4','2','459','460',NULL,NULL,NULL,NULL,NULL,NULL)
				,('257','158',NULL,'Sah atau tidaknya penetapan tersangka','Pidana Praperadilan/Sah atau tidaknya penetapan tersangka','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PN #kode_pn#',NULL,'1','Y','4','2','461','462',NULL,NULL,NULL,NULL,NULL,NULL)
				,('258','158',NULL,'Sah atau tidaknya penyitaan','Pidana Praperadilan/Sah atau tidaknya penyitaan','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PN #kode_pn#',NULL,'1','Y','4','2','463','464',NULL,NULL,NULL,NULL,NULL,NULL)
				,('259','158',NULL,'Sah atau tidaknya penggeledahan','Pidana Praperadilan/Sah atau tidaknya penggeledahan','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PN #kode_pn#',NULL,'1','Y','4','2','465','466',NULL,NULL,NULL,NULL,NULL,NULL)
				,('260','158',NULL,'Lain-lain','Pidana Praperadilan/Lain-lain','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PN #kode_pn#',NULL,'1','Y','4','2','467','468',NULL,NULL,NULL,NULL,NULL,NULL);";
		$this->patching->exe_script($sql);

		$sql = "REPLACE INTO jenis_alur_perkara (alur_perkara_id, jenis_perkara_id) 
				VALUES(119,250),(119,251),(119,252),(119,253),(119,254),(119,255)
				,(119,256),(119,257),(119,258),(119,259),(119,260);";
		$this->patching->exe_script($sql);

		$isThere = $this->patching->isColumnExist('perkara_eksekusi','nomor_register_eksekusi');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_eksekusi   
					ADD COLUMN diterima_permohonan DATE NULL  AFTER status_eksekusi_text,
					ADD COLUMN panggilan_parapihak DATE NULL  AFTER diterima_permohonan,
					ADD COLUMN penetapan_ketua DATE NULL  AFTER panggilan_parapihak,
					ADD COLUMN sk_objek_tidak_punya_kekuatan_hukum DATE NULL  AFTER penetapan_ketua,
					ADD COLUMN surat_tergugat_objek_non_executable DATE NULL  AFTER sk_objek_tidak_punya_kekuatan_hukum,
					ADD COLUMN panggilan_pihak_non_executable DATE NULL  AFTER surat_tergugat_objek_non_executable,
					ADD COLUMN upaya_kesepakatan_kompensasi DATE NULL  AFTER panggilan_pihak_non_executable,
					ADD COLUMN penetapan_ketua_kompensasi DATE NULL  AFTER upaya_kesepakatan_kompensasi,
					ADD COLUMN upaya_hukum_kma DATE NULL  AFTER penetapan_ketua_kompensasi,
					ADD COLUMN penetapan_kma_kompensasi DATE NULL  AFTER upaya_hukum_kma,
					ADD COLUMN uangpaksa_putusan_hakim BIGINT(20) NULL  AFTER penetapan_kma_kompensasi,
					ADD COLUMN uangpaksa_penetapan_ketua BIGINT(20) NULL  AFTER uangpaksa_putusan_hakim,
					ADD COLUMN surat_ketua_tergugat_uangpaksa DATE NULL  AFTER uangpaksa_penetapan_ketua,
					ADD COLUMN surat_peringatan_uangpaksa DATE NULL  AFTER surat_ketua_tergugat_uangpaksa,
					ADD COLUMN perintah_ketua_saksi_administratif DATE NULL  AFTER surat_peringatan_uangpaksa,
					ADD COLUMN sanksi_administratif_dari_pejabat DATE NULL  AFTER perintah_ketua_saksi_administratif,
					ADD COLUMN pengumuman_ketua_panitera_js DATE NULL  AFTER sanksi_administratif_dari_pejabat,
					ADD COLUMN pengumuman_media DATE NULL  AFTER pengumuman_ketua_panitera_js,
					ADD COLUMN surat_presiden DATE NULL  AFTER pengumuman_media,
					ADD COLUMN surat_lembaga_perwakilan_rakyat DATE NULL  AFTER surat_presiden,
					ADD COLUMN nomor_urut_perkara_eksekusi INT(11) NULL AFTER eksekusi_nomor_perkara,
		  			ADD COLUMN nomor_register_eksekusi VARCHAR(50) NULL AFTER nomor_urut_perkara_eksekusi;";
			$this->patching->exe_script($sql);
		}
		$sql = "REPLACE INTO status_putusan (id, jenis_perkara_id, nama, aktif, urutan) VALUES
				(8,1,'Mengabulkan Eksepsi','Y',8),
				(28,8,'Dismissal','Y',1),
				(29,8,'Gugur','Y',2);";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS sinkronisasi;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS perkara_barang_bukti;";
		$this->patching->exe_script($sql);

		$sql = "  CREATE TABLE perkara_barang_bukti (
						id bigint(20) unsigned NOT NULL AUTO_INCREMENT,
						perkara_id bigint(20) unsigned NOT NULL,
						nomor_perkara varchar(50) DEFAULT NULL,
						tanggal_penerimaan date DEFAULT NULL,
						jenis_barang_bukti TEXT DEFAULT NULL,
						tempat_penyimpanan varchar(255) DEFAULT NULL,
						tempat_penyerahan varchar(255) DEFAULT NULL,
						nama_penerima varchar(255) DEFAULT NULL,
						tanggal_penyerahan date DEFAULT NULL,
						catatan_barang_bukti text,
						diedit_oleh varchar(30) DEFAULT NULL,
						diedit_tanggal datetime DEFAULT NULL,
						diinput_oleh varchar(30) DEFAULT NULL,
						diinput_tanggal datetime DEFAULT NULL,
						diperbaharui_oleh varchar(30) DEFAULT NULL,
						diperbaharui_tanggal datetime DEFAULT NULL,
						PRIMARY KEY (id),
						KEY perkara_id (perkara_id),
						KEY perkara_id_2 (perkara_id),
						CONSTRAINT perkara_barang_bukti_ibfk_1 FOREIGN KEY (perkara_id) REFERENCES perkara (perkara_id) ON DELETE CASCADE
					) ENGINE=InnoDB";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS v_perkara_detil;";
		$this->patching->exe_script($sql);

		$sql = "CREATE VIEW v_perkara_detil AS 
				SELECT 
					perkara.perkara_id AS perkara_id,
					perkara.alur_perkara_id AS alur_perkara_id,
					perkara.tanggal_pendaftaran AS tanggal_pendaftaran,
					perkara.jenis_perkara_id AS jenis_perkara_id,
					perkara.jenis_perkara_kode AS jenis_perkara_kode,
					perkara.jenis_perkara_nama AS jenis_perkara_nama,
					perkara.jenis_perkara_text AS jenis_perkara_text,
					perkara.nomor_urut_register AS nomor_urut_register,
					perkara.nomor_urut_perkara AS nomor_urut_perkara,
					perkara.nomor_perkara AS nomor_perkara,
					perkara.nomor_indeks AS nomor_indeks,
					perkara.tanggal_surat AS tanggal_surat,
					perkara.nomor_surat AS nomor_surat,
					perkara.surat_dok AS surat_dok,
					perkara.pihak1_text AS pihak1_text,
					perkara.pengacara_pihak1 AS pengacara_pihak1,
					perkara.pihak2_text AS pihak2_text,
					perkara.pengacara_pihak2 AS pengacara_pihak2,
					perkara.pihak3_text AS pihak3_text,
					perkara.pengacara_pihak3 AS pengacara_pihak3,
					perkara.para_pihak AS para_pihak,
					perkara.pihak_dipublikasikan AS pihak_dipublikasikan,
					perkara.petitum AS petitum,
					perkara.petitum_dok AS petitum_dok,
					perkara.dakwaan AS dakwaan,
					perkara.dakwaan_dok AS dakwaan_dok,
					perkara.tanggal_rencana_perdamaian AS tanggal_rencana_perdamaian,
					perkara.tanggal_pengesahan_perdamaian AS tanggal_pengesahan_perdamaian,
					perkara.tanggal_penyelesaian_mediasi AS tanggal_penyelesaian_mediasi,
					perkara.tanggal_penyelesaian_konsiliasi AS tanggal_penyelesaian_konsiliasi,
					perkara.perkara_rujukan_id AS perkara_rujukan_id,
					perkara.nomor_perkara_rujukan AS nomor_perkara_rujukan,
					perkara.tanggal_pendaftaran_rujukan AS tanggal_pendaftaran_rujukan,
					perkara.catatan_pendaftaran AS catatan_pendaftaran,
					perkara.tahapan_terakhir_id AS tahapan_terakhir_id,
					perkara.tahapan_terakhir_text AS tahapan_terakhir_text,
					perkara.proses_terakhir_id AS proses_terakhir_id,
					perkara.proses_terakhir_text AS proses_terakhir_text,
					perkara.diedit_oleh AS diedit_oleh,
					perkara.diedit_tanggal AS diedit_tanggal,
					perkara.diinput_oleh AS diinput_oleh,
					perkara.diinput_tanggal AS diinput_tanggal,
					perkara.diperbaharui_oleh AS diperbaharui_oleh,
					perkara.diperbaharui_tanggal AS diperbaharui_tanggal,
					perkara_penetapan.penetapan_majelis_hakim AS penetapan_majelis_hakim,
					perkara_penetapan.nomor_sk_penetapan_majelis_hakim AS nomor_sk_penetapan_majelis_hakim,
					perkara_penetapan.majelis_hakim_id AS majelis_hakim_id,
					perkara_penetapan.majelis_hakim_kode AS majelis_hakim_kode,
					perkara_penetapan.majelis_hakim_nama AS majelis_hakim_nama,
					perkara_penetapan.majelis_hakim_text AS majelis_hakim_text,
					perkara_penetapan.penetapan_panitera_pengganti AS penetapan_panitera_pengganti,
					perkara_penetapan.nomor_sk_penetapan_panitera_pengganti AS nomor_sk_penetapan_panitera_pengganti,
					perkara_penetapan.panitera_pengganti_id AS panitera_pengganti_id,
					perkara_penetapan.panitera_pengganti_text AS panitera_pengganti_text,
					perkara_penetapan.penetapan_jurusita AS penetapan_jurusita,
					perkara_penetapan.nomor_sk_penetapan_jurusita AS nomor_sk_penetapan_jurusita,
					perkara_penetapan.jurusita_id AS jurusita_id,
					perkara_penetapan.jurusita_text AS jurusita_text,
					perkara_penetapan.penetapan_hari_sidang AS penetapan_hari_sidang,
					perkara_penetapan.sidang_pertama AS sidang_pertama,
					perkara_mediasi.penetapan_penunjukan_mediator AS penetapan_penunjukan_mediator,
					perkara_mediasi.nomor_sk_penetapan_mediator AS nomor_sk_penetapan_mediator,
					perkara_mediasi.mediator_id AS mediator_id,
					perkara_mediasi.status_mediator AS status_mediator,
					perkara_mediasi.mediator_text AS mediator_text,
					perkara_mediasi.penetapan_tanggal_mediasi AS penetapan_tanggal_mediasi,
					perkara_mediasi.dimulai_mediasi AS dimulai_mediasi,
					perkara_mediasi.keputusan_mediasi AS keputusan_mediasi,
					perkara_mediasi.hasil_mediasi AS hasil_mediasi,
					perkara_mediasi.mediasi_berhasil AS mediasi_berhasil,
					perkara_mediasi.akta_perdamaian AS akta_perdamaian,
					perkara_mediasi.isi_akta_perdamaian AS isi_akta_perdamaian,
					perkara_mediasi.isi_akta_perdamaian_dok AS isi_akta_perdamaian_dok,
					perkara_mediasi.mediasi_gagal AS mediasi_gagal,
					perkara_penuntutan.tanggal_penuntutan AS tanggal_penuntutan,
					perkara_penuntutan.isi_penuntutan AS isi_penuntutan,
					perkara_penuntutan.isi_penuntutan_dok AS isi_penuntutan_dok,
					perkara_putusan_sela.tanggal_putusan_sela AS tanggal_putusan_sela,
					perkara_putusan_sela.amar_sela AS amar_sela,
					perkara_putusan_sela.amar_sela_dok AS amar_sela_dok,
					perkara_putusan_sela.tanggal_minutasi_sela AS tanggal_minutasi_sela,
					perkara_putusan_sela.tanggal_berita_sela AS tanggal_berita_sela,
					perkara_putusan_sela.nama_media_berita_sela AS nama_media_berita_sela,
					perkara_putusan_sela.tanggal_surat_kabar_sela AS tanggal_surat_kabar_sela,
					perkara_putusan_sela.nama_surat_kabar_sela AS nama_surat_kabar_sela,
					perkara_putusan_sela.penetapan_hakim_pengawas AS penetapan_hakim_pengawas_sela,
					perkara_putusan_sela.hakim_pengawas_id AS hakim_pengawas_id_sela,
					perkara_putusan_sela.hakim_pengawas_id AS hakim_pengawas_nama_sela,
					perkara_putusan_sela.pengurus_id AS pengurus_id_sela,
					perkara_putusan_sela.pengurus_nama AS pengurus_nama_sela,
					perkara_putusan_sela.tanggal_perpanjangan AS tanggal_perpanjangan_sela,
					perkara_putusan_sela.mulai_perpanjangan AS mulai_perpanjangan_sela,
					perkara_putusan_sela.sampai_perpanjangan AS sampai_perpanjangan_sela,
					perkara_putusan_sela.waktu_perpanjangan AS waktu_perpanjangan_sela,
					perkara_putusan_sela.penetapan_sita_jaminan AS penetapan_sita_jaminan_sela,
					perkara_putusan_sela.pelaksanaan_sita_jaminan AS pelaksanaan_sita_jaminan_sela,
					perkara_putusan.tanggal_putusan AS tanggal_putusan,
					perkara_putusan.putusan_verstek AS putusan_verstek,
					perkara_putusan.sumber_hukum_id AS sumber_hukum_id,
					perkara_putusan.status_putusan_id AS status_putusan_id,
					perkara_putusan.status_putusan_kode AS status_putusan_kode,
					perkara_putusan.status_putusan_nama AS status_putusan_nama,
					perkara_putusan.status_putusan_text AS status_putusan_text,
					perkara_putusan.tanggal_cabut AS tanggal_cabut,
					perkara_putusan.tanggal_gugur AS tanggal_gugur,
					perkara_putusan.amar_putusan AS amar_putusan,
					perkara_putusan.amar_putusan_dok AS amar_putusan_dok,
					perkara_putusan.penetapan_hakim_pengawas AS penetapan_hakim_pengawas,
					perkara_putusan.nomor_penetapan_hakim_pengawas AS nomor_penetapan_hakim_pengawas,
					perkara_putusan.hakim_pengawas_id AS hakim_pengawas_id,
					perkara_putusan.pengurus_id AS pengurus_id,
					perkara_putusan.tanggal_penetapan_kreditur AS tanggal_penetapan_kreditur,
					perkara_putusan.panitia_kreditur AS panitia_kreditur,
					perkara_putusan.kurator_id AS kurator_id,
					perkara_putusan.tanggal_berita_putusan AS tanggal_berita_putusan,
					perkara_putusan.nama_media_berita_putusan AS nama_media_berita_putusan,
					perkara_putusan.tanggal_surat_kabar_putusan AS tanggal_surat_kabar_putusan,
					perkara_putusan.nama_surat_kabar_putusan AS nama_surat_kabar_putusan,
					perkara_putusan.tanggal_minutasi AS tanggal_minutasi,
					perkara_putusan.pemberitahuan_putusan AS pemberitahuan_putusan,
					perkara_putusan.pemberitahuan_putusan_pihak1 AS pemberitahuan_putusan_pihak1,
					perkara_putusan.pemberitahuan_putusan_pihak2 AS pemberitahuan_putusan_pihak2,
					perkara_putusan.pemberitahuan_putusan_pihak3 AS pemberitahuan_putusan_pihak3,
					perkara_putusan.menerima_putusan_pihak1 AS menerima_putusan_pihak1,
					perkara_putusan.menerima_putusan_pihak2 AS menerima_putusan_pihak2,
					perkara_putusan.penerbitan_salinan_putusan AS penerbitan_salinan_putusan,
					perkara_putusan.kirim_salinan_putusan_pihak1 AS kirim_salinan_putusan_pihak1,
					perkara_putusan.kirim_salinan_putusan_pihak2 AS kirim_salinan_putusan_pihak2,
					perkara_putusan.kirim_salinan_putusan_pihak3 AS kirim_salinan_putusan_pihak3,
					perkara_putusan.kirim_salinan_putusan_penyidik AS kirim_salinan_putusan_penyidik,
					perkara_verzet.tanggal_pendaftaran_verzet AS tanggal_pendaftaran_verzet,
					perkara_verzet.tanggal_penetapan_sidang_verzet AS tanggal_penetapan_sidang_verzet,
					perkara_verzet.tanggal_sidang_pertama_verzet AS tanggal_sidang_pertama_verzet,
					perkara_verzet.putusan_verzet AS putusan_verzet,
					perkara_verzet.status_putusan_verzet_id AS status_putusan_verzet_id,
					perkara_verzet.status_putusan_verzet_text AS status_putusan_verzet_text,
					perkara_verzet.amar_putusan_verzet AS amar_putusan_verzet,
					perkara_verzet.amar_putusan_verzet_dok AS amar_putusan_verzet_dok,
					perkara_verzet.pemberitahuan_putusan_verzet AS pemberitahuan_putusan_verzet,
					perkara_verzet.pemberitahuan_putusan_verzet_pihak1 AS pemberitahuan_putusan_verzet_pihak1,
					perkara_verzet.pemberitahuan_putusan_verzet_pihak2 AS pemberitahuan_putusan_verzet_pihak2,
					perkara_banding.permohonan_banding AS permohonan_banding,
					perkara_banding.pemohon_banding AS pemohon_banding,
					perkara_banding.para_pihak AS para_pihak_banding,
					perkara_banding.pemberitahuan_permohonan_banding AS pemberitahuan_permohonan_banding,
					perkara_banding.penerimaan_memori_banding AS penerimaan_memori_banding,
					perkara_banding.penyerahan_memori_banding AS penyerahan_memori_banding,
					perkara_banding.penerimaan_kontra_banding AS penerimaan_kontra_banding,
					perkara_banding.penyerahan_kontra_banding AS penyerahan_kontra_banding,
					perkara_banding.pemberitahuan_inzage AS pemberitahuan_inzage,
					perkara_banding.pemberitahuan_inzage_pembanding AS pemberitahuan_inzage_pembanding,
					perkara_banding.pemberitahuan_inzage_terbanding AS pemberitahuan_inzage_terbanding,
					perkara_banding.pelaksanaan_inzage AS pelaksanaan_inzage,
					perkara_banding.pelaksanaan_inzage_pembanding AS pelaksanaan_inzage_pembanding,
					perkara_banding.pelaksanaan_inzage_terbanding AS pelaksanaan_inzage_terbanding,
					perkara_banding.pengiriman_berkas_banding AS pengiriman_berkas_banding,
					perkara_banding.nomor_surat_pengiriman_berkas_banding AS nomor_surat_pengiriman_berkas_banding,
					perkara_banding.penerimaan_kembali_berkas_banding AS penerimaan_kembali_berkas_banding,
					perkara_banding.putusan_banding AS putusan_banding,
					perkara_banding.nomor_perkara_banding AS nomor_perkara_banding,
					perkara_banding.majelis_hakim_banding AS majelis_hakim_banding,
					perkara_banding.panitera_pengganti_banding AS panitera_pengganti_banding,
					perkara_banding.amar_putusan_banding AS amar_putusan_banding,
					perkara_banding.amar_putusan_banding_dok AS amar_putusan_banding_dok,
					perkara_banding.minutasi_banding AS minutasi_banding,
					perkara_banding.pemberitahuan_putusan_banding AS pemberitahuan_putusan_banding,
					perkara_banding.pemberitahuan_putusan_banding_pembanding AS pemberitahuan_putusan_banding_pembanding,
					perkara_banding.pemberitahuan_putusan_banding_terbanding AS pemberitahuan_putusan_banding_terbanding,
					perkara_kasasi.permohonan_kasasi AS permohonan_kasasi,
					perkara_kasasi.pemohon_kasasi AS pemohon_kasasi,
					perkara_kasasi.para_pihak AS para_pihak_kasasi,
					perkara_kasasi.pemberitahuan_kasasi AS pemberitahuan_kasasi,
					perkara_kasasi.penerimaan_memori_kasasi AS penerimaan_memori_kasasi,
					perkara_kasasi.penyerahan_memori_kasasi AS penyerahan_memori_kasasi,
					perkara_kasasi.penerimaan_kontra_kasasi AS penerimaan_kontra_kasasi,
					perkara_kasasi.penyerahan_kontra_kasasi AS penyerahan_kontra_kasasi,
					perkara_kasasi.pemberitahuan_inzage_kasasi AS pemberitahuan_inzage_kasasi,
					perkara_kasasi.pemberitahuan_inzage_pemohon_kasasi AS pemberitahuan_inzage_pemohon_kasasi,
					perkara_kasasi.pemberitahuan_inzage_termohon_kasasi AS pemberitahuan_inzage_termohon_kasasi,
					perkara_kasasi.pelaksanaan_inzage_kasasi AS pelaksanaan_inzage_kasasi,
					perkara_kasasi.pelaksanaan_inzage_pemohon_kasasi AS pelaksanaan_inzage_pemohon_kasasi,
					perkara_kasasi.pelaksanaan_inzage_termohon_kasasi AS pelaksanaan_inzage_termohon_kasasi,
					perkara_kasasi.pengiriman_berkas_kasasi AS pengiriman_berkas_kasasi,
					perkara_kasasi.nomor_surat_pengiriman_berkas_kasasi AS nomor_surat_pengiriman_berkas_kasasi,
					perkara_kasasi.penerimaan_berkas_kasasi AS penerimaan_berkas_kasasi,
					perkara_kasasi.putusan_kasasi AS putusan_kasasi,
					perkara_kasasi.nomor_perkara_kasasi AS nomor_perkara_kasasi,
					perkara_kasasi.majelis_hakim_kasasi AS majelis_hakim_kasasi,
					perkara_kasasi.panitera_pengganti_kasasi AS panitera_pengganti_kasasi,
					perkara_kasasi.amar_putusan_kasasi AS amar_putusan_kasasi,
					perkara_kasasi.amar_putusan_kasasi_dok AS amar_putusan_kasasi_dok,
					perkara_kasasi.minutasi_kasasi AS minutasi_kasasi,
					perkara_kasasi.pemberitahuan_putusan_kasasi AS pemberitahuan_putusan_kasasi,
					perkara_kasasi.pemberitahuan_putusan_kasasi_pihak1 AS pemberitahuan_putusan_kasasi_pihak1,
					perkara_kasasi.pemberitahuan_putusan_kasasi_pihak2 AS pemberitahuan_putusan_kasasi_pihak2,
					perkara_kasasi.tanggal_berita_putusan_kasasi AS tanggal_berita_putusan_kasasi,
					perkara_kasasi.nama_media_berita_putusan_kasasi AS nama_media_berita_putusan_kasasi,
					perkara_kasasi.tanggal_surat_kabar_putusan_kasasi AS tanggal_surat_kabar_putusan_kasasi,
					perkara_kasasi.nama_surat_kabar_putusan_kasasi AS nama_surat_kabar_putusan_kasasi,
					perkara_pk.permohonan_pk AS permohonan_pk,
					perkara_pk.pemohon_pk AS pemohon_pk,
					perkara_pk.para_pihak AS para_pihak_pk,
					perkara_pk.alasan_pk AS alasan_pk,
					perkara_pk.pemberitahuan_pk AS pemberitahuan_pk,
					perkara_pk.penerimaan_memori_pk AS penerimaan_memori_pk,
					perkara_pk.penyerahan_memori_pk AS penyerahan_memori_pk,
					perkara_pk.penerimaan_kontra_pk AS penerimaan_kontra_pk,
					perkara_pk.penyerahan_kontra_pk AS penyerahan_kontra_pk,
					perkara_pk.penetapan_majelis_hakim_pk AS penetapan_majelis_hakim_pk,
					perkara_pk.hakim_id_pk AS hakim_id_pk,
					perkara_pk.hakim_nama_pk AS hakim_nama_pk,
					perkara_pk.penetapan_pemeriksaan_pk AS penetapan_pemeriksaan_pk,
					perkara_pk.pemeriksaan_pk AS pemeriksaan_pk,
					perkara_pk.pendapat_jaksa AS pendapat_jaksa,
					perkara_pk.isi_pendapat_jaksa AS isi_pendapat_jaksa,
					perkara_pk.pendapat_hakim AS pendapat_hakim,
					perkara_pk.isi_pendapat_hakim AS isi_pendapat_hakim,
					perkara_pk.tanggal_penyumpahan AS tanggal_penyumpahan,
					perkara_pk.pemberitahuan_inzage_pk AS pemberitahuan_inzage_pk,
					perkara_pk.pemberitahuan_inzage_pemohon_pk AS pemberitahuan_inzage_pemohon_pk,
					perkara_pk.pemberitahuan_inzage_termohon_pk AS pemberitahuan_inzage_termohon_pk,
					perkara_pk.pelaksanaan_inzage_pk AS pelaksanaan_inzage_pk,
					perkara_pk.pelaksanaan_inzage_pemohon_pk AS pelaksanaan_inzage_pemohon_pk,
					perkara_pk.pelaksanaan_inzage_termohon_pk AS pelaksanaan_inzage_termohon_pk,
					perkara_pk.pengiriman_berkas_pk AS pengiriman_berkas_pk,
					perkara_pk.nomor_surat_pengiriman_berkas_pk AS nomor_surat_pengiriman_berkas_pk,
					perkara_pk.penerimaan_berkas_pk AS penerimaan_berkas_pk,
					perkara_pk.putusan_pk AS putusan_pk,
					perkara_pk.nomor_perkara_pk AS nomor_perkara_pk,
					perkara_pk.majelis_hakim_pk AS majelis_hakim_pk,
					perkara_pk.panitera_pengganti_pk AS panitera_pengganti_pk,
					perkara_pk.amar_putusan_pk AS amar_putusan_pk,
					perkara_pk.amar_putusan_pk_dok AS amar_putusan_pk_dok,
					perkara_pk.minutasi_pk AS minutasi_pk,
					perkara_pk.pemberitahuan_putusan_pk AS pemberitahuan_putusan_pk,
					perkara_pk.pemberitahuan_putusan_pk_pihak1 AS pemberitahuan_putusan_pk_pihak1,
					perkara_pk.pemberitahuan_putusan_pk_pihak2 AS pemberitahuan_putusan_pk_pihak2,
					perkara_eksekusi.permohonan_eksekusi AS permohonan_eksekusi,
					perkara_eksekusi.pemohon_eksekusi AS pemohon_eksekusi,
					perkara_eksekusi.para_pihak AS para_pihak_eksekusi,
					perkara_eksekusi.penetapan_teguran_eksekusi AS penetapan_teguran_eksekusi,
					perkara_eksekusi.nomor_penetapan_teguran_eksekusi AS nomor_penetapan_teguran_eksekusi,
					perkara_eksekusi.pelaksanaan_teguran_eksekusi AS pelaksanaan_teguran_eksekusi,
					perkara_eksekusi.penetapan_sita_eksekusi AS penetapan_sita_eksekusi,
					perkara_eksekusi.nomor_penetapan_sita_eksekusi AS nomor_penetapan_sita_eksekusi,
					perkara_eksekusi.pelaksanaan_sita_eksekusi AS pelaksanaan_sita_eksekusi,
					perkara_eksekusi.jurusita_id AS jurusita_id_eksekusi,
					perkara_eksekusi.jurusita_nama AS jurusita_nama_eksekusi,
					perkara_eksekusi.penetapan_perintah_eksekusi_lelang AS penetapan_perintah_eksekusi_lelang,
					perkara_eksekusi.pelaksanaan_eksekusi_lelang AS pelaksanaan_eksekusi_lelang,
					perkara_eksekusi.penyerahan_hasil_lelang AS penyerahan_hasil_lelang,
					perkara_eksekusi.penetapan_perintah_eksekusi_rill AS penetapan_perintah_eksekusi_rill,
					perkara_eksekusi.pelaksanaan_eksekusi_rill AS pelaksanaan_eksekusi_rill,
					perkara_eksekusi.penetapan_noneksekusi AS penetapan_noneksekusi,
					perkara.prodeo AS prodeo,
					perkara_banding.prodeo_banding AS prodeo_banding,
					perkara_kasasi.prodeo_kasasi AS prodeo_kasasi,
					perkara_pk.prodeo_pk AS prodeo_pk,
					perkara_eksekusi.prodeo_eksekusi AS prodeo_eksekusi,
					perkara.terdakwa_anak AS terdakwa_anak 
				FROM perkara 
				LEFT JOIN perkara_penetapan ON perkara.perkara_id = perkara_penetapan.perkara_id                         
				LEFT JOIN perkara_mediasi ON perkara.perkara_id = perkara_mediasi.perkara_id
				LEFT JOIN perkara_penuntutan ON perkara.perkara_id = perkara_penuntutan.perkara_id
				LEFT JOIN perkara_putusan_sela ON perkara.perkara_id = perkara_putusan_sela.perkara_id
				LEFT JOIN perkara_putusan ON perkara.perkara_id = perkara_putusan.perkara_id
				LEFT JOIN perkara_verzet ON perkara.perkara_id = perkara_verzet.perkara_id
				LEFT JOIN perkara_banding ON perkara.perkara_id = perkara_banding.perkara_id
				LEFT JOIN perkara_kasasi ON perkara.perkara_id = perkara_kasasi.perkara_id
				LEFT JOIN perkara_pk ON perkara.perkara_id = perkara_pk.perkara_id
				LEFT JOIN perkara_eksekusi ON perkara.perkara_id = perkara_eksekusi.perkara_id;";
		$this->patching->exe_script($sql);

		$sql = "CREATE OR REPLACE VIEW v_perkara_banding
				AS SELECT
					perkara_banding.perkara_id AS perkara_id,
					perkara_banding.alur_perkara_id AS alur_perkara_id,
					perkara_banding.nomor_perkara_pn AS nomor_perkara_pn,
					perkara_banding.putusan_pn AS putusan_pn,
					perkara_banding.pihak_pembanding AS pihak_pembanding,
					perkara_banding.permohonan_banding AS permohonan_banding,
					perkara_banding.pemohon_banding AS pemohon_banding,
					perkara_banding.para_pihak AS para_pihak,
					perkara_banding.pemberitahuan_putusan_pn AS pemberitahuan_putusan_pn,
					perkara_banding.pemberitahuan_permohonan_banding AS pemberitahuan_permohonan_banding,
					perkara_banding.penerimaan_memori_banding AS penerimaan_memori_banding,
					perkara_banding.penyerahan_memori_banding AS penyerahan_memori_banding,
					perkara_banding.penerimaan_kontra_banding AS penerimaan_kontra_banding,
					perkara_banding.penyerahan_kontra_banding AS penyerahan_kontra_banding,
					perkara_banding.pemberitahuan_inzage AS pemberitahuan_inzage,
					perkara_banding.pemberitahuan_inzage_pembanding AS pemberitahuan_inzage_pembanding,
					perkara_banding.pemberitahuan_inzage_terbanding AS pemberitahuan_inzage_terbanding,
					perkara_banding.pelaksanaan_inzage AS pelaksanaan_inzage,
					perkara_banding.pelaksanaan_inzage_pembanding AS pelaksanaan_inzage_pembanding,
					perkara_banding.pelaksanaan_inzage_terbanding AS pelaksanaan_inzage_terbanding,
					perkara_banding.pengiriman_berkas_banding AS pengiriman_berkas_banding,
					perkara_banding.nomor_surat_pengiriman_berkas_banding AS nomor_surat_pengiriman_berkas_banding,
					perkara_banding.penerimaan_kembali_berkas_banding AS penerimaan_kembali_berkas_banding,
					perkara_banding.nomor_perkara_banding AS nomor_perkara_banding,
					perkara_banding.hakim1_banding AS hakim1_banding,
					perkara_banding.hakim2_banding AS hakim2_banding,
					perkara_banding.hakim3_banding AS hakim3_banding,
					perkara_banding.hakim4_banding AS hakim4_banding,
					perkara_banding.hakim5_banding AS hakim5_banding,
					perkara_banding.majelis_hakim_banding AS majelis_hakim_banding,
					perkara_banding.panitera_pengganti_banding AS panitera_pengganti_banding,
					perkara_banding.putusan_banding AS putusan_banding,
					perkara_banding.minutasi_banding AS minutasi_banding,
					perkara_banding.status_putusan_banding_id AS status_putusan_banding_id,
					perkara_banding.status_putusan_banding_text AS status_putusan_banding_text,
					perkara_banding.nomor_putusan_banding AS nomor_putusan_banding,
					perkara_banding.amar_putusan_banding AS amar_putusan_banding,
					perkara_banding.amar_putusan_banding_dok AS amar_putusan_banding_dok,
					perkara_banding.pemberitahuan_putusan_banding AS pemberitahuan_putusan_banding,
					perkara_banding.pemberitahuan_putusan_banding_pembanding AS pemberitahuan_putusan_banding_pembanding,
					perkara_banding.pemberitahuan_putusan_banding_terbanding AS pemberitahuan_putusan_banding_terbanding,
					perkara_banding.catatan_banding AS catatan_banding,
					perkara_banding.prodeo_banding AS prodeo_banding,
					perkara_banding.status_banding_id AS status_banding_id,
					perkara_banding.status_banding_text AS status_banding_text,
					perkara_banding.diedit_oleh AS diedit_oleh,
					perkara_banding.diedit_tanggal AS diedit_tanggal,
					perkara_banding.diinput_oleh AS diinput_oleh,
					perkara_banding.diinput_tanggal AS diinput_tanggal,
					perkara_banding.diperbaharui_oleh AS diperbaharui_oleh,
					perkara_banding.diperbaharui_tanggal AS diperbaharui_tanggal,
					perkara.nomor_indeks AS nomor_indeks,
					perkara.tahapan_terakhir_id AS tahapan_terakhir_id,
					perkara.proses_terakhir_id AS proses_terakhir_id,
					perkara.terdakwa_anak AS terdakwa_anak,
					perkara.prodeo AS prodeo,
					perkara.tanggal_pendaftaran AS tanggal_pendaftaran
				FROM (perkara_banding left join perkara on((perkara_banding.perkara_id = perkara.perkara_id)));";
		$this->patching->exe_script($sql);

		$sql = "CREATE OR REPLACE VIEW v_perkara_kasasi
				AS SELECT
				perkara_kasasi.perkara_id AS perkara_id,
				perkara_kasasi.alur_perkara_id AS alur_perkara_id,
				perkara_kasasi.nomor_perkara_pn AS nomor_perkara_pn,
				perkara_kasasi.putusan_pn AS putusan_pn,
				perkara_kasasi.pihak_pemohon_kasasi AS pihak_pemohon_kasasi,
				perkara_kasasi.permohonan_kasasi AS permohonan_kasasi,
				perkara_kasasi.pemohon_kasasi AS pemohon_kasasi,
				perkara_kasasi.para_pihak AS para_pihak,
				perkara_kasasi.pemberitahuan_putusan_pn AS pemberitahuan_putusan_pn,
				perkara_kasasi.nomor_perkara_banding AS nomor_perkara_banding,
				perkara_kasasi.putusan_banding AS putusan_banding,
				perkara_kasasi.pemberitahuan_putusan_banding AS pemberitahuan_putusan_banding,
				perkara_kasasi.pemberitahuan_kasasi AS pemberitahuan_kasasi,
				perkara_kasasi.penerimaan_memori_kasasi AS penerimaan_memori_kasasi,
				perkara_kasasi.penyerahan_memori_kasasi AS penyerahan_memori_kasasi,
				perkara_kasasi.penerimaan_kontra_kasasi AS penerimaan_kontra_kasasi,
				perkara_kasasi.penyerahan_kontra_kasasi AS penyerahan_kontra_kasasi,
				perkara_kasasi.pemberitahuan_inzage_kasasi AS pemberitahuan_inzage_kasasi,
				perkara_kasasi.pemberitahuan_inzage_pemohon_kasasi AS pemberitahuan_inzage_pemohon_kasasi,
				perkara_kasasi.pemberitahuan_inzage_termohon_kasasi AS pemberitahuan_inzage_termohon_kasasi,
				perkara_kasasi.pelaksanaan_inzage_kasasi AS pelaksanaan_inzage_kasasi,
				perkara_kasasi.pelaksanaan_inzage_pemohon_kasasi AS pelaksanaan_inzage_pemohon_kasasi,
				perkara_kasasi.pelaksanaan_inzage_termohon_kasasi AS pelaksanaan_inzage_termohon_kasasi,
				perkara_kasasi.pengiriman_berkas_kasasi AS pengiriman_berkas_kasasi,
				perkara_kasasi.nomor_surat_pengiriman_berkas_kasasi AS nomor_surat_pengiriman_berkas_kasasi,
				perkara_kasasi.penerimaan_berkas_kasasi AS penerimaan_berkas_kasasi,
				perkara_kasasi.nomor_perkara_kasasi AS nomor_perkara_kasasi,
				perkara_kasasi.hakim1_kasasi AS hakim1_kasasi,
				perkara_kasasi.hakim2_kasasi AS hakim2_kasasi,
				perkara_kasasi.hakim3_kasasi AS hakim3_kasasi,
				perkara_kasasi.hakim4_kasasi AS hakim4_kasasi,
				perkara_kasasi.hakim5_kasasi AS hakim5_kasasi,
				perkara_kasasi.majelis_hakim_kasasi AS majelis_hakim_kasasi,
				perkara_kasasi.panitera_pengganti_kasasi AS panitera_pengganti_kasasi,
				perkara_kasasi.putusan_kasasi AS putusan_kasasi,
				perkara_kasasi.status_putusan_kasasi_id AS status_putusan_kasasi_id,
				perkara_kasasi.status_putusan_kasasi_text AS status_putusan_kasasi_text,
				perkara_kasasi.nomor_putusan_kasasi AS nomor_putusan_kasasi,
				perkara_kasasi.amar_putusan_kasasi AS amar_putusan_kasasi,
				perkara_kasasi.amar_putusan_kasasi_dok AS amar_putusan_kasasi_dok,
				perkara_kasasi.minutasi_kasasi AS minutasi_kasasi,
				perkara_kasasi.pemberitahuan_putusan_kasasi AS pemberitahuan_putusan_kasasi,
				perkara_kasasi.pemberitahuan_putusan_kasasi_pihak1 AS pemberitahuan_putusan_kasasi_pihak1,
				perkara_kasasi.pemberitahuan_putusan_kasasi_pihak2 AS pemberitahuan_putusan_kasasi_pihak2,
				perkara_kasasi.tanggal_berita_putusan_kasasi AS tanggal_berita_putusan_kasasi,
				perkara_kasasi.nama_media_berita_putusan_kasasi AS nama_media_berita_putusan_kasasi,
				perkara_kasasi.tanggal_surat_kabar_putusan_kasasi AS tanggal_surat_kabar_putusan_kasasi,
				perkara_kasasi.nama_surat_kabar_putusan_kasasi AS nama_surat_kabar_putusan_kasasi,
				perkara_kasasi.catatan_putusan_kasasi AS catatan_putusan_kasasi,
				perkara_kasasi.prodeo_kasasi AS prodeo_kasasi,
				perkara_kasasi.status_kasasi_id AS status_kasasi_id,
				perkara_kasasi.status_kasasi_text AS status_kasasi_text,
				perkara_kasasi.diedit_oleh AS diedit_oleh,
				perkara_kasasi.diedit_tanggal AS diedit_tanggal,
				perkara_kasasi.diinput_oleh AS diinput_oleh,
				perkara_kasasi.diinput_tanggal AS diinput_tanggal,
				perkara_kasasi.diperbaharui_oleh AS diperbaharui_oleh,
				perkara_kasasi.diperbaharui_tanggal AS diperbaharui_tanggal,
				perkara.nomor_indeks AS nomor_indeks,
				perkara.tahapan_terakhir_id AS tahapan_terakhir_id,
				perkara.proses_terakhir_id AS proses_terakhir_id,
				perkara.prodeo AS prodeo,
				perkara.terdakwa_anak AS terdakwa_anak,
				perkara.tanggal_pendaftaran AS tanggal_pendaftaran
				FROM (perkara_kasasi LEFT JOIN perkara ON((perkara_kasasi.perkara_id = perkara.perkara_id)));";
		$this->patching->exe_script($sql);

		$sql = "CREATE OR REPLACE VIEW v_perkara_pk
			AS SELECT
				perkara_pk.perkara_id AS perkara_id,
				perkara_pk.alur_perkara_id AS alur_perkara_id,
				perkara_pk.nomor_perkara_pn AS nomor_perkara_pn,
				perkara_pk.putusan_pn AS putusan_pn,
				perkara_pk.pihak_pemohon_pk AS pihak_pemohon_pk,
				perkara_pk.permohonan_pk AS permohonan_pk,
				perkara_pk.pemohon_pk AS pemohon_pk,
				perkara_pk.para_pihak AS para_pihak,
				perkara_pk.alasan_pk AS alasan_pk,
				perkara_pk.pemberitahuan_putusan_pn AS pemberitahuan_putusan_pn,
				perkara_pk.nomor_perkara_banding AS nomor_perkara_banding,
				perkara_pk.putusan_banding AS putusan_banding,
				perkara_pk.pemberitahuan_putusan_banding AS pemberitahuan_putusan_banding,
				perkara_pk.nomor_perkara_kasasi AS nomor_perkara_kasasi,
				perkara_pk.putusan_kasasi AS putusan_kasasi,
				perkara_pk.pemberitahuan_putusan_kasasi AS pemberitahuan_putusan_kasasi,
				perkara_pk.pemberitahuan_pk AS pemberitahuan_pk,
				perkara_pk.penerimaan_memori_pk AS penerimaan_memori_pk,
				perkara_pk.penyerahan_memori_pk AS penyerahan_memori_pk,
				perkara_pk.penerimaan_kontra_pk AS penerimaan_kontra_pk,
				perkara_pk.penyerahan_kontra_pk AS penyerahan_kontra_pk,
				perkara_pk.tanggal_penyumpahan AS tanggal_penyumpahan,
				perkara_pk.pemberitahuan_inzage_pk AS pemberitahuan_inzage_pk,
				perkara_pk.pemberitahuan_inzage_pemohon_pk AS pemberitahuan_inzage_pemohon_pk,
				perkara_pk.pemberitahuan_inzage_termohon_pk AS pemberitahuan_inzage_termohon_pk,
				perkara_pk.pelaksanaan_inzage_pk AS pelaksanaan_inzage_pk,
				perkara_pk.pelaksanaan_inzage_pemohon_pk AS pelaksanaan_inzage_pemohon_pk,
				perkara_pk.pelaksanaan_inzage_termohon_pk AS pelaksanaan_inzage_termohon_pk,
				perkara_pk.pengiriman_berkas_pk AS pengiriman_berkas_pk,
				perkara_pk.nomor_surat_pengiriman_berkas_pk AS nomor_surat_pengiriman_berkas_pk,
				perkara_pk.penerimaan_berkas_pk AS penerimaan_berkas_pk,
				perkara_pk.nomor_perkara_pk AS nomor_perkara_pk,
				perkara_pk.hakim1_pk AS hakim1_pk,
				perkara_pk.hakim2_pk AS hakim2_pk,
				perkara_pk.hakim3_pk AS hakim3_pk,
				perkara_pk.hakim4_pk AS hakim4_pk,
				perkara_pk.hakim5_pk AS hakim5_pk,
				perkara_pk.majelis_hakim_pk AS majelis_hakim_pk,
				perkara_pk.panitera_pengganti_pk AS panitera_pengganti_pk,
				perkara_pk.putusan_pk AS putusan_pk,
				perkara_pk.status_putusan_pk_id AS status_putusan_pk_id,
				perkara_pk.status_putusan_pk_text AS status_putusan_pk_text,
				perkara_pk.nomor_putusan_pk AS nomor_putusan_pk,
				perkara_pk.amar_putusan_pk AS amar_putusan_pk,
				perkara_pk.amar_putusan_pk_dok AS amar_putusan_pk_dok,
				perkara_pk.minutasi_pk AS minutasi_pk,
				perkara_pk.pemberitahuan_putusan_pk AS pemberitahuan_putusan_pk,
				perkara_pk.pemberitahuan_putusan_pk_pihak1 AS pemberitahuan_putusan_pk_pihak1,
				perkara_pk.pemberitahuan_putusan_pk_pihak2 AS pemberitahuan_putusan_pk_pihak2,
				perkara_pk.catatan_putusan_pk AS catatan_putusan_pk,
				perkara_pk.prodeo_pk AS prodeo_pk,
				perkara_pk.status_pk_id AS status_pk_id,
				perkara_pk.status_pk_text AS status_pk_text,
				perkara_pk.diedit_oleh AS diedit_oleh,
				perkara_pk.diedit_tanggal AS diedit_tanggal,
				perkara_pk.diinput_oleh AS diinput_oleh,
				perkara_pk.diinput_tanggal AS diinput_tanggal,
				perkara_pk.diperbaharui_oleh AS diperbaharui_oleh,
				perkara_pk.diperbaharui_tanggal AS diperbaharui_tanggal,
				perkara.nomor_indeks AS nomor_indeks,
				perkara.tahapan_terakhir_id AS tahapan_terakhir_id,
				perkara.proses_terakhir_id AS proses_terakhir_id,
				perkara.tanggal_pendaftaran AS tanggal_pendaftaran
			FROM (perkara_pk left join perkara on((perkara_pk.perkara_id = perkara.perkara_id)));";
		$this->patching->exe_script($sql);

		$sql = "CREATE OR REPLACE VIEW v_perkara_eksekusi
				AS SELECT
				perkara_eksekusi.perkara_id                         		AS perkara_id,
				perkara_eksekusi.alur_perkara_id                    		AS alur_perkara_id,
				perkara_eksekusi.nomor_perkara_pn                   		AS nomor_perkara_pn,
				perkara.nomor_indeks                                		AS nomor_indeks,
				perkara_eksekusi.putusan_pn                         		AS putusan_pn,
				perkara_eksekusi.nomor_perkara_banding              		AS nomor_perkara_banding,
				perkara_eksekusi.putusan_banding                    		AS putusan_banding,
				perkara_eksekusi.nomor_perkara_kasasi               		AS nomor_perkara_kasasi,
				perkara_eksekusi.putusan_kasasi                     		AS putusan_kasasi,
				perkara_eksekusi.nomor_perkara_pk                   		AS nomor_perkara_pk,
				perkara_eksekusi.putusan_pk                         		AS putusan_pk,
				perkara_eksekusi.eksekusi_putusan                   		AS eksekusi_putusan,
				perkara_eksekusi.eksekusi_nomor_perkara             		AS eksekusi_nomor_perkara,
				perkara_eksekusi.nomor_urut_perkara_eksekusi 				AS nomor_urut_perkara_eksekusi,
				perkara_eksekusi.nomor_register_eksekusi 					AS nomor_register_eksekusi,							
				perkara_eksekusi.eksekusi_amar_putusan              		AS eksekusi_amar_putusan,
				perkara_eksekusi.pihak_pemohon_eksekusi             		AS pihak_pemohon_eksekusi,
				perkara_eksekusi.permohonan_eksekusi                		AS permohonan_eksekusi,
				perkara_eksekusi.pemohon_eksekusi                   		AS pemohon_eksekusi,
				perkara_eksekusi.para_pihak                         		AS para_pihak,
				perkara_eksekusi.penetapan_teguran_eksekusi         		AS penetapan_teguran_eksekusi,
				perkara_eksekusi.nomor_penetapan_teguran_eksekusi   		AS nomor_penetapan_teguran_eksekusi,
				perkara_eksekusi.pelaksanaan_teguran_eksekusi       		AS pelaksanaan_teguran_eksekusi,
				perkara_eksekusi.penetapan_sita_eksekusi            		AS penetapan_sita_eksekusi,
				perkara_eksekusi.nomor_penetapan_sita_eksekusi      		AS nomor_penetapan_sita_eksekusi,
				perkara_eksekusi.pelaksanaan_sita_eksekusi          		AS pelaksanaan_sita_eksekusi,
				perkara_eksekusi.jurusita_id                        		AS jurusita_id,
				perkara_eksekusi.jurusita_nama                      		AS jurusita_nama,
				perkara_eksekusi.penetapan_perintah_eksekusi_lelang 		AS penetapan_perintah_eksekusi_lelang,
				perkara_eksekusi.pelaksanaan_eksekusi_lelang        		AS pelaksanaan_eksekusi_lelang,
				perkara_eksekusi.penyerahan_hasil_lelang            		AS penyerahan_hasil_lelang,
				perkara_eksekusi.penetapan_perintah_eksekusi_rill   		AS penetapan_perintah_eksekusi_rill,
				perkara_eksekusi.pelaksanaan_eksekusi_rill          		AS pelaksanaan_eksekusi_rill,
				perkara_eksekusi.penetapan_noneksekusi              		AS penetapan_noneksekusi,
				perkara_eksekusi.diterima_permohonan				            AS diterima_permohonan,
				perkara_eksekusi.panggilan_parapihak				            AS panggilan_parapihak,
				perkara_eksekusi.penetapan_ketua						            AS penetapan_ketua,
				perkara_eksekusi.sk_objek_tidak_punya_kekuatan_hukum		AS sk_objek_tidak_punya_kekuatan_hukum,
				perkara_eksekusi.surat_tergugat_objek_non_executable		AS surat_tergugat_objek_non_executable,
				perkara_eksekusi.panggilan_pihak_non_executable			    AS panggilan_pihak_non_executable,
				perkara_eksekusi.upaya_kesepakatan_kompensasi			      AS upaya_kesepakatan_kompensasi,
				perkara_eksekusi.penetapan_ketua_kompensasi			        AS penetapan_ketua_kompensasi,
				perkara_eksekusi.upaya_hukum_kma						            AS upaya_hukum_kma,
				perkara_eksekusi.penetapan_kma_kompensasi			          AS penetapan_kma_kompensasi,
				perkara_eksekusi.uangpaksa_putusan_hakim				        AS uangpaksa_putusan_hakim,
				perkara_eksekusi.uangpaksa_penetapan_ketua				      AS uangpaksa_penetapan_ketua,
				perkara_eksekusi.surat_ketua_tergugat_uangpaksa			    AS surat_ketua_tergugat_uangpaksa,
				perkara_eksekusi.surat_peringatan_uangpaksa			        AS surat_peringatan_uangpaksa,
				perkara_eksekusi.perintah_ketua_saksi_administratif			AS perintah_ketua_saksi_administratif,
				perkara_eksekusi.sanksi_administratif_dari_pejabat			AS sanksi_administratif_dari_pejabat,
				perkara_eksekusi.pengumuman_ketua_panitera_js			      AS pengumuman_ketua_panitera_js,
				perkara_eksekusi.pengumuman_media					              AS pengumuman_media,
				perkara_eksekusi.surat_presiden							            AS surat_presiden,
				perkara_eksekusi.surat_lembaga_perwakilan_rakyat			  AS surat_lembaga_perwakilan_rakyat,
			  perkara_eksekusi.alasan_eksekusi                    		AS alasan_eksekusi,
				perkara_eksekusi.catatan_eksekusi                   		AS catatan_eksekusi,
				perkara_eksekusi.prodeo_eksekusi                    		AS prodeo_eksekusi,
				perkara_eksekusi.status_eksekusi_id                 		AS status_eksekusi_id,
				perkara_eksekusi.status_eksekusi_text               		AS status_eksekusi_text,
				perkara_eksekusi.diedit_oleh                        		AS diedit_oleh,
				perkara_eksekusi.diedit_tanggal                     		AS diedit_tanggal,
				perkara_eksekusi.diinput_oleh                       		AS diinput_oleh,
				perkara_eksekusi.diinput_tanggal                    		AS diinput_tanggal,
				perkara_eksekusi.diperbaharui_oleh                  		AS diperbaharui_oleh,
				perkara_eksekusi.diperbaharui_tanggal               		AS diperbaharui_tanggal,
				perkara.prodeo                                      		AS prodeo,
				perkara.terdakwa_anak                               		AS terdakwa_anak,
				perkara.tanggal_pendaftaran                         		AS tanggal_pendaftaran
			FROM perkara_eksekusi
			   LEFT JOIN perkara
			     ON perkara_eksekusi.perkara_id = perkara.perkara_id;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS status_perkawinan;";
		$this->patching->exe_script($sql);

		$sql = "CREATE TABLE status_perkawinan(  
					id TINYINT NOT NULL AUTO_INCREMENT,
					nama VARCHAR(50),
					diinput_oleh VARCHAR(30) DEFAULT NULL,
					diinput_tanggal DATETIME DEFAULT NULL,
					diperbaharui_oleh VARCHAR(30) DEFAULT NULL,
					diperbaharui_tanggal DATETIME DEFAULT NULL,
					PRIMARY KEY (id)
				) ENGINE=MyISAM;";
		$this->patching->exe_script($sql);

		$sql = "REPLACE INTO status_perkawinan(id,nama,diinput_oleh,diinput_tanggal) 
				VALUES(1,'Kawin','System','2015-04-24 10:04:26')
				,(2,'Belum Kawin','System','2015-04-24 10:04:26')
				,(3,'Duda','System','2015-04-24 10:04:26')
				,(4,'Janda','System','2015-04-24 10:04:26');";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS jenis_identitas;";
		$this->patching->exe_script($sql);

		$sql = "CREATE TABLE jenis_identitas (
					id TINYINT(4) NOT NULL AUTO_INCREMENT,
					nama VARCHAR(50) DEFAULT NULL,
					diinput_oleh VARCHAR(30) DEFAULT NULL,
					diinput_tanggal DATETIME DEFAULT NULL,
					diperbaharui_oleh VARCHAR(30) DEFAULT NULL,
					diperbaharui_tanggal DATETIME DEFAULT NULL,
					PRIMARY KEY (id)
					) ENGINE=MyISAM;";
		$this->patching->exe_script($sql);

		$sql = "REPLACE INTO jenis_identitas(id,nama,diinput_oleh,diinput_tanggal) 
				VALUES(1,'Kartu BPJS','System','2015-04-24 10:04:26')
				,(2,'Kartu Keluarga','System','2015-04-24 10:04:26')
				,(3,'Kartu Pelajar','System','2015-04-24 10:04:26')
				,(4,'KTP','System','2015-04-24 10:04:26')
				,(5,'Paspor','System','2015-04-24 10:04:26')
				,(6,'SIM','System','2015-04-24 10:04:26');";
		$this->patching->exe_script($sql);

		$sql = "UPDATE alur_perkara SET kode = 'Pid.Sus-PRK' WHERE id = 116;";
		$this->patching->exe_script($sql);

		$sql = "UPDATE alur_perkara SET kode = 'Pid.Sus-TPK' WHERE id = 115;";
		$this->patching->exe_script($sql);

		$sql = "UPDATE alur_perkara SET kode = 'Pid.Sus-HAM' WHERE id = 117;";
		$this->patching->exe_script($sql);

		$sql = "UPDATE alur_perkara SET kode = 'Pdt.G' WHERE id = 1;";
		$this->patching->exe_script($sql);

		$sql = "UPDATE alur_perkara SET kode = 'Pdt.P' WHERE id = 2;";
		$this->patching->exe_script($sql);

		$sql = "UPDATE alur_perkara SET kode = 'Pdt.Sus-Pailit' WHERE id = 3;";
		$this->patching->exe_script($sql);

		$sql = "UPDATE alur_perkara SET kode = 'Pdt.Sus-PKPU' WHERE id = 4;";
		$this->patching->exe_script($sql);

		$sql = "UPDATE alur_perkara SET kode = 'Pdt.Sus-HKI' WHERE id = 5;";
		$this->patching->exe_script($sql);

		$sql = "UPDATE alur_perkara SET kode = 'Pdt.Sus-PHI' WHERE id = 6;";
		$this->patching->exe_script($sql);

		$sql = "UPDATE alur_perkara SET kode = 'Pid.B' WHERE id = 111;";
		$this->patching->exe_script($sql);

		$sql = "UPDATE alur_perkara SET kode = 'Pid.S' WHERE id = 112;";
		$this->patching->exe_script($sql);

		$sql = "UPDATE alur_perkara SET kode = 'Pid.C' WHERE id = 113;";
		$this->patching->exe_script($sql);

		$sql = "UPDATE alur_perkara SET kode = 'Pid.LL' WHERE id = 114;";
		$this->patching->exe_script($sql);

		$sql = "REPLACE INTO jenis_biaya (tahapan_id, jenis_transaksi, kategori_id, kode, nama, jumlah, keterangan, aktif, diedit_oleh, diedit_tanggal, diinput_oleh, diinput_tanggal, diperbaharui_oleh, diperbaharui_tanggal) 
				VALUES(99,-1,13,'HHK 1','Upah Tulis','0.00','Biaya Upah Tulis','T',NULL,NULL,'system','2012-04-23 10:47:04',NULL,NULL)
				,(99,-1,13,'HHK 2','Pencatatan pembuatan akta atau berita acara penyumpahan atau dari putusan-putusan lainnya ','0.00','Pencatatan pembuatan akta atau berita acara penyumpahan atau dari putusan-putusan lainnya yang bukan sebagai akibat keputusan Pengadilan  (PP No. 53 Tahun 2008 E.10)','Y',NULL,NULL,'system','2012-04-23 10:49:23','system','2012-11-15 23:53:01')
				,(99,-1,13,'HHK 3','Memperlihatkan surat kepada yang berkepentingan mengenai surat-surat yang tersimpan di kepaniteraan ','0.00','Memperlihatkan surat kepada yang berkepentingan mengenai surat-surat yang tersimpan di kepaniteraan (PP No. 53 Tahun 2008 E.3)','Y',NULL,NULL,'admin','2013-02-13 18:11:07',NULL,NULL)
				,(99,-1,13,'HHK 4','Penyitaan/eksekusi barang yang bergerak atau yang tidak bergerak dan untuk pencatatan pencabutan','0.00','Penyitaan/eksekusi barang yang bergerak atau yang tidak bergerak dan untuk pencatatan pencabutan suatu penyitaan di dalam berita acara turunan  (PP No. 53 Tahun 2008 E.6)','Y',NULL,NULL,'admin','2013-02-13 18:12:54',NULL,NULL)
				,(99,-1,13,'HHK 9','Pengesahan Surat dibawah tangan (PP No. 53 Tahun 2008 E.16)','0.00','Pengesahan Surat dibawah tangan (PP No. 53 Tahun 2008 E.16)','Y',NULL,NULL,'admin','2013-02-13 18:16:55',NULL,NULL)
				,(99,-1,13,'HHK 5','Melakukan penjualan dimuka umum/lelang atas perintah pengadilan (PP No. 53 Tahun 2008 E.7)','0.00','Melakukan penjualan dimuka umum/lelang atas perintah pengadilan (PP No. 53 Tahun 2008 E.7)','Y',NULL,NULL,'admin','2013-02-13 18:41:54',NULL,NULL)
				,(99,-1,13,'HHK 6','Penyerahan akta di Kepaniteraan yang dilakukan di dalam hal yang diharuskan menurut hukum','0.00','Penyerahan akta di Kepaniteraan yang dilakukan di dalam hal yang diharuskan menurut hukum (PP No. 53 Tahun 2008 E.11.1)','Y',NULL,NULL,'admin','2013-02-13 18:48:09',NULL,NULL)
				,(99,-1,13,'HHK 7','Penyerahan surat dari berkas perkara (PP No. 53 Tahun 2008 E.11.3)','0.00','Penyerahan surat dari berkas perkara (PP No. 53 Tahun 2008 E.11.3)','Y',NULL,NULL,'admin','2013-02-13 18:56:29',NULL,NULL)
				,(99,-1,13,'HHK 8','Akta asli yang dibuat di Kepaniteraan, dikecualikan penyimpanan akta catatan sipil','0.00','Akta asli yang dibuat di Kepaniteraan, dikecualikan penyimpanan akta catatan sipil dan pemasukan atau pemindahan sesuatu akta tersebut begitu pula dari segala keterangan-keterangan tertulis yang dikeluarkan oleh Panitera dalam hal yang diharuskan menurut ','Y',NULL,NULL,'admin','2013-02-13 18:57:19',NULL,NULL)
				,(99,-1,13,'HHK 12','Legalisasi dari satu atau lebih tanda tangan di dalam akta termasuk akta catatan sipil','0.00','Legalisasi dari satu atau lebih tanda tangan di dalam akta termasuk akta catatan sipil, dengan tidak mengurangi yang telah ditetapkan dalam ord. S.1916 No. 46 (PP No. 53 Tahun 2008 E.13)','Y',NULL,NULL,'admin','2013-02-13 18:58:05',NULL,NULL)
				,(99,-1,13,'HHK 10','Pendaftaran surat kuasa untuk mewakili pihak yang berperkara di Pengadilan','0.00','Pendaftaran surat kuasa untuk mewakili pihak yang berperkara di Pengadilan (PP No. 53 Tahun 2008 E.14)','Y',NULL,NULL,'admin','2013-02-13 18:58:54',NULL,NULL)
				,(99,-1,13,'HHK 11','Pembuatan surat kuasa insidentil  (PP No. 53 Tahun 2008 E.15)','0.00','Pembuatan surat kuasa insidentil  (PP No. 53 Tahun 2008 E.15)','Y',NULL,NULL,'admin','2013-02-13 18:59:35',NULL,NULL)
				,(99,-1,13,'HHK 1','Penyerahan Turunan / Salinan / Putusan Penetapan Pengadilan (PP No. 53 Tahun 2008 E.1)','0.00','Penyerahan Turunan / Salinan / Putusan Penetapan Pengadilan (PP No. 53 Tahun 2008 E.1)','Y',NULL,NULL,'angga','2013-03-25 11:42:19',NULL,NULL);";
		$this->patching->exe_script($sql);

		$isThere = $this->patching->isColumnExist('perkara_kasasi_detil','tanggal_cabut');
		if(empty($isThere)){
				$sql = "ALTER TABLE perkara_kasasi_detil ADD COLUMN tanggal_cabut DATE NULL AFTER pemberitahuan_putusan_kasasi;";
				$this->patching->exe_script($sql);
		}
		
		$isThere = $this->patching->isColumnExist('perkara_kasasi_detil','catatan_putusan_kasasi');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_kasasi_detil ADD COLUMN catatan_putusan_kasasi TEXT NULL AFTER tanggal_cabut;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_putusan','nilai_ganti_kerugian');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_putusan ADD COLUMN nilai_ganti_kerugian BIGINT NULL AFTER catatan_putusan;";
			$this->patching->exe_script($sql);
		}
		
		$isThere = $this->patching->isColumnExist('perkara_kasasi_detil','urutan_kasasi');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_kasasi_detil ADD COLUMN urutan_kasasi TINYINT(4) NULL AFTER status_pihak_text;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_kasasi_detil','tidak_memenuhi_syarat');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_kasasi_detil ADD COLUMN tidak_memenuhi_syarat DATE NULL AFTER tanggal_cabut;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_kasasi','tanggal_cabut');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_kasasi ADD COLUMN tanggal_cabut DATE NULL AFTER status_kasasi_text;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_pk_detil','urutan_pk');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_pk_detil ADD COLUMN urutan_pk TINYINT(4) NULL AFTER status_pihak_text;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_kasasi','tidak_memenuhi_syarat');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_kasasi ADD COLUMN tidak_memenuhi_syarat DATE NULL AFTER tanggal_cabut;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_banding_detil','tanggal_cabut');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_banding_detil ADD COLUMN tanggal_cabut DATE NULL AFTER pemberitahuan_putusan_banding;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_banding','tanggal_cabut');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_banding ADD COLUMN tanggal_cabut DATE NULL AFTER status_banding_text;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_pk_detil','tanggal_cabut');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_pk_detil ADD COLUMN tanggal_cabut DATE NULL AFTER pemberitahuan_putusan_pk;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_pk_detil','catatan_putusan_pk');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_pk_detil ADD COLUMN catatan_putusan_pk TEXT NULL AFTER tanggal_cabut;";
			$this->patching->exe_script($sql);
		}
		$isThere = $this->patching->isColumnExist('perkara_pk_detil','keterangan');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_pk_detil ADD COLUMN keterangan TEXT NULL AFTER catatan_putusan_pk;";
			$this->patching->exe_script($sql);
		}
		$isThere = $this->patching->isColumnExist('perkara_pk','tanggal_cabut');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_pk ADD COLUMN tanggal_cabut DATE NULL AFTER status_pk_text;";
			$this->patching->exe_script($sql);
		}

		$sql = "DROP PROCEDURE IF EXISTS perkara_proses_delete;";
		$this->patching->exe_script($sql);

		$sql = "CREATE PROCEDURE perkara_proses_delete(IN var_per_id BIGINT,IN var_proses_id INTEGER(11)) 
				BEGIN
					DELETE FROM perkara_proses WHERE perkara_id= var_per_id AND proses_id>=var_proses_id;
				END";
		$this->patching->exe_script($sql);

		$sql = "DROP PROCEDURE IF EXISTS perkara_Delete;";
		$this->patching->exe_script($sql);

		$sql = "CREATE PROCEDURE perkara_Delete(IN var_id BIGINT)
				BEGIN
					DELETE FROM perkara_penetapan WHERE perkara_id=var_id;
					DELETE FROM perkara_jadwal_sidang WHERE perkara_id=var_id;
					DELETE FROM perkara_putusan WHERE perkara_id=var_id;
					DELETE FROM perkara_putusan_sela WHERE perkara_id=var_id;
					DELETE FROM perkara_putusan_terdakwa WHERE perkara_id=var_id;
					DELETE FROM perkara_putusan_pemberitahuan_putusan WHERE perkara_id=var_id;
					DELETE FROM perkara_verzet WHERE perkara_id=var_id;
					DELETE FROM perkara_banding WHERE perkara_id=var_id;
					DELETE FROM perkara_kasasi WHERE perkara_id=var_id;
					DELETE FROM perkara_pk WHERE perkara_id=var_id;
					DELETE FROM perkara_eksekusi WHERE perkara_id=var_id;
					DELETE FROM perkara_grasi WHERE perkara_id=var_id;
					DELETE FROM perkara_pihak1 WHERE perkara_id=var_id;
					DELETE FROM perkara_pihak2 WHERE perkara_id=var_id;
					DELETE FROM perkara_pihak3 WHERE perkara_id=var_id;
					DELETE FROM perkara_pihak4 WHERE perkara_id=var_id;
					DELETE FROM perkara_pihak_korban WHERE perkara_id=var_id;
					DELETE FROM perkara_pihak_penyidik WHERE perkara_id=var_id;
					DELETE FROM perkara_pihak_pembimbing_masyarakat WHERE perkara_id=var_id;
					DELETE FROM perkara_pihak_orang_tua WHERE perkara_id=var_id;
					DELETE FROM perkara_diversi WHERE perkara_id=var_id;
					DELETE FROM perkara_keberatan WHERE perkara_id=var_id;
					DELETE FROM perkara_penyitaan WHERE perkara_id=var_id;
					DELETE FROM perkara_penyegelan WHERE perkara_id=var_id;
					DELETE FROM perkara_penuntutan WHERE perkara_id=var_id;
					DELETE FROM perkara_pengacara WHERE perkara_id=var_id;
					DELETE FROM perkara_hakim_pn WHERE perkara_id=var_id;
					DELETE FROM perkara_hakim_banding WHERE perkara_id=var_id;
					DELETE FROM perkara_hakim_kasasi WHERE perkara_id=var_id;
					DELETE FROM perkara_hakim_pk WHERE perkara_id=var_id;
					DELETE FROM perkara_panitera_pn WHERE perkara_id=var_id;
					DELETE FROM perkara_panitera_banding WHERE perkara_id=var_id;
					DELETE FROM perkara_panitera_kasasi WHERE perkara_id=var_id;
					DELETE FROM perkara_panitera_pk WHERE perkara_id=var_id;
					DELETE FROM perkara_jurusita WHERE perkara_id=var_id;
					DELETE FROM perkara_mediator WHERE perkara_id=var_id;
					DELETE FROM perkara_mediasi WHERE perkara_id=var_id;
					DELETE FROM perkara_jadwal_sidang WHERE perkara_id=var_id;
					DELETE FROM perkara_biaya WHERE perkara_id=var_id;
					DELETE FROM perkara_proses WHERE perkara_id=var_id;
					DELETE FROM perkara WHERE perkara_id=var_id;
					DELETE FROM perkara_barang_bukti WHERE perkara_id=var_id;
					DELETE FROM perkara_harta_pailit WHERE perkara_id=var_id;
					DELETE FROM perkara_actio_pauliana WHERE perkara_id=var_id;
					DELETE FROM perkara_lalulintas WHERE perkara_id=var_id;
					DELETE FROM perkara_rehabilitasi WHERE perkara_id=var_id;
					DELETE FROM perkara_penyegelan WHERE perkara_id=var_id;
					DELETE FROM perkara_penyitaan WHERE perkara_id=var_id;
				END";
		$this->patching->exe_script($sql);
		
		$sql = "REPLACE INTO proses_alur_perkara 
				(alur_perkara_id, tahapan_id, tahapan_nama, proses_id, proses_nama, batas_waktu, 
				satuan, dari_proses_id, nama_tabel_dari, nama_kolom_dari, nama_tabel_ke, 
				nama_kolom_ke, aktif, reminder) VALUES
				(8,17,'Keberatan','281','Pendaftaran Keberatan','14','8','230','perkara_putusan','pemberitahuan_putusan','perkara_verzet','tanggal_pendaftaran_verzet','Y','0')
				,(8,17,'Keberatan','285','Penetapan Jadwal Sidang  Keberatan',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','tanggal_penetapan_sidang_verzet','Y','0')
				,(8,17,'Keberatan','286','Sidang Pertama Keberatan',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','tanggal_sidang_pertama_verzet','Y','0')
				,(8,17,'Keberatan','288','Putusan Keberatan',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','putusan_verzet','Y','0')
				,(8,17,'Keberatan','289','Pemberitahuan Putusan Keberatan',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','pemberitahuan_putusan_verzet','Y','0')
				,(8,10,'Pendaftaran','10','Pendaftaran Perkara',NULL,NULL,'0',NULL,'tanggal_pendaftaran','perkara','tanggal_pendaftaran','Y','0')
				,(8,12,'Penetapan','20','Penetapan Majelis Hakim/Hakim','3','8','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','8')
				,(8,12,'Penetapan','30','Penunjukan Panitera Pengganti','3','8','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0')
				,(8,12,'Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0')
				,(8,12,'Penetapan','80','Penetapan Hari Sidang Pertama','3','8','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','8')
				,(8,12,'Penetapan','81','Sidang pertama','5','8','10',NULL,'penetapan_panitera_pengganti','perkara_penetapan','sidang_pertama','Y','0')
				,(8,13,'Mediasi','110','Penetapan Mediator','8','8','81','perkara_penetapan','sidang_pertama','perkara_mediasi','penetapan_penunjukan_mediator','Y','0')
				,(8,13,'Mediasi','120','Penetapan Tanggal Mediasi','2','8','110','perkara_mediasi','penetapan_penunjukan_mediator','perkara_mediasi','penetapan_tanggal_mediasi','Y','0')
				,(8,13,'Mediasi','121','Mulai Mediasi',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','dimulai_mediasi','Y','0')
				,(8,13,'Mediasi','130','Putusan Mediasi','61','8','121','perkara_mediasi','dimulai_mediasi','perkara_mediasi','keputusan_mediasi','Y','8')
				,(8,13,'Mediasi','140','Penetapan Akta Perdamaian',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','akta_perdamaian','Y','0')
				,(8,13,'Mediasi','150','Mediasi Gagal',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','mediasi_gagal','Y','0')
				,(8,13,'Mediasi','180','Mediasi Berhasil',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','mediasi_berhasil','Y','0')
				,(8,15,'Putusan','210','Putusan','6','3','150','perkara_mediasi','mediasi_gagal','perkara_putusan','tanggal_putusan','Y','8')
				,(8,15,'Putusan','211','Pencabutan Perkara',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_cabut','Y','0')
				,(8,15,'Putusan','212','Pernyataan Gugur',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_gugur','Y','0')
				,(8,15,'Putusan','220','Pembuatan Minutasi','14','2','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','8')
				,(8,15,'Putusan','230','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0')
				,(7,10,'Pendaftaran','10','Pendaftaran Perkara',NULL,NULL,NULL,NULL,'tanggal_pendaftaran','perkara','tanggal_pendaftaran','Y','0')
				,(7,12,'Penetapan','81','Sidang pertama',NULL,NULL,NULL,NULL,'penetapan_panitera_pengganti','perkara_penetapan','sidang_pertama','Y','0')
				,(7,12,'Penetapan','80','Penetapan Hari Sidang Pertama','3','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1')
				,(7,12,'Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0')
				,(7,12,'Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0')
				,(7,12,'Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1')
				,(7,13,'Mediasi','140','Penetapan Akta Perdamaian',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','akta_perdamaian','Y','0')
				,(7,13,'Mediasi','180','Mediasi Berhasil',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','mediasi_berhasil','Y','0')
				,(7,13,'Mediasi','150','Mediasi Gagal',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','mediasi_gagal','Y','0')
				,(7,13,'Mediasi','130','Putusan Mediasi','61','1','121','perkara_mediasi','dimulai_mediasi','perkara_mediasi','keputusan_mediasi','Y','1')
				,(7,13,'Mediasi','121','Mulai Mediasi',NULL,NULL,NULL,NULL,NULL,'perkara_mediasi','dimulai_mediasi','Y','0')
				,(7,13,'Mediasi','120','Penetapan Tanggal Mediasi','2','1','110','perkara_mediasi','penetapan_penunjukan_mediator','perkara_mediasi','penetapan_tanggal_mediasi','Y','0')
				,(7,13,'Mediasi','110','Penetapan Mediator','1','1','81','perkara_penetapan','sidang_pertama','perkara_mediasi','penetapan_penunjukan_mediator','Y','0')
				,(7,15,'Putusan','230','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0')
				,(7,15,'Putusan','220','Pembuatan Minutasi','14','2','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1')
				,(7,15,'Putusan','212','Pernyataan Gugur',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_gugur','Y','0')
				,(7,15,'Putusan','211','Pencabutan Perkara',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_cabut','Y','0')
				,(7,15,'Putusan','210','Putusan','6','3','150','perkara_mediasi','mediasi_gagal','perkara_putusan','tanggal_putusan','Y','1')
				,(7,16,'Verzet','280','Pemberitahuan Hasil Putusan Verzet',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','pemberitahuan_putusan_verzet','Y','0')
				,(7,16,'Verzet','270','Putusan Perlawanan  Verzet',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','putusan_verzet','Y','0')
				,(7,16,'Verzet','260','Sidang Pertama Perlawanan',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','tanggal_sidang_pertama_verzet','Y','0')
				,(7,16,'Verzet','240','Pendaftaran Perlawanan(Verzet)','14','1','230','perkara_putusan','pemberitahuan_putusan','perkara_verzet','tanggal_pendaftaran_verzet','Y','0')
				,(7,16,'Verzet','250','Penetapan Jadwal Sidang Verzet',NULL,NULL,NULL,NULL,NULL,'perkara_verzet','tanggal_penetapan_sidang_verzet','Y','0')
				,(7,20,'Banding','400','Pemberitahuan Putusan Banding','14','2','390','perkara_banding','putusan_banding','perkara_banding','pemberitahuan_putusan_banding','Y','1')
				,(7,20,'Banding','390','Putusan Banding','6','3','290','perkara_banding','permohonan_banding','perkara_banding','putusan_banding','Y','1')
				,(7,20,'Banding','380','Penerimaan Kembali Berkas Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kembali_berkas_banding','Y','0')
				,(7,20,'Banding','370','Pengiriman Berkas  Banding','30','2','290','perkara_banding','permohonan_banding','perkara_banding','pengiriman_berkas_banding','Y','1')
				,(7,20,'Banding','360','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pelaksanaan_inzage','Y','0')
				,(7,20,'Banding','350','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0')
				,(7,20,'Banding','340','Penyerahan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_kontra_banding','Y','0')
				,(7,20,'Banding','330','Penerimaan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kontra_banding','Y','0')
				,(7,20,'Banding','320','Penyerahan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_memori_banding','Y','0')
				,(7,20,'Banding','290','Permohonan Banding','14','1','210','perkara_putusan','tanggal_putusan','perkara_banding','permohonan_banding','Y','0')
				,(7,20,'Banding','310','Penerimaan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_memori_banding','Y','0')
				,(7,20,'Banding','300','Pemberitahuan Permohonan Banding','7','1','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1')
				,(7,30,'Kasasi','490','Putusan Kasasi','6','3','410','perkara_kasasi','permohonan_kasasi','perkara_kasasi','putusan_kasasi','Y','1')
				,(7,30,'Kasasi','500','Pemberitahuan Putus Kasasi','30','2','490','perkara_kasasi','putusan_kasasi','perkara_kasasi','pemberitahuan_putusan_kasasi','Y','1')
				,(7,30,'Kasasi','480','Penerimaan Kembali Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_berkas_kasasi','Y','0')
				,(7,30,'Kasasi','470','Pengiriman Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pengiriman_berkas_kasasi','Y','0')
				,(7,30,'Kasasi','460','Penyerahan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_kontra_kasasi','Y','0')
				,(7,30,'Kasasi','410','Permohonan Kasasi','14','2','400','perkara_banding','pemberitahuan_putusan_banding','perkara_kasasi','permohonan_kasasi','Y','0')
				,(7,30,'Kasasi','420','Pemberitahuan Permohonan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_kasasi','Y','0')
				,(7,30,'Kasasi','430','Penerimaan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_memori_kasasi','Y','0')
				,(7,30,'Kasasi','440','Penyerahan Memori Kasasi','14','2','410','perkara_kasasi','permohonan_kasasi','perkara_kasasi','penyerahan_memori_kasasi','Y','1')
				,(7,30,'Kasasi','450','Penerimaan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_kontra_kasasi','Y','0')
				,(7,30,'Kasasi','461','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_inzage_pemohon_kasasi','Y','0')
				,(7,30,'Kasasi','464','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pelaksanaan_inzage_termohon_kasasi','Y','0')
				,(7,40,'Peninjauan Kembali','570','Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','putusan_pk','Y','0')
				,(7,40,'Peninjauan Kembali','560','Penerimaan Kembali Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_berkas_pk','Y','0')
				,(7,40,'Peninjauan Kembali','510','Permohonan PK',NULL,NULL,NULL,NULL,'pemberitahuan_putusan_kasasi','perkara_pk','permohonan_pk','Y','0')
				,(7,40,'Peninjauan Kembali','520','Pemberitahuan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_pk','Y','0')
				,(7,40,'Peninjauan Kembali','521','Penerimaan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_memori_pk','Y','0')
				,(7,40,'Peninjauan Kembali','522','Penyerahan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_memori_pk','Y','0')
				,(7,40,'Peninjauan Kembali','530','Penerimaan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_kontra_pk','Y','0')
				,(7,40,'Peninjauan Kembali','540','Penyerahan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_kontra_pk','Y','0')
				,(7,40,'Peninjauan Kembali','550','Pengiriman Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pengiriman_berkas_pk','Y','0')
				,(7,40,'Peninjauan Kembali','571','Pemberitahuan Putusan PK','30','2','570','perkara_pk','putusan_pk','perkara_pk','pemberitahuan_putusan_pk','Y','1')
				,(7,50,'Eksekusi','640','Penetapan Sita Non Eksekutable',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_noneksekusi','Y','0')
				,(7,50,'Eksekusi','630','Pelaksaan Eksekusi Rill',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_eksekusi_rill','Y','0')
				,(7,50,'Eksekusi','626','Penyerahan Hasil Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penyerahan_hasil_lelang','Y','0')
				,(7,50,'Eksekusi','624','Pelaksanaan Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_eksekusi_lelang','Y','0')
				,(7,50,'Eksekusi','622','Penetapan Perintah Eksekusi Lelang',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_perintah_eksekusi_lelang','Y','0')
				,(7,50,'Eksekusi','620','Pelaksanaan Sita Eksekusi','80','1','0',NULL,NULL,'perkara_eksekusi','pelaksanaan_sita_eksekusi','Y','0')
				,(7,50,'Eksekusi','615','Penetapan Sita Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_sita_eksekusi','Y','0')
				,(7,50,'Eksekusi','610','Pelaksaan Penegoran(Aanmaning)',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','pelaksanaan_teguran_eksekusi','Y','0')
				,(7,50,'Eksekusi','605','Penetapan Teguran Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_teguran_eksekusi','Y','0')
				,(7,50,'Eksekusi','600','Permohonan Eksekusi',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','permohonan_eksekusi','Y','0')
				,(7,50,'Eksekusi','628','Penetapan Perintah Eksekusi Rill',NULL,NULL,NULL,NULL,NULL,'perkara_eksekusi','penetapan_perintah_eksekusi_rill','Y','0')
				,(118,12,'Penetapan',78,'Pembuatan Minutasi Perkara Dilanjutkan',NULL,NULL,NULL,'220',NULL,NULL,NULL,'Y',0)
				,(8, 15, 'Putusan', 214, 'Dismissal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0)
				,(119,10,'Pendaftaran','10','Pendaftaran Perkara',NULL,NULL,NULL,NULL,NULL,'perkara','tanggal_pendaftaran','Y','0')
				,(119,12,'Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1')
				,(119,12,'Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0')
				,(119,12,'Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0')
				,(119,12,'Penetapan','80','Penetapan Hari Sidang Pertama','7','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1')
				,(119,12,'Penetapan','81','Sidang pertama',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','sidang_pertama','Y','0')
				,(119,15,'Putusan','212','Pernyataan Gugur',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_gugur','Y','0')
				,(119,15,'Putusan','220','Pembuatan Minutasi','14','1','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1')
				,(119,15,'Putusan','230','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0')
				,(119,15,'Putusan','211','Pencabutan Perkara',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_cabut','Y','0')
				,(119,15,'Putusan','210','Putusan','6','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1');";
		$this->patching->exe_script($sql);
		

		$isThere = $this->patching->isColumnExist('perkara_mediasi','tgl_kirim_kesepakatan_ke_ptma');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_mediasi 
			ADD COLUMN is_mediasi TINYINT(2) DEFAULT 1  NULL  COMMENT '1.Ya;-1.Tidak' AFTER perkara_id,
			ADD COLUMN tahapan_id TINYINT(4) DEFAULT 10 COMMENT '10:pertama,20:banding,30:kasasi,40:pk' AFTER mediasi_id,
			ADD COLUMN jenis_mediasi TINYINT(1) DEFAULT 1  COMMENT '1:mediasi wajib, 2:mediasi sukarela' AFTER perkara_id,
			ADD COLUMN tgl_permohonan_uh DATE NULL  COMMENT 'Tanggal pihak mengajukan permohonan mediasi ke PN' AFTER catatan_mediasi,
			ADD COLUMN tgl_pemberitahuan_ke_ptma DATE NULL  COMMENT 'Tanggal PN memberitahukan ke PT/MA bahwa ada mediasi setelah pihak menyatakan banding' AFTER tgl_permohonan_uh,
			ADD COLUMN tgl_laporan_mediator DATE NULL  COMMENT 'Tanggal mediator melaporkan bahwa mediasi sudah mendapatkan hasil' AFTER tgl_pemberitahuan_ke_ptma,
			ADD COLUMN tgl_kirim_kesepakatan_ke_ptma DATE NULL  COMMENT 'Tanggal PN mengirimkan hasil kesepakatan mediasi ke PT/MA' AFTER tgl_laporan_mediator;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_mediasi','hasil_mediasi');
		if(!empty($isThere)){
			$sql = "ALTER TABLE perkara_mediasi
			CHANGE mediasi_id mediasi_id BIGINT(20) NOT NULL,
			CHANGE hasil_mediasi hasil_mediasi CHAR(1) NULL  COMMENT 'Hasil Mediasi: pilihan (Y=Berhasil; S=Berhasil Sebagian; T=Tidak Berhasil; D=Tidak dapat dilaksanakan)',
			CHANGE sk_penetapan_mediator_dok sk_penetapan_mediator_dok VARCHAR(250) NULL COMMENT '(tidak digunakan lagi mulai 3.1)Dokumen SK Penetapan Mediator: form upload', 
			CHANGE penetapan_tanggal_mediasi penetapan_tanggal_mediasi DATE NULL COMMENT '(tidak digunakan lagi mulai 3.1)Penetapan Tanggal Mediasi: isian tanggal', 
			CHANGE mediasi_berhasil mediasi_berhasil DATE NULL COMMENT '(tidak digunakan lagi mulai 3.1)Tanggal Mediasi Berhasil: diambil dari kolom keputusan_mediasi jika hasil_midiasi=Y berhasil (by system)', 
			CHANGE mediasi_gagal mediasi_gagal DATE NULL COMMENT '(tidak digunakan lagi mulai 3.1)Tanggal Mediasi Gagal: diambil dari kolom keputusan_mediasi jika kolom hasil_mediasi=T (by system)';";
			$this->patching->exe_script($sql);
		}

		$sql = "DROP PROCEDURE IF EXISTS perkara_update_status;";
		$this->patching->exe_script($sql);

		$sql = "CREATE PROCEDURE perkara_update_status(IN var_id BIGINT(20))
						BEGIN
							DECLARE var_alur_perkara_id INT;
							DECLARE var_jumlah_sidang INT;
							DECLARE var_tanggal_sidang DATE;
							DECLARE var_tahapan_id INT;
							DECLARE var_tahapan_nama VARCHAR(100);
							DECLARE var_proses_id INT;
							DECLARE var_proses_nama VARCHAR(200);
							DECLARE var_proses_status VARCHAR(200);
							DECLARE var_jenis_pengadilan INT;
							
							SELECT `value` INTO var_jenis_pengadilan FROM sys_config WHERE id = 83;
							SELECT alur_perkara_id INTO var_alur_perkara_id FROM perkara WHERE perkara_id= var_id ;
							SELECT tahapan_id INTO var_tahapan_id FROM perkara_proses WHERE perkara_id= var_id  ORDER BY tahapan_id DESC,tanggal DESC,proses_id DESC LIMIT 1;
							SELECT proses_id INTO var_proses_id FROM perkara_proses WHERE perkara_id= var_id  ORDER BY tahapan_id DESC,tanggal DESC,proses_id DESC LIMIT 1;
							SELECT nama INTO var_tahapan_nama FROM tahapan_proses WHERE id= var_tahapan_id AND jenis_pengadilan = var_jenis_pengadilan;
							SELECT DISTINCT proses_nama INTO var_proses_status FROM proses_alur_perkara WHERE proses_id= var_proses_id LIMIT 1;
							
							SELECT COUNT(*) INTO var_jumlah_sidang FROM perkara_jadwal_sidang WHERE perkara_id = var_id ;
							SELECT MAX(tanggal_sidang) INTO var_tanggal_sidang FROM perkara_jadwal_sidang WHERE perkara_id = var_id ;
							IF (var_alur_perkara_id > 1 AND var_proses_id=80 AND var_jumlah_sidang>1) THEN
								SET var_tahapan_id=14;
								SET var_tahapan_nama='Persidangan';
								SET var_proses_id=200;
								SET var_proses_status='Persidangan';
							 END IF;
							 
							IF(var_alur_perkara_id = 1 AND (var_proses_id=150 OR var_proses_id=191) AND var_jumlah_sidang>0) THEN
								SET var_tahapan_id=14;
								SET var_tahapan_nama='Persidangan';
								SET var_proses_id=200;
								SET var_proses_status='Persidangan';
							END IF;    
							
							UPDATE perkara SET 
								perkara.tahapan_terakhir_id= var_tahapan_id,
								perkara.tahapan_terakhir_text= var_tahapan_nama,
								perkara.proses_terakhir_id= var_proses_id,
								perkara.proses_terakhir_text= var_proses_status
							WHERE perkara_id = var_id;
						END";
		$this->patching->exe_script($sql);

		$sql = "REPLACE INTO proses_alur_perkara (alur_perkara_id, tahapan_id, tahapan_nama, proses_id, proses_nama, batas_waktu, satuan, dari_proses_id, nama_tabel_dari, nama_kolom_dari, nama_tabel_ke, nama_kolom_ke, aktif, reminder, keterangan, diedit_oleh, diedit_tanggal, diinput_oleh, diinput_tanggal, diperbaharui_oleh, diperbaharui_tanggal) 
				VALUES('119','10','Pendaftaran','10','Pendaftaran Perkara',NULL,NULL,NULL,NULL,NULL,'perkara','tanggal_pendaftaran','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL)
				,(119,12,'Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL)
				,(119,12,'Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL)
				,(119,12,'Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL)
				,(119,12,'Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL)
				,(119,12,'Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL)
				,(119,12,'Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL)
				,(119,12,'Penetapan','80','Penetapan Hari Sidang Pertama','7','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL)
				,(119,12,'Penetapan','81','Sidang pertama',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','sidang_pertama','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL)
				,(119,14,'Persidangan','200','Persidangan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','1',NULL,NULL,NULL,'system','2012-10-31 10:16:09','system','2012-10-31 10:16:25')
				,(119,15,'Putusan','212','Pernyataan Gugur',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_gugur','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL)
				,(119,15,'Putusan','220','Pembuatan Minutasi','14','1','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL)
				,(119,15,'Putusan','230','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL)
				,(119,15,'Putusan','211','Pencabutan Perkara',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_cabut','Y','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL)
				,(119,15,'Putusan','210','Putusan','6','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1',NULL,NULL,NULL,NULL,NULL,'admin','2012-11-07 13:02:43');";
		$this->patching->exe_script($sql);


		$sql = "UPDATE proses_alur_perkara SET reminder=0 WHERE id=10;";
		$this->patching->exe_script($sql);

		$sql = "UPDATE proses_alur_perkara SET reminder=0 WHERE id=1516;";
		$this->patching->exe_script($sql);

		

		$sql = "REPLACE INTO sys_group_rule VALUES(10,350)
				,(10,351),(20,350),(20,351),(30,350),(30,351),(410,350),(410,351),(412,350)
				,(412,351),(413,350),(413,351),(414,350),(414,351),(420,350),(420,351),(422,350)
				,(422,351),(423,350),(423,351),(430,350),(430,351),(431,350),(431,351),(500,350)
				,(500,351),(600,350),(600,351);";
		$this->patching->exe_script($sql);

		$isThere = $this->patching->isColumnExist('perkara','nilai_sengketa');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara 
			ADD COLUMN nilai_sengketa BIGINT(20) UNSIGNED DEFAULT 0  NULL AFTER proses_terakhir_text;";
			$this->patching->exe_script($sql);
		}

		$sql = "DROP VIEW IF EXISTS v_perkara_mediasi_terakhir";
		$this->patching->exe_script($sql);

		$sql = "CREATE VIEW v_perkara_mediasi_terakhir AS 
				SELECT *  FROM perkara_mediasi WHERE (perkara_id, mediasi_id) IN 
				(SELECT perkara_id, MAX(mediasi_id) 
					FROM perkara_mediasi WHERE tahapan_id = 10 GROUP BY perkara_id);";
		$this->patching->exe_script($sql);

		

		$isThere = $this->patching->isColumnExist('perkara_jadwal_sidang','dihadiri_oleh');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_jadwal_sidang 
					ADD COLUMN dihadiri_oleh CHAR(1) NULL  COMMENT '1. Semua Pihak, 2.Pihak Pertama Saja, 3.Pihak Kedua Saja, 4.Pihak Tidak Hadir' AFTER sidang_keliling,
					ADD COLUMN keberatan CHAR(1) DEFAULT 'T' NULL  COMMENT 'flag untuk sidang perkara keberatan' AFTER verzet,
					ADD COLUMN ikrar_talak CHAR(1) DEFAULT 'T' NULL AFTER keberatan;";
			$this->patching->exe_script($sql);
		}
		$sql = "DROP TABLE IF EXISTS sys_backup;";
		$this->patching->exe_script($sql);

		$sql = "CREATE TABLE sys_backup(  
					id BIGINT NOT NULL AUTO_INCREMENT,
					tanggal DATE,
					jam TIME,
					filename VARCHAR(150),
					location VARCHAR(150),
					timestamp_backup TIMESTAMP,
					PRIMARY KEY (id)
				)ENGINE=INNODB;";
		$this->patching->exe_script($sql);

		$isThere = $this->patching->isColumnExist('sys_backup','type');
		if(!empty($isThere)){
			$sql = "ALTER TABLE sys_backup ADD COLUMN type CHAR(1) NULL  COMMENT '1.Database, 2.Aplikasi' AFTER filename;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('pihak','difabel');
		if(empty($isThere)){
			$sql = "ALTER TABLE pihak 
					ADD COLUMN difabel CHAR(1) DEFAULT 'T' NOT NULL  COMMENT 'Y=Ya, T = Tidak' AFTER foto;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('pihak','nama');
		if(!empty($isThere)){
			$sql = "ALTER TABLE pihak 
					CHANGE nama nama VARCHAR(500) NULL  COMMENT 'Nama: isian bebas';";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_pihak1','nama');
		if(!empty($isThere)){
			$sql = "ALTER TABLE perkara_pihak1 CHANGE nama nama VARCHAR(500) NULL  COMMENT 'Nama: merujuk ke tabel pihak kolom nama(by system)';";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_pihak2','nama');
		if(!empty($isThere)){
			$sql = "ALTER TABLE perkara_pihak2 CHANGE nama nama VARCHAR(500) NULL  COMMENT 'Nama: merujuk ke tabel pihak kolom nama(by system)';";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_pihak3','nama');
		if(!empty($isThere)){
			$sql = "ALTER TABLE perkara_pihak3 CHANGE nama nama VARCHAR(500) NULL  COMMENT 'Nama: merujuk ke tabel pihak kolom nama(by system)';";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_pihak4','nama');
		if(!empty($isThere)){
			$sql = "ALTER TABLE perkara_pihak4 CHANGE nama nama VARCHAR(500) NULL  COMMENT 'Nama: merujuk ke tabel pihak kolom nama(by system)';";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('kurator','nama');
		if(!empty($isThere)){
			$sql = "ALTER TABLE kurator CHANGE nama nama VARCHAR(500) NULL  COMMENT 'Nama: merujuk ke tabel pihak kolom nama(by system)';";
			$this->patching->exe_script($sql);
		}

		$sql = "UPDATE jenis_perkara SET format_nomor = '#nomor_urut_perkara#/Pdt.Sus/#tahun#/PN #kode_pn#' WHERE id = 139;";
		$this->patching->exe_script($sql);

		$sql = "UPDATE jenis_perkara SET format_nomor = '#nomor_urut_perkara#/Pdt.Sus/#tahun#/PN #kode_pn#' WHERE id = 140;";
		$this->patching->exe_script($sql);

		$sql = "UPDATE jenis_perkara SET format_nomor = '#nomor_urut_perkara#/Pdt.Sus/#tahun#/PN #kode_pn#' WHERE id = 141;";
		$this->patching->exe_script($sql);

		$sql = "UPDATE jenis_perkara SET format_nomor = '#nomor_urut_perkara#/Pid.Sus/#tahun#/PN #kode_pn#' WHERE id = 47;";
		$this->patching->exe_script($sql);

		$sql = "UPDATE jenis_perkara SET format_nomor = '#nomor_urut_perkara#/Pid.Sus/#tahun#/PN #kode_pn#' WHERE id = 204;";
		$this->patching->exe_script($sql);

		$sql = "UPDATE jenis_perkara SET format_nomor = '#nomor_urut_perkara#/Pid.Sus/#tahun#/PN #kode_pn#' WHERE id = 205;";
		$this->patching->exe_script($sql);

		$sql = "UPDATE jenis_perkara SET format_nomor = '#nomor_urut_perkara#/Pid.Sus/#tahun#/PN #kode_pn#' WHERE id >= 228 AND id <= 240;";
		$this->patching->exe_script($sql);

		$sql = "UPDATE jenis_perkara SET format_nomor = '#nomor_urut_perkara#/Pid.Sus/#tahun#/PN #kode_pn#' WHERE id = 111;";
		$this->patching->exe_script($sql);

		$isThere = $this->patching->isColumnExist('sys_users','params');
		if(!empty($isThere)){
			$sql = "ALTER TABLE sys_users   
						CHANGE params params VARCHAR(255) NULL  COMMENT 'parameter lain',
						CHANGE lock_by lock_by VARCHAR(30) NULL  COMMENT 'Diedit Oleh: (by system)';";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('mediator','no_sertifikasi');
		if(empty($isThere)){
			$sql = "ALTER TABLE mediator ADD COLUMN no_sertifikasi VARCHAR(50) NULL AFTER profesi,
			ADD COLUMN tgl_sertifikasi DATE NULL AFTER no_sertifikasi,
			ADD COLUMN lembaga_sertifikasi VARCHAR(255) NULL AFTER tgl_sertifikasi,
			ADD COLUMN bersertifikat CHAR(1) DEFAULT 'Y' NOT NULL  COMMENT 'Status bersertifikat : Y (bersertifikat) T (tidak bersertifikat)' AFTER profesi;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('mediator','status_mediator');
		if(!empty($isThere)){
			$sql = "ALTER TABLE mediator 
			CHANGE status_mediator status_mediator CHAR(1) NULL COMMENT 'Status Mediator: pilihan H=Hakim; N=Mediator Umum; P=Pegawai';";
			$this->patching->exe_script($sql);
		}

		$this->patching->exe_script($sql);

		$sql = "UPDATE proses SET nama = 'Mediasi Tidak Berhasil' ,keterangan = 'Mediasi Tidak Berhasil' WHERE id = '150';";
		$this->patching->exe_script($sql);

		$sql = "UPDATE proses SET nama = 'Mediasi Berhasil' ,keterangan = 'Mediasi Berhasil' WHERE id = '180';";
		$this->patching->exe_script($sql);

		$sql = "UPDATE proses SET nama = 'Kesepakatan Mediasi' ,keterangan = 'Kesepakatan Mediasi' WHERE id = '130';";
		$this->patching->exe_script($sql);

		
		$tobepatch = TRUE;
		$result = $this->db->query("SELECT mediasi_id FROM perkara_mediasi WHERE jenis_mediasi IS NULL OR jenis_mediasi=''");
		if(!empty($result)){
			if($result->num_rows>0){
				$tobepatch = TRUE;
			}else{
				$tobepatch = FALSE;
			}
		}else{
			$tobepatch = FALSE;
		}
		$sql = "UPDATE perkara_mediasi 
				SET jenis_mediasi='1' 
				WHERE mediasi_id 
				IN (SELECT * FROM (SELECT mediasi_id FROM perkara_mediasi WHERE jenis_mediasi IS NULL OR jenis_mediasi=' ')tbltemp);";
		$this->patching->exe_script($sql);

		$isThere = $this->patching->isColumnExist('perkara_verzet','alasan_penundaan_verzet');
		if(!empty($isThere)){
			$sql = 'ALTER TABLE perkara_verzet   
					DROP COLUMN alasan_penundaan_verzet;';
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_verzet','sumber_hukum_id');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_verzet   
					ADD COLUMN sumber_hukum_id TINYINT(4) NULL AFTER status_putusan_verzet_text;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_verzet','putusan_verstek');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_verzet   
					ADD COLUMN putusan_verstek char(1) DEFAULT 'T' AFTER sumber_hukum_id;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_verzet','sidang_id');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_verzet   
					ADD COLUMN sidang_id BIGINT NULL  COMMENT 'Merujuk ke ID pada Table Perkara_jadwal_sidang' AFTER jurusita_text;";
			$this->patching->exe_script($sql);
		}

		

		$sql = "REPLACE INTO proses_alur_perkara (alur_perkara_id, tahapan_id, tahapan_nama, proses_id,  proses_nama) VALUES (1,16,'Verzet',241,'Penetapan Majelis Hakim Verzet')
				,(1,16,'Verzet',242,'Penetapan Panitera Pengganti Verzet')
				,(1,16,'Verzet',243,'Penetapan Jurusita Verzet')
				,(1,16,'Verzet',261,'Persidangan Verzet')
				,(119,14,'Persidangan',200,'Persidangan')
				,(119,12,'Penetapan',41,'Penunjukan Kembali Jurusita')
				,(119,12,'Penetapan',21,'Penetapan Kembali Majelis Hakim/Hakim')
				,(119,12,'Penetapan',31,'Penunjukan Kembali Panitera Pengganti')
				,(8,17,'Keberatan','282','Penetapan Majelis Hakim Keberatan')
				,(8,17,'Keberatan','283','Penetapan Panitera Pengganti Keberatan')
				,(8,17,'Keberatan','284','Penetapan Jurusita Keberatan')
				,(8,17,'Keberatan','287','Persidangan Keberatan')
				,(8,12,'Penetapan','31','Penunjukan Kembali Panitera Pengganti')
				,(8,12,'Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim')
				,(8,12,'Penetapan','31','Penunjukan Kembali Panitera Pengganti')
				,(8,12,'Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim')
				,(8,12,'Penetapan','41','Penunjukan Kembali Jurusita')
				,(8,13,'Mediasi','191','Tidak Mediasi')
				,(8,14,'Persidangan','200','Persidangan')
				,(7,13,'Mediasi','191','Tidak Mediasi')
				,(7,12,'Penetapan','41','Penunjukan Kembali Jurusita')
				,(7,12,'Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim')
				,(7,12,'Penetapan','31','Penunjukan Kembali Panitera Pengganti')
				,(7,20,'Banding','391','Pencabutan Perkara Banding')
				,(7,14,'Persidangan','200','Persidangan')
				,(1,13,'Mediasi',151, 'Mediasi Tidak Dapat Dilaksanakan')
				,(1,13,'Mediasi',181, 'Mediasi Berhasil Sebagian')
				,(7,13,'Mediasi',151, 'Mediasi Tidak Dapat Dilaksanakan')
				,(7,13,'Mediasi',181, 'Mediasi Berhasil Sebagian')
				,(8,13,'Mediasi',151, 'Mediasi Tidak Dapat Dilaksanakan')
				,(8,13,'Mediasi',181, 'Mediasi Berhasil Sebagian');";
		$this->patching->exe_script($sql);

		$sql = "REPLACE INTO jenis_alur_perkara (alur_perkara_id, jenis_perkara_id) VALUES
				(8,75),(8,120);";
		$this->patching->exe_script($sql);

		$sql = "REPLACE INTO biaya_perkara (alur_perkara_id, jenis_biaya_id, jumlah, keterangan, diinput_oleh, diinput_tanggal, diperbaharui_oleh, diperbaharui_tanggal) values('8','2','0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,3,'0.00',NULL,NULL,NULL,NULL,NULL),(8,4,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,5,'0.00',NULL,NULL,NULL,NULL,NULL),(8,6,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,7,'0.00',NULL,NULL,NULL,NULL,NULL),(8,9,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,10,'0.00',NULL,NULL,NULL,NULL,NULL),(8,11,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,12,'0.00',NULL,NULL,NULL,NULL,NULL),(8,14,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,16,'0.00',NULL,NULL,NULL,NULL,NULL),(8,8,'1000000.00',NULL,NULL,NULL,NULL,NULL)
				,(8,25,'0.00',NULL,NULL,NULL,NULL,NULL),(8,26,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,27,'0.00',NULL,NULL,NULL,NULL,NULL),(8,28,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,29,'0.00',NULL,NULL,NULL,NULL,NULL),(8,30,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,31,'0.00',NULL,NULL,NULL,NULL,NULL),(8,32,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,33,'0.00',NULL,NULL,NULL,NULL,NULL),(8,34,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,35,'0.00',NULL,NULL,NULL,NULL,NULL),(8,36,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,37,'0.00',NULL,NULL,NULL,NULL,NULL),(8,38,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,39,'0.00',NULL,NULL,NULL,NULL,NULL),(8,40,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,41,'0.00',NULL,NULL,NULL,NULL,NULL),(8,42,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,43,'0.00',NULL,NULL,NULL,NULL,NULL),(8,44,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,45,'0.00',NULL,NULL,NULL,NULL,NULL),(8,61,'30000.00',NULL,NULL,NULL,NULL,NULL)
				,(8,62,'30000.00',NULL,NULL,NULL,NULL,NULL),(8,63,'30000.00',NULL,NULL,NULL,NULL,NULL)
				,(8,64,'30000.00',NULL,NULL,NULL,NULL,NULL),(8,65,'30000.00',NULL,NULL,NULL,NULL,NULL)
				,(8,141,'0.00',NULL,NULL,NULL,NULL,NULL),(8,143,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,144,'0.00',NULL,NULL,NULL,NULL,NULL),(8,145,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,146,'0.00',NULL,NULL,NULL,NULL,NULL),(8,150,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,151,'0.00','Pengembalian Sisa Panjar','system','2012-04-23 10:29:35',NULL,NULL)
				,(8,152,'0.00','Biaya Meterai','system','2012-04-23 10:44:45',NULL,NULL)
				,(8,153,'0.00','Biaya Penyumpahan','system','2012-04-23 10:45:13',NULL,NULL)
				,(8,154,'0.00','Biaya Penerjemah','system','2012-04-23 10:45:40',NULL,NULL)
				,(8,155,'50000.00','Biaya Alat Tulis Kantor','system','2012-04-23 10:46:30',NULL,NULL)
				,(8,156,'0.00','Biaya Upah Tulis','system','2012-04-23 10:47:04',NULL,NULL)
				,(8,157,'0.00','Biaya Redaksi/Leges','system','2012-04-23 10:47:23',NULL,NULL)
				,(8,159,'0.00','Biaya Pencatatan Permohonan Sita Konservatoir','system','2012-04-23 10:49:47',NULL,NULL)
				,(8,160,'0.00','Biaya Pencatatan Permohonan Sita Revindikatoir','system','2012-04-23 10:50:07',NULL,NULL)
				,(8,161,'0.00','Biaya Permohonan Pencabutan Sita','system','2012-04-23 10:50:31',NULL,NULL)
				,(8,162,'0.00','Biaya Lain-lain','system','2012-04-23 10:50:51',NULL,NULL)
				,(8,166,'0.00','Pengembalian Sisa Panjar','system','2012-04-23 10:29:35',NULL,NULL)
				,(8,167,'0.00','Biaya Meterai','system','2012-04-23 10:44:45',NULL,NULL)
				,(8,168,'0.00','Biaya Penyumpahan','system','2012-04-23 10:45:13',NULL,NULL)
				,(8,169,'0.00','Biaya Penerjemah','system','2012-04-23 10:45:40',NULL,NULL)
				,(8,170,'50000.00','Biaya Alat Tulis Kantor','system','2012-04-23 10:46:30',NULL,NULL)
				,(8,171,'0.00','Biaya Upah Tulis','system','2012-04-23 10:47:04',NULL,NULL)
				,(8,172,'0.00','Biaya Redaksi/Leges','system','2012-04-23 10:47:23',NULL,NULL)
				,(8,174,'0.00','Biaya Pencatatan Permohonan Sita Konservatoir','system','2012-04-23 10:49:47',NULL,NULL)
				,(8,175,'0.00','Biaya Pencatatan Permohonan Sita Revindikatoir','system','2012-04-23 10:50:07',NULL,NULL)
				,(8,176,'0.00','Biaya Permohonan Pencabutan Sita','system','2012-04-23 10:50:31',NULL,NULL)
				,(8,177,'0.00','Biaya Lain-lain','system','2012-04-23 10:50:51',NULL,NULL)
				,(8,181,'0.00','Pengembalian Sisa Panjar','system','2012-04-23 10:29:35',NULL,NULL)
				,(8,182,'0.00','Biaya Meterai','system','2012-04-23 10:44:45',NULL,NULL)
				,(8,183,'0.00','Biaya Penyumpahan','system','2012-04-23 10:45:13',NULL,NULL)
				,(8,184,'0.00','Biaya Penerjemah','system','2012-04-23 10:45:40',NULL,NULL)
				,(8,185,'50000.00','Biaya Alat Tulis Kantor','system','2012-04-23 10:46:30',NULL,NULL)
				,(8,186,'0.00','Biaya Upah Tulis','system','2012-04-23 10:47:04',NULL,NULL)
				,(8,187,'0.00','Biaya Redaksi/Leges','system','2012-04-23 10:47:23',NULL,NULL)
				,(8,189,'0.00','Biaya Pencatatan Permohonan Sita Konservatoir','system','2012-04-23 10:49:47',NULL,NULL)
				,(8,190,'0.00','Biaya Pencatatan Permohonan Sita Revindikatoir','system','2012-04-23 10:50:07',NULL,NULL)
				,(8,191,'0.00','Biaya Permohonan Pencabutan Sita','system','2012-04-23 10:50:31',NULL,NULL)
				,(8,192,'0.00','Biaya Lain-lain','system','2012-04-23 10:50:51',NULL,NULL)
				,(8,196,'0.00','Pengembalian Sisa Panjar','system','2012-04-23 10:29:35',NULL,NULL)
				,(8,197,'0.00','Biaya Meterai','system','2012-04-23 10:44:45',NULL,NULL)
				,(8,198,'0.00','Biaya Penyumpahan','system','2012-04-23 10:45:13',NULL,NULL)
				,(8,199,'0.00','Biaya Penerjemah','system','2012-04-23 10:45:40',NULL,NULL)
				,(8,200,'50000.00','Biaya Alat Tulis Kantor','system','2012-04-23 10:46:30',NULL,NULL)
				,(8,201,'0.00','Biaya Upah Tulis','system','2012-04-23 10:47:04',NULL,NULL)
				,(8,202,'0.00','Biaya Redaksi/Leges','system','2012-04-23 10:47:23',NULL,NULL)
				,(8,204,'0.00','Biaya Pencatatan Permohonan Sita Konservatoir','system','2012-04-23 10:49:47',NULL,NULL)
				,(8,205,'0.00','Biaya Pencatatan Permohonan Sita Revindikatoir','system','2012-04-23 10:50:07',NULL,NULL)
				,(8,206,'0.00','Biaya Permohonan Pencabutan Sita','system','2012-04-23 10:50:31',NULL,NULL)
				,(8,207,'0.00','Biaya Lain-lain','system','2012-04-23 10:50:51',NULL,NULL)
				,(8,211,'0.00','Pengembalian Sisa Panjar','system','2012-04-23 10:29:35',NULL,NULL)
				,(8,212,'0.00','Biaya Meterai','system','2012-04-23 10:44:45',NULL,NULL)
				,(8,213,'0.00','Biaya Penyumpahan','system','2012-04-23 10:45:13',NULL,NULL)
				,(8,214,'0.00','Biaya Penerjemah','system','2012-04-23 10:45:40',NULL,NULL)
				,(8,215,'50000.00','Biaya Alat Tulis Kantor','system','2012-04-23 10:46:30',NULL,NULL)
				,(8,216,'0.00','Biaya Upah Tulis','system','2012-04-23 10:47:04',NULL,NULL)
				,(8,217,'0.00','Biaya Redaksi/Leges','system','2012-04-23 10:47:23',NULL,NULL)
				,(8,219,'0.00','Biaya Pencatatan Permohonan Sita Konservatoir','system','2012-04-23 10:49:47',NULL,NULL)
				,(8,220,'0.00','Biaya Pencatatan Permohonan Sita Revindikatoir','system','2012-04-23 10:50:07',NULL,NULL)
				,(8,221,'0.00','Biaya Permohonan Pencabutan Sita','system','2012-04-23 10:50:31',NULL,NULL)
				,(8,222,'0.00','Biaya Lain-lain','system','2012-04-23 10:50:51',NULL,NULL)
				,(8,223,'0.00',NULL,NULL,NULL,NULL,NULL),(8,224,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,225,'0.00',NULL,NULL,NULL,NULL,NULL),(8,226,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,227,'0.00',NULL,NULL,NULL,NULL,NULL),(8,228,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,229,'0.00',NULL,NULL,NULL,NULL,NULL),(8,230,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,231,'0.00',NULL,NULL,NULL,NULL,NULL),(8,236,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,237,'0.00',NULL,NULL,NULL,NULL,NULL),(8,238,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,239,'0.00',NULL,NULL,NULL,NULL,NULL),(8,240,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,241,'0.00',NULL,NULL,NULL,NULL,NULL),(8,242,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,243,'0.00',NULL,NULL,NULL,NULL,NULL),(8,244,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,245,'0.00',NULL,NULL,NULL,NULL,NULL),(8,246,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,247,'0.00',NULL,NULL,NULL,NULL,NULL),(8,248,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,249,'0.00',NULL,NULL,NULL,NULL,NULL),(8,250,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,251,'0.00',NULL,NULL,NULL,NULL,NULL),(8,252,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,257,'0.00',NULL,NULL,NULL,NULL,NULL),(8,261,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,262,'0.00',NULL,NULL,NULL,NULL,NULL),(8,263,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,264,'0.00',NULL,NULL,NULL,NULL,NULL),(8,265,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,266,'0.00',NULL,NULL,NULL,NULL,NULL),(8,267,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,268,'0.00',NULL,NULL,NULL,NULL,NULL),(8,269,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,270,'0.00',NULL,NULL,NULL,NULL,NULL),(8,271,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,272,'0.00',NULL,NULL,NULL,NULL,NULL),(8,273,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,274,'0.00',NULL,NULL,NULL,NULL,NULL),(8,275,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,276,'0.00',NULL,NULL,NULL,NULL,NULL),(8,277,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,278,'0.00',NULL,NULL,NULL,NULL,NULL),(8,279,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,280,'0.00',NULL,NULL,NULL,NULL,NULL),(8,281,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,282,'0.00',NULL,NULL,NULL,NULL,NULL),(8,283,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,284,'0.00',NULL,NULL,NULL,NULL,NULL),(8,285,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,286,'0.00',NULL,NULL,NULL,NULL,NULL),(8,287,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,288,'0.00',NULL,NULL,NULL,NULL,NULL),(8,289,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,290,'0.00',NULL,NULL,NULL,NULL,NULL),(8,291,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,292,'0.00',NULL,NULL,NULL,NULL,NULL),(8,293,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,294,'6000.00',NULL,NULL,NULL,NULL,NULL),(8,295,'6000.00',NULL,NULL,NULL,NULL,NULL)
				,(8,296,'6000.00',NULL,NULL,NULL,NULL,NULL),(8,297,'6000.00',NULL,NULL,NULL,NULL,NULL)
				,(8,298,'6000.00',NULL,NULL,NULL,NULL,NULL),(8,299,'6000.00',NULL,NULL,NULL,NULL,NULL)
				,(8,300,'6000.00',NULL,NULL,NULL,NULL,NULL),(8,301,'6000.00',NULL,NULL,NULL,NULL,NULL)
				,(8,302,'6000.00',NULL,NULL,NULL,NULL,NULL),(8,303,'6000.00',NULL,NULL,NULL,NULL,NULL)
				,(8,304,'6000.00',NULL,NULL,NULL,NULL,NULL),(8,305,'6000.00',NULL,NULL,NULL,NULL,NULL)
				,(8,306,'6000.00',NULL,NULL,NULL,NULL,NULL),(8,307,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,308,'0.00',NULL,NULL,NULL,NULL,NULL),(8,309,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,310,'0.00',NULL,NULL,NULL,NULL,NULL),(8,311,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,312,'0.00',NULL,NULL,NULL,NULL,NULL),(8,313,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,314,'0.00',NULL,NULL,NULL,NULL,NULL),(8,315,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,316,'0.00',NULL,NULL,NULL,NULL,NULL),(8,317,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,318,'0.00',NULL,NULL,NULL,NULL,NULL),(8,319,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,320,'0.00',NULL,NULL,NULL,NULL,NULL),(8,321,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,322,'0.00',NULL,NULL,NULL,NULL,NULL),(8,323,'0.00',NULL,NULL,NULL,NULL,NULL)
				,(8,324,'0.00',NULL,NULL,NULL,NULL,NULL),(8,325,'0.00',NULL,NULL,NULL,NULL,NULL);";
		$this->patching->exe_script($sql);

		
		$data = $this->patching->exe_script('SELECT proses_id FROM proses_alur_perkara WHERE proses_id=218');
		if($data->num_rows<1){
			$sql = "UPDATE proses_alur_perkara SET proses_id=75 WHERE alur_perkara_id=118 AND tahapan_id=12 AND proses_id=77;";
			$this->patching->exe_script($sql);

			$sql = "UPDATE proses_alur_perkara SET proses_id=76 WHERE alur_perkara_id=118 AND tahapan_id=12 AND proses_id=78;";
			$this->patching->exe_script($sql);
			
			$sql = "UPDATE proses_alur_perkara SET proses_id = 218 WHERE proses_id = 230;";
			$this->patching->exe_script($sql);
			$sql = "UPDATE proses_alur_perkara SET proses_id = 219 WHERE proses_id = 239;";
			$this->patching->exe_script($sql);
			$sql = "UPDATE proses SET id=218,kode = 218 WHERE id = 230;";
			$this->patching->exe_script($sql);
			$sql = "UPDATE proses SET id=219,kode = 219 WHERE id = 239;";
			$this->patching->exe_script($sql);
			$sql = "UPDATE perkara SET proses_terakhir_id = 218 WHERE proses_terakhir_id = 230;";
			$this->patching->exe_script($sql);
			$sql = "UPDATE perkara SET proses_terakhir_id = 219 WHERE proses_terakhir_id = 239;";
			$this->patching->exe_script($sql);
			$sql = "UPDATE perkara_proses SET proses_id = 218 WHERE proses_id = 230;";
			$this->patching->exe_script($sql);
			$sql = "UPDATE perkara_proses SET proses_id = 219 WHERE proses_id = 239;";
			$this->patching->exe_script($sql);
			$sql = "UPDATE proses_alur_perkara SET proses_nama = 'Kirim Salinan Putusan' WHERE proses_id = 219;";
			$this->patching->exe_script($sql);
			$sql = "UPDATE proses SET nama='Kirim Salinan Putusan',keterangan = 'Kirim Salinan Putusan' WHERE id = 219;";
			$this->patching->exe_script($sql);
			$sql = "UPDATE perkara SET proses_terakhir_text = 'Kirim Salinan Putusan' WHERE proses_terakhir_id = 219;";
			$this->patching->exe_script($sql);
			$sql = "UPDATE perkara_proses SET proses_nama = 'Kirim Salinan Putusan' WHERE proses_id = 219;";
			$this->patching->exe_script($sql);
		}

		$sql = "DROP TABLE IF EXISTS pengadilan_negeri;";
		$this->patching->exe_script($sql);

		$sql = "CREATE TABLE pengadilan_negeri (
				id int(11) unsigned NOT NULL,
				pt_id int(11) unsigned DEFAULT NULL,
				kode varchar(50) DEFAULT NULL,
				kode_pn varchar(20) DEFAULT NULL,
				nama varchar(100) NOT NULL,
				alamat varchar(500) DEFAULT NULL,
				aktif char(1) NOT NULL DEFAULT 'Y',
				jenis_pengadilan TINYINT(1) DEFAULT 1  NOT NULL,
				PRIMARY KEY (id),
				UNIQUE KEY pn_index (id,nama),
				UNIQUE KEY pt_pn_index (id,pt_id,nama),
				KEY aktif (aktif),
				KEY pt_id (pt_id)
			) ENGINE=MyISAM;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS pengadilan_tinggi;";
		$this->patching->exe_script($sql);

		$sql = "CREATE TABLE pengadilan_tinggi (
					id int(11) unsigned NOT NULL,
					kode varchar(50) DEFAULT NULL,
					nama varchar(100) NOT NULL DEFAULT '',
					alamat varchar(500) DEFAULT NULL,
					aktif char(1) NOT NULL DEFAULT 'Y',
					jenis_pengadilan TINYINT(1) DEFAULT 1  NOT NULL,
					PRIMARY KEY (id),
					UNIQUE KEY nama (nama),
					KEY aktif (aktif)
				) ENGINE=MyISAM;";
		$this->patching->exe_script($sql);

		

		$sql = "REPLACE INTO pengadilan_tinggi(id,kode,nama,alamat,aktif) VALUES 
				(1,NULL,'PENGADILAN TINGGI BANDA ACEH',NULL,'Y')
				,(2,NULL,'PENGADILAN TINGGI MEDAN',NULL,'Y')
				,(3,NULL,'PENGADILAN TINGGI PADANG',NULL,'Y')
				,(4,NULL,'PENGADILAN TINGGI PEKANBARU',NULL,'Y')
				,(5,NULL,'PENGADILAN TINGGI JAMBI',NULL,'Y')
				,(6,NULL,'PENGADILAN TINGGI PALEMBANG','Jl. Jenderal Sudirman Km. 3,5 Palembang (0711) 352900, 311666','Y')
				,(7,NULL,'PENGADILAN TINGGI BENGKULU',NULL,'Y')
				,(8,NULL,'PENGADILAN TINGGI TANJUNG KARANG',NULL,'Y')
				,(9,NULL,'PENGADILAN TINGGI BANGKA BELITUNG',NULL,'Y')
				,(11,NULL,'PENGADILAN TINGGI JAKARTA',NULL,'Y')
				,(12,NULL,'PENGADILAN TINGGI BANDUNG',NULL,'Y')
				,(13,NULL,'PENGADILAN TINGGI SEMARANG',NULL,'Y')
				,(14,NULL,'PENGADILAN TINGGI YOGYAKARTA','Jl. Prof.DR. Soepomo No.10 Yogyakarta Telp. (0274) 87324, 87227','Y')
				,(15,NULL,'PENGADILAN TINGGI SURABAYA','Jl. Sumatera No.42 Surabaya, Jawa Timur Telp. (031) 44409,44410, 5033042,5024408','Y')
				,(16,NULL,'PENGADILAN TINGGI BANTEN',NULL,'Y')
				,(17,NULL,'PENGADILAN TINGGI DENPASAR',NULL,'Y')
				,(18,NULL,'PENGADILAN TINGGI MATARAM',NULL,'Y')
				,(19,NULL,'PENGADILAN TINGGI KUPANG',NULL,'Y')
				,(20,NULL,'PENGADILAN TINGGI PONTIANAK',NULL,'Y')
				,(21,NULL,'PENGADILAN TINGGI PALANGKARAYA',NULL,'Y')
				,(22,NULL,'PENGADILAN TINGGI BANJARMASIN',NULL,'Y')
				,(23,NULL,'PENGADILAN TINGGI SAMARINDA',NULL,'Y')
				,(24,NULL,'PENGADILAN TINGGI MANADO',NULL,'Y')
				,(25,NULL,'PENGADILAN TINGGI PALU',NULL,'Y')
				,(26,NULL,'PENGADILAN TINGGI MAKASSAR',NULL,'Y')
				,(27,NULL,'PENGADILAN TINGGI KENDARI',NULL,'Y')
				,(28,NULL,'PENGADILAN TINGGI GORONTALO',NULL,'Y')
				,(30,NULL,'PENGADILAN TINGGI AMBON',NULL,'Y')
				,(31,NULL,'PENGADILAN TINGGI MALUKU UTARA',NULL,'Y')
				,(33,NULL,'PENGADILAN TINGGI JAYAPURA',NULL,'Y');";
		$this->patching->exe_script($sql);
		$this->patching->exe_script("REPLACE INTO pengadilan_tinggi (id, kode, nama, jenis_pengadilan) 
		VALUES
			(34,'MDN','PENGADILAN TINGGI TATA USAHA NEGARA MEDAN','3'),
			(35,'JKT','PENGADILAN TINGGI TATA USAHA NEGARA JAKARTA','3'),
			(36,'SBY','PENGADILAN TINGGI TATA USAHA NEGARA SURABAYA','3'),
			(37,'MKS','PENGADILAN TINGGI TATA USAHA NEGARA MAKASSAR','3'),
			(39,'PMT.I', 'PENGADILAN MILITER TINGGI I MEDAN', '2'),
			(40,'PMT.II', 'PENGADILAN MILITER TINGGI II JAKARTA','2'),
			(41,'PMT.III', 'PENGADILAN MILITER TINGGI III SURABAYA','2');");

		$this->patching->exe_script("REPLACE INTO pengadilan_tinggi (id, kode, nama, alamat, aktif, jenis_pengadilan)
		VALUES
			(42,'PTA.JK', 'PENGADILAN TINGGI AGAMA JAKARTA', 'Jl. Raden Intan II No.3 Duren Sawit, Jakarta Timur', 'Y', 4),
			(43,'PTA.Btn', 'PENGADILAN TINGGI AGAMA BANTEN', 'Jl. Raya Pandeglang KM. 7 Serang, Banten, 42171 - Telp. 0254-251485, Fax.  0254-251484', 'Y', 4),
			(44,'PTA.Bn', 'PENGADILAN TINGGI AGAMA BENGKULU', 'JI. Sungai Rupat No. 60 A, Pagar Dewa, Telp. 52373 - 52374, Fax. 52373 Bengkulu 38225', 'Y', 4),
			(45,'PTA.Yk', 'PENGADILAN TINGGI AGAMA YOGYAKARTA', 'JI. Lingkaran Selatan No. 321, Telp. 380355, Yogyakarta 55188', 'Y', 4),
			(46,'PTA.Gtlo', 'PENGADILAN TINGGI AGAMA GORONTALO', 'Jl. Tina Loga, Kode Pos 96128 Telp (0435) 831591 Fax 831625', 'Y', 4),
			(47,'PTA.Jpr', 'PENGADILAN TINGGI AGAMA JAYAPURA', 'JI. Baru 103 Kotaraja', 'Y', 4),
			(48,'PTA.Jb', 'PENGADILAN TINGGI AGAMA JAMBI', 'Jl. H. Agus Salim Kec. Kota Baru Provinsi Jambi, Telp. 41092, Jambi 36128', 'Y', 4),
			(49,'PTA.Bdg', 'PENGADILAN TINGGI AGAMA BANDUNG', 'Jl. Soekarno Hatta No. 714 Gedebage - Bandung, Telp (022) 7810365 - Fax. (022) 7810349 Bandung', 'Y', 4),
			(50,'PTA.Smg', 'PENGADILAN TINGGI AGAMA SEMARANG', 'Jl. Hanoman No. 18, Telp. 7603866 - 7600803, Semarang 50146', 'Y', 4),
			(51,'PTA.Sby', 'PENGADILAN TINGGI AGAMA SURABAYA', 'Jl. Mayjen Sungkono No. 7 Po. Box. 3, Telp. 5681797, Surabaya 60225', 'Y', 4),
			(52,'PTA.Ptk', 'PENGADILAN TINGGI AGAMA PONTIANAK', 'Jalan Jenderal Ahmad Yani No. 252 Pontianak - 78062', 'Y', 4),
			(53,'PTA.Bjm', 'PENGADILAN TINGGI AGAMA BANJARMASIN', 'JI. Jend. Gatot Subroto No. 8, Telp. 252319 - Fax. 253742, Banjarmasin 70235', 'Y', 4),
			(54,'PTA.PIk', 'PENGADILAN TINGGI AGAMA PALANGKARAYA', 'JI. Cilik Riwut Km. 4,5, Palangkaraya 73112 Kalimantan Tengah', 'Y', 4),
			(55,'PTA.Smd', 'PENGADILAN TINGGI AGAMA SAMARINDA', 'Jl. Letjen MT. Haryono No. 24, Telp. 733337, Samarinda 75126', 'Y', 4),
			(56,'PTA.BB', 'PENGADILAN TINGGI AGAMA KEPULAUAN BANGKA BELITUNG', 'Jl. Pulau Bangka Komplek Perkantoran Pemerintah Provinsi Kepulauan Bangka Belitung, Kelurahan Air Itam', 'Y', 4),
			(57,'PTA.Bdl', 'PENGADILAN TINGGI AGAMA BANDAR LAMPUNG', 'Jl. Basuki Rahmat No. 24 - Teluk Betung Utara - Bandar Lampung - Lampung - 35215', 'Y', 4),
			(58,'PTA.AB', 'PENGADILAN TINGGI AGAMA AMBON', 'Jl.. Jend. Sudirman, Batu Merah Atas, Telp./Fax. 355296, 341171, Ambon 97128', 'Y', 4),
			(59,'PTA.MU', 'PENGADILAN TINGGI AGAMA MALUKU UTARA', 'Jalan Raya 40 Sofifi', 'Y', 4),
			(60,'MS.Aceh', 'MAHKAMAH SYARIYAH ACEH', 'Jln. T. Nyak Arief - Komplek Keistimewaan Aceh Banda Aceh 23242', 'Y', 4),
			(61,'PTA.Mtr', 'PENGADILAN TINGGI AGAMA MATARAM', 'JI. Majapahit - Mataram - 83126', 'Y', 4),
			(62,'PTA.Kp', 'PENGADILAN TINGGI AGAMA KUPANG', 'Jl. Perintis Kemerdekaan, Telp. 827611, Kupang, NTT 85225', 'Y', 4),
			(63,'PTA.Pbr', 'PENGADILAN TINGGI AGAMA PEKANBARU', 'Jl. Jend. Sudirman No. 198, Telp. 32548, Fax. 26624, Pekanbaru 28282', 'Y', 4),
			(64,'PTA.Mks', 'PENGADILAN TINGGI AGAMA MAKASSAR', 'Jl. A.P. Petta Rani No. 66, Telp. 452653, Fax. 449146 Makassar 90231', 'Y', 4),
			(65,'PTA.Pal', 'PENGADILAN TINGGI AGAMA PALU', 'Jl.. Prof. Moh. Yamin No. 36, Telp. 487285 -Fax. 487284, P a l u 94111', 'Y', 4),
			(66,'PTA.Kdi', 'PENGADILAN TINGGI AGAMA KENDARI', 'Jl. Wulele No. 8 Kendari Samping Asrama Haji Sulawesi Tenggara Telp (0401) 3194475 Fax (0401) 3196322 Kendari 93117', 'Y', 4),
			(67,'PTA.Mdo', 'PENGADILAN TINGGI AGAMA MANADO', 'Jl. 17 Agustus No.46 A, Po. Box. 1241,  Manado 95012', 'Y', 4),
			(68,'PTA.Pdg', 'PENGADILAN TINGGI AGAMA PADANG', 'Jl. Prof.Dr. Hamka Lanud Tabing Padang', 'Y', 4),
			(69,'PTA.Plg', 'PENGADILAN TINGGI AGAMA PALEMBANG', 'Jl. Jend. Sudirman 43 Km. 3.5,  Telp. 351170 - 367718, Palembang 30126', 'Y', 4),
			(70,'PTA.Mdn', 'PENGADILAN TINGGI AGAMA MEDAN', 'Jl. Kapt. Sumarsono No. 12, Telp. 8457461, Fax. 8457461, Medan 20124', 'Y', 4);");
		
		$sql = "DROP TABLE IF EXISTS perkara_eksekusi_ht;";
		$this->patching->exe_script($sql);

		$sql = "CREATE TABLE perkara_eksekusi_ht (
					ht_id BIGINT(20) UNSIGNED NOT NULL,
					alur_perkara_id INT(11) UNSIGNED NOT NULL,
					nomor_perkara_pn VARCHAR(50) NULL,
					putusan_pn DATE DEFAULT NULL,
					nomor_perkara_banding VARCHAR(50) DEFAULT NULL,
					putusan_banding DATE DEFAULT NULL,
					nomor_perkara_kasasi VARCHAR(50) DEFAULT NULL,
					putusan_kasasi DATE DEFAULT NULL,
					nomor_perkara_pk VARCHAR(50) DEFAULT NULL,
					putusan_pk DATE DEFAULT NULL,
					eksekusi_putusan SMALLINT DEFAULT NULL,
					nomor_urut_perkara_eksekusi INT(11) NULL,
					eksekusi_nomor_perkara VARCHAR(50) DEFAULT NULL,
					eksekusi_amar_putusan TEXT,
					pihak_pemohon_eksekusi INT(11) DEFAULT NULL,
					permohonan_eksekusi DATE DEFAULT NULL,
					pemohon_eksekusi VARCHAR(1000) DEFAULT NULL,
					para_pihak VARCHAR(2000) DEFAULT NULL,
					penetapan_teguran_eksekusi DATE DEFAULT NULL,
					nomor_penetapan_teguran_eksekusi VARCHAR(50) DEFAULT NULL,
					pelaksanaan_teguran_eksekusi DATE DEFAULT NULL,
					penetapan_sita_eksekusi DATE DEFAULT NULL,
					nomor_penetapan_sita_eksekusi VARCHAR(50),
					pelaksanaan_sita_eksekusi DATE DEFAULT NULL,
					jurusita_id VARCHAR(50) DEFAULT NULL,
					jurusita_nama VARCHAR(500) DEFAULT NULL,
					penetapan_perintah_eksekusi_lelang DATE DEFAULT NULL,
					pelaksanaan_eksekusi_lelang DATE DEFAULT NULL,
					penyerahan_hasil_lelang DATE DEFAULT NULL,
					penetapan_perintah_eksekusi_rill DATE DEFAULT NULL,
					pelaksanaan_eksekusi_rill DATE DEFAULT NULL,
					penetapan_noneksekusi DATE DEFAULT NULL,
					alasan_eksekusi TEXT,
					catatan_eksekusi TEXT,
					prodeo_eksekusi TINYINT(1) DEFAULT '0',
					status_eksekusi_id INT(11) DEFAULT NULL,
					status_eksekusi_text VARCHAR(100) DEFAULT NULL,
					jenis_ht_id TINYINT(1) DEFAULT NULL,
					jenis_ht_text VARCHAR(250) DEFAULT NULL,
					tgl_sertifikat DATE DEFAULT NULL,
					no_sertifikat VARCHAR(250) DEFAULT NULL,
					diedit_oleh VARCHAR(30) DEFAULT NULL,
					diedit_tanggal DATETIME DEFAULT NULL,
					diinput_oleh VARCHAR(30) DEFAULT NULL,
					diinput_tanggal DATETIME DEFAULT NULL,
					diperbaharui_oleh VARCHAR(30) DEFAULT NULL,
					diperbaharui_tanggal DATETIME DEFAULT NULL,
					PRIMARY KEY (ht_id)
				) ENGINE=INNODB;";
		$this->patching->exe_script($sql);

		$sql = "ALTER TABLE perkara_eksekusi_ht   
				CHANGE eksekusi_putusan eksekusi_putusan SMALLINT DEFAULT NULL COMMENT 'Putusan yang dimohonkan eksekusi: 10=pn,20=Banding,30=Kasasi,40=PK',
				CHANGE prodeo_eksekusi prodeo_eksekusi TINYINT(1) DEFAULT '0' COMMENT 'Status Prodeo Eksekusi: 0=Tidak,1=Ya',
				CHANGE jenis_ht_id jenis_ht_id TINYINT(1) DEFAULT NULL COMMENT '1=HT,2=Hipotek,3=Fidusia';";
		$this->patching->exe_script($sql);


		$sql = "DROP TABLE IF EXISTS perkara_eksekusi_detil_ht;";
		$this->patching->exe_script($sql);

		$sql = "CREATE TABLE perkara_eksekusi_detil_ht (
				id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
				ht_id BIGINT(20) UNSIGNED NOT NULL,
				alur_perkara_id INT(11) UNSIGNED NOT NULL,
				status_pihak_id INT(11) DEFAULT NULL,
				status_pihak_text VARCHAR(100) DEFAULT NULL,
				permohonan_eksekusi DATE DEFAULT NULL,
				pihak_asal TINYINT(1) DEFAULT NULL,
				pihak_asal_text VARCHAR(50) DEFAULT NULL,
				pihak_id BIGINT(20) UNSIGNED DEFAULT NULL,
				pihak_nama VARCHAR(1000) DEFAULT NULL,
				pihak_diwakili CHAR(1) DEFAULT NULL,
				pemohon_id BIGINT(20) UNSIGNED DEFAULT NULL,
				pemohon_nama VARCHAR(1000) DEFAULT NULL,
				pemohon_pekerjaan VARCHAR(100) DEFAULT NULL,
				pemohon_alamat VARCHAR(500) DEFAULT NULL,
				pemohon_tanggal_surat DATE DEFAULT NULL,
				pemohon_nomor_surat VARCHAR(50) DEFAULT NULL,
				pemohon_eksekusi VARCHAR(1000) DEFAULT NULL,
				pemberitahuan_putusan_pn DATE DEFAULT NULL,
				pemberitahuan_putusan_banding DATE DEFAULT NULL,
				pemberitahuan_putusan_kasasi DATE DEFAULT NULL,
				pemberitahuan_putusan_pk DATE DEFAULT NULL,
				diedit_oleh VARCHAR(30) DEFAULT NULL,
				diedit_tanggal DATETIME DEFAULT NULL,
				diinput_oleh VARCHAR(30) DEFAULT NULL,
				diinput_tanggal DATETIME DEFAULT NULL,
				diperbaharui_oleh VARCHAR(30) DEFAULT NULL,
				diperbaharui_tanggal DATETIME DEFAULT NULL,
				PRIMARY KEY (id),
				KEY ht_id (ht_id)
			) ENGINE=INNODB;";
		$this->patching->exe_script($sql);


		$sql = "DROP TABLE IF EXISTS perkara_biaya_ht;";
		$this->patching->exe_script($sql);

		$sql = "CREATE TABLE perkara_biaya_ht (
					id INT(11) UNSIGNED NOT NULL,
					id_pembiayaan TINYINT(1) DEFAULT '1',
					ht_id BIGINT(20) UNSIGNED DEFAULT NULL,
					tahapan_id INT(11) UNSIGNED DEFAULT NULL,
					kategori_id INT(11) UNSIGNED DEFAULT NULL,
					jenis_biaya_id INT(11) UNSIGNED DEFAULT NULL,
					urutan INT(11) DEFAULT NULL,
					jenis_transaksi TINYINT(1) NOT NULL,
					tanggal_transaksi DATE NOT NULL,
					uraian VARCHAR(500)NOT NULL DEFAULT '',
					jumlah FLOAT(16,2) UNSIGNED NOT NULL,
					sisa FLOAT(16,2) UNSIGNED DEFAULT NULL,
					keterangan VARCHAR(500) ,
					diedit_oleh VARCHAR(30) DEFAULT NULL,
					diedit_tanggal DATETIME DEFAULT NULL,
					diinput_oleh VARCHAR(30) DEFAULT NULL,
					diinput_tanggal DATETIME DEFAULT NULL,
					diperbaharui_oleh VARCHAR(30) DEFAULT NULL,
					diperbaharui_tanggal DATETIME DEFAULT NULL,
					PRIMARY KEY (id),
					KEY jenis_biaya_id (jenis_biaya_id),
					KEY jumlah (jumlah),
					KEY urutan (urutan),
					KEY tahapan_id (tahapan_id),
					KEY kategori_id (kategori_id),
					KEY ht_id (ht_id),
					CONSTRAINT ht_id FOREIGN KEY (ht_id) REFERENCES perkara_eksekusi_ht (ht_id) ON DELETE CASCADE
			) ENGINE=INNODB;";
		$this->patching->exe_script($sql);

		$sql = "ALTER TABLE perkara_biaya_ht   
				CHANGE id_pembiayaan id_pembiayaan TINYINT(1) DEFAULT '1' COMMENT '1:reguler,2:Prodeo DIPA,3:Prodeo Murni';";
		$this->patching->exe_script($sql);


		$sql = "DROP VIEW IF EXISTS v_perkara_eksekusi_ht;";
		$this->patching->exe_script($sql);

		$sql = "CREATE VIEW v_perkara_eksekusi_ht AS 
				SELECT
					pe.ht_id                              AS ht_id,
					pe.alur_perkara_id                    AS alur_perkara_id,
					pe.nomor_perkara_pn                   AS nomor_perkara_pn,
					pe.eksekusi_nomor_perkara             AS eksekusi_nomor_perkara,
					CONCAT('-',GROUP_CONCAT(IF(status_pihak_id=1, pihak_nama, NULL) SEPARATOR '<br/>-')) AS pemohon_eksekusi,
					pe.permohonan_eksekusi                AS permohonan_eksekusi,
					pe.penetapan_teguran_eksekusi         AS penetapan_teguran_eksekusi,
					pe.nomor_penetapan_teguran_eksekusi   AS nomor_penetapan_teguran_eksekusi,
					pe.pelaksanaan_teguran_eksekusi       AS pelaksanaan_teguran_eksekusi,
					pe.penetapan_sita_eksekusi            AS penetapan_sita_eksekusi,
					pe.nomor_penetapan_sita_eksekusi      AS nomor_penetapan_sita_eksekusi,
					pe.pelaksanaan_sita_eksekusi          AS pelaksanaan_sita_eksekusi,
					pe.jurusita_id                        AS jurusita_id,
					pe.jurusita_nama                      AS jurusita_nama,
					pe.penetapan_perintah_eksekusi_lelang AS penetapan_perintah_eksekusi_lelang,
					pe.pelaksanaan_eksekusi_lelang        AS pelaksanaan_eksekusi_lelang,
					pe.penyerahan_hasil_lelang            AS penyerahan_hasil_lelang,
					pe.penetapan_perintah_eksekusi_rill   AS penetapan_perintah_eksekusi_rill,
					pe.pelaksanaan_eksekusi_rill          AS pelaksanaan_eksekusi_rill,
					pe.penetapan_noneksekusi              AS penetapan_noneksekusi,
					pe.nomor_urut_perkara_eksekusi		  AS nomor_urut_perkara_eksekusi,
					pe.alasan_eksekusi                    AS alasan_eksekusi,
					pe.catatan_eksekusi                   AS catatan_eksekusi,
					pe.prodeo_eksekusi                    AS prodeo_eksekusi,
					pe.status_eksekusi_id                 AS status_eksekusi_id,
					pe.status_eksekusi_text               AS status_eksekusi_text
				FROM perkara_eksekusi_ht AS pe
				LEFT JOIN perkara_eksekusi_detil_ht AS ped ON pe.ht_id=ped.ht_id 
				GROUP BY pe.ht_id;";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS v_sum_perkara_biaya_ht;";
		$this->patching->exe_script($sql);

		$sql = "CREATE VIEW v_sum_perkara_biaya_ht AS 
				SELECT
					perkara_biaya_ht.ht_id AS ht_id,
					perkara_biaya_ht.tahapan_id AS tahapan_id,
					SUM((CASE WHEN (perkara_biaya_ht.jenis_transaksi = 1) THEN perkara_biaya_ht.jumlah ELSE 0 END)) AS pemasukan,
					SUM((CASE WHEN (perkara_biaya_ht.jenis_transaksi = -(1)) THEN perkara_biaya_ht.jumlah ELSE 0 END)) AS pengeluaran
				FROM perkara_biaya_ht
				GROUP BY perkara_biaya_ht.ht_id,perkara_biaya_ht.tahapan_id;";
		$this->patching->exe_script($sql);


		$sql = "DROP TABLE IF EXISTS perkara_jadwal_mediasi;";
		$this->patching->exe_script($sql);

		$sql = "CREATE TABLE perkara_jadwal_mediasi (
					id bigint(20) unsigned NOT NULL,
					mediasi_id bigint(20) NOT NULL,
					urutan int(11) unsigned NOT NULL DEFAULT '1',
					tanggal_mediasi date NOT NULL,
					tempat varchar(500) DEFAULT NULL,
					ditunda char(1) DEFAULT 'T',
					diedit_oleh varchar(30) DEFAULT NULL,
					diedit_tanggal datetime DEFAULT NULL,
					diinput_oleh varchar(30) DEFAULT NULL,
					diinput_tanggal datetime DEFAULT NULL,
					diperbaharui_oleh varchar(30) DEFAULT NULL,
					diperbaharui_tanggal datetime DEFAULT NULL,
					PRIMARY KEY (id),
					KEY perkara_id (mediasi_id),
					KEY tanggal_sidang (tanggal_mediasi),
					CONSTRAINT mediasi_jadwal FOREIGN KEY (mediasi_id) REFERENCES perkara_mediasi (mediasi_id) ON DELETE CASCADE
				) ENGINE=InnoDB;";
		$this->patching->exe_script($sql);


		$sql = "DROP TABLE IF EXISTS perkara_keberatan;";
		$this->patching->exe_script($sql);

		$sql = "CREATE TABLE perkara_keberatan (
					perkara_id bigint(20) unsigned NOT NULL,
					tanggal_pendaftaran_keberatan date DEFAULT NULL,
					pemohon_keberatan varchar(500) DEFAULT NULL,
					penetapan_majelis_hakim date DEFAULT NULL,
					majelis_hakim_id varchar(50) DEFAULT NULL,
					majelis_hakim_nama varchar(500) DEFAULT NULL,
					majelis_hakim_text varchar(500) DEFAULT NULL,
					penetapan_panitera_pengganti date DEFAULT NULL,
					panitera_pengganti_id varchar(50) DEFAULT NULL,
					panitera_pengganti_text varchar(500) DEFAULT NULL,
					penetapan_jurusita date DEFAULT NULL,
					jurusita_id varchar(50) DEFAULT NULL,
					jurusita_text varchar(500) DEFAULT NULL,
					sidang_id bigint(20) DEFAULT NULL,
					tanggal_penetapan_sidang_keberatan date DEFAULT NULL,
					tanggal_sidang_pertama_keberatan date DEFAULT NULL,
					putusan_keberatan date DEFAULT NULL,
					status_putusan_keberatan_id int(11) unsigned DEFAULT NULL,
					status_putusan_keberatan_text varchar(50) DEFAULT NULL,
					amar_putusan_keberatan text,
					amar_putusan_keberatan_dok varchar(250) DEFAULT NULL,
					pemberitahuan_putusan varchar(10) DEFAULT 'Langsung',
					pemberitahuan_putusan_keberatan date DEFAULT NULL,
					pemberitahuan_putusan_keberatan_pihak1 date DEFAULT NULL,
					pemberitahuan_putusan_keberatan_pihak2 date DEFAULT NULL,
					penerimaan_memori date DEFAULT NULL,
					penyerahan_memori date DEFAULT NULL,
					penerimaan_kontra_memori date DEFAULT NULL,
					penyerahan_kontra_memori date DEFAULT NULL,
					inzage_pihak1 date DEFAULT NULL,
					inzage_pihak2 date DEFAULT NULL,
					catatan_putusan_keberatan text,
					diedit_oleh varchar(30) DEFAULT NULL,
					diedit_tanggal datetime DEFAULT NULL,
					diinput_oleh varchar(30) DEFAULT NULL,
					diinput_tanggal datetime DEFAULT NULL,
					diperbaharui_oleh varchar(30) DEFAULT NULL,
					diperbaharui_tanggal datetime DEFAULT NULL,
					PRIMARY KEY (perkara_id)
				) ENGINE=InnoDB;";
		$this->patching->exe_script($sql);

		$sql = "ALTER TABLE perkara_keberatan   
				CHANGE pemohon_keberatan pemohon_keberatan varchar(500) DEFAULT NULL COMMENT 'Pihak Pemohon Keberatan 1=Penggugat, 2=Tergugat',
				CHANGE sidang_id sidang_id bigint(20) DEFAULT NULL COMMENT 'Merujuk ke ID pada Table Perkara_jadwal_sidang',
				CHANGE pemberitahuan_putusan pemberitahuan_putusan varchar(10) DEFAULT 'Langsung' COMMENT 'Langsung, Kelurahan, Media_Masa';";
		$this->patching->exe_script($sql);

		$isThere = $this->patching->isColumnExist('perkara_biaya','pihak_id');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_biaya  
					ADD COLUMN pihak_id BIGINT NULL COMMENT 'ID Pihak pembayar' AFTER jenis_biaya_id,
					ADD COLUMN pihak_ke INT NULL  COMMENT 'Pihak Pembayar ke (1=Penggugat, 2=Tergugat)' AFTER pihak_id,
					CHANGE urutan urutan INT(11) UNSIGNED NULL;";
			$this->patching->exe_script($sql);
		}

		$sql = "UPDATE proses_alur_perkara SET reminder=0 WHERE  id=1329;";
		$this->patching->exe_script($sql);

		$sql = "UPDATE jenis_perkara SET nama_lengkap ='Perlindungan Anak' WHERE id = 248;";
		$this->patching->exe_script($sql);

		


		$isThere = $this->patching->isColumnExist('perkara_banding','hakim1_banding_id');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_banding  
					ADD COLUMN hakim1_banding_id BIGINT NULL AFTER nomor_perkara_banding,
					ADD COLUMN hakim2_banding_id BIGINT NULL AFTER hakim1_banding,
					ADD COLUMN hakim3_banding_id BIGINT NULL AFTER hakim2_banding,
					ADD COLUMN hakim4_banding_id BIGINT NULL AFTER hakim3_banding,
					ADD COLUMN hakim5_banding_id BIGINT NULL AFTER hakim4_banding,
					ADD COLUMN panitera_pengganti_banding_id BIGINT NULL AFTER majelis_hakim_banding;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_kasasi','hakim1_kasasi_id');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_kasasi  
					ADD COLUMN hakim1_kasasi_id BIGINT NULL AFTER nomor_perkara_kasasi,
					ADD COLUMN hakim2_kasasi_id BIGINT NULL AFTER hakim1_kasasi,
					ADD COLUMN hakim3_kasasi_id BIGINT NULL AFTER hakim2_kasasi,
					ADD COLUMN hakim4_kasasi_id BIGINT NULL AFTER hakim3_kasasi,
					ADD COLUMN hakim5_kasasi_id BIGINT NULL AFTER hakim4_kasasi,
					ADD COLUMN panitera_pengganti_kasasi_id BIGINT NULL AFTER majelis_hakim_kasasi;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_pk','hakim1_pk_id');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_pk  
					ADD COLUMN hakim1_pk_id BIGINT NULL AFTER nomor_perkara_pk,
					ADD COLUMN hakim2_pk_id BIGINT NULL AFTER hakim1_pk,
					ADD COLUMN hakim3_pk_id BIGINT NULL AFTER hakim2_pk,
					ADD COLUMN hakim4_pk_id BIGINT NULL AFTER hakim3_pk,
					ADD COLUMN hakim5_pk_id BIGINT NULL AFTER hakim4_pk,
					ADD COLUMN panitera_pengganti_pk_id BIGINT NULL AFTER majelis_hakim_pk;";
			$this->patching->exe_script($sql);
		}

		$sql = "DELETE FROM perkara_putusan_pemberitahuan_putusan WHERE perkara_id NOT IN (SELECT perkara_id FROM perkara_putusan);";
		$this->patching->exe_script($sql);

			$isThere = $this->patching->isKeyExist('perkara_putusan_pemberitahuan_putusan','constraint_fk');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_putusan_pemberitahuan_putusan 
				ADD CONSTRAINT constraint_fk FOREIGN KEY (perkara_id) REFERENCES perkara_putusan(perkara_id) ON DELETE CASCADE;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_hakim_pn','tahapan_id');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_hakim_pn   
							ADD COLUMN tahapan_id TINYINT DEFAULT 10  NOT NULL  COMMENT 'Mengacu ke Table Tahapan' AFTER perkara_id;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_panitera_pn','tahapan_id');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_panitera_pn   
							ADD COLUMN tahapan_id TINYINT DEFAULT 10  NOT NULL  COMMENT 'Mengacu ke Table Tahapan' AFTER perkara_id;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_jurusita','tahapan_id');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_jurusita   
							ADD COLUMN tahapan_id TINYINT DEFAULT 10  NOT NULL  COMMENT 'Mengacu ke Table Tahapan' AFTER perkara_id;";
			$this->patching->exe_script($sql);
		}

		$sql = "DROP TABLE IF EXISTS perkara_keberatan_detil;";
		$this->patching->exe_script($sql);

		$sql = "CREATE TABLE perkara_keberatan_detil (
					perkara_id bigint(20) unsigned NOT NULL,
					pihak_id bigint(20) unsigned NOT NULL,
					tanggal_permohonan date DEFAULT NULL,
					urutan_keberatan TINYINT(4) NOT NULL,
					status_pihak_id TINYINT(4) NOT NULL,
					status_pihak_text VARCHAR(50) NOT NULL,
					pihak_asal TINYINT(4) NOT NULL,
					pihak_asal_text VARCHAR(10) NOT NULL,
					nama varchar(255) DEFAULT NULL,
					alamat varchar(255) NOT NULL,
					penerimaan_memori_banding date DEFAULT NULL,
					penyerahan_memori_banding date DEFAULT NULL,
					penerimaan_kontra_banding date DEFAULT NULL,
					penyerahan_kontra_banding date DEFAULT NULL,
					diinput_oleh varchar(30) DEFAULT NULL,
					diinput_tanggal datetime DEFAULT NULL,
					diperbaharui_oleh varchar(30) DEFAULT NULL,
					diperbaharui_tanggal datetime DEFAULT NULL,
					PRIMARY KEY (perkara_id,pihak_id),
					CONSTRAINT constraint_fk_keberatan FOREIGN KEY (perkara_id) REFERENCES perkara_keberatan(perkara_id) ON DELETE CASCADE
				) ENGINE=InnoDB;";
		$this->patching->exe_script($sql);
		
		

			$sql = "ALTER TABLE perkara_keberatan_detil
					CHANGE status_pihak_id status_pihak_id TINYINT(4) NOT NULL  COMMENT '1.Pemohon; 2.Pemohon/Termohon; 3.Termohon; 4.Termohon/Pemohon; 5.Turut Termohon;';";
		$this->patching->exe_script($sql);

		$sql = "REPLACE INTO proses (id, tahapan_id, kode, nama, keterangan, nama_tabel, nama_kolom, status) VALUES 
				 (283,17,283, 'Penunjukan Panitera Pengganti Keberatan', 'Penunjukan Panitera Pengganti Keberatan', 'perkara_keberatan', 'penetapan_panitera_pengganti', 'Penunjukan Panitera Pengganti Keberatan')
				,(284,17,284, 'Penunjukan Juru Sita Keberatan', 'Penunjukan Juru Sita Keberatan', 'perkara_keberatan', 'penetapan_jurusita', 'Penunjukan Juru Sita Keberatan')
				,(285,17,285, 'Penetapan Jadwal Sidang Pertama Keberatan', 'Penetapan Jadwal Sidang Pertama Keberatan', 'perkara_keberatan', 'tanggal_penetapan_sidang_keberatan', 'Penetapan Jadwal Sidang Pertama Keberatan') 
				,(286,17,286, 'Sidang Pertama Keberatan', 'Sidang Pertama Keberatan', 'perkara_keberatan', 'tanggal_sidang_pertama_keberatan', 'Sidang Pertama Keberatan')
				,(288,17,288, 'Putusan Keberatan', 'Putusan Keberatan', 'perkara_keberatan', 'putusan_keberatan', 'Putusan Keberatan')
				,(289,17,289, 'Pemberitahuan Putusan Keberatan', 'Pemberitahuan Putusan Keberatan', 'perkara_keberatan', 'pemberitahuan_putusan_keberatan', 'Pemberitahuan Putusan Keberatan')
				,(214,15,214, 'Dismissal', 'Dismissal', NULL, NULL, NULL)
				,(287,17,287, 'Persidangan Keberatan', 'Persidangan Keberatan', NULL,NULL,NULL)
				,(42,17,42, 'Pemeriksaan Persiapan', 'Pemeriksaan Persiapan', NULL,NULL,NULL);";
		$this->patching->exe_script($sql);
 

		
		$sql = "UPDATE proses SET tahapan_id = 17 ,nama = 'Pendaftaran Keberatan' ,keterangan = 'Pendaftaran Keberatan' ,nama_tabel = 'perkara_keberatan' ,nama_kolom = 'tanggal_pendaftaran_keberatan' ,status = 'Permohonan Keberatan' ,aktif = 'Y' ,diedit_oleh = NULL ,diedit_tanggal = NULL ,diperbaharui_tanggal = NULL WHERE id = '281';";
		$this->patching->exe_script($sql);

		$sql = "UPDATE proses SET tahapan_id = 17 ,nama = 'Penetapan Majelis Hakim Keberatan' ,keterangan = 'Penetapan Majelis Hakim Keberatan' ,nama_tabel = 'perkara_keberatan' ,nama_kolom = 'penetapan_majelis_hakim' ,status = 'Penetapan Majelis Hakim Keberatan' ,aktif = 'Y',diedit_oleh = NULL ,diedit_tanggal = NULL ,diperbaharui_tanggal = NULL WHERE id = '282';";
		$this->patching->exe_script($sql);


		$sql = "DROP VIEW IF EXISTS v_perkara_list;";
		$this->patching->exe_script($sql);

		$sql = "CREATE VIEW v_perkara_list AS 
				SELECT
				  perkara.perkara_id                             AS perkara_id,
				  perkara.alur_perkara_id                        AS alur_perkara_id,
				  perkara.tanggal_pendaftaran                    AS tanggal_pendaftaran,
				  perkara.jenis_perkara_id                       AS jenis_perkara_id,
				  perkara.jenis_perkara_kode                     AS jenis_perkara_kode,
				  perkara.jenis_perkara_nama                     AS jenis_perkara_nama,
				  perkara.jenis_perkara_text                     AS jenis_perkara_text,
				  perkara.nomor_urut_register                    AS nomor_urut_register,
				  perkara.nomor_urut_perkara                     AS nomor_urut_perkara,
				  perkara.nomor_perkara                          AS nomor_perkara,
				  perkara.nomor_indeks                           AS nomor_indeks,
				  perkara.pihak1_text                            AS pihak1_text,
				  perkara.pengacara_pihak1                       AS pengacara_pihak1,
				  perkara.pihak2_text                            AS pihak2_text,
				  perkara.pengacara_pihak2                       AS pengacara_pihak2,
				  perkara.pihak3_text                            AS pihak3_text,
				  perkara.pengacara_pihak3                       AS pengacara_pihak3,
				  perkara.para_pihak                             AS para_pihak,
				  perkara.pihak_dipublikasikan                   AS pihak_dipublikasikan,
				  perkara.tahapan_terakhir_id                    AS tahapan_terakhir_id,
				  perkara.tahapan_terakhir_text                  AS tahapan_terakhir_text,
				  perkara.proses_terakhir_id                     AS proses_terakhir_id,
				  perkara.proses_terakhir_text                   AS proses_terakhir_text,
				  perkara_penetapan.penetapan_majelis_hakim      AS penetapan_majelis_hakim,
				  perkara_penetapan.majelis_hakim_id             AS majelis_hakim_id,
				  perkara_penetapan.majelis_hakim_kode           AS majelis_hakim_kode,
				  perkara_penetapan.majelis_hakim_nama           AS majelis_hakim_nama,
				  perkara_penetapan.majelis_hakim_text           AS majelis_hakim_text,
				  perkara_penetapan.penetapan_panitera_pengganti AS penetapan_panitera_pengganti,
				  perkara_penetapan.panitera_pengganti_id        AS panitera_pengganti_id,
				  perkara_penetapan.panitera_pengganti_text      AS panitera_pengganti_text,
				  perkara_penetapan.penetapan_jurusita           AS penetapan_jurusita,
				  perkara_penetapan.jurusita_id                  AS jurusita_id,
				  perkara_penetapan.jurusita_text                AS jurusita_text,
				  perkara_penetapan.penetapan_hari_sidang        AS penetapan_hari_sidang,
				  perkara_penetapan.sidang_pertama               AS sidang_pertama,
				  perkara_mediasi.penetapan_penunjukan_mediator  AS penetapan_penunjukan_mediator,
				  perkara_mediasi.mediator_id                    AS mediator_id,
				  perkara_mediasi.status_mediator                AS status_mediator,
				  perkara_mediasi.mediator_text                  AS mediator_text,
				  perkara_mediasi.penetapan_tanggal_mediasi      AS penetapan_tanggal_mediasi,
				  perkara_mediasi.dimulai_mediasi                AS dimulai_mediasi,
				  perkara_mediasi.keputusan_mediasi              AS keputusan_mediasi,
				  perkara_mediasi.hasil_mediasi                  AS hasil_mediasi,
				  perkara_mediasi.mediasi_berhasil               AS mediasi_berhasil,
				  perkara_mediasi.mediasi_gagal                  AS mediasi_gagal,
				  perkara_putusan.tanggal_putusan                AS tanggal_putusan,
				  perkara_putusan.putusan_verstek                AS putusan_verstek,
				  perkara_putusan.sumber_hukum_id                AS sumber_hukum_id,
				  perkara_putusan.status_putusan_id              AS status_putusan_id,
				  perkara_putusan.status_putusan_kode            AS status_putusan_kode,
				  perkara_putusan.status_putusan_nama            AS status_putusan_nama,
				  perkara_putusan.status_putusan_text            AS status_putusan_text,
				  perkara_putusan.tanggal_minutasi               AS tanggal_minutasi,
				  perkara.prodeo                                 AS prodeo,
				  perkara.terdakwa_anak                          AS terdakwa_anak,
				  perkara_keberatan.majelis_hakim_id             AS majelis_hakim_id_keberatan,
				  perkara_keberatan.majelis_hakim_nama           AS majelis_hakim_nama_keberatan,
				  perkara_keberatan.majelis_hakim_text           AS majelis_hakim_text_keberatan,
				  perkara_keberatan.penetapan_panitera_pengganti AS penetapan_panitera_pengganti_keberatan,
				  perkara_keberatan.panitera_pengganti_id        AS panitera_pengganti_id_keberatan,
				  perkara_keberatan.panitera_pengganti_text      AS panitera_pengganti_text_keberatan,
				  perkara_keberatan.penetapan_jurusita           AS penetapan_jurusita_keberatan,
				  perkara_keberatan.jurusita_id                  AS jurusita_id_keberatan,
				  perkara_keberatan.jurusita_text                AS jurusita_text_keberatan,
				  perkara_verzet.majelis_hakim_id                AS majelis_hakim_id_verzet,
				  perkara_verzet.panitera_pengganti_id           AS panitera_pengganti_id_verzet,
				  perkara_verzet.jurusita_id                     AS jurusita_id_verzet
				FROM ((((perkara
				      LEFT JOIN perkara_penetapan
				        ON ((perkara.perkara_id = perkara_penetapan.perkara_id)))
				     LEFT JOIN perkara_mediasi
				       ON ((perkara.perkara_id = perkara_mediasi.perkara_id)))
				    LEFT JOIN perkara_putusan
				      ON ((perkara.perkara_id = perkara_putusan.perkara_id)))
				   LEFT JOIN perkara_keberatan
				     ON ((perkara.perkara_id = perkara_keberatan.perkara_id))
				   LEFT JOIN perkara_verzet
				     ON ((perkara.perkara_id = perkara_verzet.perkara_id)))";
		$this->patching->exe_script($sql);
		
		#$this->dbforge->drop_table('perkara_putusan_terdakwa_copy',TRUE);

		$sql = "ALTER TABLE perkara_proses CHANGE urutan urutan TINYINT(4) NOT NULL DEFAULT '0',
					DROP PRIMARY KEY,
					ADD PRIMARY KEY (perkara_id, proses_id, urutan);";
		$this->patching->exe_script($sql);
		
		$isThere = $this->patching->isColumnExist('sys_config','VALUE');
		if(!empty($isThere)){
			$sql = "ALTER TABLE sys_config CHANGE VALUE `value` VARCHAR(255) NULL;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_pihak3','isi_petitum');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_pihak3 ADD COLUMN isi_petitum TEXT NULL AFTER keterangan;";
			$this->patching->exe_script($sql);
		}

		$sql = "DROP TABLE IF EXISTS perkara_rekonvensi;";
		$this->patching->exe_script($sql);

		$sql = "CREATE TABLE perkara_rekonvensi(
					perkara_id BIGINT UNSIGNED NOT NULL,
					tanggal_pendaftaran DATE,
					parapihak varchar(500) DEFAULT NULL,
					isi_petitum TEXT,
					diinput_oleh VARCHAR(30) DEFAULT NULL,
					diinput_tanggal DATETIME DEFAULT NULL,
					diperbaharui_oleh VARCHAR(30) DEFAULT NULL,
					diperbaharui_tanggal DATETIME DEFAULT NULL,
					PRIMARY KEY (perkara_id),
					CONSTRAINT perkara_rekonvensi_fk FOREIGN KEY (perkara_id) REFERENCES perkara (perkara_id) ON DELETE CASCADE
				)ENGINE=InnoDB;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS perkara_rekonvensi_detil;";
		$this->patching->exe_script($sql);

		$sql = "CREATE TABLE perkara_rekonvensi_detil (
					perkara_id BIGINT(20) UNSIGNED NOT NULL,
					pihak_id BIGINT(20) UNSIGNED NOT NULL,
					tanggal_pendaftaran DATE DEFAULT NULL,
					urutan TINYINT(4) NOT NULL,
					status_pihak_id TINYINT(4) NOT NULL,
					status_pihak_text VARCHAR(50) NOT NULL,
					pihak_asal TINYINT(4) NOT NULL,
					pihak_asal_text VARCHAR(15) NOT NULL,
					nama VARCHAR(255) DEFAULT NULL,
					alamat VARCHAR(255) NOT NULL,
					diinput_oleh VARCHAR(30) DEFAULT NULL,
					diinput_tanggal DATETIME DEFAULT NULL,
					diperbaharui_oleh VARCHAR(30) DEFAULT NULL,
					diperbaharui_tanggal DATETIME DEFAULT NULL,
					PRIMARY KEY (perkara_id,pihak_id),
					CONSTRAINT rekonven_pihak FOREIGN KEY (perkara_id) REFERENCES perkara_rekonvensi (perkara_id) ON DELETE CASCADE
				) ENGINE=InnoDB;";
		$this->patching->exe_script($sql);

		$sql = "ALTER TABLE perkara_rekonvensi_detil
			CHANGE status_pihak_id status_pihak_id TINYINT(4) NOT NULL  COMMENT '1.Penggugat; 3.Tergugat; 5.Turut Tergugat;';";
		$this->patching->exe_script($sql);

		$sql = "UPDATE tahapan_proses SET urutan = 12 WHERE id = 60;";
		$this->patching->exe_script($sql);
		$sql = "UPDATE tahapan_proses SET urutan = 11 WHERE id = 50;";
		$this->patching->exe_script($sql);
		$sql = "UPDATE tahapan_proses SET urutan = 10 WHERE id = 40;";
		$this->patching->exe_script($sql);
		$sql = "UPDATE tahapan_proses SET urutan = 9 WHERE id = 30;";
		$this->patching->exe_script($sql);
		$sql = "UPDATE tahapan_proses SET urutan = 8 WHERE id = 20;";
		$this->patching->exe_script($sql);

		$sql = "DELETE FROM perkara_pihak1 WHERE pihak_id IS NULL;";
		$this->patching->exe_script($sql);

		$sql = "DELETE FROM perkara_pihak2 WHERE pihak_id IS NULL;";
		$this->patching->exe_script($sql);

		$sql = "DELETE FROM perkara_pihak3 WHERE pihak_id IS NULL;";
		$this->patching->exe_script($sql);

		$sql = "DELETE FROM perkara_pihak4 WHERE pihak_id IS NULL;";
		$this->patching->exe_script($sql);

		$sql = "REPLACE INTO tahapan_proses(Id,kode,nama,keterangan,urutan,aktif) VALUES(17,17,'Keberatan','Keberatan',7,'Y');";
		$this->patching->exe_script($sql);

		$sql = "ALTER TABLE perkara_banding_detil
			CHANGE status_pihak_id status_pihak_id INT(11) UNSIGNED NULL  COMMENT 'Referense status_pihak';";
		$this->patching->exe_script($sql);


		$sql = "DROP TABLE IF EXISTS pihak_pembimbing_masyarakat;";
		$this->patching->exe_script($sql);

		$sql = "CREATE TABLE pihak_pembimbing_masyarakat (
					pihak_id bigint(20) unsigned NOT NULL,
					instansi varchar(250) DEFAULT NULL,
					alamat_instansi varchar(500) DEFAULT NULL,
					diedit_oleh varchar(30) DEFAULT NULL,
					diedit_tanggal datetime DEFAULT NULL,
					diinput_oleh varchar(30) DEFAULT NULL,
					diinput_tanggal datetime DEFAULT NULL,
					diperbaharui_oleh varchar(30) DEFAULT NULL,
					diperbaharui_tanggal datetime DEFAULT NULL,
					PRIMARY KEY (pihak_id)
				) ENGINE=InnoDB;";

		$this->patching->exe_script($sql);

		$sql = "DROP PROCEDURE IF EXISTS perkara_banding_proses;";
		$this->patching->exe_script($sql);

		$sql = "CREATE PROCEDURE perkara_banding_proses(
						IN var_perkara_id BIGINT,
						IN var_proses_id INTEGER(11),
						IN var_proses_nama VARCHAR(100)
				)
		BEGIN
			DECLARE old_status_id INTEGER(11);
			SELECT status_banding_id INTO old_status_id FROM perkara_banding WHERE perkara_id = var_perkara_id;
			IF var_proses_id>old_status_id THEN
				UPDATE perkara_banding SET status_banding_id=var_proses_id, status_banding_text = var_proses_nama
					WHERE perkara_id = var_perkara_id;
			END IF;
		END;";
		$this->patching->exe_script($sql);

		$sql = "DROP PROCEDURE IF EXISTS perkara_kasasi_proses;";
		$this->patching->exe_script($sql);

		$sql = "CREATE PROCEDURE perkara_kasasi_proses(
						IN var_perkara_id BIGINT,
						IN var_proses_id INTEGER(11),
						IN var_proses_nama VARCHAR(100)
				)
		BEGIN
			DECLARE old_status_id INTEGER(11);
			SELECT status_kasasi_id INTO old_status_id FROM perkara_kasasi WHERE perkara_id = var_perkara_id;
			IF var_proses_id>old_status_id THEN
				UPDATE perkara_kasasi SET status_kasasi_id=var_proses_id, status_kasasi_text = var_proses_nama
					WHERE perkara_id = var_perkara_id;
			END IF;
		END;";
		$this->patching->exe_script($sql);

		$sql = "DROP PROCEDURE IF EXISTS perkara_pk_proses;";
		$this->patching->exe_script($sql);

		$sql = "CREATE PROCEDURE perkara_pk_proses(
						IN var_perkara_id BIGINT,
						IN var_proses_id INTEGER(11),
						IN var_proses_nama VARCHAR(100)
				)
		BEGIN
			DECLARE old_status_id INTEGER(11);
			SELECT status_pk_id INTO old_status_id FROM perkara_pk WHERE perkara_id = var_perkara_id;
			IF var_proses_id>old_status_id THEN
				UPDATE perkara_pk SET status_pk_id=var_proses_id, status_pk_text = var_proses_nama
					WHERE perkara_id = var_perkara_id;
			END IF;
		END;";
		$this->patching->exe_script($sql);

		$sql = "REPLACE INTO status_pihak (alur_perkara_id,tahapan_id,pihak_ke,nama,aktif,urutan) VALUE 
					(1,10,7,'Kuasa Hukum Penggugat','Y',1)
					,(1,10,8,'Kuasa Hukum Tergugat','Y',1)
					,(1,10,9,'Kuasa Hukum Intervensi','Y',1)
					,(1,10,10,'Kuasa Hukum Turut Tergugat','Y',1)
					,(2,10,7,'Kuasa Hukum Pemohon','Y',1)
					,(2,10,8,'Kuasa Hukum Termohon','Y',1)
					,(3,10,7,'Kuasa Hukum Pemohon','Y',1)
					,(3,10,8,'Kuasa Hukum Termohon','Y',1)
					,(3,10,9,'Kuasa Hukum Turut Termohon','Y',1)
					,(4,10,7,'Kuasa Hukum Pemohon','Y',1)
					,(4,10,8,'Kuasa Hukum Termohon','Y',1)
					,(4,10,9,'Kuasa Hukum Turut Termohon','Y',1)
					,(5,10,7,'Kuasa Hukum Penggugat','Y',1)
					,(5,10,8,'Kuasa Hukum Tergugat','Y',1)
					,(5,10,9,'Kuasa Hukum Turut Tergugat','Y',1)
					,(6,10,7,'Kuasa Hukum Penggugat','Y',1)
					,(6,10,8,'Kuasa Hukum Tergugat','Y',1)
					,(6,10,9,'Kuasa Hukum Turut Tergugat','Y',1)
					,(7,10,7,'Kuasa Hukum Penggugat','Y',1)
					,(7,10,8,'Kuasa Hukum Tergugat','Y',1)
					,(7,10,9,'Kuasa Hukum Intervensi','Y',1)
					,(7,10,10,'Kuasa Hukum Turut Tergugat','Y',1)
					,(8,10,7,'Kuasa Hukum Penggugat','Y',1)
					,(8,10,8,'Kuasa Hukum Tergugat','Y',1)
					,(111,10,8,'Penasihat Hukum Terdakwa','Y',1)
					,(112,10,8,'Penasihat Hukum Terdakwa','Y',1)
					,(113,10,8,'Penasihat Hukum Terdakwa','Y',1)
					,(115,10,8,'Penasihat Hukum Terdakwa','Y',1)
					,(116,10,8,'Penasihat Hukum Terdakwa','Y',1)
					,(117,10,8,'Penasihat Hukum Terdakwa','Y',1)
					,(118,10,8,'Penasihat Hukum Anak','Y',1)
					,(119,10,7,'Kuasa Hukum Pemohon','Y',1)
					,(119,10,8,'Kuasa Hukum Termohon','Y',1),
					(15, 10, 1,  'Penggugat',  'Y', 1),
					(15, 10, 2,  'Tergugat',  'Y', 2),
					(15, 10, 3,  'Intervensi',  'Y', 3),
					(15, 10, 4,  'Turut Tergugat',  'Y', 4),
					(15, 10, 7,  'Kuasa Hukum Penggugat',  'Y', 1),
					(15, 10, 8,  'Kuasa Hukum Tergugat',  'Y', 1),
					(15, 10, 9,  'Kuasa Hukum Intervensi',  'Y', 1),
					(15, 10, 10, 'Kuasa Hukum Turut Tergugat',  'Y', 1),
					(15, 10, 13, 'Saksi',  'Y', 1),
					(15, 20, 1,  'Pembanding',  'Y', 1),
					(15, 20, 2,  'Pembanding/Terbanding',  'Y', 2),
					(15, 20, 3,  'Turut Terbanding',  'Y', 3),
					(15, 20, 4,  'Terbanding',  'Y', 4),
					(15, 20, 5,  'Terbanding/Pembanding',  'Y', 5),
					(15, 30, 1,  'Pemohon Kasasi',  'Y', 1),
					(15, 30, 2,  'Pemohon/Termohon Kasasi',  'Y', 2),
					(15, 30, 3,  'Turut Termohon Kasasi',  'Y', 3),
					(15, 30, 4,  'Termohon Kasasi',  'Y', 4),
					(15, 30, 5,  'Termohon/Pemohon Kasasi',  'Y', 5),
					(15, 40, 1,  'Pemohon PK',  'Y', 1),
					(15, 40, 2,  'Pemohon/Termohon PK',  'Y', 2),
					(15, 40, 3,  'Turut Termohon PK',  'Y', 3),
					(15, 40, 4,  'Termohon PK',  'Y', 4),
					(15, 40, 5,  'Termohon/Pemohon PK',  'Y', 5),
					(15, 50, 1,  'Pemohon',  'Y', 1),
					(15, 50, 2,  'Termohon',  'Y', 2),
					(15, 16, 1, 'Pelawan', 'Y', 1),
					(15, 16, 2, 'Terlawan', 'Y', 2),
					(16, 10, 1,  'Pemohon',  'Y', 1),
					(16, 10, 2,  'Termohon',  'Y', 2),
					(16, 10, 7,  'Kuasa Hukum Pemohon',  'Y', 1),
					(16, 10, 8,  'Kuasa Hukum Termohon',  'Y', 1),
					(16, 10, 13,  'Saksi',  'Y', 1),
					(16, 20, 1,  'Pembanding',  'Y', 1),
					(16, 20, 2,  'Pembanding/Terbanding',  'Y', 2),
					(16, 20, 3,  'Turut Terbanding',  'Y', 3),
					(16, 20, 4,  'Terbanding',  'Y', 4),
					(16, 20, 5,  'Terbanding/Pembanding',  'Y', 5),
					(16, 30, 1,  'Pemohon Kasasi',  'Y', 1),
					(16, 30, 2,  'Pemohon/Termohon Kasasi',  'Y', 2),
					(16, 30, 3,  'Turut Termohon Kasasi',  'Y', 3),
					(16, 30, 4,  'Termohon Kasasi',  'Y', 4),
					(16, 30, 5,  'Termohon/Pemohon Kasasi',  'Y', 5),
					(16, 40, 1,  'Pemohon PK',  'Y', 1),
					(16, 40, 2,  'Pemohon/Termohon PK',  'Y', 2),
					(16, 40, 3,  'Turut Termohon PK',  'Y', 5),
					(16, 40, 4,  'Termohon PK',  'Y', 3),
					(16, 40, 5,  'Termohon/Pemohon PK',  'Y', 4),
					(16, 50, 1,  'Pemohon',  'Y', 1),
					(16, 50, 2,  'Termohon',  'Y', 2);";
		$this->patching->exe_script($sql);

		$isThere = $this->patching->isColumnExist('perkara_pk','jenis_pk');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_pk ADD COLUMN jenis_pk char(1) DEFAULT '1' AFTER perkara_id;";
			$this->patching->exe_script($sql);
		}

		$sql = "DELETE FROM perkara_putusan_pemberitahuan_putusan WHERE pihak =1 AND (pihak_id, perkara_id) NOT IN (SELECT id,perkara_id FROM perkara_pihak1);";
		$this->patching->exe_script($sql);

		$sql = "DELETE FROM perkara_putusan_pemberitahuan_putusan WHERE pihak =2 AND (pihak_id, perkara_id) NOT IN (SELECT id,perkara_id FROM perkara_pihak2);";
		$this->patching->exe_script($sql);

		$sql = "UPDATE proses_alur_perkara SET id = '17' WHERE alur_perkara_id = '1' AND tahapan_id = '14' AND proses_id = '200'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '23' WHERE alur_perkara_id = '1' AND tahapan_id = '16' AND proses_id = '240'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '24' WHERE alur_perkara_id = '1' AND tahapan_id = '16' AND proses_id = '241'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '25' WHERE alur_perkara_id = '1' AND tahapan_id = '16' AND proses_id = '242'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '26' WHERE alur_perkara_id = '1' AND tahapan_id = '16' AND proses_id = '243'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '27' WHERE alur_perkara_id = '1' AND tahapan_id = '16' AND proses_id = '250'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '28' WHERE alur_perkara_id = '1' AND tahapan_id = '16' AND proses_id = '260'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '29' WHERE alur_perkara_id = '1' AND tahapan_id = '16' AND proses_id = '261'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '515' WHERE alur_perkara_id = '6' AND tahapan_id = '14' AND proses_id = '200'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '414' WHERE alur_perkara_id = '5' AND tahapan_id = '14' AND proses_id = '200'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '313' WHERE alur_perkara_id = '4' AND tahapan_id = '14' AND proses_id = '200'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '212' WHERE alur_perkara_id = '3' AND tahapan_id = '14' AND proses_id = '200'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '111' WHERE alur_perkara_id = '2' AND tahapan_id = '14' AND proses_id = '200'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1381' WHERE alur_perkara_id = '7' AND tahapan_id = '10' AND proses_id = '10'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1382' WHERE alur_perkara_id = '7' AND tahapan_id = '12' AND proses_id = '20'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1383' WHERE alur_perkara_id = '7' AND tahapan_id = '12' AND proses_id = '21'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1384' WHERE alur_perkara_id = '7' AND tahapan_id = '12' AND proses_id = '30'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1385' WHERE alur_perkara_id = '7' AND tahapan_id = '12' AND proses_id = '31'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1386' WHERE alur_perkara_id = '7' AND tahapan_id = '12' AND proses_id = '40'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1387' WHERE alur_perkara_id = '7' AND tahapan_id = '12' AND proses_id = '41'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1388' WHERE alur_perkara_id = '7' AND tahapan_id = '12' AND proses_id = '80'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1389' WHERE alur_perkara_id = '7' AND tahapan_id = '12' AND proses_id = '81'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1390' WHERE alur_perkara_id = '7' AND tahapan_id = '13' AND proses_id = '110'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1391' WHERE alur_perkara_id = '7' AND tahapan_id = '13' AND proses_id = '120'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1392' WHERE alur_perkara_id = '7' AND tahapan_id = '13' AND proses_id = '121'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1393' WHERE alur_perkara_id = '7' AND tahapan_id = '13' AND proses_id = '130'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1394' WHERE alur_perkara_id = '7' AND tahapan_id = '13' AND proses_id = '140'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1395' WHERE alur_perkara_id = '7' AND tahapan_id = '13' AND proses_id = '150'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1397' WHERE alur_perkara_id = '7' AND tahapan_id = '13' AND proses_id = '180'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1399' WHERE alur_perkara_id = '7' AND tahapan_id = '13' AND proses_id = '191'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1400' WHERE alur_perkara_id = '7' AND tahapan_id = '14' AND proses_id = '200'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1401' WHERE alur_perkara_id = '7' AND tahapan_id = '15' AND proses_id = '210'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1402' WHERE alur_perkara_id = '7' AND tahapan_id = '15' AND proses_id = '211'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1403' WHERE alur_perkara_id = '7' AND tahapan_id = '15' AND proses_id = '212'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1404' WHERE alur_perkara_id = '7' AND tahapan_id = '15' AND proses_id = '218'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1405' WHERE alur_perkara_id = '7' AND tahapan_id = '15' AND proses_id = '220'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1406' WHERE alur_perkara_id = '7' AND tahapan_id = '15' AND proses_id = '230'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1407' WHERE alur_perkara_id = '7' AND tahapan_id = '16' AND proses_id = '240'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1408' WHERE alur_perkara_id = '7' AND tahapan_id = '16' AND proses_id = '250'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1409' WHERE alur_perkara_id = '7' AND tahapan_id = '16' AND proses_id = '260'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1410' WHERE alur_perkara_id = '7' AND tahapan_id = '16' AND proses_id = '270'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1411' WHERE alur_perkara_id = '7' AND tahapan_id = '16' AND proses_id = '280'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1412' WHERE alur_perkara_id = '7' AND tahapan_id = '20' AND proses_id = '290'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1413' WHERE alur_perkara_id = '7' AND tahapan_id = '20' AND proses_id = '300'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1414' WHERE alur_perkara_id = '7' AND tahapan_id = '20' AND proses_id = '310'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1415' WHERE alur_perkara_id = '7' AND tahapan_id = '20' AND proses_id = '320'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1416' WHERE alur_perkara_id = '7' AND tahapan_id = '20' AND proses_id = '330'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1417' WHERE alur_perkara_id = '7' AND tahapan_id = '20' AND proses_id = '340'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1418' WHERE alur_perkara_id = '7' AND tahapan_id = '20' AND proses_id = '350'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1419' WHERE alur_perkara_id = '7' AND tahapan_id = '20' AND proses_id = '360'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1420' WHERE alur_perkara_id = '7' AND tahapan_id = '20' AND proses_id = '370'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1421' WHERE alur_perkara_id = '7' AND tahapan_id = '20' AND proses_id = '380'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1422' WHERE alur_perkara_id = '7' AND tahapan_id = '20' AND proses_id = '390'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1423' WHERE alur_perkara_id = '7' AND tahapan_id = '20' AND proses_id = '391'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1424' WHERE alur_perkara_id = '7' AND tahapan_id = '20' AND proses_id = '400'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1425' WHERE alur_perkara_id = '7' AND tahapan_id = '30' AND proses_id = '410'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1426' WHERE alur_perkara_id = '7' AND tahapan_id = '30' AND proses_id = '420'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1427' WHERE alur_perkara_id = '7' AND tahapan_id = '30' AND proses_id = '430'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1428' WHERE alur_perkara_id = '7' AND tahapan_id = '30' AND proses_id = '440'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1429' WHERE alur_perkara_id = '7' AND tahapan_id = '30' AND proses_id = '450'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1430' WHERE alur_perkara_id = '7' AND tahapan_id = '30' AND proses_id = '460'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1431' WHERE alur_perkara_id = '7' AND tahapan_id = '30' AND proses_id = '461'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1432' WHERE alur_perkara_id = '7' AND tahapan_id = '30' AND proses_id = '464'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1433' WHERE alur_perkara_id = '7' AND tahapan_id = '30' AND proses_id = '470'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1434' WHERE alur_perkara_id = '7' AND tahapan_id = '30' AND proses_id = '480'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1435' WHERE alur_perkara_id = '7' AND tahapan_id = '30' AND proses_id = '490'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1436' WHERE alur_perkara_id = '7' AND tahapan_id = '30' AND proses_id = '500'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1437' WHERE alur_perkara_id = '7' AND tahapan_id = '40' AND proses_id = '510'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1438' WHERE alur_perkara_id = '7' AND tahapan_id = '40' AND proses_id = '520'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1439' WHERE alur_perkara_id = '7' AND tahapan_id = '40' AND proses_id = '521'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1440' WHERE alur_perkara_id = '7' AND tahapan_id = '40' AND proses_id = '522'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1441' WHERE alur_perkara_id = '7' AND tahapan_id = '40' AND proses_id = '530'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1442' WHERE alur_perkara_id = '7' AND tahapan_id = '40' AND proses_id = '540'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1443' WHERE alur_perkara_id = '7' AND tahapan_id = '40' AND proses_id = '550'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1444' WHERE alur_perkara_id = '7' AND tahapan_id = '40' AND proses_id = '560'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1445' WHERE alur_perkara_id = '7' AND tahapan_id = '40' AND proses_id = '570'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1446' WHERE alur_perkara_id = '7' AND tahapan_id = '40' AND proses_id = '571'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1447' WHERE alur_perkara_id = '7' AND tahapan_id = '50' AND proses_id = '600'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1448' WHERE alur_perkara_id = '7' AND tahapan_id = '50' AND proses_id = '605'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1449' WHERE alur_perkara_id = '7' AND tahapan_id = '50' AND proses_id = '610'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1450' WHERE alur_perkara_id = '7' AND tahapan_id = '50' AND proses_id = '615'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1451' WHERE alur_perkara_id = '7' AND tahapan_id = '50' AND proses_id = '620'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1452' WHERE alur_perkara_id = '7' AND tahapan_id = '50' AND proses_id = '622'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1453' WHERE alur_perkara_id = '7' AND tahapan_id = '50' AND proses_id = '624'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1454' WHERE alur_perkara_id = '7' AND tahapan_id = '50' AND proses_id = '626'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1455' WHERE alur_perkara_id = '7' AND tahapan_id = '50' AND proses_id = '628'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1456' WHERE alur_perkara_id = '7' AND tahapan_id = '50' AND proses_id = '630'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1457' WHERE alur_perkara_id = '7' AND tahapan_id = '50' AND proses_id = '640'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1458' WHERE alur_perkara_id = '8' AND tahapan_id = '10' AND proses_id = '10'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1459' WHERE alur_perkara_id = '8' AND tahapan_id = '12' AND proses_id = '20'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1460' WHERE alur_perkara_id = '8' AND tahapan_id = '12' AND proses_id = '21'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1461' WHERE alur_perkara_id = '8' AND tahapan_id = '12' AND proses_id = '30'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1462' WHERE alur_perkara_id = '8' AND tahapan_id = '12' AND proses_id = '31'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1463' WHERE alur_perkara_id = '8' AND tahapan_id = '12' AND proses_id = '40'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1464' WHERE alur_perkara_id = '8' AND tahapan_id = '12' AND proses_id = '41'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1465' WHERE alur_perkara_id = '8' AND tahapan_id = '12' AND proses_id = '80'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1466' WHERE alur_perkara_id = '8' AND tahapan_id = '12' AND proses_id = '81'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1467' WHERE alur_perkara_id = '8' AND tahapan_id = '13' AND proses_id = '110'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1468' WHERE alur_perkara_id = '8' AND tahapan_id = '13' AND proses_id = '120'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1469' WHERE alur_perkara_id = '8' AND tahapan_id = '13' AND proses_id = '121'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1470' WHERE alur_perkara_id = '8' AND tahapan_id = '13' AND proses_id = '130'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1471' WHERE alur_perkara_id = '8' AND tahapan_id = '13' AND proses_id = '140'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1472' WHERE alur_perkara_id = '8' AND tahapan_id = '13' AND proses_id = '150'";
		$this->patching->exe_script($sql);
		$sql = "UPDATE proses_alur_perkara SET id = '1474' WHERE alur_perkara_id = '8' AND tahapan_id = '13' AND proses_id = '180'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1476' WHERE alur_perkara_id = '8' AND tahapan_id = '13' AND proses_id = '191'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1477' WHERE alur_perkara_id = '8' AND tahapan_id = '14' AND proses_id = '200'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1478' WHERE alur_perkara_id = '8' AND tahapan_id = '15' AND proses_id = '210'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1479' WHERE alur_perkara_id = '8' AND tahapan_id = '15' AND proses_id = '211'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1480' WHERE alur_perkara_id = '8' AND tahapan_id = '15' AND proses_id = '212'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1481' WHERE alur_perkara_id = '8' AND tahapan_id = '15' AND proses_id = '214'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1482' WHERE alur_perkara_id = '8' AND tahapan_id = '15' AND proses_id = '218'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1483' WHERE alur_perkara_id = '8' AND tahapan_id = '15' AND proses_id = '220'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1484' WHERE alur_perkara_id = '8' AND tahapan_id = '15' AND proses_id = '230'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1485' WHERE alur_perkara_id = '8' AND tahapan_id = '17' AND proses_id = '281'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1486' WHERE alur_perkara_id = '8' AND tahapan_id = '17' AND proses_id = '282'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1487' WHERE alur_perkara_id = '8' AND tahapan_id = '17' AND proses_id = '283'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1488' WHERE alur_perkara_id = '8' AND tahapan_id = '17' AND proses_id = '284'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1489' WHERE alur_perkara_id = '8' AND tahapan_id = '17' AND proses_id = '285'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1490' WHERE alur_perkara_id = '8' AND tahapan_id = '17' AND proses_id = '286'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1491' WHERE alur_perkara_id = '8' AND tahapan_id = '17' AND proses_id = '287'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1492' WHERE alur_perkara_id = '8' AND tahapan_id = '17' AND proses_id = '288'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1493' WHERE alur_perkara_id = '8' AND tahapan_id = '17' AND proses_id = '289'";
		$this->patching->exe_script($sql);
		$sql = "UPDATE proses_alur_perkara SET id = '1494' WHERE alur_perkara_id = '119' AND tahapan_id = '10' AND proses_id = '10'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1495' WHERE alur_perkara_id = '119' AND tahapan_id = '12' AND proses_id = '20'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1496' WHERE alur_perkara_id = '119' AND tahapan_id = '12' AND proses_id = '21'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1497' WHERE alur_perkara_id = '119' AND tahapan_id = '12' AND proses_id = '30'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1498' WHERE alur_perkara_id = '119' AND tahapan_id = '12' AND proses_id = '31'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1499' WHERE alur_perkara_id = '119' AND tahapan_id = '12' AND proses_id = '40'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1500' WHERE alur_perkara_id = '119' AND tahapan_id = '12' AND proses_id = '41'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1501' WHERE alur_perkara_id = '119' AND tahapan_id = '12' AND proses_id = '80'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1502' WHERE alur_perkara_id = '119' AND tahapan_id = '12' AND proses_id = '81'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1503' WHERE alur_perkara_id = '119' AND tahapan_id = '14' AND proses_id = '200'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1504' WHERE alur_perkara_id = '119' AND tahapan_id = '15' AND proses_id = '210'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1505' WHERE alur_perkara_id = '119' AND tahapan_id = '15' AND proses_id = '211'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1506' WHERE alur_perkara_id = '119' AND tahapan_id = '15' AND proses_id = '212'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1507' WHERE alur_perkara_id = '119' AND tahapan_id = '15' AND proses_id = '218'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1508' WHERE alur_perkara_id = '119' AND tahapan_id = '15' AND proses_id = '220'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1509' WHERE alur_perkara_id = '119' AND tahapan_id = '15' AND proses_id = '230'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET proses_nama = 'Mediasi Tidak Berhasil' WHERE alur_perkara_id = '1' AND tahapan_id = '13' AND proses_id = '150'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET proses_nama = 'Kesepakatan Mediasi' WHERE alur_perkara_id = '1' AND tahapan_id = '13' AND proses_id = '130'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET proses_nama = 'Kesepakatan Mediasi' WHERE alur_perkara_id = '7' AND tahapan_id = '13' AND proses_id = '130'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET proses_nama = 'Mediasi Tidak Berhasil' WHERE alur_perkara_id = '7' AND tahapan_id = '13' AND proses_id = '150'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET proses_nama = 'Kesepakatan Mediasi' WHERE alur_perkara_id = '8' AND tahapan_id = '13' AND proses_id = '130'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET proses_nama = 'Mediasi Tidak Berhasil' WHERE alur_perkara_id = '8' AND tahapan_id = '13' AND proses_id = '150'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1318' WHERE alur_perkara_id = '118' AND tahapan_id = '10' AND proses_id = '10'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1319' WHERE alur_perkara_id = '118' AND tahapan_id = '10' AND proses_id = '10'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1320' WHERE alur_perkara_id = '118' AND tahapan_id = '12' AND proses_id = '20'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1321' WHERE alur_perkara_id = '118' AND tahapan_id = '12' AND proses_id = '21'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1322' WHERE alur_perkara_id = '118' AND tahapan_id = '12' AND proses_id = '30'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1323' WHERE alur_perkara_id = '118' AND tahapan_id = '12' AND proses_id = '31'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1324' WHERE alur_perkara_id = '118' AND tahapan_id = '12' AND proses_id = '40'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1325' WHERE alur_perkara_id = '118' AND tahapan_id = '12' AND proses_id = '41'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1326' WHERE alur_perkara_id = '118' AND tahapan_id = '12' AND proses_id = '76'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET proses_id = '77' WHERE alur_perkara_id = '118' AND tahapan_id = '12' AND proses_id = '75'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1327' WHERE alur_perkara_id = '118' AND tahapan_id = '12' AND proses_id = '77'";
		$this->patching->exe_script($sql); 
		$sql = "UPDATE proses_alur_perkara SET id = '1328',proses_nama = 'Diversi Gagal' WHERE alur_perkara_id = '118' AND tahapan_id = '12' AND proses_id = '78'";
		$this->patching->exe_script($sql);

		$sql = "UPDATE proses_alur_perkara SET reminder = 0 WHERE id = 1337;";
		$this->patching->exe_script($sql);
		

		$isThere = $this->patching->isColumnExist('pihak_penyidik','diedit_oleh');
		if(empty($isThere)){
			$sql = "ALTER TABLE pihak_penyidik
				ADD COLUMN diedit_oleh varchar(30)  COLLATE latin1_swedish_ci NULL COMMENT 'Diedit Oleh: (by system)' after alamat_kantor, 
				ADD COLUMN diedit_tanggal datetime   NULL COMMENT 'Diedit Tanggal: (by system)' after diedit_oleh, 
				ADD COLUMN diinput_oleh varchar(30)  COLLATE latin1_swedish_ci NULL COMMENT 'Diinput Oleh: (by system)' after diedit_tanggal, 
				ADD COLUMN diinput_tanggal datetime   NULL COMMENT 'Diinput Tanggal: (by system)' after diinput_oleh, 
				ADD COLUMN diperbaharui_oleh varchar(30)  COLLATE latin1_swedish_ci NULL COMMENT 'Diperbaharui Oleh: (by system)' after diinput_tanggal, 
				ADD COLUMN diperbaharui_tanggal datetime   NULL COMMENT 'Diperbaharui Tanggal: (by system)' after diperbaharui_oleh;";
			$this->patching->exe_script($sql);
		}
		
		$sql = "REPLACE INTO status_putusan(id,jenis_perkara_id,kode,nama,aktif,urutan) VALUES
				(30,3,'K','Dikabulkan','Y',1)
				,(31,3,NULL,'Dinyatakan Gugur','Y',2)
				,(32,3,'TL','Ditolak','Y',3)
				,(33,3,'NO','Tidak Dapat Diterima','Y',4);";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS sys_backup;";
		$this->patching->exe_script($sql);

		$sql = "CREATE TABLE sys_backup (
					id bigint(20) NOT NULL AUTO_INCREMENT,
					tanggal date DEFAULT NULL,
					jam time DEFAULT NULL,
					filename varchar(150) DEFAULT NULL,
					type char(1) DEFAULT NULL,
					location varchar(150) DEFAULT NULL,
					timestamp_backup timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
					PRIMARY KEY (id)
				) ENGINE=InnoDB;";
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO sumber_hukum (id,kode,nama,aktif,urutan) VALUE (5,'RV','RV','Y',5)";
		
		$sql = "DROP PROCEDURE IF EXISTS sys_reset_data;";
		$this->patching->exe_script($sql);
		$sql = "CREATE PROCEDURE sys_reset_data()
			BEGIN
				TRUNCATE TABLE actiopaulianaweb;
				TRUNCATE TABLE bandingdetilweb;
				TRUNCATE TABLE bandingweb;
				TRUNCATE TABLE dataumumweb;
				TRUNCATE TABLE eksekusidetilweb;
				TRUNCATE TABLE eksekusiweb;
				TRUNCATE TABLE grasiweb;
				TRUNCATE TABLE hartapailitweb;
				TRUNCATE TABLE jadwalsidangweb;
				TRUNCATE TABLE kasasidetilweb;
				TRUNCATE TABLE kasasiweb;
				TRUNCATE TABLE mediasiweb;
				TRUNCATE TABLE penahananweb;
				TRUNCATE TABLE pengacaraweb;
				TRUNCATE TABLE perkarabiayaweb;
				TRUNCATE TABLE perkarapenuntutanweb;
				TRUNCATE TABLE perkaraprosesweb;
				TRUNCATE TABLE pihakintervensiweb;
				TRUNCATE TABLE pihakweb;
				TRUNCATE TABLE pkdetilweb;
				TRUNCATE TABLE pkweb;
				TRUNCATE TABLE ppweb;
				TRUNCATE TABLE putusanselaweb;
				TRUNCATE TABLE verzetweb;
				TRUNCATE TABLE hakimweb;
				TRUNCATE TABLE ppweb;
				TRUNCATE TABLE jurusitaweb;
				TRUNCATE TABLE perkaraputusanweb;
				TRUNCATE TABLE alurperkaraweb;
				TRUNCATE TABLE barangbuktiweb;
				TRUNCATE TABLE delegasikeluarweb;
				TRUNCATE TABLE delegasimasukweb;
				TRUNCATE TABLE delegasiproseskeluarweb;
				TRUNCATE TABLE delegasiprosesmasukweb;
				TRUNCATE TABLE diversiweb;
				TRUNCATE TABLE hartapailitweb;
				TRUNCATE TABLE perkaraeksekusihtweb;
				TRUNCATE TABLE perkarakeberatanweb;
				TRUNCATE TABLE perkaraputusanterdakwa;
				TRUNCATE TABLE prosesalurperkaraweb;
				TRUNCATE TABLE sidangpertamaweb;
				TRUNCATE TABLE statuspihakweb;
				TRUNCATE TABLE statusputusanweb;
				TRUNCATE TABLE alurperkaraweb;
				TRUNCATE TABLE rekonvensiweb;
				TRUNCATE TABLE putusanpemberitahuanweb;

				DELETE FROM perkara;
				TRUNCATE TABLE penahanan_terdakwa;
				TRUNCATE TABLE perkara_actio_pauliana;
				DELETE FROM perkara_banding_detil;
				DELETE FROM perkara_banding;
				DELETE FROM perkara_barang_bukti;
				TRUNCATE TABLE perkara_biaya;
				TRUNCATE TABLE perkara_biaya_ht;
				TRUNCATE TABLE perkara_dismissal;
				TRUNCATE TABLE perkara_diversi;
				TRUNCATE TABLE perkara_dokumen; 
				DELETE FROM perkara_eksekusi_detil;
				DELETE FROM perkara_eksekusi;
				DELETE FROM perkara_eksekusi_detil_ht;
				DELETE FROM perkara_eksekusi_ht;
				DELETE FROM perkara_grasi;
				DELETE FROM perkara_ikrar_talak;
				DELETE FROM perkara_izin_cerai;
				DELETE FROM perkara_data_pernikahan;
				TRUNCATE TABLE perkara_hakim_banding; 
				TRUNCATE TABLE perkara_hakim_kasasi; 
				TRUNCATE TABLE perkara_hakim_pk; 
				TRUNCATE TABLE perkara_hakim_pn; 
				TRUNCATE TABLE perkara_harta_pailit; 
				TRUNCATE TABLE perkara_jadwal_sidang;
				TRUNCATE TABLE perkara_jadwal_mediasi; 
				TRUNCATE TABLE perkara_jurusita; 
				TRUNCATE TABLE perkara_kasasi_detil;
				TRUNCATE TABLE perkara_kasasi;
				DELETE FROM perkara_keberatan;
				DELETE FROM perkara_keberatan_detil;
				TRUNCATE TABLE perkara_lalulintas;
				DELETE FROM perkara_mediasi; 
				TRUNCATE TABLE perkara_mediator; 
				TRUNCATE TABLE perkara_panitera_banding; 
				TRUNCATE TABLE perkara_panitera_kasasi; 
				TRUNCATE TABLE perkara_panitera_pk; 
				TRUNCATE TABLE perkara_panitera_pn;
				TRUNCATE TABLE perkara_penetapan; 
				TRUNCATE TABLE perkara_pengacara; 
				TRUNCATE TABLE perkara_penuntutan; 
				TRUNCATE TABLE perkara_penyegelan; 
				TRUNCATE TABLE perkara_penyitaan;
				TRUNCATE TABLE perkara_pihak_korban;
				TRUNCATE TABLE perkara_pihak_orang_tua;
				TRUNCATE TABLE perkara_pihak_pembimbing_masyarakat;
				TRUNCATE TABLE perkara_pihak_penyidik;
				TRUNCATE TABLE perkara_pihak1;
				TRUNCATE TABLE perkara_pihak2; 
				TRUNCATE TABLE perkara_pihak3;
				TRUNCATE TABLE perkara_pihak4;
				TRUNCATE TABLE perkara_pk_detil;
				DELETE FROM perkara_pk;
				TRUNCATE TABLE perkara_proses;
				TRUNCATE TABLE perkara_putusan_sela;
				TRUNCATE TABLE perkara_putusan_terdakwa;
				DELETE FROM perkara_putusan;
				TRUNCATE TABLE perkara_putusan_pemberitahuan_putusan;
				TRUNCATE TABLE perkara_rehabilitasi;
				TRUNCATE TABLE perkara_verzet; 
				TRUNCATE TABLE pesan_tujuan;
				DELETE FROM pesan;
				TRUNCATE TABLE pihak_foto;
				TRUNCATE TABLE pihak_jaksa;
				TRUNCATE TABLE pihak_pengacara;
				DELETE FROM pihak; 
				TRUNCATE TABLE pihak_penyidik; 
				TRUNCATE TABLE pihak_pembimbing_masyarakat; 
				DELETE FROM ruangan_sidang; 
				TRUNCATE TABLE sys_audittrail; 
				TRUNCATE TABLE saldo_awal;
				DELETE FROM sys_user_group WHERE userid>1; 
				TRUNCATE TABLE sys_user_online; 
				DELETE FROM sys_users WHERE userid>1;
				TRUNCATE TABLE user_hakim; 
				TRUNCATE TABLE user_jurusita; 
				TRUNCATE TABLE user_panitera; 
				TRUNCATE TABLE web_statistik;
				DELETE FROM hakim_ma; 
				DELETE FROM hakim_pn; 
				DELETE FROM hakim_pt;
				TRUNCATE TABLE hari_libur; 
				TRUNCATE TABLE izin_penggeledahan; 
				TRUNCATE TABLE izin_penyitaan;
				DELETE FROM jurusita; 
				DELETE FROM kurator;
				DELETE FROM mediator;
				DELETE FROM panitera_ma; 
				DELETE FROM panitera_pn; 
				DELETE FROM panitera_pt;
				DELETE FROM delegasi_keluar;
				DELETE FROM delegasi_masuk;
				DELETE FROM delegasi_proses_keluar;
				DELETE FROM delegasi_proses_masuk;
				
				DELETE FROM antrian;
				DELETE FROM arsip;
				DELETE FROM perkara_rekonvensi;
				DELETE FROM perkara_rekonvensi_detil;
				DELETE FROM arsip_pinjam;
				DELETE FROM template_history;
				UPDATE sys_config SET VALUE='' WHERE NAME='NamaPT';
				UPDATE sys_config SET VALUE='' WHERE NAME='AlamatPT';
				UPDATE sys_config SET VALUE='' WHERE NAME='KodePN';
				UPDATE sys_config SET VALUE='' WHERE NAME='NamaPN';
				UPDATE sys_config SET VALUE='' WHERE NAME='AlamatPN';
				UPDATE sys_config SET VALUE='' WHERE NAME='KetuaPNNama';
				UPDATE sys_config SET VALUE='' WHERE NAME='KetuaPNNIP';
				UPDATE sys_config SET VALUE='' WHERE NAME='WakilKetuaPNNama';
				UPDATE sys_config SET VALUE='' WHERE NAME='WakilKetuaPNNIP';
				UPDATE sys_config SET VALUE='' WHERE NAME='PanSekNama';
				UPDATE sys_config SET VALUE='' WHERE NAME='PanSekNIP';
				UPDATE sys_config SET VALUE='' WHERE NAME='WaPanNama';
				UPDATE sys_config SET VALUE='' WHERE NAME='WaPanNIP';
				UPDATE sys_config SET VALUE='' WHERE NAME='WaSekNama';
				UPDATE sys_config SET VALUE='' WHERE NAME='WaSekNIP';
				UPDATE sys_config SET VALUE='' WHERE NAME='ZonaWaktu';
				UPDATE sys_config SET VALUE='127.0.0.1' WHERE NAME='SMTP_Server';
				UPDATE sys_config SET VALUE='25' WHERE NAME='SMTP_Port';
				UPDATE sys_config SET VALUE='' WHERE NAME='SMTP_User';
				UPDATE sys_config SET VALUE='' WHERE NAME='SMTP_Password';
				UPDATE sys_config SET VALUE='' WHERE NAME='SMTP_Email';
				UPDATE saldo_awal SET tanggal_saldo_awal=NULL, jumlah_saldo_awal=0;
				ALTER TABLE perkara_eksekusi_detil AUTO_INCREMENT = 0;
				ALTER TABLE perkara_hakim_banding AUTO_INCREMENT = 0;
				ALTER TABLE perkara_hakim_kasasi AUTO_INCREMENT = 0;
				ALTER TABLE perkara_hakim_pn AUTO_INCREMENT = 0;
				ALTER TABLE perkara_panitera_banding AUTO_INCREMENT = 0;
				ALTER TABLE perkara_panitera_kasasi AUTO_INCREMENT = 0;
				ALTER TABLE perkara_panitera_pn AUTO_INCREMENT = 0;
				ALTER TABLE perkara_pk_detil AUTO_INCREMENT = 0;
				ALTER TABLE perkara_kasasi_detil AUTO_INCREMENT = 0;
				ALTER TABLE perkara_banding_detil AUTO_INCREMENT = 0;
				ALTER TABLE perkara_pengacara AUTO_INCREMENT = 0;
				ALTER TABLE perkara_putusan_sela AUTO_INCREMENT = 0;
				ALTER TABLE penahanan_terdakwa AUTO_INCREMENT = 0;
				ALTER TABLE pesan AUTO_INCREMENT = 0;
			END;";
		$this->patching->exe_script($sql);

		$isThere = $this->patching->isTableExist('perkara_pengacara_copy');
		if(empty($isThere)){
			$this->patching->exe_script('UPDATE perkara_pengacara SET masa_aktif = NULL WHERE masa_aktif = "";');
			$sql = "CREATE TABLE perkara_pengacara_copy LIKE perkara_pengacara;";
			$this->patching->exe_script($sql);
			$sql = "REPLACE INTO perkara_pengacara_copy SELECT * FROM perkara_pengacara;";
			$this->patching->exe_script($sql);

			$sql = "DROP TABLE IF EXISTS perkara_pengacara_tmp;";
			$this->patching->exe_script($sql);
			$sql = "CREATE TABLE perkara_pengacara_tmp AS
					SELECT e.perkara_id, pihak_ke, SUBSTRING_INDEX(SUBSTRING_INDEX(e.pihak_id, ',', n.n), ',', -1) AS pihak_id, 
						urutan, pengacara_id, jenis_pihak_id, nama, alamat,keterangan,aktif,
						aktif_mulai,aktif_sampai,masa_aktif,
						diedit_oleh,diedit_tanggal,diinput_oleh,diinput_tanggal,diperbaharui_oleh,diperbaharui_tanggal
						FROM perkara_pengacara AS e CROSS JOIN (
							SELECT a.N + b.N * 10 + 1 n
								FROM 
									(SELECT 0 AS N 
										UNION ALL 
											SELECT 1 
										UNION ALL 
											SELECT 2 
										UNION ALL 
											SELECT 3 
										UNION ALL 
											SELECT 4 
										UNION ALL 
											SELECT 5 
										UNION ALL 
											SELECT 6 
										UNION ALL 
											SELECT 7
										UNION ALL 
											SELECT 8 
										UNION ALL 
											SELECT 9) a,
									(SELECT 0 AS N 
										UNION ALL 
											SELECT 1 
										UNION ALL 
											SELECT 2 
										UNION ALL 
											SELECT 3 
										UNION ALL 
											SELECT 4 
										UNION ALL 
											SELECT 5 
										UNION ALL 
											SELECT 6 
										UNION ALL 
											SELECT 7
										UNION ALL 
											SELECT 8 
										UNION ALL 
											SELECT 9) b
								ORDER BY n) n
							WHERE n.n <= 1+ (LENGTH(e.pihak_id)-LENGTH(REPLACE(e.pihak_id,',','')));";
			$this->patching->exe_script($sql);
			$this->patching->exe_script('UPDATE perkara_pengacara_tmp SET masa_aktif = NULL WHERE masa_aktif = "";');
			$this->patching->exe_script('DELETE FROM perkara_pengacara_tmp WHERE pihak_id = "" OR pihak_id IS NULL;');
			$sql = "ALTER TABLE perkara_pengacara_tmp   
					CHANGE perkara_id perkara_id BIGINT(20) UNSIGNED NOT NULL  COMMENT 'Id Perkara: merujuk ke tabel perkara kolom perkara_id(by system)',
					CHANGE pihak_id pihak_id BIGINT(20) NOT NULL,
					CHANGE pengacara_id pengacara_id BIGINT(20) UNSIGNED NOT NULL COMMENT 'Id Pengacara: merujuk ke tabel pengacara kolom id',
					CHANGE nama nama VARCHAR(500) NULL,
					CHANGE alamat alamat VARCHAR(500) NULL,
					CHANGE keterangan keterangan VARCHAR(500) NULL,
					CHANGE masa_aktif masa_aktif SMALLINT(5) NULL;";
			$this->patching->exe_script($sql);

			$this->dbforge->drop_table('perkara_pengacara',TRUE);
			$this->dbforge->rename_table('perkara_pengacara_tmp', 'perkara_pengacara');
		}else{
			$sql = "DROP TABLE IF EXISTS perkara_pengacara_tmp;";
			$this->patching->exe_script($sql);
			$sql = "CREATE TABLE perkara_pengacara_tmp AS
					SELECT e.perkara_id, pihak_ke, SUBSTRING_INDEX(SUBSTRING_INDEX(e.pihak_id, ',', n.n), ',', -1) AS pihak_id, 
						urutan, pengacara_id, jenis_pihak_id, nama, alamat,keterangan,aktif,
						aktif_mulai,aktif_sampai,masa_aktif,
						diedit_oleh,diedit_tanggal,diinput_oleh,diinput_tanggal,diperbaharui_oleh,diperbaharui_tanggal
						FROM perkara_pengacara_copy AS e CROSS JOIN (
							SELECT a.N + b.N * 10 + 1 n
								FROM 
									(SELECT 0 AS N 
										UNION ALL 
											SELECT 1 
										UNION ALL 
											SELECT 2 
										UNION ALL 
											SELECT 3 
										UNION ALL 
											SELECT 4 
										UNION ALL 
											SELECT 5 
										UNION ALL 
											SELECT 6 
										UNION ALL 
											SELECT 7
										UNION ALL 
											SELECT 8 
										UNION ALL 
											SELECT 9) a,
									(SELECT 0 AS N 
										UNION ALL 
											SELECT 1 
										UNION ALL 
											SELECT 2 
										UNION ALL 
											SELECT 3 
										UNION ALL 
											SELECT 4 
										UNION ALL 
											SELECT 5 
										UNION ALL 
											SELECT 6 
										UNION ALL 
											SELECT 7
										UNION ALL 
											SELECT 8 
										UNION ALL 
											SELECT 9) b
								ORDER BY n) n
							WHERE n.n <= 1+ (LENGTH(e.pihak_id)-LENGTH(REPLACE(e.pihak_id,',','')));";
			$this->patching->exe_script($sql);

			$this->patching->exe_script('UPDATE perkara_pengacara_tmp SET masa_aktif = NULL WHERE masa_aktif = "";');
			$this->patching->exe_script('DELETE FROM perkara_pengacara_tmp WHERE pihak_id = "" OR pihak_id IS NULL;');
			$sql = "ALTER TABLE perkara_pengacara_tmp   
					CHANGE perkara_id perkara_id BIGINT(20) UNSIGNED NOT NULL  COMMENT 'Id Perkara: merujuk ke tabel perkara kolom perkara_id(by system)',
					CHANGE pihak_id pihak_id BIGINT(20) NOT NULL,
					CHANGE pengacara_id pengacara_id BIGINT(20) UNSIGNED NOT NULL COMMENT 'Id Pengacara: merujuk ke tabel pengacara kolom id',
					CHANGE nama nama VARCHAR(500) NULL,
					CHANGE alamat alamat VARCHAR(500) NULL,
					CHANGE keterangan keterangan VARCHAR(500) NULL,
					CHANGE masa_aktif masa_aktif SMALLINT(5) NULL;";
			$this->patching->exe_script($sql);
			$this->dbforge->drop_table('perkara_pengacara',TRUE);
			$this->dbforge->rename_table('perkara_pengacara_tmp', 'perkara_pengacara');
		}
		$this->patching->exe_script('DELETE FROM perkara_pengacara WHERE pihak_id = 0;');

		$isThere = $this->patching->isColumnExist('perkara_pengacara','id');
		if(empty($isThere)){
		$sql = "ALTER TABLE perkara_pengacara
					ADD COLUMN id BIGINT(20) UNSIGNED AUTO_INCREMENT FIRST,
					ADD PRIMARY KEY (id),
					ADD CONSTRAINT perkara_pengacara_ibfk_3 FOREIGN KEY (perkara_id) REFERENCES perkara(perkara_id) ON DELETE CASCADE;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('tahapan_proses','diedit_oleh');
		if(!empty($isThere)){
			$sql = "ALTER TABLE tahapan_proses   
						DROP COLUMN diedit_oleh, 
						DROP COLUMN diedit_tanggal, 
						DROP COLUMN diinput_oleh, 
						DROP COLUMN diinput_tanggal, 
						DROP COLUMN diperbaharui_oleh, 
						DROP COLUMN diperbaharui_tanggal, 
						CHANGE nama nama VARCHAR(100) NOT NULL ,
						ADD COLUMN jenis_pengadilan CHAR(2) DEFAULT '1' NOT NULL AFTER aktif, 
						DROP PRIMARY KEY,
						ADD PRIMARY KEY (Id, jenis_pengadilan);";
			$this->patching->exe_script($sql);
		}


		$isThere = $this->patching->isColumnExist('perkara_verzet','tanggal_surat');
		if(empty($isThere)){
		$sql = "ALTER TABLE perkara_verzet
			ADD COLUMN tanggal_surat DATE NULL AFTER tanggal_pendaftaran_verzet,
			ADD COLUMN tanggal_minutasi_verzet DATE NULL AFTER pemberitahuan_putusan_verzet_pihak2;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('pihak_jaksa','pangkat');
		if(empty($isThere)){
			$sql = "ALTER TABLE pihak_jaksa 
						ADD COLUMN pangkat VARCHAR(100) NULL AFTER alamat_kantor, 
						ADD COLUMN jabatan VARCHAR(100) NULL AFTER pangkat, 
						ADD COLUMN kesatuan VARCHAR(100) NULL AFTER jabatan,
						ADD COLUMN diinput_oleh VARCHAR(30) NULL AFTER jabatan,
						ADD COLUMN diinput_tanggal DATETIME NULL AFTER diinput_oleh,
						ADD COLUMN diperbaharui_oleh VARCHAR(30) NULL AFTER diinput_tanggal,
						ADD COLUMN diperbaharui_tanggal DATETIME NULL AFTER diperbaharui_oleh;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('jenis_pihak','jenis_pengadilan');
		if(empty($isThere)){
			$sql = "ALTER TABLE jenis_pihak
					ADD COLUMN jenis_pengadilan CHAR(1) DEFAULT 1 NOT NULL AFTER aktif, 
					DROP PRIMARY KEY,
					DROP INDEX nama,
					ADD PRIMARY KEY (id, jenis_pengadilan);";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara','jenis_acara');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara
				ADD COLUMN jenis_acara CHAR(1) NULL AFTER perkara_id,
				ADD COLUMN pasal_dakwaan TEXT NULL AFTER dakwaan;";
			$this->patching->exe_script($sql);
		}
  
		$isThere = $this->patching->isColumnExist('perkara_putusan','tanggal_bht');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_putusan
					ADD COLUMN tanggal_bht DATE NULL AFTER nilai_ganti_kerugian,
					ADD COLUMN pemberitahuan_putusan_ankum DATE NULL AFTER pemberitahuan_putusan_pihak3,
					ADD COLUMN pemberitahuan_putusan_pepera DATE NULL AFTER pemberitahuan_putusan_ankum;";
			$this->patching->exe_script($sql);
		}

		

		$isThere = $this->patching->isColumnExist('perkara_pihak2','pangkat');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_pihak2 
						 ADD COLUMN pangkat VARCHAR(100) NULL AFTER keterangan, 
						 ADD COLUMN nrp VARCHAR(50) NULL AFTER pangkat, 
						 ADD COLUMN jabatan VARCHAR(100) NULL AFTER nrp, 
						 ADD COLUMN kesatuan VARCHAR(100) NULL AFTER jabatan;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('pihak_pengacara','pangkat');
		if(empty($isThere)){
			$sql = "ALTER TABLE pihak_pengacara 
						 ADD COLUMN pangkat VARCHAR(100) NULL,
						 ADD COLUMN jabatan VARCHAR(100) NULL, 
						 ADD COLUMN kesatuan VARCHAR(100) NULL;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('panitera_pn','pangkat');
		if(empty($isThere)){
			$sql = "ALTER TABLE panitera_pn 
						ADD COLUMN pangkat VARCHAR(20) NULL AFTER nip, 
						ADD COLUMN jabatan VARCHAR(20) NULL AFTER pangkat;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('panitera_pt','pangkat');
		if(empty($isThere)){
			$sql = "ALTER TABLE panitera_pt 
						ADD COLUMN pangkat VARCHAR(20) NULL AFTER nip, 
						ADD COLUMN jabatan VARCHAR(20) NULL AFTER pangkat;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('hakim_pn','pangkat');
		if(empty($isThere)){
			$sql = "ALTER TABLE hakim_pn
					ADD COLUMN pangkat VARCHAR(35) NULL AFTER nip, 
					ADD COLUMN jabatan VARCHAR(35) NULL AFTER pangkat;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('hakim_pt','pangkat');
		if(empty($isThere)){
			$sql = "ALTER TABLE hakim_pt
					ADD COLUMN pangkat VARCHAR(35) NULL AFTER nip, 
					ADD COLUMN jabatan VARCHAR(35) NULL AFTER pangkat;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('penahanan_terdakwa','rutan_id');
		if(empty($isThere)){
			$sql = "ALTER TABLE penahanan_terdakwa 
					ADD COLUMN rutan_id SMALLINT(11) UNSIGNED NULL AFTER jenis_tahanan_id,
					ADD COLUMN pejabat_penahan VARCHAR(200) NULL AFTER keterangan;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('jenis_penahanan','jenis_pengadilan');
		if(empty($isThere)){
			$sql = "ALTER TABLE jenis_penahanan 
					ADD COLUMN jenis_pengadilan TINYINT(1) NULL AFTER keterangan;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('sumber_hukum','jenis_pengadilan');
		if(empty($isThere)){
			$sql = "ALTER TABLE sumber_hukum
				DROP INDEX kode,
				DROP INDEX nama,
				ADD COLUMN jenis_pengadilan CHAR(1) DEFAULT 1 AFTER keterangan;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('status_putusan','jenis_pengadilan');
		if(empty($isThere)){
					$sql = "ALTER TABLE status_putusan 
			ADD COLUMN jenis_pengadilan TINYINT(1) DEFAULT 1 NOT NULL AFTER satuan,
			DROP INDEX jenis_putusan_u1;";
			$this->patching->exe_script($sql);
		}

		$isThere = $this->patching->isColumnExist('perkara_putusan_sela','urutan');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_putusan_sela
					CHANGE amar_sela amar_sela MEDIUMTEXT NULL,
					ADD COLUMN urutan TINYINT(2) DEFAULT 1 AFTER perkara_id,
					ADD COLUMN pemberitahuan_putusan_sela_pihak4 DATE NULL AFTER pemberitahuan_putusan_sela_pihak3,
					DROP PRIMARY KEY, 
					DROP FOREIGN KEY perkara_putusan_sela_fk, 
					ADD COLUMN putusansela_id BIGINT(11) UNSIGNED NOT NULL AUTO_INCREMENT FIRST,
					ADD PRIMARY KEY (putusansela_id),
					ADD CONSTRAINT perkara_putusan_sela_forgein FOREIGN KEY (perkara_id) REFERENCES perkara(perkara_id) ON DELETE CASCADE;";
			$this->patching->exe_script($sql);
		}

		

		$isThere = $this->patching->isColumnExist('perkara_penetapan','jenis_acara');
		if(empty($isThere)){
			$sql = "ALTER TABLE perkara_penetapan
  				ADD COLUMN jenis_acara CHAR(1) NULL COMMENT '1.Acara Cepat 2.Acara Biasa' AFTER perkara_id ;";
			$this->patching->exe_script($sql);
		}

		$this->patching->exe_script("REPLACE INTO tahapan_proses (Id, kode, nama, keterangan, urutan, jenis_pengadilan)
		VALUES
			(10,01, 'Pendaftaran', 'Pendaftaran', 1,  3),
			(12,02, 'Penetapan', 'Penetapan', 2,  3),
			(13,13, 'Perlawanan', 'Perlawanan', 3,  3),
			(14,14, 'Persidangan', 'Persidangan', 4,  3),
			(15,03, 'Putusan', 'Putusan', 5,  3),
			(20,05, 'Banding', 'Banding', 6,  3),
			(30,06, 'Kasasi', 'Kasasi', 7,  3),
			(40,07, 'Peninjauan Kembali', 'Peninjauan Kembali', 8,  3),
			(50,08, 'Eksekusi', 'Eksekusi', 9,  3),
			(10,01, 'Pendaftaran', 'Pendaftaran', 1, 2),
			(12,02, 'Penetapan', 'Penetapan', 2, 2),
			(14,14, 'Persidangan', 'Persidangan', 3, 2), 
			(15,03, 'Putusan', 'Putusan', 4, 2), 
			(20,05, 'Banding', 'Banding', 5, 2), 
			(30,06, 'Kasasi', 'Kasasi', 6, 2), 
			(40,07, 'Peninjauan Kembali', 'Peninjauan Kembali', 7, 2), 
			(60,10, 'Grasi', 'Grasi', 8, 2),
			(10,'1','Pendaftaran','Pendaftaran','1','4'),
			(12,'2','Penetapan','Penetapan','2','4'),
			(13,'13','Mediasi','Mediasi','3','4'),
			(14,'14','Persidangan','Persidangan','4','4'),
			(15,'3','Putusan','Putusan','5','4'),
			(16,'4','Verzet','Verzet','6','4'),
			(17,'17','Keberatan','Keberatan','7','4'),
			(18,'18','Ikrar Talak','Ikrar Talak','8','4'),
			(19,'19','Akta Cerai','Akta Cerai','9','4'),
			(20,'5','Banding','Banding','9','4'),
			(30,'6','Kasasi','Kasasi','10','4'),
			(40,'7','Peninjauan Kembali','Peninjauan Kembali','11','4'),
			(50,'8','Eksekusi','Eksekusi','12','4');");


		$this->patching->exe_script("REPLACE INTO proses (id,tahapan_id,kode,nama,keterangan,aktif)
		VALUES 
			(15,12,12,'Panggilan Pihak','Panggilan Para Pihak','Y'),
			(16,12,12,'Penetapan Dismissal Diterima','Penetapan Dismissal Diterima','Y'),
			(17,15,15,'Putusan Perlawanan Diterima','Putusan Perlawanan Diterima','Y'),
			(110,13,13,'Pendaftaran Perlawanan','Pendaftaran Perlawanan','Y'),
			(111,13,13,'Penetapan Majelis Hakim Perlawanan','Penetapan Majelis Hakim Perlawanan','Y'),
			(112,13,13,'Penetapan Panitera Pengganti Perlawanan','Penetapan Panitera Pengganti Perlawanan','Y'),
			(113,13,13,'Penetapan Jurusita Perlawanan','Penetapan Jurusita Perlawanan','Y'),
			(114,13,13,'Penetapan Jadwal Sidang Perlawanan','Penetapan Jadwal Sidang Perlawanan','Y'),
			(115,13,13,'Sidang Pertama Perlawanan','Sidang Pertama Perlawanan','Y'),
			(219,15,15,'Putusan Perlawanan Ditolak','Putusan Perlawanan Ditolak','Y'),
			(140,13,13,'Penetapan Akta Perdamaian','Penetapan Akta Perdamaian','Y'),
			(191,13,13,'Tidak Mediasi','Tidak Mediasi','Y'),
			(217,15,15,'Putusan Perlawanan Ditolak','Putusan Perlawanan Ditolak','Y'),
			(230,15,15,'Pemberitahuan Putusan','Pemberitahuan Putusan','Y'),
			(391,20,20,'Pencabutan Perkara Banding','Pencabutan Perkara Banding','Y');");

		 
		$this->patching->exe_script("DROP TABLE IF EXISTS sys_langguage");
		$this->patching->exe_script("CREATE TABLE sys_langguage (
			id int(11) unsigned NOT NULL AUTO_INCREMENT,
			jenis_pengadilan char(1) NOT NULL DEFAULT 1,
			nama varchar(50) DEFAULT NULL,
			translate varchar(50) DEFAULT NULL,
			PRIMARY KEY (id,jenis_pengadilan)
		) ENGINE=InnoDB;");

		$this->patching->exe_script("REPLACE INTO sys_langguage (id,jenis_pengadilan, nama, `translate`)
			VALUES
				(1, '1', 'amar', 'Amar'),
				(2, '2', 'amar', 'Petikan'),
				(3, '3', 'amar', 'Amar'),
				(4, '1', 'kejaksaan', 'Kejaksaan'),
				(5, '3', 'kejaksaan', 'Kejaksaan'),
				(6, '2', 'kejaksaan', 'Otmil'),
				(7, '1', 'nip', 'NIP'),
				(8, '3', 'nip', 'NIP'),
				(9, '2', 'nip', 'NRP'),
				(11, '1', 'verzet', 'Verzet'),
				(12, '3', 'verzet', 'Perlawanan'),
				(21, '1', 'nomor_perkara', 'Nomor Perkara PN'),
				(22, '2', 'nomor_perkara', 'Nomor Perkara DILMIL'),
				(23, '3', 'nomor_perkara', 'Nomor Perkara PTUN'),
				(24, '1', 'pengadilan_negeri', 'Pengadilan Negeri'),
				(25, '3', 'pengadilan_negeri', 'Pengadilan Tata Usaha Negara'),
				(26, '1', 'penuntut_umum', 'Jaksa'),
				(27, '2', 'penuntut_umum', 'Oditur'),
				(28, '4', 'amar', 'Amar'),
				(29, '4', 'kejaksaan', 'Kejaksaan'),
				(30, '4', 'nip', 'NIP'),
				(31, '4', 'verzet', 'Verzet'),
				(32, '4', 'nomor_perkara', 'Nomor Perkara'),
				(33, '4', 'pengadilan_negeri', 'Pengadilan Agama'),
				(34,4,'penuntut_umum','Jaksa');");

		$this->patching->exe_script("REPLACE INTO status_pihak (alur_perkara_id, tahapan_id, pihak_ke, nama, aktif, urutan) 
		VALUES
			(9,10,1,'Penggugat','Y','1'),
			(9,10,2,'Tergugat','Y','2'),
			(9,10,3,'Intervensi','Y','3'),
			(9,10,7,'Kuasa Hukum Penggugat','Y','1'),
			(9,10,8,'Kuasa Hukum Tergugat','Y','1'),
			(9,10,9,'Kuasa Hukum Intervensi','Y','1'),
			(9,10,13,'Saksi','Y','1'),
			(9,13,1,'Pelawan','Y','1'),
			(9,13,2,'Terlawan','Y','2'),
			(9,20,1,'Pembanding','Y','1'),
			(9,20,2,'Pembandin/Terbanding','Y','2'),
			(9,20,3,'Turut Terbanding','Y','3'),
			(9,20,4,'Terbanding','Y','4'),
			(9,20,5,'Terbanding/Pembanding','Y','5'),
			(9,30,1,'Pemohon Kasasi','Y','1'),
			(9,30,2,'Pemohon/Termohon Kasasi','Y','2'),
			(9,30,3,'Turut Termohon Kasasi','Y','3'),
			(9,30,4,'Termohon Kasasi','Y','4'),
			(9,30,5,'Termohon/Pemohon Kasasi','Y','5'),
			(9,40,1,'Pemohon PK','Y','1'),
			(9,40,2,'Pemohon/Termohon PK','Y','2'),
			(9,40,3,'Turut Termohon PK','Y','3'),
			(9,40,4,'Termohon PK','Y','4'),
			(9,40,5,'Termohon/Pemohon PK','Y','5'),
			(9,50,1,'Pemohon','Y','1'),
			(9,50,2,'Termohon','Y','2'),
			(120,10,1,'Oditur','Y',1),
			(120,10,2,'Terdakwa','Y',2),
			(120,10,8,'Penasihat Hukum Terdakwa','Y',3),
			(120,10,13,'Saksi','Y',4),
			(121,10,1,'Oditur','Y',1),
			(121,10,2,'Terdakwa','Y',2),
			(121,10,8,'Penasihat Hukum Terdakwa','Y',3),
			(121,10,13,'Saksi','Y',4),
			(10,10,1,'Pemohon','Y','1'),
			(10,10,2,'Termohon','Y','2'),
			(10,10,7,'Kuasa Hukum Pemohon','Y','1'),
			(10,10,8,'Kuasa Hukum Termohon','Y','1'),
			(10,20,1,'Pembanding','Y','1'),
			(10,20,2,'Pembanding/Terbanding','Y','2'),
			(10,20,3,'Turut Terbanding','Y','3'),
			(10,20,4,'Terbanding','Y','4'),
			(10,20,5,'Terbanding/Pembanding','Y','5'),
			(10,30,1,'Pemohon Kasasi','Y','1'),
			(10,30,2,'Pemohon/Termohon Kasasi','Y','2'),
			(10,30,3,'Turut Termohon Kasasi','Y','3'),
			(10,30,4,'Termohon Kasasi','Y','4'),
			(10,30,5,'Termohon/Pemohon Kasasi','Y','5'),
			(10,40,1,'Pemohon PK','Y','1'),
			(10,40,2,'Pemohon/Termohon PK','Y','2'),
			(10,40,3,'Turut Termohon PK','Y','5'),
			(10,40,4,'Termohon PK','Y','3'),
			(10,40,5,'Termohon/Pemohon PK','Y','4'),
			(10,50,1,'Pemohon','Y','1'),
			(10,50,2,'Termohon','Y','2'),
			(11,10,1,'Pemohon','Y','1'),
			(11,10,2,'Termohon','Y','2'),
			(11,10,7,'Kuasa Hukum Pemohon','Y','1'),
			(11,10,8,'Kuasa Hukum Termohon','Y','1'),
			(11,20,1,'Pembanding','Y','1'),
			(11,20,2,'Pembanding/Terbanding','Y','2'),
			(11,20,3,'Turut Terbanding','Y','3'),
			(11,20,4,'Terbanding','Y','4'),
			(11,20,5,'Terbanding/Pembanding','Y','5'),
			(11,30,1,'Pemohon Kasasi','Y','1'),
			(11,30,2,'Pemohon/Termohon Kasasi','Y','2'),
			(11,30,3,'Turut Termohon Kasasi','Y','3'),
			(11,30,4,'Termohon Kasasi','Y','4'),
			(11,30,5,'Termohon/Pemohon Kasasi','Y','5'),
			(11,40,1,'Pemohon PK','Y','1'),
			(11,40,2,'Pemohon/Termohon PK','Y','2'),
			(11,40,3,'Turut Termohon PK','Y','5'),
			(11,40,4,'Termohon PK','Y','3'),
			(11,40,5,'Termohon/Pemohon PK','Y','4'),
			(11,50,1,'Pemohon','Y','1'),
			(11,50,2,'Termohon','Y','2'),
			(12,10,1,'Pemohon','Y','1'),
			(12,10,2,'Termohon','Y','2'),
			(12,10,7,'Kuasa Hukum Pemohon','Y','1'),
			(12,10,8,'Kuasa Hukum Termohon','Y','1'),
			(12,20,1,'Pembanding','Y','1'),
			(12,20,2,'Pembanding/Terbanding','Y','2'),
			(12,20,3,'Turut Terbanding','Y','3'),
			(12,20,4,'Terbanding','Y','4'),
			(12,20,5,'Terbanding/Pembanding','Y','5'),
			(12,30,1,'Pemohon Kasasi','Y','1'),
			(12,30,2,'Pemohon/Termohon Kasasi','Y','2'),
			(12,30,3,'Turut Termohon Kasasi','Y','3'),
			(12,30,4,'Termohon Kasasi','Y','4'),
			(12,30,5,'Termohon/Pemohon Kasasi','Y','5'),
			(12,40,1,'Pemohon PK','Y','1'),
			(12,40,2,'Pemohon/Termohon PK','Y','2'),
			(12,40,3,'Turut Termohon PK','Y','5'),
			(12,40,4,'Termohon PK','Y','3'),
			(12,40,5,'Termohon/Pemohon PK','Y','4'),
			(12,50,1,'Pemohon','Y','1'),
			(12,50,2,'Termohon','Y','2'),
			(13,10,1,'Pemohon','Y','1'),
			(13,10,2,'Termohon','Y','2'),
			(13,10,7,'Kuasa Hukum Pemohon','Y','1'),
			(13,10,8,'Kuasa Hukum Termohon','Y','1'),
			(13,20,1,'Pembanding','Y','1'),
			(13,20,2,'Pembanding/Terbanding','Y','2'),
			(13,20,3,'Turut Terbanding','Y','3'),
			(13,20,4,'Terbanding','Y','4'),
			(13,20,5,'Terbanding/Pembanding','Y','5'),
			(13,30,1,'Pemohon Kasasi','Y','1'),
			(13,30,2,'Pemohon/Termohon Kasasi','Y','2'),
			(13,30,3,'Turut Termohon Kasasi','Y','3'),
			(13,30,4,'Termohon Kasasi','Y','4'),
			(13,30,5,'Termohon/Pemohon Kasasi','Y','5'),
			(13,40,1,'Pemohon PK','Y','1'),
			(13,40,2,'Pemohon/Termohon PK','Y','2'),
			(13,40,3,'Turut Termohon PK','Y','5'),
			(13,40,4,'Termohon PK','Y','3'),
			(13,40,5,'Termohon/Pemohon PK','Y','4'),
			(13,50,1,'Pemohon','Y','1'),
			(13,50,2,'Termohon','Y','2'),
			(14,10,1,'Pemohon','Y','1'),
			(14,10,2,'Termohon','Y','2'),
			(14,10,7,'Kuasa Hukum Pemohon','Y','1'),
			(14,10,8,'Kuasa Hukum Termohon','Y','1'),
			(14,20,1,'Pembanding','Y','1'),
			(14,20,2,'Pembanding/Terbanding','Y','2'),
			(14,20,3,'Turut Terbanding','Y','3'),
			(14,20,4,'Terbanding','Y','4'),
			(14,20,5,'Terbanding/Pembanding','Y','5'),
			(14,30,1,'Pemohon Kasasi','Y','1'),
			(14,30,2,'Pemohon/Termohon Kasasi','Y','2'),
			(14,30,3,'Turut Termohon Kasasi','Y','3'),
			(14,30,4,'Termohon Kasasi','Y','4'),
			(14,30,5,'Termohon/Pemohon Kasasi','Y','5'),
			(14,40,1,'Pemohon PK','Y','1'),
			(14,40,2,'Pemohon/Termohon PK','Y','2'),
			(14,40,3,'Turut Termohon PK','Y','5'),
			(14,40,4,'Termohon PK','Y','3'),
			(14,40,5,'Termohon/Pemohon PK','Y','4'),
			(14,50,1,'Pemohon','Y','1'),
			(14,50,2,'Termohon','Y','2'),
			(1,10,13,'Saksi','Y',1),
			(2,10,13,'Saksi','Y',1),
			(3,10,13,'Saksi','Y',1),
			(4,10,13,'Saksi','Y',1),
			(5,10,13,'Saksi','Y',1),
			(6,10,13,'Saksi','Y',1),
			(7,10,13,'Saksi','Y',1),
			(8,10,13,'Saksi','Y',1),
			(111,10,13,'Saksi','Y',1),
			(112,10,13,'Saksi','Y',1),
			(113,10,13,'Saksi','Y',1),
			(114,10,13,'Saksi','Y',1),
			(115,10,13,'Saksi','Y',1),
			(116,10,13,'Saksi','Y',1),
			(117,10,13,'Saksi','Y',1),
			(118,10,13,'Saksi','Y',1),
			(119,10,13,'Saksi','Y',1),
			(10,10,13,'Saksi','Y',1),
			(11,10,13,'Saksi','Y',1),
			(12,10,13,'Saksi','Y',1),
			(13,10,13,'Saksi','Y',1),
			(14,10,13,'Saksi','Y',1),
			(121,10,13,'Saksi','Y',1);");

		$this->patching->exe_script("DROP TABLE IF EXISTS perkara_pihak5;");
		$this->patching->exe_script("CREATE TABLE perkara_pihak5 (
			id BIGINT(20) unsigned NOT NULL,
			perkara_id BIGINT(20) unsigned DEFAULT NULL,
			urutan TINYINT(11) unsigned DEFAULT NULL,
			saksi_pihak_ke TINYINT(1) UNSIGNED NULL,
			pihak_id BIGINT(20) unsigned DEFAULT NULL,
			jenis_pihak_id TINYINT(1) unsigned DEFAULT NULL,
			nama VARCHAR(500) DEFAULT NULL,
			alamat VARCHAR(500) DEFAULT NULL,
			pangkat VARCHAR(100) DEFAULT NULL,
			nrp VARCHAR(50) NULL,
			jabatan VARCHAR(100) NULL,
			kesatuan VARCHAR(100) NULL,
			keterangan VARCHAR(255) DEFAULT NULL,
			diinput_oleh VARCHAR(30) DEFAULT NULL,
			diinput_tanggal DATETIME DEFAULT NULL,
			diperbaharui_oleh VARCHAR(30) DEFAULT NULL,
			diperbaharui_tanggal DATETIME DEFAULT NULL,
			PRIMARY KEY (id),
			KEY perkara_id (perkara_id),
			KEY pihak_id (pihak_id),
			CONSTRAINT perkara_pihak5_fk FOREIGN KEY (perkara_id) REFERENCES perkara (perkara_id) ON DELETE CASCADE,
			CONSTRAINT perkara_pihak5_fk1 FOREIGN KEY (pihak_id) REFERENCES pihak (id)
		) ENGINE=InnoDB;");

		$this->patching->exe_script("REPLACE INTO sys_config (id, category, name, value)
		VALUES
			(83, 'System', 'jenis_pengadilan',1),
			(84,'Site', 'PangkatKetua',NULL),
			(85,'System','pangkat_wakil_ketua',NULL),
			(86,'System','pangkat_panitera',NULL),
			(87,'System','pangkat_wakil_panitera',NULL);");


		$this->patching->exe_script("UPDATE alur_perkara SET jenis_pengadilan = 1 WHERE id IN (1,2,3,4,5,6,7,8,111,112,113,114,115,116,117,118,119);");
		$this->patching->exe_script("UPDATE alur_perkara SET jenis_pengadilan = 2 WHERE id IN (120,121);");
		$this->patching->exe_script("UPDATE alur_perkara SET jenis_pengadilan = 3 WHERE id IN (9,10,11,12,13,14);");

		$this->patching->exe_script("REPLACE INTO alur_perkara (id,kode, nama, keterangan, aktif, urutan,jenis_pengadilan) 
		VALUES
			(9,'G','Gugatan','Gugatan','Y','1','3'),
			(10,'PMH-AP','Permohonan UU AP','Permohonan UU AP','T','2','3'),
			(11,'PMH-KIP','Permohonan Keberatan (KIP)','Permohonan Keberatan (KIP)','T','3','3'),
			(12,'PMH-FiPo','Permohonan Fiktif Positif','Permohonan Fiktif Positif','T','4','3'),
			(13,'PMH-PW','Permohonan Penyalahgunaan Wewenang','Permohonan Penyalahgunaan Wewenang','T','5','3'),
			(14,'PMH-Pertanahan','Permohonan Pertanahan','Permohonan Pertanahan','T','6','3'),
			(120, 'K', 'Pidana Kejahatan', 'Pidana Kejahatan','Y', '1', '2'),
			(121, 'P', 'Pidana Pelanggaran', 'Pidana Pelanggaran','Y', '2', '2'),
			(122, 'JN', 'Jinayat', 'Jinayat', 'Y', 1, '4'),
			(123, 'JN.Pra', 'Praperadilan Jinayat', 'Praperadilan Jinayat', 'Y', 1, '4');");



		//$this->patching->exe_script("UPDATE jenis_pihak SET jenis_pengadilan = 1 WHERE id IN (1,2,3);");
		$this->patching->exe_script("REPLACE INTO jenis_pihak (id,nama,aktif,jenis_pengadilan)
		VALUES
		(1,'Perorangan','Y','3'),
		(2,'Pemerintahan Pusat','Y','3'),
		(4,'Pemerintahan Daerah','Y','3'),
		(3,'Badan Hukum','Y','3'),
		(1,'Perorangan','Y','2'),
		(1,'Perorangan','Y',4),
		(3,'Badan Hukum','Y',4);");

		


		$this->patching->exe_script("REPLACE INTO pengadilan_negeri (id, pt_id, kode, kode_pn, nama, alamat, aktif, jenis_pengadilan)
			VALUES
				(1, 1, '98441', 'BNA', 'PENGADILAN NEGERI BANDA ACEH', 'Jl Cut Meutia N0 23', 'Y', '1'),
				(2, 1, '98455', '', 'PENGADILAN NEGERI SABANG', 'jl Jend. Ahmad Yani no 04', 'Y', '1'),
				(3, 1, '98462', '', 'PENGADILAN NEGERI SIGLI', 'Jl. Tgk. Chik Ditiro No. 48', 'Y', '1'),
				(4, 1, '98476', '', 'PENGADILAN NEGERI BIREUEN', 'Jl Sultan Malaikussaleh', 'Y', '1'),
				(5, 1, '98480', 'LSK', 'PENGADILAN NEGERI LHOKSUKON', 'Jl. T.P Polem no 3', 'Y', '1'),
				(6, 1, '98497', '', 'PENGADILAN NEGERI LHOKSEUMAWE', 'Jl Iskandar Muda', 'Y', '1'),
				(7, 1, '98502', '', 'PENGADILAN NEGERI TAKENGON', 'Jl. Yos Sudarso no 154 Takengon', 'Y', '1'),
				(8, 1, '98519', '', 'PENGADILAN NEGERI LANGSA', 'Jl. W.R Supratman No 10', 'Y', '1'),
				(9, 1, '98523', '', 'PENGADILAN NEGERI IDI', 'Jl. Petua Husin No 4', 'Y', '1'),
				(10, 1, '98530', '', 'PENGADILAN NEGERI KUALA SIMPANG', 'Jl. Ir. H. juanda Karang Baru no 22', 'Y', '1'),
				(11, 1, '98544', '', 'PENGADILAN NEGERI BLANGKEJEREN', 'Jl Kongbur no 52', 'Y', '1'),
				(12, 1, '98551', '', 'PENGADILAN NEGERI KUTACANE', 'Jl Cut Nyak Dien No 174', 'Y', '1'),
				(13, 1, '98565', '', 'PENGADILAN NEGERI MEULABOH', 'Jl. Dr .Sutomo No 5', 'Y', '1'),
				(14, 1, '98572', '', 'PENGADILAN NEGERI CALANG', 'Jl. Pengadilan No. 10', 'Y', '1'),
				(15, 1, '98586', '', 'PENGADILAN NEGERI SINABANG', 'Jl. T. Diujung No406', 'Y', '1'),
				(16, 1, '98590', '', 'PENGADILAN NEGERI TAPAKTUAN', 'Jl. syech abdurauf No 11', 'Y', '1'),
				(17, 1, '98608', '', 'PENGADILAN NEGERI SINGKIL', 'Jl Singkil Km 20', 'Y', '1'),
				(18, 1, '400415', '', 'PENGADILAN NEGERI JANTHO', 'JL. Bachtiar Panglima Polem No 3', 'Y', '1'),
				(19, 2, '98629', 'MDN', 'PENGADILAN NEGERI MEDAN', 'Jl. Pengadilan No. 8 Medan', 'Y', '1'),
				(20, 2, '98633', '', 'PENGADILAN NEGERI BINJAI', 'Jl. Jend. Gatot Subroto No. 77', 'Y', '1'),
				(21, 2, '98640', '', 'PENGADILAN NEGERI TANJUNG BALAI ASAHAN', 'Jl. Pahlawan No. 9 Tanjungbalai', 'Y', '1'),
				(22, 2, '98654', 'SDK', 'PENGADILAN NEGERI SIDIKALANG', 'Jl. Ahmad Yani No. 133', 'Y', '1'),
				(23, 2, '98661', '', 'PENGADILAN NEGERI KABANJAHE', 'Jl. Jamin Ginting No. 9 Kabanjahe', 'Y', '1'),
				(24, 2, '98675', '', 'PENGADILAN NEGERI RANTAU PRAPAT', 'Jl. Sisingamangaraja No. 58 Rantauprapat', 'Y', '1'),
				(25, 2, '98682', 'TTD', 'PENGADILAN NEGERI TEBING TINGGI', 'Jl. Merdeka No. 2 Tebing Tinggi', 'Y', '1'),
				(26, 2, '98696', '', 'PENGADILAN NEGERI GUNUNG SITOLI', 'Jl. Pancasila No. 12 Gunungsitoli', 'Y', '1'),
				(27, 2, '98701', '', 'PENGADILAN NEGERI PEMATANG SIANTAR', 'Jl. Jend. Sudirman No. 15 Pematangsiantar', 'Y', '1'),
				(28, 2, '98718', '', 'PENGADILAN NEGERI TARUTUNG', 'Jl. MAYJEN YUNUS SAMOSIR NO 93 TARUTUNG', 'Y', '1'),
				(29, 2, '98722', '', 'PENGADILAN NEGERI PADANG SIDEMPUAN', 'Jl. Jend. Sudirman No. 10 Padangsidimpuan', 'Y', '1'),
				(30, 2, '98739', '', 'PENGADILAN NEGERI SIBOLGA', 'Jl. Padangsidimpuan No. 6 Sibolga', 'Y', '1'),
				(31, 2, '108025', 'STB', 'PENGADILAN NEGERI STABAT', 'Jl. Proklamasi No. 49 Stabat', 'Y', '1'),
				(32, 2, '400370', '', 'PENGADILAN NEGERI SIMALUNGUN', 'Jl. Asahan Km. 4  Kec. Siantar, Kab. Simalungun', 'Y', '1'),
				(33, 2, '400389', '', 'PENGADILAN NEGERI KISARAN', 'Jl. Ahmad Yani No. 33 Kisaran', 'Y', '1'),
				(34, 2, '400395', '', 'PENGADILAN NEGERI LUBUK PAKAM', 'Jl. Jend. Sudirman No. 58 Lubuk Pakam', 'Y', '1'),
				(35, 2, '477399', '', 'PENGADILAN NEGERI MANDAILING NATAL', 'Jl. Lintas Sumatera Km. 7 Panyabungan', 'Y', '1'),
				(36, 2, '672910', '', 'PENGADILAN NEGERI BALIGE', 'Jl. Patuan Nagari No. 6 Balige', 'Y', '1'),
				(37, 3, '98750', '', 'PENGADILAN NEGERI PADANG', 'Jl. Khatib Sulaiman No.80 Padang', 'Y', '1'),
				(38, 3, '98764', 'SWL', 'PENGADILAN NEGERI SAWAHLUNTO', 'Jl. Jenderal Sudirman No. 3 Sawahlunto', 'Y', '1'),
				(39, 3, '98771', '', 'PENGADILAN NEGERI BATUSANGKAR', 'Jln. Lareh Nan Panjang No.103', 'Y', '1'),
				(40, 3, '98785', '', 'PENGADILAN NEGERI SOLOK', 'Jl. Lubuk Sikarah No. 32', 'Y', '1'),
				(41, 3, '98792', '', 'PENGADILAN NEGERI PARIAMAN', 'Jl. Imam Bonjol No. 26', 'Y', '1'),
				(42, 3, '98807', '', 'PENGADILAN NEGERI PAINAN', 'Jl. Jenderal Sudirman No. 158 Salido Painan', 'Y', '1'),
				(43, 3, '98811', '', 'PENGADILAN NEGERI BUKITTINGGI', 'Jl. Veteran No. 219 A Kota Bukittinggi', 'Y', '1'),
				(44, 3, '98828', '', 'PENGADILAN NEGERI LUBUK SIKAPING', 'Jl. Sudirman No.64', 'Y', '1'),
				(45, 3, '98832', '', 'PENGADILAN NEGERI PAYAKUMBUH', 'Jl. Soekarno Hatta No. 240', 'Y', '1'),
				(46, 3, '400188', 'PP', 'PENGADILAN NEGERI PADANG PANJANG', 'Jl.Soekarno Hatta, No.7', 'Y', '1'),
				(47, 3, '400333', '', 'PENGADILAN NEGERI LUBUK BASUNG', 'Jl. DR. M. Hatta No. 538', 'Y', '1'),
				(48, 3, '400421', '', 'PENGADILAN NEGERI TANJUNG PATI', 'JALAN RAYA NEGARA KM.7 TANJUNG PATI', 'Y', '1'),
				(49, 3, '400446', '', 'PENGADILAN NEGERI KOTOBARU', 'Jl. Raya Koto Baru', 'Y', '1'),
				(50, 3, '400461', 'MR', 'PENGADILAN NEGERI MUARO', 'Jl. Prof. M. Yamin, SH No. 51  Muaro Sijunjung', 'Y', '1'),
				(51, 3, '477352', '', 'PENGADILAN NEGERI PASAMAN BARAT', 'JL. SOEKARNO-HATTA', 'Y', '1'),
				(52, 4, '98849', '', 'PENGADILAN NEGERI PEKANBARU', 'Jl. Teratai No.85', 'Y', '1'),
				(53, 4, '98853', '', 'PENGADILAN NEGERI BENGKALIS', 'Jl. Karimun No. 12 Bengkalis', 'Y', '1'),
				(54, 4, '98860', '', 'PENGADILAN NEGERI RENGAT/INDRAGIRI', 'Jl. Raya Belilas Pematang Reba', 'Y', '1'),
				(55, 4, '98874', '', 'PENGADILAN NEGERI TEMBILAHAN', 'JL. PROF. M. YAMIN, SH. NO. 02', 'Y', '1'),
				(56, 4, '400141', '', 'PENGADILAN NEGERI BANGKINANG', 'Jl. Letnan Boyak No. 77 Bangkinang', 'Y', '1'),
				(57, 4, '400327', '', 'PENGADILAN NEGERI DUMAI', 'Jl.RAYA BUKIT DATUK', 'Y', '1'),
				(58, 4, '477255', 'PLW', 'PENGADILAN NEGERI PELALAWAN', 'Jl. Hangtuah SP. VI Pangkalan Kerinci', 'Y', '1'),
				(59, 4, '477261', 'RHL', 'PENGADILAN NEGERI ROKAN HILIR', 'Jl. Lintas Riau-Sumut KM 167 Banjar XII Ujung Tanjung', 'Y', '1'),
				(60, 4, '477343', '', 'PENGADILAN NEGERI SIAK SRI INDRAPURA', 'Komplek Perkantoran Tanjung Agung', 'Y', '1'),
				(61, 4, '662990', '', 'PENGADILAN NEGERI PASIR PENGARAIAN', 'Jl. Diponegoro No. 102 Pasir Pangaraian', 'Y', '1'),
				(62, 5, '98895', '', 'PENGADILAN NEGERI JAMBI', 'Jl. A. Yani No. 16', 'Y', '1'),
				(63, 5, '98900', '', 'PENGADILAN NEGERI MUARA BUNGO', 'R.M. THAHER No. 495', 'Y', '1'),
				(64, 5, '98917', '', 'PENGADILAN NEGERI KUALA TUNGKAL', 'Jl. Prof. Dr. Sri Soedewi MS, SH Kuala Tungkal', 'Y', '1'),
				(65, 5, '98921', '', 'PENGADILAN NEGERI SUNGAI PENUH', 'Jl. Depati Parbo No.24', 'Y', '1'),
				(66, 5, '400311', '', 'PENGADILAN NEGERI BANGKO', 'JL. JEND. SUDIRMAN KM.2 BANGKO', 'Y', '1'),
				(67, 5, '400430', '', 'PENGADILAN NEGERI MUARA BULIAN', 'Jend. Sudirman Muara Bulian', 'Y', '1'),
				(68, 5, '477368', '', 'PENGADILAN NEGERI TEBO', 'Komp. Perkantoran Seentak Galah Serengkuh Dayung Jalan Lintas Tebo-Bungo Km.12 Muara Tebo', 'Y', '1'),
				(69, 5, '477374', '', 'PENGADILAN NEGERI SAROLANGUN', 'Komplek Perkantoran Gunung Kembang', 'Y', '1'),
				(70, 5, '477400', '', 'PENGADILAN NEGERI TANJUNG JABUNG TIMUR', 'Komplek Perkantoran Bukit Menderang', 'Y', '1'),
				(71, 5, '663012', '', 'PENGADILAN NEGERI SENGETI', 'Jl. Lintar Timur Sengeti', 'Y', '1'),
				(72, 6, '98942', 'PLG', 'PENGADILAN NEGERI PALEMBANG', 'JL. KAPTEN A. RIVAI NO.16', 'Y', '1'),
				(73, 6, '98959', 'KAG', 'PENGADILAN NEGERI KAYUAGUNG', 'JL. LETNAN MUCHTAR SALEH NO. 119', 'Y', '1'),
				(74, 6, '98963', 'BTA', 'PENGADILAN NEGERI BATURAJA', 'Jl.HS.Simanjuntak No.0792', 'Y', '1'),
				(75, 6, '98970', '', 'PENGADILAN NEGERI LUBUK LINGGAU', 'JL.DEPATI SAID,No. 01, Kel. SIDOREJO', 'Y', '1'),
				(76, 6, '98984', '', 'PENGADILAN NEGERI LAHAT', 'Jalan Kolonel Barlian Bandar Jaya', 'Y', '1'),
				(77, 6, '98991', '', 'PENGADILAN NEGERI MUARA ENIM', 'JL. JEND. AHMAD YANI NO. 17 A', 'Y', '1'),
				(78, 6, '99003', '', 'PENGADILAN NEGERI SEKAYU', 'JL. MERDEKA NO.485 LK.I SEKAYU', 'Y', '1'),
				(79, 8, '400452', '', 'PENGADILAN NEGERI KALIANDA', 'Jl. Indra Bangsawan No. 37 Kalianda', 'Y', '1'),
				(80, 7, '400110', '', 'PENGADILAN NEGERI BENGKULU', 'Jl. S. PArman', 'Y', '1'),
				(81, 7, '400126', '', 'PENGADILAN NEGERI CURUP', 'jl. Basuki Rahmat No. 15 curup', 'Y', '1'),
				(82, 7, '400132', '', 'PENGADILAN NEGERI MANNA', 'Jl. Affan Bachsin No. 109 Manna', 'Y', '1'),
				(83, 7, '400239', '', 'PENGADILAN NEGERI ARGA MAKMUR', 'isi', 'Y', '1'),
				(84, 7, '672994', '', 'PENGADILAN NEGERI BINTUHAN', 'Jl. Pengadilan - Padang Kempas Kab. Kaur', 'Y', '1'),
				(85, 7, '673041', '', 'PENGADILAN NEGERI KEPAHIANG', 'Jl. Aipda Muan Komplek Perkantoran Pemkab Kepahiang', 'Y', '1'),
				(86, 8, '99031', '', 'PENGADILAN NEGERI TANJUNG KARANG', 'Jl. Wolter Monginsidi No. 27 Tanjung Karang', 'Y', '1'),
				(87, 8, '99045', '', 'PENGADILAN NEGERI METRO', 'Jl. Sutan Sjahrir, Kota Metro', 'Y', '1'),
				(88, 8, '99052', '', 'PENGADILAN NEGERI KOTABUMI', 'Jl. Jend. Sudirman No. 136 Kotabumi', 'Y', '1'),
				(89, 8, '477306', '', 'PENGADILAN NEGERI KOTA AGUNG', 'Jl. Jend. Suprapto Kota Agung,', 'Y', '1'),
				(90, 8, '614883', '', 'PENGADILAN NEGERI LIWA KABUPATEN LAMPUNG BARAT', 'Jl. Raden Intan Liwa', 'Y', '1'),
				(91, 8, '663026', '', 'PENGADILAN NEGERI MENGGALA', 'Jl. Cemara Komp. Perkantoran Pemda Tulang Bawang', 'Y', '1'),
				(92, 8, '663030', '', 'PENGADILAN NEGERI GUNUNG SUGIH', 'Jl. Negara Gunung Sugih', 'Y', '1'),
				(93, 8, '663047', '', 'PENGADILAN NEGERI SUKADANA', 'Jl. Sampurna Jaya No. 1 Sukadana', 'Y', '1'),
				(94, 8, '663051', '', 'PENGADILAN NEGERI BLAMBANGAN UMPU', 'Jl. R. Jambat No. 65 Blambangan Umpu', 'Y', '1'),
				(95, 9, '99010', '', 'PENGADILAN NEGERI PANGKALPINANG', 'Jl. Jendral Sudirman No.09 Pangkalpinang', 'Y', '1'),
				(96, 9, '99024', '', 'PENGADILAN NEGERI SUNGAI LIAT', 'Jl. Pemuda no. 12 Sungailiat', 'Y', '1'),
				(97, 9, '400600', '', 'PENGADILAN NEGERI TANJUNG PANDAN', 'Jl. Sriwijaya No. 1  Tanjungpandan', 'Y', '1'),
				(98, 4, '98881', '', 'PENGADILAN NEGERI TANJUNG PINANG', 'Jl. Jend. A. Yani No. 29', 'Y', '1'),
				(99, 4, '108309', '', 'PENGADILAN NEGERI BATAM', 'Engku Putri Batam Center Kota Batam', 'Y', '1'),
				(100, 4, '663005', '', 'PENGADILAN NEGERI TANJUNG BALAI KARIMUN', 'Jln. Jend. Sudirman', 'Y', '1'),
				(101, 11, '97471', '', 'PENGADILAN NEGERI JAKARTA PUSAT', 'Jalan Gajah Mada No.17', 'Y', '1'),
				(102, 11, '97488', '', 'PENGADILAN NEGERI JAKARTA BARAT', 'Jl.Let.Jend.S.Parman Kav.71 Slipi Jak-bar', 'Y', '1'),
				(103, 11, '97492', 'JKT.TIM', 'PENGADILAN NEGERI JAKARTA TIMUR', 'Jl. Dr. SUMARNO No.1, Penggilingan', 'Y', '1'),
				(104, 11, '400214', '', 'PENGADILAN NEGERI JAKARTA SELATAN', 'Jalan Ampera Raya No.133 Ragunan Jakarta Selatan', 'Y', '1'),
				(105, 11, '400220', '', 'PENGADILAN NEGERI JAKARTA UTARA', 'JL. RE MARTADINATA NO. 4 ANCOL SELATAN', 'Y', '1'),
				(106, 12, '97514', 'BDG', 'PENGADILAN NEGERI BANDUNG', 'Jl. RE Martadinata no. 74-80', 'Y', '1'),
				(107, 12, '97521', 'SMD', 'PENGADILAN NEGERI SUMEDANG', 'Jln. Raya Sumedang-Cirebon Km. 04 No. 52', 'Y', '1'),
				(108, 12, '97535', '', 'PENGADILAN NEGERI TASIKMALAYA', 'Jl. Siliwangi no. 18', 'Y', '1'),
				(109, 12, '97542', 'GRT', 'PENGADILAN NEGERI GARUT', 'Jl. merdeka No. 123', 'Y', '1'),
				(110, 12, '97556', '', 'PENGADILAN NEGERI CIAMIS', 'Jl. Jenderal Sudirman No.116', 'Y', '1'),
				(111, 12, '97603', '', 'PENGADILAN NEGERI PURWAKARTA', 'Jl. Kolonel Singawinata No. 101', 'Y', '1'),
				(112, 12, '97610', '', 'PENGADILAN NEGERI BEKASI', 'Jl.Pramuka No.81, Bekasi', 'Y', '1'),
				(113, 12, '97624', '', 'PENGADILAN NEGERI KARAWANG', 'Jl. Jend.A Yani (By Pass)', 'Y', '1'),
				(114, 12, '97631', '', 'PENGADILAN NEGERI SUBANG', 'Jl. Mayjen Sutoyo. S. No. 1', 'Y', '1'),
				(115, 12, '97645', '', 'PENGADILAN NEGERI BOGOR', 'Jl. Pengadilan No.10 Bogor', 'Y', '1'),
				(116, 12, '97652', '', 'PENGADILAN NEGERI SUKABUMI', 'Jl. Bhayangkara No. 105', 'Y', '1'),
				(117, 12, '97666', '', 'PENGADILAN NEGERI CIANJUR', 'Jl. Dr. Muwardi No. 174', 'Y', '1'),
				(118, 12, '97670', '', 'PENGADILAN NEGERI CIREBON', 'Jl DR Wahidin Sudirohusodo No. 18', 'Y', '1'),
				(119, 12, '97687', '', 'PENGADILAN NEGERI INDRAMAYU', 'JL. JEND. SUDIRMAN NO. 183', 'Y', '1'),
				(120, 12, '97691', '', 'PENGADILAN NEGERI MAJALENGKA', 'K.H.Abdul Halim 499 Majalengka', 'Y', '1'),
				(121, 12, '97709', '', 'PENGADILAN NEGERI KUNINGAN', 'JL.Pengadilan No. 2', 'Y', '1'),
				(122, 12, '400409', '', 'PENGADILAN NEGERI CIBADAK', 'Jln. Jend. Sudirman Blok Jajaway No. 2  Palabuhanratu', 'Y', '1'),
				(123, 12, '400477', '', 'PENGADILAN NEGERI SUMBER', 'Jl. Sunan Drajat No. 4', 'Y', '1'),
				(124, 12, '400483', '', 'PENGADILAN NEGERI BALE BANDUNG', 'Jl. Jaksa Naranata No. 1 Bale Endah', 'Y', '1'),
				(125, 12, '477292', '', 'PENGADILAN NEGERI DEPOK', 'Jalan Boulevard No. 7 komplek Perkantoran Kota Depok', 'Y', '1'),
				(126, 12, '613519', '', 'PENGADILAN NEGERI CIBINONG', 'Jl.Tegar Beriman No.5 Cibinong', 'Y', '1'),
				(127, 13, '97720', 'SMG', 'PENGADILAN NEGERI SEMARANG', 'Jl. Siliwangi No.512', 'Y', '1'),
				(128, 13, '97734', '', 'PENGADILAN NEGERI TEGAL', 'Jl. Mayjend. Sutoyo SM. No. 9', 'Y', '1'),
				(129, 13, '97741', '', 'PENGADILAN NEGERI PEKALONGAN', 'Jalan Cendrawasih Nomor 2 Pekalongan', 'Y', '1'),
				(130, 13, '97755', 'KDS', 'PENGADILAN NEGERI KUDUS', 'Jl. Sunan Muria No. 1', 'Y', '1'),
				(131, 13, '97762', '', 'PENGADILAN NEGERI PATI', 'Jalan Raya Pati-Kudus KM 3', 'Y', '1'),
				(132, 13, '97776', '', 'PENGADILAN NEGERI BREBES', 'Jl. A. Yani No. 89', 'Y', '1'),
				(133, 13, '97780', '', 'PENGADILAN NEGERI PEMALANG', 'Jl. Pemuda No. 59 Pemalang', 'Y', '1'),
				(134, 13, '97797', '', 'PENGADILAN NEGERI KENDAL', 'Jl. Soekarno Hatta No.220', 'Y', '1'),
				(135, 13, '97802', '', 'PENGADILAN NEGERI DEMAK', 'Jl. Sultan Trenggono No. 27 Demak', 'Y', '1'),
				(136, 13, '97819', '', 'PENGADILAN NEGERI PURWODADI', 'Jl. Letjen R. Soeprapto No. 109 Purwodadi', 'Y', '1'),
				(137, 13, '97823', '', 'PENGADILAN NEGERI SALATIGA', 'JL. VETERAN NO.4', 'Y', '1'),
				(138, 13, '97830', '', 'PENGADILAN NEGERI KABUPATEN SEMARANG DI UNGARAN', 'Jln. Gatot Subroto No.16, Ungaran', 'Y', '1'),
				(139, 13, '97844', '', 'PENGADILAN NEGERI JEPARA', 'Jl. KHA. Fauzan No. 04', 'Y', '1'),
				(140, 13, '97851', '', 'PENGADILAN NEGERI BLORA', 'Jl. Raya Blora-Cepu Km. 5', 'Y', '1'),
				(141, 13, '97865', '', 'PENGADILAN NEGERI REMBANG', 'Jl. P. Diponegoro No. 97', 'Y', '1'),
				(142, 13, '97872', '', 'PENGADILAN NEGERI BATANG', 'Jl. Slamet Riyadi No. 05', 'Y', '1'),
				(143, 13, '97886', '', 'PENGADILAN NEGERI PURWOREJO', 'Jalan Tentara Pelajar KM.4', 'Y', '1'),
				(144, 13, '97890', '', 'PENGADILAN NEGERI MAGELANG', 'Jl. Veteran No. 1 Magelang', 'Y', '1'),
				(145, 13, '97908', '', 'PENGADILAN NEGERI KEBUMEN', 'JL.Indrakila No.15', 'Y', '1'),
				(146, 13, '97912', '', 'PENGADILAN NEGERI TEMANGGUNG', 'Jl.Jend.sudirman', 'Y', '1'),
				(147, 13, '97929', '', 'PENGADILAN NEGERI WONOSOBO', 'Jl. Tumenggung Jogonegoro No. 38', 'Y', '1'),
				(148, 13, '97933', '', 'PENGADILAN NEGERI SURAKARTA', 'Jl. Slamet riyadi no.290 Surakarta', 'Y', '1'),
				(149, 13, '97940', '', 'PENGADILAN NEGERI SRAGEN', 'JL.Raya Sukowati No.253 Sragen', 'Y', '1'),
				(150, 13, '97954', '', 'PENGADILAN NEGERI WONOGIRI', 'Jl. RM.Said', 'Y', '1'),
				(151, 13, '97961', '', 'PENGADILAN NEGERI SUKOHARJO', 'Jl. Jenderal Sudirman No. 193 Sukoharjo', 'Y', '1'),
				(152, 13, '97975', '', 'PENGADILAN NEGERI KARANGANYAR', 'Jl. Lawu Barat No. 76 B', 'Y', '1'),
				(153, 13, '97982', '', 'PENGADILAN NEGERI BOYOLALI', 'Jl. Perintis Kemerdekaan No.2', 'Y', '1'),
				(154, 13, '97996', 'KLT', 'PENGADILAN NEGERI KLATEN', 'Jl. Raya-Klaten Solo Km. 2, Klaten', 'Y', '1'),
				(155, 13, '98001', '', 'PENGADILAN NEGERI PURWOKERTO', 'Jl.Gerilya.no.241 Purwokerto', 'Y', '1'),
				(156, 13, '98015', '', 'PENGADILAN NEGERI CILACAP', 'Jln. Letjen Suprapto No. 67', 'Y', '1'),
				(157, 13, '98022', '', 'PENGADILAN NEGERI BANYUMAS', 'Jl. Pramuka No. 9', 'Y', '1'),
				(158, 13, '98036', '', 'PENGADILAN NEGERI PURBALINGGA', 'Jl. Letnan Akhmadi D-80 Purbalingga', 'Y', '1'),
				(159, 13, '98040', '', 'PENGADILAN NEGERI BANJARNEGARA', 'Jln. Let. Jend. Soeprapto 121/ 44', 'Y', '1'),
				(160, 13, '400565', '', 'PENGADILAN NEGERI KABUPATEN TEGAL DI SLAWI', 'JL. A.YANI NO. 99 PROCOT, SLAWI', 'Y', '1'),
				(161, 13, '400571', '', 'PENGADILAN NEGERI KABUPATEN MAGELANG DI MUNGKID', 'Jalan Soekarno Hatta No. 9 Mungkid', 'Y', '1'),
				(162, 14, '98057', '', 'PENGADILAN NEGERI YOGYAKARTA', 'Jalan Kapas No. 10', 'Y', '1'),
				(163, 14, '98061', 'WT', 'PENGADILAN NEGERI WATES', 'Jalan Sugiman No. 19 Wates', 'Y', '1'),
				(164, 14, '98078', '', 'PENGADILAN NEGERI WONOSARI', 'Jl. Taman Bhakti No. 1', 'Y', '1'),
				(165, 14, '98082', 'SLMN', 'PENGADILAN NEGERI SLEMAN', 'Jl.Merapi,beran,Sleman', 'Y', '1'),
				(166, 14, '400172', '', 'PENGADILAN NEGERI BANTUL', 'Jl. Prof. Dr. Soepomo, SH. No.04', 'Y', '1'),
				(167, 15, '98111', 'SBY', 'PENGADILAN NEGERI SURABAYA', 'Jl. Raya Arjuna No. 16-18', 'Y', '1'),
				(168, 15, '98125', '', 'PENGADILAN NEGERI BOJONEGORO', 'Jl. Hayam Wuruk No. 131', 'Y', '1'),
				(169, 15, '98132', 'TBN', 'PENGADILAN NEGERI TUBAN', 'Jl. Veteran No. 8', 'Y', '1'),
				(170, 15, '98146', '', 'PENGADILAN NEGERI LAMONGAN', 'Jl. Veteran No. 18', 'Y', '1'),
				(171, 15, '98150', '', 'PENGADILAN NEGERI GRESIK', 'Jl. Raya Permata No. 6', 'Y', '1'),
				(172, 15, '98167', 'SDA', 'PENGADILAN NEGERI SIDOARJO', 'Jl. Jaksa Agung R. Suprapto No. 10', 'Y', '1'),
				(173, 15, '98171', 'MKT', 'PENGADILAN NEGERI MOJOKERTO', 'Jl. RA. Basuni No. 11', 'Y', '1'),
				(174, 15, '98188', '', 'PENGADILAN NEGERI JOMBANG', 'Jl. KH. Wahid Hasyim No. 135', 'Y', '1'),
				(175, 15, '98192', '', 'PENGADILAN NEGERI BONDOWOSO', 'Jl. Santawi No. 59', 'Y', '1'),
				(176, 15, '98200', '', 'PENGADILAN NEGERI JEMBER', 'Jl. Kalimantan No. 3, Kotak Pos 103', 'Y', '1'),
				(177, 15, '98214', '', 'PENGADILAN NEGERI BANYUWANGI', 'Jl. Adi Sucipto No. 26', 'Y', '1'),
				(178, 15, '98221', '', 'PENGADILAN NEGERI SITUBONDO', 'Jl. PB Sudirman No. 97', 'Y', '1'),
				(179, 15, '98235', '', 'PENGADILAN NEGERI KEDIRI', 'Jl. Dr. Saharjo No. 20', 'Y', '1'),
				(180, 15, '98242', '', 'PENGADILAN NEGERI NGANJUK', 'Jl. Dermojoyo No. 20', 'Y', '1'),
				(181, 15, '98256', 'TA', 'PENGADILAN NEGERI TULUNGAGUNG', 'Jl. Jayengkusuma no.21 Tulungagung', 'Y', '1'),
				(182, 15, '98260', 'TL', 'PENGADILAN NEGERI TRENGGALEK', 'Jl. Dewi Sartika No.1', 'Y', '1'),
				(183, 15, '98277', '', 'PENGADILAN NEGERI BLITAR', 'Jl. Imam Bonjol No. 68', 'Y', '1'),
				(184, 15, '98281', '', 'PENGADILAN NEGERI MALANG', 'Jl. Jend. A. Yani Utara No. 198', 'Y', '1'),
				(185, 15, '98298', '', 'PENGADILAN NEGERI PASURUAN', 'Jl. Pahlawan No. 24', 'Y', '1'),
				(186, 15, '98303', '', 'PENGADILAN NEGERI PROBOLINGGO', 'Jl. Dr. Moch. Saleh No. 26', 'Y', '1'),
				(187, 15, '98310', '', 'PENGADILAN NEGERI LUMAJANG', 'Jl. Jend. Gatot Subroto No. 74', 'Y', '1'),
				(188, 15, '98324', '', 'PENGADILAN NEGERI BANGIL', 'Jl. Dr. Sutomo No. 25', 'Y', '1'),
				(189, 15, '98331', '', 'PENGADILAN NEGERI KRAKSAAN', 'Jl. Raya Panglima Sudirman No. 5 Kraksaan', 'Y', '1'),
				(190, 15, '98345', '', 'PENGADILAN NEGERI MADIUN', 'Jl. R.A. Kartni No. 7', 'Y', '1'),
				(191, 15, '98352', '', 'PENGADILAN NEGERI PONOROGO', 'Jl. Ir. H. Juanda No. 23', 'Y', '1'),
				(192, 15, '98366', '', 'PENGADILAN NEGERI PACITAN', 'Jl. Yos Sudarso No. 2', 'Y', '1'),
				(193, 15, '98370', '', 'PENGADILAN NEGERI NGAWI', 'Jl. PB Sudirman No. 97', 'Y', '1'),
				(194, 15, '98387', '', 'PENGADILAN NEGERI MAGETAN', 'Jl. Karya Dharma No. 10', 'Y', '1'),
				(195, 15, '98391', '', 'PENGADILAN NEGERI PAMEKASAN', 'Jl. Pangeran Trunojoyo', 'Y', '1'),
				(196, 15, '98409', '', 'PENGADILAN NEGERI SUMENEP', 'Jl. K.H. Mansyur (Pabian) No. 49', 'Y', '1'),
				(197, 15, '98413', '', 'PENGADILAN NEGERI BANGKALAN', 'Jl. Sukarno Hatta No. 4', 'Y', '1'),
				(198, 15, '98420', '', 'PENGADILAN NEGERI SAMPANG', 'Jl. Jaksa Agung Suprapto No. 74', 'Y', '1'),
				(199, 15, '400580', '', 'PENGADILAN NEGERI KAB. KEDIRI', 'Jl. Pamenang No. 60Gampeng Rejo,', 'Y', '1'),
				(200, 15, '400596', '', 'PENGADILAN NEGERI KAB. MADIUN', 'Jl. Soekarno - Hatta No. 15', 'Y', '1'),
				(201, 15, '626156', '', 'PENGADILAN NEGERI KEPANJEN', 'Jl. R. Panji No. 205, Kepanjen', 'Y', '1'),
				(202, 16, '97560', 'SRG', 'PENGADILAN NEGERI SERANG', 'JL. K.H. ABDUL HADI NO. 29', 'Y', '1'),
				(203, 16, '97577', '', 'PENGADILAN NEGERI RANGKAS BITUNG', 'Jl. RA. Kartini No. 55 Rangkasbitung', 'Y', '1'),
				(204, 16, '97581', '', 'PENGADILAN NEGERI PANDEGLANG', 'Jl. Raya Serang KM.1 Curug Sawer', 'Y', '1'),
				(205, 16, '97598', '', 'PENGADILAN NEGERI TANGERANG', 'Jl. T.M.P Taruna Tangerang No. 7', 'Y', '1'),
				(206, 17, '99780', 'DPS', 'PENGADILAN NEGERI DENPASAR', 'Jl. P. B. Sudirman No.1 Denpasar', 'Y', '1'),
				(207, 17, '99794', '', 'PENGADILAN NEGERI SINGARAJA', 'Jalan Kartini No. 2', 'Y', '1'),
				(208, 17, '99802', '', 'PENGADILAN NEGERI NEGARA', 'JL. MAYOR SUGIANYAR 1 NEGARA', 'Y', '1'),
				(209, 17, '99816', '', 'PENGADILAN NEGERI SEMARAPURA', 'Jl. Gajah Mada no 59 Semarapura', 'Y', '1'),
				(210, 17, '99820', '', 'PENGADILAN NEGERI TABANAN', 'Jl. Pahlawan No.6', 'Y', '1'),
				(211, 17, '99837', '', 'PENGADILAN NEGERI AMLAPURA', 'Jl. Kapten Jaya Tirta No 14, Amlapura', 'Y', '1'),
				(212, 17, '99841', '', 'PENGADILAN NEGERI GIANYAR', 'Jl. Ciung Wenara No.1 B Gianyar', 'Y', '1'),
				(213, 17, '99858', 'BLI', 'PENGADILAN NEGERI BANGLI', 'Jl. Brigjen Ngurah Rai No. 61', 'Y', '1'),
				(214, 18, '99862', '', 'PENGADILAN NEGERI MATARAM', 'Jl. Langko No. 68A', 'Y', '1'),
				(215, 18, '99879', '', 'PENGADILAN NEGERI RABA/BIMA', 'JL.SOEKARNO HATTA NO. 161', 'Y', '1'),
				(216, 18, '99883', 'SBB', 'PENGADILAN NEGERI SUMBAWA BESAR', 'JL. GARUDA NO.105', 'Y', '1'),
				(217, 18, '99890', '', 'PENGADILAN NEGERI SELONG', 'JL.PROF.SOEPOMO NO.1', 'Y', '1'),
				(218, 18, '99905', 'DOM', 'PENGADILAN NEGERI DOMPU', 'JL. BERINGIN NO. 2', 'Y', '1'),
				(219, 18, '99912', '', 'PENGADILAN NEGERI PRAYA', 'Jl.Diponegoro No.2 Praya', 'Y', '1'),
				(220, 19, '99926', '', 'PENGADILAN NEGERI KUPANG', 'Jl. PALAPA', 'Y', '1'),
				(221, 19, '99930', '', 'PENGADILAN NEGERI ATAMBUA', 'Jl. Prof. Soepomo, SH.', 'Y', '1'),
				(222, 19, '99947', '', 'PENGADILAN NEGERI SOE', 'Soe', 'Y', '1'),
				(223, 19, '99951', '', 'PENGADILAN NEGERI KEFAMENANU', 'kefa', 'Y', '1'),
				(224, 19, '99968', '', 'PENGADILAN NEGERI WAINGAPU', 'M. T. Haryono Nomor 11', 'Y', '1'),
				(225, 19, '99972', '', 'PENGADILAN NEGERI WAIKABUBAK', 'Jl.Jend.Sudirman No.10', 'Y', '1'),
				(226, 19, '99989', '', 'PENGADILAN NEGERI ENDE', 'Ende', 'Y', '1'),
				(227, 19, '99993', '', 'PENGADILAN NEGERI MAUMERE', 'Jl. AHMAD YANI NO.18', 'Y', '1'),
				(228, 19, '400007', '', 'PENGADILAN NEGERI LARANTUKA', 'Larantuka', 'Y', '1'),
				(229, 19, '400013', '', 'PENGADILAN NEGERI RUTENG', 'Jl. Komodo Nomor 30 - Ruteng', 'Y', '1'),
				(230, 19, '400157', '', 'PENGADILAN NEGERI BAJAWA', '400158', 'Y', '1'),
				(231, 19, '400163', '', 'PENGADILAN NEGERI KALABAHI', 'JL. Jend. Sudirman No. 20, Kalabahi', 'Y', '1'),
				(232, 19, '477230', '', 'PENGADILAN NEGERI LEMBATA', 'Jalan Trans Atadei', 'Y', '1'),
				(233, 19, '477249', '', 'PENGADILAN NEGERI ROTE NDAO', 'Rote', 'Y', '1'),
				(234, 20, '99066', '', 'PENGADILAN NEGERI PONTIANAK', 'Jl. Sultan Abdurrahman No. 89', 'Y', '1'),
				(235, 20, '99070', '', 'PENGADILAN NEGERI SINGKAWANG', 'FIRDAUS H. RAIS NO. 3', 'Y', '1'),
				(236, 20, '99087', '', 'PENGADILAN NEGERI SINTANG', 'Jl. Letjen S. Parman No.106', 'Y', '1'),
				(237, 20, '99091', '', 'PENGADILAN NEGERI KETAPANG', 'JL. Jendral Sudirman No. 19', 'Y', '1'),
				(238, 20, '99109', '', 'PENGADILAN NEGERI MEMPAWAH', 'Jl. Raden Kusno No. 80 Mempawah', 'Y', '1'),
				(239, 20, '99113', 'SGU', 'PENGADILAN NEGERI SANGGAU', 'Jl. Jenderal Sudirman No. 1/XXI', 'Y', '1'),
				(240, 20, '400194', '', 'PENGADILAN NEGERI PUTUSSIBAU', 'Jl. Antasari No. 03', 'Y', '1'),
				(241, 20, '670227', '', 'PENGADILAN NEGERI SAMBAS', 'Jl. Pembangunan Sambas', 'Y', '1'),
				(242, 20, '670231', '', 'PENGADILAN NEGERI BENGKAYANG', 'Jl. Trans Rangkang', 'Y', '1'),
				(243, 21, '99120', '', 'PENGADILAN NEGERI PALANGKARAYA', 'Jl.Diponegoro No. 21 Palangka Raya', 'Y', '1'),
				(244, 21, '99134', '', 'PENGADILAN NEGERI PANGKALAN BUN', 'Jl. Sutan Syahrir No. 16', 'Y', '1'),
				(245, 21, '99141', '', 'PENGADILAN NEGERI MUARA TEWEH', 'Jln. Yetro Sinseng No. 08', 'Y', '1'),
				(246, 21, '99155', '', 'PENGADILAN NEGERI KUALA KAPUAS', 'Jl. Tambun Bungai No. 55', 'Y', '1'),
				(247, 21, '99162', '', 'PENGADILAN NEGERI BUNTOK', 'Jl. Pelita Raya  No. 20', 'Y', '1'),
				(248, 21, '99176', '', 'PENGADILAN NEGERI SAMPIT', 'Jl.HM.Arsyad No.36', 'Y', '1'),
				(249, 21, '670191', '', 'PENGADILAN NEGERI TAMIANG LAYANG', 'Jl. A. Yani, Tamiang Layang', 'Y', '1'),
				(250, 25, '672980', '', 'PENGADILAN NEGERI PARIGI', 'JL. sungai pakabata', 'Y', '1'),
				(251, 22, '99197', '', 'PENGADILAN NEGERI BANJARMASIN', 'Jl. May. Jend. DI Panjaitan No. 27 Banjarmasin', 'Y', '1'),
				(252, 22, '99202', '', 'PENGADILAN NEGERI KANDANGAN', 'Jl. Pangeran Antasari No. 2', 'Y', '1'),
				(253, 22, '99219', '', 'PENGADILAN NEGERI KOTABARU', 'Jl. Jamrud 1', 'Y', '1'),
				(254, 22, '99223', '', 'PENGADILAN NEGERI BARABAI', 'Murakata No.1', 'Y', '1'),
				(255, 22, '99230', '', 'PENGADILAN NEGERI MARTAPURA', 'Jalan Jenderal A. yani N0. 32 Martapura', 'Y', '1'),
				(256, 22, '99244', '', 'PENGADILAN NEGERI TANJUNG', 'Jl. Jend.Sudirman No. 18 Tanjung 71513', 'Y', '1'),
				(257, 22, '99251', '', 'PENGADILAN NEGERI AMUNTAI', 'Jl. A. Yani No. 5 Amuntai', 'Y', '1'),
				(258, 22, '99265', '', 'PENGADILAN NEGERI RANTAU', 'Jl. Brig. Jend. H. Hasan Basery No. 38 Rantau', 'Y', '1'),
				(259, 22, '400260', '', 'PENGADILAN NEGERI MARABAHAN', 'Jl. Putri Junjung Buih No.77', 'Y', '1'),
				(260, 22, '400282', '', 'PENGADILAN NEGERI PELAIHARI', 'Jl.H.Boejasin Komplek Perkantoran Gagas Pelaihari', 'Y', '1'),
				(261, 22, '653458', '', 'PENGADILAN NEGERI BANJARBARU', 'Jl. Trikora No.3', 'Y', '1'),
				(262, 23, '99272', '', 'PENGADILAN NEGERI TARAKAN', 'Jl. Diponegoro, No. 99 Tarakan', 'Y', '1'),
				(263, 23, '99286', 'SMDA', 'PENGADILAN NEGERI SAMARINDA', 'Jl. M. Yamin Samarinda', 'Y', '1'),
				(264, 23, '99290', '', 'PENGADILAN NEGERI TENGGARONG', 'Jl. Ahmad Yani no. 16 Tenggarong', 'Y', '1'),
				(265, 23, '99308', '', 'PENGADILAN NEGERI BALIKPAPAN', 'Jl. Jenderal Sudirman No. 788', 'Y', '1'),
				(266, 23, '400291', '', 'PENGADILAN NEGERI TANJUNG REDEP', 'Jl. Pemuda No. 26, Tanjung Redeb', 'Y', '1'),
				(267, 23, '400302', '', 'PENGADILAN NEGERI TANAH GROGOT', 'Jl. Jenderal Sudirman, No. 19, Tanah Grogot', 'Y', '1'),
				(268, 23, '477270', '', 'PENGADILAN NEGERI NUNUKAN', 'Jl. Ujang Dewa, Sedadap, Nunukan', 'Y', '1'),
				(269, 23, '477286', 'MLN', 'PENGADILAN NEGERI MALINAU', 'Jl. Pusat Pemerintahan, Malinau', 'Y', '1'),
				(270, 23, '477380', '', 'PENGADILAN NEGERI KUTAI BARAT', 'Jl. Sendawar Raya, Barong Tongkok', 'Y', '1'),
				(271, 23, '662972', '', 'PENGADILAN NEGERI BONTANG', 'Jl. Awang Long, No. 10, Bontang', 'Y', '1'),
				(272, 23, '662986', '', 'PENGADILAN NEGERI SANGATTA', 'Jl. Prof. Dr. Wirjono Projodjodikoro, S.H, No. 1, Bukit Pelangi, Sangatta', 'Y', '1'),
				(273, 23, '670170', '', 'PENGADILAN NEGERI TANJUNG SELOR', 'Jl. Jelarai Raya, Tanjung Selor', 'Y', '1'),
				(274, 24, '99329', '', 'PENGADILAN NEGERI MANADO', 'Jl. Sam Ratulangi No. 18', 'Y', '1'),
				(275, 24, '99333', '', 'PENGADILAN NEGERI KOTAMOBAGU', 'Jl. Mayjend Soetoyo No. 348', 'Y', '1'),
				(276, 24, '99340', '', 'PENGADILAN NEGERI TAHUNA', 'Jl. Sam Ratulangi No. 10 Tahuna 95812', 'Y', '1'),
				(277, 24, '99354', '', 'PENGADILAN NEGERI TONDANO', 'Manguni No. 75 Tondano', 'Y', '1'),
				(278, 24, '568725', '', 'PENGADILAN NEGERI BITUNG', 'Jl. DR. Sam Ratulangi No.58', 'Y', '1'),
				(279, 24, '670210', '', 'PENGADILAN NEGERI AIRMADIDI', 'Kompleks Perkantoran Bupati Minahasa Utara', 'Y', '1'),
				(280, 25, '99375', '', 'PENGADILAN NEGERI PALU', 'Jl. Samratulangi Palu', 'Y', '1'),
				(281, 25, '99382', '', 'PENGADILAN NEGERI TOLI-TOLI', 'Jl. Magamu No. 84 Kel. Baru Kec. Baolan', 'Y', '1'),
				(282, 25, '99396', '', 'PENGADILAN NEGERI LUWUK', 'Jl.Jenderal Ahmad Yani No. 6 Luwuk', 'Y', '1'),
				(283, 25, '99401', '', 'PENGADILAN NEGERI POSO', 'Jalan Pulau Kalimantan No. 11', 'Y', '1'),
				(284, 25, '477202', '', 'PENGADILAN NEGERI DONGGALA', 'Jl. VATUBALA NO. 4', 'Y', '1'),
				(285, 25, '670248', '', 'PENGADILAN NEGERI BUOL', 'Jl. DR.Wahidin Sudirohusodo No.13 Kel. Leok II Kec. Biau', 'Y', '1'),
				(286, 26, '99422', 'MKS', 'PENGADILAN NEGERI MAKASSAR', 'Jln. R.A. Kartini No. 18/23', 'Y', '1'),
				(287, 26, '99439', '', 'PENGADILAN NEGERI SUNGGUMINASA', 'Jl. Usman Salengke No 103', 'Y', '1'),
				(288, 26, '99443', '', 'PENGADILAN NEGERI PANGKAJENE', 'Jl. Sultan Hasanuddin No. 38', 'Y', '1'),
				(289, 26, '99450', '', 'PENGADILAN NEGERI BARRU', 'Jl. St. Hasanuddin No.1', 'Y', '1'),
				(290, 26, '99464', '', 'PENGADILAN NEGERI TAKALAR', 'Jl. Jend. Sudirman No. 11', 'Y', '1'),
				(291, 26, '99471', '', 'PENGADILAN NEGERI MAROS', 'Jl. DR. Sam Ratulangi No. 58', 'Y', '1'),
				(292, 26, '99485', '', 'PENGADILAN NEGERI JENEPONTO', 'Jl. Pahlawan No. 14', 'Y', '1'),
				(293, 26, '99492', '', 'PENGADILAN NEGERI PARE-PARE', 'Jl. Jend. Sudirman No. 39', 'Y', '1'),
				(294, 26, '99507', '', 'PENGADILAN NEGERI ENREKANG', 'Jl. Lasinrang No. 2', 'Y', '1'),
				(295, 26, '99511', '', 'PENGADILAN NEGERI SIDRAP', 'Jl. Jend. Sudirman No. 169', 'Y', '1'),
				(296, 26, '99528', '', 'PENGADILAN NEGERI PINRANG', 'Jl. Jend. Sukawati No. 38', 'Y', '1'),
				(297, 26, '99532', '', 'PENGADILAN NEGERI WATAMPONE', 'Jl. Let. Jend. M. T. Haryono', 'Y', '1'),
				(298, 26, '99549', '', 'PENGADILAN NEGERI WATANSOPPENG', 'Jl. Kemakmuran No. 18', 'Y', '1'),
				(299, 26, '99553', '', 'PENGADILAN NEGERI SENGKANG', 'Jl. Bau Baharudin No. 9', 'Y', '1'),
				(300, 26, '99560', '', 'PENGADILAN NEGERI BANTAENG', 'Jl. Andi Manappiang No. 15', 'Y', '1'),
				(301, 26, '99574', '', 'PENGADILAN NEGERI SINJAI', 'Jl. Jend. Sudirman No.1', 'Y', '1'),
				(302, 26, '99581', '', 'PENGADILAN NEGERI BULUKUMBA', 'Jl. Nangka No. 2', 'Y', '1'),
				(303, 26, '99595', '', 'PENGADILAN NEGERI SELAYAR', 'Jl. Kelapa No. 7', 'Y', '1'),
				(304, 26, '99600', 'PLP', 'PENGADILAN NEGERI PALOPO', 'Jl. Andi Djemma No. 126', 'Y', '1'),
				(305, 26, '99617', '', 'PENGADILAN NEGERI MAKALE', 'Jl. Pongtiku No. 48', 'Y', '1'),
				(306, 27, '99659', '', 'PENGADILAN NEGERI KENDARI', 'JL. MAYJEN SUTOYO NO. 37 TIPULU', 'Y', '1'),
				(307, 27, '99663', '', 'PENGADILAN NEGERI BAU-BAU', 'Jln. Betoambari No. 57', 'Y', '1'),
				(308, 27, '99670', '', 'PENGADILAN NEGERI RAHA', 'JL.M.H.THAMRIN NO.33 RAHA', 'Y', '1'),
				(309, 27, '99684', '', 'PENGADILAN NEGERI KOLAKA', 'Jln. Pemuda No. 175 Kolaka', 'Y', '1'),
				(310, 27, '477224', 'UNH', 'PENGADILAN NEGERI UNAAHA', 'Jl. Inolobunggadue II No. 821', 'Y', '1'),
				(311, 28, '99361', '', 'PENGADILAN NEGERI GORONTALO', 'Jl. Achmad Nadjamuddin', 'Y', '1'),
				(312, 28, '400208', '', 'PENGADILAN NEGERI LIMBOTO', 'Jl. Kol. Rauf Moo Kel. Kayubulan', 'Y', '1'),
				(313, 28, '477218', '', 'PENGADILAN NEGERI TILAMUTA', 'Jl.Jend. Ahmad Yani', 'Y', '1'),
				(314, 26, '99621', '', 'PENGADILAN NEGERI MAJENE', 'Jalan Jenderal Sudirman', 'Y', '1'),
				(315, 26, '99638', '', 'PENGADILAN NEGERI MAMUJU', 'Jalan A.P. Pettarani', 'Y', '1'),
				(316, 26, '99642', '', 'PENGADILAN NEGERI POLEWALI', 'Jl.Mr.Muh.Yamin No.15', 'Y', '1'),
				(317, 30, '99706', '', 'PENGADILAN NEGERI AMBON', 'Jl.Sultan Hairun', 'Y', '1'),
				(318, 30, '99710', '', 'PENGADILAN NEGERI MASOHI', 'Jl. Geser No.1 Masohi', 'Y', '1'),
				(319, 30, '99727', '', 'PENGADILAN NEGERI TUAL', 'Jl. Karel Sadsuitubun no. 1', 'Y', '1'),
				(320, 30, '672931', '', 'PENGADILAN NEGERI SAUMLAKI', 'Jalan Ir. Soekarno', 'Y', '1'),
				(321, 31, '99731', '', 'PENGADILAN NEGERI TERNATE', 'Jl. Jati Lurus No. 338', 'Y', '1'),
				(322, 31, '99748', '', 'PENGADILAN NEGERI TOBELO', 'Jl. SISWA - Tobelo', 'Y', '1'),
				(323, 31, '99752', '', 'PENGADILAN NEGERI LABUHA', 'Jalan Molunjunga', 'Y', '1'),
				(324, 31, '99769', '', 'PENGADILAN NEGERI SOASIU', 'Jl. Jend A. Yani N0. 8', 'Y', '1'),
				(325, 33, '400069', '', 'PENGADILAN NEGERI MANOKWARI', 'Jl.Pahlawan', 'Y', '1'),
				(326, 33, '400075', '', 'PENGADILAN NEGERI SORONG', 'Jln. Jend. Sudirman No. 5', 'Y', '1'),
				(327, 33, '400081', '', 'PENGADILAN NEGERI FAK FAK', 'Jl. Yos Sudarso No.92 Wagom - Fakfak', 'Y', '1'),
				(328, 33, '400038', 'Jpr', 'PENGADILAN NEGERI JAYAPURA', 'Jl.Raya Abepura', 'Y', '1'),
				(329, 33, '400044', '', 'PENGADILAN NEGERI WAMENA', 'Wamena', 'Y', '1'),
				(330, 33, '400050', '', 'PENGADILAN NEGERI MERAUKE', 'Jl.Brawijaya No. 166 Mopah Baru', 'Y', '1'),
				(331, 33, '400090', '', 'PENGADILAN NEGERI BIAK', 'JL. Majapahit No. 1 Biak Papua', 'Y', '1'),
				(332, 33, '400101', '', 'PENGADILAN NEGERI NABIRE', 'JL. Merdeka No.69 Nabire', 'Y', '1'),
				(333, 33, '400276', '', 'PENGADILAN NEGERI SERUI', 'Jl. Sumatera Serui', 'Y', '1'),
				(334, 33, '614890', '', 'PENGADILAN NEGERI KOTA TIMIKA KABUPATEN MIMIKA', 'Jln. Yos Sudarso No. 42 Sempan - Timika', 'Y', '1'),
				(335, 4, '672948', '', 'PENGADILAN NEGERI RANAI', 'Datuk Kaya Wan Mohd. Benteng', 'Y', '1'),
				(336, 6, '672969', '', 'PENGADILAN NEGERI PAGAR ALAM', 'Komplek Perkantoran Gunung Gare', 'Y', '1'),
				(337, 6, '672952', 'PBM', 'PENGADILAN NEGERI PRABUMULIH', 'Jl. Jend. Sudirman KM 12', 'Y', '1'),
				(338, 7, '673009', '', 'PENGADILAN NEGERI TAIS', 'JL.S.PARMAN NO 01 KEL.TALANG SALING', 'Y', '1'),
				(339, 7, '673055', '', 'PENGADILAN NEGERI TUBEI', 'Jalan Raya Lebong-Argamakmur', 'Y', '1'),
				(341, 22, '670206', '', 'PENGADILAN NEGERI BATULICIN', 'Jl. Dharma Praja No.68 Gungung Tinggi Batulicin', 'Y', '1'),
				(342, 21, '672973', '', 'PENGADILAN NEGERI KASONGAN', 'Jl. A. Yani (Komplek Perkantoran Pemkab. Katingan) Kereng Humbang Kasongan', 'Y', '1'),
				(343, 20, '', '', 'PENGADILAN NEGERI NGABANG', 'PN BELUM BEROPERASI', 'T', '1'),
				(345, 26, '672927', '', 'PENGADILAN NEGERI MASAMBA', 'Jalan Letnan Jenderal Ahmad Yani No. 21', 'Y', '1'),
				(346, 26, '673013', '', 'PENGADILAN NEGERI MALILI', 'JL. SOEKARNO-HATTA', 'Y', '1'),
				(347, 26, '681422', '', 'PENGADILAN NEGERI PASANGKAYU', 'Jl. Andi Bandaco', 'Y', '1'),
				(348, 27, '681440', '', 'PENGADILAN NEGERI ANDOOLO', '', 'Y', '1'),
				(349, 27, '681444', '', 'PENGADILAN NEGERI PASARWAJO', '', 'Y', '1'),
				(350, 24, '673034', '', 'PENGADILAN NEGERI AMURANG', 'Jl. Trans Sulawesi Kel. Pondang', 'Y', '1'),
				(351, 28, '670185', '', 'PENGADILAN NEGERI MARISA', '', 'Y', '1'),
				(352, 19, '673021', '', 'PENGADILAN NEGERI LABUAN BAJO', '', 'Y', '1'),
				(353, 19, '681418', 'OLM', 'PENGADILAN NEGERI OELAMASI', '(Komp. Civic Centre Kab. Kupang) Jl. Timor Raya KM. 36 Oelamasi', 'Y', '1'),
				(354, 1, '', '', 'PENGADILAN NEGERI SIMPANG TIGA REDELONG', 'PN BELUM BEROPERASI', 'T', '1'),
				(403, 42, '400631', 'PA.JB', 'PENGADILAN AGAMA JAKARTA BARAT', 'Jl. Pesanggrahan Raya No. 32 Kembangan', 'Y', '4'),
				(404, 42, '400616', 'PA.JP', 'PENGADILAN AGAMA JAKARTA PUSAT', 'Jl. Rawasari Selatan No. 51, Cempaka Putih', 'Y', '4'),
				(405, 42, '400653', 'PA.JS', 'PENGADILAN AGAMA JAKARTA SELATAN', 'Jl. Harsono RM No.1 Ragunan Pasar Minggu', 'Y', '4'),
				(406, 42, '400647', 'PA.JT', 'PENGADILAN AGAMA JAKARTA TIMUR', 'Jalan Raya PKP No. 24, Kelapa Dua Wetan, Ciracas', 'Y', '4'),
				(407, 42, '400622', 'PA.JU', 'PENGADILAN AGAMA JAKARTA UTARA', 'Jl. Plumpang Semper Raya No.5, Koja, Tanjung Priok', 'Y', '4'),
				(408, 43, '652076', 'PA.Clg', 'PENGADILAN AGAMA CILEGON', 'Jl. Sukabumi 2 Kav. Blok i', 'Y', '4'),
				(409, 43, '400801', 'PA.Pdlg', 'PENGADILAN AGAMA PANDEGLANG', 'Jl. Raya Labuan Km.03 Maja Sukaratu', 'Y', '4'),
				(410, 43, '400817', 'PA.Rks', 'PENGADILAN AGAMA RANGKASBITUNG', 'Jend. Sudirman KM.03 Narimbang Mulya', 'Y', '4'),
				(411, 43, '400797', 'PA.Srg', 'PENGADILAN AGAMA SERANG', 'serang', 'Y', '4'),
				(412, 43, '400823', 'PA.Tng', 'PENGADILAN AGAMA TANGERANG', 'JL. Perintis Kemerdekaan', 'Y', '4'),
				(413, 43, '604723', 'PA.Tgrs', 'PENGADILAN AGAMA TIGARAKSA', 'Jl. Atiek Soeardi Tigaraksa', 'Y', '4'),
				(414, 44, '308035', 'PA.AGM', 'PENGADILAN AGAMA ARGA MAKMUR', 'Jalan Prof. M. Yamin No. 68 Arga Makmur', 'Y', '4'),
				(415, 44, '308152', 'PA.Bn', 'PENGADILAN AGAMA BENGKULU', 'Jalan Jend Basuki Rahmat No 11 Kota Bengkulu', 'Y', '4'),
				(416, 44, '308021', 'PA.Crp', 'PENGADILAN AGAMA CURUP', 'Jalan S. Sukowati No. 24 Curup', 'Y', '4'),
				(417, 44, '308014', 'PA.Mna', 'PENGADILAN AGAMA MANNA', 'Jalan Raya Padang Panjang Manna', 'Y', '4'),
				(418, 44, '682253', 'PA.Lbg', 'PENGADILAN AGAMA LEBONG', 'Jalan Raya Lebong - Arga Makmur, Tanjung Agung - Pelabai', 'Y', '4'),
				(419, 45, '401225', 'PA.Btl', 'PENGADILAN AGAMA BANTUL', 'Jl. Urip Sumoharjo No.8 Bantul', 'Y', '4'),
				(420, 45, '401200', 'PA.Smn', 'PENGADILAN AGAMA SLEMAN', 'Jl. Parasamya, Beran, Tridadi, Sleman', 'Y', '4'),
				(421, 45, '401219', 'PA.Wt', 'PENGADILAN AGAMA WATES', 'JL. RAYA WATES-PURWOREJO KM. 2,6 WATES', 'Y', '4'),
				(422, 45, '401231', 'PA.Wno', 'PENGADILAN AGAMA WONOSARI', 'KRT. Judoningrat, Siraman, Wonosari', 'Y', '4'),
				(423, 45, '401199', 'PA.YK', 'PENGADILAN AGAMA YOGYAKARTA', 'Jln. Ipda Tut Harsono No 53 Yogyakarta', 'Y', '4'),
				(424, 46, '307250', 'PA.Gtlo', 'PENGADILAN AGAMA GORONTALO', 'Jalan Achmad Nadjamudin', 'Y', '4'),
				(425, 46, '402690', 'PA.Lbt', 'PENGADILAN AGAMA LIMBOTO', 'Jl. Baso Bobihoe No. 9', 'Y', '4'),
				(426, 46, '652130', 'PA.Tlm', 'PENGADILAN AGAMA TILAMUTA', 'Jl. Trans Sulawesi Desa Lamu Kec. Tilamuta', 'Y', '4'),
				(427, 46, '682185', 'PA.Msa', 'PENGADILAN AGAMA MARISA', 'JL. Kusnodaupoyo', 'Y', '4'),
				(428, 47, '402891', 'PA.Bik', 'PENGADILAN AGAMA BIAK', 'Jalan Majapahit', 'Y', '4'),
				(429, 47, '402902', 'PA.FF', 'PENGADILAN AGAMA FAK-FAK', 'Jl. Jendral Sudirman No. 7 Wagom', 'Y', '4'),
				(430, 47, '402876', 'PA.Jpr', 'PENGADILAN AGAMA JAYAPURA', 'Jl.Raya Kota Raja', 'Y', '4'),
				(431, 47, '402911', 'PA.Mw', 'PENGADILAN AGAMA MANOKWARI', 'Jl.Condronegoro', 'Y', '4'),
				(432, 47, '402958', 'PA.Mrk', 'PENGADILAN AGAMA MERAUKE', 'merauke', 'Y', '4'),
				(433, 47, '614773', 'PA.Mmk', 'PENGADILAN AGAMA MIMIKA', 'Jl. Yos Sudarso KM 4, Nawaripi - Timika', 'Y', '4'),
				(434, 47, '402927', 'PA.Nbr', 'PENGADILAN AGAMA NABIRE', 'Bumi Wonorejo', 'Y', '4'),
				(435, 47, '614780', 'PA.Pan', 'PENGADILAN AGAMA PANIAI', 'Jalan Dr. Soetomo, Kelurahan Oyehe', 'Y', '4'),
				(436, 47, '614769', 'PA.Stn', 'PENGADILAN AGAMA SENTANI', 'Gunung Merah', 'Y', '4'),
				(437, 47, '402942', 'PA.Sri', 'PENGADILAN AGAMA SERUI', 'serui aja', 'Y', '4'),
				(438, 47, '402933', 'PA.W', 'PENGADILAN AGAMA WAMENA', 'Jl. Diponegoro No. 10', 'Y', '4'),
				(439, 47, '402882', 'PA.Srog', 'PENGADILAN AGAMA SORONG', 'Jl. Pahlawan - Kelurahan Remu Utara', 'Y', '4'),
				(440, 47, '682300', 'PA.Ars', 'PENGADILAN AGAMA ARSO', 'Jl.Trans Swakarsa', 'Y', '4'),
				(441, 48, '402211', 'PA.Bko', 'PENGADILAN AGAMA BANGKO', 'Jl. Jenderal Sudirman KM 2 Bangko', 'Y', '4'),
				(442, 48, '402185', 'PA.Jmb', 'PENGADILAN AGAMA JAMBI', 'Jalan Jakarta Kota Baru', 'Y', '4'),
				(443, 48, '402205', 'PA.Ktl', 'PENGADILAN AGAMA KUALA TUNGKAL', 'Jl. Prof. Dr. Sri Soedewi MS. SH Kuala Tungkal', 'Y', '4'),
				(444, 48, '403052', 'PA.Mbl', 'PENGADILAN AGAMA MUARA BULIAN', 'Jl. Gajah Mada No. 10 Muara Bulian', 'Y', '4'),
				(445, 48, '402191', 'PA.Mab', 'PENGADILAN AGAMA MUARA BUNGO', 'Jl. Raden Mataher Rimbo Tengah Muara Bungo', 'Y', '4'),
				(446, 48, '632022', 'PA.MS', 'PENGADILAN AGAMA MUARA SABAK', 'Jl. Komplek Perkantoran Bukit Menderang Muara Sabak', 'Y', '4'),
				(447, 48, '652020', 'PA.Mto', 'PENGADILAN AGAMA MUARA TEBO', 'Jl. Lintas Tebo -  Bungo Km 12 Muara Tebo', 'Y', '4'),
				(448, 48, '632018', 'PA.Srl', 'PENGADILAN AGAMA SAROLANGUN', 'Jl. Komplek Perkantoran Gunung Kembang', 'Y', '4'),
				(449, 48, '652034', 'PA.Sgt', 'PENGADILAN AGAMA SENGETI', 'Komplek Perkantoran Bukit Cinto Kenang', 'Y', '4'),
				(450, 48, '402220', 'PA.Spn', 'PENGADILAN AGAMA SUNGAI PENUH', 'Jl. Depati Parbo, Sungai Penuh', 'Y', '4'),
				(451, 49, '400662', 'PA.Badg', 'PENGADILAN AGAMA BANDUNG', 'Jl. Terusan Jakarta No.120,  Antapani Tengah', 'Y', '4'),
				(452, 49, '400832', 'PA.Bks', 'PENGADILAN AGAMA BEKASI', 'Jl. Jend. Ahmad Yani No. 10', 'Y', '4'),
				(453, 49, '400729', 'PA.Bgr', 'PENGADILAN AGAMA BOGOR', 'Jl. KH. Abdullah Bin Nuh', 'Y', '4'),
				(454, 49, '400690', 'PA.Cms', 'PENGADILAN AGAMA CIAMIS', 'Jl. RAA. Sastrawinata No. 2', 'Y', '4'),
				(455, 49, '400741', 'PA.CJR', 'PENGADILAN AGAMA CIANJUR', 'Jl. Raya Bandung No.45', 'Y', '4'),
				(456, 49, '402995', 'PA.Cbd', 'PENGADILAN AGAMA CIBADAK', 'Jl. Jend. Sudirman No. 3 Komplek Perkantoran OPD, Palabuhanratu', 'Y', '4'),
				(457, 49, '604719', 'PA.Cbn', 'PENGADILAN AGAMA CIBINONG', 'Jl. Bersih No. 1 Komp. Pemda Kabupaten Bogor', 'Y', '4'),
				(458, 49, '614706', 'PA.Ckr', 'PENGADILAN AGAMA CIKARANG', 'Komplek Pemda Kab. Bekasi Blok E2', 'Y', '4'),
				(459, 49, '400684', 'PA.Cmi', 'PENGADILAN AGAMA CIMAHI', 'Jl. Raya Soreang Km. 17 Komp. Pemda Kab Bandung', 'Y', '4'),
				(460, 49, '400750', 'PA.CN', 'PENGADILAN AGAMA CIREBON', 'Jl. Dr. Ciptomangunkusumo No. 42', 'Y', '4'),
				(461, 49, '652062', 'PA.Dpk', 'PENGADILAN AGAMA DEPOK', 'Jl. Boulevard Sektor Anggrek Grand Depok City', 'Y', '4'),
				(462, 49, '400710', 'PA.Grt', 'PENGADILAN AGAMA GARUT', 'Jl. Hasan Arif No. 17', 'Y', '4'),
				(463, 49, '400766', 'PA.IM', 'PENGADILAN AGAMA INDRAMAYU', 'Jl. M.T.Haryono  No.2A', 'Y', '4'),
				(464, 49, '400848', 'PA.Krw', 'PENGADILAN AGAMA KARAWANG', 'Jl. Jend. Ahmad Yani No. 53', 'Y', '4'),
				(465, 49, '400781', 'PA.Kng', 'PENGADILAN AGAMA KUNINGAN', 'Jalan Perjuangan No. 63, Ancaran', 'Y', '4'),
				(466, 49, '400772', 'PA.Mjl', 'PENGADILAN AGAMA MAJALENGKA', 'Jl. Gerakan Koperasi No. 33', 'Y', '4'),
				(467, 49, '400854', 'PA.Pwk', 'PENGADILAN AGAMA PURWAKARTA', 'Jl. Gandanegara No. 25', 'Y', '4'),
				(468, 49, '402587', 'PA.Sbg', 'PENGADILAN AGAMA SUBANG', 'Jl. Aipda KS. Tubun No.1', 'Y', '4'),
				(469, 49, '400735', 'PA.SMI', 'PENGADILAN AGAMA SUKABUMI', 'Jl. Taman Bahagia No. 19', 'Y', '4'),
				(470, 49, '403009', 'PA.Sbr', 'PENGADILAN AGAMA SUMBER', 'Jl. Sunan Drajat No 1A Sumber', 'Y', '4'),
				(471, 49, '400678', 'PA.Smdg', 'PENGADILAN AGAMA SUMEDANG', 'Jl. Statistik No. 35', 'Y', '4'),
				(472, 49, '400704', 'PA.Tsm', 'PENGADILAN AGAMA TASIKMALAYA', 'Jl. By Pass Linggasari Komplek Perkantoran Pemkab Tasikmalaya', 'Y', '4'),
				(473, 49, '690023', 'PA.Tmk', 'PENGADILAN AGAMA KOTA TASIKMALAYA', 'Jln. Bebedahan II No.24/30 Kota Tasikmalaya', 'Y', '4'),
				(474, 49, '682164', 'PA.Bjr', 'PENGADILAN AGAMA KOTA BANJAR', 'Jl. Perintis Kemerdekaan No. 64', 'Y', '4'),
				(475, 50, '402593', 'PA.Amb', 'PENGADILAN AGAMA AMBARAWA', 'Jl Mgr. Soegijo Pranoto No.105, Ambarawa', 'Y', '4'),
				(476, 50, '401106', 'PA.Ba', 'PENGADILAN AGAMA BANJARNEGARA', 'Jl. Letnan Jendral Suprapto', 'Y', '4'),
				(477, 50, '401070', 'PA.Bms', 'PENGADILAN AGAMA BANYUMAS', 'Jl. Raya Kaliori No. 58', 'Y', '4'),
				(478, 50, '400905', 'PA.Btg', 'PENGADILAN AGAMA BATANG', 'Jl. KH AHMAD DAHLAN NO.62B', 'Y', '4'),
				(479, 50, '401002', 'PA.Bla', 'PENGADILAN AGAMA BLORA', 'Jl. Raya Blora Cepu Km. 3 Blora', 'Y', '4'),
				(480, 50, '401137', 'PA.Bi', 'PENGADILAN AGAMA BOYOLALI', 'Jl. Pandanaran No 167 Boyolali', 'Y', '4'),
				(481, 50, '400891', 'PA.Bbs', 'PENGADILAN AGAMA BREBES', 'Jl. Ahmad Yani No. 92', 'Y', '4'),
				(482, 50, '401086', 'PA.Clp', 'PENGADILAN AGAMA CILACAP', 'Jalan Dr. Rajiman No. 25B Cilacap', 'Y', '4'),
				(483, 50, '400942', 'PA.Dmk', 'PENGADILAN AGAMA DEMAK', 'Jl. Sultan Trenggono No. 23', 'Y', '4'),
				(484, 50, '400982', 'PA.Jepr', 'PENGADILAN AGAMA JEPARA', 'Jl. Shima No. 18, Pengkol', 'Y', '4'),
				(485, 50, '401174', 'PA.Kra', 'PENGADILAN AGAMA KARANG ANYAR', 'Jl. Lawu Timur No.137', 'Y', '4'),
				(486, 50, '401055', 'PA.Kbm', 'PENGADILAN AGAMA KEBUMEN', 'Jl.Indrakila No.42', 'Y', '4'),
				(487, 50, '400936', 'PA.Kdl', 'PENGADILAN AGAMA KENDAL', 'Jalan Soekarno Hatta Km. 4, Brangsong', 'Y', '4'),
				(488, 50, '401121', 'PA.Klt', 'PENGADILAN AGAMA KLATEN', 'Jl. K. H. Samanhudi No. 9', 'Y', '4'),
				(489, 50, '400973', 'PA.Kds', 'PENGADILAN AGAMA KUDUS', 'Jl. Raya Kudus-Pati KM. 4', 'Y', '4'),
				(490, 50, '401018', 'PA.Mgl', 'PENGADILAN AGAMA MAGELANG', 'Jl. Sunan Giri Jurangombo Selatan', 'Y', '4'),
				(491, 50, '403021', 'PA.Mkd', 'PENGADILAN AGAMA MUNGKID', 'Jalan Soekarno - Hatta, Kota Mungkid', 'Y', '4'),
				(492, 50, '400967', 'PA.Pt', 'PENGADILAN AGAMA PATI', 'Jl. P.  Sudirman No.67', 'Y', '4'),
				(493, 50, '400860', 'PA.Pkl', 'PENGADILAN AGAMA PEKALONGAN', 'Jl. Dr. Sutomo No.190', 'Y', '4'),
				(494, 50, '400879', 'PA.PML', 'PENGADILAN AGAMA PEMALANG', 'Jl. Sulawesi', 'Y', '4'),
				(495, 50, '401092', 'PA.Pbg', 'PENGADILAN AGAMA PURBALINGGA', 'Jl. Let Jend S Parman', 'Y', '4'),
				(496, 50, '400951', 'PA.Pwd', 'PENGADILAN AGAMA PURWODADI', 'Jl. M. H. Thamrin Purwodadi No. 09', 'Y', '4'),
				(497, 50, '401061', 'PA.Pwt', 'PENGADILAN AGAMA PURWOKERTO', 'Jl. Gerilya No. 7A Purwokerto', 'Y', '4'),
				(498, 50, '401049', 'PA.Pwr', 'PENGADILAN AGAMA PURWOREJO', 'Jalan Pahlawan No. 5', 'Y', '4'),
				(499, 50, '400998', 'PA.Rbg', 'PENGADILAN AGAMA REMBANG', 'Jl. Pemuda Km.3 Rembang', 'Y', '4'),
				(500, 50, '400920', 'PA.SAL', 'PENGADILAN AGAMA SALATIGA', 'Jl. Lingkar Selatan Dukuh Jagalan RT. 14 RW. 05', 'Y', '4'),
				(501, 50, '400911', 'PA.Smg', 'PENGADILAN AGAMA SEMARANG', 'Jl. Ronggolawe No. 6', 'Y', '4'),
				(502, 50, '403015', 'PA.Slw', 'PENGADILAN AGAMA SLAWI', 'Jl.Gajah Mada Po.Box.34 Slawi', 'Y', '4'),
				(503, 50, '401143', 'PA.Sr', 'PENGADILAN AGAMA SRAGEN', 'Jl. Dr. Soetomo No. 3A', 'Y', '4'),
				(504, 50, '401168', 'PA.SKH', 'PENGADILAN AGAMA SUKOHARJO', 'Jl.  Rajawali No. 10', 'Y', '4'),
				(505, 50, '401180', 'PA.Ska', 'PENGADILAN AGAMA SURAKARTA', 'Jl. Veteran No. 273', 'Y', '4'),
				(506, 50, '400885', 'PA.Tg', 'PENGADILAN AGAMA TEGAL', 'Jl. Mataram No. 6', 'Y', '4'),
				(507, 50, '401024', 'PA.Tmg', 'PENGADILAN AGAMA TEMANGGUNG', 'Jl. Pahlawan No. 3', 'Y', '4'),
				(508, 50, '401152', 'PA.Wng', 'PENGADILAN AGAMA WONOGIRI', 'Jl. Pemuda No. 01', 'Y', '4'),
				(509, 50, '401030', 'PA.Wsb', 'PENGADILAN AGAMA WONOSOBO', 'Jl. Mayjend Bambang Sugeng Km 3', 'Y', '4'),
				(510, 50, '614710', 'PA.Kjn', 'PENGADILAN AGAMA KAJEN', 'Jl. Teuku Umar No. 9 Kajen', 'Y', '4'),
				(511, 51, '401441', 'PA.Bgl', 'PENGADILAN AGAMA BANGIL', 'Jl. Raya Raci - Bangil', 'Y', '4'),
				(512, 51, '401545', 'PA.Bkl', 'PENGADILAN AGAMA BANGKALAN', 'Jalan Soekarno-Hatta no.19 Bangkalan', 'Y', '4'),
				(513, 51, '401369', 'PA.Bwi', 'PENGADILAN AGAMA BANYUWANGI', 'Jalan Ahmad Yani No.106', 'Y', '4'),
				(514, 51, '401287', 'PA.Bwn', 'PENGADILAN AGAMA BAWEAN', 'Jl. Masjid Jami No.3 Sangkapura-Bawean', 'Y', '4'),
				(515, 51, '401401', 'PA.BL', 'PENGADILAN AGAMA BLITAR', 'Jalan Imam Bonjol No.42', 'Y', '4'),
				(516, 51, '401307', 'PA.Bjn', 'PENGADILAN AGAMA BOJONEGORO', 'M. H. Tharmin No. 88', 'Y', '4'),
				(517, 51, '401344', 'PA.Bdw', 'PENGADILAN AGAMA BONDOWOSO', 'Jl. Santawi No.94 A', 'Y', '4'),
				(518, 51, '401293', 'PA.Gs', 'PENGADILAN AGAMA GRESIK', 'Jl. Dr. Wahidin Sudirohusodo No. 45 Gresik', 'Y', '4'),
				(519, 51, '401338', 'PA.Jr', 'PENGADILAN AGAMA JEMBER', 'Jalan Cendrawasih No. 27', 'Y', '4'),
				(520, 51, '401271', 'PA.Jbg', 'PENGADILAN AGAMA JOMBANG', 'Jl. Prof. Dr. Nurcholish Madjid  Denanyar', 'Y', '4'),
				(521, 51, '401375', 'PA.Kab.Kdr', 'PENGADILAN AGAMA KABUPATEN KEDIRI', 'Jl. Sekartaji No. 12', 'Y', '4'),
				(522, 51, '403030', 'PA.Kab.Mn', 'PENGADILAN AGAMA KABUPATEN MADIUN', 'JL.RAYA TIRON KM.6 NGLAMES', 'Y', '4'),
				(523, 51, '604730', 'PA.KAB.MLG', 'PENGADILAN AGAMA KABUPATEN MALANG', 'Jl. Raya Mojosari No. 77 Kec. Kepanjen', 'Y', '4'),
				(524, 51, '401576', 'PA.Kgn', 'PENGADILAN AGAMA KANGEAN', 'Jl. Raya Duko No. 10 Arjasa Kepulauan Kangean', 'Y', '4'),
				(525, 51, '403046', 'PA.Kdr', 'PENGADILAN AGAMA KOTA MADYA KEDIRI', 'Jalan Sunan Ampel No.1', 'Y', '4'),
				(526, 51, '401488', 'PA.Mn', 'PENGADILAN AGAMA KOTA MADYA MADIUN', 'Jln Ring Road Barat No 1', 'Y', '4'),
				(527, 51, '401426', 'PA.MLG', 'PENGADILAN AGAMA KOTA MADYA MALANG', 'Jl. R. Panji Suroso No. 1', 'Y', '4'),
				(528, 51, '401463', 'PA.Krs', 'PENGADILAN AGAMA KRAKSAAN', 'Mayjen Sutoyo No. 69', 'Y', '4'),
				(529, 51, '401322', 'PA.Lmg.', 'PENGADILAN AGAMA LAMONGAN', 'Jalan Panglima Sudirman 738 B', 'Y', '4'),
				(530, 51, '401472', 'PA.Lmj', 'PENGADILAN AGAMA LUMAJANG', 'Jl. A. Yani No. 12', 'Y', '4'),
				(531, 51, '401494', 'PA.Mgt', 'PENGADILAN AGAMA MAGETAN', 'Jl. Raya Magetan Maospati Km.06', 'Y', '4'),
				(532, 51, '401256', 'PA.Mr', 'PENGADILAN AGAMA MOJOKERTO', 'Jl. Raya Prajuritkulon No. 17', 'Y', '4'),
				(533, 51, '401410', 'PA.NGJ', 'PENGADILAN AGAMA NGANJUK', 'Jl. Gatot Subroto - Nganjuk', 'Y', '4'),
				(534, 51, '401508', 'PA.Ngw', 'PENGADILAN AGAMA NGAWI', 'Jalan Trunojoyo N0. 59 Ngawi', 'Y', '4'),
				(535, 51, '401520', 'PA.Pct', 'PENGADILAN AGAMA PACITAN', 'Jl. K.S. Tubun No. 09 Pacitan', 'Y', '4'),
				(536, 51, '401539', 'PA.Pmk', 'PENGADILAN AGAMA PAMEKASAN', 'Jalan Raya Tlanakan', 'Y', '4'),
				(537, 51, '401432', 'PA.Pas', 'PENGADILAN AGAMA PASURUAN', 'Jl. Ir. H. JUANDA NO. 11 A', 'Y', '4'),
				(538, 51, '401514', 'PA.PO', 'PENGADILAN AGAMA PONOROGO', 'Jl. Ir. H. Juanda No. 25', 'Y', '4'),
				(539, 51, '401457', 'PA.Prob', 'PENGADILAN AGAMA PROBOLINGGO', 'Jl. D.I. Panjaitan 71', 'Y', '4'),
				(540, 51, '401551', 'PA.Spg', 'PENGADILAN AGAMA SAMPANG', 'Jl. Jaksa Agung Suprapto no 86', 'Y', '4'),
				(541, 51, '401262', 'PA.Sda', 'PENGADILAN AGAMA SIDOARJO', 'Jl Hasanuddin 90', 'Y', '4'),
				(542, 51, '401350', 'PA.SIT', 'PENGADILAN AGAMA SITUBONDO', 'Jl. Jaksa Agung Suprapto No. 18', 'Y', '4'),
				(543, 51, '401560', 'PA.Smp', 'PENGADILAN AGAMA SUMENEP', 'Jln. Trunojoyo KM. 3 No. 300 Sumenep', 'Y', '4'),
				(544, 51, '401240', 'PA.Sby', 'PENGADILAN AGAMA SURABAYA', 'Jl. Ketintang Madya VI/3', 'Y', '4'),
				(545, 51, '401390', 'PA.TL', 'PENGADILAN AGAMA TRENGGALEK', 'Jl. Dr. Sutomo No. 21 Trenggalek', 'Y', '4'),
				(546, 51, '450737', 'PA.Tbn', 'PENGADILAN AGAMA TUBAN', 'Jl. Sunan Kalijogo No. 27', 'Y', '4'),
				(547, 51, '401381', 'PA.TA', 'PENGADILAN AGAMA TULUNG AGUNG', 'Jl. Ir. Soekarno - Hatta No.117', 'Y', '4'),
				(548, 52, '632039', 'PA.Bky', 'PENGADILAN AGAMA BENGKAYANG', 'Jalan Alianyang No. 34 A Singkawang', 'Y', '4'),
				(549, 52, '402386', 'PA.Ktp', 'PENGADILAN AGAMA KETAPANG', 'JL. LETJEND. S. PARMAN NO. 67', 'Y', '4'),
				(550, 52, '402669', 'PA.Mpw', 'PENGADILAN AGAMA MEMPAWAH', 'Jl. Raden Kusno No. 39 Mempawah', 'Y', '4'),
				(551, 52, '402361', 'PA.Ptk', 'PENGADILAN AGAMA PONTIANAK', 'Jl. Jenderal Ahmad Yani No.8', 'Y', '4'),
				(552, 52, '402412', 'PA.Pts', 'PENGADILAN AGAMA PUTUSSIBAU', 'Jl. Jend. D.I. Pandjaitan Nomor 10 Putussibau', 'Y', '4'),
				(553, 52, '402370', 'PA.Sbs', 'PENGADILAN AGAMA SAMBAS', 'Jl. Pembangunan', 'Y', '4'),
				(554, 52, '402392', 'PA.Sgu', 'PENGADILAN AGAMA SANGGAU', 'Jl. Jend. Sudirman km 7 No.14A', 'Y', '4'),
				(555, 52, '402406', 'PA.Stg', 'PENGADILAN AGAMA SINTANG', 'Jalan.PKP. Mujahidin No.14', 'Y', '4'),
				(556, 53, '402556', 'PA.AMT', 'PENGADILAN AGAMA AMUNTAI', 'Jl.Empu Mandastana No.10 Kel.Sungai Malang Kec. Amuntai Tengah', 'Y', '4'),
				(557, 53, '632043', 'PA.BJB', 'PENGADILAN AGAMA BANJAR BARU', 'Jl.Trikora No.4', 'Y', '4'),
				(558, 53, '402500', 'PA.Bjm', 'PENGADILAN AGAMA BANJARMASIN', 'Jl.Gatot Subroto No. 97', 'Y', '4'),
				(559, 53, '402540', 'PA.Brb', 'PENGADILAN AGAMA BARABAI', 'Jl.H.Abdul Muis Redhani No.62', 'Y', '4'),
				(560, 53, '402531', 'PA.Kdg', 'PENGADILAN AGAMA KANDANGAN', 'Jl.Jend Sudirman Km.2 No.35', 'Y', '4'),
				(561, 53, '307122', 'PA.KTB', 'PENGADILAN AGAMA KOTA BARU', 'Jl.Raya Stagen Km.10 RT.2', 'Y', '4'),
				(562, 53, '307101', 'PA.Mrb', 'PENGADILAN AGAMA MARABAHAN', 'Jln. Jenderal Sudirman Komp. Perkantoran', 'Y', '4'),
				(563, 53, '402519', 'PA.Mtp', 'PENGADILAN AGAMA MARTAPURA', 'Jl.Perwira No.47G Martapura', 'Y', '4'),
				(564, 53, '307115', 'PA.Plh', 'PENGADILAN AGAMA PELAIHARI', 'Jl.H.Boejasin Komp.Perk Gagas', 'Y', '4'),
				(565, 53, '682260', 'PA.Blcn', 'PENGADILAN AGAMA BATU LICIN', 'JL. Dharma Praja No. 45 RT.02 RW. 01 Gunung Tinggi', 'Y', '4'),
				(566, 53, '402525', 'PA.Rtu', 'PENGADILAN AGAMA RANTAU', 'Jl.R.Suprapto No.30', 'Y', '4'),
				(567, 53, '402562', 'PA.Tjg', 'PENGADILAN AGAMA TANJUNG', 'Jl.Tanjung Selatan Raya No.661', 'Y', '4'),
				(568, 53, '402571', 'PA.Negr', 'PENGADILAN AGAMA NEGARA', 'Jl. Negara Kandangan Km.3,5 No.160 Negara Kandangan', 'Y', '4'),
				(569, 54, '402452', 'PA.Btk', 'PENGADILAN AGAMA BUNTOK', 'JL. Buntok Ampah Km. 12 No. 62', 'Y', '4'),
				(570, 54, '402468', 'PA.K.Kps', 'PENGADILAN AGAMA KUALA KAPUAS', 'Jl. Pemuda KM. 5,5 Kuala Kapuas', 'Y', '4'),
				(571, 54, '402443', 'PA.Mtw', 'PENGADILAN AGAMA MUARA TEWEH', 'Jl.YETRO SINSENG NO. 25', 'Y', '4'),
				(572, 54, '402421', 'PA.Plk', 'PENGADILAN AGAMA PALANGKARAYA', 'Jl. Kapten Piere Tendean No. 2', 'Y', '4'),
				(573, 54, '402437', 'PA.PBun', 'PENGADILAN AGAMA PANGKALAN BUN', 'Jl.Pasir Panjang Kumpai Batu Atas Km. 5,5', 'Y', '4'),
				(574, 54, '402474', 'PA.Spt', 'PENGADILAN AGAMA SAMPIT', 'Jl. Jend. Sudirman km 3,5 Sampit', 'Y', '4'),
				(575, 55, '307199', 'PA.Bpp', 'PENGADILAN AGAMA BALIKPAPAN', 'Jl. Kol. H. Syarifuddin Yoes, Balikpapan', 'Y', '4'),
				(576, 55, '652080', 'PA.Botg', 'PENGADILAN AGAMA BONTANG', 'Jl. Awang Long, No. 69, Bontang', 'Y', '4'),
				(577, 55, '307161', 'PA.Tgr', 'PENGADILAN AGAMA TENGGARONG', 'Jl Pesut, Kelurahan Timbau', 'Y', '4'),
				(578, 55, '307178', 'PA.Smd', 'PENGADILAN AGAMA SAMARINDA', 'Jl. Ir. H. Juanda No. 64 Samarinda', 'Y', '4'),
				(579, 55, '652097', 'PA.Sgta', 'PENGADILAN AGAMA SANGATTA', 'Jl. Prof. Dr. Baharudin Lopa, S.H, No.1, Bukit Pelangi Sangatta', 'Y', '4'),
				(580, 55, '307182', 'PA.Tgt', 'PENGADILAN AGAMA TANAH GROGOT', 'Jl. Sultan Ibrahim Khaliluddin, Tanah Grogot', 'Y', '4'),
				(581, 55, '307204', 'PA.TR', 'PENGADILAN AGAMA TANJUNG REDEB', 'Jl. DR. Murjani II No.46, Tanjung Redeb', 'Y', '4'),
				(582, 55, '307211', 'PA.TSe', 'PENGADILAN AGAMA TANJUNG SELOR', 'Jalan Sengkawit Nomor 5 Tanjung Selor', 'Y', '4'),
				(583, 55, '402675', 'PA.Trk', 'PENGADILAN AGAMA TARAKAN', 'Jl. Sei. Sesayap, No. 1, Tarakan', 'Y', '4'),
				(584, 55, '682295', 'PA.Nnk', 'PENGADILAN AGAMA NUNUKAN', 'Jl. Tanjung, No. 1, Nunukan', 'Y', '4'),
				(585, 56, '402302', 'PA.PKP', 'PENGADILAN AGAMA PANGKAL PINANG', 'Jl. Pulau Bangka Komplek Perkantoran Pemprov. Kep. Bangka Belitung', 'Y', '4'),
				(586, 56, '403092', 'PA.Sglt', 'PENGADILAN AGAMA SUNGAILIAT', 'Jl. Jend. Ahmad Yani Jalur II - Sungailiat', 'Y', '4'),
				(587, 56, '402318', 'PA.TDN', 'PENGADILAN AGAMA TANJUNG PANDAN', 'Jl. Anwar N0. 5 Tanjungpandan', 'Y', '4'),
				(588, 56, '682249', 'PA.MTK', 'PENGADILAN AGAMA MENTOK', 'Komplek Perkantoran Pemkab Bangka Barat, Dusun IV Daya Baru,Desa Belo Laut,Kecamatan Muntok', 'Y', '4'),
				(589, 57, '652055', 'PA.Blu', 'PENGADILAN AGAMA BLAMBANGAN UMPU', 'Jl. Mayjend Ryacudu Km. 5 Blambangan Umpu', 'Y', '4'),
				(590, 57, '652041', 'PA.Gsg', 'PENGADILAN AGAMA GUNUNG SUGIH', 'Jalan Negara No. 99 Gunung Sugih', 'Y', '4'),
				(591, 57, '402644', 'PA.Kla', 'PENGADILAN AGAMA KALIANDA', 'Jl. Kolonel Makmun Rasyid No.48  Kalianda', 'Y', '4'),
				(592, 57, '402349', 'PA.Ktbm', 'PENGADILAN AGAMA KOTABUMI', 'Jl. Letjend. H. Alamsyah Ratu Perwira Negara No.138 Kotabumi', 'Y', '4'),
				(593, 57, '402330', 'PA.Kr', 'PENGADILAN AGAMA KRUI', 'JL. Mawar No. 10 Way Mengaku Liwa', 'Y', '4'),
				(594, 57, '402355', 'PA.Mt', 'PENGADILAN AGAMA METRO', 'Jl. Stadion 24B, Tejoagung, Metro Timur', 'Y', '4'),
				(595, 57, '402324', 'PA.Tnk', 'PENGADILAN AGAMA TANJUNG KARANG', 'Jl. Untung Surapati No. 2 Bandar Lampung', 'Y', '4'),
				(596, 57, '614691', 'PA.Tgm', 'PENGADILAN AGAMA TANGGAMUS', 'Jl. Jend. Ahmad Yani Komplek Pemkab Tanggamus', 'Y', '4'),
				(597, 57, '614684', 'PA.Tlb', 'PENGADILAN AGAMA TULANG BAWANG', 'Jl. Cemara Komplek Pemda Tulang Bawang   , Menggala', 'Y', '4'),
				(598, 58, '307754', 'PA.Ab', 'PENGADILAN AGAMA AMBON', 'Jln. KH. Achmad Dahlan - Air Kuning', 'Y', '4'),
				(599, 58, '307775', 'PA.Msh', 'PENGADILAN AGAMA MASOHI', 'Jl. kuako No. 04', 'Y', '4'),
				(600, 58, '307761', 'PA.Tl', 'PENGADILAN AGAMA TUAL', 'Jln. Jenderal Soedirman', 'Y', '4'),
				(601, 59, '307818', 'PA.LBH', 'PENGADILAN AGAMA LABUHA', 'JL. BENTENG BARNAVELD', 'Y', '4'),
				(602, 59, '307796', 'PA.MORTB', 'PENGADILAN AGAMA MOROTAI', 'Jl. Gamsungi Utara', 'Y', '4'),
				(603, 59, '307801', 'PA.SS', 'PENGADILAN AGAMA SOASIO', 'JL. Jenderal Ahmad Yani, No. 10', 'Y', '4'),
				(604, 59, '307782', 'PA.TTE', 'PENGADILAN AGAMA TERNATE', 'JL. TUGU MAKUGAWENE', 'Y', '4'),
				(605, 60, '401591', 'MS.Bna', 'MAHKAMAH SYARIYAH BANDA ACEH', 'Jl. Soekarno Hatta KM.02 Mibo', 'Y', '4'),
				(606, 60, '401633', 'MS.BIR', 'MAHKAMAH SYARIYAH BIREUEN', 'Jln. Banda Aceh - Medan Km. 210 Blang Bladeh', 'Y', '4'),
				(607, 60, '401709', 'MS.Bkj', 'MAHKAMAH SYARIYAH BLANGKAJEREN', 'Jln. Inen Mayak Teri', 'Y', '4'),
				(608, 60, '401746', 'MS.CAG', 'MAHKAMAH SYARIYAH CALANG', 'Jln. Pengadilan No. 2 Gampong Blang, Aceh Jaya', 'Y', '4'),
				(609, 60, '401670', 'MS.Idi', 'MAHKAMAH SYARIYAH IDI', 'Jln. Medan Banda Aceh, Paya Gajah, Peureulak Barat', 'Y', '4'),
				(610, 60, '402607', 'MS.Jth', 'MAHKAMAH SYARIYAH JANTHO', 'Jln. T. Bachtiar P. Polem, SH', 'Y', '4'),
				(611, 60, '401695', 'MS.KSG', 'MAHKAMAH SYARIYAH KUALA SIMPANG', 'Jln. Sekerak-Kampung Bundar Karang Baru, Komplek Perkantoran Pemkab A. Tamiang', 'Y', '4'),
				(612, 60, '401715', 'MS.KC', 'MAHKAMAH SYARIYAH KUTACANE', 'Jln. Bedussamad No. 259', 'Y', '4'),
				(613, 60, '401689', 'MS.LGS', 'MAHKAMAH SYARIYAH LANGSA', 'JL. TM. BAHRUM', 'Y', '4'),
				(614, 60, '401664', 'MS.Lsm', 'MAHKAMAH SYARIYAH LHOKSEUMAWE', 'Jln. Banda Aceh - Medan', 'Y', '4'),
				(615, 60, '401642', 'MS.Lsk', 'MAHKAMAH SYARIYAH LHOKSUKON', 'Jln. Medan- Banda Aceh Gampong Alue Mudem', 'Y', '4'),
				(616, 60, '401721', 'MS.Mbo', 'MAHKAMAH SYARIYAH MEULABOH', 'Jl. Rahmat Tsunami No. 03 Peunaga Paya', 'Y', '4'),
				(617, 60, '401627', 'MS.Mrd', 'MAHKAMAH SYARIYAH MEUREUDU', 'Komplek Perkantoran Pemkab. Pidie Jaya, Cot Trieng', 'Y', '4'),
				(618, 60, '401602', 'MS.Sab', 'MAHKAMAH SYARIYAH SABANG', 'Jln. Yossudarso Gp. Cot Bau Kota Sabang', 'Y', '4'),
				(619, 60, '401611', 'MS.SGI', 'MAHKAMAH SYARIYAH SIGLI', 'jln. lingkar-blang paseh', 'Y', '4'),
				(620, 60, '401730', 'MS.SNB', 'MAHKAMAH SYARIYAH SINABANG', 'Jln. Tgk. Diujung KM. 5 Desa Suak Buluh', 'Y', '4'),
				(621, 60, '401752', 'MS.Skl', 'MAHKAMAH SYARIYAH SINGKIL', 'Jln. Raya Singkil Rimo KM. 20', 'Y', '4'),
				(622, 60, '401658', 'MS.Tkn', 'MAHKAMAH SYARIYAH TAKENGON', 'Jln. lukup Badak', 'Y', '4'),
				(623, 60, '401761', 'MS.Ttn', 'MAHKAMAH SYARIYAH TAPAK TUAN', 'Jln. T. Ben Mahmud, Air Berudang', 'Y', '4'),
				(624, 60, '682228', 'MS.STR', 'MAHKAMAH SYARIYAH SIMPANG TIGA REDELONG', 'Jln. Bandara Rembele, Kec. Wih Pesam', 'Y', '4'),
				(625, 61, '614731', 'PA.BDG', 'PENGADILAN AGAMA BADUNG', 'Jalan Raya Sempidi No. 1 Mengwi', 'Y', '4'),
				(626, 61, '402726', 'PA.Bagl', 'PENGADILAN AGAMA BANGLI', 'Jl. Merdeka No. 140 Bangli', 'Y', '4'),
				(627, 61, '307822', 'PA.Dps', 'PENGADILAN AGAMA DENPASAR', 'Jl. Cokroaminoto Gg. Katalia I', 'Y', '4'),
				(628, 61, '402772', 'PA.Gia', 'PENGADILAN AGAMA GIANYAR', 'jl.Kepundung No. 10', 'Y', '4'),
				(629, 61, '402741', 'PA.Kras', 'PENGADILAN AGAMA KARANG ASEM', 'Jl. RA. Kartini - Amlapura', 'Y', '4'),
				(630, 61, '402763', 'PA.Klg', 'PENGADILAN AGAMA KLUNGKUNG', 'JL. Gajah Mada No. 53', 'Y', '4'),
				(631, 61, '402732', 'PA.Ngr', 'PENGADILAN AGAMA NEGARA', 'Jln.Ngurah Rai No. 122 Negara-Bali', 'Y', '4'),
				(632, 61, '307839', 'PA.Sgr', 'PENGADILAN AGAMA SINGARAJA', 'Jl. Udayana No.15', 'Y', '4'),
				(633, 61, '402757', 'PA.Tbnan', 'PENGADILAN AGAMA TABANAN', 'Jl. Pulau Batam No. 12B', 'Y', '4'),
				(634, 61, '307928', 'PA.Bm', 'PENGADILAN AGAMA BIMA', 'JL. GATOT SUBROTO NO. 10', 'Y', '4'),
				(635, 61, '307932', 'PA.Dp', 'PENGADILAN AGAMA DOMPU', 'JL. SONOKLING NO.5', 'Y', '4'),
				(636, 61, '614727', 'PA.Gm', 'PENGADILAN AGAMA GIRI MENANG', 'JL. SOEKARNO-HATTA NO.2, GERUNG', 'Y', '4'),
				(637, 61, '307885', 'PA.Mtr', 'PENGADILAN AGAMA MATARAM', 'JL. LANGKO NO.3', 'Y', '4'),
				(638, 61, '307907', 'PA.PRA', 'PENGADILAN AGAMA PRAYA', 'JL. JENDRAL A YANI NO. 3', 'Y', '4'),
				(639, 61, '307911', 'PA.SEL', 'PENGADILAN AGAMA SELONG', 'Jln. Dr. Cipto Mangun Kusumo No. 200  Selong', 'Y', '4'),
				(640, 61, '307892', 'PA.SUB', 'PENGADILAN AGAMA SUMBAWA BESAR', 'JL.BUNGUR NO.4 B', 'Y', '4'),
				(641, 61, '682274', 'PA.TLG', 'PENGADILAN AGAMA TALIWANG', 'Jl. Undru No. 02 Taliwang', 'Y', '4'),
				(642, 62, '402814', 'PA.Atb', 'PENGADILAN AGAMA ATAMBUA', 'Jl. Sultan Hamengkubuwono IX No.3', 'Y', '4'),
				(643, 62, '402845', 'PA.BJW', 'PENGADILAN AGAMA BAJAWA', 'Jln. Patimura', 'Y', '4'),
				(644, 62, '307974', 'PA.Ed', 'PENGADILAN AGAMA ENDE', 'Jl.Gatot Subroto', 'Y', '4'),
				(645, 62, '307960', 'PA.Klb', 'PENGADILAN AGAMA KALABAHI', 'Jl. Soekarno-Hatta Batunirwala Kalabahi', 'Y', '4'),
				(646, 62, '402839', 'PA.Kfn', 'PENGADILAN AGAMA KEFAMENANU', 'Jl. Benpasi No.1', 'Y', '4'),
				(647, 62, '307953', 'PA.Kp', 'PENGADILAN AGAMA KUPANG', 'Jl.Kejora', 'Y', '4'),
				(648, 62, '402794', 'PA.Lrt', 'PENGADILAN AGAMA LARANTUKA', 'Jl.Ahmad Yani No. 10', 'Y', '4'),
				(649, 62, '632064', 'PA.Lwb', 'PENGADILAN AGAMA LEWO LEBA', 'J. Trans Atadei, Lusikawak', 'Y', '4'),
				(650, 62, '402851', 'PA.Mur', 'PENGADILAN AGAMA MAUMERE', 'Jl.Diponegoro No -, Maumere', 'Y', '4'),
				(651, 62, '402808', 'PA.Rtg', 'PENGADILAN AGAMA RUTENG', 'Jl. Satar Tacik', 'Y', '4'),
				(652, 62, '402820', 'PA.Soe', 'PENGADILAN AGAMA SOE', 'JL. Perintis Kemerdekaan', 'Y', '4'),
				(653, 62, '307949', 'PA.Wkb', 'PENGADILAN AGAMA WAIKABUBAK', 'Jl. Nangka No.14, Waikabubak', 'Y', '4'),
				(654, 62, '307981', 'PA.WGP', 'PENGADILAN AGAMA WAINGAPU', 'Jl. Soeharto', 'Y', '4'),
				(655, 62, '682281', 'PA.Lbj', 'PENGADILAN AGAMA LABUAN BAJO', 'Jl. Frans Nala', 'Y', '4'),
				(656, 63, '402101', 'PA.Bkn', 'PENGADILAN AGAMA BANGKINANG', 'JEND. SUDIRMAN NO. 99 Bangkinang', 'Y', '4'),
				(657, 63, '402117', 'PA.Bkls', 'PENGADILAN AGAMA BENGKALIS', 'Jln. Lembaga, Senggoro', 'Y', '4'),
				(658, 63, '402622', 'PA.Dum', 'PENGADILAN AGAMA DUMAI', 'Jl. Putri Tujuh', 'Y', '4'),
				(659, 63, '631999', 'Pa.Pkc', 'PENGADILAN AGAMA PANGKALAN KERINCI', 'Jl. Hangtuah Sp. 6', 'Y', '4'),
				(660, 63, '402123', 'PA.Ppg', 'PENGADILAN AGAMA PASIR PANGARAIAN', 'Diponegoro KM. 2 No. 1011, Desa Koto Tinggi, Kec. Rambah', 'Y', '4'),
				(661, 63, '402072', 'PA.Pbr', 'PENGADILAN AGAMA PEKANBARU', 'Jln. Rawa Indah Nomor: 1', 'Y', '4'),
				(662, 63, '402081', 'PA.RGT', 'PENGADILAN AGAMA RENGAT', 'Jln. Batu Canai No. 17 Pematang Reba', 'Y', '4'),
				(663, 63, '402132', 'PA.Slp', 'PENGADILAN AGAMA SELAT PANJANG', 'Jl. Dorak', 'Y', '4'),
				(664, 63, '402097', 'PA.Tbh', 'PENGADILAN AGAMA TEMBILAHAN', 'JL Bunga No 06', 'Y', '4'),
				(665, 63, '632001', 'PA.Utj', 'PENGADILAN AGAMA UJUNG TANJUNG', 'JL. LINTAS RIAU SUMUT', 'Y', '4'),
				(666, 63, '547699', 'PA.BTM', 'PENGADILAN AGAMA BATAM', 'Jl.Ir Sutami Sekupang- Batam', 'Y', '4'),
				(667, 63, '402154', 'PA.DBS', 'PENGADILAN AGAMA DABO SINGKEP', 'Jl. Kartini No. 48', 'Y', '4'),
				(668, 63, '614670', 'PA.Ntn', 'PENGADILAN AGAMA NATUNA', 'Jl. HR. Soebrantas No. 127 - Ranai', 'Y', '4'),
				(669, 63, '402148', 'PA.TPI', 'PENGADILAN AGAMA TANJUNG PINANG', 'Senggarang Raya', 'Y', '4'),
				(670, 63, '402179', 'PA.Trp', 'PENGADILAN AGAMA TAREMPA', 'Jl. Jend. A  Yani No. 40 A Tarempa Barat', 'Y', '4'),
				(671, 63, '402160', 'PA.TBK', 'PENGADILAN AGAMA TANJUNG BALAI KARIMUN', 'Jl.Jendral Sudirman', 'Y', '4'),
				(672, 64, '307534', 'PA.Batg', 'PENGADILAN AGAMA BANTAENG', 'Jl.A.Manappiang No.1', 'Y', '4'),
				(673, 64, '307487', 'PA.Br', 'PENGADILAN AGAMA BARRU', 'Jalan Sultan Hasanuddin No. 111', 'Y', '4'),
				(674, 64, '307541', 'PA.Blk', 'PENGADILAN AGAMA BULUKUMBA', 'Jl.Lanto Dg.Pasewang No.18', 'Y', '4'),
				(675, 64, '307597', 'PA.EK', 'PENGADILAN AGAMA ENREKANG', 'Jalan Sultan Hasanuddin No. 190/450', 'Y', '4'),
				(676, 64, '307466', 'PA.Jnp', 'PENGADILAN AGAMA JENEPONTO', 'Jalan Pahlawan', 'Y', '4'),
				(677, 64, '307644', 'PA.Mj', 'PENGADILAN AGAMA MAJENE', 'Jl. Jenderal Sudirman No.91', 'Y', '4'),
				(678, 64, '307623', 'PA.Mkl', 'PENGADILAN AGAMA MAKALE', 'Jl. Merdeka No. 15', 'Y', '4'),
				(679, 64, '307651', 'PA.Mmj', 'PENGADILAN AGAMA MAMUJU', 'Jalan KS Tubun No. 68', 'Y', '4'),
				(680, 64, '307445', 'PA.Mrs', 'PENGADILAN AGAMA MAROS', 'Jl. Jend. Sudirman No. 9 Maros', 'Y', '4'),
				(681, 64, '632050', 'PA.Msb', 'PENGADILAN AGAMA MASAMBA', 'Jl.Simpurusiang', 'Y', '4'),
				(682, 64, '307619', 'PA.Plp', 'PENGADILAN AGAMA PALOPO', 'Jl.Andi Djemma', 'Y', '4'),
				(683, 64, '307431', 'PA.Pkj', 'PENGADILAN AGAMA PANGKAJENE', 'Jl. Poros Makassar Pare-Pare', 'Y', '4'),
				(684, 64, '307576', 'PA.Pare', 'PENGADILAN AGAMA PARE-PARE', 'Jenderal Sudirman No. 74', 'Y', '4'),
				(685, 64, '307580', 'PA.Prg', 'PENGADILAN AGAMA PINRANG', 'Jl. Bintang', 'Y', '4'),
				(686, 64, '307630', 'PA.Pwl', 'PENGADILAN AGAMA POLEWALI', 'Jl. Budi utomo No. 23', 'Y', '4'),
				(687, 64, '307562', 'PA.Sly', 'PENGADILAN AGAMA SELAYAR', 'Jl.Jend.Ahmad Yani', 'Y', '4'),
				(688, 64, '307513', 'PA.Skg', 'PENGADILAN AGAMA SENGKANG', 'Jalan Beringin I Sengkang', 'Y', '4'),
				(689, 64, '307602', 'PA.SIDRAP', 'PENGADILAN AGAMA SIDENRENG RAPPANG', 'Jl.Korban 40.000 No.4', 'Y', '4'),
				(690, 64, '307555', 'PA.Sj', 'PENGADILAN AGAMA SINJAI', 'Jl. Jend. Sudirman No. 5', 'Y', '4'),
				(691, 64, '307491', 'PA.Sgm', 'PENGADILAN AGAMA SUNGGUMINASA', 'Jalan Masjid Agung No. 25 Sungguminasa', 'Y', '4'),
				(692, 64, '307470', 'PA.Tkl', 'PENGADILAN AGAMA TAKALAR', 'Jl. Pangeran Diponegoro No. 5 Takalar', 'Y', '4'),
				(693, 64, '307509', 'PA.Wtp', 'PENGADILAN AGAMA WATAMPONE', 'Laksamana Yos Sudarso', 'Y', '4'),
				(694, 64, '307520', 'PA.Wsp', 'PENGADILAN AGAMA WATANSOPPENG', 'Jl.Salotungo', 'Y', '4'),
				(695, 64, '307452', 'PA.Mks', 'PENGADILAN AGAMA MAKASSAR', 'Jl. Perintis Kemerdekaan Km.14', 'Y', '4'),
				(696, 65, '652123', 'PA.Bgi', 'PENGADILAN AGAMA BANGGAI', 'Jl. Ki Hajar Dewantara, Timbong', 'Y', '4'),
				(697, 65, '652119', 'PA.Buk', 'PENGADILAN AGAMA BUNGKU', 'Jl. Trans Sulawesi Bungku', 'Y', '4'),
				(698, 65, '652102', 'PA.BUOL', 'PENGADILAN AGAMA BUOL', 'Jalan Ir. Karim Mbow Kel. Leok 2 Kec. Biau', 'Y', '4'),
				(699, 65, '604765', 'PA.Dgl', 'PENGADILAN AGAMA DONGGALA', 'JL. VATU BALA KOMPLEKS PERKANTORAN DONGGALA', 'Y', '4'),
				(700, 65, '307271', 'PA.PAL', 'PENGADILAN AGAMA PALU', 'Jalan WR.Supratman No. 10 Palu', 'Y', '4'),
				(701, 65, '307300', 'PA.Lwk', 'PENGADILAN AGAMA LUWUK', 'Jl. Komplex perkantoran Bukit Halimun', 'Y', '4'),
				(702, 65, '307292', 'PA.Pso', 'PENGADILAN AGAMA POSO', 'Jl. Pulau Kalimantan No.30, Kelurahan Gebangrejo, Kecamatan Poso Kota', 'Y', '4'),
				(703, 65, '307288', 'PA.Tli', 'PENGADILAN AGAMA TOLI-TOLI', 'Jl.H.Mallu. No.23', 'Y', '4'),
				(704, 65, '682192', 'PA.Prgi', 'PENGADILAN AGAMA PARIGI', 'Jl. Sungai Pakabata, Bambalemo', 'Y', '4'),
				(705, 66, '307729', 'PA.Bb', 'PENGADILAN AGAMA BAU-BAU', 'Jalan Raya Palagimata', 'Y', '4'),
				(706, 66, '307712', 'PA.Kdi', 'PENGADILAN AGAMA KENDARI', 'Jl. Kapt. Pierre Tendean No. 45', 'Y', '4'),
				(707, 66, '307690', 'PA.Klk', 'PENGADILAN AGAMA KOLAKA', 'Jl. Pemuda KM. 5 Balandete', 'Y', '4'),
				(708, 66, '307708', 'PA.Rh', 'PENGADILAN AGAMA MUNA-RAHA', 'Jl. Gatot Subroto No... Poros Raha-Tampo', 'Y', '4'),
				(709, 66, '604772', 'PA.Una', 'PENGADILAN AGAMA UNAAHA', 'Jl. Inolobunggadue II', 'Y', '4'),
				(710, 66, '682207', 'PA.Adl', 'PENGADILAN AGAMA ANDOOLO', 'Jln. Kompleks Perkantoran Pemda Konsel', 'Y', '4'),
				(711, 66, '682211', 'PA.Pw', 'PENGADILAN AGAMA PASARWAJO', 'Jl. Protokol No... Kel. Kombeli Pasarwajo', 'Y', '4'),
				(712, 67, '604751', 'PA.Bitg', 'PENGADILAN AGAMA BITUNG', 'Jalan Dua Sudara', 'Y', '4'),
				(713, 67, '307232', 'PA.Ktg', 'PENGADILAN AGAMA KOTAMOBAGU', 'Jln. Kinalang', 'Y', '4'),
				(714, 67, '307225', 'PA.Mdo', 'PENGADILAN AGAMA MANADO', 'Jln. Cendrawasih No. 2', 'Y', '4'),
				(715, 67, '307246', 'PA.Thn', 'PENGADILAN AGAMA TAHUNA', 'Jalan Baru Tonna', 'Y', '4'),
				(716, 67, '402701', 'PA.Tdo', 'PENGADILAN AGAMA TONDANO', 'Manguni Nomor 85', 'Y', '4'),
				(717, 67, '682171', 'PA.Amg.', 'PENGADILAN AGAMA AMURANG', 'Jalan Trans Sulawesi', 'Y', '4'),
				(718, 68, '401947', 'PA.Bsk', 'PENGADILAN AGAMA BATU SANGKAR', 'Jl. Sudirman No 1 Lima Kaum Batusangkar', 'Y', '4'),
				(719, 68, '402010', 'PA.Bkt', 'PENGADILAN AGAMA BUKIT TINGGI', 'Jl. Kusuma Bhakti Gulai Bancah', 'Y', '4'),
				(720, 68, '401984', 'PA.KBr', 'PENGADILAN AGAMA KOTO BARU', 'Raya Koto Baru No 75 Solok', 'Y', '4'),
				(721, 68, '402613', 'PA.LB', 'PENGADILAN AGAMA LUBUK BASUNG', 'Jl. Sutan Syahrir No. 2', 'Y', '4'),
				(722, 68, '402029', 'PA.Lbs', 'PENGADILAN AGAMA LUBUK SIKAPING', 'Jl. A. Yani No. 40 Lubuk Sikaping', 'Y', '4'),
				(723, 68, '402041', 'PA.Min', 'PENGADILAN AGAMA MANINJAU', 'Jl. H. Udin Rahmani No. 85 Maninjau', 'Y', '4'),
				(724, 68, '401990', 'PA.ML', 'PENGADILAN AGAMA MUARA LABUH', 'Jln. Raya Muara Labuh-Padang Aro, Km.12 Ampalu', 'Y', '4'),
				(725, 68, '401953', 'PA.Pdg', 'PENGADILAN AGAMA PADANG', 'Jln. Durian Tarung No. 1', 'Y', '4'),
				(726, 68, '401962', 'PA.PP', 'PENGADILAN AGAMA PADANG PANJANG', 'Jl. H. Agus Salim No. 04', 'Y', '4'),
				(727, 68, '402004', 'PA.Pn', 'PENGADILAN AGAMA PAINAN', 'Jl. Dr. Moh. Hatta Painan', 'Y', '4'),
				(728, 68, '401916', 'PA.Prm', 'PENGADILAN AGAMA PARIAMAN', 'Jl. Syekh Burhanuddin No. 106', 'Y', '4'),
				(729, 68, '402050', 'PA.PYK', 'PENGADILAN AGAMA PAYAKUMBUH', 'Jln. Soekarno-Hatta No. 214', 'Y', '4'),
				(730, 68, '401931', 'PA.Swl', 'PENGADILAN AGAMA SAWAH LUNTO', 'Jl. Khatib Sulaiman KM 8 Kolok MUdik', 'Y', '4'),
				(731, 68, '401978', 'PA.SJJ', 'PENGADILAN AGAMA SIJUNJUNG', 'Jl. Prof.M.Yamin No. 65', 'Y', '4'),
				(732, 68, '401922', 'PA.Slk', 'PENGADILAN AGAMA SOLOK', 'Jln. Kapten Bahar Hamid Laing', 'Y', '4'),
				(733, 68, '402035', 'PA TALU', 'PENGADILAN AGAMA TALU', 'Jl. Jati II', 'Y', '4'),
				(734, 68, '402066', 'PA.LK', 'PENGADILAN AGAMA TANJUNG PATI', 'Jl. Negara Km. 11 Tanjung Pati', 'Y', '4'),
				(735, 69, '402267', 'PA.BTA', 'PENGADILAN AGAMA BATURAJA', 'Jln. Jend. A. Yani Kemelak Bindung Langit Baturaja', 'Y', '4'),
				(736, 69, '402273', 'PA.KAG', 'PENGADILAN AGAMA KAYU AGUNG', 'Jl. Letjend. M. Yusuf Singadekane No. 228 Kayuagung', 'Y', '4'),
				(737, 69, '402251', 'PA.Lt', 'PENGADILAN AGAMA LAHAT', 'Jalan Kolonel Barlian Bandar Jaya Lahat 31414', 'Y', '4'),
				(738, 69, '402298', 'PA.LLG', 'PENGADILAN AGAMA LUBUK LINGGAU', 'Jl. Yos sudarso No. 34 Km.7 Taba Pingin Lubuklingau Sumatera Selatan Indonesia 31626', 'Y', '4'),
				(739, 69, '402282', 'PA.ME', 'PENGADILAN AGAMA MUARA ENIM', 'Mayor Tjik Agus Kiemas, S.H. nomor 1', 'Y', '4'),
				(740, 69, '402242', 'PA.PLG', 'PENGADILAN AGAMA PALEMBANG', 'Jln. Pangeran ratu rt 24 rw.09 kel. 15 ulu jakabaring', 'Y', '4'),
				(741, 69, '402638', 'PA.SKY', 'PENGADILAN AGAMA SEKAYU', 'Merdeka Lingkungan I No. 497', 'Y', '4'),
				(742, 70, '401865', 'PA.BLG', 'PENGADILAN AGAMA BALIGE', 'Jl. Balige-Laguboti Km. 5 Tambunan Lumban Pea Timur', 'Y', '4'),
				(743, 70, '401783', 'PA.Bji', 'PENGADILAN AGAMA BINJAI', 'Jl. Sultan Hasanuddin No. 24 Binjai', 'Y', '4'),
				(744, 70, '401896', 'PA.Gst', 'PENGADILAN AGAMA GUNUNG SITOLI', 'Jl. Pancasila No. 29 Gunungsitoli', 'Y', '4'),
				(745, 70, '401792', 'PA.Kbj', 'PENGADILAN AGAMA KABANJAHE', 'Jl. Jamin Ginting No. 73', 'Y', '4'),
				(746, 70, '403061', 'PA.Kis', 'PENGADILAN AGAMA KISARAN', 'Jl. Jend. Ahmad Yani No. 73 Kisaran', 'Y', '4'),
				(747, 70, '403077', 'PA.Lpk', 'PENGADILAN AGAMA LUBUK PAKAM', 'Jl. Mahoni No. 3 Komp. Perkantoran Pemkab. Deli Serdang', 'Y', '4'),
				(748, 70, '401803', 'PA.Mdn', 'PENGADILAN AGAMA MEDAN', 'Jl. SM. Raja Km. 8,8 No. 198 Medan', 'Y', '4'),
				(749, 70, '401880', 'PA.Psp', 'PENGADILAN AGAMA PADANG SIDEMPUAN', 'Jl. H.T. Rizal Nurdin km. 7 Padangsidempuan', 'Y', '4'),
				(750, 70, '604744', 'Pa.Pdn', 'PENGADILAN AGAMA PANDAN', 'Jl. D.I. Panjaitan/Almuslimin No. 4 Pandan', 'Y', '4'),
				(751, 70, '631982', 'PA.Pyb', 'PENGADILAN AGAMA PANYABUNGAN', 'Jl. Willem Iskandar No. 5 Panyabungan', 'Y', '4'),
				(752, 70, '401859', 'PA.PST', 'PENGADILAN AGAMA PEMATANG SIANTAR', 'Jl. Sisingamangaraja No. 47 Pematangsiantar', 'Y', '4'),
				(753, 70, '401812', 'PA.RAP', 'PENGADILAN AGAMA RANTAU PRAPAT', 'Jl. Sisingamangaraja Komp. Asrama Haji No. 4 Rantauprapat', 'Y', '4'),
				(754, 70, '401871', 'PA.Sbga', 'PENGADILAN AGAMA SIBOLGA', 'Jl. Perintis Kemerdekaan No. 1 Sibolga', 'Y', '4'),
				(755, 70, '401840', 'PA.Sdk', 'PENGADILAN AGAMA SIDIKALANG', 'Rumah Sakit Umum No. 16', 'Y', '4'),
				(756, 70, '403083', 'PA.Sim', 'PENGADILAN AGAMA SIMALUNGUN', 'Jl. Asahan Km. 3 Pematangsiantar', 'Y', '4'),
				(757, 70, '547682', 'PA.Stb', 'PENGADILAN AGAMA STABAT', 'Jl. Proklamasi No. 46 Stabat', 'Y', '4'),
				(758, 70, '401828', 'PA.Tba', 'PENGADILAN AGAMA TANJUNG BALAI', 'Jl. Jend. Sudirman Km. 5,5 Sijambi Tanjungbalai', 'Y', '4'),
				(759, 70, '631978', 'PA.Trt', 'PENGADILAN AGAMA TARUTUNG', 'Jl. Raja Yohanes Hutabarat No. 51 Tarutung', 'Y', '4'),
				(760, 70, '401834', 'PA.Ttd', 'PENGADILAN AGAMA TEBING TINGGI', 'Jalan Tuanku Imam Bonjol No 7', 'Y', '4'),
				(761, 70, '682232', 'PA.Pspk', 'PENGADILAN AGAMA KOTA PADANG SIDEMPUAN', 'jl. williem iskandar iv, sadabuan', 'Y', '4'),
				(355, 34, '578818', 'BNA', 'PENGADILAN TATA USAHA NEGARA BANDA ACEH', 'JL. IR M.THAHIR 25 LUENG BATA', 'Y', '3'),
				(356, 34, '526746', 'MDN', 'PENGADILAN TATA USAHA NEGARA MEDAN', 'Jl. Bunga Raya No. 18 Kel. Asam Kumbang Kec. Medan Selayang', 'Y', '3'),
				(357, 34, '531844', 'PDG', 'PENGADILAN TATA USAHA NEGARA PADANG', 'Jl. Diponegoro No. 8 Padang', 'Y', '3'),
				(358, 34, '578822', 'PBR', 'PENGADILAN TATA USAHA NEGARA PEKANBARU', 'Jl. HR Subrantas KM 9 Pekanbaru', 'Y', '3'),
				(359, 34, '578839', 'JBI', 'PENGADILAN TATA USAHA NEGARA JAMBI', 'Jln. Kol. M. Kukuh No. 1 Kota Baru', 'Y', '3'),
				(360, 34, '526750', 'PLG', 'PENGADILAN TATA USAHA NEGARA PALEMBANG', 'Jl.A.Yani No.67', 'Y', '3'),
				(361, 34, '559840', 'BL', 'PENGADILAN TATA USAHA NEGARA BANDAR LAMPUNG', 'JL.P.Emir M Noer NO. 27', 'Y', '3'),
				(362, 34, '578885', 'BKL', 'PENGADILAN TATA USAHA NEGARA BENGKULU', 'Jl. RE. Martadinata No. 01 Bengkulu', 'Y', '3'),
				(363, 34, '689309', 'TPI', 'PENGADILAN TATA USAHA NEGARA TANJUNG PINANG', 'Jl. Ir. Sutami No. 3 sekupang', 'Y', '3'),
				(364, 35, '526732', 'JKT', 'PENGADILAN TATA USAHA NEGARA JAKARTA', 'Jl. Sentra Primer Baru Timur, Pulo Gebang', 'Y', '3'),
				(365, 35, '531823', 'BDG', 'PENGADILAN TATA USAHA NEGARA BANDUNG', 'Jl. Diponegoro No. 34 Bandung', 'Y', '3'),
				(366, 35, '531851', 'PTK', 'PENGADILAN TATA USAHA NEGARA PONTIANAK', 'Jl. Jenderal A. Yani No. 10', 'Y', '3'),
				(367, 35, '578843', 'PLK', 'PENGADILAN TATA USAHA NEGARA PALANGKARAYA', 'Jl. Cilik Riwut Km.5', 'Y', '3'),
				(368, 35, '531865', 'BJM', 'PENGADILAN TATA USAHA NEGARA BANJARMASIN', 'Jl. Brigjen H. Hasan Basri No. 32', 'Y', '3'),
				(369, 35, '559857', 'SMD', 'PENGADILAN TATA USAHA NEGARA SAMARINDA', 'Jl. Bung Tomo, No. 136, Samarinda Seberang', 'Y', '3'),
				(370, 36, '531830', 'SMG', 'PENGADILAN TATA USAHA NEGARA SEMARANG', 'Jl.Abdulrahman saleh no.89', 'Y', '3'),
				(371, 36, '578801', 'YK', 'PENGADILAN TATA USAHA NEGARA YOGYAKARTA', 'Jl. Janti No. 66', 'Y', '3'),
				(372, 36, '526767', 'SBY', 'PENGADILAN TATA USAHA NEGARA SURABAYA', 'Jl. Raya Ir. H. Juanda No.89 Semambung Gedangan', 'Y', '3'),
				(373, 36, '559861', 'DPS', 'PENGADILAN TATA USAHA NEGARA DENPASAR', 'Jl. Kapten Cok Agung Tresna No 4', 'Y', '3'),
				(374, 36, '578871', 'MTR', 'PENGADILAN TATA USAHA NEGARA MATARAM', 'Jl. Dr. Soedjono Lingkar Selatan', 'Y', '3'),
				(375, 36, '539121', 'KPG', 'PENGADILAN TATA USAHA NEGARA KUPANG', 'Jl. PALAPA No. 16 A', 'Y', '3'),
				(376, 37, '689313', 'MDO', 'PENGADILAN TATA USAHA NEGARA MANADO', 'Jl. Syech Nawawi Al-Bantani No. 3 Km. 5', 'Y', '3'),
				(377, 37, '578850', 'PL', 'PENGADILAN TATA USAHA NEGARA PALU', 'Moh. Yamin Nomor 52 Palu', 'Y', '3'),
				(378, 37, '526771', 'MKS', 'PENGADILAN TATA USAHA NEGARA MAKASAR', 'Raya Pendidikan No. 1', 'Y', '3'),
				(379, 37, '578864', 'KDI', 'PENGADILAN TATA USAHA NEGARA KENDARI', 'Jl.Badak no.7', 'Y', '3'),
				(380, 37, '539117', 'ABN', 'PENGADILAN TATA USAHA NEGARA AMBON', 'Jl.Wortel Mongensidi Lateri-Ambon', 'Y', '3'),
				(381, 37, '539138', 'JPR', 'PENGADILAN TATA USAHA NEGARA JAYAPURA', 'Jl.Raya Sentani-Waena', 'Y', '3'),
				(383, 39, '663182', 'PM.I-01', 'PENGADILAN MILITER I-01 BANDA ACEH', 'Jln. T.Imeum Lueng Bata No. 108', 'Y', '2'),
				(384, 39, '663199', 'PM.I-02', 'PENGADILAN MILITER I-02 MEDAN', 'Jl. Ngumban Surbakti No. 45 Medan', 'Y', '2'),
				(385, 39, '663204', 'PM.I-03', 'PENGADILAN MILITER I-03 PADANG', 'JL RAYA BY PASS KM 16', 'Y', '2'),
				(386, 39, '663211', 'PM.I-04', 'PENGADILAN MILITER I-04 PALEMBANG', 'Jl. Gubernur H.A Bastari Komplek OPI Palembang', 'Y', '2'),
				(387, 39, '663225', 'PM.I-05', 'PENGADILAN MILITER I-05 PONTIANAK', 'Jl.Ahmad Yani No.10 A', 'Y', '2'),
				(388, 39, '663232', 'PM.I-06', 'PENGADILAN MILITER I-06 BANJARMASIN', 'Jl.Trikora No 106 Banjarbaru', 'Y', '2'),
				(389, 39, '663246', 'PM.I-07', 'PENGADILAN MILITER I-07 BALIKPAPAN', 'Jl. Syarifoedin Yoes No.39 Sepinggan, Balikpapan', 'Y', '2'),
				(390, 40, '663267', 'PM.II-08', 'PENGADILAN MILITER II-08 JAKARTA', 'Jl Raya Penggilingan 7 Cakung Jakarta Timur', 'Y', '2'),
				(391, 40, '663271', 'PM.II-09', 'PENGADILAN MILITER II-09 BANDUNG', 'Jalan Soekarno Hatta No 745 Bandung', 'Y', '2'),
				(392, 40, '663288', 'PM.II-10', 'PENGADILAN MILITER II-10 SEMARANG', 'JL. Kertanegara VI/8 Semarang', 'Y', '2'),
				(393, 40, '663292', 'PM.II-11', 'PENGADILAN MILITER II-11 YOGYAKARTA', 'Jl. Perempatan Ring Road Timur Banguntapan Bantul', 'Y', '2'),
				(394, 41, '663314', 'PM.III-12', 'PENGADILAN MILITER III-12 SURABAYA', 'Jl. Raya Ir. H. Juanda No. 85', 'Y', '2'),
				(395, 41, '663321', 'PM.III-13', 'PENGADILAN MILITER III-13 MADIUN', 'Jl. SALAK III NO. 38', 'Y', '2'),
				(396, 41, '663335', 'PM.III-14', 'PENGADILAN MILITER III-14 DENPASAR', 'Jl. Yos Sudarso No. 1 Denpasar', 'Y', '2'),
				(397, 41, '663342', 'PM.III-15', 'PENGADILAN MILITER III-15 KUPANG', 'Jl. Perintis Kemerdekaan I, Kayu Putih', 'Y', '2'),
				(398, 41, '663356', 'PM.III-16', 'PENGADILAN MILITER III-16 MAKASSAR', 'Jl. Batara Bira No.5 KM.16, Badoka, Makassar', 'Y', '2'),
				(399, 41, '663360', 'PM.III-17', 'PENGADILAN MILITER III-17 MANADO', 'Jalan Sam Ratulangi No. 16 Manado', 'Y', '2'),
				(400, 41, '663377', 'PM.III-18', 'PENGADILAN MILITER III-18 AMBON', 'Jln. Sultan Hasanudin Tantui', 'Y', '2'),
				(401, 41, '663381', 'PM.III-19', 'PENGADILAN MILITER III-19 JAYAPURA', 'Jl. Samratulangi No.17 Jayapura', 'Y', '2'),
				(402, 35, '690202', 'SRG', 'PENGADILAN TATA USAHA NEGARA SERANG', 'Jl. Syech Nawawi Al-Bantani No.3 Km 5 Kel Banjarsari Serang - Provinsi Banten Telp/Fax.(0254) 214085/214855', 'Y', '3');");


		$this->patching->exe_script("REPLACE INTO jenis_tahanan (id, nama) VALUES (4, 'Tahanan Rutan Militer');"); 

		$this->patching->exe_script("UPDATE jenis_penahanan SET jenis_pengadilan = '1' WHERE id >= '1' AND id <=14;");

		$this->patching->exe_script("REPLACE INTO jenis_penahanan (id, nama, batas_waktu, keterangan, jenis_pengadilan) 
		VALUES (15, 'Atasan Yang Berhak Menghukum', '20', 'Penahanan oleh Atasan Yang Berhak Menghukum', '2'),
		       (16, 'ANKUM Perpanjangan I oleh Perwira Penyerah Perkara', '30', 'Penahanan oleh ANKUM dengan perpanjangan ke I oleh Perwira Penyerah Perkara (PAPERA)', '2'),
		       (17, 'ANKUM Perpanjangan II oleh Perwira Penyerah Perkara', '30', 'Penahanan oleh ANKUM dengan perpanjangan ke II oleh Perwira Penyerah Perkara (PAPERA)', '2'),
		       (18, 'ANKUM Perpanjangan III oleh Perwira Penyerah Perkara', '30', 'Penahanan oleh ANKUM dengan perpanjangan ke III oleh Perwira Penyerah Perkara (PAPERA)', '2'),
		       (19, 'ANKUM Perpanjangan IV oleh Perwira Penyerah Perkara', '30', 'Penahanan oleh ANKUM dengan perpanjangan ke IV oleh Perwira Penyerah Perkara (PAPERA)', '2'),
		       (20, 'ANKUM Perpanjangan V oleh Perwira Penyerah Perkara', '30', 'Penahanan oleh ANKUM dengan perpanjangan ke V oleh Perwira Penyerah Perkara (PAPERA)', '2'),
		       (21, 'ANKUM Perpanjangan VI oleh Perwira Penyerah Perkara', '30', 'Penahanan oleh ANKUM dengan perpanjangan ke VI oleh Perwira Penyerah Perkara (PAPERA)', '2'),
		       (22, 'Hakim Ketua', '30', 'Penahanan oleh Hakim Ketua', '2'),
		       (23, 'Hakim Ketua Perpanjangan Oleh Kadilmil', '60', 'Penahanan oleh Hakim Ketua dengan perpanjangan oleh Kadilmil', '2'),
		       (24, 'Hakim Ketua Perpanjangan Oleh Kadilmilti', '60', 'Penahanan oleh Hakim Ketua dengan perpanjangan oleh Kadilmilti', '2'),
		       (25, 'Hakim TK Banding', '30', 'Penahanan oleh Hakim Ketua TK Banding', '2'),
		       (26, 'Hakim TK Banding Perpanjangan Oleh Kadilmilti', '60', 'Penahanan oleh Hakim TK Banding dengan perpanjangan oleh Kadilmilti', '2'),
		       (27, 'Hakim TK Banding Perpanjangan Oleh Kadilmiltama', '60', 'Penahanan oleh Hakim TK Banding dengan perpanjangan oleh Kadilmiltama', '2'),
		       (28, 'Hakim TK Banding Perpanjangan Oleh Ketua MA', '60', 'Penahanan oleh Hakim TK Banding dengan perpanjangan oleh Ketua MA', '2'),
		       (29, 'Hakim Agung', '50', 'Penahanan oleh Hakim Agung (Kasasi)', '2'),
		       (30, 'Hakim Agung Perpanjangan Oleh Ketua MA', '60', 'Penahanan oleh Hakim Agung (Banding) dengan perpanjangan oleh Ketua MA', '2');");

		$this->patching->exe_script("REPLACE INTO jenis_penahanan (id, nama, keterangan, jenis_pengadilan) 
		VALUES 	(31, 'Kadilmil', 'Pembebasan oleh Kadilmil', '2'),
				(32, 'Kadilmilti', 'Pembebasan oleh Kadilmilti', '2'),
				(33, 'Kadilmiltama', 'Pembebasan oleh Kadilmiltama','2'),
				(34, 'Ketua MA', 'Pembebasan oleh Ketua MA', '2');");


		$this->patching->exe_script("REPLACE INTO sumber_hukum (id, kode, nama,jenis_pengadilan, aktif, urutan) 
		VALUES
			(6, 'Peraturan Perundangan-Undangan', 'Peraturan Perundangan-Undangan', 3, 'Y', '1'),
			(7, 'Asas-Asas Pemerintahan Yang Baik', 'Asas-Asas Pemerintahan Yang Baik', 3, 'Y', '2'),
			(12,'Perpu dan Asas-Asas Pemerintahan Yang Baik','Perpu dan Asas-Asas Pemerintahan Yang Baik', 3, 'Y', '3'),
			(8, 'KHI', 'Kompilasi Hukum Islam',  '4', 'Y', 1),
			(9, 'KHES', 'Kompilasi Hukum Ekonomi Syariah',  '4', 'Y', 2),
			(10,'FIQH', 'Fiqh Islam',  '4', 'Y', 3),
			(11,'UU/PP', 'UU/PP',  '4', 'Y', 4),
			(13, 'Qanun', 'Qanun Aceh', '4', 'Y', 5);");



		$this->patching->exe_script("REPLACE INTO status_putusan (id, jenis_perkara_id, nama, urutan, satuan, jenis_pengadilan) 
		VALUES 
		(44,2, 'Pidana Penjara Seumur Hidup', '1', '3', '2'),
		(45,2, 'Pidana Penjara', '2', '1', '2'),
		(46,2, 'Pidana Denda', '3', '2', '2'),
		(47,2, 'Pidana Percobaan', '4', '3', '2'),
		(48,2, 'Bebas Dari Dakwaan', '5', '3', '2'),
		(49,2, 'Lepas Dari Tuntutan', '6', '3', '2'),
		(50,2, 'In-Absentia', '7', '3', '2'),
		(51,2, 'Pidana Mati', '8', '3', '2'),
		(52,2, 'Dipecat Dari Dinas Militer', '9', '3', '2'),
		(53,2, 'Rehabilisasi', '10', '3', '2'),
		(54,2, 'Pidana Tambahan', '11', '4', '2'),
		(55,2, 'Subsider Penjara', '12', '1', '2'),
		(56,2, 'Subsider Kurungan', '13', '1', '2'),
		(57,2, 'Subsider Denda', '14', '2', '2'),
		(58,2, 'Lain-lain', '15', '4', '2'),
		(59,2, 'Dilimpahkan', '0', NULL, '2'),
		(60,2, 'Biaya Perkara', '16', '2', '2'),
		(61,2, 'Tidak dapat diterima', '17',NULL, '2'),
		(34,1, 'Dikabulkan','1',NULL,'3'), 
		(35,1, 'Ditolak','2',NULL,'3'),
		(36,1, 'Tidak Dapat diterima',3,NULL,'3'),
		(37,1, 'Dicabut','4',NULL,'3'),
		(38,1, 'Gugur','5',NULL,'3');");

		$this->patching->exe_script("DROP TABLE IF EXISTS perkara_jadwal_sidang_detil;");
		$this->patching->exe_script("CREATE TABLE perkara_jadwal_sidang_detil(	
			perkara_id BIGINT(20) UNSIGNED NOT NULL, 
			sidang_id BIGINT(20) UNSIGNED NOT NULL, 
			jenis_agenda_id SMALLINT(6) NOT NULL,
			uraian TEXT,
			diinput_oleh VARCHAR(30) NULL,
			diinput_tanggal DATETIME NULL,
			diperbaharui_oleh VARCHAR(30) NULL,
			diperbaharui_tanggal DATETIME NULL,
			PRIMARY KEY (perkara_id,sidang_id,jenis_agenda_id), 
			CONSTRAINT perkara_jadwal_sidang_detil_fk FOREIGN KEY (perkara_id) REFERENCES perkara (perkara_id) ON DELETE CASCADE 
			)ENGINE=INNODB;");

		$this->patching->exe_script("REPLACE INTO jenis_perkara (id, parent_id,nama, nama_lengkap, format_nomor) 
		VALUES 
		(318,NULL,'Pertanahan','Pertanahan','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PTUN.#kode_pn#'),
		(319,NULL,'Kepegawaian','Kepegawaian','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PTUN.#kode_pn#'),
		(320,NULL,'Pajak','Pajak','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PTUN.#kode_pn#'),
		(321,NULL,'Perijinan','Perijinan','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PTUN.#kode_pn#'),
		(322,NULL,'Lelang','Lelang','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PTUN.#kode_pn#'),
		(323,NULL,'Tender','Tender','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PTUN.#kode_pn#'),
		(324,NULL,'HAKI','HAKI','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PTUN.#kode_pn#'),
		(325,NULL,'Badan Hukum','Badan Hukum','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PTUN.#kode_pn#'),
		(326,NULL,'Kehutanan','Kehutanan','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PTUN.#kode_pn#'),
		(327,NULL,'Perumahan','Perumahan','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PTUN.#kode_pn#'),
		(328,NULL,'Pemilukada','Pemilukada','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PTUN.#kode_pn#'),
		(329,NULL,'Partai Politik','Partai','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PTUN.#kode_pn#'),
		(330,NULL,'Lain-Lain','Gugatan Lain-Lain','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PTUN.#kode_pn#'),
		(331,NULL,'Permohonan UU AP','Permohonan UU AP','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PTUN.#kode_pn#'),
		(332,NULL,'Permohonan Pertanahan','Permohonan Pertanahan','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PTUN.#kode_pn#'),
		(333,NULL,'Permohonan Fiktif Positif','Permohonan Fiktif Positif','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PTUN.#kode_pn#'),
		(334,NULL,'Permohonan Penyalahgunaan Wewenang','Permohonan Penyalahgunaan Wewenang','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PTUN.#kode_pn#'),
		(335,NULL,'Permohonan Keberatan (KIP)','Permohonan Keberatan (KIP)','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/PTUN.#kode_pn#'),
		(336,NULL,'KUHP','KHUP','#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(337,NULL,'KUHPM','KUHPM','#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'), 
		(338,NULL,'Pelanggaran', 'Pelanggaran', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'), 
		(339,NULL,'Lain-Lain', 'Lain-Lain', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(261,337,'Pengkhianatan Militer Dalam Waktu Perang', 'Pengkhianatan Militer Dalam Waktu Perang', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(262,337,'Kejahatan Penerbangan dan Kejahatan Terhadap Sarana/Prasarana Penerbangan', 'Kejahatan Penerbangan dan Kejahatan Terhadap Sarana/Prasarana Penerbangan', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(263,337,'Pemberontakan Militer', 'Pemberontakan Militer', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(264,337,'Mangkir', 'Mangkir', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(265,337,'Desersi', 'Desersi', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(266,337,'Pemalsuan Surat', 'Pemalsuan Surat', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(267,337,'Menghina Atasan', 'Menghina Atasan', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(268,337,'Menantang Atasan Untuk Berkelahi Sehubungan Dengan Kedinasan', 'Menantang Atasan Untuk Berkelahi Sehubungan Dengan Kedinasan', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(269,337,'Tidak Mentaati Perintah Dinas', 'Tidak Mentaati Perintah Dinas', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(270,337,'Mengancam dengan Kekerasan Terhadap Atasan', 'Mengancam dengan Kekerasan Terhadap Atasan', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(271,337,'Dengan Sengaja Dengan Tindakan Nyata Menyerang Seorang Atasan', 'Dengan Sengaja Dengan Tindakan Nyata Menyerang Seorang Atasan', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(272,337,'Insubordinasi', 'Insubordinasi', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(273,337,'Pencurian pada Suatu Tempat Dibawah Penjagaan atau Pengamanannya', 'Pencurian pada Suatu Tempat Dibawah Penjagaan atau Pengamanannya', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(274,337,'Penjaga Meninggalkan Pos', 'Penjaga Meninggalkan Pos', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(275,337,'Dengan Sengaja Menarik Diri dari Suatu Dinas', 'Dengan Sengaja Menarik Diri dari Suatu Dinas', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(276,337,'Lalai Untuk Meneruskan Suatu Pemberitahuan', 'Lalai Untuk Meneruskan Suatu Pemberitahuan', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(277,337,'Penyalahgunaan Keuasaan dan wewenang', 'Penyalahgunaan Kekuasaan dan Wewenang', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(278,337,'Dengan Sengaja Memaki-memaki Seorang Bawahan', 'Dengan Sengaja Memaki-maki Seorang Bawahan', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(279,337,'Pencurian dan Penadahan', 'Pencurian dan Penadahan', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(280,337,'Dengan Sengaja Memukul Seorang Bawahan', 'Dengan Sengaja Memukul Seorang Bawahan', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(281,337,'Menghilangkan Suatu Barang Keperluan Perang', 'Menghilangkan Suatu Barang Keperluan Perang', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(282,336,'Kejahatan Terhadap Keamanan Negara', 'Kejahatan Terhadap Keamanan Negara', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(283,336,'Kejahatan Terhadap Melakukan Kewajiban dan Hak Kenegaraan', 'Kejahatan Terhadap Melakukan Kewajiban dan Hak Kenegaraan', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(284,336,'Kejahatan Terhadap Ketertiban Umum', 'Kejahatan Terhadap Ketertiban Umum', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(285,336,'Perkelahian Tanding', 'Perkelahian Tanding', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(286,336,'Kejahatan yang Membahayakan Keamanan Umum bagi Orang atau Barang', 'Kejahatan yang Membahayakan Keamanan Umum bagi Orang atau Barang', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(287,336,'Kejahatan Terhadap Penguasa Umum', 'Kejahatan Terhadap Penguasa Umum', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(288,336,'Sumpah Palsu dan Keterangan Palsu', 'Sumpah Palsu dan Keterangan Palsu', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(289,336,'Pemalsuan Mata Uang dan Uang Kertas', 'Pemalsuan Mata Uang dan Uang Kertas', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(290,336,'Pemalsuan Meterai dan Merk', 'Pemalsuan Meterai dan Merk', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(291,336,'Pemalsuan Surat', 'Pemalsuan Surat', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(292,336,'Kejahatan Terhadap Asal Usul dan Perkawinan', 'Kejahatan Terhadap Asal Usul dan Perkawinan', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(293,336,'Kejahatan Terhadap Kesusilaan', 'Kejahatan Terhadap Kesusilaan', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(294,336,'Meninggalkan Orang yang Perlu Ditolong', 'Meninggalkan Orang yang Perlu Ditolong', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(295,336,'Penghinaan', 'Penghinaan', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(296,336,'Membuka Rahasia', 'Membuka Rahasia', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(297,336,'Kejahatan Terhadap Kemerdekaan Orang', 'Kejahatan Terhadap Kemerdekaan Orang', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(298,336,'Kejahatan Terhadap Nyawa', 'Kejahatan Terhadap Nyawa', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(299,336,'Penganiayaan', 'Penganiayaan', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(300,336,'Menyebabkan Mati atau Luka-luka Karena Kealpaan', 'Menyebabkan Mati atau Luka-luka Karena Kealpaan', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'), 
		(301,336,'Pencurian', 'Pencurian', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(302,336,'Pemerasan dan Pengancaman', 'Pemerasan dan Pengancaman', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'), 
		(303,336,'Penggelapan', 'Penggelapan', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(304,336,'Penipuan', 'Penipuan', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(305,336,'Perbuatan Merugikan Pemiutang atau Orang Yang Mempunyai Hak', 'Perbuatan Merugikan Pemiutang atau Orang Yang Mempunyai Hak', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'), 
		(306,336,'Menghancurkan atau Merusak Barang', 'Menghancurkan atau Merusak Barang', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(307,336,'Kejahatan Jabatan', 'Kejahatan Jabatan', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(308,336,'Kejahatan Pelayaran', 'Kejahatan Pelayaran', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'), 
		(309,336,'Penadahan, Pencetakan dan Penerbitan', 'Penadahan, Pencetakan dan Penerbitan', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'), 
		(310,336,'Narkotika', 'Narkotika', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(311,336,'Penghapusan Kekerasan Dalam Rumah Tangga', 'Penghapusan Kekerasan Dalam Rumah Tangga', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'), 
		(312,336,'Perlindungan Anak', 'Perlindungan Anak', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(313,336,'Jaminan Fidusia', 'Jaminan Fidusia', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(314,336,'Pemberantasan Tindak Pidana Korupsi', 'Pemberantasan Tindak Pidana Korupsi', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'), 
		(315,336,'Ilegal Logging', 'Ilegal Logging', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(316,336,'Senjata Api', 'Senjata Api', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(317,336,'Lalu-Lintas', 'Lalu-Lintas', '#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(340,NULL,'Lalu lintas dan Angkutan Jalan ','Lalu lintas dan angkutan jalan ','#nomor_urut_perkara#-#kode_alur_perkara#/#kode_pn#/#matra#/#bulan#/#tahun#'),
		(341,NULL,'Izin Poligami','Izin Poligami','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
		(342,NULL,'Pencegahan Perkawinan','Pencegahan Perkawinan','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
		(343,NULL,'Penolakan Perkawinan','Penolakan Perkawinan oleh PPN','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
		(344,NULL,'Pembatalan Perkawinan','Pembatalan Perkawinan','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
		(345,NULL,'Kelalaian Atas Kewajiban Suami / Istri','Kelalaian Atas Kewajiban Suami / Istri','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
		(346,NULL,'Cerai Talak','Cerai Talak','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
		(347,NULL,'Cerai Gugat','Cerai Gugat','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
		(348,NULL,'Harta Bersama','Harta Bersama','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
		(349,NULL,'Penguasaan Anak/Pengang','Penguasaan Anak','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
		(350,NULL,'Nafkah Anak Oleh Ibu karena Ayah tidak mampu','Nafkah Anak Oleh Ibu karena Ayah tidak mampu','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
		(351,NULL,'Hak - hak bekas istri/kewajiban bekas Suami','Hak - hak bekas istri/kewajiban bekas Suami','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
		(352,NULL,'Pengesahan Anak','Pengesahan Anak','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
		(353,NULL,'Pencabutan Kekuasaan Orang Tua','Pencabutan Kekuasaan Orang Tua','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
		(354,NULL,'Perwalian','Perwalian','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
		(355,NULL,'Pencabutan Kekuasaan Wali','Pencabutan Kekuasaan Wali','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
		(356,NULL,'Penunjukan orang lain sebagai Wali oleh Pengadilan','Penunjukan orang lain sebagai Wali oleh Pengadilan','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
		(357,NULL,'Ganti Rugi terhadap Wali','Ganti Rugi terhadap Wali','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
		(358,NULL,'Asal Usul Anak','Asal Usul Anak','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
		(359,NULL,'Perkawinan Campuran','Penolakan Kawin Campuran','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
		(360,NULL,'Pengesahan Perkawinan/Istbat Nikah','Pengesahan Perkawinan/Istbat Nikah','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
		(361,NULL,'Izin Kawin','Izin Kawin','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
		(362,NULL,'Dispensasi Kawin','Dispensasi Kawin','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
		(363,NULL,'Wali Adhol','Wali Adhol','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
		(364,NULL,'Kewarisan','Kewarisan','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
		(365,NULL,'Wasiat','Wasiat','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
		(366,NULL,'Hibah','Hibah','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
		(367,NULL,'Wakaf','Wakaf','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
		(369,NULL,'Lain-Lain','Lain-Lain','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
		(370,NULL,'Ekonomi Syariah','Ekonomi Syariah','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
		(371,NULL,'P3HP/Penetapan Ahli Waris','P3HP/Penetapan Ahli Waris','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#');");


		$this->patching->exe_script("REPLACE INTO biaya_perkara (alur_perkara_id,jenis_biaya_id,jumlah) SELECT 9,jenis_biaya_id,jumlah FROM biaya_perkara WHERE alur_perkara_id=1;");
		$this->patching->exe_script("DELETE FROM biaya_perkara WHERE jenis_biaya_id IN (25,26,27,159,160,161,174,175,176,189,190,191,204,205,206,219,220,221,244,245,246,247,248,249,250,251,282,284,285,286,287,288,289,290,291,292,293,316,294,295,296,297,298) AND alur_perkara_id=9;");



		$this->patching->exe_script("DROP TABLE IF EXISTS perkara_dismissal;");
		$this->patching->exe_script("CREATE TABLE perkara_dismissal(  
			perkara_id BIGINT(30) UNSIGNED NOT NULL,
			tanggal_penetapan DATE,
			amar TEXT,
			hasil CHAR(1),
			pemberitahuan_penggugat DATE,
			pemberitahuan_tergugat DATE,
			diinput_oleh VARCHAR(30),
			diinput_tanggal DATE,
			diperbaharui_oleh VARCHAR(30),
			diperbaharui_tanggal DATE,
			PRIMARY KEY (perkara_id),
			CONSTRAINT perkara_dismissal_fk FOREIGN KEY (perkara_id) REFERENCES perkara (perkara_id) ON DELETE CASCADE
			);");

		$this->patching->exe_script("DROP TABLE IF EXISTS perkara_panggilan_dismissal;");
		$this->patching->exe_script("CREATE TABLE perkara_panggilan_dismissal(  
			id BIGINT(30) UNSIGNED NOT NULL,
			perkara_id BIGINT(30) UNSIGNED NOT NULL,
			tanggal_panggilan DATE,
			waktu TIME NULL,
			`status` CHAR(1),
			status_text VARCHAR(30),
			diinput_oleh VARCHAR(30),
			diinput_tanggal DATE,
			diperbaharui_oleh VARCHAR(30),
			diperbaharui_tanggal DATE,
			PRIMARY KEY (id),
			CONSTRAINT perkara_panggilan_dismissal_fk FOREIGN KEY (perkara_id) REFERENCES perkara (perkara_id) ON DELETE CASCADE
		);");

		$this->patching->exe_script("DROP TABLE IF EXISTS perkara_persiapan;");
		$this->patching->exe_script("CREATE TABLE perkara_persiapan(  
			perkara_id BIGINT(20) UNSIGNED NOT NULL,
			tanggal_penetapan_persiapan DATE NOT NULL,
			petitum TEXT NOT NULL,
			petitum_dok VARCHAR(200),
			diinput_oleh VARCHAR(30),
			diinput_tanggal DATETIME,
			diperbaharui_oleh VARCHAR(30),
			diperbaharui_tanggal DATETIME,
			PRIMARY KEY (perkara_id),
			CONSTRAINT perkara_persiapan_fk FOREIGN KEY (perkara_id) REFERENCES perkara(perkara_id) ON DELETE CASCADE
		) ENGINE=INNODB;");

		$this->patching->exe_script("DROP TABLE IF EXISTS perkara_persiapan_proses;");
		$this->patching->exe_script("CREATE TABLE perkara_persiapan_proses(  
			id BIGINT(20) NOT NULL AUTO_INCREMENT,
			perkara_id BIGINT(20) NOT NULL,
			urutan INT(9) NOT NULL,
			tanggal_musyawarah DATE,
			agenda_musyawarah VARCHAR(100) NOT NULL,
			waktu_musyawarah TIME,
			keterangan VARCHAR(255),
			diinput_oleh VARCHAR(30),
			diinput_tanggal DATE,
			diperbaharui_oleh VARCHAR(30),
			diperbaharui_tanggal DATE,
			PRIMARY KEY (id, perkara_id),
			CONSTRAINT perkara_persiapan_proses_fk FOREIGN KEY (perkara_id) REFERENCES perkara(perkara_id) ON DELETE CASCADE
		) ENGINE=MYISAM;");
		
$this->patching->exe_script("DROP TABLE IF EXISTS delegasi_keluar;");
$this->patching->exe_script("CREATE TABLE delegasi_keluar (
                              id bigint(11) unsigned NOT NULL AUTO_INCREMENT,
                              perkara_id bigint(20) unsigned NOT NULL,
                              nomor_perkara varchar(50) NOT NULL,
                              id_pn_asal smallint(11) NOT NULL,
                              kode_satker_asal int(11) NOT NULL,
                              pn_asal_text varchar(100) DEFAULT NULL,
                              id_pn_tujuan smallint(11) NOT NULL,
                              kode_satker_tujuan int(11) NOT NULL,
                              pn_tujuan_text varchar(100) DEFAULT NULL,
                              tgl_delegasi date DEFAULT NULL,
                              id_jenis_delegasi char(2) NOT NULL,
                              jenis_delegasi_text varchar(100) DEFAULT NULL,
                              tgl_surat date DEFAULT NULL,
                              tgl_pengiriman date DEFAULT NULL,
                              nomor_surat varchar(100) DEFAULT NULL,
                              tgl_sidang DATE NULL,
                              namadokumen varchar(100) DEFAULT NULL,
                              document longblob,
                              document_size bigint(20) DEFAULT NULL,
                              document_mime varchar(50) DEFAULT NULL,
                              tgl_resi date DEFAULT NULL,
                              nomor_resi varchar(50) DEFAULT NULL,
                              biaya float(16,2) DEFAULT NULL,
                              pihak varchar(1000) NULL,
                              catatan varchar(100) DEFAULT NULL,
                              diinput_oleh varchar(30) DEFAULT NULL,
                              diinput_tanggal date DEFAULT NULL,
                              diperbaharui_oleh varchar(30) DEFAULT NULL,
                              diperbaharui_tanggal date DEFAULT NULL,
                              PRIMARY KEY (id,id_pn_asal,id_pn_tujuan,id_jenis_delegasi)
                            ) ENGINE=MyISAM;");



$this->patching->exe_script("DROP TABLE IF EXISTS delegasi_masuk;");
$this->patching->exe_script("CREATE TABLE delegasi_masuk (
                            id bigint(11) unsigned NOT NULL AUTO_INCREMENT,
                            perkara_id bigint(20) unsigned NOT NULL,
                            nomor_perkara varchar(50) NOT NULL,
                            id_pn_asal smallint(11) NOT NULL,
                            kode_satker_asal int(11) NOT NULL,
                            pn_asal_text varchar(100) DEFAULT NULL,
                            id_pn_tujuan smallint(11) NOT NULL,
                            kode_satker_tujuan int(11) NOT NULL,
                            pn_tujuan_text varchar(100) DEFAULT NULL,
                            tgl_delegasi date DEFAULT NULL,
                            id_jenis_delegasi char(2) NOT NULL,
                            jenis_delegasi_text varchar(100) DEFAULT NULL,
                            tgl_surat date DEFAULT NULL,
                            tgl_pengiriman date DEFAULT NULL,
                            nomor_surat varchar(100) DEFAULT NULL,
                            tgl_sidang DATE NULL,
                            namadokumen varchar(100) DEFAULT NULL,
                            document longblob,
                            document_size bigint(20) DEFAULT NULL,
                            document_mime varchar(50) DEFAULT NULL,
                            tgl_resi date DEFAULT NULL,
                            nomor_resi varchar(50) DEFAULT NULL,
                            biaya float(16,2) DEFAULT NULL,
                            pihak varchar(1000) NULL,
                            catatan varchar(100) DEFAULT NULL,
                            diinput_oleh varchar(30) DEFAULT NULL,
                            diinput_tanggal date DEFAULT NULL,
                            diperbaharui_oleh varchar(30) DEFAULT NULL,
                            diperbaharui_tanggal date DEFAULT NULL,
                            PRIMARY KEY (id,id_pn_asal,id_pn_tujuan,id_jenis_delegasi)
                          ) ENGINE=MyISAM;");



$this->patching->exe_script("DROP TABLE IF EXISTS delegasi_proses_keluar;");

$this->patching->exe_script("CREATE TABLE delegasi_proses_keluar (
                              delegasi_id bigint(20) unsigned NOT NULL,
                              tgl_surat_diterima date DEFAULT NULL,
                              perkara_id bigint(20) unsigned NOT NULL,
                              tgl_penunjukan_jurusita date DEFAULT NULL,
                              jurusita_id bigint(11) unsigned NOT NULL,
                              jurusita_nama varchar(100) DEFAULT NULL,
                              id_pn_asal smallint(11) unsigned NOT NULL,
                              pn_asal_text varchar(100) DEFAULT NULL,
                              kode_satker_asal int(11) DEFAULT NULL,
                              id_pn_tujuan smallint(11) NOT NULL,
                              pn_tujuan_text varchar(100) DEFAULT NULL,
                              kode_satker_tujuan int(11) DEFAULT NULL,
                              tgl_relaas date DEFAULT NULL,
                              nomor_relaas varchar(50) DEFAULT NULL,
                              tgl_pengiriman_relaas date DEFAULT NULL,
                              nomor_surat_pengantar_relaas varchar(50) DEFAULT NULL,
                              id_status_delegasi char(1) DEFAULT NULL,
                              status_delegasi varchar(50) DEFAULT NULL,
                              namadokumen varchar(100) DEFAULT NULL,
                              document longblob,
                              document_size bigint(20) DEFAULT NULL,
                              document_mime varchar(50) DEFAULT NULL,
                              tgl_resi date DEFAULT NULL,
                              nomor_resi varchar(50) DEFAULT NULL,
                              biaya float(16,2) DEFAULT NULL,
                              catatan varchar(100) DEFAULT NULL,
                              diinput_oleh varchar(30) DEFAULT NULL,
                              diinput_tanggal date DEFAULT NULL,
                              diperbaharui_oleh varchar(30) DEFAULT NULL,
                              diperbaharui_tanggal date DEFAULT NULL,
                              PRIMARY KEY (delegasi_id),
                              KEY indeks (delegasi_id)
                            ) ENGINE=MyISAM;");


$this->patching->exe_script("DROP TABLE IF EXISTS delegasi_proses_masuk;");

$this->patching->exe_script("CREATE TABLE delegasi_proses_masuk (
                            delegasi_id bigint(20) NOT NULL,
                            tgl_surat_diterima date DEFAULT NULL,
                            perkara_id bigint(20) NOT NULL,
                            tgl_penunjukan_jurusita date DEFAULT NULL,
                            jurusita_id bigint(11) NOT NULL,
                            jurusita_nama varchar(100) DEFAULT NULL,
                            id_pn_asal smallint(11) NOT NULL,
                            pn_asal_text varchar(100) DEFAULT NULL,
                            kode_satker_asal int(11) DEFAULT NULL,
                            id_pn_tujuan smallint(11) NOT NULL,
                            pn_tujuan_text varchar(100) DEFAULT NULL,
                            kode_satker_tujuan int(11) DEFAULT NULL,
                            tgl_relaas date DEFAULT NULL,
                            nomor_relaas varchar(50) DEFAULT NULL,
                            tgl_pengiriman_relaas date DEFAULT NULL,
                            nomor_surat_pengantar_relaas varchar(50) DEFAULT NULL,
                            id_status_delegasi char(1) DEFAULT NULL,
                            status_delegasi varchar(50) DEFAULT NULL,
                            namadokumen varchar(100) DEFAULT NULL,
                            document longblob,
                            document_size bigint(20) DEFAULT NULL,
                            document_mime varchar(50) DEFAULT NULL,
                            tgl_resi date DEFAULT NULL,
                            nomor_resi varchar(50) DEFAULT NULL,
                            biaya float(16,2) DEFAULT NULL,
                            catatan varchar(100) DEFAULT NULL,
                            diinput_oleh varchar(30) DEFAULT NULL,
                            diinput_tanggal date DEFAULT NULL,
                            diperbaharui_oleh varchar(30) DEFAULT NULL,
                            diperbaharui_tanggal date DEFAULT NULL,
                            PRIMARY KEY (delegasi_id),
                            KEY indeks (delegasi_id)
                          ) ENGINE=MyISAM;");

		$this->patching->exe_script("DROP TABLE IF EXISTS jenis_delegasi;");
		$this->patching->exe_script("CREATE TABLE jenis_delegasi (
		  id INT(11) NOT NULL AUTO_INCREMENT,
		  jenis_delegasi VARCHAR(255) DEFAULT NULL,
		  PRIMARY KEY (id)
		) ENGINE=MYISAM;");

		$this->patching->exe_script("REPLACE INTO jenis_delegasi(id,jenis_delegasi) 
		VALUES 
		(1,'Panggilan Sidang'),
		(2,'Pemberitahuan Putusan Pengadilan Tingkat Pertama'),
		(3,'Pemberitahuan Pernyataan Banding'),
		(4,'Pemberitahuan dan Penyerahan Memori Banding'),
		(5,'Pemberitahuan Memeriksa Berkas'),
		(6,'Pemberitahuan Putusan Pengadilan Tinggi'),
		(7,'Pemberitahuan Pernyataan Kasasi'),
		(8,'Pemberitahuan dan Penyerahan Memori Kasasi'),
		(9,'Pemberitahuan dan Penyerahan Kontra Memori Kasasi '),
		(10,'Pemberitahuan Putusan Mahkamah Agung (Kasasi)'),
		(11,'Pemberitahuan Pernyataan PK'),
		(12,'Pemberitahuan dan Penyerahan memori PK'),
		(13,'Pemberitahuan dan Penyerahan Kontra memori PK'),
		(14,'Pemberitahuan Putusan Mahkamah Agung (PK)'),
		(15,'Lain lain');");
$this->patching->exe_script("DROP TABLE IF EXISTS delegasikeluarweb;");
$this->patching->exe_script("CREATE TABLE delegasikeluarweb (
                            ID bigint(11) unsigned NOT NULL DEFAULT '0',
                            IDPerkara bigint(20) unsigned NOT NULL,
                            noPerkara varchar(50) NOT NULL,
                            idPNAsal smallint(11) NOT NULL,
                            kodeSatkerAsal int(11) NOT NULL,
                            pnAsalText varchar(100) DEFAULT NULL,
                            IDPNTujuan smallint(11) NOT NULL,
                            kodeSatkerTujuan int(11) NOT NULL,
                            pnTujuanText varchar(100) DEFAULT NULL,
                            tglDelegasi date DEFAULT NULL,
                            IDJenisDelegasi char(2) NOT NULL,
                            jenisDelegasiText varchar(100) DEFAULT NULL,
                            tglSurat date DEFAULT NULL,
                            tglPengiriman date DEFAULT NULL,
                            noSurat varchar(100) DEFAULT NULL
                          ) ENGINE=MyISAM;");

$this->patching->exe_script("DROP TABLE IF EXISTS delegasimasukweb;");

$this->patching->exe_script("CREATE TABLE delegasimasukweb (
                            ID bigint(11) unsigned NOT NULL DEFAULT '0',
                            IDPerkara bigint(20) unsigned NOT NULL,
                            noPerkara varchar(50) NOT NULL,
                            idPNAsal smallint(11) NOT NULL,
                            kodeSatkerAsal int(11) NOT NULL,
                            pnAsalText varchar(100) DEFAULT NULL,
                            IDPNTujuan smallint(11) NOT NULL,
                            kodeSatkerTujuan int(11) NOT NULL,
                            pnTujuanText varchar(100) DEFAULT NULL,
                            tglDelegasi date DEFAULT NULL,
                            IDJenisDelegasi char(2) NOT NULL,
                            jenisDelegasiText varchar(100) DEFAULT NULL,
                            tglSurat date DEFAULT NULL,
                            tglPengiriman date DEFAULT NULL,
                            noSurat varchar(100) DEFAULT NULL
                          ) ENGINE=MyISAM;");

$this->patching->exe_script("DROP TABLE IF EXISTS delegasiproseskeluarweb");

$this->patching->exe_script("CREATE TABLE delegasiproseskeluarweb (
                            IDDelegasi bigint(20) unsigned NOT NULL,
                            tglSuratDiterima date DEFAULT NULL,
                            IDPerkara bigint(20) unsigned NOT NULL,
                            IDJurusita bigint(11) unsigned NOT NULL,
                            jurusitaNama varchar(100) DEFAULT NULL,
                            idPNAsal smallint(11) unsigned NOT NULL,
                            pnAsalText varchar(100) DEFAULT NULL,
                            kodeSatkerAsal int(11) DEFAULT NULL,
                            idPNTujuan smallint(11) NOT NULL,
                            pnTujuanText varchar(100) DEFAULT NULL,
                            kodeSatkertTujuan int(11) DEFAULT NULL,
                            tglRelaas date DEFAULT NULL,
                            nomorRelaas varchar(50) DEFAULT NULL,
                            tglPengirimanRelaas date DEFAULT NULL,
                            nomorSuratPengantarRelaas varchar(50) DEFAULT NULL,
                            idStatusDeleasgi char(1) DEFAULT NULL,
                            statusDelegasi varchar(50) DEFAULT NULL,
                            catatan varchar(100) DEFAULT NULL
                          ) ENGINE=MyISAM;");

$this->patching->exe_script("DROP TABLE IF EXISTS delegasiprosesmasukweb;");
$this->patching->exe_script("CREATE TABLE delegasiprosesmasukweb (
                            IDDelegasi bigint(20) NOT NULL,
                            tglSuratDiterima date DEFAULT NULL,
                            IDPerkara bigint(20) NOT NULL,
                            IDJurusita bigint(11) NOT NULL,
                            jurusitaNama varchar(100) DEFAULT NULL,
                            idPNAsal smallint(11) NOT NULL,
                            pnAsalText varchar(100) DEFAULT NULL,
                            kodeSatkerAsal int(11) DEFAULT NULL,
                            idPNTujuan smallint(11) NOT NULL,
                            pnTujuanText varchar(100) DEFAULT NULL,
                            kodeSatkertTujuan int(11) DEFAULT NULL,
                            tglRelaas date DEFAULT NULL,
                            nomorRelaas varchar(50) DEFAULT NULL,
                            tglPengirimanRelaas date DEFAULT NULL,
                            nomorSuratPengantarRelaas varchar(50) DEFAULT NULL,
                            idStatusDeleasgi char(1) DEFAULT NULL,
                            statusDelegasi varchar(50) DEFAULT NULL,
                            catatan varchar(100) DEFAULT NULL
                          ) ENGINE=MyISAM;");

		$this->patching->exe_script("REPLACE INTO jenis_alur_perkara (alur_perkara_id, jenis_perkara_id)
		VALUES 
		(120, 262),
		(120, 263),
		(120, 264),
		(120, 265),
		(120, 266),
		(120, 267), 
		(120, 268),
		(120, 269),
		(120, 270),
		(120, 271),
		(120, 272),
		(120, 273), 
		(120, 274),
		(120, 275),
		(120, 276),
		(120, 277),
		(120, 278),
		(120, 279), 
		(120, 280),
		(120, 281),
		(120, 282),
		(120, 283),
		(120, 284),
		(120, 285), 
		(120, 286),
		(120, 287),
		(120, 288),
		(120, 289),
		(120, 290),
		(120, 291), 
		(120, 292),
		(120, 293),
		(120, 294),
		(120, 295),
		(120, 296),
		(120, 297), 
		(120, 298),
		(120, 299),
		(120, 300),
		(120, 301),
		(120, 302),
		(120, 303), 
		(120, 304),
		(120, 305),
		(120, 306),
		(120, 307),
		(120, 308),
		(120, 309), 
		(120, 310),
		(120, 311),
		(120, 312),
		(120, 313),
		(120, 314),
		(120, 315),
		(120, 316),
		(120, 317),
		(120, 338),
		(120, 339),
		(121,340),
		(9,318),
		(9,319),
		(9,320),
		(9,321),
		(9,322),
		(9,323),
		(9,324),
		(9,325),
		(9,326),
		(9,327),
		(9,328),
		(9,329),
		(9,330),
		(9,331),
		(9,332),
		(9,333),
		(9,334),
		(9,335),
		(10,331),
		(11,335),
		(12,333),
		(13,334),
		(14,332),
		(121,340),
		(15,341),
		(16,342),
		(16,343),
		(15,344),
		(15,345),
		(15,346),
		(15,347),
		(15,348),
		(15,349),
		(16,349),
		(15,350),
		(16,350),
		(15,351),
		(16,351),
		(15,352),
		(16,352),
		(15,353),
		(16,353),
		(15,354),
		(15,355),
		(16,355),
		(15,356),
		(16,356),
		(15,357),
		(16,357),
		(15,358),
		(16,358),
		(16,359),
		(15,360),
		(16,360),
		(16,361),
		(16,362),
		(16,363),
		(15,364),
		(15,365),
		(15,366),
		(15,367),
		(15,368),
		(15,369),
		(16,369),
		(15,370),
		(16,371);");


		$this->patching->exe_script("UPDATE sys_groups SET parent_id = 410 WHERE groupid = 702;");

		$this->patching->exe_script("REPLACE INTO status_penahanan (id, nama) VALUES (5, 'Dibebaskan');");


		$this->patching->exe_script("DROP VIEW IF EXISTS v_perkara_eksekusi");
		$this->patching->exe_script("CREATE VIEW v_perkara_eksekusi AS 
		SELECT
			perkara_eksekusi.perkara_id                         		AS perkara_id,
			perkara_eksekusi.alur_perkara_id                    		AS alur_perkara_id,
			perkara_eksekusi.nomor_perkara_pn                   		AS nomor_perkara_pn,
			perkara.nomor_indeks                                		AS nomor_indeks,
			perkara_eksekusi.putusan_pn                         		AS putusan_pn,
			perkara_eksekusi.nomor_perkara_banding              		AS nomor_perkara_banding,
			perkara_eksekusi.putusan_banding                    		AS putusan_banding,
			perkara_eksekusi.nomor_perkara_kasasi               		AS nomor_perkara_kasasi,
			perkara_eksekusi.putusan_kasasi                     		AS putusan_kasasi,
			perkara_eksekusi.nomor_perkara_pk                   		AS nomor_perkara_pk,
			perkara_eksekusi.putusan_pk                         		AS putusan_pk,
			perkara_eksekusi.eksekusi_putusan                   		AS eksekusi_putusan,
			perkara_eksekusi.eksekusi_nomor_perkara             		AS eksekusi_nomor_perkara,
			perkara_eksekusi.nomor_urut_perkara_eksekusi		  						AS nomor_urut_perkara_eksekusi,
			perkara_eksekusi.nomor_register_eksekusi		  	  						AS nomor_register_eksekusi,
			perkara_eksekusi.eksekusi_amar_putusan              		AS eksekusi_amar_putusan,
			perkara_eksekusi.pihak_pemohon_eksekusi             		AS pihak_pemohon_eksekusi,
			perkara_eksekusi.permohonan_eksekusi                		AS permohonan_eksekusi,
			perkara_eksekusi.pemohon_eksekusi                   		AS pemohon_eksekusi,
			perkara_eksekusi.para_pihak                         		AS para_pihak,
			perkara_eksekusi.penetapan_teguran_eksekusi         		AS penetapan_teguran_eksekusi,
			perkara_eksekusi.nomor_penetapan_teguran_eksekusi   		AS nomor_penetapan_teguran_eksekusi,
			perkara_eksekusi.pelaksanaan_teguran_eksekusi       		AS pelaksanaan_teguran_eksekusi,
			perkara_eksekusi.penetapan_sita_eksekusi            		AS penetapan_sita_eksekusi,
			perkara_eksekusi.nomor_penetapan_sita_eksekusi      		AS nomor_penetapan_sita_eksekusi,
			perkara_eksekusi.pelaksanaan_sita_eksekusi          		AS pelaksanaan_sita_eksekusi,
			perkara_eksekusi.jurusita_id                        		AS jurusita_id,
			perkara_eksekusi.jurusita_nama                      		AS jurusita_nama,
			perkara_eksekusi.penetapan_perintah_eksekusi_lelang 		AS penetapan_perintah_eksekusi_lelang,
			perkara_eksekusi.pelaksanaan_eksekusi_lelang        		AS pelaksanaan_eksekusi_lelang,
			perkara_eksekusi.penyerahan_hasil_lelang            		AS penyerahan_hasil_lelang,
			perkara_eksekusi.penetapan_perintah_eksekusi_rill   		AS penetapan_perintah_eksekusi_rill,
			perkara_eksekusi.pelaksanaan_eksekusi_rill          		AS pelaksanaan_eksekusi_rill,
			perkara_eksekusi.penetapan_noneksekusi              		AS penetapan_noneksekusi,
			perkara_eksekusi.diterima_permohonan				        AS diterima_permohonan,
			perkara_eksekusi.panggilan_parapihak				        AS panggilan_parapihak,
			perkara_eksekusi.penetapan_ketua						    AS penetapan_ketua,
			perkara_eksekusi.sk_objek_tidak_punya_kekuatan_hukum		AS sk_objek_tidak_punya_kekuatan_hukum,
			perkara_eksekusi.surat_tergugat_objek_non_executable		AS surat_tergugat_objek_non_executable,
			perkara_eksekusi.panggilan_pihak_non_executable			    AS panggilan_pihak_non_executable,
			perkara_eksekusi.upaya_kesepakatan_kompensasi			      AS upaya_kesepakatan_kompensasi,
			perkara_eksekusi.penetapan_ketua_kompensasi			        AS penetapan_ketua_kompensasi,
			perkara_eksekusi.upaya_hukum_kma						            AS upaya_hukum_kma,
			perkara_eksekusi.penetapan_kma_kompensasi			          AS penetapan_kma_kompensasi,
			perkara_eksekusi.uangpaksa_putusan_hakim				        AS uangpaksa_putusan_hakim,
			perkara_eksekusi.uangpaksa_penetapan_ketua				      AS uangpaksa_penetapan_ketua,
			perkara_eksekusi.surat_ketua_tergugat_uangpaksa			    AS surat_ketua_tergugat_uangpaksa,
			perkara_eksekusi.surat_peringatan_uangpaksa			        AS surat_peringatan_uangpaksa,
			perkara_eksekusi.perintah_ketua_saksi_administratif			AS perintah_ketua_saksi_administratif,
			perkara_eksekusi.sanksi_administratif_dari_pejabat			AS sanksi_administratif_dari_pejabat,
			perkara_eksekusi.pengumuman_ketua_panitera_js			      AS pengumuman_ketua_panitera_js,
			perkara_eksekusi.pengumuman_media					              AS pengumuman_media,
			perkara_eksekusi.surat_presiden							            AS surat_presiden,
			perkara_eksekusi.surat_lembaga_perwakilan_rakyat			  AS surat_lembaga_perwakilan_rakyat,
		  perkara_eksekusi.alasan_eksekusi                    		AS alasan_eksekusi,
			perkara_eksekusi.catatan_eksekusi                   		AS catatan_eksekusi,
			perkara_eksekusi.prodeo_eksekusi                    		AS prodeo_eksekusi,
			perkara_eksekusi.status_eksekusi_id                 		AS status_eksekusi_id,
			perkara_eksekusi.status_eksekusi_text               		AS status_eksekusi_text,
			perkara_eksekusi.diedit_oleh                        		AS diedit_oleh,
			perkara_eksekusi.diedit_tanggal                     		AS diedit_tanggal,
			perkara_eksekusi.diinput_oleh                       		AS diinput_oleh,
			perkara_eksekusi.diinput_tanggal                    		AS diinput_tanggal,
			perkara_eksekusi.diperbaharui_oleh                  		AS diperbaharui_oleh,
			perkara_eksekusi.diperbaharui_tanggal               		AS diperbaharui_tanggal,
			perkara.prodeo                                      		AS prodeo,
			perkara.terdakwa_anak                               		AS terdakwa_anak,
			perkara.tanggal_pendaftaran                         		AS tanggal_pendaftaran
		FROM (perkara_eksekusi
		   LEFT JOIN perkara
		     ON ((perkara_eksekusi.perkara_id = perkara.perkara_id)));");

		$this->patching->exe_script("DROP TABLE IF EXISTS lembaga_pemasyarakatan;");

		$this->patching->exe_script("CREATE TABLE lembaga_pemasyarakatan(  
			  id INT(11) UNSIGNED NOT NULL,
			  kode_satker INT(11) UNSIGNED,
			  id_propinsi INT(11) UNSIGNED NOT NULL,
			  propinsi VARCHAR(50) NOT NULL,
			  id_kabupaten INT(11) UNSIGNED NOT NULL,
			  kabupaten VARCHAR(50) NOT NULL,
			  nama VARCHAR(250) NOT NULL,
			  alamat VARCHAR(500) NOT NULL,
			  jenis TINYINT(1) DEFAULT NULL,   
			  kode_pos VARCHAR(50),
			  kanwil VARCHAR(50),
			  diinput_oleh VARCHAR(30),
			  diinput_tanggal DATETIME,
			  diperbaharui_oleh VARCHAR(30),
			  diperbaharui_tanggal DATETIME,
			  PRIMARY KEY (id)
			) ENGINE=INNODB;");
		$this->patching->exe_script("ALTER TABLE lembaga_pemasyarakatan 
					CHANGE jenis jenis TINYINT(1) DEFAULT NULL COMMENT '1=Rutan, 2=Rupbasan, 3=Cabrut, 4=Lapas, 5=Bapas';");
		
		$this->patching->exe_script("REPLACE INTO lembaga_pemasyarakatan (id, kode_satker, id_propinsi, propinsi, id_kabupaten, kabupaten, nama, alamat, jenis, kode_pos, kanwil, diinput_oleh, diinput_tanggal) VALUES
		('1','683402','1','Nanggroe Aceh Darussalam','1','BANDA ACEH','RUTAN KELAS II B BANDA ACEH','NULL','1','','KANWIL ACEH','system','2015-12-20 15:39:01'),
		('2','632595','1','Nanggroe Aceh Darussalam','1','BANDA ACEH','RUPBASAN KLAS I BANDA ACEH','JL. NYAK ARIF NO.270 Jeulingke Banda Aceh','2','','KANWIL ACEH','system','2015-12-20 15:39:01'),
		('3','539096','1','Nanggroe Aceh Darussalam','1','ACEH BESAR','RUTAN KELAS II B JANTHO','JL. Ibrahim Saidi No. 07 Kota Jantho, Aceh Besar','1','','KANWIL ACEH','system','2015-12-20 15:39:01'),
		('4','405662','1','Nanggroe Aceh Darussalam','1','BANDA ACEH','CABANG RUTAN SINGKEL','JL. MERDEKA NO.54, SINGKEL','3','23114','KANWIL ACEH','system','2015-12-20 15:39:01'),
		('5','405534','1','Nanggroe Aceh Darussalam','1','LHOKNGA','CABANG RUTAN LHOK NGA','JL. MEULABOH KM. 14','3','23353','KANWIL ACEH','system','2015-12-20 15:39:01'),
		('6','405492','1','Nanggroe Aceh Darussalam','1','BANDA ACEH','LAPAS KELAS II A BANDA ACEH','Jl. Lembaga Desa Bineuh Blang Kec. Ingin Jaya Kab.','4','23242','KANWIL ACEH','system','2015-12-20 15:39:01'),
		('7','109113','1','Nanggroe Aceh Darussalam','1','BANDA ACEH','BAPAS KLAS II ACEH','JL. LAKSAMANA MALAHAYATI NO.6','5','23373','KANWIL ACEH','system','2015-12-20 15:39:01'),
		('8','405503','1','Nanggroe Aceh Darussalam','2','SABANG','RUTAN KELAS II B SABANG','JL. O. SURAPATI','1','23511','KANWIL ACEH','system','2015-12-20 15:39:01'),
		('9','683992','1','Nanggroe Aceh Darussalam','3','SIGLI','LAPAS WANITA KELAS III SIGLI','NULL','4','','KANWIL ACEH','system','2015-12-20 15:39:01'),
		('10','405571','1','Nanggroe Aceh Darussalam','3','KOTA BAKTI','CABANG RUTAN KOTA BAKTI','JL. TGK. CIK DITIRO','3','24164','KANWIL ACEH','system','2015-12-20 15:39:01'),
		('11','405512','1','Nanggroe Aceh Darussalam','3','SIGLI','RUTAN KELAS II B SIGLI','JL. MALAHAYATI NO.1','1','24119','KANWIL ACEH','system','2015-12-20 15:39:01'),
		('12','405559','1','Nanggroe Aceh Darussalam','4','BIREUEN','CABANG RUTAN BEUREUN','JL. LAKSAMANA MALAHAYATI NO. 14','3','','KANWIL ACEH','system','2015-12-20 15:39:01'),
		('13','405543','1','Nanggroe Aceh Darussalam','5','LHOK SUKON','CABANG RUTAN LHOK SUKON','JL. TGK. CIK DITIRO, LHOK SUKON','3','24382','KANWIL ACEH','system','2015-12-20 15:39:01'),
		('14','405528','1','Nanggroe Aceh Darussalam','6','LHOK SEUMAWE','LAPAS KELAS II A LHOK SEUMAWE','JL. DIPONEGORO NO. 22','4','24315','KANWIL ACEH','system','2015-12-20 15:39:01'),
		('15','405565','1','Nanggroe Aceh Darussalam','7','TAKENGON','RUTAN KELAS II B TAKENGON','JL. LEMBAGA NO. 139','1','24315','KANWIL ACEH','system','2015-12-20 15:39:01'),
		('16','683657','1','Nanggroe Aceh Darussalam','8','Langsa','LAPAS NARKOTIKA KELAS III LANGSA','Jalan Banda Aceh-Medan Km 438 kota Langsa','4','','KANWIL ACEH','system','2015-12-20 15:39:01'),
		('17','405610','1','Nanggroe Aceh Darussalam','8','Langsa','CABANG RUTAN LANGSA','JL. T. PANGLIMA POLIM NO. 391','3','24454','KANWIL ACEH','system','2015-12-20 15:39:01'),
		('18','405590','1','Nanggroe Aceh Darussalam','8','LANGSA','LAPAS KELAS II B LANGSA','JL. PANGLIMA POLIM NO.39','4','24416','KANWIL ACEH','system','2015-12-20 15:39:01'),
		('19','405596','1','Nanggroe Aceh Darussalam','10','ACEH TAMIANG','LAPAS KELAS II B KUALA SIMPANG','DS. DALAM KEC. KARANG BARU, KUALA SIMPANG','4','24475','KANWIL ACEH','system','2015-12-20 15:39:01'),
		('20','405622','1','Nanggroe Aceh Darussalam','11','BLANGKEJEREN','CABANG RUTAN BLANGKAJEREN','JL. KONGBUR NO. 51','3','24653','KANWIL ACEH','system','2015-12-20 15:39:01'),
		('21','653065','1','Nanggroe Aceh Darussalam','12','KUTACANE','BAPAS KLAS II KUTACANE','JL. KUTACANE BLANGKEJEREN KM. 4 PURWODADI','5','','KANWIL ACEH','system','2015-12-20 15:39:01'),
		('22','405616','1','Nanggroe Aceh Darussalam','12','KUTACANE','LAPAS KELAS II B KUTACANE','JL. JEND. A. YANI','4','24601','KANWIL ACEH','system','2015-12-20 15:39:01'),
		('23','405631','1','Nanggroe Aceh Darussalam','13','MEULABOH','LAPAS KELAS II B MEULABOH','JL. KESATRYA SK/III-23','4','23611','KANWIL ACEH','system','2015-12-20 15:39:01'),
		('24','405647','1','Nanggroe Aceh Darussalam','14','CALANG','CABANG RUTAN CALANG','JL. ASRAMA TNI-AD NO. 171','3','23654','KANWIL ACEH','system','2015-12-20 15:39:01'),
		('25','405678','1','Nanggroe Aceh Darussalam','15','SINABANG','CABANG RUTAN SINABANG','JL. PAHLAWAN NO. 180/RT.II','3','23691','KANWIL ACEH','system','2015-12-20 15:39:01'),
		('26','683991','1','Nanggroe Aceh Darussalam','16','BLANG PIDIE','LAPAS KELAS III BLANGPIDIE','NULL','4','','KANWIL ACEH','system','2015-12-20 15:39:01'),
		('27','405653','1','Nanggroe Aceh Darussalam','16','TAPAKTUAN','RUTAN KELAS II B TAPAKTUAN','JL. SUDIRMAN NO.111','1','23711','KANWIL ACEH','system','2015-12-20 15:39:01'),
		('28','109115','2','Sumatera Utara','19','MEDAN','LEMBAGA PEMBINAAN KHUSUS ANAK KELAS I MEDAN','Jl. Pemasyarakatan Tanjung Gusta Medan','4','20125','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('29','405797','2','Sumatera Utara','19','LABUHAN DELI','RUTAN KELAS II B LABUHAN DELI','JL. HAMPARAN PERAK S.D. 34/35','1','20251','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('30','405693','2','Sumatera Utara','19','MEDAN','LAPAS KELAS I MEDAN','JL. PEMASYARAKATAN, TANJUNG GUSTA','4','20125','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('31','109114','2','Sumatera Utara','19','Medan','LAPAS WANITA KELAS II A MEDAN','Jl. Pemasyarakatan Tg. Gusta','4','','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('32','405684','2','Sumatera Utara','19','MEDAN','BAPAS KLAS I MEDAN','JL. ASRAMA GG. JAYAK NO. 33 KM. 6,5','5','22900','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('33','109116','2','Sumatera Utara','19','MEDAN','RUTAN KELAS I MEDAN','JL. PEMASYARAKATAN, TANJUNG GUSTA','1','20125','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('34','626101','2','Sumatera Utara','19','MEDAN','RUPBASAN KLAS I MEDAN','JL. PEMASYARAKATAN, TANJUNG GUSTA','2','20125','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('35','405713','2','Sumatera Utara','20','BINJAI','LAPAS KELAS II A BINJAI','JL. Gatot Subroto No. 72 Binjai','4','','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('36','405735','2','Sumatera Utara','21','TANJUNG BALAI','LAPAS KELAS II B TANJUNG BALAI ASAHAN','Jalan Mesjid, Pulau Simardan, Tanjung Balai','4','21366','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('37','405832','2','Sumatera Utara','22','SIDIKALANG','RUTAN KELAS II B SIDIKALANG','JL. RIMO BUNGA NO.40','1','22251','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('38','405911','2','Sumatera Utara','23','GUNUNG TUA','CABANG RUTAN GUNUNG TUA','JL. SISINGAMANGARAJA NO.32','3','22753','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('39','405766','2','Sumatera Utara','23','KABANJAHE','RUTAN KELAS II B KABANJAHE','JL. BHAYANGKARA','1','','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('40','405781','2','Sumatera Utara','24','KOTA PINANG','CABANG RUTAN KOTA PINANG','JL. PROF. HM. YAMIN, SH','3','21464','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('41','405772','2','Sumatera Utara','24','LABUHANBATU','CABANG RUTAN LABUHAN BILIK','Jl. Kesehatan No. 6 Labuhan Bilik, Kec. Panai Teng','3','21472','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('42','405760','2','Sumatera Utara','24','RANTAUPRAPAT','LAPAS KELAS II A RANTAU PRAPAT','JL. JUANG 45 NO. 209','4','21415','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('43','405817','2','Sumatera Utara','25','TEBING TINGGI','LAPAS KELAS II B TEBING TINGGI DELI','JL. PUSARA PEJUANG NO.3','4','20635','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('44','406441','2','Sumatera Selatan','25','TEBING TINGGI','CABANG RUTAN TEBING TINGGI','JL. TEBING BENTENG','3','','KANWIL SUMATERA SELATAN','system','2015-12-20 15:39:01'),
		('45','405879','2','Sumatera Utara','26','PULAU TELLO/NIAS','CABANG RUTAN PULAU TELO','JL. SIWA BADANO LAOWO','3','22881','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('46','405863','2','Sumatera Utara','26','GUNUNG SITOLI','LAPAS KELAS II B GUNUNG SITOLI','JL. DOLOK MARTIMBANG, DESA HILINA&amp;amp;amp;#39;','4','','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('47','405854','2','Sumatera Utara','26','SIBOLGA, TAPANULI TENGAH','LAPAS KELAS II A SIBOLGA','JL. R. SUPRAPTO NO. 9 DESA SIBULUAN I','4','','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('48','405848','2','Sumatera Utara','27','PEMATANG SIANTAR','LAPAS KELAS II A PEMATANG SIANTAR','jln. Asahan Batu VI No. 08 Pematang Siantar, Sumat','4','','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('49','652941','2','Sumatera Utara','27','PEMATANG SIANTAR','LAPAS NARKOTIKA KELAS II A PEMATANG SIANTAR','JL. ASAHAN KM. VII NO. 8','4','21151','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('50','405930','2','Sumatera Utara','28','TAPANULI UTARA','LAPAS KELAS II B SIBORONG-BORONG','JL. SILIWANGI NO. 14, KEC. SIBORONG-BORONG','4','22474','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('51','405905','2','Sumatera Utara','28','TARUTUNG','RUTAN KELAS II B TARUTUNG','JL. K. S. TUBUN NO.23','1','','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('52','405951','2','Sumatera Utara','29','SIPIROK','CABANG RUTAN SIPIROK','Jl. Simangambat No.228','3','','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('53','405885','2','Sumatera Utara','29','PADANG SIDEMPUAN','LAPAS KELAS II B PADANG SIDEMPUAN','JL. LINTAS SUMATRA KM.7','4','22733','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('54','653072','2','Sumatera Utara','30','SIBOLGA','BAPAS KLAS II SIBOLGA','JL. S.SISWOMIHARJO NO.24 SIBOLGA','5','','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('55','405967','2','Sumatera Utara','30','BARUS','CABANG RUTAN BARUS','JL. K.S TUBUN NO. 16','3','22564','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('56','405801','2','Sumatera Utara','31','PANGKALAN BRANDAN','RUTAN KELAS II B PANGKALAN BRANDAN','Jln. Stasiun No. 9','1','20857','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('57','405729','2','Sumatera Utara','31','LANGKAT','RUTAN KELAS II B TANJUNG PURA','Jalan Binjai No. 12 Kelurahan Pekan Tanjung Pura, ','1','20853','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('58','683661','2','Sumatera Utara','31','STABAT','LAPAS NARKOTIKA  KELAS III LANGKAT','Jln. Simpang Ladang Estate Desa Cempa Hinai Langka','4','','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('59','405741','2','Sumatera Utara','33','LABUHAN RUKU','LAPAS KELAS II A LABUHAN RUKU','JL. BESAR KAYU ARA NO. 33','4','21254','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('60','405823','2','Sumatera Utara','34','LUBUK PAKAM','LAPAS KELAS II B LUBUK PAKAM',' JL. JENDRAL SUDIRMAN NO.27 LUBUK PAKAM, 20512 Sum','4','','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('61','405704','2','Sumatera Utara','34','PANCUR BATU','CABANG RUTAN PANCUR BATU','JL. LETJEN JAMIN GINTING NO.56','3','20353','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('62','405982','2','Sumatera Utara','35','SIBUHUAN','CABANG RUTAN SIBUHUAN','JL. SULTAN HASANUDDIN NO.15','3','22763','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('63','405998','2','Sumatera Utara','35','NATAL','CABANG RUTAN NATAL','JL. MT. HARYONO NO.3','3','22987','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('64','405973','2','Sumatera Utara','35','PANYABUNGAN','LAPAS KELAS II B PANYABUNGAN','Jl.Syekh.H.Abdul Mutholib Lubis No.11 Sipapaga','4','','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('65','405891','2','Sumatera Utara','35','KOTA NOPAN','CABANG RUTAN KOTANOPAN','JL. SINDANGLAYA NO.2','3','22994','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('66','683725','2','Sumatera Utara','36','BALIGE','RUTAN KELAS II B HUMBANG HASUNDUTAN','NULL','1','','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('67','405942','2','Sumatera Utara','36','SAMOSIR','CABANG RUTAN PANGURURAN','JL. KEJAKSAAN NO. 18 PANGURURAN','3','22392','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('68','405936','2','Sumatera Utara','36','BALIGE','RUTAN KELAS II B BALIGE','JL. SILIWANGI NO. 17','1','','KANWIL SUMATERA UTARA','system','2015-12-20 15:39:01'),
		('69','406002','3','Sumatera Barat','37','PADANG','LAPAS KELAS II A PADANG','Jl Muara No. 42 Padang','4','','KANWIL SUMATERA BARAT','system','2015-12-20 15:39:01'),
		('70','652831','3','Sumatera Barat','37','PADANG LANSANO','LAPAS KELAS II B LUBUK BASUNG','Jl Raya lubuk basung - Pasaman KM 4 Padang Lansano','4','','KANWIL SUMATERA BARAT','system','2015-12-20 15:39:01'),
		('71','408686','3','Sumatera Barat','37','PADANG','BAPAS KLAS I PADANG','Jl Muara No.40 B Padang','5','','KANWIL SUMATERA BARAT','system','2015-12-20 15:39:01'),
		('72','632616','3','Sumatera Barat','37','PADANG','RUPBASAN KLAS I PADANG','Jl S Parman No 223 padang','2','','KANWIL SUMATERA BARAT','system','2015-12-20 15:39:01'),
		('73','683993','3','Sumatera Barat','37','PADANG','RUTAN KELAS II B PADANG','NULL','1','','KANWIL SUMATERA BARAT','system','2015-12-20 15:39:01'),
		('74','406121','3','Sumatera Barat','38','SAWAHLUNTO','RUTAN KELAS II B SAWAHLUNTO','Jalan Soekarno-Hatta No.9','1','','KANWIL SUMATERA BARAT','system','2015-12-20 15:39:01'),
		('75','683994','3','Sumatera Barat','38','SAWAHLUNTO','LAPAS NARKOTIKA KELAS III SAWAHLUNTO','NULL','4','','KANWIL SUMATERA BARAT','system','2015-12-20 15:39:01'),
		('76','406152','3','Sumatera Barat','39','BATUSANGKAR','RUTAN KELAS II B BATUSANGKAR','Jl Hamka No 24 Batusangkar','1','','KANWIL SUMATERA BARAT','system','2015-12-20 15:39:01'),
		('77','406137','3','Sumatera Barat','40','SOLOK','LAPAS KELAS II B SOLOK','Jl Kapten Bahar Hamid Kel. Laing Kota Solok','4','27325','KANWIL SUMATERA BARAT','system','2015-12-20 15:39:01'),
		('78','406018','3','Sumatera Barat','41','PARIAMAN','LAPAS KELAS II B PARIAMAN','Jl Syech Burhanuddin Karan Aur Pariaman','4','','KANWIL SUMATERA BARAT','system','2015-12-20 15:39:01'),
		('79','406049','3','Sumatera Barat','42','MUARA LABUH','CABANG RUTAN MUARA LABUH','Jl Sekolah No 02','3','','KANWIL SUMATERA BARAT','system','2015-12-20 15:39:01'),
		('80','406024','3','Sumatera Barat','42','PAINAN','RUTAN KELAS II B PAINAN','Jl H Ilyas Yacup','1','25611','KANWIL SUMATERA BARAT','system','2015-12-20 15:39:01'),
		('81','653086','3','Sumatera Barat','43','BUKIT TINGGI','BAPAS KLAS II BUKITTINGGI','Jl Raya Bukitinggi - Payakumbuh KM 8','5','26191','KANWIL SUMATERA BARAT','system','2015-12-20 15:39:01'),
		('82','406086','3','Sumatera Barat','43','MANINJAU','CABANG RUTAN MANINJAU','Jl Muara Pisang Maninjau','3','26471','KANWIL SUMATERA BARAT','system','2015-12-20 15:39:01'),
		('83','406055','3','Sumatera Barat','43','BUKITTINGGI','LAPAS KELAS II A BUKITTINGGI','Jl Raya Bukittinggi-Payakumbuh KM 8','4','26191','KANWIL SUMATERA BARAT','system','2015-12-20 15:39:01'),
		('84','406092','3','Sumatera Barat','44','LUBUK SIKAPING','RUTAN KELAS II B LUBUK SIKAPING','JL. A. YANI NO. 26','1','26313','KANWIL SUMATERA BARAT','system','2015-12-20 15:39:01'),
		('85','406112','3','Sumatera Barat','45','SULIKI','CABANG RUTAN SULIKI','Jalan Tan Malaka, Kecamatan Suliki, Kabupaten 50 k','3','26255','KANWIL SUMATERA BARAT','system','2015-12-20 15:39:01'),
		('86','406106','3','Sumatera Barat','45','PAYAKUMBUH','LAPAS KELAS II B PAYAKUMBUH','Jl Jendral Sudirman No 15 Payakumbuh','4','','KANWIL SUMATERA BARAT','system','2015-12-20 15:39:01'),
		('87','406080','3','Sumatera Barat','46','PADANG PANJANG','RUTAN KELAS II B PADANG PANJANG','Jl. Urip Sumoharjo No. 1','1','27121','KANWIL SUMATERA BARAT','system','2015-12-20 15:39:01'),
		('88','524232','3','Sumatera Barat','48','TANJUNG PATI','LEMBAGA PEMBINAAN KHUSUS ANAK KELAS II TANJUNG PAT','Jl Raya Negara KM 11 Tanjung Pati','4','26271','KANWIL SUMATERA BARAT','system','2015-12-20 15:39:01'),
		('89','406033','3','Sumatera Barat','49','ALAHAN PANJANG','CABANG RUTAN ALAHAN PANJANG','Jl Gajah Mada No.28 Alahan Panjang','3','','KANWIL SUMATERA BARAT','system','2015-12-20 15:39:01'),
		('90','406143','3','Sumatera Barat','50','MUARO SIJUNJUNG','LAPAS KELAS II B MUARA SIJUNJUNG','Jl Pengayoman','4','27511','KANWIL SUMATERA BARAT','system','2015-12-20 15:39:01'),
		('91','683995','3','Sumatera Barat','50','SUNGAIDAREH','LAPAS KELAS III DHARMASRAYA','NULL','4','','KANWIL SUMATERA BARAT','system','2015-12-20 15:39:01'),
		('92','406061','3','Sumatera Barat','51','TALU PASAMAN','CABANG RUTAN TALU','JL. A. YANI NO. 26','3','26313','KANWIL SUMATERA BARAT','system','2015-12-20 15:39:01'),
		('93','652890','3','Sumatera Barat','51','PASAMAN BARAT','LAPAS TERBUKA KELAS II B PASAMAN','Jorong Padang Tujuh, Nagari Pasaman, Kecamatan Pas','4','','KANWIL SUMATERA BARAT','system','2015-12-20 15:39:01'),
		('94','406168','4','Riau','52','PEKANBARU','BAPAS KLAS II PEKANBARU','JL.HR. SUBRANTAS KM 10.5 ','5','28294','KANWIL RIAU','system','2015-12-20 15:39:01'),
		('95','683732','4','Riau','52','PEKANBARU','RUTAN KELAS II B PEKANBARU','NULL','1','','KANWIL RIAU','system','2015-12-20 15:39:01'),
		('96','409151','4','Riau','52','PEKANBARU','LEMBAGA PEMBINAAN KHUSUS ANAK KELAS II PEKANBARU','JL. BINDANAK NO.01','4','28282','KANWIL RIAU','system','2015-12-20 15:39:01'),
		('97','406174','4','Riau','52','PEKANBARU','LAPAS KELAS II A PEKANBARU','JL. PEMASYARAKATAN NO. 19','4','28282','KANWIL RIAU','system','2015-12-20 15:39:01'),
		('98','683999','4','Riau','52','PEKANBARU','LAPAS TERBUKA KELAS III RUMBAI','Jl pemasyarakatan No. 001 Rumbai Bukit ','4','28264','KANWIL RIAU','system','2015-12-20 15:39:01'),
		('99','632602','4','Riau','52','PEKANBARU','RUPBASAN KLAS I PEKANBARU','JL. SIALANG BUNGKUK KULIM','2','28285','KANWIL RIAU','system','2015-12-20 15:39:01'),
		('100','406250','4','Riau','53','SELAT PANJANG','CABANG RUTAN SELAT PANJANG','JL. TANJUNG HARAPAN','3','28753','KANWIL RIAU','system','2015-12-20 15:39:01'),
		('101','406183','4','Riau','53','BENGKALIS','LAPAS KELAS II A BENGKALIS','JL. Pertanian No. 219 ','4','28751','KANWIL RIAU','system','2015-12-20 15:39:01'),
		('102','650194','4','Riau','53','BENGKALIS','RUPBASAN KLAS II BENGKALIS','JL. PEMASYARAKATAN NO. 86','2','29113','KANWIL RIAU','system','2015-12-20 15:39:01'),
		('103','406231','4','Riau','54','TELUK KUANTAN','CABANG RUTAN TELUK KUANTAN','JL. IMAM BONJOL NO. 34','3','29362','KANWIL RIAU','system','2015-12-20 15:39:01'),
		('104','406219','4','Riau','54','RENGAT','RUTAN KELAS II B RENGAT','JL. PEKAN HERA KM 4 PEMATANG REBA','1','29351','KANWIL RIAU','system','2015-12-20 15:39:01'),
		('105','650202','4','Riau','54','RENGAT','RUPBASAN KLAS II RENGAT','JL. A. YANI NO. 37 KEL. SEKIP HULU','2','29351','KANWIL RIAU','system','2015-12-20 15:39:01'),
		('106','406225','4','Riau','55','TEMBILAHAN','LAPAS KELAS II A TEMBILAHAN','JL. PROF. M. YAMIN, SH NO.3','4','28411','KANWIL RIAU','system','2015-12-20 15:39:01'),
		('107','408551','4','Kepulauan Riau','55','DOBO SINGKEP','CABANG RUTAN DABO SINGKEP','JL. PAHLAWAN','3','29171','KANWIL KEPULAUAN RIAU','system','2015-12-20 15:39:01'),
		('108','406256','4','Riau','56','BANGKINANG','LAPAS KELAS II B BANGKINANG','JL. TUANKU TAMBUSAI BUKIT CANDIKA','4','28412','KANWIL RIAU','system','2015-12-20 15:39:01'),
		('109','650216','4','Riau','56','BANGKINANG','RUPBASAN KLAS II BANGKINANG','JL. SULTAN SYARIF QASIM','2','','KANWIL RIAU','system','2015-12-20 15:39:01'),
		('110','406203','4','Riau','57','BAGAN SIAPI-API','CABANG RUTAN BAGAN SIAPI-API','JL. DR. PRATOMO NO. 224','3','28914','KANWIL RIAU','system','2015-12-20 15:39:01'),
		('111','408454','4','Riau','57','DUMAI','RUTAN KELAS II B DUMAI','JL. PEMASYARAKATAN NO. 1','1','28813','KANWIL RIAU','system','2015-12-20 15:39:01'),
		('112','406199','4','Riau','60','SRI INDRAPURA','RUTAN KELAS II B SIAK SRI INDRAPURA','JL. SULTAN SYARIF HASYIM, KAMPUNG DALAM','1','28771','KANWIL RIAU','system','2015-12-20 15:39:01'),
		('113','406262','4','Riau','61','PANGARAYAN','LAPAS KELAS II B PASIR PANGARAYAN','JL. PENGAYOMAN NO. 33','4','29342','KANWIL RIAU','system','2015-12-20 15:39:01'),
		('114','653093','4','Kepulauan Riau','98','TANJUNG PINANG','BAPAS KLAS II TANJUNG PINANG','JL. BAKAR BATU NO. 89','5','29113','KANWIL KEPULAUAN RIAU','system','2015-12-20 15:39:01'),
		('115','406271','4','Kepulauan Riau','98','TANJUNG PINANG','LAPAS KELAS II A TANJUNG PINANG','JL. DR. SAHARJO KM 18','4','29113','KANWIL KEPULAUAN RIAU','system','2015-12-20 15:39:01'),
		('116','650223','4','Kepulauan Riau','98','TANJUNG PINANG','RUPBASAN KLAS II TANJUNG PINANG','JL. Dr. SAHARDJO, SH. KM 18','2','21191','KANWIL KEPULAUAN RIAU','system','2015-12-20 15:39:01'),
		('117','667944','4','Kepulauan Riau','98','TANJUNGPINANG','RUTAN KELAS I TANJUNG PINANG','Jalan Pemasyarakatan No.08 Kota Tanjungpinang Prov','1','29111','KANWIL KEPULAUAN RIAU','system','2015-12-20 15:39:01'),
		('118','497877','4','Kepulauan Riau','98','TANJUNG PINANG','LAPAS NARKOTIKA  KELAS II A TANJUNG PINANG','Jalan Dr. Sahardjo, SH Kp. Banjar Km.18 Kijang - B','4','','KANWIL KEPULAUAN RIAU','system','2015-12-20 15:39:01'),
		('119','683998','4','Kepulauan Riau','99','BATAM','LEMBAGA PEMBINAAN KHUSUS ANAK KELAS II BATAM','JL SUDIRMAN NO I  BALAI BATAM','4','','KANWIL KEPULAUAN RIAU','system','2015-12-20 15:39:01'),
		('120','109154','4','Kepulauan Riau','99','BATAM','LAPAS KELAS II A BATAM','JL. TRANS BARELANG NO.1, TEMBESI, KOTA BATAM','4','29432','KANWIL KEPULAUAN RIAU','system','2015-12-20 15:39:01'),
		('121','497861','4','Kepulauan Riau','99','BATAM','RUTAN KELAS II A BATAM','Jl. Jenderal Sudirman No.03 Sei Baloi Batam','1','','KANWIL KEPULAUAN RIAU','system','2015-12-20 15:39:01'),
		('122','406287','4','Kepulauan Riau','100','TANJUNG BALAI KARIMUN','RUTAN KELAS II B TANJUNG BALAI KARIMUN','JL. PEMASYARAKATAN NO. 1, TELUK AIR','1','29161','KANWIL KEPULAUAN RIAU','system','2015-12-20 15:39:01'),
		('123','683678','5','Jambi','62','JAMBI','LAPAS NARKOTIKA  KELAS III MUARA SABAK','Jambi','4','','KANWIL JAMBI','system','2015-12-20 15:39:01'),
		('124','109117','5','Jambi','62','JAMBI','BAPAS KLAS II JAMBI','JL. JEND. BASUKI RACHMAT, KOTABARU','5','36128','KANWIL JAMBI','system','2015-12-20 15:39:01'),
		('125','649044','5','Jambi','62','JAMBI','RUPBASAN KLAS I JAMBI','LINGKAR SELATAN, KOTABARU','2','','KANWIL JAMBI','system','2015-12-20 15:39:01'),
		('126','406293','5','Jambi','62','JAMBI','LAPAS KELAS II A JAMBI','JL. KAPITEN PATIMURA KM.8 NO.10','4','','KANWIL JAMBI','system','2015-12-20 15:39:01'),
		('127','683572','5','Jambi','62','JAMBI','LAPAS KELAS III SAROLANGUN','JAMBI','4','','KANWIL JAMBI','system','2015-12-20 15:39:01'),
		('128','653112','5','Jambi','63','MUARA TEBO','BAPAS KLAS II MUARA BUNGO','KOMPLEK PERKANTORAN PEMDA TEBO KM.12','5','','KANWIL JAMBI','system','2015-12-20 15:39:01'),
		('129','406313','5','Jambi','63','BUNGO','LAPAS KELAS II B MUARA BUNGO','Jl. Jenderal Sudirman KM 2,5 arah Bangko Kel. Sei ','4','37214','KANWIL JAMBI','system','2015-12-20 15:39:01'),
		('130','406322','5','Jambi','63','MUARA TEBO','LAPAS KELAS II B MUARA TEBO','JL. LINTAS KM 2, MUARA TEBO-MUARA BUNGO','4','37271','KANWIL JAMBI','system','2015-12-20 15:39:01'),
		('131','406344','5','Jambi','64','KUALA TUNGKAL','LAPAS KELAS II B KUALA TUNGKAL','JL.RAYA TELUK NILAU KEL.BRAM ITAM KIRI KEC.BRAM IT','4','36513','KANWIL JAMBI','system','2015-12-20 15:39:01'),
		('132','406353','5','Jambi','65','SUNGAI PENUH','RUTAN KELAS II B SUNGAI PENUH','JL. JENDERAL SUDIRMAN NO.16','1','37113','KANWIL JAMBI','system','2015-12-20 15:39:01'),
		('133','406338','5','Jambi','66','BANGKO','LAPAS KELAS II B BANGKO','JALan lintas Sumatera Km. 3 Bangko','4','37313','KANWIL JAMBI','system','2015-12-20 15:39:01'),
		('134','626136','5','Jambi','67','MUARA BULIAN','LEMBAGA PEMBINAAN KHUSUS ANAK KELAS II MUARA BULIA','JL. NESS KM.11 SEI BULUH','4','36601','KANWIL JAMBI','system','2015-12-20 15:39:01'),
		('135','406307','5','Jambi','67','MUARA BULIAN','LAPAS KELAS II B MUARA BULIAN','jalan Sudirman KM 04 Muara Bulian','4','','KANWIL JAMBI','system','2015-12-20 15:39:01'),
		('136','683996','6','Sumatera Selatan','72','PALEMBANG','LAPAS NARKOTIKA KELAS III PALEMBANG','Jl. Tanjung Sari LK. III Rt. 029 Rw. 006 Kel. Suko','4','','KANWIL SUMATERA SELATAN','system','2015-12-20 15:39:01'),
		('137','406539','6','Sumatera Selatan','72','PALEMBANG','LEMBAGA PEMBINAAN KHUSUS ANAK KELAS I PALEMBANG','Jl. Inspektur Marzuki Km.4,5 Lorok Pakjo Palembang','4','30138','KANWIL SUMATERA SELATAN','system','2015-12-20 15:39:01'),
		('138','626115','6','Sumatera Selatan','72','PALEMBANG','RUPBASAN KLAS I PALEMBANG','JL. INSP. MARZUKI KM 4,5, PAKJO','2','','KANWIL SUMATERA SELATAN','system','2015-12-20 15:39:01'),
		('139','497733','6','Sumatera Selatan','72','PALEMBANG','LAPAS WANITA KELAS II A PALEMBANG','JL. MERDEKA NO. 12 PALEMBANG','4','','KANWIL SUMATERA SELATAN','system','2015-12-20 15:39:01'),
		('140','406369','6','Sumatera Selatan','72','PALEMBANG','BAPAS KLAS I PALEMBANG','JL. KAPT.A. RIVAI NO. 90','5','30135','KANWIL SUMATERA SELATAN','system','2015-12-20 15:39:01'),
		('141','683589','6','Sumatera Selatan','72','PANGKALAN BALAI','LAPAS KELAS III BANYUASIN','Jalan Lingkar Mulia Agung Kab.Banyuasin','4','','KANWIL SUMATERA SELATAN','system','2015-12-20 15:39:01'),
		('142','406375','6','Sumatera Selatan','72','PALEMBANG','LAPAS KELAS I PALEMBANG','Jl. Taqwa mata merah Banyuasin','4','','KANWIL SUMATERA SELATAN','system','2015-12-20 15:39:01'),
		('143','109118','6','Sumatera Selatan','72','PALEMBANG','RUTAN KELAS I PALEMBANG','Jl.Inspektur Marzuki Km.4,5 Pakjo Palembang','1','','KANWIL SUMATERA SELATAN','system','2015-12-20 15:39:01'),
		('144','683593','6','Sumatera Selatan','73','KAYU AGUNG','LAPAS KELAS III KAYU AGUNG','NULL','4','','KANWIL SUMATERA SELATAN','system','2015-12-20 15:39:01'),
		('145','406381','6','Sumatera Selatan','73','TANJUNG RAJA (OGAN ILIR)','LAPAS KELAS II A TANJUNG RAJA','JL. SULTAN MAHMUD BADARUDIN II','4','30661','KANWIL SUMATERA SELATAN','system','2015-12-20 15:39:01'),
		('146','406472','6','Sumatera Selatan','74','BATURAJA','RUTAN KELAS II B BATURAJA','JL. IMAM BONJOL SARANG ELANG','1','32112','KANWIL SUMATERA SELATAN','system','2015-12-20 15:39:01'),
		('147','653271','6','Sumatera Selatan','74','BATURAJA','RUPBASAN KLAS II BATURAJA','JL. HOS COKROAMINOTO NO. 0005','2','32100','KANWIL SUMATERA SELATAN','system','2015-12-20 15:39:01'),
		('148','652958','6','Sumatera Selatan','75','KAB. MUSI RAWAS','LAPAS NARKOTIKA KELAS II A LUBUK LINGGAU','JL. LINTAS SUMATERA KM. 19, MUARA BELITI','4','','KANWIL SUMATERA SELATAN','system','2015-12-20 15:39:01'),
		('149','406463','6','Sumatera Selatan','75','LUBUK LINGGAU','CABANG RUTAN SOROLANGUN RAWAS','JL. JAMBI, SUROLANGUN','3','','KANWIL SUMATERA SELATAN','system','2015-12-20 15:39:01'),
		('150','406457','6','Sumatera Selatan','75','LUBUKLINGGAU','LAPAS KELAS II A LUBUK LINGGAU','JL. DEPATI SAID','4','31616','KANWIL SUMATERA SELATAN','system','2015-12-20 15:39:01'),
		('151','406402','6','Sumatera Selatan','76','LAHAT','LAPAS KELAS II A LAHAT','JL.RE. MARTADINATA PASAR LAMA','4','31413','KANWIL SUMATERA SELATAN','system','2015-12-20 15:39:01'),
		('152','653108','6','Sumatera Selatan','76','LAHAT','BAPAS KLAS II LAHAT','JL. BHAYANGKARA BANDAR JAYA','5','31414','KANWIL SUMATERA SELATAN','system','2015-12-20 15:39:01'),
		('153','406420','6','Sumatera Selatan','77','MUARA ENIM','LAPAS KELAS II B MUARA ENIM','JLN.HUTAN TANAMAN INDUSTRI MUARA LAWAI, MUARA ENIM','4','31315','KANWIL SUMATERA SELATAN','system','2015-12-20 15:39:01'),
		('154','406401','6','Sumatera Selatan','78','SEKAYU','LAPAS KELAS II B SEKAYU','Jl. Inpres Penjara Lk. III Kel. Serasan Jaya Kec. ','4','30711','KANWIL SUMATERA SELATAN','system','2015-12-20 15:39:01'),
		('155','406488','6','Sumatera Selatan','255','MARTAPURA','CABANG RUTAN MARTAPURA','JL. MERDEKA NO. 3','3','','KANWIL SUMATERA SELATAN','system','2015-12-20 15:39:01'),
		('156','406432','6','Sumatera Selatan','336','PAGAR ALAM','CABANG RUTAN PAGAR ALAM','Jl. Kopral Cikwan Pagar Alam Utara ','3','31511','KANWIL SUMATERA SELATAN','system','2015-12-20 15:39:01'),
		('157','406426','6','Sumatera Selatan','337','MUARA DUA','CABANG RUTAN MUARA DUA','JL. WEDANA PANGKOE N0.796','3','32171','KANWIL SUMATERA SELATAN','system','2015-12-20 15:39:01'),
		('158','406494','6','Sumatera Selatan','337','PRABUMULIH','RUTAN KELAS II B PRABUMULIH','JL. RA. Kartini No.30 Kel. Sukajadi Kec. Prabumuli','1','31111','KANWIL SUMATERA SELATAN','system','2015-12-20 15:39:01'),
		('159','407902','7','Bengkulu','80','BENGKULU','LAPAS KELAS II A BENGKULU','JL. BRIGJEN BERLIAN NO.556','4','38113','KANWIL BENGKULU','system','2015-12-20 15:39:01'),
		('160','109151','7','Bengkulu','80','BENGKULU','BAPAS KLAS II BENGKULU','JL. KUALA LEMPUING','5','38224','KANWIL BENGKULU','system','2015-12-20 15:39:01'),
		('161','683997','7','Bengkulu','80','BENGKULU','RUTAN KELAS II B BENGKULU','NULL','1','','KANWIL BENGKULU','system','2015-12-20 15:39:01'),
		('162','632768','7','Bengkulu','80','BENGKULU','RUPBASAN KLAS I BENGKULU','Jl. Pelabuhan Lama No. IA, Kel Malabero Bengkulu','2','','KANWIL BENGKULU','system','2015-12-20 15:39:01'),
		('163','407927','7','Bengkulu','81','CURUP','LAPAS KELAS II A CURUP','JL. NUSIRWAN NO.38, PO BOX 127','4','39111','KANWIL BENGKULU','system','2015-12-20 15:39:01'),
		('164','407911','7','Bengkulu','82','MANNA','RUTAN KELAS II B MANNA','JL. Pangeran Duayu ','1','38517','KANWIL BENGKULU','system','2015-12-20 15:39:01'),
		('165','109150','7','Bengkulu','83','ARGA MAKMUR','LAPAS KELAS II B ARGAMAKMUR','JL. DR. AK GANI NO.121, GUNUNG AGUNG','4','38613','KANWIL BENGKULU','system','2015-12-20 15:39:01'),
		('166','653421','7','Bengkulu','83','BENGKULU UTARA','RUPBASAN KLAS II ARGA MAKMUR','Jl. Ir. Soekarno Desa Gunung Agung, Kecamatan kota','2','','KANWIL BENGKULU','system','2015-12-20 15:39:01'),
		('167','408536','8','Bandar Lampung','79','KALIANDA','LAPAS KELAS II A KALIANDA','JL. TRANS SUMATERA I KM.5','4','','KANWIL LAMPUNG','system','2015-12-20 15:39:01'),
		('168','683704','8','Bandar Lampung','86','BANDAR LAMPUNG','LEMBAGA PEMBINAAN KHUSUS ANAK KELAS II BANDAR LAMP','Jl. Ikatan Saudara No. 39 Masgar, Pesawaran','4','','KANWIL LAMPUNG','system','2015-12-20 15:39:01'),
		('169','652962','8','Bandar Lampung','86','BANDAR LAMPUNG','LAPAS NARKOTIKA KELAS II A BANDAR LAMPUNG','Jl. Ryacudu Way Hui Sukarame Bandar Lampung','4','','KANWIL LAMPUNG','system','2015-12-20 15:39:01'),
		('170','497764','8','Bandar Lampung','86','BANDAR LAMPUNG','LAPAS WANITA KELAS II A BANDAR LAMPUNG','Jl. Ryacudu Way Hui Bandar Lampung','4','','KANWIL LAMPUNG','system','2015-12-20 15:39:01'),
		('171','663073','8','Bandar Lampung','86','BANDAR LAMPUNG','RUTAN KELAS I BANDAR LAMPUNG','Jl. Ryacudu Way Hui Bandar Lampung','1','','KANWIL LAMPUNG','system','2015-12-20 15:39:01'),
		('172','632623','8','Bandar Lampung','86','BANDAR LAMPUNG','RUPBASAN KLAS I LAMPUNG','JL. RYACUDU WAY HUI','2','','KANWIL LAMPUNG','system','2015-12-20 15:39:01'),
		('173','497758','8','Bandar Lampung','86','WAY KANAN','LAPAS KELAS II B WAYKANAN','Jl. Lintas Sumatera, Way Kanan, Kab. Way Kanan','4','','KANWIL LAMPUNG','system','2015-12-20 15:39:01'),
		('174','406545','8','Bandar Lampung','86','BANDAR LAMPUNG','LAPAS KELAS I BANDAR LAMPUNG','Jl. Pramuka No.12 Rajabasa Bandar Lampung','4','','KANWIL LAMPUNG','system','2015-12-20 15:39:01'),
		('175','109137','8','Bandar Lampung','86','BANDAR LAMPUNG','BAPAS KLAS II BANDAR LAMPUNG','JL. MR. MOCHAMAD ROEM NO. 30, TELUK BETUNG','5','35215','KANWIL LAMPUNG','system','2015-12-20 15:39:01'),
		('176','653260','8','Bandar Lampung','87','METRO','RUPBASAN KLAS II METRO','JL. JENDERAL A. YANI NO. 180','2','','KANWIL LAMPUNG','system','2015-12-20 15:39:01'),
		('177','653129','8','Bandar Lampung','87','METRO','BAPAS KLAS II METRO','JL. SUTRISNO','5','34111','KANWIL LAMPUNG','system','2015-12-20 15:39:01'),
		('178','406282','8','Bandar Lampung','87','METRO','LAPAS KELAS II A METRO','JL. JEND. A. YANI NO. 223','4','34100','KANWIL LAMPUNG','system','2015-12-20 15:39:01'),
		('179','406551','8','Bandar Lampung','88','LAMPUNG UTARA','LAPAS ANAK KELAS II A KOTABUMI','JL. PEMASYARAKATAN NO.215, KOTABUMI','4','34511','KANWIL LAMPUNG','system','2015-12-20 15:39:01'),
		('180','653264','8','Bandar Lampung','88','KOTABUMI','RUPBASAN KLAS II KOTABUMI','jl. Tjoekoel Soebroto Kel. Kelapa Tujuh','2','34511','KANWIL LAMPUNG','system','2015-12-20 15:39:01'),
		('181','497742','8','Bandar Lampung','88','KOTABUMI','RUTAN KELAS II B KOTABUMI','Jl. Tjoekoel Soebroto Kelapa Tujuh, Kotabumi','1','34513','KANWIL LAMPUNG','system','2015-12-20 15:39:01'),
		('182','683390','8','Bandar Lampung','89','KOTA AGUNG','RUTAN KELAS II B KOTA AGUNG','NULL','1','','KANWIL LAMPUNG','system','2015-12-20 15:39:01'),
		('183','408530','8','Bandar Lampung','89','KOTA AGUNG','LAPAS KELAS II B KOTA AGUNG','Jl. Pemasyarakatan No.02 Kec. Kota Agung Barat','4','35384','KANWIL LAMPUNG','system','2015-12-20 15:39:01'),
		('184','406591','8','Bandar Lampung','90','KRUI','RUTAN KELAS II B KRUI','Jl. Cempaka No.17 Krui,Kab.Lampung Barat','1','34874','KANWIL LAMPUNG','system','2015-12-20 15:39:01'),
		('185','406570','8','Bandar Lampung','91','MENGGALA','RUTAN KELAS II B MENGGALA','Jl. Lintas Asia KM.01 Bawang Latak Menggala Tulang','1','','KANWIL LAMPUNG','system','2015-12-20 15:39:01'),
		('186','683313','8','Bandar Lampung','92','GUNUNG SUGIH','LAPAS KELAS III GUNUNG SUGIH','Jl.Raya Kota Gajah, Kec. Gunung Sugih Kab. Lampung','4','34161','KANWIL LAMPUNG','system','2015-12-20 15:39:01'),
		('187','406576','8','Bandar Lampung','93','SUKADANA','RUTAN KELAS II B SUKADANA','Jl. Jend. Sudirman No. 21 Sukadana','1','','KANWIL LAMPUNG','system','2015-12-20 15:39:01'),
		('188','683682','9','Bangka Belitung','95','PANGKAL PINANG','LAPAS NARKOTIKA KELAS III PANGKAL PINANG','PANGKAL PINANG','4','','KANWIL BANGKA BELITUNG','system','2015-12-20 15:39:01'),
		('189','663090','9','Bangka Belitung','95','PANGKAL PINANG','RUPBASAN KLAS II PANGKAL PINANG','JL. AHMAD YANI NO. 21','2','33121','KANWIL BANGKA BELITUNG','system','2015-12-20 15:39:01'),
		('190','406508','9','Bangka Belitung','95','PANGKAL PINANG','LAPAS KELAS II A PANGKAL PINANG','JL. TUATUNU','4','33124','KANWIL BANGKA BELITUNG','system','2015-12-20 15:39:01'),
		('191','653222','9','Bangka Belitung','95','PANGKAL PINANG','BAPAS KLAS II PANGKAL PINANG','JL. ICAN SALEH NO.77, PANGKAL PINANG','5','33124','KANWIL BANGKA BELITUNG','system','2015-12-20 15:39:01'),
		('192','406523','9','Bangka Belitung','96','MUNTOK','CABANG RUTAN MUNTOK','JL. KAPTEN P. TENDEAN NO.1','3','','KANWIL BANGKA BELITUNG','system','2015-12-20 15:39:01'),
		('193','568712','9','Bangka Belitung','96','BANGKA','LAPAS KELAS II B SUNGAI LIAT','JL. A. YANI DUA JALUR BUKIT SEMUT, SUNGAILIAT','4','','KANWIL BANGKA BELITUNG','system','2015-12-20 15:39:01'),
		('194','406514','9','Bangka Belitung','97','TANJUNG PANDAN','LAPAS KELAS II B TANJUNG PANDAN','JL. PENGAYOMAN DESA SERUCUK, BADAU','4','33411','KANWIL BANGKA BELITUNG','system','2015-12-20 15:39:01'),
		('195','632531','11','DKI Jakarta','101','JAKARTA PUSAT','RUPBASAN KLAS I JAKARTA PUSAT','Jl. LP. Cipinang No. 2 Cipinang Jakarta Timur','2','13410','KANWIL DKI JAKARTA','system','2015-12-20 15:39:01'),
		('196','404243','11','DKI Jakarta','101','JAKARTA PUSAT','BAPAS KLAS I JAKARTA PUSAT','JL. PERCETAKAN NEGARA VIII NO. 54, SALEMBA','5','10570','KANWIL DKI JAKARTA','system','2015-12-20 15:39:01'),
		('197','497651','11','DKI Jakarta','101','JAKARTA PUSAT','LAPAS KELAS II A SALEMBA','JL. PERCETAKAN NEGARA VIII NO. 88 A, SALEMBA','4','','KANWIL DKI JAKARTA','system','2015-12-20 15:39:01'),
		('198','408692','11','DKI Jakarta','101','JAKARTA PUSAT','RUTAN KELAS I JAKARTA PUSAT','Jl. Percetakan Negara No. 88 Rawasari, Cempaka Put','1','','KANWIL DKI JAKARTA','system','2015-12-20 15:39:01'),
		('199','404259','11','DKI Jakarta','102','JAKARTA BARAT','BAPAS KLAS I JAKARTA BARAT','JL. PALMERAH BARAT V NO.12','5','11480','KANWIL DKI JAKARTA','system','2015-12-20 15:39:01'),
		('200','632569','11','DKI Jakarta','103','JAKARTA TIMUR','RUPBASAN KLAS I JAKARTA TIMUR','Jl.cipinang raya No.37B Jakarta Timur','2','','KANWIL DKI JAKARTA','system','2015-12-20 15:39:01'),
		('201','652979','11','DKI Jakarta','103','JAKARTA TIMUR','LAPAS NARKOTIKA KELAS II A CIPINANG','Jl.Raya Bekasi Timur 170A ','4','13410','KANWIL DKI JAKARTA','system','2015-12-20 15:39:01'),
		('202','497645','11','DKI Jakarta','103','JAKARTA TIMUR','RUTAN KELAS I CIPINANG','Jl. Raya Bekasi timur no 22-23 ','1','','KANWIL DKI JAKARTA','system','2015-12-20 15:39:01'),
		('203','404296','11','DKI Jakarta','103','JAKARTA TIMUR','RUTAN KELAS II A JAKARTA TIMUR','Jl Pahlawan Revolusi Pondok Bambu','1','13430','KANWIL DKI JAKARTA','system','2015-12-20 15:39:01'),
		('204','404271','11','DKI Jakarta','103','JAKARTA TIMUR','LAPAS KELAS I CIPINANG','JL. RAYA BEKASI TIMUR NO. 170','4','13410','KANWIL DKI JAKARTA','system','2015-12-20 15:39:01'),
		('205','404265','11','DKI Jakarta','103','JAKARTA TIMUR','BAPAS KLAS I JAKARTA TIMUR/JAKARTA UTARA','JL. PEMBINA I NO.2, CIPINANG MUARA','5','13420','KANWIL DKI JAKARTA','system','2015-12-20 15:39:01'),
		('206','632552','11','DKI Jakarta','104','JAKARTA SELATAN','RUPBASAN KLAS I JAKARTA SELATAN','JL. AMPERA RAYA NO. 6A','2','','KANWIL DKI JAKARTA','system','2015-12-20 15:39:01'),
		('207','652894','11','DKI Jakarta','104','JAKARTA SELATAN','LAPAS TERBUKA KELAS II B  JAKARTA','JL. GANDUL CINERE','4','','KANWIL DKI JAKARTA','system','2015-12-20 15:39:01'),
		('208','559879','11','DKI Jakarta','104','JAKARTA SELATAN','BAPAS KLAS I JAKARTA SELATAN','JL. MOCH. KAHFI II NO. 42A, JAGAKARSA','5','12620','KANWIL DKI JAKARTA','system','2015-12-20 15:39:01'),
		('209','632548','11','DKI Jakarta','105','JAKARTA UTARA','RUPBASAN KLAS I JAKARTA UTARA','JL. SUNGAI LANDAK NO. 7 CILINCING','2','','KANWIL DKI JAKARTA','system','2015-12-20 15:39:01'),
		('210','626072','12','Jawa Barat','106','BANDUNG','RUPBASAN KLAS I BANDUNG','JL. ARCAMANIK NO.1','2','40293','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('211','526801','12','Jawa Barat','106','BANDUNG','RUTAN KELAS I BANDUNG','JL. JAKARTA NO.29','1','40272','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('212','683711','12','Jawa Barat','106','BANDUNG','LEMBAGA PEMBINAAN KHUSUS ANAK KELAS II BANDUNG','Jl.Pacuan Kuda No.3a Arcamanik Bandung','4','40293','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('213','404378','12','Jawa Barat','106','BANDUNG','LAPAS KELAS I SUKAMISKIN','JL. A. H. NASUTION NO. 114','4','40293','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('214','404322','12','Jawa Barat','106','BANDUNG','LAPAS KELAS II A BANCEUY BANDUNG','JL. SUKARNO HATTA NO. 187A','4','40235','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('215','404316','12','Jawa Barat','106','BANDUNG','BAPAS KLAS I BANDUNG','JL. IBRAHIM ADJIE NO. 431','5','40284','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('216','652983','12','Jawa Barat','106','BANDUNG','LAPAS NARKOTIKA  KELAS II A BANDUNG','Jl.Rancamanuk Kelurahan Warga Kecamatan Baleendah ','4','','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('217','497682','12','Jawa Barat','106','BANDUNG','LAPAS WANITA KELAS II A BANDUNG','NULL','4','','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('218','404331','12','Jawa Barat','107','SUMEDANG','LAPAS KELAS II B SUMEDANG','Jl.Prabu Geusan Ulun No.40 ,Sumedang','4','45311','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('219','404362','12','Jawa Barat','108','TASIKMALAYA','LAPAS KELAS II B TASIKMALAYA','Jl. Oto Iskandardinata No. 1 Tasikmalaya Jawa Bara','4','','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('220','683394','12','Jawa Barat','109','GARUT','RUTAN KELAS II B GARUT','NULL','1','','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('221','404347','12','Jawa Barat','109','GARUT','LAPAS KELAS II B GARUT','JL. RD DEWI SARTIKA NO.2','4','44110','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('222','497670','12','Jawa Barat','109','GARUT','BAPAS KLAS II GARUT','NULL','5','','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('223','683622','12','Jawa Barat','110','BANJAR','LAPAS KELAS III BANJAR','Jalan Pelita','4','46311','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('224','404353','12','Jawa Barat','110','CIAMIS','LAPAS KELAS II B CIAMIS','Jl. IR. H. Juanda No. 146 Ciamis','4','','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('225','404501','12','Jawa Barat','111','PURWAKARTA','LAPAS KELAS II B PURWAKARTA','JL. DR. KUSUMA ATMADJA NO.14','4','41114','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('226','107950','12','Jawa Barat','112','BEKASI','LAPAS KELAS II A BEKASI','JL. PAHLAWAN NO.1 BULAKKAPAL BEKASI. 17111 JAWA BA','4','17111','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('227','683615','12','Jawa Barat','112','KAB. BEKASI','LAPAS KELAS III BEKASI','Jl. Cilampayan Desa Pasirtanjung Kecamatan Cikaran','4','17530','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('228','109104','12','Jawa Barat','113','KARAWANG','LAPAS KELAS II A KARAWANG','JL. SUROTOKUNTO KM.6','4','41371','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('229','404517','12','Jawa Barat','114','SUBANG','LAPAS KELAS II A SUBANG','JL. PALABUAN NO.3','4','41251','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('230','683601','12','Jawa Barat','115','BOGOR','LAPAS KELAS III GUNUNG SINDUR','JL.PENGAYOMAN KOMPLEK KEMENTERIAN HUKUM DAN HAM RI','4','16340','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('231','404472','12','Jawa Barat','115','BOGOR','LAPAS KELAS II A BOGOR','Jl. PALEDANG No. 2','4','','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('232','404466','12','Jawa Barat','115','BOGOR','BAPAS KLAS II BOGOR','JL. DARUL QURâ€™AN NO.3, LOJI','5','16117','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('233','683746','12','Jawa Barat','115','BOGOR','RUTAN KELAS II B GUNUNG SINDUR','Jl. Pengayoman Komplek Kementerian Hukum dan HAM R','1','','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('234','404481','12','Jawa Barat','116','SUKABUMI','LAPAS KELAS II B SUKABUMI','Jl. Lettu Bakrie No. 17','4','','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('235','683327','12','Jawa Barat','116','SUKABUMI','LAPAS KELAS III WARUNGKIARA','JL PELABUHAN RATU KM 30 (PILAR) WARUNG KIARA KAB. ','4','43162','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('236','404497','12','Jawa Barat','117','CIANJUR','LAPAS KELAS II B CIANJUR','JL. ARIA CIKONDANG NO. 75','4','43213','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('237','653285','12','Jawa Barat','118','CIREBON','RUPBASAN KLAS I CIREBON','JL. TERATAI NO. 198 TUPAREV','2','45153','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('238','404429','12','Jawa Barat','118','CIREBON','RUTAN KELAS I CIREBON','JL. BENTENG NO.1','1','45112','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('239','404404','12','Jawa Barat','118','CIREBON','LAPAS KELAS I CIREBON','JL. KESAMBI NO.38','4','45134','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('240','404393','12','Jawa Barat','118','CIREBON','BAPAS KLAS II CIREBON','JL. DR. WAHIDIN SUDIROHUSODO NO. 54','5','45153','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('241','649040','12','Jawa Barat','118','CIREBON','LAPAS NARKOTIKA KELAS II A CIREBON','Jl. Wijayakusuma, Ds Gintung Tengah, Kec. Ciwaring','4','','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('242','653292','12','Jawa Barat','119','INDRAMAYU','RUPBASAN KLAS II INDRAMAYU','JL.TERUSAN SINDANG KM.3 ','2','','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('243','404460','12','Jawa Barat','119','INDRAMAYU','LAPAS KELAS II B INDRAMAYU','Jl.Gatot Subtroto No. 04 Indramayu','4','','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('244','404441','12','Jawa Barat','120','MAJALENGKA','LAPAS KELAS II B MAJALENGKA','JL. KH. ABDUL HALIM NO. 254','4','45411','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('245','404435','12','Jawa Barat','121','KUNINGAN','LAPAS KELAS II A KUNINGAN','Jl. Siliwangi No. 2 ','4','','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('246','684000','12','Jawa Barat','125','DEPOK','RUTAN KELAS II B DEPOK','NULL','1','','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('247','497676','12','Jawa Barat','126','CIBINONG','LAPAS KELAS II A CIBINONG','CIBINONG','4','','KANWIL JAWA BARAT','system','2015-12-20 15:39:01'),
		('248','404642','13','Jawa Tengah','127','SEMARANG','LAPAS KELAS I SEMARANG','JL. RAYA SEMARANG-BOJA KM.4, KEL. WATES','4','50188','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('249','626089','13','Jawa Tengah','127','SEMARANG','RUPBASAN KLAS I SEMARANG','JL. DR.CIPTO NO.62 SEMARANG','2','','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('250','404701','13','Jawa Tengah','127','SEMARANG','LAPAS KELAS II A AMBARAWA','JL. BETENG, KEL. LODOYONG, KEC. AMBARAWA','4','50601','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('251','405037','13','Jawa Tengah','127','SEMARANG','LAPAS PEMUDA KELAS II B PLANTUNGAN','JL. PLANTUNGAN, KENDAL','4','51362','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('252','404718','13','Jawa Tengah','127','SEMARANG','LAPAS WANITA KELAS II A SEMARANG','JL. MGR. SOGIYOPRANOTO NO.59','4','50188','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('253','404636','13','Jawa Tengah','127','SEMARANG','BAPAS KLAS I SEMARANG','JL. SILIWANGI NO. 508, KRAPYAK','5','50146','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('254','497710','13','Jawa Tengah','128','SLAWI','LAPAS KELAS II B SLAWI','Jl. RAYA TEGAL ANDONG KECAMATAN LEBAKSIU KABUPATEN','4','','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('255','404760','13','Jawa Tengah','128','TEGAL','LAPAS KELAS II B TEGAL','JL. YOS SUDARSO NO. 2','4','52111','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('256','404733','13','Jawa Tengah','129','PEKALONGAN','LAPAS KELAS II A PEKALONGAN','JL. WR.SUPRATMAN NO.106 PEKALONGAN PROVINSI JAWA T','4','','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('257','109110','13','Jawa Tengah','129','PEKALONGAN','RUTAN KELAS II A PEKALONGAN','JL. RAJAWALI NO. 1','1','51114','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('258','404724','13','Jawa Tengah','129','PEKALONGAN','BAPAS KLAS II  PEKALONGAN','JL. DARMA BAKTI NO. 133','5','51111','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('259','653328','13','Jawa Tengah','129','PEKALONGAN','RUPBASAN KLAS I PEKALONGAN','JL. TENTARA PELAJAR NO. 13','2','','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('260','404883','13','Jawa Tengah','130','KUDUS','RUTAN KELAS II B KUDUS','Jalan Sunan Kudus No. 70 ','1','59313','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('261','404842','13','Jawa Tengah','131','PATI','BAPAS KLAS II PATI','JL. SUDIRMAN KM.3','5','59163','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('262','404851','13','Jawa Tengah','131','PATI','LAPAS KELAS II B PATI','JL. AKBP. AGIL KUSUMADYA NO. 19','4','59101','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('263','404780','13','Jawa Tengah','132','BREBES','LAPAS KELAS II B BREBES','JL. SLAMET NO.1','4','52212','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('264','404755','13','Jawa Tengah','133','PEMALANG','RUTAN KELAS II B PEMALANG','JL. MOCHTAR NO. 3','1','52312','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('265','404682','13','Jawa Tengah','134','KENDAL','LAPAS KELAS II A KENDAL','JL. ALUN-ALUN NO.1','4','51313','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('266','652902','13','Jawa Tengah','134','KENDAL','LAPAS TERBUKA KELAS II B KENDAL','JL. RAYA BLENDER, KENDAL KM.10','4','51351','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('267','404697','13','Jawa Tengah','135','DEMAK','RUTAN KELAS II B DEMAK','Jl. Glagahwangi No. 92 Demak','1','59511','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('268','404667','13','Jawa Tengah','136','GROBOGAN','RUTAN KELAS II B PURWODADI','JL. R.SOEPRAPTO NO.54 PURWODADI, GROBOGAN','1','58111','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('269','404673','13','Jawa Tengah','137','SALATIGA','RUTAN KELAS II B SALATIGA','JL. YOS SUDARSO NO. 2','1','','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('270','404874','13','Jawa Tengah','139','JEPARA','RUTAN KELAS II B JEPARA','JL. A. YANI NO. 4','1','59415','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('271','404899','13','Jawa Tengah','140','BLORA','RUTAN KELAS II B BLORA','JL. ABU UMAR NO. 9','1','58212','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('272','404868','13','Jawa Tengah','141','REMBANG','RUTAN KELAS II B REMBANG','JL. P. DIPONEGORO NO. 100','1','59211','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('273','497691','13','Jawa Tengah','142','BATANG','RUTAN KELAS II B BATANG','JL. RAYA BATANG KM 4,1','1','','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('274','408655','13','Jawa Tengah','143','KUTOARJO','LEMBAGA PEMBINAAN KHUSUS ANAK KELAS I KUTOARJO','JL. P. DIPONEGORO NO. 36A','4','54212','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('275','404821','13','Jawa Tengah','143','PURWOREJO','RUTAN KELAS II B PURWOREJO','JL. MAYJEN SUTOYO NO. 61','1','54113','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('276','404792','13','Jawa Tengah','144','MAGELANG','LAPAS KELAS II A MAGELANG','JL. SUTOPO NO.2','4','56121','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('277','404786','13','Jawa Tengah','144','MAGELANG','BAPAS KLAS II MAGELANG','JL. PURWOREJO KM.4','5','56101','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('278','404837','13','Jawa Tengah','145','KEBUMEN','RUTAN KELAS II B KEBUMEN','JL. PAHLAWAN NO. 163','1','54311','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('279','404806','13','Jawa Tengah','146','TEMANGGUNG','RUTAN KELAS II B TEMANGGUNG','JL. BRIGJEN KATAMSO NO. 1','1','56213','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('280','404812','13','Jawa Tengah','147','WONOSOBO','RUTAN KELAS II B WONOSOBO','JL. PRAMUKA NO. 1','1','56311','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('281','404919','13','Jawa Tengah','148','SURAKARTA','RUTAN KELAS I SURAKARTA','JL. SLAMET RIYADI NO. 18','1','57111','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('282','404903','13','Jawa Tengah','148','SURAKARTA','BAPAS KLAS II SURAKARTA','JL. RM. SAID NO. 259','5','57139','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('283','653310','13','Jawa Tengah','148','SURAKARTA','RUPBASAN KLAS I SURAKARTA','JL. IR. SUTAMI NO.7','2','67126','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('284','653332','13','Jawa Tengah','149','SRAGEN','RUPBASAN KLAS II SRAGEN','JL. RAYA SUKAWATI NO. 317','2','','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('285','404925','13','Jawa Tengah','149','SRAGEN','LAPAS KELAS II A SRAGEN','JL. RAYA SUKOWATI NO.1','4','57214','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('286','652351','13','Jawa Tengah','150','WONOGIRI','RUPBASAN KLAS II  WONOGIRI','JL. Ir SUTAMI II WONOGIRI','2','57612','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('287','404956','13','Jawa Tengah','150','WONOGIRI','RUTAN KELAS II B WONOGIRI','JL. JEND. SUDIRMAN NO.193.B','1','57614','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('288','404931','13','Jawa Tengah','153','BOYOLALI','RUTAN KELAS II B BOYOLALI','JL. MERBABU NO. 19','1','57311','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('289','404950','13','Jawa Tengah','154','KLATEN','LAPAS KELAS II B KLATEN','JL. PEMUDA No.206 KLATEN, PROVINSI JAWA TENGAH','4','','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('290','404971','13','Jawa Tengah','155','PURWOKERTO','LAPAS KELAS II A PURWOKERTO','JL. JEND SUDIRMAN NO. 134','4','53115','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('291','404962','13','Jawa Tengah','155','PURWOKERTO','BAPAS KLAS II PURWOKERTO','JL. PASUKAN PELAJAR IMAM No.04 ','5','','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('292','653307','13','Jawa Tengah','155','PURWOKERTO','RUPBASAN KLAS II PURWOKERTO','JL. JENDERAL SOEDIRMAN NO 61 A PURWOKERTO','2','','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('293','109107','13','Jawa Tengah','156','CILACAP','LAPAS KELAS I BATU NUSAKAMBANGAN','Candi-Nusakambangan','4','53213','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('294','109109','13','Jawa Tengah','156','CILACAP','LAPAS KELAS II A KEMBANG KUNING NUSAKAMBANGAN','NUSAKAMBANGAN','4','53213','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('295','109108','13','Jawa Tengah','156','CILACAP','LAPAS KELAS II A BESI NUSAKAMBANGAN','BESI NUSAKAMBANGAN','4','53213','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('296','652916','13','Jawa Tengah','156','CILACAP','LAPAS TERBUKA KELAS II B  NUSAKAMBANGAN','NUSAKAMBANGAN','4','53213','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('297','653000','13','Jawa Tengah','156','CILACAP','LAPAS NARKOTIKA  KELAS II A NUSAKAMBANGAN','Nusakambangan Km 8.5','4','53211','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('298','653353','13','Jawa Tengah','156','CILACAP','RUPBASAN KLAS II CILACAP','JL. JEND. A. YANI NO. 39','2','','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('299','405022','13','Jawa Tengah','156','CILACAP','LAPAS KELAS II B CILACAP','JL. KERINCI NO. 120','4','53223','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('300','497702','13','Jawa Tengah','156','CILACAP','LAPAS KELAS II A PASIR PUTIH NUSAKAMBANGAN','NUSAKAMBANGAN','4','53213','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('301','109106','13','Jawa Tengah','156','CILACAP','LAPAS KELAS II A PERMISAN NUSAKAMBANGAN','NUSAKAMBANGAN','4','53213','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('302','404987','13','Jawa Tengah','157','BANYUMAS','RUTAN KELAS II B BANYUMAS','JL. ALUN-ALUN NO.245','1','','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('303','653349','13','Jawa Tengah','158','PURBALINGGA','RUPBASAN KLAS II PURBALINGGA','jln.Letnan Kusni 27 Purbalingga','2','','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('304','404993','13','Jawa Tengah','158','PURBALINGGA','RUTAN KELAS II B PURBALINGGA','JL. ALUN-ALUN SELATAN NO.1','1','','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('305','405007','13','Jawa Tengah','159','BANJARNEGARA','RUTAN KELAS II B BANJARNEGARA','JL. PEMUDA NO. 81','1','53415','KANWIL JAWA TENGAH','system','2015-12-20 15:39:01'),
		('306','497727','14','DI Yogjakarta','162','YOGYAKARTA','LAPAS NARKOTIKA KELAS II A YOGYAKARTA','JL. Kaliurang KM. 17,5 Pakem, Sleman, Yogyakarta','4','','KANWIL D.I. YOGYAKARTA','system','2015-12-20 15:39:01'),
		('307','632590','14','DI Yogjakarta','162','YOGYAKARTA','RUPBASAN KLAS I YOGYAKARTA','JL. TAMAN SISWA NO. 8','2','','KANWIL D.I. YOGYAKARTA','system','2015-12-20 15:39:01'),
		('308','109636','14','DI Yogjakarta','162','YOGYAKARTA','RUTAN KELAS II A YOGYAKARTA','Jl.Taman Siswa No. 6A','1','','KANWIL D.I. YOGYAKARTA','system','2015-12-20 15:39:01'),
		('309','404591','14','DI Yogjakarta','162','YOGYAKARTA','LAPAS KELAS II A YOGYAKARTA','JL. TAMAN SISWA NO. 6','4','55111','KANWIL D.I. YOGYAKARTA','system','2015-12-20 15:39:01'),
		('310','404585','14','DI Yogjakarta','162','YOGYAKARTA','BAPAS KLAS I YOGYAKARTA','Jl. Trikora No. 1 Yogyakarta','5','55121','KANWIL D.I. YOGYAKARTA','system','2015-12-20 15:39:01'),
		('311','404611','14','DI Yogjakarta','163','WATES','RUTAN KELAS II B WATES','JL. SUPARMAN NO.3','1','55611','KANWIL D.I. YOGYAKARTA','system','2015-12-20 15:39:01'),
		('312','652433','14','DI Yogjakarta','163','WATES','RUPBASAN KLAS II WATES','JL. SUGIMAN GANG BISPA NO.1','2','','KANWIL D.I. YOGYAKARTA','system','2015-12-20 15:39:01'),
		('313','653442','14','DI Yogjakarta','164','WONOSARI','RUPBASAN KLAS II WONOSARI','Jl. Ki Ageng Giring No. 10','2','55813','KANWIL D.I. YOGYAKARTA','system','2015-12-20 15:39:01'),
		('314','404630','14','DI Yogjakarta','164','WONOSARI','RUTAN KELAS II B WONOSARI','Jl. MGR Sugiyopranoto 35 Wonosari kodepos 55811','1','','KANWIL D.I. YOGYAKARTA','system','2015-12-20 15:39:01'),
		('315','653133','14','DI Yogjakarta','164','WONOSARI','BAPAS KLAS II WONOSARI','Jl. Mgr. Sugiyopranoto No. 37, Baleharjo','5','55811','KANWIL D.I. YOGYAKARTA','system','2015-12-20 15:39:01'),
		('316','652852','14','DI Yogjakarta','165','SLEMAN','LAPAS KELAS II B SLEMAN','JL. BEDINGIN, SUMBERADI, MLATI','4','55288','KANWIL D.I. YOGYAKARTA','system','2015-12-20 15:39:01'),
		('317','653438','14','DI Yogjakarta','166','BANTUL','RUPBASAN KLAS II BANTUL','Jl. Srandakan Pandak Wijirejo Pandak Bantul','2','55761','KANWIL D.I. YOGYAKARTA','system','2015-12-20 15:39:01'),
		('318','109111','14','DI Yogjakarta','166','BANTUL','RUTAN KELAS II B BANTUL','Guwosari Pajangan Bantul kodepos 155','1','','KANWIL D.I. YOGYAKARTA','system','2015-12-20 15:39:01'),
		('319','405053','15','Jawa Timur','167','SIDOARJO','LAPAS KELAS I SURABAYA','DS. KEBON AGUNG, KEC. PORONG','4','','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('320','109112','15','Jawa Timur','167','SIDOARJO','RUTAN KELAS I SURABAYA','JL. LETJEN SUTOYO, MEDAENG, WARU','1','','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('321','626093','15','Jawa Timur','167','SURABAYA','RUPBASAN KLAS I SURABAYA','JL. LETJEN SUTOYO N0.266B, MEDAENG, WARU','2','','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('322','405120','15','Jawa Timur','168','BOJONEGORO','LAPAS KELAS II A BOJONEGORO','JL. DIPONEGORO NO. 94','4','62111','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('323','405102','15','Jawa Timur','168','BOJONEGORO','BAPAS KLAS II BOJONEGORO','JL. BASUKI RACHMAT NO. 46','5','62116','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('324','405126','15','Jawa Timur','169','TUBAN','LAPAS KELAS II B TUBAN','JL. VETERAN NO. 1','4','','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('325','405132','15','Jawa Timur','170','LAMONGAN','LAPAS KELAS II B LAMONGAN','JL. SUMARGO NO. 19','4','62217','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('326','567869','15','Jawa Timur','171','GRESIK','RUTAN KELAS II B GRESIK','JL. RAYA BANJARSARI','1','','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('327','405075','15','Jawa Timur','172','SIDOARJO','LAPAS KELAS II A SIDOARJO','Jl.Sultan Agung NO:32','4','61201','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('328','405044','15','Jawa Timur','172','SIDOARJO','BAPAS KLAS I SURABAYA','JL. LETJEN SUTOYO NO.111, WARU','5','61256','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('329','405081','15','Jawa Timur','173','MOJOKERTO','LAPAS KELAS II B MOJOKERTO','Jl. Taman Siswa No . 10 Mojokerto','4','','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('330','653370','15','Jawa Timur','173','MOJOKERTO','RUPBASAN KLAS II MOJOKERTO','JL. TAMANSISWA NO.10','2','','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('331','405101','15','Jawa Timur','174','JOMBANG','LAPAS KELAS II B JOMBANG','JL. KH. WAHID HASYIM NO.155','4','61419','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('332','653374','15','Jawa Timur','174','JOMBANG','RUPBASAN KLAS II JOMBANG','Jl. Raya Veteran No.66A Mojoagung Jombang','2','','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('333','405223','15','Jawa Timur','175','BONDOWOSO','LAPAS KELAS II B BONDOWOSO','JL. JAKSA AGUNG SUPRAPTO NO. 5','4','68211','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('334','405214','15','Jawa Timur','176','JEMBER','LAPAS KELAS II A JEMBER','JL. PB. SUDIRMAN NO. 13','4','68118','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('335','405208','15','Jawa Timur','176','JEMBER','BAPAS KLAS II JEMBER','JL. JAWA NO.34, SUMBER SARI','5','68121','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('336','405239','15','Jawa Timur','177','BANYUWANGI','LAPAS KELAS II B BANYUWANGI','JL. LETKOL ISTIQLAH NO. 59','4','68422','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('337','405245','15','Jawa Timur','178','SITUBONDO','RUTAN KELAS II B SITUBONDO','JL. JAKFAR NO.3','1','','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('338','405157','15','Jawa Timur','179','KEDIRI','LAPAS KELAS II A KEDIRI','JL. JAKSA AGUNG SUPRAPTO NO.21','4','64112','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('339','405141','15','Jawa Timur','179','KEDIRI','BAPAS KLAS II KEDIRI','Jl. Penangguan No. 19 Kediri','5','64114','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('340','405172','15','Jawa Timur','180','NGANJUK','RUTAN KELAS II B NGANJUK','JL. SUPRIYADI NO. 9','1','64411','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('341','405163','15','Jawa Timur','181','TULUNG AGUNG','LAPAS KELAS II B TULUNGAGUNG','JL. PAHLAWAN NO.139','4','66225','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('342','405194','15','Jawa Timur','182','TRENGGALEK','RUTAN KELAS II B TRENGGALEK','Jl. Supriyadi No. 15 ,Tranggalek','1','','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('343','405188','15','Jawa Timur','183','BLITAR','LAPAS KELAS II B BLITAR','JL. MERAPI NO. 2','4','66112','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('344','405483','15','Jawa Timur','183','BLITAR','LEMBAGA PEMBINAAN KHUSUS ANAK KELAS I BLITAR','JL. BALI NO. 76','4','66137','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('345','652386','15','Jawa Timur','183','BLITAR','RUPBASAN KLAS II BLITAR','Jl. Sumatra No.187 Blitar','2','','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('346','405333','15','Jawa Timur','184','MALANG','LAPAS KELAS I MALANG','Jl. Asahan No. 7 Malang','4','','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('347','405327','15','Jawa Timur','184','MALANG','BAPAS KLAS I MALANG','JL. BARITO NO.1','5','65123','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('348','405409','15','Jawa Timur','184','MALANG','LAPAS WANITA KELAS II A MALANG','JL. RAYA KEBONSARI','4','65149','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('349','405389','15','Jawa Timur','185','PASURUAN','LAPAS KELAS II B PASURUAN','JL. PANGLIMA SUDIRMAN NO.4','4','67115','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('350','653381','15','Jawa Timur','185','PASURUAN','RUPBASAN KLAS II PASURUAN','Jl. Ir. H. Juanda No. 3 Pasuruan','2','60000','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('351','405358','15','Jawa Timur','186','PROBOLINGGO','LAPAS KELAS II B PROBOLINGGO','JL. TRUNOJOYO NO. 1','4','','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('352','662945','15','Jawa Timur','186','PROBOLINGGO','RUPBASAN KLAS II PROBOLINGGO','Jl. Anggrek No. 29 Kel. Sukabumi ,Kec Mayangan Pro','2','','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('353','405373','15','Jawa Timur','187','LUMAJANG','LAPAS KELAS II B LUMAJANG','Jl. Alun-Alun Timur No. 05','4','67314','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('354','405395','15','Jawa Timur','188','PASURUAN','RUTAN KELAS II B BANGIL','Jl.Mangga No.2 Bangil','1','67153','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('355','405364','15','Jawa Timur','189','KRAKSAAN','RUTAN KELAS II B KRAKSAAN','Jl. Raya P. Sudirman No. 69 Kraksaan','1','67282','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('356','405421','15','Jawa Timur','190','MADIUN','LAPAS KELAS I MADIUN','JL. YOS SUDARSO NO. 100','4','63122','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('357','653002','15','Jawa Timur','190','MADIUN','LAPAS NARKOTIKA  KELAS II A MADIUN','NULL','4','','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('358','405414','15','Jawa Timur','190','MADIUN','BAPAS KLAS II MADIUN','JL. SALAK NO.85, TAMAN','5','63131','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('359','405461','15','Jawa Timur','191','PONOROGO','RUTAN KELAS II B PONOROGO','JL. SUKARNO-HATTA NO.53','1','63411','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('360','405477','15','Jawa Timur','192','PACITAN','RUTAN KELAS II B PACITAN','JL. RONGGO WARSITO NO. 5','1','','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('361','405452','15','Jawa Timur','193','NGAWI','LAPAS KELAS II B NGAWI','JL. M. H. THAMRIN NO. 35','4','63217','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('362','405446','15','Jawa Timur','194','MAGETAN','RUTAN KELAS II B MAGETAN','JL. MERAPI NO. 168','1','63314','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('363','405270','15','Jawa Timur','195','PAMEKASAN','LAPAS KELAS II A PAMEKASAN','JL. PEMBINA NO.1','4','69317','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('364','653019','15','Jawa Timur','195','PAMEKASAN','LAPAS NARKOTIKA KELAS II A PAMEKASAN','NULL','4','','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('365','405251','15','Jawa Timur','195','PAMEKASAN','BAPAS KLAS II PAMEKASAN','JL. JALMAK NO.14','5','69301','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('366','405282','15','Jawa Timur','196','SUMENEP','RUTAN KELAS II B SUMENEP','JL. KH. MANSYUR NO.355','1','69411','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('367','405302','15','Jawa Timur','196','PULAU KANGEAN','CABANG RUTAN ARJASA','JL. TIMUR ALUN-ALUN, ARJASA','3','69491','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('368','405291','15','Jawa Timur','197','BANGKALAN','RUTAN KELAS II B BANGKALAN','JL. PERTEMPURAN NO.21','1','69112','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('369','405311','15','Jawa Timur','198','SAMPANG','RUTAN KELAS II B SAMPANG','JL. KH WAHID HASYIM NO.151','1','69213','KANWIL JAWA TIMUR','system','2015-12-20 15:39:01'),
		('370','526815','16','Banten','202','SERANG','RUTAN KELAS II B SERANG','JL. Mayor Syafei No. 118 Serang Banten','1','42112','KANWIL BANTEN','system','2015-12-20 15:39:01'),
		('371','683636','16','Banten','202','CILEGON','LAPAS KELAS III CILEGON','Jl. Cikerai Link. Koweni Kel. Kalitimbang Kec. Cib','4','42424','KANWIL BANTEN','system','2015-12-20 15:39:01'),
		('372','653239','16','Banten','202','SERANG','BAPAS KLAS II SERANG','JL. KH. FATAH HASAN NO.51','5','42112','KANWIL BANTEN','system','2015-12-20 15:39:01'),
		('373','632573','16','Banten','202','SERANG','RUPBASAN KLAS II SERANG','JL. BRIGJEN KH. SAMAUN NO. 44 D','2','','KANWIL BANTEN','system','2015-12-20 15:39:01'),
		('374','404523','16','Banten','202','SERANG','LAPAS KELAS II A SERANG','JL.Raya Pandeglang, Serang KM 6,5 Serang','4','','KANWIL BANTEN','system','2015-12-20 15:39:01'),
		('375','404548','16','Banten','203','LEBAK','RUTAN KELAS II B RANGKASBITUNG','Jl.Multatuli No.2 Rangkasbitung','1','42311','KANWIL BANTEN','system','2015-12-20 15:39:01'),
		('376','404532','16','Banten','204','PANDEGLANG','RUTAN KELAS II B PANDEGLANG','Jl. Mesjid Agung No. 3 Pandeglang','1','','KANWIL BANTEN','system','2015-12-20 15:39:01'),
		('377','404563','16','Banten','205','TANGERANG','LAPAS ANAK PRIA KELAS II A TANGERANG','JL. Raya Daan Mogot No. 29 C Tangerang','4','','KANWIL BANTEN','system','2015-12-20 15:39:01'),
		('378','404579','16','Banten','205','TANGERANG','LAPAS ANAK WANITA KELAS II B TANGERANG','Jl. Raya Daan Mogot No. 28 C, PO BOX 479, Tangeran','4','','KANWIL BANTEN','system','2015-12-20 15:39:01'),
		('379','404554','16','Banten','205','TANGERANG','LAPAS PEMUDA KELAS II A TANGERANG','Jl. LPK Pemuda','4','','KANWIL BANTEN','system','2015-12-20 15:39:01'),
		('380','559883','16','Banten','205','TANGERANG','RUPBASAN KLAS I JAKARTA BARAT DI TANGERANG','JL. TARUNA NO. 41','2','','KANWIL DKI JAKARTA','system','2015-12-20 15:39:01'),
		('381','408661','16','Banten','205','TANGERANG','LAPAS WANITA KELAS II A TANGERANG','Jln. Moh. Yamin Tangerang','4','','KANWIL BANTEN','system','2015-12-20 15:39:01'),
		('382','497846','16','Banten','205','TANGERANG','RUTAN KELAS I TANGERANG','Jl. Raya Pacing Desa Taban Kecamatan Jambe Kab. Ta','1','','KANWIL BANTEN','system','2015-12-20 15:39:01'),
		('383','408706','16','Banten','205','TANGERANG','LAPAS KELAS I TANGERANG','JL. Veteran 11 Kotak Pos 137 Tangerang','4','15118','KANWIL BANTEN','system','2015-12-20 15:39:01'),
		('384','632726','17','Bali','206','DENPASAR','RUPBASAN KLAS I DENPASAR','JL. RATNA NO.19','2','','KANWIL BALI','system','2015-12-20 15:39:01'),
		('385','407525','17','Bali','206','DENPASAR','LAPAS KELAS II A DENPASAR','JL. KEN AROK NO.4 TANGKUBAN PERAHU, KEROBOKAN, KEC','4','80030','KANWIL BALI','system','2015-12-20 15:39:01'),
		('386','407519','17','Bali','206','DENPASAR','BAPAS KLAS I DENPASAR','JL. Ken Arok No. 4 Denpasar','5','80115','KANWIL BALI','system','2015-12-20 15:39:01'),
		('387','407531','17','Bali','207','SINGARAJA','LAPAS KELAS II B SINGARAJA','JL. VETERAN NO. 18','4','81118','KANWIL BALI','system','2015-12-20 15:39:01'),
		('388','407550','17','Bali','208','BALI','RUTAN KELAS II B NEGARA','   JL. Wijaya Kusuma No. 23 Negara, Bali','1','','KANWIL BALI','system','2015-12-20 15:39:01'),
		('389','407556','17','Bali','209','SEMARAPURA','RUTAN KELAS II B KLUNGKUNG','JL. MAWAR NO. 12, KLUNGKUNG','1','80714','KANWIL BALI','system','2015-12-20 15:39:01'),
		('390','407562','17','Bali','210','TABANAN','LAPAS KELAS II B TABANAN','JL. GUNUNG AGUNG NO. 21','4','82114','KANWIL BALI','system','2015-12-20 15:39:01'),
		('391','109147','17','Bali','211','KARANG ASEM','LEMBAGA PEMBINAAN KHUSUS ANAK KELAS II GIANYAR','JL. Serma Natih Amlapura ','4','80811','KANWIL BALI','system','2015-12-20 15:39:01'),
		('392','653175','17','Bali','211','KARANG ASEM','BAPAS KLAS II KARANGASEM','JL. SERMA-NATIH AMLAPURA','5','80811','KANWIL BALI','system','2015-12-20 15:39:01'),
		('393','407593','17','Bali','211','KARANG ASEM','LAPAS KELAS II B KARANGASEM','JL. SERMA NATIH NO.2, AMLAPURA','4','80811','KANWIL BALI','system','2015-12-20 15:39:01'),
		('394','407571','17','Bali','212','GIANYAR','RUTAN KELAS II B GIANYAR','JAlan Ngurah Rai I / 3 Gianyar','1','80511','KANWIL BALI','system','2015-12-20 15:39:01'),
		('395','653040','17','Bali','213','BANGLI','LAPAS NARKOTIKA KELAS II A BANGLI','Br.Buungan Ds.Tiga Kec.Susut Kab. Bangli','4','80661','KANWIL BALI','system','2015-12-20 15:39:01'),
		('396','407587','17','Bali','213','BANGLI','RUTAN KELAS II B BANGLI','JL. MERDEKA NO. 95','1','80613','KANWIL BALI','system','2015-12-20 15:39:01'),
		('397','683373','18','Nusa Tenggara Barat','214','MATARAM','LEMBAGA PEMBINAAN KHUSUS ANAK KELAS II MATARAM','NULL','4','','KANWIL NUSA TENGGARA BARAT','system','2015-12-20 15:39:01'),
		('398','407607','18','Nusa Tenggara Barat','214','MATARAM','BAPAS KLAS II MATARAM','Jl. kokok Segara No. 06 Kekalik','5','83127','KANWIL NUSA TENGGARA BARAT','system','2015-12-20 15:39:01'),
		('399','632734','18','Nusa Tenggara Barat','214','MATARAM','RUPBASAN KLAS I MATARAM','JL. MAJAPAHIT NO. 44','2','','KANWIL NUSA TENGGARA BARAT','system','2015-12-20 15:39:01'),
		('400','407613','18','Nusa Tenggara Barat','214','MATARAM','LAPAS KELAS II A MATARAM','jalan Hoscokroaminoto no 5, mataram, nusa tenggara','4','','KANWIL NUSA TENGGARA BARAT','system','2015-12-20 15:39:01'),
		('401','407653','18','Nusa Tenggara Barat','215','BIMA','RUTAN KELAS II B RABA BIMA','NULL','1','','KANWIL NUSA TENGGARA BARAT','system','2015-12-20 15:39:01'),
		('402','407644','18','Nusa Tenggara Barat','216','SUMBAWA BESAR','LAPAS KELAS II A SUMBAWA BESAR','JL. RAYA JURUSAN BIMA KM 7 Sumbawa Besar ','4','84313','KANWIL NUSA TENGGARA BARAT','system','2015-12-20 15:39:01'),
		('403','653182','18','Nusa Tenggara Barat','216','SUMBAWA BESAR','BAPAS KLAS II SUMBAWA BESAR','JL. RAYA JURUSAN BIMA KM. 7','5','','KANWIL NUSA TENGGARA BARAT','system','2015-12-20 15:39:01'),
		('404','653417','18','Nusa Tenggara Barat','216','SUMBAWA BESAR','RUPBASAN KLAS II SUMBAWA BESAR','JL. KIHAJAR DEWANTARA NO. 12','2','','KANWIL NUSA TENGGARA BARAT','system','2015-12-20 15:39:01'),
		('405','407622','18','Nusa Tenggara Barat','217','SELONG','RUTAN KELAS II B SELONG','Jl.TGH.M.Zainuddin Abdul Madjid 199 ','1','83613','KANWIL NUSA TENGGARA BARAT','system','2015-12-20 15:39:01'),
		('406','408649','18','Nusa Tenggara Barat','218','DOMPU','LAPAS KELAS II B DOMPU','JLN. AHMAD YANI KM. 08 DOMPU','4','84251','KANWIL NUSA TENGGARA BARAT','system','2015-12-20 15:39:01'),
		('407','652923','18','Nusa Tenggara Barat','219','BATUKLIANG','LAPAS TERBUKA KELAS II B  MATARAM','Jln. Tojong-Ojong, Ds. Selebung, Kec. Batukliang, ','4','','KANWIL NUSA TENGGARA BARAT','system','2015-12-20 15:39:01'),
		('408','407638','18','Nusa Tenggara Barat','219','PRAYA','RUTAN KELAS II B PRAYA','jalan Basuki Rahmat No.02, Praya, Lombok Tengah, N','1','','KANWIL NUSA TENGGARA BARAT','system','2015-12-20 15:39:01'),
		('409','407732','19','Nusa Tenggara Timur','225','WAIKABUBAK','LAPAS KELAS II B WAIKABUBAK','JL. ADHYAKSA KM.6 WAIKABUBAK','4','87203','KANWIL NUSA TENGGARA TIMUR','system','2015-12-20 15:39:01'),
		('410','621797','19','Nusa Tenggara Timur','220','KUPANG','LEMBAGA PEMBINAAN KHUSUS ANAK KELAS I KUPANG','Jalan Matahari,Oesapa selatan, Kelapa Lima ','4','85000','KANWIL NUSA TENGGARA TIMUR','system','2015-12-20 15:39:01'),
		('411','407669','19','Nusa Tenggara Timur','220','KUPANG','LAPAS KELAS II A KUPANG','Jl. Matahari, Penfui, Kota Kupang','4','58361','KANWIL NUSA TENGGARA TIMUR','system','2015-12-20 15:39:01'),
		('412','109148','19','Nusa Tenggara Timur','220','KUPANG','BAPAS KLAS II KUPANG','JL. MATAHARI NO.2 PENFUI','5','85111','KANWIL NUSA TENGGARA TIMUR','system','2015-12-20 15:39:01'),
		('413','683352','19','Nusa Tenggara Timur','220','KUPANG','LAPAS WANITA KELAS III KUPANG','NULL','4','','KANWIL NUSA TENGGARA TIMUR','system','2015-12-20 15:39:01'),
		('414','683416','19','Nusa Tenggara Timur','220','KUPANG','RUTAN KELAS II B KUPANG','NULL','1','','KANWIL NUSA TENGGARA TIMUR','system','2015-12-20 15:39:01'),
		('415','632747','19','Nusa Tenggara Timur','220','KUPANG','RUPBASAN KLAS I KUPANG','jln. matahari no.06 kupang-ntt','2','85111','KANWIL NUSA TENGGARA TIMUR','system','2015-12-20 15:39:01'),
		('416','407675','19','Nusa Tenggara Timur','221','ATAMBUA','LAPAS KELAS II B ATAMBUA','JL. PROF. SUPOMO, SH','4','85718','KANWIL NUSA TENGGARA TIMUR','system','2015-12-20 15:39:01'),
		('417','407702','19','Nusa Tenggara Timur','222','SOE','RUTAN KELAS II B SOE','Jalan Ikan Arwana No. 16','1','85511','KANWIL NUSA TENGGARA TIMUR','system','2015-12-20 15:39:01'),
		('418','407681','19','Nusa Tenggara Timur','223','KEFAMENANU','RUTAN KELAS II B KEFAMENANU','Jalan Sisingamangaraja','1','','KANWIL NUSA TENGGARA TIMUR','system','2015-12-20 15:39:01'),
		('419','407726','19','Nusa Tenggara Timur','224','WAINGAPU, SUMBA TIMUR','LAPAS KELAS II A WAINGAPU','JL. HASANUDDIN NO.39','4','87111','KANWIL NUSA TENGGARA TIMUR','system','2015-12-20 15:39:01'),
		('420','652937','19','Nusa Tenggara Timur','225','WAIKABUBAK','LAPAS TERBUKA KELAS II B WAIKABUBAK','NULL','4','','KANWIL NUSA TENGGARA TIMUR','system','2015-12-20 15:39:01'),
		('421','653218','19','Nusa Tenggara Timur','225','WAIKABUBAK','BAPAS KLAS II WAIKABUBAK','JL. ADYAKSA KM. 6','5','','KANWIL NUSA TENGGARA TIMUR','system','2015-12-20 15:39:01'),
		('422','407741','19','Nusa Tenggara Timur','226','ENDE','LAPAS KELAS II B ENDE','JL. SAM RATULANGI','4','86318','KANWIL NUSA TENGGARA TIMUR','system','2015-12-20 15:39:01'),
		('423','407772','19','Nusa Tenggara Timur','227','MAUMERE','RUTAN KELAS II B MAUMERE','JL. KS. TUBUN NO. 30','1','86111','KANWIL NUSA TENGGARA TIMUR','system','2015-12-20 15:39:01'),
		('424','407788','19','Nusa Tenggara Timur','228','LARANTUKA','RUTAN KELAS II B LARANTUKA','JL. JEND. SUDIRMAN NO. 50','1','','KANWIL NUSA TENGGARA TIMUR','system','2015-12-20 15:39:01'),
		('425','407763','19','Nusa Tenggara Timur','229','RUTENG','RUTAN KELAS II B RUTENG','JL. RANAKA KM. 3','1','86519','KANWIL NUSA TENGGARA TIMUR','system','2015-12-20 15:39:01'),
		('426','407757','19','Nusa Tenggara Timur','230','BAJAWA','RUTAN KELAS II B BAJAWA','JL. SOEKARNO-HATTA NO. 17','1','86412','KANWIL NUSA TENGGARA TIMUR','system','2015-12-20 15:39:01'),
		('427','407720','19','Nusa Tenggara Timur','231','KALABAHI','LAPAS KELAS II B KALABAHI','JL. MOLA','4','','KANWIL NUSA TENGGARA TIMUR','system','2015-12-20 15:39:01'),
		('428','683331','19','Nusa Tenggara Timur','232','LEMBATA','LAPAS KELAS III LEMBATA','NULL','4','','KANWIL NUSA TENGGARA TIMUR','system','2015-12-20 15:39:01'),
		('429','407701','19','Nusa Tenggara Timur','233','BAA','CABANG RUTAN KUPANG DI BAA','JL. LEKUNIK','3','85371','KANWIL NUSA TENGGARA TIMUR','system','2015-12-20 15:39:01'),
		('430','406673','20','Kalimantan Barat','234','PONTIANAK','LAPAS ANAK KELAS II B PONTIANAK','JL. ADI SUCIPTO KM.5, SUNGAI RAYA','4','78391','KANWIL KALIMANTAN BARAT','system','2015-12-20 15:39:01'),
		('431','567873','20','Kalimantan Barat','234','PONTIANAK','RUTAN KELAS II A PONTIANAK','JL. SUNGAI RAYA DALAM KM.1,3','1','78124','KANWIL KALIMANTAN BARAT','system','2015-12-20 15:39:01'),
		('432','409139','20','Kalimantan Barat','234','PONTIANAK','BAPAS KLAS II PONTIANAK','JL. ABDULRAHMAN SALEH NO. 37','5','','KANWIL KALIMANTAN BARAT','system','2015-12-20 15:39:01'),
		('433','632637','20','Kalimantan Barat','234','PONTIANAK','RUPBASAN KLAS I PONTIANAK','JL. ADI SUCIPTO KM 06','2','','KANWIL KALIMANTAN BARAT','system','2015-12-20 15:39:01'),
		('434','406602','20','Kalimantan Barat','234','PONTIANAK','LAPAS KELAS II A PONTIANAK','JL. ADI SUCIPTO, SUNGAI RAYA','4','78391','KANWIL KALIMANTAN BARAT','system','2015-12-20 15:39:01'),
		('435','653395','20','Kalimantan Barat','235','SINGKAWANG','RUPBASAN KLAS II SINGKAWANG','JL. FIRDAUS H. RAIS NO 65','2','','KANWIL KALIMANTAN BARAT','system','2015-12-20 15:39:01'),
		('436','406627','20','Kalimantan Barat','235','SINGKAWANG','LAPAS KELAS II B SINGKAWANG','Jl. Tanjung Batu No. 33 Singkawang Kalimantan Bara','4','','KANWIL KALIMANTAN BARAT','system','2015-12-20 15:39:01'),
		('437','622441','20','Kalimantan Barat','236','SINTANG','BAPAS KLAS II SINTANG','JL. DR. WAHIDIN SUDIRO HUSODO ','5','78612','KANWIL KALIMANTAN BARAT','system','2015-12-20 15:39:01'),
		('438','406658','20','Kalimantan Barat','236','SINTANG','LAPAS KELAS II B SINTANG','JL. DR. WAHIDIN SUDIRO HUSODO SINTANG','4','','KANWIL KALIMANTAN BARAT','system','2015-12-20 15:39:01'),
		('439','406664','20','Kalimantan Barat','237','KETAPANG','LAPAS KELAS II B KETAPANG','Jl. Letjen S. Parman No. 65','4','','KANWIL KALIMANTAN BARAT','system','2015-12-20 15:39:01'),
		('440','406633','20','Kalimantan Barat','238','MEMPAWAH','RUTAN KELAS II B MEMPAWAH','Jln. Daeng Menambon No.15 ','1','78911','KANWIL KALIMANTAN BARAT','system','2015-12-20 15:39:01'),
		('441','653403','20','Kalimantan Barat','239','SANGGAU','RUPBASAN KELAS II SANGGAU',' JALAN JEND. SUDRIMAN KILO METER 06 SEMBOJA NOMOR ','2','','KANWIL KALIMANTAN BARAT','system','2015-12-20 15:39:01'),
		('442','406611','20','Kalimantan Barat','239','SANGGAU','RUTAN KELAS II B SANGGAU','Jln.K,H,Dewantara No.03 Kel.Ilir Kota Kec.Kapuas K','1','78513','KANWIL KALIMANTAN BARAT','system','2015-12-20 15:39:01'),
		('443','526822','20','Kalimantan Barat','240','PUTUSSIBAU','RUTAN KELAS II B PUTUSSIBAU','JALAN PENJARA NO.47 PUTUSSIBAU','1','','KANWIL KALIMANTAN BARAT','system','2015-12-20 15:39:01'),
		('444','406642','20','Kalimantan Barat','241','SAMBAS','RUTAN KELAS II B SAMBAS','Jalan Pemabangunan ','1','','KANWIL KALIMANTAN BARAT','system','2015-12-20 15:39:01'),
		('445','497789','20','Kalimantan Barat','242','BENGKAYANG','RUTAN KELAS II B BENGKAYANG','JL. RAYA BENGKAYANG, SANGGAU LEDO KM 19 KEC. LUMAR','1','','KANWIL KALIMANTAN BARAT','system','2015-12-20 15:39:01'),
		('446','497773','20','Kalimantan Barat','343','NGABANG','RUTAN KELAS II B LANDAK','Jl.Serimbu Ngabang Ds.Ambarang No.23 Kec.Ngabang, ','1','78357','KANWIL KALIMANTAN BARAT','system','2015-12-20 15:39:01'),
		('447','632641','21','Kalimantan Tengah','243','PALANGKA RAYA','RUPBASAN KLAS I PALANGKARAYA','NULL','2','','KANWIL KALIMANTAN TENGAH','system','2015-12-20 15:39:01'),
		('448','406689','21','Kalimantan Tengah','243','PALANGKARAYA','LAPAS KELAS II A PALANGKARAYA','JL. Cilik Riwut Km 2.5 Palangkaraya','4','','KANWIL KALIMANTAN TENGAH','system','2015-12-20 15:39:01'),
		('449','621819','21','Kalimantan Tengah','243','PALANGKA RAYA','RUTAN KELAS II A PALANGKARAYA','Jl. Cilik Riwut Km. 5','1','73112','KANWIL KALIMANTAN TENGAH','system','2015-12-20 15:39:01'),
		('450','109138','21','Kalimantan Tengah','243','KOTA PALANGKA RAYA','BAPAS KLAS II PALANGKARAYA','Jln. Tjilik Riwut Km.4,5','5','','KANWIL KALIMANTAN TENGAH','system','2015-12-20 15:39:01'),
		('451','406715','21','Kalimantan Tengah','244','PANGKALAN BUN','LAPAS KELAS II B PANGKALAN BUN','Jl. Jend. Sudirman No. 51','4','74111','KANWIL KALIMANTAN TENGAH','system','2015-12-20 15:39:01'),
		('452','626178','21','Kalimantan Tengah','244','PANGKALAN BUN','BAPAS KLAS II PANGKALAN BUN','Jl. Landak Rt.02 Pangkalan Bun ','5','74111','KANWIL KALIMANTAN TENGAH','system','2015-12-20 15:39:01'),
		('453','653150','21','Kalimantan Tengah','245','MUARA TEWEH','BAPAS KLAS II MUARA TEWE','JL. NEGARA KM. 6','5','','KANWIL KALIMANTAN TENGAH','system','2015-12-20 15:39:01'),
		('454','406709','21','Kalimantan Tengah','245','MUARA TEWEH','LAPAS KELAS II B MUARA TEWEH','Jl. Pramuka No.113, Kel. Lanjas, Kec.Teweh Tengah,','4','73812','KANWIL KALIMANTAN TENGAH','system','2015-12-20 15:39:01'),
		('455','406695','21','Kalimantan Tengah','246','KUALA KAPUAS','RUTAN KELAS II B KUALA KAPUAS','Jl. Cilik Riwut IV/55','1','73516','KANWIL KALIMANTAN TENGAH','system','2015-12-20 15:39:01'),
		('456','408633','21','Kalimantan Tengah','247','BUNTOK','RUTAN KELAS II B BUNTOK','Jl. Pahlawan Km. 5','1','','KANWIL KALIMANTAN TENGAH','system','2015-12-20 15:39:01'),
		('457','406721','21','Kalimantan Tengah','248','SAMPIT','LAPAS KELAS II B SAMPIT','NULL','4','','KANWIL KALIMANTAN TENGAH','system','2015-12-20 15:39:01'),
		('458','683753','21','Kalimantan Tengah','249','TAMIANG LAYANG','RUTAN KELAS II B TAMIANG LAYANG','NULL','1','','KANWIL KALIMANTAN TENGAH','system','2015-12-20 15:39:01'),
		('459','683699','21','Kalimantan Tengah','342','KASONGAN','LAPAS NARKOTIKA KELAS III KASONGAN','NULL','4','','KANWIL KALIMANTAN TENGAH','system','2015-12-20 15:39:01'),
		('460','408680','22','Kalimantan Selatan','251','BANJARMASIN','BAPAS KLAS I BANJARMASIN','JL. JEND. A. YANI KM. 5,5 NO.39','5','70248','KANWIL KALIMANTAN SELATAN','system','2015-12-20 15:39:01'),
		('461','406740','22','Kalimantan Selatan','251','BANJARMASIN','LAPAS KELAS II A BANJARMASIN','JL. MAYJEN SUTOYO S. NO. 01','4','70118','KANWIL KALIMANTAN SELATAN','system','2015-12-20 15:39:01'),
		('462','406777','22','Kalimantan Selatan','252','KANDANGAN','RUTAN KELAS II B KANDANGAN','JL. M. JOHANSYAH NO. 37','1','71211','KANWIL KALIMANTAN SELATAN','system','2015-12-20 15:39:01'),
		('463','406761','22','Kalimantan Selatan','253','KOTABARU','LAPAS KELAS II B KOTABARU','JL. BRIGJEND H. HASAN BASRI NO. 109','4','72117','KANWIL KALIMANTAN SELATAN','system','2015-12-20 15:39:01'),
		('464','406792','22','Kalimantan Selatan','254','BARABAI','RUTAN KELAS II B BARABAI','JL. H. SIBLI IMANSYAH NO. 01 BARABAI - HULU SUNGAI','1','71314','KANWIL KALIMANTAN SELATAN','system','2015-12-20 15:39:01'),
		('465','406746','22','Kalimantan Selatan','255','MARTAPURA','LEMBAGA PEMBINAAN KHUSUS ANAK KELAS I MARTAPURA','Jl. Pintu Air Tanjung Rema Darat Martapura ','4','70613','KANWIL KALIMANTAN SELATAN','system','2015-12-20 15:39:01'),
		('466','213001','22','Kalimantan Selatan','255','MARTAPURA','LAPAS NARKOTIKA KELAS II A KARANG INTAN','Ds. Lihung Kec. Karang Intan Kab. Banjar Prov. Kal','4','','KANWIL KALIMANTAN SELATAN','system','2015-12-20 15:39:01'),
		('467','632658','22','Kalimantan Selatan','255','MARTAPURA','RUPBASAN KLAS I BANJARMASIN','JL.Pintu Air Tanjung Rema Darat Rt.09 No.1','2','70613','KANWIL KALIMANTAN SELATAN','system','2015-12-20 15:39:01'),
		('468','683348','22','Kalimantan Selatan','256','TANJUNG','LAPAS KELAS III TANJUNG','Jl. A. Yani Km.10 Komp. Islamic Center Maburai - T','4','71571','KANWIL KALIMANTAN SELATAN','system','2015-12-20 15:39:01'),
		('469','406812','22','Kalimantan Selatan','256','TANJUNG','RUTAN KELAS II B TANJUNG','Jalan Jaksa Agung Suprapto No. 74 Tanjung Kabupate','1','71571','KANWIL KALIMANTAN SELATAN','system','2015-12-20 15:39:01'),
		('470','626051','22','Kalimantan Selatan','257','AMUNTAI','BAPAS KLAS II AMUNTAI','JL. SUKAMARGA NO. 324','5','71418','KANWIL KALIMANTAN SELATAN','system','2015-12-20 15:39:01'),
		('471','406803','22','Kalimantan Selatan','257','AMUNTAI','LAPAS KELAS II B AMUNTAI','JL. SUKAMARGA NO. 324','4','71418','KANWIL KALIMANTAN SELATAN','system','2015-12-20 15:39:01'),
		('472','406783','22','Kalimantan Selatan','258','RANTAU','RUTAN KELAS II B RANTAU','Jl. SPG, RT.01, Kelurahan Rangda Malingkung, Kecam','1','71114','KANWIL KALIMANTAN SELATAN','system','2015-12-20 15:39:01'),
		('473','109139','22','Kalimantan Selatan','259','MARABAHAN','RUTAN KELAS II B MARABAHAN','Jalan Putri Junjung Buih No. 125','1','','KANWIL KALIMANTAN SELATAN','system','2015-12-20 15:39:01'),
		('474','406752','22','Kalimantan Selatan','260','PELAIHARI','RUTAN KELAS II B PELAIHARI','JL. A. SYAIRANI RT. 9','1','70813','KANWIL KALIMANTAN SELATAN','system','2015-12-20 15:39:01'),
		('475','684001','22','Kalimantan Selatan','261','BANJARBARU','LAPAS KELAS III BANJAR BARU','NULL','4','','KANWIL KALIMANTAN SELATAN','system','2015-12-20 15:39:01'),
		('476','406865','23','Kalimantan Timur','262','TARAKAN','LAPAS KELAS II A TARAKAN','JL. LEMBAGA PEMASYARAKATAN KARANG REJO','4','77112','KANWIL KALIMANTAN TIMUR','system','2015-12-20 15:39:01'),
		('477','683369','23','Kalimantan Timur','263','SAMARINDA','LAPAS NARKOTIKA KELAS III SAMARINDA','Jalan Padat Karya Rt 16 Bayur, Kelurahan Sempaja U','4','','KANWIL KALIMANTAN TIMUR','system','2015-12-20 15:39:01'),
		('478','632662','23','Kalimantan Timur','263','SAMARINDA','RUPBASAN KELAS I SAMARINDA','JL. P.SURYANATA PERUM BUKIT PINANG','2','75126','KANWIL KALIMANTAN TIMUR','system','2015-12-20 15:39:01'),
		('479','650190','23','Kalimantan Timur','263','SAMARINDA','RUTAN KELAS II A SAMARINDA','JL. KH. Wahid Hasyim RT.51 No.36 Kelurahan Sempaja','1','75115','KANWIL KALIMANTAN TIMUR','system','2015-12-20 15:39:01'),
		('480','406843','23','Kalimantan Timur','263','SAMARINDA','LAPAS KELAS II A SAMARINDA','JL. JEND. SUDIRMAN NO. 15','4','75121','KANWIL KALIMANTAN TIMUR','system','2015-12-20 15:39:01'),
		('481','626068','23','Kalimantan Timur','263','SAMARINDA','BAPAS KLAS II SAMARINDA','JL. MT. HARYONO NO.22','5','75124','KANWIL KALIMANTAN TIMUR','system','2015-12-20 15:39:01'),
		('482','406859','23','Kalimantan Timur','264','TENGGARONG','LAPAS KELAS II B TENGGARONG','jl Mangkuraja No 1 Kelurahan Loa Ipuh Kecamatan Te','4','','KANWIL KALIMANTAN TIMUR','system','2015-12-20 15:39:01'),
		('483','531887','23','Kalimantan Timur','265','BALIKPAPAN','RUTAN KELAS II B BALIKPAPAN','JL. JEND. SUDIRMAN NO.533','1','76114','KANWIL KALIMANTAN TIMUR','system','2015-12-20 15:39:01'),
		('484','406828','23','Kalimantan Timur','265','BALIKPAPAN','LAPAS KELAS II A BALIKPAPAN','Jl. Jend. Sudirman No. 03 RT. 41','4','76114','KANWIL KALIMANTAN TIMUR','system','2015-12-20 15:39:01'),
		('485','109141','23','Kalimantan Timur','265','BALIKPAPAN','BAPAS KLAS II BALIKPAPAN','JL. JEND. SUDIRMAN / LAP. GOLF NO. 106','5','76114','KANWIL KALIMANTAN TIMUR','system','2015-12-20 15:39:01'),
		('486','406834','23','Kalimantan Timur','266','TANJUNG REDEB','RUTAN KELAS II B TANJUNG REDEB','JL. DR. MURJANI II','1','77311','KANWIL KALIMANTAN TIMUR','system','2015-12-20 15:39:01'),
		('487','109140','23','Kalimantan Timur','267','TANAH GROGOT','RUTAN KELAS II B TANAH GROGOT','JL. KUSUMA BANGSA NO. 411 KM. 4','1','76211','KANWIL KALIMANTAN TIMUR','system','2015-12-20 15:39:01'),
		('488','497795','23','Kalimantan Timur','268','NUNUKAN','LAPAS KELAS II B NUNUKAN','JL. LINTAS LAPAS NO. 7','4','','KANWIL KALIMANTAN TIMUR','system','2015-12-20 15:39:01'),
		('489','683643','23','Kalimantan Timur','271','BONTANG','LAPAS KELAS III BONTANG','Jl. Prestasi, Bontang Lestari','4','75325','KANWIL KALIMANTAN TIMUR','system','2015-12-20 15:39:01'),
		('490','406916','24','Sulawesi Utara','275','KOTAMOBAGU','RUTAN KELAS II B KOTAMOBAGU','Jl. Jend. Achmad Yani No. 636 Kotamobagu Sulawesi ','1','','KANWIL SULAWESI UTARA','system','2015-12-20 15:39:01'),
		('491','406910','24','Sulawesi Utara','277','TOMOHON','LEMBAGA PEMBINAAN KHUSUS ANAK KELAS II TOMOHON','JL. P.L. Kaunang Kelurahan Kolongan I Kecamatan To','4','95681','KANWIL SULAWESI UTARA','system','2015-12-20 15:39:01'),
		('492','406984','24','Sulawesi Utara','276','KABUPATEN KEPULAUAN SIAu Tagulandang Biaro','LAPAS KELAS II B ULU SIAU','DS. BUISSE, KEC. SIAU TIMUR','4','95681','KANWIL SULAWESI UTARA','system','2015-12-20 15:39:01'),
		('493','406947','24','Sulawesi Utara','276','TAHUNA','CABANG RUTAN ENEMAWIRA','JL. RAYA TAHUNA-PETTA NO. 19, ENEMAWIRA','3','95856','KANWIL SULAWESI UTARA','system','2015-12-20 15:39:01'),
		('494','406978','24','Sulawesi Utara','278','SITARO','CABANG RUTAN TAGULANDANG','JL. RAYA BUHIAS  NO.18 KELURAHAN BAHOI LINK I KECA','3','95863','KANWIL SULAWESI UTARA','system','2015-12-20 15:39:01'),
		('495','406896','24','Sulawesi Utara','277','TONDANO','LAPAS KELAS II B TONDANO','Jalan Papakelan Kec. Tondano Timur','4','95613','KANWIL SULAWESI UTARA','system','2015-12-20 15:39:01'),
		('496','632679','24','Sulawesi Utara','274','MANADO','RUPBASAN KLAS I MANADO','JL. WORI KEL. PANDU, KEC. MAPANGE','2','95251','KANWIL SULAWESI UTARA','system','2015-12-20 15:39:01'),
		('497','497809','24','Sulawesi Utara','274','MANADO','RUTAN KELAS II A MANADO','Jl. CENDRAWASIH, MALENDENG, KEC. TIKALA','1','','KANWIL SULAWESI UTARA','system','2015-12-20 15:39:01'),
		('498','406931','24','Sulawesi Utara','276','TAHUNA','LAPAS KELAS II B TAHUNA','JL. JEND. SUDIRMAN NO. 28','4','95851','KANWIL SULAWESI UTARA','system','2015-12-20 15:39:01'),
		('499','406871','24','Sulawesi Utara','274','MANADO','LAPAS KELAS II A MANADO','JL. HUSNI THAMRIN NO. 52, TUMINTING','4','95239','KANWIL SULAWESI UTARA','system','2015-12-20 15:39:01'),
		('500','652869','24','Sulawesi Utara','278','BITUNG UTARA','LAPAS KELAS II B BITUNG','JL. H. P. KALANGI KEL. TEWAAN','4','','KANWIL SULAWESI UTARA','system','2015-12-20 15:39:01'),
		('501','406953','24','Sulawesi Utara','276','TOMAKO','CABANG RUTAN TAMAKO','JL. DS. POKOL, KEC. TAMAKO','3','','KANWIL SULAWESI UTARA','system','2015-12-20 15:39:01'),
		('502','406962','24','Sulawesi Utara','276','LIRUNG','CABANG RUTAN LIRUNG','JL. DS. LIRUNG, KEC. LIRUNG','3','95871','KANWIL SULAWESI UTARA','system','2015-12-20 15:39:01'),
		('503','406890','24','Sulawesi Utara','350','AMURANG','CABANG RUTAN AMURANG','Jl. Desa Teep Trans Kecamatan Amurang Barat Kabupa','3','95854','KANWIL SULAWESI UTARA','system','2015-12-20 15:39:01'),
		('504','109142','24','Sulawesi Utara','274','MANADO','BAPAS KLAS II MANADO','JL. POMOROW TELING ATAS NO. 106','5','95125','KANWIL SULAWESI UTARA','system','2015-12-20 15:39:01'),
		('505','407013','25','Sulawesi Tengah','250','PARIGI','CABANG RUTAN PARIGI','JL. KUDA LAUT','3','94371','KANWIL SULAWESI TENGAH','system','2015-12-20 15:39:01'),
		('506','632683','25','Sulawesi Tengah','280','PALU','RUPBASAN KLAS I PALU','JL. KEKENTINA NO. 1','2','','KANWIL SULAWESI TENGAH','system','2015-12-20 15:39:01'),
		('507','567890','25','Sulawesi Tengah','280','PALU','RUTAN KELAS II A PALU','JL. BALI NO.1A','1','94125','KANWIL SULAWESI TENGAH','system','2015-12-20 15:39:01'),
		('508','406993','25','Sulawesi Tengah','280','PALU','LAPAS KELAS II A PALU','JL. DEWI SARTIKA NO. 73','4','94114','KANWIL SULAWESI TENGAH','system','2015-12-20 15:39:01'),
		('509','109143','25','Sulawesi Tengah','280','PALU','BAPAS KLAS II PALU','Jln. Dewi Sartika No. 77 ','5','','KANWIL SULAWESI TENGAH','system','2015-12-20 15:39:01'),
		('510','407029','25','Sulawesi Tengah','281','TOLITOLI','LAPAS KELAS II B TOLI-TOLI','JL. DR. SHARJO, SH NO.06 TAMBUN TOLITOLI','4','','KANWIL SULAWESI TENGAH','system','2015-12-20 15:39:01'),
		('511','407041','25','Sulawesi Tengah','282','LUWUK','LAPAS KELAS II B LUWUK','JL. P. KALIMANTAN NO.267, KOTAK POS 107','4','94017','KANWIL SULAWESI TENGAH','system','2015-12-20 15:39:01'),
		('512','626143','25','Sulawesi Tengah','282','LUWUK','BAPAS KLAS II LUWUK','JL. DANAU TONDANO NO.60','5','94713','KANWIL SULAWESI TENGAH','system','2015-12-20 15:39:01'),
		('513','408567','25','Sulawesi Tengah','282','AMPANAN','LAPAS KELAS II B AMPANA','JL. TANDJUMBULU NO. 53','4','94683','KANWIL SULAWESI TENGAH','system','2015-12-20 15:39:01'),
		('514','407066','25','Sulawesi Tengah','283','POSO','RUTAN KELAS II B POSO','JL. P. KALIMANTAN NO. 51','1','94619','KANWIL SULAWESI TENGAH','system','2015-12-20 15:39:01'),
		('515','407060','25','Sulawesi Tengah','283','KOLONEDALE','CABANG RUTAN KOLONEDALE','JL. SAHARJO NO.1','3','94671','KANWIL SULAWESI TENGAH','system','2015-12-20 15:39:01'),
		('516','407004','25','Sulawesi Tengah','284','DONGGALA','RUTAN KELAS II B DONGGALA','JL. BANAWA NO. 214','1','94351','KANWIL SULAWESI TENGAH','system','2015-12-20 15:39:01'),
		('517','407035','25','Sulawesi Tengah','285','LEOK','CABANG RUTAN LEOK','JL. PEMASYARAKATAN, KEC. BIAU','3','94371','KANWIL SULAWESI TENGAH','system','2015-12-20 15:39:01'),
		('518','626122','26','Sulawesi Selatan','286','MAKASSAR','RUPBASAN KLAS I MAKASSAR','JL. RUTAN NO. 2','2','','KANWIL SULAWESI SELATAN','system','2015-12-20 15:39:01'),
		('519','526793','26','Sulawesi Selatan','286','MAKASSAR','RUTAN KELAS I MAKASSAR','Jl. Rutan No.8 Gunung Sari Makassar','1','','KANWIL SULAWESI SELATAN','system','2015-12-20 15:39:01'),
		('520','407081','26','Sulawesi Selatan','286','MAKASSAR','LAPAS KELAS I MAKASSAR','Jalan Sultan Alauddin No.191, Kelurahan Gunung Sar','4','90221','KANWIL SULAWESI SELATAN','system','2015-12-20 15:39:01'),
		('521','407072','26','Sulawesi Selatan','286','MAKASSAR','BAPAS KLAS I MAKASSAR','JL. JEND. HERTASNING NO. 1','5','90222','KANWIL SULAWESI SELATAN','system','2015-12-20 15:39:01'),
		('522','653044','26','Sulawesi Selatan','287','SUNGGUMINASA','LAPAS NARKOTIKA  KELAS II A SUNGGUMINASA','Jalan Lembaga Bolangi Desa Timbusseng Kecamatan Pa','4','92172','KANWIL SULAWESI SELATAN','system','2015-12-20 15:39:01'),
		('523','497821','26','Sulawesi Selatan','287','GOWA','LAPAS WANITA KELAS II A SUNGGUMINASA','JL. LEMBAGA BOLANGI KEL. PATTALASANG','4','92171','KANWIL SULAWESI SELATAN','system','2015-12-20 15:39:01'),
		('524','407236','26','Sulawesi Selatan','288','PANGKAJENE','RUTAN KELAS II B SIDENRENG RAPANG','Jln. Pengayoman - Galung Aserae Sidrap','1','','KANWIL SULAWESI SELATAN','system','2015-12-20 15:39:01'),
		('525','407097','26','Sulawesi Selatan','288','PANGKAJENE','RUTAN KELAS II B PANGKAJENE','JL. Poros Makassar Pare-Pare Kec. Bungoro','1','90611','KANWIL SULAWESI SELATAN','system','2015-12-20 15:39:01'),
		('526','407251','26','Sulawesi Selatan','289','BARRU','RUTAN KELAS II B BARRU','JL. ANDI PANGERANG NO. 34, PETTA RANI','1','90711','KANWIL SULAWESI SELATAN','system','2015-12-20 15:39:01'),
		('527','407117','26','Sulawesi Selatan','290','TAKALAR','LAPAS KELAS II B TAKALAR','JL. RANGGONG DG. ROMO NO. 121','4','92213','KANWIL SULAWESI SELATAN','system','2015-12-20 15:39:01'),
		('528','407101','26','Sulawesi Selatan','291','MAROS','LAPAS KELAS II A MAROS','JL. RAYA KARIANGO KM.3','4','90552','KANWIL SULAWESI SELATAN','system','2015-12-20 15:39:01'),
		('529','407123','26','Sulawesi Selatan','292','JENEPONTO','RUTAN KELAS II B JENEPONTO','JL. MUH. ALI GASSING NO.179','1','92316','KANWIL SULAWESI SELATAN','system','2015-12-20 15:39:01'),
		('530','407211','26','Sulawesi Selatan','293','PARE-PARE','LEMBAGA PEMBINAAN KHUSUS ANAK KELAS II PARE-PARE','JL. ILHAM NO. 3','4','91111','KANWIL SULAWESI SELATAN','system','2015-12-20 15:39:01'),
		('531','407242','26','Sulawesi Selatan','294','ENREKANG','RUTAN KELAS II B ENREKANG','JL. WOLTER MONGONSIDI','1','','KANWIL SULAWESI SELATAN','system','2015-12-20 15:39:01'),
		('532','407230','26','Sulawesi Selatan','296','PINRANG','RUTAN KELAS II B PINRANG','JL. ANDI ABDULLAH NO. 9','1','91211','KANWIL SULAWESI SELATAN','system','2015-12-20 15:39:01'),
		('533','407302','26','Sulawesi Selatan','297','WATAMPONE','LAPAS KELAS II A WATAMPONE','JL. LAKSAMANA YOS SUDARSO KM.4, DS. CELLU','4','92715','KANWIL SULAWESI SELATAN','system','2015-12-20 15:39:01'),
		('534','109144','26','Sulawesi Selatan','297','WATAMPONE','BAPAS KLAS II WATAMPONE','JL. LAKS. YOS SUDARSO KM.5','5','92700','KANWIL SULAWESI SELATAN','system','2015-12-20 15:39:01'),
		('535','407324','26','Sulawesi Selatan','298','WATANSOPPENG','RUTAN KELAS II B WATANSOPPENG','Jalan Pengayoman No. 1','1','','KANWIL SULAWESI SELATAN','system','2015-12-20 15:39:01'),
		('536','407318','26','Sulawesi Selatan','299','SENGKANG','RUTAN KELAS II B SENGKANG','JL. Petta Ulaweng, Dsa Lempa,Kec. Pammana, Kab. Wa','1','90910','KANWIL SULAWESI SELATAN','system','2015-12-20 15:39:01'),
		('537','407148','26','Sulawesi Selatan','300','BANTAENG','RUTAN KELAS II B BANTAENG','JL. MAWAR NO. 9','1','92411','KANWIL SULAWESI SELATAN','system','2015-12-20 15:39:01'),
		('538','407179','26','Sulawesi Selatan','301','SINJAI','RUTAN KELAS II B SINJAI','JL. TEUKU UMAR NO. 3','1','92611','KANWIL SULAWESI SELATAN','system','2015-12-20 15:39:01'),
		('539','407163','26','Sulawesi Selatan','301','MALINO','RUTAN KELAS II B MALINO','Jl. Bakti No. 156 Malino','1','92174','KANWIL SULAWESI SELATAN','system','2015-12-20 15:39:01'),
		('540','407154','26','Sulawesi Selatan','302','BULUKUMBA','LAPAS KELAS II A BULUKUMBA','Jl. Jend. Ahmad Yani No.13','4','92561','KANWIL SULAWESI SELATAN','system','2015-12-20 15:39:01'),
		('541','407132','26','Sulawesi Selatan','303','BENTENG','RUTAN KELAS II B SELAYAR','Jl.Emmy Saelan No.11','1','92812','KANWIL SULAWESI SELATAN','system','2015-12-20 15:39:01'),
		('542','407185','26','Sulawesi Selatan','304','PALOPO','LAPAS KELAS II A PALOPO','JL. DR. SAM RATULANGI KM. 8','4','91914','KANWIL SULAWESI SELATAN','system','2015-12-20 15:39:01'),
		('543','653154','26','Sulawesi Selatan','304','PALOPO','BAPAS KLAS II PALOPO','JL. DR. RATULANGI KM.8','5','','KANWIL SULAWESI SELATAN','system','2015-12-20 15:39:01'),
		('544','653154','26','Sulawesi Selatan','304','PALOPO','BAPAS KLAS II PALOPO','JL. DR. RATULANGI KM.8','5','','KANWIL SULAWESI SELATAN','system','2015-12-20 15:39:01'),
		('545','407282','26','Sulawesi Barat','305','MAMASA,SULAWESI BARAT','CABANG RUTAN MAMASA','Penanian Desa Balla Kec. Balla Kab. Mamasa','3','91362','KANWIL SULAWESI BARAT','system','2015-12-20 15:39:01'),
		('546','407282','26','Sulawesi Barat','305','MAMASA,SULAWESI BARAT','CABANG RUTAN MAMASA','Penanian Desa Balla Kec. Balla Kab. Mamasa','3','91362','KANWIL SULAWESI BARAT','system','2015-12-20 15:39:01'),
		('547','407267','26','Sulawesi Barat','314','MAJENE','RUTAN KELAS II B MAJENE','Jl. Andi Tonra No. 13 Majene','1','','KANWIL SULAWESI BARAT','system','2015-12-20 15:39:01'),
		('548','683423','26','Sulawesi Barat','315','MAMUJU UTARA','RUTAN KELAS II B PASANGKAYU','Jalan Poros Pasangkayu-Palu, Desa Randomayang Kec.','1','91574','KANWIL SULAWESI BARAT','system','2015-12-20 15:39:01'),
		('549','407298','26','Sulawesi Barat','315','MAMUJU KOTA','RUTAN KELAS II B MAMUJU','JL. JEND. A. YANI NO. 19','1','91511','KANWIL SULAWESI BARAT','system','2015-12-20 15:39:01'),
		('550','497883','26','Sulawesi Barat','316','POLEWALI MANDAR','BAPAS KLAS II POLEWALI','Jl. Ammana Pattola No.04','5','91311','KANWIL SULAWESI BARAT','system','2015-12-20 15:39:01'),
		('551','407273','26','Sulawesi Barat','316','POLEWALI MANDAR','LAPAS KELAS II B POLEWALI','Jalan Elang No.28 Pekkabata Kec. Polewali','4','91315','KANWIL SULAWESI BARAT','system','2015-12-20 15:39:01'),
		('552','632513','27','Sulawesi Tenggara','306','KENDARI','RUTAN KELAS II A KENDARI','Jl.R. Suprapto No.112 Kel. Punggolaka Kec. Puuwatu','1','','KANWIL SULAWESI TENGGARA','system','2015-12-20 15:39:01'),
		('553','632700','27','Sulawesi Tenggara','306','KENDARI','RUPBASAN KLAS I KENDARI','Jl. Haluoleo (Kompleks Bumi Praja Anduonohu) Kenda','2','','KANWIL SULAWESI TENGGARA','system','2015-12-20 15:39:01'),
		('554','407333','27','Sulawesi Tenggara','306','KENDARI','LAPAS KELAS II A KENDARI','Jl. Kapten Piere Tendean Baruga','4','93116','KANWIL SULAWESI TENGGARA','system','2015-12-20 15:39:01'),
		('555','109145','27','Sulawesi Tenggara','306','KENDARI','BAPAS KLAS II KENDARI','JL. PASAENO NO. 9','5','','KANWIL SULAWESI TENGGARA','system','2015-12-20 15:39:01'),
		('556','407355','27','Sulawesi Tenggara','307','BAU-BAU','LAPAS KELAS II A BAU-BAU','JL. JEND. SUDIRMAN NO. 66A','4','','KANWIL SULAWESI TENGGARA','system','2015-12-20 15:39:01'),
		('557','653161','27','Sulawesi Tenggara','307','BAU-BAU','BAPAS KLAS II BAU-BAU','JL. SULTAN DAYANU IKHSANUDDIN, BAU-BAU','5','','KANWIL SULAWESI TENGGARA','system','2015-12-20 15:39:01'),
		('558','407349','27','Sulawesi Tenggara','308','RAHA','RUTAN KELAS II B RAHA','JL. JEND. BASUKI RAHMAT NO.10','1','93611','KANWIL SULAWESI TENGGARA','system','2015-12-20 15:39:01'),
		('559','407361','27','Sulawesi Tenggara','309','KOLAKA','RUTAN KELAS II B KOLAKA','Jl. Pendidikan No. 83 Kolaka','1','93517','KANWIL SULAWESI TENGGARA','system','2015-12-20 15:39:01'),
		('560','497815','27','Sulawesi Tenggara','310','UNAAHA','RUTAN KELAS II B UNAAHA','Jl. Pemasyarakatan Desa Lalonggowuna Kec. Tongauna','1','','KANWIL SULAWESI TENGGARA','system','2015-12-20 15:39:01'),
		('561','683771','28','Gorontalo','311','GORONTALO','RUPBASAN KELAS I GORONTALO','Jln. Prof. DR. Mansoer Pateda, Desa Pentadio Timur','2','','KANWIL GORONTALO','system','2015-12-20 15:39:01'),
		('562','653243','28','Gorontalo','311','GORONTALO','BAPAS KLAS II GORONTALO','Jl. Tinaloga No.01 ','5','','KANWIL GORONTALO','system','2015-12-20 15:39:01'),
		('563','406922','28','Gorontalo','311','GORONTALO','LAPAS KELAS II A GORONTALO',' Jln. Katamso, No. 33, Gorontalo','4','96116','KANWIL GORONTALO','system','2015-12-20 15:39:01'),
		('564','497852','28','Gorontalo','313','BOALEMO','LAPAS KELAS II B BOALEMO','JL. PROF.DR. SAMIR RAJIK NUR, SH','4','','KANWIL GORONTALO','system','2015-12-20 15:39:01'),
		('565','684002','28','Gorontalo','351','POHUWATO','LAPAS KELAS III PAHUWATO','Jl. Trans Sulawesi Desa Balayo Kec. Patilanggio Ka','4','','KANWIL GORONTALO','system','2015-12-20 15:39:01'),
		('566','632705','30','Maluku','317','AMBON','RUPBASAN KLAS I AMBON','JL. WAIYARI - SULI','2','','KANWIL MALUKU','system','2015-12-20 15:39:01'),
		('567','407412','30','Maluku','317','NAMLEA','CABANG RUTAN NAMLEA','JL. RAYA JIKUMERASA','3','97571','KANWIL MALUKU','system','2015-12-20 15:39:01'),
		('568','407392','30','Maluku','317','SAPARUA','CABANG RUTAN SAPARUA','JL. LAPANGAN PATTIMURA','3','','KANWIL MALUKU','system','2015-12-20 15:39:01'),
		('569','407421','30','Maluku','317','BANDA NAIRA','CABANG RUTAN BANDANAIRA','JL. DR. MOH. HATTA','3','','KANWIL MALUKU','system','2015-12-20 15:39:01'),
		('570','109146','30','Maluku','317','AMBON','BAPAS KLAS II AMBON','JL. KS. TUBUN, PASSO - BATU BONG','5','','KANWIL MALUKU','system','2015-12-20 15:39:01'),
		('571','407380','30','Maluku','317','AMBON','LAPAS KELAS II A AMBON','JL. LAKSDYA LEO WATTIMENA','4','','KANWIL MALUKU','system','2015-12-20 15:39:01'),
		('572','632527','30','Maluku','317','AMBON','RUTAN KELAS II A AMBON','JL. LAKSDYA LEO WATTIMENA','1','97233','KANWIL MALUKU','system','2015-12-20 15:39:01'),
		('573','407443','30','Maluku','318','WAHAI','CABANG RUTAN WAHAI','JL. YUNUS MAKATITA KECAMATAN SERAM UTARA KABUPATEN','3','','KANWIL MALUKU','system','2015-12-20 15:39:01'),
		('574','407386','30','Maluku','318','PIRU','LAPAS KELAS II B PIRU','JL. KAPUK SERAM BARAT','4','','KANWIL MALUKU','system','2015-12-20 15:39:01'),
		('575','407406','30','Maluku','318','MASOHI','RUTAN KELAS II B MASOHI','JL. DIPONEGORO','1','','KANWIL MALUKU','system','2015-12-20 15:39:01'),
		('576','407468','30','Maluku','319','DOBO','CABANG RUTAN DOBO','JL. Ali Moertopo, Gang Galai Lasi, Kelurahan Galay','3','','KANWIL MALUKU','system','2015-12-20 15:39:01'),
		('577','407437','30','Maluku','319','GESER','CABANG RUTAN GESER','JL. PENDIDIKAN, KECAMATAN SERAM TIMUR, KABUPATEN S','3','97594','KANWIL MALUKU','system','2015-12-20 15:39:01'),
		('578','407474','30','Maluku','319','TUAL','LAPAS KELAS II B TUAL','JL. JENDRAL SUDIRMAN, TUAL','4','97611','KANWIL MALUKU','system','2015-12-20 15:39:01'),
		('579','407483','30','Maluku','320','SAUMLAKI','CABANG RUTAN SAUMLAKI','Jl. Bhayangkara','3','','KANWIL MALUKU','system','2015-12-20 15:39:01'),
		('580','407452','30','Maluku','320','WONRELI','CABANG RUTAN WONRELI','JL. JAWALANG','3','','KANWIL MALUKU','system','2015-12-20 15:39:01'),
		('581','684003','31','Maluku Utara','321','WEDA','RUTAN KELAS II B WEDA','NULL','1','','KANWIL MALUKU UTARA','system','2015-12-20 15:39:01'),
		('582','632712','31','Maluku Utara','321','TERNATE','RUPBASAN KLAS II  TERNATE','JL. PANGYOMAN JAMBULA','2','97700','KANWIL MALUKU UTARA','system','2015-12-20 15:39:01'),
		('583','497840','31','Maluku Utara','321','JAILOLO','LAPAS KELAS II B JAILOLO','JL. BUA-BUA HATE BICARA, KAB HALMAHERA BARAT JAILO','4','97763','KANWIL MALUKU UTARA','system','2015-12-20 15:39:01'),
		('584','652827','31','Maluku Utara','321','TERNATE','LAPAS KELAS II A TERNATE','JALAN PENGAYOMAN KEL. JAMBULA, KEC. PULAU TERNATE','4','','KANWIL MALUKU UTARA','system','2015-12-20 15:39:01'),
		('585','407499','31','Maluku Utara','321','TERNATE','RUTAN KELAS II B TERNATE','JL. Hasan Senen No. 1 Kel. Muhajirin Kec. Kota Ter','1','97713','KANWIL MALUKU UTARA','system','2015-12-20 15:39:01'),
		('586','626161','31','Maluku Utara','321','TERNATE','BAPAS KLAS II TERNATE','JL. MAKUGAWENE','5','97700','KANWIL MALUKU UTARA','system','2015-12-20 15:39:01'),
		('587','109152','31','Maluku Utara','322','TOBELO','LAPAS KELAS II B TOBELLO','JL. GORUA','4','97762','KANWIL MALUKU UTARA','system','2015-12-20 15:39:01'),
		('588','109153','31','Maluku Utara','323','SANANA','LAPAS KELAS II B SANANA','JL. FOGI, KAB. SULA KEPULAUAN SANANA','4','97795','KANWIL MALUKU UTARA','system','2015-12-20 15:39:01'),
		('589','407503','31','Maluku Utara','324','SOA SIU, MALUKU','CABANG RUTAN LABUHA','JL. PULAU LABUHA','3','','KANWIL MALUKU UTARA','system','2015-12-20 15:39:01'),
		('590','531891','31','Maluku Utara','324','SOA SIU, TIDORE','RUTAN KELAS II B SOA SIU','JL. MT. HARYONO, KOTA TIDORE KEPULAUAN','1','97813','KANWIL MALUKU UTARA','system','2015-12-20 15:39:01'),
		('591','683441','33','Papua Barat','325','MANOKWARI','BAPAS KLAS I MANOKWARI','NULL','5','','KANWIL PAPUA BARAT','system','2015-12-20 15:39:01'),
		('592','683437','33','Papua Barat','325','MANOKWARI','RUPBASAN KLAS I MANOKWARI','NULL','2','','KANWIL PAPUA BARAT','system','2015-12-20 15:39:01'),
		('593','407851','33','Papua Barat','325','MANOKWARI','LAPAS KELAS II B MANOKWARI','JL. SABANG NO. 4 KOTAK POS 106','4','98301','KANWIL PAPUA BARAT','system','2015-12-20 15:39:01'),
		('594','683767','33','Papua','325','BINTUNI','RUTAN KELAS II B BINTUNI','NULL','1','','KANWIL PAPUA BARAT','system','2015-12-20 15:39:01'),
		('595','653196','33','Papua Barat','326','SORONG','BAPAS KLAS II SORONG','JL. SAPTA TARUNA KM. 10 KLAWUYUK','5','','KANWIL PAPUA BARAT','system','2015-12-20 15:39:01'),
		('596','407876','33','Papua Barat','326','SORONG','LAPAS KELAS II B SORONG','NULL','4','','KANWIL PAPUA BARAT','system','2015-12-20 15:39:01'),
		('597','407891','33','Papua Barat','327','KAIMANA','CABANG RUTAN KAIMANA','NULL','3','','KANWIL PAPUA BARAT','system','2015-12-20 15:39:01'),
		('598','407882','33','Papua Barat','327','FAK-FAK','LAPAS KELAS II B FAK-FAK','JL. LETJEN S. PARMAN NO.1','4','98601','KANWIL PAPUA BARAT','system','2015-12-20 15:39:01'),
		('599','409233','33','Irian Jaya','327','TANAH MERAH','CABANG RUTAN TANAH MERAH','JL. TRANS IRIAN NO. 60','3','','KANWIL PAPUA','system','2015-12-20 15:39:01'),
		('600','109149','33','Irian Jaya','328','JAYAPURA, PAPUA','BAPAS KLAS II JAYAPURA','JL. RAYA ABEPURA -  KOTARAJA','5','','KANWIL PAPUA','system','2015-12-20 15:39:01'),
		('601','407794','33','Irian Jaya','328','JAYAPURA, PAPUA','LAPAS KELAS II A ABEPURA','JL. KESEHATAN 11','4','999351','KANWIL PAPUA','system','2015-12-20 15:39:01'),
		('602','632751','33','Irian Jaya','328','JAYAPURA, PAPUA','RUPBASAN KLAS I JAYAPURA','JL. KESEHATAN II','2','','KANWIL PAPUA','system','2015-12-20 15:39:01'),
		('603','653051','33','Irian Jaya','328','JAYAPURA','LAPAS NARKOTIKA  KELAS II A JAYAPURA','NULL','4','','KANWIL PAPUA','system','2015-12-20 15:39:01'),
		('604','407808','33','Irian Jaya','329','WAMENA','LAPAS KELAS II B WAMENA','JL. HOM-HOM NO.37','4','99501','KANWIL PAPUA','system','2015-12-20 15:39:01'),
		('605','653201','33','Irian Jaya','330','MERAUKE','BAPAS KLAS II MERAUKE','NULL','5','','KANWIL PAPUA','system','2015-12-20 15:39:01'),
		('606','407845','33','Irian Jaya','330','MERAUKE','LAPAS KELAS II B MERAUKE','Jl. Ermasu No. 18  Kel. Maro Kab. Merauke','4','99616','KANWIL PAPUA','system','2015-12-20 15:39:01'),
		('607','407823','33','Irian Jaya','331','BIAK','LAPAS KLAS II B BIAK','JL. CONDRONEGORO, SAMOFA','4','98117','KANWIL PAPUA','system','2015-12-20 15:39:01'),
		('608','407814','33','Irian Jaya','332','NABIRE','LAPAS KELAS II B NABIRE','JL. PADAT KARYA','4','98801','KANWIL PAPUA','system','2015-12-20 15:39:01'),
		('609','407839','33','Irian Jaya','333','SERUI','LAPAS KELAS II B SERUI','JL. SUMATERA','4','','KANWIL PAPUA','system','2015-12-20 15:39:01'),
		('610','407870','33','Papua Barat','334','TEMINABUHAN','CABANG RUTAN TEMINABUHAN','JL. S. KONJOL NO.3','3','98454','KANWIL PAPUA BARAT','system','2015-12-20 15:39:01'),
		('611','652873','33','Irian Jaya','334','TIMIKA','LAPAS KELAS II B TIMIKA','NULL','4','','KANWIL PAPUA','system','2015-12-20 15:39:01');");

		$this->patching->exe_script("REPLACE INTO proses_alur_perkara (id, alur_perkara_id, tahapan_id, tahapan_nama, proses_id, proses_nama, batas_waktu, satuan, dari_proses_id, nama_tabel_dari, nama_kolom_dari, nama_tabel_ke, nama_kolom_ke, aktif, reminder) 
		VALUES
		(2098, 120, 10, 'Pendaftaran', 10, 'Pendaftaran Perkara', NULL, NULL, NULL, NULL, NULL, 'perkara', 'tanggal_pendaftaran', 'Y', 0),
		(1510, 120, 12, 'Penetapan', 20, 'Penetapan Majelis Hakim/Hakim', 3, '1', 10, 'perkara', 'tanggal_pendaftaran', 'perkara_penetapan', 'penetapan_majelis_hakim', 'Y', 1),
		(1511, 120, 12, 'Penetapan', 21, 'Penetapan Kembali Majelis Hakim/Hakim', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1512, 120, 12, 'Penetapan', 30, 'Penunjukan Panitera Pengganti', 3, '1', 10, 'perkara', 'tanggal_pendaftaran', 'perkara_penetapan', 'penetapan_panitera_pengganti', 'Y', 0),
		(1513, 120, 12, 'Penetapan', 31, 'Penunjukan Kembali Panitera Pengganti', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1514, 120, 12, 'Penetapan', 40, 'Penunjukan Jurusita', NULL, NULL, NULL, NULL, NULL, 'perkara_penetapan', 'penetapan_jurusita', 'Y', 0),
		(1515, 120, 12, 'Penetapan', 41, 'Penunjukan Kembali Jurusita', NULL, NULL, NULL, NULL,NULL, NULL, NULL, 'Y', 0),
		(1516, 120, 12, 'Penetapan', 80, 'Penetapan Hari Sidang Pertama', 7, '1', 20, 'perkara_penetapan', 'penetapan_majelis_hakim', 'perkara_penetapan', 'penetapan_hari_sidang', 'Y', 1),
		(1517, 120, 12, 'Penetapan', 81, 'Sidang pertama', NULL, NULL, NULL, NULL, NULL, 'perkara_penetapan', 'sidang_pertama', 'Y', 0),
		(1518, 120, 14, 'Persidangan', 200, 'Persidangan', NULL, '', NULL, NULL, NULL, '', '', 'Y', 0),
		(1519, 120, 15, 'Putusan', 210, 'Putusan', 5, '3', 10, 'perkara', 'tanggal_pendaftaran', 'perkara_putusan', 'tanggal_putusan', 'Y', 1),
		(1520, 120, 15, 'Putusan', 218, 'Pemberitahuan Putusan', NULL, NULL, NULL, NULL, NULL, 'perkara_putusan', 'pemberitahuan_putusan', 'Y', 0),
		(1521, 120, 15, 'Putusan', 219, 'Kirim Salinan Putusan', NULL, NULL, NULL, NULL, NULL, 'perkara_putusan', 'kirim_salinan_putusan_penyidik', 'Y', 0),
		(1522, 120, 15, 'Putusan', 220, 'Pembuatan Minutasi', 14, '1', 210, 'perkara_putusan', 'tanggal_putusan', 'perkara_putusan', 'tanggal_minutasi', 'Y', 1),
		(1523, 120, 20, 'Banding', 290, 'Permohonan Banding', 14, '1', 210, 'perkara_putusan', 'tanggal_putusan', 'perkara_banding', 'permohonan_banding', 'Y', 0),
		(1524, 120, 20, 'Banding', 300, 'Pemberitahuan Permohonan Banding', 7, '1', 290, 'perkara_banding', 'permohonan_banding', 'perkara_banding', 'pemberitahuan_permohonan_banding', 'Y', 1),
		(1525, 120, 20, 'Banding', 310, 'Penerimaan Memori Banding', 0, '', NULL, NULL, NULL, 'perkara_banding', 'penerimaan_memori_banding', 'Y', 1),
		(1526, 120, 20, 'Banding', 320, 'Penyerahan Memori Banding', NULL, NULL, NULL, NULL, NULL, 'perkara_banding', 'penyerahan_memori_banding', 'Y', 0),
		(1527, 120, 20, 'Banding', 330, 'Penerimaan Kontra Memori Banding', 0, '', NULL, NULL, NULL, 'perkara_banding', 'penerimaan_kontra_banding', 'Y', 1),
		(1528, 120, 20, 'Banding', 340, 'Penyerahan Kontra Memori Banding', NULL, NULL, NULL, NULL, NULL, 'perkara_banding', 'penyerahan_kontra_banding', 'Y', 0),
		(1529, 120, 20, 'Banding', 350, 'Permberitahuan Untuk Memeriksa Berkas(Inzage)', 0, '', NULL, NULL, NULL, 'perkara_banding_detil', 'pemberitahuan_inzage', 'Y', 1),
		(1530, 120, 20, 'Banding', 360, 'Pelaksanaan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_banding_detil', 'pemberitahuan_inzage', 'Y', 0),
		(1531, 120, 20, 'Banding', 370, 'Pengiriman Berkas  Banding', 30, '2', 290, 'perkara_banding', 'permohonan_banding', 'perkara_banding', 'pengiriman_berkas_banding', 'Y', 1),
		(1532, 120, 20, 'Banding', 380, 'Penerimaan Kembali Berkas Banding', NULL, NULL, NULL, NULL, NULL, 'perkara_banding', 'penerimaan_kembali_berkas_banding', 'Y', 0),
		(1533, 120, 20, 'Banding', 390, 'Putusan Banding', 3, '3', 290, 'perkara_banding', 'permohonan_banding', 'perkara_banding', 'putusan_banding', 'Y', 1),
		(1534, 120, 20, 'Banding', 391, 'Pencabutan Perkara Banding', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'T', 0),
		(1535, 120, 20, 'Banding', 400, 'Pemberitahuan Putusan Banding', 2, '1', 390, 'perkara_banding', 'putusan_banding', 'perkara_banding', 'pemberitahuan_putusan_banding', 'Y', 1),
		(1536, 120, 30, 'Kasasi', 410, 'Permohonan Kasasi', 14, '2', 400, 'perkara_banding', 'pemberitahuan_putusan_banding', 'perkara_kasasi', 'permohonan_kasasi', 'Y', 0),
		(1537, 120, 30, 'Kasasi', 420, 'Pemberitahuan Permohonan Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pemberitahuan_kasasi', 'Y', 0),
		(1538, 120, 30, 'Kasasi', 430, 'Penerimaan Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_memori_kasasi', 'Y', 0),
		(1539, 120, 30, 'Kasasi', 440, 'Penyerahan Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penyerahan_memori_kasasi', 'Y', 0),
		(1540, 120, 30, 'Kasasi', 450, 'Penerimaan Kontra Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_kontra_kasasi', 'Y', 0),
		(1541, 120, 30, 'Kasasi', 460, 'Penyerahan Kontra Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penyerahan_kontra_kasasi', 'Y', 0),
		(1542, 120, 30, 'Kasasi', 461, 'Permberitahuan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pemberitahuan_inzage_pemohon_kasasi', 'Y', 0),
		(1543, 120, 30, 'Kasasi', 464, 'Pelaksanaan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pelaksanaan_inzage_termohon_kasasi', 'Y', 0),
		(1544, 120, 30, 'Kasasi', 470, 'Pengiriman Berkas Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pengiriman_berkas_kasasi', 'Y', 0),
		(1545, 120, 30, 'Kasasi', 480, 'Penerimaan Kembali Berkas Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_berkas_kasasi', 'Y', 0),
		(1546, 120, 30, 'Kasasi', 490, 'Putusan Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'putusan_kasasi', 'Y', 0),
		(1547, 120, 30, 'Kasasi', 500, 'Pemberitahuan Putus Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pemberitahuan_putusan_kasasi', 'Y', 0),
		(1548, 120, 40, 'Peninjauan Kembali', 510, 'Permohonan PK', 14, '1', 500, 'perkara_kasasi', 'pemberitahuan_putusan_kasasi', 'perkara_pk', 'permohonan_pk', 'Y', 0),
		(1549, 120, 40, 'Peninjauan Kembali', 520, 'Pemberitahuan PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'pemberitahuan_pk', 'Y', 0),
		(1550, 120, 40, 'Peninjauan Kembali', 521, 'Penerimaan Memori PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_memori_pk', 'Y', 0),
		(1551, 120, 40, 'Peninjauan Kembali', 522, 'Penyerahan Memori PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penyerahan_memori_pk', 'Y', 0),
		(1552, 120, 40, 'Peninjauan Kembali', 530, 'Penerimaan Jawaban PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_kontra_pk', 'Y', 0),
		(1553, 120, 40, 'Peninjauan Kembali', 540, 'Penyerahan Jawaban PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penyerahan_kontra_pk', 'Y', 0),
		(1554, 120, 40, 'Peninjauan Kembali', 550, 'Pengiriman Berkas PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'pengiriman_berkas_pk', 'Y', 0),
		(1555, 120, 40, 'Peninjauan Kembali', 560, 'Penerimaan Kembali Berkas PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_berkas_pk', 'Y', 0),
		(1556, 120, 40, 'Peninjauan Kembali', 570, 'Putusan PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'putusan_pk', 'Y', 0),
		(1557, 120, 40, 'Peninjauan Kembali', 571, 'Pemberitahuan Putusan PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'pemberitahuan_putusan_pk', 'Y', 0),
		(1558, 120, 60, 'Grasi', 650, 'Permohonan Grasi PN', NULL, NULL, NULL, NULL, NULL, 'perkara_grasi', 'permohonan_grasi', 'Y', 0),
		(1559, 120, 60, 'Grasi', 660, 'Pengiriman salinan permohonan grasi berikut berkas putusan dari PN ke Kejaksaan', 7, '1', 650, 'perkara_grasi', 'permohonan_grasi', 'perkara_grasi', 'pengiriman_berkas_grasi_ke_kejaksaan', 'Y', 1),
		(1560, 120, 60, 'Grasi', 662, 'Pengiriman salinan permohonan grasi berikut berkas putusan ke MA', NULL, NULL, NULL, NULL, NULL, 'perkara_grasi', 'pengiriman_berkas_grasi_ke_kejaksaan', 'Y', 0),
		(1561, 120, 60, 'Grasi', 665, 'Pengiriman pertimbangan berikut berkas perkara dari MA ke Presiden', NULL, NULL, NULL, NULL, NULL, 'perkara_grasi', 'pengiriman_pertimbangan_hakim_grasi', 'Y', 0),
		(1562, 120, 60, 'Grasi', 670, 'Penerimaan Kembali Berkas Grasi', NULL, NULL, NULL, NULL, NULL, 'perkara_grasi', 'tanggal_penerimaan_kembali_berkas_grasi', 'Y', 0),
		(1563, 120, 60, 'Grasi', 680, 'Putusan Grasi', NULL, NULL, NULL, NULL, NULL, 'perkara_grasi', 'tanggal_putusan_grasi', 'Y', 0),
		(1564, 120, 60, 'Grasi', 690, 'Pemberitahuan Putusan Grasi', NULL, NULL, NULL, NULL, NULL, 'perkara_grasi', 'pemberitahuan_putusan_grasi', 'Y', 0),
		(1565, 120, 60, 'Grasi', 700, 'Pemberitahuan Tembusan Putusan Grasi', NULL, NULL, NULL, NULL, NULL, 'perkara_grasi', 'pemberitahuan_tembusan_grasi', 'Y', 0),
		(1566, 121, 10, 'Pendaftaran', 10, 'Pendaftaran Perkara', NULL, NULL, NULL, NULL, NULL, 'perkara', 'tanggal_pendaftaran', 'Y', 0),
		(1567, 121, 12, 'Penetapan', 20, 'Penetapan Majelis Hakim/Hakim', 3, '1', 10, 'perkara', 'tanggal_pendaftaran', 'perkara_penetapan', 'penetapan_majelis_hakim', 'Y', 1),
		(1568, 121, 12, 'Penetapan', 21, 'Penetapan Kembali Majelis Hakim/Hakim', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1569, 121, 12, 'Penetapan', 30, 'Penunjukan Panitera Pengganti', 3, '1', 10, 'perkara', 'tanggal_pendaftaran', 'perkara_penetapan', 'penetapan_panitera_pengganti', 'Y', 0),
		(1570, 121, 12, 'Penetapan', 31, 'Penunjukan Kembali Panitera Pengganti', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1571, 121, 12, 'Penetapan', 40, 'Penunjukan Jurusita', NULL, NULL, NULL, NULL, NULL, 'perkara_penetapan', 'penetapan_jurusita', 'Y', 0),
		(1572, 121, 12, 'Penetapan', 41, 'Penunjukan Kembali Jurusita', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1573, 121, 12, 'Penetapan', 80, 'Penetapan Hari Sidang Pertama', 7, '1', 20, 'perkara_penetapan', 'penetapan_majelis_hakim', 'perkara_penetapan', 'penetapan_hari_sidang', 'Y', 1),
		(1574, 121, 12, 'Penetapan', 81, 'Sidang pertama', NULL, NULL, NULL, NULL, NULL, 'perkara_penetapan', 'sidang_pertama', 'Y', 0),
		(1575, 121, 14, 'Persidangan', 200, 'Persidangan', NULL, '', NULL, NULL, NULL, '', '', 'Y', 0),
		(1576, 121, 15, 'Putusan', 210, 'Putusan', 5, '3', 10, 'perkara', 'tanggal_pendaftaran', 'perkara_putusan', 'tanggal_putusan', 'Y', 1),
		(1577, 121, 15, 'Putusan', 218, 'Pemberitahuan Putusan', NULL, NULL, NULL, NULL, NULL, 'perkara_putusan', 'pemberitahuan_putusan', 'Y', 0),
		(1578, 121, 15, 'Putusan', 219, 'Kirim Salinan Putusan', NULL, NULL, NULL, NULL, NULL, 'perkara_putusan', 'kirim_salinan_putusan_penyidik', 'Y', 0),
		(1579, 121, 15, 'Putusan', 220, 'Pembuatan Minutasi', 14, '1', 210, 'perkara_putusan', 'tanggal_putusan', 'perkara_putusan', 'tanggal_minutasi', 'Y', 1),
		(1580, 121, 20, 'Banding', 290, 'Permohonan Banding', 14, '1', 210, 'perkara_putusan', 'tanggal_putusan', 'perkara_banding', 'permohonan_banding', 'Y', 0),
		(1581, 121, 20, 'Banding', 300, 'Pemberitahuan Permohonan Banding', 7, '1', 290, 'perkara_banding', 'permohonan_banding', 'perkara_banding', 'pemberitahuan_permohonan_banding', 'Y', 1),
		(1582, 121, 20, 'Banding', 310, 'Penerimaan Memori Banding', 0, '', NULL, NULL, NULL, 'perkara_banding', 'penerimaan_memori_banding', 'Y', 1),
		(1583, 121, 20, 'Banding', 320, 'Penyerahan Memori Banding', NULL, NULL, NULL, NULL, NULL, 'perkara_banding', 'penyerahan_memori_banding', 'Y', 0),
		(1584, 121, 20, 'Banding', 330, 'Penerimaan Kontra Memori Banding', 0, '', NULL, NULL, NULL, 'perkara_banding', 'penerimaan_kontra_banding', 'Y', 1),
		(1585, 121, 20, 'Banding', 340, 'Penyerahan Kontra Memori Banding', NULL, NULL, NULL, NULL, NULL, 'perkara_banding', 'penyerahan_kontra_banding', 'Y', 0),
		(1586, 121, 20, 'Banding', 350, 'Permberitahuan Untuk Memeriksa Berkas(Inzage)', 0, '', NULL, NULL, NULL, 'perkara_banding_detil', 'pemberitahuan_inzage', 'Y', 1),
		(1587, 121, 20, 'Banding', 360, 'Pelaksanaan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_banding_detil', 'pemberitahuan_inzage', 'Y', 0),
		(1588, 121, 20, 'Banding', 370, 'Pengiriman Berkas  Banding', 30, '2', 290, 'perkara_banding', 'permohonan_banding', 'perkara_banding', 'pengiriman_berkas_banding', 'Y', 1),
		(1589, 121, 20, 'Banding', 380, 'Penerimaan Kembali Berkas Banding', NULL, NULL, NULL, NULL, NULL, 'perkara_banding', 'penerimaan_kembali_berkas_banding', 'Y', 0),
		(1590, 121, 20, 'Banding', 390, 'Putusan Banding', 3, '3', 290, 'perkara_banding', 'permohonan_banding', 'perkara_banding', 'putusan_banding', 'Y', 1),
		(1591, 121, 20, 'Banding', 391, 'Pencabutan Perkara Banding', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'T', 0),
		(1592, 121, 20, 'Banding', 400, 'Pemberitahuan Putusan Banding', 2, '1', 390, 'perkara_banding', 'putusan_banding', 'perkara_banding', 'pemberitahuan_putusan_banding', 'Y', 1),
		(1593, 121, 30, 'Kasasi', 410, 'Permohonan Kasasi', 14, '2', 400, 'perkara_banding', 'pemberitahuan_putusan_banding', 'perkara_kasasi', 'permohonan_kasasi', 'Y', 0),
		(1594, 121, 30, 'Kasasi', 420, 'Pemberitahuan Permohonan Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pemberitahuan_kasasi', 'Y', 0),
		(1595, 121, 30, 'Kasasi', 430, 'Penerimaan Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_memori_kasasi', 'Y', 0),
		(1596, 121, 30, 'Kasasi', 440, 'Penyerahan Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penyerahan_memori_kasasi', 'Y', 0),
		(1597, 121, 30, 'Kasasi', 450, 'Penerimaan Kontra Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_kontra_kasasi', 'Y', 0),
		(1598, 121, 30, 'Kasasi', 460, 'Penyerahan Kontra Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penyerahan_kontra_kasasi', 'Y', 0),
		(1599, 121, 30, 'Kasasi', 461, 'Permberitahuan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pemberitahuan_inzage_pemohon_kasasi', 'Y', 0),
		(1600, 121, 30, 'Kasasi', 464, 'Pelaksanaan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pelaksanaan_inzage_termohon_kasasi', 'Y', 0),
		(1601, 121, 30, 'Kasasi', 470, 'Pengiriman Berkas Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pengiriman_berkas_kasasi', 'Y', 0),
		(1602, 121, 30, 'Kasasi', 480, 'Penerimaan Kembali Berkas Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_berkas_kasasi', 'Y', 0),
		(1603, 121, 30, 'Kasasi', 490, 'Putusan Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'putusan_kasasi', 'Y', 0),
		(1604, 121, 30, 'Kasasi', 500, 'Pemberitahuan Putus Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pemberitahuan_putusan_kasasi', 'Y', 0),
		(1605, 121, 40, 'Peninjauan Kembali', 510, 'Permohonan PK', 14, '1', 500, 'perkara_kasasi', 'pemberitahuan_putusan_kasasi','perkara_pk', 'permohonan_pk', 'Y', 0),
		(1606, 121, 40, 'Peninjauan Kembali', 520, 'Pemberitahuan PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'pemberitahuan_pk', 'Y', 0),
		(1607, 121, 40, 'Peninjauan Kembali', 521, 'Penerimaan Memori PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_memori_pk', 'Y', 0),
		(1608, 121, 40, 'Peninjauan Kembali', 522, 'Penyerahan Memori PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penyerahan_memori_pk', 'Y', 0),
		(1609, 121, 40, 'Peninjauan Kembali', 530, 'Penerimaan Jawaban PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_kontra_pk', 'Y', 0),
		(1610, 121, 40, 'Peninjauan Kembali', 540, 'Penyerahan Jawaban PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penyerahan_kontra_pk', 'Y', 0),
		(1611, 121, 40, 'Peninjauan Kembali', 550, 'Pengiriman Berkas PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'pengiriman_berkas_pk', 'Y', 0),
		(1612, 121, 40, 'Peninjauan Kembali', 560, 'Penerimaan Kembali Berkas PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_berkas_pk', 'Y', 0),
		(1613, 121, 40, 'Peninjauan Kembali', 570, 'Putusan PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'putusan_pk', 'Y', 0),
		(1614, 121, 40, 'Peninjauan Kembali', 571, 'Pemberitahuan Putusan PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'pemberitahuan_putusan_pk', 'Y', 0),
		(1615, 121, 60, 'Grasi', 650, 'Permohonan Grasi PN', NULL, NULL, NULL, NULL, NULL, 'perkara_grasi', 'permohonan_grasi', 'Y', 0),
		(1616, 121, 60, 'Grasi', 660, 'Pengiriman salinan permohonan grasi berikut berkas putusan dari PN ke Kejaksaan', 7, '1', 650, 'perkara_grasi', 'permohonan_grasi', 'perkara_grasi', 'pengiriman_berkas_grasi_ke_kejaksaan', 'Y', 1),
		(1617, 121, 60, 'Grasi', 662, 'Pengiriman salinan permohonan grasi berikut berkas putusan ke MA', NULL, NULL, NULL, NULL, NULL, 'perkara_grasi', 'pengiriman_berkas_grasi_ke_kejaksaan', 'Y', 0),
		(1618, 121, 60, 'Grasi', 665, 'Pengiriman pertimbangan berikut berkas perkara dari MA ke Presiden', NULL, NULL, NULL, NULL, NULL, 'perkara_grasi', 'pengiriman_pertimbangan_hakim_grasi', 'Y', 0),
		(1619, 121, 60, 'Grasi', 670, 'Penerimaan Kembali Berkas Grasi', NULL, NULL, NULL, NULL, NULL, 'perkara_grasi', 'tanggal_penerimaan_kembali_berkas_grasi', 'Y', 0),
		(1620, 121, 60, 'Grasi', 680, 'Putusan Grasi', NULL, NULL, NULL, NULL, NULL, 'perkara_grasi', 'tanggal_putusan_grasi', 'Y', 0),
		(1621, 121, 60, 'Grasi', 690, 'Pemberitahuan Putusan Grasi', NULL, NULL, NULL, NULL, NULL, 'perkara_grasi', 'pemberitahuan_putusan_grasi', 'Y', 0),
		(1622, 121, 60, 'Grasi', 700, 'Pemberitahuan Tembusan Putusan Grasi', NULL, NULL, NULL, NULL, NULL, 'perkara_grasi', 'pemberitahuan_tembusan_grasi', 'Y', 0),
		(1623, 9, 10, 'Pendaftaran', 10, 'Pendaftaran Perkara', NULL, '', NULL, '', 'tanggal_pendaftaran', 'perkara', 'tanggal_pendaftaran', 'Y', 0),
		(1632, 9, 12, 'Penetapan', 15, 'Panggilan Para Pihak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1633, 9, 12, 'Penetapan', 16, 'Penetapan Dismissal Diterima', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1634, 9, 15, 'Putusan', 17, 'Putusan Perlawanan Diterima', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1624, 9, 12, 'Penetapan', 20, 'Penetapan Majelis Hakim/Hakim', 3, '1', 10, 'perkara', 'tanggal_pendaftaran', 'perkara_penetapan', 'penetapan_majelis_hakim', 'Y', 1),
		(1625, 9, 12, 'Penetapan', 21, 'Penetapan Kembali Majelis Hakim/Hakim', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1626, 9, 12, 'Penetapan', 30, 'Penunjukan Panitera Pengganti', 3, '1', 10, 'perkara', 'tanggal_pendaftaran', 'perkara_penetapan', 'penetapan_panitera_pengganti', 'Y', 0),
		(1627, 9, 12, 'Penetapan', 31, 'Penunjukan Kembali Panitera Pengganti', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1628, 9, 12, 'Penetapan', 40, 'Penunjukan Jurusita', NULL, NULL, NULL, NULL, NULL, 'perkara_penetapan', 'penetapan_jurusita', 'Y', 0),
		(1629, 9, 12, 'Penetapan', 41, 'Penunjukan Kembali Jurusita', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1630, 9, 12, 'Penetapan', 80, 'Penetapan Hari Sidang Pertama', 3, '1', 20, 'perkara_penetapan', 'penetapan_majelis_hakim', 'perkara_penetapan', 'penetapan_hari_sidang', 'Y', 1),
		(1631, 9, 12, 'Penetapan', 81, 'Sidang pertama', NULL, '', NULL, '', 'penetapan_panitera_pengganti', 'perkara_penetapan', 'sidang_pertama', 'Y', 0),
		(1648, 9, 13, 'Perlawanan', 110, 'Pendaftaran Perlawanan', NULL, '', NULL, '', '', '', '', 'Y', 0),
		(1649, 9, 13, 'Perlawanan', 111, 'Penetapan Majelis Hakim Perlawanan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1650, 9, 13, 'Perlawanan', 112, 'Penetapan Panitera Pengganti Perlawanan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1651, 9, 13, 'Perlawanan', 113, 'Penetapan Jurusita Perlawanan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1652, 9, 13, 'Perlawanan', 114, 'Penetapan Jadwal Sidang Perlawanan', NULL, NULL, NULL, NULL, NULL, 'perkara_verzet', 'tanggal_penetapan_sidang_verzet', 'Y', 0),
		(1653, 9, 13, 'Perlawanan', 115, 'Sidang Pertama Perlawanan', NULL, NULL, NULL, NULL, NULL, 'perkara_verzet', 'tanggal_sidang_pertama_verzet', 'Y', 0),
		(1642, 9, 14, 'Persidangan', 200, 'Persidangan', NULL, '', NULL, '', '', '', '', 'Y', 1),
		(1643, 9, 15, 'Putusan', 210, 'Putusan', 5, '3', 10, 'perkara', 'tanggal_pendaftaran', 'perkara_putusan', 'tanggal_putusan', 'Y', 1),
		(1644, 9, 15, 'Putusan', 211, 'Pencabutan Perkara', NULL, NULL, NULL, NULL, NULL, 'perkara_putusan', 'tanggal_cabut', 'Y', 0),
		(1645, 9, 15, 'Putusan', 212, 'Pernyataan Gugur', NULL, NULL, NULL, NULL, NULL, 'perkara_putusan', 'tanggal_gugur', 'Y', 0),
		(1635, 9, 15, 'Putusan', 214, 'Dismissal Ditolak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1646, 9, 15, 'Putusan', 218, 'Pemberitahuan Putusan', NULL, NULL, NULL, NULL, NULL, 'perkara_putusan', 'pemberitahuan_putusan', 'Y', 0),
		(1647, 9, 15, 'Putusan', 220, 'Pembuatan Minutasi', 14, '2', 210, 'perkara_putusan', 'tanggal_putusan', 'perkara_putusan', 'tanggal_minutasi', 'Y', 1),
		(1655, 9, 15, 'Putusan', 217, 'Putusan Perlawanan Ditolak', NULL, NULL, NULL, NULL, NULL, 'perkara_verzet', 'putusan_verzet', 'Y', 0),
		(1657, 9, 20, 'Banding', 290, 'Permohonan Banding', 14, '1', 210, 'perkara_putusan', 'tanggal_putusan', 'perkara_banding', 'permohonan_banding', 'Y', 0),
		(1658, 9, 20, 'Banding', 300, 'Pemberitahuan Permohonan Banding', 7, '2', 290, 'perkara_banding', 'permohonan_banding', 'perkara_banding', 'pemberitahuan_permohonan_banding', 'Y', 1),
		(1659, 9, 20, 'Banding', 310, 'Penerimaan Memori Banding', 0, '', NULL, NULL, NULL, 'perkara_banding', 'penerimaan_memori_banding', 'Y', 1),
		(1660, 9, 20, 'Banding', 320, 'Penyerahan Memori Banding', NULL, NULL, NULL, NULL, NULL, 'perkara_banding', 'penyerahan_memori_banding', 'Y', 0),
		(1661, 9, 20, 'Banding', 330, 'Penerimaan Kontra Memori Banding', 0, '', NULL, NULL, NULL, 'perkara_banding', 'penerimaan_kontra_banding', 'Y', 1),
		(1662, 9, 20, 'Banding', 340, 'Penyerahan Kontra Memori Banding', NULL, NULL, NULL, NULL, NULL, 'perkara_banding', 'penyerahan_kontra_banding', 'Y', 0),
		(1663, 9, 20, 'Banding', 350, 'Permberitahuan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_banding_detil', 'pemberitahuan_inzage', 'Y', 0),
		(1664, 9, 20, 'Banding', 360, 'Pelaksanaan Untuk Memeriksa Berkas(Inzage)', NULL, '', NULL, NULL, NULL, 'perkara_banding_detil', 'pelaksanaan_inzage', 'Y', 0),
		(1665, 9, 20, 'Banding', 370, 'Pengiriman Berkas  Banding', 30, '2', 290, 'perkara_banding', 'permohonan_banding', 'perkara_banding', 'pengiriman_berkas_banding', 'Y', 1),
		(1667, 9, 20, 'Banding', 380, 'Penerimaan Kembali Berkas Banding', NULL, NULL, NULL, NULL, NULL, 'perkara_banding', 'penerimaan_kembali_berkas_banding', 'Y', 0),
		(1668, 9, 20, 'Banding', 390, 'Putusan Banding', 3, '3', 290, 'perkara_banding', 'permohonan_banding', 'perkara_banding', 'putusan_banding', 'Y', 1),
		(1669, 9, 20, 'Banding', 391, 'Pencabutan Perkara Banding', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'T', 0),
		(1670, 9, 20, 'Banding', 400, 'Pemberitahuan Putusan Banding', 14, '2', 390, 'perkara_banding', 'putusan_banding', 'perkara_banding', 'pemberitahuan_putusan_banding', 'Y', 1),
		(1671, 9, 30, 'Kasasi', 410, 'Permohonan Kasasi', 14, '2', 400, 'perkara_banding', 'pemberitahuan_putusan_banding', 'perkara_kasasi', 'permohonan_kasasi', 'Y', 0),
		(1672, 9, 30, 'Kasasi', 420, 'Pemberitahuan Permohonan Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pemberitahuan_kasasi', 'Y', 0),
		(1673, 9, 30, 'Kasasi', 430, 'Penerimaan Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_memori_kasasi', 'Y', 0),
		(1674, 9, 30, 'Kasasi', 440, 'Penyerahan Memori Kasasi', 14, '2', 410, 'perkara_kasasi', 'permohonan_kasasi', 'perkara_kasasi', 'penyerahan_memori_kasasi', 'Y', 1),
		(1675, 9, 30, 'Kasasi', 450, 'Penerimaan Kontra Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_kontra_kasasi', 'Y', 0),
		(1676, 9, 30, 'Kasasi', 460, 'Penyerahan Kontra Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penyerahan_kontra_kasasi', 'Y', 0),
		(1677, 9, 30, 'Kasasi', 461, 'Permberitahuan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pemberitahuan_inzage_pemohon_kasasi', 'Y', 0),
		(1678, 9, 30, 'Kasasi', 464, 'Pelaksanaan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pelaksanaan_inzage_termohon_kasasi', 'Y', 0),
		(1679, 9, 30, 'Kasasi', 470, 'Pengiriman Berkas Kasasi', 65, '2', 410, 'perkara_kasasi', 'permohonan_kasasi', 'perkara_kasasi', 'pengiriman_berkas_kasasi', 'Y', 1),
		(1680, 9, 30, 'Kasasi', 480, 'Penerimaan Kembali Berkas Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_berkas_kasasi', 'Y', 0),
		(1681, 9, 30, 'Kasasi', 490, 'Putusan Kasasi', 6, '3', 410, 'perkara_kasasi', 'permohonan_kasasi', 'perkara_kasasi', 'putusan_kasasi', 'Y', 1),
		(1682, 9, 30, 'Kasasi', 500, 'Pemberitahuan Putus Kasasi', 30, '2', 490, 'perkara_kasasi', 'putusan_kasasi', 'perkara_kasasi', 'pemberitahuan_putusan_kasasi', 'Y', 1),
		(1683, 9, 40, 'Peninjauan Kembali', 510, 'Permohonan PK', NULL, '', NULL, '', 'pemberitahuan_putusan_kasasi', 'perkara_pk', 'permohonan_pk', 'Y', 0),
		(1684, 9, 40, 'Peninjauan Kembali', 520, 'Pemberitahuan PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'pemberitahuan_pk', 'Y', 0),
		(1685, 9, 40, 'Peninjauan Kembali', 521, 'Penerimaan Memori PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_memori_pk', 'Y', 0),
		(1686, 9, 40, 'Peninjauan Kembali', 522, 'Penyerahan Memori PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penyerahan_memori_pk', 'Y', 0),
		(1687, 9, 40, 'Peninjauan Kembali', 530, 'Penerimaan Jawaban PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_kontra_pk', 'Y', 0),
		(1688, 9, 40, 'Peninjauan Kembali', 540, 'Penyerahan Jawaban PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penyerahan_kontra_pk', 'Y', 0),
		(1689, 9, 40, 'Peninjauan Kembali', 550, 'Pengiriman Berkas PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'pengiriman_berkas_pk', 'Y', 0),
		(1689, 9, 40, 'Peninjauan Kembali', 560, 'Penerimaan Kembali Berkas PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_berkas_pk', 'Y', 0),
		(1690, 9, 40, 'Peninjauan Kembali', 570, 'Putusan PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'putusan_pk', 'Y', 0),
		(1691, 9, 40, 'Peninjauan Kembali', 571, 'Pemberitahuan Putusan PK', 30, '2', 570, 'perkara_pk', 'putusan_pk', 'perkara_pk', 'pemberitahuan_putusan_pk', 'Y', 1),
		(1692, 9, 50, 'Eksekusi', 600, 'Permohonan Eksekusi', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'permohonan_eksekusi', 'Y', 0),
		(1693, 9, 50, 'Eksekusi', 605, 'Penetapan Teguran Eksekusi', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_teguran_eksekusi', 'Y', 0),
		(1694, 9, 50, 'Eksekusi', 610, 'Pelaksaan Penegoran(Aanmaning)', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'pelaksanaan_teguran_eksekusi', 'Y', 0),
		(1695, 9, 50, 'Eksekusi', 615, 'Penetapan Sita Eksekusi', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_sita_eksekusi', 'Y', 0),
		(1695, 9, 50, 'Eksekusi', 620, 'Pelaksanaan Sita Eksekusi', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_sita_eksekusi', 'Y', 0),
		(1703, 10, 10, 'Pendaftaran', 10, 'Pendaftaran Perkara', NULL, '', NULL, '', 'tanggal_pendaftaran', 'perkara', 'tanggal_pendaftaran', 'Y', 0),
		(1704, 10, 12, 'Penetapan', 20, 'Penetapan Majelis Hakim/Hakim', 3, '1', 10, 'perkara', 'tanggal_pendaftaran', 'perkara_penetapan', 'penetapan_majelis_hakim', 'Y', 1),
		(1705, 10, 12, 'Penetapan', 21, 'Penetapan Kembali Majelis Hakim/Hakim', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1706, 10, 12, 'Penetapan', 30, 'Penunjukan Panitera Pengganti', 3, '1', 10, 'perkara', 'tanggal_pendaftaran', 'perkara_penetapan', 'penetapan_panitera_pengganti', 'Y', 0),
		(1707, 10, 12, 'Penetapan', 31, 'Penunjukan Kembali Panitera Pengganti', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1708, 10, 12, 'Penetapan', 40, 'Penunjukan Jurusita', NULL, NULL, NULL, NULL, NULL, 'perkara_penetapan', 'penetapan_jurusita', 'Y', 0),
		(1709, 10, 12, 'Penetapan', 41, 'Penunjukan Kembali Jurusita', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1710, 10, 12, 'Penetapan', 80, 'Penetapan Hari Sidang Pertama', 3, '1', 20, 'perkara_penetapan', 'penetapan_majelis_hakim', 'perkara_penetapan', 'penetapan_hari_sidang', 'Y', 1),
		(1709, 10, 12, 'Penetapan', 81, 'Sidang pertama', NULL, '', NULL, '', 'penetapan_panitera_pengganti', 'perkara_penetapan', 'sidang_pertama', 'Y', 0),
		(1710, 10, 13, 'Mediasi', 110, 'Penetapan Mediator', 1, '1', 81, 'perkara_penetapan', 'sidang_pertama', 'perkara_mediasi', 'penetapan_penunjukan_mediator', 'Y', 0),
		(1711, 10, 13, 'Mediasi', 120, 'Penetapan Tanggal Mediasi', 2, '1', 110, 'perkara_mediasi', 'penetapan_penunjukan_mediator', 'perkara_mediasi', 'penetapan_tanggal_mediasi', 'Y', 0),
		(1712, 10, 13, 'Mediasi', 121, 'Mulai Mediasi', NULL, NULL, NULL, NULL, NULL, 'perkara_mediasi', 'dimulai_mediasi', 'Y', 0),
		(1713, 10, 13, 'Mediasi', 130, 'Kesepakatan Mediasi', 61, '1', 121, 'perkara_mediasi', 'dimulai_mediasi', 'perkara_mediasi', 'keputusan_mediasi', 'Y', 1),
		(1714, 10, 13, 'Mediasi', 150, 'Mediasi Tidak Berhasil', NULL, NULL, NULL, NULL, NULL, 'perkara_mediasi', 'mediasi_gagal', 'Y', 0),
		(1715, 10, 13, 'Mediasi', 151, 'Mediasi Tidak Dapat Dilaksanakan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1716, 10, 13, 'Mediasi', 180, 'Mediasi Berhasil', NULL, NULL, NULL, NULL, NULL, 'perkara_mediasi', 'mediasi_berhasil', 'Y', 0),
		(1717, 10, 13, 'Mediasi', 181, 'Mediasi Berhasil Sebagian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1718, 10, 13, 'Mediasi', 190, 'Penetapan Akta Perdamaian', NULL, NULL, NULL, NULL, NULL, 'perkara_mediasi', 'akta_perdamaian', 'Y', 0),
		(1719, 10, 14, 'Persidangan', 200, 'Persidangan', NULL, '', NULL, '', '', '', '', 'Y', 1),
		(1720, 10, 15, 'Putusan', 210, 'Putusan', 5, '3', 10, 'perkara', 'tanggal_pendaftaran', 'perkara_putusan', 'tanggal_putusan', 'Y', 1),
		(1721, 10, 15, 'Putusan', 211, 'Pencabutan Perkara', NULL, NULL, NULL, NULL, NULL, 'perkara_putusan', 'tanggal_cabut', 'Y', 0),
		(1722, 10, 15, 'Putusan', 212, 'Pernyataan Gugur', NULL, NULL, NULL, NULL, NULL, 'perkara_putusan', 'tanggal_gugur', 'Y', 0),
		(1723, 10, 15, 'Putusan', 218, 'Pemberitahuan Putusan', NULL, NULL, NULL, NULL, NULL, 'perkara_putusan', 'pemberitahuan_putusan', 'Y', 0),
		(1724, 10, 15, 'Putusan', 220, 'Pembuatan Minutasi', 14, '2', 210, 'perkara_putusan', 'tanggal_putusan', 'perkara_putusan', 'tanggal_minutasi', 'Y', 1),
		(1725, 10, 16, 'Verzet', 240, 'Pendaftaran Perlawanan(Verzet)', 14, '1', 230, 'perkara_putusan', 'pemberitahuan_putusan', 'perkara_verzet', 'tanggal_pendaftaran_verzet', 'Y', 0),
		(1726, 10, 16, 'Verzet', 241, 'Penetapan Majelis Hakim Verzet', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1727, 10, 16, 'Verzet', 242, 'Penetapan Panitera Pengganti Verzet', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1728, 10, 16, 'Verzet', 243, 'Penetapan Jurusita Verzet', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1729, 10, 16, 'Verzet', 250, 'Penetapan Jadwal Sidang Verzet', NULL, NULL, NULL, NULL, NULL, 'perkara_verzet', 'tanggal_penetapan_sidang_verzet', 'Y', 0),
		(1730, 10, 16, 'Verzet', 260, 'Sidang Pertama Perlawanan', NULL, NULL, NULL, NULL, NULL, 'perkara_verzet', 'tanggal_sidang_pertama_verzet', 'Y', 0),
		(1731, 10, 16, 'Verzet', 261, 'Persidangan Verzet', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1732, 10, 16, 'Verzet', 270, 'Putusan Perlawanan  Verzet', NULL, NULL, NULL, NULL, NULL, 'perkara_verzet', 'putusan_verzet', 'Y', 0),
		(1733, 10, 16, 'Verzet', 280, 'Pemberitahuan Hasil Putusan Verzet', NULL, NULL, NULL, NULL, NULL, 'perkara_verzet', 'pemberitahuan_putusan_verzet', 'Y', 0),
		(1734, 10, 20, 'Banding', 290, 'Permohonan Banding', 14, '1', 210, 'perkara_putusan', 'tanggal_putusan', 'perkara_banding', 'permohonan_banding', 'Y', 0),
		(1735, 10, 20, 'Banding', 300, 'Pemberitahuan Permohonan Banding', 7, '2', 290, 'perkara_banding', 'permohonan_banding', 'perkara_banding', 'pemberitahuan_permohonan_banding', 'Y', 1),
		(1736, 10, 20, 'Banding', 310, 'Penerimaan Memori Banding', 0, '', NULL, NULL, NULL, 'perkara_banding', 'penerimaan_memori_banding', 'Y', 1),
		(1737, 10, 20, 'Banding', 320, 'Penyerahan Memori Banding', NULL, NULL, NULL, NULL, NULL, 'perkara_banding', 'penyerahan_memori_banding', 'Y', 0),
		(1738, 10, 20, 'Banding', 330, 'Penerimaan Kontra Memori Banding', 0, '', NULL, NULL, NULL, 'perkara_banding', 'penerimaan_kontra_banding', 'Y', 1),
		(1739, 10, 20, 'Banding', 340, 'Penyerahan Kontra Memori Banding', NULL, NULL, NULL, NULL, NULL, 'perkara_banding', 'penyerahan_kontra_banding', 'Y', 0),
		(1740, 10, 20, 'Banding', 350, 'Permberitahuan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_banding_detil', 'pemberitahuan_inzage', 'Y', 0),
		(1741, 10, 20, 'Banding', 360, 'Pelaksanaan Untuk Memeriksa Berkas(Inzage)', NULL, '', NULL, NULL, NULL, 'perkara_banding_detil', 'pelaksanaan_inzage', 'Y', 0),
		(1742, 10, 20, 'Banding', 370, 'Pengiriman Berkas  Banding', 30, '2', 290, 'perkara_banding', 'permohonan_banding', 'perkara_banding', 'pengiriman_berkas_banding', 'Y', 1),
		(1743, 10, 20, 'Banding', 380, 'Penerimaan Kembali Berkas Banding', NULL, NULL, NULL, NULL, NULL, 'perkara_banding', 'penerimaan_kembali_berkas_banding', 'Y', 0),
		(1744, 10, 20, 'Banding', 390, 'Putusan Banding', 3, '3', 290, 'perkara_banding', 'permohonan_banding', 'perkara_banding', 'putusan_banding', 'Y', 1),
		(1745, 10, 20, 'Banding', 391, 'Pencabutan Perkara Banding', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'T', 0),
		(1746, 10, 20, 'Banding', 400, 'Pemberitahuan Putusan Banding', 14, '2', 390, 'perkara_banding', 'putusan_banding', 'perkara_banding', 'pemberitahuan_putusan_banding', 'Y', 1),
		(1747, 10, 30, 'Kasasi', 410, 'Permohonan Kasasi', 14, '2', 400, 'perkara_banding', 'pemberitahuan_putusan_banding', 'perkara_kasasi', 'permohonan_kasasi', 'Y', 0),
		(1748, 10, 30, 'Kasasi', 420, 'Pemberitahuan Permohonan Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pemberitahuan_kasasi', 'Y', 0),
		(1749, 10, 30, 'Kasasi', 430, 'Penerimaan Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_memori_kasasi', 'Y', 0),
		(1750, 10, 30, 'Kasasi', 440, 'Penyerahan Memori Kasasi', 14, 2, 410, 'perkara_kasasi', 'permohonan_kasasi', 'perkara_kasasi', 'penyerahan_memori_kasasi', 'Y', 1),
		(1751, 10, 30, 'Kasasi', 450, 'Penerimaan Kontra Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_kontra_kasasi', 'Y', 0),
		(1752, 10, 30, 'Kasasi', 460, 'Penyerahan Kontra Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penyerahan_kontra_kasasi', 'Y', 0),
		(1753, 10, 30, 'Kasasi', 461, 'Permberitahuan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pemberitahuan_inzage_pemohon_kasasi', 'Y', 0),
		(1754, 10, 30, 'Kasasi', 464, 'Pelaksanaan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pelaksanaan_inzage_termohon_kasasi', 'Y', 0),
		(1755, 10, 30, 'Kasasi', 470, 'Pengiriman Berkas Kasasi', 65, 2, 410, 'perkara_kasasi', 'permohonan_kasasi', 'perkara_kasasi', 'pengiriman_berkas_kasasi', 'Y', 1),
		(1756, 10, 30, 'Kasasi', 480, 'Penerimaan Kembali Berkas Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_berkas_kasasi', 'Y', 0),
		(1757, 10, 30, 'Kasasi', 490, 'Putusan Kasasi', 6, 3, 410, 'perkara_kasasi', 'permohonan_kasasi', 'perkara_kasasi', 'putusan_kasasi', 'Y', 1),
		(1758, 10, 30, 'Kasasi', 500, 'Pemberitahuan Putus Kasasi', 30, '2', 490, 'perkara_kasasi', 'putusan_kasasi', 'perkara_kasasi', 'pemberitahuan_putusan_kasasi', 'Y', 1),
		(1759, 10, 40, 'Peninjauan Kembali', 510, 'Permohonan PK', NULL, '', NULL, '', 'pemberitahuan_putusan_kasasi', 'perkara_pk', 'permohonan_pk', 'Y', 0),
		(1760, 10, 40, 'Peninjauan Kembali', 520, 'Pemberitahuan PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'pemberitahuan_pk', 'Y', 0),
		(1761, 10, 40, 'Peninjauan Kembali', 521, 'Penerimaan Memori PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_memori_pk', 'Y', 0),
		(1762, 10, 40, 'Peninjauan Kembali', 522, 'Penyerahan Memori PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penyerahan_memori_pk', 'Y', 0),
		(1763, 10, 40, 'Peninjauan Kembali', 530, 'Penerimaan Jawaban PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_kontra_pk', 'Y', 0),
		(1764, 10, 40, 'Peninjauan Kembali', 540, 'Penyerahan Jawaban PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penyerahan_kontra_pk', 'Y', 0),
		(1765, 10, 40, 'Peninjauan Kembali', 550, 'Pengiriman Berkas PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'pengiriman_berkas_pk', 'Y', 0),
		(1766, 10, 40, 'Peninjauan Kembali', 560, 'Penerimaan Kembali Berkas PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_berkas_pk', 'Y', 0),
		(1767, 10, 40, 'Peninjauan Kembali', 570, 'Putusan PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'putusan_pk', 'Y', 0),
		(1768, 10, 40, 'Peninjauan Kembali', 571, 'Pemberitahuan Putusan PK', 30, '2', 570, 'perkara_pk', 'putusan_pk', 'perkara_pk', 'pemberitahuan_putusan_pk', 'Y', 1),
		(1769, 10, 50, 'Eksekusi', 600, 'Permohonan Eksekusi', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'permohonan_eksekusi', 'Y', 0),
		(1770, 10, 50, 'Eksekusi', 605, 'Penetapan Teguran Eksekusi', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_teguran_eksekusi', 'Y', 0),
		(1771, 10, 50, 'Eksekusi', 610, 'Pelaksaan Penegoran(Aanmaning)', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'pelaksanaan_teguran_eksekusi', 'Y', 0),
		(1772, 10, 50, 'Eksekusi', 615, 'Penetapan Sita Eksekusi', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_sita_eksekusi', 'Y', 0),
		(1773, 10, 50, 'Eksekusi', 620, 'Pelaksanaan Sita Eksekusi', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'pelaksanaan_sita_eksekusi', 'Y', 0),
		(1774, 10, 50, 'Eksekusi', 622, 'Penetapan Perintah Eksekusi Lelang', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_perintah_eksekusi_lelang', 'Y', 0),
		(1775, 10, 50, 'Eksekusi', 624, 'Pelaksanaan Eksekusi Lelang', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'pelaksanaan_eksekusi_lelang', 'Y', 0),
		(1776, 10, 50, 'Eksekusi', 626, 'Penyerahan Hasil Eksekusi Lelang', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penyerahan_hasil_lelang', 'Y', 0),
		(1777, 10, 50, 'Eksekusi', 628, 'Penetapan Perintah Eksekusi Rill', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_perintah_eksekusi_rill', 'Y', 0),
		(1778, 10, 50, 'Eksekusi', 630, 'Pelaksaan Eksekusi Rill', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'pelaksanaan_eksekusi_rill', 'Y', 0),
		(1779, 10, 50, 'Eksekusi', 640, 'Penetapan Sita Non Eksekutable', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_noneksekusi', 'Y', 0),
		(1780, 11, 10, 'Pendaftaran', 10, 'Pendaftaran Perkara', NULL, '', NULL, '', 'tanggal_pendaftaran', 'perkara', 'tanggal_pendaftaran', 'Y', 0),
		(1781, 11, 12, 'Penetapan', 20, 'Penetapan Majelis Hakim/Hakim', 3, '1', 10, 'perkara', 'tanggal_pendaftaran', 'perkara_penetapan', 'penetapan_majelis_hakim', 'Y', 1),
		(1782, 11, 12, 'Penetapan', 21, 'Penetapan Kembali Majelis Hakim/Hakim', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1783, 11, 12, 'Penetapan', 30, 'Penunjukan Panitera Pengganti', 3, '1', 10, 'perkara', 'tanggal_pendaftaran', 'perkara_penetapan', 'penetapan_panitera_pengganti', 'Y', 0),
		(1784, 11, 12, 'Penetapan', 31, 'Penunjukan Kembali Panitera Pengganti', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1785, 11, 12, 'Penetapan', 40, 'Penunjukan Jurusita', NULL, NULL, NULL, NULL, NULL, 'perkara_penetapan', 'penetapan_jurusita', 'Y', 0),
		(1786, 11, 12, 'Penetapan', 41, 'Penunjukan Kembali Jurusita', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1787, 11, 12, 'Penetapan', 80, 'Penetapan Hari Sidang Pertama', 3, '1', 20, 'perkara_penetapan', 'penetapan_majelis_hakim', 'perkara_penetapan', 'penetapan_hari_sidang', 'Y', 1),
		(1788, 11, 12, 'Penetapan', 81, 'Sidang pertama', NULL, '', NULL, '', 'penetapan_panitera_pengganti', 'perkara_penetapan', 'sidang_pertama', 'Y', 0),
		(1789, 11, 13, 'Mediasi', 110, 'Penetapan Mediator', 1, '1', 81, 'perkara_penetapan', 'sidang_pertama', 'perkara_mediasi', 'penetapan_penunjukan_mediator', 'Y', 0),
		(1790, 11, 13, 'Mediasi', 120, 'Penetapan Tanggal Mediasi', 2, '1', 110, 'perkara_mediasi', 'penetapan_penunjukan_mediator', 'perkara_mediasi', 'penetapan_tanggal_mediasi', 'Y', 0),
		(1791, 11, 13, 'Mediasi', 121, 'Mulai Mediasi', NULL, NULL, NULL, NULL, NULL, 'perkara_mediasi', 'dimulai_mediasi', 'Y', 0),
		(1792, 11, 13, 'Mediasi', 130, 'Kesepakatan Mediasi', 61, '1', 121, 'perkara_mediasi', 'dimulai_mediasi', 'perkara_mediasi', 'keputusan_mediasi', 'Y', 1),
		(1793, 11, 13, 'Mediasi', 150, 'Mediasi Tidak Berhasil', NULL, NULL, NULL, NULL, NULL, 'perkara_mediasi', 'mediasi_gagal', 'Y', 0),
		(1794, 11, 13, 'Mediasi', 151, 'Mediasi Tidak Dapat Dilaksanakan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1795, 11, 13, 'Mediasi', 180, 'Mediasi Berhasil', NULL, NULL, NULL, NULL, NULL, 'perkara_mediasi', 'mediasi_berhasil', 'Y', 0),
		(1796, 11, 13, 'Mediasi', 181, 'Mediasi Berhasil Sebagian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1797, 11, 13, 'Mediasi', 190, 'Penetapan Akta Perdamaian', NULL, NULL, NULL, NULL, NULL, 'perkara_mediasi', 'akta_perdamaian', 'Y', 0),
		(1798, 11, 14, 'Persidangan', 200, 'Persidangan', NULL, '', NULL, '', '', '', '', 'Y', 1),
		(1799, 11, 15, 'Putusan', 210, 'Putusan', 5, '3', 10, 'perkara', 'tanggal_pendaftaran', 'perkara_putusan', 'tanggal_putusan', 'Y', 1),
		(1800, 11, 15, 'Putusan', 211, 'Pencabutan Perkara', NULL, NULL, NULL, NULL, NULL, 'perkara_putusan', 'tanggal_cabut', 'Y', 0),
		(1801, 11, 15, 'Putusan', 212, 'Pernyataan Gugur', NULL, NULL, NULL, NULL, NULL, 'perkara_putusan', 'tanggal_gugur', 'Y', 0),
		(1802, 11, 15, 'Putusan', 218, 'Pemberitahuan Putusan', NULL, NULL, NULL, NULL, NULL, 'perkara_putusan', 'pemberitahuan_putusan', 'Y', 0),
		(1803, 11, 15, 'Putusan', 220, 'Pembuatan Minutasi', 14, '2', 210, 'perkara_putusan', 'tanggal_putusan', 'perkara_putusan', 'tanggal_minutasi', 'Y', 1),
		(1804, 11, 16, 'Verzet', 240, 'Pendaftaran Perlawanan(Verzet)', 14, '1', 230, 'perkara_putusan', 'pemberitahuan_putusan', 'perkara_verzet', 'tanggal_pendaftaran_verzet', 'Y', 0),
		(1805, 11, 16, 'Verzet', 241, 'Penetapan Majelis Hakim Verzet', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1806, 11, 16, 'Verzet', 242, 'Penetapan Panitera Pengganti Verzet', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1807, 11, 16, 'Verzet', 243, 'Penetapan Jurusita Verzet', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1809, 11, 16, 'Verzet', 250, 'Penetapan Jadwal Sidang Verzet', NULL, NULL, NULL, NULL, NULL, 'perkara_verzet', 'tanggal_penetapan_sidang_verzet', 'Y', 0),
		(1810, 11, 16, 'Verzet', 260, 'Sidang Pertama Perlawanan', NULL, NULL, NULL, NULL, NULL, 'perkara_verzet', 'tanggal_sidang_pertama_verzet', 'Y', 0),
		(1811, 11, 16, 'Verzet', 261, 'Persidangan Verzet', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1812, 11, 16, 'Verzet', 270, 'Putusan Perlawanan  Verzet', NULL, NULL, NULL, NULL, NULL, 'perkara_verzet', 'putusan_verzet', 'Y', 0),
		(1813, 11, 16, 'Verzet', 280, 'Pemberitahuan Hasil Putusan Verzet', NULL, NULL, NULL, NULL, NULL, 'perkara_verzet', 'pemberitahuan_putusan_verzet', 'Y', 0),
		(1814, 11, 20, 'Banding', 290, 'Permohonan Banding', 14, '1', 210, 'perkara_putusan', 'tanggal_putusan', 'perkara_banding', 'permohonan_banding', 'Y', 0),
		(1815, 11, 20, 'Banding', 300, 'Pemberitahuan Permohonan Banding', 7, '2', 290, 'perkara_banding', 'permohonan_banding', 'perkara_banding', 'pemberitahuan_permohonan_banding', 'Y', 1),
		(1816, 11, 20, 'Banding', 310, 'Penerimaan Memori Banding', 0, '', NULL, NULL, NULL, 'perkara_banding', 'penerimaan_memori_banding', 'Y', 1),
		(1817, 11, 20, 'Banding', 320, 'Penyerahan Memori Banding', NULL, NULL, NULL, NULL, NULL, 'perkara_banding', 'penyerahan_memori_banding', 'Y', 0),
		(1818, 11, 20, 'Banding', 330, 'Penerimaan Kontra Memori Banding', 0, '', NULL, NULL, NULL, 'perkara_banding', 'penerimaan_kontra_banding', 'Y', 1),
		(1819, 11, 20, 'Banding', 340, 'Penyerahan Kontra Memori Banding', NULL, NULL, NULL, NULL, NULL, 'perkara_banding', 'penyerahan_kontra_banding', 'Y', 0),
		(1820, 11, 20, 'Banding', 350, 'Permberitahuan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_banding_detil', 'pemberitahuan_inzage', 'Y', 0),
		(1821, 11, 20, 'Banding', 360, 'Pelaksanaan Untuk Memeriksa Berkas(Inzage)', NULL, '', NULL, NULL, NULL, 'perkara_banding_detil', 'pelaksanaan_inzage', 'Y', 0),
		(1822, 11, 20, 'Banding', 370, 'Pengiriman Berkas  Banding', 30, '2', 290, 'perkara_banding', 'permohonan_banding', 'perkara_banding', 'pengiriman_berkas_banding', 'Y', 1),
		(1823, 11, 20, 'Banding', 380, 'Penerimaan Kembali Berkas Banding', NULL, NULL, NULL, NULL, NULL, 'perkara_banding', 'penerimaan_kembali_berkas_banding', 'Y', 0),
		(1824, 11, 20, 'Banding', 390, 'Putusan Banding', 3, '3', 290, 'perkara_banding', 'permohonan_banding', 'perkara_banding', 'putusan_banding', 'Y', 1),
		(1825, 11, 20, 'Banding', 391, 'Pencabutan Perkara Banding', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'T', 0),
		(1826, 11, 20, 'Banding', 400, 'Pemberitahuan Putusan Banding', 14, '2', 390, 'perkara_banding', 'putusan_banding', 'perkara_banding', 'pemberitahuan_putusan_banding', 'Y', 1),
		(1827, 11, 30, 'Kasasi', 410, 'Permohonan Kasasi', 14, '2', 400, 'perkara_banding', 'pemberitahuan_putusan_banding', 'perkara_kasasi', 'permohonan_kasasi', 'Y', 0),
		(1829, 11, 30, 'Kasasi', 420, 'Pemberitahuan Permohonan Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pemberitahuan_kasasi', 'Y', 0),
		(1830, 11, 30, 'Kasasi', 430, 'Penerimaan Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_memori_kasasi', 'Y', 0),
		(1831, 11, 30, 'Kasasi', 440, 'Penyerahan Memori Kasasi', 14, '2', 410, 'perkara_kasasi', 'permohonan_kasasi', 'perkara_kasasi', 'penyerahan_memori_kasasi', 'Y', 1),
		(1832, 11, 30, 'Kasasi', 450, 'Penerimaan Kontra Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_kontra_kasasi', 'Y', 0),
		(1833, 11, 30, 'Kasasi', 460, 'Penyerahan Kontra Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penyerahan_kontra_kasasi', 'Y', 0),
		(1834, 11, 30, 'Kasasi', 461, 'Permberitahuan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pemberitahuan_inzage_pemohon_kasasi', 'Y', 0),
		(1835, 11, 30, 'Kasasi', 464, 'Pelaksanaan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pelaksanaan_inzage_termohon_kasasi', 'Y', 0),
		(1836, 11, 30, 'Kasasi', 470, 'Pengiriman Berkas Kasasi', 65, '2', 410, 'perkara_kasasi', 'permohonan_kasasi', 'perkara_kasasi', 'pengiriman_berkas_kasasi', 'Y', 1),
		(1837, 11, 30, 'Kasasi', 480, 'Penerimaan Kembali Berkas Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_berkas_kasasi', 'Y', 0),
		(1838, 11, 30, 'Kasasi', 490, 'Putusan Kasasi', 6, '3', 410, 'perkara_kasasi', 'permohonan_kasasi', 'perkara_kasasi', 'putusan_kasasi', 'Y', 1),
		(1839, 11, 30, 'Kasasi', 500, 'Pemberitahuan Putus Kasasi', 30, '2', 490, 'perkara_kasasi', 'putusan_kasasi', 'perkara_kasasi', 'pemberitahuan_putusan_kasasi', 'Y', 1),
		(1840, 11, 40, 'Peninjauan Kembali', 510, 'Permohonan PK', NULL, '', NULL, '', 'pemberitahuan_putusan_kasasi', 'perkara_pk', 'permohonan_pk', 'Y', 0),
		(1841, 11, 40, 'Peninjauan Kembali', 520, 'Pemberitahuan PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'pemberitahuan_pk', 'Y', 0),
		(1842, 11, 40, 'Peninjauan Kembali', 521, 'Penerimaan Memori PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_memori_pk', 'Y', 0),
		(1843, 11, 40, 'Peninjauan Kembali', 522, 'Penyerahan Memori PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penyerahan_memori_pk', 'Y', 0),
		(1844, 11, 40, 'Peninjauan Kembali', 530, 'Penerimaan Jawaban PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_kontra_pk', 'Y', 0),
		(1845, 11, 40, 'Peninjauan Kembali', 540, 'Penyerahan Jawaban PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penyerahan_kontra_pk', 'Y', 0),
		(1846, 11, 40, 'Peninjauan Kembali', 550, 'Pengiriman Berkas PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'pengiriman_berkas_pk', 'Y', 0),
		(1847, 11, 40, 'Peninjauan Kembali', 560, 'Penerimaan Kembali Berkas PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_berkas_pk', 'Y', 0),
		(1848, 11, 40, 'Peninjauan Kembali', 570, 'Putusan PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'putusan_pk', 'Y', 0),
		(1849, 11, 40, 'Peninjauan Kembali', 571, 'Pemberitahuan Putusan PK', 30, '2', 570, 'perkara_pk', 'putusan_pk', 'perkara_pk', 'pemberitahuan_putusan_pk', 'Y', 1),
		(1850, 11, 50, 'Eksekusi', 600, 'Permohonan Eksekusi', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'permohonan_eksekusi', 'Y', 0),
		(1851, 11, 50, 'Eksekusi', 605, 'Penetapan Teguran Eksekusi', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_teguran_eksekusi', 'Y', 0),
		(1852, 11, 50, 'Eksekusi', 610, 'Pelaksaan Penegoran(Aanmaning)', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'pelaksanaan_teguran_eksekusi', 'Y', 0),
		(1853, 11, 50, 'Eksekusi', 615, 'Penetapan Sita Eksekusi', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_sita_eksekusi', 'Y', 0),
		(1854, 11, 50, 'Eksekusi', 620, 'Pelaksanaan Sita Eksekusi', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'pelaksanaan_sita_eksekusi', 'Y', 0),
		(1855, 11, 50, 'Eksekusi', 622, 'Penetapan Perintah Eksekusi Lelang', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_perintah_eksekusi_lelang', 'Y', 0),
		(1856, 11, 50, 'Eksekusi', 624, 'Pelaksanaan Eksekusi Lelang', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'pelaksanaan_eksekusi_lelang', 'Y', 0),
		(1857, 11, 50, 'Eksekusi', 626, 'Penyerahan Hasil Eksekusi Lelang', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penyerahan_hasil_lelang', 'Y', 0),
		(1858, 11, 50, 'Eksekusi', 628, 'Penetapan Perintah Eksekusi Rill', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_perintah_eksekusi_rill', 'Y', 0),
		(1859, 11, 50, 'Eksekusi', 630, 'Pelaksaan Eksekusi Rill', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'pelaksanaan_eksekusi_rill', 'Y', 0),
		(1860, 11, 50, 'Eksekusi', 640, 'Penetapan Sita Non Eksekutable', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_noneksekusi', 'Y', 0),
		(1861, 12, 10, 'Pendaftaran', 10, 'Pendaftaran Perkara', NULL, '', NULL, '', 'tanggal_pendaftaran', 'perkara', 'tanggal_pendaftaran', 'Y', 0),
		(1862, 12, 12, 'Penetapan', 20, 'Penetapan Majelis Hakim/Hakim', 3, '1', 10, 'perkara', 'tanggal_pendaftaran', 'perkara_penetapan', 'penetapan_majelis_hakim', 'Y', 1),
		(1863, 12, 12, 'Penetapan', 21, 'Penetapan Kembali Majelis Hakim/Hakim', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1864, 12, 12, 'Penetapan', 30, 'Penunjukan Panitera Pengganti', 3, '1', 10, 'perkara', 'tanggal_pendaftaran', 'perkara_penetapan', 'penetapan_panitera_pengganti', 'Y', 0),
		(1865, 12, 12, 'Penetapan', 31, 'Penunjukan Kembali Panitera Pengganti', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1866, 12, 12, 'Penetapan', 40, 'Penunjukan Jurusita', NULL, NULL, NULL, NULL, NULL, 'perkara_penetapan', 'penetapan_jurusita', 'Y', 0),
		(1867, 12, 12, 'Penetapan', 41, 'Penunjukan Kembali Jurusita', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1868, 12, 12, 'Penetapan', 80, 'Penetapan Hari Sidang Pertama', 3, '1', 20, 'perkara_penetapan', 'penetapan_majelis_hakim', 'perkara_penetapan', 'penetapan_hari_sidang', 'Y', 1),
		(1869, 12, 12, 'Penetapan', 81, 'Sidang pertama', NULL, '', NULL, '', 'penetapan_panitera_pengganti', 'perkara_penetapan', 'sidang_pertama', 'Y', 0),
		(1870, 12, 13, 'Mediasi', 110, 'Penetapan Mediator', 1, '1', 81, 'perkara_penetapan', 'sidang_pertama', 'perkara_mediasi', 'penetapan_penunjukan_mediator', 'Y', 0),
		(1871, 12, 13, 'Mediasi', 120, 'Penetapan Tanggal Mediasi', 2, '1', 110, 'perkara_mediasi', 'penetapan_penunjukan_mediator', 'perkara_mediasi', 'penetapan_tanggal_mediasi', 'Y', 0),
		(1872, 12, 13, 'Mediasi', 121, 'Mulai Mediasi', NULL, NULL, NULL, NULL, NULL, 'perkara_mediasi', 'dimulai_mediasi', 'Y', 0),
		(1873, 12, 13, 'Mediasi', 130, 'Kesepakatan Mediasi', 61, '1', 121, 'perkara_mediasi', 'dimulai_mediasi', 'perkara_mediasi', 'keputusan_mediasi', 'Y', 1),
		(1874, 12, 13, 'Mediasi', 150, 'Mediasi Tidak Berhasil', NULL, NULL, NULL, NULL, NULL, 'perkara_mediasi', 'mediasi_gagal', 'Y', 0),
		(1875, 12, 13, 'Mediasi', 151, 'Mediasi Tidak Dapat Dilaksanakan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1876, 12, 13, 'Mediasi', 180, 'Mediasi Berhasil', NULL, NULL, NULL, NULL, NULL, 'perkara_mediasi', 'mediasi_berhasil', 'Y', 0),
		(1877, 12, 13, 'Mediasi', 181, 'Mediasi Berhasil Sebagian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1878, 12, 13, 'Mediasi', 190, 'Penetapan Akta Perdamaian', NULL, NULL, NULL, NULL, NULL, 'perkara_mediasi', 'akta_perdamaian', 'Y', 0),
		(1879, 12, 14, 'Persidangan', 200, 'Persidangan', NULL, '', NULL, '', '', '', '', 'Y', 1),
		(1880, 12, 15, 'Putusan', 210, 'Putusan', 5, '3', 10, 'perkara', 'tanggal_pendaftaran', 'perkara_putusan', 'tanggal_putusan', 'Y', 1),
		(1881, 12, 15, 'Putusan', 211, 'Pencabutan Perkara', NULL, NULL, NULL, NULL, NULL, 'perkara_putusan', 'tanggal_cabut', 'Y', 0),
		(1882, 12, 15, 'Putusan', 212, 'Pernyataan Gugur', NULL, NULL, NULL, NULL, NULL, 'perkara_putusan', 'tanggal_gugur', 'Y', 0),
		(1883, 12, 15, 'Putusan', 218, 'Pemberitahuan Putusan', NULL, NULL, NULL, NULL, NULL, 'perkara_putusan', 'pemberitahuan_putusan', 'Y', 0),
		(1884, 12, 15, 'Putusan', 220, 'Pembuatan Minutasi', 14, '2', 210, 'perkara_putusan', 'tanggal_putusan', 'perkara_putusan', 'tanggal_minutasi', 'Y', 1),
		(1885, 12, 16, 'Verzet', 240, 'Pendaftaran Perlawanan(Verzet)', 14, '1', 230, 'perkara_putusan', 'pemberitahuan_putusan', 'perkara_verzet', 'tanggal_pendaftaran_verzet', 'Y', 0),
		(1886, 12, 16, 'Verzet', 241, 'Penetapan Majelis Hakim Verzet', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1887, 12, 16, 'Verzet', 242, 'Penetapan Panitera Pengganti Verzet', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1888, 12, 16, 'Verzet', 243, 'Penetapan Jurusita Verzet', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1889, 12, 16, 'Verzet', 250, 'Penetapan Jadwal Sidang Verzet', NULL, NULL, NULL, NULL, NULL, 'perkara_verzet', 'tanggal_penetapan_sidang_verzet', 'Y', 0),
		(1890, 12, 16, 'Verzet', 260, 'Sidang Pertama Perlawanan', NULL, NULL, NULL, NULL, NULL, 'perkara_verzet', 'tanggal_sidang_pertama_verzet', 'Y', 0),
		(1891, 12, 16, 'Verzet', 261, 'Persidangan Verzet', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1892, 12, 16, 'Verzet', 270, 'Putusan Perlawanan  Verzet', NULL, NULL, NULL, NULL, NULL, 'perkara_verzet', 'putusan_verzet', 'Y', 0),
		(1893, 12, 16, 'Verzet', 280, 'Pemberitahuan Hasil Putusan Verzet', NULL, NULL, NULL, NULL, NULL, 'perkara_verzet', 'pemberitahuan_putusan_verzet', 'Y', 0),
		(1894, 12, 20, 'Banding', 290, 'Permohonan Banding', 14, '1', 210, 'perkara_putusan', 'tanggal_putusan', 'perkara_banding', 'permohonan_banding', 'Y', 0),
		(1895, 12, 20, 'Banding', 300, 'Pemberitahuan Permohonan Banding', 7, '2', 290, 'perkara_banding', 'permohonan_banding', 'perkara_banding', 'pemberitahuan_permohonan_banding', 'Y', 1),
		(1896, 12, 20, 'Banding', 310, 'Penerimaan Memori Banding', 0, '', NULL, NULL, NULL, 'perkara_banding', 'penerimaan_memori_banding', 'Y', 1),
		(1897, 12, 20, 'Banding', 320, 'Penyerahan Memori Banding', NULL, NULL, NULL, NULL, NULL, 'perkara_banding', 'penyerahan_memori_banding', 'Y', 0),
		(1898, 12, 20, 'Banding', 330, 'Penerimaan Kontra Memori Banding', 0, '', NULL, NULL, NULL, 'perkara_banding', 'penerimaan_kontra_banding', 'Y', 1),
		(1899, 12, 20, 'Banding', 340, 'Penyerahan Kontra Memori Banding', NULL, NULL, NULL, NULL, NULL, 'perkara_banding', 'penyerahan_kontra_banding', 'Y', 0),
		(1900, 12, 20, 'Banding', 350, 'Permberitahuan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_banding_detil', 'pemberitahuan_inzage', 'Y', 0),
		(1901, 12, 20, 'Banding', 360, 'Pelaksanaan Untuk Memeriksa Berkas(Inzage)', NULL, '', NULL, NULL, NULL, 'perkara_banding_detil', 'pelaksanaan_inzage', 'Y', 0),
		(1902, 12, 20, 'Banding', 370, 'Pengiriman Berkas  Banding', 30, '2', 290, 'perkara_banding', 'permohonan_banding', 'perkara_banding', 'pengiriman_berkas_banding', 'Y', 1),
		(1903, 12, 20, 'Banding', 380, 'Penerimaan Kembali Berkas Banding', NULL, NULL, NULL, NULL, NULL, 'perkara_banding', 'penerimaan_kembali_berkas_banding', 'Y', 0),
		(1904, 12, 20, 'Banding', 390, 'Putusan Banding', 3, '3', 290, 'perkara_banding', 'permohonan_banding', 'perkara_banding', 'putusan_banding', 'Y', 1),
		(1905, 12, 20, 'Banding', 391, 'Pencabutan Perkara Banding', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'T', 0),
		(1906, 12, 20, 'Banding', 400, 'Pemberitahuan Putusan Banding', 14, '2', 390, 'perkara_banding', 'putusan_banding', 'perkara_banding', 'pemberitahuan_putusan_banding', 'Y', 1),
		(1907, 12, 30, 'Kasasi', 410, 'Permohonan Kasasi', 14, '2', 400, 'perkara_banding', 'pemberitahuan_putusan_banding', 'perkara_kasasi', 'permohonan_kasasi', 'Y', 0),
		(1908, 12, 30, 'Kasasi', 420, 'Pemberitahuan Permohonan Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pemberitahuan_kasasi', 'Y', 0),
		(1909, 12, 30, 'Kasasi', 430, 'Penerimaan Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_memori_kasasi', 'Y', 0),
		(1910, 12, 30, 'Kasasi', 440, 'Penyerahan Memori Kasasi', 14, '2', 410, 'perkara_kasasi', 'permohonan_kasasi', 'perkara_kasasi', 'penyerahan_memori_kasasi', 'Y', 1),
		(1911, 12, 30, 'Kasasi', 450, 'Penerimaan Kontra Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_kontra_kasasi', 'Y', 0),
		(1912, 12, 30, 'Kasasi', 460, 'Penyerahan Kontra Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penyerahan_kontra_kasasi', 'Y', 0),
		(1913, 12, 30, 'Kasasi', 461, 'Permberitahuan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pemberitahuan_inzage_pemohon_kasasi', 'Y', 0),
		(1914, 12, 30, 'Kasasi', 464, 'Pelaksanaan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pelaksanaan_inzage_termohon_kasasi', 'Y', 0),
		(1915, 12, 30, 'Kasasi', 470, 'Pengiriman Berkas Kasasi', 65, '2', 410, 'perkara_kasasi', 'permohonan_kasasi', 'perkara_kasasi', 'pengiriman_berkas_kasasi', 'Y', 1),
		(1916, 12, 30, 'Kasasi', 480, 'Penerimaan Kembali Berkas Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_berkas_kasasi', 'Y', 0),
		(1917, 12, 30, 'Kasasi', 490, 'Putusan Kasasi', 6, '3', 410, 'perkara_kasasi', 'permohonan_kasasi', 'perkara_kasasi', 'putusan_kasasi', 'Y', 1),
		(1918, 12, 30, 'Kasasi', 500, 'Pemberitahuan Putus Kasasi', 30, '2', 490, 'perkara_kasasi', 'putusan_kasasi', 'perkara_kasasi', 'pemberitahuan_putusan_kasasi', 'Y', 1),
		(1919, 12, 40, 'Peninjauan Kembali', 510, 'Permohonan PK', NULL, '', NULL, '', 'pemberitahuan_putusan_kasasi', 'perkara_pk', 'permohonan_pk', 'Y', 0),
		(1920, 12, 40, 'Peninjauan Kembali', 520, 'Pemberitahuan PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'pemberitahuan_pk', 'Y', 0),
		(1921, 12, 40, 'Peninjauan Kembali', 521, 'Penerimaan Memori PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_memori_pk', 'Y', 0),
		(1922, 12, 40, 'Peninjauan Kembali', 522, 'Penyerahan Memori PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penyerahan_memori_pk', 'Y', 0),
		(1923, 12, 40, 'Peninjauan Kembali', 530, 'Penerimaan Jawaban PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_kontra_pk', 'Y', 0),
		(1924, 12, 40, 'Peninjauan Kembali', 540, 'Penyerahan Jawaban PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penyerahan_kontra_pk', 'Y', 0),
		(1925, 12, 40, 'Peninjauan Kembali', 550, 'Pengiriman Berkas PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'pengiriman_berkas_pk', 'Y', 0),
		(1926, 12, 40, 'Peninjauan Kembali', 560, 'Penerimaan Kembali Berkas PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_berkas_pk', 'Y', 0),
		(1927, 12, 40, 'Peninjauan Kembali', 570, 'Putusan PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'putusan_pk', 'Y', 0),
		(1928, 12, 40, 'Peninjauan Kembali', 571, 'Pemberitahuan Putusan PK', 30, '2', 570, 'perkara_pk', 'putusan_pk', 'perkara_pk', 'pemberitahuan_putusan_pk', 'Y', 1),
		(1929, 12, 50, 'Eksekusi', 600, 'Permohonan Eksekusi', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'permohonan_eksekusi', 'Y', 0),
		(1930, 12, 50, 'Eksekusi', 605, 'Penetapan Teguran Eksekusi', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_teguran_eksekusi', 'Y', 0),
		(1931, 12, 50, 'Eksekusi', 610, 'Pelaksaan Penegoran(Aanmaning)', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'pelaksanaan_teguran_eksekusi', 'Y', 0),
		(1932, 12, 50, 'Eksekusi', 615, 'Penetapan Sita Eksekusi', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_sita_eksekusi', 'Y', 0),
		(1933, 12, 50, 'Eksekusi', 620, 'Pelaksanaan Sita Eksekusi', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'pelaksanaan_sita_eksekusi', 'Y', 0),
		(1934, 12, 50, 'Eksekusi', 622, 'Penetapan Perintah Eksekusi Lelang', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_perintah_eksekusi_lelang', 'Y', 0),
		(1935, 12, 50, 'Eksekusi', 624, 'Pelaksanaan Eksekusi Lelang', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'pelaksanaan_eksekusi_lelang', 'Y', 0),
		(1936, 12, 50, 'Eksekusi', 626, 'Penyerahan Hasil Eksekusi Lelang', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penyerahan_hasil_lelang', 'Y', 0),
		(1937, 12, 50, 'Eksekusi', 628, 'Penetapan Perintah Eksekusi Rill', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_perintah_eksekusi_rill', 'Y', 0),
		(1938, 12, 50, 'Eksekusi', 630, 'Pelaksaan Eksekusi Rill', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'pelaksanaan_eksekusi_rill', 'Y', 0),
		(1939, 12, 50, 'Eksekusi', 640, 'Penetapan Sita Non Eksekutable', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_noneksekusi', 'Y', 0),
		(1940, 13, 10, 'Pendaftaran', 10, 'Pendaftaran Perkara', NULL, '', NULL, '', 'tanggal_pendaftaran', 'perkara', 'tanggal_pendaftaran', 'Y', 0),
		(1941, 13, 12, 'Penetapan', 20, 'Penetapan Majelis Hakim/Hakim', 3, '1', 10, 'perkara', 'tanggal_pendaftaran', 'perkara_penetapan', 'penetapan_majelis_hakim', 'Y', 1),
		(1942, 13, 12, 'Penetapan', 21, 'Penetapan Kembali Majelis Hakim/Hakim', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1943, 13, 12, 'Penetapan', 30, 'Penunjukan Panitera Pengganti', 3, '1', 10, 'perkara', 'tanggal_pendaftaran', 'perkara_penetapan', 'penetapan_panitera_pengganti', 'Y', 0),
		(1944, 13, 12, 'Penetapan', 31, 'Penunjukan Kembali Panitera Pengganti', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1945, 13, 12, 'Penetapan', 40, 'Penunjukan Jurusita', NULL, NULL, NULL, NULL, NULL, 'perkara_penetapan', 'penetapan_jurusita', 'Y', 0),
		(1946, 13, 12, 'Penetapan', 41, 'Penunjukan Kembali Jurusita', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1947, 13, 12, 'Penetapan', 80, 'Penetapan Hari Sidang Pertama', 3, '1', 20, 'perkara_penetapan', 'penetapan_majelis_hakim', 'perkara_penetapan', 'penetapan_hari_sidang', 'Y', 1),
		(1948, 13, 12, 'Penetapan', 81, 'Sidang pertama', NULL, '', NULL, '', 'penetapan_panitera_pengganti', 'perkara_penetapan', 'sidang_pertama', 'Y', 0),
		(1949, 13, 13, 'Mediasi', 110, 'Penetapan Mediator', 1, '1', 81, 'perkara_penetapan', 'sidang_pertama', 'perkara_mediasi', 'penetapan_penunjukan_mediator', 'Y', 0),
		(1950, 13, 13, 'Mediasi', 120, 'Penetapan Tanggal Mediasi', 2, '1', 110, 'perkara_mediasi', 'penetapan_penunjukan_mediator', 'perkara_mediasi', 'penetapan_tanggal_mediasi', 'Y', 0),
		(1951, 13, 13, 'Mediasi', 121, 'Mulai Mediasi', NULL, NULL, NULL, NULL, NULL, 'perkara_mediasi', 'dimulai_mediasi', 'Y', 0),
		(1952, 13, 13, 'Mediasi', 130, 'Kesepakatan Mediasi', 61, '1', 121, 'perkara_mediasi', 'dimulai_mediasi', 'perkara_mediasi', 'keputusan_mediasi', 'Y', 1),
		(1953, 13, 13, 'Mediasi', 150, 'Mediasi Tidak Berhasil', NULL, NULL, NULL, NULL, NULL, 'perkara_mediasi', 'mediasi_gagal', 'Y', 0),
		(1954, 13, 13, 'Mediasi', 151, 'Mediasi Tidak Dapat Dilaksanakan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1955, 13, 13, 'Mediasi', 180, 'Mediasi Berhasil', NULL, NULL, NULL, NULL, NULL, 'perkara_mediasi', 'mediasi_berhasil', 'Y', 0),
		(1956, 13, 13, 'Mediasi', 181, 'Mediasi Berhasil Sebagian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1957, 13, 13, 'Mediasi', 190, 'Penetapan Akta Perdamaian', NULL, NULL, NULL, NULL, NULL, 'perkara_mediasi', 'akta_perdamaian', 'Y', 0),
		(1958, 13, 14, 'Persidangan', 200, 'Persidangan', NULL, '', NULL, '', '', '', '', 'Y', 1),
		(1959, 13, 15, 'Putusan', 210, 'Putusan', 5, '3', 10, 'perkara', 'tanggal_pendaftaran', 'perkara_putusan', 'tanggal_putusan', 'Y', 1),
		(1960, 13, 15, 'Putusan', 211, 'Pencabutan Perkara', NULL, NULL, NULL, NULL, NULL, 'perkara_putusan', 'tanggal_cabut', 'Y', 0),
		(1961, 13, 15, 'Putusan', 212, 'Pernyataan Gugur', NULL, NULL, NULL, NULL, NULL, 'perkara_putusan', 'tanggal_gugur', 'Y', 0),
		(1962, 13, 15, 'Putusan', 218, 'Pemberitahuan Putusan', NULL, NULL, NULL, NULL, NULL, 'perkara_putusan', 'pemberitahuan_putusan', 'Y', 0),
		(1963, 13, 15, 'Putusan', 220, 'Pembuatan Minutasi', 14, '2', 210, 'perkara_putusan', 'tanggal_putusan', 'perkara_putusan', 'tanggal_minutasi', 'Y', 1),
		(1964, 13, 16, 'Verzet', 240, 'Pendaftaran Perlawanan(Verzet)', 14, '1', 230, 'perkara_putusan', 'pemberitahuan_putusan', 'perkara_verzet', 'tanggal_pendaftaran_verzet', 'Y', 0),
		(1965, 13, 16, 'Verzet', 241, 'Penetapan Majelis Hakim Verzet', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1966, 13, 16, 'Verzet', 242, 'Penetapan Panitera Pengganti Verzet', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1967, 13, 16, 'Verzet', 243, 'Penetapan Jurusita Verzet', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1968, 13, 16, 'Verzet', 250, 'Penetapan Jadwal Sidang Verzet', NULL, NULL, NULL, NULL, NULL, 'perkara_verzet', 'tanggal_penetapan_sidang_verzet', 'Y', 0),
		(1969, 13, 16, 'Verzet', 260, 'Sidang Pertama Perlawanan', NULL, NULL, NULL, NULL, NULL, 'perkara_verzet', 'tanggal_sidang_pertama_verzet', 'Y', 0),
		(1970, 13, 16, 'Verzet', 261, 'Persidangan Verzet', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(1971, 13, 16, 'Verzet', 270, 'Putusan Perlawanan  Verzet', NULL, NULL, NULL, NULL, NULL, 'perkara_verzet', 'putusan_verzet', 'Y', 0),
		(1972, 13, 16, 'Verzet', 280, 'Pemberitahuan Hasil Putusan Verzet', NULL, NULL, NULL, NULL, NULL, 'perkara_verzet', 'pemberitahuan_putusan_verzet', 'Y', 0),
		(1973, 13, 20, 'Banding', 290, 'Permohonan Banding', 14, '1', 210, 'perkara_putusan', 'tanggal_putusan', 'perkara_banding', 'permohonan_banding', 'Y', 0),
		(1974, 13, 20, 'Banding', 300, 'Pemberitahuan Permohonan Banding', 7, '2', 290, 'perkara_banding', 'permohonan_banding', 'perkara_banding', 'pemberitahuan_permohonan_banding', 'Y', 1),
		(1975, 13, 20, 'Banding', 310, 'Penerimaan Memori Banding', 0, '', NULL, NULL, NULL, 'perkara_banding', 'penerimaan_memori_banding', 'Y', 1),
		(1976, 13, 20, 'Banding', 320, 'Penyerahan Memori Banding', NULL, NULL, NULL, NULL, NULL, 'perkara_banding', 'penyerahan_memori_banding', 'Y', 0),
		(1977, 13, 20, 'Banding', 330, 'Penerimaan Kontra Memori Banding', 0, '', NULL, NULL, NULL, 'perkara_banding', 'penerimaan_kontra_banding', 'Y', 1),
		(1978, 13, 20, 'Banding', 340, 'Penyerahan Kontra Memori Banding', NULL, NULL, NULL, NULL, NULL, 'perkara_banding', 'penyerahan_kontra_banding', 'Y', 0),
		(1979, 13, 20, 'Banding', 350, 'Permberitahuan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_banding_detil', 'pemberitahuan_inzage', 'Y', 0),
		(1980, 13, 20, 'Banding', 360, 'Pelaksanaan Untuk Memeriksa Berkas(Inzage)', NULL, '', NULL, NULL, NULL, 'perkara_banding_detil', 'pelaksanaan_inzage', 'Y', 0),
		(1981, 13, 20, 'Banding', 370, 'Pengiriman Berkas  Banding', 30, '2', 290, 'perkara_banding', 'permohonan_banding', 'perkara_banding', 'pengiriman_berkas_banding', 'Y', 1),
		(1982, 13, 20, 'Banding', 380, 'Penerimaan Kembali Berkas Banding', NULL, NULL, NULL, NULL, NULL, 'perkara_banding', 'penerimaan_kembali_berkas_banding', 'Y', 0),
		(1983, 13, 20, 'Banding', 390, 'Putusan Banding', 3, '3', 290, 'perkara_banding', 'permohonan_banding', 'perkara_banding', 'putusan_banding', 'Y', 1),
		(1984, 13, 20, 'Banding', 391, 'Pencabutan Perkara Banding', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'T', 0),
		(1985, 13, 20, 'Banding', 400, 'Pemberitahuan Putusan Banding', 14, '2', 390, 'perkara_banding', 'putusan_banding', 'perkara_banding', 'pemberitahuan_putusan_banding', 'Y', 1),
		(1986, 13, 30, 'Kasasi', 410, 'Permohonan Kasasi', 14, '2', 400, 'perkara_banding', 'pemberitahuan_putusan_banding', 'perkara_kasasi', 'permohonan_kasasi', 'Y', 0),
		(1987, 13, 30, 'Kasasi', 420, 'Pemberitahuan Permohonan Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pemberitahuan_kasasi', 'Y', 0),
		(1988, 13, 30, 'Kasasi', 430, 'Penerimaan Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_memori_kasasi', 'Y', 0),
		(1989, 13, 30, 'Kasasi', 440, 'Penyerahan Memori Kasasi', 14, '2', 410, 'perkara_kasasi', 'permohonan_kasasi', 'perkara_kasasi', 'penyerahan_memori_kasasi', 'Y', 1),
		(1990, 13, 30, 'Kasasi', 450, 'Penerimaan Kontra Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_kontra_kasasi', 'Y', 0),
		(1991, 13, 30, 'Kasasi', 460, 'Penyerahan Kontra Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penyerahan_kontra_kasasi', 'Y', 0),
		(1992, 13, 30, 'Kasasi', 461, 'Permberitahuan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pemberitahuan_inzage_pemohon_kasasi', 'Y', 0),
		(1993, 13, 30, 'Kasasi', 464, 'Pelaksanaan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pelaksanaan_inzage_termohon_kasasi', 'Y', 0),
		(1994, 13, 30, 'Kasasi', 470, 'Pengiriman Berkas Kasasi', 65, '2', 410, 'perkara_kasasi', 'permohonan_kasasi', 'perkara_kasasi', 'pengiriman_berkas_kasasi', 'Y', 1),
		(1995, 13, 30, 'Kasasi', 480, 'Penerimaan Kembali Berkas Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_berkas_kasasi', 'Y', 0),
		(1996, 13, 30, 'Kasasi', 490, 'Putusan Kasasi', 6, '3', 410, 'perkara_kasasi', 'permohonan_kasasi', 'perkara_kasasi', 'putusan_kasasi', 'Y', 1),
		(1997, 13, 30, 'Kasasi', 500, 'Pemberitahuan Putus Kasasi', 30, '2', 490, 'perkara_kasasi', 'putusan_kasasi', 'perkara_kasasi', 'pemberitahuan_putusan_kasasi', 'Y', 1),
		(1998, 13, 40, 'Peninjauan Kembali', 510, 'Permohonan PK', NULL, '', NULL, '', 'pemberitahuan_putusan_kasasi', 'perkara_pk', 'permohonan_pk', 'Y', 0),
		(1999, 13, 40, 'Peninjauan Kembali', 520, 'Pemberitahuan PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'pemberitahuan_pk', 'Y', 0),
		(2000, 13, 40, 'Peninjauan Kembali', 521, 'Penerimaan Memori PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_memori_pk', 'Y', 0),
		(2001, 13, 40, 'Peninjauan Kembali', 522, 'Penyerahan Memori PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penyerahan_memori_pk', 'Y', 0),
		(2002, 13, 40, 'Peninjauan Kembali', 530, 'Penerimaan Jawaban PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_kontra_pk', 'Y', 0),
		(2003, 13, 40, 'Peninjauan Kembali', 540, 'Penyerahan Jawaban PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penyerahan_kontra_pk', 'Y', 0),
		(2004, 13, 40, 'Peninjauan Kembali', 550, 'Pengiriman Berkas PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'pengiriman_berkas_pk', 'Y', 0),
		(2005, 13, 40, 'Peninjauan Kembali', 560, 'Penerimaan Kembali Berkas PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_berkas_pk', 'Y', 0),
		(2006, 13, 40, 'Peninjauan Kembali', 570, 'Putusan PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'putusan_pk', 'Y', 0),
		(2007, 13, 40, 'Peninjauan Kembali', 571, 'Pemberitahuan Putusan PK', 30, '2', 570, 'perkara_pk', 'putusan_pk', 'perkara_pk', 'pemberitahuan_putusan_pk', 'Y', 1),
		(2008, 13, 50, 'Eksekusi', 600, 'Permohonan Eksekusi', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'permohonan_eksekusi', 'Y', 0),
		(2009, 13, 50, 'Eksekusi', 605, 'Penetapan Teguran Eksekusi', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_teguran_eksekusi', 'Y', 0),
		(2010, 13, 50, 'Eksekusi', 610, 'Pelaksaan Penegoran(Aanmaning)', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'pelaksanaan_teguran_eksekusi', 'Y', 0),
		(2011, 13, 50, 'Eksekusi', 615, 'Penetapan Sita Eksekusi', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_sita_eksekusi', 'Y', 0),
		(2012, 13, 50, 'Eksekusi', 620, 'Pelaksanaan Sita Eksekusi', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'pelaksanaan_sita_eksekusi', 'Y', 0),
		(2013, 13, 50, 'Eksekusi', 622, 'Penetapan Perintah Eksekusi Lelang', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_perintah_eksekusi_lelang', 'Y', 0),
		(2014, 13, 50, 'Eksekusi', 624, 'Pelaksanaan Eksekusi Lelang', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'pelaksanaan_eksekusi_lelang', 'Y', 0),
		(2015, 13, 50, 'Eksekusi', 626, 'Penyerahan Hasil Eksekusi Lelang', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penyerahan_hasil_lelang', 'Y', 0),
		(2016, 13, 50, 'Eksekusi', 628, 'Penetapan Perintah Eksekusi Rill', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_perintah_eksekusi_rill', 'Y', 0),
		(2017, 13, 50, 'Eksekusi', 630, 'Pelaksaan Eksekusi Rill', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'pelaksanaan_eksekusi_rill', 'Y', 0),
		(2018, 13, 50, 'Eksekusi', 640, 'Penetapan Sita Non Eksekutable', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_noneksekusi', 'Y', 0),
		(2019, 14, 10, 'Pendaftaran', 10, 'Pendaftaran Perkara', NULL, '', NULL, '', 'tanggal_pendaftaran', 'perkara', 'tanggal_pendaftaran', 'Y', 0),
		(2020, 14, 12, 'Penetapan', 20, 'Penetapan Majelis Hakim/Hakim', 3, '1', 10, 'perkara', 'tanggal_pendaftaran', 'perkara_penetapan', 'penetapan_majelis_hakim', 'Y', 1),
		(2021, 14, 12, 'Penetapan', 21, 'Penetapan Kembali Majelis Hakim/Hakim', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(2022, 14, 12, 'Penetapan', 30, 'Penunjukan Panitera Pengganti', 3, '1', 10, 'perkara', 'tanggal_pendaftaran', 'perkara_penetapan', 'penetapan_panitera_pengganti', 'Y', 0),
		(2023, 14, 12, 'Penetapan', 31, 'Penunjukan Kembali Panitera Pengganti', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(2024, 14, 12, 'Penetapan', 40, 'Penunjukan Jurusita', NULL, NULL, NULL, NULL, NULL, 'perkara_penetapan', 'penetapan_jurusita', 'Y', 0),
		(2025, 14, 12, 'Penetapan', 41, 'Penunjukan Kembali Jurusita', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(2026, 14, 12, 'Penetapan', 80, 'Penetapan Hari Sidang Pertama', 3, '1', 20, 'perkara_penetapan', 'penetapan_majelis_hakim', 'perkara_penetapan', 'penetapan_hari_sidang', 'Y', 1),
		(2027, 14, 12, 'Penetapan', 81, 'Sidang pertama', NULL, '', NULL, '', 'penetapan_panitera_pengganti', 'perkara_penetapan', 'sidang_pertama', 'Y', 0),
		(2028, 14, 13, 'Mediasi', 110, 'Penetapan Mediator', 1, '1', 81, 'perkara_penetapan', 'sidang_pertama', 'perkara_mediasi', 'penetapan_penunjukan_mediator', 'Y', 0),
		(2029, 14, 13, 'Mediasi', 120, 'Penetapan Tanggal Mediasi', 2, '1', 110, 'perkara_mediasi', 'penetapan_penunjukan_mediator', 'perkara_mediasi', 'penetapan_tanggal_mediasi', 'Y', 0),
		(2030, 14, 13, 'Mediasi', 121, 'Mulai Mediasi', NULL, NULL, NULL, NULL, NULL, 'perkara_mediasi', 'dimulai_mediasi', 'Y', 0),
		(2031, 14, 13, 'Mediasi', 130, 'Kesepakatan Mediasi', 61, '1', 121, 'perkara_mediasi', 'dimulai_mediasi', 'perkara_mediasi', 'keputusan_mediasi', 'Y', 1),
		(2032, 14, 13, 'Mediasi', 150, 'Mediasi Tidak Berhasil', NULL, NULL, NULL, NULL, NULL, 'perkara_mediasi', 'mediasi_gagal', 'Y', 0),
		(2033, 14, 13, 'Mediasi', 151, 'Mediasi Tidak Dapat Dilaksanakan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(2034, 14, 13, 'Mediasi', 180, 'Mediasi Berhasil', NULL, NULL, NULL, NULL, NULL, 'perkara_mediasi', 'mediasi_berhasil', 'Y', 0),
		(2035, 14, 13, 'Mediasi', 181, 'Mediasi Berhasil Sebagian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(2036, 14, 13, 'Mediasi', 190, 'Penetapan Akta Perdamaian', NULL, NULL, NULL, NULL, NULL, 'perkara_mediasi', 'akta_perdamaian', 'Y', 0),
		(2037, 14, 14, 'Persidangan', 200, 'Persidangan', NULL, '', NULL, '', '', '', '', 'Y', 1),
		(2038, 14, 15, 'Putusan', 210, 'Putusan', 5, '3', 10, 'perkara', 'tanggal_pendaftaran', 'perkara_putusan', 'tanggal_putusan', 'Y', 1),
		(2039, 14, 15, 'Putusan', 211, 'Pencabutan Perkara', NULL, NULL, NULL, NULL, NULL, 'perkara_putusan', 'tanggal_cabut', 'Y', 0),
		(2040, 14, 15, 'Putusan', 212, 'Pernyataan Gugur', NULL, NULL, NULL, NULL, NULL, 'perkara_putusan', 'tanggal_gugur', 'Y', 0),
		(2041, 14, 15, 'Putusan', 218, 'Pemberitahuan Putusan', NULL, NULL, NULL, NULL, NULL, 'perkara_putusan', 'pemberitahuan_putusan', 'Y', 0),
		(2042, 14, 15, 'Putusan', 220, 'Pembuatan Minutasi', 14, '2', 210, 'perkara_putusan', 'tanggal_putusan', 'perkara_putusan', 'tanggal_minutasi', 'Y', 1),
		(2043, 14, 16, 'Verzet', 240, 'Pendaftaran Perlawanan(Verzet)', 14, '1', 230, 'perkara_putusan', 'pemberitahuan_putusan', 'perkara_verzet', 'tanggal_pendaftaran_verzet', 'Y', 0),
		(2044, 14, 16, 'Verzet', 241, 'Penetapan Majelis Hakim Verzet', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(2045, 14, 16, 'Verzet', 242, 'Penetapan Panitera Pengganti Verzet', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(2046, 14, 16, 'Verzet', 243, 'Penetapan Jurusita Verzet', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(2047, 14, 16, 'Verzet', 250, 'Penetapan Jadwal Sidang Verzet', NULL, NULL, NULL, NULL, NULL, 'perkara_verzet', 'tanggal_penetapan_sidang_verzet', 'Y', 0),
		(2048, 14, 16, 'Verzet', 260, 'Sidang Pertama Perlawanan', NULL, NULL, NULL, NULL, NULL, 'perkara_verzet', 'tanggal_sidang_pertama_verzet', 'Y', 0),
		(2049, 14, 16, 'Verzet', 261, 'Persidangan Verzet', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', 0),
		(2050, 14, 16, 'Verzet', 270, 'Putusan Perlawanan  Verzet', NULL, NULL, NULL, NULL, NULL, 'perkara_verzet', 'putusan_verzet', 'Y', 0),
		(2051, 14, 16, 'Verzet', 280, 'Pemberitahuan Hasil Putusan Verzet', NULL, NULL, NULL, NULL, NULL, 'perkara_verzet', 'pemberitahuan_putusan_verzet', 'Y', 0),
		(2052, 14, 20, 'Banding', 290, 'Permohonan Banding', 14, '1', 210, 'perkara_putusan', 'tanggal_putusan', 'perkara_banding', 'permohonan_banding', 'Y', 0),
		(2053, 14, 20, 'Banding', 300, 'Pemberitahuan Permohonan Banding', 7, '2', 290, 'perkara_banding', 'permohonan_banding', 'perkara_banding', 'pemberitahuan_permohonan_banding', 'Y', 1),
		(2054, 14, 20, 'Banding', 310, 'Penerimaan Memori Banding', 0, '', NULL, NULL, NULL, 'perkara_banding', 'penerimaan_memori_banding', 'Y', 1),
		(2055, 14, 20, 'Banding', 320, 'Penyerahan Memori Banding', NULL, NULL, NULL, NULL, NULL, 'perkara_banding', 'penyerahan_memori_banding', 'Y', 0),
		(2056, 14, 20, 'Banding', 330, 'Penerimaan Kontra Memori Banding', 0, '', NULL, NULL, NULL, 'perkara_banding', 'penerimaan_kontra_banding', 'Y', 1),
		(2057, 14, 20, 'Banding', 340, 'Penyerahan Kontra Memori Banding', NULL, NULL, NULL, NULL, NULL, 'perkara_banding', 'penyerahan_kontra_banding', 'Y', 0),
		(2058, 14, 20, 'Banding', 350, 'Permberitahuan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_banding_detil', 'pemberitahuan_inzage', 'Y', 0),
		(2059, 14, 20, 'Banding', 360, 'Pelaksanaan Untuk Memeriksa Berkas(Inzage)', NULL, '', NULL, NULL, NULL, 'perkara_banding_detil', 'pelaksanaan_inzage', 'Y', 0),
		(2060, 14, 20, 'Banding', 370, 'Pengiriman Berkas  Banding', 30, '2', 290, 'perkara_banding', 'permohonan_banding', 'perkara_banding', 'pengiriman_berkas_banding', 'Y', 1),
		(2061, 14, 20, 'Banding', 380, 'Penerimaan Kembali Berkas Banding', NULL, NULL, NULL, NULL, NULL, 'perkara_banding', 'penerimaan_kembali_berkas_banding', 'Y', 0),
		(2062, 14, 20, 'Banding', 390, 'Putusan Banding', 3, '3', 290, 'perkara_banding', 'permohonan_banding', 'perkara_banding', 'putusan_banding', 'Y', 1),
		(2063, 14, 20, 'Banding', 391, 'Pencabutan Perkara Banding', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'T', 0),
		(2064, 14, 20, 'Banding', 400, 'Pemberitahuan Putusan Banding', 14, '2', 390, 'perkara_banding', 'putusan_banding', 'perkara_banding', 'pemberitahuan_putusan_banding', 'Y', 1),
		(2065, 14, 30, 'Kasasi', 410, 'Permohonan Kasasi', 14, '2', 400, 'perkara_banding', 'pemberitahuan_putusan_banding', 'perkara_kasasi', 'permohonan_kasasi', 'Y', 0),
		(2066, 14, 30, 'Kasasi', 420, 'Pemberitahuan Permohonan Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pemberitahuan_kasasi', 'Y', 0),
		(2067, 14, 30, 'Kasasi', 430, 'Penerimaan Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_memori_kasasi', 'Y', 0),
		(2068, 14, 30, 'Kasasi', 440, 'Penyerahan Memori Kasasi', 14, '2', 410, 'perkara_kasasi', 'permohonan_kasasi', 'perkara_kasasi', 'penyerahan_memori_kasasi', 'Y', 1),
		(2069, 14, 30, 'Kasasi', 450, 'Penerimaan Kontra Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_kontra_kasasi', 'Y', 0),
		(2070, 14, 30, 'Kasasi', 460, 'Penyerahan Kontra Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penyerahan_kontra_kasasi', 'Y', 0),
		(2071, 14, 30, 'Kasasi', 461, 'Permberitahuan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pemberitahuan_inzage_pemohon_kasasi', 'Y', 0),
		(2072, 14, 30, 'Kasasi', 464, 'Pelaksanaan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pelaksanaan_inzage_termohon_kasasi', 'Y', 0),
		(2073, 14, 30, 'Kasasi', 470, 'Pengiriman Berkas Kasasi', 65, '2', 410, 'perkara_kasasi', 'permohonan_kasasi', 'perkara_kasasi', 'pengiriman_berkas_kasasi', 'Y', 1),
		(2074, 14, 30, 'Kasasi', 480, 'Penerimaan Kembali Berkas Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_berkas_kasasi', 'Y', 0),
		(2075, 14, 30, 'Kasasi', 490, 'Putusan Kasasi', 6, '3', 410, 'perkara_kasasi', 'permohonan_kasasi', 'perkara_kasasi', 'putusan_kasasi', 'Y', 1),
		(2076, 14, 30, 'Kasasi', 500, 'Pemberitahuan Putus Kasasi', 30, '2', 490, 'perkara_kasasi', 'putusan_kasasi', 'perkara_kasasi', 'pemberitahuan_putusan_kasasi', 'Y', 1),
		(2077, 14, 40, 'Peninjauan Kembali', 510, 'Permohonan PK', NULL, '', NULL, '', 'pemberitahuan_putusan_kasasi', 'perkara_pk', 'permohonan_pk', 'Y', 0),
		(2078, 14, 40, 'Peninjauan Kembali', 520, 'Pemberitahuan PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'pemberitahuan_pk', 'Y', 0),
		(2079, 14, 40, 'Peninjauan Kembali', 521, 'Penerimaan Memori PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_memori_pk', 'Y', 0),
		(2080, 14, 40, 'Peninjauan Kembali', 522, 'Penyerahan Memori PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penyerahan_memori_pk', 'Y', 0),
		(2081, 14, 40, 'Peninjauan Kembali', 530, 'Penerimaan Jawaban PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_kontra_pk', 'Y', 0),
		(2082, 14, 40, 'Peninjauan Kembali', 540, 'Penyerahan Jawaban PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penyerahan_kontra_pk', 'Y', 0),
		(2083, 14, 40, 'Peninjauan Kembali', 550, 'Pengiriman Berkas PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'pengiriman_berkas_pk', 'Y', 0),
		(2084, 14, 40, 'Peninjauan Kembali', 560, 'Penerimaan Kembali Berkas PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_berkas_pk', 'Y', 0),
		(2085, 14, 40, 'Peninjauan Kembali', 570, 'Putusan PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'putusan_pk', 'Y', 0),
		(2086, 14, 40, 'Peninjauan Kembali', 571, 'Pemberitahuan Putusan PK', 30, '2', 570, 'perkara_pk', 'putusan_pk', 'perkara_pk', 'pemberitahuan_putusan_pk', 'Y', 1),
		(2087, 14, 50, 'Eksekusi', 600, 'Permohonan Eksekusi', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'permohonan_eksekusi', 'Y', 0),
		(2088, 14, 50, 'Eksekusi', 605, 'Penetapan Teguran Eksekusi', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_teguran_eksekusi', 'Y', 0),
		(2089, 14, 50, 'Eksekusi', 610, 'Pelaksaan Penegoran(Aanmaning)', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'pelaksanaan_teguran_eksekusi', 'Y', 0),
		(2090, 14, 50, 'Eksekusi', 615, 'Penetapan Sita Eksekusi', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_sita_eksekusi', 'Y', 0),
		(2091, 14, 50, 'Eksekusi', 620, 'Pelaksanaan Sita Eksekusi', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'pelaksanaan_sita_eksekusi', 'Y', 0),
		(2092, 14, 50, 'Eksekusi', 622, 'Penetapan Perintah Eksekusi Lelang', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_perintah_eksekusi_lelang', 'Y', 0),
		(2093, 14, 50, 'Eksekusi', 624, 'Pelaksanaan Eksekusi Lelang', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'pelaksanaan_eksekusi_lelang', 'Y', 0),
		(2094, 14, 50, 'Eksekusi', 626, 'Penyerahan Hasil Eksekusi Lelang', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penyerahan_hasil_lelang', 'Y', 0),
		(2095, 14, 50, 'Eksekusi', 628, 'Penetapan Perintah Eksekusi Rill', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_perintah_eksekusi_rill', 'Y', 0),
		(2096, 14, 50, 'Eksekusi', 630, 'Pelaksaan Eksekusi Rill', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'pelaksanaan_eksekusi_rill', 'Y', 0),
		(2097, 14, 50, 'Eksekusi', 640, 'Penetapan Sita Non Eksekutable', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_noneksekusi', 'Y', 0);");


		$this->patching->exe_script("REPLACE INTO template_dokumen (id, alur_perkara_id, tahapan_id, proses_id, nomor, kode, nama)
		VALUES 
		(1583,9,13,114,1,'G_9_13_114_1','Penetapan Sidang Pertama Perlawanan'),
		(1585,9,10,10,1,'G_9_10_10_1','Resume Gugatan (Meja I)'),
		(1590,9,10,10,2,'G_9_10_10_2','Penetapan Permohonan Acara Cepat dikabulkan/Pen. Majelis Hakim Tunggal'),
		(1591,9,10,10,3,'G_9_10_10_3','Penetapan Permohonan Acara Cepat ditolak/Pen. Majelis Hakim Acara Biasa'),
		(1594,9,10,10,8,'G_9_10_10_8','Penetapan Penundaan Keputusan TUN dikabulkan oleh Ketua'),
		(1595,9,12,16,1,'G_9_12_16_1','Penetapan Lolos Dismissal'),
		(1596,9,12,16,2,'G_9_12_16_2','Penetapan Dismissal'),
		(1597,9,12,15,1,'G_9_12_15_1','Surat Panggilan Proses Dissmisal kepada Penggugat'),
		(1598,9,12,15,2,'G_9_12_15_2','Surat Panggilan Proses Dissmisal kepada Tergugat'),
		(1601,9,10,16,5,'G_9_10_16_5','Berita Acara Proses Dismissal Tunda'),
		(1602,9,10,16,6,'G_9_10_16_6','Berita Acara Proses Dismissal Pembacaan Penetapan'),
		(1603,9,10,16,7,'G_9_10_16_7','Penetapan Penunjukan Majelis Hakim Acara Singkat (perlawanan)'),
		(1604,9,10,16,8,'G_9_10_16_8','Surat Penunjukan Panitera/Panitera Pengganti Acara Singkat'),
		(1605,9,10,16,9,'G_9_10_16_9','Surat Penunjukan Juru Sita/ Juru Sita Pengganti Acara Singkat'),
		(1606,9,13,112,1,'G_9_13_112_1','Surat Penunjukan Panitera Pengganti Perlawanan'),
		(1612,9,14,115,1,'G_9_14_115_1','Berita Acara Sidang Perlawanan 1 (Acara Singkat) Tunda'),
		(1613,9,14,115,2,'G_9_14_115_2','Berita Acara Sidang Perlawanan 2 (Acara Singkat) Tunda'),
		(1614,9,14,115,3,'G_9_14_115_3','Berita Acara Sidang Perlawanan 3 (Acara Singkat) Putusan'),
		(1615,9,15,219,1,'G_9_15_219_1','Putusan Perlawanan Diterima'),
		(1616,9,15,219,1,'G_9_15_219_2','Putusan Perlawanan Ditolak'),
		(1617,9,15,231,1,'G_9_15_231_1','Surat Pemberitahuan Putusan Perlawanan kepada Penggugat'),
		(1618,9,15,232,1,'G_9_15_232_1','Surat Pemberitahuan Putusan Perlawanan kepada Tergugat'),
		(1620,9,12,30,1,'G_9_12_30_1','Surat Penunjukan Panitera/Panitera Pengganti Acara Cepat'),
		(1621,9,12,30,2,'G_9_12_30_2','Surat Penunjukan Juru Sita/ Juru Sita Pengganti Acara Cepat'),
		(1622,9,14,200,1,'G_9_14_200_27','BAP Acara Cepat 1 Tunda'),
		(1623,9,14,200,2,'G_9_14_200_28','BAP Acara Cepat 2 Tunda'),
		(1624,9,14,200,3,'G_9_14_200_29','BAP Acara Cepat 3 Putusan'),
		(1625,9,15,210,1,'G_9_15_210_1','Putusan Acara Cepat'),
		(1626,9,12,20,1,'G_9_12_20_1','Penetapan Majelis Hakim'),
		(1627,9,12,16,3,'G_9_12_16_3','Pemberitahuan Penetapan Dismissal Untuk Penggugat'),
		(1628,9,12,16,4,'G_9_12_16_4','Pemberitahuan Penetapan Dismissal Untuk Tergugat'),
		(1631,9,12,30,3,'G_9_12_30_3','Surat Penunjukan Panitera/Panitera Pengganti'),
		(1632,9,12,40,1,'G_9_12_40_1','Surat Penunjukan Juru Sita/Juru Sita Pengganti'),
		(1633,9,12,42,1,'G_9_12_42_1','Penetapan Hari Pemeriksaan Persiapan'),
		(1640,9,12,42,2,'G_9_12_42_2','Surat Panggilan Pemeriksaan Persiapan kepada Penggugat'),
		(1641,9,12,42,3,'G_9_12_42_3','Surat Panggilan Pemeriksaan Persiapan kepada Tergugat'),
		(1646,9,14,200,4,'G_9_14_200_30','Berita Acara Pemeriksaan Persiapan I'),
		(1647,9,14,200,5,'G_9_14_200_31','Berita Acara Pemeriksaan Persiapan II'),
		(1648,9,14,200,6,'G_9_14_200_6','Berita Acara Pemeriksaan Persiapan III'),
		(1649,9,14,200,7,'G_9_14_200_7','Berita Acara Pemeriksaan Persiapan IV '),
		(1650,9,14,200,8,'G_9_14_200_8','Berita Acara Pemeriksaan Persiapan V (Pembacaan Putusan Tidak Dapat Diterima) '),
		(1652,9,15,210,2,'G_9_15_210_2','Putusan Sela Tidak Dapat Diterima'),
		(1653,9,14,80,2,'G_9_14_80_2','Penetapan Hari Persidangan Pertama'),
		(1654,9,14,200,1,'G_9_14_200_1','Surat Panggilan Sidang kepada Penggugat'),
		(1655,9,14,200,2,'G_9_14_200_2','Surat Panggilan Sidang kepada Tergugat'),
		(1656,9,14,200,3,'G_9_14_200_3','Surat Panggilan Sidang kepada Intervensi'),
		(1657,9,14,200,4,'G_9_14_200_4','Surat Panggilan Saksi'),
		(1658,9,14,200,5,'G_9_14_200_5','Surat Panggilan Ahli'),
		(1659,9,14,200,9,'G_9_14_200_9','BAP  Pembacaan Gugatan'),
		(1660,9,14,200,10,'G_9_14_200_10','BAP  Pembacaan Jawaban'),
		(1665,9,14,200,11,'G_9_14_200_11','BAP Putusan Sela Penetapan Pihak Intervensi'),
		(1666,9,14,200,12,'G_9_14_200_12','BAP Putusan Sela Penetapan Penundaan KTUN'),
		(1667,9,14,200,13,'G_9_14_200_13','BAP Penyerahan Replik'),
		(1668,9,14,200,14,'G_9_14_200_14','BAP Penyerahan Duplik'),
		(1669,9,14,200,15,'G_9_14_200_15','BAP Pencabutan Gugatan'),
		(1670,9,12,211,1,'G_9_12_211_1','Putusan Sela Penetapan Pencabutan Gugatan Dikabulkan'),
		(1671,9,14,200,16,'G_9_14_200_16','BAP Penyerahan Bukti P'),
		(1672,9,14,200,17,'G_9_14_200_17','BAP Penyerahan Bukti T'),
		(1673,9,14,200,18,'G_9_14_200_18','BAP Penyerahan Bukti TII Intervensi'),
		(1674,9,14,200,19,'G_9_14_200_19','BAP Penyerahan Bukti P dan Bukti T'),
		(1675,9,14,200,20,'G_9_14_200_20','BAP Penyerahan Bukti P, Bukti T dan Bukti TII Intervensi'),
		(1676,9,14,200,21,'G_9_14_200_21','BAP Pemeriksaan Saksi P'),
		(1677,9,14,200,22,'G_9_14_200_22','BAP Pemeriksaan Saksi T'),
		(1678,9,14,200,23,'G_9_14_200_23','BAP Pemeriksaan Saksi P dan Saksi T'),
		(1679,9,14,200,24,'G_9_14_200_24','BAP Pemeriksaan Saksi P, Saksi T dan Saksi TII Intervensi'),
		(1680,9,14,200,25,'G_9_14_200_25','BAP Kesimpulan'),
		(1681,9,14,200,26,'G_9_14_200_26','BAP Putusan'),
		(1682,9,15,210,3,'G_9_15_210_3','Putusan Dikabulkan'),
		(1683,9,15,210,4,'G_9_15_210_4','Putusan Ditolak'),
		(1684,9,15,210,5,'G_9_15_210_5','Putusan Gugur'),
		(1685,9,15,218,1,'G_9_15_218_1','Surat Pemberitahuan Amar Putusan kepada Penggugat'),
		(1686,9,15,218,2,'G_9_15_218_2','Surat Pemberitahuan Amar Putusan kepada Tergugat'),
		(1687,9,15,233,1,'G_9_15_233_1','Surat Pemberitahuan Amar Putusan kepada Tergugat II Intervensi'),
		(1688,9,20,290,1,'G_9_20_290_1','Surat keterangan lewat waktu banding'),
		(1689,9,20,290,2,'G_9_20_290_2','Akta Permohonan Banding oleh Penggugat'),
		(1690,9,20,290,3,'G_9_20_290_3','Akta Permohonan Banding oleh Kuasa Penggugat'),
		(1691,9,20,290,4,'G_9_20_290_4','Akta Permohonan Banding oleh Tergugat'),
		(1692,9,20,290,5,'G_9_20_290_5','Akta Permohonan Banding oleh Kuasa Tergugat'),
		(1693,9,20,300,1,'G_9_20_300_1','Surat pemberitahuan pernyataan banding kepada penggugat/Terbanding'),
		(1694,9,20,300,2,'G_9_20_300_2','Surat pemberitahuan pernyataan banding kepada kuasa penggugat'),
		(1695,9,20,300,3,'G_9_20_300_3','Surat pemberitahuan pernyataan banding kepada Tergugat'),
		(1696,9,20,300,4,'G_9_20_300_4','Surat pemberitahuan pernyataan banding kepada Kuasa Tergugat atau Tergugat II Intervensi'),
		(1697,9,20,320,1,'G_9_20_320_1','Surat pemberitahuan memori banding kepada penggugat'),
		(1698,9,20,320,2,'G_9_20_320_2','Surat pemberitahuan memori banding kepada kuasa penggugat'),
		(1699,9,20,320,3,'G_9_20_320_3','Surat pemberitahuan memori banding kepada tergugat atau tergugat II intervensi'),
		(1700,9,20,320,4,'G_9_20_320_4','Surat pemberitahuan memori banding kepada kuasa tergugat atau tergugat II intervensi'),
		(1703,9,20,340,1,'G_9_20_340_1','Surat pemberitahuan kontra memori banding kepada penggugat'),
		(1704,9,20,340,2,'G_9_20_340_2','Surat pemberitahuan kontra memori banding kepada kuasa penggugat'),
		(1711,9,20,340,3,'G_9_20_340_3','Surat pemberitahuan kontra memori banding kepada tergugat atau tergugat II intervensi'),
		(1712,9,20,340,4,'G_9_20_340_4','Surat pemberitahuan kontra memori banding kepada kuasa tergugat atau tergugat II intervensi'),
		(1713,9,20,360,1,'G_9_20_360_1','Surat pemberitahuan melihat berkas perkara kepada penggugat'),
		(1714,9,20,360,2,'G_9_20_360_2','Surat pemberitahuan melihat berkas perkara kepada kuasa penggugat'),
		(1715,9,20,360,3,'G_9_20_360_3','Surat pemberitahuan melihat berkas perkara kepada tergugat atau tergugat II intervensi'),
		(1716,9,20,360,4,'G_9_20_360_4','Surat pemberitahuan melihat berkas perkara kepada kuasa tergugat atau tergugat II intervensi'),
		(1717,9,13,111,1,'G_9_13_111_1','Penetapan Majelis Hakim Perlawanan'),
		(1718,9,12,80,1,'G_9_12_80_1','Penetapan Hari Sidang Pertama'),
		(1720,9,12,20,2,'G_9_12_20_2','Penetapan Penunjukan Hakim Tunggal'),
		(1722,9,12,21,1,'G_9_12_21_1','Penetapan Kembali Majelis Hakim'),
		(1723,9,20,400,1,'G_9_20_400_1','Surat pemberitahuan putusan banding kepada penggugat'),
		(1724,9,20,400,2,'G_9_20_400_2','Surat pemberitahuan putusan banding kepada kuasa penggugat'),
		(1725,9,20,400,3,'G_9_20_400_3','Surat pemberitahuan putusan banding kepada tergugat atau atau Tergugat II Intervensi'),
		(1726,9,20,400,4,'G_9_20_400_4','Surat pemberitahuan putusan banding kepada kuasa tergugat atau atau Tergugat II Intervensi'),
		(1727,9,30,410,1,'G_9_30_410_1','Akta permohonan kasasi oleh penggugat'),
		(1728,9,30,410,2,'G_9_30_410_2','Akta permohonan kasasi oleh kuasa penggugat'),
		(1729,9,30,410,3,'G_9_30_410_3','Akta permohonan kasasi oleh Tergugat'),
		(1730,9,30,410,4,'G_9_30_410_4','Akta permohonan kasasi oleh kuasa Tergugat'),
		(1739,9,30,420,1,'G_9_30_420_1','Surat pemberitahuan pernyataan kasasi Kepada penggugat'),
		(1740,9,30,420,2,'G_9_30_420_2','Surat pemberitahuan pernyataan kasasi Kepada kuasa penggugat'),
		(1741,9,30,420,3,'G_9_30_420_3','Surat pemberitahuan pernyataan kasasi Kepada Tergugat'),
		(1742,9,30,420,4,'G_9_30_420_4','Surat pemberitahuan pernyataan kasasi Kepada kuasa Tergugat'),
		(1747,9,30,410,5,'G_9_30_410_5','Penetapan Tidak Memenuhi syarat Formil karena terlambat mengajukan permohonan kasasi'),
		(1748,9,30,410,6,'G_9_30_410_6','Penetapan Tidak Memenuhi syarat Formil karena tidak atau terlambat mengajukan memori kasasi'),
		(1749,9,30,410,7,'G_9_30_410_7','Penetapan Pasal 45'),
		(1750,9,30,430,1,'G_9_30_430_1','Surat pemberitahuan dan penyerahan memori kasasi kepada penggugat'),
		(1754,9,30,430,2,'G_9_30_430_2','Surat pemberitahuan dan penyerahan memori kasasi kepada kuasa penggugat'),
		(1755,9,30,430,3,'G_9_30_430_3','Surat pemberitahuan dan penyerahan memori kasasi kepada tergugat atau tergugat intervensi'),
		(1756,9,30,430,4,'G_9_30_430_4','Surat pemberitahuan dan penyerahan memori kasasi kepada kuasa tergugat atau tergugat intervensi'),
		(1759,9,30,460,1,'G_9_30_460_1','Surat pemberitahuan dan penyerahan kontra memori kasasi kepada penggugat'),
		(1760,9,30,460,2,'G_9_30_460_2','Surat pemberitahuan dan penyerahan kontra memori kasasi kepada kuasa penggugat'),
		(1761,9,30,460,3,'G_9_30_460_3','Surat pemberitahuan dan penyerahan kontra memori kasasi kepada tergugat atau tergugat intervensi'),
		(1762,9,30,460,4,'G_9_30_460_4','Surat pemberitahuan dan penyerahan kontra memori kasasi kepada kuasa tergugat atau tergugat intervensi'),
		(1763,9,30,500,1,'G_9_30_500_1','Surat pemberitahuan putusan kasasi kepada penggugat'),
		(1764,9,30,500,2,'G_9_30_500_2','Surat pemberitahuan putusan kasasi kepada kuasa penggugat'),
		(1765,9,30,500,3,'G_9_30_500_3','Surat pemberitahuan putusan kasasi kepada tergugat atau tergugat intervensi'),
		(1766,9,30,500,4,'G_9_30_500_4','Surat pemberitahuan putusan kasasi kepada kuasa tergugat atau tergugat intervensi'),
		(1767,9,40,510,1,'G_9_40_510_1','Akta Permohonan Peninjauan Kembali Penggugat'),
		(1768,9,40,520,1,'G_9_40_520_1','Surat Pemberitahuan dan Penyerahan Memori PK Kepada Penggugat'),
		(1769,9,40,540,1,'G_9_40_540_1','Surat Pemberitahuan dan Penyerahan Kontra Memori PK Kepada Penggugat'),
		(1770,9,40,510,6,'G_9_40_510_6','Akta pencabutan permohonan  PK Penggugat'),
		(1775,9,40,510,9,'G_9_40_510_9','Surat pemberitahuan pencabutan permohonan PK'),
		(1776,9,40,571,1,'G_9_40_571_1','Surat Pemberitahuan Putusan PK Kepada Penggugat'),
		(1777,9,50,600,1,'G_9_50_600_1','Surat panggilan eksekusi'),
		(1779,9,50,600,2,'G_9_50_600_2','Surat pengumuman eksekusi di media '),
		(1780,9,12,20,3,'G_9_12_20_3','Penetapan Majelis Hakim Penolakan Acara Singkat'),
		(1782,9,10,10,7,'G_9_10_10_7','Surat pemberitahuan perkara KIP'),
		(1814,9,12,200,2,'G_9_12_200_2','Surat Teguran Pelaksanaan  Penundaan Keputusan TUN'),
		(1815,9,10,10,6,'G_9_10_10_6','Penetapan izin kuasa insidentil'),
		(1817,9,50,600,3,'G_9_50_600_3','Penetapan Permohonan Eksekusi'),
		(1818,9,50,610,1,'G_9_50_610_1','Surat Eksekusi otomatis (Pengawasan Pelaksanaan eksekusi)'),
		(1819,9,50,610,2,'G_9_50_610_2','Surat meminta penjelasan (Pengawasan Pelaksanaan eksekusi)'),
		(1820,9,50,610,3,'G_9_50_610_3','Surat teguran (Pengawasan Pelaksanaan eksekusi)'),
		(1821,9,50,610,4,'G_9_50_610_4','Surat ke Presiden  (Pengawasan Pelaksanaan eksekusi)'),
		(1822,9,50,610,5,'G_9_50_610_5','Surat ke DPR  (Pengawasan Pelaksanaan eksekusi)'),
		(1825,9,12,31,1,'G_9_12_31_1','Surat Pergantian Penunjukkan Panitera Pengganti'),
		(1826,9,10,16,10,'G_9_10_16_10','Berita Acara Proses Dismisal Tunda 2'),
		(1828,9,50,615,1,'G_9_50_615_1','Penetapan Eksekusi'),
		(1829,9,20,290,6,'G_9_20_290_6','Akta Permohonan Banding oleh Intervensi'),
		(1830,9,20,290,7,'G_9_20_290_7','Akta Permohonan Banding oleh Kuasa Intervensi'),
		(1834,9,30,420,5,'G_9_30_420_5','Surat pemberitahuan pernyataan kasasi Kepada Intervensi'),
		(1835,9,40,510,2,'G_9_40_510_2','Akta Permohonan Peninjauan Kembali Kuasa Penggugat'),
		(1836,9,40,510,3,'G_9_40_510_3','Akta Permohonan Peninjauan Kembali Tergugat'),
		(1837,9,40,510,4,'G_9_40_510_4','Akta Permohonan Peninjauan Kembali Kuasa Tergugat'),
		(1838,9,40,520,2,'G_9_40_520_2','Surat Pemberitahuan dan Penyerahan Memori PK Kepada Kuasa Penggugat'),
		(1839,9,40,520,3,'G_9_40_520_3','Surat Pemberitahuan dan Penyerahan Memori PK Kepada Tergugat'),
		(1840,9,40,520,4,'G_9_40_520_4','Surat Pemberitahuan dan Penyerahan Memori PK Kepada Kuasa Tergugat'),
		(1841,9,40,540,2,'G_9_40_540_2','Surat Pemberitahuan dan Penyerahan Kontra Memori PK Kepada Kuasa Penggugat'),
		(1842,9,40,540,3,'G_9_40_540_3','Surat Pemberitahuan dan Penyerahan Kontra Memori PK Kepada Tergugat'),
		(1843,9,40,540,4,'G_9_40_540_4','Surat Pemberitahuan dan Penyerahan Kontra Memori PK Kepada Kuasa Tergugat'),
		(1844,9,40,571,2,'G_9_40_571_2','Surat Pemberitahuan Putusan PK Kepada Kuasa Penggugat'),
		(1845,9,40,571,3,'G_9_40_571_3','Surat Pemberitahuan Putusan PK Kepada Tegugat'),
		(1846,9,40,571,4,'G_9_40_571_4','Surat Pemberitahuan Putusan PK Kepada Kuasa Tergugat'),
		(1847,9,40,510,5,'G_9_40_510_5','Akta Permohonan Peninjauan Kembali Intervensi'),
		(1848,9,40,520,5,'G_9_40_520_5','Surat Pemberitahuan dan Penyerahan Memori PK Kepada Pihak Intervensi'),
		(1849,9,20,290,8,'G_9_20_290_8','Akta Pencabutan Permohonan Banding Penggugat'),
		(1850,9,20,290,9,'G_9_20_290_9','Akta Pencabutan Permohonan Banding Kuasa Penggugat'),
		(1851,9,20,290,10,'G_9_20_290_10','Akta Pencabutan Permohonan Banding Tergugat'),
		(1852,9,20,290,11,'G_9_20_290_11','Akta Pencabutan Permohonan Banding Kuasa Tergugat'),
		(1853,9,20,290,12,'G_9_20_290_12','Akta Pencabutan Permohonan Banding Intervensi'),
		(1854,9,30,461,1,'G_9_30_461_1','Surat pemberitahuan melihat berkas perkara kepada Penggugat'),
		(1855,9,30,461,2,'G_9_30_461_2','Surat pemberitahuan melihat berkas perkara kepada Kuasa Penggugat'),
		(1856,9,30,461,3,'G_9_30_461_3','Surat pemberitahuan melihat berkas perkara kepada Tergugat'),
		(1857,9,30,461,4,'G_9_30_461_4','Surat pemberitahuan melihat berkas perkara kepada Kuasa Penggugat'),
		(1858,9,30,461,5,'G_9_30_260_5','Surat pemberitahuan melihat berkas perkara kepada Intervensi'),
		(1859,9,10,10,9,'G_9_10_10_9','Penetapan Penundaan Pelaksanaan Keputusan TUN Ditolak oleh Ketua'),
		(1860,9,12,211,2,'G_9_12_211_2','Putusan Sela Penetapan Pencabutan Gugatan Ditolak'),
		(1861,9,12,211,3,'G_9_12_211_3','Putusan Sela Penetapan Penundaan Pelaksanaan KTUN Dikabulkan oleh Majelis Hakim'),
		(1862,9,12,211,4,'G_9_12_211_4','Putusan Sela Penetapan Penundaan Pelaksanaan KTUN Ditolak oleh Majelis Hakim'),
		(1863,9,12,211,5,'G_9_12_211_5','Putusan Sela Penetapan Pihak Intervensi dikabulkan'),
		(1864,9,12,211,6,'G_9_12_211_6','Putusan Sela Penetapan Pihak Intervensi ditolak'),
		(1865,9,30,410,8,'G_9_30_410_8','Akta Pencabutan Permohonan Kasasi oleh Penggugat'),
		(1866,9,30,410,9,'G_9_30_410_9','Akta Pencabutan Permohonan Kasasi oleh  Kuasa Penggugat'),
		(1867,9,30,410,10,'G_9_30_410_10','Akta Pencabutan Permohonan Kasasi oleh  Tergugat'),
		(1868,9,30,410,11,'G_9_30_410_11','Akta Pencabutan Permohonan Kasasi oleh  Kuasa Penggugat'),
		(1869,9,30,410,12,'G_9_30_410_12','Akta Pencabutan Permohonan Kasasi oleh  Intervensi'),
		(1870,9,30,500,5,'G_9_30_500_5','Surat Pemberitahuan Putusan Kasasi kepada Intervensi'),
		(1871,9,30,430,5,'G_9_30_430_5','Surat pemberitahuan dan penyerahan memori kasasi kepda Intervensi'),
		(1872,9,30,460,5,'G_9_30_460_5','Surat pemberitahuan dan penyerahan kontra memori kasasi kepada Intervensi'),
		(1873,9,40,540,5,'G_9_40_540_5','Surat Pemberitahuan dan Penyerahan Kontra Memori PK Kepada Intervensi'),
		(1874,9,40,571,5,'G_9_40_571_5','Surat Pemberitahuan Putusan PK Kepada Intervensi');");


		$this->patching->exe_script("DROP FUNCTION IF EXISTS GetListParaPihakText;");
		$this->patching->exe_script("CREATE FUNCTION GetListParaPihakText(var_id BIGINT) RETURNS VARCHAR(3000) DETERMINISTIC
				BEGIN
						  DECLARE listpihak1 VARCHAR(3000);
						  DECLARE listpihak2 VARCHAR(3000);
						  DECLARE listpihak3 VARCHAR(3000);
						  DECLARE listpihak4 VARCHAR(3000);
						  DECLARE listparapihak VARCHAR(3000);
						  DECLARE alurPerkaraId INTEGER;
						  DECLARE jenisPerkaraId INTEGER;
						  DECLARE pihak1Nama VARCHAR(250);
						  DECLARE pihak2Nama VARCHAR(250);
						  DECLARE pihak3Nama VARCHAR(250);
						  DECLARE pihak4Nama VARCHAR(250);
						  DECLARE tahapanId INTEGER;
						   
						    SELECT pihak1_text INTO listpihak1 FROM perkara  WHERE perkara_id=var_id ;
						    SELECT pihak2_text INTO listpihak2 FROM perkara  WHERE perkara_id=var_id ;
						    SELECT pihak3_text INTO listpihak3 FROM perkara  WHERE perkara_id=var_id ;
						    SELECT pihak4_text INTO listpihak4 FROM perkara  WHERE perkara_id=var_id ;
						    
						    SELECT alur_perkara_id INTO alurPerkaraId FROM perkara WHERE perkara_id=var_id;
						    SELECT jenis_perkara_id INTO jenisPerkaraId FROM perkara WHERE perkara_id=var_id;
						    SELECT tahapan_terakhir_id INTO tahapanId FROM perkara WHERE perkara_id=var_id;
						   
						    SELECT nama INTO pihak1Nama FROM status_pihak WHERE alur_perkara_id=alurPerkaraId AND tahapan_id=10 AND pihak_ke=1;
						    SELECT nama INTO pihak2Nama FROM status_pihak WHERE alur_perkara_id=alurPerkaraId AND tahapan_id=10 AND pihak_ke=2;
						    SELECT nama INTO pihak3Nama FROM status_pihak WHERE alur_perkara_id=alurPerkaraId AND tahapan_id=10 AND pihak_ke=3;
						    SELECT nama INTO pihak4Nama FROM status_pihak WHERE alur_perkara_id=alurPerkaraId AND tahapan_id=10 AND pihak_ke=4;
						    
						    IF (alurPerkaraID IS NOT NULL AND alurPerkaraId=15 AND jenisPerkaraID=346 AND tahapanId>=10 AND tahapanId<20) THEN 
								SET pihak1Nama='Pemohon';
								SET pihak2Nama='Termohon';
						    END IF;
						    IF(listpihak1 IS NOT NULL AND listpihak1 <> '' AND listpihak2 IS NOT NULL AND listpihak2 <> '' AND listpihak4 IS NOT NULL AND listpihak4 <> '') THEN
						       SET listparapihak=CONCAT(pihak1Nama,':<br />',listpihak1,'<br />',pihak2Nama,':<br />',listpihak2,'<br />',pihak4Nama,':<br />',listpihak4);
						    ELSEIF(listpihak1 IS NOT NULL AND listpihak1 <> '' AND listpihak2 IS NOT NULL AND listpihak2 <> '') THEN
						       SET listparapihak=CONCAT(pihak1Nama,':<br />',listpihak1,'<br />',pihak2Nama,':<br />',listpihak2);
						    ELSEIF(listpihak1 IS NOT NULL AND listpihak1 <> '' AND (listpihak2 IS NULL OR listpihak2='')) THEN
						       SET listparapihak=CONCAT(pihak1Nama,':<br />',listpihak1);
						    ELSEIF((listpihak1 IS NULL OR listpihak1='') AND listpihak2 IS NOT NULL AND listpihak2 <> '') THEN
						       SET listparapihak=CONCAT(pihak2Nama,':<br />',listpihak2);
						    ELSE
						       SET listparapihak=NULL;
						    END IF;
						    
						    IF((alurPerkaraId =1 OR alurperkaraid=9) AND listpihak3 IS NOT NULL AND listpihak3 <> '') THEN
						       SET listparapihak=CONCAT(listparapihak,'<br />',pihak3Nama,':<br />',listpihak3);
						    END IF;
						    
						  RETURN listparapihak;
						END");


		$this->patching->exe_script("REPLACE INTO sys_menu_rule (menuid, ruleid)
		VALUES
			(600, 94),
			(600, 156),
			(600, 157),
			(603, 94),
			(603, 156),
			(603, 157),
			(604, 94),
			(604, 156),
			(604, 157),
			(605, 94),
			(605, 156),
			(605, 157),
			(606, 94),
			(606, 156),
			(606, 157),
			(607, 94),
			(607, 156),
			(607, 157),
			(608, 94),
			(608, 156),
			(608, 157),
			(609, 94),
			(609, 156),
			(609, 157),
			(610, 94),
			(610, 156),
			(610, 157),
			(611, 94),
			(611, 156),
			(611, 157),
			(612, 94),
			(612, 156),
			(612, 157),
			(700,157),
			(2004,157),
			(232,273),
			(232,273),
			(226,273),
			(221,273),
			(710,273),
			(209,273),
			(2005,273),
			(2008,273),
			(1003,5);");

		$this->patching->exe_script("DELETE FROM sys_group_rule WHERE groupid = 430 AND ruleid = 94;");
		$this->patching->exe_script("DELETE FROM sys_group_rule WHERE groupid = 430 AND ruleid = 1;");
		$this->patching->exe_script("DELETE FROM sys_group_rule WHERE groupid = 430 AND ruleid = 6;");
		$this->patching->exe_script("DELETE FROM sys_group_rule WHERE ruleid =1 AND groupid >30;");

		$sql = "DROP VIEW IF EXISTS v_perkara";
		$this->patching->exe_script($sql);

		$sql = "CREATE VIEW v_perkara
				AS SELECT
				   perkara.perkara_id AS perkara_id,
				   perkara.alur_perkara_id AS alur_perkara_id,
				   alur_perkara.nama AS alur_perkara_nama,
				   alur_perkara.jenis_pengadilan AS jenis_pengadilan,YEAR(perkara.tanggal_pendaftaran) AS tahun_pendaftaran,MONTH(perkara.tanggal_pendaftaran) AS bulan_pendaftaran,
				   perkara.tanggal_pendaftaran AS tanggal_pendaftaran,
				   perkara.jenis_perkara_id AS jenis_perkara_id,
				   perkara.jenis_perkara_kode AS jenis_perkara_kode,
				   perkara.jenis_perkara_nama AS jenis_perkara_nama,
				   perkara.jenis_perkara_text AS jenis_perkara_text,
				   perkara.nomor_urut_register AS nomor_urut_register,
				   perkara.nomor_urut_perkara AS nomor_urut_perkara,
				   perkara.nomor_perkara AS nomor_perkara,
				   perkara.nomor_indeks AS nomor_indeks,
				   perkara.tanggal_surat AS tanggal_surat,
				   perkara.nomor_surat AS nomor_surat,
				   perkara.surat_dok AS surat_dok,
				   perkara.pihak1_text AS pihak1_text,
				   perkara.nilai_sengketa AS nilai_sengketa,
				   perkara.pengacara_pihak1 AS pengacara_pihak1,
				   perkara.pihak2_text AS pihak2_text,
				   perkara.pengacara_pihak2 AS pengacara_pihak2,
				   perkara.pihak3_text AS pihak3_text,
				   perkara.pengacara_pihak3 AS pengacara_pihak3,
				   perkara.pihak4_text AS pihak4_text,
				   perkara.pengacara_pihak4 AS pengacara_pihak4,
				   perkara.para_pihak AS para_pihak,
				   perkara.pihak_dipublikasikan AS pihak_dipublikasikan,
				   perkara.petitum AS petitum,
				   perkara.petitum_dok AS petitum_dok,
				   perkara.dakwaan AS dakwaan,
				   perkara.pasal_dakwaan AS pasal_dakwaan,
				   perkara.dakwaan_dok AS dakwaan_dok,
				   perkara.catatan_pendaftaran AS catatan_pendaftaran,
				   perkara.prodeo AS prodeo,
				   perkara_penetapan.penetapan_majelis_hakim AS penetapan_majelis_hakim,
				   perkara_penetapan.nomor_sk_penetapan_majelis_hakim AS nomor_sk_penetapan_majelis_hakim,
				   perkara_penetapan.sk_penetapan_majelis_hakim_dok AS sk_penetapan_majelis_hakim_dok,
				   perkara_penetapan.majelis_hakim_id AS majelis_hakim_id,
				   perkara_penetapan.majelis_hakim_kode AS majelis_hakim_kode,
				   perkara_penetapan.majelis_hakim_nama AS majelis_hakim_nama,
				   perkara_penetapan.majelis_hakim_text AS majelis_hakim_text,
				   perkara_penetapan.penetapan_panitera_pengganti AS penetapan_panitera_pengganti,
				   perkara_penetapan.nomor_sk_penetapan_panitera_pengganti AS nomor_sk_penetapan_panitera_pengganti,
				   perkara_penetapan.sk_penetapan_panitera_pengganti_dok AS sk_penetapan_panitera_pengganti_dok,
				   perkara_penetapan.panitera_pengganti_id AS panitera_pengganti_id,
				   perkara_penetapan.panitera_pengganti_text AS panitera_pengganti_text,
				   perkara_penetapan.penetapan_jurusita AS penetapan_jurusita,
				   perkara_penetapan.nomor_sk_penetapan_jurusita AS nomor_sk_penetapan_jurusita,
				   perkara_penetapan.sk_penetapan_jurusita_dok AS sk_penetapan_jurusita_dok,
				   perkara_penetapan.jurusita_id AS jurusita_id,
				   perkara_penetapan.jurusita_text AS jurusita_text,
				   perkara_penetapan.penetapan_hari_sidang AS penetapan_hari_sidang,
				   perkara_penetapan.sidang_pertama AS sidang_pertama,
				   perkara_penetapan.jenis_acara AS jenis_acara,
				   perkara_penetapan.catatan_penetapan AS catatan_penetapan,
				   perkara_mediasi.is_mediasi AS is_mediasi,
				   perkara_mediasi.penetapan_penunjukan_mediator AS penetapan_penunjukan_mediator,
				   perkara_mediasi.penetapan_tanggal_mediasi AS penetapan_tanggal_mediasi,
				   perkara_mediasi.mediator_id AS mediator_id,
				   perkara_mediasi.status_mediator AS status_mediator,
				   perkara_mediasi.mediator_text AS mediator_text,
				   perkara_mediasi.dimulai_mediasi AS dimulai_mediasi,
				   perkara_mediasi.keputusan_mediasi AS keputusan_mediasi,
				   perkara_mediasi.hasil_mediasi AS hasil_mediasi,
				   perkara_mediasi.mediasi_berhasil AS mediasi_berhasil,
				   perkara_mediasi.akta_perdamaian AS akta_perdamaian,
				   perkara_mediasi.isi_akta_perdamaian AS isi_akta_perdamaian,
				   perkara_mediasi.isi_akta_perdamaian_dok AS isi_akta_perdamaian_dok,
				   perkara_mediasi.mediasi_gagal AS mediasi_gagal,
				   perkara_mediasi.catatan_mediasi AS catatan_mediasi,
				   perkara_penuntutan.tanggal_penuntutan AS tanggal_penuntutan,
				   perkara_penuntutan.isi_penuntutan AS isi_penuntutan,
				   perkara_putusan_sela.tanggal_putusan_sela AS tanggal_putusan_sela,
				   perkara_putusan_sela.tanggal_minutasi_sela AS tanggal_minutasi_sela,
				   perkara_putusan.tanggal_putusan AS tanggal_putusan,
				   perkara_putusan.putusan_verstek AS putusan_verstek,
				   perkara_putusan.status_putusan_id AS status_putusan_id,
				   status_putusan.nama AS status_putusan_kode,
				   perkara_putusan.status_putusan_nama AS status_putusan_nama,
				   perkara_putusan.status_putusan_text AS status_putusan_text,
				   perkara_putusan.tanggal_cabut AS tanggal_cabut,
				   perkara_putusan.tanggal_gugur AS tanggal_gugur,
				   perkara_putusan.amar_putusan AS amar_putusan,
				   perkara_putusan.amar_putusan_dok AS amar_putusan_dok,
				   perkara_putusan.tanggal_minutasi AS tanggal_minutasi,
				   perkara_putusan.pemberitahuan_putusan AS pemberitahuan_putusan,
				   perkara_putusan.pemberitahuan_putusan_pihak1 AS pemberitahuan_putusan_pihak1,
				   perkara_putusan.pemberitahuan_putusan_pihak2 AS pemberitahuan_putusan_pihak2,
				   perkara_putusan.menerima_putusan_pihak1 AS menerima_putusan_pihak1,
				   perkara_putusan.menerima_putusan_pihak2 AS menerima_putusan_pihak2,
				   perkara_putusan.kirim_salinan_putusan_pihak1 AS kirim_salinan_putusan_pihak1,
				   perkara_putusan.kirim_salinan_putusan_pihak2 AS kirim_salinan_putusan_pihak2,
				   perkara_putusan.kirim_salinan_putusan_pihak3 AS kirim_salinan_putusan_pihak3,
				   perkara_putusan.pemberitahuan_putusan_pihak3 AS pemberitahuan_putusan_pihak3,
				   perkara_putusan.kirim_salinan_putusan_penyidik AS kirim_salinan_putusan_penyidik,
				   perkara_putusan.catatan_putusan AS catatan_putusan,
				   perkara_putusan.tanggal_bht AS tanggal_bht,
				   perkara_verzet.tanggal_pendaftaran_verzet AS tanggal_pendaftaran_verzet,
				   perkara_verzet.tanggal_penetapan_sidang_verzet AS tanggal_penetapan_sidang_verzet,
				   perkara_verzet.tanggal_sidang_pertama_verzet AS tanggal_sidang_pertama_verzet,
				   perkara_verzet.putusan_verzet AS putusan_verzet,
				   perkara_verzet.pemberitahuan_putusan_verzet AS pemberitahuan_putusan_verzet,
				   perkara_verzet.pemberitahuan_putusan_verzet_pihak1 AS pemberitahuan_putusan_verzet_pihak1,
				   perkara_verzet.pemberitahuan_putusan_verzet_pihak2 AS pemberitahuan_putusan_verzet_pihak2,
				   perkara.tahapan_terakhir_id AS tahapan_terakhir_id,
				   perkara.tahapan_terakhir_text AS tahapan_terakhir_text,
				   perkara.proses_terakhir_id AS proses_terakhir_id,
				   perkara.proses_terakhir_text AS proses_terakhir_text,
				   perkara.diedit_oleh AS diedit_oleh,
				   perkara.diedit_tanggal AS diedit_tanggal,
				   perkara.diinput_oleh AS diinput_oleh,
				   perkara.diinput_tanggal AS diinput_tanggal,
				   perkara.diperbaharui_oleh AS diperbaharui_oleh,
				   perkara.diperbaharui_tanggal AS diperbaharui_tanggal,
				   perkara.terdakwa_anak AS terdakwa_anak,
				   perkara_matra.matra AS matra,
				   perkara_matra.berkas_dari AS berkas_dari,
				   perkara_matra.tanggal_kejadian AS tanggal_kejadian,
				   perkara_matra.tempat_kejadian AS tempat_kejadian,
				   perkara_matra.tanggal_skeppera AS tanggal_skeppera,
				   perkara_matra.nomor_skeppera AS nomor_skeppera,
				   perkara_matra.pejabat_skeppera AS pejabat_skeppera,
				   perkara_matra.tanggal_surat_dakwaan AS tanggal_surat_dakwaan,
				   perkara_matra.nomor_surat_dakwaan AS nomor_surat_dakwaan,
				   perkara_matra.penyidik_mil AS penyidik_mil,
				   perkara_matra.no_bap_penyidik_mil AS no_bap_penyidik_mil,
				   perkara_matra.tgl_penyidik_mil AS tgl_penyidik_mil,
				   perkara_data_pernikahan.tgl_nikah AS tgl_nikah,
				   perkara_data_pernikahan.tgl_kutipan_akta_nikah AS tgl_kutipan_akta_nikah,
				   perkara_data_pernikahan.no_kutipan_akta_nikah AS no_kutipan_akta_nikah,
				   perkara_data_pernikahan.kua_tempat_nikah AS kua_tempat_nikah
				FROM 
						perkara 
					LEFT JOIN 
						perkara_penetapan 
						ON perkara.perkara_id = perkara_penetapan.perkara_id 
					LEFT JOIN perkara_penuntutan 
						ON perkara.perkara_id = perkara_penuntutan.perkara_id
					LEFT JOIN perkara_putusan_sela 
						ON perkara.perkara_id = perkara_putusan_sela.perkara_id
					LEFT JOIN perkara_putusan 
						ON perkara.perkara_id = perkara_putusan.perkara_id
					LEFT JOIN status_putusan 
						ON status_putusan.id = perkara_putusan.status_putusan_id
					LEFT JOIN v_perkara_mediasi_terakhir perkara_mediasi 
						ON perkara.perkara_id = perkara_mediasi.perkara_id AND perkara_mediasi.tahapan_id = 10
					LEFT JOIN alur_perkara 
						ON perkara.alur_perkara_id = alur_perkara.id
					LEFT JOIN perkara_verzet 
						ON perkara.perkara_id = perkara_verzet.perkara_id
					LEFT JOIN perkara_matra 
						ON perkara.perkara_id = perkara_matra.perkara_id 
					LEFT JOIN perkara_data_pernikahan 
						ON perkara.perkara_id = perkara_data_pernikahan.perkara_id;";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS v_perkara_banding";
		$this->patching->exe_script($sql);

		$sql = "CREATE VIEW v_perkara_banding AS 
				SELECT
					perkara_banding.perkara_id                               AS perkara_id,
					perkara_banding.alur_perkara_id                          AS alur_perkara_id,
					perkara_banding.nomor_perkara_pn                         AS nomor_perkara_pn,
					perkara_banding.putusan_pn                               AS putusan_pn,
					perkara_banding.pihak_pembanding                         AS pihak_pembanding,
					perkara_banding.permohonan_banding                       AS permohonan_banding,
					perkara_banding.pemohon_banding                          AS pemohon_banding,
					perkara_banding.para_pihak                               AS para_pihak,
					perkara_banding.pemberitahuan_putusan_pn                 AS pemberitahuan_putusan_pn,
					perkara_banding.pemberitahuan_permohonan_banding         AS pemberitahuan_permohonan_banding,
					perkara_banding.penerimaan_memori_banding                AS penerimaan_memori_banding,
					perkara_banding.penyerahan_memori_banding                AS penyerahan_memori_banding,
					perkara_banding.penerimaan_kontra_banding                AS penerimaan_kontra_banding,
					perkara_banding.penyerahan_kontra_banding                AS penyerahan_kontra_banding,
					perkara_banding.pemberitahuan_inzage                     AS pemberitahuan_inzage,
					perkara_banding.pemberitahuan_inzage_pembanding          AS pemberitahuan_inzage_pembanding,
					perkara_banding.pemberitahuan_inzage_terbanding          AS pemberitahuan_inzage_terbanding,
					perkara_banding.pelaksanaan_inzage                       AS pelaksanaan_inzage,
					perkara_banding.pelaksanaan_inzage_pembanding            AS pelaksanaan_inzage_pembanding,
					perkara_banding.pelaksanaan_inzage_terbanding            AS pelaksanaan_inzage_terbanding,
					perkara_banding.pengiriman_berkas_banding                AS pengiriman_berkas_banding,
					perkara_banding.nomor_surat_pengiriman_berkas_banding    AS nomor_surat_pengiriman_berkas_banding,
					perkara_banding.penerimaan_kembali_berkas_banding        AS penerimaan_kembali_berkas_banding,
					perkara_banding.nomor_perkara_banding                    AS nomor_perkara_banding,
					perkara_banding.hakim1_banding                           AS hakim1_banding,
					perkara_banding.hakim2_banding                           AS hakim2_banding,
					perkara_banding.hakim3_banding                           AS hakim3_banding,
					perkara_banding.hakim4_banding                           AS hakim4_banding,
					perkara_banding.hakim5_banding                           AS hakim5_banding,
					perkara_banding.majelis_hakim_banding                    AS majelis_hakim_banding,
					perkara_banding.panitera_pengganti_banding               AS panitera_pengganti_banding,
					perkara_banding.putusan_banding                          AS putusan_banding,
					perkara_banding.minutasi_banding                         AS minutasi_banding,
					perkara_banding.status_putusan_banding_id                AS status_putusan_banding_id,
					perkara_banding.status_putusan_banding_text              AS status_putusan_banding_text,
					perkara_banding.nomor_putusan_banding                    AS nomor_putusan_banding,
					perkara_banding.amar_putusan_banding                     AS amar_putusan_banding,
					perkara_banding.amar_putusan_banding_dok                 AS amar_putusan_banding_dok,
					perkara_banding.pemberitahuan_putusan_banding            AS pemberitahuan_putusan_banding,
					perkara_banding.pemberitahuan_putusan_banding_pembanding AS pemberitahuan_putusan_banding_pembanding,
					perkara_banding.pemberitahuan_putusan_banding_terbanding AS pemberitahuan_putusan_banding_terbanding,
					perkara_banding.catatan_banding                          AS catatan_banding,
					perkara_banding.prodeo_banding                           AS prodeo_banding,
					perkara_banding.status_banding_id                        AS status_banding_id,
					perkara_banding.status_banding_text                      AS status_banding_text,
					perkara_banding.tanggal_cabut                            AS tanggal_cabut,
					perkara_banding.diedit_oleh                              AS diedit_oleh,
					perkara_banding.diedit_tanggal                           AS diedit_tanggal,
					perkara_banding.diinput_oleh                             AS diinput_oleh,
					perkara_banding.diinput_tanggal                          AS diinput_tanggal,
					perkara_banding.diperbaharui_oleh                        AS diperbaharui_oleh,
					perkara_banding.diperbaharui_tanggal                     AS diperbaharui_tanggal,
					perkara.nomor_indeks                                     AS nomor_indeks,
					perkara.tahapan_terakhir_id                              AS tahapan_terakhir_id,
					perkara.proses_terakhir_id                               AS proses_terakhir_id,
					perkara.terdakwa_anak                                    AS terdakwa_anak,
					perkara.prodeo                                           AS prodeo,
					perkara.tanggal_pendaftaran                              AS tanggal_pendaftaran
				FROM (perkara_banding
					 LEFT JOIN perkara
						 ON ((perkara_banding.perkara_id = perkara.perkara_id)));";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS v_penyidik";
		$this->patching->exe_script($sql);

		$sql = "CREATE VIEW v_penyidik AS 
			SELECT
				pihak.id                     AS id,
				pihak.jenis_pihak_id         AS jenis_pihak_id,
				pihak.jenis_indentitas       AS jenis_indentitas,
				pihak.nomor_indentitas       AS nomor_indentitas,
				pihak.nama                   AS nama,
				pihak.tempat_lahir           AS tempat_lahir,
				pihak.tanggal_lahir          AS tanggal_lahir,
				pihak.jenis_kelamin          AS jenis_kelamin,
				pihak.golongan_darah         AS golongan_darah,
				pihak.alamat                 AS alamat,
				pihak.rtrw                   AS rtrw,
				pihak.kelurahan              AS kelurahan,
				pihak.kecamatan              AS kecamatan,
				pihak.kabupaten_id           AS kabupaten_id,
				pihak.kabupaten              AS kabupaten,
				pihak.propinsi_id            AS propinsi_id,
				pihak.propinsi               AS propinsi,
				pihak.telepon                AS telepon,
				pihak.fax                    AS fax,
				pihak.email                  AS email,
				pihak.agama_id               AS agama_id,
				pihak.agama_nama             AS agama_nama,
				pihak.status_kawin           AS status_kawin,
				pihak.pekerjaan              AS pekerjaan,
				pihak.pendidikan_id          AS pendidikan_id,
				pihak.pendidikan             AS pendidikan,
				pihak.warga_negara_id        AS warga_negara_id,
				pihak.warga_negara           AS warga_negara,
				pihak.nama_ayah              AS nama_ayah,
				pihak.nama_ibu               AS nama_ibu,
				pihak.keterangan             AS keterangan,
				pihak.foto                   AS foto,
				pihak_penyidik.NIP           AS NIP,
				pihak_penyidik.kepolisian    AS kepolisian,
				pihak_penyidik.alamat_kantor AS alamat_kantor,
				pihak.diedit_oleh            AS diedit_oleh,
				pihak.diedit_tanggal         AS diedit_tanggal,
				pihak.diinput_oleh           AS diinput_oleh,
				pihak.diinput_tanggal        AS diinput_tanggal,
				pihak.diperbaharui_oleh      AS diperbaharui_oleh,
				pihak.diperbaharui_tanggal   AS diperbaharui_tanggal
			FROM (pihak
							 JOIN pihak_penyidik
								 ON ((pihak.id = pihak_penyidik.pihak_id)));";
		$this->patching->exe_script($sql);

		$sql = "CREATE  VIEW v_penahanan AS 
				SELECT
					p.perkara_id             AS perkara_id,
					p.alur_perkara_id        AS alur_perkara_id,
					p.tanggal_pendaftaran    AS tanggal_pendaftaran,
					p.jenis_perkara_id       AS jenis_perkara_id,
					p.nomor_perkara          AS nomor_perkara,
					p.nomor_indeks           AS nomor_indeks,
					p.dakwaan                AS dakwaan,
					p.tanggal_putusan        AS tanggal_putusan,
					p.tanggal_minutasi       AS tanggal_minutasi,
					p.tahapan_terakhir_id    AS tahapan_terakhir_id,
					p.tahapan_terakhir_text  AS tahapan_terakhir_text,
					p.proses_terakhir_id     AS proses_terakhir_id,
					p.proses_terakhir_text   AS proses_terakhir_text,
					pp.pihak_id              AS pihak_id,
					pp.nama                  AS nama,
					p0.tempat_lahir          AS tempat_lahir,
					p0.tanggal_lahir         AS tanggal_lahir,
					YEAR(p.tanggal_pendaftaran) - YEAR(p0.tanggal_lahir) AS umur,
					(CASE WHEN (YEAR(p.tanggal_pendaftaran) - YEAR(p0.tanggal_lahir))>18 THEN 1 ELSE 0 END) AS dewasa,
					p0.jenis_kelamin         AS jenis_kelamin,
					p0.alamat                AS alamat,
					p0.agama_id              AS agama_id,
					p0.agama_nama            AS agama_nama,
					p0.status_kawin          AS status_kawin,
					p0.pekerjaan             AS pekerjaan,
					p0.pendidikan_id         AS pendidikan_id,
					p0.pendidikan            AS pendidikan,
					p0.warga_negara_id       AS warga_negara_id,
					p0.warga_negara          AS warga_negara,
					pe.status_penahanan_id   AS status_penahanan_id,
					pe.status_penahanan_nama AS status_penahanan_nama,
					pe.jenis_tahanan_id      AS jenis_tahanan_id,
					pe.jenis_tahanan_nama    AS jenis_tahanan_nama,
					pe.jenis_penahanan_id    AS jenis_penahanan_id,
					pe.jenis_penahanan_nama  AS jenis_penahanan_nama,
					pe.mulai                 AS mulai,
					pe.sampai                AS sampai,
					alur_perkara.aktif       AS alur_perkara_aktif
				FROM perkara_pihak2 pp
						 JOIN v_penahanan_terdakwa pe
							 ON pp.perkara_id = pe.perkara_id
									AND pp.pihak_id = pe.pihak_id
					LEFT JOIN v_perkara p
						 ON pp.perkara_id = p.perkara_id
					LEFT JOIN alur_perkara
						 ON p.alur_perkara_id = alur_perkara.id
					LEFT JOIN pihak p0
						 ON p0.id = pp.pihak_id
				WHERE p.alur_perkara_id >= 111
				AND pe.status_penahanan_id = 1;";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS v_perkara_sidang_keliling;";
		$this->patching->exe_script($sql);

		$sql = "CREATE VIEW v_perkara_sidang_keliling AS 
				SELECT
					IFNULL(ps.sidang_keliling,'T')          AS sidang_keliling,
					p.perkara_id                            AS perkara_id,
					p.alur_perkara_id                       AS alur_perkara_id,
					p.alur_perkara_nama                     AS alur_perkara_nama,
					p.tahun_pendaftaran                     AS tahun_pendaftaran,
					p.bulan_pendaftaran                     AS bulan_pendaftaran,
					p.tanggal_pendaftaran                   AS tanggal_pendaftaran,
					p.jenis_perkara_id                      AS jenis_perkara_id,
					p.jenis_perkara_kode                    AS jenis_perkara_kode,
					p.jenis_perkara_nama                    AS jenis_perkara_nama,
					p.jenis_perkara_text                    AS jenis_perkara_text,
					p.nomor_urut_register                   AS nomor_urut_register,
					p.nomor_urut_perkara                    AS nomor_urut_perkara,
					p.nomor_perkara                         AS nomor_perkara,
					p.nomor_indeks                          AS nomor_indeks,
					p.tanggal_surat                         AS tanggal_surat,
					p.nomor_surat                           AS nomor_surat,
					p.surat_dok                             AS surat_dok,
					p.pihak1_text                           AS pihak1_text,
					p.pengacara_pihak1                      AS pengacara_pihak1,
					p.pihak2_text                           AS pihak2_text,
					p.pengacara_pihak2                      AS pengacara_pihak2,
					p.para_pihak                            AS para_pihak,
					p.pihak_dipublikasikan                  AS pihak_dipublikasikan,
					p.petitum                               AS petitum,
					p.petitum_dok                           AS petitum_dok,
					p.dakwaan                               AS dakwaan,
					p.dakwaan_dok                           AS dakwaan_dok,
					p.catatan_pendaftaran                   AS catatan_pendaftaran,
					p.prodeo                                AS prodeo,
					p.penetapan_majelis_hakim               AS penetapan_majelis_hakim,
					p.nomor_sk_penetapan_majelis_hakim      AS nomor_sk_penetapan_majelis_hakim,
					p.sk_penetapan_majelis_hakim_dok        AS sk_penetapan_majelis_hakim_dok,
					p.majelis_hakim_id                      AS majelis_hakim_id,
					p.majelis_hakim_kode                    AS majelis_hakim_kode,
					p.majelis_hakim_nama                    AS majelis_hakim_nama,
					p.majelis_hakim_text                    AS majelis_hakim_text,
					p.penetapan_panitera_pengganti          AS penetapan_panitera_pengganti,
					p.nomor_sk_penetapan_panitera_pengganti AS nomor_sk_penetapan_panitera_pengganti,
					p.sk_penetapan_panitera_pengganti_dok   AS sk_penetapan_panitera_pengganti_dok,
					p.panitera_pengganti_id                 AS panitera_pengganti_id,
					p.panitera_pengganti_text               AS panitera_pengganti_text,
					p.penetapan_jurusita                    AS penetapan_jurusita,
					p.nomor_sk_penetapan_jurusita           AS nomor_sk_penetapan_jurusita,
					p.sk_penetapan_jurusita_dok             AS sk_penetapan_jurusita_dok,
					p.jurusita_id                           AS jurusita_id,
					p.jurusita_text                         AS jurusita_text,
					p.penetapan_hari_sidang                 AS penetapan_hari_sidang,
					p.sidang_pertama                        AS sidang_pertama,
					p.catatan_penetapan                     AS catatan_penetapan,
					p.penetapan_penunjukan_mediator         AS penetapan_penunjukan_mediator,
					p.penetapan_tanggal_mediasi             AS penetapan_tanggal_mediasi,
					p.mediator_id                           AS mediator_id,
					p.status_mediator                       AS status_mediator,
					p.mediator_text                         AS mediator_text,
					p.dimulai_mediasi                       AS dimulai_mediasi,
					p.keputusan_mediasi                     AS keputusan_mediasi,
					p.hasil_mediasi                         AS hasil_mediasi,
					p.mediasi_berhasil                      AS mediasi_berhasil,
					p.akta_perdamaian                       AS akta_perdamaian,
					p.isi_akta_perdamaian                   AS isi_akta_perdamaian,
					p.isi_akta_perdamaian_dok               AS isi_akta_perdamaian_dok,
					p.mediasi_gagal                         AS mediasi_gagal,
					p.catatan_mediasi                       AS catatan_mediasi,
					p.tanggal_penuntutan                    AS tanggal_penuntutan,
					p.tanggal_putusan_sela                  AS tanggal_putusan_sela,
					p.tanggal_minutasi_sela                 AS tanggal_minutasi_sela,
					p.tanggal_putusan                       AS tanggal_putusan,
					p.putusan_verstek                       AS putusan_verstek,
					p.status_putusan_id                     AS status_putusan_id,
					p.status_putusan_kode                   AS status_putusan_kode,
					p.status_putusan_nama                   AS status_putusan_nama,
					p.status_putusan_text                   AS status_putusan_text,
					p.tanggal_cabut                         AS tanggal_cabut,
					p.tanggal_gugur                         AS tanggal_gugur,
					p.amar_putusan                          AS amar_putusan,
					p.amar_putusan_dok                      AS amar_putusan_dok,
					p.tanggal_minutasi                      AS tanggal_minutasi,
					p.pemberitahuan_putusan                 AS pemberitahuan_putusan,
					p.pemberitahuan_putusan_pihak1          AS pemberitahuan_putusan_pihak1,
					p.pemberitahuan_putusan_pihak2          AS pemberitahuan_putusan_pihak2,
					p.menerima_putusan_pihak1               AS menerima_putusan_pihak1,
					p.menerima_putusan_pihak2               AS menerima_putusan_pihak2,
					p.kirim_salinan_putusan_pihak1          AS kirim_salinan_putusan_pihak1,
					p.kirim_salinan_putusan_pihak2          AS kirim_salinan_putusan_pihak2,
					p.kirim_salinan_putusan_pihak3          AS kirim_salinan_putusan_pihak3,
					p.pemberitahuan_putusan_pihak3          AS pemberitahuan_putusan_pihak3,
					p.kirim_salinan_putusan_penyidik        AS kirim_salinan_putusan_penyidik,
					p.catatan_putusan                       AS catatan_putusan,
					p.tanggal_pendaftaran_verzet            AS tanggal_pendaftaran_verzet,
					p.tanggal_penetapan_sidang_verzet       AS tanggal_penetapan_sidang_verzet,
					p.tanggal_sidang_pertama_verzet         AS tanggal_sidang_pertama_verzet,
					p.putusan_verzet                        AS putusan_verzet,
					p.pemberitahuan_putusan_verzet          AS pemberitahuan_putusan_verzet,
					p.pemberitahuan_putusan_verzet_pihak1   AS pemberitahuan_putusan_verzet_pihak1,
					p.pemberitahuan_putusan_verzet_pihak2   AS pemberitahuan_putusan_verzet_pihak2,
					p.tahapan_terakhir_id                   AS tahapan_terakhir_id,
					p.tahapan_terakhir_text                 AS tahapan_terakhir_text,
					p.proses_terakhir_id                    AS proses_terakhir_id,
					p.proses_terakhir_text                  AS proses_terakhir_text,
					p.diedit_oleh                           AS diedit_oleh,
					p.diedit_tanggal                        AS diedit_tanggal,
					p.diinput_oleh                          AS diinput_oleh,
					p.diinput_tanggal                       AS diinput_tanggal,
					p.diperbaharui_oleh                     AS diperbaharui_oleh,
					p.diperbaharui_tanggal                  AS diperbaharui_tanggal,
					p.terdakwa_anak                         AS terdakwa_anak
				FROM (v_perkara p
					 LEFT JOIN perkara_jadwal_sidang ps
						 ON (((p.perkara_id = ps.perkara_id)
									AND (ps.sidang_keliling = 'Y'))))";
		$this->patching->exe_script($sql);


		$sql = "DROP VIEW IF EXISTS v_putus_pdt";
		$this->patching->exe_script($sql);

		$sql = "CREATE VIEW v_putus_pdt AS 
				SELECT
					v_perkara.alur_perkara_id AS alur_perkara_id,
					v_perkara.perkara_id AS perkara_id,
					10 AS tahapan_id,
					'PN' AS tahapan_nama,
					v_perkara.tanggal_putusan AS tanggal_putusan
				FROM v_perkara
				WHERE (v_perkara.alur_perkara_id < 111)UNION SELECT
					perkara_banding.alur_perkara_id AS alur_perkara_id,
					perkara_banding.perkara_id AS perkara_id,
					20 AS tahapan_id,
					'Banding' AS tahapan_nama,
					perkara_banding.putusan_banding AS tanggal_putusan
				FROM perkara_banding
				WHERE (perkara_banding.alur_perkara_id < 111)UNION SELECT
					perkara_kasasi.alur_perkara_id AS alur_perkara_id,
					perkara_kasasi.perkara_id AS perkara_id,
					30 AS tahapan_id,
					'Kasasi' AS tahapan_nama,
					perkara_kasasi.putusan_kasasi AS tanggal_putusan
				FROM perkara_kasasi
				WHERE (perkara_kasasi.alur_perkara_id < 111)UNION SELECT
					perkara_pk.alur_perkara_id AS alur_perkara_id,
					perkara_pk.perkara_id AS perkara_id,
					40 AS tahapan_id,
					'Peninjauan Kembali' AS tahapan_nama,
					perkara_pk.putusan_pk AS tanggal_putusan
				FROM perkara_pk
				WHERE (perkara_pk.alur_perkara_id < 111)
				ORDER BY perkara_id,tahapan_id DESC";
		$this->patching->exe_script($sql);


		$sql = "DROP VIEW IF EXISTS v_biaya_reminder";
		$this->patching->exe_script($sql);

		$sql = "CREATE VIEW v_biaya_reminder AS 
				SELECT
					a.alur_perkara_id AS alur_perkara_id,
					a.perkara_id      AS perkara_id,
					a.tahapan_id      AS tahapan_id,
					a.tahapan_nama    AS tahapan_nama,
					a.tanggal_putusan AS tanggal_putusan,
					(b.pemasukan - b.pengeluaran) AS sisa
				FROM (v_putus_pdt a
					 LEFT JOIN v_sum_perkara_biaya b
						 ON (((a.perkara_id = b.perkara_id)
									AND (a.tahapan_id = b.tahapan_id))))
				WHERE (a.tanggal_putusan IS NOT NULL)
				HAVING (sisa > 0);";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS v_biaya_reminder_minus";
		$this->patching->exe_script($sql);

		$sql = "CREATE VIEW v_biaya_reminder_minus AS 
				SELECT
					a.alur_perkara_id AS alur_perkara_id,
					a.perkara_id      AS perkara_id,
					a.tahapan_id      AS tahapan_id,
					a.tahapan_nama    AS tahapan_nama,
					a.tanggal_putusan AS tanggal_putusan,
					(b.pemasukan - b.pengeluaran) AS sisa
				FROM (v_putus_pdt a
					 LEFT JOIN v_sum_perkara_biaya b
						 ON (((a.perkara_id = b.perkara_id)
									AND (a.tahapan_id = b.tahapan_id))))
				WHERE (a.tanggal_putusan IS NULL)
				HAVING (sisa < 50000);";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS v_pihak;";
		$this->patching->exe_script($sql);

		$sql = "CREATE VIEW v_pihak AS
				SELECT 
					p. id,
					p.jenis_pihak_id,
					p.jenis_indentitas,
					p.nomor_indentitas,
					p.nama,
					p.tempat_lahir,
					p.tanggal_lahir,
					p.jenis_kelamin,
					p.golongan_darah,
					p.alamat,
					p.telepon,
					p.fax,
					p.email,
					p.agama_id,
					p.status_kawin,
					p.pekerjaan,
					p.pendidikan_id,
					p.warga_negara_id,
					p.nama_ayah,
					p.nama_ibu,
					p.difabel,
					p.keterangan,
					CASE
						WHEN p1.pihak_id IS NOT NULL THEN p1.perkara_id
						WHEN p2.pihak_id IS NOT NULL THEN p2.perkara_id
						WHEN p3.pihak_id IS NOT NULL THEN p3.perkara_id
						WHEN p4.pihak_id IS NOT NULL THEN p4.perkara_id
						WHEN p5.pihak_id IS NOT NULL THEN p5.perkara_id
						ELSE NULL
						END AS perkara_id,
					CASE
						WHEN p2.pihak_id IS NOT NULL THEN p2.nrp
						WHEN p5.pihak_id IS NOT NULL THEN p5.nrp
						WHEN p6.pihak_id IS NOT NULL THEN p6.nip
						ELSE NULL
						END AS nip_nrp,
					CASE
						WHEN p2.pihak_id IS NOT NULL THEN p2.pangkat
						WHEN p5.pihak_id IS NOT NULL THEN p5.pangkat
						WHEN p6.pihak_id IS NOT NULL THEN p6.pangkat
						ELSE NULL
						END AS pangkat,
					CASE
						WHEN p2.pihak_id IS NOT NULL THEN p2.jabatan
						WHEN p5.pihak_id IS NOT NULL THEN p5.jabatan
						WHEN p6.pihak_id IS NOT NULL THEN p6.jabatan
						ELSE NULL
						END AS jabatan,
					CASE
						WHEN p2.pihak_id IS NOT NULL THEN p2.kesatuan
						WHEN p5.pihak_id IS NOT NULL THEN p5.kesatuan
						WHEN p6.pihak_id IS NOT NULL THEN p6.kesatuan
						ELSE NULL
						END AS kesatuan
				FROM pihak AS p
				LEFT JOIN perkara_pihak1 AS p1
					ON p1.pihak_id = p.id
				LEFT JOIN perkara_pihak2 AS p2
					ON p2.pihak_id = p.id
				LEFT JOIN perkara_pihak3 AS p3
					ON p3.pihak_id = p.id
				LEFT JOIN perkara_pihak4 AS p4
					ON p4.pihak_id = p.id
				LEFT JOIN perkara_pihak5 AS p5
					ON p5.pihak_id = p.id
				LEFT JOIN pihak_jaksa AS p6
					ON p6.pihak_id = p.id
				GROUP BY p.id;";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS v_pihak_perkara;";
		$this->patching->exe_script($sql);
		
		$sql = "CREATE VIEW v_pihak_perkara AS 
						SELECT   CONCAT('pihak1_',CAST(pihak1.id AS CHAR(20) CHARSET latin1)) AS id,
							 pihak1.pihak_id AS pihak_id,
							 1 AS pihak_ke,
							 pihak1.urutan AS urutan,
							 pihak1.jenis_pihak_id AS jenis_pihak_id,
							 pihak1.nama AS nama,
							 pihak1.alamat AS alamat,
							 (SELECT status_pihak.nama AS nama FROM status_pihak WHERE ((status_pihak.alur_perkara_id = per.alur_perkara_id) AND (status_pihak.tahapan_id = 10) AND (status_pihak.pihak_ke = 1))) AS status_perkara,
							 per.tanggal_pendaftaran AS tanggal_pendaftaran,
							 per.perkara_id AS perkara_id,
							 per.alur_perkara_id AS alur_perkara_id,
							 per.nomor_perkara AS nomor_perkara,
							 per.nomor_indeks AS nomor_indeks,
							 per.jenis_perkara_nama AS jenis_perkara_nama,
							 per.jenis_perkara_text AS jenis_perkara_text,
							 per.tahapan_terakhir_text AS tahapan_terakhir_text,
							 per.proses_terakhir_text AS proses_terakhir_text FROM (perkara_pihak1 pihak1 LEFT JOIN perkara per ON((pihak1.perkara_id = per.perkara_id))) 
						UNION SELECT CONCAT('pihak2_',CAST(pihak2.id AS CHAR(20) CHARSET latin1)) AS id,
							 pihak2.pihak_id AS pihak_id,
							 2 AS pihak_ke,
							 pihak2.urutan AS urutan,
							 pihak2.jenis_pihak_id AS jenis_pihak_id,
							 pihak2.nama AS nama,
							 pihak2.alamat AS alamat,
							 (SELECT status_pihak.nama AS nama FROM status_pihak WHERE ((status_pihak.alur_perkara_id = per.alur_perkara_id) AND (status_pihak.tahapan_id = 10) AND (status_pihak.pihak_ke = 2))) AS status_perkara,
							 per.tanggal_pendaftaran AS tanggal_pendaftaran,
							 per.perkara_id AS perkara_id,
							 per.alur_perkara_id AS alur_perkara_id,
							 per.nomor_perkara AS nomor_perkara,
							 per.nomor_indeks AS nomor_indeks,
							 per.jenis_perkara_nama AS jenis_perkara_nama,
							 per.jenis_perkara_text AS jenis_perkara_text,
							 per.tahapan_terakhir_text AS tahapan_terakhir_text,
							 per.proses_terakhir_text AS proses_terakhir_text FROM (perkara_pihak2 pihak2 LEFT JOIN perkara per ON((pihak2.perkara_id = per.perkara_id))) 
						UNION SELECT CONCAT('pihak3_',CAST(pihak3.id AS CHAR(20) CHARSET latin1)) AS id,
							 pihak3.pihak_id AS pihak_id,
							 3 AS pihak_ke,
							 pihak3.urutan AS urutan,
							 pihak3.jenis_pihak_id AS jenis_pihak_id,
							 pihak3.nama AS nama,
							 pihak3.alamat AS alamat,
							 (SELECT status_pihak.nama AS nama FROM status_pihak WHERE ((status_pihak.alur_perkara_id = per.alur_perkara_id) AND (status_pihak.tahapan_id = 10) AND (status_pihak.pihak_ke = 3))) AS status_perkara,
							 per.tanggal_pendaftaran AS tanggal_pendaftaran,
							 per.perkara_id AS perkara_id,
							 per.alur_perkara_id AS alur_perkara_id,
							 per.nomor_perkara AS nomor_perkara,
							 per.nomor_indeks AS nomor_indeks,
							 per.jenis_perkara_nama AS jenis_perkara_nama,
							 per.jenis_perkara_text AS jenis_perkara_text,
							 per.tahapan_terakhir_text AS tahapan_terakhir_text,
							 per.proses_terakhir_text AS proses_terakhir_text FROM (perkara_pihak3 pihak3 LEFT JOIN perkara per ON((pihak3.perkara_id = per.perkara_id))) 
						UNION SELECT CONCAT('pihak4_',CAST(pihak4.id AS CHAR(20) CHARSET latin1)) AS id,
							 pihak4.pihak_id AS pihak_id,
							 4 AS pihak_ke,
							 pihak4.urutan AS urutan,
							 pihak4.jenis_pihak_id AS jenis_pihak_id,
							 pihak4.nama AS nama,
							 pihak4.alamat AS alamat,
							 (SELECT status_pihak.nama AS nama FROM status_pihak WHERE ((status_pihak.alur_perkara_id = per.alur_perkara_id) AND (status_pihak.tahapan_id = 10) AND (status_pihak.pihak_ke = 4))) AS status_perkara,
							 per.tanggal_pendaftaran AS tanggal_pendaftaran,
							 per.perkara_id AS perkara_id,
							 per.alur_perkara_id AS alur_perkara_id,
							 per.nomor_perkara AS nomor_perkara,
							 per.nomor_indeks AS nomor_indeks,
							 per.jenis_perkara_nama AS jenis_perkara_nama,
							 per.jenis_perkara_text AS jenis_perkara_text,
							 per.tahapan_terakhir_text AS tahapan_terakhir_text,
							 per.proses_terakhir_text AS proses_terakhir_text FROM (perkara_pihak4 pihak4 LEFT JOIN perkara per ON((pihak4.perkara_id = per.perkara_id))) 
						UNION SELECT CONCAT('pihak5_',CAST(pihak5.id AS CHAR(20) CHARSET latin1)) AS id,
							 pihak5.pihak_id AS pihak_id,
							 5 AS pihak_ke,
							 pihak5.urutan AS urutan,
							 pihak5.jenis_pihak_id AS jenis_pihak_id,
							 pihak5.nama AS nama,
							 pihak5.alamat AS alamat,
							 (SELECT status_pihak.nama AS nama FROM status_pihak WHERE ((status_pihak.alur_perkara_id = per.alur_perkara_id) AND (status_pihak.tahapan_id = 10) AND (status_pihak.pihak_ke = 13))) AS status_perkara,
							 per.tanggal_pendaftaran AS tanggal_pendaftaran,
							 per.perkara_id AS perkara_id,
							 per.alur_perkara_id AS alur_perkara_id,
							 per.nomor_perkara AS nomor_perkara,
							 per.nomor_indeks AS nomor_indeks,
							 per.jenis_perkara_nama AS jenis_perkara_nama,
							 per.jenis_perkara_text AS jenis_perkara_text,
							 per.tahapan_terakhir_text AS tahapan_terakhir_text,
							 per.proses_terakhir_text AS proses_terakhir_text FROM (perkara_pihak5 pihak5 LEFT JOIN perkara per ON((pihak5.perkara_id = per.perkara_id))) 
						UNION SELECT CONCAT('perkara_pihak_korban_',CAST(perkara_pihak_korban.id AS CHAR(20) CHARSET latin1)) AS id,
							 perkara_pihak_korban.pihak_id AS pihak_id,
							 6 AS pihak_ke,
							 perkara_pihak_korban.urutan AS urutan,
							 perkara_pihak_korban.jenis_pihak_id AS jenis_pihak_id,
							 perkara_pihak_korban.nama AS nama,
							 perkara_pihak_korban.alamat AS alamat,
							 (SELECT status_pihak.nama AS nama FROM status_pihak WHERE ((status_pihak.alur_perkara_id = per.alur_perkara_id) AND (status_pihak.tahapan_id = 10) AND (status_pihak.pihak_ke = 6))) AS status_perkara,
							 per.tanggal_pendaftaran AS tanggal_pendaftaran,
							 per.perkara_id AS perkara_id,
							 per.alur_perkara_id AS alur_perkara_id,
							 per.nomor_perkara AS nomor_perkara,
							 per.nomor_indeks AS nomor_indeks,
							 per.jenis_perkara_nama AS jenis_perkara_nama,
							 per.jenis_perkara_text AS jenis_perkara_text,
							 per.tahapan_terakhir_text AS tahapan_terakhir_text,
							 per.proses_terakhir_text AS proses_terakhir_text FROM (perkara_pihak_korban LEFT JOIN perkara per ON((perkara_pihak_korban.perkara_id = per.perkara_id)));";
								
		$this->patching->exe_script($sql);

		## web

		$sql = "DROP PROCEDURE IF EXISTS updateTable;";
		$this->patching->exe_script($sql);

		$sql = "CREATE PROCEDURE updateTable()
				BEGIN
					REPLACE INTO dataumumweb SELECT * FROM viewdataumumweb;
					REPLACE INTO pihakweb SELECT * FROM viewpihakweb;
					REPLACE INTO pengacaraweb SELECT * FROM viewpengacaraweb;
					REPLACE INTO hakimweb SELECT * FROM viewhakimweb;
					REPLACE INTO ppweb SELECT * FROM viewppweb;
					REPLACE INTO jurusitaweb SELECT * FROM viewjurusitaweb;
					REPLACE INTO mediasiweb SELECT * FROM viewmediasiweb;
					REPLACE INTO jadwalsidangweb SELECT * FROM viewjadwalsidangweb;
					REPLACE INTO perkarabiayaweb SELECT * FROM viewperkarabiayaweb ORDER BY idperkara,tgltransaksi ASC;
					REPLACE INTO verzetweb SELECT * FROM viewverzetweb;
					REPLACE INTO penahananweb SELECT * FROM viewpenahananweb;
					REPLACE INTO putusanselaweb SELECT * FROM viewputusanselaweb;
					REPLACE INTO pihakintervensiweb SELECT * FROM viewpihakintervensiweb;
					REPLACE INTO bandingweb SELECT * FROM viewbandingweb;
					REPLACE INTO bandingdetilweb SELECT * FROM viewbandingdetilweb;
					REPLACE INTO diversiweb SELECT * FROM viewdiversiweb;
					REPLACE INTO eksekusiweb SELECT * FROM vieweksekusiweb;
					REPLACE INTO eksekusidetilweb SELECT * FROM vieweksekusidetilweb;   
					REPLACE INTO kasasiweb SELECT * FROM viewkasasiweb;
					REPLACE INTO kasasidetilweb SELECT * FROM viewkasasidetilweb;
					REPLACE INTO pkweb SELECT * FROM viewpkweb;
					REPLACE INTO pkdetilweb SELECT * FROM viewpkdetilweb;
					REPLACE INTO grasiweb SELECT * FROM viewgrasiweb;
					REPLACE INTO perkarapenuntutanweb SELECT * FROM viewperkarapenuntutanweb;   
					REPLACE INTO actiopaulianaweb SELECT * FROM viewactiopaulianaweb;
					REPLACE INTO perkaraprosesweb SELECT * FROM viewperkaraprosesweb;
					REPLACE INTO perkarakeberatanweb SELECT * FROM viewperkarakeberatanweb;
					REPLACE INTO perkaraeksekusihtweb SELECT * FROM viewperkaraeksekusihtweb;
					REPLACE INTO putusanpemberitahuanweb SELECT * FROM viewputusanpemberitahuanweb;
					REPLACE INTO barangbuktiweb SELECT * FROM viewbarangbuktiweb;
					REPLACE INTO perkaraputusanweb SELECT * FROM viewperkaraputusanweb;
					REPLACE INTO perkaraputusanterdakwa SELECT * FROM viewperkaraputusanterdakwa;
					REPLACE INTO rekonvensiweb SELECT * FROM viewrekonvensiweb;
					REPLACE INTO alurperkaraweb SELECT * FROM viewalurperkaraweb;
					REPLACE INTO statuspihakweb SELECT * FROM viewstatuspihakweb;
					REPLACE INTO ikrarweb SELECT * FROM viewikrarweb;
					REPLACE INTO sys_config SELECT * FROM sys_config WHERE id >60;
					REPLACE INTO perkaramatraweb SELECT * FROM viewperkaramatraweb;
					REPLACE INTO panggilandismissalweb SELECT * FROM viewpanggilandismissalweb;
					REPLACE INTO penetapandismissalweb SELECT * FROM viewpenetapandismissalweb;
					REPLACE INTO sidangpertamaweb SELECT * FROM viewsidangpertamaweb;
					REPLACE INTO penetapanpersiapanweb SELECT * FROM viewpenetapanpersiapanweb;
					REPLACE INTO penetapanpersiapanprosesweb SELECT * FROM viewpenetapanpersiapanprosesweb;
					REPLACE INTO statusputusanweb SELECT * FROM viewstatusputusanweb;
					REPLACE INTO jenisperkaraweb SELECT * FROM viewjenisperkaraweb;
					REPLACE INTO delegasikeluarweb SELECT * FROM viewdelegasikeluarweb;
					REPLACE INTO delegasimasukweb SELECT * FROM viewdelegasimasukweb;
					REPLACE INTO delegasiproseskeluarweb SELECT * FROM viewdelegasiproseskeluarweb;
					REPLACE INTO delegasiprosesmasukweb SELECT * FROM viewdelegasiprosesmasukweb;
					
				END;";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS viewputusanperkara;";
		$this->patching->exe_script($sql);

		$sql = "CREATE  VIEW viewputusanperkara AS 
				SELECT
				  perkara_putusan.perkara_id       AS IDPerkara,
				  perkara_putusan.tanggal_putusan  AS tglPutusan,
				  perkara_putusan.tanggal_minutasi AS tglMinutasi,
				  perkara_putusan.tanggal_bht AS tglBHT
				FROM perkara_putusan;";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS viewdataumumweb;";
		$this->patching->exe_script($sql);

		$sql = "CREATE  VIEW viewdataumumweb AS
				SELECT
				  perkara.perkara_id           AS IDPerkara,
				  perkara.tanggal_pendaftaran  AS tglPendaftaran,
				  perkara.alur_perkara_id      AS klasifikasiPerkara,
				  perkara.jenis_perkara_id     AS IDJenisPerkara,
				  perkara.jenis_perkara_nama   AS jenisPerkara,
				  perkara.nomor_perkara        AS noPerkara,
				  perkara.tanggal_surat        AS tglSurat,
				  perkara.nomor_surat          AS noSurat,
				  CASE
				    WHEN (perkara.alur_perkara_id<100 AND perkara.pihak_dipublikasikan='T') THEN 'Disamarkan'
				    WHEN (perkara.alur_perkara_id<100 AND perkara.pihak_dipublikasikan='Y') THEN perkara.petitum
				    WHEN (perkara.alur_perkara_id>100 AND perkara.pihak_dipublikasikan='T') THEN 'Disamarkan'
				    WHEN (perkara.alur_perkara_id>100 AND perkara.pihak_dipublikasikan='Y') THEN perkara.dakwaan
				    WHEN ((perkara.alur_perkara_id = 15) AND (perkara.jenis_perkara_id = 346)) THEN 'Disamarkan'
				  	WHEN ((perkara.alur_perkara_id = 15) AND (perkara.jenis_perkara_id = 347)) THEN 'Disamarkan'
				    ELSE 'Error'
				  END
				  AS petitumDakwaan,
				  perkara.pihak_dipublikasikan AS dipublikasikan,
				  perkara.prodeo               AS prodeo,
				  perkara.nilai_sengketa       AS nilai_sengketa,
				  perkara.proses_terakhir_id   AS IDProses,
				  perkara.proses_terakhir_text AS statusAkhir,
				  (CASE 
				  	WHEN ((perkara.alur_perkara_id = 1) AND (perkara.jenis_perkara_id = 64)) THEN 'Disamarkan' 
				  	WHEN ((perkara.alur_perkara_id = 1) AND (perkara.jenis_perkara_id = 137)) THEN 'Disamarkan'
				  	WHEN ((perkara.alur_perkara_id = 15) AND (perkara.jenis_perkara_id = 346)) THEN 'Disamarkan'
				  	WHEN ((perkara.alur_perkara_id = 15) AND (perkara.jenis_perkara_id = 347)) THEN 'Disamarkan' 
				  	WHEN ((perkara.pihak_dipublikasikan = 'T') AND (perkara.alur_perkara_id >100)) THEN perkara.pihak1_text
				  	WHEN ((perkara.pihak_dipublikasikan = 'T') AND (perkara.pihak1_text IS NOT NULL) AND (perkara.pihak1_text <> '')) THEN 'Disamarkan' 
				  	ELSE perkara.pihak1_text END) AS pihakPertama,
				  (CASE 
					WHEN (perkara.alur_perkara_id = 118) THEN 'Anak Berhadapan Dengan Hukum' 
					WHEN (perkara.jenis_perkara_id = 98) THEN 'Terdakwa' 
					WHEN ((perkara.alur_perkara_id = 1) AND (perkara.jenis_perkara_id = 64)) THEN 'Disamarkan'
					WHEN ((perkara.alur_perkara_id = 15) AND (perkara.jenis_perkara_id = 346)) THEN 'Disamarkan'
				  	WHEN ((perkara.alur_perkara_id = 15) AND (perkara.jenis_perkara_id = 347)) THEN 'Disamarkan' 
					WHEN ((perkara.alur_perkara_id = 111) AND (perkara.jenis_perkara_id = 25)) THEN 'Terdakwa' 
					WHEN ((perkara.alur_perkara_id = 111) AND (perkara.jenis_perkara_id = 200)) THEN 'Terdakwa' 
					WHEN ((perkara.pihak_dipublikasikan = 'T') AND (perkara.pihak2_text IS NOT NULL) AND (perkara.pihak2_text <> '')) THEN 'Disamarkan' ELSE perkara.pihak2_text END) AS pihakKedua,
				  (CASE 
				  	WHEN ((perkara.alur_perkara_id = 1) AND (perkara.jenis_perkara_id = 64) AND (perkara.pihak3_text IS NOT NULL) AND (perkara.pihak3_text <> '')) THEN 'Disamarkan' 
				  	WHEN ((perkara.alur_perkara_id = 1) AND (perkara.jenis_perkara_id = 137) AND (perkara.pihak3_text IS NOT NULL) AND (perkara.pihak3_text <> '')) THEN 'Disamarkan'
				  	WHEN ((perkara.alur_perkara_id = 15) AND (perkara.jenis_perkara_id = 346) AND (perkara.pihak3_text IS NOT NULL) AND (perkara.pihak3_text <> '')) THEN 'Disamarkan'
				  	WHEN ((perkara.alur_perkara_id = 15) AND (perkara.jenis_perkara_id = 347) AND (perkara.pihak3_text IS NOT NULL) AND (perkara.pihak3_text <> '')) THEN 'Disamarkan'

				  	WHEN ((perkara.pihak_dipublikasikan = 'T') AND (perkara.pihak3_text IS NOT NULL) AND (perkara.pihak3_text <> '')) THEN 'Disamarkan' ELSE perkara.pihak3_text END) AS pihakKetiga,
				  (CASE 
				  	WHEN ((perkara.alur_perkara_id = 1) AND (perkara.jenis_perkara_id = 64) AND ((perkara.pihak4_text IS NOT NULL) OR (perkara.pihak4_text <> ''))) THEN 'Disamarkan' 
				  	WHEN ((perkara.alur_perkara_id = 1) AND (perkara.jenis_perkara_id = 137) AND ((perkara.pihak4_text IS NOT NULL) OR (perkara.pihak4_text <> ''))) THEN 'Disamarkan' 
				  	WHEN ((perkara.alur_perkara_id = 15) AND (perkara.jenis_perkara_id = 347) AND ((perkara.pihak4_text IS NOT NULL) OR (perkara.pihak4_text <> ''))) THEN 'Disamarkan' 
				  	WHEN ((perkara.alur_perkara_id = 15) AND (perkara.jenis_perkara_id = 346) AND ((perkara.pihak4_text IS NOT NULL) OR (perkara.pihak4_text <> ''))) THEN 'Disamarkan' 
				  	WHEN ((perkara.pihak_dipublikasikan = 'T') AND ((perkara.pihak4_text IS NOT NULL) OR (perkara.pihak4_text <> ''))) THEN 'Disamarkan' ELSE perkara.pihak4_text END) AS pihakKeempat,
				  p.tglPutusan                 AS tglPutusan,
				  p.tglMinutasi                AS tglMinutasi,
				  pasal_dakwaan AS pasalDakwaan,
				  p.tglBHT
				FROM (perkara
				   LEFT JOIN viewputusanperkara p
				     ON ((perkara.perkara_id = p.IDPerkara)));";
		$this->patching->exe_script($sql);

			$sql = "DROP TABLE IF EXISTS dataumumweb;";
			$this->patching->exe_script($sql);
			$sql = "CREATE TABLE dataumumweb (
					IDPerkara BIGINT(20) NOT NULL,
					tglPendaftaran DATE,
					klasifikasiPerkara TINYINT DEFAULT NULL,
					IDJenisPerkara SMALLINT,
					jenisPerkara VARCHAR(255) DEFAULT NULL,
					noPerkara VARCHAR(50) DEFAULT NULL,
					tglSurat DATE DEFAULT NULL,
					noSurat VARCHAR(50) DEFAULT NULL,
					petitumDakwaan TEXT,
					dipublikasikan CHAR(1) DEFAULT NULL,
					prodeo TINYINT(1) DEFAULT NULL,
					nilai_sengketa INT(11) DEFAULT NULL,
					IDProses SMALLINT,
					statusAkhir VARCHAR(100) DEFAULT NULL,
					pihakPertama TEXT DEFAULT NULL,
					pihakKedua TEXT DEFAULT NULL,
					pihakKetiga TEXT DEFAULT NULL,
					pihakKeempat TEXT DEFAULT NULL,
					tglPutusan DATE DEFAULT NULL,
					tglMinutasi DATE DEFAULT NULL,
					pasalDakwaan TEXT,
					tglBHT DATE DEFAULT NULL,
					PRIMARY KEY (IDPerkara),
					FULLTEXT KEY jenisPerkara (jenisPerkara,petitumDakwaan,statusAkhir,pihakPertama,pihakKedua,pihakKetiga,pihakKeempat)
				) ENGINE=MyISAM;";
		$this->patching->exe_script($sql);


		$sql = "DROP VIEW IF EXISTS viewperkaramatraweb;";
		$this->patching->exe_script($sql);

		$sql = "CREATE VIEW viewperkaramatraweb AS
				SELECT perkara_id,
					matra,
					berkas_dari,
					tanggal_kejadian,
					tempat_kejadian,
					tanggal_skeppera,
					nomor_skeppera,
					pejabat_skeppera,
					tanggal_surat_dakwaan,
					nomor_surat_dakwaan,
					penyidik_mil,
					no_bap_penyidik_mil,
					tgl_penyidik_mil
				FROM perkara_matra;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS perkaramatraweb;";
		$this->patching->exe_script($sql);

		$sql = "CREATE TABLE perkaramatraweb (
					IDPerkara bigint(20) unsigned NOT NULL,
					matra char(4) DEFAULT NULL,
					asalBerkas varchar(100) DEFAULT NULL,
					tglKejadian varchar(500) DEFAULT NULL,
					tempatKejadian text,
					tglSkeppera date DEFAULT NULL,
					noSkeppera varchar(50) DEFAULT NULL,
					pejabatSkeppera varchar(50) DEFAULT NULL,
					tglSuratDakwaan date DEFAULT NULL,
					noSuratDakwaan varchar(50) DEFAULT NULL,
					penyidik varchar(100) DEFAULT NULL,
					noBAPPenyidik varchar(100) DEFAULT NULL,
					tglPenyidik date DEFAULT NULL,
					PRIMARY KEY (IDPerkara)
				) ENGINE=InnoDB;";
		$this->patching->exe_script($sql);


		$sql = "DROP TABLE IF EXISTS diversiweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE diversiweb (
					id bigint(20) NOT NULL,
					perkara_id bigint(20),
					no_reg_penyidik varchar(50),
					no_reg_penuntut_umum varchar(50),
					tgl_penetapan_musyawarah date,
					tgl_musyawarah date,
					tgl_kesepakatan_diversi date,
					tgl_penetapan_kesepakatan_diversi date,
					no_penetapan_kesepakatan varchar(50),
					tgl_lap_pembimbing_masyarakat date,
					hasil_diversi varchar(50),
					dibuka_kembali int(1),
					no_dibuka_kembali varchar(50),
					tgl_dibuka_kembali date,
					PRIMARY KEY (id)
				) ENGINE=InnoDB;";
		$this->patching->exe_script($sql);


		$sql = "DROP VIEW IF EXISTS viewpihakweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE  VIEW viewpihakweb AS 
				SELECT 
				        '1'                             AS pihak_ke,
				        p1.pihak_id                     AS ID,
				        p1.perkara_id                   AS IDPerkara,
				        (CASE 
				        	WHEN ((p.alur_perkara_id = 1) AND (p.jenis_perkara_id = 64) AND (p1.nama IS NOT NULL) AND (p1.nama <> '')) THEN 'Disamarkan' 
				        	WHEN ((p.alur_perkara_id = 1) AND (p.jenis_perkara_id = 137) AND (p1.nama IS NOT NULL) AND (p1.nama <> '')) THEN 'Disamarkan'
				        	WHEN ((p.alur_perkara_id = 15) AND (p.jenis_perkara_id = 346) AND (p1.nama IS NOT NULL) AND (p1.nama <> '')) THEN 'Disamarkan' 
				        	WHEN ((p.alur_perkara_id = 15) AND (p.jenis_perkara_id = 347) AND (p1.nama IS NOT NULL) AND (p1.nama <> '')) THEN 'Disamarkan' 
				        	WHEN (p.pihak_dipublikasikan = 'Y') THEN p1.nama 
				        	WHEN ((p.pihak_dipublikasikan = 'T') AND (p1.nama IS NOT NULL) AND (p1.nama <> '')) THEN 'Disamarkan' 
				        	ELSE p1.nama END) AS nama,
				        p1.urutan                       AS urutan FROM (perkara_pihak1 p1 LEFT JOIN perkara p ON((p.perkara_id = p1.perkara_id))) UNION ALL SELECT '2' AS pihak_ke,
				        p2.pihak_id                     AS ID,p2.perkara_id AS IDPerkara,
				        (CASE 
				        	WHEN ((p.alur_perkara_id = 118) AND (p2.nama IS NOT NULL) AND (p2.nama <> '')) THEN CONCAT('Anak Berhadapan Dengan Hukum ',p2.urutan) 
				        	WHEN ((p.jenis_perkara_id = 98) AND (p2.nama IS NOT NULL) AND (p2.nama <> '')) THEN 'Terdakwa' 
				        	WHEN ((p.alur_perkara_id = 1) AND (p.jenis_perkara_id = 64) AND (p2.nama IS NOT NULL) AND (p2.nama <> '')) THEN 'Disamarkan' 
				        	WHEN ((p.alur_perkara_id = 1) AND (p.jenis_perkara_id = 137) AND (p2.nama IS NOT NULL) AND (p2.nama <> '')) THEN 'Disamarkan'
				        	WHEN ((p.alur_perkara_id = 15) AND (p.jenis_perkara_id = 346) AND (p2.nama IS NOT NULL) AND (p2.nama <> '')) THEN 'Disamarkan'
				        	WHEN ((p.alur_perkara_id = 15) AND (p.jenis_perkara_id = 347) AND (p2.nama IS NOT NULL) AND (p2.nama <> '')) THEN 'Disamarkan' 
				        	WHEN ((p.pihak_dipublikasikan = 'T') AND (p2.nama IS NOT NULL) AND (p2.nama <> '')) THEN 'Disamarkan' 
				        	ELSE p2.nama END) AS nama,
				        p2.urutan                       AS urutan FROM (perkara_pihak2 p2 LEFT JOIN perkara p ON((p.perkara_id = p2.perkara_id))) UNION ALL SELECT '3' AS pihak_ke,
				        p3.pihak_id                     AS ID,
				        p3.perkara_id                   AS IDPerkara,
				        (CASE 
				        	WHEN ((p.alur_perkara_id = 1) AND (p.jenis_perkara_id = 64) AND (p3.nama IS NOT NULL) AND (p3.nama <> '')) THEN 'Disamarkan' 
				        	WHEN ((p.alur_perkara_id = 1) AND (p.jenis_perkara_id = 137) AND (p3.nama IS NOT NULL) AND (p3.nama <> '')) THEN 'Disamarkan'
				        	WHEN ((p.alur_perkara_id = 15) AND (p.jenis_perkara_id = 346) AND (p3.nama IS NOT NULL) AND (p3.nama <> '')) THEN 'Disamarkan'
				        	WHEN ((p.alur_perkara_id = 15) AND (p.jenis_perkara_id = 347) AND (p3.nama IS NOT NULL) AND (p3.nama <> '')) THEN 'Disamarkan' 
				        	WHEN ((p.pihak_dipublikasikan = 'T') AND (p3.nama IS NOT NULL) AND (p3.nama <> '')) THEN 'Disamarkan' 
				        	ELSE p3.nama END) AS nama,
				        p3.urutan                       AS urutan FROM (perkara_pihak3 p3 LEFT JOIN perkara p ON((p.perkara_id = p3.perkara_id))) UNION ALL SELECT '4' AS pihak_ke,
				        p4.pihak_id                     AS ID,
				        p4.perkara_id                   AS IDPerkara,
				        (CASE 
				        	WHEN ((p.alur_perkara_id = 1) AND (p.jenis_perkara_id = 64) AND (p4.nama IS NOT NULL) AND (p4.nama <> '')) THEN 'Disamarkan' 
				        	WHEN ((p.alur_perkara_id = 1) AND (p.jenis_perkara_id = 137) AND (p4.nama IS NOT NULL) AND (p4.nama <> '')) THEN 'Disamarkan'
				        	WHEN ((p.alur_perkara_id = 15) AND (p.jenis_perkara_id = 346) AND (p4.nama IS NOT NULL) AND (p4.nama <> '')) THEN 'Disamarkan'
				        	WHEN ((p.alur_perkara_id = 15) AND (p.jenis_perkara_id = 347) AND (p4.nama IS NOT NULL) AND (p4.nama <> '')) THEN 'Disamarkan' 
				        	WHEN ((p.pihak_dipublikasikan = 'T') AND (p4.nama IS NOT NULL) AND (p4.nama <> '')) THEN 'Disamarkan' 
				        	ELSE p4.nama END) AS nama,
				        p4.urutan                       AS urutan FROM (perkara_pihak4 p4 LEFT JOIN perkara p ON((p.perkara_id = p4.perkara_id)));
				";
		$this->patching->exe_script($sql);
	
		$sql = "DROP TABLE IF EXISTS pihakweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE  pihakweb(
			pihak_ke TINYINT NOT NULL,
			ID  BIGINT NOT NULL,
			IDPerkara BIGINT NOT NULL,
			nama  TEXT DEFAULT NULL,
			urutan INT(20) DEFAULT NULL,
			PRIMARY KEY (ID,IDPerkara),
			KEY indeks (ID)
		)ENGINE=InnoDB;";
		$this->patching->exe_script($sql);



		$this->patching->exe_script("DROP TABLE IF EXISTS perkara_akta_cerai;");
		$this->patching->exe_script("CREATE TABLE perkara_akta_cerai (
				perkara_id bigint(20) unsigned NOT NULL,
				tahun_akta_cerai int(11) DEFAULT NULL,
				nomor_urut_akta_cerai int(11) DEFAULT NULL,
				nomor_akta_cerai varchar(50) DEFAULT NULL,
				tgl_akta_cerai date DEFAULT NULL,
				no_seri_akta_cerai varchar(50) DEFAULT NULL,
				jenis_cerai varchar(50) DEFAULT NULL,
				faktor_perceraian_id int(11) DEFAULT NULL,
				qobla_bada tinyint(4) DEFAULT NULL,
				perceraian_ke int(11) DEFAULT NULL,
				keadaan_istri TINYINT(4) NULL,
				tgl_penyerahan_akta_cerai DATE NULL,
				akta_cerai_dok VARCHAR(255) DEFAULT NULL,
				diedit_oleh varchar(30) DEFAULT NULL,
				diedit_tanggal datetime DEFAULT NULL,
				diinput_oleh varchar(30) DEFAULT NULL,
				diinput_tanggal datetime DEFAULT NULL,
				diperbaharui_oleh varchar(30) DEFAULT NULL,
				diperbaharui_tanggal datetime DEFAULT NULL,
				PRIMARY KEY (perkara_id),  
				CONSTRAINT perkara_akta_cerai_fk FOREIGN KEY (perkara_id) REFERENCES perkara(perkara_id) ON DELETE CASCADE
				) ENGINE=InnoDB;");
		

		$this->patching->exe_script("DROP TABLE IF EXISTS perkara_ikrar_talak;");
		$this->patching->exe_script("CREATE TABLE perkara_ikrar_talak (
				perkara_id bigint(20) unsigned NOT NULL,
				penetapan_majelis_hakim date DEFAULT NULL,
				majelis_hakim_id varchar(50) DEFAULT NULL,
				majelis_hakim_nama varchar(500) DEFAULT NULL,
				majelis_hakim_text varchar(500) DEFAULT NULL,
				penetapan_panitera_pengganti date DEFAULT NULL,
				panitera_pengganti_id varchar(50) DEFAULT NULL,
				panitera_pengganti_text varchar(500) DEFAULT NULL,
				penetapan_jurusita date DEFAULT NULL,
				jurusita_id varchar(50) DEFAULT NULL,
				jurusita_text varchar(500) DEFAULT NULL,
				sidang_id bigint(20) DEFAULT NULL,
				tanggal_penetapan_sidang_ikrar date DEFAULT NULL,
				tanggal_sidang_pertama date DEFAULT NULL,
				tgl_ikrar_talak date DEFAULT NULL,
				status_penetapan_ikrar_talak_id char(1) DEFAULT NULL,
				amar_ikrar_talak text,
				ikrar_talak_dok varchar(255) DEFAULT NULL,
				diinput_oleh varchar(30) DEFAULT NULL,
				diinput_tanggal datetime DEFAULT NULL,
				diperbaharui_oleh varchar(30) DEFAULT NULL,
				diperbaharui_tanggal datetime DEFAULT NULL,
				PRIMARY KEY (perkara_id),
				CONSTRAINT perkara_ikrar_talak_fk FOREIGN KEY (perkara_id) REFERENCES perkara(perkara_id) ON DELETE CASCADE
				) ENGINE=InnoDB;");

		$this->patching->exe_script("DROP TABLE IF EXISTS perkara_izin_cerai;");
		$this->patching->exe_script("CREATE TABLE perkara_izin_cerai(  
				perkara_id BIGINT(20) UNSIGNED NOT NULL,
				pihak_id BIGINT(20) NOT NULL,
				STATUS TINYINT(1),
				tanggal_surat DATE,
				nomor_surat VARCHAR(30),
				nama_pejabat VARCHAR(50),
				jabatan_pejabat VARCHAR(50),
				diedit_oleh VARCHAR(30),
				diedit_tanggal DATETIME,
				diinput_oleh VARCHAR(30),
				diinput_tanggal DATETIME,
				diperbaharui_oleh VARCHAR(30),
				diperbaharui_tanggal DATETIME,
				PRIMARY KEY (pihak_id),
				CONSTRAINT perkara_izin_cerai_fk FOREIGN KEY (perkara_id) REFERENCES perkara(perkara_id) ON DELETE CASCADE
				)ENGINE=INNODB;");


		$sql = "DROP VIEW IF EXISTS viewpengacaraweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE VIEW viewpengacaraweb AS 
				SELECT
				        pengacara.perkara_id   AS IDPerkara,
				        pengacara.pengacara_id AS pengacara_id,
				        pengacara.nama         AS nama,
				        pengacara.urutan       AS urutan,
				        pengacara.aktif        AS aktif,
				        pengacara.pihak_ke     AS pihak_ke,
				        pengacara.pihak_id     AS pihak_id,
				        CASE 
				        	WHEN per.alur_perkara_id = 1 AND per.jenis_perkara_id = 64 THEN 'Disamarkan' 
				        	WHEN per.alur_perkara_id = 1 AND per.jenis_perkara_id = 137 THEN 'Disamarkan' 
				        	WHEN per.alur_perkara_id = 15 AND per.jenis_perkara_id = 347 THEN 'Disamarkan' 
				        	WHEN per.alur_perkara_id = 15 AND per.jenis_perkara_id = 346 THEN 'Disamarkan' 
				        	WHEN per.pihak_dipublikasikan = 'T' AND (p.nama IS NOT NULL OR p.nama <> '') THEN 'Disamarkan' 
				        	ELSE p.nama END AS namapihak
				FROM perkara_pengacara pengacara
				          LEFT JOIN pihak p
				            ON p.id = pengacara.pihak_id
				         LEFT JOIN perkara per
				           ON per.perkara_id = pengacara.perkara_id;";
		$this->patching->exe_script($sql);



		$sql = "DROP TABLE IF EXISTS pengacaraweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE  pengacaraweb(
			IDPerkara  BIGINT(20) UNSIGNED NOT NULL,
			IDPengacara  BIGINT(20) UNSIGNED NOT NULL,
			pengacaraNama VARCHAR(500) NOT NULL,
			urutan SMALLINT DEFAULT NULL,
			aktif CHAR(1) DEFAULT 'Y',
				pihakKe  TINYINT(1) NOT NULL,
				IDPihak  BIGINT(20) UNSIGNED NOT NULL,
				pihakNama  VARCHAR(500) NOT NULL,
				PRIMARY KEY (IDPerkara,IDPengacara,IDPihak,pihakKe)
		)ENGINE=InnoDB;";
		$this->patching->exe_script($sql);



		$sql = "DROP VIEW IF EXISTS viewhakimweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE VIEW viewhakimweb AS 
				SELECT
				        perkarahakim.perkara_id         AS IDPerkara,
				        perkarahakim.hakim_id           AS IDHakim,
				        perkarahakim.tahapan_id         AS IDTahapan,
				        perkarahakim.tanggal_penetapan  AS tglPenetapan,
				        perkarahakim.jabatan_hakim_nama AS posisiHakim,
				        perkarahakim.urutan             AS urutan,
				        (CASE WHEN (vp.hasil_mediasi = 'Y') THEN hakim.nama WHEN ((vp.tanggal_putusan IS NOT NULL)) THEN hakim.nama WHEN ((vp.tanggal_cabut IS NOT NULL)) THEN hakim.nama WHEN ((vp.tanggal_gugur IS NOT NULL)) THEN hakim.nama ELSE 'Belum Dapat Ditampilkan' END) AS nama,
				        perkarahakim.aktif              AS aktif,
				        vp.jenis_acara
				FROM perkara_hakim_pn perkarahakim
				          LEFT JOIN hakim_pn hakim
				            ON perkarahakim.hakim_id = hakim.id
				         LEFT JOIN v_perkara vp
				           ON perkarahakim.perkara_id = vp.perkara_id
				ORDER BY perkarahakim.perkara_id,perkarahakim.urutan;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS hakimweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE hakimweb (
				  IDPerkara BIGINT(20) NOT NULL,
				  IDHakim BIGINT(20) NOT NULL,
				  IDTahapan TINYINT(2),
				  tglPenetapan DATE NOT NULL,
				  posisiHakim VARCHAR(20) DEFAULT NULL,
				  urutan TINYINT(2) DEFAULT NULL,
				  nama VARCHAR(100) DEFAULT NULL,
				  aktif CHAR(1) DEFAULT NULL,
				  jenisAcara VARCHAR(20) DEFAULT NULL,
				  PRIMARY KEY (IDPerkara,IDHakim,tglPenetapan),
				  KEY indeks (IDPerkara)
				) ENGINE=InnoDB;";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS viewppweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE  VIEW viewppweb AS 
				SELECT
				  perkarapp.id                AS IDPP,
				  perkarapp.perkara_id        AS IDPerkara,
				  perkarapp.tahapan_id        AS IDTahapan,
				  perkarapp.tanggal_penetapan AS tglPenetapan,
				  (CASE WHEN (vp.hasil_mediasi = 'Y') THEN pp.nama WHEN ((vp.tanggal_putusan IS NOT NULL)) THEN pp.nama WHEN ((vp.tanggal_cabut IS NOT NULL)) THEN pp.nama WHEN ((vp.tanggal_gugur IS NOT NULL)) THEN pp.nama ELSE 'Belum Dapat Ditampilkan' END) AS nama,
				  perkarapp.aktif             AS aktif
				FROM ((perkara_panitera_pn perkarapp
				    LEFT JOIN panitera_pn pp
				      ON ((perkarapp.panitera_id = pp.id)))
				   LEFT JOIN v_perkara vp
				     ON ((perkarapp.perkara_id = vp.perkara_id)));";
		$this->patching->exe_script($sql);


		$sql = "DROP TABLE IF EXISTS ppweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE ppweb (
				  IDPP BIGINT(11) NOT NULL,
				  IDPerkara BIGINT(20) NOT NULL,
				  IDTahapan TINYINT(2) DEFAULT '10',
				  tglPenetapan DATE NOT NULL,
				  nama VARCHAR(100) DEFAULT NULL,
				  aktif CHAR(1) DEFAULT NULL,
				  PRIMARY KEY (IDPerkara,IDPP,tglPenetapan)
				) ENGINE=InnoDB;";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS viewjurusitaweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE VIEW viewjurusitaweb AS 
				SELECT
				        perkarajs.id                AS IDJs,
				        perkarajs.perkara_id        AS IDPerkara,
				        perkarajs.tahapan_id        AS IDTahapan,
				        perkarajs.tanggal_penetapan AS tglPenetapan,
				        (CASE WHEN (vp.hasil_mediasi = 'Y') THEN js.nama WHEN ((vp.tanggal_putusan IS NOT NULL)) THEN js.nama WHEN ((vp.tanggal_cabut IS NOT NULL)) THEN js.nama WHEN ((vp.tanggal_gugur IS NOT NULL)) THEN js.nama ELSE 'Belum Dapat Ditampilkan' END) AS nama,
				        perkarajs.aktif             AS aktif
				FROM ((perkara_jurusita perkarajs
				          LEFT JOIN jurusita js
				            ON ((perkarajs.jurusita_id = js.id)))
				         LEFT JOIN v_perkara vp
				           ON ((perkarajs.perkara_id = vp.perkara_id)))
				ORDER BY perkarajs.perkara_id;";
		$this->patching->exe_script($sql);


		$sql = "DROP TABLE IF EXISTS jurusitaweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE jurusitaweb (
				  IDJs BIGINT(20) DEFAULT NULL,
				  IDPerkara BIGINT(20) NOT NULL,
				  IDTahapan TINYINT(2) DEFAULT '10',
				  tglPenetapan DATE NOT NULL,
				  nama VARCHAR(100) NOT NULL,
				  aktif CHAR(1) DEFAULT NULL,
				  PRIMARY KEY (IDPerkara,tglPenetapan,nama)
				) ENGINE=InnoDB;";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS tmediasi;";
		$this->patching->exe_script($sql);
		$sql = "CREATE VIEW tmediasi AS
		SELECT  mediasi_id AS IDMediasi,
				jenis_mediasi AS jenisMediasi,
				tahapan_id AS IDTahapan,
				perkara_id AS IDPerkara,
				penetapan_penunjukan_mediator AS tglPenetapan,
				nomor_sk_penetapan_mediator AS SKPenetapan,
				mediator_id AS IDMediator,
				dimulai_mediasi AS tglMediasi,
				keputusan_mediasi AS tglPutusan,
				IF(hasil_mediasi='T','Mediasi Tidak Berhasil',isi_akta_perdamaian) AS hasil,
				hasil_mediasi                 AS jenis_hasil_mediasi,
				akta_perdamaian AS tglAkta,
				isi_akta_perdamaian AS isiAkta,
				tgl_permohonan_uh AS tglPermohonanMediasi,
				tgl_pemberitahuan_ke_ptma AS tglBeritahu,
				tgl_laporan_mediator AS tglLaporan,
				tgl_kirim_kesepakatan_ke_ptma AS tglKirimKesepakatan
				FROM perkara_mediasi;";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS viewmediasiweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE VIEW viewmediasiweb AS 
				SELECT
				        tmediasi.IDMediasi            AS IDMediasi,
				        tmediasi.IDTahapan            AS IDTahapan,
				        tmediasi.IDPerkara            AS IDPerkara,
				        tmediasi.jenisMediasi         AS jenisMediasi,
				        tmediasi.tglPenetapan         AS tglPenetapan,
				        tmediasi.SKPenetapan          AS SKPenetapan,
				        tmediasi.IDMediator           AS IDMediator,
				        tmediator.profesi             AS statusMediator,
				        tmediator.nama_gelar          AS nama,
				        tmediasi.tglMediasi           AS tglMediasi,
				        tmediasi.tglPutusan           AS tglPutusan,
				        tmediasi.hasil                AS hasil,
				        tmediasi.jenis_hasil_mediasi  AS jenis_hasil_mediasi,
				        tmediasi.tglAkta              AS tglAkta,
				        tmediasi.isiAkta              AS isiAkta,
				        tmediasi.tglPermohonanMediasi AS tglPermohonanMediasi,
				        tmediasi.tglBeritahu          AS tglBeritahu,
				        tmediasi.tglLaporan           AS tglLaporan,
				        tmediasi.tglKirimKesepakatan  AS tglKirimKesepakatan
				FROM (tmediasi
				         LEFT JOIN mediator tmediator
				           ON ((tmediasi.IDMediator = tmediator.id)))
				ORDER BY tmediasi.IDMediasi;";
		$this->patching->exe_script($sql);


		$sql = "DROP TABLE IF EXISTS mediasiweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE mediasiweb (
			IDMediasi BIGINT NOT NULL,  
			IDTahapan TINYINT(1),
			IDPerkara BIGINT NOT NULL,
			jenisMediasi TINYINT(1),
			tglPenetapan DATE,
			SKPenetapan VARCHAR(50),  
			IDMediator VARCHAR(50),
			statusMediator VARCHAR(50),
			nama VARCHAR(50), 
			tglMulaiMediasi DATE,
			tglPutusan DATE,
			hasil TEXT,
			jenisHasilMediasi TEXT,
			tglAkta DATE,
			isiAkta TEXT,
			tglPermohonanMediasi DATE,
			tglBeritahu DATE,
			tglLaporan DATE,
			tglKirimKesepakatan DATE,
			PRIMARY KEY (IDMediasi,IDPerkara),
			KEY indeks (IDMediasi)
		)ENGINE=InnoDB;";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS viewputusanperdataweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS putusanperdataweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS viewputusanpidanaweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS putusanpidanaweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS viewputusanpenahananweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS putusanpenahananweb;";
		$this->patching->exe_script($sql);

		$this->patching->exe_script('DROP PROCEDURE IF EXISTS syncPutusanPerdataWeb;');
		$this->patching->exe_script('DROP TRIGGER IF EXISTS InsertPutusanPerdataWeb;');
		$this->patching->exe_script('DROP TRIGGER IF EXISTS UpdatePutusanPerdataWeb;');
		$this->patching->exe_script('DROP TRIGGER IF EXISTS DelPutusanPerdataWeb;');

		$this->patching->exe_script('DROP PROCEDURE IF EXISTS syncPutusanPidanaWeb;');
		$this->patching->exe_script('DROP PROCEDURE IF EXISTS syncPutusanPenahananWeb;');

		$this->patching->exe_script('DROP TRIGGER IF EXISTS InsertPutusanPenahananWeb;');
		$this->patching->exe_script('DROP TRIGGER IF EXISTS UpdatePutusanPenahananWeb;');
		$this->patching->exe_script('DROP TRIGGER IF EXISTS DelPutusanPenahananWeb;');

		$sql = "DROP VIEW IF EXISTS viewsidangpertamaweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE  VIEW viewsidangpertamaweb AS 
				SELECT
				  perkara_penetapan.perkara_id            AS IDPerkara,
				  perkara_penetapan.penetapan_hari_sidang AS tglPenetapan,
				  perkara_penetapan.sidang_pertama        AS tglSidangPertama
				FROM perkara_penetapan;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS sidangpertamaweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE sidangpertamaweb (
			IDPerkara  BIGINT NOT NULL,
			tglPenetapan DATE,
			tglSidangPertama DATE,
			PRIMARY KEY (IDPerkara)
		)ENGINE=InnoDB;";
		$this->patching->exe_script($sql);

		$sql = "REPLACE INTO sidangpertamaweb SELECT * FROM viewsidangpertamaweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP PROCEDURE IF EXISTS syncSidangPertamaweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE PROCEDURE syncSidangPertamaweb (NEWIDPerkara BIGINT)
		BEGIN
			REPLACE INTO sidangpertamaweb SELECT * FROM viewsidangpertamaweb WHERE IDPerkara = NEWIDPerkara;
		END;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS InsertSidangPertamaweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TRIGGER InsertSidangPertamaweb AFTER INSERT ON perkara_penetapan
			FOR EACH ROW
				BEGIN
					CALL syncSidangPertamaweb(NEW.perkara_id);
				END;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS UpdateSidangPertamaweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TRIGGER UpdateSidangPertamaweb AFTER UPDATE ON perkara_penetapan
		FOR EACH ROW
			BEGIN
				CALL syncSidangPertamaweb(NEW.perkara_id);
			END;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS DelSidangPertamaweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TRIGGER DelSidangPertamaweb AFTER DELETE ON perkara_penetapan
		FOR EACH ROW
			BEGIN
				DELETE FROM sidangpertamaweb WHERE IDPerkara = OLD.perkara_id;
			END;";
		$this->patching->exe_script($sql);


		$sql = "DROP VIEW IF EXISTS viewjadwalsidangweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE VIEW viewjadwalsidangweb AS 
				SELECT
				        perkara_jadwal_sidang.id              AS ID,
				        perkara_jadwal_sidang.perkara_id      AS IDPerkara,
				        perkara_jadwal_sidang.tanggal_sidang  AS tglSidang,
				        perkara_jadwal_sidang.jam_sidang      AS jamSidang,
				        perkara_jadwal_sidang.sampai_jam      AS selesaiSidang,
				        perkara_jadwal_sidang.agenda          AS agenda,
				        perkara_jadwal_sidang.ruangan         AS ruangan,
				        perkara_jadwal_sidang.sidang_keliling AS sidangKeliling,
				        (CASE WHEN (ISNULL(perkara_jadwal_sidang.dihadiri_oleh) OR (perkara_jadwal_sidang.dihadiri_oleh = '')) THEN NULL WHEN (perkara_jadwal_sidang.dihadiri_oleh = 1) THEN 'Semua Pihak' WHEN (perkara_jadwal_sidang.dihadiri_oleh = 2) THEN 'Pihak Pertama Saja' WHEN (perkara_jadwal_sidang.dihadiri_oleh = 3) THEN 'Pihak Kedua Saja' WHEN (perkara_jadwal_sidang.dihadiri_oleh = 4) THEN 'Pihak Tidak Hadir' ELSE NULL END) AS dihadiriOleh,
				        perkara_jadwal_sidang.ditunda         AS ditunda,
				        perkara_jadwal_sidang.alasan_ditunda  AS alasanDitunda,
				        perkara_jadwal_sidang.keberatan       AS keberatan,
				        perkara_jadwal_sidang.keterangan      AS keterangan
				FROM perkara_jadwal_sidang;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS jadwalsidangweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE jadwalsidangweb (
			ID BIGINT NOT NULL,
			IDPerkara BIGINT NOT NULL,
			tglSidang DATE,
			jamSidang TIME,
			selesaiSidang TIME,
			agenda TEXT,
			ruangan VARCHAR(50),
			sidangKeliling CHAR(1),
			dihadiriOleh VARCHAR(25),
			ditunda CHAR(1),
			alasanDitunda TEXT,
			verzet CHAR(1),
			keterangan TEXT,
			PRIMARY KEY (ID, IDPerkara),
			KEY indeks (IDPerkara)
		)ENGINE=InnoDB;";
		$this->patching->exe_script($sql);



		$sql = "DROP VIEW IF EXISTS viewperkarabiayaweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE VIEW viewperkarabiayaweb AS 
				SELECT
				        perkara_biaya.id                AS ID,
				        perkara_biaya.perkara_id        AS IDPerkara,
				        perkara_biaya.tahapan_id        AS IDTahapan,
				        perkara_biaya.jenis_transaksi   AS jenisTransaksi,
				        perkara_biaya.tanggal_transaksi AS tglTransaksi,
				        perkara_biaya.uraian            AS uraian,
				        perkara_biaya.jumlah            AS nominal,
				        perkara_biaya.keterangan        AS keterangan
				FROM perkara_biaya
				WHERE perkara_id IS NOT NULL
				ORDER BY perkara_biaya.perkara_id,perkara_biaya.tanggal_transaksi;";
		$this->patching->exe_script($sql);


		$sql="DROP VIEW IF EXISTS viewhartapailitweb";
		$this->patching->exe_script($sql);
		$sql ="CREATE VIEW viewhartapailitweb AS 
				SELECT
				        perkara_harta_pailit.perkara_id                       AS perkara_id,
				        perkara_harta_pailit.tanggal_pendaftaran              AS tanggal_pendaftaran,
				        perkara_harta_pailit.tanggal_penetapan_hakim_pengawas AS tanggal_penetapan_hakim_pengawas,
				        perkara_harta_pailit.hakim_pengawas_id                AS hakim_pengawas_id,
				        perkara_harta_pailit.nama_kurator                     AS nama_kurator,
				        perkara_harta_pailit.tanggal_insolvensi               AS tanggal_insolvensi,
				        perkara_harta_pailit.amar_penetapan_hakim_pengawas    AS amar_penetapan_hakim_pengawas,
				        perkara_harta_pailit.panitera_id                      AS panitera_id,
				        perkara_harta_pailit.jurusita_id                      AS jurusita_id,
				        perkara_harta_pailit.tanggal_pelelangan               AS tanggal_pelelangan,
				        perkara_harta_pailit.tanggal_pembagian                AS tanggal_pembagian,
				        perkara_harta_pailit.nama_kreditur                    AS nama_kreditur,
				        perkara_harta_pailit.jumlah_pembagian                 AS jumlah_pembagian,
				        perkara_harta_pailit.catatan_harta_pailit             AS catatan_harta_pailit
				FROM perkara_harta_pailit;";
		$this->patching->exe_script($sql);



		$sql = "DROP TABLE IF EXISTS perkarabiayaweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE  perkarabiayaweb (
			ID BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
				IDPerkara BIGINT UNSIGNED NOT NULL,
				IDTahapan SMALLINT,
				jenisTransaksi TINYINT(1) DEFAULT NULL,
				tglTransaksi DATE DEFAULT NULL,
				uraian VARCHAR(255) DEFAULT NULL,
				nominal INT UNSIGNED NOT NULL,
				keterangan TEXT DEFAULT NULL,
				PRIMARY KEY (ID, IDPerkara)
		)ENGINE=InnoDB;";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS viewverzetweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE  VIEW viewverzetweb AS 
				SELECT
				  v.perkara_id                          AS IDPerkara,
				  v.tanggal_pendaftaran_verzet          AS tglPendaftaran,
				  v.penetapan_majelis_hakim             AS tglPenetapanMajelis,
				  IF(ISNULL(v.putusan_verzet),'Belum Dapat Ditampilkan',v.majelis_hakim_text) AS majelisHakim,
				  v.penetapan_panitera_pengganti        AS tglPenetapanPP,
				  IF(ISNULL(v.putusan_verzet),'Belum Dapat Ditampilkan',v.panitera_pengganti_text) AS paniteraPengganti,
				  v.penetapan_jurusita                  AS tglPenetapanJurusita,
				  IF(ISNULL(v.putusan_verzet),'Belum Dapat Ditampilkan',v.jurusita_text) AS jurusita,
				  v.tanggal_penetapan_sidang_verzet     AS tglPenetapanSidang,
				  v.tanggal_sidang_pertama_verzet       AS tglSidangPertama,
				  v.putusan_verstek                     AS verstek,
				  s.nama                                AS sumberHukum,
				  v.putusan_verzet                      AS putusan,
				  v.status_putusan_verzet_text          AS statusPutusan,
				  v.amar_putusan_verzet                 AS amarPutusan,
				  v.pemberitahuan_putusan               AS jenisPemberitahuan,
				  v.pemberitahuan_putusan_verzet        AS tglPemberitahuan,
				  v.pemberitahuan_putusan_verzet_pihak1 AS tglPemberitahuanPutusanKpdPenggugat,
				  v.pemberitahuan_putusan_verzet_pihak2 AS tglPemberitahuanPutusanKpdTergugat
				FROM (perkara_verzet v
				   LEFT JOIN sumber_hukum s
				     ON ((s.id = v.sumber_hukum_id)));";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS verzetweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE  verzetweb (
			IDPerkara BIGINT UNSIGNED NOT NULL,
			tglPendaftaran DATE,
			tglPenetapanMajelis DATE,
			majelisHakim VARCHAR(500),
			tglPenetapanPP DATE,
			paniteraPengganti VARCHAR(500),
			tglPenetapanJurusita DATE,
			jurusita VARCHAR(500),
			tglPenetapanSidang DATE,
			tglSidangPertama DATE,
			verstek CHAR(1),
			sumberHukum VARCHAR(50),
			putusan DATE,
			statusPutusan VARCHAR(50),  
			amarPutusan TEXT,
			jenisPemberitahuan VARCHAR(15),
			tglPemberitahuan DATE,
			tglPemberitahuanPutusanKpdPenggugat TEXT,
			tglPemberitahuanPutusanKpdTergugat TEXT,
				PRIMARY KEY (IDPerkara)
		)ENGINE=InnoDB;";
		$this->patching->exe_script($sql);


		$sql = "DROP VIEW IF EXISTS viewikrarweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE  VIEW viewikrarweb AS 
				SELECT
				  perkara_id                        AS IDPerkara,
				  penetapan_majelis_hakim           AS tglPenetapanMajelis,
				  majelis_hakim_text 				AS majelisHakim,
				  penetapan_panitera_pengganti      AS tglPenetapanPP,
				  panitera_pengganti_text 			AS paniteraPengganti,
				  penetapan_jurusita                AS tglPenetapanJurusita,
				  jurusita_text 					AS jurusita,
				  tanggal_penetapan_sidang_ikrar    AS tglPenetapanSidang,
				  tanggal_sidang_pertama      		AS tglSidangPertama,
				  tgl_ikrar_talak                   AS tglIkrar,
				  status_penetapan_ikrar_talak_id   AS IDStatusPenetapan,
				  amar_ikrar_talak                 	AS amarPutusan
				FROM perkara_ikrar_talak;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS ikrarweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE  ikrarweb (
					IDPerkara 		BIGINT UNSIGNED NOT NULL,
					tglPenetapanMajelis DATE,
					majelisHakim 	VARCHAR(500),
					tglPenetapanPP DATE,
					paniteraPengganti VARCHAR(200),
					tglPenetapanJurusita DATE,
					jurusita VARCHAR(200),
					tglPenetapanSidang DATE,
					tglSidangPertama DATE,
					tglIkrar DATE,
					IDStatusPenetapan CHAR(50),  
					amarPutusan TEXT,
					PRIMARY KEY (IDPerkara)
				)ENGINE=InnoDB;";
		$this->patching->exe_script($sql);


		$sql = "DROP VIEW IF EXISTS viewpenahananweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE VIEW viewpenahananweb AS 
				SELECT
				        tp.id            AS id,
				        tp.perkara_id    AS IDPerkara,
				        pihak.nama       AS terdakwa,
				        (CASE WHEN (tp.jenis_tahanan_id = 1) THEN 'Tahanan Kota' WHEN (tp.jenis_tahanan_id = 2) THEN 'Tahanan Rumah' WHEN (tp.jenis_tahanan_id = 3) THEN 'Tahanan Rutan' ELSE 'Tidak Diketahui' END) AS jenisTahanan,
				        jp.nama          AS ditahanOleh,
				        (CASE WHEN (tp.status_penahanan_id = 1) THEN 'Ditahan' WHEN (tp.status_penahanan_id = 2) THEN 'Tidak Ditahan' WHEN (tp.status_penahanan_id = 3) THEN 'Dibantar(Stuitting)' WHEN (tp.status_penahanan_id = 4) THEN 'Ditangguhkan' ELSE 'Tidak Diketahui' END) AS statusPenahanan,
				        tp.tanggal_surat AS tglSurat,
				        tp.nomor_surat   AS noSurat,
				        tp.mulai         AS mulai,
				        tp.sampai        AS sampai,
				        tp.keterangan    AS keterangan
				FROM ((penahanan_terdakwa tp
				          JOIN perkara_pihak2 pihak)
				         JOIN jenis_penahanan jp)
				WHERE ((tp.pihak_id = pihak.pihak_id)
				       AND (tp.jenis_penahanan_id = jp.id));";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS penahananweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE  penahananweb (
			ID  BIGINT UNSIGNED NOT NULL,
			IDPerkara BIGINT UNSIGNED NOT NULL,
			terdakwa VARCHAR(255),
			jenisTahanan VARCHAR(100),
			ditahanOleh VARCHAR(100),
			statusPenahanan VARCHAR(100),
			tglSurat DATE,
			noSurat VARCHAR(100),
			mulai DATE,
			sampai  DATE,
			keterangan VARCHAR(255),
				PRIMARY KEY (ID)
		)ENGINE=InnoDB;";
		$this->patching->exe_script($sql);

		# ===============
		$this->patching->exe_script("UPDATE perkara_putusan SET hakim_pengawas_id=NULL WHERE hakim_pengawas_id ='';");
		$this->patching->exe_script("UPDATE perkara_putusan SET pengurus_id=NULL WHERE pengurus_id ='';");
		$this->patching->exe_script("UPDATE perkara_putusan SET kurator_id=NULL WHERE kurator_id ='';");


		$sql = "DROP VIEW IF EXISTS viewperkaraputusanweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE VIEW viewperkaraputusanweb AS 
            SELECT
          put.perkara_id                     AS IDPerkara,
          put.tanggal_putusan                AS tglPutusan,
          put.putusan_verstek                AS isVerstek,
          s.nama                             AS sumberHukum,
          put.status_putusan_id              AS IDStatusPutusan,
          sp.nama                            AS statusPutusan,
          put.tanggal_cabut                  AS tglCabut,
          put.tanggal_gugur                  AS tglGugur,
          (CASE
            WHEN p.alur_perkara_id = 118 THEN 'Disamarkan'
            WHEN p.jenis_perkara_id IN (64,98,242,346,347,248,312,349,350,352) THEN 'Disamarkan'
            ELSE    put.amar_putusan 
            END) AS amar,
          put.penetapan_hakim_pengawas       AS tglPenetapanHakimPengawas,
          put.nomor_penetapan_hakim_pengawas AS noPenetapanHakimPengawas,
          put.hakim_pengawas_id              AS IDHakimPengawas,
          put.pengurus_id                    AS IDPengurus,
          put.tanggal_penetapan_kreditur     AS tglPenetapanKreditur,
          put.panitia_kreditur               AS panitiaKreditur,
          put.kurator_id                     AS IDKurator,
          put.tanggal_berita_putusan         AS tglMediaBerita,
          put.nama_media_berita_putusan      AS namaMediaBerita,
          put.tanggal_surat_kabar_putusan    AS tglSuratKabar,
          put.nama_surat_kabar_putusan       AS namaSuratKabar,
          put.tanggal_minutasi               AS tglMinutasi,
          put.kirim_salinan_putusan_penyidik AS TglKirimSalinanPenyidik,
          put.catatan_putusan                AS catatan_putusan,
          put.nilai_ganti_kerugian           AS nilai_ganti_kerugian
        FROM perkara_putusan AS put
            LEFT JOIN sumber_hukum AS s
              ON s.id = put.sumber_hukum_id
           LEFT JOIN status_putusan AS sp
             ON sp.id = put.status_putusan_id
           LEFT JOIN perkara AS p
            ON p.perkara_id = put.perkara_id;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS perkaraputusanweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE perkaraputusanweb (
					IDPerkara BIGINT(20) UNSIGNED NOT NULL,
					tglPutusan DATE NOT NULL,
					isVerstek CHAR(1) DEFAULT NULL,
					sumberHukum VARCHAR(100) DEFAULT NULL,
					IDStatusPutusan SMALLINT(20) DEFAULT NULL,
					statusPutusan VARCHAR(100) DEFAULT NULL,
					tglCabut DATE DEFAULT NULL,
					tglGugur DATE DEFAULT NULL,
					amar TEXT,
					tglPenetapanHakimPengawas DATE DEFAULT NULL,
					noPenetapanHakimPengawas VARCHAR(50),
					IDHakimPengawas BIGINT(20) UNSIGNED DEFAULT NULL,
					IDPengurus BIGINT(20) UNSIGNED DEFAULT NULL,
					tglPenetapanKreditur DATE DEFAULT NULL,
					panitiaKreditur VARCHAR(500) DEFAULT NULL,
					IDKurator BIGINT(20) UNSIGNED DEFAULT NULL,
					tglMediaBerita DATE DEFAULT NULL,
					namaMediaBerita VARCHAR(250) DEFAULT NULL,
					tglSuratKabar DATE DEFAULT NULL,
					namaSuratKabar VARCHAR(250),
					tglMinutasi DATE DEFAULT NULL,
					TglKirimSalinanPenyidik DATE DEFAULT NULL,
					keterangan TEXT,
					nilaiGantiRugi INT(20) DEFAULT NULL,
					PRIMARY KEY (IDPerkara)
				) ENGINE=InnoDB;";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS viewperkaraputusanterdakwa;";
		$this->patching->exe_script($sql);
		$sql = "CREATE VIEW viewperkaraputusanterdakwa AS 
              SELECT 
                      p.id AS ID,
                      p.perkara_id AS IDPerkara,
                      pp.status_putusan_id AS IDStatusPutusan,
                      (CASE
                        WHEN (v_perkara.pihak_dipublikasikan = 'T') THEN concat('Terdakwa',p.urutan) 
                    WHEN (v_perkara.alur_perkara_id = 118) THEN concat('Anak Berhadapan Dengan Hukum ',p.urutan) ELSE p.nama 
                      END) AS nama,
                      pp.durasi_nominal AS durasiNominal,
                      v_perkara.tanggal_putusan AS tglPutusan,
                      s.nama AS statusPutusan,
                      pp.satuan AS satuan 
              FROM
                  perkara_pihak2 p 
                LEFT JOIN perkara_putusan_terdakwa pp 
                ON pp.perkara_id = p.perkara_id AND pp.pihak2_id = p.id
                LEFT JOIN status_putusan s ON s.id = pp.status_putusan_id
                LEFT JOIN v_perkara ON v_perkara.perkara_id = pp.perkara_id
                  WHERE v_perkara.alur_perkara_id >100
                  ORDER BY p.urutan;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS perkaraputusanterdakwa;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE perkaraputusanterdakwa (
				ID BIGINT(20) UNSIGNED NOT NULL,
				IDPerkara BIGINT(20) UNSIGNED DEFAULT NULL,
				IDStatusPutusan TINYINT(4) NOT NULL,
				nama TEXT,
				durasiNominal TEXT,
				tglPutusan DATE DEFAULT NULL,
				statusPutusan VARCHAR(50) DEFAULT NULL,
				satuan TINYINT(4) DEFAULT NULL,
				PRIMARY KEY (ID,IDPerkara,IDStatusPutusan)
				) ENGINE=InnoDB;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS putusanpidanaweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS putusanpenahananweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS viewputusanselaweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS viewputusanpenahananweb;";
		$this->patching->exe_script($sql);


		# ===============

		$sql = "DROP VIEW IF EXISTS viewputusanselaweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE  VIEW viewputusanselaweb AS 
				SELECT
				  perkara_putusan_sela.perkara_id                        AS IDPerkara,
				  perkara_putusan_sela.tanggal_putusan_sela              AS tglPutusanSela,
				  perkara_putusan_sela.amar_sela                         AS amarSela,
				  perkara_putusan_sela.tanggal_minutasi_sela             AS tglMinutasi,
				  perkara_putusan_sela.tanggal_berita_sela               AS tglBerita,
				  perkara_putusan_sela.nama_media_berita_sela            AS namaMedia,
				  perkara_putusan_sela.tanggal_surat_kabar_sela          AS tglSuratKabar,
				  perkara_putusan_sela.nama_surat_kabar_sela             AS namaSuratKabar,
				  perkara_putusan_sela.penetapan_hakim_pengawas          AS tglPenetapanHakim,
				  perkara_putusan_sela.hakim_pengawas_nama               AS hakimPengawas,
				  perkara_putusan_sela.pengurus_nama                     AS pengurusNama,
				  perkara_putusan_sela.tanggal_perpanjangan              AS tglPerpanjangan,
				  perkara_putusan_sela.mulai_perpanjangan                AS mulaiPerpanjangan,
				  perkara_putusan_sela.sampai_perpanjangan               AS sampaiPerpanjangan,
				  perkara_putusan_sela.penetapan_sita_jaminan            AS penetapanSitaJaminan,
				  perkara_putusan_sela.pelaksanaan_sita_jaminan          AS pelaksanaanSitaJaminan,
				  perkara_putusan_sela.pemberitahuan_putusan_sela_pihak1 AS pemberitahuanPihak1,
				  perkara_putusan_sela.pemberitahuan_putusan_sela_pihak2 AS pemberitahuanPihak2,
				  perkara_putusan_sela.pemberitahuan_putusan_sela_pihak3 AS pemberitahuanPihak3,
				  perkara_putusan_sela.catatan_putusan                   AS keterangan
				FROM perkara_putusan_sela;";
		$this->patching->exe_script($sql);


		$sql = "DROP TABLE IF EXISTS putusanselaweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE  putusanselaweb (
			IDPerkara BIGINT UNSIGNED NOT NULL,
			tglPutusanSela DATE NULL, 
			amarSela TEXT NULL,
			tglMinutasi DATE NULL,
			tglBerita DATE NULL,
			namaMedia VARCHAR(255),
			tglSuratKabar DATE NULL,
			namaSuratKabar VARCHAR(255),
			tglPenetapanHakim DATE NULL,
			hakimPengawas VARCHAR(255),
			pengurusNama VARCHAR(255),
			tglPerpanjangan DATE NULL,
			mulaiPerpanjangan DATE NULL,
			sampaiPerpanjangan DATE NULL,
			penetapanSitaJaminan DATE NULL,
			pelaksanaanSitaJaminan DATE NULL,
			tglPemberitahuanPihak1 DATE NULL,
			tglPemberitahuanPihak2 DATE NULL,
			tglPemberitahuanPihak3 DATE NULL,
			keterangan TEXT NULL,
				PRIMARY KEY (IDPerkara)
		)ENGINE=InnoDB;";
		$this->patching->exe_script($sql);


		$sql = "DROP VIEW IF EXISTS viewputusanselakhususweb;";
		$this->patching->exe_script($sql);
		$sql = "DROP TABLE IF EXISTS putusanselakhususweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS viewmediatorweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE VIEW viewmediatorweb AS 
				SELECT
				        mediator.id                  AS IDMediator,
				        mediator.status_mediator     AS statusMediator,
				        mediator.hakim_id            AS IDHakim,
				        mediator.nip                 AS nip,
				        mediator.nama                AS nama,
				        mediator.nama_gelar          AS namaGelar,
				        mediator.profesi             AS profesi,
				        mediator.bersertifikat       AS bersertifikat,
				        mediator.no_sertifikasi      AS nomorSertifikasi,
				        mediator.tgl_sertifikasi     AS tglSertifikasi,
				        mediator.lembaga_sertifikasi AS lembagaSertifikasi,
				        mediator.keterangan          AS keterangan
				FROM mediator;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS mediatorweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS viewpihakintervensiweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE  VIEW viewpihakintervensiweb AS 
				SELECT
				  perkara_pihak3.id                      AS ID,
				  perkara_pihak3.perkara_id              AS IDPerkara,
				  perkara_pihak3.nama                    AS nama,
				  perkara_pihak3.jenis_intervensi_nama   AS jenisIntervensi,
				  perkara_pihak3.tanggal_izin_intervensi AS tglIzinIntervensi,
				  IF((perkara_pihak3.tergabung_ke_pihak = 1),'Penggugat',IF((perkara_pihak3.tergabung_ke_pihak = 2),'Tergugat',IF((perkara_pihak3.tergabung_ke_pihak = 3),'Sendiri',''))) AS tergabungKePihak,
				  perkara_pihak3.isi_petitum             AS petitum
				FROM perkara_pihak3
				ORDER BY perkara_pihak3.urutan;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS pihakintervensiweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE  pihakintervensiweb (
			ID BIGINT UNSIGNED NOT NULL,
			IDPerkara BIGINT UNSIGNED NOT NULL,
			nama VARCHAR(255) NULL,
			jenisIntervensi VARCHAR(20) NULL,
			tglIzinIntervensi DATE NULL,
			tergabungKePihak VARCHAR(25),
			petitum TEXT NULL,
			PRIMARY KEY (ID,IDPerkara),
				KEY indeks (IDPerkara)
		)ENGINE=InnoDB;";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS viewrekonvensiweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE  VIEW viewrekonvensiweb AS 
				SELECT
				  perkara_rekonvensi.perkara_id          AS IDPerkara,
				  perkara_rekonvensi.tanggal_pendaftaran AS tglPendaftaran,
				  perkara_rekonvensi.parapihak           AS parapihak,
				  perkara_rekonvensi.isi_petitum         AS petitum
				FROM perkara_rekonvensi;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS rekonvensiweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE  rekonvensiweb (
			IDPerkara BIGINT UNSIGNED NOT NULL,
			tglPendaftaran DATE NOT NULL, 
			parapihak VARCHAR(500) NOT NULL,
			petitum TEXT NOT NULL,
				PRIMARY KEY (IDPerkara)
		)ENGINE=InnoDB;";
		$this->patching->exe_script($sql);


		$sql = "DROP VIEW IF EXISTS viewbandingweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE VIEW viewbandingweb AS 
        SELECT
                b.id                               AS ID,
                b.perkara_id                       AS IDPerkara,
                (CASE
                  WHEN b.alur_perkara_id = 118 AND b.pihak_asal = 2 THEN 'ANAK BERHADAPAN DENGAN HUKUM'
                  WHEN p.jenis_perkara_id IN (64,98,242,346,347,248,312,349,350,352) THEN 'disamarkan'
                  ELSE b.pihak_nama
                  END) AS nama,
                b.status_pihak_id                  AS IDStatusPihak,
                CONCAT(IFNULL(b.status_pihak_text,''),' (',b.pihak_asal_text,')') AS statusPihak,
                (CASE
                  WHEN b.alur_perkara_id = 118 AND b.pihak_asal = 2 THEN 'ANAK BERHADAPAN DENGAN HUKUM'
                  WHEN p.jenis_perkara_id IN (64,98,242,346,347,248,312,349,350,352) THEN 'disamarkan'
                  ELSE b.pihak_nama
                  END)                      AS pihakNama,
                b.pihak_diwakili                   AS pihakDiwakili,
                b.pemohon_nama                     AS pemohonNama,
                b.permohonan_banding               AS tglPermohonan,
                b.pemberitahuan_permohonan_banding AS tglPemberitahuanPermohonan,
                b.penerimaan_memori_banding        AS tglPenerimaanMemori,
                b.penyerahan_memori_banding        AS tglPenyerahanMemori,
                b.penerimaan_kontra_banding        AS tglPenerimaanKontra,
                b.penyerahan_kontra_banding        AS tglPenyerahanKontra,
                b.pemberitahuan_inzage             AS tglPemberitahuanInzage,
                b.pelaksanaan_inzage               AS tglPelaksanaanInzage,
                b.pemberitahuan_putusan_banding    AS tglPemberitahuanPutusanBanding,
                b.tanggal_cabut                    AS tglCabut,
                b.keterangan                       AS keterangan
        FROM perkara_banding_detil AS b
        LEFT JOIN perkara AS p
        ON p.perkara_id = b.perkara_id;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS bandingweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE bandingweb (
				  ID BIGINT(20) UNSIGNED NOT NULL,
				  IDPerkara BIGINT(20) UNSIGNED NOT NULL,
				  nama TEXT,
				  IDStatusPihak TINYINT(4) DEFAULT NULL,
				  statusPihak VARCHAR(50) DEFAULT NULL,
				  pihakNama VARCHAR(500) DEFAULT NULL,
				  pihakDiwakili CHAR(1) DEFAULT 'T',
				  pemohonNama VARCHAR(500) DEFAULT NULL,
				  tglPermohonan DATE DEFAULT NULL,
				  tglPemberitahuanPermohonan DATE DEFAULT NULL,
				  tglPenerimaanMemori DATE DEFAULT NULL,
				  tglPenyerahanMemori DATE DEFAULT NULL,
				  tglPenerimaanKontra DATE DEFAULT NULL,
				  tglPenyerahanKontra DATE DEFAULT NULL,
				  tglPemberitahuanInzage DATE DEFAULT NULL,
				  tglPelaksanaanInzage DATE DEFAULT NULL,
				  tglPemberitahuanPutusanBanding DATE DEFAULT NULL,
				  tglCabut DATE DEFAULT NULL,
				  keterangan TEXT,
				  PRIMARY KEY (ID,IDPerkara)
				) ENGINE=InnoDB;";
		$this->patching->exe_script($sql);


		$sql = "DROP VIEW IF EXISTS viewbandingdetilweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE VIEW viewbandingdetilweb AS 
				SELECT
		        perkara_banding.perkara_id                               AS IDPerkara,
		        perkara_banding.nomor_perkara_banding                    AS noPerkarabanding,
		        perkara_banding.permohonan_banding                       AS tglPermohonanBanding,
		        perkara_banding.pemohon_banding                          AS pemohonBanding,
		        perkara_banding.pemberitahuan_permohonan_banding         AS tglPemberitahuanPermohonan,
		        perkara_banding.penerimaan_memori_banding                AS tglPenerimaanMemori,
		        perkara_banding.penyerahan_memori_banding                AS tglPenyerahanMemori,
		        perkara_banding.penerimaan_kontra_banding                AS tglPenerimaanKontra,
		        perkara_banding.penyerahan_kontra_banding                AS tglPenyerahanKontra,
		        perkara_banding.pemberitahuan_inzage_pembanding          AS tglPemberitahuanInzagePembanding,
		        perkara_banding.pemberitahuan_inzage_terbanding          AS tglPemberitahuanInzageTerbanding,
		        perkara_banding.pelaksanaan_inzage_pembanding            AS tglPelaksanaanInzagePembanding,
		        perkara_banding.pelaksanaan_inzage_terbanding            AS tglPelaksanaanInzageTerbanding,
		        perkara_banding.pengiriman_berkas_banding                AS tglPengirimanBerkas,
		        perkara_banding.nomor_surat_pengiriman_berkas_banding    AS nomorSuratPengiriman,
		        perkara_banding.penerimaan_kembali_berkas_banding        AS tglPenerimaanKembaliBerkas,
		        perkara_banding.hakim1_banding                           AS hakimPertama,
		        perkara_banding.hakim2_banding                           AS hakimKedua,
		        perkara_banding.hakim3_banding                           AS hakimKetiga,
		        perkara_banding.hakim4_banding                           AS hakimKeempat,
		        perkara_banding.hakim5_banding                           AS hakimKelima,
		        perkara_banding.panitera_pengganti_banding               AS paniteraPengganti,
		        perkara_banding.putusan_banding                          AS tglPutusan,
		        perkara_banding.nomor_putusan_banding                    AS noPutusanBanding,
		        perkara_banding.amar_putusan_banding                     AS amarPutusan,
		        perkara_banding.minutasi_banding                         AS tglMinutasi,
		        perkara_banding.pemberitahuan_putusan_banding_pembanding AS tglPemberitahuanPutusanPembanding,
		        perkara_banding.pemberitahuan_putusan_banding_terbanding AS tglPemberitahuanPutusanTerbanding,
		        perkara_banding.catatan_banding                          AS keterangan
				FROM perkara_banding;";
				$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS bandingdetilweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE  bandingdetilweb (
					IDPerkara BIGINT UNSIGNED NOT NULL,
					noPerkaraBanding VARCHAR(50) NULL,
					tglPermohonanBanding DATE NULL,
					pemohonBanding TEXT NULL,
					tglPemberitahuanPermohonan DATE NULL,
					tglPenerimaanMemori DATE NULL,
					tglPenyerahanMemori DATE NULL,
					tglPenerimaanKontra DATE NULL,
					tglPenyerahanKontra DATE NULL,
					tglPemberitahuanInzagePembanding DATE NULL,
					tglPemberitahuanInzageTerbanding DATE NULL,
					tglPelaksanaanInzagePembanding DATE NULL,
					tglPelaksanaanInzageTerbanding DATE NULL,
					tglPengirimanBerkas DATE NULL,
					nomorSuratPengiriman VARCHAR(100) NULL,
					tglPenerimaanKembaliBerkas DATE,
					hakimPertama VARCHAR(50) NULL,
					hakimKedua VARCHAR(50) NULL,
					hakimKetiga VARCHAR(50) NULL,
					hakimKeempat VARCHAR(50) NULL,
					hakimKelima VARCHAR(50) NULL,
					paniteraPengganti VARCHAR(50) NULL,
					tglPutusan DATE NULL,
					noPutusanBanding VARCHAR(50) NULL,
					amarPutusan TEXT NULL,
					tglMinutasi DATE NULL,
					tglPemberitahuanPutusanPembanding DATE NULL,
					tglPemberitahuanPutusanTerbanding DATE NULL,
					keterangan TEXT NULL,
					PRIMARY KEY (IDPerkara),
					KEY indeks (IDPerkara)
				)ENGINE=InnoDB;";
		$this->patching->exe_script($sql);



		$sql = "DROP VIEW IF EXISTS vieweksekusiweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE VIEW vieweksekusiweb AS 
				SELECT
				        perkara_eksekusi_detil.id                  AS ID,
				        perkara_eksekusi_detil.perkara_id          AS IDPerkara,
				        perkara_eksekusi_detil.pihak_nama          AS nama,
				        perkara_eksekusi_detil.status_pihak_id     AS IDStatusPihak,
				        CONCAT(perkara_eksekusi_detil.status_pihak_text,'(',perkara_eksekusi_detil.pihak_asal_text,')') AS statusPihak,
				        IF((perkara_eksekusi_detil.pihak_diwakili = 'Y'),perkara_eksekusi_detil.pemohon_nama,NULL) AS pihakDimohonkan,
				        perkara_eksekusi_detil.permohonan_eksekusi AS tglPemberitahuanPermohonan
				FROM perkara_eksekusi_detil;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS eksekusiweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE  eksekusiweb (
			ID BIGINT UNSIGNED NOT NULL,
			IDPerkara BIGINT UNSIGNED NOT NULL,
			nama TEXT NULL,
			IDStatusPihak TINYINT,
			statusPihak VARCHAR(50) NULL,
			pihakDimohonkan TEXT NULL,
			tglPemberitahuanPermohonan DATE,
			PRIMARY KEY (ID, IDPerkara)
		)ENGINE=InnoDB;";
		$this->patching->exe_script($sql);


		$sql = "DROP VIEW IF EXISTS vieweksekusidetilweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE VIEW vieweksekusidetilweb AS 
				SELECT
				        perkara_eksekusi.perkara_id                          AS IDPerkara,
				        perkara_eksekusi.alur_perkara_id                     AS IDAlurPerkara,
				        perkara_eksekusi.nomor_perkara_pn                    AS noPerkaraPN,
				        perkara_eksekusi.putusan_pn                          AS PutusanPN,
				        perkara_eksekusi.nomor_perkara_banding               AS noPerkaraBanding,
				        perkara_eksekusi.putusan_banding                     AS putusanBanding,
				        perkara_eksekusi.nomor_perkara_kasasi                AS noPerkaraKasasi,
				        perkara_eksekusi.putusan_kasasi                      AS putusanKasasi,
				        perkara_eksekusi.nomor_perkara_pk                    AS noPerkaraPK,
				        perkara_eksekusi.putusan_pk                          AS putusanPK,
				        perkara_eksekusi.eksekusi_putusan                    AS eksekusiPutusan,
				        perkara_eksekusi.eksekusi_nomor_perkara              AS eksekusiNomorPerkara,
				        perkara_eksekusi.eksekusi_amar_putusan               AS eksekusiAmarPutusan,
				        perkara_eksekusi.pihak_pemohon_eksekusi              AS pihakPemohonEksekusi,
				        perkara_eksekusi.permohonan_eksekusi                 AS permohonanEsekusi,
				        perkara_eksekusi.pemohon_eksekusi                    AS pemohonEksekusi,
				        perkara_eksekusi.para_pihak                          AS paraPihak,
				        perkara_eksekusi.penetapan_teguran_eksekusi          AS penetapanTeguranEksekusi,
				        perkara_eksekusi.nomor_penetapan_teguran_eksekusi    AS nomorPenetapanTeguranEksekusi,
				        perkara_eksekusi.pelaksanaan_teguran_eksekusi        AS pelaksanaanTeguranEksekusi,
				        perkara_eksekusi.penetapan_sita_eksekusi             AS penetapanSitaEksekusi,
				        perkara_eksekusi.nomor_penetapan_sita_eksekusi       AS nomorPenetapanSitaEksekusi,
				        perkara_eksekusi.pelaksanaan_sita_eksekusi           AS pelaksanaanSitaEksekusi,
				        perkara_eksekusi.jurusita_nama                       AS jurusitaNama,
				        perkara_eksekusi.penetapan_perintah_eksekusi_lelang  AS penetapanPerintahEksekusiLelang,
				        perkara_eksekusi.pelaksanaan_eksekusi_lelang         AS pelaksanaanEksekusiLelang,
				        perkara_eksekusi.penyerahan_hasil_lelang             AS penyerahanHasilLelang,
				        perkara_eksekusi.penetapan_perintah_eksekusi_rill    AS penetapanPerintahEksekusiRill,
				        perkara_eksekusi.pelaksanaan_eksekusi_rill           AS pelaksanaanEksekusiRill,
				        perkara_eksekusi.penetapan_noneksekusi               AS penetapanNoneksekusi,
				        perkara_eksekusi.diterima_permohonan                 AS diterimaPermohonan,
				        perkara_eksekusi.panggilan_parapihak                 AS panggilanParapihak,
				        perkara_eksekusi.penetapan_ketua                     AS penetapanKetua,
				        perkara_eksekusi.sk_objek_tidak_punya_kekuatan_hukum AS skObjekTidakPunyaKekuatanHukum,
				        perkara_eksekusi.surat_tergugat_objek_non_executable AS suratTergugatObjekNonExecutable,
				        perkara_eksekusi.panggilan_pihak_non_executable      AS panggilanPihakNonExecutable,
				        perkara_eksekusi.upaya_kesepakatan_kompensasi        AS upayaKesepakatanKompensasi,
				        perkara_eksekusi.penetapan_ketua_kompensasi          AS penetapanKetuaKompensasi,
				        perkara_eksekusi.upaya_hukum_kma                     AS upayaHukumKma,
				        perkara_eksekusi.penetapan_kma_kompensasi            AS penetapanKmaKompensasi,
				        perkara_eksekusi.uangpaksa_putusan_hakim             AS uangpaksaPutusanHakim,
				        perkara_eksekusi.uangpaksa_penetapan_ketua           AS uangpaksaPenetapanKetua,
				        perkara_eksekusi.surat_ketua_tergugat_uangpaksa      AS suratKetuaTergugatUangpaksa,
				        perkara_eksekusi.surat_peringatan_uangpaksa          AS suratPeringatanUangpaksa,
				        perkara_eksekusi.perintah_ketua_saksi_administratif  AS perintahKetuaSaksiAdministratif,
				        perkara_eksekusi.sanksi_administratif_dari_pejabat   AS sanksiAministratifDariPejabat,
				        perkara_eksekusi.pengumuman_ketua_panitera_js        AS pengumumanKetuaPaniteraJs,
				        perkara_eksekusi.pengumuman_media                    AS pengumumanMedia,
				        perkara_eksekusi.surat_presiden                      AS surat_Pesiden,
				        perkara_eksekusi.surat_lembaga_perwakilan_rakyat     AS suratLembagaPerwakilanRakyat,
				        perkara_eksekusi.alasan_eksekusi                     AS alasanEksekusi,
				        perkara_eksekusi.catatan_eksekusi                    AS catatanEksekusi,
				        perkara_eksekusi.prodeo_eksekusi                     AS prodeoEksekusi,
				        perkara_eksekusi.status_eksekusi_text                AS statusEksekusiText,
				        perkara.prodeo                                       AS prodeo,
				        perkara.tanggal_pendaftaran                          AS tglPendaftaran
				FROM (perkara_eksekusi
				         LEFT JOIN perkara
				           ON ((perkara_eksekusi.perkara_id = perkara.perkara_id)));";
		$this->patching->exe_script($sql);


		$sql = "DROP TABLE IF EXISTS eksekusidetilweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE eksekusidetilweb (
				  IDPerkara BIGINT(20) UNSIGNED NOT NULL,
				  IDAlurPerkara INT(11) UNSIGNED NOT NULL,
				  noPerkaraPN VARCHAR(50) NOT NULL,
				  PutusanPN DATE DEFAULT NULL,
				  noPerkaraBanding VARCHAR(50) DEFAULT NULL,
				  putusanBanding DATE DEFAULT NULL,
				  noPerkaraKasasi VARCHAR(50) DEFAULT NULL,
				  putusanKasasi DATE DEFAULT NULL,
				  noPerkaraPK VARCHAR(50) DEFAULT NULL,
				  putusanPK DATE DEFAULT NULL,
				  eksekusiPutusan INT(11) DEFAULT NULL,
				  eksekusiNomorPerkara VARCHAR(50) DEFAULT NULL,
				  eksekusiAmarPutusan TEXT,
				  pihakPemohonEksekusi INT(11) DEFAULT NULL,
				  permohonanEsekusi DATE DEFAULT NULL,
				  pemohonEksekusi VARCHAR(1000) DEFAULT NULL,
				  paraPihak VARCHAR(2000) DEFAULT NULL,
				  penetapanTeguranEksekusi DATE DEFAULT NULL,
				  nomorPenetapanTeguranEksekusi VARCHAR(50) DEFAULT NULL,
				  pelaksanaanTeguranEksekusi DATE DEFAULT NULL,
				  penetapanSitaEksekusi DATE DEFAULT NULL,
				  nomorPenetapanSitaEksekusi VARCHAR(50) DEFAULT NULL,
				  pelaksanaanSitaEksekusi DATE DEFAULT NULL,
				  jurusitaNama VARCHAR(500) DEFAULT NULL,
				  penetapanPerintahEksekusiLelang DATE DEFAULT NULL,
				  pelaksanaanEksekusiLelang DATE DEFAULT NULL,
				  penyerahanHasilLelang DATE DEFAULT NULL,
				  penetapanPerintahEksekusiRill DATE DEFAULT NULL,
				  pelaksanaanEksekusiRill DATE DEFAULT NULL,
				  penetapanNoneksekusi DATE DEFAULT NULL,
				  diterimaPermohonan DATE DEFAULT NULL,
				  panggilanParapihak DATE DEFAULT NULL,
				  penetapanKetua DATE DEFAULT NULL,
				  skObjekTidakPunyaKekuatanHukum DATE DEFAULT NULL,
				  suratTergugatObjekNonExecutable DATE DEFAULT NULL,
				  panggilanPihakNonExecutable DATE DEFAULT NULL,
				  upayaKesepakatanKompensasi DATE DEFAULT NULL,
				  penetapanKetuaKompensasi DATE DEFAULT NULL,
				  upayaHukumKma DATE DEFAULT NULL,
				  penetapanKmaKompensasi DATE DEFAULT NULL,
				  uangpaksaPutusanHakim BIGINT(20) DEFAULT NULL,
				  uangpaksaPenetapanKetua BIGINT(20) DEFAULT NULL,
				  suratKetuaTergugatUangpaksa DATE DEFAULT NULL,
				  suratPeringatanUangpaksa DATE DEFAULT NULL,
				  perintahKetuaSaksiAdministratif DATE DEFAULT NULL,
				  sanksiAministratifDariPejabat DATE DEFAULT NULL,
				  pengumumanKetuaPaniteraJs DATE DEFAULT NULL,
				  pengumumanMedia DATE DEFAULT NULL,
				  surat_Pesiden DATE DEFAULT NULL,
				  suratLembagaPerwakilanRakyat DATE DEFAULT NULL,
				  alasanEksekusi TEXT,
				  catatanEksekusi TEXT,
				  prodeoEksekusi TINYINT(1) DEFAULT NULL,
				  statusEksekusiText VARCHAR(100) DEFAULT NULL,
				  prodeo TINYINT(1) DEFAULT NULL,
				  tglPendaftaran DATE DEFAULT NULL,
				  PRIMARY KEY (IDPerkara)
				) ENGINE=InnoDB;";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS viewkasasiweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE VIEW viewkasasiweb AS 
SELECT
                k.id                           AS ID,
                k.perkara_id                   AS IDPerkara,
                (CASE
                  WHEN p.jenis_perkara_id IN (248,312) AND k.pihak_asal = 2 THEN 'ANAK BERHADAPAN DENGAN HUKUM'
                  WHEN p.jenis_perkara_id IN (64,98,242,346,347,349,350,352) THEN 'disamarkan'
                  ELSE k.pihak_nama
                  END) AS nama,
                k.status_pihak_id              AS IDStatusPihak,
                CONCAT(IFNULL(k.status_pihak_text,''),' (',k.pihak_asal_text,')') AS statusPihak,
                (CASE
                  WHEN p.jenis_perkara_id IN (248,312) AND k.pihak_asal = 2 THEN 'ANAK BERHADAPAN DENGAN HUKUM'
                  WHEN p.jenis_perkara_id IN (64,98,242,346,347,349,350,352) THEN 'disamarkan'
                  ELSE k.pihak_nama
                  END)                  AS pihak_nama,
                k.pihak_diwakili               AS pihak_diwakili,
                k.pemohon_nama                 AS pemohon_nama,
                k.permohonan_kasasi            AS tglPermohonan,
                k.pemberitahuan_kasasi         AS tglPemberitahuanPermohonan,
                k.penerimaan_memori_kasasi     AS tglPenerimaanMemori,
                k.penyerahan_memori_kasasi     AS tglPenyerahanMemori,
                k.penerimaan_kontra_kasasi     AS tglPenerimaanKontra,
                k.penyerahan_kontra_kasasi     AS tglPenyerahanKontra,
                k.pemberitahuan_inzage_kasasi  AS tglPemberitahuanInzage,
                k.pelaksanaan_inzage_kasasi    AS tglPelaksanaanInzage,
                k.pemberitahuan_putusan_kasasi AS tglPemberitahuanPutusanKasasi,
                k.tanggal_cabut                AS tglCabut
        FROM perkara_kasasi_detil AS k
        LEFT JOIN perkara AS p
        ON p.perkara_id = k.perkara_id;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS kasasiweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE  kasasiweb (
			ID BIGINT UNSIGNED NOT NULL,
			IDPerkara BIGINT UNSIGNED NOT NULL,
			nama TEXT NULL,
			IDStatusPihak TINYINT,
			statusPihak VARCHAR(50) NULL,
			pihakNama VARCHAR(500) NULL,
			pihakDiwakili CHAR(1) DEFAULT 'T',
			pemohonNama VARCHAR(500) NULL,
			tglPermohonan DATE,
			tglPemberitahuanPermohonan DATE NULL,
			tglPenerimaanMemori DATE NULL,
			tglPenyerahanMemori DATE NULL,
			tglPenerimaanKontra DATE NULL,
			tglPenyerahanKontra DATE NULL,
			tglPemberitahuanInzage DATE NULL,
			tglPelaksanaanInzage DATE NULL,
			tglPemberitahuanPutusanKasasi DATE NULL,
			tglCabut DATE NULL,
			PRIMARY KEY (ID, IDPerkara)
		)ENGINE=InnoDB;";
		$this->patching->exe_script($sql);


		$sql = "DROP VIEW IF EXISTS viewkasasidetilweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE VIEW viewkasasidetilweb AS 
				SELECT
				        perkara_kasasi.perkara_id                           AS IDPerkara,
				        perkara_kasasi.nomor_perkara_kasasi                 AS noPerkaraKasasi,
				        perkara_kasasi.permohonan_kasasi                    AS tglPermohonankasasi,
				        perkara_kasasi.pemohon_kasasi                       AS pemohonkasasi,
				        perkara_kasasi.pengiriman_berkas_kasasi             AS tglPengirimanBerkas,
				        perkara_kasasi.nomor_surat_pengiriman_berkas_kasasi AS noSuratPengiriman,
				        perkara_kasasi.penerimaan_berkas_kasasi             AS tglPenerimaanKembaliBerkas,
				        perkara_kasasi.hakim1_kasasi                        AS hakimPertama,
				        perkara_kasasi.hakim2_kasasi                        AS hakimKedua,
				        perkara_kasasi.hakim3_kasasi                        AS hakimKetiga,
				        perkara_kasasi.hakim4_kasasi                        AS hakimKeempat,
				        perkara_kasasi.hakim5_kasasi                        AS hakimKelima,
				        perkara_kasasi.panitera_pengganti_kasasi            AS paniteraPengganti,
				        perkara_kasasi.putusan_kasasi                       AS tglPutusan,
				        perkara_kasasi.nomor_putusan_kasasi                 AS noPutusankasasi,
				        perkara_kasasi.amar_putusan_kasasi                  AS amarPutusan,
				        perkara_kasasi.minutasi_kasasi                      AS tglMinutasi,
				        perkara_kasasi.tanggal_berita_putusan_kasasi        AS tglBeritaPutusan,
				        perkara_kasasi.nama_media_berita_putusan_kasasi     AS namaMediaBerita,
				        perkara_kasasi.tanggal_surat_kabar_putusan_kasasi   AS tglSuratKabar,
				        perkara_kasasi.nama_surat_kabar_putusan_kasasi      AS namaSuratKabar,
				        perkara_kasasi.prodeo_kasasi                        AS prodeo,
				        perkara_kasasi.catatan_putusan_kasasi               AS keterangan
				FROM perkara_kasasi;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS kasasidetilweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE  kasasidetilweb (
			IDPerkara BIGINT UNSIGNED NOT NULL,
			noPerkaraKasasi VARCHAR(50),
			tglPermohonanKasasi DATE NULL,
			pemohonKasasi TEXT NULL,
			tglPengirimanBerkas DATE NULL,
			noSuratPengiriman VARCHAR(50) NULL,
			tglPenerimaanKembaliBerkas DATE,
			hakimPertama VARCHAR(50) NULL,
			hakimKedua VARCHAR(50) NULL,
			hakimKetiga VARCHAR(50) NULL,
			hakimKeempat VARCHAR(50) NULL,
			hakimKelima VARCHAR(50) NULL,
			paniteraPengganti VARCHAR(50) NULL,
			tglPutusan DATE NULL,
			noPutusanKasasi VARCHAR(50) NULL,
			amarPutusan TEXT NULL,
			tglMinutasi DATE NULL,
			tglBeritaPutusan DATE,
			namaMediaBerita VARCHAR(50),
			tglSuratKabar DATE,
			namaSuratKabar VARCHAR(50),
			prodeo TINYINT,
			keterangan TEXT NULL,
			PRIMARY KEY (IDPerkara)
		)ENGINE=InnoDB;";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS viewpkweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE  VIEW viewpkweb AS 
        SELECT
           pk.id AS ID,
           pk.perkara_id AS IDPerkara,
          (CASE
                  WHEN p.jenis_perkara_id IN (248,312) AND pk.pihak_asal = 2 THEN 'ANAK BERHADAPAN DENGAN HUKUM'
                  WHEN p.jenis_perkara_id IN (64,98,242,346,347,349,350,352) THEN 'disamarkan'
                  ELSE pk.pihak_nama
                  END) AS nama,
           pk.status_pihak_id AS IDStatusPihak,
           CONCAT(IFNULL(pk.status_pihak_text,''),' (',pk.pihak_asal_text,')') AS statusPihak,
            (CASE
                  WHEN p.jenis_perkara_id IN (248,312) AND pk.pihak_asal = 2 THEN 'ANAK BERHADAPAN DENGAN HUKUM'
                  WHEN p.jenis_perkara_id IN (64,98,242,346,347,349,350,352) THEN 'disamarkan'
                  ELSE pk.pihak_nama
                  END) AS pihak_nama,
           pk.pihak_diwakili AS pihak_diwakili,
           pk.pemohon_nama AS pemohon_nama,
           pk.permohonan_pk AS tglPermohonan,
           pk.pemberitahuan_pk AS tglPemberitahuanPermohonan,
           pk.penerimaan_memori_pk AS tglPenerimaanMemori,
           pk.penyerahan_memori_pk AS tglPenyerahanMemori,
           pk.penerimaan_kontra_pk AS tglPenerimaanKontra,
           pk.penyerahan_kontra_pk AS tglPenyerahanKontra,
           pk.pemberitahuan_inzage_pk AS tglPemberitahuanInzage,
           pk.pelaksanaan_inzage_pk AS tglPelaksanaanInzage,
           pk.pemberitahuan_putusan_pk AS tglPemberitahuanPutusan,
           pk.tanggal_cabut AS tglCabut
        FROM perkara_pk_detil AS pk
        LEFT JOIN perkara AS p
        ON p.perkara_id = pk.perkara_id;;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS pkweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE  pkweb (
			ID BIGINT UNSIGNED NOT NULL,
			IDPerkara BIGINT UNSIGNED NOT NULL,
			nama TEXT NULL,
			IDStatusPihak TINYINT,
			statusPihak VARCHAR(50) NULL,
			pihakNama VARCHAR(500) NULL,
			pihakDiwakili CHAR(1) DEFAULT 'T',
			pemohonNama VARCHAR(500) NULL,
			tglPermohonan DATE,
			tglPemberitahuanPermohonan DATE NULL,
			tglPenerimaanMemori DATE NULL,
			tglPenyerahanMemori DATE NULL,
			tglPenerimaanKontra DATE NULL,
			tglPenyerahanKontra DATE NULL,
			tglPemberitahuanInzage DATE NULL,
			tglPelaksanaanInzage DATE NULL,
			tglPemberitahuanPutusan DATE NULL,
			tglCabut DATE NULL,
			PRIMARY KEY (ID, IDPerkara)
		)ENGINE=InnoDB;";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS viewpkdetilweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE  VIEW viewpkdetilweb AS 
				SELECT
				   perkara_pk.perkara_id AS IDPerkara,
				   perkara_pk.nomor_perkara_pk AS noPerkarapk,
				   perkara_pk.permohonan_pk AS tglPermohonan,
				   perkara_pk.pemohon_pk AS pemohon,
				   perkara_pk.pemberitahuan_pk AS tglPemberitahuanPermohonan,
				   perkara_pk.penerimaan_memori_pk AS tglPenerimaanMemori,
				   perkara_pk.penyerahan_memori_pk AS tglPenyerahanMemori,
				   perkara_pk.penerimaan_kontra_pk AS tglPenerimaanKontra,
				   perkara_pk.penyerahan_kontra_pk AS tglPenyerahanKontra,
				   perkara_pk.pemberitahuan_inzage_pemohon_pk AS tglPemberitahuanInzagePihak1,
				   perkara_pk.pemberitahuan_inzage_termohon_pk AS tglPemberitahuanInzagePihak2,
				   perkara_pk.pelaksanaan_inzage_pemohon_pk AS tglPelaksanaanInzagePihak1,
				   perkara_pk.pelaksanaan_inzage_termohon_pk AS tglPelaksanaanInzagePihak2,
				   perkara_pk.pengiriman_berkas_pk AS tglPengirimanBerkas,
				   perkara_pk.nomor_surat_pengiriman_berkas_pk AS nomorSuratPengiriman,
				   perkara_pk.penerimaan_berkas_pk AS tglPenerimaanKembaliBerkas,
				   perkara_pk.majelis_hakim_pk AS majelisHakim,
				   perkara_pk.panitera_pengganti_pk AS paniteraPengganti,
				   perkara_pk.putusan_pk AS tglPutusan,
				   perkara_pk.nomor_putusan_pk AS noPutusanPK,
				   perkara_pk.amar_putusan_pk AS amarPutusan,
				   perkara_pk.minutasi_pk AS tglMinutasi,
				   perkara_pk.pemberitahuan_putusan_pk_pihak1 AS tglPemberitahuanPutusanPihak1,
				   perkara_pk.pemberitahuan_putusan_pk_pihak2 AS tglPemberitahuanPutusanPihak2
				FROM perkara_pk;";
		$this->patching->exe_script($sql);


		$sql = "DROP TABLE IF EXISTS pkdetilweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE  pkdetilweb (
			IDPerkara BIGINT UNSIGNED NOT NULL,
			noPerkaraPK VARCHAR(50) NULL,
			tglPermohonan DATE NULL,
			pemohon TEXT NULL,
			tglPemberitahuanPermohonan DATE NULL,
			tglPenerimaanMemori DATE NULL,
			tglPenyerahanMemori DATE NULL,
			tglPenerimaanKontra DATE NULL,
			tglPenyerahankontra DATE NULL,
			tglPemberitahuanInzagePihak1 DATE NULL,
			tglPemberitahuanInzagePihak2 DATE NULL,
			tglPelaksanaanInzagePihak1 DATE NULL,
			tglPelaksanaanInzageTihak2 DATE NULL,
			tglPengirimanBerkas DATE NULL,
			noSuratPengiriman VARCHAR(50) NULL,
			tglPenerimaanBerkas DATE,
			majelisHakimPK VARCHAR(500) NULL,
			paniteraPengganti VARCHAR(50) NULL,
			tglPutusan DATE NULL,
			noPutusanPK VARCHAR(50) NULL,
			amarPutusan TEXT NULL,
			tglMinutasi DATE NULL,
			tglPemberitahuanPutusanPihak1 DATE NULL,
			tglPemberitahuanPutusanPihak2 DATE NULL,
			PRIMARY KEY (IDPerkara)
		)ENGINE=InnoDB;";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS viewgrasiweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE VIEW viewgrasiweb AS 
				SELECT
				        perkara_grasi.id                                      AS ID,
				        perkara_grasi.perkara_id                              AS IDPerkara,
				        perkara_grasi.alur_perkara_id                         AS IDAlurPerkara,
				        perkara_grasi.permohonan_grasi                        AS tglPermohonan,
				        perkara_grasi.terdakwa_nama                           AS namaTerdakwa,
				        perkara_grasi.pemohon_nama                            AS namaPemohon,
				        perkara_grasi.tanggal_pertimbangan_hakim              AS tglPertimbanganMA,
				        perkara_grasi.pengiriman_pertimbangan_hakim_grasi     AS tglPengirimanBerkas,
				        perkara_grasi.tanggal_penerimaan_kembali_berkas_grasi AS tglPenerimaanBerkas,
				        perkara_grasi.tanggal_putusan_grasi                   AS tglPutusan,
				        perkara_grasi.nomor_putusan_grasi                     AS noPutusan,
				        perkara_grasi.amar_putusan_grasi                      AS amarPutusan,
				        perkara_grasi.pemberitahuan_putusan_grasi             AS tglPemberitahuanPutusan,
				        perkara_grasi.pemberitahuan_tembusan_grasi            AS tglPemberitahuanTembusan,
				        perkara_grasi.catatan_putusan_grasi                   AS keterangan
				FROM perkara_grasi;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS grasiweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE grasiweb (
			ID BIGINT UNSIGNED NOT NULL,
			IDPerkara BIGINT UNSIGNED NOT NULL,
			IDAlurPerkara SMALLINT UNSIGNED NOT NULL,
			tglPermohonan DATE DEFAULT NULL,
			namaTerdakwa TEXT DEFAULT NULL,
			namaPemohon TEXT DEFAULT NULL,
			tglPertimbanganMA DATE DEFAULT NULL,
			tglPengirimanBerkas DATE DEFAULT NULL,
			tglPenerimaanBerkas DATE DEFAULT NULL,
			tglPutusan DATE DEFAULT NULL,
			noPutusan VARCHAR(50),
			amarPutusan TEXT,
			tglPemberitahuanPutusan DATE DEFAULT NULL,
			tglPemberitahuanTembusan DATE DEFAULT NULL,
			keterangan TEXT,
			PRIMARY KEY (ID,IDPerkara)
		)ENGINE=InnoDB;";
		$this->patching->exe_script($sql);


		$sql = "DROP VIEW IF EXISTS viewperkarapenuntutanweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE VIEW viewperkarapenuntutanweb AS 
            SELECT
            pp.perkara_id         AS IDPerkara,
            pp.tanggal_penuntutan AS tglPenuntutan,
            IF(p.alur_perkara_id = 118,'Disamarkan', pp.isi_penuntutan)     AS isiTuntutan
            FROM perkara_penuntutan AS pp
            LEFT JOIN perkara AS p
            ON pp.perkara_id = p.perkara_id;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS perkarapenuntutanweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE perkarapenuntutanweb(
			IDPerkara BIGINT UNSIGNED NOT NULL,
			tglPenuntutan DATE DEFAULT NULL,
			isiTuntutan TEXT,
			PRIMARY KEY (IDPerkara)
			)ENGINE=InnoDB;";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS viewactiopaulianaweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE VIEW viewactiopaulianaweb AS 
				SELECT
				        perkara_id                AS perkara_id,
				        tanggal_pendaftaran_actio AS tanggal_pendaftaran_actio,
				        catatan_pendaftaran       AS catatan_pendaftaran
				FROM perkara_actio_pauliana;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS actiopaulianaweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE actiopaulianaweb (
			IDPerkara BIGINT UNSIGNED NOT NULL,
			tglPendaftaranAction DATE DEFAULT NULL,
			keterangan VARCHAR(255),
			PRIMARY KEY (IDPerkara)
		)ENGINE=InnoDB;";
		$this->patching->exe_script($sql);


		$sql = "DROP TABLE IF EXISTS perkarakeberatanweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE perkarakeberatanweb (
			IDPerkara bigint(20) unsigned NOT NULL,
			tglPendaftaran date,
			pemohon varchar(500),
			tglPenetapanMajelis date,
			majelisHakim varchar(500),
			tglPenetapanPP date,
			paniteraPengganti varchar(500),
			tglPenetapanJurusita date,
			jurusita varchar(500),
			tglPutusan date,
			statusPutusan varchar(50),
			amar text,
			jenisPemberitahuan varchar(10),
			tglPemberitahuan date,
			tglPemberitahuanPihakPertama date,
			tglPemberitahuanPihakKedua date,
			penerimaanMemori date,
			penyerahanMemori date,
			penerimaanKontra date,
			penyerahanKontra date,
			PRIMARY KEY (IDPerkara)
		) ENGINE=InnoDB;";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS viewperkarakeberatanweb;";
		$this->patching->exe_script($sql);

		$sql = "CREATE  VIEW viewperkarakeberatanweb AS 
				SELECT
				  perkara_keberatan.perkara_id                             AS IDperkara,
				  perkara_keberatan.tanggal_pendaftaran_keberatan          AS tglPendaftaranKeberatan,
				  perkara_keberatan.pemohon_keberatan                      AS pemohonKeberatan,
				  perkara_keberatan.penetapan_majelis_hakim                AS penetapanMajelisHakim,
				  IF((ISNULL(perkara_keberatan.putusan_keberatan) AND (perkara_keberatan.penetapan_majelis_hakim IS NOT NULL)),'Belum Dapat Ditampilkan',perkara_keberatan.majelis_hakim_nama) AS namaMajelis,
				  perkara_keberatan.penetapan_panitera_pengganti           AS penetapanPaniter,
				  IF((ISNULL(perkara_keberatan.putusan_keberatan) AND (perkara_keberatan.penetapan_panitera_pengganti IS NOT NULL)),'Belum Dapat Ditampilkan',perkara_keberatan.panitera_pengganti_text) AS namaPanitera,
				  perkara_keberatan.penetapan_jurusita                     AS penetapanJurusita,
				  IF((ISNULL(perkara_keberatan.putusan_keberatan) AND (perkara_keberatan.penetapan_jurusita IS NOT NULL)),'Belum Dapat Ditampilkan',perkara_keberatan.jurusita_text) AS namaJurusita,
				  perkara_keberatan.putusan_keberatan                      AS putusanKeberatan,
				  perkara_keberatan.status_putusan_keberatan_text          AS statusPutusanKeberatan,
				  perkara_keberatan.amar_putusan_keberatan                 AS amarPutusanKeberatan,
				  perkara_keberatan.pemberitahuan_putusan                  AS pemberitahuanPutusan,
				  perkara_keberatan.pemberitahuan_putusan_keberatan_pihak1 AS tglPemberitahuanPutusanPihak1,
				  perkara_keberatan.pemberitahuan_putusan_keberatan_pihak2 AS tglPemberitahuanPutusanPihak2,
				  perkara_keberatan.penerimaan_memori                      AS penerimaanMemori,
				  perkara_keberatan.penyerahan_memori                      AS penyerahanMemori,
				  perkara_keberatan.penerimaan_kontra_memori               AS penerimaanKontra,
				  perkara_keberatan.penyerahan_kontra_memori               AS penyerahanKontra,
				  perkara_keberatan.catatan_putusan_keberatan              AS catatanPutusanKeberatan
				FROM perkara_keberatan;";
		$this->patching->exe_script($sql);


		$sql = "DROP VIEW IF EXISTS viewdiversiweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE VIEW viewdiversiweb AS 
				SELECT
				        perkara_diversi.id                                AS id,
				        perkara_diversi.perkara_id                        AS perkara_id,
				        perkara_diversi.no_reg_penyidik                   AS no_reg_penyidik,
				        perkara_diversi.no_reg_penuntut_umum              AS no_reg_penuntut_umum,
				        perkara_diversi.tgl_penetapan_musyawarah          AS tgl_penetapan_musyawarah,
				        perkara_diversi.tgl_musyawarah                    AS tgl_musyawarah,
				        perkara_diversi.tgl_kesepakatan_diversi           AS tgl_kesepakatan_diversi,
				        perkara_diversi.tgl_penetapan_kesepakatan_diversi AS tgl_penetapan_kesepakatan_diversi,
				        perkara_diversi.no_penetapan_kesepakatan          AS no_penetapan_kesepakatan,
				        perkara_diversi.tgl_lap_pembimbing_masyarakat     AS tgl_lap_pembimbing_masyarakat,
				        IF((perkara_diversi.hasil_diversi = 1),'Berhasil','Tidak Berhasil') AS hasil_diversi,
				        perkara_diversi.dibuka_kembali                    AS dibuka_kembali,
				        perkara_diversi.no_dibuka_kembali                 AS no_dibuka_kembali,
				        perkara_diversi.tgl_dibuka_kembali                AS tgl_dibuka_kembali
				FROM perkara_diversi;";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS viewperkaraprosesweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE  VIEW viewperkaraprosesweb AS 
				SELECT
				  perkara_proses.perkara_id   AS IDPerkara,
				  perkara_proses.tahapan_id   AS IDTahapan,
				  perkara_proses.tahapan_nama AS tahapan,
				  perkara_proses.proses_id    AS IDProses,
				  perkara_proses.proses_nama  AS proses,
				  perkara_proses.tanggal      AS tanggal
				FROM perkara_proses;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS perkaraprosesweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE  perkaraprosesweb (
			IDPerkara BIGINT UNSIGNED NOT NULL,
			IDTahapan SMALLINT,
			tahapan VARCHAR(25),
			IDProses SMALLINT,
			proses VARCHAR(200),
			tanggal DATE,
			PRIMARY KEY (IDPerkara,IDTahapan,IDProses)
		)ENGINE=InnoDB;";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS viewperkaraeksekusihtweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE  VIEW viewperkaraeksekusihtweb AS 
				SELECT
				  perkara_eksekusi_ht.ht_id                              AS IDHT,
				  perkara_eksekusi_ht.nomor_perkara_pn                   AS nomorperkaraPN,
				  perkara_eksekusi_ht.putusan_pn                         AS putusanPn,
				  perkara_eksekusi_ht.nomor_perkara_banding              AS nomorPerkaraBanding,
				  perkara_eksekusi_ht.putusan_banding                    AS putusanBanding,
				  perkara_eksekusi_ht.nomor_perkara_kasasi               AS nomorPerkaraKasasi,
				  perkara_eksekusi_ht.putusan_kasasi                     AS putusanKasasi,
				  perkara_eksekusi_ht.nomor_perkara_pk                   AS nomorPerkaraPK,
				  perkara_eksekusi_ht.putusan_pk                         AS putusanPK,
				  perkara_eksekusi_ht.eksekusi_putusan                   AS eksekusiPutusan,
				  perkara_eksekusi_ht.eksekusi_nomor_perkara             AS eksekusiNomorPerkara,
				  perkara_eksekusi_ht.eksekusi_amar_putusan              AS eksekusiAmarPutusan,
				  perkara_eksekusi_ht.pihak_pemohon_eksekusi             AS pihakPemohonEksekusi,
				  perkara_eksekusi_ht.permohonan_eksekusi                AS permohonanEksekusi,
				  perkara_eksekusi_ht.pemohon_eksekusi                   AS pemohonEksekusi,
				  perkara_eksekusi_ht.para_pihak                         AS paraPihak,
				  perkara_eksekusi_ht.penetapan_teguran_eksekusi         AS PenetapanTeguranEksekusi,
				  perkara_eksekusi_ht.nomor_penetapan_teguran_eksekusi   AS nomorPenetapanTeguranEksekusi,
				  perkara_eksekusi_ht.pelaksanaan_teguran_eksekusi       AS pelaksanaanTeguranEksekusi,
				  perkara_eksekusi_ht.penetapan_sita_eksekusi            AS penetapanSitaEKsekusi,
				  perkara_eksekusi_ht.nomor_penetapan_sita_eksekusi      AS nomorPenetapanSitaEksekusi,
				  perkara_eksekusi_ht.pelaksanaan_sita_eksekusi          AS pelaksanaanSitaEksekusi,
				  perkara_eksekusi_ht.jurusita_nama                      AS jurusitaNama,
				  perkara_eksekusi_ht.penetapan_perintah_eksekusi_lelang AS penetapanPerintahEksekusiLelang,
				  perkara_eksekusi_ht.pelaksanaan_eksekusi_lelang        AS pelaksanaanEksekusiLelang,
				  perkara_eksekusi_ht.penyerahan_hasil_lelang            AS penyerahanHasilLelang,
				  perkara_eksekusi_ht.penetapan_perintah_eksekusi_rill   AS penetapanPerintahEksekusiRill,
				  perkara_eksekusi_ht.pelaksanaan_eksekusi_rill          AS pelaksanaanEksekusiRill,
				  perkara_eksekusi_ht.penetapan_noneksekusi              AS penetapanNonEksekusi,
				  perkara_eksekusi_ht.alasan_eksekusi                    AS alasanEksekusi,
				  perkara_eksekusi_ht.catatan_eksekusi                   AS catatanEksekusi,
				  perkara_eksekusi_ht.prodeo_eksekusi                    AS prodeoEksekusi,
				  perkara_eksekusi_ht.status_eksekusi_text               AS statusEksekusiText,
				  perkara_eksekusi_ht.jenis_ht_text                      AS jenisHTText,
				  perkara_eksekusi_ht.tgl_sertifikat                     AS tglSertifikat,
				  perkara_eksekusi_ht.no_sertifikat                      AS noSertifikat
				FROM perkara_eksekusi_ht;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTs perkaraeksekusihtweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE perkaraeksekusihtweb (
				IDHT bigint(20) unsigned NOT NULL,
				nomorperkaraPN varchar(50) DEFAULT NULL,
				putusanPn date DEFAULT NULL,
				nomorPerkaraBanding varchar(50) DEFAULT NULL,
				putusanBanding date DEFAULT NULL,
				nomorPerkaraKasasi varchar(50) DEFAULT NULL,
				putusanKasasi date DEFAULT NULL,
				nomorPerkaraPK varchar(50) DEFAULT NULL,
				putusanPK date DEFAULT NULL,
				eksekusiPutusan int(11) DEFAULT NULL,
				eksekusiNomorPerkara varchar(50) DEFAULT NULL,
				eksekusiAmarPutusan text,
				pihakPemohonEksekusi int(11) DEFAULT NULL,
				permohonanEksekusi date DEFAULT NULL,
				pemohonEksekusi varchar(1000) DEFAULT NULL,
				paraPihak varchar(2000) DEFAULT NULL,
				PenetapanTeguranEksekusi date DEFAULT NULL,
				nomorPenetapanTeguranEksekusi varchar(50) DEFAULT NULL,
				pelaksanaanTeguranEksekusi date DEFAULT NULL,
				penetapanSitaEKsekusi date DEFAULT NULL,
				nomorPenetapanSitaEksekusi varchar(50) DEFAULT NULL,
				pelaksanaanSitaEksekusi date DEFAULT NULL,
				jurusitaNama varchar(500) DEFAULT NULL,
				penetapanPerintahEksekusiLelang date DEFAULT NULL,
				pelaksanaanEksekusiLelang date DEFAULT NULL,
				penyerahanHasilLelang date DEFAULT NULL,
				penetapanPerintahEksekusiRill date DEFAULT NULL,
				pelaksanaanEksekusiRill date DEFAULT NULL,
				penetapanNonEksekusi date DEFAULT NULL,
				alasanEksekusi text,
				catatanEksekusi text,
				prodeoEksekusi tinyint(1) DEFAULT NULL,
				statusEksekusiText varchar(100) DEFAULT NULL,
				jenisHTText varchar(250) DEFAULT NULL,
				tglSertifikat date DEFAULT NULL,
				noSertifikat varchar(250) DEFAULT NULL,
				PRIMARY KEY (IDHT)
		) ENGINE=InnoDB;";
		$this->patching->exe_script($sql);

		$sql = "DROP VIEW IF EXISTS viewputusanpemberitahuanweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE  VIEW viewputusanpemberitahuanweb AS 
				SELECT
				  put.perkara_id                    AS IDPerkara,
				  put.putusan_akhir                 AS PutusanAkhir,
				  put.pihak                         AS pihakke,
				  put.pihak_id                      AS IDPihak,
				  (CASE WHEN (put.pihak = 1) THEN p1.urutan WHEN (put.pihak = 2) THEN p2.urutan WHEN (put.pihak = 3) THEN p3.urutan WHEN (put.pihak = 4) THEN p4.urutan ELSE 1 END) AS urutan,
				  (CASE WHEN ((perkara.alur_perkara_id = 1) AND (perkara.jenis_perkara_id = 64)) THEN 'Disamarkan' WHEN ((perkara.alur_perkara_id = 1) AND (perkara.jenis_perkara_id = 137)) THEN 'Disamarkan' WHEN (perkara.pihak_dipublikasikan = 'T') THEN 'Disamarkan' WHEN ((put.pihak = 1) AND (perkara.jenis_perkara_id <> 64) AND (perkara.jenis_perkara_id <> 137) AND (perkara.pihak_dipublikasikan = 'Y')) THEN p1.nama WHEN ((put.pihak = 2) AND (perkara.alur_perkara_id = 118)) THEN 'ANAK' WHEN ((put.pihak = 2) AND (perkara.alur_perkara_id <> 118) AND (perkara.pihak_dipublikasikan = 'Y')) THEN p2.nama WHEN ((put.pihak = 3) AND (perkara.pihak_dipublikasikan = 'Y')) THEN p3.nama WHEN ((put.pihak = 4) AND (perkara.pihak_dipublikasikan = 'Y')) THEN p4.nama ELSE 'Disamarkan' END) AS nama,
				  put.tanggal_pemberitahuan_putusan AS tglPemberitahuan,
				  put.tanggal_menerima_putusan      AS tglMenerimaPutusan,
				  put.tanggal_kirim_salinan_putusan AS tglKirimSalinan
				FROM (((((perkara_putusan_pemberitahuan_putusan put
				       LEFT JOIN perkara
				         ON ((perkara.perkara_id = put.perkara_id)))
				      LEFT JOIN perkara_pihak1 p1
				        ON ((p1.id = put.pihak_id)))
				     LEFT JOIN perkara_pihak2 p2
				       ON ((p2.id = put.pihak_id)))
				    LEFT JOIN perkara_pihak3 p3
				      ON ((p3.id = put.pihak_id)))
				   LEFT JOIN perkara_pihak4 p4
				     ON ((p4.id = put.pihak_id)));";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS putusanpemberitahuanweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE putusanpemberitahuanweb (
					IDPerkara BIGINT(20) UNSIGNED NOT NULL,
					PutusanAkhir TINYINT(4) NOT NULL DEFAULT 2,
					pihakke TINYINT(4) NOT NULL,
					IDPihak BIGINT(20) NOT NULL,
					urutan SMALLINT(6) NOT NULL,
					nama TEXT,
					tglPemberitahuan DATE DEFAULT NULL,
					tglMenerimaPutusan DATE DEFAULT NULL,
					tglKirimSalinan DATE DEFAULT NULL,
					PRIMARY KEY (IDPerkara,PutusanAkhir,pihakke,IDPihak)
				) ENGINE=InnoDB;";
		$this->patching->exe_script($sql);


		$sql = "DROP VIEW IF EXISTS viewbarangbuktiweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE VIEW viewbarangbuktiweb AS 
				SELECT
				        perkara_barang_bukti.id                   AS IDBarangBukti,
				        perkara_barang_bukti.perkara_id           AS IDPerkara,
				        perkara_barang_bukti.nomor_perkara        AS noPerkara,
				        perkara_barang_bukti.tanggal_penerimaan   AS tglPenerimaan,
				        perkara_barang_bukti.jenis_barang_bukti   AS jenisBB,
				        perkara_barang_bukti.tempat_penyimpanan   AS tempatSimpan,
				        perkara_barang_bukti.tempat_penyerahan    AS tempatPenyerahan,
				        perkara_barang_bukti.nama_penerima        AS penerima,
				        perkara_barang_bukti.tanggal_penyerahan   AS tglPenyerahan,
				        perkara_barang_bukti.catatan_barang_bukti AS Catatan
				FROM perkara_barang_bukti;";
		$this->patching->exe_script($sql);

		$sql = "DROP TABLE IF EXISTS barangbuktiweb;";
		$this->patching->exe_script($sql);
		$sql = "CREATE TABLE barangbuktiweb (
			IDBarangBukti BIGINT (20) NOT NULL AUTO_INCREMENT,
			IDPerkara BIGINT (20),
			noPerkara VARCHAR(450),
			tglPenerimaan DATE,
			jenisBB TEXT,
			tempatSimpan VARCHAR(150),
			tempatPenyerahan VARCHAR(150),
			penerima VARCHAR(1500),
			tglPenyerahan DATE ,
			Catatan TEXT,
			PRIMARY KEY (IDBarangBukti)
		)ENGINE=InnoDB; ";
		$this->patching->exe_script($sql);

		$this->patching->exe_script("DROP TABLE IF EXISTS statusputusanweb;");
		$this->patching->exe_script("CREATE TABLE statusputusanweb (
										id TINYINT(2) NOT NULL,
										IDJenisPerkara TINYINT(2) NOT NULL,
										nama VARCHAR(100) DEFAULT NULL,
										jenis_pengadilan TINYINT(2) NOT NULL,
										PRIMARY KEY (id,jenis_pengadilan)
									) ENGINE=InnoDB;");

		$this->patching->exe_script("DROP VIEW IF EXISTS viewstatusputusanweb;");
		$this->patching->exe_script("CREATE VIEW viewstatusputusanweb AS SELECT
										status_putusan.id AS id,
										status_putusan.jenis_perkara_id AS IDJenisPerkara,
										status_putusan.nama AS nama,
										sys_config.value AS jenis_pengadilan
									FROM status_putusan 
									LEFT JOIN sys_config 
									ON status_putusan.jenis_pengadilan = sys_config.value
									WHERE sys_config.id = 83 AND status_putusan.aktif = 'Y';");

		$this->patching->exe_script("DROP TABLE IF EXISTS prosesweb;");
		$this->patching->exe_script("CREATE TABLE prosesweb (
									  ID SMALLINT(6) NOT NULL,
									  idalurperkara SMALLINT(3) DEFAULT NULL,
									  nama VARCHAR(100) DEFAULT NULL,
									  PRIMARY KEY (ID)
									) ENGINE=MYISAM;");

		$this->patching->exe_script("DROP VIEW IF EXISTS viewprosesweb;");
		$this->patching->exe_script("CREATE VIEW viewprosesweb AS SELECT id, tahapan_id, nama FROM proses;");

		$this->patching->exe_script("DROP VIEW IF EXISTS viewpenetapanpersiapanweb;");
		$this->patching->exe_script("CREATE VIEW viewpenetapanpersiapanweb AS 
									SELECT
									        perkara_persiapan.perkara_id                  AS IDPerkara,
									        perkara_persiapan.tanggal_penetapan_persiapan AS tglPenetapan,
									        perkara_persiapan.petitum                     AS petitum
									FROM perkara_persiapan;");

		$this->patching->exe_script("DROP TABLE IF EXISTS penetapanpersiapanweb;");
		$this->patching->exe_script("CREATE TABLE penetapanpersiapanweb (
									  IDPerkara BIGINT(20) UNSIGNED NOT NULL,
									  tglPenetapan DATE NOT NULL,
									  petitum TEXT NOT NULL,
									  PRIMARY KEY (IDPerkara)
									) ENGINE=InnoDB;;");



		$this->patching->exe_script("DROP TABLE IF EXISTS penetapanpersiapanprosesweb;");
		$this->patching->exe_script("CREATE TABLE penetapanpersiapanprosesweb (
									  ID BIGINT(20) UNSIGNED NOT NULL,
									  IDPerkara BIGINT(20) UNSIGNED NOT NULL,
									  urutan SMALLINT(2) NOT NULL,
									  tglMusyawarah DATE NOT NULL,
									  agenda VARCHAR(100) DEFAULT NULL,
									  waktu TIME DEFAULT NULL,
									  keterangan VARCHAR(255) DEFAULT NULL,
									  PRIMARY KEY (ID,IDPerkara)
									) ENGINE=InnoDB;");


		$this->patching->exe_script("DROP VIEW IF EXISTS viewpenetapandismissalweb;");
		$this->patching->exe_script("CREATE VIEW viewpenetapandismissalweb AS 
                            SELECT
                                    perkara_dismissal.perkara_id              AS IDPerkara,
                                    perkara_dismissal.tanggal_penetapan       AS tglPenetapan,
                                    perkara_dismissal.amar                    AS amar,
                                    perkara_dismissal.hasil                   AS hasil,
                                    perkara_dismissal.pemberitahuan_penggugat AS pemberitahuanPenggugat,
                                    perkara_dismissal.pemberitahuan_tergugat  AS pemberitahuanTergugat
                            FROM perkara_dismissal;");

		$this->patching->exe_script("DROP TABLE IF EXISTS penetapandismissalweb;");
		$this->patching->exe_script("CREATE TABLE penetapandismissalweb (
								IDPerkara BIGINT(20) UNSIGNED NOT NULL,
								tglPenetapan DATE NOT NULL,
								amar TEXT,
								hasil CHAR(1) DEFAULT NULL,
								pemberitahuanPenggugat DATE DEFAULT NULL,
								pemberitahuanTergugat DATE DEFAULT NULL,
								PRIMARY KEY (IDPerkara)
							) ENGINE=InnoDB;");

		$this->patching->exe_script("DROP VIEW IF EXISTS viewpanggilandismissalweb;");
		$this->patching->exe_script("CREATE VIEW viewpanggilandismissalweb AS 
                            SELECT
                                    perkara_panggilan_dismissal.id                AS ID,
                                    perkara_panggilan_dismissal.perkara_id        AS IDPerkara,
                                    perkara_panggilan_dismissal.tanggal_panggilan AS tglPanggilan,
                                    perkara_panggilan_dismissal.status_text       AS statusText
                            FROM perkara_panggilan_dismissal;");

		$this->patching->exe_script("DROP TABLE IF EXISTS panggilandismissalweb;");
		$this->patching->exe_script("CREATE TABLE panggilandismissalweb (
									  ID BIGINT(20) UNSIGNED NOT NULL,
									  IDPerkara BIGINT(20) UNSIGNED NOT NULL,
									  tglPanggilan DATE NOT NULL,
									  statusText VARCHAR(30) DEFAULT NULL,
									  PRIMARY KEY (ID,IDPerkara)
									) ENGINE=InnoDB;");



		$this->patching->exe_script("DROP VIEW IF EXISTS viewalurperkaraweb;");
		$this->patching->exe_script("CREATE VIEW viewalurperkaraweb AS 
		                            SELECT
		                                    alur_perkara.id   AS id,
		                                    alur_perkara.nama AS nama
		                            FROM (alur_perkara
		                                     LEFT JOIN sys_config
		                                       ON ((alur_perkara.jenis_pengadilan = sys_config.value)))
		                            WHERE ((sys_config.id = 83)
		                                   AND (alur_perkara.aktif = 'Y'));");
		
		$this->patching->exe_script("DROP TABLE IF EXISTS alurperkaraweb;");
		$this->patching->exe_script("CREATE TABLE alurperkaraweb (
										id tinyint(4) NOT NULL DEFAULT '0',
										nama varchar(50) DEFAULT NULL,
									PRIMARY KEY (id)
									) ENGINE=InnoDB;");

		$this->patching->exe_script("DROP VIEW IF EXISTS viewstatuspihakweb;");
		$this->patching->exe_script("CREATE VIEW  viewstatuspihakweb AS 
									SELECT 
										alur_perkara_id AS IDAlurPerkara,
										tahapan_id AS IDTahapan,
										pihak_ke AS PihakKe,
										status_pihak.nama AS nama,
										status_pihak.aktif AS aktif
									FROM status_pihak
									LEFT JOIN alur_perkara
										ON status_pihak.alur_perkara_id = alur_perkara.id
									LEFT JOIN sys_config
										ON alur_perkara.jenis_pengadilan = sys_config.value 
									WHERE sys_config.id = 83 AND alur_perkara.aktif = 'Y';");

		$this->patching->exe_script("DROP TABLE IF EXISTS statuspihakweb;");
		$this->patching->exe_script("CREATE TABLE statuspihakweb (
									  IDAlurPerkara SMALLINT(11) unsigned NOT NULL,
									  IDTahapan int(11) unsigned NOT NULL,
									  PihakKe tinyint(1) unsigned NOT NULL,
									  nama varchar(50) NOT NULL,
									  aktif char(1) NOT NULL DEFAULT 'Y',
									  PRIMARY KEY (IDAlurPerkara,IDTahapan,PihakKe)
									) ENGINE=InnoDB;");


		$this->patching->exe_script("DROP VIEW IF EXISTS viewjenisperkaraweb;");
		$this->patching->exe_script("CREATE VIEW viewjenisperkaraweb AS 
		                                SELECT
		                                        jenis_perkara.id   AS id,
		                                        alur_perkara.id    AS idalurperkara,
		                                        jenis_perkara.nama AS nama
		                                FROM (((jenis_perkara
		                                           LEFT JOIN jenis_alur_perkara
		                                             ON ((jenis_perkara.id = jenis_alur_perkara.jenis_perkara_id)))
		                                          LEFT JOIN alur_perkara
		                                            ON ((jenis_alur_perkara.alur_perkara_id = alur_perkara.id)))
		                                         LEFT JOIN sys_config
		                                           ON ((alur_perkara.jenis_pengadilan = sys_config.value)))
		                                WHERE ((sys_config.id = 83)
		                                       AND (alur_perkara.aktif = 'Y'))
		                                ORDER BY jenis_perkara.nama;");
		
		$this->patching->exe_script("DROP TABLE IF EXISTS jenisperkaraweb;");
		$this->patching->exe_script("CREATE TABLE jenisperkaraweb (
									  id SMALLINT(3) NOT NULL DEFAULT '0',
									  idalurperkara SMALLINT(3) NOT NULL DEFAULT '0',
									  nama VARCHAR(150) DEFAULT NULL,
									  PRIMARY KEY (id,idalurperkara)
									) ENGINE=INNODB;");


		$this->patching->exe_script("DROP VIEW IF EXISTS viewpenetapanpersiapanprosesweb;");
		$this->patching->exe_script("CREATE VIEW viewpenetapanpersiapanprosesweb AS 
                            SELECT
                                    perkara_persiapan_proses.id                 AS ID,
                                    perkara_persiapan_proses.perkara_id         AS IDPerkara,
                                    perkara_persiapan_proses.urutan             AS urutan,
                                    perkara_persiapan_proses.tanggal_musyawarah AS tglMusyawarah,
                                    perkara_persiapan_proses.agenda_musyawarah  AS agenda,
                                    perkara_persiapan_proses.waktu_musyawarah   AS waktu,
                                    perkara_persiapan_proses.keterangan         AS keterangan
                            FROM perkara_persiapan_proses;");

		$this->patching->exe_script("DROP TABLE IF EXISTS prosesalurperkaraweb;");
		$this->patching->exe_script("CREATE TABLE prosesalurperkaraweb (
									ID TINYINT(2) NOT NULL,
									IDTahapan TINYINT(2) NOT NULL,
									IDAlurPerkara SMALLINT(3) NOT NULL,
									IDProses SMALLINT(3) NOT NULL,
									nama VARCHAR(100) DEFAULT NULL,
									PRIMARY KEY (IDTahapan,IDAlurPerkara,IDProses)
								) ENGINE=InnoDB;");

		$this->patching->exe_script("DROP VIEW IF EXISTS viewprosesalurperkaraweb;");
		$this->patching->exe_script("CREATE VIEW viewprosesalurperkaraweb AS SELECT id, tahapan_id, alur_perkara_id, proses_id, proses_nama FROM proses_alur_perkara;");

		$this->patching->exe_script("DROP VIEW IF EXISTS viewdelegasikeluarweb;");
		$this->patching->exe_script("CREATE VIEW viewdelegasikeluarweb AS 
		                            SELECT
		                                    delegasi_keluar.id                  AS ID,
		                                    delegasi_keluar.perkara_id           AS IDPerkara,
		                                    delegasi_keluar.nomor_perkara       AS noPerkara,
		                                    delegasi_keluar.id_pn_asal          AS idPNAsal,
		                                    delegasi_keluar.kode_satker_asal    AS kodeSatkerAsal,
		                                    delegasi_keluar.pn_asal_text        AS pnAsalText,
		                                    delegasi_keluar.id_pn_tujuan        AS IDPNTujuan,
		                                    delegasi_keluar.kode_satker_tujuan  AS kodeSatkerTujuan,
		                                    delegasi_keluar.pn_tujuan_text      AS pnTujuanText,
		                                    delegasi_keluar.tgl_delegasi        AS tglDelegasi,
		                                    delegasi_keluar.id_jenis_delegasi   AS IDJenisDelegasi,
		                                    delegasi_keluar.jenis_delegasi_text AS jenisDelegasiText,
		                                    delegasi_keluar.tgl_surat           AS tglSurat,
		                                    delegasi_keluar.tgl_pengiriman      AS tglPengiriman,
		                                    delegasi_keluar.nomor_surat         AS noSurat
		                            FROM delegasi_keluar;");

		$this->patching->exe_script("DROP VIEW IF EXISTS viewdelegasimasukweb;");
		$this->patching->exe_script("CREATE VIEW viewdelegasimasukweb AS 
		                            SELECT
		                                    delegasi_masuk.id                  AS ID,
		                                    delegasi_masuk.perkara_id           AS IDPerkara,
		                                    delegasi_masuk.nomor_perkara       AS noPerkara,
		                                    delegasi_masuk.id_pn_asal          AS idPNAsal,
		                                    delegasi_masuk.kode_satker_asal    AS kodeSatkerAsal,
		                                    delegasi_masuk.pn_asal_text        AS pnAsalText,
		                                    delegasi_masuk.id_pn_tujuan        AS IDPNTujuan,
		                                    delegasi_masuk.kode_satker_tujuan  AS kodeSatkerTujuan,
		                                    delegasi_masuk.pn_tujuan_text      AS pnTujuanText,
		                                    delegasi_masuk.tgl_delegasi        AS tglDelegasi,
		                                    delegasi_masuk.id_jenis_delegasi   AS IDJenisDelegasi,
		                                    delegasi_masuk.jenis_delegasi_text AS jenisDelegasiText,
		                                    delegasi_masuk.tgl_surat           AS tglSurat,
		                                    delegasi_masuk.tgl_pengiriman      AS tglPengiriman,
		                                    delegasi_masuk.nomor_surat         AS noSurat
		                            FROM delegasi_masuk;");

			$this->patching->exe_script("DROP VIEW IF EXISTS viewdelegasiproseskeluarweb;");
			$this->patching->exe_script("CREATE VIEW viewdelegasiproseskeluarweb AS 
			                            SELECT
			                                    delegasi_proses_keluar.delegasi_id                   AS IDDelegasi,
			                                    delegasi_proses_keluar.tgl_surat_diterima           AS tglSuratDiterima,
			                                    delegasi_proses_keluar.perkara_id                    AS IDPerkara,
			                                    delegasi_proses_keluar.jurusita_id                   AS IDJurusita,
			                                    delegasi_proses_keluar.jurusita_nama                AS jurusitaNama,
			                                    delegasi_proses_keluar.id_pn_asal                   AS idPNAsal,
			                                    delegasi_proses_keluar.pn_asal_text                 AS pnAsalText,
			                                    delegasi_proses_keluar.kode_satker_asal             AS kodeSatkerAsal,
			                                    delegasi_proses_keluar.id_pn_tujuan                 AS idPNTujuan,
			                                    delegasi_proses_keluar.pn_tujuan_text               AS pnTujuanText,
			                                    delegasi_proses_keluar.kode_satker_tujuan           AS kodeSatkertTujuan,
			                                    delegasi_proses_keluar.tgl_relaas                   AS tglRelaas,
			                                    delegasi_proses_keluar.nomor_relaas                 AS nomorRelaas,
			                                    delegasi_proses_keluar.tgl_pengiriman_relaas        AS tglPengirimanRelaas,
			                                    delegasi_proses_keluar.nomor_surat_pengantar_relaas AS nomorSuratPengantarRelaas,
			                                    delegasi_proses_keluar.id_status_delegasi           AS idStatusDeleasgi,
			                                    delegasi_proses_keluar.status_delegasi              AS statusDelegasi,
			                                    delegasi_proses_keluar.catatan                      AS catatan
			                            FROM delegasi_proses_keluar;");

			$this->patching->exe_script("DROP VIEW IF EXISTS viewdelegasiprosesmasukweb;");
			$this->patching->exe_script("CREATE VIEW viewdelegasiprosesmasukweb AS 
			                            SELECT
			                                    delegasi_proses_masuk.delegasi_id                   AS IDDelegasi,
			                                    delegasi_proses_masuk.tgl_surat_diterima           AS tglSuratDiterima,
			                                    delegasi_proses_masuk.perkara_id                    AS IDPerkara,
			                                    delegasi_proses_masuk.jurusita_id                   AS IDJurusita,
			                                    delegasi_proses_masuk.jurusita_nama                AS jurusitaNama,
			                                    delegasi_proses_masuk.id_pn_asal                   AS idPNAsal,
			                                    delegasi_proses_masuk.pn_asal_text                 AS pnAsalText,
			                                    delegasi_proses_masuk.kode_satker_asal             AS kodeSatkerAsal,
			                                    delegasi_proses_masuk.id_pn_tujuan                 AS idPNTujuan,
			                                    delegasi_proses_masuk.pn_tujuan_text               AS pnTujuanText,
			                                    delegasi_proses_masuk.kode_satker_tujuan           AS kodeSatkertTujuan,
			                                    delegasi_proses_masuk.tgl_relaas                   AS tglRelaas,
			                                    delegasi_proses_masuk.nomor_relaas                 AS nomorRelaas,
			                                    delegasi_proses_masuk.tgl_pengiriman_relaas        AS tglPengirimanRelaas,
			                                    delegasi_proses_masuk.nomor_surat_pengantar_relaas AS nomorSuratPengantarRelaas,
			                                    delegasi_proses_masuk.id_status_delegasi           AS idStatusDeleasgi,
			                                    delegasi_proses_masuk.status_delegasi              AS statusDelegasi,
			                                    delegasi_proses_masuk.catatan                      AS catatan
			                            FROM delegasi_proses_masuk;");

		$sql = "REPLACE INTO delegasimasukweb SELECT * FROM viewdelegasimasukweb;";
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO delegasikeluarweb SELECT * FROM viewdelegasikeluarweb;";
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO delegasiprosesmasukweb SELECT * FROM viewdelegasiprosesmasukweb;";
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO delegasiproseskeluarweb SELECT * FROM viewdelegasiproseskeluarweb;";
		$this->patching->exe_script($sql);

		$sql = "REPLACE INTO dataumumweb SELECT * FROM viewdataumumweb;";
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO pihakweb SELECT * FROM viewpihakweb;";
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO pengacaraweb SELECT * FROM viewpengacaraweb;";
		$this->patching->exe_script($sql);
		
		#$sql = "REPLACE INTO hakimweb SELECT * FROM viewhakimweb;";
		#$this->patching->exe_script($sql);
		
		//$sql = "REPLACE INTO ppweb SELECT * FROM viewppweb;";
		//$this->patching->exe_script($sql);
		//$sql = "REPLACE INTO jurusitaweb SELECT * FROM viewjurusitaweb;";
		//$this->patching->exe_script($sql);
		
		$sql = "REPLACE INTO mediasiweb SELECT * FROM viewmediasiweb;";
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO jadwalsidangweb SELECT * FROM viewjadwalsidangweb;";
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO perkarabiayaweb SELECT * FROM viewperkarabiayaweb ORDER BY idperkara,tgltransaksi ASC;";
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO verzetweb SELECT * FROM viewverzetweb;";
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO penahananweb SELECT * FROM viewpenahananweb;";
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO putusanselaweb SELECT * FROM viewputusanselaweb;";
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO pihakintervensiweb SELECT * FROM viewpihakintervensiweb;";
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO bandingweb SELECT * FROM viewbandingweb;";
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO bandingdetilweb SELECT * FROM viewbandingdetilweb;";
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO diversiweb SELECT * FROM diversiweb;";
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO eksekusiweb SELECT * FROM vieweksekusiweb;";
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO eksekusidetilweb SELECT * FROM vieweksekusidetilweb;";   
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO kasasiweb SELECT * FROM viewkasasiweb;";
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO kasasidetilweb SELECT * FROM viewkasasidetilweb;";
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO pkweb SELECT * FROM viewpkweb;";
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO pkdetilweb SELECT * FROM viewpkdetilweb;";
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO grasiweb SELECT * FROM viewgrasiweb;";
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO perkarapenuntutanweb SELECT * FROM viewperkarapenuntutanweb;"; 
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO actiopaulianaweb SELECT * FROM viewactiopaulianaweb;";
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO perkaraprosesweb SELECT * FROM viewperkaraprosesweb;";
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO perkarakeberatanweb SELECT * FROM viewperkarakeberatanweb;";
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO perkaraeksekusihtweb SELECT * FROM viewperkaraeksekusihtweb;";
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO putusanpemberitahuanweb SELECT * FROM viewputusanpemberitahuanweb;";
		$this->patching->exe_script($sql);
		
		$sql = "REPLACE INTO barangbuktiweb SELECT * FROM viewbarangbuktiweb;";
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO perkaraputusanweb SELECT * FROM viewperkaraputusanweb;";
		$this->patching->exe_script($sql);
		$sql = "REPLACE INTO perkaraputusanterdakwa SELECT * FROM viewperkaraputusanterdakwa;";

		$sql = "REPLACE INTO rekonvensiweb SELECT * FROM viewrekonvensiweb;";
		$this->patching->exe_script($sql);
		
		$sql = "DROP PROCEDURE IF EXISTS syncDataUmum;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS InsertDataUmumWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS UpdateDataUmumWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS DeleteDataUmumWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP PROCEDURE IF EXISTS syncPengacaraweb;";
		$this->patching->exe_script($sql);


		$sql = "DROP PROCEDURE IF EXISTS syncPihakweb;";
		$this->patching->exe_script($sql);


		$sql = "DROP PROCEDURE IF EXISTS syncHakimweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS InsertHakimweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS UpdateHakimweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS DelHakimweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP PROCEDURE IF EXISTS syncPPweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS InsertPPweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS UpdatePPweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS DelPPweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP PROCEDURE IF EXISTS syncJurusitaweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS InsertJurusitaweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS UpdateJurusitaweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS DelJurusitaweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP PROCEDURE IF EXISTS syncMediasiweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS InsertMediasiweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS UpdateMediasiweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS DelMediasiweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP PROCEDURE IF EXISTS syncJadwalSidangWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS InsertJadwalSidangWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS UpdateJadwalSidangWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS DelJadwalSidangWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP PROCEDURE IF EXISTS syncVerzetWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS InsertVerzetWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS UpdateVerzetWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS DelVerzetWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP PROCEDURE IF EXISTS syncPenahananWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS InsertPenahananWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS UpdatePenahananWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS DelPenahananWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP PROCEDURE IF EXISTS syncPutusanSelaWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS InsertPutusanSelaWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS UpdatePutusanSelaWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS DelPutusanSelaWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP PROCEDURE IF EXISTS syncPihakIntervensiWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS InsertPihakIntervensiWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS UpdatePihakIntervensiWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS DelPihakIntervensiWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP PROCEDURE IF EXISTS syncBandingWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS InsertBandingWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS UpdateBandingWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS DelBandingWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP PROCEDURE IF EXISTS syncBandingDetilWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS InsertBandingDetilWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS UpdateBandingDetilWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS DelBandingDetilWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP PROCEDURE IF EXISTS syncEksekusiWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS InsertEksekusiWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS UpdateEksekusiWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS DelEksekusiWeb;";
		$this->patching->exe_script($sql);
		
		$sql = "DROP PROCEDURE IF EXISTS syncEksekusiDetilWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS InsertEksekusiDetilWeb;";
		$this->patching->exe_script($sql);
		
		$sql = "DROP TRIGGER IF EXISTS UpdateEksekusiDetilWeb;";
		$this->patching->exe_script($sql);
		
		$sql = "DROP TRIGGER IF EXISTS DelEksekusiDetilWeb;";
		$this->patching->exe_script($sql);
		
		$sql = "DROP PROCEDURE IF EXISTS syncKasasiWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS InsertKasasiWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS UpdateKasasiWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS DelKasasiWeb;";
		$this->patching->exe_script($sql);
		
		$sql = "DROP PROCEDURE IF EXISTS syncKasasiDetilWeb;";
		$this->patching->exe_script($sql);
		
		$sql = "DROP TRIGGER IF EXISTS InsertKasasiDetilWeb;";
		$this->patching->exe_script($sql);
		
		$sql = "DROP TRIGGER IF EXISTS UpdateKasasiDetilWeb;";
		$this->patching->exe_script($sql);
		
		$sql = "DROP TRIGGER IF EXISTS DelKasasiDetilWeb;";
		$this->patching->exe_script($sql);
		
		$sql = "DROP PROCEDURE IF EXISTS syncPKWeb;";
		$this->patching->exe_script($sql);
		
		$sql = "DROP TRIGGER IF EXISTS InsertPKWeb;";
		$this->patching->exe_script($sql);
		
		$sql = "DROP TRIGGER IF EXISTS UpdatePKWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS DelPKWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP PROCEDURE IF EXISTS syncPKDetilWeb;";
		$this->patching->exe_script($sql);
		
		$sql = "DROP TRIGGER IF EXISTS InsertPKDetilWeb;";
		$this->patching->exe_script($sql);
		
		$sql = "DROP TRIGGER IF EXISTS UpdatePKDetilWeb;";
		$this->patching->exe_script($sql);
		
		$sql = "DROP TRIGGER IF EXISTS DelPKDetilWeb;";
		$this->patching->exe_script($sql);
		
		$sql = "DROP PROCEDURE IF EXISTS syncGrasiWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS InsertGrasiWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS UpdateGrasiWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS DelGrasiWeb;";
		$this->patching->exe_script($sql);
		
		$sql = "DROP PROCEDURE IF EXISTS syncPerkaraPenuntutanWeb;";
		$this->patching->exe_script($sql);
		
		$sql = "DROP TRIGGER IF EXISTS InsertPerkaraPenuntutanWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS UpdatePerkaraPenuntutanWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS DelPerkaraPenuntutanWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP PROCEDURE IF EXISTS syncActioPaulianaWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS InsertActioPaulianaWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS UpdateActioPaulianaWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS DelActioPaulianaWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP PROCEDURE IF EXISTS syncPerkaraProsesWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS InsertPerkaraProsesWeb;";
		$this->patching->exe_script($sql);

		
		$this->patching->exe_script('DROP PROCEDURE IF EXISTS syncHartaPailitWeb;');
		$this->patching->exe_script('DROP PROCEDURE IF EXISTS syncPutusanSelaKhususWeb;');
		$this->patching->exe_script('DROP PROCEDURE IF EXISTS syncSidangPertamaweb;');
		$this->patching->exe_script('DROP TRIGGER IF EXISTS DelHartaPailitWeb;');
		$this->patching->exe_script('DROP TRIGGER IF EXISTS DelSidangPertamaweb;');
		$this->patching->exe_script('DROP TRIGGER IF EXISTS InsertHartaPailitWeb;');
		$this->patching->exe_script('DROP TRIGGER IF EXISTS InsertSidangPertamaweb;');
		$this->patching->exe_script('DROP TRIGGER IF EXISTS UpdateHartaPailitWeb;');
		$this->patching->exe_script('DROP TRIGGER IF EXISTS UpdateSidangPertamaweb;');

		$sql = "DROP TRIGGER IF EXISTS UpdatePerkaraProsesWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS DelPerkaraProsesWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP PROCEDURE IF EXISTS syncPerkaraBiayaWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS InsertPerkaraBiayaWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS UpdatePerkaraBiayaWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS DelPerkaraBiayaWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP PROCEDURE IF EXISTS syncKeberatanWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS InsertKeberatanWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS UpdateKeberatanWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS DelKeberatanWeb;";
		$this->patching->exe_script($sql);


		$this->patching->exe_script("DROP VIEW IF EXISTS v_menus;");

		$sql = "DROP PROCEDURE IF EXISTS syncPerkaraEksekusihtweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS InsertPerkaraEksekusihtWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS UpdatePerkaraEksekusihtWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS DelPerkaraEksekusihtWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP PROCEDURE IF EXISTS syncDiversiWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS InsertDiversiWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS UpdateDiversiWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS DelDiversiWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP PROCEDURE IF EXISTS syncPutusanPemberitahuanWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS InsertPutusanPemberitahuanWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS UpdatePutusanPemberitahuanWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS DelPutusanPemberitahuanWeb;";
		$this->patching->exe_script($sql);

		$sql = "DROP PROCEDURE IF EXISTS syncbarangbuktiweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS Insertbarangbuktiweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS Updatebarangbuktiweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS Delbarangbuktiweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP PROCEDURE IF EXISTS syncPutusanweb;";
		$this->patching->exe_script($sql);
		
		$sql = "DROP TRIGGER IF EXISTS InsertPutusanweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS UpdatePutusanweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS DelPutusanweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP PROCEDURE IF EXISTS syncPutusanTerdakwaweb;";
		$this->patching->exe_script($sql);
		
		$sql = "DROP TRIGGER IF EXISTS InsertPutusanTerdakwaweb;";
		$this->patching->exe_script($sql);

		$sql = "DROP TRIGGER IF EXISTS UpdatePutusanTerdakwaweb;";
		$this->patching->exe_script($sql);


		$sql = "DROP TRIGGER IF EXISTS DelPutusanTerdakwaweb;";
		$this->patching->exe_script($sql);

		$this->patching->exe_script("DROP TABLE IF EXISTS antrian");
		$this->patching->exe_script("CREATE TABLE antrian (
					  id int(11) unsigned NOT NULL AUTO_INCREMENT,
					  nomor_antrian int(11) NOT NULL,
					  tanggal_sidang date NOT NULL,
					  ruang_id tinyint(11) DEFAULT NULL,
					  perkara_id bigint(11) DEFAULT NULL,
					  status tinyint(11) DEFAULT NULL,
					  urutan tinyint(4) DEFAULT NULL,
					  PRIMARY KEY (id)
					) ENGINE=InnoDB;");

		$this->patching->exe_script("DROP TABLE IF EXISTS arsip");
		$this->patching->exe_script("CREATE TABLE arsip (
					id bigint(11) unsigned NOT NULL AUTO_INCREMENT,
					no_ruang varchar(50) DEFAULT NULL,
					no_lemari char(5) DEFAULT NULL,
					no_rak char(5) DEFAULT NULL,
					no_berkas char(5) DEFAULT NULL,
					nomor_arsip varchar(100) DEFAULT NULL,
					perkara_id bigint(11) DEFAULT NULL,
					nomor_perkara varchar(50) DEFAULT NULL,
					tanggal_masuk_arsip date DEFAULT NULL,
					nama_penerima varchar(50) DEFAULT NULL,
					nama_penyerah varchar(50) DEFAULT NULL,
					lengkap char(1) NOT NULL DEFAULT 'Y',
					status tinyint(1) DEFAULT NULL,
					keterangan varchar(255) DEFAULT NULL,
					diinput_oleh varchar(30) DEFAULT NULL,
					diinput_tanggal datetime DEFAULT NULL,
					diperbaharui_oleh varchar(30) DEFAULT NULL,
					diperbaharui_tanggal datetime DEFAULT NULL,
					PRIMARY KEY (id)
				) ENGINE=InnoDB;");

		$this->patching->exe_script("DROP TABLE IF EXISTS arsip_pinjam");
		$this->patching->exe_script("CREATE TABLE arsip_pinjam (
				id int(11) unsigned NOT NULL AUTO_INCREMENT,
				arsip_id bigint(11) DEFAULT NULL,
				tanggal_pinjam date DEFAULT NULL,
				batas_waktu int(11) DEFAULT NULL,
				tanggal_kembali date DEFAULT NULL,
				petugas_peminjam varchar(50) DEFAULT NULL,
				petugas_penerima varchar(50) DEFAULT NULL,
				keterangan varchar(255) DEFAULT NULL,
				diinput_oleh varchar(30) DEFAULT NULL,
				diinput_tanggal datetime DEFAULT NULL,
				diperbaharui_oleh varchar(30) DEFAULT NULL,
				diperbaharui_tanggal datetime DEFAULT NULL,
				PRIMARY KEY (id)
			) ENGINE=InnoDB;");

		$this->patching->exe_script('DROP VIEW IF EXISTS v_staff;');
		$this->patching->exe_script("CREATE view v_staff
				AS SELECT 
					concat('C-',hakim.id) AS id,
					hakim.nip,
					hakim.nama_gelar,
					hakim.aktif
				FROM hakim_pn hakim
				UNION ALL
				SELECT 
					concat('D-',pp.id) AS id,
					pp.nip,
					pp.nama_gelar,
					pp.aktif
				FROM panitera_pn pp
				UNION ALL
				SELECT 
					concat('E-',js.id) AS id,
					js.nip,
					js.nama_gelar,
					js.aktif
				FROM jurusita js;");
		
		$this->patching->exe_script('DROP TABLE IF EXISTS faktor_perceraian;');
		$this->patching->exe_script("CREATE TABLE faktor_perceraian (
				id int(11) unsigned NOT NULL,
				nama varchar(100) DEFAULT NULL,
				aktif char(1) DEFAULT 'Y',
				diedit_oleh varchar(30) DEFAULT NULL,
				diedit_tanggal datetime DEFAULT NULL,
				diinput_oleh varchar(30) DEFAULT NULL,
				diinput_tanggal datetime DEFAULT NULL,
				diperbaharui_oleh varchar(30) DEFAULT NULL,
				diperbaharui_tanggal datetime DEFAULT NULL,
				PRIMARY KEY (id)
			) ENGINE=MyISAM;");

		$this->patching->exe_script("REPLACE INTO faktor_perceraian (id,nama,aktif) VALUES 
				(1,'Zina','Y'),
				(2,'Mabuk','Y'),
				(3,'Madat','Y'),
				(4,'Judi','Y'),
				(5,'Meninggalkan Salah Satu Pihak','Y'),
				(6,'Dihukum Penjara','Y'),
				(7,'Kekerasan Dalam Rumah Tangga','Y'),
				(8,'Cacat Badan','Y'),
				(9,'Peselisihan dan Pertengkaran Terus Menerus','Y'),
				(10,'Kawin Paksa','Y'),
				(11,'Murtad','Y'),
				(12,'Ekonomi','Y'),
				(13,'Poligami','Y'),
				(14,'Lain-Lain','T'),
				(15,'Poligami Tidak Sehat','T'),
				(16,'Krisis Akhlak','T'),
				(17,'Cemburu','T'),
				(18,'Tidak Ada Tanggung Jawab','T'),
				(19,'Kawin Dibawah Umur','T'),
				(20,'Dihukum','T'),
				(21,'Cacat Biologis','T'),
				(22,'Politis','T'),
				(23,'Gangguan Pihak Ketiga','T'),
				(24,'Tidak Ada Keharmonisan','T'),
				(25,'Kekejaman Jasmani','T'),
				(26,'Kekejaman Mental','T');");

		$this->patching->exe_script("REPLACE INTO status_putusan(id,jenis_perkara_id,nama,keterangan,urutan,jenis_pengadilan)
				VALUES (62,1,'Dikabulkan','Status amar putusan',1,4),
				(63,1,'Ditolak','Status amar putusan',2,4),
				(64,1,'Tidak Dapat Diterima','Status amar putusan',3,4),
				(65,1,'Digugurkan','Status amar putusan',4,4),
				(66,1,'Dicoret dari Register','Status amar putusan',5,4),
				(67,1,'Dicabut','Status amar putusan',6,4),
				(68,2, 'Cambuk', '1', '4', '4'),
				(69,2, 'Denda', '2', '2', '4'),
				(70,2, 'Kerja Sosial', '3', '4', '4'),
				(71,2, 'Pembinaan Oleh Negara', '4', '3', '4'),
				(72,2, 'Pemutusan Perkawinan', '5', '3', '4'),
				(73,2, 'Pencabutan Izin dan Pencabutan Hak', '6', '4', '4'),
				(74,2, 'Pengembalian Kepada Orang Tua/Wali', '7', '3', '4'),
				(75,2, 'Penjara', '8', '1', '4'),
				(76,2, 'Perampasan Barang-Barang Tertentu ', '9', '4', '4'),
				(77,2, 'Restitusi', '10', '2', '4'),
				(78,2, 'Restitusi Oleh Orang Tua/Wali', '11', '2', '4');");

		$this->patching->exe_script("REPLACE INTO biaya_perkara (alur_perkara_id, jenis_biaya_id, jumlah, keterangan)  VALUES
				(15,'1','0.00',''),
				(15,'2','0.00',''),
				(15,'4','0.00',''),
				(15,'6','0.00',''),
				(15,'9','0.00',''),
				(15,'10','0.00',''),
				(15,'11','0.00',''),
				(15,'12','0.00',''),
				(15,'14','0.00',''),
				(15,'16','0.00',''),
				(15,'25','0.00',''),
				(15,'26','0.00',''),
				(15,'27','0.00',''),
				(15,'28','0.00',''),
				(15,'29','0.00',''),
				(15,'30','0.00',''),
				(15,'31','0.00',''),
				(15,'32','0.00',''),
				(15,'33','0.00',''),
				(15,'34','0.00',''),
				(15,'35','0.00',''),
				(15,'36','0.00',''),
				(15,'37','0.00',''),
				(15,'38','0.00',''),
				(15,'39','0.00',''),
				(15,'40','0.00',''),
				(15,'41','0.00',''),
				(15,'42','0.00',''),
				(15,'43','0.00',''),
				(15,'44','0.00',''),
				(15,'45','0.00',''),
				(15,'61','30000.00',''),
				(15,'62','50000.00',''),
				(15,'63','50000.00',''),
				(15,'65','200000.00',''),
				(15,'64','25000.00',''),
				(15,'141','0.00',''),
				(15,'144','0.00',''),
				(15,'145','0.00',''),
				(15,'146','0.00',''),
				(15,'150','0.00',''),
				(15,'151','0.00','Pengembalian Sisa Panjar'),
				(15,'152','0.00','Biaya Meterai'),
				(15,'153','0.00','Biaya Penyumpahan'),
				(15,'154','0.00','Biaya Penerjemah'),
				(15,'155','50000.00','Biaya Alat Tulis Kantor'),
				(15,'157','5000.00','Biaya Redaksi'),
				(15,'162','0.00','Biaya Lain-lain'),
				(15,'166','0.00','Pengembalian Sisa Panjar'),
				(15,'167','0.00','Biaya Meterai'),
				(15,'168','0.00','Biaya Penyumpahan'),
				(15,'169','0.00','Biaya Penerjemah'),
				(15,'170','50000.00','Biaya Alat Tulis Kantor'),
				(15,'172','5000.00','Biaya Redaksi'),
				(15,'177','0.00','Biaya Lain-lain'),
				(15,'181','0.00','Pengembalian Sisa Panjar'),
				(15,'182','0.00','Biaya Meterai'),
				(15,'183','0.00','Biaya Penyumpahan'),
				(15,'184','0.00','Biaya Penerjemah'),
				(15,'185','50000.00','Biaya Alat Tulis Kantor'),
				(15,'186','0.00','Biaya Upah Tulis'),
				(15,'187','5000.00','Biaya Redaksi'),
				(15,'189','0.00','Biaya Pencatatan Permohonan Sita Konservatoir'),
				(15,'190','0.00','Biaya Pencatatan Permohonan Sita Revindikatoir'),
				(15,'191','0.00','Biaya Permohonan Pencabutan Sita'),
				(15,'192','0.00','Biaya Lain-lain'),
				(15,'196','0.00','Pengembalian Sisa Panjar'),
				(15,'197','0.00','Biaya Meterai'),
				(15,'198','0.00','Biaya Penyumpahan'),
				(15,'199','0.00','Biaya Penerjemah'),
				(15,'200','50000.00','Biaya Alat Tulis Kantor'),
				(15,'201','0.00','Biaya Upah Tulis'),
				(15,'202','5000.00','Biaya Redaksi'),
				(15,'204','0.00','Biaya Pencatatan Permohonan Sita Konservatoir'),
				(15,'205','0.00','Biaya Pencatatan Permohonan Sita Revindikatoir'),
				(15,'206','0.00','Biaya Permohonan Pencabutan Sita'),
				(15,'207','0.00','Biaya Lain-lain'),
				(15,'211','0.00','Pengembalian Sisa Panjar'),
				(15,'212','0.00','Biaya Meterai'),
				(15,'213','0.00','Biaya Penyumpahan'),
				(15,'214','0.00','Biaya Penerjemah'),
				(15,'215','50000.00','Biaya Alat Tulis Kantor'),
				(15,'216','0.00','Biaya Upah Tulis'),
				(15,'217','5000.00','Biaya Redaksi'),
				(15,'219','0.00','Biaya Pencatatan Permohonan Sita Konservatoir'),
				(15,'220','0.00','Biaya Pencatatan Permohonan Sita Revindikatoir'),
				(15,'221','0.00','Biaya Permohonan Pencabutan Sita'),
				(15,'222','0.00','Biaya Lain-lain'),
				(15,'223','0.00',''),
				(15,'224','0.00',''),
				(15,'225','0.00',''),
				(15,'226','0.00',''),
				(15,'227','0.00',''),
				(15,'228','0.00',''),
				(15,'229','0.00',''),
				(15,'230','0.00',''),
				(15,'231','0.00',''),
				(15,'271','0.00',''),
				(15,'272','0.00',''),
				(15,'273','0.00',''),
				(15,'274','0.00',''),
				(15,'275','0.00',''),
				(15,'276','0.00',''),
				(15,'277','0.00',''),
				(15,'278','0.00',''),
				(15,'279','0.00',''),
				(15,'280','0.00',''),
				(15,'281','0.00',''),
				(15,'282','0.00',''),
				(15,'283','0.00',''),
				(15,'284','0.00',''),
				(15,'285','0.00',''),
				(15,'286','0.00',''),
				(15,'287','0.00',''),
				(15,'288','0.00',''),
				(15,'289','0.00',''),
				(15,'290','0.00',''),
				(15,'291','0.00',''),
				(15,'292','0.00',''),
				(15,'293','0.00',''),
				(15,'294','6000.00',''),
				(15,'295','6000.00',''),
				(15,'296','6000.00',''),
				(15,'297','6000.00',''),
				(15,'298','6000.00',''),
				(15,'299','6000.00',''),
				(15,'300','6000.00',''),
				(15,'301','6000.00',''),
				(15,'302','6000.00',''),
				(15,'303','6000.00',''),
				(15,'304','6000.00',''),
				(15,'305','6000.00',''),
				(15,'306','6000.00',''),
				(15,'307','0.00',''),
				(15,'308','0.00',''),
				(15,'309','0.00',''),
				(15,'310','0.00',''),
				(15,'311','0.00',''),
				(15,'312','0.00',''),
				(15,'313','0.00',''),
				(15,'314','0.00',''),
				(15,'315','0.00',''),
				(15,'316','0.00',''),
				(15,'317','0.00',''),
				(15,'318','0.00',''),
				(15,'319','0.00',''),
				(15,'320','0.00',''),
				(15,'321','0.00',''),
				(15,'322','0.00',''),
				(15,'323','0.00',''),
				(15,'324','0.00',''),
				(15,'325','0.00',''),
				(15,'326','0.00',''),
				(15,'327','0.00',''),
				(15,'328','5000.00','Memperlihatkan surat kepada yang berkepentingan mengenai surat-surat yang tersimpan di kepaniteraan'),
				(15,'329','25000.00','Penyitaan/eksekusi barang yang bergerak atau yang tidak bergerak dan untuk pencatatan pencabutan'),
				(15,'330','5000.00','Pengesahan Surat dibawah tangan (PP No. 53 Tahun 2008 E.16)'),
				(15,'331','25000.00','Melakukan penjualan dimuka umum/lelang atas perintah pengadilan (PP No. 53 Tahun 2008 E.7)'),
				(15,'332','5000.00','Penyerahan akta di Kepaniteraan yang dilakukan di dalam hal yang diharuskan menurut hukum'),
				(15,'333','5000.00','Penyerahan surat dari berkas perkara (PP No. 53 Tahun 2008 E.11.3)'),
				(15,'334','5000.00','Akta asli yang dibuat di Kepaniteraan, dikecualikan penyimpanan akta catatan sipil'),
				(15,'335','5000.00','Legalisasi dari satu atau lebih tanda tangan di dalam akta termasuk akta catatan sipil'),
				(15,'336','5000.00','Pendaftaran surat kuasa untuk mewakili pihak yang berperkara di Pengadilan'),
				(15,'337','5000.00','Pembuatan surat kuasa insidentil  (PP No. 53 Tahun 2008 E.15)'),
				(15,'338','0.00',''),
				(15,'339','0.00',''),
				(15,'340','0.00',''),
				(15,'341','0.00',''),
				(15,'342','0.00',''),
				(15,'349','0.00',''),
				(15,'350','0.00',''),
				(16,'2','0.00',''),
				(16,'1','0.00',''),
				(16,'4','0.00',''),
				(16,'6','0.00',''),
				(16,'9','0.00',''),
				(16,'10','0.00',''),
				(16,'11','0.00',''),
				(16,'13','0.00',''),
				(16,'15','0.00',''),
				(16,'25','0.00',''),
				(16,'26','0.00',''),
				(16,'27','0.00',''),
				(16,'28','0.00',''),
				(16,'29','0.00',''),
				(16,'30','0.00',''),
				(16,'31','0.00',''),
				(16,'32','0.00',''),
				(16,'33','0.00',''),
				(16,'34','0.00',''),
				(16,'35','0.00',''),
				(16,'36','0.00',''),
				(16,'37','0.00',''),
				(16,'38','0.00',''),
				(16,'39','0.00',''),
				(16,'40','0.00',''),
				(16,'41','0.00',''),
				(16,'42','0.00',''),
				(16,'43','0.00',''),
				(16,'44','0.00',''),
				(16,'45','0.00',''),
				(16,'61','30000.00',''),
				(16,'63','50000.00',''),
				(16,'64','200000.00',''),
				(16,'65','25000.00',''),
				(16,'141','0.00',''),
				(16,'144','0.00',''),
				(16,'145','0.00',''),
				(16,'146','0.00',''),
				(16,'150','0.00',''),
				(16,'151','0.00','Pengembalian Sisa Panjar'),
				(16,'152','0.00','Biaya Meterai'),
				(16,'153','0.00','Biaya Penyumpahan'),
				(16,'154','0.00','Biaya Penerjemah'),
				(16,'155','50000.00','Biaya Alat Tulis Kantor'),
				(16,'157','5000.00','Biaya Redaksi'),
				(16,'162','0.00','Biaya Lain-lain'),
				(16,'166','0.00','Pengembalian Sisa Panjar'),
				(16,'167','0.00','Biaya Meterai'),
				(16,'168','0.00','Biaya Penyumpahan'),
				(16,'169','0.00','Biaya Penerjemah'),
				(16,'170','50000.00','Biaya Alat Tulis Kantor'),
				(16,'172','5000.00','Biaya Redaksi'),
				(16,'177','0.00','Biaya Lain-lain'),
				(16,'181','0.00','Pengembalian Sisa Panjar'),
				(16,'182','0.00','Biaya Meterai'),
				(16,'183','0.00','Biaya Penyumpahan'),
				(16,'184','0.00','Biaya Penerjemah'),
				(16,'185','50000.00','Biaya Alat Tulis Kantor'),
				(16,'186','0.00','Biaya Upah Tulis'),
				(16,'187','5000.00','Biaya Redaksi'),
				(16,'189','0.00','Biaya Pencatatan Permohonan Sita Konservatoir'),
				(16,'190','0.00','Biaya Pencatatan Permohonan Sita Revindikatoir'),
				(16,'191','0.00','Biaya Permohonan Pencabutan Sita'),
				(16,'192','0.00','Biaya Lain-lain'),
				(16,'196','0.00','Pengembalian Sisa Panjar'),
				(16,'197','0.00','Biaya Meterai'),
				(16,'198','0.00','Biaya Penyumpahan'),
				(16,'199','0.00','Biaya Penerjemah'),
				(16,'200','50000.00','Biaya Alat Tulis Kantor'),
				(16,'201','0.00','Biaya Upah Tulis'),
				(16,'202','5000.00','Biaya Redaksi'),
				(16,'204','0.00','Biaya Pencatatan Permohonan Sita Konservatoir'),
				(16,'205','0.00','Biaya Pencatatan Permohonan Sita Revindikatoir'),
				(16,'206','0.00','Biaya Permohonan Pencabutan Sita'),
				(16,'207','0.00','Biaya Lain-lain'),
				(16,'211','0.00','Pengembalian Sisa Panjar'),
				(16,'212','0.00','Biaya Meterai'),
				(16,'213','0.00','Biaya Penyumpahan'),
				(16,'214','0.00','Biaya Penerjemah'),
				(16,'215','50000.00','Biaya Alat Tulis Kantor'),
				(16,'216','0.00','Biaya Upah Tulis'),
				(16,'217','5000.00','Biaya Redaksi'),
				(16,'219','0.00','Biaya Pencatatan Permohonan Sita Konservatoir'),
				(16,'220','0.00','Biaya Pencatatan Permohonan Sita Revindikatoir'),
				(16,'221','0.00','Biaya Permohonan Pencabutan Sita'),
				(16,'222','0.00','Biaya Lain-lain'),
				(16,'223','0.00',''),
				(16,'224','0.00',''),
				(16,'226','0.00',''),
				(16,'232','0.00',''),
				(16,'233','0.00',''),
				(16,'234','0.00',''),
				(16,'235','0.00',''),
				(16,'253','0.00',''),
				(16,'254','0.00',''),
				(16,'255','0.00',''),
				(16,'256','0.00',''),
				(16,'258','0.00',''),
				(16,'259','0.00',''),
				(16,'260','0.00',''),
				(16,'271','0.00',''),
				(16,'272','0.00',''),
				(16,'273','0.00',''),
				(16,'274','0.00',''),
				(16,'275','0.00',''),
				(16,'276','0.00',''),
				(16,'294','6000.00',''),
				(16,'295','6000.00',''),
				(16,'296','6000.00',''),
				(16,'297','6000.00',''),
				(16,'316','0.00',''),
				(16,'326','0.00',''),
				(16,'327','0.00',''),
				(16,'328','5000.00','Memperlihatkan surat kepada yang berkepentingan mengenai surat-surat yang tersimpan di kepaniteraan'),
				(16,'329','25000.00','Penyitaan/eksekusi barang yang bergerak atau yang tidak bergerak dan untuk pencatatan pencabutan'),
				(16,'330','5000.00','Pengesahan Surat dibawah tangan (PP No. 53 Tahun 2008 E.16)'),
				(16,'331','25000.00','Melakukan penjualan dimuka umum/lelang atas perintah pengadilan (PP No. 53 Tahun 2008 E.7)'),
				(16,'332','5000.00','Penyerahan akta di Kepaniteraan yang dilakukan di dalam hal yang diharuskan menurut hukum'),
				(16,'333','5000.00','Penyerahan surat dari berkas perkara (PP No. 53 Tahun 2008 E.11.3)'),
				(16,'334','5000.00','Akta asli yang dibuat di Kepaniteraan, dikecualikan penyimpanan akta catatan sipil'),
				(16,'335','5000.00','Legalisasi dari satu atau lebih tanda tangan di dalam akta termasuk akta catatan sipil'),
				(16,'336','5000.00','Pendaftaran surat kuasa untuk mewakili pihak yang berperkara di Pengadilan'),
				(16,'337','5000.00','Pembuatan surat kuasa insidentil  (PP No. 53 Tahun 2008 E.15)'),
				(16,'338','0.00',''),
				(16,'340','0.00',''),
				(16,'341','0.00',''),
				(16,'342','0.00',''),
				(16,'349','0.00',''),
				(16,'350','0.00','');");
		
		

		$this->nativesession->set('update_progress', 99);
		session_write_close();
		session_start();
		$this->patching->exe_script("REPLACE INTO template_dokumen (id,alur_perkara_id,tahapan_id,proses_id,nomor,kode,nama) VALUES 
		(1885,15,12,20,1,'PDT_15_12_20_1','A.1.a Penetapan Majelis Hakim'),
		(1886,15,12,30,1,'PDT_15_12_30_1','A.1.d. Surat Penunjukan Panitera / Panitera Pengganti'),
		(1887,15,12,40,1,'PDT_15_12_40_1','A.1.e. Surat Penunjukan Jurusita/Jurusita Pengganti'),
		(1889,15,18,290,1,'PDT_15_18_290_1','A.1.c. Penetapan Majelis Hakim Sidang Ikrar Talak'),
		(1891,15,15,210,1,'PDT_15_15_210_1','Putusan Verstek'),
		(1892,15,15,210,2,'PDT_15_15_210_2','Putusan Tolak Gugatan'),
		(1893,15,15,210,3,'PDT_15_15_210_3','Putusan Gugur'),
		(1894,15,15,210,4,'PDT_15_15_210_4','Putusan Cabut'),
		(1895,15,15,210,5,'PDT_15_15_210_5','Putusan N.O.'),
		(1896,15,15,210,6,'PDT_15_15_210_6','Putusan Verstek N.O.'),
		(1897,15,15,210,7,'PDT_15_15_210_7','Putusan Batal Daftar'),
		(1898,16,15,210,1,'PDT_16_15_210_1','Penetapan Permohonan Kabul'),
		(1899,16,15,210,2,'PDT_16_15_210_2','Penetapan Permohonan Tolak'),
		(1900,15,15,210,10,'PDT_15_15_210_10','Penetapan Gugur'),
		(1901,15,15,210,11,'PDT_15_15_210_11','Penetapan Cabut'),
		(1902,15,15,210,12,'PDT_15_15_210_12','Penetapan Batal Daftar'),
		(1903,15,15,210,13,'PDT_15_15_210_13','Penetapan Tentang Tidak Berkekuatan Hukumnya Putusan Cerai Talak'),
		(1904,15,15,210,14,'PDT_15_15_210_14','Penetapan Tentang Terjadinya Talak'),
		(1905,15,15,210,15,'PDT_15_15_210_15','Penetapan (saat ikrar, para pihak rukun)'),
		(1907,15,14,200,1,'PDT_15_14_200_1','BAS Pertama P dan T Tidak Hadir'),
		(1908,15,14,200,2,'PDT_15_14_200_2','BAS Pertama P dan Kuasanya Tidak Hadir'),
		(1909,15,14,200,3,'PDT_15_14_200_3','BAS Pertama T Tidak Hadir'),
		(1910,15,14,200,4,'PDT_15_14_200_4','BAS Pertama P Tidak Hadir'),
		(1911,15,14,200,5,'PDT_15_14_200_5','BAS Pertama P dan T Hadir Mediasi Sidang Keliling'),
		(1912,15,14,200,6,'PDT_15_14_200_6','BAS Pertama P dan T Hadir Mediasi Dengan Kuasa'),
		(1913,15,14,200,7,'PDT_15_14_200_7','BAS Pertama P dan T Hadir Mediasi'),
		(1914,15,14,200,8,'PDT_15_14_200_8','BAS Pertama darden verzet Mediasi'),
		(1915,15,14,200,132,'PDT_15_14_200_132','BAS lanjutan putus verstek'),
		(1916,15,14,200,101,'PDT_15_14_200_101','BAS lanjutan berhasil damai tanpa akta (hasil konsultasi)'),
		(1917,15,14,200,102,'PDT_15_14_200_102','BAS lanjutan Biaya Habis (hasil konsultasi)'),
		(1918,15,14,200,103,'PDT_15_14_200_103','BAS lanjutan Cabut Belum Jawab (hasil konsultasi)'),
		(1919,15,14,200,104,'PDT_15_14_200_104','BAS lanjutan dengan akta perdamaian (hasil konsultasi)'),
		(1920,15,14,200,105,'PDT_15_14_200_105','BAS lanjutan hasil mediasi belum siap jawaban (hasil konsultasi)'),
		(1921,15,14,200,106,'PDT_15_14_200_106','BAS lanjutan sepakat memilih mediator (hasil konsultasi)'),
		(1922,15,14,200,107,'PDT_15_14_200_107','BAS lanjutan tidak sepakat memilih mediator (hasil konsultasi)'),
		(1923,15,14,200,108,'PDT_15_14_200_108','BAS lanjutan, gugatan rekonpensi Lisan (hasil konsultasi)'),
		(1924,15,14,200,109,'PDT_15_14_200_109','BAS lanjutan hasil mediasi belum siap jawab (tertulis) (hasil konsultasi)'),
		(1925,15,14,200,110,'PDT_15_14_200_110','BAS lanjutan, jawaban Lisan, pembuktian, tunda putusan (hasil konsultasi)'),
		(1926,15,14,200,111,'PDT_15_14_200_111','BAS lanjutan Pembuktian (hasil konsultasi)'),
		(1927,15,14,200,112,'PDT_15_14_200_112','BAS lanjutan DECENTE (hasil konsultasi)'),
		(1928,15,14,200,113,'PDT_15_14_200_113','BAS lanjutan Sumpah Supletoir Tanpa Sela (hasil konsultasi)'),
		(1929,15,14,200,114,'PDT_15_14_200_114','BAS lanjutan pemeriksaan SAKSI AHLI (hasil konsultasi)'),
		(1930,15,14,200,115,'PDT_15_14_200_115','BAS lanjutan Jawaban-Belum Siap Replik (hasil konsultasi)'),
		(1931,15,14,200,116,'PDT_15_14_200_116','BAS lanjutan damai oleh meditor dan dicabut perkara (hasil konsultasi)'),
		(1932,15,14,200,117,'PDT_15_14_200_117','BAS lanjutan Putus Gugur (P & T tdk hadir) (hasil konsultasi)'),
		(1933,15,14,200,118,'PDT_15_14_200_118','BAS Putus PA tdk berwenang mengadili (verstek_relatif)'),
		(1934,15,14,200,119,'PDT_15_14_200_119','BAS Putus PA tidak berwenang (absolut) (hasil konsultasi)'),
		(1935,15,14,200,120,'PDT_15_14_200_120','BAS Putus verstek (hasil konsultasi)'),
		(1936,15,14,200,121,'PDT_15_14_200_121','BAS putusan Contradiktur (hasil konsultasi)'),
		(1937,15,14,200,122,'PDT_15_14_200_122','BAS Putus Gugur (hasil konsultasi)'),
		(1938,15,14,200,123,'PDT_15_14_200_123','BAS Putus verstek (sid Keliling) (hasil konsultasi)'),
		(1939,15,18,200,8,'PDT_15_18_200_8','BAS Ikrar P hadir dan T tdk hadir (hasil konsultasi)'),
		(1940,15,14,200,125,'PDT_15_14_200_125','BAS Aanmaning P dan T hadir (hasil konsultasi)'),
		(1941,15,14,200,126,'PDT_15_14_200_126','BAS Aanmaning P dan T tidak hadir (hasil konsultasi)'),
		(1942,15,14,200,201,'PDT_15_14_200_201','A.3.a2. Relaas Panggilan P (Kepala Desa / Lurah)'),
		(1943,15,14,200,231,'PDT_15_14_200_231','A.3.b2. Relaas Panggilan T (Kepala Desa / Lurah)'),
		(1948,15,14,200,251,'PDT_15_14_200_251','A.3.e. Relaas Panggilan Delegasi P'),
		(1949,15,14,200,252,'PDT_15_14_200_252','A.3.e. Relaas Panggilan Delegasi T'),
		(1950,15,14,200,232,'PDT_15_14_200_232','A.3.k. Relaas Panggilan I Melalui Media Massa (Perceraian)'),
		(1951,15,14,200,233,'PDT_15_14_200_233','A.3.l. Relaas Panggilan II Melalui Media Massa (Perceraian)'),
		(1952,15,15,210,8,'PDT_15_15_210_8','Putusan Cerai Talak dan Rekonvensi Harta Bersama'),
		(1953,15,18,294,203,'PDT_15_18_294_203','A.3.o. Relaas Panggilan Ikrar Talak (Termohon) Yang Tidak Diketahui Tempat Tinggalnya'),
		(1955,15,18,294,204,'PDT_15_18_294_204','A.3.n. Relaas Panggilan Ikrar Talak (Termohon)'),
		(1956,15,18,294,205,'PDT_15_18_294_205','A.3.m. Relaas Panggilan Ikrar Talak (Pemohon)'),
		(1957,15,18,294,206,'PDT_15_18_294_206','A.3.p. Relaas Panggilan Ikrar Talak (Pemohon Di Luar Wilayah)'),
		(1959,15,14,200,202,'PDT_15_14_200_202','A.3.a1. Relaas Panggilan P (Bertemu P)'),
		(1960,15,14,200,234,'PDT_15_14_200_234','A.3.b1. Relaas Panggilan T (Bertemu T)'),
		(1961,15,20,340,201,'PDT_15_20_340_201','A.6.g. Relaas Pemberitahuan dan Penyerahan Kontra Memori Banding'),
		(1962,15,20,340,202,'PDT_15_20_340_202','A.6.g. Relaas Pemberitahuan T dan Penyerahan Kontra Memori Banding (Langsung)'),
		(1963,15,15,230,201,'PDT_15_15_230_201','A-4.b. Relaas Pemberitahuan Putusan Verstek'),
		(1964,15,20,350,201,'PDT_15_20_350_201','A.6.h. Relaas Pemberitahuan Inzage'),
		(1965,15,20,360,1,'PDT_15_20_360_1','A.6.i. Surat Keterangan Tidak Melakukan Inzage'),
		(1966,15,15,230,202,'PDT_15_15_230_202','A-4.c. Relaas Pemberitahuan Putusan Pihak T Tidak Hadir'),
		(1967,15,14,200,235,'PDT_15_14_200_235','A.3.g. Panggilan Pihak di Luar Negeri  (Pasal 28 PP No. 9 Tahun 1975)'),
		(1968,15,20,301,201,'PDT_15_20_301_201','A.6.b1. Relaas Pemberitahuan Pernyataan Banding'),
		(1973,16,14,200,201,'PDT_16_14_200_201','A.3.c1. Relaas Voluntaire P (Bertemu Langsung)'),
		(1974,16,14,200,202,'PDT_16_14_200_202','A.3.c2. Relaas Voluntaire P (Kepala Desa / Lurah)'),
		(1975,15,20,300,3,'PDT_15_20_300_3','A.6.a3. Akta Permohonan Banding (Melalui Kuasa Insidentil)'),
		(1976,15,20,300,4,'PDT_15_20_300_4','A.6.a4. Akta Permohonan Banding Secara Prodeo'),
		(1977,15,20,300,1,'PDT_15_20_300_1','A.6.a3. Akta Permohonan Banding (Melalui Kuasa Insidentil)'),
		(1978,15,20,300,2,'PDT_15_20_300_2','A.6.a2. Akta Permohonan Banding (Melalui Kuasa Hukum)'),
		(1979,15,14,200,10,'PDT_15_14_200_10','BAS Pertama P dan T Tidak Hadir dg Kuasa (hasil konsultasi)'),
		(1980,15,14,200,11,'PDT_15_14_200_11','BAS Pertama P hadir dan T1 T2 tidak hadir(darden verzet)'),
		(1981,15,14,200,12,'PDT_15_14_200_12','BAS Pertama Tentang Penolakan Hakim'),
		(1982,15,14,200,13,'PDT_15_14_200_13','BAS Pertama Penolakan Panitera'),
		(1983,15,14,200,127,'PDT_15_14_200_127','BAS lanjutan Putusan Sela Penggabungan Pihak Ketiga (tussenkomst/intervensi)'),
		(1984,15,14,200,128,'PDT_15_14_200_128','BAS lanjutan Putusan Sela Penggabungan Pihak Ketiga (Voeging)'),
		(1985,15,14,200,129,'PDT_15_14_200_129','BAS lanjutan Putusan Sela Penarikan Pihak Ketiga (vrijwaring)'),
		(1986,15,14,200,130,'PDT_15_14_200_130','BAS Lanjutan Pembuktian verzet'),
		(1987,15,14,200,131,'PDT_15_14_200_131','BAS Lanjutan jawab menjawab (darden verzet)'),
		(1988,15,50,615,101,'PDT_15_50_615_101','Berita Acara Sita Eksekusi'),
		(1989,15,50,622,101,'PDT_15_50_622_101','Berita Acara Eksekusi Lelang'),
		(1990,15,18,200,9,'PDT_15_18_200_9','BAS Ikrar P dan T hadir'),
		(1991,15,18,200,10,'PDT_15_18_200_10','BAS Ikrar P dan T tidak hadir Tunda 6 bulan (hasil konsultasi)'),
		(1992,15,20,301,203,'PDT_15_20_301_203','A.6.c. Surat Bantuan Penyampaian Pemberitahuan Banding'),
		(1993,15,15,231,201,'PDT_15_15_231_201','A.3.d. Surat Bantuan Pemberitahuan Putusan Delegasi P'),
		(1996,15,20,320,201,'PDT_15_20_320_201','A.6.f. Relaas Pemberitahuan dan Penyerahan Memori Banding.'),
		(1997,15,20,340,203,'PDT_15_20_340_203','A-6.b.Surat Bantuan Penyampaian Pemberitahuan Dan Penyerahan Kontra Memori Banding'),
		(1998,15,20,350,205,'PDT_15_20_350_205','A.6.h. Relaas Pemberitahuan Inzage P (Kepala Desa / Lurah)'),
		(1999,15,20,350,206,'PDT_15_20_350_206','A.6.h. Relaas Pemberitahuan Inzage T (Kepala Desa / Lurah)'),
		(2001,15,15,230,203,'PDT_15_15_230_203','A-4.d. Relaas Pemberitahuan Putusan Verstek (ex Pasal 390 HIR-718 RBg)'),
		(2002,15,15,230,211,'PDT_15_15_230_211','A-4.c. Relaas Pemberitahuan Putusan Pihak P Tidak Hadir'),
		(2004,15,20,340,204,'PDT_15_20_340_204','A.6.e. Relaas Pemberitahuan dan Penyerahan Kontra Memori Banding P (Kepala Desa / Lurah)'),
		(2005,15,20,320,202,'PDT_15_20_320_202','A.6.e. Relaas Pemberitahuan dan Penyerahan Memori Banding T (Kepala Desa / Lurah)'),
		(2006,15,12,80,1,'PDT_15_12_80_1','A.2.a. Penetapan Hari Sidang (Contentieus)'),
		(2007,16,12,80,3,'PDT_16_12_80_3','A.2.c. Penetapan Hari Sidang Isbat Nikah'),
		(2008,16,12,80,2,'PDT_16_12_80_2','A.2.b. Penetepan Hari Sidang (Voluntaire)'),
		(2009,15,50,615,1,'PDT_15_50_615_1','A.8.p. Penetapan Perintah Sita Eksekusi untuk membayar sejumlah uang'),
		(2010,15,50,615,7,'PDT_15_50_615_7','A.2.k.Penetapan Perintah Sita Revindicatoir dengan disertai Penetapan Hari Sidang'),
		(2011,16,14,200,203,'PDT_16_14_200_203','A.3.q. Pengumuman Permohonan Isbat Nikah'),
		(2013,15,50,615,2,'PDT_15_50_615_2','A.2.j. Penolakan Sita disertai Penetapan Hari Sidang'),
		(2014,15,12,20,2,'PDT_15_12_20_2','A.1.b. Pergantian Majelis Hakim'),
		(2019,15,50,615,3,'PDT_15_50_615_3','A.2.f. Penetapan Hari Sidang Dengan Disertai Pengabulan Sita'),
		(2020,15,50,615,4,'PDT_15_50_615_4','A.2.g. Penetapan Hari Sidang Dengan Disertai Penangguhan Sita'),
		(2021,15,12,80,4,'PDT_15_12_80_4','A.2.d. Penetapan Hari Sidang ex Pasal 27 PP 9 Th. 75'),
		(2022,15,12,80,5,'PDT_15_12_80_5','A.2.e. Penetapan Hari Sidang ex Pasal 718 (3) RBg.'),
		(2024,15,50,615,5,'PDT_15_50_615_5','A.2.i. Penetapan Hari Sidang Setelah Penetapan Sita.'),
		(2025,15,50,615,6,'PDT_15_50_615_6','A.2.h. Penetepan Sita Dikabulkan Dan Penetapan Hari Sidang Ditetapkan Tersendiri'),
		(2026,15,18,293,1,'PDT_15_18_293_1','A.2.n. Penetapan Hari Sidang Ikrar Talak'),
		(2027,15,13,121,1,'PDT_15_13_121_1','A.2.o. Penetapan Penunjukkan Mediator'),
		(2028,15,12,80,6,'PDT_15_12_80_6','A.2.l. Penetapan Hari Sidang Setelah Pemeriksaan Setempat'),
		(2029,15,30,410,1,'PDT_15_30_410_1','Akta Permohonan Kasasi'),
		(2030,15,30,410,2,'PDT_15_30_410_2','A.7.b. Akta Permohonan Kasasi (Melalui Kuasa Hukumnya)'),
		(2031,15,30,410,3,'PDT_15_30_410_3','A.7.c. Akta Permohonan Kasasi (Melalui Kuasa Insidentil)'),
		(2032,15,30,410,4,'PDT_15_30_410_4','A.7.d. Akta Permohonan Kasasi Secara Prodeo'),
		(2033,15,30,420,201,'PDT_15_30_420_201','A.7.e. Relaas Pemberitahuan Pernyataan Kasasi'),
		(2034,15,30,420,202,'PDT_15_30_420_202','A.7.f. Surat Bantuan Penyampaian Pemberitahuan Kasasi'),
		(2035,15,30,430,1,'PDT_15_30_430_1','A.7.g. Tanda Terima Memori Kasasi'),
		(2036,15,30,450,1,'PDT_15_30_450_1','A.7.h. Tanda Terima Kontra Memori Kasasi'),
		(2037,15,30,440,201,'PDT_15_30_440_201','A.7.i. Relaas Pemberitahuan dan Penyerahan Memori Kasasi'),
		(2038,15,30,460,201,'PDT_15_30_460_201','A.7.j. Relaas Pemberitahuan dan Penyerahan Kontra Memori Kasasi'),
		(2039,15,30,490,1,'PDT_15_30_490_1','A.7.k. Akta Pencabutan Permohonan Kasasi, sebelum berkas perkara dikirim ke Mahkamah Agung RI'),
		(2040,15,30,490,2,'PDT_15_30_490_2','A.7.l. Akta Pencabutan Permohonan Kasasi, setelah berkas perkara dikirim ke Mahkamah Agung RI'),
		(2041,15,30,490,3,'PDT_15_30_490_3','A.7.n. Penetapan Permohonan Kasasi Tidak Memenuhi Syarat Formil'),
		(2042,15,30,490,4,'PDT_15_30_490_4','A.7.o. Laporan Permohonan Kasasi Yang Tidak Memenuhi Syarat Formil'),
		(2043,15,30,490,201,'PDT_15_30_490_201','A.7.p. Relaas Pemberitahuan dan Penyerahan Salinan Penetapan Tentang Kasasi Tidak Memenuhi Syarat Formil'),
		(2053,15,40,510,1,'PDT_15_40_510_1','A.8.a. Akta Permohonan Peninjauan Kembali'),
		(2054,15,40,510,2,'PDT_15_40_510_2','A.8.b. Akta Permohonan Peninjauan Kembali (Melalui Kuasa Hukumnya)'),
		(2055,15,40,510,3,'PDT_15_40_510_3','A.8.c. Akta Permohonan Peninjauan Kembali (Melalui Kuasa Insidentil)'),
		(2056,15,40,510,4,'PDT_15_40_510_4','A.8.d. Akta Permohonan Peninjauan Kembali Secara Prodeo'),
		(2057,15,40,520,201,'PDT_15_40_520_201','A.8.e. Relaas Pemberitahuan Pernyataan Peninjauan Kembali'),
		(2058,15,40,520,202,'PDT_15_40_520_202','A.8.f. Surat Bantuan Penyampaian Pemberitahuan Peninjauan Kembali'),
		(2059,15,40,521,1,'PDT_15_40_521_1','A.8.g. Tanda Terima Memori Peninjauan Kembali'),
		(2060,15,40,523,1,'PDT_15_40_523_1','A.8.h. Tanda Terima Kontra Memori Peninjauan Kembali'),
		(2061,15,40,522,201,'PDT_15_40_522_201','A.8.i. Relaas Pemberitahuan dan Penyerahan Memori Peninjauan Kembali'),
		(2062,15,40,524,201,'PDT_15_40_524_201','A.8.j. Relaas Pemberitahuan dan Penyerahan Kontra Memori Peninjauan Kembali'),
		(2063,15,40,570,1,'PDT_15_40_570_1','A.8.k. Akta Pencabutan Permohonan Peninjauan Kembali, sebelum berkas perkara dikirim ke Mahkamah Agung RI'),
		(2064,15,40,570,2,'PDT_15_40_570_2','A.8.l. Akta Pencabutan Permohonan Peninjauan Kembali, setelah berkas perkara dikirim ke Mahkamah Agung RI'),
		(2065,15,14,200,901,'PDT_15_14_200_901','A.4.a. Tegoran Untuk Tambah Panjar'),
		(2066,15,12,80,7,'PDT_15_12_80_7','A.2.m Penetapan Pengunduran Hari Sidang Dalam Hal Majelis Hakim Berhalangan'),
		(2070,15,20,310,1,'PDT_15_20_310_1','A.6.d. Tanda Terima Memori Banding'),
		(2071,15,20,330,1,'PDT_15_20_330_1','A.6.e. Tanda Terima Kontra Memori Banding.'),
		(2072,15,20,391,1,'PDT_15_20_391_1','A.6.j. Akta Pencabutan Permohonan Banding, sebelum berkas perkara dikirim ke PTA/MSY Aceh.'),
		(2073,15,20,391,2,'PDT_15_20_391_2','A.6.k. Akta Pencabutan Permohonan Banding, setelah berkas perkara dikirim ke PTA/MSY Aceh'),
		(2074,15,50,605,1,'PDT_15_50_605_1','A.8.m. Penetapan Aanmaning'),
		(2075,15,50,628,1,'PDT_15_50_628_1','A.8.n. Penetapan Eksekusi Riil'),
		(2076,15,50,615,8,'PDT_15_50_615_8','A.8.o. Penetapan Sita Eksekusi'),
		(2077,15,50,622,1,'PDT_15_50_622_1','A.8.q. Penetapan Eksekusi Lelang'),
		(2078,15,50,615,9,'PDT_15_50_615_9','A.8.r. Penetapan Pengangkatan Sita Jaminan (Telah dilaksanakan secara sukarela)'),
		(2079,15,50,615,10,'PDT_15_50_615_10','A.8.s. Penetapan Pencabutan Eksekusi'),
		(2080,15,50,615,11,'PDT_15_50_615_11','A.8.t. Penetapan Penghentian Eksekusi Putusan Provisi'),
		(2081,15,50,622,2,'PDT_15_50_622_2','A.8.u. Penetapan Harga Limit'),
		(2082,15,50,624,1,'PDT_15_50_624_1','A.8.v. Pengantar Lelang'),
		(2083,15,50,624,2,'PDT_15_50_624_2','A.8.w. Permintaan Cabut Pemblokiran Kendaraan'),
		(2084,15,50,640,1,'PDT_15_50_640_1','A.8.x. Penetapaan Non Ekskutabel'),
		(2085,15,15,231,202,'PDT_15_15_231_202','A.3.d. Surat Bantuan Pemberitahuan Putusan Delegasi T'),
		(2086,15,18,294,207,'PDT_15_18_294_207','A.3.p. Relaas Panggilan Ikrar Talak (Termohon Di Luar Wilayah)'),
		(2087,15,15,210,16,'PDT_15_15_210_16','Putusan Kabul');");
		
		$this->patching->exe_script("REPLACE INTO jenis_perkara (id,parent_id,kode,nama,nama_lengkap,format_nomor) VALUES
					(372,3,'LH','Perdata Lingkungan Hidup','Perdata Lingkungan Hidup','#nomor_urut_perkara#/Pdt.G-LH/#tahun#/PN #kode_pn#'),
					(373,372,NULL,'Pencemaran Air','Lingkungan Hidup/Pencemaran Air','#nomor_urut_perkara#/Pdt.G-LH/#tahun#/PN #kode_pn#'),
					(374,372,NULL,'Pencemaran Udara dan Gangguan (Kebisingan,Getaran dan Kebauan)','Lingkungan Hidup/Pencemaran Udara dan Gangguan (Kebisingan,Getaran dan Kebauan)','#nomor_urut_perkara#/Pdt.G-LH/#tahun#/PN #kode_pn#'),
					(375,372,NULL,'Pencemaran Tanah','Lingkungan Hidup/Pencemaran Tanah','#nomor_urut_perkara#/Pdt.G-LH/#tahun#/PN #kode_pn#'),
					(376,372,NULL,'Pencemaran Laut','Lingkungan Hidup/Pencemaran Laut','#nomor_urut_perkara#/Pdt.G-LH/#tahun#/PN #kode_pn#'),
					(377,372,NULL,'Kerusakan Terumbu Karang, Hutan Bakau(Mangrove), Lautan dan Pesisir','Lingkungan Hidup/Kerusakan Terumbu Karang, Hutan Bakau(Mangrove), Lautan dan Pesisir','#nomor_urut_perkara#/Pdt.G-LH/#tahun#/PN #kode_pn#'),
					(378,372,NULL,'Kebakaran Hutan','Lingkungan Hidup/Kebakaran Hutan','#nomor_urut_perkara#/Pdt.G-LH/#tahun#/PN #kode_pn#'),
					(379,372,NULL,'Penebangan Kayu','Lingkungan Hidup/Penebangan Kayu','#nomor_urut_perkara#/Pdt.G-LH/#tahun#/PN #kode_pn#'),
					(380,372,NULL,'Perubahan Kawasan Alam/Tata Ruang','Lingkungan Hidup/Perubahan Kawasan Alam/Tata Ruang','#nomor_urut_perkara#/Pdt.G-LH/#tahun#/PN #kode_pn#'),
					(381,372,NULL,'Tanaman Yang Dilindungi','Lingkungan Hidup/Tanaman Yang Dilindungi','#nomor_urut_perkara#/Pdt.G-LH/#tahun#/PN #kode_pn#'),
					(382,372,NULL,'Kerusakan Lingkungan Akibat Kegiatan Pertambangan(Mineral,Batu Bara), Minyak dan Gas Bumi','Lingkungan Hidup/Kerusakan Lingkungan Akibat Kegiatan Pertambangan(Mineral,Batu Bara), Minyak dan Gas Bumi','#nomor_urut_perkara#/Pdt.G-LH/#tahun#/PN #kode_pn#'),
					(383,372,NULL,'Konservasi Sumber Daya Alam','Lingkungan Hidup/Konservasi Sumber Daya Alam','#nomor_urut_perkara#/Pdt.G-LH/#tahun#/PN #kode_pn#'),
					(384,372,NULL,'Limbah Bahan Beracun Berbahaya (B3)','Lingkungan Hidup/Limbah Bahan Beracun Berbahaya (B3)','#nomor_urut_perkara#/Pdt.G-LH/#tahun#/PN #kode_pn#'),
					(385,372,NULL,'Reklamasi Pantai','Lingkungan Hidup/Reklamasi Pantai','#nomor_urut_perkara#/Pdt.G-LH/#tahun#/PN #kode_pn#'),
					(386,372,NULL,'Pembuangan Limbah','Lingkungan Hidup/Pembuangan Limbah','#nomor_urut_perkara#/Pdt.G-LH/#tahun#/PN #kode_pn#'),
					(387,372,NULL,'Penangkapan Ikan (dengan racun, bahan peledak/bom ikan)','Lingkungan Hidup/Penangkapan Ikan (dengan racun, bahan peledak/bom ikan)','#nomor_urut_perkara#/Pdt.G-LH/#tahun#/PN #kode_pn#'),
					(388,372,NULL,'Perubahan Iklim','Lingkungan Hidup/Perubahan Iklim','#nomor_urut_perkara#/Pdt.G-LH/#tahun#/PN #kode_pn#'),
					(389,372,NULL,'Gugatan Terhadap Aktivis Lingkungan Hidup/Warga/Masyarakat yang memperjuangkan lingkungan hidup','Lingkungan Hidup/Gugatan Terhadap Aktivis Lingkungan Hidup/Warga/Masyarakat yang memperjuangkan lingkungan hidup','#nomor_urut_perkara#/Pdt.G-LH/#tahun#/PN #kode_pn#'),
					(390,372,NULL,'Hal-hal yang mengakibatkan kerusakan dan pencemaran lingkungan','Lingkungan Hidup/Hal-hal yang mengakibatkan kerusakan dan pencemaran lingkungan','#nomor_urut_perkara#/Pdt.G-LH/#tahun#/PN #kode_pn#'),
					(391,372,NULL,'Satwa Liar (Penangkapan,Perdagangan dll)','Lingkungan Hidup/Satwa Liar (Penangkapan,Perdagangan dll)','#nomor_urut_perkara#/Pdt.G-LH/#tahun#/PN #kode_pn#'),
					(392,2,'LH','Pidana Lingkungan Hidup','Pidana Lingkungan Hidup','#nomor_urut_perkara#/Pid.Sus-LH/#tahun#/PN #kode_pn#'),
					(393,392,NULL,'Pencemaran Air','Lingkungan Hidup/Pencemaran Air','#nomor_urut_perkara#/Pid.Sus-LH/#tahun#/PN #kode_pn#'),
					(394,392,NULL,'Pencemaran Udara dan Gangguan (Kebisingan,Getaran dan Kebauan)','Lingkungan Hidup/Pencemaran Udara dan Gangguan (Kebisingan,Getaran dan Kebauan)','#nomor_urut_perkara#/Pid.Sus-LH/#tahun#/PN #kode_pn#'),
					(395,392,NULL,'Pencemaran Tanah','Lingkungan Hidup/Pencemaran Tanah','#nomor_urut_perkara#/Pid.Sus-LH/#tahun#/PN #kode_pn#'),
					(396,392,NULL,'Pencemaran Laut','Lingkungan Hidup/Pencemaran Laut','#nomor_urut_perkara#/Pid.Sus-LH/#tahun#/PN #kode_pn#'),
					(397,392,NULL,'Kerusakan Terumbu Karang, Hutan Bakau(Mangrove), Lautan dan Pesisir','Lingkungan Hidup/Kerusakan Terumbu Karang, Hutan Bakau(Mangrove), Lautan dan Pesisir','#nomor_urut_perkara#/Pid.Sus-LH/#tahun#/PN #kode_pn#'),
					(398,392,NULL,'Kebakaran Hutan','Lingkungan Hidup/Kebakaran Hutan','#nomor_urut_perkara#/Pid.Sus-LH/#tahun#/PN #kode_pn#'),
					(399,392,NULL,'Penebangan Kayu','Lingkungan Hidup/Penebangan Kayu','#nomor_urut_perkara#/Pid.Sus-LH/#tahun#/PN #kode_pn#'),
					(400,392,NULL,'Perubahan Kawasan Alam/Tata Ruang','Lingkungan Hidup/Perubahan Kawasan Alam/Tata Ruang','#nomor_urut_perkara#/Pid.Sus-LH/#tahun#/PN #kode_pn#'),
					(401,392,NULL,'Satwa Liar (Penangkapan,Perdagangan dll)','Lingkungan Hidup/Satwa Liar (Penangkapan,Perdagangan dll)','#nomor_urut_perkara#/Pid.Sus-LH/#tahun#/PN #kode_pn#'),
					(402,392,NULL,'Tanaman Yang Dilindungi','Lingkungan Hidup/Tanaman Yang Dilindungi','#nomor_urut_perkara#/Pid.Sus-LH/#tahun#/PN #kode_pn#'),
					(403,392,NULL,'Kerusakan Lingkungan Akibat Kegiatan Pertambangan(Mineral,Batu Bara), Minyak dan Gas Bumi','Lingkungan Hidup/Kerusakan Lingkungan Akibat Kegiatan Pertambangan(Mineral,Batu Bara), Minyak dan Gas Bumi','#nomor_urut_perkara#/Pid.Sus-LH/#tahun#/PN #kode_pn#'),
					(404,392,NULL,'Konservasi Sumber Daya Alam','Lingkungan Hidup/Konservasi Sumber Daya Alam','#nomor_urut_perkara#/Pid.Sus-LH/#tahun#/PN #kode_pn#'),
					(405,392,NULL,'Limbah Bahan Beracun Berbahaya (B3)','Lingkungan Hidup/Limbah Bahan Beracun Berbahaya (B3)','#nomor_urut_perkara#/Pid.Sus-LH/#tahun#/PN #kode_pn#'),
					(406,392,NULL,'Reklamasi Pantai','Lingkungan Hidup/Reklamasi Pantai','#nomor_urut_perkara#/Pid.Sus-LH/#tahun#/PN #kode_pn#'),
					(407,392,NULL,'Pembuangan Limbah','Lingkungan Hidup/Pembuangan Limbah','#nomor_urut_perkara#/Pid.Sus-LH/#tahun#/PN #kode_pn#'),
					(408,392,NULL,'Penangkapan Ikan (dengan racun, bahan peledak/bom ikan)','Lingkungan Hidup/Penangkapan Ikan (dengan racun, bahan peledak/bom ikan)','#nomor_urut_perkara#/Pid.Sus-LH/#tahun#/PN #kode_pn#'),
					(409,392,NULL,'Perubahan Iklim','Lingkungan Hidup/Perubahan Iklim','#nomor_urut_perkara#/Pid.Sus-LH/#tahun#/PN #kode_pn#'),
					(410,392,NULL,'Hal-hal yang mengakibatkan kerusakan dan pencemaran lingkungan','Lingkungan Hidup/Hal-hal yang mengakibatkan kerusakan dan pencemaran lingkungan','#nomor_urut_perkara#/Pid.Sus-LH/#tahun#/PN #kode_pn#');");

		$this->patching->exe_script("REPLACE INTO jenis_alur_perkara(alur_perkara_id,jenis_perkara_id) VALUES
				(1,373),(1,374),(1,375),(1,376),(1,377),(1,378),(1,379),(1,380),(1,381),(1,382),(1,383),(1,384),(1,385),(1,386),(1,387),(1,388),(1,389),(1,390),(1,391),
				(111,393),(111,394),(111,395),(111,396),(111,397),(111,398),(111,399),(111,400),(111,401),(111,402),(111,403),(111,404),(111,405),(111,406),(111,407),(111,408),(111,409),(111,410);");
		
		$this->patching->exe_script("REPLACE INTO proses_alur_perkara (id,alur_perkara_id,tahapan_id,tahapan_nama,proses_id,proses_nama) VALUES
				(94,1,40,'Peninjauan Kembali',523,'Penerimaan Kontra Memori PK'),
				(95,1,40,'Penyerahan Kontra Memori PK',524,'Penyerahan Kontra Memori PK'),
				(182,2,40,'Peninjauan Kembali',523,'Penerimaan Kontra Memori PK'),
				(183,2,40,'Penyerahan Kontra Memori PK',524,'Penyerahan Kontra Memori PK'),
				(283,3,40,'Peninjauan Kembali',523,'Penerimaan Kontra Memori PK'),
				(284,3,40,'Penyerahan Kontra Memori PK',524,'Penyerahan Kontra Memori PK'),
				(384,4,40,'Peninjauan Kembali',523,'Penerimaan Kontra Memori PK'),
				(385,4,40,'Penyerahan Kontra Memori PK',524,'Penyerahan Kontra Memori PK'),
				(473,5,40,'Peninjauan Kembali',523,'Penerimaan Kontra Memori PK'),
				(474,5,40,'Penyerahan Kontra Memori PK',524,'Penyerahan Kontra Memori PK'),
				(586,6,40,'Peninjauan Kembali',523,'Penerimaan Kontra Memori PK'),
				(587,6,40,'Penyerahan Kontra Memori PK',524,'Penyerahan Kontra Memori PK'),
				(1510,7,40,'Peninjauan Kembali',523,'Penerimaan Kontra Memori PK'),
				(1511,7,40,'Penyerahan Kontra Memori PK',524,'Penyerahan Kontra Memori PK'),
				(1512,8,40,'Peninjauan Kembali',523,'Penerimaan Kontra Memori PK'),
				(1513,8,40,'Penyerahan Kontra Memori PK',524,'Penyerahan Kontra Memori PK'),
				(1696,9,40,'Peninjauan Kembali',523,'Penerimaan Kontra Memori PK'),
				(1697,9,40,'Penyerahan Kontra Memori PK',524,'Penyerahan Kontra Memori PK'),
				(NULL,9,12,'Penetapan',42,'Pemeriksaan Persiapan'),
				(687,111,40,'Peninjauan Kembali',523,'Penerimaan Kontra Memori PK'),
				(688,111,40,'Penyerahan Kontra Memori PK',524,'Penyerahan Kontra Memori PK'),
				(788,112,40,'Peninjauan Kembali',523,'Penerimaan Kontra Memori PK'),
				(789,112,40,'Penyerahan Kontra Memori PK',524,'Penyerahan Kontra Memori PK'),
				(889,113,40,'Peninjauan Kembali',523,'Penerimaan Kontra Memori PK'),
				(890,113,40,'Penyerahan Kontra Memori PK',524,'Penyerahan Kontra Memori PK'),
				(1091,115,40,'Peninjauan Kembali',523,'Penerimaan Kontra Memori PK'),
				(1092,115,40,'Penyerahan Kontra Memori PK',524,'Penyerahan Kontra Memori PK'),
				(1192,116,40,'Peninjauan Kembali',523,'Penerimaan Kontra Memori PK'),
				(1193,116,40,'Penyerahan Kontra Memori PK',524,'Penyerahan Kontra Memori PK'),
				(1293,117,40,'Peninjauan Kembali',523,'Penerimaan Kontra Memori PK'),
				(1294,117,40,'Penyerahan Kontra Memori PK',524,'Penyerahan Kontra Memori PK'),
				(1380,118,40,'Peninjauan Kembali',523,'Penerimaan Kontra Memori PK'),
				(1381,118,40,'Penyerahan Kontra Memori PK',524,'Penyerahan Kontra Memori PK'),
				(1623,120,40,'Peninjauan Kembali',523,'Penerimaan Kontra Memori PK'),
				(1624,120,40,'Penyerahan Kontra Memori PK',524,'Penyerahan Kontra Memori PK'),
				(1625,121,40,'Peninjauan Kembali',523,'Penerimaan Kontra Memori PK'),
				(1626,121,40,'Penyerahan Kontra Memori PK',524,'Penyerahan Kontra Memori PK');");
		
		$this->patching->exe_script("REPLACE INTO proses (id,tahapan_id,kode,nama,keterangan,nama_tabel,nama_kolom,STATUS) VALUES
				(523,40,523,'Penerimaan Kontra Memori PK','Penerimaan Kontra Memori PK','perkara_pk','penerimaan_kontra_pk','Penerimaan Kontra Memori PK'),
				(524,40,524,'Penyerahan Kontra Memori PK','Penyerahan Kontra Memori PK','perkara_pk','penyerahan_kontra_pk','Penyerahan Kontra Memori PK');");

		$this->patching->exe_script('SET FOREIGN_KEY_CHECKS=0;');
		$this->patching->exe_script("TRUNCATE TABLE sys_menu_rule;");
		$this->patching->exe_script("TRUNCATE TABLE sys_group_rule;");
		$this->patching->exe_script("TRUNCATE TABLE sys_menus;");
		$this->patching->exe_script("REPLACE INTO sys_menu_rule (menuid, ruleid)
				VALUES (1000,62),(1001,63),(1002,64),(2, 1),(2, 2),(2, 3),(2, 4),(2, 5),(2, 6),(2, 7),(2, 8),(3, 7),(20, 5),(37, 6),(64, 9),(64, 10),(64, 11),(64, 12),(64, 13),(64, 14),(64, 15),(64, 16),(64, 17),(64, 18),(64, 19),(64, 20),(64, 21),(64, 22),(64, 25),(64, 26),(64, 27),(64, 28),(64, 29),(64, 30),(84, 80),(84, 228),(84, 229),(84, 230),(84, 478),(84, 479),(84, 480),(84, 481),(84, 482),(84, 483),(84, 484),(84, 485),(84, 486),(84, 487),(84, 488),(84, 489),(84, 490),(84, 491),(84, 492),(84, 493),(84, 494),(84, 495),(84, 496),(85, 4),(85, 5),(100, 22),(106, 478),(106, 479),(106, 491),(106, 492),(117, 44),(117, 144),(117, 145),(117, 146),(117, 443),(118, 25),(119, 26),(120, 27),(121, 28),(122, 45),(122, 147),(122, 148),(122, 149),(122, 444),(123, 46),(123, 150),(123, 151),(123, 152),(123, 446),(124, 47),(124, 153),(124, 154),(124, 155),(124, 449),(126, 62),(126, 216),(126, 217),(126, 218),(127, 63),(127, 219),(127, 220),(127, 221),(128, 64),(128, 222),(128, 223),(128, 224),(129, 65),(129, 225),(129, 226),(129, 227),(132, 480),(132, 481),(132, 493),(132, 494),(133, 482),(133, 495),(134, 483),(134, 496),(137, 484),(137, 485),(137, 486),(137, 487),(140, 488),(141, 489),(142, 490),(158, 25),(159, 25),(160, 25),(164, 88),(164, 189),(164, 190),(164, 191),(165, 89),(165, 192),(165, 193),(165, 194),(166, 90),(166, 195),(166, 196),(166, 197),(167, 83),(167, 84),(167, 85),(167, 183),(167, 451),(168, 91),(168, 198),(168, 199),(168, 200),(169, 92),(169, 201),(169, 202),(169, 203),(170, 105),(170, 319),(170, 320),(170, 321),(171, 106),(171, 322),(171, 323),(171, 324),(172, 93),(172, 204),(172, 205),(172, 206),(174, 121),(174, 257),(174, 258),(174, 259),(175, 122),(175, 260),(175, 261),(175, 262),(177, 129),(177, 283),(177, 284),(177, 285),(178, 130),(178, 286),(178, 287),(178, 288),(179, 131),(179, 289),(179, 290),(179, 291),(180, 132),(180, 292),(180, 293),(180, 294),(181, 133),(181, 295),(181, 296),(181, 297),(182, 134),(182, 298),(182, 299),(182, 300),(183, 135),(183, 301),(183, 302),(183, 303),(184, 136),(184, 304),(184, 305),(184, 306),(185, 137),(185, 307),(185, 308),(185, 309),(187, 332),(187, 363),(187, 364),(187, 365),(188, 333),(188, 366),(188, 367),(188, 368),(189, 334),(189, 369),(189, 370),(189, 371),(190, 335),(190, 372),(190, 373),(190, 374),(192, 338),(192, 378),(192, 379),(192, 380),(193, 333),(193, 366),(193, 367),(193, 368),(194, 341),(194, 387),(194, 388),(194, 389),(196, 344),(196, 393),(196, 394),(196, 395),(197, 345),(197, 396),(197, 397),(197, 398),(198, 346),(198, 399),(198, 400),(198, 401),(199, 347),(199, 402),(199, 403),(199, 404),(200, 94),(200, 156),(200, 157),(201, 95),(201, 159),(201, 160),(202, 96),(202, 162),(202, 163),(203, 97),(203, 165),(203, 166),(204, 98),(204, 168),(204, 169),(205, 99),(205, 171),(205, 172),(207, 101),(207, 174),(207, 175),(208, 103),(208, 177),(208, 178),(209, 104),(209, 180),(209, 181),(209, 273),(213, 109),(213, 207),(213, 208),(214, 110),(214, 210),(214, 211),(215, 111),(215, 231),(215, 232),(216, 112),(216, 234),(216, 235),(217, 113),(217, 237),(217, 238),(218, 114),(218, 240),(218, 241),(219, 115),(219, 243),(219, 244),(220, 116),(220, 246),(220, 247),(221, 117),(221, 249),(221, 250),(221, 273),(222, 123),(222, 263),(222, 264),(223, 124),(223, 266),(223, 267),(224, 125),(224, 269),(224, 270),(225, 126),(225, 272),(225, 273),(226, 127),(226, 273),(226, 275),(226, 276),(227, 138),(227, 310),(227, 311),(228, 139),(228, 313),(228, 314),(229, 140),(229, 316),(229, 317),(230, 138),(230, 310),(230, 311),(231, 138),(231, 310),(231, 311),(232, 127),(232, 273),(232, 275),(232, 276),(233, 330),(233, 355),(233, 356),(233, 357),(234, 336),(234, 375),(234, 376),(234, 377),(235, 342),(235, 390),(235, 391),(235, 392),(236, 348),(236, 405),(236, 406),(236, 407),(237, 340),(237, 384),(237, 385),(237, 386),(238, 141),(239, 26),(240, 26),(241, 26),(243, 5),(265, 5),(268, 525),(600, 94),(600, 156),(600, 157),(603, 94),(603, 156),(603, 157),(604, 94),(604, 156),(604, 157),(605, 94),(605, 156),(605, 157),(606, 94),(606, 156),(606, 157),(607, 94),(607, 156),(607, 157),(608, 94),(608, 156),(608, 157),(609, 94),(609, 156),(609, 157),(610, 94),(610, 156),(610, 157),(611, 94),(611, 156),(611, 157),(612, 94),(612, 156),(612, 157),(700, 97),(701, 97),(703, 157),(704, 160),(705, 96),(708, 99),(709, 99),(710, 175),(710, 180),(710, 273),(711, 175),(1000, 350),(1000, 408),(1000, 409),(1000, 410),(1001, 351),(1001, 411),(1001, 412),(1001, 413),(1002, 352),(1002, 414),(1002, 415),(1002, 416),(1003, 1),(1003, 5),(2004, 157),(2005, 273),(2008, 273),(2016, 526),(5000, 80);");
		$this->patching->exe_script("REPLACE INTO sys_group_rule (groupid, ruleid)
				VALUES (-1, 526),(1, 1),(1, 4),(1, 5),(1, 6),(1, 7),(1, 8),(1, 9),(1, 10),(1, 11),(1, 12),(1, 13),(1, 14),(1, 16),(1, 17),(1, 22),(1, 25),(1, 26),(1, 27),(1, 28),(1, 44),(1, 45),(1, 46),(1, 47),(1, 62),(1, 63),(1, 64),(1, 65),(1, 80),(1, 83),(1, 84),(1, 85),(1, 88),(1, 89),(1, 90),(1, 91),(1, 92),(1, 93),(1, 94),(1, 95),(1, 96),(1, 97),(1, 98),(1, 99),(1, 101),(1, 103),(1, 104),(1, 105),(1, 106),(1, 109),(1, 110),(1, 111),(1, 112),(1, 113),(1, 114),(1, 115),(1, 116),(1, 117),(1, 121),(1, 122),(1, 123),(1, 124),(1, 125),(1, 126),(1, 127),(1, 129),(1, 130),(1, 131),(1, 132),(1, 133),(1, 134),(1, 135),(1, 136),(1, 137),(1, 138),(1, 139),(1, 140),(1, 141),(1, 144),(1, 145),(1, 146),(1, 147),(1, 148),(1, 149),(1, 150),(1, 151),(1, 152),(1, 153),(1, 154),(1, 155),(1, 156),(1, 157),(1, 159),(1, 160),(1, 162),(1, 163),(1, 165),(1, 166),(1, 168),(1, 169),(1, 171),(1, 172),(1, 174),(1, 175),(1, 177),(1, 178),(1, 180),(1, 181),(1, 183),(1, 189),(1, 190),(1, 191),(1, 192),(1, 193),(1, 194),(1, 195),(1, 196),(1, 197),(1, 198),(1, 199),(1, 200),(1, 201),(1, 202),(1, 203),(1, 204),(1, 205),(1, 206),(1, 207),(1, 208),(1, 210),(1, 211),(1, 216),(1, 217),(1, 218),(1, 219),(1, 220),(1, 221),(1, 222),(1, 223),(1, 224),(1, 225),(1, 226),(1, 227),(1, 228),(1, 229),(1, 230),(1, 231),(1, 232),(1, 234),(1, 235),(1, 237),(1, 238),(1, 240),(1, 241),(1, 243),(1, 244),(1, 246),(1, 247),(1, 249),(1, 250),(1, 257),(1, 258),(1, 259),(1, 260),(1, 261),(1, 262),(1, 263),(1, 264),(1, 266),(1, 267),(1, 269),(1, 270),(1, 272),(1, 273),(1, 275),(1, 276),(1, 283),(1, 284),(1, 285),(1, 286),(1, 287),(1, 288),(1, 289),(1, 290),(1, 291),(1, 292),(1, 293),(1, 294),(1, 295),(1, 296),(1, 297),(1, 298),(1, 299),(1, 300),(1, 301),(1, 302),(1, 303),(1, 304),(1, 305),(1, 306),(1, 307),(1, 308),(1, 309),(1, 310),(1, 311),(1, 313),(1, 314),(1, 316),(1, 317),(1, 319),(1, 320),(1, 321),(1, 322),(1, 323),(1, 324),(1, 330),(1, 332),(1, 333),(1, 334),(1, 335),(1, 336),(1, 338),(1, 340),(1, 341),(1, 342),(1, 344),(1, 345),(1, 346),(1, 347),(1, 348),(1, 350),(1, 351),(1, 352),(1, 355),(1, 356),(1, 357),(1, 363),(1, 364),(1, 365),(1, 366),(1, 367),(1, 368),(1, 369),(1, 370),(1, 371),(1, 372),(1, 373),(1, 374),(1, 375),(1, 376),(1, 377),(1, 378),(1, 379),(1, 380),(1, 384),(1, 385),(1, 386),(1, 387),(1, 388),(1, 389),(1, 390),(1, 391),(1, 392),(1, 393),(1, 394),(1, 395),(1, 396),(1, 397),(1, 398),(1, 399),(1, 400),(1, 401),(1, 402),(1, 403),(1, 404),(1, 405),(1, 406),(1, 407),(1, 408),(1, 409),(1, 410),(1, 411),(1, 412),(1, 413),(1, 414),(1, 415),(1, 416),(1, 443),(1, 444),(1, 446),(1, 449),(1, 451),(1, 477),(1, 478),(1, 479),(1, 480),(1, 481),(1, 482),(1, 483),(1, 484),(1, 485),(1, 486),(1, 487),(1, 488),(1, 489),(1, 490),(1, 491),(1, 492),(1, 493),(1, 494),(1, 495),(1, 496),(1, 525),(1, 526),(2, 1),(2, 6),(2, 7),(2, 8),(2, 9),(2, 10),(2, 11),(2, 12),(2, 13),(2, 14),(2, 16),(2, 17),(2, 22),(2, 25),(2, 26),(2, 27),(2, 28),(2, 44),(2, 45),(2, 46),(2, 47),(2, 62),(2, 63),(2, 64),(2, 65),(2, 80),(2, 83),(2, 84),(2, 85),(2, 88),(2, 89),(2, 90),(2, 91),(2, 92),(2, 93),(2, 94),(2, 95),(2, 96),(2, 97),(2, 98),(2, 99),(2, 101),(2, 103),(2, 104),(2, 105),(2, 106),(2, 109),(2, 110),(2, 111),(2, 112),(2, 113),(2, 114),(2, 115),(2, 116),(2, 117),(2, 121),(2, 122),(2, 123),(2, 124),(2, 125),(2, 126),(2, 127),(2, 129),(2, 130),(2, 131),(2, 132),(2, 133),(2, 134),(2, 135),(2, 136),(2, 137),(2, 138),(2, 139),(2, 140),(2, 141),(2, 144),(2, 145),(2, 146),(2, 147),(2, 148),(2, 149),(2, 150),(2, 151),(2, 152),(2, 153),(2, 154),(2, 155),(2, 156),(2, 157),(2, 159),(2, 160),(2, 162),(2, 163),(2, 165),(2, 166),(2, 168),(2, 169),(2, 171),(2, 172),(2, 174),(2, 175),(2, 177),(2, 178),(2, 180),(2, 181),(2, 183),(2, 189),(2, 190),(2, 191),(2, 192),(2, 193),(2, 194),(2, 195),(2, 196),(2, 197),(2, 198),(2, 199),(2, 200),(2, 201),(2, 202),(2, 203),(2, 204),(2, 205),(2, 206),(2, 207),(2, 208),(2, 210),(2, 211),(2, 216),(2, 217),(2, 218),(2, 219),(2, 220),(2, 221),(2, 222),(2, 223),(2, 224),(2, 225),(2, 226),(2, 227),(2, 228),(2, 229),(2, 230),(2, 231),(2, 232),(2, 234),(2, 235),(2, 237),(2, 238),(2, 240),(2, 241),(2, 243),(2, 244),(2, 246),(2, 247),(2, 249),(2, 250),(2, 257),(2, 258),(2, 259),(2, 260),(2, 261),(2, 262),(2, 263),(2, 264),(2, 266),(2, 267),(2, 269),(2, 270),(2, 272),(2, 273),(2, 275),(2, 276),(2, 283),(2, 284),(2, 285),(2, 286),(2, 287),(2, 288),(2, 289),(2, 290),(2, 291),(2, 292),(2, 293),(2, 294),(2, 295),(2, 296),(2, 297),(2, 298),(2, 299),(2, 300),(2, 301),(2, 302),(2, 303),(2, 304),(2, 305),(2, 306),(2, 307),(2, 308),(2, 309),(2, 310),(2, 311),(2, 313),(2, 314),(2, 316),(2, 317),(2, 319),(2, 320),(2, 321),(2, 322),(2, 323),(2, 324),(2, 330),(2, 332),(2, 333),(2, 334),(2, 335),(2, 336),(2, 338),(2, 340),(2, 341),(2, 342),(2, 344),(2, 345),(2, 346),(2, 347),(2, 348),(2, 355),(2, 356),(2, 357),(2, 363),(2, 364),(2, 365),(2, 366),(2, 367),(2, 368),(2, 369),(2, 370),(2, 371),(2, 372),(2, 373),(2, 374),(2, 375),(2, 376),(2, 377),(2, 378),(2, 379),(2, 380),(2, 384),(2, 385),(2, 386),(2, 387),(2, 388),(2, 389),(2, 390),(2, 391),(2, 392),(2, 393),(2, 394),(2, 395),(2, 396),(2, 397),(2, 398),(2, 399),(2, 400),(2, 401),(2, 402),(2, 403),(2, 404),(2, 405),(2, 406),(2, 407),(2, 443),(2, 444),(2, 446),(2, 449),(2, 451),(2, 477),(2, 478),(2, 479),(2, 480),(2, 481),(2, 482),(2, 483),(2, 484),(2, 485),(2, 486),(2, 487),(2, 488),(2, 489),(2, 490),(2, 491),(2, 492),(2, 493),(2, 494),(2, 495),(2, 496),(2, 526),(10, 1),(10, 6),(10, 44),(10, 45),(10, 46),(10, 47),(10, 62),(10, 63),(10, 64),(10, 65),(10, 80),(10, 83),(10, 84),(10, 85),(10, 88),(10, 89),(10, 90),(10, 91),(10, 92),(10, 93),(10, 94),(10, 95),(10, 96),(10, 97),(10, 98),(10, 99),(10, 101),(10, 103),(10, 104),(10, 105),(10, 106),(10, 109),(10, 110),(10, 111),(10, 112),(10, 113),(10, 114),(10, 115),(10, 116),(10, 117),(10, 121),(10, 122),(10, 123),(10, 124),(10, 125),(10, 126),(10, 127),(10, 129),(10, 130),(10, 131),(10, 132),(10, 133),(10, 134),(10, 135),(10, 136),(10, 137),(10, 138),(10, 139),(10, 140),(10, 144),(10, 145),(10, 146),(10, 147),(10, 148),(10, 149),(10, 150),(10, 151),(10, 152),(10, 153),(10, 154),(10, 155),(10, 156),(10, 157),(10, 159),(10, 160),(10, 162),(10, 163),(10, 165),(10, 166),(10, 168),(10, 169),(10, 171),(10, 172),(10, 174),(10, 175),(10, 177),(10, 178),(10, 180),(10, 181),(10, 183),(10, 189),(10, 190),(10, 191),(10, 192),(10, 193),(10, 194),(10, 195),(10, 196),(10, 197),(10, 198),(10, 199),(10, 200),(10, 201),(10, 202),(10, 203),(10, 204),(10, 205),(10, 206),(10, 207),(10, 208),(10, 210),(10, 211),(10, 216),(10, 217),(10, 218),(10, 219),(10, 220),(10, 221),(10, 222),(10, 223),(10, 224),(10, 225),(10, 226),(10, 227),(10, 228),(10, 229),(10, 230),(10, 231),(10, 232),(10, 234),(10, 235),(10, 237),(10, 238),(10, 240),(10, 241),(10, 243),(10, 244),(10, 246),(10, 247),(10, 249),(10, 250),(10, 257),(10, 258),(10, 259),(10, 260),(10, 261),(10, 262),(10, 263),(10, 264),(10, 266),(10, 267),(10, 269),(10, 270),(10, 272),(10, 273),(10, 275),(10, 276),(10, 283),(10, 284),(10, 285),(10, 286),(10, 287),(10, 288),(10, 289),(10, 290),(10, 291),(10, 292),(10, 293),(10, 294),(10, 295),(10, 296),(10, 297),(10, 298),(10, 299),(10, 300),(10, 301),(10, 302),(10, 303),(10, 304),(10, 305),(10, 306),(10, 307),(10, 308),(10, 309),(10, 310),(10, 311),(10, 313),(10, 314),(10, 316),(10, 317),(10, 319),(10, 320),(10, 321),(10, 322),(10, 323),(10, 324),(10, 330),(10, 332),(10, 333),(10, 334),(10, 335),(10, 336),(10, 338),(10, 340),(10, 341),(10, 342),(10, 344),(10, 345),(10, 346),(10, 347),(10, 348),(10, 350),(10, 351),(10, 352),(10, 355),(10, 356),(10, 357),(10, 363),(10, 364),(10, 365),(10, 366),(10, 367),(10, 368),(10, 369),(10, 370),(10, 371),(10, 372),(10, 373),(10, 374),(10, 375),(10, 376),(10, 377),(10, 378),(10, 379),(10, 380),(10, 384),(10, 385),(10, 386),(10, 387),(10, 388),(10, 389),(10, 390),(10, 391),(10, 392),(10, 393),(10, 394),(10, 395),(10, 396),(10, 397),(10, 398),(10, 399),(10, 400),(10, 401),(10, 402),(10, 403),(10, 404),(10, 405),(10, 406),(10, 407),(10, 408),(10, 409),(10, 410),(10, 411),(10, 412),(10, 413),(10, 414),(10, 415),(10, 416),(10, 443),(10, 444),(10, 446),(10, 449),(10, 451),(10, 477),(10, 478),(10, 479),(10, 480),(10, 481),(10, 482),(10, 483),(10, 484),(10, 485),(10, 486),(10, 487),(10, 488),(10, 489),(10, 490),(10, 491),(10, 492),(10, 493),(10, 494),(10, 495),(10, 496),(10, 525),(10, 526),(20, 80),(20, 83),(20, 228),(20, 229),(20, 230),(20, 330),(20, 355),(20, 356),(20, 477),(20, 478),(20, 479),(20, 480),(20, 481),(20, 482),(20, 483),(20, 484),(20, 485),(20, 486),(20, 487),(20, 488),(20, 489),(20, 490),(20, 491),(20, 492),(20, 493),(20, 494),(20, 495),(20, 496),(20, 526),(30, 1),(30, 6),(30, 44),(30, 45),(30, 46),(30, 47),(30, 62),(30, 63),(30, 64),(30, 65),(30, 80),(30, 83),(30, 85),(30, 88),(30, 89),(30, 90),(30, 91),(30, 92),(30, 93),(30, 94),(30, 95),(30, 96),(30, 97),(30, 98),(30, 99),(30, 101),(30, 103),(30, 104),(30, 105),(30, 106),(30, 109),(30, 110),(30, 111),(30, 112),(30, 113),(30, 114),(30, 115),(30, 116),(30, 117),(30, 121),(30, 122),(30, 123),(30, 124),(30, 125),(30, 126),(30, 127),(30, 129),(30, 130),(30, 131),(30, 132),(30, 133),(30, 134),(30, 135),(30, 136),(30, 137),(30, 138),(30, 139),(30, 140),(30, 145),(30, 148),(30, 151),(30, 154),(30, 156),(30, 157),(30, 159),(30, 160),(30, 162),(30, 163),(30, 165),(30, 166),(30, 168),(30, 169),(30, 171),(30, 172),(30, 174),(30, 175),(30, 177),(30, 178),(30, 180),(30, 181),(30, 190),(30, 193),(30, 196),(30, 199),(30, 202),(30, 205),(30, 207),(30, 208),(30, 210),(30, 211),(30, 217),(30, 220),(30, 223),(30, 226),(30, 228),(30, 229),(30, 230),(30, 231),(30, 232),(30, 234),(30, 235),(30, 237),(30, 238),(30, 240),(30, 241),(30, 243),(30, 244),(30, 246),(30, 247),(30, 249),(30, 250),(30, 258),(30, 261),(30, 263),(30, 264),(30, 266),(30, 267),(30, 269),(30, 270),(30, 272),(30, 273),(30, 275),(30, 276),(30, 284),(30, 287),(30, 290),(30, 293),(30, 296),(30, 299),(30, 302),(30, 305),(30, 308),(30, 310),(30, 311),(30, 313),(30, 314),(30, 316),(30, 317),(30, 320),(30, 323),(30, 330),(30, 332),(30, 333),(30, 334),(30, 335),(30, 336),(30, 338),(30, 340),(30, 341),(30, 342),(30, 344),(30, 345),(30, 346),(30, 347),(30, 348),(30, 350),(30, 351),(30, 352),(30, 356),(30, 364),(30, 367),(30, 370),(30, 373),(30, 376),(30, 379),(30, 385),(30, 388),(30, 391),(30, 394),(30, 397),(30, 400),(30, 403),(30, 406),(30, 409),(30, 412),(30, 415),(30, 443),(30, 444),(30, 446),(30, 449),(30, 451),(30, 477),(30, 478),(30, 479),(30, 480),(30, 481),(30, 482),(30, 483),(30, 484),(30, 485),(30, 486),(30, 487),(30, 488),(30, 489),(30, 490),(30, 491),(30, 492),(30, 493),(30, 494),(30, 495),(30, 496),(30, 526),(410, 44),(410, 45),(410, 46),(410, 47),(410, 80),(410, 94),(410, 95),(410, 96),(410, 97),(410, 98),(410, 99),(410, 101),(410, 103),(410, 104),(410, 144),(410, 145),(410, 147),(410, 148),(410, 150),(410, 151),(410, 153),(410, 154),(410, 156),(410, 157),(410, 159),(410, 160),(410, 162),(410, 163),(410, 165),(410, 166),(410, 168),(410, 169),(410, 171),(410, 172),(410, 174),(410, 175),(410, 177),(410, 178),(410, 180),(410, 181),(410, 228),(410, 230),(410, 443),(410, 444),(410, 446),(410, 449),(410, 477),(410, 478),(410, 479),(410, 491),(410, 492),(410, 526),(411, 1),(411, 25),(411, 26),(411, 27),(411, 28),(411, 44),(411, 45),(411, 46),(411, 47),(411, 94),(411, 95),(411, 96),(411, 97),(411, 98),(411, 99),(411, 101),(411, 103),(411, 104),(411, 141),(411, 144),(411, 145),(411, 147),(411, 148),(411, 150),(411, 151),(411, 153),(411, 154),(411, 156),(411, 157),(411, 159),(411, 160),(411, 162),(411, 163),(411, 165),(411, 166),(411, 168),(411, 169),(411, 171),(411, 172),(411, 174),(411, 175),(411, 177),(411, 178),(411, 180),(411, 181),(411, 443),(411, 444),(411, 446),(411, 449),(411, 477),(412, 44),(412, 45),(412, 46),(412, 47),(412, 154),(412, 449),(412, 477),(412, 526),(413, 154),(413, 449),(413, 477),(413, 526),(414, 44),(414, 45),(414, 46),(414, 47),(414, 144),(414, 145),(414, 147),(414, 148),(414, 150),(414, 151),(414, 153),(414, 154),(414, 443),(414, 444),(414, 446),(414, 449),(414, 477),(414, 526),(420, 62),(420, 63),(420, 64),(420, 65),(420, 80),(420, 216),(420, 217),(420, 219),(420, 220),(420, 222),(420, 223),(420, 225),(420, 226),(420, 229),(420, 330),(420, 350),(420, 351),(420, 352),(420, 355),(420, 356),(420, 408),(420, 409),(420, 410),(420, 411),(420, 412),(420, 413),(420, 414),(420, 415),(420, 416),(420, 477),(420, 484),(420, 485),(420, 486),(420, 487),(420, 525),(421, 1),(421, 25),(421, 26),(421, 27),(421, 62),(421, 63),(421, 64),(421, 65),(421, 216),(421, 217),(421, 219),(421, 220),(421, 222),(421, 223),(421, 225),(421, 226),(421, 330),(421, 355),(421, 356),(421, 408),(421, 409),(421, 410),(421, 411),(421, 412),(421, 413),(421, 414),(421, 415),(421, 416),(421, 477),(421, 525),(422, 330),(422, 355),(422, 356),(422, 408),(422, 409),(422, 410),(422, 411),(422, 412),(422, 413),(422, 414),(422, 415),(422, 416),(422, 477),(422, 525),(423, 25),(423, 26),(423, 62),(423, 63),(423, 64),(423, 65),(423, 216),(423, 217),(423, 219),(423, 220),(423, 222),(423, 223),(423, 225),(423, 226),(423, 330),(423, 355),(423, 356),(423, 477),(430, 1),(430, 6),(430, 44),(430, 45),(430, 46),(430, 47),(430, 62),(430, 63),(430, 64),(430, 65),(430, 80),(430, 83),(430, 88),(430, 89),(430, 90),(430, 91),(430, 92),(430, 93),(430, 94),(430, 95),(430, 96),(430, 97),(430, 98),(430, 99),(430, 101),(430, 103),(430, 104),(430, 105),(430, 106),(430, 109),(430, 110),(430, 111),(430, 112),(430, 113),(430, 114),(430, 115),(430, 116),(430, 117),(430, 121),(430, 122),(430, 123),(430, 124),(430, 125),(430, 126),(430, 127),(430, 129),(430, 130),(430, 131),(430, 132),(430, 133),(430, 134),(430, 135),(430, 136),(430, 137),(430, 138),(430, 139),(430, 140),(430, 228),(430, 229),(430, 230),(430, 330),(430, 332),(430, 333),(430, 334),(430, 335),(430, 336),(430, 338),(430, 340),(430, 341),(430, 342),(430, 344),(430, 345),(430, 346),(430, 347),(430, 348),(430, 477),(430, 478),(430, 479),(430, 480),(430, 481),(430, 482),(430, 483),(430, 484),(430, 485),(430, 486),(430, 487),(430, 488),(430, 489),(430, 490),(430, 491),(430, 492),(430, 493),(430, 494),(430, 495),(430, 496),(430, 525),(431, 44),(431, 45),(431, 46),(431, 47),(431, 62),(431, 63),(431, 64),(431, 65),(431, 80),(431, 83),(431, 88),(431, 89),(431, 90),(431, 91),(431, 92),(431, 93),(431, 101),(431, 103),(431, 104),(431, 105),(431, 106),(431, 121),(431, 122),(431, 123),(431, 124),(431, 125),(431, 126),(431, 127),(431, 129),(431, 130),(431, 131),(431, 132),(431, 133),(431, 134),(431, 135),(431, 136),(431, 137),(431, 228),(431, 229),(431, 230),(431, 330),(431, 332),(431, 333),(431, 334),(431, 335),(431, 336),(431, 338),(431, 340),(431, 341),(431, 342),(431, 344),(431, 345),(431, 346),(431, 347),(431, 348),(431, 477),(431, 478),(431, 479),(431, 484),(431, 485),(431, 486),(431, 487),(431, 491),(431, 492),(440, 1),(440, 6),(440, 80),(440, 129),(440, 130),(440, 131),(440, 132),(440, 133),(440, 134),(440, 135),(440, 136),(440, 137),(440, 138),(440, 139),(440, 140),(440, 228),(440, 230),(440, 283),(440, 284),(440, 286),(440, 287),(440, 289),(440, 290),(440, 292),(440, 293),(440, 295),(440, 296),(440, 298),(440, 299),(440, 301),(440, 302),(440, 304),(440, 305),(440, 307),(440, 308),(440, 310),(440, 311),(440, 313),(440, 314),(440, 316),(440, 317),(440, 477),(440, 483),(440, 496),(440, 526),(441, 1),(441, 9),(441, 25),(441, 26),(441, 27),(441, 129),(441, 130),(441, 131),(441, 132),(441, 133),(441, 134),(441, 135),(441, 136),(441, 137),(441, 138),(441, 139),(441, 140),(441, 141),(441, 283),(441, 284),(441, 286),(441, 287),(441, 289),(441, 290),(441, 292),(441, 293),(441, 295),(441, 296),(441, 298),(441, 299),(441, 301),(441, 302),(441, 304),(441, 305),(441, 307),(441, 308),(441, 310),(441, 311),(441, 313),(441, 314),(441, 316),(441, 317),(441, 477),(442, 129),(442, 130),(442, 131),(442, 132),(442, 133),(442, 134),(442, 135),(442, 136),(442, 137),(442, 290),(442, 292),(442, 293),(442, 295),(442, 296),(442, 298),(442, 299),(442, 301),(442, 302),(442, 304),(442, 305),(442, 307),(442, 308),(442, 477),(442, 526),(443, 129),(443, 130),(443, 131),(443, 132),(443, 133),(443, 134),(443, 135),(443, 136),(443, 137),(443, 283),(443, 284),(443, 286),(443, 287),(443, 290),(443, 292),(443, 293),(443, 295),(443, 296),(443, 298),(443, 299),(443, 301),(443, 302),(443, 307),(443, 308),(443, 477),(443, 526),(450, 1),(450, 6),(450, 80),(450, 83),(450, 84),(450, 85),(450, 88),(450, 89),(450, 90),(450, 91),(450, 92),(450, 93),(450, 109),(450, 110),(450, 111),(450, 112),(450, 113),(450, 114),(450, 115),(450, 116),(450, 117),(450, 121),(450, 122),(450, 123),(450, 124),(450, 125),(450, 126),(450, 127),(450, 189),(450, 190),(450, 192),(450, 193),(450, 195),(450, 196),(450, 198),(450, 199),(450, 201),(450, 202),(450, 204),(450, 205),(450, 207),(450, 208),(450, 210),(450, 211),(450, 228),(450, 230),(450, 231),(450, 232),(450, 234),(450, 235),(450, 237),(450, 238),(450, 240),(450, 241),(450, 243),(450, 244),(450, 246),(450, 247),(450, 249),(450, 250),(450, 257),(450, 258),(450, 260),(450, 261),(450, 263),(450, 264),(450, 266),(450, 267),(450, 269),(450, 270),(450, 272),(450, 273),(450, 275),(450, 276),(450, 451),(450, 477),(450, 480),(450, 481),(450, 482),(450, 493),(450, 494),(450, 495),(450, 526),(451, 1),(451, 25),(451, 26),(451, 27),(451, 83),(451, 84),(451, 85),(451, 88),(451, 89),(451, 90),(451, 91),(451, 92),(451, 93),(451, 109),(451, 110),(451, 111),(451, 112),(451, 113),(451, 114),(451, 115),(451, 116),(451, 117),(451, 121),(451, 122),(451, 123),(451, 124),(451, 125),(451, 126),(451, 127),(451, 141),(451, 189),(451, 190),(451, 192),(451, 193),(451, 195),(451, 196),(451, 198),(451, 199),(451, 201),(451, 202),(451, 204),(451, 205),(451, 207),(451, 208),(451, 210),(451, 211),(451, 231),(451, 232),(451, 234),(451, 235),(451, 237),(451, 238),(451, 240),(451, 241),(451, 243),(451, 244),(451, 246),(451, 247),(451, 249),(451, 250),(451, 257),(451, 258),(451, 260),(451, 261),(451, 263),(451, 264),(451, 266),(451, 267),(451, 269),(451, 270),(451, 272),(451, 273),(451, 275),(451, 276),(451, 451),(451, 477),(452, 83),(452, 84),(452, 85),(452, 88),(452, 89),(452, 90),(452, 91),(452, 92),(452, 93),(452, 121),(452, 122),(452, 196),(452, 202),(452, 205),(452, 477),(452, 526),(453, 83),(453, 88),(453, 89),(453, 90),(453, 91),(453, 92),(453, 93),(453, 121),(453, 122),(453, 189),(453, 190),(453, 192),(453, 193),(453, 195),(453, 196),(453, 198),(453, 199),(453, 201),(453, 202),(453, 204),(453, 205),(453, 257),(453, 258),(453, 260),(453, 261),(453, 477),(453, 526),(460, 1),(460, 6),(460, 80),(460, 229),(460, 332),(460, 333),(460, 334),(460, 335),(460, 336),(460, 363),(460, 364),(460, 366),(460, 367),(460, 369),(460, 370),(460, 372),(460, 373),(460, 375),(460, 376),(460, 477),(460, 488),(461, 1),(461, 17),(461, 25),(461, 26),(461, 27),(461, 332),(461, 333),(461, 334),(461, 335),(461, 336),(461, 363),(461, 364),(461, 366),(461, 367),(461, 369),(461, 370),(461, 372),(461, 373),(461, 375),(461, 376),(461, 477),(462, 332),(462, 333),(462, 334),(462, 335),(462, 336),(462, 375),(462, 376),(462, 477),(463, 332),(463, 333),(463, 334),(463, 335),(463, 336),(463, 363),(463, 364),(463, 366),(463, 367),(463, 369),(463, 370),(463, 372),(463, 373),(463, 375),(463, 376),(463, 477),(470, 1),(470, 6),(470, 80),(470, 229),(470, 338),(470, 340),(470, 341),(470, 342),(470, 378),(470, 379),(470, 384),(470, 385),(470, 387),(470, 388),(470, 390),(470, 391),(470, 477),(470, 490),(471, 338),(471, 340),(471, 341),(471, 342),(471, 379),(471, 385),(471, 388),(471, 391),(471, 477),(472, 338),(472, 340),(472, 341),(472, 342),(472, 477),(473, 338),(473, 340),(473, 341),(473, 342),(473, 477),(480, 344),(480, 345),(480, 346),(480, 347),(480, 348),(480, 394),(480, 397),(480, 400),(480, 403),(480, 406),(480, 477),(481, 1),(481, 17),(481, 25),(481, 26),(481, 27),(481, 344),(481, 345),(481, 346),(481, 347),(481, 348),(481, 393),(481, 394),(481, 396),(481, 397),(481, 399),(481, 400),(481, 402),(481, 403),(481, 405),(481, 406),(481, 477),(482, 344),(482, 345),(482, 346),(482, 347),(482, 348),(482, 477),(483, 344),(483, 345),(483, 346),(483, 347),(483, 348),(483, 393),(483, 394),(483, 396),(483, 397),(483, 399),(483, 400),(483, 402),(483, 403),(483, 405),(483, 406),(483, 477),(500, 44),(500, 45),(500, 46),(500, 47),(500, 62),(500, 63),(500, 64),(500, 65),(500, 83),(500, 88),(500, 89),(500, 90),(500, 91),(500, 92),(500, 93),(500, 105),(500, 106),(500, 121),(500, 122),(500, 129),(500, 130),(500, 131),(500, 132),(500, 133),(500, 134),(500, 135),(500, 136),(500, 137),(500, 330),(500, 332),(500, 333),(500, 334),(500, 335),(500, 336),(500, 338),(500, 340),(500, 341),(500, 342),(500, 344),(500, 345),(500, 346),(500, 347),(500, 348),(500, 350),(500, 351),(500, 352),(500, 355),(500, 356),(500, 477),(600, 44),(600, 45),(600, 46),(600, 47),(600, 62),(600, 63),(600, 64),(600, 65),(600, 83),(600, 88),(600, 89),(600, 90),(600, 91),(600, 92),(600, 93),(600, 105),(600, 106),(600, 121),(600, 122),(600, 129),(600, 130),(600, 131),(600, 132),(600, 133),(600, 134),(600, 135),(600, 136),(600, 137),(600, 145),(600, 148),(600, 151),(600, 154),(600, 190),(600, 193),(600, 196),(600, 217),(600, 220),(600, 223),(600, 226),(600, 258),(600, 261),(600, 284),(600, 287),(600, 290),(600, 330),(600, 332),(600, 333),(600, 334),(600, 335),(600, 336),(600, 338),(600, 340),(600, 341),(600, 342),(600, 344),(600, 345),(600, 346),(600, 347),(600, 348),(600, 364),(600, 367),(600, 370),(600, 373),(600, 379),(600, 385),(600, 388),(600, 394),(600, 397),(600, 400),(600, 403),(600, 477),(600, 526),(700, 44),(700, 45),(700, 46),(700, 47),(700, 62),(700, 63),(700, 64),(700, 65),(700, 80),(700, 83),(700, 88),(700, 89),(700, 90),(700, 91),(700, 92),(700, 93),(700, 94),(700, 95),(700, 96),(700, 97),(700, 98),(700, 99),(700, 101),(700, 103),(700, 104),(700, 105),(700, 106),(700, 109),(700, 110),(700, 111),(700, 112),(700, 113),(700, 114),(700, 115),(700, 116),(700, 117),(700, 121),(700, 122),(700, 123),(700, 124),(700, 125),(700, 126),(700, 127),(700, 129),(700, 130),(700, 131),(700, 132),(700, 133),(700, 134),(700, 135),(700, 136),(700, 137),(700, 138),(700, 139),(700, 140),(700, 156),(700, 157),(700, 159),(700, 160),(700, 162),(700, 163),(700, 165),(700, 166),(700, 168),(700, 169),(700, 171),(700, 172),(700, 174),(700, 175),(700, 177),(700, 178),(700, 180),(700, 181),(700, 207),(700, 208),(700, 210),(700, 211),(700, 230),(700, 231),(700, 232),(700, 234),(700, 235),(700, 237),(700, 238),(700, 240),(700, 241),(700, 243),(700, 244),(700, 246),(700, 247),(700, 249),(700, 250),(700, 263),(700, 264),(700, 266),(700, 267),(700, 269),(700, 270),(700, 272),(700, 273),(700, 275),(700, 276),(700, 310),(700, 311),(700, 313),(700, 314),(700, 316),(700, 317),(700, 319),(700, 320),(700, 322),(700, 323),(700, 330),(700, 332),(700, 333),(700, 334),(700, 335),(700, 336),(700, 338),(700, 340),(700, 341),(700, 342),(700, 344),(700, 345),(700, 346),(700, 347),(700, 348),(700, 477),(701, 44),(701, 45),(701, 46),(701, 47),(701, 62),(701, 63),(701, 64),(701, 65),(701, 80),(701, 83),(701, 88),(701, 89),(701, 90),(701, 91),(701, 92),(701, 93),(701, 94),(701, 95),(701, 96),(701, 97),(701, 98),(701, 99),(701, 101),(701, 103),(701, 104),(701, 105),(701, 106),(701, 109),(701, 110),(701, 111),(701, 112),(701, 113),(701, 114),(701, 115),(701, 116),(701, 117),(701, 121),(701, 122),(701, 123),(701, 124),(701, 125),(701, 126),(701, 127),(701, 129),(701, 130),(701, 131),(701, 132),(701, 133),(701, 134),(701, 135),(701, 136),(701, 137),(701, 138),(701, 139),(701, 140),(701, 156),(701, 157),(701, 159),(701, 160),(701, 162),(701, 163),(701, 165),(701, 166),(701, 168),(701, 169),(701, 171),(701, 172),(701, 174),(701, 175),(701, 177),(701, 178),(701, 180),(701, 181),(701, 207),(701, 208),(701, 210),(701, 211),(701, 230),(701, 231),(701, 232),(701, 234),(701, 235),(701, 237),(701, 238),(701, 240),(701, 241),(701, 243),(701, 244),(701, 246),(701, 247),(701, 249),(701, 250),(701, 263),(701, 264),(701, 266),(701, 267),(701, 269),(701, 270),(701, 272),(701, 273),(701, 275),(701, 276),(701, 310),(701, 311),(701, 313),(701, 314),(701, 316),(701, 317),(701, 319),(701, 320),(701, 322),(701, 323),(701, 330),(701, 332),(701, 333),(701, 334),(701, 335),(701, 336),(701, 338),(701, 340),(701, 341),(701, 342),(701, 344),(701, 345),(701, 346),(701, 347),(701, 348),(701, 477),(702, 80),(702, 83),(702, 94),(702, 95),(702, 96),(702, 97),(702, 98),(702, 99),(702, 101),(702, 103),(702, 104),(702, 109),(702, 110),(702, 111),(702, 112),(702, 113),(702, 114),(702, 115),(702, 116),(702, 117),(702, 123),(702, 124),(702, 125),(702, 126),(702, 127),(702, 138),(702, 139),(702, 140),(702, 156),(702, 157),(702, 159),(702, 160),(702, 162),(702, 163),(702, 165),(702, 166),(702, 168),(702, 169),(702, 171),(702, 172),(702, 174),(702, 175),(702, 177),(702, 178),(702, 180),(702, 181),(702, 207),(702, 208),(702, 210),(702, 211),(702, 230),(702, 231),(702, 232),(702, 234),(702, 235),(702, 237),(702, 238),(702, 240),(702, 241),(702, 243),(702, 244),(702, 246),(702, 247),(702, 249),(702, 250),(702, 263),(702, 264),(702, 266),(702, 267),(702, 269),(702, 270),(702, 272),(702, 273),(702, 275),(702, 276),(702, 310),(702, 311),(702, 313),(702, 314),(702, 316),(702, 317),(702, 477),(800, 44),(800, 45),(800, 46),(800, 47),(800, 62),(800, 63),(800, 64),(800, 65),(800, 83),(800, 88),(800, 89),(800, 90),(800, 91),(800, 92),(800, 93),(800, 105),(800, 106),(800, 121),(800, 122),(800, 129),(800, 130),(800, 131),(800, 132),(800, 133),(800, 134),(800, 135),(800, 136),(800, 137),(800, 330),(800, 332),(800, 333),(800, 334),(800, 335),(800, 336),(800, 338),(800, 340),(800, 341),(800, 342),(800, 344),(800, 345),(800, 346),(800, 347),(800, 348),(800, 477),(801, 44),(801, 45),(801, 46),(801, 47),(801, 62),(801, 63),(801, 64),(801, 65),(801, 83),(801, 88),(801, 89),(801, 90),(801, 91),(801, 92),(801, 93),(801, 105),(801, 106),(801, 121),(801, 122),(801, 129),(801, 130),(801, 131),(801, 132),(801, 133),(801, 134),(801, 135),(801, 136),(801, 137),(801, 330),(801, 332),(801, 333),(801, 334),(801, 335),(801, 336),(801, 338),(801, 340),(801, 341),(801, 342),(801, 344),(801, 345),(801, 346),(801, 347),(801, 348),(801, 477),(802, 44),(802, 45),(802, 46),(802, 47),(802, 62),(802, 63),(802, 64),(802, 65),(802, 83),(802, 88),(802, 89),(802, 90),(802, 91),(802, 92),(802, 93),(802, 105),(802, 106),(802, 121),(802, 122),(802, 129),(802, 130),(802, 131),(802, 132),(802, 133),(802, 134),(802, 135),(802, 136),(802, 137),(802, 330),(802, 332),(802, 333),(802, 334),(802, 335),(802, 336),(802, 338),(802, 340),(802, 341),(802, 342),(802, 344),(802, 345),(802, 346),(802, 347),(802, 348),(802, 477),(901,25),(901,26),(901,27),(901,28),(900, 25),(900, 26),(900, 27),(900, 28),(1000, 96),(1000, 97),(1000, 98),(1000, 99),(1000, 157),(1000, 175),(1000, 180),(1000, 477),(1000, 526),(1001, 96),(1001, 97),(1001, 98),(1001, 99),(1001, 157),(1001, 175),(1001, 180),(1001, 477),(1001, 526),(1002, 477),(1002, 526),(1003, 477),(1003, 526),(1010, 97),(1010, 98),(1010, 160),(1010, 175),(1010, 180),(1010, 477),(1010, 526),(1011, 97),(1011, 98),(1011, 160),(1011, 175),(1011, 180),(1011, 477),(1011, 526),(1012, 477),(1012, 526),(1013, 477),(1013, 526);");

		$this->patching->exe_script("REPLACE INTO sys_groups (groupid,parent_id,`level`,lft,rgt,`name`,description,`enable`,ordering) VALUES
				(1000,30,5,100,110,'Panmud Gugatan','Paniter Muda Gugatan',1,1),
				(1001,1000,6,101,102,'Meja I Gugatan','Meja I Gugatan',1,2),
				(1002,1000,6,103,104,'Meja II Gugatan','Meja II Gugatan',1,3),
				(1003,1000,6,105,106,'Meja III Gugatan','Meja III Gugatan',1,4),
				(1010,30,5,111,121,'Panmud Permohonan','Paniter Muda Permohonan',1,1),
				(1011,1010,6,112,113,'Meja I Permohonan','Meja I Permohonan',1,2),
				(1012,1010,6,114,115,'Meja II Permohonan','Meja II Permohonan',1,3),
				(1013,1010,6,116,117,'Meja III Permohonan','Meja III Permohonan',1,4),
				(1020, 30, 5, 19, 25, 'Panmud Jinayat', 'Panitera Muda Jinayat', 1, 2),
				(1022, 1020, 6, 22, 23, 'Meja I Jinayat', 'Meja I Jinayat', 1, 3),
				(1023, 1020, 6, 24, 25, 'Meja II Jinayat', 'Meja II Jinayat', 1, 4),
				(1030, 30, 5, 10, 18, 'Panmud Perkara', 'Panitera Muda Perkara', 0, 1),
				(1031, 1030, 6, 11, 12, 'Admin Panitera Perkara', 'Admin Panitera Perkara', 0, 1),
				(1032, 1030, 6, 13, 14, 'Meja I Perkara', 'Meja I Perkara', 0, 2),
				(1033, 1030, 6, 15, 16, 'Meja II Perkara', 'Meja II Perkara', 0, 3),
				(1034, 1030, 6, 17, 18, 'Meja III Perkara', 'Meja III Perkara', 0, 4);");

		$this->patching->exe_script("REPLACE INTO sys_menus (id, menutype, parent_id, level, title, link, params, published, ordering)
				VALUES
				(1, 'mainmenu', NULL, 0, 'Home', 'default', '', 1, 0),
				(2, 'mainmenu', NULL, 0, 'System', '', '', 1, 10),
				(3, 'mainmenu', 2, 1, 'User Management', 'users_list', '', 1, 5),
				(20, 'mainmenu', 2, 1, 'Konfigurasi System', 'configuration', '', 1, 3),
				(37, 'mainmenu', 2, 1, 'Audit Trail', 'audittrail_list', '', 1, 1),
				(64, 'mainmenu', NULL, 0, 'Referensi', '', '', 1, 9),
				(84, 'mainmenu', NULL, 0, 'Laporan', '', '', 1, 7),
				(85, 'mainmenu', 2, 1, 'Manajemen Menu', 'menus_list', '', 1, 9),
				(100, 'mainmenu', 64, 1, 'Ruangan Sidang', 'ruangan_sidang_list', '', 1, 7),
				(106, 'mainmenu', 2012, 2, 'Perdata Umum', 'laporan_perdata', 'varreport_alur_perkara_id=1,2', 1, 1),
				(107, 'mainmenu', NULL, 0, 'Perdata Umum', '', '', 0, 1),
				(108, 'mainmenu', NULL, 0, 'Pidana Umum', '', '', 0, 4),
				(110, 'mainmenu', 2003, 2, 'Register Induk Perkara Permohonan', 'perkara_list', 'varlist_alur_perkara_id=2', 1, 3),
				(111, 'mainmenu', 108, 1, 'Register Induk Perkara Pidana Biasa', 'perkara_list', 'varlist_alur_perkara_id=111', 1, 1),
				(112, 'mainmenu', 108, 1, 'Register Induk Perkara Pidana Singkat', 'perkara_list', 'varlist_alur_perkara_id=112', 1, 2),
				(113, 'mainmenu', 108, 1, 'Register Induk Perkara Pidana Cepat', 'perkara_list', 'varlist_alur_perkara_id=113', 1, 4),
				(114, 'mainmenu', 2003, 2, 'Register Induk Perkara Gugatan', 'perkara_list', 'varlist_alur_perkara_id=1', 1, 1),
				(117, 'mainmenu', 2003, 2, 'Register Permohonan Banding', 'perkara_banding_list', 'varlist_alur_perkara_id=1', 1, 5),
				(118, 'mainmenu', 64, 1, 'Hakim', '', '', 1, 2),
				(119, 'mainmenu', 64, 1, 'Panitera', '', '', 1, 6),
				(120, 'mainmenu', 64, 1, 'Jurusita', 'jurusita_list', '', 1, 4),
				(121, 'mainmenu', 64, 1, 'Mediator', 'mediator_list', '', 1, 5),
				(122, 'mainmenu', 2003, 2, 'Register Permohonan Kasasi', 'perkara_kasasi_list', 'varlist_alur_perkara_id=1,2', 1, 6),
				(123, 'mainmenu', 2003, 2, 'Register Permohonan Peninjauan Kembali', 'perkara_pk_list', 'varlist_alur_perkara_id=1,2', 1, 7),
				(124, 'mainmenu', 2003, 2, 'Register Permohonan Eksekusi', 'perkara_eksekusi_list', 'varlist_alur_perkara_id=1', 1, 8),
				(126, 'mainmenu', 108, 1, 'Register Permohonan Banding', 'perkara_banding_list', 'varlist_alur_perkara_id=111,112,113', 1, 6),
				(127, 'mainmenu', 108, 1, 'Register Permohonan Kasasi', 'perkara_kasasi_list', 'varlist_alur_perkara_id=111,112,113', 1, 7),
				(128, 'mainmenu', 108, 1, 'Register Permohonan Peninjauan Kembali', 'perkara_pk_list', 'varlist_alur_perkara_id=111,112,113', 1, 8),
				(129, 'mainmenu', 108, 1, 'Register Permohonan Grasi', 'perkara_grasi_list', 'varlist_alur_perkara_id=111,112,113', 1, 9),
				(130, 'mainmenu', 135, 2, 'Gugatan', 'jadwal_sidang_list', 'varlist_alur_perkara_id=1', 1, 1),
				(131, 'mainmenu', 135, 2, 'Permohonan', 'jadwal_sidang_list', 'varlist_alur_perkara_id=2', 1, 4),
				(132, 'mainmenu', 84, 1, 'Kepailitan & PKPU', 'laporan_pailit', 'varreport_alur_perkara_id=3,4', 0, 4),
				(133, 'mainmenu', 84, 1, 'Hak Kekayaan Intelektual (HKI)', 'laporan_hki', 'varreport_alur_perkara_id=5', 0, 2),
				(134, 'mainmenu', 84, 1, 'Pengadilan Hubungan Industrial (PHI)', 'laporan_phi', 'varreport_alur_perkara_id=6', 0, 7),
				(135, 'mainmenu', 157, 1, 'Perdata Umum', 'jadwal_sidang_list', 'varlist_alur_perkara_id=1,2,7,8', 0, 1),
				(136, 'mainmenu', 157, 1, 'Pidana Umum', 'jadwal_sidang_list', 'varlist_alur_perkara_id=111,112,113,114,119', 0, 3),
				(137, 'mainmenu', 84, 1, 'Pidana Umum', 'laporan_pidana', 'varreport_alur_perkara_id=111,112,113,114', 0, 17),
				(140, 'mainmenu', 84, 1, 'Tindak Pidana Korupsi', 'laporan_tipikor', 'varreport_alur_perkara_id=115', 0, 18),
				(141, 'mainmenu', 84, 1, 'Perikanan', 'laporan_perikanan', 'varreport_alur_perkara_id=116', 0, 8),
				(142, 'mainmenu', 84, 1, 'Hak Asasi Manusia (HAM)', 'laporan_ham', 'varreport_alur_perkara_id=117', 0, 1),
				(145, 'mainmenu', 108, 1, 'Register Induk Perkara Lalu-Lintas', 'perkara_lalulintas_list', 'varlist_alur_perkara_id=114', 1, 5),
				(146, 'mainmenu', NULL, 0, 'Perdata Khusus', '', 'varlist_alur_perkara_id=3,4,5,6', 0, 3),
				(147, 'mainmenu', NULL, 0, 'Pidana Khusus', '', 'varlist_alur_perkara_id=115,116,117', 0, 5),
				(148, 'mainmenu', 146, 1, 'Pengadilan Hubungan Industrial (PHI)', 'perkara_list', 'varlist_alur_perkara_id=6', 1, 3),
				(149, 'mainmenu', 146, 1, 'Kepailitan & PKPU', '', 'varlist_alur_perkara_id=3,4', 1, 1),
				(150, 'mainmenu', 2006, 3, 'Register Induk Kepailitan', 'perkara_list', 'varlist_alur_perkara_id=3', 1, 1),
				(151, 'mainmenu', 146, 1, 'Hak Kekayaan Intelektual (HKI)', 'perkara_list', 'varlist_alur_perkara_id=5', 1, 2),
				(152, 'mainmenu', 2006, 3, 'Register Induk PKPU', 'perkara_list', 'varlist_alur_perkara_id=4', 1, 2),
				(154, 'mainmenu', 147, 1, 'Tindak Pidana Korupsi (Tipikor)', 'perkara_list', 'varlist_alur_perkara_id=115', 1, 4),
				(155, 'mainmenu', 147, 1, 'Perikanan', 'perkara_list', 'varlist_alur_perkara_id=116', 1, 3),
				(156, 'mainmenu', 147, 1, 'Hak Asasi Manusia (HAM)', 'perkara_list', 'varlist_alur_perkara_id=117', 1, 2),
				(157, 'mainmenu', NULL, 0, 'Jadwal Sidang', 'jadwal_sidang_list', 'varlist_alur_perkara_id=1,2,3,4,5,6,7,8,9,10,11,12,13,14,111,112,113,114,115,116,117,118,119,120,121,122,123', 1, 8),
				(158, 'mainmenu', 118, 2, 'Hakim Tingkat Pertama', 'hakim_pn_list', '', 1, 1),
				(159, 'mainmenu', 118, 2, 'Hakim Tinggi', 'hakim_pt_list', '', 1, 2),
				(160, 'mainmenu', 118, 2, 'Hakim Agung', 'hakim_ma_list', '', 1, 3),
				(164, 'mainmenu', 2006, 3, 'Register Permohonan Kasasi Kepailitan', 'perkara_kasasi_list', 'varlist_alur_perkara_id=3,4', 1, 3),
				(165, 'mainmenu', 2006, 3, 'Register Permohonan Peninjauan Kembali Kepailitan', 'perkara_pk_list', 'varlist_alur_perkara_id=3,4', 1, 4),
				(166, 'mainmenu', 2006, 3, 'Register Penyitaan Kepailitan', 'perkara_penyitaan_list', 'varlist_alur_perkara_id=3,4', 1, 5),
				(167, 'mainmenu', 2006, 3, 'Register Pemberesan Harta Pailit', 'perkara_harta_pailit_list', 'varlist_alur_perkara_id=3,4', 1, 6),
				(168, 'mainmenu', 2006, 3, 'Register Actio Pauliana', 'perkara_actio_pauliana_list', '', 1, 7),
				(169, 'mainmenu', 2006, 3, 'Register Rehabilitasi', 'perkara_rehabilitasi_list', '', 1, 8),
				(170, 'mainmenu', 2006, 3, 'Register Kurator', 'kurator_list', '', 1, 9),
				(171, 'mainmenu', 2006, 3, 'Register Pengurus', '', '', 1, 10),
				(172, 'mainmenu', 2006, 3, 'Register Penyegelan', 'perkara_penyegelan_list', '', 1, 11),
				(173, 'mainmenu', 151, 2, 'Register Induk Perkara HKI', 'perkara_list', 'varlist_alur_perkara_id=5', 1, 1),
				(174, 'mainmenu', 151, 2, 'Register Permohonan Kasasi HKI', 'perkara_kasasi_list', 'varlist_alur_perkara_id=5', 1, 2),
				(175, 'mainmenu', 151, 2, 'Register Permohonan Peninjauan Kembali HKI', 'perkara_pk_list', 'varlist_alur_perkara_id=5', 1, 3),
				(176, 'mainmenu', 148, 2, 'Register Induk Perkara Gugatan PHI', 'perkara_list', 'varlist_alur_perkara_id=6', 1, 1),
				(177, 'mainmenu', 148, 2, 'Register Permohonan Kasasi PHI', 'perkara_kasasi_list', 'varlist_alur_perkara_id=6', 1, 2),
				(178, 'mainmenu', 148, 2, 'Register Permohonan Peninjauan Kembali PHI', 'perkara_pk_list', 'varlist_alur_perkara_id=6', 1, 3),
				(179, 'mainmenu', 148, 2, 'Register Eksekusi PHI', 'perkara_eksekusi_list', 'varlist_alur_perkara_id=6', 1, 4),
				(180, 'mainmenu', 148, 2, 'Register Penyitaan PHI', 'perkara_penyitaan_list', 'varlist_alur_perkara_id=6', 1, 5),
				(181, 'mainmenu', 148, 2, 'Register Pendaftaran Perjanjian Bersama Bipartit', '', '', 1, 6),
				(182, 'mainmenu', 148, 2, 'Register Pendaftaran Perjanjian Bersama Mediasi', '', '', 1, 7),
				(183, 'mainmenu', 148, 2, 'Register Pendaftaran Perjanjian Bersama Konsiliasi', '', '', 1, 8),
				(184, 'mainmenu', 148, 2, 'Register Pendaftaran Putusan Arbitrase', '', '', 1, 9),
				(185, 'mainmenu', 148, 2, 'Register Pendaftaran Akta Perdamaian Arbitrase', '', '', 1, 10),
				(186, 'mainmenu', 154, 2, 'Register Induk Perkara Korupsi', 'perkara_list', 'varlist_alur_perkara_id=115', 1, 1),
				(187, 'mainmenu', 154, 2, 'Register Permohonan Banding', 'perkara_banding_list', 'varlist_alur_perkara_id=115', 1, 2),
				(188, 'mainmenu', 154, 2, 'Register Permohonan Kasasi', 'perkara_kasasi_list', 'varlist_alur_perkara_id=115', 1, 3),
				(189, 'mainmenu', 154, 2, 'Register Permohonan Peninjauan Kembali', 'perkara_pk_list', 'varlist_alur_perkara_id=115', 1, 4),
				(190, 'mainmenu', 154, 2, 'Register Permohonan Grasi', 'perkara_grasi_list', 'varlist_alur_perkara_id=115', 1, 5),
				(191, 'mainmenu', 155, 2, 'Register Induk Perkara Perikanan', 'perkara_list', 'varlist_alur_perkara_id=116', 1, 1),
				(192, 'mainmenu', 155, 2, 'Register Permohonan Banding', 'perkara_banding_list', 'varlist_alur_perkara_id=116', 1, 2),
				(193, 'mainmenu', 155, 2, 'Register Permohonan Kasasi', 'perkara_kasasi_list', 'varlist_alur_perkara_id=116', 1, 3),
				(194, 'mainmenu', 155, 2, 'Register Permohonan Grasi', 'perkara_grasi_list', 'varlist_alur_perkara_id=116', 1, 5),
				(195, 'mainmenu', 156, 2, 'Register Induk Perkara HAM', 'perkara_list', 'varlist_alur_perkara_id=117', 1, 1),
				(196, 'mainmenu', 156, 2, 'Register Permohonan Banding', 'perkara_banding_list', 'varlist_alur_perkara_id=117', 1, 2),
				(197, 'mainmenu', 156, 2, 'Register Permohonan Kasasi', 'perkara_kasasi_list', 'varlist_alur_perkara_id=117', 1, 3),
				(198, 'mainmenu', 156, 2, 'Register Permohonan Peninjauan Kembali', 'perkara_pk_list', 'varlist_alur_perkara_id=117', 1, 4),
				(199, 'mainmenu', 156, 2, 'Register Permohonan Grasi', 'perkara_grasi_list', 'varlist_alur_perkara_id=117', 1, 5),
				(200, 'mainmenu', 2004, 2, 'Jurnal Perkara Gugatan', 'jurnal_perkara_list', 'varlist_alur_perkara_id=1;var_tahapan_id=10', 1, 1),
				(201, 'mainmenu', 2004, 2, 'Jurnal Perkara Permohonan', 'jurnal_perkara_list', 'varlist_alur_perkara_id=2;var_tahapan_id=10', 1, 4),
				(202, 'mainmenu', 2004, 2, 'Jurnal Permohonan Banding', 'jurnal_banding_list', 'varlist_alur_perkara_id=1;var_tahapan_id=20', 1, 5),
				(203, 'mainmenu', 2004, 2, 'Jurnal Permohonan Kasasi', 'jurnal_kasasi_list', 'varlist_alur_perkara_id=1,2;var_tahapan_id=30', 1, 6),
				(204, 'mainmenu', 2004, 2, 'Jurnal Permohonan Peninjauan Kembali', 'jurnal_pk_list', 'varlist_alur_perkara_id=1,2;var_tahapan_id=40', 1, 7),
				(205, 'mainmenu', 2004, 2, 'Jurnal Permohonan Eksekusi', 'jurnal_eksekusi_list', 'varlist_alur_perkara_id=1,2;var_tahapan_id=50', 1, 8),
				(207, 'mainmenu', 2005, 2, 'Buku Induk Keuangan Perkara Perdata', 'jurnal_induk_list', 'varlist_alur_perkara_id=1,2', 1, 3),
				(208, 'mainmenu', 2005, 2, 'Buku Keuangan Biaya Eksekusi', '', '', 0, 1),
				(209, 'mainmenu', 2005, 2, 'Buku Induk Penerimaan Uang Hak-hak Kepaniteraan', 'jurnal_hkk_list', 'varlist_alur_perkara_id=1,2', 1, 2),
				(213, 'mainmenu', 2007, 3, 'Jurnal Perkara Kepailitan', 'jurnal_perkara_list', 'varlist_alur_perkara_id=3;var_tahapan_id=10', 1, 1),
				(214, 'mainmenu', 2007, 3, 'Jurnal Perkara PKPU', 'jurnal_perkara_list', 'varlist_alur_perkara_id=4;var_tahapan_id=10', 1, 2),
				(215, 'mainmenu', 2007, 3, 'Jurnal Permohonan Kasasi', 'jurnal_kasasi_list', 'varlist_alur_perkara_id=3,4;var_tahapan_id=30', 1, 3),
				(216, 'mainmenu', 2007, 3, 'Jurnal Permohonan Peninjauan Kembali', 'jurnal_pk_list', 'varlist_alur_perkara_id=3,4;var_tahapan_id=40', 1, 4),
				(217, 'mainmenu', 2007, 3, 'Jurnal Permohonan Actio Pauliana', '', '', 1, 5),
				(218, 'mainmenu', 2007, 3, 'Jurnal Permohonan Rehabilitasi', '', '', 1, 6),
				(219, 'mainmenu', 2008, 3, 'Buku Induk Keuangan Perkara Perdata Kepailitan & PKPU', 'jurnal_induk_list', 'varlist_alur_perkara_id=3,4', 1, 1),
				(220, 'mainmenu', 2008, 3, 'Buku Keuangan Biaya Eksekusi', '', '', 0, 2),
				(221, 'mainmenu', 2008, 3, 'Buku Induk Penerimaan Uang Hak-hak Kepaniteraan', 'jurnal_hkk_list', 'varlist_alur_perkara_id=3,4', 1, 3),
				(222, 'mainmenu', 151, 2, 'Jurnal Keuangan Perkara HKI', 'jurnal_perkara_list', 'varlist_alur_perkara_id=5;var_tahapan_id=10', 1, 4),
				(223, 'mainmenu', 151, 2, 'Jurnal Keuangan Pemohonan Kasasi Perkara HKI', 'jurnal_kasasi_list', 'varlist_alur_perkara_id=5;var_tahapan_id=30', 1, 5),
				(224, 'mainmenu', 151, 2, 'Jurnal Keuangan Permohonan PK Perkara HKI', 'jurnal_pk_list', 'varlist_alur_perkara_id=5;var_tahapan_id=40', 1, 6),
				(225, 'mainmenu', 151, 2, 'Buku Induk Keuangan Perkara HKI', 'jurnal_induk_list', 'varlist_alur_perkara_id=5', 1, 7),
				(226, 'mainmenu', 151, 2, 'Buku Induk Penerimaan Uang Hak-hak Kepaniteraan', 'jurnal_hkk_list', 'varlist_alur_perkara_id=5', 1, 8),
				(227, 'mainmenu', 148, 2, 'Jurnal Keuangan Perkara Gugatan PHI', 'jurnal_perkara_list', 'varlist_alur_perkara_id=6;var_tahapan_id=10', 1, 11),
				(228, 'mainmenu', 148, 2, 'Jurnal Keuangan Pemohonan Kasasi Perkara PHI', 'jurnal_kasasi_list', 'varlist_alur_perkara_id=6;var_tahapan_id=30', 1, 12),
				(229, 'mainmenu', 148, 2, 'Jurnal Keuangan Permohonan PK Perkara PHI', 'jurnal_pk_list', 'varlist_alur_perkara_id=6;var_tahapan_id=40', 1, 13),
				(230, 'mainmenu', 148, 2, 'Jurnal Keuangan Eksekusi Perkara PHI', 'jurnal_perkara_list', 'varlist_alur_perkara_id=6;var_tahapan_id=50', 1, 14),
				(231, 'mainmenu', 148, 2, 'Buku Induk Keuangan Perkara PHI', 'jurnal_induk_list', 'varlist_alur_perkara_id=6', 1, 15),
				(232, 'mainmenu', 148, 2, 'Buku Induk Penerimaan Uang HHK', 'jurnal_hkk_list', 'varlist_alur_perkara_id=6', 1, 16),
				(233, 'mainmenu', 108, 1, 'Register Penahanan Pidana Umum', 'penahanan_list', 'varlist_alur_perkara_id=111,112', 1, 10),
				(234, 'mainmenu', 154, 2, 'Register Penahanan Tipikor', 'penahanan_list', 'varlist_alur_perkara_id=115', 1, 6),
				(235, 'mainmenu', 155, 2, 'Register Penahanan Perikanan', 'penahanan_list', 'varlist_alur_perkara_id=116', 1, 6),
				(236, 'mainmenu', 156, 2, 'Register Penahanan HAM', 'penahanan_list', 'varlist_alur_perkara_id=117', 1, 6),
				(237, 'mainmenu', 155, 2, 'Register Permohonan Peninjauan Kembali', 'perkara_pk_list', 'varlist_alur_perkara_id=116', 1, 4),
				(238, 'mainmenu', 64, 1, 'Biaya Perkara', 'ref_biaya_perkara_list', '', 1, 1),
				(239, 'mainmenu', 119, 2, 'Panitera Tingkat Pertama', 'panitera_pn_list', '', 1, 1),
				(240, 'mainmenu', 119, 2, 'Panitera Pengadilan Tinggi', 'panitera_pt_list', '', 1, 2),
				(241, 'mainmenu', 119, 2, 'Panitera Mahkamah Agung', 'panitera_ma_list', '', 1, 3),
				(243, 'mainmenu', 64, 1, 'Hari Libur', 'hari_libur_list', '', 1, 3),
				(248, 'mainmenu', 136, 2, 'Pidana Biasa', 'jadwal_sidang_list', 'varlist_alur_perkara_id=111', 1, 1),
				(249, 'mainmenu', 136, 2, 'Pidana Singkat', 'jadwal_sidang_list', 'varlist_alur_perkara_id=112', 1, 4),
				(250, 'mainmenu', 136, 2, 'Pidana Cepat', 'jadwal_sidang_list', 'varlist_alur_perkara_id=113', 1, 2),
				(251, 'mainmenu', 136, 2, 'Pidana Lalulintas', 'jadwal_sidang_list', 'varlist_alur_perkara_id=114', 1, 3),
				(252, 'mainmenu', 157, 1, 'Perdata Khusus', 'jadwal_sidang_list', 'varlist_alur_perkara_id=3,4,5,6', 0, 2),
				(253, 'mainmenu', 157, 1, 'Pidana Khusus', 'jadwal_sidang_list', 'varlist_alur_perkara_id=115,116,117,118', 0, 4),
				(254, 'mainmenu', 252, 2, 'Kepailitan', 'jadwal_sidang_list', 'varlist_alur_perkara_id=3', 1, 2),
				(255, 'mainmenu', 252, 2, 'PKPU', 'jadwal_sidang_list', 'varlist_alur_perkara_id=4', 1, 4),
				(256, 'mainmenu', 252, 2, 'Hak Kekayaan Intelektual (HKI)', 'jadwal_sidang_list', 'varlist_alur_perkara_id=5', 1, 1),
				(257, 'mainmenu', 252, 2, 'Pengadilan Hubungan Industrial (PHI)', 'jadwal_sidang_list', 'varlist_alur_perkara_id=6', 1, 3),
				(258, 'mainmenu', 253, 2, 'Tindak Pidana Korupsi (TIPIKOR)', 'jadwal_sidang_list', 'varlist_alur_perkara_id=115', 1, 4),
				(259, 'mainmenu', 253, 2, 'Perikanan', 'jadwal_sidang_list', 'varlist_alur_perkara_id=116', 1, 2),
				(260, 'mainmenu', 253, 2, 'Hak Asasi Manusia (HAM)', 'jadwal_sidang_list', 'varlist_alur_perkara_id=117', 1, 1),
				(261, 'mainmenu', NULL, 0, 'Peta Situs', 'peta_situs', '', 0, 12),
				(262, 'mainmenu', NULL, 0, 'Pesan', 'pesan_masuk_list', NULL, 1, 11),
				(263, 'mainmenu', 262, 1, 'Pesan Masuk', 'pesan_masuk_list', NULL, 1, 1),
				(264, 'mainmenu', 262, 1, 'Pesan Keluar', 'pesan_keluar_list', NULL, 1, 2),
				(265, 'mainmenu', 2, 1, 'Konfigurasi Saldo Awal', 'saldo_awal_edit', NULL, 1, 4),
				(266, 'mainmenu', 147, 1, 'Pidana Anak', '', '', 0, 1),
				(267, 'mainmenu', 266, 1, 'Register Induk Pidana Anak', 'perkara_list', 'varlist_alur_perkara_id=118', 1, 1),
				(268, 'mainmenu', 84, 1, 'Pidana Anak', 'laporan_pidana_anak', 'varreport_alur_perkara_id=118', 0, 15),
				(269, 'mainmenu', 266, 1, 'Register Penahanan', 'penahanan_list', 'varlist_alur_perkara_id=118', 1, 5),
				(270, 'mainmenu', 84, 1, 'Pidana Praperadilan', 'laporan_pidana', 'varreport_alur_perkara_id=119', 0, 16),
				(300, 'mainmenu', 108, 1, 'Register Induk Perkara Praperadilan', 'perkara_list', 'varlist_alur_perkara_id=119', 1, 3),
				(301, 'mainmenu', 108, 1, 'Register Barang Bukti', 'barang_bukti_list', 'varlist_alur_perkara_id=111,112,113,114,115,116,11', 1, 11),
				(302, 'mainmenu', 2004, 2, 'Jurnal Permohonan Eksekusi Hak Tanggungan', 'jurnal_ht_list', 'varlist_alur_perkara_id=0;var_tahapan_id=51', 1, 9),
				(303, 'mainmenu', 2003, 2, 'Register Permohonan Eksekusi Hak Tanggungan', 'perkara_ht_list', 'varlist_alur_perkara_id=0', 1, 9),
				(401, 'mainmenu', 108, 2, 'Register Induk Pidana Pelanggaran', 'perkara_list', 'varlist_alur_perkara_id=121', 0, 1),
				(402, 'mainmenu', NULL, 0, 'Pidana Militer', '', '', 0, 1),
				(403, 'mainmenu', 402, 1, 'Register Induk Pidana Kejahatan', 'perkara_list', 'varlist_alur_perkara_id=120', 1, 1),
				(404, 'mainmenu', 402, 1, 'Register Induk Pidana Pelangggaran', 'perkara_list', 'varlist_alur_perkara_id=121', 1, 2),
				(405, 'mainmenu', 402, 1, 'Register Permohonan Banding', 'perkara_banding_list', 'varlist_alur_perkara_id=120,121', 1, 3),
				(406, 'mainmenu', 402, 1, 'Register Permohonan Kasasi', 'perkara_kasasi_list', 'varlist_alur_perkara_id=120', 1, 4),
				(407, 'mainmenu', 402, 1, 'Register Permohonan Peninjauan Kembali', 'perkara_pk_list', 'varlist_alur_perkara_id=120', 1, 5),
				(408, 'mainmenu', 402, 1, 'Register Permohonan Grasi', 'perkara_grasi_list', 'varlist_alur_perkara_id=120', 1, 6),
				(409, 'mainmenu', 402, 1, 'Register Penahanan Pidana Militer', 'penahanan_list', 'varlist_alur_perkara_id=120', 1, 8),
				(410, 'mainmenu', 402, 1, 'Register Barang Bukti', 'barang_bukti_list', 'varlist_alur_perkara_id=120', 1, 7),
				(600, 'mainmenu', NULL, 0, 'Jurnal Perkara', '', '', 0, 1),
				(601, 'mainmenu', NULL, 0, 'Register Induk Perkara', '', '', 0, 2),
				(602, 'mainmenu', NULL, 0, 'Register Keuangan', '', '', 0, 3),
				(603, 'mainmenu', 600, 1, 'Jurnal Induk Perkara TUN', 'jurnal_perkara_list', 'varlist_alur_perkara_id=9;var_tahapan_id=10', 0, 1),
				(604, 'mainmenu', 600, 1, 'Jurnal Permohonan UU AP', 'jurnal_perkara_list', 'varlist_alur_perkara_id=10;var_tahapan_id=10', 0, 2),
				(605, 'mainmenu', 600, 1, 'Jurnal Permohonan Keberatan (KIP)', 'jurnal_perkara_list', 'varlist_alur_perkara_id=11;var_tahapan_id=10', 0, 3),
				(606, 'mainmenu', 600, 1, 'Jurnal Permohonan Fiktif Positif', 'jurnal_perkara_list', 'varlist_alur_perkara_id=12;var_tahapan_id=10', 0, 4),
				(607, 'mainmenu', 600, 1, 'Jurnal Permohonan Penyalahgunaan Wewenang', 'jurnal_perkara_list', 'varlist_alur_perkara_id=13;var_tahapan_id=10', 0, 5),
				(608, 'mainmenu', 600, 1, 'Jurnal Banding', 'jurnal_perkara_list', 'varlist_alur_perkara_id=9;var_tahapan_id=20', 0, 7),
				(609, 'mainmenu', 600, 1, 'Jurnal Kasasi', 'jurnal_perkara_list', 'varlist_alur_perkara_id=9;var_tahapan_id=30', 0, 8),
				(610, 'mainmenu', 600, 1, 'Jurnal PK', 'jurnal_perkara_list', 'varlist_alur_perkara_id=9;var_tahapan_id=40', 0, 9),
				(611, 'mainmenu', 600, 1, 'Jurnal Pengawasan Eksekusi', 'jurnal_perkara_list', 'varlist_alur_perkara_id=9;var_tahapan_id=50', 0, 10),
				(612, 'mainmenu', 600, 1, 'Jurnal Permohonan Pertanahan', 'jurnal_perkara_list', 'varlist_alur_perkara_id=14;var_tahapan_id=10', 0, 6),
				(613, 'mainmenu', 601, 1, 'Register Induk Perkara TUN', 'perkara_list', 'varlist_alur_perkara_id=9', 0, 1),
				(614, 'mainmenu', 601, 1, 'Register Permohonan UU AP', 'perkara_list', 'varlist_alur_perkara_id=10', 0, 2),
				(615, 'mainmenu', 601, 1, 'Register Permohonan Keberatan (KIP)', 'perkara_list', 'varlist_alur_perkara_id=11', 0, 3),
				(616, 'mainmenu', 601, 1, 'Register Permohonan Fiktif Positif', 'perkara_list', 'varlist_alur_perkara_id=12', 0, 4),
				(617, 'mainmenu', 601, 1, 'Register Permohonan Penyalahgunaan Wewenang', 'perkara_list', 'varlist_alur_perkara_id=13', 0, 5),
				(618, 'mainmenu', 601, 1, 'Register Permohonan Pertanahan', 'perkara_list', 'varlist_alur_perkara_id=14', 0, 6),
				(619, 'mainmenu', 601, 1, 'Register Banding', 'perkara_banding_list', 'varlist_alur_perkara_id=9', 0, 7),
				(620, 'mainmenu', 601, 1, 'Register Kasasi', 'perkara_kasasi_list', 'varlist_alur_perkara_id=9', 0, 8),
				(621, 'mainmenu', 601, 1, 'Register Peninjauan Kembali', 'perkara_pk_list', 'varlist_alur_perkara_id=9', 0, 9),
				(622, 'mainmenu', 602, 1, 'Buku Hak-Hak Keuangan Kepaniteraan/PNBP', 'jurnal_hkk_list', 'varlist_alur_perkara_id=9,10,11,12,13,14', 0, 1),
				(623, 'mainmenu', 602, 1, 'Buku Induk Keuangan Perkara', 'jurnal_induk_list', 'varlist_alur_perkara_id=9,10,11,12,13,14', 0, 2),
				(624, 'mainmenu', 84, 1, 'Perkara TUN', 'laporan_tun', 'varreport_alur_perkara_id=9', 0, 9),
				(625, 'mainmenu', 84, 1, 'Permohonan UU AP', 'laporan_tun', 'varreport_alur_perkara_id=10', 0, 14),
				(626, 'mainmenu', 84, 1, 'Permohonan Keberatan (KIP)', 'laporan_tun', 'varreport_alur_perkara_id=11', 0, 11),
				(627, 'mainmenu', 84, 1, 'Permohonan Fiktif Positif', 'laporan_tun', 'varreport_alur_perkara_id=12', 0, 10),
				(628, 'mainmenu', 84, 1, 'Permohonan Penyalahgunaan Wewenang', 'laporan_tun', 'varreport_alur_perkara_id=13', 0, 12),
				(629, 'mainmenu', 84, 1, 'Permohonan Pertanahan', 'laporan_tun', 'varreport_alur_perkara_id=14', 0, 13),
				(630, 'mainmenu', 157, 1, 'Gugatan', 'jadwal_sidang_list', 'varlist_alur_perkara_id=9', 0, 5),
				(631, 'mainmenu', 157, 1, 'Permohonan UU AP', 'jadwal_sidang_list', 'varlist_alur_perkara_id=10', 0, 6),
				(632, 'mainmenu', 157, 1, 'Permohonan Keberatan (KIP)', 'jadwal_sidang_list', 'varlist_alur_perkara_id=11', 0, 7),
				(633, 'mainmenu', 157, 1, 'Permohonan Fiktif Positif', 'jadwal_sidang_list', 'varlist_alur_perkara_id=12', 0, 8),
				(634, 'mainmenu', 157, 1, 'Permohonan Penyalahgunaan Wewenang', 'jadwal_sidang_list', 'varlist_alur_perkara_id=13', 0, 9),
				(635, 'mainmenu', 157, 1, 'Permohonan Pertanahan', 'jadwal_sidang_list', 'varlist_alur_perkara_id=14', 0, 10),
				(636, 'mainmenu', 601, 1, 'Register Pengawasan Eksekusi TUN', 'perkara_eksekusi_list', 'varlist_alur_perkara_id=9', 0, 10),
				(700, 'mainmenu', NULL, 0, 'Jurnal Perkara', '', '', 1, 1),
				(701, 'mainmenu', NULL, 0, 'Register Induk Keuangan', '', '', 1, 2),
				(702, 'mainmenu', NULL, 0, 'Perdata', '', '', 1, 3),
				(703, 'mainmenu', 700, 1, 'Jurnal Perkara Gugatan', 'jurnal_perkara_list', 'varlist_alur_perkara_id=15;var_tahapan_id=10', 1, 1),
				(704, 'mainmenu', 700, 1, 'Jurnal Perkara Permohonan', 'jurnal_perkara_list', 'varlist_alur_perkara_id=16;var_tahapan_id=10', 1, 2),
				(705, 'mainmenu', 700, 1, 'Jurnal Permohonan Banding', 'jurnal_banding_list', 'varlist_alur_perkara_id=15;var_tahapan_id=20', 1, 3),
				(706, 'mainmenu', 700, 1, 'Jurnal Permohonan Kasasi', 'jurnal_kasasi_list', 'varlist_alur_perkara_id=15,16;var_tahapan_id=30', 1, 4),
				(707, 'mainmenu', 700, 1, 'Jurnal Permohonan Peninjauan Kembali', 'jurnal_pk_list', 'varlist_alur_perkara_id=15,16;var_tahapan_id=40', 1, 5),
				(708, 'mainmenu', 700, 1, 'Jurnal Permohonan Eksekusi', 'jurnal_eksekusi_list', 'varlist_alur_perkara_id=15;var_tahapan_id=50', 1, 6),
				(709, 'mainmenu', 700, 1, 'Jurnal Permohonan Eksekusi Hak Tanggungan', 'jurnal_ht_list', 'varlist_alur_perkara_id=0;var_tahapan_id=51', 1, 7),
				(710, 'mainmenu', 701, 1, 'Buku Induk Penerimaan Uang Hak-hak Kepaniteraan', 'jurnal_hkk_list', 'varlist_alur_perkara_id=15,16', 1, 1),
				(711, 'mainmenu', 701, 1, 'Buku Induk Keuangan Perkara Perdata', 'jurnal_induk_list', 'varlist_alur_perkara_id=15,16', 1, 3),
				(712, 'mainmenu', 702, 1, 'Register Induk Perkara Gugatan', 'perkara_list', 'varlist_alur_perkara_id=15', 1, 1),
				(713, 'mainmenu', 702, 1, 'Register Induk Perkara Permohonan', 'perkara_list', 'varlist_alur_perkara_id=16', 1, 2),
				(714, 'mainmenu', 702, 1, 'Register Permohonan Banding', 'perkara_banding_list', 'varlist_alur_perkara_id=15', 1, 3),
				(715, 'mainmenu', 702, 1, 'Register Permohonan Kasasi', 'perkara_kasasi_list', 'varlist_alur_perkara_id=15,16', 1, 4),
				(716, 'mainmenu', 702, 1, 'Register Permohonan Peninjauan Kembali', 'perkara_pk_list', 'varlist_alur_perkara_id=15,16', 1, 5),
				(717, 'mainmenu', 702, 1, 'Register Permohonan Eksekusi', 'perkara_eksekusi_list', 'varlist_alur_perkara_id=15', 1, 6),
				(718, 'mainmenu', 702, 1, 'Register Permohonan Eksekusi Hak Tanggungan', 'perkara_ht_list', 'varlist_alur_perkara_id=0', 1, 7),
				(719, 'mainmenu', 84, 1, 'Perdata Agama', 'laporan_agama', 'varreport_alur_perkara_id=15,16', 1, 1),
				(720, 'mainmenu', 84, 1, 'Mediasi', 'laporan_mediasi', '', 1, 2),
				(721, 'mainmenu', 157, 1, 'Sidang Gugatan', 'jadwal_sidang_list', 'varlist_alur_perkara_id=15', 1, 1),
				(722, 'mainmenu', 157, 1, 'Sidang Permohonan', 'jadwal_sidang_list', 'varlist_alur_perkara_id=16', 1, 2),
				(723, 'mainmenu', 157, 1, 'Sidang Jinayat', 'jadwal_sidang_list', 'varlist_alur_perkara_id=122', 0, 2),
				(724, 'mainmenu', 157, 1, 'Sidang Praperadilan', 'jadwal_sidang_list', 'varlist_alur_perkara_id=123', 0, 2),
				(1000, 'mainmenu', 266, 1, 'Register Permohonan Banding', 'perkara_banding_list', 'varlist_alur_perkara_id=118', 1, 2),
				(1001, 'mainmenu', 266, 1, 'Register Permohonan Kasasi', 'perkara_kasasi_list', 'varlist_alur_perkara_id=118', 1, 3),
				(1002, 'mainmenu', 266, 1, 'Register Permohonan Peninjauan Kembali', 'perkara_pk_list', 'varlist_alur_perkara_id=118', 1, 4),
				(1003, 'mainmenu', 2, 1, 'Backup', 'backup', '', 1, 2),
				(1004, 'mainmenu', 253, 2, 'Tindak Pidana Anak', 'jadwal_sidang_list', 'varlist_alur_perkara_id=118', 1, 3),
				(2000, 'mainmenu', NULL, 0, 'Lapor', 'testing_dev_list', '', 1, 14),
				(2001, 'mainmenu', 2003, 2, 'Register Induk Perkara Gugatan Sederhana', 'perkara_list', 'varlist_alur_perkara_id=8', 1, 2),
				(2002, 'mainmenu', 2004, 2, 'Jurnal Perkara Gugatan Sederhana', 'jurnal_perkara_list', 'varlist_alur_perkara_id=8;var_tahapan_id=10', 1, 2),
				(2003, 'mainmenu', 107, 1, 'Register Induk Perkara', '', '', 1, 1),
				(2004, 'mainmenu', 107, 1, 'Jurnal Perkara', '', '', 1, 2),
				(2005, 'mainmenu', 107, 1, 'Register Induk Keuangan', '', '', 1, 3),
				(2006, 'mainmenu', 149, 2, 'Register Induk Perkara', '', '', 1, 1),
				(2007, 'mainmenu', 149, 2, 'Jurnal Keuangan Perkara', '', '', 1, 2),
				(2008, 'mainmenu', 149, 2, 'Register Induk Keuangan', '', '', 1, 3),
				(2010, 'mainmenu', 2012, 2, 'Mediasi', 'laporan_mediasi', '', 1, 1),
				(2011, 'mainmenu', 2012, 2, 'Perkara Gugatan Sederhana', 'laporan_gugatan_sederhana', '', 1, 2),
				(2012, 'mainmenu', 84, 1, 'Laporan Perdata Umum', '', '', 0, 5),
				(2013, 'mainmenu', 135, 2, 'Bantahan (Derden Verzet)', 'jadwal_sidang_list', 'varlist_alur_perkara_id=7', 1, 3),
				(2014, 'mainmenu', 135, 2, 'Gugatan Sederhana', 'jadwal_sidang_list', 'varlist_alur_perkara_id=8', 1, 2),
				(2015, 'mainmenu', 136, 2, 'Praperadilan', 'jadwal_sidang_list', 'varlist_alur_perkara_id=119', 1, 5),
				(2016, 'mainmenu', NULL, 2, 'Delegasi', '', '', 1, 6),
				(2017, 'mainmenu', 2016, 2, 'Delegasi Masuk', 'perkara_list_delegasi', 'var_id=1', 1, 1),
				(2018, 'mainmenu', 2016, 2, 'Delegasi Keluar', 'perkara_list_delegasi', 'var_id=2', 1, 2),
				(2020, 'mainmenu', 84, 0, 'Kejahatan', 'laporan_pid_mil', 'varreport_alur_perkara_id=120', 0, 3),
				(2021, 'mainmenu', 84, 0, 'Pelanggaran', 'laporan_pid_mil', 'varreport_alur_perkara_id=121', 0, 6),
				(2022, 'mainmenu', 157, 0, 'Pidana Kejahatan', 'jadwal_sidang_list', 'varlist_alur_perkara_id=120', 0, 1),
				(2023, 'mainmenu', 157, 0, 'Pidana Pelanggaran', 'jadwal_sidang_list', 'varlist_alur_perkara_id=121', 0, 2),
				(2024, 'mainmenu', NULL, 0, 'Jinayat', '', NULL, 0, 4),
				(2025, 'mainmenu', 2024, 1, 'Register Induk Perkara Jinayat', 'perkara_list', 'varlist_alur_perkara_id=122', 1, 1),
				(2026, 'mainmenu', 2024, 1, 'Register Induk Perkara Praperadilan Jinayat', 'perkara_list', 'varlist_alur_perkara_id=123', 1, 2),
				(2027, 'mainmenu', 2024, 1, 'Register Permohonan Banding', 'perkara_banding_list', 'varlist_alur_perkara_id=122', 1, 3),
				(2028, 'mainmenu', 2024, 1, 'Register Permohonan Kasasi', 'perkara_kasasi_list', 'varlist_alur_perkara_id=122', 1, 4),
				(2029, 'mainmenu', 2024, 1, 'Register Permohonan Peninjauan Kembali', 'perkara_pk_list', 'varlist_alur_perkara_id=122', 1, 5),
				(2030, 'mainmenu', 2024, 2, 'Register Permohonan Grasi', 'perkara_grasi_list', 'varlist_alur_perkara_id=122', 1, 6),
				(2031, 'mainmenu', 2024, 1, 'Register Penahanan', 'penahanan_list', 'varlist_alur_perkara_id=122', 1, 7),
				(2032, 'mainmenu', 2024, 1, 'Register Barang Bukti', 'barang_bukti_list', 'varlist_alur_perkara_id=120', 1, 8),
				(5000, 'mainmenu', NULL, 0, 'Arsip Perkara', '', '', 1, 15),
				(5001, 'mainmenu', 5000, 1, 'Daftar Arsip Perkara', 'list_arsip', '', 1, 1),
				(6000, 'mainmenu', NULL, 0, 'Antrian', '', '', 1, 16),
				(6001, 'mainmenu', 6000, 1, 'Input Antrian Para Pihak', 'antrian', 'input=1', 1, 1),
				(6002, 'mainmenu', 6000, 1, 'Input Antrian Hakim/PP', 'antrian', 'input=2', 1, 2),
				(6003, 'mainmenu', 6000, 1, 'Display Antrian', 'antrian', 'input=3', 1, 3);;");
	$this->patching->exe_script('SET FOREIGN_KEY_CHECKS=1;');
	$this->patching->exe_script("DELETE FROM sys_menus WHERE id IN (161,153,210,211,212,19,91,247,94,15,82,89,91,92,93,94,95,96,97,98,99,102,103,104,162,163,242,244,4,66,88,90,246,555,105);");
	
	
	$data = $this->db->query("SELECT nama FROM proses WHERE id = 301;");
	$sudahUpdate = FALSE;
	if($data!=''){
		if($data->num_rows>0){
			foreach ($data->result() as $row) {
				if($row->nama=='Pemberitahuan Permohonan Banding'){
					$sudahUpdate = TRUE;
				}
			}
		}
	}
	if(!$sudahUpdate){
		$this->patching->exe_script("UPDATE proses SET id = 301, kode = 301 WHERE id = 300;");
		$this->patching->exe_script("UPDATE proses SET id = 300, kode = 300 WHERE id = 290;");
		$this->patching->exe_script("UPDATE proses_alur_perkara SET proses_id = 301 WHERE proses_id = 300 AND (alur_perkara_id<>15 AND alur_perkara_id<>16);");
		$this->patching->exe_script("UPDATE proses_alur_perkara SET proses_id = 300 WHERE proses_id = 290 AND (alur_perkara_id<>15 AND alur_perkara_id<>16);");
		$this->patching->exe_script("UPDATE perkara_proses SET proses_id = 301 WHERE proses_id = 300;");
		$this->patching->exe_script("UPDATE perkara_proses SET proses_id = 300 WHERE proses_id = 290;");
		$this->patching->exe_script("UPDATE perkara SET proses_terakhir_id = 301 WHERE proses_terakhir_id = 300;");
		$this->patching->exe_script("UPDATE perkara SET proses_terakhir_id = 300 WHERE proses_terakhir_id = 290;");
	}
	
	$this->patching->exe_script("UPDATE sys_groups SET name = 'Panitera/Wakil Panitera' WHERE groupid = 30;");

	$this->patching->exe_script("UPDATE sys_menus SET published = '1' WHERE id = '2016';");

	$sql = "REPLACE INTO proses (id, tahapan_id, kode, nama, keterangan) VALUES 
			(151,13,151,'Mediasi Tidak Dapat Dilaksanakan', 'Mediasi Tidak Dapat Dilaksanakan'),
			(181,13,181,'Mediasi Berhasil Sebagian', 'Mediasi Berhasil Sebagian'),
			(261,16,261,'Persidangan Verzet','Persidangan Verzet'),
			(290, 18, 290, 'Penetapan Majelis Hakim Ikrar Talak', 'Penetapan Majelis Hakim Ikrar Talak'),
			(291, 18, 291, 'Penunjukan Panitera Pengganti Ikrar Talak', 'Penunjukan Panitera Pengganti Ikrar Talak'),
			(292, 18, 292, 'Penunjukan Jurusita', 'Penunjukan Jurusita'),
			(293, 18, 293, 'Penetapan Hari Sidang Ikrar Talak', 'Penetapan Hari Sidang Ikrar Talak'),
			(294, 18, 294, 'Panggilan Sidang Ikrar Talak', 'Panggilan Sidang Ikrar Talak'),
			(295, 18, 295, 'Penetapan Ikrar Talak', 'Penetapan Ikrar Talak'),
			(296, 19, 296, 'Pembuatan Akta Cerai', 'Pembuatan Akta Cerai'),
			(297, 19, 297, 'Penyerahan Akta Cerai', 'Penyerahan Akta Cerai'),
			(491,30,491,'Pencabutan Perkara Kasasi','Pencabutan Perkara Kasasi'),
			(492,30,492,'Tidak Memenuhi Syarat Formil','Tidak Memenuhi Syarat Formil');";
	$this->patching->exe_script($sql);

	$sql = "REPLACE INTO proses (id, tahapan_id, kode, nama, keterangan, nama_tabel, nama_kolom, status, aktif) VALUES 
			(241,16,241,'Penetapan Majelis Hakim Verzet','Penetapan Majelis Hakim Verzet','perkara_verzet','penetapan_majelis_hakim','Penetapan Majelis Hakim Verzet','Y'),
			(242,16,242,'Penetapan Panitera Pengganti Verzet','Penetapan Panitera Pengganti Verzet','perkara_verzet','penetapan_panitera_pengganti','Penetapan Panitera Pengganti Verzet','Y'),
			(243,16,243,'Penetapan Jurusita Verzet','Penetapan Jurusita Verzet','perkara_verzet','penetapan_jurusita','Penetapan Jurusita Verzet','Y'),
			(76, 12,76, 'Pembuatan Minutasi Perkara Dilanjutkan', 'Pembuatan Minutasi Perkara Dilanjutkan', 'perkara_diversi', 'tgl_dibuka_kembali', 'Pembuatan Minutasi Perkara Dilanjutkan','Y');";
	$this->patching->exe_script($sql);

	$this->patching->exe_script("REPLACE INTO jenis_perkara (id,nama,nama_lengkap,format_nomor) VALUES
			(500,'Ikhtilath','Ikhtilath','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
			(501,'Khamar','Khamar','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
			(502,'Khalwat','Khalwat','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
			(503,'Liwath','Liwath','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
			(504,'Maisir','Maisir','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
			(505,'Musahaqah','Musahaqah','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
			(506,'Pelecehan Seksual','Pelecehan Seksual','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
			(507,'Pemerkosaan','Pemerkosaan','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
			(508,'Qadzaf','Qadzaf','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#'),
			(509,'Zina','Zina','#nomor_urut_perkara#/#kode_alur_perkara#/#tahun#/#kode_pn#');");

	$this->patching->exe_script("REPLACE INTO jenis_alur_perkara (alur_perkara_id,jenis_perkara_id) VALUES
			(122,500),(122,501),(122,502),(122,503),(122,504),(122,505),(122,506),(122,507),(122,508),(122,509),
			(123,250),(123,251),(123,252),(123,253),(123,254),(123,255),(123,256),(123,257),(123,258),(123,259),(123,260);");
	
	$this->patching->exe_script("REPLACE INTO jenis_penahanan (id,kode,nama,batas_waktu,batas_waktu_anak,keterangan,jenis_pengadilan,diperbaharui_oleh,diperbaharui_tanggal) VALUES
			('35','PNY','Penyidik','20','7','Penahanan oleh Penyidik','4','system','2015-12-30'),
			('36','PNY_PU','Penyidik Perpanjangan Oleh PU','40','8','Penahanan oleh Penyidik dengan perpanjangan oleh Penuntut Umum','4','system','2015-12-30'),
			('37','PNY_KPN','Penyidik Perpanjangan Oleh Ketua MS','30','0','Penahanan oleh Penyidik dengan perpanjangan oleh Ketua MS','4','system','2015-12-30'),
			('38','PU','Penuntut','20','5','Penahanan oleh Penuntut Umum','4','system','2015-12-30'),
			('39','PU_KPN','Penuntut Perpanjangan Oleh Ketua MS','30','5','Penahanan oleh Penuntut Umum dengan perpanjangan oleh Ketua MS','4','system','2015-12-30'),
			('40','PU_KPT','Penuntut Perpanjangan Oleh Ketua MS Aceh','30','0','Penahanan oleh Penuntut Umum dengan perpanjangan oleh Ketua MS Aceh','4','system','2015-12-30'),
			('41','HKPN','Hakim MS','30','10','Penahanan oleh Hakim MS','4','system','2015-12-30'),
			('42','HKPN_KPN','Hakim MS Perpanjangan Oleh Ketua MS','60','15','Penahanan oleh Hakim MS dengan perpanjangan oleh Ketua MS','4','system','2015-12-30'),
			('43','HKPN_KPT','Hakim MS Perpanjangan Oleh Ketua MS Aceh','60','0','Penahanan oleh Hakim MS dengan perpanjangan oleh Ketua MS Aceh','4','system','2015-12-30'),
			('44','HKPT','Hakim MS Aceh','30','10','Penahanan oleh Hakim MS Aceh (Banding)','4','system','2015-12-30'),
			('45','HKPT_KPT','Hakim MS Aceh Perpanjangan Oleh Ketua MS Aceh','30','15','Penahanan oleh Hakim MS Aceh (Banding) dengan perpanjangan oleh Ketua MS Aceh','4','system','2015-12-30'),
			('46','HKPT_KMA','Hakim MS Aceh Perpanjangan Oleh Ketua MA','60','0','Penahanan oleh Hakim MS Aceh (Banding) dengan perpanjangan oleh Ketua MA','4','system','2015-12-30'),
			('47','HKMA','Hakim Agung','50','15','Penahanan oleh Hakim Agung (Kasasi)','4','system','2015-12-30'),
			('48','HKMA_KMA','Hakim Agung Perpanjangan Oleh Ketua MA','60','20','Penahanan oleh Hakim Agung (Banding) dengan perpanjangan oleh Ketua MA','4','system','2015-12-30');");
	
	$this->patching->exe_script("REPLACE INTO sys_rules (id, parent_id, code, name, description, published, ordering, level, lft, rgt)
			VALUES(526, NULL, 'ManageDelegasi', 'Delegasi', 'Delegasi', 1, 8, 2, 967, 968);");

	$this->patching->exe_script("REPLACE INTO status_pihak (alur_perkara_id,tahapan_id,pihak_ke,nama,urutan) VALUES
			(122,10,'1','Penuntut Umum','1'),
			(122,10,'2','Terdakwa','2'),
			(122,10,'8','Penasihat Hukum Terdakwa','1'),
			(122,10,'13','Saksi','1'),
			(122,20,'1','Pembanding','1'),
			(122,20,'2','Pembanding/Terbanding','2'),
			(122,20,'3','Turut Terbanding','5'),
			(122,20,'4','Terbanding','3'),
			(122,20,'5','Terbanding/Pembanding','4'),
			(122,30,'1','Pemohon Kasasi','1'),
			(122,30,'2','Pemohon/Termohon Kasasi','2'),
			(122,30,'3','Turut Termohon Kasasi','5'),
			(122,30,'4','Termohon Kasasi','3'),
			(122,30,'5','Termohon/Pemohon Kasasi','4'),
			(122,40,'1','Pemohon PK','1'),
			(122,40,'2','Pemohon/Termohon PK','2'),
			(122,40,'3','Turut Termohon PK','5'),
			(122,40,'4','Termohon PK','3'),
			(122,40,'5','Termohon/Pemohon PK','4'),
			(123,10,'1','Pemohon','1'),
			(123,10,'2','Termohon','2'),
			(123,10,'7','Kuasa Hukum Pemohon','1'),
			(123,10,'8','Kuasa Hukum Termohon','1'),
			(123,10,'13','Saksi','1'),
			(123,20,'1','Pembanding','1'),
			(123,20,'2','Pembanding/Terbanding','2'),
			(123,20,'3','Turut Terbanding','3'),
			(123,20,'4','Terbanding','4'),
			(123,20,'5','Terbanding/Pembanding','5'),
			(123,30,'1','Pemohon','1'),
			(123,30,'2','Pemohon/Termohon Kasasi','2'),
			(123,30,'3','Turut Termohon Kasasi','3'),
			(123,30,'4','Termohon Kasasi','4'),
			(123,30,'5','Termohon/Pemohon Kasasi','5'),
			(123,40,'1','Pemohon PK','1'),
			(123,40,'2','Pemohon/Termohon PK','2'),
			(123,40,'3','Turut Termohon PK','5'),
			(123,40,'4','Termohon PK','3'),
			(123,40,'5','Termohon/Pemohon PK','4'),
			(123,50,'1','Pemohon','1'),
			(123,50,'2','Termohon','2');");
	$this->patching->exe_script('SET FOREIGN_KEY_CHECKS=0;');
	$this->patching->exe_script("REPLACE INTO sys_menus (id, menutype, parent_id, level, title, link, params, published, ordering)
VALUES
	(1, 'mainmenu', NULL, 0, 'Home', 'default', '', 1, 0),
	(2, 'mainmenu', NULL, 0, 'System', '', '', 1, 10),
	(3, 'mainmenu', 2, 1, 'User Management', 'users_list', '', 1, 5),
	(20, 'mainmenu', 2, 1, 'Konfigurasi System', 'configuration', '', 1, 3),
	(37, 'mainmenu', 2, 1, 'Audit Trail', 'audittrail_list', '', 1, 1),
	(64, 'mainmenu', NULL, 0, 'Referensi', '', '', 1, 9),
	(84, 'mainmenu', NULL, 0, 'Laporan', '', '', 1, 7),
	(85, 'mainmenu', 2, 1, 'Manajemen Menu', 'menus_list', '', 1, 9),
	(100, 'mainmenu', 64, 1, 'Ruangan Sidang', 'ruangan_sidang_list', '', 1, 7),
	(106, 'mainmenu', 2012, 2, 'Perdata Umum', 'laporan_perdata', 'varreport_alur_perkara_id=1,2', 1, 1),
	(107, 'mainmenu', NULL, 0, 'Perdata Umum', '', '', 1, 1),
	(108, 'mainmenu', NULL, 0, 'Pidana Umum', '', '', 1, 4),
	(110, 'mainmenu', 2003, 2, 'Register Induk Perkara Permohonan', 'perkara_list', 'varlist_alur_perkara_id=2', 1, 3),
	(111, 'mainmenu', 108, 1, 'Register Induk Perkara Pidana Biasa', 'perkara_list', 'varlist_alur_perkara_id=111', 1, 1),
	(112, 'mainmenu', 108, 1, 'Register Induk Perkara Pidana Singkat', 'perkara_list', 'varlist_alur_perkara_id=112', 1, 2),
	(113, 'mainmenu', 108, 1, 'Register Induk Perkara Pidana Cepat', 'perkara_list', 'varlist_alur_perkara_id=113', 1, 4),
	(114, 'mainmenu', 2003, 2, 'Register Induk Perkara Gugatan', 'perkara_list', 'varlist_alur_perkara_id=1', 1, 1),
	(117, 'mainmenu', 2003, 2, 'Register Permohonan Banding', 'perkara_banding_list', 'varlist_alur_perkara_id=1', 1, 5),
	(118, 'mainmenu', 64, 1, 'Hakim', '', '', 1, 2),
	(119, 'mainmenu', 64, 1, 'Panitera', '', '', 1, 6),
	(120, 'mainmenu', 64, 1, 'Jurusita', 'jurusita_list', '', 1, 4),
	(121, 'mainmenu', 64, 1, 'Mediator', 'mediator_list', '', 1, 5),
	(122, 'mainmenu', 2003, 2, 'Register Permohonan Kasasi', 'perkara_kasasi_list', 'varlist_alur_perkara_id=1,2', 1, 6),
	(123, 'mainmenu', 2003, 2, 'Register Permohonan Peninjauan Kembali', 'perkara_pk_list', 'varlist_alur_perkara_id=1,2', 1, 7),
	(124, 'mainmenu', 2003, 2, 'Register Permohonan Eksekusi', 'perkara_eksekusi_list', 'varlist_alur_perkara_id=1', 1, 8),
	(126, 'mainmenu', 108, 1, 'Register Permohonan Banding', 'perkara_banding_list', 'varlist_alur_perkara_id=111,112,113', 1, 6),
	(127, 'mainmenu', 108, 1, 'Register Permohonan Kasasi', 'perkara_kasasi_list', 'varlist_alur_perkara_id=111,112,113', 1, 7),
	(128, 'mainmenu', 108, 1, 'Register Permohonan Peninjauan Kembali', 'perkara_pk_list', 'varlist_alur_perkara_id=111,112,113', 1, 8),
	(129, 'mainmenu', 108, 1, 'Register Permohonan Grasi', 'perkara_grasi_list', 'varlist_alur_perkara_id=111,112,113', 1, 9),
	(130, 'mainmenu', 135, 2, 'Gugatan', 'jadwal_sidang_list', 'varlist_alur_perkara_id=1', 1, 1),
	(131, 'mainmenu', 135, 2, 'Permohonan', 'jadwal_sidang_list', 'varlist_alur_perkara_id=2', 1, 4),
	(132, 'mainmenu', 84, 1, 'Kepailitan & PKPU', 'laporan_pailit', 'varreport_alur_perkara_id=3,4', 1, 4),
	(133, 'mainmenu', 84, 1, 'Hak Kekayaan Intelektual (HKI)', 'laporan_hki', 'varreport_alur_perkara_id=5', 1, 2),
	(134, 'mainmenu', 84, 1, 'Pengadilan Hubungan Industrial (PHI)', 'laporan_phi', 'varreport_alur_perkara_id=6', 1, 7),
	(135, 'mainmenu', 157, 1, 'Perdata Umum', 'jadwal_sidang_list', 'varlist_alur_perkara_id=1,2,7,8', 1, 1),
	(136, 'mainmenu', 157, 1, 'Pidana Umum', 'jadwal_sidang_list', 'varlist_alur_perkara_id=111,112,113,114,119', 1, 3),
	(137, 'mainmenu', 84, 1, 'Pidana Umum', 'laporan_pidana', 'varreport_alur_perkara_id=111,112,113,114', 1, 17),
	(140, 'mainmenu', 84, 1, 'Tindak Pidana Korupsi', 'laporan_tipikor', 'varreport_alur_perkara_id=115', 1, 18),
	(141, 'mainmenu', 84, 1, 'Perikanan', 'laporan_perikanan', 'varreport_alur_perkara_id=116', 1, 8),
	(142, 'mainmenu', 84, 1, 'Hak Asasi Manusia (HAM)', 'laporan_ham', 'varreport_alur_perkara_id=117', 1, 1),
	(145, 'mainmenu', 108, 1, 'Register Induk Perkara Lalu-Lintas', 'perkara_lalulintas_list', 'varlist_alur_perkara_id=114', 1, 5),
	(146, 'mainmenu', NULL, 0, 'Perdata Khusus', '', 'varlist_alur_perkara_id=3,4,5,6', 1, 3),
	(147, 'mainmenu', NULL, 0, 'Pidana Khusus', '', 'varlist_alur_perkara_id=115,116,117', 1, 5),
	(148, 'mainmenu', 146, 1, 'Pengadilan Hubungan Industrial (PHI)', 'perkara_list', 'varlist_alur_perkara_id=6', 1, 3),
	(149, 'mainmenu', 146, 1, 'Kepailitan & PKPU', '', 'varlist_alur_perkara_id=3,4', 1, 1),
	(150, 'mainmenu', 2006, 3, 'Register Induk Kepailitan', 'perkara_list', 'varlist_alur_perkara_id=3', 1, 1),
	(151, 'mainmenu', 146, 1, 'Hak Kekayaan Intelektual (HKI)', 'perkara_list', 'varlist_alur_perkara_id=5', 1, 2),
	(152, 'mainmenu', 2006, 3, 'Register Induk PKPU', 'perkara_list', 'varlist_alur_perkara_id=4', 1, 2),
	(154, 'mainmenu', 147, 1, 'Tindak Pidana Korupsi (Tipikor)', 'perkara_list', 'varlist_alur_perkara_id=115', 1, 4),
	(155, 'mainmenu', 147, 1, 'Perikanan', 'perkara_list', 'varlist_alur_perkara_id=116', 1, 3),
	(156, 'mainmenu', 147, 1, 'Hak Asasi Manusia (HAM)', 'perkara_list', 'varlist_alur_perkara_id=117', 1, 2),
	(157, 'mainmenu', NULL, 0, 'Jadwal Sidang', 'jadwal_sidang_list', 'varlist_alur_perkara_id=1,2,3,4,5,6,7,8,9,10,11,12,13,14,111,112,113,114,115,116,117,118,119,120,121,122,123', 1, 8),
	(158, 'mainmenu', 118, 2, 'Hakim Tingkat Pertama', 'hakim_pn_list', '', 1, 1),
	(159, 'mainmenu', 118, 2, 'Hakim Tinggi', 'hakim_pt_list', '', 1, 2),
	(160, 'mainmenu', 118, 2, 'Hakim Agung', 'hakim_ma_list', '', 1, 3),
	(164, 'mainmenu', 2006, 3, 'Register Permohonan Kasasi Kepailitan', 'perkara_kasasi_list', 'varlist_alur_perkara_id=3,4', 1, 3),
	(165, 'mainmenu', 2006, 3, 'Register Permohonan Peninjauan Kembali Kepailitan', 'perkara_pk_list', 'varlist_alur_perkara_id=3,4', 1, 4),
	(166, 'mainmenu', 2006, 3, 'Register Penyitaan Kepailitan', 'perkara_penyitaan_list', 'varlist_alur_perkara_id=3,4', 1, 5),
	(167, 'mainmenu', 2006, 3, 'Register Pemberesan Harta Pailit', 'perkara_harta_pailit_list', 'varlist_alur_perkara_id=3,4', 1, 6),
	(168, 'mainmenu', 2006, 3, 'Register Actio Pauliana', 'perkara_actio_pauliana_list', '', 1, 7),
	(169, 'mainmenu', 2006, 3, 'Register Rehabilitasi', 'perkara_rehabilitasi_list', '', 1, 8),
	(170, 'mainmenu', 2006, 3, 'Register Kurator', 'kurator_list', '', 1, 9),
	(171, 'mainmenu', 2006, 3, 'Register Pengurus', '', '', 1, 10),
	(172, 'mainmenu', 2006, 3, 'Register Penyegelan', 'perkara_penyegelan_list', '', 1, 11),
	(173, 'mainmenu', 151, 2, 'Register Induk Perkara HKI', 'perkara_list', 'varlist_alur_perkara_id=5', 1, 1),
	(174, 'mainmenu', 151, 2, 'Register Permohonan Kasasi HKI', 'perkara_kasasi_list', 'varlist_alur_perkara_id=5', 1, 2),
	(175, 'mainmenu', 151, 2, 'Register Permohonan Peninjauan Kembali HKI', 'perkara_pk_list', 'varlist_alur_perkara_id=5', 1, 3),
	(176, 'mainmenu', 148, 2, 'Register Induk Perkara Gugatan PHI', 'perkara_list', 'varlist_alur_perkara_id=6', 1, 1),
	(177, 'mainmenu', 148, 2, 'Register Permohonan Kasasi PHI', 'perkara_kasasi_list', 'varlist_alur_perkara_id=6', 1, 2),
	(178, 'mainmenu', 148, 2, 'Register Permohonan Peninjauan Kembali PHI', 'perkara_pk_list', 'varlist_alur_perkara_id=6', 1, 3),
	(179, 'mainmenu', 148, 2, 'Register Eksekusi PHI', 'perkara_eksekusi_list', 'varlist_alur_perkara_id=6', 1, 4),
	(180, 'mainmenu', 148, 2, 'Register Penyitaan PHI', 'perkara_penyitaan_list', 'varlist_alur_perkara_id=6', 1, 5),
	(181, 'mainmenu', 148, 2, 'Register Pendaftaran Perjanjian Bersama Bipartit', '', '', 1, 6),
	(182, 'mainmenu', 148, 2, 'Register Pendaftaran Perjanjian Bersama Mediasi', '', '', 1, 7),
	(183, 'mainmenu', 148, 2, 'Register Pendaftaran Perjanjian Bersama Konsiliasi', '', '', 1, 8),
	(184, 'mainmenu', 148, 2, 'Register Pendaftaran Putusan Arbitrase', '', '', 1, 9),
	(185, 'mainmenu', 148, 2, 'Register Pendaftaran Akta Perdamaian Arbitrase', '', '', 1, 10),
	(186, 'mainmenu', 154, 2, 'Register Induk Perkara Korupsi', 'perkara_list', 'varlist_alur_perkara_id=115', 1, 1),
	(187, 'mainmenu', 154, 2, 'Register Permohonan Banding', 'perkara_banding_list', 'varlist_alur_perkara_id=115', 1, 2),
	(188, 'mainmenu', 154, 2, 'Register Permohonan Kasasi', 'perkara_kasasi_list', 'varlist_alur_perkara_id=115', 1, 3),
	(189, 'mainmenu', 154, 2, 'Register Permohonan Peninjauan Kembali', 'perkara_pk_list', 'varlist_alur_perkara_id=115', 1, 4),
	(190, 'mainmenu', 154, 2, 'Register Permohonan Grasi', 'perkara_grasi_list', 'varlist_alur_perkara_id=115', 1, 5),
	(191, 'mainmenu', 155, 2, 'Register Induk Perkara Perikanan', 'perkara_list', 'varlist_alur_perkara_id=116', 1, 1),
	(192, 'mainmenu', 155, 2, 'Register Permohonan Banding', 'perkara_banding_list', 'varlist_alur_perkara_id=116', 1, 2),
	(193, 'mainmenu', 155, 2, 'Register Permohonan Kasasi', 'perkara_kasasi_list', 'varlist_alur_perkara_id=116', 1, 3),
	(194, 'mainmenu', 155, 2, 'Register Permohonan Grasi', 'perkara_grasi_list', 'varlist_alur_perkara_id=116', 1, 5),
	(195, 'mainmenu', 156, 2, 'Register Induk Perkara HAM', 'perkara_list', 'varlist_alur_perkara_id=117', 1, 1),
	(196, 'mainmenu', 156, 2, 'Register Permohonan Banding', 'perkara_banding_list', 'varlist_alur_perkara_id=117', 1, 2),
	(197, 'mainmenu', 156, 2, 'Register Permohonan Kasasi', 'perkara_kasasi_list', 'varlist_alur_perkara_id=117', 1, 3),
	(198, 'mainmenu', 156, 2, 'Register Permohonan Peninjauan Kembali', 'perkara_pk_list', 'varlist_alur_perkara_id=117', 1, 4),
	(199, 'mainmenu', 156, 2, 'Register Permohonan Grasi', 'perkara_grasi_list', 'varlist_alur_perkara_id=117', 1, 5),
	(200, 'mainmenu', 2004, 2, 'Jurnal Perkara Gugatan', 'jurnal_perkara_list', 'varlist_alur_perkara_id=1;var_tahapan_id=10', 1, 1),
	(201, 'mainmenu', 2004, 2, 'Jurnal Perkara Permohonan', 'jurnal_perkara_list', 'varlist_alur_perkara_id=2;var_tahapan_id=10', 1, 4),
	(202, 'mainmenu', 2004, 2, 'Jurnal Permohonan Banding', 'jurnal_banding_list', 'varlist_alur_perkara_id=1;var_tahapan_id=20', 1, 5),
	(203, 'mainmenu', 2004, 2, 'Jurnal Permohonan Kasasi', 'jurnal_kasasi_list', 'varlist_alur_perkara_id=1,2;var_tahapan_id=30', 1, 6),
	(204, 'mainmenu', 2004, 2, 'Jurnal Permohonan Peninjauan Kembali', 'jurnal_pk_list', 'varlist_alur_perkara_id=1,2;var_tahapan_id=40', 1, 7),
	(205, 'mainmenu', 2004, 2, 'Jurnal Permohonan Eksekusi', 'jurnal_eksekusi_list', 'varlist_alur_perkara_id=1,2;var_tahapan_id=50', 1, 8),
	(207, 'mainmenu', 2005, 2, 'Buku Induk Keuangan Perkara Perdata', 'jurnal_induk_list', 'varlist_alur_perkara_id=1,2', 1, 3),
	(208, 'mainmenu', 2005, 2, 'Buku Keuangan Biaya Eksekusi', '', '', 0, 1),
	(209, 'mainmenu', 2005, 2, 'Buku Induk Penerimaan Uang Hak-hak Kepaniteraan', 'jurnal_hkk_list', 'varlist_alur_perkara_id=1,2', 1, 2),
	(213, 'mainmenu', 2007, 3, 'Jurnal Perkara Kepailitan', 'jurnal_perkara_list', 'varlist_alur_perkara_id=3;var_tahapan_id=10', 1, 1),
	(214, 'mainmenu', 2007, 3, 'Jurnal Perkara PKPU', 'jurnal_perkara_list', 'varlist_alur_perkara_id=4;var_tahapan_id=10', 1, 2),
	(215, 'mainmenu', 2007, 3, 'Jurnal Permohonan Kasasi', 'jurnal_kasasi_list', 'varlist_alur_perkara_id=3,4;var_tahapan_id=30', 1, 3),
	(216, 'mainmenu', 2007, 3, 'Jurnal Permohonan Peninjauan Kembali', 'jurnal_pk_list', 'varlist_alur_perkara_id=3,4;var_tahapan_id=40', 1, 4),
	(217, 'mainmenu', 2007, 3, 'Jurnal Permohonan Actio Pauliana', '', '', 1, 5),
	(218, 'mainmenu', 2007, 3, 'Jurnal Permohonan Rehabilitasi', '', '', 1, 6),
	(219, 'mainmenu', 2008, 3, 'Buku Induk Keuangan Perkara Perdata Kepailitan & PKPU', 'jurnal_induk_list', 'varlist_alur_perkara_id=3,4', 1, 1),
	(220, 'mainmenu', 2008, 3, 'Buku Keuangan Biaya Eksekusi', '', '', 0, 2),
	(221, 'mainmenu', 2008, 3, 'Buku Induk Penerimaan Uang Hak-hak Kepaniteraan', 'jurnal_hkk_list', 'varlist_alur_perkara_id=3,4', 1, 3),
	(222, 'mainmenu', 151, 2, 'Jurnal Keuangan Perkara HKI', 'jurnal_perkara_list', 'varlist_alur_perkara_id=5;var_tahapan_id=10', 1, 4),
	(223, 'mainmenu', 151, 2, 'Jurnal Keuangan Pemohonan Kasasi Perkara HKI', 'jurnal_kasasi_list', 'varlist_alur_perkara_id=5;var_tahapan_id=30', 1, 5),
	(224, 'mainmenu', 151, 2, 'Jurnal Keuangan Permohonan PK Perkara HKI', 'jurnal_pk_list', 'varlist_alur_perkara_id=5;var_tahapan_id=40', 1, 6),
	(225, 'mainmenu', 151, 2, 'Buku Induk Keuangan Perkara HKI', 'jurnal_induk_list', 'varlist_alur_perkara_id=5', 1, 7),
	(226, 'mainmenu', 151, 2, 'Buku Induk Penerimaan Uang Hak-hak Kepaniteraan', 'jurnal_hkk_list', 'varlist_alur_perkara_id=5', 1, 8),
	(227, 'mainmenu', 148, 2, 'Jurnal Keuangan Perkara Gugatan PHI', 'jurnal_perkara_list', 'varlist_alur_perkara_id=6;var_tahapan_id=10', 1, 11),
	(228, 'mainmenu', 148, 2, 'Jurnal Keuangan Pemohonan Kasasi Perkara PHI', 'jurnal_kasasi_list', 'varlist_alur_perkara_id=6;var_tahapan_id=30', 1, 12),
	(229, 'mainmenu', 148, 2, 'Jurnal Keuangan Permohonan PK Perkara PHI', 'jurnal_pk_list', 'varlist_alur_perkara_id=6;var_tahapan_id=40', 1, 13),
	(230, 'mainmenu', 148, 2, 'Jurnal Keuangan Eksekusi Perkara PHI', 'jurnal_perkara_list', 'varlist_alur_perkara_id=6;var_tahapan_id=50', 1, 14),
	(231, 'mainmenu', 148, 2, 'Buku Induk Keuangan Perkara PHI', 'jurnal_induk_list', 'varlist_alur_perkara_id=6', 1, 15),
	(232, 'mainmenu', 148, 2, 'Buku Induk Penerimaan Uang HHK', 'jurnal_hkk_list', 'varlist_alur_perkara_id=6', 1, 16),
	(233, 'mainmenu', 108, 1, 'Register Penahanan Pidana Umum', 'penahanan_list', 'varlist_alur_perkara_id=111,112', 1, 10),
	(234, 'mainmenu', 154, 2, 'Register Penahanan Tipikor', 'penahanan_list', 'varlist_alur_perkara_id=115', 1, 6),
	(235, 'mainmenu', 155, 2, 'Register Penahanan Perikanan', 'penahanan_list', 'varlist_alur_perkara_id=116', 1, 6),
	(236, 'mainmenu', 156, 2, 'Register Penahanan HAM', 'penahanan_list', 'varlist_alur_perkara_id=117', 1, 6),
	(237, 'mainmenu', 155, 2, 'Register Permohonan Peninjauan Kembali', 'perkara_pk_list', 'varlist_alur_perkara_id=116', 1, 4),
	(238, 'mainmenu', 64, 1, 'Biaya Perkara', 'ref_biaya_perkara_list', '', 1, 1),
	(239, 'mainmenu', 119, 2, 'Panitera Tingkat Pertama', 'panitera_pn_list', '', 1, 1),
	(240, 'mainmenu', 119, 2, 'Panitera Pengadilan Tinggi', 'panitera_pt_list', '', 1, 2),
	(241, 'mainmenu', 119, 2, 'Panitera Mahkamah Agung', 'panitera_ma_list', '', 1, 3),
	(243, 'mainmenu', 64, 1, 'Hari Libur', 'hari_libur_list', '', 1, 3),
	(248, 'mainmenu', 136, 2, 'Pidana Biasa', 'jadwal_sidang_list', 'varlist_alur_perkara_id=111', 1, 1),
	(249, 'mainmenu', 136, 2, 'Pidana Singkat', 'jadwal_sidang_list', 'varlist_alur_perkara_id=112', 1, 4),
	(250, 'mainmenu', 136, 2, 'Pidana Cepat', 'jadwal_sidang_list', 'varlist_alur_perkara_id=113', 1, 2),
	(251, 'mainmenu', 136, 2, 'Pidana Lalulintas', 'jadwal_sidang_list', 'varlist_alur_perkara_id=114', 1, 3),
	(252, 'mainmenu', 157, 1, 'Perdata Khusus', 'jadwal_sidang_list', 'varlist_alur_perkara_id=3,4,5,6', 1, 2),
	(253, 'mainmenu', 157, 1, 'Pidana Khusus', 'jadwal_sidang_list', 'varlist_alur_perkara_id=115,116,117,118', 1, 4),
	(254, 'mainmenu', 252, 2, 'Kepailitan', 'jadwal_sidang_list', 'varlist_alur_perkara_id=3', 1, 2),
	(255, 'mainmenu', 252, 2, 'PKPU', 'jadwal_sidang_list', 'varlist_alur_perkara_id=4', 1, 4),
	(256, 'mainmenu', 252, 2, 'Hak Kekayaan Intelektual (HKI)', 'jadwal_sidang_list', 'varlist_alur_perkara_id=5', 1, 1),
	(257, 'mainmenu', 252, 2, 'Pengadilan Hubungan Industrial (PHI)', 'jadwal_sidang_list', 'varlist_alur_perkara_id=6', 1, 3),
	(258, 'mainmenu', 253, 2, 'Tindak Pidana Korupsi (TIPIKOR)', 'jadwal_sidang_list', 'varlist_alur_perkara_id=115', 1, 4),
	(259, 'mainmenu', 253, 2, 'Perikanan', 'jadwal_sidang_list', 'varlist_alur_perkara_id=116', 1, 2),
	(260, 'mainmenu', 253, 2, 'Hak Asasi Manusia (HAM)', 'jadwal_sidang_list', 'varlist_alur_perkara_id=117', 1, 1),
	(261, 'mainmenu', NULL, 0, 'Peta Situs', 'peta_situs', '', 0, 12),
	(262, 'mainmenu', NULL, 0, 'Pesan', 'pesan_masuk_list', NULL, 1, 11),
	(263, 'mainmenu', 262, 1, 'Pesan Masuk', 'pesan_masuk_list', NULL, 1, 1),
	(264, 'mainmenu', 262, 1, 'Pesan Keluar', 'pesan_keluar_list', NULL, 1, 2),
	(265, 'mainmenu', 2, 1, 'Konfigurasi Saldo Awal', 'saldo_awal_edit', NULL, 1, 4),
	(266, 'mainmenu', 147, 1, 'Pidana Anak', '', '', 1, 1),
	(267, 'mainmenu', 266, 1, 'Register Induk Pidana Anak', 'perkara_list', 'varlist_alur_perkara_id=118', 1, 1),
	(268, 'mainmenu', 84, 1, 'Pidana Anak', 'laporan_pidana_anak', 'varreport_alur_perkara_id=118', 1, 15),
	(269, 'mainmenu', 266, 1, 'Register Penahanan', 'penahanan_list', 'varlist_alur_perkara_id=118', 1, 5),
	(270, 'mainmenu', 84, 1, 'Pidana Praperadilan', 'laporan_pidana', 'varreport_alur_perkara_id=119', 1, 16),
	(300, 'mainmenu', 108, 1, 'Register Induk Perkara Praperadilan', 'perkara_list', 'varlist_alur_perkara_id=119', 1, 3),
	(301, 'mainmenu', 108, 1, 'Register Barang Bukti', 'barang_bukti_list', 'varlist_alur_perkara_id=111,112,113,114,115,116,11', 1, 11),
	(302, 'mainmenu', 2004, 2, 'Jurnal Permohonan Eksekusi Hak Tanggungan', 'jurnal_ht_list', 'varlist_alur_perkara_id=0;var_tahapan_id=51', 1, 9),
	(303, 'mainmenu', 2003, 2, 'Register Permohonan Eksekusi Hak Tanggungan', 'perkara_ht_list', 'varlist_alur_perkara_id=0', 1, 9),
	(401, 'mainmenu', 108, 2, 'Register Induk Pidana Pelanggaran', 'perkara_list', 'varlist_alur_perkara_id=121', 0, 1),
	(402, 'mainmenu', NULL, 0, 'Pidana Militer', '', '', 0, 1),
	(403, 'mainmenu', 402, 1, 'Register Induk Pidana Kejahatan', 'perkara_list', 'varlist_alur_perkara_id=120', 1, 0),
	(404, 'mainmenu', 402, 1, 'Register Induk Pidana Pelangggaran', 'perkara_list', 'varlist_alur_perkara_id=121', 1, 0),
	(405, 'mainmenu', 402, 1, 'Register Permohonan Banding', 'perkara_banding_list', 'varlist_alur_perkara_id=120,121', 1, 0),
	(406, 'mainmenu', 402, 1, 'Register Permohonan Kasasi', 'perkara_kasasi_list', 'varlist_alur_perkara_id=120', 1, 0),
	(407, 'mainmenu', 402, 1, 'Register Permohonan Peninjauan Kembali', 'perkara_pk_list', 'varlist_alur_perkara_id=120', 1, 0),
	(408, 'mainmenu', 402, 1, 'Register Permohonan Grasi', 'perkara_grasi_list', 'varlist_alur_perkara_id=120', 1, 0),
	(409, 'mainmenu', 402, 1, 'Register Penahanan Pidana Militer', 'penahanan_list', 'varlist_alur_perkara_id=120', 1, 0),
	(410, 'mainmenu', 402, 1, 'Register Barang Bukti', 'barang_bukti_list', 'varlist_alur_perkara_id=120', 1, 0),
	(600, 'mainmenu', NULL, 0, 'Jurnal Perkara', '', '', 0, 1),
	(601, 'mainmenu', NULL, 0, 'Register Induk Perkara', '', '', 0, 2),
	(602, 'mainmenu', NULL, 0, 'Register Keuangan', '', '', 0, 3),
	(603, 'mainmenu', 600, 1, 'Jurnal Induk Perkara TUN', 'jurnal_perkara_list', 'varlist_alur_perkara_id=9;var_tahapan_id=10', 0, 1),
	(604, 'mainmenu', 600, 1, 'Jurnal Permohonan UU AP', 'jurnal_perkara_list', 'varlist_alur_perkara_id=10;var_tahapan_id=10', 0, 2),
	(605, 'mainmenu', 600, 1, 'Jurnal Permohonan Keberatan (KIP)', 'jurnal_perkara_list', 'varlist_alur_perkara_id=11;var_tahapan_id=10', 0, 3),
	(606, 'mainmenu', 600, 1, 'Jurnal Permohonan Fiktif Positif', 'jurnal_perkara_list', 'varlist_alur_perkara_id=12;var_tahapan_id=10', 0, 4),
	(607, 'mainmenu', 600, 1, 'Jurnal Permohonan Penyalahgunaan Wewenang', 'jurnal_perkara_list', 'varlist_alur_perkara_id=13;var_tahapan_id=10', 0, 5),
	(608, 'mainmenu', 600, 1, 'Jurnal Banding', 'jurnal_perkara_list', 'varlist_alur_perkara_id=9;var_tahapan_id=20', 0, 7),
	(609, 'mainmenu', 600, 1, 'Jurnal Kasasi', 'jurnal_perkara_list', 'varlist_alur_perkara_id=9;var_tahapan_id=30', 0, 8),
	(610, 'mainmenu', 600, 1, 'Jurnal PK', 'jurnal_perkara_list', 'varlist_alur_perkara_id=9;var_tahapan_id=40', 0, 9),
	(611, 'mainmenu', 600, 1, 'Jurnal Pengawasan Eksekusi', 'jurnal_perkara_list', 'varlist_alur_perkara_id=9;var_tahapan_id=50', 0, 10),
	(612, 'mainmenu', 600, 1, 'Jurnal Permohonan Pertanahan', 'jurnal_perkara_list', 'varlist_alur_perkara_id=14;var_tahapan_id=10', 0, 6),
	(613, 'mainmenu', 601, 1, 'Register Induk Perkara TUN', 'perkara_list', 'varlist_alur_perkara_id=9', 0, 1),
	(614, 'mainmenu', 601, 1, 'Register Permohonan UU AP', 'perkara_list', 'varlist_alur_perkara_id=10', 0, 2),
	(615, 'mainmenu', 601, 1, 'Register Permohonan Keberatan (KIP)', 'perkara_list', 'varlist_alur_perkara_id=11', 0, 3),
	(616, 'mainmenu', 601, 1, 'Register Permohonan Fiktif Positif', 'perkara_list', 'varlist_alur_perkara_id=12', 0, 4),
	(617, 'mainmenu', 601, 1, 'Register Permohonan Penyalahgunaan Wewenang', 'perkara_list', 'varlist_alur_perkara_id=13', 0, 5),
	(618, 'mainmenu', 601, 1, 'Register Permohonan Pertanahan', 'perkara_list', 'varlist_alur_perkara_id=14', 0, 6),
	(619, 'mainmenu', 601, 1, 'Register Banding', 'perkara_banding_list', 'varlist_alur_perkara_id=9', 0, 7),
	(620, 'mainmenu', 601, 1, 'Register Kasasi', 'perkara_kasasi_list', 'varlist_alur_perkara_id=9', 0, 8),
	(621, 'mainmenu', 601, 1, 'Register Peninjauan Kembali', 'perkara_pk_list', 'varlist_alur_perkara_id=9', 0, 9),
	(622, 'mainmenu', 602, 1, 'Buku Hak-Hak Keuangan Kepaniteraan/PNBP', 'jurnal_hkk_list', 'varlist_alur_perkara_id=9,10,11,12,13,14', 0, 1),
	(623, 'mainmenu', 602, 1, 'Buku Induk Keuangan Perkara', 'jurnal_induk_list', 'varlist_alur_perkara_id=9,10,11,12,13,14', 0, 2),
	(624, 'mainmenu', 84, 1, 'Perkara TUN', 'laporan_tun', 'varreport_alur_perkara_id=9', 0, 9),
	(625, 'mainmenu', 84, 1, 'Permohonan UU AP', 'laporan_tun', 'varreport_alur_perkara_id=10', 0, 14),
	(626, 'mainmenu', 84, 1, 'Permohonan Keberatan (KIP)', 'laporan_tun', 'varreport_alur_perkara_id=11', 0, 11),
	(627, 'mainmenu', 84, 1, 'Permohonan Fiktif Positif', 'laporan_tun', 'varreport_alur_perkara_id=12', 0, 10),
	(628, 'mainmenu', 84, 1, 'Permohonan Penyalahgunaan Wewenang', 'laporan_tun', 'varreport_alur_perkara_id=13', 0, 12),
	(629, 'mainmenu', 84, 1, 'Permohonan Pertanahan', 'laporan_tun', 'varreport_alur_perkara_id=14', 0, 13),
	(630, 'mainmenu', 157, 1, 'Gugatan', 'jadwal_sidang_list', 'varlist_alur_perkara_id=9', 0, 5),
	(631, 'mainmenu', 157, 1, 'Permohonan UU AP', 'jadwal_sidang_list', 'varlist_alur_perkara_id=10', 0, 6),
	(632, 'mainmenu', 157, 1, 'Permohonan Keberatan (KIP)', 'jadwal_sidang_list', 'varlist_alur_perkara_id=11', 0, 7),
	(633, 'mainmenu', 157, 1, 'Permohonan Fiktif Positif', 'jadwal_sidang_list', 'varlist_alur_perkara_id=12', 0, 8),
	(634, 'mainmenu', 157, 1, 'Permohonan Penyalahgunaan Wewenang', 'jadwal_sidang_list', 'varlist_alur_perkara_id=13', 0, 9),
	(635, 'mainmenu', 157, 1, 'Permohonan Pertanahan', 'jadwal_sidang_list', 'varlist_alur_perkara_id=14', 0, 10),
	(636, 'mainmenu', 601, 1, 'Register Pengawasan Eksekusi TUN', 'perkara_eksekusi_list', 'varlist_alur_perkara_id=9', 0, 10),
	(700, 'mainmenu', NULL, 0, 'Jurnal Perkara', '', '', 0, 1),
	(701, 'mainmenu', NULL, 0, 'Register Induk Keuangan', '', '', 0, 2),
	(702, 'mainmenu', NULL, 0, 'Perdata', '', '', 0, 3),
	(703, 'mainmenu', 700, 1, 'Jurnal Perkara Gugatan', 'jurnal_perkara_list', 'varlist_alur_perkara_id=15;var_tahapan_id=10', 0, 1),
	(704, 'mainmenu', 700, 1, 'Jurnal Perkara Permohonan', 'jurnal_perkara_list', 'varlist_alur_perkara_id=16;var_tahapan_id=10', 0, 2),
	(705, 'mainmenu', 700, 1, 'Jurnal Permohonan Banding', 'jurnal_banding_list', 'varlist_alur_perkara_id=15;var_tahapan_id=20', 0, 3),
	(706, 'mainmenu', 700, 1, 'Jurnal Permohonan Kasasi', 'jurnal_kasasi_list', 'varlist_alur_perkara_id=15,16;var_tahapan_id=30', 0, 4),
	(707, 'mainmenu', 700, 1, 'Jurnal Permohonan Peninjauan Kembali', 'jurnal_pk_list', 'varlist_alur_perkara_id=15,16;var_tahapan_id=40', 0, 5),
	(708, 'mainmenu', 700, 1, 'Jurnal Permohonan Eksekusi', 'jurnal_eksekusi_list', 'varlist_alur_perkara_id=15;var_tahapan_id=50', 0, 6),
	(709, 'mainmenu', 700, 1, 'Jurnal Permohonan Eksekusi Hak Tanggungan', 'jurnal_ht_list', 'varlist_alur_perkara_id=0;var_tahapan_id=51', 0, 7),
	(710, 'mainmenu', 701, 1, 'Buku Induk Penerimaan Uang Hak-hak Kepaniteraan', 'jurnal_hkk_list', 'varlist_alur_perkara_id=15,16', 0, 1),
	(711, 'mainmenu', 701, 1, 'Buku Induk Keuangan Perkara Perdata', 'jurnal_induk_list', 'varlist_alur_perkara_id=15,16', 0, 3),
	(712, 'mainmenu', 702, 1, 'Register Induk Perkara Gugatan', 'perkara_list', 'varlist_alur_perkara_id=15', 0, 1),
	(713, 'mainmenu', 702, 1, 'Register Induk Perkara Permohonan', 'perkara_list', 'varlist_alur_perkara_id=16', 0, 2),
	(714, 'mainmenu', 702, 1, 'Register Permohonan Banding', 'perkara_banding_list', 'varlist_alur_perkara_id=15', 0, 3),
	(715, 'mainmenu', 702, 1, 'Register Permohonan Kasasi', 'perkara_kasasi_list', 'varlist_alur_perkara_id=15,16', 0, 4),
	(716, 'mainmenu', 702, 1, 'Register Permohonan Peninjauan Kembali', 'perkara_pk_list', 'varlist_alur_perkara_id=15,16', 0, 5),
	(717, 'mainmenu', 702, 1, 'Register Permohonan Eksekusi', 'perkara_eksekusi_list', 'varlist_alur_perkara_id=15', 0, 6),
	(718, 'mainmenu', 702, 1, 'Register Permohonan Eksekusi Hak Tanggungan', 'perkara_ht_list', 'varlist_alur_perkara_id=0', 0, 7),
	(719, 'mainmenu', 84, 1, 'Perdata Agama', 'laporan_agama', 'varreport_alur_perkara_id=15,16', 0, 1),
	(720, 'mainmenu', 84, 1, 'Mediasi', 'laporan_mediasi', '', 0, 2),
	(721, 'mainmenu', 157, 1, 'Sidang Gugatan', 'jadwal_sidang_list', 'varlist_alur_perkara_id=15', 0, 1),
	(722, 'mainmenu', 157, 1, 'Sidang Permohonan', 'jadwal_sidang_list', 'varlist_alur_perkara_id=16', 0, 2),
	(723, 'mainmenu', 157, 1, 'Sidang Jinayat', 'jadwal_sidang_list', 'varlist_alur_perkara_id=122', 1, 2),
	(724, 'mainmenu', 157, 1, 'Sidang Praperadilan', 'jadwal_sidang_list', 'varlist_alur_perkara_id=123', 1, 2),
	(1000, 'mainmenu', 266, 1, 'Register Permohonan Banding', 'perkara_banding_list', 'varlist_alur_perkara_id=118', 1, 2),
	(1001, 'mainmenu', 266, 1, 'Register Permohonan Kasasi', 'perkara_kasasi_list', 'varlist_alur_perkara_id=118', 1, 3),
	(1002, 'mainmenu', 266, 1, 'Register Permohonan Peninjauan Kembali', 'perkara_pk_list', 'varlist_alur_perkara_id=118', 1, 4),
	(1003, 'mainmenu', 2, 1, 'Backup', 'backup', '', 0, 2),
	(1004, 'mainmenu', 253, 2, 'Tindak Pidana Anak', 'jadwal_sidang_list', 'varlist_alur_perkara_id=118', 1, 3),
	(2000, 'mainmenu', NULL, 0, 'Lapor', 'testing_dev_list', '', 0, 14),
	(2001, 'mainmenu', 2003, 2, 'Register Induk Perkara Gugatan Sederhana', 'perkara_list', 'varlist_alur_perkara_id=8', 1, 2),
	(2002, 'mainmenu', 2004, 2, 'Jurnal Perkara Gugatan Sederhana', 'jurnal_perkara_list', 'varlist_alur_perkara_id=8;var_tahapan_id=10', 1, 2),
	(2003, 'mainmenu', 107, 1, 'Register Induk Perkara', '', '', 1, 1),
	(2004, 'mainmenu', 107, 1, 'Jurnal Perkara', '', '', 1, 2),
	(2005, 'mainmenu', 107, 1, 'Register Induk Keuangan', '', '', 1, 3),
	(2006, 'mainmenu', 149, 2, 'Register Induk Perkara', '', '', 1, 1),
	(2007, 'mainmenu', 149, 2, 'Jurnal Keuangan Perkara', '', '', 1, 2),
	(2008, 'mainmenu', 149, 2, 'Register Induk Keuangan', '', '', 1, 3),
	(2010, 'mainmenu', 2012, 2, 'Mediasi', 'laporan_mediasi', '', 1, 1),
	(2011, 'mainmenu', 2012, 2, 'Perkara Gugatan Sederhana', 'laporan_gugatan_sederhana', '', 1, 2),
	(2012, 'mainmenu', 84, 1, 'Laporan Perdata Umum', '', '', 1, 5),
	(2013, 'mainmenu', 135, 2, 'Perlawanan', 'jadwal_sidang_lis