<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Tab_ikrar_talak_c extends CI_Controller {
	function index(){
		$data=$this->load_data();
		$this->load->view('perkara_tab/ikrar_talak/tab_ikrar_v', $data);
	}

	function addIkrarTalak(){
		$this->penetapan_majelis('add');
	}
	function load_data(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		$data['idperkara'] = $data['perkara_id'];
		
		$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
		
		$data['list_hakim'] = $this->ikrar->get_list_hakim($data['perkara_id']);
		$data['list_hakim_lama'] = $this->ikrar->get_list_hakim_lama($data['perkara_id']);
		$data['list_panitera'] = $this->ikrar->get_list_panitera($data['perkara_id']);
		$data['list_panitera_lama'] = $this->ikrar->get_list_panitera_lama($data['perkara_id']);

		$row=$this->ikrar->get_no_perkara($data['perkara_id']);
		$data['nomor_perkara']=$row->nomor_perkara;

		$data['idalurperkara'] = $row->alur_perkara_id;
		$data['idproses'] = $row->proses_terakhir_id;
		$data['tahapan'] = 18;
		$data['tanggal_bht']=$row->tanggal_bht;
		$data['tanggal_putusan']=$row->tanggal_putusan;
		$data['penetapan_majelis_hakim']=$row->penetapan_majelis_hakim;

		$data['majelis_hakim_id']=$row->majelis_hakim_id;
		$data['majelis_hakim_nama']=$row->majelis_hakim_nama;
		$data['majelis_hakim_text']=$row->majelis_hakim_text;
		$data['penetapan_panitera_pengganti']=$row->penetapan_panitera_pengganti;
		$data['panitera_pengganti_id']=$row->panitera_pengganti_id;
		$data['panitera_pengganti_text']=$row->panitera_pengganti_text;
		$data['penetapan_jurusita']=$row->penetapan_jurusita;
		$data['jurusita_id']=$row->jurusita_id;
		$data['jurusita_text']=$row->jurusita_text;
		$data['tanggal_penetapan_sidang_verzet']=$row->tanggal_penetapan_sidang_ikrar;
		$data['tanggal_sidang_pertama_verzet']=$row->tanggal_sidang_pertama;
		$data['tanggal_ikrar']=$row->tgl_ikrar_talak;
		if(!empty($row->status_penetapan_ikrar_talak_id)){
			switch($row->status_penetapan_ikrar_talak_id){
				case '1' : $data['status_penetapan_ikrar'] = 'Diikrarkan';
				           break;
				case '2' : $data['status_penetapan_ikrar'] = 'Pemohon Tidak Hadir';
				           break;
				case '3' : $data['status_penetapan_ikrar'] = 'Rukun Kembali';
						   break;
				default  : $data['status_penetapan_ikrar'] = '';
			}
		}
		else
			$data['status_penetapan_ikrar']= '';
		if(!empty($row->keadaan_istri)){
			switch($row->keadaan_istri){
				case '1' : $data['keadaan_istri'] = 'Suci';
						   break;
				case '2' : $data['keadaan_istri'] = 'Haid';
						   break;
				case '3' : $data['keadaan_istri'] = 'Sedang Hamil';
						   break;
				case '4' : $data['keadaan_istri'] = 'Tidak Diketahui';
						   break;
				default  : $data['keadaan_istri'] = '';
 			}
		}else{
			$data['keadaan_istri']='';
		}
		$data['amar_ikrar_talak']=$row->amar_ikrar_talak;
		$data['ikrar_talak_dok']=$row->ikrar_talak_dok;
		$data['current_date'] = date('d/m/Y');		
		return $data;
	}

	function penetapan_majelis($action='edit'){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['action'] = $action;
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		
		$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
		$row=$this->ikrar->get_no_perkara($data['perkara_id']);
		$data['nomor_perkara']	= $row->nomor_perkara;

		$data['idalurperkara'] = $row->alur_perkara_id;
		$data['tahapan'] = 18;
		$data['tanggal_putusan']=$row->tanggal_putusan;
		$data['tanggal_bht'] = $row->tanggal_bht;

		$data['majelis_hakim_id'] = $row->majelis_hakim_id;
		//$data['tanggal_pendaftaran_verzet']	= $row->tanggal_pendaftaran_verzet;
		$data['penetapan_majelis_hakim']	= $row->penetapan_majelis_hakim;
		$data['current_date'] = date('d/m/Y');
		$data['listHakim'] = $this->ikrar->getListHakim();
		$data['idketua'] = '';
		$data['idAnggota1'] = '';
		$data['idAnggota2'] = '';
		$tmp = explode(',', $data['majelis_hakim_id']);
		if(count($tmp)>2){
			$data['idketua'] = $tmp[0];
			$data['idAnggota1'] = $tmp[1];
			$data['idAnggota2'] = $tmp[2];
		}

		$this->load->view('perkara_tab/ikrar_talak/form_ikrar_penetapan_h', $data);
	}

	function validateInputPenetapanHakim(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$status = $this->input->post('status', TRUE);
		$action = $this->input->post('act', TRUE);
		if($action!='add' AND $action!='edit'){
			echo json_encode(array('st'=>0,'msg'=>'Incorrect Parameters Setup.'));
			return;
		}
		if($status=='Y'){
			$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
			$dataMajelisLama = $this->ikrar->getOldPenetapanMajelis($idperkara);
			if($dataMajelisLama->num_rows()>0){
				foreach ($dataMajelisLama->result() as $row) {
					$dataPenetapan = array(
						'perkara_id'=>$idperkara,
						'penetapan_majelis_hakim'=>$row->penetapan_majelis_hakim,
						'majelis_hakim_id'=>$row->majelis_hakim_id,
						'majelis_hakim_nama'=>$row->majelis_hakim_nama,
						'majelis_hakim_text'=>$row->majelis_hakim_text,
						'diperbaharui_oleh'=>$this->session->userdata('username'),
						'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
					);
				}
				$datahakim='';
				$result = $this->ikrar->updateDataPenetapanMajelis($idperkara,$dataPenetapan,$datahakim,$action,$status);							
				//$result = $this->ikrar->updateDataPenetapanMajelis($idperkara,$dataPenetapan,$action);
				if($result){
					echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
					return;
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
					return;
				}
			}
		}

		$this->form_validation->set_rules('tgl_pen_majelis', 'Tanggal Penetapan Majelis Hakim', 'trim|required|max_length[10]|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;

		}else{
			$hakimKetua = $this->encrypt->decode(base64_decode($this->input->post('h_ketua', TRUE)));
			$hakimAnggota1 = $this->encrypt->decode(base64_decode($this->input->post('h_anggota1', TRUE)));
			$hakimAnggota2 = $this->encrypt->decode(base64_decode($this->input->post('h_anggota2', TRUE)));

			$tglPenetapan = $this->input->post('tgl_pen_majelis', TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tglPenetapan = $this->tanggalhelper->convertToMysqlDate($tglPenetapan);
			if($tglPenetapan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPenetapan,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglPenetapan);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusan = $this->tanggalhelper->getTanggalPutusan($idperkara);
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$tglPenetapan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Kurang Dari Tanggal Putusan/Penetapan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}

			$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');

			if(intval($hakimKetua)<0){
				echo json_encode(array('st'=>0,'msg'=>'Error, Identitas Hakim Ketua Tidak Ditemukan.'));
				return;
			}elseif(empty($hakimKetua)){
				echo json_encode(array('st'=>0,'msg'=>'Error, Pilih Hakim Ketua.'));
				return;
			}
			if(intval($hakimAnggota1)<0){
				echo json_encode(array('st'=>0,'msg'=>'Error, Identitas Hakim Anggota I Tidak Ditemukan.'));
				return;
			}elseif(empty($hakimAnggota1)){
				echo json_encode(array('st'=>0,'msg'=>'Error, Pilih Hakim Anggota I.'));
				return;
			}

			if(intval($hakimAnggota2)<0){
				echo json_encode(array('st'=>0,'msg'=>'Error, Identitas Hakim Anggota II Tidak Ditemukan.'));
				return;
			}elseif(empty($hakimAnggota2)){
				echo json_encode(array('st'=>0,'msg'=>'Error, Pilih Hakim Anggota II.'));
				return;
			}
			if($hakimKetua==$hakimAnggota1 OR $hakimKetua== $hakimAnggota2 OR $hakimAnggota1==$hakimAnggota2){
				echo json_encode(array('st'=>0,'msg'=>'Error, Tidak Dapat Memilih Hakim Yang Sama.'));
				return;
			}
			$hakimKetuaNama = $this->ikrar->getHakimNama($hakimKetua);
			$hakimAnggota1Nama = $this->ikrar->getHakimNama($hakimAnggota1);
			$hakimAnggota2Nama = $this->ikrar->getHakimNama($hakimAnggota2);
			$majelisHakimText = 'Hakim Ketua: '.$hakimKetuaNama.'</br>Hakim Anggota 1: '.$hakimAnggota1Nama.'</br>Hakim Anggota 2: '.$hakimAnggota2Nama;
			$majelisHakimID = $hakimKetua.','.$hakimAnggota1.','.$hakimAnggota2;
			$majelisHakimNamaText = $hakimKetuaNama.'</br>'.$hakimAnggota1Nama.'</br>'.$hakimAnggota2Nama;
			
			$dataPenetapan = array(
				'perkara_id'=>$idperkara,
				'penetapan_majelis_hakim'=>$tglPenetapan,
				'majelis_hakim_id'=>$majelisHakimID,
				'majelis_hakim_nama'=>$majelisHakimNamaText,
				'majelis_hakim_text'=>$majelisHakimText,
				'diperbaharui_oleh'=>$this->session->userdata('username'),
				'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
				);
			$tahapan = 18;
			$datahakim=array(
				array(
					'perkara_id'=>$idperkara,
					'tahapan_id' => $tahapan,
					'tanggal_penetapan' =>$tglPenetapan,
					'urutan' => 1,
					'jabatan_hakim_id' => 1,
					'jabatan_hakim_nama' => 'Hakim Ketua',
					'hakim_id' => $hakimKetua,
					'hakim_nama' => $hakimKetuaNama,
					'aktif' => 'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
					),
				array(
					'perkara_id'=>$idperkara,
					'tahapan_id' => $tahapan,
					'tanggal_penetapan' =>$tglPenetapan,
					'urutan' => 2,
					'jabatan_hakim_id' => 2,
					'jabatan_hakim_nama' => 'Hakim Anggota',
					'hakim_id' => $hakimAnggota1,
					'hakim_nama' => $hakimAnggota1Nama,
					'aktif' => 'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
					),
				array(
					'perkara_id'=>$idperkara,
					'tahapan_id' => $tahapan,
					'tanggal_penetapan' =>$tglPenetapan,
					'urutan' => 3,
					'jabatan_hakim_id' => 2,
					'jabatan_hakim_nama' => 'Hakim Anggota',
					'hakim_id' => $hakimAnggota2,
					'hakim_nama' => $hakimAnggota2Nama,
					'aktif' => 'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
					)
				);
			$result = $this->ikrar->updateDataPenetapanMajelis($idperkara,$dataPenetapan,$datahakim,$action,$status);
			if($result){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
				return;
			}
			
		}
	}

	function penetapan_kembali_majelis($action='add'){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['action'] = $action;
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		
		$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
		$row=$this->ikrar->get_no_perkara($data['perkara_id']);
		$data['nomor_perkara']	= $row->nomor_perkara;

		$data['idalurperkara'] = $row->alur_perkara_id;
		$data['tahapan'] = 18;
		$data['tanggal_putusan']=$row->tanggal_putusan;
		$data['tanggal_bht'] = $row->tanggal_bht;

		$data['majelis_hakim_id'] = $row->majelis_hakim_id;
		//$data['tanggal_pendaftaran_verzet']	= $row->tanggal_pendaftaran_verzet;
		$data['penetapan_majelis_hakim']	= $row->penetapan_majelis_hakim;
		$data['current_date'] = date('d/m/Y');
		$data['listHakim'] = $this->ikrar->getListHakim();
		$data['idketua'] = '';
		$data['idAnggota1'] = '';
		$data['idAnggota2'] = '';
		$tmp = explode(',', $data['majelis_hakim_id']);
		if(count($tmp)>2){
			$data['idketua'] = $tmp[0];
			$data['idAnggota1'] = $tmp[1];
			$data['idAnggota2'] = $tmp[2];
		}

		$this->load->view('perkara_tab/ikrar_talak/form_ikrar_penetapan_kembali_h', $data);
	}

	function validateInputPenetapanKembaliHakim(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$action = $this->input->post('act', TRUE);
		if($action!='add'){
			echo json_encode(array('st'=>0,'msg'=>'Incorrect Parameters Setup.'));
			return;
		}

		$this->form_validation->set_rules('tgl_pen_majelis', 'Tanggal Penetapan Majelis Hakim', 'trim|required|max_length[10]|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;

		}else{
			$hakimKetua = $this->encrypt->decode(base64_decode($this->input->post('h_ketua', TRUE)));
			$hakimAnggota1 = $this->encrypt->decode(base64_decode($this->input->post('h_anggota1', TRUE)));
			$hakimAnggota2 = $this->encrypt->decode(base64_decode($this->input->post('h_anggota2', TRUE)));

			$tglPenetapan = $this->input->post('tgl_pen_majelis', TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tglPenetapan = $this->tanggalhelper->convertToMysqlDate($tglPenetapan);
			if($tglPenetapan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPenetapan,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglPenetapan);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusan = $this->tanggalhelper->getTanggalPutusan($idperkara);
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$tglPenetapan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Kurang Dari Tanggal Putusan/Penetapan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}

			$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');

			if(intval($hakimKetua)<0){
				echo json_encode(array('st'=>0,'msg'=>'Error, Identitas Hakim Ketua Tidak Ditemukan.'));
				return;
			}elseif(empty($hakimKetua)){
				echo json_encode(array('st'=>0,'msg'=>'Error, Pilih Hakim Ketua.'));
				return;
			}
			if(intval($hakimAnggota1)<0){
				echo json_encode(array('st'=>0,'msg'=>'Error, Identitas Hakim Anggota I Tidak Ditemukan.'));
				return;
			}elseif(empty($hakimAnggota1)){
				echo json_encode(array('st'=>0,'msg'=>'Error, Pilih Hakim Anggota I.'));
				return;
			}

			if(intval($hakimAnggota2)<0){
				echo json_encode(array('st'=>0,'msg'=>'Error, Identitas Hakim Anggota II Tidak Ditemukan.'));
				return;
			}elseif(empty($hakimAnggota2)){
				echo json_encode(array('st'=>0,'msg'=>'Error, Pilih Hakim Anggota II.'));
				return;
			}
			if($hakimKetua==$hakimAnggota1 OR $hakimKetua== $hakimAnggota2 OR $hakimAnggota1==$hakimAnggota2){
				echo json_encode(array('st'=>0,'msg'=>'Error, Tidak Dapat Memilih Hakim Yang Sama.'));
				return;
			}
			$hakimKetuaNama = $this->ikrar->getHakimNama($hakimKetua);
			$hakimAnggota1Nama = $this->ikrar->getHakimNama($hakimAnggota1);
			$hakimAnggota2Nama = $this->ikrar->getHakimNama($hakimAnggota2);
			$majelisHakimText = 'Hakim Ketua: '.$hakimKetuaNama.'</br>Hakim Anggota 1: '.$hakimAnggota1Nama.'</br>Hakim Anggota 2: '.$hakimAnggota2Nama;
			$majelisHakimID = $hakimKetua.','.$hakimAnggota1.','.$hakimAnggota2;
			$majelisHakimNamaText = $hakimKetuaNama.'</br>'.$hakimAnggota1Nama.'</br>'.$hakimAnggota2Nama;
			
			$dataPenetapan = array(
				'perkara_id'=>$idperkara,
				'penetapan_majelis_hakim'=>$tglPenetapan,
				'majelis_hakim_id'=>$majelisHakimID,
				'majelis_hakim_nama'=>$majelisHakimNamaText,
				'majelis_hakim_text'=>$majelisHakimText,
				'diperbaharui_oleh'=>$this->session->userdata('username'),
				'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
			);
			$tahapan = 18;
			$datahakim=array(
				array(
					'perkara_id'=>$idperkara,
					'tahapan_id' => $tahapan,
					'tanggal_penetapan' =>$tglPenetapan,
					'urutan' => 1,
					'jabatan_hakim_id' => 1,
					'jabatan_hakim_nama' => 'Hakim Ketua',
					'hakim_id' => $hakimKetua,
					'hakim_nama' => $hakimKetuaNama,
					'aktif' => 'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
					),
				array(
					'perkara_id'=>$idperkara,
					'tahapan_id' => $tahapan,
					'tanggal_penetapan' =>$tglPenetapan,
					'urutan' => 2,
					'jabatan_hakim_id' => 2,
					'jabatan_hakim_nama' => 'Hakim Anggota',
					'hakim_id' => $hakimAnggota1,
					'hakim_nama' => $hakimAnggota1Nama,
					'aktif' => 'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
					),
				array(
					'perkara_id'=>$idperkara,
					'tahapan_id' => $tahapan,
					'tanggal_penetapan' =>$tglPenetapan,
					'urutan' => 3,
					'jabatan_hakim_id' => 2,
					'jabatan_hakim_nama' => 'Hakim Anggota',
					'hakim_id' => $hakimAnggota2,
					'hakim_nama' => $hakimAnggota2Nama,
					'aktif' => 'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
					)
				);
			$result = $this->ikrar->updateDataPenetapanMajelis($idperkara,$dataPenetapan,$datahakim,'edit');
			if($result){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
				return;
			}
			
		}
	}

	function penetapan_panitera(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		
		$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
		$row=$this->ikrar->get_no_perkara($data['perkara_id']);
		$data['nomor_perkara']	= $row->nomor_perkara;
		$data['idalurperkara'] = $row->alur_perkara_id;

		$data['tahapan'] = 18;
		$data['tanggal_putusan']=$row->tanggal_putusan;
		$data['tanggal_bht'] = $row->tanggal_bht;
		$data['panitera_id'] = $row->panitera_pengganti_id;
		$data['penetapan_panitera_pengganti']	= $row->penetapan_panitera_pengganti;
		$data['current_date'] = date('d/m/Y');
		$data['listPanitera'] = $this->ikrar->getListPanitera();
		$tmp = explode(',', $data['panitera_id']);
		if(count($tmp)>1){
			$data['idPanitera1'] = $tmp[0];
			$data['idPanitera2'] = $tmp[1];
		}else{
			$data['idPanitera1'] = $data['panitera_id'];
			$data['idPanitera2'] = '';
		}
		$this->load->view('perkara_tab/ikrar_talak/form_ikrar_penetapan_pp', $data);
	}

	function penetapan_kembali_panitera(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		
		$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
		$row=$this->ikrar->get_no_perkara($data['perkara_id']);
		$data['nomor_perkara']	= $row->nomor_perkara;
		$data['idalurperkara'] = $row->alur_perkara_id;

		$data['tahapan'] = 18;
		$data['tanggal_putusan']=$row->tanggal_putusan;
		$data['tanggal_bht'] = $row->tanggal_bht;
		$data['panitera_id'] = $row->panitera_pengganti_id;
		$data['penetapan_panitera_pengganti']	= $row->penetapan_panitera_pengganti;
		$data['current_date'] = date('d/m/Y');
		$data['listPanitera'] = $this->ikrar->getListPanitera();
		$tmp = explode(',', $data['panitera_id']);
		if(count($tmp)>1){
			$data['idPanitera1'] = $tmp[0];
			$data['idPanitera2'] = $tmp[1];
		}else{
			$data['idPanitera1'] = $data['panitera_id'];
			$data['idPanitera2'] = '';
		}
		$this->load->view('perkara_tab/ikrar_talak/form_ikrar_penetapan_kembali_pp', $data);
	}

	function validateInputPenetapanPanitera(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$status = $this->input->post('status', TRUE);

		if($status=='Y'){
			$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
			$dataPaniteraLama = $this->ikrar->getOldPenetapanPanitera($idperkara);
			if($dataPaniteraLama->num_rows()>0){
				foreach ($dataPaniteraLama->result() as $row) {
					$dataPenetapan = array(
						'perkara_id'=>$idperkara,
						'penetapan_panitera_pengganti'=>$row->penetapan_panitera_pengganti,
						'panitera_pengganti_id'=>$row->panitera_pengganti_id,
						'panitera_pengganti_text'=>$row->panitera_pengganti_text,
						'diperbaharui_oleh'=>$this->session->userdata('username'),
						'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
					);
				}
				$result = $this->ikrar->updateDataPenetapanPanitera($idperkara,$dataPenetapan);
				if($result){
					echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
					return;
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
					return;
				}
			}
		}
		
		$this->form_validation->set_rules('tgl_pen_panitera', 'Tanggal Penetapan Panitera Pengganti', 'trim|required|max_length[10]|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;

		}else{
			$panitera1 = $this->encrypt->decode(base64_decode($this->input->post('panitera1', TRUE)));
			$panitera2 = $this->encrypt->decode(base64_decode($this->input->post('panitera2', TRUE)));

			$tglPenetapan = $this->input->post('tgl_pen_panitera', TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tglPenetapan = $this->tanggalhelper->convertToMysqlDate($tglPenetapan);
			if($tglPenetapan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPenetapan,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglPenetapan);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusan = $this->tanggalhelper->getTanggalPutusan($idperkara);
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$tglPenetapan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}

			$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
			$tglPermohonan = $this->ikrar->getTanggalPermohonan($idperkara);

			$selisih = $this->tanggalhelper->getSelisihHari($tglPermohonan,$tglPenetapan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Kurang Dari Tanggal Permohonan '.$this->nativesession->getLangguage('verzet')));
				return;
			}

			if(intval($panitera1)<0){
				echo json_encode(array('st'=>0,'msg'=>'Error, Identitas Panitera Pertama Tidak Ditemukan.'));
				return;
			}elseif(empty($panitera1)){
				echo json_encode(array('st'=>0,'msg'=>'Error, Pilih Panitera Pertama.'));
				return;
			}
			$panitera1Nama = $this->ikrar->getPaniteraNama($panitera1);
			$paniteraID = $panitera1;
			$paniteraText = 'Panitera Pengganti: '.$panitera1Nama;

			$tahapan = 18;

			$datapanitera = array(
				array(
					'perkara_id'=>$idperkara,
					'tahapan_id' => $tahapan,
					'tanggal_penetapan' =>$tglPenetapan,
					'urutan' => 1,
					'panitera_id' => $panitera1,
					'panitera_nama' => $panitera1Nama,
					'aktif' => 'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
					)
				);

			if(!empty($panitera2)){
				if(intval($panitera2)<0){
					echo json_encode(array('st'=>0,'msg'=>'Error, Identitas Panitera Kedua Tidak Ditemukan.'));
					return;
				}elseif(empty($panitera2)){
					echo json_encode(array('st'=>0,'msg'=>'Error, Pilih Panitera Kedua.'));
					return;
				}

				if($panitera1==$panitera2){
					echo json_encode(array('st'=>0,'msg'=>'Error, Tidak Dapat Memilih Panitera Yang Sama.'));
					return;
				}

				$panitera2Nama 	= $this->ikrar->getPaniteraNama($panitera2);
				$paniteraID 	.=  ','.$panitera2;
				$paniteraText 	.=  '</br>'.$panitera2Nama;

				$datapanitera[1] = array(
					'perkara_id'=>$idperkara,
					'tahapan_id' => $tahapan,
					'tanggal_penetapan' =>$tglPenetapan,
					'urutan' => 2,
					'panitera_id' => $panitera2,
					'panitera_nama' => $panitera2Nama,
					'aktif' => 'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
					);
			}
			
			$dataPenetapan = array(
				'penetapan_panitera_pengganti'=>$tglPenetapan,
				'panitera_pengganti_id'=>$paniteraID,
				'panitera_pengganti_text'=>$paniteraText,
				'diperbaharui_oleh'=>$this->session->userdata('username'),
				'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
			);
			$result = $this->ikrar->updateDataPenetapanPanitera($idperkara,$dataPenetapan,$datapanitera);
			if($result){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
				return;
			}
			
		}
	}

	function validateInputPenetapanKembaliPanitera(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		
		$this->form_validation->set_rules('tgl_pen_panitera', 'Tanggal Penetapan Panitera Pengganti', 'trim|required|max_length[10]|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;

		}else{
			$panitera1 = $this->encrypt->decode(base64_decode($this->input->post('panitera1', TRUE)));
			$panitera2 = $this->encrypt->decode(base64_decode($this->input->post('panitera2', TRUE)));

			$tglPenetapan = $this->input->post('tgl_pen_panitera', TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tglPenetapan = $this->tanggalhelper->convertToMysqlDate($tglPenetapan);
			if($tglPenetapan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPenetapan,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglPenetapan);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusan = $this->tanggalhelper->getTanggalPutusan($idperkara);
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$tglPenetapan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}

			$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
			$tglPermohonan = $this->ikrar->getTanggalPermohonan($idperkara);

			$selisih = $this->tanggalhelper->getSelisihHari($tglPermohonan,$tglPenetapan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Kurang Dari Tanggal Permohonan '.$this->nativesession->getLangguage('verzet')));
				return;
			}

			if(intval($panitera1)<0){
				echo json_encode(array('st'=>0,'msg'=>'Error, Identitas Panitera Pertama Tidak Ditemukan.'));
				return;
			}elseif(empty($panitera1)){
				echo json_encode(array('st'=>0,'msg'=>'Error, Pilih Panitera Pertama.'));
				return;
			}
			$panitera1Nama = $this->ikrar->getPaniteraNama($panitera1);
			$paniteraID = $panitera1;
			$paniteraText = 'Panitera Pengganti: '.$panitera1Nama;

			$tahapan = 18;

			$datapanitera = array(
				array(
					'perkara_id'=>$idperkara,
					'tahapan_id' => $tahapan,
					'tanggal_penetapan' =>$tglPenetapan,
					'urutan' => 1,
					'panitera_id' => $panitera1,
					'panitera_nama' => $panitera1Nama,
					'aktif' => 'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
					)
				);

			if(!empty($panitera2)){
				if(intval($panitera2)<0){
					echo json_encode(array('st'=>0,'msg'=>'Error, Identitas Panitera Kedua Tidak Ditemukan.'));
					return;
				}elseif(empty($panitera2)){
					echo json_encode(array('st'=>0,'msg'=>'Error, Pilih Panitera Kedua.'));
					return;
				}

				if($panitera1==$panitera2){
					echo json_encode(array('st'=>0,'msg'=>'Error, Tidak Dapat Memilih Panitera Yang Sama.'));
					return;
				}

				$panitera2Nama 	= $this->ikrar->getPaniteraNama($panitera2);
				$paniteraID 	.=  ','.$panitera2;
				$paniteraText 	.=  '</br>'.$panitera2Nama;

				$datapanitera[1] = array(
					'perkara_id'=>$idperkara,
					'tahapan_id' => $tahapan,
					'tanggal_penetapan' =>$tglPenetapan,
					'urutan' => 2,
					'panitera_id' => $panitera2,
					'panitera_nama' => $panitera2Nama,
					'aktif' => 'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
					);
			}
			
			$dataPenetapan = array(
				'penetapan_panitera_pengganti'=>$tglPenetapan,
				'panitera_pengganti_id'=>$paniteraID,
				'panitera_pengganti_text'=>$paniteraText,
				'diperbaharui_oleh'=>$this->session->userdata('username'),
				'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
			);
			$this->ikrar->addDataPenetapanKembaliPP($datapanitera,$idperkara);
			$result = $this->ikrar->updateDataPenetapanPanitera($idperkara,$dataPenetapan,$datapanitera);
			if($result){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
				return;
			}
			
		}
	}

	function penetapan_jurusita(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		
		$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
		$row=$this->ikrar->get_no_perkara($data['perkara_id']);
		$data['nomor_perkara']	= $row->nomor_perkara;
		$data['idalurperkara'] = $row->alur_perkara_id;

		$data['tahapan'] = 18;
		$data['tanggal_putusan']=$row->tanggal_putusan;
		$data['tanggal_bht'] = $row->tanggal_bht;
		$data['jurusita_id'] = $row->jurusita_id;
		$data['penetapan_jurusita']	= $row->penetapan_jurusita;
		$data['penetapan_panitera_pengganti']	= $row->penetapan_panitera_pengganti;
		$data['current_date'] = date('d/m/Y');
		$data['listJurusita'] = $this->ikrar->getListJurusita();
		$tmp = explode(',', $data['jurusita_id']);
		if(count($tmp)>1){
			$data['idJurusita1'] = $tmp[0];
			$data['idJurusita2'] = $tmp[0];
		}else{
			$data['idJurusita1'] = $data['jurusita_id'];
			$data['idJurusita2'] = '';
		}
		$this->load->view('perkara_tab/ikrar_talak/form_ikrar_penetapan_jurusita', $data);
	}

	function validateInputPenetapanJurusita(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$status = $this->input->post('status', TRUE);

		if($status=='Y'){
			$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
			$dataJuristaLama = $this->ikrar->getOldPenetapanJurusita($idperkara);
			if($dataJuristaLama->num_rows()>0){
				foreach ($dataJuristaLama->result() as $row) {
					$dataPenetapan = array(
						'perkara_id'=>$idperkara,
						'penetapan_jurusita'=>$row->penetapan_jurusita,
						'jurusita_id'=>$row->jurusita_id,
						'jurusita_text'=>$row->jurusita_text,
						'diperbaharui_oleh'=>$this->session->userdata('username'),
						'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
					);
				}
				if(empty($dataPenetapan['penetapan_jurusita'])){
					echo json_encode(array('st'=>0,'msg'=>'Tidak Ditemukan Data Penetapan Jurusita Pada Proses Sebelumnya'));
					return;
				}
				$result = $this->ikrar->updateDataPenetapanJurusita($idperkara,$dataPenetapan);
				if($result){
					echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
					return;
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
					return;
				}
			}
		}

		$this->form_validation->set_rules('tgl_pen_js', 'Tanggal Penetapan Jurusita', 'trim|required|max_length[10]|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;

		}else{
			$jurusita1 = $this->encrypt->decode(base64_decode($this->input->post('jurusita1', TRUE)));
			$jurusita2 = $this->encrypt->decode(base64_decode($this->input->post('jurusita2', TRUE)));

			$tglPenetapan = $this->input->post('tgl_pen_js', TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tglPenetapan = $this->tanggalhelper->convertToMysqlDate($tglPenetapan);
			if($tglPenetapan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPenetapan,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglPenetapan);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusan = $this->tanggalhelper->getTanggalPutusan($idperkara);
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$tglPenetapan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}

			$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
			$tglPermohonan = $this->ikrar->getTanggalPermohonan($idperkara);

			$selisih = $this->tanggalhelper->getSelisihHari($tglPermohonan,$tglPenetapan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Kurang Dari Tanggal Permohonan '.$this->nativesession->getLangguage('verzet')));
				return;
			}

			if(intval($jurusita1)<0){
				echo json_encode(array('st'=>0,'msg'=>'Error, Identitas Jurusita Pertama Tidak Ditemukan.'));
				return;
			}elseif(empty($jurusita1)){
				echo json_encode(array('st'=>0,'msg'=>'Error, Pilih Jurusita Pertama.'));
				return;
			}
			$jurusita1Nama = $this->ikrar->getJurusitaNama($jurusita1);
			$jurusitaID = $jurusita1;
			$jurusitaText = 'Juru Sita Pengganti: '.$jurusita1Nama;
			
			if($this->session->userdata('jenis_pengadilan')==3){
				$tahapan = 13;
			}else{
				$tahapan = 16;
			}
			$datajurusita = array(
				array(
					'perkara_id'=>$idperkara,
					'tahapan_id' => $tahapan,
					'tanggal_penetapan' =>$tglPenetapan,
					'urutan' => 1,
					'jurusita_id' => $jurusita1,
					'jurusita_nama' => $jurusita1Nama,
					'aktif' => 'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
					)
				);

			if(!empty($jurusita2)){
				if(intval($jurusita2)<0){
					echo json_encode(array('st'=>0,'msg'=>'Error, Identitas Jurusita Kedua Tidak Ditemukan.'));
					return;
				}elseif(empty($jurusita2)){
					echo json_encode(array('st'=>0,'msg'=>'Error, Pilih Jurusita Kedua.'));
					return;
				}

				if($jurusita1==$jurusita2){
					echo json_encode(array('st'=>0,'msg'=>'Error, Tidak Dapat Memilih Jurusita Yang Sama.'));
					return;
				}

				$jurusita2Nama 	= $this->ikrar->getPaniteraNama($jurusita2);
				$jurusitaID 	.=  ','.$jurusita2;
				$jurusitaText 	.=  '</br>'.$jurusita2Nama;

				$datajurusita[1] = array(
					'perkara_id'=>$idperkara,
					'tahapan_id' => $tahapan,
					'tanggal_penetapan' =>$tglPenetapan,
					'urutan' => 2,
					'jurusita_id' => $jurusita2,
					'jurusita_nama' => $jurusita2Nama,
					'aktif' => 'Y',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
					);
			}
			
			$dataPenetapan = array(
				'penetapan_jurusita'=>$tglPenetapan,
				'jurusita_id'=>$jurusitaID,
				'jurusita_text'=>$jurusitaText,
				'diperbaharui_oleh'=>$this->session->userdata('username'),
				'diperbaharui_tanggal'=>date('Y-m-d H:i:s')					
			);
			$result = $this->ikrar->updateDataPenetapanJurusita($idperkara,$dataPenetapan);
			if($result){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
				return;
			}
			
		}
	}

	function penetapan_sidang(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		
		$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
		$row=$this->ikrar->get_no_perkara($data['perkara_id']);
		$data['nomor_perkara']	= $row->nomor_perkara;
		$data['enc_sidang']	= base64_encode($this->encrypt->encode($row->sidang_id));
		$data['idalurperkara'] = $row->alur_perkara_id;

		$data['tahapan'] = 18;
		$data['tanggal_putusan']=$row->tanggal_putusan;
		$data['tanggal_bht'] = $row->tanggal_bht;
		$data['tanggal_penetapan_sidang']	= $row->tanggal_penetapan_sidang_ikrar;
		$data['tanggal_sidang_pertama']	= $row->tanggal_sidang_pertama;
		$data['jam_sidang']	= $row->jam_sidang;
		$data['current_date'] = date('d/m/Y');
		$this->load->view('perkara_tab/ikrar_talak/form_ikrar_penetapan_sidang', $data);
	}

	function validateInputPenetapanSidang(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		
		$this->form_validation->set_rules('tgl_pen_sidang', 'Tanggal Penetapan Sidang Pertama', 'trim|required|max_length[10]|xss_clean');
		$this->form_validation->set_rules('tgl_sidang', 'Tanggal Sidang Pertama', 'trim|required|max_length[10]|xss_clean');
		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{

			$tglPenetapan = $this->input->post('tgl_pen_sidang', TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tglPenetapan = $this->tanggalhelper->convertToMysqlDate($tglPenetapan);
			if($tglPenetapan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPenetapan,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglPenetapan);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusan = $this->tanggalhelper->getTanggalPutusan($idperkara);
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$tglPenetapan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}

			$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');

			$tglSidang = $this->input->post('tgl_sidang', TRUE);
			$tglSidang = $this->tanggalhelper->convertToMysqlDate($tglSidang);
			if($tglSidang==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglSidang);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Sidang Pertama Ikrar Talak Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusan = $this->tanggalhelper->getTanggalPutusan($idperkara);
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$tglSidang);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Sidang Pertama Ikrar Talak Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}
			
			$dataPenetapan = array(
				'perkara_id'=>$idperkara,
				'tanggal_penetapan_sidang_ikrar'=>$tglPenetapan,
				'tanggal_sidang_pertama'=>$tglSidang,
				'diperbaharui_oleh'=>$this->session->userdata('username'),
				'diperbaharui_tanggal'=>date('Y-m-d H:i:s')			
			);
			
			
			$hasSidangPertama = $this->ikrar->hasSidangPertama($idperkara);
			$lastSidang = $this->ikrar->getLastSidang($idperkara);
			if ($tglSidang<$lastSidang){
				$lastSidang = $this->tanggalhelper->convertDayDate($lastSidang);
				echo json_encode(array('st'=>0,'msg'=>'Tanggal Sidang Ikrar Talak Tidak Boleh sebelum Tanggal Sidang Terakhir. '.$lastSidang));
				return;
			}
			if($hasSidangPertama==FALSE){
				$dataSidang = array(
					'perkara_id'=>$idperkara, 
					'ikrar_talak'=>'Y',
					'tanggal_sidang'=>$tglSidang, 
					'jam_sidang'=>'09:00',
					'agenda'=>'SIDANG IKRAR TALAK',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
				);
				$idjadwalsidang = $this->ikrar->addJadwalSidang($dataSidang);
				$dataPenetapan['sidang_id'] = $idjadwalsidang;
			}else{
				$dataSidang = array(
					'perkara_id'=>$idperkara, 
					'ikrar_talak'=>'Y',
					'tanggal_sidang'=>$tglSidang, 
					'jam_sidang'=>'09:00',
					'agenda'=>'SIDANG IKRAR TALAK',
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
				);
				$datasidangpertama = $this->ikrar->getSidangPertamaVerzet($idperkara);
				if($datasidangpertama->num_rows>1){
					foreach ($datasidangpertama->result() as $row) {
						$dataSidang['id'] = $row->id;
					}
					$idjadwalsidang = $this->ikrar->updateJadwalSidangPertama($dataSidang);
				}else{
					$idjadwalsidang = $this->ikrar->addJadwalSidang($dataSidang);
					$dataPenetapan['sidang_id'] = $idjadwalsidang;
				}
			}

			$result = $this->ikrar->updateDataPenetapanSidang($idperkara,$dataPenetapan);
			if($result){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
				return;
			}
			
		}
	}

	function validateDeleteSidang(){
		if(empty($_POST)){
			show_404();
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$idsidang = ($this->encrypt->decode(base64_decode($this->input->post('enc_sidang'))));
		if(empty($idsidang) OR intval($idsidang)<1){
			echo json_encode(array('st'=>0,'msg'=>'Data Tidak Ditemukan.'));
			return;
		}

		$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
		$delData = $this->ikrar->deleteDataSidang($idperkara,$idsidang);
		if($delData){
			echo json_encode(array('st'=>1,'msg'=>'Data Penetapan Sidang Pertama Ikrar Talak Berhasil DiHapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Data Penetapan Sidang Pertama Ikrar Talak Gagal.'));
			return;
		}
	}

	function validateDeleteJurusita(){
		if(empty($_POST)){
			show_404();
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
		$delData = $this->ikrar->deleteDataPenJurusita($idperkara);
		if($delData){
			echo json_encode(array('st'=>1,'msg'=>'Data Penetapan Jurusita Ikrar Talak Berhasil DiHapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Data Penetapan Jurusita Ikrar Talak Gagal.'));
			return;
		}
	}

	function validateDeletePanitera(){
		if(empty($_POST)){
			show_404();
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
		$delData = $this->ikrar->deleteDataPenPanitera($idperkara);
		if($delData){
			echo json_encode(array('st'=>1,'msg'=>'Data Penetapan Panitera Pengganti Ikrar Talak Berhasil DiHapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Data Penetapan Panitera Pengganti Ikrar Talak Gagal.'));
			return;
		}
	}

	function validateDeleteHakim(){
		if(empty($_POST)){
			show_404();
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
		$info = $this->ikrar->infoikrartalak($idperkara);
		$tglIkrarTalak = $info->tgl_ikrar_talak;
		$tglPenetapanSidang = $info->tanggal_penetapan_sidang_ikrar;
		$tglPenetapanJurusita = $info->penetapan_jurusita;
		$tglPenetapanPP = $info->penetapan_panitera_pengganti;
		
		if((empty($tglIkrarTalak) OR $tglIkrarTalak=='') && (empty($tglPenetapanSidang) OR $tglPenetapanSidang=='') && (empty($tglPenetapanJurusita) OR $tglPenetapanJurusita=='') && (empty($tglPenetapanPP) OR $tglPenetapanPP=='')){
			$delData = $this->ikrar->deleteRowDataPenHakim($idperkara);
		}else{
			$delData = $this->ikrar->deleteDataPenHakim($idperkara);
		}		
		if($delData){
			echo json_encode(array('st'=>1,'msg'=>'Data Penetapan Majelis Hakim Ikrar Talak Berhasil DiHapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Data Penetapan Majelis Hakim Ikrar Talak Gagal.'));
			return;
		}
	}

	function ikrar_talak_penetapan(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		if(empty($data['perkara_id']) OR intval($data['perkara_id'])<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
		$row=$this->ikrar->get_no_perkara($data['perkara_id']);
		$data['nomor_perkara']	= $row->nomor_perkara;
		$data['idalurperkara'] = $row->alur_perkara_id;

		$data['tahapan'] = 18;
		$data['tanggal_putusan']=$row->tanggal_putusan;
		$data['tanggal_bht'] = $row->tanggal_bht;
		$data['tanggal_ikrar']=$row->tgl_ikrar_talak;
		$data['status_penetapan']=$row->status_penetapan_ikrar_talak_id;
		$data['keadaan_istri']=$row->keadaan_istri;
		$data['amar_ikrar_talak']=$row->amar_ikrar_talak;

		$data['current_date'] = date('d/m/Y');
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-','RemoveFormat','-', 'Blockquote',
					'-','JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '100%';
		$this->ckeditor->config['height'] = '250px';
		
		$this->load->view('perkara_tab/ikrar_talak/form_ikrar_putusan', $data);
	}

	function validateInputPenetapanIkrar(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->form_validation->set_rules('tgl_ikrar', 'Tanggal Penetapan Ikrar Talak', 'trim|required|max_length[10]|xss_clean');		
		$this->form_validation->set_rules('amar_text', 'Amar Penetapan Ikrar', 'trim|required|xss_clean|min_length[50]');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{

			$tglPenetapanIkrar = $this->input->post('tgl_ikrar', TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tglPenetapanIkrar = $this->tanggalhelper->convertToMysqlDate($tglPenetapanIkrar);
			if($tglPenetapanIkrar==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPenetapanIkrar,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Ikrar Talak Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglPenetapanIkrar);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Ikrar Talak Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusan = $this->tanggalhelper->getTanggalPutusan($idperkara);
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$tglPenetapanIkrar);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Ikrar Talak Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}

			$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
			$data = $this->ikrar->get_no_perkara($idperkara);

			$tanggal = $data->tanggal_penetapan_sidang_ikrar;
			$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$tglPenetapanIkrar);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Ikrar Tidak Boleh Kurang Dari Tanggal Penetapan Sidang Pertama'));
				return;
			}

			$tanggal = $data->penetapan_jurusita;
			$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$tglPenetapanIkrar);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Ikrar Tidak Boleh Kurang Dari Tanggal Penetapan Jurusita'));
				return;
			}

			$tanggal = $data->penetapan_panitera_pengganti;
			$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$tglPenetapanIkrar);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Ikrar Tidak Boleh Kurang Dari Tanggal Penetapan Panitera Pengganti'));
				return;
			}

			$tanggal = $data->penetapan_majelis_hakim;
			$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$tglPenetapanIkrar);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Ikrar Tidak Boleh Kurang Dari Tanggal Penetapan Majelis Hakim'));
				return;
			}					

			$statusPenetapanIkrar = $this->input->post('status_penetapan', TRUE);
			if(intval($statusPenetapanIkrar)!=1 AND intval($statusPenetapanIkrar)!=2 AND intval($statusPenetapanIkrar)!=3){
				echo json_encode(array('st'=>0,'msg'=>'Invalid Status Penetapan Ikrar Talak'));
				return;
			}

			$keadaanistri = $this->input->post('keadaan_istri', TRUE);
			if(intval($keadaanistri)!=1 AND intval($keadaanistri)!=2 AND intval($keadaanistri)!=3 AND intval($keadaanistri)!=4){
				echo json_encode(array('st'=>0,'msg'=>'Invalid Status Penetapan Ikrar Talak'));
				return;
			}

			$amar = trim($this->input->post('amar_text',TRUE));
			$amar = str_replace("&nbsp;", " ", $amar);

			$dataPenetapan = array(
				'tgl_ikrar_talak'=>$tglPenetapanIkrar,
				'status_penetapan_ikrar_talak_id'=>$statusPenetapanIkrar,
				'amar_ikrar_talak'=>$amar,
				'diperbaharui_oleh'=>$this->session->userdata('username'),
				'diperbaharui_tanggal'=>date('Y-m-d H:i:s')					
			);
			$result = $this->ikrar->updateDataKeadaanIstri($keadaanistri,$idperkara);
			$result = $this->ikrar->updateDataPenetapan($idperkara,$dataPenetapan);			
			if($result){
				echo json_encode(array('st'=>1,'msg'=>'Data Penetapan Ikrar Talak Berhasil Disimpan '));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
				return;
			}
		}
	}
	
	function verzet_pemberitahuan(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		if(empty($data['perkara_id']) OR intval($data['perkara_id'])<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
		$row=$this->ikrar->get_no_perkara($data['perkara_id']);
		$data['nomor_perkara']	= $row->nomor_perkara;
		$data['idalurperkara'] = $row->alur_perkara_id;

		if($data['idalurperkara']==9){
			$data['tahapan'] = 13;
			$data['tanggal_putusan']=$this->ikrar->getTanggalDismissal($data['perkara_id']);
		}else{
			$data['tahapan'] = 16;
			$data['tanggal_putusan']=$row->tanggal_putusan;
		}
		$data['tanggal_pendaftaran_verzet']	= $row->tanggal_pendaftaran_verzet;
		$data['putusan_verzet']=$row->putusan_verzet;
		$data['pemberitahuan_putusan_verzet_pihak1']=$row->pemberitahuan_putusan_verzet_pihak1;
		$data['pemberitahuan_putusan_verzet_pihak2']=$row->pemberitahuan_putusan_verzet_pihak2;
		$data['current_date'] = date('d/m/Y');
		$this->load->view('perkara_tab/verzet/form_verzet_pemberitahuan', $data);
	}

	function validateInputPemberitahuanVerzet(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$dataPemberitahuan = array(
			'diperbaharui_oleh'=>$this->session->userdata('username'),
			'diperbaharui_tanggal'=>date('Y-m-d H:i:s')					
		);

		$curr_date = date('Y-m-d');
		$todayDate = date('d/m/Y');
		$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
		$tglPutusan = $this->ikrar->getTglPutusanVerzet($idperkara);
		if(empty($tglPutusan)){
			echo json_encode(array('st'=>0,'msg'=>'Data Putusan Masih Kosong'));
			return;
		}
		$tglpemberitahuanpihak1 = $this->input->post('tgl_pemberitahuan_pihak1', TRUE);
		$tglpemberitahuanpihak2 = $this->input->post('tgl_pemberitahuan_pihak2', TRUE);
	
		$tglPemberitahuanPihak1 = $this->input->post('tgl_pemberitahuan_pihak1', TRUE);
		if(!empty($tglPemberitahuanPihak1)){
			$tglPemberitahuanPihak1 = $this->tanggalhelper->convertToMysqlDate($tglPemberitahuanPihak1);
			if($tglPemberitahuanPihak1==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPemberitahuanPihak1,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan '.$this->nativesession->getLangguage('verzet').' Kepada Pemohon Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglPemberitahuanPihak1);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pemberitahuan '.$this->nativesession->getLangguage('verzet').' Kepada Pemohon Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$tglPemberitahuanPihak1);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan '.$this->nativesession->getLangguage('verzet').' Kepada Pemohon Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}
			$dataPemberitahuan['pemberitahuan_putusan'] = $tglPemberitahuanPihak1;
			$dataPemberitahuan['pemberitahuan_putusan_verzet_pihak1'] = $tglPemberitahuanPihak1;
		}
		
		$tglPemberitahuanPihak2 = $this->input->post('tgl_pemberitahuan_pihak2', TRUE);
		if(!empty($tglPemberitahuanPihak2)){
			
			$tglPemberitahuanPihak2 = $this->tanggalhelper->convertToMysqlDate($tglPemberitahuanPihak2);
			if($tglPemberitahuanPihak2==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPemberitahuanPihak2,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan '.$this->nativesession->getLangguage('verzet').' Kepada Termohon Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglPemberitahuanPihak2);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pemberitahuan '.$this->nativesession->getLangguage('verzet').' Kepada Termohon Dihari Libur, Sabtu dan Minggu.'));
				return;
			}
			
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$tglPemberitahuanPihak2);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan '.$this->nativesession->getLangguage('verzet').' Kepada Termohon Tidak Boleh Kurang Dari Tanggal Putusan. '.$this->tanggalhelper->convertDayDate($tglPutusan)));
				return;
			}

			$dataPemberitahuan['pemberitahuan_putusan_verzet_pihak2'] = $tglPemberitahuanPihak2;
			
			if(empty($tglpemberitahuanpihak1)){
				$dataPemberitahuan['pemberitahuan_putusan'] = $tglPemberitahuanPihak2;
			}else{
				$dataPemberitahuan['pemberitahuan_putusan'] = $tglPemberitahuanPihak1;
			}
		}
		
		if(empty($tglpemberitahuanpihak1) AND empty($tglpemberitahuanpihak2)){
			echo json_encode(array('st'=>0,'msg'=>'Mohon Mengisikan Data Tanggal Pemberitahuan'));
			return;
		}

		$result = $this->ikrar->updateDataPemberitahuan($idperkara,$dataPemberitahuan);
		if($result){
			echo json_encode(array('st'=>1,'msg'=>'Data Pemberitahuan Berhasil Disimpan'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
			return;
		}
	}

	function validateDeletePemberitahuan(){
		if(empty($_POST)){
			show_404();
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
		$delData = $this->ikrar->deleteDataPemberitahuan($idperkara);
		if($delData){
			echo json_encode(array('st'=>1,'msg'=>'Data Pemberitahuan Putusan '.$this->nativesession->getLangguage('verzet').' Berhasil DiHapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Data Pemberitahuan Putusan '.$this->nativesession->getLangguage('verzet').' Gagal.'));
			return;
		}
	}

	function validateDeletePutusan(){
		if(empty($_POST)){
			show_404();
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
		$delData = $this->ikrar->deleteDataPutusan($idperkara);
		if($delData){
			echo json_encode(array('st'=>1,'msg'=>'Data Penetapan Ikrar Talak Berhasil DiHapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Data Penetapan Ikrar Talak Gagal.'));
			return;
		}
	}

	
	function verzet_minutasi(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($data['enc']));
		if(empty($data['perkara_id']) OR intval($data['perkara_id'])<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
		$row=$this->ikrar->get_no_perkara($data['perkara_id']);
		$data['nomor_perkara']	= $row->nomor_perkara;
		$data['idalurperkara'] = $row->alur_perkara_id;

		if($data['idalurperkara']==9){
			$data['tahapan'] = 13;
			$data['tanggal_putusan']=$this->ikrar->getTanggalDismissal($data['perkara_id']);
		}else{
			$data['tahapan'] = 16;
			$data['tanggal_putusan']=$row->tanggal_putusan;
		}
		$data['tanggal_pendaftaran_verzet']	= $row->tanggal_pendaftaran_verzet;
		$data['putusan_verzet']=$row->putusan_verzet;
		$data['pemberitahuan_putusan_verzet_pihak1']=$row->pemberitahuan_putusan_verzet_pihak1;
		$data['pemberitahuan_putusan_verzet_pihak2']=$row->pemberitahuan_putusan_verzet_pihak2;
		$data['tanggal_minutasi_verzet']=$row->tanggal_minutasi_verzet;
		$data['current_date'] = date('d/m/Y');
		$this->load->view('perkara_tab/verzet/form_verzet_minutasi', $data);
		
	}

	function validateInputTanggalMinutasiVerzet(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}		

		$curr_date = date('Y-m-d');
		$todayDate = date('d/m/Y');
		$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
		$tglPemberitahuanPihak1 = $this->ikrar->getTglPemberitahuanPihak1($idperkara);
		$tglPemberitahuanPihak2 = $this->ikrar->getTglPemberitahuanPihak2($idperkara);
		if(empty($tglPemberitahuanPihak1) AND empty($tglPemberitahuanPihak2)){
			echo json_encode(array('st'=>0,'msg'=>'Data Pemberitahuan Kepada Para Pihak Masih Kosong'));
			return;
		}
		
		//$tanggalminutasiverzet = $this->ikrar->getTanggalMinutasiVerzet($idperkara);
		$tanggalminutasiverzet = $this->input->post('tanggal_minutasi', TRUE);
		#$tglpemberitahuanpihak1 = $this->input->post('tgl_pemberitahuan_pihak1', TRUE);
		#$tglpemberitahuanpihak2 = $this->input->post('tgl_pemberitahuan_pihak2', TRUE);
		#$tanggalminutasiverzet = $this->input->post('tanggalminutasiverzet', TRUE);
		if(empty($tanggalminutasiverzet)){
			echo json_encode(array('st'=>0,'msg'=>'Mohon Mengisikan Data Tanggal Minutasi'));
			return;
		}
		
		if(!empty($tanggalminutasiverzet)){
			$tanggalminutasiverzet = $this->tanggalhelper->convertToMysqlDate($tanggalminutasiverzet);
			if($tanggalminutasiverzet==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tanggalminutasiverzet,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Minutasi '.$this->nativesession->getLangguage('verzet').' Kepada Pemohon Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tanggalminutasiverzet);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Minutasi '.$this->nativesession->getLangguage('verzet').' Kepada Pemohon Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPemberitahuanPihak1, $tanggalminutasiverzet);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Minutasi '.$this->nativesession->getLangguage('verzet').' Tidak Boleh Kurang Dari Tanggal Pemberitahuan Putusan. '.$this->tanggalhelper->convertDayDate($tglPemberitahuanPihak1)));
				return;	
			}
			//$dataPemberitahuan['pemberitahuan_putusan_verzet_pihak1'] = $tglPemberitahuanPihak1;
			//$tanggalminutasiverzet['tanggal_minutasi_verzet'] = $tanggalminutasiverzet;

			$selisih = $this->tanggalhelper->getSelisihHari($tglPemberitahuanPihak2, $tanggalminutasiverzet);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Minutasi '.$this->nativesession->getLangguage('verzet').' Tidak Boleh Kurang Dari Tanggal Pemberitahuan Putusan. '.$this->tanggalhelper->convertDayDate($tglPemberitahuanPihak2)));
				return;	
			}
			//$dataPemberitahuan['pemberitahuan_putusan_verzet_pihak2'] = $tglPemberitahuanPihak2;
			//$dataPemberi['tanggal_minutasi_verzet'] = $tanggalminutasiverzet;
			$dataPemberi = array(
				'tanggal_minutasi_verzet' => $tanggalminutasiverzet,
				'diperbaharui_oleh'=>$this->session->userdata('username'),
				'diperbaharui_tanggal'=>date('Y-m-d H:i:s')					
			);	
		}
		
			

		$result = $this->ikrar->updateDataMinutasi($idperkara,$dataPemberi);
		if($result){
			echo json_encode(array('st'=>1,'msg'=>'Data Minutasi Berhasil Disimpan'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
			return;
		}
	}

	function validateDeleteMinutasi(){
		if(empty($_POST)){
			show_404();
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->load->model('ikrar_talak/ikrar_talak_m','ikrar');
		$delData = $this->ikrar->deleteDataMinutasi($idperkara);
		if($delData){
			echo json_encode(array('st'=>1,'msg'=>'Data Tanggal Minutasi'.$this->nativesession->getLangguage('verzet').' Berhasil DiHapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Data Minutasi '.$this->nativesession->getLangguage('verzet').' Gagal.'));
			return;
		}
	}
}












