<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Setting_bas_c extends CI_Controller {

	function __construct(){
		parent::__construct();
		if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }       
        $this->load->helper('text');
	}

	function index(){
		$jenis_pengadilan=$this->session->userdata('jenis_pengadilan');
		$enc = $this->nativesession->get_flash_session('enc');
		$this->nativesession->set('enc', $enc);
		$perkara_id=$this->encrypt->decode(base64_decode($enc));
		$sidang_id = $this->nativesession->get_flash_session('sidang_id');
		$this->nativesession->set('sidang_id', $sidang_id);
		$this->load->model('bas/info_perkara', 'perkara');
		$result = ($this->perkara->getInfoPerkara($perkara_id)->result_array());
		$data = $result[0];
		$result=$this->perkara->get_info_sidang($sidang_id, $perkara_id)->result_array();
		$data['arr_info_sidang'] = $result[0];
		$data['enc']=$enc;
		$data['perkara_id']=$perkara_id;
		$result=$this->perkara->get_data_bas($sidang_id);
		if ($result->num_rows()!=0){
			$data['info_bas']=$result->result();
			$tes = $result->result();
		}else{
			$data['info_bas']=array();
		};
		foreach ($data['info_bas'] as $row) {
			if ($row->jenis_agenda_id==6 || $row->jenis_agenda_id==7){
				$result=$this->perkara->get_data_tanya_jawab($sidang_id);
				break;
			}
		}
		$data['info_tanya_jawab']=array();
		if (count($data['info_bas'])>0){
			$data['info_tanya_jawab']=$result->result();
		}
		$penutup_id=$this->perkara->get_penutup_bas($perkara_id, $sidang_id);
		if ($penutup_id->num_rows()>0){
			$penutup_id=$penutup_id->row()->agenda_id;
		}else{
			$penutup_id='';
		}
		$data['penutup_id']=$penutup_id;
		$data['list_penutupan']=$this->perkara->getListPenutupan();
		$this->load->view('bas/setting_bas_v', $data);
	}

	function tambah_agenda_bas($no_urut=0){
		$alur_perkara_id=$this->nativesession->get_flash_session('alur_perkara_id');
		$enc = $this->nativesession->get_flash_session('enc');
		$data['enc']=$enc;
		$this->load->model('bas/info_perkara', 'perkara');
		$result=$this->perkara->get_jenis_agenda()->result_array();
		$data['jenis_agenda']=$result;
		$data['no_urut'] = $no_urut;
		$this->load->view('bas/tambah_agenda_bas_v', $data);	
	}

	function get_list_pihak(){
		if ($this->input->post('status_pihak_id')){
			$status_pihak_id = $this->input->post('status_pihak_id', true);
			$perkara_id = $this->nativesession->get('perkara_id');
			$this->load->model('bas/info_perkara', 'perkara');
			switch($status_pihak_id){
				case '1':
					//saksi pihak 1
					$table='perkara_pihak5';
					$result=$this->perkara->get_list_pihak($table, $perkara_id,$status_pihak_id)->result();
				break;
				case '2':
					//saksi pihak 2
					$table='perkara_pihak5';
					$result=$this->perkara->get_list_pihak($table, $perkara_id,$status_pihak_id)->result();
				break;
				case '3':
					//saksi pihak 3
					$table='perkara_pihak5';
					$result=$this->perkara->get_list_pihak($table, $perkara_id,$status_pihak_id)->result();
				break;
			}
			$res='';
			foreach ($result as $row) {
				$res.="<option value='".$row->id."'>".$row->nama."</option> ";
			}
			echo $res;
		}
	}
	function get_agenda_param(){
		if ($this->input->post('agenda_id')){
			$ada_ck=false;
			$agenda_id=$this->input->post('agenda_id', true);
			$this->load->model('bas/info_perkara', 'perkara');
			$result=$this->perkara->get_agenda($agenda_id)->result();
			if ($agenda_id==4){ 
				foreach ($result as $row) {
					$data['id']=$row->id;
				}
				$this->load->model('putusan/data_putusan', 'putusan');
				$perkara_id = $this->nativesession->get('perkara_id');
				$data['perkara_id']=$perkara_id;
				$data['enc']=base64_encode($this->encrypt->encode($perkara_id));
				$data['agenda_id']=$agenda_id;
				$result=$this->putusan->getDataPutusanSela($perkara_id, 'else');
				$data['arr_put_sel']=$result->result();
				$res=$this->load->view('bas/putusan_sela', $data);
			}elseif ($agenda_id==13){ 
				foreach ($result as $row) {
					$data['id']=$row->id;
				}
				$this->load->model('putusan/data_putusan_akhir', 'putusan');
				$perkara_id = $this->nativesession->get('perkara_id');
				$data['perkara_id']=$perkara_id;
				$data['enc']=base64_encode($this->encrypt->encode($perkara_id));
				$data['agenda_id']=$agenda_id;
				$temp=$this->perkara->get_agenda($agenda_id)->result();
				$data['id']=$temp[0]->id;
				$result=$this->putusan->getDataPutusanAkhir($perkara_id);
				$data['arr_put_akhir']=$result->result();
				$res=$this->load->view('bas/putusan_akhir', $data);
			}elseif ($agenda_id==6){ 
				foreach ($result as $row) {
					$data['id']=$row->id;
				}
				$this->load->model('saksi/saksi_m', 'saksi');
				$perkara_id = $this->nativesession->get('perkara_id');
				$data['perkara_id']=$perkara_id;
				$data['enc']=base64_encode($this->encrypt->encode($perkara_id));
				$data['agenda_id']=$agenda_id;
				$result=$this->saksi->get_data_saksi($perkara_id);
				$data['arr_saksi']=$result->result();
				$res=$this->load->view('bas/pemeriksaan_saksi_v', $data);
			}elseif ($agenda_id==107){ 
				foreach ($result as $row) {
					$data['id']=$row->id;
				}
				$this->load->model('saksi/saksi_m', 'saksi');
				$perkara_id = $this->nativesession->get('perkara_id');
				$data['perkara_id']=$perkara_id;
				$data['enc']=base64_encode($this->encrypt->encode($perkara_id));
				$data['agenda_id']=$agenda_id;
				$result=$this->saksi->get_data_saksi($perkara_id);
				$data['arr_saksi']=$result->result();
				$res=$this->load->view('bas/pemeriksaan_saksi_tun_v', $data);
			}elseif ($agenda_id==108){ 
				foreach ($result as $row) {
					$data['id']=$row->id;
				}
				$this->load->model('saksi/saksi_m', 'saksi');
				$perkara_id = $this->nativesession->get('perkara_id');
				$data['perkara_id']=$perkara_id;
				$data['enc']=base64_encode($this->encrypt->encode($perkara_id));
				$data['agenda_id']=$agenda_id;
				$result=$this->saksi->get_data_saksi($perkara_id);
				$data['arr_saksi']=$result->result();
				$res=$this->load->view('bas/pemeriksaan_saksi_tun_v', $data);
			}elseif($agenda_id==7){
				foreach ($result as $row) {
					$data['id']=$row->id;
				}
				$perkara_id = $this->nativesession->get('perkara_id');
				$data['perkara_id']=$perkara_id;
				$data['enc']=base64_encode($this->encrypt->encode($perkara_id));
				$data['agenda_id']=$agenda_id;
				$data['arr_terdakwa']=$this->perkara->get_list_pihak('perkara_pihak2', $perkara_id)->result();
				$res=$this->load->view('bas/pemeriksaan_terdakwa_v', $data);
			}else{
				$opsi=array(); 
				$urutan=0;$i=0;
				$res='';$textarea=array();
				foreach ($result as $row) {
					if ($row->urutan==0){
						$konten_dokumen=$row->konten_dokumen;
						//$res.='<label>'.$konten_dokumen.'</label>';
					}else{
						//$opsi[$row->urutan]=$row->konten_dokumen;
						if($row->urutan!=1){
							
							if (strpos($row->type,'dropdown') !== false) {
								$res.="<option value='".$row->id."'>".$row->preview."</option>";
							}
							if($i==count($result)){
								$res.='</select></span></br>';	
							}
						}else{
							$res.='<label>Opsi '.$row->urutan."</label> ";
							if (strpos($row->type,'dropdown') !== false) {
								$res.="<span class='custom-dropdown custom-dropdown--emerald' style='width:300px'>
										<select name='select_".$agenda_id."' style='width:300px' class='custom-dropdown__select custom-dropdown__select--white options_ck dynamic'>";	
								$res.="<option value='".$row->id."'>".$row->preview."</option>";
							}
						}
					}
					if (strpos($row->type,'input_text') !== false) {
						if (!$ada_ck){
							#configurasi CKeditor, this editior has been costumize for SIPP need.
							$this->load->library('ckeditor');
							$this->ckeditor->basePath = base_url().'resources/ckeditor/';
							$this->ckeditor->config['toolbar'] = array(
								array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
									'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
										'-', 'RemoveFormat','-', 'Blockquote',
										'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
										'-','Undo','Redo','-','NumberedList','BulletedList','/',
										'-','Image'),
								array('-','Format', 'Font', 'FontSize',
									'-','TextColor', 'BGColor','Table',
									'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
									'-','Print','Preview'
									));
							$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
							$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
							$this->ckeditor->config['resize'] = 'false';
							$this->ckeditor->config['language'] = 'en';
							$this->ckeditor->config['width'] = '810px';
							$this->ckeditor->config['height'] = '250px';
						}
						$ada_ck=true;
						$textarea[]='<div id="ckdiv"><label hidden class="isian" id="lbl_isian_'.$row->id.'">Isian: </label></br><textarea style ="height:0px;display:none;" class="textarea" id="text_'.$row->id.'" name="text_'.$row->id.'">'.$row->preview.'</textarea></br></div>';
						$this->ckeditor->replace('text_'.$row->id);

					}
					$urutan=$row->urutan;$i++;
				}
				$res.='</select></span></br>';
				foreach ($textarea as $value) {
					$res.=$value;
				}
			}
			
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> '));
			return;
		}
		echo $res; 
	}
	function get_preview(){
		if ($this->input->post()){
			$param = $this->input->post('param',true);
			$agenda_id = $this->input->post('agenda_id',true);
			$isian=$this->input->post('isian', true);
			$enc=$this->input->post('enc', true);
			$this->load->model('bas/info_perkara', 'perkara');
			$result=$this->perkara->get_jenis_agenda($agenda_id)->result();
			if ($this->input->post('no_urut')==1){
				$res=$result[0]->konten_dokumen;	
			}else{
				$res='';
			}
			$arr_param = explode('&', $param);
			$id=array();$urutan=array();
			$where='';$i=1;
			$sl_tanggapan_put_terdakwa='';
			$sl_tanggapan_put_oditur='';
			foreach ($arr_param as $val) {
				$arr=explode('=',$val);	
				if (strpos($arr[0],'select') !== false) {
					$urutan[]=$arr[1];
					$id[]=$arr[1];
					$where.= ' id='.$arr[1];
					if ($i<=(count($arr_param))){
						$where.=' OR ';
					}
				}
				if ($arr[0]=='sl_tanggapan_put_terdakwa'){
					$sl_tanggapan_put_terdakwa=$arr[1];
				}
				if ($arr[0]=='sl_tanggapan_put_oditur'){
					$sl_tanggapan_put_oditur=$arr[1];
				}
				$i++;
			} 
			$where.=' urutan=0';
			$result=$this->perkara->get_preview($agenda_id, $where)->result();
			foreach ($result as $row) {
				$res.=$row->konten_dokumen.' ';
			}
			if ($isian!=''){
				$res = str_replace('#isian#',''.$isian.'',$res);
			}
			if ($agenda_id==9){
				$perkara_id=$this->encrypt->decode(base64_decode($enc));
				$result=$this->perkara->getInfoPerkara($perkara_id)->result();
				$isian_penuntutan = ($result[0]->isi_penuntutan);
				if ($isian_penuntutan!=''){
					$res = str_replace('#isian_penuntutan#',''.$isian_penuntutan.'',$res);
				}else{
					$res = str_replace('#isian_penuntutan#','[PENUNTUTAN BELUM DIINPUT KEDALAM APLIKASI SIPP]',$res);
				}
			}elseif ($agenda_id==4){
				$perkara_id=$this->encrypt->decode(base64_decode($enc));
				$result=$this->perkara->getInfoPerkara($perkara_id)->result();
				$isian_penuntutan = ($result[0]->isi_penuntutan);
				if ($isian_penuntutan!=''){
					$res = str_replace('#isian_putusan_sela#',''.$isian_penuntutan.'',$res);
				}else{
					$res = str_replace('#isian_putusan_sela#','[PENUNTUTAN BELUM DIINPUT KEDALAM APLIKASI SIPP]',$res);
				}
			}
			if($sl_tanggapan_put_terdakwa!=''){
				switch ($sl_tanggapan_put_terdakwa) {
					case '1':
						$res = str_replace('#sikap_terdakwa_putusan#','menerima putusan',$res);
					break;
					case '2':
						$res = str_replace('#sikap_terdakwa_putusan#','mengajukan grasi',$res);
					break;
					case '3':
						$res = str_replace('#sikap_terdakwa_putusan#','mengajukan banding',$res);
					break;
					case '4':
						$res = str_replace('#sikap_terdakwa_putusan#','belum menyatakan sikap',$res);
					break;
				}
			}
			if($sl_tanggapan_put_oditur!=''){
				switch ($sl_tanggapan_put_oditur) {
					case '1':
						$res = str_replace('#sikap_jaksa_putusan#','menerima putusan',$res);
					break;
					case '2':
						$res = str_replace('#sikap_jaksa_putusan#','mengajukan banding',$res);
					break;
					case '4':
						$res = str_replace('#sikap_jaksa_putusan#','belum menyatakan sikap',$res);
					break;
				}
			}
			$res = str_replace('#jaksa#','Oditur Militer',$res);
			$res = str_replace('#tunggal/ketua#','Hakim Ketua',$res);
			$res = str_replace('#hakim/majelis#','Majelis Hakim',$res);
			print_r($res);
		}
	}
	 


	function cetak(){
		$arr_agenda_id=array();
		$arr_id=array();$arr_isian=array();$arr_tanya_jawab=array();
		$segment = $this->uri->segment_array();
		$perkara_id=$this->encrypt->decode(base64_decode($segment[3]));
		$this->perkara_id=$perkara_id;
		$sidang_id=$segment[4];
		$penutup_id='';
		$arr_tanggapan_put=array();
		$arr_post=$this->input->post();
		//print_r($arr_post);exit;
		foreach ($arr_post as $key => $value) {
			if (is_numeric($key)){
				$value= json_decode($value);
				if (($value->name=='agenda_id[]') !== false) {
					$arr_agenda_id[]=$value->value;
				}elseif (strpos($value->name,'text') !== false){
					$arr_isian[$value->name]=$this->templatehelper->cleanHtmlTagSpecial($value->value);
				}elseif (strpos($value->name,'id[]') !== false){
					$arr_id[]=$value->value;
				}elseif ((strpos($value->name,'pihak_ke') !== false) 
					OR (strpos($value->name,'sumber_id') !== false)
					OR (strpos($value->name,'penanya_t') !== false)
					OR (strpos($value->name,'pertanyaan_t') !== false)
					OR (strpos($value->name,'jawaban_t') !== false)
					OR (strpos($value->name,'kenal') !== false)
					OR (strpos($value->name,'tanggapan_terdakwa') !== false)
					OR (strpos($value->name,'urutan_sumber') !== false)
					OR (strpos($value->name,'urutan_penanya') !== false)
					OR (strpos($value->name,'urutan_pertanyaan') !== false)
					OR (strpos($value->name,'tanya_jawab_agenda_id') !== false)
					)
				{
					$arr=explode('__', $value->name);
					if ($arr[0]==='pihak_ke'){	
						switch ($value->value) {
							case '13':
								$table='perkara_pihak5';
								$agenda_id='6';
							break;
							case '1':
								$table='perkara_pihak1';
								$agenda_id='0'; //sumber oditur acara sidang apa?
							break;
							case '8':
								$table='perkara_pengacara';
								$agenda_id='0'; //sumber penasihat_hukum acara sidang apa?
							break;
							case '2':
								$table='perkara_pihak2';
								$agenda_id='7';
							break;
							default:
								$table='perkara_pihak5';
							break;
						}
						$arr_val=array('perkara_id'=>$perkara_id, 'sidang_id'=>$sidang_id, 'jenis_agenda_id'=>$agenda_id, $arr[0]=>$value->value, 'tabel_asal_sumber'=>$table);
					}else if($arr[0]==='tanya_jawab_agenda_id'){
						if($value->value>100)$arr_tanya_jawab[$arr[1]]['jenis_agenda_id']=$value->value;
					}else{
						$arr_val=array($arr[0]=>$value->value);
					}
					if(empty($arr_tanya_jawab[$arr[1]])){
						$arr_tanya_jawab[$arr[1]] = array();
					}
					$arr_tanya_jawab[$arr[1]] = array_merge($arr_tanya_jawab[$arr[1]], $arr_val);
				}elseif (strpos($value->name,'sl_tanggapan') !== false){
					$arr_tanggapan_put[$value->name]=$value->value;
				}else{
					echo 'Gagal parse post data';
					exit();
				} 
			}else{
				$penutup_id=$value;
			}
		}
		$data=array();
		$data['perkara_id']=$perkara_id;
		$data['sidang_id']=$sidang_id;
		$insert_batch_tanya_jawab=array();
		$data['pemeriksaan_saksi']=false;
		$data['pemeriksaan_terdakwa']=false;
		
		foreach ($arr_tanya_jawab as $row) {
			if (!array_key_exists('kenal', $row)) {
			    $row['kenal']='';
			    $row['tanggapan_terdakwa']='';
			    $data['pemeriksaan_terdakwa']=true;
			    if($this->session->userdata('jenis_pengadilan')=='3')$data['pemeriksaan_saksi']=true;
			}else{
				if ($row['kenal']==''){
					$data['pemeriksaan_terdakwa']=true;
				}else{
					$data['pemeriksaan_saksi']=true;
				}
			}
			$insert_batch_tanya_jawab[]=$row;
		}
		$this->load->model('bas/info_perkara', 'perkara');
		$result = ($this->perkara->getInfoPerkara($perkara_id)->result_array());
		foreach ($result[0] as $key =>$val) {
			$data[$key]=$val;
		}

		//getinfosidang
		$result=$this->perkara->get_info_sidang($sidang_id, $perkara_id)->result();
		$tanggal_sidang=$result[0]->tanggal_sidang;
		$urutan = ($result[0]->urutan);
		//ambil kontent pembuka bas
		if($this->session->userdata('jenis_pengadilan')==2){
			$jenis_agenda_id_pembuka =0;
		}elseif($this->session->userdata('jenis_pengadilan')==3){
			$jenis_agenda_id_pembuka =100;
		}elseif($this->session->userdata('jenis_pengadilan')==4){
			$jenis_agenda_id_pembuka =200;
		}
		if ($urutan==1){
			$data['lanjutan']='';
			$result=$this->perkara->get_preview($jenis_agenda_id_pembuka, 'urutan=1')->result();
		}else{
			$data['lanjutan']=' LANJUTAN KE '.$urutan;
			$result=$this->perkara->get_preview($jenis_agenda_id_pembuka, 'urutan=2')->result();
		}
		$data['pembuka_bas']=$this->templatehelper->cleanHtmlTagSpecial(ascii_to_entities($result[0]->konten_dokumen));
		//ambil kontent penutup bas
		switch ($this->session->userdata('jenis_pengadilan')) {
			case '2':
				$result=$this->perkara->get_preview(-1, 'id='.$penutup_id)->result();
			break;
			case '3':
				$result=$this->perkara->get_preview(-100, 'id='.$penutup_id)->result();
			break;
			case '4':
				$result=$this->perkara->get_preview(-200, 'id='.$penutup_id)->result();
			break;
		}
		if (count($result)>0){
			$data_penutup=array();
			$data_penutup['perkara_id']=$perkara_id;
			$data_penutup['sidang_id']=$sidang_id;
			$data_penutup['agenda_id']=$penutup_id;
			$data_penutup['redaksi']=$this->templatehelper->cleanHtmlTagSpecial(ascii_to_entities($result[0]->konten_dokumen));
			$data_penutup['diinput_tanggal']=date('Y-m-d H:i:s');
			$data_penutup['diinput_oleh']=$this->session->userdata('username');
			$this->perkara->add_penutup_bas($data_penutup);
			$data['penutup_bas']=$this->templatehelper->cleanHtmlTagSpecial(ascii_to_entities($result[0]->konten_dokumen));
		}else{
			$data['penutup_bas']='Redaksi Penutup Tidak Ada dalam Database ';
		}
		
		$isian_penuntutan='';
		foreach ($arr_agenda_id as $val) {
			if ($val==9){
				$penuntutan=$this->perkara->getInfoPerkara($perkara_id)->result();
				$isian_penuntutan = ($penuntutan[0]->isi_penuntutan);
			}
		}
		//print_r($arr_agenda_id);exit();
		$result=$this->perkara->get_jenis_agenda($arr_agenda_id[0])->result();
		$res=$this->templatehelper->cleanHtmlTagSpecial(ascii_to_entities($result[0]->konten_dokumen)).' ';
		$where='';$i=1;
		foreach ($arr_id as $val) {
			$where.= ' a.id="'.$val.'"';
			if($i<count($arr_id)){
				$where.=' OR ';	
			}
			$i++;
		};
		$result=$this->perkara->cetak_preview(1000, $where)->result();
		//print_r($result);
		//exit();
		$i=1;
		$data_insert = array();
		$data_sidang_detil=array();
		foreach ($result as $row) {
			if (strpos($row->type,'input_text') !== false) {
				$row->konten_dokumen = str_replace('#isian#',''.$arr_isian['text_'.$row->id].'',$row->konten_dokumen);
				$arr_data_sidang_detil[$row->jenis_agenda_id]=array('jenis_agenda_id'=>$row->jenis_agenda_id,
																'uraian'=>$arr_isian['text_'.$row->id],
																'diinput_oleh' => $this->session->userdata('username'),
								    							'diinput_tanggal' => date("Y-m-d h:i:s",time())
								    						);
			}elseif (strpos($row->type,'tanya_jawab') !== false){
				$arr_data_sidang_detil[$row->jenis_agenda_id]=array('jenis_agenda_id'=>$row->jenis_agenda_id,
																'uraian'=>$row->konten_dokumen,
																'diinput_oleh' => $this->session->userdata('username'),
								    							'diinput_tanggal' => date("Y-m-d h:i:s",time())
								    						);
			}
			$res.=$this->templatehelper->cleanHtmlTagSpecial(ascii_to_entities($row->konten_dokumen)).' ';
			if ($i==1){
				$row->konten_dokumen=$res;
			}
			$data_insert[]=array(
			      'perkara_id' => $perkara_id,
			      'sidang_id' => $sidang_id,
			      'jenis_agenda_id' => $row->jenis_agenda_id,
			      'nama_agenda' => $row->nama,
			      'agenda_id' => $row->id,
			      'urutan' => $i,
			      'redaksi' => $this->templatehelper->cleanHtmlTagSpecial(ascii_to_entities($row->konten_dokumen)),
			      'diinput_oleh' => $this->session->userdata('username'),
			      'diinput_tanggal' => date("Y-m-d h:i:s",time())
			   );
			$i++;
		};
		//print_r($arr_data_sidang_detil);
		//exit();
		if (!empty($arr_data_sidang_detil)){
			foreach ($arr_data_sidang_detil as $row) {
				foreach ($row as $key => $value) {
					$row[$key]=$this->templatehelper->cleanHtmlTagSpecial(ascii_to_entities($value));
				}
				$data_sidang_detil[]=$row;
			}
			$this->perkara->simpan_sidang_detil($data_sidang_detil, $perkara_id, $sidang_id);	
		}
		
		if (!empty($insert_batch_tanya_jawab)){
			$this->perkara->simpan_tanya_jawab($insert_batch_tanya_jawab, $perkara_id, $sidang_id);	
		}
		if ($data['pemeriksaan_saksi']){
			if($this->session->userdata('jenis_pengadilan')=='2'){
				$data['info_pemeriksaan_saksi']=$this->perkara->get_info_pemeriksaan($perkara_id, $sidang_id, 6)->result();		
				$data['info_pihak_saksi']=$this->perkara->get_info_pihak($perkara_id, $sidang_id, 6)->result();		
			}else{
				$data['info_pemeriksaan_saksi']=$this->perkara->get_info_pemeriksaan($perkara_id, $sidang_id, $insert_batch_tanya_jawab[0]['jenis_agenda_id'])->result();		
				$data['info_pihak_saksi']=$this->perkara->get_info_pihak($perkara_id, $sidang_id, $insert_batch_tanya_jawab[0]['jenis_agenda_id'])->result();		
			}
		}
		if ($data['pemeriksaan_terdakwa']){
			$data['info_pemeriksaan_terdakwa']=$this->perkara->get_info_pemeriksaan($perkara_id, $sidang_id, 7)->result();		
			$data['info_pihak_terdakwa']=$this->perkara->get_info_pihak($perkara_id, $sidang_id, 7)->result();		
		}
		if ($isian_penuntutan!=''){
			$res = str_replace('#isian_penuntutan#',''.$isian_penuntutan.'',$res);
		}else{
			$res = str_replace('#isian_penuntutan#','[PENUNTUTAN BELUM DIINPUT KEDALAM APLIKASI SIPP]',$res);
		}
		if (!empty($arr_tanggapan_put)){
			switch ($arr_tanggapan_put['sl_tanggapan_put_terdakwa']) {
				case '1':
					$res = str_replace('#sikap_terdakwa_putusan#','menerima putusan',$res);
				break;
				case '2':
					$res = str_replace('#sikap_terdakwa_putusan#','mengajukan grasi',$res);
				break;
				case '3':
					$res = str_replace('#sikap_terdakwa_putusan#','mengajukan banding',$res);
				break;
				case '4':
					$res = str_replace('#sikap_terdakwa_putusan#','belum menyatakan sikap',$res);
				break;
			}
			switch ($arr_tanggapan_put['sl_tanggapan_put_oditur']) {
				case '1':
					$res = str_replace('#sikap_jaksa_putusan#','menerima putusan',$res);
				break;
				case '2':
					$res = str_replace('#sikap_jaksa_putusan#','mengajukan banding',$res);
				break;
				case '4':
					$res = str_replace('#sikap_jaksa_putusan#','belum menyatakan sikap',$res);
				break;
			}
		}
		$data['jenis_pengadilan']=$this->session->userdata('jenis_pengadilan');
		$result=$this->perkara->get_info_sidang($sidang_id, $perkara_id);
		$data['info_sidang']=$result->result();
		$result=$this->perkara->get_info_sidang_tundaan($sidang_id, $perkara_id);
		$data['info_sidang_tundaan']=$result;
		$data['dataterdakwa']=$this->perkara->getDataTerdakwaMil($perkara_id);
		$data['datapenahanan'] = $this->perkara->getDataPenahananTerdakwaMil($perkara_id);
		$data['susunanMajelis']=$this->perkara->getSusunanMajelisMil($perkara_id);
		$data['konten']=$this->templatehelper->cleanHtmlTagSpecial($res);
		
		//print_r($data_insert);
		//exit();
		if ($this->perkara->add_data($data_insert)){
			$info_pn=$this->perkara->getDataPN()->result();
			$data['info_pn']=$info_pn[0];
			#configurasi CKeditor, this editior has been costumize for SIPP need.
			$this->load->library('ckeditor');
			$this->ckeditor->basePath = base_url().'resources/ckeditor/';
			$this->ckeditor->config['toolbar'] = array(
				array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
					'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
						'-', 'RemoveFormat','-', 'Blockquote',
						'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
						'-','indent','-', 'Undo','Redo','-','NumberedList','BulletedList','/',
						'-','Image'),
				array('-','Format', 'Font', 'FontSize',
					'-','TextColor', 'BGColor','Table',
					'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
					'-','Print','Preview'
					));
			$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
			$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
			$this->ckeditor->config['resize'] = 'false';
			$this->ckeditor->config['language'] = 'en';
			$this->ckeditor->config['width'] = '810px';
			$this->ckeditor->config['height'] = '250px';
			$this->ckeditor->config['extraPlugins'] = 'indentblock';
			$this->ckeditor->config['extraPlugins'] = 'indent';
			
			switch ($this->session->userdata('jenis_pengadilan')) {
				case '2':
					$data['filemaster']= 'master';
					$data['Template']=$this->replace_temp_mil($data);
					$this->load->view('bas/cetak',$data);	
				break;
				case '3':
					$data = array_merge($data,$this->load_data_tun());
					//$data['Template']= $this->get_contens('master_tun');
					$data['Template']=$this->replace_temp_tun($data);
					$this->load->view('bas/cetak_tun_bas',$data,FALSE);	
				break;
				case '4':
					$data = array_merge($data,$this->load_data_agama());
					//$data['Template']= $this->get_contens('master_tun');
					$data['Template']=$this->replace_temp_agama($data);
					$this->load->view('bas/cetak_tun_bas',$data,FALSE);	
				break;
			}
		}else{
			echo "Gagal Cetak !!!";
		}
	}

	function load_data_agama(){
		$this->load->model('generate_template/m_template_bas_pertama_agama','template');
        $data['dataperkara'] = $this->template->getDataPerkara($this->perkara_id);
        $data['datapengadilan'] = $this->template->getDataPA();
        $data['datapenetapanpanitera']=$this->template->getDataPenetapanPanitera($this->perkara_id);
        $data['datapenetapanhakim']=$this->template->getDataPenetapanHakim($this->perkara_id);
        $data['datapaniterapengganti']=$this->template->getDataPP($this->perkara_id);
        $data['datapersidangan']=$this->template->getDataSidang($this->perkara_id);
        $data['datamediator']=$this->template->getDataMediator($this->perkara_id);
        $data['dataputusanverstek']=$this->template->getDataPutusanVerstek($this->perkara_id);
        $data['dataputusansela']=$this->template->getDataPutusanSela($this->perkara_id);
        $data['dataPihak1']=$this->template->get_data_pihak_loop($this->perkara_id,1);
        $data['dataPihak2']=$this->template->get_data_pihak_loop($this->perkara_id,2);
        $data['dataPihak3']=$this->template->get_data_pihak_loop($this->perkara_id,3);
        $data['dataPihak4']=$this->template->get_data_pihak_loop($this->perkara_id,4);
        $data['dataPengacaraPihak1']=$this->template->get_data_pengacara($this->perkara_id,1);
        $data['dataPengacaraPihak2']=$this->template->get_data_pengacara($this->perkara_id,2);        
        $data['dataPengacaraPihak3']=$this->template->get_data_pengacara($this->perkara_id,3); 
        return $data;
	}

	function load_data_tun(){
		$this->load->model('generate_template/m_template_putusan_tun','template');
        $data['dataPN'] = $this->template->get_data_pn($this->perkara_id);
        $data['dataPihak1']=$this->template->get_data_pihak($this->perkara_id,1);
        $data['dataPengacaraPihak1']=$this->template->get_data_pengacara($this->perkara_id,1);
        $data['dataPihak2']=$this->template->get_data_pihak($this->perkara_id,2);
        $data['dataPengacaraPihak2']=$this->template->get_data_pengacara($this->perkara_id,2);
        $data['dataPihak3']=$this->template->get_data_pihak($this->perkara_id,3);
        $data['dataPengacaraPihak3']=$this->template->get_data_pengacara($this->perkara_id,3);
        $data['dataPutusan']=$this->template->get_data_putusan($this->perkara_id)->result();
        return $data;
	}

	function get_contens($filemaster){
		$url = base_url("resources/template/berita_acara/bas_atria/".$filemaster.".rtf");
		$Template = file_get_contents($url);
		return $Template;
	}

	function in_multiarray($sval, $arr){
	    $ret = false;
	    foreach ($arr as $value) {
	        if (is_array($value)){
	            $ret = $ret | $this->in_multiarray($sval, $value);
	        }else{
	            if ($value == $sval){
	                return true;
	            }
	        }
	    }
	    return $ret;
	}

	function looping_majelis_mil($Template, $data){
		foreach ($data as $key => $value) {
			$$key=$value;
		}
		$data = $susunanMajelis;
		$hakim = array();
		$pengacara = array();
		foreach ($data->result() as $row) {
		    if (!$this->in_multiarray($row->nama_hakim, $hakim)){
		        $hakimItem = array();
		        $hakimItem["urutan_hakim"] = $row->urutan_hakim;
		        $hakimItem["jabatan_hakim_id"] = $row->jabatan_hakim_id;
		        $hakimItem["nama"] = $row->nama_hakim;
		        $hakimItem["nrp_hakim"] = $row->nip_hakim;
		        $hakimItem["pangkat_hakim"] = $row->pangkat_hakim;
		        $hakimItem["jabatan_hakim_nama"] = $row->jabatan_hakim_nama;
		        $hakimItem["nama_pp"] = $row->nama_pp;
		        $hakimItem["pangkat_pp"] = $row->pangkat_pp;
		        $hakimItem["nip_pp"] = $row->nip_pp;
		        $hakimItem["nama_om"] = $row->nama_om;
		        $hakimItem["nrp_om"] = $row->nrp_om;
		        $hakimItem["pangkat_om"] = $row->pangkat_om; 
		        $hakimItem["nama_p"] = $row->nama_p;
		        $hakimItem["nrp_p"] = $row->nrp_p;
		        $hakimItem["pangkat_p"] = $row->pangkat_p;
		        $hakim[] = $hakimItem;
		        if ($row->jabatan_hakim_id==1){
		            $this->nrp_hakim_ketua=$row->nip_hakim;
		            $this->pangkat_hakim_ketua=$row->pangkat_hakim;
		        }
		    }
		   if (!$this->in_multiarray($row->nama_p, $pengacara)){
		        $pengacaraPitem = array();
		        $pengacaraPitem["nama_ph"] = $row->nama_p;
		        $pengacara[]=$pengacaraPitem;
		    }
		}

		$hakim_anggotas = '';
		$daftar_majelis = '';
		$data_hakim = $hakim;
		$this->cData_ph = count($pengacara);
		$this->cDataPenahanan = count($this->penahanan_pihak);
		$majelis = true;
		$i=1;$j=1;
		foreach ($data_hakim as $row) {
		    if($row['jabatan_hakim_id']==1){
		        $this->hakim_ketua = $this->templatehelper->standradnaming($row['nama']);
		        $daftar_majelis .= $this->templatehelper->standradnaming($row['nama']).' '.$row['pangkat_hakim'].' NRP. '.$row['nrp_hakim'].' \tab  Sebagai Hakim Ketua;\\par ';
		    }elseif($row['jabatan_hakim_id']==2){
		        if ($i === count($data_hakim)){
		            $hakim_anggotas .= $this->templatehelper->standradnaming($row['nama']).'';
		        }else{
		            if ($j==1 && $i>1){
		                $hakim_anggotas .= $this->templatehelper->standradnaming($row['nama']).'\tab '.$this->hakim_ketua.'\\par \\par \\par ';
		            }else{
		                $hakim_anggotas .= $this->templatehelper->standradnaming($row['nama']).'\\par \\par \\par ';
		            }
		        }
		        $daftar_majelis .= $this->templatehelper->standradnaming($row['nama']).' '.$row['pangkat_hakim'].' NRP. '.$row['nrp_hakim'].' \tab Sebagai Hakim Anggota;\\par ';
		        $nama_p = $this->templatehelper->standradnaming($row['nama_p']).' \tab sebagai Penasihat Hukum;\\par ';
		        $j++;
		    }elseif($row['jabatan_hakim_id']==3){
		        $majelis = false;
		        $daftar_majelis .= $this->templatehelper->standradnaming($row['nama']).' '.$row['pangkat_hakim'].' NRP. '.$row['nrp_hakim'].' \tab Sebagai Hakim;\\par ';
		        $nama_p = $this->templatehelper->standradnaming($row['nama_p']).' \tab sebagai Penasihat Hukum;\\par ';
		        $this->hakim_ketua = $this->templatehelper->standradnaming($row['nama']);
		    }
		    $this->panitera = $this->templatehelper->standradnaming($row['nama_pp']).' '.$row['pangkat_pp'].' NRP. '.$row['nip_pp'].' \tab Sebagai Panitera;\\par ';
		    $this->panitera_ttd = $this->templatehelper->standradnaming($row['nama_pp']);
		    $this->pangkat_panitera_ttd = $this->templatehelper->standradnaming($row['pangkat_pp']);
		    $this->nrp_panitera_ttd = $this->templatehelper->standradnaming($row['nip_pp']);
		    $nama_om='';
		    if ($row['nama_om']!=''){
		    	$nama_om = $this->templatehelper->standradnaming($row['nama_om']).' '.$row['pangkat_om'].' NRP. '.$row['nrp_om'].' \tab Sebagai Oditur Militer;\\par ';
		    }
		    $nama_p='';
		    if ($row['nama_p']!=''){
		    	$nama_p = $this->templatehelper->standradnaming($row['nama_p']).' '.$row['pangkat_p'].' NRP. '.$row['nrp_p'].' \tab sebagai Penasihat Hukum;\\par ';
		    }
		    $i++;
		}
		
		if($majelis){
		    $Template = str_replace('#susunan_majelis#','\ltrpar\qj\li0\ri0\fi0\tqr\tx9356 #susunan_majelis# \ltrpar\qj ',$Template);
		    $Template = str_replace('#susunan_majelis#',$daftar_majelis.$this->panitera.$nama_om.$nama_p,$Template);
		}
		return $Template;
	}

	function looping_terdakwa_mil($Template, $data){
		foreach ($data as $key => $value) {
			$$key=$value;
		}
		$Template = str_replace('#identitas_terdakwa#','\fi-2977\li3828 #identitas_terdakwa# \ltrpar\qj \fi855\li0 ',$Template);
		$Template = str_replace('#identitas_terdakwa_second#','\fi-2977\li3828 #identitas_terdakwa_second# \ltrpar\qj \fi855\li0 ',$Template);
		$numbering = true;
		if($dataterdakwa->num_rows >1){
		    for ($i=0; $i < $dataterdakwa->num_rows; $i++) { 
		        $text = 'terdakwa'.($i+1);
		        $text2='terdakwa_second'.($i+1);
		        if($i==$dataterdakwa->num_rows-1){
		            $Template = str_replace('#identitas_terdakwa#','\b#'.$text.'#\b0',$Template);
		            $Template = str_replace('#identitas_terdakwa_second#','\b#'.$text2.'#\b0',$Template);
		        }else{
		            $Template = str_replace('#identitas_terdakwa#','\b#'.$text.'#\b0\\par'.PHP_EOL.'#identitas_terdakwa#',$Template);
		            $Template = str_replace('#identitas_terdakwa_second#','\b#'.$text2.'#\b0\\par'.PHP_EOL.'#identitas_terdakwa_second#',$Template);
		        }
		    }   
		}else{
		    $numbering = false;
		    $Template = str_replace('#identitas_terdakwa#','#terdakwa#',$Template);
		    $Template = str_replace('#identitas_terdakwa_second#','#terdakwa_second#',$Template);
		}
		$counter = 1;
		$arr_terdakwa = array();
		if (!empty($dataterdakwa->num_rows)){   
		    foreach ($dataterdakwa->result() as $row){
		        $arr_terdakwa[]=$row->pihak_id;
		        if ($dataterdakwa->num_rows==1) {
		            $terdakwa = '\b0\\par ';
		        }else{
		            $terdakwa = '\fi-2977\li3828 \b Terdakwa '.$counter.'\b0\\par ';
		        }
		        $pihak2 = $terdakwa;
		        $pihak2 .= 'Nama \tab : '.$this->templatehelper->standradnaming($row->nama).'\\par ';
		        $pihak2 .= 'Pangkat / Nrp \tab : '.$row->pangkat_terdakwa.'/'.$row->nrp_terdakwa.'\\par ';
		        $pihak2 .= 'J a b a t a n \tab : '.$row->jabatan_terdakwa.'\\par ';
		        $pihak2 .= 'K e s a t u a n \tab : '.$row->kesatuan_terdakwa.'\\par ';
		        $pihak2 .= 'Tempat/tanggal lahir \tab : '.$row->tempat_lahir.'/'.$this->templatehelper->convertKeTglIndo($row->tanggal_lahir).'\\par ';
		        $row->jenis_kelamin = $row->jenis_kelamin == 'P' ? 'Perempuan': 'Laki-laki';
		        $pihak2 .= 'Jenis kelamin \tab : '.$row->jenis_kelamin.'\\par ';
		        $pihak2 .= 'Kewarganegaraan \tab : Indonesia\\par ';
		        $pihak2 .= 'Agama \tab : '.$row->agama_nama.'\\par ';
		        $pihak2 .= 'Tempat tinggal \tab : '.$row->alamat.'\\par \\par ';
		        

		        $pihak3 = $terdakwa;
		        $pihak3 .= 'Nama \tab : '.$this->templatehelper->standradnaming($row->nama).'\\par ';
		        $pihak3 .= 'Pangkat / Nrp \tab : '.$row->pangkat_terdakwa.'/'.$row->nrp_terdakwa.'\\par ';
		        $pihak3 .= 'J a b a t a n \tab : '.$row->jabatan_terdakwa.'\\par ';
		        $pihak3 .= 'K e s a t u a n \tab : '.$row->kesatuan_terdakwa.'\\par ';
		        $pihak3 .= 'Tempat/tanggal lahir \tab : '.$row->tempat_lahir.'/'.$this->templatehelper->convertKeTglIndo($row->tanggal_lahir).'\\par ';
		        $row->jenis_kelamin = $row->jenis_kelamin == 'P' ? 'Perempuan': 'Laki-laki';
		        $pihak3 .= 'Jenis kelamin \tab : '.$row->jenis_kelamin.'\\par ';
		        $pihak3 .= 'Kewarganegaraan \tab : Indonesia\\par ';
		        $pihak3 .= 'Agama \tab : '.$row->agama_nama.'\\par ';
		        $pihak3 .= 'Tempat tinggal \tab : '.$row->alamat.'\\par ';
		        
		        $temp = '';$temp2 = '';
		        $counterpenahanan = 'a';
		        $counterstatuspenahanan = 1;
		        $counterpapera=1;
		        $status_penahanan = '';$this->penahanan_pihak=array();
		        foreach ($datapenahanan->result() as $baris) {
		            if((trim($baris->pihak_id))==$row->pihak_id){
		                $this->penahanan_pihak[]=$baris;
		            }
		        }

		        $jenis_penahanan_id=-100;
		        if (!empty($this->penahanan_pihak)){
		        	//print_r($this->penahanan_pihak);exit();
		            foreach ($this->penahanan_pihak as $val){
		            	if ($val->status_penahanan_id!=5){
		            		$temp = ' '.strtolower($val->status_penahanan.' pada '.$val->jenis_tahanan);	
		            	}else{
		            		$temp = ' '.strtolower($val->status_penahanan);
		            	}
		                
		                $temp2 = '';
		                if ($status_penahanan != $val->status_penahanan || $status_penahanan ===''){
		                    $pihak2 .= '\par\fi-283\li1134 '.$counterstatuspenahanan.'. Terdakwa '.$this->templatehelper->standradnaming($row->nama).' '.$temp.' oleh ';
		                    $counterstatuspenahanan++;
		                }
		                if($val->jenis_penahanan_id==='15'){
		                    $temp2 = ' berdasarkan Keputusan Penahanan Sementara nomor : ';
		                }elseif($val->jenis_penahanan_id==='16'){
		                    $temp2 = ' berdasarkan Keputusan Perpanjangan Penahanan nomor : ';
		                }else{
		                    $temp2 = ' berdasarkan Penetapan Penahanan nomor : ';
		                }
		                $val->oleh=str_replace('Atasan Yang Berhak Menghukum (ANKUM)', ' selaku Ankum', $val->oleh);
		                if ($jenis_penahanan_id!=$val->jenis_penahanan_id && $val->status_penahanan_id!=5){
		                	if ($status_penahanan != $val->status_penahanan || $status_penahanan ===''){
			                	$pihak2.=":\par ";
			                }
		                    switch(intval($val->jenis_penahanan_id)) {
		                        case 15:
		                            $pihak2.='\qj\fi-306\li1418 '.$counterpenahanan.'.\tab '.$val->pejabat_penahan.' '.$val->oleh.' selama '.$val->lama_penahanan.' ('.$this->templatehelper->Terbilang($val->lama_penahanan).') hari sejak tanggal '
		                                .$this->templatehelper->convertKeTglIndo($val->sejak).' sampai dengan tanggal '.$this->templatehelper->convertKeTglIndo($val->sampai).' '
		                                .$temp2.$val->nomor_surat.' tanggal '.$this->templatehelper->convertKeTglIndo($val->tanggal_surat).' \\par ';
		                            $counterpenahanan++;    
		                        break;
		                        case 16:
		                            $pihak2.='\qj\fi-306\li1418 '.$counterpenahanan.'.\tab '.$val->pejabat_penahan.' selaku Perwira Penyerah Perkara memperpanjang penahanan Terdakwa sebagai berikut: \par ';
		                            $pihak2.='\fi-284 \lin1843 '.$counterpapera.'). '.$val->oleh.' selama '.$val->lama_penahanan.' ('.$this->templatehelper->Terbilang($val->lama_penahanan).') hari sejak tanggal '
		                                .$this->templatehelper->convertKeTglIndo($val->sejak).' sampai dengan tanggal '.$this->templatehelper->convertKeTglIndo($val->sampai).' '
		                                .$temp2.$val->nomor_surat.' tanggal '.$this->templatehelper->convertKeTglIndo($val->tanggal_surat).' \\par ';
		                            $counterpenahanan++;$counterpapera++;
		                        break;
		                        case 17:
		                        case 18:
		                        case 19:
		                        case 20:
		                        case 21:
		                            $pihak2.='\fi-284 \lin1843 '.$counterpapera.'). '.$val->oleh.' selama '.$val->lama_penahanan.' ('.$this->templatehelper->Terbilang($val->lama_penahanan).') hari sejak tanggal '
		                                .$this->templatehelper->convertKeTglIndo($val->sejak).' sampai dengan tanggal '.$this->templatehelper->convertKeTglIndo($val->sampai).' '
		                                .$temp2.$val->nomor_surat.' tanggal '.$this->templatehelper->convertKeTglIndo($val->tanggal_surat).' \\par ';
		                            $counterpapera++;
		                        break;
		                        default:
		                            $pihak2.=' \fi-731\li1440\tx1701\tab '.$counterpenahanan.'. \tab '.$val->oleh.' selama '.$val->lama_penahanan.' ('.$this->templatehelper->Terbilang($val->lama_penahanan).') hari sejak tanggal '
		                                .$this->templatehelper->convertKeTglIndo($val->sejak).' sampai dengan tanggal '.$this->templatehelper->convertKeTglIndo($val->sampai).' '
		                                .$temp2.$val->nomor_surat.' tanggal '.$this->templatehelper->convertKeTglIndo($val->tanggal_surat).' \\par ';
		                            $counterpenahanan++;
		                        break;
		                    }
		                }else{
		                	$counterpenahanan = 'a';
		                	if ($val->pejabat_penahan!=0 && $val->pejabat_penahan!=''){
		                		$pihak2.=$val->pejabat_penahan.' selaku '.$val->oleh.' sejak tanggal '.$this->templatehelper->convertKeTglIndo($val->sejak).' berdasarkan surat Nomor : '.$val->nomor_surat.' tanggal '.$this->templatehelper->convertKeTglIndo($val->tanggal_surat).'\par ';
		                	}else{
		                		$pihak2.=$val->oleh.' sejak tanggal '.$this->templatehelper->convertKeTglIndo($val->sejak).' berdasarkan surat Nomor : '.$val->nomor_surat.' tanggal '.$this->templatehelper->convertKeTglIndo($val->tanggal_surat).'\par ';
		                	}
		                }
		                $status_penahanan = $val->status_penahanan;
		                $jenis_penahanan_id=$val->jenis_penahanan_id;
		            }
		        }else{
		            $pihak2 .= 'Terdakwa tidak ditahan \par ';

		        }
		    
		        if($numbering==true){
		            $Template = str_replace('#terdakwa'.$counter.'#',$pihak2,$Template);
		            $Template = str_replace('#terdakwa_second'.$counter.'#',$pihak3,$Template);
		            $Template = str_replace('#terdakwa/paraterdakwa#','Para Terdakwa',$Template);
		            $Template = str_replace('#terdakwa/paraterdakwa2#','PARA TERDAKWA',$Template);
		        }else{
		           $Template = str_replace('#terdakwa#',$pihak2,$Template);
		           $Template = str_replace('#terdakwa_second#',$pihak3,$Template);
		           $Template = str_replace('#terdakwa/paraterdakwa#','Terdakwa',$Template);
		        }
		        $counter++;
		    }
		}
		return $Template;
	}

	function replace_temp_mil($data){
		foreach ($data as $key => $value) {
			$$key=$value;
		}
		
		$url = base_url("resources/template/berita_acara/bas_atria/master.rtf");
		$Template = file_get_contents($url);


		$Template = str_replace('#penutup_bas#',''.$penutup_bas.'',$Template);
		$Template = str_replace('#nomor_perkara#',''.$nomor_perkara.'',$Template);
		$Template = str_replace('#lanjutan#',''.$lanjutan.'',$Template);
		$Template = str_replace('#pembuka_bas#',''.$pembuka_bas.'',$Template);
		$Template = str_replace('#konten_bas#',''.$konten.'',$Template);


		$Template=$this->looping_terdakwa_mil($Template,$data);
		$Template=$this->looping_majelis_mil($Template,$data);
		
		if ($pemeriksaan_saksi){
		    $saksi='';
		    $counter=1;
		    foreach ($info_pihak_saksi as $row) {
		        $text='#saksi'.$counter.'#';
		        if ($counter<count($info_pihak_saksi)){
		            $Template = str_replace('#looping_saksi#',''.$text.' \par '.PHP_EOL.'#looping_saksi#',$Template);    
		        }else{
		            $Template = str_replace('#looping_saksi#',''.$text.' \par ',$Template);
		        }
		        
		        $counter++;
		    }

		    $saksi='';$counter=1;
		    foreach ($info_pihak_saksi as $row) {
		        $saksi='Saksi '.$counter.' \par ';
		        $saksi.='Nama lengkap \tab\tab : '.$row->nama.' \par ';
		        $saksi.='Pangkat/NRP \tab\tab :  \par ';
		        $saksi.='Jabatan \tab\tab\tab :  \par ';
		        $saksi.='Kesatuan \tab\tab\tab :  \par '; 
		        $saksi.='Tempat tanggal lahir \tab : '.$row->tempat_lahir.' '.$row->tanggal_lahir.'\par ';
		        $saksi.='Jenis Kelamin \tab\tab : '.$row->jenis_kelamin.' \par ';
		        $saksi.='Kewarganegaraan \tab\tab :  \par ';
		        $saksi.='Agama \tab\tab\tab : '.$row->agama_nama.' \par ';
		        $saksi.='Tempat tinggal \tab\tab : '.$row->alamat.' \par \par ';

		        $saksi.= 'Atas pertanyaan #tunggal/ketua#, Saksi '.$counter.' menerangkan bahwa ia '.$row->kenal.' dengan #para/terdakwa# sebelum perbuatannya yang menjadikan perkara ini, tidak mempunyai hubungan keluarga sedarah atau semenda dan tidak pula mempunyai hubungan kerja dengan Terdakwa. ';
		        $saksi.= 'Kemudian Saksi '.$counter.' mengucapkan sumpahnya menurut agama yang dianutnya bahwa ia akan menerangkan yang sebenarnya dan tidak lain dari pada yang sebenarnya. \line \line ';
		        

		        $i=1;$urutan_penanya=1;$x=1;
		        foreach ($info_pemeriksaan_saksi as $det) {
		            if ($row->id==$det->id){
		                if ($urutan_penanya==1 && $i==1){
		                    $saksi.= 'Atas pertanyaan #tunggal/ketua#, Saksi '.$counter.' memberikan keterangan sebagai berikut : \line \line ';                    
		                }
		                if ($urutan_penanya!=$det->urutan_penanya){
		                    if ($urutan_penanya==1){
		                        $saksi.='\line Kemudian secara berturut-turut Hakim Ketua memberi kesempatan bertanya kepada Hakim Anggota I, Hakim Anggota II, Oditur, Penasihat Hukum dan #para/terdakwa#. \line ';
		                    }
		                    $x=1;
		                    $saksi.='\line Atas pertanyaan '.ucwords(str_replace("_", " ", $det->penanya_t)).', Saksi I memberikan keterangan sebagai berikut : \line \line ';

		                }
		                $saksi.= $x.'. '.$det->pertanyaan_t.' \line ';
		                $saksi.= '\tab '.$x.'. '.$det->pertanyaan_t.' \line ';
		                $x++;$i++;$urutan_penanya=$det->urutan_penanya;    
		            }
		        }

		        $saksi.= '\line Sesudah semua pihak yang diberi kesempatan bertanya oleh #tunggal/ketua# selesai mengajukan pertanyaan kepada Saksi '.$counter.', #tunggal/ketua# memberi kesempatan kepada #para/terdakwa# untuk menanggapi keterangan Saksi. #para/terdakwa# menanggapi keterangan Saksi tersebut bahwa ia '.$det->tanggapan_terdakwa.' keterangan Saksi. \line';

		        $Template = str_replace('#saksi'.$counter.'#',''.$saksi.' ',$Template);
		        $counter++;
		    }
		}
		if($pemeriksaan_terdakwa){
		    //$Template='#looping_pemeriksaan_terdakwa#';
		    $terdakwa='';
		    $counter=1;
		    foreach ($info_pihak_terdakwa as $row) {
		        $text='#pemeriksaanterdakwa'.$counter.'#';
		        if ($counter<count($info_pihak_terdakwa)){
		            $Template = str_replace('#looping_pemeriksaan_terdakwa#',''.$text.' \par '.PHP_EOL.'#looping_pemeriksaan_terdakwa#',$Template);    
		        }else{
		            $Template = str_replace('#looping_pemeriksaan_terdakwa#',''.$text.' \par ',$Template);
		        }
		        $counter++;
		    }

		    $terdakwa='';$counter=1;
		    foreach ($info_pihak_terdakwa as $row) {
		        $urutan_penanya=1;
		        $i=1;$x=1;
		        foreach ($info_pemeriksaan_terdakwa as $det) {
		            if ($row->id==$det->id){
		                if ($urutan_penanya==1 && $i==1){
		                    $terdakwa='kemudian #tunggal/ketua# mulai mengajukan pertanyaan kepada Terdakwa '.$counter.', yang dijawab oleh Terdakwa '.$counter.' sebagai berikut : \par ';                    
		                }
		                if ($urutan_penanya!=$det->urutan_penanya){
		                    $x=1;
		                    if ($urutan_penanya==1){
		                    $terdakwa.='\line Kemudian secara berturut-turut #tunggal/ketua# memberi kesempatan bertanya kepada Hakim Anggota I, Hakim Anggota II, Oditur, dan Penasihat Hukum \line';
		                    }
		                    $terdakwa.='\par Atas pertanyaan '.$det->penanya_t.', Terdakwa '.$counter.' memberikan keterangan sebagai berikut : \par \par ';
		                }
		                $terdakwa.=$x.'. '.$det->pertanyaan_t.' \par ';
		                $terdakwa.=' \tab '.$x.'. '.$det->jawaban_t.' \par ';
		                $urutan_penanya=$det->urutan_penanya;
		                $x++;
		            }else{
		                if ($urutan_penanya==1 && $i==1){
		                    $terdakwa='kemudian #tunggal/ketua# mulai mengajukan pertanyaan kepada Terdakwa '.$counter.', yang dijawab oleh Terdakwa '.$counter.' sebagai berikut : \par ';                    
		                }
		            }
		            $i++;
		        }
		        $Template = str_replace('#pemeriksaanterdakwa'.$counter.'#',''.$terdakwa.' ',$Template);
		        $counter++;
		    }
		    //echo $Template;echo '</br></br>';
		    //print_r($info_pemeriksaan_terdakwa);echo '</br></br>';
		    //exit();
		}


		if($this->cData_ph>0){
		    $Template = str_replace('#tidak/didampingi#',' didampingi ',$Template);
		    $Template = str_replace('#Terdakwa/PenasihatHukum#',' Penasihat Hukum ',$Template);
		}else{
		    $Template = str_replace('#tidak/didampingi#',' tidak didampingi ',$Template);
		    $Template = str_replace('#Terdakwa/PenasihatHukum#',' Penasihat Hukum ',$Template);
		}
		if($this->cDataPenahanan>0){
		    $Template = str_replace('#pernah/tidak#',' pernah ',$Template);
		}else{
		    $Template = str_replace('#pernah/tidak#',' tidak pernah ',$Template);
		}

		$cTerdakwa = $dataterdakwa->num_rows();
		if($cTerdakwa>1){
		    $Template = str_replace('#para/terdakwa#',' Para Terdakwa ',$Template);
		}else{
		    $Template = str_replace('#para/terdakwa#',' Terdakwa ',$Template);
		}

		$Template = str_replace('#nama_panitera#',$this->panitera_ttd,$Template);
		$Template = str_replace('#pangkat_panitera#',$this->pangkat_panitera_ttd,$Template);
		$Template = str_replace('#nrp_panitera#',$this->nrp_panitera_ttd,$Template);
		$Template = str_replace('#nama_hakim_ketua#',$this->hakim_ketua,$Template);
		$Template = str_replace('#pangkat_hakim_ketua#',$this->pangkat_hakim_ketua,$Template);
		$Template = str_replace('#nrp_hakim_ketua#',$this->nrp_hakim_ketua,$Template);
		$inf_sidang = $info_sidang;
		foreach ($inf_sidang as $row) {
		    $hari_sidang = $this->templatehelper->getHari($row->tanggal_sidang);
		    $tanggal_sidang = $this->templatehelper->convertKeTglIndo($row->tanggal_sidang);
		    $expl_jam = explode(":", $row->jam_sidang);
		    $jam_sidang=$row->jam_sidang;
		    if(count($expl_jam)>1){
		        $jam_sidang = $expl_jam[0].":".$expl_jam[1];
		    }
		    $expl_jam = explode(":", $row->sampai_jam);
		    $sampai_jam = $row->sampai_jam;
		    if(count($expl_jam)>1){
		        $jam_sidang = $expl_jam[0].":".$expl_jam[1];
		    }
		    $Template = str_replace('#hari_sidang#',$hari_sidang,$Template);
		    $Template = str_replace('#tanggal_sidang#',$tanggal_sidang,$Template);
		    $Template = str_replace('#jam_sidang#',$jam_sidang." #zona_waktu#",$Template);
		    $Template = str_replace('#jam_selesai_sidang#',$sampai_jam." #zona_waktu#",$Template);
		    $Template = str_replace('#tundaan_sidang#',''.($row->alasan_ditunda).'',$Template);	
		}
		
		if (!empty($info_sidang_tundaan)){
			$Template = str_replace('#hari_tundaan_sidang#',$this->templatehelper->getHari($info_sidang_tundaan->tanggal_sidang),$Template);
			$Template = str_replace('#tanggal_tundaan_sidang#',''.$this->templatehelper->convertKeTglIndo($info_sidang_tundaan->tanggal_sidang).'',$Template);	
		}

		$Template = str_replace('#jaksa#','Oditur Militer',$Template);
		$Template = str_replace('#tunggal/ketua#','Hakim Ketua',$Template);
		$Template = str_replace('#hakim/majelis#','Majelis Hakim',$Template);
		$Template = str_replace('#tanggal_dakwaan#',''.$this->templatehelper->convertKeTglIndo($tanggal_surat).'',$Template);
		$Template = str_replace('#nomor_dakwaan#',$nomor_surat_dakwaan,$Template);
		$Template = str_replace('#isi_dakwaan#',''.$this->templatehelper->cleanHtmlTagSpecial($dakwaan).'',$Template);
		$Template = str_replace('#tempat yang telah disediakan/samping kanan Penasihat Hukum#','samping kanan Penasihat Hukum',$Template);

		$nama_pengadilan=$info_pn->NamaPN;
		$nama_pengadilan=explode(" ", $nama_pengadilan);
		$nama_kota=ucwords(strtolower($nama_pengadilan[3]));
		$kode_satker=strtoupper($nama_pengadilan[2]);
		foreach ($nama_pengadilan as $k=>$v) {
		    if (strpos("I-", $v)!==false) {
		    }else{
		        ucwords(strtolower($nama_pengadilan[$k]));
		    }
		}
		$nama_pengadilan=implode(" ", $nama_pengadilan);
		$Template = str_replace('#nama_pengadilan#',''.$this->templatehelper->standradnaming($nama_pengadilan).'',$Template);
		$Template = str_replace('#kode_satker#',$kode_satker,$Template);
		$Template = str_replace('#nama_kota#',''.$this->templatehelper->standradnaming($nama_kota).'',$Template);
		$Template = str_replace('#zona_waktu#',''.$info_pn->ZonaWaktu.'',$Template);
		$Template = str_replace('#tundaan_sidang#','__________',$Template);
		//exit();
		return $Template;
	}

	function replace_temp_tun($data){
		foreach ($data as $key => $value) {
			$$key=$value;
		}
		
		$url = base_url("resources/template/berita_acara/bas_atria/master_tun.rtf");
		$Template = file_get_contents($url);
		$Template = str_replace('#penutup_bas#',''.$penutup_bas.'',$Template);
		$Template = str_replace('#nomor_perkara#',''.$nomor_perkara.'',$Template);
		$Template = str_replace('#lanjutan#',''.$lanjutan.'',$Template);
		$Template = str_replace('#pembuka_bas#',''.$pembuka_bas.'',$Template);
		$Template = str_replace('#konten_bas#',''.$konten.'',$Template);
		
		$ada_intervensi=false;
		$intervensi_penggugat=false;
		$intervensi_tergugat=false; 
		if($dataPihak3->num_rows >1){
			$ada_intervensi=true;
			foreach ($dataPihak3->result() as $row) {
				if ($row->tergabung_ke_pihak==1){
					$intervensi_penggugat=true;
				}
				if ($row->tergabung_ke_pihak==2){
					$intervensi_tergugat=true;
				}
				if ($intervensi_penggugat && $intervensi_tergugat) break;
			}
		}
		$this->arr_pengacara_penggugat=array();
		$this->arr_pengacara_tergugat=array();
		if ($intervensi_penggugat){
			$Template = str_replace('#looping_penggugat#','\b #looping_penggugat#\b0 \par\b DAN \b0\par\par #looping_intervensi#',$Template);			
		}
		$Template=$this->looping_pihak_tun('penggugat',$dataPihak1, $dataPengacaraPihak1, $Template);
		if ($intervensi_penggugat){
				$Template=$this->looping_pihak_tun('intervensi',$dataPihak3, $dataPengacaraPihak3, $Template,1);
		}

		if ($intervensi_tergugat){
			$Template = str_replace('#looping_tergugat#','\b #looping_tergugat#\b0 \par\b DAN \b0\par\par #looping_intervensi#',$Template);
		}
		$Template=$this->looping_pihak_tun('tergugat',$dataPihak2, $dataPengacaraPihak2, $Template);
		if ($intervensi_tergugat){
				$Template=$this->looping_pihak_tun('intervensi',$dataPihak3, $dataPengacaraPihak3, $Template,2);
		}
		
		//MAJELIS HAKIM
		$data = $susunanMajelis;
		$hakim = array();
		$pengacara = array();
		foreach ($data->result() as $row) {
		    if (!$this->in_multiarray($row->nama_hakim, $hakim)){
		        $hakimItem = array();
		        $hakimItem["urutan_hakim"] = $row->urutan_hakim;
		        $hakimItem["jabatan_hakim_id"] = $row->jabatan_hakim_id;
		        $hakimItem["nama"] = $row->nama_hakim;
		        $hakimItem["nrp_hakim"] = $row->nip_hakim;
		        $hakimItem["pangkat_hakim"] = $row->pangkat_hakim;
		        $hakimItem["jabatan_hakim_nama"] = $row->jabatan_hakim_nama;
		        $hakimItem["nama_pp"] = $row->nama_pp;
		        $hakimItem["pangkat_pp"] = $row->pangkat_pp;
		        $hakimItem["nip_pp"] = $row->nip_pp;
		        $hakimItem["nama_om"] = $row->nama_om;
		        $hakimItem["nrp_om"] = $row->nrp_om;
		        $hakimItem["pangkat_om"] = $row->pangkat_om;
		        $hakimItem["nama_p"] = $row->nama_p;
		        $hakimItem["nrp_p"] = $row->nrp_p;
		        $hakimItem["pangkat_p"] = $row->pangkat_p;
		        $hakim[] = $hakimItem;
		        if ($row->jabatan_hakim_id==1){
		            $nrp_hakim_ketua=$row->nip_hakim;
		            $pangkat_hakim_ketua=$row->pangkat_hakim;
		        }
		    }
		   if (!$this->in_multiarray($row->nama_p, $pengacara)){
		        $pengacaraPitem = array();
		        $pengacaraPitem["nama_ph"] = $row->nama_p;
		        $pengacara[]=$pengacaraPitem;
		    }
		}
		$hakim_anggotas = '';
		$daftar_majelis = '';
		$data_hakim = $hakim;
		$cData_ph = count($pengacara);
		$majelis = true;
		$i=1;$j=1; 

		foreach ($data_hakim as $row) {
		    if($row['jabatan_hakim_id']==1){
		        $hakim_ketua = $this->templatehelper->standradnaming($row['nama']);
		        $daftar_majelis .= $i.'. '.$this->templatehelper->standradnaming($row['nama']).' \tab Sebagai Hakim Ketua Majelis;\\par ';
		    }elseif($row['jabatan_hakim_id']==2){
		        if ($i === count($data_hakim)){
		            $hakim_anggotas .= $this->templatehelper->standradnaming($row['nama']).'';
		        }else{
		            if ($j==1 && $i>1){
		                $hakim_anggotas .= $this->templatehelper->standradnaming($row['nama']).'\tab '.$hakim_ketua.'\\par \\par \\par ';
		            }else{
		                $hakim_anggotas .= $this->templatehelper->standradnaming($row['nama']).'\\par \\par \\par ';
		            }
		        } 
		        $daftar_majelis .= $i.'. '.$this->templatehelper->standradnaming($row['nama']).' \tab Sebagai Hakim Anggota '.$this->templatehelper->convertToRomawi($j).';\\par ';
		        $j++;
		    }elseif($row['jabatan_hakim_id']==3){
		        $majelis = false;
		        $daftar_majelis .= '1. '.$this->templatehelper->standradnaming($row['nama']).' \tab Sebagai Hakim;\\par ';
		        $hakim_ketua = $this->templatehelper->standradnaming($row['nama']);
		    }
		    $panitera = $this->templatehelper->standradnaming($row['nama_pp']).' \tab Sebagai Panitera Pengganti;\\par ';
		    $panitera_ttd = $this->templatehelper->standradnaming($row['nama_pp']);
		    $i++;
		}

		$Template = str_replace('#susunan_majelis#','\pard \sl360\slmult1\tldot\tx6000 #susunan_majelis# \ltrpar\qj \fi855\li0 ',$Template);
		$Template = str_replace('#susunan_majelis#',$daftar_majelis.(count($data_hakim)+1).'. '.$panitera,$Template);
		if ($majelis){
			$Template = str_replace('#tunggal/ketua#','Hakim Ketua',$Template);
			$Template = str_replace('#hakim/majelis#','Majelis Hakim',$Template);
		}else{
			$Template = str_replace('#tunggal/ketua#','Hakim',$Template);
		$Template = str_replace('#hakim/majelis#','Hakim',$Template);
		}
		$Template = str_replace('#hakim_ketua_ttd#',$hakim_ketua,$Template);
		$Template = str_replace('#pp_ttd#',$panitera_ttd,$Template);
		//Info Sidang
		$inf_sidang = $info_sidang;
		foreach ($inf_sidang as $row) {
		    $hari_sidang = $this->templatehelper->getHari($row->tanggal_sidang);
		    $tanggal_sidang = $this->templatehelper->convertKeTglIndo($row->tanggal_sidang);
		    $jam_sidang = explode(":", $row->jam_sidang);
		    $jam_sidang = $jam_sidang[0].":".$jam_sidang[1];
		    $expl_jam = explode(":", $row->sampai_jam);
		    $sampai_jam = $row->sampai_jam;
		    if(count($expl_jam)>1){
		        $jam_sidang = $expl_jam[0].":".$expl_jam[1];
		    }
		    
		    $dihadiri_oleh=$row->dihadiri_oleh;
		    $Template = str_replace('#hari_sidang#',$hari_sidang,$Template);
		    $Template = str_replace('#tanggal_sidang#',$tanggal_sidang,$Template);
		    $Template = str_replace('#jam_sidang#',$jam_sidang." #zona_waktu#",$Template);
		    $Template = str_replace('#jam_selesai_sidang#',$sampai_jam." #zona_waktu#",$Template);
		}
		//print_r($this->arr_pengacara_tergugat);exit();
		switch ($dihadiri_oleh) {
			case 1:
				$kehadiran="- Untuk Penggugat \\tab : Hadir ";
				if(!empty($this->arr_pengacara_penggugat)){
					$kehadiran.= "menghadap Kuasa Hukumnya bernama: ";
					foreach ($this->arr_pengacara_penggugat as $value) {
						$kehadiran.="\par\\tab\\tab\\tab   - ".$value->nama." ";
					}
				}else{
					$kehadiran.= "menghadap sendiri ";
				}
				$kehadiran.="\\par - Untuk Tergugat\\tab : Hadir ";
				if(!empty($this->arr_pengacara_tergugat)){
					$kehadiran.= "menghadap Kuasa Hukumnya bernama: ";
					foreach ($this->arr_pengacara_tergugat as $value) {
						$kehadiran.="\par\\tab\\tab\\tab   - ".$value->nama." ";
					}
				}else{
					$kehadiran.= "menghadap sendiri ";
				}
			break;
			case 2:
				$kehadiran="- Untuk Penggugat \\tab : Hadir ";
				if(!empty($this->arr_pengacara_penggugat)){
					$kehadiran.= "menghadap Kuasa Hukumnya bernama: ";
					foreach ($this->arr_pengacara_penggugat as $value) {
						$kehadiran.="\par\\tab\\tab\\tab   - ".$value->nama." ";
					}
				}else{
					$kehadiran.= "menghadap sendiri ";
				}
				$kehadiran.="\\par - Untuk Tergugat\\tab : Tidak hadir ";
			break;
			case 3:
				$kehadiran="- Untuk Penggugat \\tab : Tidak hadir ";
				$kehadiran.="\\par - Untuk Tergugat\\tab : Hadir ";
				if(!empty($this->arr_pengacara_tergugat)){
					$kehadiran.= "menghadap Kuasa Hukumnya bernama: ";
					foreach ($this->arr_pengacara_tergugat as $value) {
						$kehadiran.="\par\\tab\\tab\\tab   - ".$value->nama." ";
					}
				}else{
					$kehadiran.= "menghadap sendiri ";
				}
			break;
			case 4:
				$kehadiran="- Untuk Penggugat \\tab : Tidak hadir ";
				$kehadiran.="\\par - Untuk Tergugat\\tab : Tidak hadir ";
			break;
			default:
				$kehadiran="\\highlight7 [Mohon diisi kehadiran d dalam aplikasi jadwal sidang]\\highlight0 ";
			break;
		}
		if (count($dataPutusan)>0){
			$Template = str_replace('#amar_putusan#',''.$this->templatehelper->cleanHtmlTagSpecial($dataPutusan[0]->amar_putusan).'',$Template);	
		}
		$Template = str_replace('#kehadiran_sidang#',"\pard \sl360\slmult1\ ".$kehadiran,$Template);
		$nama_pengadilan=$info_pn->NamaPN;
		$nama_pengadilan=explode(" ", $nama_pengadilan);
		$nama_kota=ucwords(strtolower($nama_pengadilan[3]));
		$kode_satker=strtoupper($nama_pengadilan[2]);
		foreach ($nama_pengadilan as $k=>$v) {
		    if (strpos("I-", $v)!==false) {
		    }else{
		        ucwords(strtolower($nama_pengadilan[$k]));
		    }
		}
		$nama_pengadilan=implode(" ", $nama_pengadilan);
		$Template = str_replace('#nama_pengadilan#',''.$this->templatehelper->standradnaming($nama_pengadilan).'',$Template);
		$Template = str_replace('#kode_satker#',$kode_satker,$Template);
		$Template = str_replace('#nama_kota#',''.$this->templatehelper->standradnaming($nama_kota).'',$Template);
		$Template = str_replace('#zona_waktu#',''.$info_pn->ZonaWaktu.'',$Template);
		$Template = str_replace('#tundaan_sidang#','__________',$Template);
		$Template = str_replace('#tanggal_tunda_sidang#','__________',$Template);
		$Template = str_replace('#hari_tunda_sidang#','__________',$Template);
		
		if ($pemeriksaan_saksi){
		    $saksi='';
		    $counter=1;
		    foreach ($info_pihak_saksi as $row) {
		        $text='#saksi'.$counter.'#';
		        if ($counter<count($info_pihak_saksi)){
		            $Template = str_replace('#looping_saksi#',''.$text.' \par '.PHP_EOL.'#looping_saksi#',$Template);    
		        }else{
		            $Template = str_replace('#looping_saksi#',''.$text.' \par ',$Template);
		        }
		        
		        $counter++;
		    }

		    $saksi='';$counter=1;
		    foreach ($info_pihak_saksi as $row) {
		        $saksi='Saksi '.$counter.' \par ';
		        $saksi.='Nama lengkap \tab\tab : '.$row->nama.' \par ';
		        $saksi.='Pangkat/NRP \tab\tab :  \par ';
		        $saksi.='Jabatan \tab\tab\tab :  \par ';
		        $saksi.='Kesatuan \tab\tab\tab :  \par '; 
		        $saksi.='Tempat tanggal lahir \tab : '.$row->tempat_lahir.' '.$row->tanggal_lahir.'\par ';
		        $saksi.='Jenis Kelamin \tab\tab : '.$row->jenis_kelamin.' \par ';
		        $saksi.='Kewarganegaraan \tab\tab :  \par ';
		        $saksi.='Agama \tab\tab\tab : '.$row->agama_nama.' \par ';
		        $saksi.='Tempat tinggal \tab\tab : '.$row->alamat.' \par \par ';

		        $saksi.= 'Atas pertanyaan #tunggal/ketua#, Saksi '.$counter.' menerangkan bahwa ia '.$row->kenal.' dengan #para/terdakwa# sebelum perbuatannya yang menjadikan perkara ini, tidak mempunyai hubungan keluarga sedarah atau semenda dan tidak pula mempunyai hubungan kerja dengan Terdakwa. ';
		        $saksi.= 'Kemudian Saksi '.$counter.' mengucapkan sumpahnya menurut agama yang dianutnya bahwa ia akan menerangkan yang sebenarnya dan tidak lain dari pada yang sebenarnya. \line \line ';
		        

		        $i=1;$urutan_penanya=1;$x=1;
		        foreach ($info_pemeriksaan_saksi as $det) {
		            if ($row->id==$det->id){
		                if ($urutan_penanya==1 && $i==1){
		                    $saksi.= 'Atas pertanyaan #tunggal/ketua#, Saksi '.$counter.' memberikan keterangan sebagai berikut : \line \line ';                    
		                }
		                if ($urutan_penanya!=$det->urutan_penanya){
		                    if ($urutan_penanya==1){
		                        $saksi.='\line Kemudian secara berturut-turut Hakim Ketua memberi kesempatan bertanya kepada Hakim Anggota I, Hakim Anggota II, Oditur, Penasihat Hukum dan #para/terdakwa#. \line ';
		                    }
		                    $x=1;
		                    $saksi.='\line Atas pertanyaan '.ucwords(str_replace("_", " ", $det->penanya_t)).', Saksi I memberikan keterangan sebagai berikut : \line \line ';

		                }
		                $saksi.= $x.'. '.$det->pertanyaan_t.' \line ';
		                $saksi.= '\tab '.$x.'. '.$det->pertanyaan_t.' \line ';
		                $x++;$i++;$urutan_penanya=$det->urutan_penanya;    
		            }
		        }

		        $saksi.= '\line Sesudah semua pihak yang diberi kesempatan bertanya oleh #tunggal/ketua# selesai mengajukan pertanyaan kepada Saksi '.$counter.', #tunggal/ketua# memberi kesempatan kepada #para/terdakwa# untuk menanggapi keterangan Saksi. #para/terdakwa# menanggapi keterangan Saksi tersebut bahwa ia '.$det->tanggapan_terdakwa.' keterangan Saksi. \line';

		        $Template = str_replace('#saksi'.$counter.'#',''.$saksi.' ',$Template);
		        $counter++;
		    }
		}
		return $Template;
	}

	function looping_pihak_tun($pihak_text, $dataPihak1, $dataPengacaraPihak1, $Template, $tergabung_ke_pihak=0){
		//PENGGUGAT
		$counter = 1;
		$pihak1 = '';
		$pihak1_id='';
		$arr_pihak1 = array();
		$numbering = true;

		if($dataPihak1->num_rows >0){
			if ($tergabung_ke_pihak!=0){
				foreach ($dataPihak1->result() as $value) {
					if ($value->tergabung_ke_pihak==$tergabung_ke_pihak){
						$temp[]=$value;
					}
				}

			}else{
				$temp=$dataPihak1->result();	
			}
			$j=0;
		    for ($i=0; $i < count($temp); $i++) { 
		    	$val=$temp[$i];
	    		$text = $pihak_text.($j+1);
		        if($i==count($temp)-1){
		            $Template = str_replace('#looping_'.$pihak_text.'#','\fi-2977\li3686\ri0\tx993\tx3544\b #'.$text.'#\b0',$Template);
		        }else{
		            $Template = str_replace('#looping_'.$pihak_text.'#','\fi-2977\li3686\ri0\tx993\tx3544\b #'.$text.'#\b0\\par'.PHP_EOL.'#looping_'.$pihak_text.'#',$Template);
		        }
	    	
		        $j++;
		    }   
		}else{
		    $numbering = false;
		    $Template = str_replace('#looping_'.$pihak_text.'#','#'.$pihak_text.'#',$Template);
		}
		
		$pihak_text1=($pihak_text=='intervensi')?(($tergabung_ke_pihak==1)?'penggugat II intervensi':'tergugat II intervensi'):$pihak_text;
		
		if ((count($temp))>0){  
			$j=0; 
		    for ($i=0;$i<(count($temp));$i++){
		    	$val=$temp[$i];
		    	if ($tergabung_ke_pihak!=0){
		    		if ($val->tergabung_ke_pihak!=$tergabung_ke_pihak) continue;	
		    	}
		        $pihak1_id=$val->pihak_id;
		        $arr_pihak1[]=$val->id;
		        if (count($temp)==1) {
		            $nomor='';
		            $tab='\tab ';
		            $penggugat = '\b0 ';
		        }else{
		            $nomor=$counter.".";
		            $tab='\tab ';
		            $penggugat = '\b0 ';
		        }
		        
		        $pihak1 = $penggugat;
		        if ($val->jenis_pihak_id=='1'){
		        	$pihak1 .= $nomor.$tab.'Nama \tab :\tab '.$this->templatehelper->standradnaming($val->nama).'\\par';
			        $pihak1 .= '\tab Kewarganegaraan\tab :\tab '.$val->kewarganegaraan.'\\par ';
			        $pihak1 .= '\tab Tempat tinggal \tab :\tab '.$val->alamat.'\\par ';
			        $pihak1 .= '\tab Pekerjaan\tab :\tab '.$val->pekerjaan.'\\par ';
		        }elseif ($val->jenis_pihak_id=='2'){
	        		$pihak1 .= $nomor.$tab.'Nama Jabatan \tab :\tab '.$this->templatehelper->standradnaming($val->nama).'\\par';
	        		$pihak1 .= '\tab Tempat Kedudukan \tab :\tab '.$val->alamat.'\\par ';
		        }elseif ($val->jenis_pihak_id=='3'){
	        		$pihak1 .= $nomor.$tab.'Badan Hukum Perdata \tab :\tab '.$this->templatehelper->standradnaming($val->nama).'\\par';
	        		$pihak1 .= '\tab Beralamat di \tab :\tab '.$val->alamat.'\\par ';
	        		$pihak1 .= '\ql \li3686\ri0\fi0\ql Dalam hal ini berdasarkan Akta Pernyataan Keputusan Rapat \highlight7 _________ \highlight0, Nomor \highlight7 _________ \highlight0 Tanggal \highlight7 _________ \highlight0 Bulan \highlight7 _________ \highlight0 Tahun \highlight7 _________ \highlight0 yang dibuat dihadapan Notaris \highlight7 _________ \highlight0 . \\par ';
		        	$pihak1 .= 'Bertindak untuk dan atas nama \highlight7 _________ \highlight0 diwakili oleh \highlight7 _________ \highlight0. \par ';
		       		$pihak1 .= 'Nama \tab\tab : \highlight7 _________ \highlight0 \par '; 	
		       		$pihak1 .= 'Kewarganegaraan \tab : \highlight7 _________ \highlight0 \par '; 	
		       		$pihak1 .= 'Tempat Tinggal \tab : \highlight7 _________ \highlight0 \par '; 	
		       		$pihak1 .= 'Pekerjaan \tab : \highlight7 _________ \highlight0 \par '; 	
		        }elseif ($val->jenis_pihak_id=='4'){
	        		$pihak1 .= $nomor.$tab.'Pemerintahan Daerah \tab :\tab '.$this->templatehelper->standradnaming($val->nama).'\\par';
	        		$pihak1 .= '\tab Beralamat di \tab :\tab '.$val->alamat.'\\par ';
	        		$pihak1 .= '\ql \li3686\ri0\fi0\ql Dalam hal ini berdasarkan Akta Pernyataan Keputusan Rapat \highlight7 _________ \highlight0, Nomor \highlight7 _________ \highlight0 Tanggal \highlight7 _________ \highlight0 Bulan \highlight7 _________ \highlight0 Tahun \highlight7 _________ \highlight0 yang dibuat dihadapan Notaris \highlight7 _________ \highlight0 . \\par ';
		        	$pihak1 .= 'Bertindak untuk dan atas nama \highlight7 _________ \highlight0 diwakili oleh \highlight7 _________ \highlight0. \par ';
		       		$pihak1 .= 'Nama \tab\tab : \highlight7 _________ \highlight0 \par '; 	
		       		$pihak1 .= 'Kewarganegaraan \tab : \highlight7 _________ \highlight0 \par '; 	
		       		$pihak1 .= 'Tempat Tinggal \tab : \highlight7 _________ \highlight0 \par '; 	
		       		$pihak1 .= 'Pekerjaan \tab : \highlight7 _________ \highlight0 \par '; 	
		        }
		                       
		        $counterAdv1 = 1;
		        $pengacara1 = '';
		        $arr_pengacara = array();
		        $numberingAdv = true;
		        $kesemuanya='';$temp_tgl_surat_kuasa='';
		        $tulis=true;
		        if (!empty($dataPengacaraPihak1->num_rows)){   
		        	foreach ($dataPengacaraPihak1->result() as $row){
		        		if ((strpos($row->pihak_id, $pihak1_id) !== false)){
		        			$arr_pengacara[]=$row;
		        			if ($pihak_text=='penggugat'){
		        				$this->arr_pengacara_penggugat[]=$row;
		        			}elseif($pihak_text=='tergugat'){
		        				$this->arr_pengacara_tergugat[]=$row;
		        			}
		        			if (isset($temp[$i+1])){
				        		if ((strpos($row->pihak_id, $temp[$i+1]->pihak_id) !== false)){
				        			$tulis=false;
				        		}
					    	}
		        		}
		        	}
		        	//print_r($arr_pengacara);echo'<br><br>';
		        	if (count($arr_pengacara)==0) $tulis=true;	
		            foreach ($arr_pengacara as $row){
		            	if ($tulis){
		                    if ($row->pekerjaan==' '?$pekerjaan_advokat='........... ' :$pekerjaan_advokat= $row->pekerjaan);
		                    if ($row->alamat==''?$alamat_kantor_advokat='............' :$alamat_kantor_advokat=$row->alamat);
		                    if ($row->aktif_mulai==''?$tgl_surat_kuasa='............' :$tgl_surat_kuasa=$this->templatehelper->convertKeTglIndo($row->aktif_mulai));
		                    if ($temp_tgl_surat_kuasa!=$tgl_surat_kuasa || $temp_tgl_surat_kuasa==''){
		                        $pihak1 .= '\ql \li3686\ri0\fi0\ql Dalam hal ini berdasarkan Surat kuasa Khusus tertanggal '.$tgl_surat_kuasa.'  memberikan kuasa kepada: \\par ';
		                    }
		                    $temp_tgl_surat_kuasa=$tgl_surat_kuasa;
		                    $pengacara = '\b0 \fi-2268\li5954\ri0\nowidctlpar\tx5812 ';
		                    $pengacara1 = $pengacara;
		                    if (count($arr_pengacara)==1) {
		                        $nomor='';
		                        $tab=' \tab ';
		                        $pengacara1 .= $nomor.'Nama \tab : \tab '.$this->templatehelper->standradnaming($row->nama).'\\par ';
		                        $pengacara1 .= 'Kewarganegaraan\tab : \tab '.$row->kewarganegaraan.'\\par ';
		                        $pengacara1 .= 'Tempat tinggal\tab : \tab'.$row->alamat.'\\par ';
		                        $pengacara1 .='Alamat kantor \tab : \tab '.$alamat_kantor_advokat.' \\par ';
		                        $pengacara1 .= 'Pekerjaan \tab : \tab '.$row->pekerjaan.'\\par ';
		                    }else{
		                        $nomor=$counterAdv1.".";
		                        $tab=' \tab ';
		                        $pengacara1 .= $nomor.' '.$this->templatehelper->standradnaming($row->nama).' ';
		                    }
		                    $pihak1 .=$pengacara1;
		                    $pihak1 .= '';
		                    $pihak1 .= $kesemuanya;
		                    if (count($arr_pengacara)>1) {
		                    	if ($counterAdv1==count($arr_pengacara)){
		                    		$pihak1 .=' \\par\ql \li3686\ri0\fi0\ql Kesemuanya kewarganegaraan '.$row->kewarganegaraan.', pekerjaan '.$pekerjaan_advokat.'  beralamat kantor di '.$alamat_kantor_advokat.' \\par\\par ';
		                    	}else{
		                    		$pihak1 .=' \\par ';
		                    	}
				            }else{
				                $pihak1 .=' \\par ';
				            }
				            $counterAdv1++;
		                }
		            }
		            if ($tulis){
		            	$pihak1 .= '\ql \li3686\ri0\fi0\ql Untuk selanjutnya disebut sebagai \b '.strtoupper($pihak_text1).' '.$counter.'\b0 \par ';
		            }
		        }else{
		        	if (true){
			        	if ($dataPihak1->num_rows==1){
			        		$pihak1 .= '\ql \li3686\ri0\fi0\ql Untuk selanjutnya disebut sebagai \b '.strtoupper($pihak_text1).' '.$counter.'\b0 \par ';		
			        	}else{
			        		$pihak1 .= '\ql \li3686\ri0\fi0\ql Untuk selanjutnya disebut sebagai \b '.strtoupper($pihak_text1).' '.$counter.'\b0 \par ';	
			        	}
			        }
		        }
		        $pihak1.=' \li0\fi720 ';
		        if($numbering==true){
		            $Template = str_replace('#'.$pihak_text.$counter.'#',$pihak1,$Template);
		            $Template = str_replace('#'.$pihak_text.'/para'.$pihak_text.'#','Para '.ucwords($pihak_text1),$Template);
		        }else{
		           $Template = str_replace('#'.$pihak_text.'#',$pihak1,$Template);
		           $Template = str_replace('#'.$pihak_text.'/para'.$pihak_text.'#',ucwords($pihak_text1),$Template);
		        }
		        $counter++;    
		    }
		}
		//exit();
		//print_r($arr_pengacara);exit();
		return $Template;
	}

	function replace_temp_agama($data){
		foreach ($data as $key => $value) {
			$$key=$value;
		}
		
		$url = base_url("resources/template/berita_acara/bas_atria/master_agama.rtf");
		$Template = file_get_contents($url);
		$Template = str_replace('#penutup_bas#',''.$penutup_bas.'',$Template);
		$Template = str_replace('#nomor_perkara#',''.$nomor_perkara.'',$Template);
		$Template = str_replace('#lanjutan#',''.$lanjutan.'',$Template);
		$Template = str_replace('#pembuka_bas#',''.$pembuka_bas.'',$Template);
		$Template = str_replace('#konten_bas#',''.$konten.'',$Template);

		$Template=$this->looping_majelis_agama($Template,$data);
		//START COPY
		$nomor_perkara = $dataperkara->row(0)->nomor_perkara;
		$tgl_pendaftaran = $this->templatehelper->convertKeTglIndo($dataperkara->row(0)->tanggal_pendaftaran);
		$namakota = $datapengadilan->row(0)->NamaPN;

		$id_urutan =0;
		if($datapersidangan!=''){
		    if($datapersidangan->num_rows>0){
		        foreach ($datapersidangan->result() as $row) {
		            //$nextsidang = $idjadwal+1;
		            if ($id_urutan>0){
		                $nextsidang = $id_urutan+1;
		                    if($nextsidang=$row->urutan){
		                        $tgl_sidang_tunda = $row->tanggal_sidang;
		                    }
		            }
		            if($row->id==$sidang_id){
		                $id_urutan = $row->urutan;
		                $tgl_sidang = $row->tanggal_sidang;
		            }
		        }
		    }
		}

		if(!empty($tgl_sidang_tunda)){
		    $tgl_sidang_tunda = $this->templatehelper->convertKeTglIndo($tgl_sidang_tunda);
		    $hari_sidang_tunda =  $this->templatehelper->getHari($tgl_sidang_tunda);
		}else{
		    $tgl_sidang_tunda = '----------------------------';
		    $hari_sidang_tunda = '----------------------------';
		}

		$Template = str_replace("#TGL_SIDANG#", $this->templatehelper->convertKeTglIndo($tgl_sidang) ,$Template);
		$Template = str_replace("#HARI_SIDANG#", $this->templatehelper->getHari($tgl_sidang) ,$Template);
		$Template = str_replace("#TGL_SIDANG_TUNDA#", $tgl_sidang_tunda ,$Template);
		$Template = str_replace("#HARI_SIDANG_TUNDA#", $hari_sidang_tunda ,$Template);

		$i=0;
		$temp_pihak='';
		$temp_kuasa='';
		$pihak_array='';
		foreach ($dataPihak1->result() as $row) {
		    if($temp_pihak!=$row->id_pihak){
		        $temp_pihak=$row->id_pihak;
		        if($i>0){
		            $pihak_array = str_replace("#ke#",' '.$this->templatehelper->converToAngkaRomawi($i), $pihak_array);
		        }
		        
		        $pihak_array.=$row->nama.', umur '.$row->umur.' tahun, agama '.$row->agama.
		                ', pekerjaan '.$row->pekerjaan.', Pendidikan '.$row->pendidikan.
		                ', alamat '.$row->alamat;  
		                    
		        if($row->id_kuasa!=''){
		            if($i>0){$pihak_array= str_replace("#DKK#",'', $pihak_array);}
		            $pihak_array.=' dalam hal ini memberikan kuasa khusus kepada '.$row->nama_kuasa.
		                ' #DKK# advokat/penasehat hukum dari '.$row->nama.
		                ' yang berkantor di '.$row->alamat_kuasa.' berdasarkan surat kuasa khusus tanggal '.$this->templatehelper->convertKeTglIndo($row->tgl_kuasa).
		                ' sebagai #SEBAGAI_P##ke#;#par#';            
		        }else{
		            $pihak_array.=' sebagai #SEBAGAI_P##ke#;#par#';    
		        }
		        $i++;
		    }else{
		         $pihak_array = str_replace("#DKK#",'dan kawan kawan', $pihak_array);
		    }
		}
		if($i>1){
		    $pihak_array = str_replace("#ke#",' '.$this->templatehelper->converToAngkaRomawi($i), $pihak_array);
		    $pihak_array = str_replace("#par#",' \\par ', $pihak_array);
		}else{
		    $pihak_array = str_replace("#ke#",'', $pihak_array);
		    $pihak_array = str_replace("#par#",'', $pihak_array);
		}
		$pihak_array = str_replace("#DKK#",'', $pihak_array);
		$Template = str_replace("#loopingpenggugat#",$pihak_array,$Template);

		$i=0;
		$temp_pihak='';
		$temp_kuasa='';
		$pihak_array='';
		foreach ($dataPihak2->result() as $row) {
		    if($temp_pihak!=$row->id_pihak){
		        $temp_pihak=$row->id_pihak;
		        if($i>0){
		            $pihak_array = str_replace("#ke#",' '.$this->templatehelper->converToAngkaRomawi($i), $pihak_array);
		        }
		        
		        $pihak_array.=$row->nama.', umur '.$row->umur.' tahun, agama '.$row->agama.
		                ', pekerjaan '.$row->pekerjaan.', Pendidikan '.$row->pendidikan.
		                ', alamat '.$row->alamat;  
		                    
		        if($row->id_kuasa!=''){
		            if($i>0){$pihak_array= str_replace("#DKK#",'', $pihak_array);}
		            $pihak_array.=' dalam hal ini memberikan kuasa khusus kepada '.$row->nama_kuasa.
		                ' #DKK# advokat/penasehat hukum dari '.$row->nama.
		                ' yang berkantor di '.$row->alamat_kuasa.' berdasarkan surat kuasa khusus tanggal '.$this->templatehelper->convertKeTglIndo($row->tgl_kuasa).
		                ' sebagai #SEBAGAI_T##ke#;#par#';            
		        }else{
		            $pihak_array.=' sebagai #SEBAGAI_T##ke#;#par#';    
		        }
		        $i++;
		    }else{
		         $pihak_array = str_replace("#DKK#",'dan kawan kawan', $pihak_array);
		    }
		}
		if($i>1){
		    $pihak_array = str_replace("#ke#",' '.$this->templatehelper->converToAngkaRomawi($i), $pihak_array);
		    $pihak_array = str_replace("#par#",' \\par ', $pihak_array);
		}else{
		    $pihak_array = str_replace("#ke#",'', $pihak_array);
		    $pihak_array = str_replace("#par#",'', $pihak_array);
		}
		$pihak_array = str_replace("#DKK#",'', $pihak_array);
		$Template = str_replace("#loopingtergugat#",$pihak_array,$Template);

		$idalurperkara = $this->tanggalhelper->getIDAlurPerkara($perkara_id);
		$jenisPerkaraID=$this->tanggalhelper->getIDJenisPerkara($perkara_id);

		if ($idalurperkara==15) {
		    $Template = str_replace("#jenis_perkara#",''."Gugatan".'',$Template);
		    if ($jenisPerkaraID==346) {
		        $Template = str_replace("#jenis_pihak1#",''."Pemohon".'',$Template);
		        $Template = str_replace("#jenis_pihak2#",''."Termohon".'',$Template);
				$Template = str_replace("#SEBAGAI_P#","Pemohon",$Template);
				$Template = str_replace("#SEBAGAI_T#","Termohon",$Template);
		    }else{
		        $Template = str_replace("#jenis_pihak1#",''."Penggugat".'',$Template);
		        $Template = str_replace("#jenis_pihak2#",''."Tergugat".'',$Template);
		        $Template = str_replace("#SEBAGAI_P#","Penggugat",$Template);
		        $Template = str_replace("#SEBAGAI_T#","Tergugat",$Template);
		    }
		}else{
		    $Template = str_replace("#jenis_perkara# ",''." Permohonan ".'',$Template);   
		    $Template = str_replace("#jenis_pihak1#",''." Pemohon ".'',$Template);
		    $Template = str_replace("#jenis_pihak2#",''." Termohon ".'',$Template);
		}
		$Template = str_replace("#NAMA_P#",$dataPihak1->row(0)->nama,$Template);
		if ($dataPihak2->num_rows > 0){
		    $Template = str_replace("#NAMA_T#",$dataPihak2->row(0)->nama,$Template);
		}
		//Pihaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaak
		$Template = str_replace("#nomor_perkara#",$dataperkara->row(0)->nomor_perkara,$Template);
		$Template = str_replace("#NOMOR_PERKARA#",$dataperkara->row(0)->nomor_perkara,$Template);
		$Template = str_replace("#nama_pp#",$datapaniterapengganti->row(0)->nama_gelar,$Template);
		$Template = str_replace("#hakim_ketua#",$datapenetapanhakim->row(0)->nama_gelar,$Template);
		$Template = str_replace("#nama_pa#",ucwords(strtolower($datapengadilan->row(0)->NamaPN)),$Template);
		if(substr(ucwords(strtolower($datapengadilan->row(0)->NamaPN)),0,1)=="P"){$jenis_satker="Pengadilan Agama";}else{$jenis_satker="Mahkamah Syar'iah";}
		$Template = str_replace("#JENIS_SATKER#",$jenis_satker,$Template);

		$Template = str_replace("#ZONA#",$datapengadilan->row(0)->ZonaWaktu,$Template);
		//$Template = str_replace("#amar_putusan#",''.$this->templatehelper->cleanHtmlTagSpecial($dataamar->row(0)->amar_putusan).'',$Template);

		if($datapenetapanhakim!=''){
		    if($datapenetapanhakim->num_rows>0){
		        foreach ($datapenetapanhakim->result() as $row) {
		            if(($row->urutan)==1){
		                $ketuaMajelis = $row->hakim_nama;
		            }elseif(($row->urutan)==2){
		                $hakimAnggota1 = $row->hakim_nama;
		            }elseif(($row->urutan)==3){
		                $hakimAnggota2 = $row->hakim_nama;
		            }
		        }
		    }
		}
		$Template = str_replace("#NAMA_MAJELIS#",''.$ketuaMajelis.'',$Template);
		$Template = str_replace("#NAMA_ANGGOTA1#",''.$hakimAnggota1.'',$Template);
		$Template = str_replace("#NAMA_ANGGOTA2#",''.$hakimAnggota2.'',$Template);

		if($datamediator!=''){
		    if($datamediator->num_rows>0){
		        foreach ($datamediator->result() as $mediator) {
		            $namaMediator = $mediator->mediator_text;
		        }
		        $Template = str_replace("#NAMA_MEDIATOR#",''.$namaMediator.'',$Template);
		    }
		}

		if($dataputusanverstek!=''){
		    if($dataputusanverstek->num_rows>0){
		        foreach ($dataputusanverstek->result() as $putusan) {
		            $amarPutusan = $this->templatehelper->cleanHtmlTagSpecial($putusan->amar_putusan);
		        }
		        $Template = str_replace("#AMAR#",''.$amarPutusan.'',$Template);
		    }
		}
		if($dataputusansela!=''){
		    if($dataputusansela->num_rows>0){
		        foreach ($dataputusansela->result() as $sela) {
		            $amarPutusansela = $this->templatehelper->cleanHtmlTagSpecial($sela->amar_sela);
		            $tgl_putusansela = $this->templatehelper->convertKeTglIndo($sela->tanggal_putusan_sela);
		            $hari_putusansela = $this->templatehelper->getHari($sela->tanggal_putusan_sela);
		            $tgl_putusanselaHijriah = $this->templatehelper->convertToHijriah($sela->tanggal_putusan_sela);
		        }
		        $Template = str_replace("#PENETAPANSELA#",''.$amarPutusansela.'',$Template);
		        $Template = str_replace("#TANGGALSELA#",''.$tgl_putusansela.'',$Template);
		        $Template = str_replace("#HARISELA#",''.$hari_putusansela.'',$Template);
		        $Template = str_replace("#TGL_HIJRIAH#",''.$tgl_putusanselaHijriah.'',$Template);
		    }else {
				$Template = str_replace("#PENETAPANSELA#",''." ........amar putusan sela....... ".'',$Template);
		        $Template = str_replace("#TANGGALSELA#",''." ............... ".'',$Template);
		        $Template = str_replace("#HARISELA#",''." ............... ".'',$Template);
		        $Template = str_replace("#TGL_HIJRIAH#",''." ............... ".'',$Template);
			}
		}

		$temp = explode(' ', ($datapengadilan->row(0)->NamaPN));
		$Template = str_replace("#pa/ms#",''. ucwords(strtolower($temp[0].' '. $temp[1])).'',$Template);
		//END COPY

		
		//Info Sidang
		$inf_sidang = $info_sidang;
		foreach ($inf_sidang as $row) {
		    $hari_sidang = $this->templatehelper->getHari($row->tanggal_sidang);
		    $tanggal_sidang = $this->templatehelper->convertKeTglIndo($row->tanggal_sidang);
		    $jam_sidang='........';
		    $sampai_jam='........';
		    if($row->jam_sidang!=''){
		    	$jam_sidang = explode(":", $row->jam_sidang);
		    	$jam_sidang = $jam_sidang[0].":".$jam_sidang[1];
			}
			if($row->sampai_jam!=''){
				$sampai_jam = explode(":", $row->sampai_jam);
		    	$sampai_jam = $sampai_jam[0].":".$sampai_jam[1];
			}
		    $dihadiri_oleh=$row->dihadiri_oleh;
		    $Template = str_replace('#hari_sidang#',$hari_sidang,$Template);
		    $Template = str_replace('#tanggal_sidang#',$tanggal_sidang,$Template);
		    $Template = str_replace('#jam_sidang#',$jam_sidang." #zona_waktu#",$Template);
		    $Template = str_replace('#jam_selesai_sidang#',$sampai_jam." #zona_waktu#",$Template);
		}
		//print_r($this->arr_pengacara_tergugat);exit();
		switch ($dihadiri_oleh) {
			case 1:
				$kehadiran="Pemohon/Penggugat ";
				if(!empty($this->arr_pengacara_penggugat)){
					$kehadiran.= "dan kuasanya menghadap di muka persidangan ";
				}else{
					$kehadiran.= "menghadap sendiri ";
				}
				$kehadiran.="\\par Termohon/Tergugat ";
				if(!empty($this->arr_pengacara_tergugat)){
					$kehadiran.= "dan kuasanya menghadap di muka persidangan ";
				}else{
					$kehadiran.= "menghadap sendiri ";
				}
				$kehadiran.="\\par\\fi855\\qj Selanjutnya #tunggal/ketua# memeriksa identitas Pemohon/Penggugat dan Termohon/Tergugat, yang ternyata identitas Pemohon/Penggugat dan Termohon/Tergugat sesuai dengan yang tertera dalam surat permohonan/ gugatan;";
			break;
			case 2:
				$kehadiran="Pemohon/Penggugat ";
				if(!empty($this->arr_pengacara_penggugat)){
					$kehadiran.= "dan kuasanya menghadap di muka persidangan ";
				}else{
					$kehadiran.= "menghadap sendiri ";
				}
				$kehadiran.="\\par Termohon/Tergugat ";
				if(!empty($this->arr_pengacara_tergugat)){
					$kehadiran.= "dan kuasanya tidak menghadap ke  persidangan sekalipun menurut relaas Nomor #NOMOR_PERKARA#, tanggal \highlight7 ……………\highlight0 yang dibacakan di persidangan, Kuasa Pemohon/Penggugat telah dipanggil secara resmi dan patut untuk menghadap ke persidangan; ";
				}else{
					$kehadiran.= "tidak menghadap ke  persidangan sekalipun menurut relaas Nomor #NOMOR_PERKARA#, tanggal \highlight7 ……………\highlight0 yang dibacakan di persidangan, Kuasa Pemohon/Penggugat telah dipanggil secara resmi dan patut untuk menghadap ke persidangan; ";
				}
			break;
			case 3:
				$kehadiran="Pemohon/Penggugat ";
				if(!empty($this->arr_pengacara_penggugat)){
					$kehadiran.= "dan kuasanya tidak menghadap ke  persidangan sekalipun menurut relaas Nomor #NOMOR_PERKARA#, tanggal \highlight7 ……………\highlight0 yang dibacakan di persidangan, Kuasa Pemohon/Penggugat telah dipanggil secara resmi dan patut untuk menghadap ke persidangan; ";
				}else{
					$kehadiran.= "tidak menghadap ke  persidangan sekalipun menurut relaas Nomor #NOMOR_PERKARA#, tanggal \highlight7 ……………\highlight0 yang dibacakan di persidangan, Kuasa Pemohon/Penggugat telah dipanggil secara resmi dan patut untuk menghadap ke persidangan; ";
				}
				$kehadiran.="\\par Termohon/Tergugat ";
				if(!empty($this->arr_pengacara_tergugat)){
					$kehadiran.= "dan kuasanya menghadap di muka persidangan ";
				}else{
					$kehadiran.= "menghadap sendiri ";
				}
			break;
			case 4:
				$kehadiran="Pemohon/Penggugat ";
				if(!empty($this->arr_pengacara_penggugat)){
					$kehadiran.= "dan kuasanya tidak menghadap ke  persidangan sekalipun menurut relaas Nomor #NOMOR_PERKARA#, tanggal \highlight7 ……………\highlight0 yang dibacakan di persidangan, Kuasa Pemohon/Penggugat telah dipanggil secara resmi dan patut untuk menghadap ke persidangan; ";
				}else{
					$kehadiran.= "tidak menghadap ke  persidangan sekalipun menurut relaas Nomor #NOMOR_PERKARA#, tanggal \highlight7 ……………\highlight0 yang dibacakan di persidangan, Kuasa Pemohon/Penggugat telah dipanggil secara resmi dan patut untuk menghadap ke persidangan; ";
				}
				$kehadiran.="\\par Termohon/Tergugat ";
				if(!empty($this->arr_pengacara_tergugat)){
					$kehadiran.= "dan kuasanya tidak menghadap ke  persidangan sekalipun menurut relaas Nomor #NOMOR_PERKARA#, tanggal \highlight7 ……………\highlight0 yang dibacakan di persidangan, Kuasa Pemohon/Penggugat telah dipanggil secara resmi dan patut untuk menghadap ke persidangan; ";
				}else{
					$kehadiran.= "tidak menghadap ke  persidangan sekalipun menurut relaas Nomor #NOMOR_PERKARA#, tanggal \highlight7 ……………\highlight0 yang dibacakan di persidangan, Kuasa Pemohon/Penggugat telah dipanggil secara resmi dan patut untuk menghadap ke persidangan; ";
				}
			break;
			default:
				$kehadiran="\\highlight7 [Mohon diisi kehadiran di dalam aplikasi jadwal sidang]\\highlight0 ";
			break;
		}
		$kehadiran="\\fi855 ".$kehadiran;
		$Template = str_replace('#kehadiran_sidang#',"\pard \sl360\slmult1 ".$kehadiran,$Template);
		
		return $Template;
	}

	function looping_majelis_agama($Template, $data){
		foreach ($data as $key => $value) {
			$$key=$value;
		}
		$data = $susunanMajelis;
		$hakim = array();
		$pengacara = array();
		foreach ($data->result() as $row) {
		    if (!$this->in_multiarray($row->nama_hakim, $hakim)){
		        $hakimItem = array();
		        $hakimItem["urutan_hakim"] = $row->urutan_hakim;
		        $hakimItem["jabatan_hakim_id"] = $row->jabatan_hakim_id;
		        $hakimItem["nama"] = $row->nama_hakim;
		        $hakimItem["nrp_hakim"] = '';
		        $hakimItem["pangkat_hakim"] = '';
		        $hakimItem["jabatan_hakim_nama"] = $row->jabatan_hakim_nama;
		        $hakimItem["nama_pp"] = $row->nama_pp;
		        $hakimItem["pangkat_pp"] = '';
		        $hakimItem["nip_pp"] = '';
		        $hakimItem["nama_om"] = '';
		        $hakimItem["nrp_om"] = '';
		        $hakimItem["pangkat_om"] = ''; 
		        $hakimItem["nama_p"] = $row->nama_p;
		        $hakimItem["nrp_p"] = '';
		        $hakimItem["pangkat_p"] = $row->pangkat_p;
		        $hakim[] = $hakimItem;
		        if ($row->jabatan_hakim_id==1){
		            $this->nrp_hakim_ketua=$row->nip_hakim;
		            $this->pangkat_hakim_ketua=$row->pangkat_hakim;
		        }
		    }
		   if (!$this->in_multiarray($row->nama_p, $pengacara)){
		        $pengacaraPitem = array();
		        $pengacaraPitem["nama_ph"] = $row->nama_p;
		        $pengacara[]=$pengacaraPitem;
		    }
		}

		$hakim_anggotas = '';
		$daftar_majelis = '';
		$data_hakim = $hakim;
		$majelis = true;
		$i=1;$j=1;
		foreach ($data_hakim as $row) {
		    if($row['jabatan_hakim_id']==1){
		        $this->hakim_ketua = $this->templatehelper->standradnaming($row['nama']);
		        $daftar_majelis .= $i.".\\tab ".$this->templatehelper->standradnaming($row['nama']).' \tab Sebagai Hakim Ketua;\\par ';
		    }elseif($row['jabatan_hakim_id']==2){
		        if ($i === count($data_hakim)){
		            $hakim_anggotas .= $this->templatehelper->standradnaming($row['nama']).'';
		        }else{
		            if ($j==1 && $i>1){
		                $hakim_anggotas .= $this->templatehelper->standradnaming($row['nama']).'\tab '.$this->hakim_ketua.'\\par \\par \\par ';
		            }else{
		                $hakim_anggotas .= $this->templatehelper->standradnaming($row['nama']).'\\par \\par \\par ';
		            }
		        }
		        $daftar_majelis .= $i.".\\tab ".$this->templatehelper->standradnaming($row['nama']).' \tab Sebagai Hakim Anggota; ';
		        if($i!=3)$daftar_majelis .= "\\par ";
		        $j++;
		    }elseif($row['jabatan_hakim_id']==3){
		        $majelis = false;
		        $daftar_majelis .= $i.".\\tab ".$this->templatehelper->standradnaming($row['nama']).' \tab Sebagai Hakim;\\par ';
		        $this->hakim_ketua = $this->templatehelper->standradnaming($row['nama']);
		    }
		    $this->panitera = $this->templatehelper->standradnaming($row['nama_pp']).' \tab Sebagai Panitera;\\par ';
		    $this->panitera_ttd = $this->templatehelper->standradnaming($row['nama_pp']);
		    $i++;
		}
		$daftar_majelis.="dan dibantu ".$this->panitera;
		if($majelis){
		    $Template = str_replace('#susunan_majelis#','\ltrpar\qj\fi-284\li284 #susunan_majelis# \ltrpar\qj ',$Template);
		    $Template = str_replace('#susunan_majelis#',$daftar_majelis,$Template);
		}
		return $Template;
	}
}
?>
