<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Setting_bas_agama_c extends CI_Controller {

	function __construct(){
		parent::__construct();
		if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }       
        $this->load->helper('text');
	}

	function index(){
		$jenis_pengadilan=$this->session->userdata('jenis_pengadilan');
		$enc = $this->nativesession->get_flash_session('enc');
		$this->nativesession->set('enc', $enc);
		$perkara_id=$this->encrypt->decode(base64_decode($enc));
		$sidang_id = $this->nativesession->get_flash_session('sidang_id');
		$this->nativesession->set('sidang_id', $sidang_id);
		$this->load->model('bas/info_perkara', 'perkara');
		$result = ($this->perkara->getInfoPerkara($perkara_id)->result_array());
		$data = $result[0];
		$result=$this->perkara->get_info_sidang($sidang_id, $perkara_id)->result_array();
		$data['arr_info_sidang'] = $result[0];
		$data['enc']=$enc;
		$data['perkara_id']=$perkara_id;
		$result=$this->perkara->get_data_bas($sidang_id);
		if ($result->num_rows()!=0){
			$data['info_bas']=$result->result();
			$tes = $result->result();
		}else{
			$data['info_bas']=array();
		};
		foreach ($data['info_bas'] as $row) {
			if ($row->jenis_agenda_id==6 || $row->jenis_agenda_id==7){
				$result=$this->perkara->get_data_tanya_jawab($sidang_id);
				break;
			}
		}
		$data['info_tanya_jawab']=array();
		if (count($data['info_bas'])>0){
			$data['info_tanya_jawab']=$result->result();
		}
		$penutup_id=$this->perkara->get_penutup_bas($perkara_id, $sidang_id);
		if ($penutup_id->num_rows()>0){
			$penutup_id=$penutup_id->row()->agenda_id;
		}else{
			$penutup_id='';
		}
		$data['penutup_id']=$penutup_id;
		$data['list_penutupan']=$this->perkara->getListPenutupan();
		$this->load->view('bas/setting_bas_v', $data);
	}

	function tambah_agenda_bas($no_urut=0){
		$alur_perkara_id=$this->nativesession->get_flash_session('alur_perkara_id');
		$enc = $this->nativesession->get_flash_session('enc');
		$data['enc']=$enc;
		$this->load->model('bas/info_perkara', 'perkara');
		$result=$this->perkara->get_jenis_agenda()->result_array();
		$data['jenis_agenda']=$result;
		$data['no_urut'] = $no_urut;
		$this->load->view('bas/tambah_agenda_bas_v', $data);	
	}

	function get_list_pihak(){
		if ($this->input->post('status_pihak_id')){
			$status_pihak_id = $this->input->post('status_pihak_id', true);
			$perkara_id = $this->nativesession->get('perkara_id');
			$this->load->model('bas/info_perkara', 'perkara');
			switch($status_pihak_id){
				case '1':
					//saksi pihak 1
					$table='perkara_pihak5';
					$result=$this->perkara->get_list_pihak($table, $perkara_id,$status_pihak_id)->result();
				break;
				case '2':
					//saksi pihak 2
					$table='perkara_pihak5';
					$result=$this->perkara->get_list_pihak($table, $perkara_id,$status_pihak_id)->result();
				break;
				case '3':
					//saksi pihak 3
					$table='perkara_pihak5';
					$result=$this->perkara->get_list_pihak($table, $perkara_id,$status_pihak_id)->result();
				break;
			}
			$res='';
			foreach ($result as $row) {
				$res.="<option value='".$row->id."'>".$row->nama."</option> ";
			}
			echo $res;
		}
	}
	function get_agenda_param(){
		if ($this->input->post('agenda_id')){
			$ada_ck=false;
			$agenda_id=$this->input->post('agenda_id', true);
			$this->load->model('bas/info_perkara', 'perkara');
			$result=$this->perkara->get_agenda($agenda_id)->result();
			$opsi=array(); 
			$urutan=0;$i=0;
			$res='';$textarea=array();
			foreach ($result as $row) {
				if ($row->urutan==0){
					$konten_dokumen=$row->konten_dokumen;
				}else{
					if($row->urutan!=1){
						
						if (strpos($row->type,'dropdown') !== false) {
							$res.="<option value='".$row->id."'>".$row->preview."</option>";
						}
						if($i==count($result)){
							$res.='</select></span></br>';	
						}
					}else{
						$res.='<label>Opsi '.$row->urutan."</label> ";
						if (strpos($row->type,'dropdown') !== false) {
							$res.="<span class='custom-dropdown custom-dropdown--emerald' style='width:300px'>
									<select name='select_".$agenda_id."' style='width:300px' class='custom-dropdown__select custom-dropdown__select--white options_ck dynamic'>";	
							$res.="<option value='".$row->id."'>".$row->preview."</option>";
						}
					}
				}
				if (strpos($row->type,'input_text') !== false) {
					if (!$ada_ck){
						#configurasi CKeditor, this editior has been costumize for SIPP need.
						$this->load->library('ckeditor');
						$this->ckeditor->basePath = base_url().'resources/ckeditor/';
						$this->ckeditor->config['toolbar'] = array(
							array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
								'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
									'-', 'RemoveFormat','-', 'Blockquote',
									'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
									'-','Undo','Redo','-','NumberedList','BulletedList','/',
									'-','Image'),
							array('-','Format', 'Font', 'FontSize',
								'-','TextColor', 'BGColor','Table',
								'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
								'-','Print','Preview'
								));
						$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
						$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
						$this->ckeditor->config['resize'] = 'false';
						$this->ckeditor->config['language'] = 'en';
						$this->ckeditor->config['width'] = '810px';
						$this->ckeditor->config['height'] = '250px';
					}
					$ada_ck=true;
					$textarea[]='<div id="ckdiv"><label hidden class="isian" id="lbl_isian_'.$row->id.'">Isian: </label></br><textarea style ="height:0px;display:none;" class="textarea" id="text_'.$row->id.'" name="text_'.$row->id.'">'.$row->preview.'</textarea></br></div>';
					$this->ckeditor->replace('text_'.$row->id);

				}
				$urutan=$row->urutan;$i++;
			}
			$res.='</select></span></br>';
			foreach ($textarea as $value) {
				$res.=$value;
			}
		
			
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> '));
			return;
		}
		echo $res; 
	}
	function get_preview(){
		if ($this->input->post()){
			$param = $this->input->post('param',true);
			$agenda_id = $this->input->post('agenda_id',true);
			$isian=$this->input->post('isian', true);
			$enc=$this->input->post('enc', true);
			$this->load->model('bas/info_perkara', 'perkara');
			$result=$this->perkara->get_jenis_agenda($agenda_id)->result();
			if ($this->input->post('no_urut')==1){
				$res=$result[0]->konten_dokumen;	
			}else{
				$res='';
			}
			$arr_param = explode('&', $param);
			$id=array();$urutan=array();
			$where='';$i=1;
			$sl_tanggapan_put_terdakwa='';
			$sl_tanggapan_put_oditur='';
			foreach ($arr_param as $val) {
				$arr=explode('=',$val);	
				if (strpos($arr[0],'select') !== false) {
					$urutan[]=$arr[1];
					$id[]=$arr[1];
					$where.= ' id='.$arr[1];
					if ($i<=(count($arr_param))){
						$where.=' OR ';
					}
				}
				if ($arr[0]=='sl_tanggapan_put_terdakwa'){
					$sl_tanggapan_put_terdakwa=$arr[1];
				}
				if ($arr[0]=='sl_tanggapan_put_oditur'){
					$sl_tanggapan_put_oditur=$arr[1];
				}
				$i++;
			} 
			$where.=' urutan=0';
			$result=$this->perkara->get_preview($agenda_id, $where)->result();
			foreach ($result as $row) {
				$res.=$row->konten_dokumen.' ';
			}
			if ($isian!=''){
				$res = str_replace('#isian#',''.$isian.'',$res);
			}
			if ($agenda_id==9){
				$perkara_id=$this->encrypt->decode(base64_decode($enc));
				$result=$this->perkara->getInfoPerkara($perkara_id)->result();
				$isian_penuntutan = ($result[0]->isi_penuntutan);
				if ($isian_penuntutan!=''){
					$res = str_replace('#isian_penuntutan#',''.$isian_penuntutan.'',$res);
				}else{
					$res = str_replace('#isian_penuntutan#','[PENUNTUTAN BELUM DIINPUT KEDALAM APLIKASI SIPP]',$res);
				}
			}elseif ($agenda_id==4){
				$perkara_id=$this->encrypt->decode(base64_decode($enc));
				$result=$this->perkara->getInfoPerkara($perkara_id)->result();
				$isian_penuntutan = ($result[0]->isi_penuntutan);
				if ($isian_penuntutan!=''){
					$res = str_replace('#isian_putusan_sela#',''.$isian_penuntutan.'',$res);
				}else{
					$res = str_replace('#isian_putusan_sela#','[PENUNTUTAN BELUM DIINPUT KEDALAM APLIKASI SIPP]',$res);
				}
			}
			if($sl_tanggapan_put_terdakwa!=''){
				switch ($sl_tanggapan_put_terdakwa) {
					case '1':
						$res = str_replace('#sikap_terdakwa_putusan#','menerima putusan',$res);
					break;
					case '2':
						$res = str_replace('#sikap_terdakwa_putusan#','mengajukan grasi',$res);
					break;
					case '3':
						$res = str_replace('#sikap_terdakwa_putusan#','mengajukan banding',$res);
					break;
					case '4':
						$res = str_replace('#sikap_terdakwa_putusan#','belum menyatakan sikap',$res);
					break;
				}
			}
			if($sl_tanggapan_put_oditur!=''){
				switch ($sl_tanggapan_put_oditur) {
					case '1':
						$res = str_replace('#sikap_jaksa_putusan#','menerima putusan',$res);
					break;
					case '2':
						$res = str_replace('#sikap_jaksa_putusan#','mengajukan banding',$res);
					break;
					case '4':
						$res = str_replace('#sikap_jaksa_putusan#','belum menyatakan sikap',$res);
					break;
				}
			}
			$res = str_replace('#jaksa#','Oditur Militer',$res);
			$res = str_replace('#tunggal/ketua#','Hakim Ketua',$res);
			$res = str_replace('#hakim/majelis#','Majelis Hakim',$res);
			print_r($res);
		}
	}
	 


	function cetak(){
		$arr_agenda_id=array();
		$arr_id=array();$arr_isian=array();$arr_tanya_jawab=array();
		$segment = $this->uri->segment_array();
		$perkara_id=$this->encrypt->decode(base64_decode($segment[3]));
		$this->perkara_id=$perkara_id;
		$sidang_id=$segment[4];
		$penutup_id='';
		$arr_tanggapan_put=array();
		$arr_post=$this->input->post();
		foreach ($arr_post as $key => $value) {
			if (is_numeric($key)){
				$value= json_decode($value);
				if (strpos($value->name,'agenda_id') !== false) {
					$arr_agenda_id[]=$value->value;
				}elseif (strpos($value->name,'text') !== false){
					$arr_isian[$value->name]=$this->templatehelper->cleanHtmlTagSpecial($value->value);
				}elseif (strpos($value->name,'id[]') !== false){
					$arr_id[]=$value->value;
				}elseif ((strpos($value->name,'pihak_ke') !== false) 
					OR (strpos($value->name,'sumber_id') !== false)
					OR (strpos($value->name,'penanya_t') !== false)
					OR (strpos($value->name,'pertanyaan_t') !== false)
					OR (strpos($value->name,'jawaban_t') !== false)
					OR (strpos($value->name,'kenal') !== false)
					OR (strpos($value->name,'tanggapan_terdakwa') !== false)
					OR (strpos($value->name,'urutan_sumber') !== false)
					OR (strpos($value->name,'urutan_penanya') !== false)
					OR (strpos($value->name,'urutan_pertanyaan') !== false)
					)
				{
					$arr=explode('__', $value->name);
					if ($arr[0]==='pihak_ke'){	
						switch ($value->value) {
							case '13':
								$table='perkara_pihak5';
								$agenda_id='6';
							break;
							case '1':
								$table='perkara_pihak1';
								$agenda_id='0'; //sumber oditur acara sidang apa?
							break;
							case '8':
								$table='perkara_pengacara';
								$agenda_id='0'; //sumber penasihat_hukum acara sidang apa?
							break;
							case '2':
								$table='perkara_pihak2';
								$agenda_id='7';
							break;
							default:
								$table='perkara_pihak5';
								$agenda_id='6';
							break;
						}
						$arr_val=array('perkara_id'=>$perkara_id, 'sidang_id'=>$sidang_id, 'jenis_agenda_id'=>$agenda_id, $arr[0]=>$value->value, 'tabel_asal_sumber'=>$table);
					}else{
						$arr_val=array($arr[0]=>$value->value);
					}
					if(empty($arr_tanya_jawab[$arr[1]])){
						$arr_tanya_jawab[$arr[1]] = array();
					}
					$arr_tanya_jawab[$arr[1]] = array_merge($arr_tanya_jawab[$arr[1]], $arr_val);
				}elseif (strpos($value->name,'sl_tanggapan') !== false){
					$arr_tanggapan_put[$value->name]=$value->value;
				}else{
					echo 'Gagal parse post data';
					exit();
				} 
			}else{
				$penutup_id=$value;
			}
		}
		$data=array();
		$data['perkara_id']=$perkara_id;
		$data['sidang_id']=$sidang_id;
		$insert_batch_tanya_jawab=array();
		$data['pemeriksaan_saksi']=false;
		$data['pemeriksaan_terdakwa']=false;
		foreach ($arr_tanya_jawab as $row) {
			if (!array_key_exists('kenal', $row)) {
			    $row['kenal']='';
			    $row['tanggapan_terdakwa']='';
			    $data['pemeriksaan_terdakwa']=true;
			}else{
				if ($row['kenal']==''){
					$data['pemeriksaan_terdakwa']=true;
				}else{
					$data['pemeriksaan_saksi']=true;
				}
			}
			$insert_batch_tanya_jawab[]=$row;
		}
		$this->load->model('bas/info_perkara', 'perkara');
		$result = ($this->perkara->getInfoPerkara($perkara_id)->result_array());
		foreach ($result[0] as $key =>$val) {
			$data[$key]=$val;
		}

		//getinfosidang
		$result=$this->perkara->get_info_sidang($sidang_id, $perkara_id)->result();
		$tanggal_sidang=$result[0]->tanggal_sidang;
		$urutan = ($result[0]->urutan);
		//ambil kontent pembuka bas
		if($this->session->userdata('jenis_pengadilan')==2){
			$jenis_agenda_id_pembuka =0;
		}elseif($this->session->userdata('jenis_pengadilan')==3){
			$jenis_agenda_id_pembuka =100;
		}elseif($this->session->userdata('jenis_pengadilan')==4){
			$jenis_agenda_id_pembuka =200;
		}
		if ($urutan==1){
			$data['lanjutan']='';
			$result=$this->perkara->get_preview($jenis_agenda_id_pembuka, 'urutan=1')->result();
		}else{
			$data['lanjutan']=' LANJUTAN KE '.$urutan;
			$result=$this->perkara->get_preview($jenis_agenda_id_pembuka, 'urutan=2')->result();
		}
		$data['pembuka_bas']=$this->templatehelper->cleanHtmlTagSpecial(ascii_to_entities($result[0]->konten_dokumen));
		//ambil kontent penutup bas
		switch ($this->session->userdata('jenis_pengadilan')) {
			case '2':
				$result=$this->perkara->get_preview(-1, 'id='.$penutup_id)->result();
			break;
			case '3':
				$result=$this->perkara->get_preview(-100, 'id='.$penutup_id)->result();
			break;
			case '4':
				$result=$this->perkara->get_preview(-200, 'id='.$penutup_id)->result();
			break;
		}
		if (count($result)>0){
			$data_penutup=array();
			$data_penutup['perkara_id']=$perkara_id;
			$data_penutup['sidang_id']=$sidang_id;
			$data_penutup['agenda_id']=$penutup_id;
			$data_penutup['redaksi']=$this->templatehelper->cleanHtmlTagSpecial(ascii_to_entities($result[0]->konten_dokumen));
			$data_penutup['diinput_tanggal']=date('Y-m-d H:i:s');
			$data_penutup['diinput_oleh']=$this->session->userdata('username');
			$this->perkara->add_penutup_bas($data_penutup);
			$data['penutup_bas']=$this->templatehelper->cleanHtmlTagSpecial(ascii_to_entities($result[0]->konten_dokumen));
		}else{
			$data['penutup_bas']='Redaksi Penutup Tidak Ada dalam Database ';
		}
		
		$isian_penuntutan='';
		foreach ($arr_agenda_id as $val) {
			if ($val==9){
				$penuntutan=$this->perkara->getInfoPerkara($perkara_id)->result();
				$isian_penuntutan = ($penuntutan[0]->isi_penuntutan);
			}
		}
		//print_r($arr_agenda_id);exit();
		$result=$this->perkara->get_jenis_agenda($arr_agenda_id[0])->result();
		$res=$this->templatehelper->cleanHtmlTagSpecial(ascii_to_entities($result[0]->konten_dokumen)).' ';
		$where='';$i=1;
		foreach ($arr_id as $val) {
			$where.= ' a.id="'.$val.'"';
			if($i<count($arr_id)){
				$where.=' OR ';	
			}
			$i++;
		};
		
		$result=$this->perkara->cetak_preview(1000, $where)->result();
		//print_r($result);
		//exit();
		$i=1;
		$data_insert = array();
		$data_sidang_detil=array();
		foreach ($result as $row) {
			if (strpos($row->type,'input_text') !== false) {
				$row->konten_dokumen = str_replace('#isian#',''.$arr_isian['text_'.$row->id].'',$row->konten_dokumen);
				$arr_data_sidang_detil[$row->jenis_agenda_id]=array('jenis_agenda_id'=>$row->jenis_agenda_id,
																'uraian'=>$arr_isian['text_'.$row->id],
																'diinput_oleh' => $this->session->userdata('username'),
								    							'diinput_tanggal' => date("Y-m-d h:i:s",time())
								    						);
			}elseif (strpos($row->type,'tanya_jawab') !== false){
				$arr_data_sidang_detil[$row->jenis_agenda_id]=array('jenis_agenda_id'=>$row->jenis_agenda_id,
																'uraian'=>$row->konten_dokumen,
																'diinput_oleh' => $this->session->userdata('username'),
								    							'diinput_tanggal' => date("Y-m-d h:i:s",time())
								    						);
			}
			$res.=$this->templatehelper->cleanHtmlTagSpecial(ascii_to_entities($row->konten_dokumen)).' ';
			if ($i==1){
				$row->konten_dokumen=$res;
			}
			$data_insert[]=array(
			      'perkara_id' => $perkara_id,
			      'sidang_id' => $sidang_id,
			      'jenis_agenda_id' => $row->jenis_agenda_id,
			      'nama_agenda' => $row->nama,
			      'agenda_id' => $row->id,
			      'urutan' => $i,
			      'redaksi' => $this->templatehelper->cleanHtmlTagSpecial(ascii_to_entities($row->konten_dokumen)),
			      'diinput_oleh' => $this->session->userdata('username'),
			      'diinput_tanggal' => date("Y-m-d h:i:s",time())
			   );
			$i++;
		};
		//print_r($arr_data_sidang_detil);
		//exit();
		if (!empty($arr_data_sidang_detil)){
			foreach ($arr_data_sidang_detil as $row) {
				foreach ($row as $key => $value) {
					$row[$key]=$this->templatehelper->cleanHtmlTagSpecial(ascii_to_entities($value));
				}
				$data_sidang_detil[]=$row;
			}
			$this->perkara->simpan_sidang_detil($data_sidang_detil, $perkara_id, $sidang_id);	
		}
		//print_r($insert_batch_tanya_jawab);
		//exit();
		if (!empty($insert_batch_tanya_jawab)){
			$this->perkara->simpan_tanya_jawab($insert_batch_tanya_jawab, $perkara_id, $sidang_id);	
		}
		//print_r($insert_batch_tanya_jawab);
		//exit();
		if ($data['pemeriksaan_saksi']){
			$data['info_pemeriksaan_saksi']=$this->perkara->get_info_pemeriksaan($perkara_id, $sidang_id, 6)->result();		
			$data['info_pihak_saksi']=$this->perkara->get_info_pihak($perkara_id, $sidang_id, 6)->result();		
		}
		if ($data['pemeriksaan_terdakwa']){
			$data['info_pemeriksaan_terdakwa']=$this->perkara->get_info_pemeriksaan($perkara_id, $sidang_id, 7)->result();		
			$data['info_pihak_terdakwa']=$this->perkara->get_info_pihak($perkara_id, $sidang_id, 7)->result();		
		}
		$data['jenis_pengadilan']=$this->session->userdata('jenis_pengadilan');
		$result=$this->perkara->get_info_sidang($sidang_id, $perkara_id);
		$data['info_sidang']=$result->result();
		$result=$this->perkara->get_info_sidang_tundaan($sidang_id, $perkara_id);
		$data['info_sidang_tundaan']=$result;
		$data['dataterdakwa']=$this->perkara->getDataTerdakwaMil($perkara_id);
		//$data['datapenahanan'] = $this->perkara->getDataPenahananTerdakwaMil($perkara_id);
		$data['susunanMajelis']=$this->perkara->getSusunanMajelisMil($perkara_id);
		$data['konten']=$this->templatehelper->cleanHtmlTagSpecial($res);
		
		//print_r($data_insert);
		//exit();
		if ($this->perkara->add_data($data_insert)){
			$info_pn=$this->perkara->getDataPN()->result();
			$data['info_pn']=$info_pn[0];
			#configurasi CKeditor, this editior has been costumize for SIPP need.
			$this->load->library('ckeditor');
			$this->ckeditor->basePath = base_url().'resources/ckeditor/';
			$this->ckeditor->config['toolbar'] = array(
				array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
					'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
						'-', 'RemoveFormat','-', 'Blockquote',
						'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
						'-','indent','-', 'Undo','Redo','-','NumberedList','BulletedList','/',
						'-','Image'),
				array('-','Format', 'Font', 'FontSize',
					'-','TextColor', 'BGColor','Table',
					'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
					'-','Print','Preview'
					));
			$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
			$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
			$this->ckeditor->config['resize'] = 'false';
			$this->ckeditor->config['language'] = 'en';
			$this->ckeditor->config['width'] = '810px';
			$this->ckeditor->config['height'] = '250px';
			$this->ckeditor->config['extraPlugins'] = 'indentblock';
			$this->ckeditor->config['extraPlugins'] = 'indent';
			
			switch ($this->session->userdata('jenis_pengadilan')) {
				case '4':
					$data = array_merge($data,$this->load_data_agama());
					//$data['Template']= $this->get_contens('master_tun');
					$data['Template']=$this->replace_temp_agama($data);
					$this->load->view('bas/cetak_tun_bas',$data,FALSE);	
				break;
			}
		}else{
			echo "Gagal Cetak !!!";
		}
	}

	function load_data_agama(){
		$this->load->model('generate_template/m_template_bas_pertama_agama','template');
        $data['dataperkara'] = $this->template->getDataPerkara($this->perkara_id);
        $data['datapengadilan'] = $this->template->getDataPA();
        $data['datapenetapanpanitera']=$this->template->getDataPenetapanPanitera($this->perkara_id);
        $data['datapenetapanhakim']=$this->template->getDataPenetapanHakim($this->perkara_id);
        $data['datapaniterapengganti']=$this->template->getDataPP($this->perkara_id);
        $data['datapersidangan']=$this->template->getDataSidang($this->perkara_id);
        $data['datamediator']=$this->template->getDataMediator($this->perkara_id);
        $data['dataputusanverstek']=$this->template->getDataPutusanVerstek($this->perkara_id);
        $data['dataputusansela']=$this->template->getDataPutusanSela($this->perkara_id);
        $data['dataPihak1']=$this->template->get_data_pihak_loop($this->perkara_id,1);
        $data['dataPihak2']=$this->template->get_data_pihak_loop($this->perkara_id,2);
        $data['dataPihak3']=$this->template->get_data_pihak_loop($this->perkara_id,3);
        $data['dataPihak4']=$this->template->get_data_pihak_loop($this->perkara_id,4);
        $data['dataPengacaraPihak1']=$this->template->get_data_pengacara($this->perkara_id,1);
        $data['dataPengacaraPihak2']=$this->template->get_data_pengacara($this->perkara_id,2);        
        $data['dataPengacaraPihak3']=$this->template->get_data_pengacara($this->perkara_id,3); 
        return $data;
	}


	function get_contens($filemaster){
		$url = base_url("resources/template/berita_acara/bas_atria/".$filemaster.".rtf");
		$Template = file_get_contents($url);
		return $Template;
	}

	function in_multiarray($sval, $arr){
	    $ret = false;
	    foreach ($arr as $value) {
	        if (is_array($value)){
	            $ret = $ret | $this->in_multiarray($sval, $value);
	        }else{
	            if ($value == $sval){
	                return true;
	            }
	        }
	    }
	    return $ret;
	}

	function replace_temp_agama($data){
		foreach ($data as $key => $value) {
			$$key=$value;
		}
		
		$url = base_url("resources/template/berita_acara/bas_atria/master_agama.rtf");
		$Template = file_get_contents($url);
		$Template = str_replace('#penutup_bas#',''.$penutup_bas.'',$Template);
		$Template = str_replace('#nomor_perkara#',''.$nomor_perkara.'',$Template);
		$Template = str_replace('#lanjutan#',''.$lanjutan.'',$Template);
		$Template = str_replace('#pembuka_bas#',''.$pembuka_bas.'',$Template);
		$Template = str_replace('#konten_bas#',''.$konten.'',$Template);

		$Template=$this->looping_majelis_agama($Template,$data);
		//START COPY
		$nomor_perkara = $dataperkara->row(0)->nomor_perkara;
		$tgl_pendaftaran = $this->templatehelper->convertKeTglIndo($dataperkara->row(0)->tanggal_pendaftaran);
		$namakota = $datapengadilan->row(0)->NamaPN;

		$id_urutan =0;
		if($datapersidangan!=''){
		    if($datapersidangan->num_rows>0){
		        foreach ($datapersidangan->result() as $row) {
		            //$nextsidang = $idjadwal+1;
		            if ($id_urutan>0){
		                $nextsidang = $id_urutan+1;
		                    if($nextsidang=$row->urutan){
		                        $tgl_sidang_tunda = $row->tanggal_sidang;
		                    }
		            }
		            if($row->id==$sidang_id){
		                $id_urutan = $row->urutan;
		                $tgl_sidang = $row->tanggal_sidang;
		            }
		        }
		    }
		}

		if(!empty($tgl_sidang_tunda)){
		    $tgl_sidang_tunda = $this->templatehelper->convertKeTglIndo($tgl_sidang_tunda);
		    $hari_sidang_tunda =  $this->templatehelper->getHari($tgl_sidang_tunda);
		}else{
		    $tgl_sidang_tunda = '----------------------------';
		    $hari_sidang_tunda = '----------------------------';
		}
		//print_r($tgl_sidang_tunda);exit;

		$Template = str_replace("#TGL_SIDANG#", $this->templatehelper->convertKeTglIndo($tgl_sidang) ,$Template);
		$Template = str_replace("#HARI_SIDANG#", $this->templatehelper->getHari($tgl_sidang) ,$Template);
		$Template = str_replace("#TGL_SIDANG_TUNDA#", $tgl_sidang_tunda ,$Template);
		$Template = str_replace("#HARI_SIDANG_TUNDA#", $hari_sidang_tunda ,$Template);

		$this->arr_pengacara_penggugat='';
		$this->arr_pengacara_tergugat='';
		$i=0;
		$temp_pihak='';
		$temp_kuasa='';
		$pihak_array='';
		if($dataPihak1->num_rows>0){
			foreach ($dataPihak1->result() as $row) {
			    if($temp_pihak!=$row->id_pihak){
			        $temp_pihak=$row->id_pihak;
			        if($i>0){
			            $pihak_array = str_replace("#ke#",' '.$this->templatehelper->converToAngkaRomawi($i), $pihak_array);
			        }
			        
			        $pihak_array.=$row->nama.', umur '.$row->umur.' tahun, agama '.$row->agama.
			                ', pekerjaan '.$row->pekerjaan.', Pendidikan '.$row->pendidikan.
			                ', alamat '.$row->alamat;  
			                    
			        if($row->id_kuasa!=''){
			        	$this->arr_pengacara_penggugat='--';
			            if($i>0){$pihak_array= str_replace("#DKK#",'', $pihak_array);}
			            $pihak_array.=' dalam hal ini memberikan kuasa khusus kepada '.$row->nama_kuasa.
			                ' #DKK# advokat/penasehat hukum dari '.$row->nama.
			                ' yang berkantor di '.$row->alamat_kuasa.' berdasarkan surat kuasa khusus tanggal '.$this->templatehelper->convertKeTglIndo($row->tgl_kuasa).
			                ' sebagai #SEBAGAI_P##ke#;#par#';            
			        }else{
			            $pihak_array.=' sebagai #SEBAGAI_P##ke#;#par#';    
			        }
			        $i++;
			    }else{
			         $pihak_array = str_replace("#DKK#",'dan kawan kawan', $pihak_array);
			    }
			}
			if($i>1){
			    $pihak_array = str_replace("#ke#",' '.$this->templatehelper->converToAngkaRomawi($i), $pihak_array);
			    $pihak_array = str_replace("#par#",' \\par ', $pihak_array);
			}else{
			    $pihak_array = str_replace("#ke#",'', $pihak_array);
			    $pihak_array = str_replace("#par#",'', $pihak_array);
			}
			$pihak_array = str_replace("#DKK#",'', $pihak_array);
			$Template = str_replace("#loopingpenggugat#",$pihak_array,$Template);
		}else{
			$Template = str_replace("#loopingpenggugat#","Data Pihak1 Tidak Ada dalam Database!!!",$Template);
		}

		$i=0;
		$temp_pihak='';
		$temp_kuasa='';
		$pihak_array='';
		if($dataPihak2->num_rows>0){
			foreach ($dataPihak2->result() as $row) {
			    if($temp_pihak!=$row->id_pihak){
			        $temp_pihak=$row->id_pihak;
			        if($i>0){
			            $pihak_array = str_replace("#ke#",' '.$this->templatehelper->converToAngkaRomawi($i), $pihak_array);
			        }
			        
			        $pihak_array.=$row->nama.', umur '.$row->umur.' tahun, agama '.$row->agama.
			                ', pekerjaan '.$row->pekerjaan.', Pendidikan '.$row->pendidikan.
			                ', alamat '.$row->alamat;  
			                    
			        if($row->id_kuasa!=''){
			        	$this->arr_pengacara_tergugat='--';
			            if($i>0){$pihak_array= str_replace("#DKK#",'', $pihak_array);}
			            $pihak_array.=' dalam hal ini memberikan kuasa khusus kepada '.$row->nama_kuasa.
			                ' #DKK# advokat/penasehat hukum dari '.$row->nama.
			                ' yang berkantor di '.$row->alamat_kuasa.' berdasarkan surat kuasa khusus tanggal '.$this->templatehelper->convertKeTglIndo($row->tgl_kuasa).
			                ' sebagai #SEBAGAI_T##ke#;#par#';            
			        }else{
			            $pihak_array.=' sebagai #SEBAGAI_T##ke#;#par#';    
			        }
			        $i++;
			    }else{
			         $pihak_array = str_replace("#DKK#",'dan kawan kawan', $pihak_array);
			    }
			}
			if($i>1){
			    $pihak_array = str_replace("#ke#",' '.$this->templatehelper->converToAngkaRomawi($i), $pihak_array);
			    $pihak_array = str_replace("#par#",' \\par ', $pihak_array);
			}else{
			    $pihak_array = str_replace("#ke#",'', $pihak_array);
			    $pihak_array = str_replace("#par#",'', $pihak_array);
			}
			$pihak_array = str_replace("#DKK#",'', $pihak_array);
			$Template = str_replace("#loopingtergugat#",$pihak_array,$Template);
		}else{
			$Template = str_replace("#loopingtergugat#","Data Pihak2 Tidak Ada dalam Database!!!",$Template);
		}

		$idalurperkara = $this->tanggalhelper->getIDAlurPerkara($perkara_id);
		$jenisPerkaraID=$this->tanggalhelper->getIDJenisPerkara($perkara_id);

		//Info Sidang
		$inf_sidang = $info_sidang;
		foreach ($inf_sidang as $row) {
		    $hari_sidang = $this->templatehelper->getHari($row->tanggal_sidang);
		    $tanggal_sidang = $this->templatehelper->convertKeTglIndo($row->tanggal_sidang);
		    $jam_sidang='........';
		    $sampai_jam='........';
		    if($row->jam_sidang!=''){
		    	$jam_sidang = explode(":", $row->jam_sidang);
		    	$jam_sidang = $jam_sidang[0].":".$jam_sidang[1];
			}
			if($row->sampai_jam!=''){
				$sampai_jam = explode(":", $row->sampai_jam);
		    	$sampai_jam = $sampai_jam[0].":".$sampai_jam[1];
			}
		    $dihadiri_oleh=$row->dihadiri_oleh;
		    $Template = str_replace('#hari_sidang#',$hari_sidang,$Template);
		    $Template = str_replace('#tanggal_sidang#',$tanggal_sidang,$Template);
		    $Template = str_replace('#jam_sidang#',$jam_sidang." #zona_waktu#",$Template);
		    $Template = str_replace('#jam_selesai_sidang#',$sampai_jam." #zona_waktu#",$Template);
		}
		//print_r($this->arr_pengacara_tergugat);exit();
		switch ($dihadiri_oleh) {
			case 1:
				$kehadiran="#SEBAGAI_P# ";
				$pemeriksaan_kuasa='';
				if(!empty($this->arr_pengacara_penggugat)){
					$kehadiran.= "dan kuasanya menghadap di muka persidangan ";
					$pemeriksaan_kuasa.="identitas Kuasa Hukum #jenis_pihak1# ";
				}else{
					$kehadiran.= "menghadap sendiri ";
				}
				$kehadiran.="\\par #SEBAGAI_T# ";
				if(!empty($this->arr_pengacara_tergugat)){
					$kehadiran.= "dan kuasanya menghadap di muka persidangan ";
					if($pemeriksaan_kuasa!=''){
						$pemeriksaan_kuasa.="dan ";	
					}
					$pemeriksaan_kuasa.="identitas Kuasa Hukum #jenis_pihak1# ";
				}else{
					$kehadiran.= "menghadap sendiri ";
				}
				$kehadiran.="\\par\\fi855\\qj Selanjutnya #tunggal/ketua# memeriksa identitas #SEBAGAI_P# dan #SEBAGAI_T#, yang ternyata identitas #SEBAGAI_P# dan #SEBAGAI_T# sesuai dengan yang tertera dalam surat #jenis_perkara#;";
				if($pemeriksaan_kuasa!=''){
					$kehadiran.="\\par Kemudian #tunggal/ketua# memeriksa ".$pemeriksaan_kuasa." serta surat kuasanya, ternyata identitasnya sesuai dengan yang tertera dalam surat #jenis_perkara# dan surat kuasa telah memenuhi syarat formal;";
				}
			break;
			case 2:
				$kehadiran="#SEBAGAI_P# ";
				if(!empty($this->arr_pengacara_penggugat)){
					$kehadiran.= "dan kuasanya menghadap di muka persidangan ";
				}else{
					$kehadiran.= "menghadap sendiri ";
				}
				$kehadiran.="\\par #SEBAGAI_T# ";
				if(!empty($this->arr_pengacara_tergugat)){
					$kehadiran.= "dan kuasanya tidak menghadap ke persidangan sekalipun menurut relaas Nomor #NOMOR_PERKARA#, tanggal \highlight7 ……………\highlight0 yang dibacakan di persidangan, Kuasa #SEBAGAI_T# telah dipanggil secara resmi dan patut untuk menghadap ke persidangan; ";
				}else{
					$kehadiran.= "tidak menghadap ke  persidangan sekalipun menurut relaas Nomor #NOMOR_PERKARA#, tanggal \highlight7 ……………\highlight0 yang dibacakan di persidangan, Kuasa #SEBAGAI_T# telah dipanggil secara resmi dan patut untuk menghadap ke persidangan; ";
				}
			break;
			case 3:
				$kehadiran="#SEBAGAI_P# ";
				if(!empty($this->arr_pengacara_penggugat)){
					$kehadiran.= "dan kuasanya tidak menghadap ke  persidangan sekalipun menurut relaas Nomor #NOMOR_PERKARA#, tanggal \highlight7 ……………\highlight0 yang dibacakan di persidangan, Kuasa #SEBAGAI_P# telah dipanggil secara resmi dan patut untuk menghadap ke persidangan; ";
				}else{
					$kehadiran.= "tidak menghadap ke  persidangan sekalipun menurut relaas Nomor #NOMOR_PERKARA#, tanggal \highlight7 ……………\highlight0 yang dibacakan di persidangan, Kuasa #SEBAGAI_P# telah dipanggil secara resmi dan patut untuk menghadap ke persidangan; ";
				}
				$kehadiran.="\\par #SEBAGAI_T# ";
				if(!empty($this->arr_pengacara_tergugat)){
					$kehadiran.= "dan kuasanya menghadap di muka persidangan ";
				}else{
					$kehadiran.= "menghadap sendiri ";
				}
			break;
			case 4:
				$kehadiran="#SEBAGAI_P# ";
				if(!empty($this->arr_pengacara_penggugat)){
					$kehadiran.= "dan kuasanya tidak menghadap ke  persidangan sekalipun menurut relaas Nomor #NOMOR_PERKARA#, tanggal \highlight7 ……………\highlight0 yang dibacakan di persidangan, Kuasa #SEBAGAI_P# telah dipanggil secara resmi dan patut untuk menghadap ke persidangan; ";
				}else{
					$kehadiran.= "tidak menghadap ke  persidangan sekalipun menurut relaas Nomor #NOMOR_PERKARA#, tanggal \highlight7 ……………\highlight0 yang dibacakan di persidangan, Kuasa #SEBAGAI_P# telah dipanggil secara resmi dan patut untuk menghadap ke persidangan; ";
				}
				$kehadiran.="\\par #SEBAGAI_T# ";
				if(!empty($this->arr_pengacara_tergugat)){
					$kehadiran.= "dan kuasanya tidak menghadap ke  persidangan sekalipun menurut relaas Nomor #NOMOR_PERKARA#, tanggal \highlight7 ……………\highlight0 yang dibacakan di persidangan, Kuasa #SEBAGAI_T# telah dipanggil secara resmi dan patut untuk menghadap ke persidangan; ";
				}else{
					$kehadiran.= "tidak menghadap ke  persidangan sekalipun menurut relaas Nomor #NOMOR_PERKARA#, tanggal \highlight7 ……………\highlight0 yang dibacakan di persidangan, Kuasa #SEBAGAI_T# telah dipanggil secara resmi dan patut untuk menghadap ke persidangan; ";
				}
			break;
			default:
				$kehadiran="\\highlight7 [Mohon diisi kehadiran di dalam aplikasi jadwal sidang]\\highlight0 ";
			break;
		}
		$kehadiran="\\fi855 ".$kehadiran;
		$Template = str_replace('#kehadiran_sidang#',"\pard \sl360\slmult1 ".$kehadiran,$Template);



		if ($idalurperkara==15) {
		    $Template = str_replace("#jenis_perkara#",''."Gugatan".'',$Template);
		    if ($jenisPerkaraID==346) {
		        $Template = str_replace("#jenis_pihak1#",''."Pemohon".'',$Template);
		        $Template = str_replace("#jenis_pihak2#",''."Termohon".'',$Template);
				$Template = str_replace("#SEBAGAI_P#","Pemohon",$Template);
				$Template = str_replace("#SEBAGAI_T#","Termohon",$Template);
		    }else{
		        $Template = str_replace("#jenis_pihak1#",''."Penggugat".'',$Template);
		        $Template = str_replace("#jenis_pihak2#",''."Tergugat".'',$Template);
		        $Template = str_replace("#SEBAGAI_P#","Penggugat",$Template);
		        $Template = str_replace("#SEBAGAI_T#","Tergugat",$Template);
		    }
		}else{
		    $Template = str_replace("#jenis_perkara# ",''." Permohonan ".'',$Template);   
		    $Template = str_replace("#jenis_pihak1#",''." Pemohon ".'',$Template);
		    $Template = str_replace("#jenis_pihak2#",''." Termohon ".'',$Template);
		}
		if($dataPihak2->num_rows>0){
			$Template = str_replace("#NAMA_P#",$dataPihak1->row(0)->nama,$Template);
		}
		if ($dataPihak2->num_rows > 0){
		    $Template = str_replace("#NAMA_T#",$dataPihak2->row(0)->nama,$Template);
		}
		//Pihaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaak
		$Template = str_replace("#nomor_perkara#",$dataperkara->row(0)->nomor_perkara,$Template);
		$Template = str_replace("#NOMOR_PERKARA#",$dataperkara->row(0)->nomor_perkara,$Template);
		$Template = str_replace("#nama_pp#",$datapaniterapengganti->row(0)->nama_gelar,$Template);
		$Template = str_replace("#hakim_ketua#",$datapenetapanhakim->row(0)->nama_gelar,$Template);
		$Template = str_replace("#nama_pa#",ucwords(strtolower($datapengadilan->row(0)->NamaPN)),$Template);
		if(substr(ucwords(strtolower($datapengadilan->row(0)->NamaPN)),0,1)=="P"){$jenis_satker="Pengadilan Agama";}else{$jenis_satker="Mahkamah Syar'iah";}
		$Template = str_replace("#JENIS_SATKER#",$jenis_satker,$Template);

		$Template = str_replace("#ZONA#",$datapengadilan->row(0)->ZonaWaktu,$Template);

		if($datamediator!=''){
		    if($datamediator->num_rows>0){
		        foreach ($datamediator->result() as $mediator) {
		            $namaMediator = $mediator->mediator_text;
		        }
		        $Template = str_replace("#NAMA_MEDIATOR#",''.$namaMediator.'',$Template);
		    }else{
		    	$Template = str_replace("#NAMA_MEDIATOR#",'\\highlight7 [Masukkan Data Mediator keDalam Aplikasi]\\highlight0 ',$Template);
		    }
		}else{
			$Template = str_replace("#NAMA_MEDIATOR#",'\\highlight7 [Masukkan Data Mediator keDalam Aplikasi]\\highlight0 ',$Template);
		}

		if($dataputusanverstek!=''){
		    if($dataputusanverstek->num_rows>0){
		        foreach ($dataputusanverstek->result() as $putusan) {
		            $amarPutusan = $this->templatehelper->cleanHtmlTagSpecial($putusan->amar_putusan);
		        }
		        $Template = str_replace("#AMAR#",''.$amarPutusan.'',$Template);
		    }
		}
		if($dataputusansela!=''){
		    if($dataputusansela->num_rows>0){
		        foreach ($dataputusansela->result() as $sela) {
		            $amarPutusansela = $this->templatehelper->cleanHtmlTagSpecial($sela->amar_sela);
		            $tgl_putusansela = $this->templatehelper->convertKeTglIndo($sela->tanggal_putusan_sela);
		            $hari_putusansela = $this->templatehelper->getHari($sela->tanggal_putusan_sela);
		            $tgl_putusanselaHijriah = $this->templatehelper->convertToHijriah($sela->tanggal_putusan_sela);
		        }
		        $Template = str_replace("#PENETAPANSELA#",''.$amarPutusansela.'',$Template);
		        $Template = str_replace("#TANGGALSELA#",''.$tgl_putusansela.'',$Template);
		        $Template = str_replace("#HARISELA#",''.$hari_putusansela.'',$Template);
		        $Template = str_replace("#TGL_HIJRIAH#",''.$tgl_putusanselaHijriah.'',$Template);
		    }else {
				$Template = str_replace("#PENETAPANSELA#",''." ........amar putusan sela....... ".'',$Template);
		        $Template = str_replace("#TANGGALSELA#",''." ............... ".'',$Template);
		        $Template = str_replace("#HARISELA#",''." ............... ".'',$Template);
		        $Template = str_replace("#TGL_HIJRIAH#",''." ............... ".'',$Template);
			}
		}

		$temp = explode(' ', ($datapengadilan->row(0)->NamaPN));
		$Template = str_replace("#pa/ms#",''. ucwords(strtolower($temp[0].' '. $temp[1])).'',$Template);
		//END COPY

		if($this->majelis){
			$Template = str_replace('#tunggal/ketua#','Ketua Majelis',$Template);
			$Template = str_replace('#hakim/majelis#','Majelis Hakim',$Template);
		}else{
			$Template = str_replace('#tunggal/ketua#','Hakim',$Template);
			$Template = str_replace('#hakim/majelis#','Majelis',$Template);
		}
		return $Template;
	}

	function looping_majelis_agama($Template, $data){
		foreach ($data as $key => $value) {
			$$key=$value;
		}
		$data = $susunanMajelis;
		$hakim = array();
		$pengacara = array();
		foreach ($data->result() as $row) {
		    if (!$this->in_multiarray($row->nama_hakim, $hakim)){
		        $hakimItem = array();
		        $hakimItem["urutan_hakim"] = $row->urutan_hakim;
		        $hakimItem["jabatan_hakim_id"] = $row->jabatan_hakim_id;
		        $hakimItem["nama"] = $row->nama_hakim;
		        $hakimItem["nrp_hakim"] = '';
		        $hakimItem["pangkat_hakim"] = '';
		        $hakimItem["jabatan_hakim_nama"] = $row->jabatan_hakim_nama;
		        $hakimItem["nama_pp"] = $row->nama_pp;
		        $hakimItem["pangkat_pp"] = '';
		        $hakimItem["nip_pp"] = '';
		        $hakimItem["nama_om"] = '';
		        $hakimItem["nrp_om"] = '';
		        $hakimItem["pangkat_om"] = ''; 
		        $hakimItem["nama_p"] = $row->nama_p;
		        $hakimItem["nrp_p"] = '';
		        $hakimItem["pangkat_p"] = $row->pangkat_p;
		        $hakim[] = $hakimItem;
		        if ($row->jabatan_hakim_id==1){
		            $this->nrp_hakim_ketua=$row->nip_hakim;
		            $this->pangkat_hakim_ketua=$row->pangkat_hakim;
		        }
		    }
		   if (!$this->in_multiarray($row->nama_p, $pengacara)){
		        $pengacaraPitem = array();
		        $pengacaraPitem["nama_ph"] = $row->nama_p;
		        $pengacara[]=$pengacaraPitem;
		    }
		}

		$hakim_anggotas = '';
		$daftar_majelis = '';
		$data_hakim = $hakim;
		$this->majelis = true;
		$i=1;$j=1;
		foreach ($data_hakim as $row) {
		    if($row['jabatan_hakim_id']==1){
		        $this->hakim_ketua = $this->templatehelper->standradnaming($row['nama']);
		        $daftar_majelis .= $i.".\\tab ".$this->templatehelper->standradnaming($row['nama']).' \tab Sebagai Hakim Ketua;\\par ';
		    }elseif($row['jabatan_hakim_id']==2){
		        if ($i === count($data_hakim)){
		            $hakim_anggotas .= $this->templatehelper->standradnaming($row['nama']).'';
		        }else{
		            if ($j==1 && $i>1){
		                $hakim_anggotas .= $this->templatehelper->standradnaming($row['nama']).'\tab '.$this->hakim_ketua.'\\par \\par \\par ';
		            }else{
		                $hakim_anggotas .= $this->templatehelper->standradnaming($row['nama']).'\\par \\par \\par ';
		            }
		        }
		        $daftar_majelis .= $i.".\\tab ".$this->templatehelper->standradnaming($row['nama']).' \tab Sebagai Hakim Anggota; ';
		        if($i!=3)$daftar_majelis .= "\\par ";
		        $j++;
		    }elseif($row['jabatan_hakim_id']==3){
		        $$this->majelis = false;
		        $daftar_majelis .= $i.".\\tab ".$this->templatehelper->standradnaming($row['nama']).' \tab Sebagai Hakim;\\par ';
		        $this->hakim_ketua = $this->templatehelper->standradnaming($row['nama']);
		    }
		    $this->panitera = $this->templatehelper->standradnaming($row['nama_pp']).' \tab Sebagai Panitera;\\par ';
		    $this->panitera_ttd = $this->templatehelper->standradnaming($row['nama_pp']);
		    $i++;
		}
		$daftar_majelis.="dan dibantu ".$this->panitera;
		if($this->majelis){
		    $Template = str_replace('#susunan_majelis#','\ltrpar\qj\fi-284\li284 #susunan_majelis# \ltrpar\qj ',$Template);
		    $Template = str_replace('#susunan_majelis#',$daftar_majelis,$Template);
		}
		return $Template;
	}
}
?>