<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Search_detail extends CI_Controller {
	function index($enc=null){
		if(empty($enc)){
			$enc = '';
		}
		$this->show_form($enc);	
	}

	function show_form($enc){
		$arr=explode(';', $this->encrypt->decode(base64_decode($enc)));
		if (count($arr)>1){
			$alur_id=explode('=', $arr[0]);
			$idalurperkara=$alur_id[1];
			$view_file='search/search_jurnal';
		}else{
			$idalurperkara = $this->encrypt->decode(base64_decode($enc));
			$view_file='search/search';
		}
		$this->load->model('search/search');

		$data['regular'] = $this->session->flashdata('regular');
		$data['klasifikasi_perkara'] = $this->search->getKlasifikasiPerkara($idalurperkara);
		$data['jenis_putusan'] = $this->search->getJenisPutusanPerkara($idalurperkara);
		$data['tahapan_proses'] = $this->search->getTahapanPerkara();
		$data['proses_perkara'] = $this->search->getProsesPerkara($idalurperkara);
		$data['alur_perkara_list'] = $this->search->getAlurPerkara();
		$data['hakim'] = $this->search->getHakim();
		$data['panitera'] = $this->search->getPanitera();
		$data['jurusita'] = $this->search->getJurusita();
		$data['mediator'] = $this->search->getMediator();
		$data['idalurperkara'] = $idalurperkara;
		$data['enc'] = $enc;
		foreach ($data['alur_perkara_list']->result() as $key) {
			if ($key->id==$idalurperkara){
				$data['alur_perkara']=strtoupper($key->nama);
				break; 
			}
		}
		$this->load->vars($data);		
		$this->load->view($view_file);	
	}

	function show_form_jadwal($enc=null){
		if(empty($enc)){
			$enc = '';
		}
		$arr=explode(';', $this->encrypt->decode(base64_decode($enc)));
		$idalurperkara=$arr[0];
		$this->load->model('search/search');
		$data['jenis_putusan'] = $this->search->getJenisPutusanPerkara($idalurperkara);
		$data['alur_perkara'] = $this->search->getAlurPerkara();
		$data['hakim'] = $this->search->getHakim();
		$data['panitera'] = $this->search->getPanitera();
		$data['idalurperkara'] = $idalurperkara;
		$data['ruangan_sidang'] = $this->search->getRuangSidang();
		$data['enc'] = $enc;
		$view_file='search/search_jadwal';
		$this->load->vars($data);
		$this->load->view($view_file);
	}

	function show_form_eksekusi($enc=null){
		if(empty($enc)){
			$enc = '';
		}
		$idalurperkara = $this->encrypt->decode(base64_decode($enc));
		$view_file='search/search_eksekusi';
		$this->load->model('search/search');
		$data['enc'] = $enc;
		$data['ht'] = false;
		$this->load->vars($data);
		$this->load->view($view_file);	
	}

	function show_form_eksekusi_ht($enc=null){
		if(empty($enc)){
			$enc = '';
		}
		$idalurperkara = $this->encrypt->decode(base64_decode($enc));
		$view_file='search/search_eksekusi';
		$this->load->model('search/search');
		$data['enc'] = $enc;
		$data['ht'] = true;
		$this->load->vars($data);
		$this->load->view($view_file);	
	}

	function search_arsip(){
		$this->load->view('search/search_arsip');
	}
}

?>
