<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Saldo extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('is_logged_in')==null){
			redirect('login');
		}
		$this->load->model('saldo/db_saldo');
	}

	function index(){
		if($this->session->userdata('idgroup')>2){
			redirect('login');
		}

		if($this->nativesession->is_flash_session('security')===FALSE){
			redirect('main');
		}
		$sec = $this->nativesession->get_flash_session('security');
		$this->showPage();
	}

	function showPage(){
		$data=array('page_title' =>'Konfigurasi Saldo Awal',
					'main_body'=> 'saldo/saldo_awal',
					'enc' => "",
					'page_url' => 'saldo_update',
					'alur_perkara_list' =>$this->db_saldo->get_lits_alur_perkara(),
					'tahun_saldo'=>$this->db_saldo->get_year());
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_edit');
	}

	function info(){ 
		$this->load->model('saldo/db_saldo');
		$saldo_id = $this->input->post('saldo_id',TRUE);
		if(!empty($saldo_id) and $saldo_id>0){
			$query = $this->db_saldo->get_lits_alur_perkara($saldo_id);
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					$tgl ='';
					if(!empty($row->tanggal_saldo_awal)){
						$date_fmt = new DateTime(str_replace("-","",$row->tanggal_saldo_awal));
						$tgl = $date_fmt->format('d/m/Y');
					}
					echo json_encode(array(
						'st'=>1,
						'tahun_saldo'=>$row->tahun_saldo,
						'saldo_awal_tunai'=>number_format($row->saldo_awal_tunai, 0, ',', '.'),
						'saldo_awal_bank'=>number_format($row->saldo_awal_bank, 0, ',', '.'),
						'total_saldo'=>number_format($row->jumlah_saldo_awal, 0, ',', '.'),
						'ket'=>$row->keterangan
						)
					);
				}
			}else{
				echo json_encode(array('st'=>0,'msg'=>$saldo_id));
			}
		}elseif($saldo_id==0){
			echo json_encode(array(
				'st'=>1,
				'saldo_awal_tunai'=>0,
				'saldo_awal_bank'=>0,
				'total_saldo'=>0
				)
			);
		}
	}

	function validate_input(){
		$this->form_validation->set_rules('tahun', 'Tahun Saldo Awal', 'trim|required|xss_clean');
		$this->form_validation->set_rules('saldo_awal_bank', 'Jumlah Saldo Awal Bank', 'trim|required|xss_clean');
		$this->form_validation->set_rules('saldo_awal_tunai', 'Jumlah Saldo Awal Tunai', 'trim|required|xss_clean');
		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil'.validation_errors()));
		}else{
			$saldo_awal_bank = str_replace('.', '', $this->input->post('saldo_awal_bank',TRUE));
			$saldo_awal_tunai = str_replace('.', '', $this->input->post('saldo_awal_tunai',TRUE));
			$jumlah_saldo_awal = $saldo_awal_tunai+$saldo_awal_bank;
			$action=$this->input->post('action');
			$data = array(
					'tahun_saldo'=>$this->input->post('tahun'),
					'saldo_awal_tunai'=>$saldo_awal_tunai,
					'saldo_awal_bank'=>$saldo_awal_bank,
					'jumlah_saldo_awal'=>$jumlah_saldo_awal,
					'keterangan'=>$this->input->post('keterangan')
			);
			if($action==0){
				$data['diinput_oleh']=$this->session->userdata('username');
				$data['diinput_tanggal']= date("Y-m-d h:i:s",time());
			}elseif($action>0){
				$data['diperbaharui_oleh']=$this->session->userdata('username');
				$data['diperbaharui_tanggal']= date("Y-m-d h:i:s",time());
			}

			if($this->db_saldo->update_data($data,$action)===TRUE){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Saat Simpan Kedatabase'));
				return;
			}

			
		}
	}

	function parseDate($tgl){
		$tmp = explode('/', $tgl);
		return $tmp[2].'-'.$tmp[1].'-'.$tmp[0];
	}
}