<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Perkara_list_delegasi extends CI_Controller {
	function index(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		

		$functions = $this->nativesession->get_flash_session('function');	
		$enc = $this->nativesession->get_flash_session('enc');
		$idalur=$this->nativesession->get_flash_session('idalur');
		if($functions == 'sort'){
			$col = $this->nativesession->get_flash_session('col');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->sort($col,$idalur,$keyword);
		}elseif($functions == 'type'){
			$this->session->set_userdata('asc_desc','DESC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc);
		}elseif($functions == 'page'){
			$page = $this->nativesession->get_flash_session('page');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$where=$this->nativesession->get_flash_session('where');
			$this->nativesession->set_flash_session('where', $where);
			$column_sorted = $this->nativesession->get_flash_session('col');
			$this->showData($idalur,$column_sorted,$page,$keyword,$where);
		}elseif($functions == 'search'){
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->session->set_userdata('keyword',$keyword);
			$page = $this->nativesession->get_flash_session('page');
			$column_sorted = $this->nativesession->get_flash_session('col');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($idalur,$column_sorted,$page,$keyword);
		}else{
			$this->session->set_userdata('asc_desc','DESC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData();
		}
	}



	function sort($col=null,$idalur=NULL,$keyword=null){

		if($this->session->userdata('asc_desc')){
			if($this->session->userdata('asc_desc')=="DESC"){
				$this->session->set_userdata('asc_desc','ASC');
			}else{
				$this->session->set_userdata('asc_desc','DESC');
			}
		}else{
			$this->session->set_userdata('asc_desc','ASC');
		}
	}


	function showData($enc='',$col=3,$start_page=0,$keyword='',$where=''){
		$data['ses']=$this->session->userdata('is_logged_in');
		$idalur=$this->encrypt->decode(base64_decode($enc));

		$asc_desc = $this->session->userdata('asc_desc');
		$this->load->model('perkara/delegasi');
		if($start_page>0){
			$begin_limit = ($start_page-1)*50;
		}else{
			$begin_limit = 0;
			$start_page = 1;
		}
		if ($where==''){
			$query = $this->delegasi->getPerkaraListDelegasi($idalur,$col,$asc_desc,$begin_limit,$keyword);	
		}else{
			$query = $this->eksekusi->getPerkaraListDelegasi($idalur,$col,$asc_desc,$begin_limit,$where);
		}

		if($start_page>0){
			$begin_limit = ($start_page-1)*50;
		}else{
			$begin_limit = 0;
			$start_page = 1;
		}
		
		$data['list_perkara'] = $query;

		if($this->session->userdata('total_rows')){
			if($this->session->userdata('total_rows')==-1){
				$data['total_rows'] = $this->delegasi->fecth_data_num($keyword);
				$this->session->set_userdata('total_rows',$data['total_rows']);
			}else{
				$data['total_rows'] = $this->session->userdata('total_rows');
			}
		}else{
			$data['total_rows'] = $this->delegasi->fecth_data_num($keyword);
			$this->session->set_userdata('total_rows',$data['total_rows']);
		}
		
		
		if ($idalur==1) {
			$data['page_title'] = 'DAFTAR DELEGASI MASUK';
			$data['idalur'] = base64_encode($this->encrypt->encode('1'));
			$data['satker_nama'] = "Asal";
		}else if ($idalur==2) {
			$data['page_title'] = 'DAFTAR DELEGASI KELUAR';
			$data['idalur'] = base64_encode($this->encrypt->encode('2'));
			$data['satker_nama'] = "Tujuan";
		}else if ($idalur=='k_sdh_k') {
			$data['page_title'] = 'DAFTAR DELEGASI KELUAR YANG SUDAH DIKIRIM';
			$data['idalur'] = base64_encode($this->encrypt->encode('2'));
			$data['satker_nama'] = "Tujuan";
		}else if ($idalur=='k_blm_k') {
			$data['page_title'] = 'DAFTAR DELEGASI KELUAR YANG BELUM DIKIRIM';
			$data['idalur'] = base64_encode($this->encrypt->encode('2'));
			$data['satker_nama'] = "Tujuan";
		}else if ($idalur=='k_sdh_l') {
			$data['page_title'] = 'DAFTAR DELEGASI KELUAR YANG SUDAH DILAKSANAKAN';
			$data['idalur'] = base64_encode($this->encrypt->encode('2'));
			$data['satker_nama'] = "Tujuan";
		}else if ($idalur=='k_blm_l') {
			$data['page_title'] = 'DAFTAR DELEGASI KELUAR YANG BELUM DILAKSANAKAN';
			$data['idalur'] = base64_encode($this->encrypt->encode('2'));
			$data['satker_nama'] = "Tujuan";
		}else if ($idalur=='m_blm_l') {
			$data['page_title'] = 'DAFTAR DELEGASI MASUK YANG BELUM DILAKSANAKAN';
			$data['idalur'] = base64_encode($this->encrypt->encode('1'));
			$data['satker_nama'] = "Asal";
		}else if ($idalur=='m_sdh_l') {
			$data['page_title'] = 'DAFTAR DELEGASI MASUK YANG SUDAH DILAKSANAKAN';
			$data['idalur'] = base64_encode($this->encrypt->encode('1'));
			$data['satker_nama'] = "Asal";
		}else{
			$data['page_title'] = 'DAFTAR DELEGASI MASUK';
			$data['idalur'] = base64_encode($this->encrypt->encode('1'));
			$data['satker_nama'] = "Asal";
		}
		$this->nativesession->set_flash_session('idalur',$data['idalur']);

		$data['page_active'] = $begin_limit;
		$data['page_number'] = $start_page;
		$data['page_url'] = 'perkara_list_delegasi';
		if(!empty($keyword))
			$data['keyword'] = base64_encode($this->encrypt->encode($keyword));
		else
			$data['keyword'] = $keyword;

		$data['column_sorted'] = $col;
		$data['iddelegasi'] = '';
		$data['previous']=$this->nativesession->set_flash_session('previous',current_url());
		$history = $this->nativesession->get_flash_session('url_requested');
		$data['main_history'] = $history;
		$data['main_body'] = 'perkara_list/perkara_list_delegasi';
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body');
	}
}
