<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Perkara_list extends CI_Controller {
	function index(){
		
		$functions = $this->nativesession->get_flash_session('function');
		$enc = $this->nativesession->get_flash_session('enc');
		if($this->session->userdata('is_logged_in') AND empty($enc)){
			redirect('dashboard');
		}
		if ($this->session->userdata('is_logged_in')==false){
				redirect('login');
		}
		$idalurperkara = $this->encrypt->decode(base64_decode($enc));
		if($functions == 'sort'){
			$col = $this->nativesession->get_flash_session('col');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->sort($col,$enc,$keyword);
		}elseif($functions == 'type'){
			$this->session->set_userdata('asc_desc','DESC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$idalurperkara);
		}elseif($functions == 'page'){
			$page = $this->nativesession->get_flash_session('page');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$where=$this->nativesession->get_flash_session('where');
			$this->nativesession->set_flash_session('where', $where);
			$column_sorted = $this->nativesession->get_flash_session('col');
			$this->showData($enc,$idalurperkara,$column_sorted,$page,$keyword,$where);
		}elseif($functions == 'search'){
			$keyword ='';
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->session->set_userdata('keyword',$keyword);

			$page = $this->nativesession->get_flash_session('page');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$idalurperkara,2,$page,$keyword);

		}elseif($functions == 'search_detail'){
			$keyword ='search_detail';
			$page = $this->nativesession->get_flash_session('page');
			$this->session->set_userdata('total_rows',-1);
			$where=$this->nativesession->get_flash_session('where');
			$this->nativesession->set_flash_session('where', $where);
			$this->showData($enc,$idalurperkara,2,$page, $keyword, $where);
		}else{
			$this->session->set_userdata('asc_desc','DESC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData();
		}
	}

	function sort($col=null,$enc=null,$keyword=null){
		if($this->session->userdata('asc_desc')){
			if($this->session->userdata('asc_desc')=="DESC"){
				$this->session->set_userdata('asc_desc','ASC');
			}else{
				$this->session->set_userdata('asc_desc','DESC');
			}
		}else{
			$this->session->set_userdata('asc_desc','ASC');
		}
		$idalurperkara = $this->encrypt->decode(base64_decode($enc));
		$this->showData($enc,$idalurperkara,$col,0,$keyword);
	}

	function showData($enc='',$idalurperkara='',$col=2,$start_page=0,$keyword='',$where=''){
		//$keyword = $this->encrypt->decode(base64_decode($keyword));
		$asc_desc = $this->session->userdata('asc_desc');
		$this->load->model('perkara/perkara');
		if($start_page>0){
			$begin_limit = ($start_page-1)*50;
		}else{
			$begin_limit = 0;
			$start_page = 1;
		}
		if ($where==''){
			$query = $this->perkara->getPerkaraList($idalurperkara,$col,$asc_desc,$begin_limit,$keyword);	
		}else{
			$query = $this->perkara->getPerkaraList_search_detail($idalurperkara,$col,$asc_desc,$begin_limit,$where);
		}
		$data['list_perkara'] = $query;
		if($this->session->userdata('total_rows')){
			if($this->session->userdata('total_rows')==-1){
				$data['total_rows'] = $this->perkara->fecth_data_num($idalurperkara,$keyword);
				$this->session->set_userdata('total_rows',$data['total_rows']);
			}else{
				$data['total_rows'] = $this->session->userdata('total_rows');
			}
		}else{
			$data['total_rows'] = $this->perkara->fecth_data_num($idalurperkara,$keyword);
			$this->session->set_userdata('total_rows',$data['total_rows']);
		}
		
		$data['page_active'] = $begin_limit;
		if($idalurperkara=='114'){
			$data['page_title'] = 'DAFTAR '.strtoupper($this->perkara->getJenisPerkara($idalurperkara));
		} else {
			$data['page_title'] = 'DAFTAR PERKARA '.strtoupper($this->perkara->getJenisPerkara($idalurperkara));
		}

		$data['main_body'] = 'perkara_list/perkara_list';
		$data['enc'] = $enc;
		$data['idalurperkara'] = $idalurperkara;
		
		$data['page_number'] = $start_page;
		$data['page_url'] = 'perkara_list';
		if(!empty($keyword))
			$data['keyword'] = base64_encode($this->encrypt->encode($keyword));
		else
			$data['keyword'] = $keyword;
		$data['column_sorted'] = $col;
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body');
	}
	
	function f_guest(){
		$this->load->view('header');
		$this->load->view('guest_v');
		$this->load->view('footer');
	}
}