<?php
class Perkara_lalulintas extends CI_Controller {
	
	function add_perkara(){
		if($this->nativesession->is_flash_session('security')===FALSE){
			redirect('main');
		}
		$sec = $this->nativesession->get_flash_session('security');

		if($this->session->userdata('is_logged_in')===FALSE){
			redirect('login');
		}


		$this->load->model('perkara/lalulintas','perkara');
		$data['page_title'] = 'TAMBAH - DATA PERKARA LALU LINTAS';
		$data['hakim_list'] = $this->perkara->getListHakimPN();
		$data['panitera_list'] = $this->perkara->getListPaniteraPN();
		$data['ruangan_sidang'] = $this->perkara->getListRuangSidang();
		$data['main_body'] = 'perkara/new_lalulintas';
		$data['previous'] = $this->nativesession->get_flash_session('url_requested');
		$data['curr_date'] = date('d/m/Y');
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');

	}

	

	function validasi_import_lalulintas(){
		
		$this->load->library(array('PHPExcel','PHPExcel/IOFactory'));
		$this->load->model('perkara/lalulintas','perkara');
		$this->load->model('perkara/new_perdata','perdata');

		$this->form_validation->set_rules('previous', 'ID Previous', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tanggal_pelimpahan', 'Tanggal Pelimpahan', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tanggal_penetapan_sidang', 'Tanggal Penetapan Sidang', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tanggal_sidang', 'Tanggal Sidang', 'trim|required|xss_clean');
		$this->form_validation->set_rules('ruang_sidang', 'Ruang Sidang', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tanggal_penetapan_hakim', 'Tanggal Penetapan Hakim', 'trim|required|xss_clean');
		$this->form_validation->set_rules('hakim', 'Hakim', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tanggal_penetapan_panitera', 'Tanggal Penetapan Panitera', 'trim|required|xss_clean');
		$this->form_validation->set_rules('panitera', 'Panitera', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tilang_oleh', 'Tilang Oleh', 'trim|required|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Kesalahan : Tidak Berhasil | '.validation_errors().'<br/>'));
			return;
		} else {
			
			$fileName = $_FILES['import']['name'];
				
			$config['upload_path'] = 'resources/tmp/';
			$config['file_name'] = $fileName;
			$config['allowed_types'] = 'xls|xlsx';
			$config['max_size']	= 16777216;

			$this->load->library('upload');
			$this->upload->initialize($config);

			if(! $this->upload->do_upload('import') )
			$this->upload->display_errors();
			$media = $this->upload->data('import');
			$inputFileName = 'resources/tmp/'.$media['file_name'];
			
			try {
				$inputFileType = IOFactory::identify($inputFileName);
				$objReader = IOFactory::createReader($inputFileType);
				$objPHPExcel = $objReader->load($inputFileName);
			} catch(Exception $e) {
				die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
			}

			
			/*
			$data1 = $objPHPExcel->getActiveSheet(1)->getCell('H1')->getValue();
			$data2 = $objPHPExcel->getActiveSheet(1)->getCell('I1')->getValue();
			$data3 = $objPHPExcel->getActiveSheet(1)->getCell('J1')->getValue();
			$data4 = $objPHPExcel->getActiveSheet(1)->getCell('K1')->getValue();
			$data5 = $objPHPExcel->getActiveSheet(1)->getCell('L1')->getValue();
			$data6 = $objPHPExcel->getActiveSheet(1)->getCell('M1')->getValue();
			
			if($data1!=='DODON'){
				echo json_encode(array('st'=>0,'msg'=>'Kesalahan : Silahkan Menggunakan Form isian dari aplikasi SIPP'));
				return;
			} else if ($data2!=='CATUR'){
				echo json_encode(array('st'=>0,'msg'=>'Kesalahan : Silahkan Menggunakan Form isian dari aplikasi SIPP'));
				return;
			} else if ($data3!=='PUJI'){
				echo json_encode(array('st'=>0,'msg'=>'Kesalahan : Silahkan Menggunakan Form isian dari aplikasi SIPP'));
				return;
			} else if ($data4!=='DIDIK'){
				echo json_encode(array('st'=>0,'msg'=>'Kesalahan : Silahkan Menggunakan Form isian dari aplikasi SIPP'));
				return;
			} else if ($data5!=='ROBY'){
				echo json_encode(array('st'=>0,'msg'=>'Kesalahan : Silahkan Menggunakan Form isian dari aplikasi SIPP'));
				return;
			} else if ($data6!=='ADIT'){
				echo json_encode(array('st'=>0,'msg'=>'Kesalahan : Silahkan Menggunakan Form isian dari aplikasi SIPP'));
				return;
			} 	
			*/		
			

			$data_perkara=array();
			$data_proses_pendaftaran=array();
			$data_lalulintas=array();
			$data_pihak=array();
			$data_pihak2=array();
			$data_penetapan=array();
			$data_sidang=array();
			$data_putusan=array();
			$data_pemberitahuan_putusan=array();
			$data_putusan_terdakwa=array();
			$data_proses_pendaftaran=array();
			$data_proses_hakim=array();
			$data_proses_panitera=array();
			$data_proses_sidang=array();
			$data_proses_putusan=array();
			$data_proses_minutasi=array();
			$data_hakim=array();
			$data_panitera=array();

			$sheet = $objPHPExcel->getSheet(0);
			$highestRow = $sheet->getHighestRow();
			$highestColumn = $sheet->getHighestColumn();


			$perkara_id = intval($this->db->query("SELECT IFNULL(max(perkara_id)+1,1) as perkara_id FROM perkara;")->row()->perkara_id);
			$pihak_id = intval($this->db->query("SELECT IFNULL(max(id)+1,1) as pihak_id FROM pihak;")->row()->pihak_id);
			$pihak2_id = intval($this->db->query("SELECT IFNULL(max(id)+1,1) as pihak2_id FROM perkara_pihak2;")->row()->pihak2_id);
			$sidang_id = intval($this->db->query("SELECT IFNULL(max(id)+1,1) as sidang_id FROM perkara_jadwal_sidang;")->row()->sidang_id);

			for ($row = 2; $row <= $highestRow; $row++){  				 				
	            	$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row,
													NULL,
													TRUE,
													FALSE);

	            $nomor_urut = intval($rowData[0][0]);
	            $nomor_seri = intval($rowData[0][1]);
	            $nomor_perkara = intval($rowData[0][2]);
	            $nama_pelanggar = trim($rowData[0][3]);
	            $alamat = trim($rowData[0][4]);
	            $pasal = trim($rowData[0][5]);
	            $nomor_polisi = trim($rowData[0][6]);
	            $bb = $rowData[0][7];
	            $jenis_kendaraan = $rowData[0][8];
	            $verstek = trim($rowData[0][9]);
	            $denda = intval($rowData[0][10]);
	            $subsider = intval($rowData[0][11]);
	            $biaya_perkara = $rowData[0][12];

	            if($bb!==''){
	            	$bukti = explode("|",$bb);
	            	$id_bb = intval($bukti[0]);
	            	$nama_bb = $bukti[1];
	            } else {
	            	echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Barang Bukti Kosong'.validation_errors()));
					return;
	            }

	            if($jenis_kendaraan!==''){
	            	$kendaraan = explode("|",$jenis_kendaraan);
	            	$id_kendaraan = intval($kendaraan[0]);
	            	$nama_kendaraan = $kendaraan[1];
	            } else {
	            	echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Nama Kendaraan Kosong'.validation_errors()));
					return;
	            }
	            
	            #Nomor Urut
	            if($nomor_urut==''){
	            	echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Nomor Urut Kosong'.validation_errors()));
					return;
	            }
	            
	            #Nomor Seri Tilang
	            if($nomor_seri==''){
	            	echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Nomor Seri Tilang Kosong'.validation_errors()));
					return;
	            }
	            #Nomor Perkara
	            if($nomor_perkara==''){
	            	echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Nomor Perkara Kosong'.validation_errors()));
					return;
	            }
	            #Nama Pelangar
	            if($nama_pelanggar==''){
	            	echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Nama Pelanggar Kosong'.validation_errors()));
					return;
	            }
	            #Alamat
	            if($alamat==''){
	            	echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Alamat Kosong'.validation_errors()));
					return;
	            }
	            #Pasal Dakwaan
	            if($pasal==''){
	            	echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Pasal Kosong'.validation_errors()));
					return;
	            }
	           
	            #Status Verstek
	            if($verstek==''){
	            	echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Status Verstek Kosong'.validation_errors()));
					return;
	            }
	            #Jumlah Denda
	            if($denda==''){
	            	echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Jumlah Denda Kosong'.validation_errors()));
					return;
	            }
	            #Subsider
	            if($subsider==''){
	            	echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Status Subsider Kosong'.validation_errors()));
					return;
	            }
	            #Biaya Perkara
	            if($biaya_perkara==''){
	            	echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Biaya Perkara Kosong'.validation_errors()));
					return;
	            }

	            #Cek Id Dan Nama Barang Bukti dengan DB
	            $cekBarangBukti = $this->perkara->getDataBuktiTilang($id_bb,$nama_bb);
	            if($cekBarangBukti->num_rows()==0){
	            	echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Data Barang Bukti Tidak Sesuai'.validation_errors()));
					return;
	            }

	            #Cek Id dan Jenis Kendaraan dengan DB
	            $cekJenisKendaraan = $this->perkara->getDataKendaraan($id_kendaraan,$nama_kendaraan);
	            if($cekJenisKendaraan->num_rows()==0){
	            	echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Data Kendaraan Tidak Sesuai'.validation_errors()));
					return;
	            }



	            $tanggal_pelimpahan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_pelimpahan',TRUE));
	            $tahun_pelimpahan = date('Y', strtotime($tanggal_pelimpahan));
	            $tanggal_bulan_pelimpahan = date('Y-m', strtotime($tanggal_pelimpahan));
	            $tanggal_penetapan_hakim =  $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_penetapan_hakim'));
	            $ruang_sidang = explode("|",$this->input->post('ruang_sidang'));
	            $id_ruang_sidang = intval($ruang_sidang[0]);
	            $nama_ruang_sidang = $ruang_sidang[1];
	            $hakim = explode("|",$this->input->post('hakim'));
	            $id_hakim = intval($hakim[0]);
	            $nama_hakim = trim($hakim[1]);
	            $tanggal_penetapan_panitera = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_penetapan_panitera'));
	            $panitera = explode("|", $this->input->post('panitera'));
	            $id_panitera = intval($panitera[0]);
	            $nama_panitera = $panitera[1];	
	            $tanggal_penetapan_sidang =  $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_penetapan_sidang'));
	            $tanggal_sidang =  $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_sidang'));
	            $tilang_oleh = $this->input->post('tilang_oleh');
	            $kodePN = $this->perdata->getKodePN();

	            	

	            $nomor_perkara_fix = $nomor_perkara."/Pid.LL/".$tahun_pelimpahan."/PN ".$kodePN;

	            $isPerkaraExists = $this->perdata->isNomorPerkaraExist($nomor_perkara_fix);
	            if($isPerkaraExists===TRUE){
					echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Nomor Perkara Sudah Ada Didalam System'));
					return;
				}

				$nomor_urut_register = $this->perdata->getNomorUrutRegister('114',$tanggal_bulan_pelimpahan);
				$nomor_urut_perkara = $this->perdata->getNomorUrutPerkara('114',$tahun_pelimpahan);
				$para_pihak = "Pelanggar:<br/>".$this->templatehelper->standradnaming($nama_pelanggar);
				$nip_hakim = intval($this->db->query("SELECT nip AS nip_hakim FROM hakim_pn WHERE id=$id_hakim")->row()->nip_hakim);
				$kode_hakim = $this->db->query("SELECT kode AS kode_hakim FROM hakim_pn WHERE id=$id_hakim")->row()->kode_hakim;
				$nip_panitera = intval($this->db->query("SELECT nip AS nip_panitera FROM panitera_pn WHERE id=$id_panitera")->row()->nip_panitera);
				$kode_panitera = $this->db->query("SELECT kode AS kode_panitera FROM panitera_pn WHERE id=$id_panitera")->row()->kode_panitera;

				#PN.BDG_2011_PID.B_0001
				$tmp = explode("/",$nomor_perkara_fix);
				$nomor_urut_perkara = $tmp[0];
				$tmpIndexs = $tmp[0];
				if($tmpIndexs<10){
					$tmpIndexs = '000'.$tmpIndexs;
				}elseif($tmpIndexs>9 and $tmpIndexs <1000){
					$tmpIndexs = '00'.$tmpIndexs;
				}
				$nomorIndexs = $tmp[3].'_'.$tmp[2].'_'.$tmp[1].'_'.$tmpIndexs;

				#Tabel Perkara
				$data_perkara[] = array(
   					'perkara_id' => $perkara_id,
   					'alur_perkara_id' => '114',
   					'tanggal_pendaftaran' => $tanggal_pelimpahan,
   					'jenis_perkara_id' => '161',
   					'jenis_perkara_kode' => 'LL',
   					'jenis_perkara_nama' => 'Perkara Lalu-Lintas',
   					'jenis_perkara_text' => 'Perkara Lalu-Lintas',
   					'nomor_urut_register' => $nomor_urut_register,
   					'nomor_urut_perkara' => $nomor_urut_perkara,
   					'nomor_perkara' => $nomor_perkara_fix,
   					'nomor_indeks' => $nomorIndexs,
   					'pihak2_text' => $this->templatehelper->standradnaming($nama_pelanggar),
   					'para_pihak' => $para_pihak,
   					'pihak_dipublikasikan' => 'Y',
   					'dakwaan' => $pasal,
   					'tahapan_terakhir_id' => '15',
   					'tahapan_terakhir_text' => 'Putusan',
   					'proses_terakhir_id' => '220',
   					'proses_terakhir_text' => 'Minutasi',
   					'diinput_oleh' => $this->session->userdata('username'),
					'diinput_tanggal' => date("Y-m-d h:i:s",time()) 
				);

				#Tabel Perkara LaluLintas
				$data_lalulintas[] = array(
 					'perkara_id'=> $perkara_id,
 					'ditilang_oleh'=> $tilang_oleh,
 					'nomor_tilang'=> $nomor_seri,
 					'jenis_kendaraan_id'=> $id_kendaraan,
 					'nomor_polisi'=> $nomor_polisi,
 					'bukti_tilang_id'=> $id_bb,
 					'diinput_oleh'=> $this->session->userdata('username'),
 					'diinput_tanggal'=> date("Y-m-d h:i:s",time())
				);

				#Tabel Pihak
				$data_pihak[]=array(
					'id'=> $pihak_id,
					'jenis_pihak_id'=> '1',
					'nama'=> $this->templatehelper->standradnaming($nama_pelanggar),
					'alamat'=> $this->templatehelper->standradnaming($alamat),
					'diinput_oleh'=> $this->session->userdata('username'),
					'diinput_tanggal'=> date("Y-m-d h:i:s",time())
				);

				#Tabel Perkara Pihak2
				$data_pihak2[]=array(
					'id'=> $pihak2_id,
					'perkara_id'=> $perkara_id,
					'urutan'=> '1',
					'pihak_id'=> $pihak_id,
					'jenis_pihak_id'=> '1',
					'nama'=> $this->templatehelper->standradnaming($nama_pelanggar),
					'alamat'=> $this->templatehelper->standradnaming($alamat),
					'diinput_oleh'=> $this->session->userdata('username'),
					'diinput_tanggal'=> date("Y-m-d h:i:s",time())
				);


				#Tabel Hakim
				$data_hakim[]=array(
					'perkara_id' => $perkara_id,
					'tanggal_penetapan' => $tanggal_penetapan_hakim,
					'urutan' => '1',
					'jabatan_hakim_id' => '3',
					'jabatan_hakim_nama' => 'Hakim Tunggal',
					'hakim_id' => $id_hakim,
					'hakim_kode' => $kode_hakim,
					'hakim_nip' => $nip_hakim,
					'hakim_nama' => $this->templatehelper->standradnaming($nama_hakim),
					'diinput_oleh' => $this->session->userdata('username'),
					'diinput_tanggal' => date("Y-m-d h:i:s",time())
				);

				#Tabel Panitera
				$data_panitera[]=array(
					'perkara_id' => $perkara_id,
					'tanggal_penetapan' => $tanggal_penetapan_panitera,
					'panitera_id' => $id_panitera,
					'panitera_kode' => $kode_panitera,
					'panitera_nip' => $nip_panitera,
					'panitera_nama' => $this->templatehelper->standradnaming($nama_panitera),
					'diinput_oleh' => $this->session->userdata('username'),
					'diinput_tanggal' => date("Y-m-d h:i:s",time())
				);
					
				#Tabel Penetapan
				$data_penetapan[]=array(
					'perkara_id' => $perkara_id,
					'penetapan_majelis_hakim' => $tanggal_penetapan_hakim,
					'majelis_hakim_id' => $id_hakim,
					'majelis_hakim_kode' => '',
					'majelis_hakim_nama' => $this->templatehelper->standradnaming($nama_hakim),
					'majelis_hakim_text' => "Hakim Tunggal:".$this->templatehelper->standradnaming($nama_hakim)."",
					'penetapan_panitera_pengganti' => $tanggal_penetapan_panitera,
					'panitera_pengganti_id' => $id_panitera,
					'panitera_pengganti_text' => $this->templatehelper->standradnaming($nama_panitera),
					'penetapan_hari_sidang' => $tanggal_penetapan_sidang,
					'sidang_pertama' => $tanggal_sidang,
					'diinput_oleh' => $this->session->userdata('username'),
					'diinput_tanggal' => date("Y-m-d h:i:s",time())
				);

				#Tabel Sidang Pertama/Persidangan
				$data_sidang[]=array(
					'id' => $sidang_id,
					'perkara_id' => $perkara_id,
					'tanggal_sidang' => $tanggal_sidang,
					'jam_sidang' => '09:00:00',
					'agenda' => 'Sidang Pertama / Putusan',
					'ruangan_id' => $id_ruang_sidang,
					'ruangan' => $nama_ruang_sidang,
					'diinput_oleh' => $this->session->userdata('username'),
					'diinput_tanggal' => date("Y-m-d h:i:s",time())
				);


				#Tabel Putusan
				$data_putusan[]=array(
					'perkara_id' => $perkara_id,
					'tanggal_putusan' => $tanggal_sidang,
					'putusan_verstek' => $verstek,
					'status_putusan_nama' => 'Pidana Denda,Subsider Kurungan',
					'status_putusan_text' => '16,24',
					'amar_putusan' => "Pidana Denda Rp ".number_format($denda).", Subsider Kurungan ".$subsider." Hari",
					'tanggal_minutasi' => $tanggal_sidang,
					'pemberitahuan_putusan' => $tanggal_sidang,
					'pemberitahuan_putusan_pihak2' => $tanggal_sidang,
					'diinput_oleh' => $this->session->userdata('username'),
					'diinput_tanggal' => date("Y-m-d h:i:s",time())
				);

				#Tabel Pemberitahuan Putusan
				$data_pemberitahuan_putusan[]=array(
					'perkara_id' => $perkara_id,
					'putusan_akhir' => '2',
					'pihak' => '2',
					'pihak_id' => $pihak_id,
					'tanggal_pemberitahuan_putusan' => $tanggal_sidang,
					'tanggal_menerima_putusan' => $tanggal_sidang
				);

				#Tabel Putusan Terdakwa
				$data_putusan_terdakwa[]=array(
					'pihak2_id' => $pihak2_id,
					'perkara_id' => $perkara_id,
					'pihak_id' => $pihak_id,
					'status_putusan_id' => '16,24',
					'tanggal_putusan' => $tanggal_sidang,
					'status_putusan_text' => "Pidana Denda (Rp ".number_format($denda)."), Subsider Kurungan ( ".$subsider." Hari )",
					'durasi_nominal' => $denda,
					'satuan' => '2',
					'diinput_oleh' => $this->session->userdata('username'),
					'diinput_tanggal' => date("Y-m-d h:i:s",time())
				);


				#Tabel Pendaftaran
				$data_proses_pendaftaran[]=array(
					'perkara_id'=> $perkara_id,
					'tahapan_id'=> '10',
					'tahapan_nama'=> 'Pendaftaran',
					'proses_id'=> '10',
					'proses_nama'=> 'Pendaftaran Perkara',
					'tanggal'=> $tanggal_pelimpahan,
					'urutan'=> '1',
					'diinput_oleh'=> $this->session->userdata('username'),
					'diinput_tanggal'=> date("Y-m-d h:i:s",time())
				);


				#Proses Penetapan Hakim
				$data_proses_hakim[]=array(
					'perkara_id'=> $perkara_id,
					'tahapan_id'=> '12',
					'tahapan_nama'=> 'Penetapan',
					'proses_id'=> '20',
					'proses_nama'=> 'Penetapan Majelis Hakim/Hakim',
					'tanggal'=> $tanggal_penetapan_hakim,
					'urutan'=> '2',
					'diinput_oleh'=> $this->session->userdata('username'),
					'diinput_tanggal'=> date("Y-m-d h:i:s",time())
				);

				#Proses Penetapan Panitera
				$data_proses_panitera[]=array(
					'perkara_id'=> $perkara_id,
					'tahapan_id'=> '12',
					'tahapan_nama'=> 'Penetapan',
					'proses_id'=> '30',
					'proses_nama'=> 'Penunjukan Panitera Pengganti',
					'tanggal'=> $tanggal_penetapan_panitera,
					'urutan'=> '3',
					'diinput_oleh'=> $this->session->userdata('username'),
					'diinput_tanggal'=> date("Y-m-d h:i:s",time())
				);

				#Proses Penetapan Hari Sidang
				$data_proses_sidang[]=array(
					'perkara_id'=> $perkara_id,
					'tahapan_id'=> '12',
					'tahapan_nama'=> 'Penetapan',
					'proses_id'=> '80',
					'proses_nama'=> 'Penetapan Hari Sidang Pertama',
					'tanggal'=> $tanggal_penetapan_sidang,
					'urutan'=> '4',
					'diinput_oleh'=> $this->session->userdata('username'),
					'diinput_tanggal'=> date("Y-m-d h:i:s",time())
				);

				#Proses Putusan
				$data_proses_putusan[]=array(
					'perkara_id'=> $perkara_id,
					'tahapan_id'=> '15',
					'tahapan_nama'=> 'Putusan',
					'proses_id'=> '210',
					'proses_nama'=> 'Putusan',
					'tanggal'=> $tanggal_sidang,
					'urutan'=> '5',
					'diinput_oleh'=> $this->session->userdata('username'),
					'diinput_tanggal'=> date("Y-m-d h:i:s",time())
				);

				#Proses Minutasi
				$data_proses_minutasi[]=array(
					'perkara_id'=> $perkara_id,
					'tahapan_id'=> '15',
					'tahapan_nama'=> 'Putusan',
					'proses_id'=> '220',
					'proses_nama'=> 'Minutasi',
					'tanggal'=> $tanggal_sidang,
					'urutan'=> '6',
					'diinput_oleh'=> $this->session->userdata('username'),
					'diinput_tanggal'=> date("Y-m-d h:i:s",time())
				);

				$perkara_id++;
				$pihak_id++;
				$pihak2_id++;
				$sidang_id++;
			}

				$this->db->insert_batch('perkara',$data_perkara); 
				$this->db->insert_batch('perkara_proses',$data_proses_pendaftaran);
				$this->db->insert_batch('perkara_lalulintas',$data_lalulintas); 
				$this->db->insert_batch('pihak',$data_pihak); 
				$this->db->insert_batch('perkara_pihak2',$data_pihak2); 
				$this->db->insert_batch('perkara_hakim_pn',$data_hakim);
				$this->db->insert_batch('perkara_panitera_pn',$data_panitera);
				$this->db->insert_batch('perkara_penetapan',$data_penetapan);
				$this->db->insert_batch('perkara_proses',$data_proses_hakim);
				$this->db->insert_batch('perkara_proses',$data_proses_panitera);
				$this->db->insert_batch('perkara_proses',$data_proses_sidang); 
				$this->db->insert_batch('perkara_jadwal_sidang',$data_sidang); 
				$this->db->insert_batch('perkara_putusan',$data_putusan);
				$this->db->insert_batch('perkara_proses',$data_proses_putusan); 
				$this->db->insert_batch('perkara_proses',$data_proses_minutasi); 
				$this->db->insert_batch('perkara_putusan_pemberitahuan_putusan',$data_pemberitahuan_putusan); 
				$this->db->insert_batch('perkara_putusan_terdakwa',$data_putusan_terdakwa); 
				
			}
			delete_files('resources/tmp/', TRUE);
			$data['page_title'] = 'TAMBAH - DATA PERKARA LALU LINTAS';
			$data['main_body'] = 'perkara/new_lalulintas';
			$data['previous'] = $this->input->post('previous');
			$data['curr_date'] = date('d/m/Y');
			$this->load->vars($data);
			$this->load->view('header');
			$this->load->view('body/body_new');
	}
}