<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Penetapan_gugur extends CI_Controller {
	function index($enc){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$idperkara = $this->encrypt->decode(base64_decode($enc));
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}
		$this->tampil_form($idperkara,'add');
	}

	function edit($enc){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$idperkara = $this->encrypt->decode(base64_decode($enc));
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}
		$this->tampil_form($idperkara,'edit');
	}

	function tampil_form($idperkara,$status){
		$data['enc']=base64_encode($this->encrypt->encode($idperkara));
		$data['tgl_sekarang'] = date('d/m/Y');
		$data['status']=$status;
		$data['nomor_perkara']='';
		$data['tanggal_pendaftaran']='';
		
		$this->load->model('perkara/penetapan_gugur_scc','perkara');
		$result = $this->perkara->get_data_perkara($idperkara);
		if($result!=''){
			if($result->num_rows()>0){
				foreach ($result->result() as $row) {
					$data['nomor_perkara'] = $row->nomor_perkara;
					$data['tanggal_pendaftaran'] = $row->tanggal_pendaftaran;
				}
			}else{
				$this->error_page->show_error_msg('Error Found','Tidak ada Perkara');
				exit();
			}
		}
		
		$data['tgl_penetapan'] = '';
		$result = $this->perkara->get_data_penetapan($idperkara);
		if($result!=''){
			if($result->num_rows()>0){
				foreach ($result->result() as $row) {
					$data['tgl_penetapan'] = $row->tanggal_putusan;
				}
			}
		}

		$this->load->vars($data);
		$this->load->view('penetapan_gugur/penetapan_gugur_form');
	}

	function validateInput(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$this->form_validation->set_rules('tgl_penetapan', 'Tanggal Cabut', 'trim|required|xss_clean|exact_length[10]');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			if(empty($idperkara) OR intval($idperkara)<1){
				echo json_encode(array('st'=>0,'msg'=>'Invalid Data.'));
				return;
			}
			$nomor_perkara = $this->tanggalhelper->getNomorPerkara($idperkara);
			$isi_amar = '<p>Menimbang, bahwa penggugat tidak hadir dalam sidang pertama tanpa alasan yang sah, Hakim berpendapat bahwa Penggugat tersebut tidak serius maka gugatan dinyatakan gugur.</p>
                                <p>Mengingat, ketentuan Pasal 13 ayat (1) Peraturan Mahkamah Agung No. 2 Tahun 2015 tentang Pedoman Penyelesaian Gugatan Perkara Sederhana.</p>
                                <p style="text-align:center;">MENETAPKAN:</p>
                                <p>1. Menyatakan gugatan Penggugat  gugur;</p>
                                <p>2. Memerintahkan Panitera untuk mencoret perkara No. '.$nomor_perkara.' dalam register perkara; dan</p>
                                <p>3. memerintahkan pengembalian sisa panjar biaya perkara kepada Penggugat.</p>';
			
			if(!is_numeric($idperkara)){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Perkara Tidak ditemukan. Code Error = 194.'));
				return;
			}else{

				$curr_date = date('Y-m-d');
				$todayDate = date('d/m/Y');
				
				$tgl_penetapan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_penetapan',TRUE));
				
				$selisih = $this->tanggalhelper->getSelisihHari($tgl_penetapan,$curr_date);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Gugur Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
					return;
				}

				$dayname = $this->tanggalhelper->getDayName($tgl_penetapan);
				if($dayname=='Saturday' OR $dayname=='Sunday'){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Gugur Dihari Libur, Sabtu dan Minggu.'));
					return;
				}

				$tglpendaftaran = $this->tanggalhelper->getTanggalPendaftaran($idperkara);

				$selisih = $this->tanggalhelper->getSelisihHari($tglpendaftaran,$tgl_penetapan);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Gugur Tidak Boleh Kurang dari Tanggal Pendaftaran Perkara.'));
					return;
				}

				$tglsidangpertama = $this->tanggalhelper->getTanggalSidangPertama($idperkara);
				$selisih = $this->tanggalhelper->getSelisihHari($tglsidangpertama,$tgl_penetapan);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Gugur Tidak Boleh Kurang dari Tanggal Sidang Pertama.'.$this->tanggalhelper->convertDayDate($tglsidangpertama)));
					return;
				}

				$data_add = array(
						'perkara_id' => $idperkara,
						'tanggal_putusan' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_penetapan',TRUE)),	
						'status_putusan_id' => 29,
						'amar_putusan' => $isi_amar,
						'diinput_oleh' => $this->session->userdata('username'),
						'diinput_tanggal' => date("Y-m-d h:i:s",time())
					);
				$this->load->model('perkara/penetapan_gugur_scc','penetapan');
				$status = $this->input->post('status',TRUE);
				if($status=='edit'){
					$data_add['diperbaharui_oleh'] = $this->session->userdata('username');
					$data_add['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
					$result = $this->penetapan->update_penetapan($idperkara,$data_add);
				}elseif ($status=='add') {
					$data_add['diinput_oleh'] = $this->session->userdata('username');
					$data_add['diinput_tanggal'] = date("Y-m-d h:i:s",time());
					$result = $this->penetapan->add_penetapan($data_add);
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Invalid Data Found.'));
					return;
				}
				if($result===FALSE){
					echo json_encode(array('st'=>0,'msg'=>'Penetapan Gugur Gagal Disimpan'));
					return;
				}
				echo json_encode(array('st'=>1,'msg'=>'Penetapan Gugur Berhasil Disimpan'));
				return;
			}
		}
	}


	function showinfo($enc){
		$data['enc'] = $enc;
		$idperkara = $this->encrypt->decode(base64_decode($enc));
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}
		$data['idperkara'] = $idperkara;
		$this->load->model('perkara/penetapan_gugur_scc','perkara');
		$data['tgl_penetapan'] = '';
		$data['isi_penetapan'] = '';
		$data['tgl_minutasi'] = '';
		$data['tgl_pemberitahuan'] = '';
		$result = $this->perkara->get_data_penetapan($idperkara);
		if($result!=''){
			if($result->num_rows()>0){
				foreach ($result->result() as $row) {
					$data['tgl_penetapan'] = $row->tanggal_putusan;
					$data['isi_penetapan'] = $row->amar_putusan;
					$data['tgl_minutasi'] = $row->tanggal_minutasi;
					#$data['tgl_pemberitahuan'] = '';
				}
			}
		}
		$data['pihak_pertama'] = $this->perkara->getPihak($idperkara,1);
		$data['pihak_kedua'] = $this->perkara->getPihak($idperkara,2);	
		$this->load->vars($data);
		$this->load->view('penetapan_gugur/penetapan_gugur_tab');
	}

	function validateDelete(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Invalid Data.'));
			return;
		}
		
		$this->load->model('perkara/penetapan_gugur_scc','perkara');
		$result = $this->perkara->deleteData($idperkara);
		if($result===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Penetapan Gugur Gagal Dihapus'));
			return;
		}
		echo json_encode(array('st'=>1,'msg'=>'Penetapan Gugur Berhasil Dihapus'));
		return;
	}

	function pen_pemberitahuan($enc){
		$data['enc'] = $enc;
		$idperkara = $this->encrypt->decode(base64_decode($enc));
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}
		$data['idperkara'] = $idperkara;
		$idalurperkara = $this->tanggalhelper->getIDAlurPerkara($idperkara);
		$data['idalurperkara'] = $idalurperkara;
		$this->load->model('perkara/penetapan_gugur_scc','perkara');
		$data['enc']=base64_encode($this->encrypt->encode($idperkara));
		$data['tgl_sekarang'] = date('d/m/Y');
		$data['nomor_perkara']='';
		$data['tanggal_pendaftaran']='';
		
		$result = $this->perkara->get_data_perkara($idperkara);
		if($result!=''){
			if($result->num_rows()>0){
				foreach ($result->result() as $row) {
					$data['nomor_perkara'] = $row->nomor_perkara;
					$data['tanggal_pendaftaran'] = $row->tanggal_pendaftaran;
				}
			}else{
				$this->error_page->show_error_msg('Error Found','Tidak ada Perkara');
				exit();
			}
		}
		$data['tgl_penetapan'] = '';
		$data['isi_penetapan'] = '';
		$data['tgl_minutasi'] = '';
		$data['tgl_pemberitahuan'] = '';
		$result = $this->perkara->get_data_penetapan($idperkara);
		if($result!=''){
			if($result->num_rows()>0){
				foreach ($result->result() as $row) {
					$data['tgl_penetapan'] = $row->tanggal_putusan;
					$data['isi_penetapan'] = $row->amar_putusan;
					$data['tgl_minutasi'] = $row->tanggal_minutasi;
				}
			}
		}
		$data['pihak_pertama'] = $this->perkara->getPihak($idperkara,1);
		$data['pihak_kedua'] = $this->perkara->getPihak($idperkara,2);	
		$this->load->vars($data);
		$this->load->view('penetapan_gugur/penetapan_gugur_form_pemberitahuan');
	}

	function validateDate($tanggal,$idperkara){
		$curr_date = date('Y-m-d');
		$todayDate = date('d/m/Y');

		$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$curr_date);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Penetapan Gugur Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
			return;
		}

		$dayname = $this->tanggalhelper->getDayName($tanggal);
		if($dayname=='Saturday' OR $dayname=='Sunday'){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pemberitahuan Penetapan Gugur Dihari Libur, Sabtu dan Minggu.'));
			return;
		}

		$tglpendaftaran = $this->tanggalhelper->getTanggalPendaftaran($idperkara);
		$selisih = $this->tanggalhelper->getSelisihHari($tglpendaftaran,$tanggal);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Penetapan Gugur Tidak Boleh Kurang dari Tanggal Pendaftaran Perkara.'));
			return;
		}

		$tglsidangpertama = $this->tanggalhelper->getTanggalSidangPertama($idperkara);
		$selisih = $this->tanggalhelper->getSelisihHari($tglsidangpertama,$tanggal);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Penetapan Gugur Tidak Boleh Kurang dari Tanggal Sidang Pertama.'.$this->tanggalhelper->convertDayDate($tglsidangpertama)));
			return;
		}
		$tglputusan = $this->tanggalhelper->getTanggalPutusan($idperkara);
		$selisih = $this->tanggalhelper->getSelisihHari($tglputusan,$tanggal);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Penetapan Gugur Tidak Boleh Kurang dari Tanggal Penetapan Gugur.'.$this->tanggalhelper->convertDayDate($tglputusan)));
			return;
		}
		return TRUE;
	}

	function validatePemberitahuanInput(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Invalid Data.'));
			return;
		}

		$this->load->model('perkara/penetapan_gugur_scc','perkara');
		$i=0;
		$pihak_pertama = $this->perkara->getPihak($idperkara,1);
		$data_pemberitahuan = array();

		if($pihak_pertama->num_rows>0){
			foreach ($pihak_pertama->result() as $row) {
				$data_pemberitahuan[$i] = array(
					'perkara_id' =>$idperkara,
					'putusan_akhir' =>2,
					'pihak' =>1,
					'pihak_id' =>$row->id,

					);
				$input_name = 'pem_pihak_1_'.$row->id;
				$tgl_pemberitahuan = $this->input->post($input_name,TRUE);
				if(!empty($tgl_pemberitahuan)){
					$tgl_pemberitahuan = $this->tanggalhelper->convertToMysqlDate($tgl_pemberitahuan);
					if($this->validateDate($tgl_pemberitahuan,$idperkara)){
						$date = $tgl_pemberitahuan;
					}else{
						return;
					}
				}else{
					$date = 'NULL';
				}
				$data_pemberitahuan[$i] = array(
					'perkara_id' =>$idperkara,
					'putusan_akhir' =>2,
					'pihak' =>1,
					'pihak_id' =>$row->id,
					'tanggal_pemberitahuan_putusan' =>$date,
				);
				$i++;
			}
		}
		
		$pihak_kedua = $this->perkara->getPihak($idperkara,2);
		if($pihak_kedua->num_rows>0){
			foreach ($pihak_kedua->result() as $row) {
				$data_pemberitahuan[$i] = array(
					'perkara_id' =>$idperkara,
					'putusan_akhir' =>2,
					'pihak' =>1,
					'pihak_id' =>$row->id,

					);
				$input_name = 'pem_pihak_2_'.$row->id;
				$tgl_pemberitahuan = $this->input->post($input_name,TRUE);
				if(!empty($tgl_pemberitahuan)){
					$tgl_pemberitahuan = $this->tanggalhelper->convertToMysqlDate($tgl_pemberitahuan);
					if($this->validateDate($tgl_pemberitahuan,$idperkara)){
						$date = $tgl_pemberitahuan;
					}else{
						return;
					}
				}else{
					$date = 'NULL';
				}
				$data_pemberitahuan[$i] = array(
					'perkara_id' =>$idperkara,
					'putusan_akhir' =>2,
					'pihak' =>2,
					'pihak_id' =>$row->id,
					'tanggal_pemberitahuan_putusan' =>$date,
				);
				$i++;
			}
		}
		
		$tgl_minutasi = $this->input->post('tgl_minutasi',TRUE);
		if(!empty($tgl_minutasi)){
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');
			$tgl_minutasi = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_minutasi',TRUE));
			
			$selisih = $this->tanggalhelper->getSelisihHari($tgl_minutasi,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Minutasi Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tgl_minutasi);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Minutasi Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglpendaftaran = $this->tanggalhelper->getTanggalPendaftaran($idperkara);

			$selisih = $this->tanggalhelper->getSelisihHari($tglpendaftaran,$tgl_minutasi);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Minutasi Tidak Boleh Kurang dari Tanggal Pendaftaran Perkara.'));
				return;
			}
			$data_add = array(
				'perkara_id' =>$idperkara,
				'tanggal_minutasi' => $tgl_minutasi,
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
				);
			$result = $this->perkara->update_minutasi($idperkara,$data_add);
		}

		$result = $this->perkara->add_pemberitahuan_penetapan($data_pemberitahuan);
		if($result===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Data Pemberitahuan Gagal Disimpan'));
			return;
		}
		echo json_encode(array('st'=>1,'msg'=>'Data Pemberitahuan Berhasil Disimpan'));
		return;
	}
}