<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Migrasi_siadmil extends CI_Controller {
	
	function index(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		if($this->session->userdata('idgroup')>1){
			show_404();
		}
		$data['page_title'] = 'MIGRASI DATA SIADMIL';
		$data['main_body'] = 'migrasi/migrasi_mil';
		
		$data['data_asal'] = 'MSSQL - SIADMIL';
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}

	function check_progress(){
		echo $this->nativesession->get('update_progress');
	}
	function validateUpdate(){ 
		$this->load->helper('text');
		ini_set('odbc.defaultlrl', 65536); //-->for unlimited read mssql var 
		set_time_limit(0);
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('idgroup')>1){
			echo json_encode(array('st'=>0,'msg'=>'Anda Tidak Memiliki Kewenangan Untuk Mengakses Halaman Ini.'));
			return;
		}

		
		$this->load->model('migrasi/migrasi','patching');
		
		//anti-constraint
		$this->patching->exe_script('SET FOREIGN_KEY_CHECKS=0;');
		$this->patching->exe_script('SET autocommit = 0;');
		
		//--connect mssql server--
		$conn = conn_sqlserver();
		//--
		$this->nativesession->set('update_progress', 0);
		$this->nativesession->set('counter', 0);

		//--table perkara---
		$ms_perkara1 = "IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'v_perkara') BEGIN
    					DROP VIEW dbo.v_perkara
						END";
		$ms_perkara1_exe = exe_sqlserver($conn,$ms_perkara1);
		if($ms_perkara1_exe){
			$this->nativesession->set('update_progress', 1); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara1.'));
			return;
		}
		
		$ms_perkara2= "CREATE VIEW v_perkara AS
						SELECT
							DATA_ID as perkara_id,
							(case
								when (SELECT MKOD_KODE FROM MS_KODE WHERE dr.KODE_ID = MS_KODE.MKOD_ID) = 'K' then '120'
								when (SELECT MKOD_KODE FROM MS_KODE WHERE dr.KODE_ID = MS_KODE.MKOD_ID) = 'P' then '121'
							end) as alur_perkara_id,
							CONVERT(CHAR(10), dr.DREG_TGL_TERIMA_BERKAS, 120)	as tanggal_pendaftaran,
							dr.JNSPERK_ID										as jenis_perkara_id,
							jp.JNSPERK_NAMA										as jenis_perkara_nama,
							jp.JNSPERK_NAMA										as jenis_perkara_text,
							(RTRIM(dr.NO_PERK)+'-'+cast((SELECT MKOD_KODE FROM MS_KODE WHERE dr.KODE_ID =MS_KODE.MKOD_ID) COLLATE DATABASE_DEFAULT as varchar(50))+
							'/'+cast((select MSET_VALUE from MS_SETTING where MSET_KEY='KODENOPERK') COLLATE DATABASE_DEFAULT as varchar(50))+
							'/'+cast((SELECT MMAT_NAMA FROM MS_MATRA WHERE dr.MATRA_ID =MS_MATRA.MMAT_ID) COLLATE DATABASE_DEFAULT as varchar(50))+
							(case 
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=1 then +'/I/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=2 then +'/II/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=3 then +'/III/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=4 then +'/IV/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=5 then +'/V/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=6 then +'/VI/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=7 then +'/VII/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=8 then +'/VIII/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=9 then +'/IX/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=10 then +'/X/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=11 then +'/XI/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=12 then +'/XII/'
							end)
							+cast(DATEPART(YEAR,dr.DREG_TGL_DAFTAR) as char(4))) as nomor_perkara,
							cast((select MSET_VALUE from MS_SETTING where MSET_KEY='KODENOPERK') COLLATE DATABASE_DEFAULT as varchar(50))+
							+'_'+cast(DATEPART(YEAR,dr.DREG_TGL_DAFTAR) as char(4))
							+'_'+cast((SELECT MKOD_KODE FROM MS_KODE WHERE dr.KODE_ID =MS_KODE.MKOD_ID) COLLATE DATABASE_DEFAULT as varchar(50))+
							(case 
								when len(RTRIM(dr.NO_PERK))=1 then +'00'+RTRIM(dr.NO_PERK)
								when len(RTRIM(dr.NO_PERK))=2 then +'0'+RTRIM(dr.NO_PERK)
								when len(RTRIM(dr.NO_PERK))=3 then +RTRIM(dr.NO_PERK)
							end) as nomor_indeks,
							CONVERT(CHAR(10), dr.DREG_TGL_PELIMPAHAN_BERKAS, 120)	as tanggal_surat,
							dr.DREG_NO_PELIMPAHAN_BERKAS							as nomor_surat,
							(SELECT MODT_NAMA FROM MS_ODITUR WHERE dr.MODT_ID =MS_ODITUR.MODT_ID) as pihak1_text,
							(select a.DTER_NAMA from (select 
														distinct
															DREG_ID,
															(SELECT STUFF(
																	 (SELECT '</br>' + DTER_NAMA 
																	  FROM DATA_TERDAKWA md 
																		WHERE md.DREG_ID = m.DREG_ID
																	  FOR XML PATH(''), TYPE).value('.', 'NVARCHAR(MAX)'), 1, 5, '') 
															) as DTER_NAMA
														from DATA_TERDAKWA m) as a where a.DREG_ID=dr.DATA_ID) as pihak2_text,
							
							(select a.DKUASA_NAMA from (select 
														distinct
															DATA_ID,
															(SELECT STUFF(
																	 (SELECT '</br>' + DKUASA_NAMA 
																	  FROM DATA_KUASA md 
																		WHERE md.DATA_ID = m.DATA_ID
																	  FOR XML PATH(''), TYPE).value('.', 'NVARCHAR(MAX)'), 1, 5, '') 
															) as DKUASA_NAMA
														from DATA_KUASA m) as a where a.DATA_ID=dr.DATA_ID) as pengacara_pihak2,									
							('Oditur :<br>'+
							(SELECT MODT_NAMA FROM MS_ODITUR WHERE dr.MODT_ID =MS_ODITUR.MODT_ID)+
							'Terdakwa:<br>'+
							(select a.DTER_NAMA from (select 
														distinct
															DREG_ID,
															(SELECT STUFF(
																	 (SELECT '</br>' + DTER_NAMA 
																	  FROM DATA_TERDAKWA md 
																		WHERE md.DREG_ID = m.DREG_ID
																	  FOR XML PATH(''), TYPE).value('.', 'NVARCHAR(MAX)'), 1, 5, '') 
															) as DTER_NAMA
														from DATA_TERDAKWA m) as a where a.DREG_ID=dr.DATA_ID)) as para_pihak,
							'Y' as pihak_dipublikasikan,
							dr.DREG_ISI_DAKWAAN				as dakwaan,
							dr.DREG_PASAL					as pasal_dakwaan


						from (select 0 as no) as nmr,DATA_REGISTER as dr
						LEFT JOIN MS_JENIS_PERKARA as jp on dr.JNSPERK_ID=jp.JNSPERK_ID";
		
		if(exe_sqlserver($conn,$ms_perkara2)){
			$this->nativesession->set('update_progress', 2); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara2.'));
			return;
		}

		$ms_perkara3 = "SELECT * FROM v_perkara where nomor_perkara is not null";
		$ms_perkara3_exe = exe_sqlserver($conn,$ms_perkara3);

		$jml_data = odbc_num_rows($ms_perkara3_exe);
		if($jml_data>0){
				
		while($row = odbc_fetch_array($ms_perkara3_exe)){
			//$this->load->helper('text');
			
			$count = null;    
			$matches = ('"{\*?\\.+(;})|\s?\\[A-Za-z0-9]+|\s?{\s?\\[A-Za-z0-9]+\s?|\s?}\s?"');
			
			
			$data['perkara_id']=$row['perkara_id'];
			$data['alur_perkara_id']=$row['alur_perkara_id'];
			$data['tanggal_pendaftaran']=$row['tanggal_pendaftaran'];
			$data['jenis_perkara_id']=$row['jenis_perkara_id'];
			$data['jenis_perkara_nama']=$row['jenis_perkara_nama'];
			$data['jenis_perkara_text']=$row['jenis_perkara_text'];
			$data['nomor_perkara']=ascii_to_entities($row['nomor_perkara']);
			$data['nomor_indeks']=ascii_to_entities($row['nomor_indeks']);
			$data['nomor_surat']=ascii_to_entities($row['nomor_surat']);
			$data['pihak1_text']=ascii_to_entities($row['pihak1_text']);
			$data['pihak2_text']=ascii_to_entities($row['pihak2_text']);
			$data['pengacara_pihak2']=ascii_to_entities($row['pengacara_pihak2']);
			$data['para_pihak']=ascii_to_entities($row['para_pihak']);
			$data['pihak_dipublikasikan']=$row['pihak_dipublikasikan'];
			$dakwaan_reg=str_replace(array("\pard","\par"), array("</br>","</br>"), ascii_to_entities($row['dakwaan']));
			$dakwaan_br=preg_replace('(\'"{\\*?\\\\.+(;})|\\s?\\\\[A-Za-z0-9]+|\\s?{\\s?\\\\[A-Za-z0-9]+\\s?|\\s?}\\s?"\')','',$dakwaan_reg, -1, $count);
			$cari=array("Courier New;}","Arial Narrow;}","Arial Narrow;}","Times New Roman;}","Calibri;}","Calibri;}","Times New Roman;}};}","Normal;}","{\* Default Paragraph Font;}","Body Text;}","{\* Body Text Text;}","List Paragraph;}","No Spacing;}}{\*","-720\'02\'00.;}\'01;}}","-360\'02\'01.;}\'01;}}","-180\'02\'02.;}\'01;}}","-360\'02\'03.;}\'01;}}","-360\'02\'04.;}\'01;}}","-180\'02\'05.;}\'01;}}","-360\'02\'06.;}\'01;}}","-360\'02\'07.;}\'01;}}","-180\'02\'08.;}\'01;}}","\'02\'00.;}\'01;}}","-360\'02\'07.;}","Arial;}","};;}","Body Text Indent 3;}{\* Body Text Indent 3 Text;}","No Spacing;}}","Wingdings;}","Symbol;}};;}","header;}{\* header Text;}-240","Body Text Indent 2;}{\* Body Text Indent 2 Text;}","Body Text Indent;}{\* Body Text Indent Text;}","Body Text,Char;}{\* Body Text,Char Text;}","{\* page number;}","{\* Strong;}","Body Text,Char Char,Char Char1,Char Char Char,Body Text Char1,Char Char2,Body Text Char Char,Char Char1 Char;}{\* Body Text,Char Char,Char Char1,Char Char Char,Body Text Char1,Char Char2,Body Text Char Char,Char Char1 Char Text;}}","};}","Symbol;}","-360\'01-;};}}","-360\'01o;};}}","-360\'01 ?;};}}","-360\'01o;};}}","-360\'02\'06.;}\'01;}","Body Text 2;}","{\* Body Text 2 Text;}-3420 -360 }","};;;}"," {\* Body Text 2 Text;}}","-3420 }","header;}","{\* header Text;}}","{\* \'02\'00);}\'01;}}","{\* } }","}{\*","-705","      }","}","{\* Body Text 2 Text;",";;;;","{\* Body Text 2 Text;","\'02\'00);\'01;","{\*","\'02\'00.;\'0","-240","{\* header Text; ","header Text;","Body Text,","Char","Char;","Char","Text;","-360\'02\'02);\'01;","-360\'02\'08.;\'01;","-1080\'01\'01;\'01;","-360\'02\'06.;{","-1080","heading 1;","heading 1 Text;","{\* header Text;","{\* Body Text 2 Text;","Subtitle;","Subtitle Text;","Plain Text;","Plain Text Text;","footer;","footer Text;","Block Text;","-1080","-285","-360\'02\'02.;\'01;","heading 7;","heading 7 -360","-420","-360\'02\'05.;\'01;",", 1,  ,Body Text 1, 2,Body Text  , 1 ;  , 1,  ,Body Text 1, 2,Body Text  , 1","-2160","-720\'01\'00;\'01;","-690\'02\'01.;\'01;","-330",",, ;  ,,  -720  No Spacing;","-180{");
			$ganti=array('','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
			$dakwaan_clean=str_replace($cari, $ganti, $dakwaan_br);
			$data['dakwaan']=$dakwaan_clean;			
			$data['pasal_dakwaan']=ascii_to_entities($row['pasal_dakwaan']);

			$data['tahapan_terakhir_id']=10;
			$data['tahapan_terakhir_text']='Pendaftaran';
			$data['proses_terakhir_id']=10;
			$data['proses_terakhir_text']='Pendaftaran Perkara';
			$data['diinput_oleh']='System';
			$data['diinput_tanggal']=date("Y-m-d H:i:s", time());

			$data1['perkara_id']=$row['perkara_id'];
			$data1['tahapan_id']=10;
			$data1['tahapan_nama']='Pendaftaran';
			$data1['proses_id']=10;
			$data1['proses_nama']='Pendaftaran Perkara';
			$data1['tanggal']=$row['tanggal_pendaftaran'];
			$data1['diinput_oleh']='System';
			$data1['diinput_tanggal']=date("Y-m-d H:i:s", time());

			$my_perkara3 = $this->patching->replace_data('perkara',$data);
			$my_perkara3_1 = $this->patching->replace_data('perkara_proses',$data1);
		}
		if($my_perkara3 && $my_perkara3_1){
			$this->nativesession->set('update_progress', 3); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query my_perkara3.'));
			return;
		}
		}

		$my_perkara4 =" UPDATE perkara SET jenis_perkara_id=
						CASE
							WHEN jenis_perkara_id=61 THEN 265
							WHEN jenis_perkara_id=62 THEN 272
							WHEN jenis_perkara_id=70 THEN 274
							WHEN jenis_perkara_id=76 THEN 277
							WHEN jenis_perkara_id=18 THEN 291
							WHEN jenis_perkara_id=27 THEN 299
							WHEN jenis_perkara_id=30 THEN 301
							WHEN jenis_perkara_id=31 THEN 302
							WHEN jenis_perkara_id=32 THEN 303
							WHEN jenis_perkara_id=33 THEN 304
							WHEN jenis_perkara_id=38 THEN 309
							WHEN jenis_perkara_id=43 THEN 310
							WHEN jenis_perkara_id=50 THEN 312
							WHEN jenis_perkara_id=52 THEN 315
							WHEN jenis_perkara_id=42 THEN 316
							WHEN jenis_perkara_id=4 THEN 317
							WHEN jenis_perkara_id=78 THEN 264
							WHEN jenis_perkara_id=79 THEN 268
							WHEN jenis_perkara_id=41 THEN 314
							WHEN jenis_perkara_id=80 THEN 289
							WHEN jenis_perkara_id=72 THEN 273
							WHEN jenis_perkara_id=49 THEN 292
							WHEN jenis_perkara_id=65 THEN 300
							WHEN jenis_perkara_id=20 THEN 293
							WHEN jenis_perkara_id=69 THEN 293
							WHEN jenis_perkara_id=71 THEN 293
							WHEN jenis_perkara_id=73 THEN 298
							WHEN jenis_perkara_id=35 THEN 306
							WHEN jenis_perkara_id=74 THEN 292
							WHEN jenis_perkara_id=59 THEN 339
							WHEN jenis_perkara_id=1 THEN 284
							WHEN jenis_perkara_id=2 THEN 338
						END	
						WHERE jenis_perkara_id IN (61,62,70,76,18,27,30,31,32,33,38,43,50,52,42,4,78,79,41,80,72,49,65,20,69,71,73,35,74,59,1,2)";

		if($this->patching->exe_script($my_perkara4)){
			$this->nativesession->set('update_progress', 4); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query my_perkara4.'));
			return;
		}



		$sql = "DROP TABLE IF EXISTS pihak2_idlama_idbaru";
		$this->patching->exe_script($sql);
		$sql1 = "CREATE TABLE pihak2_idlama_idbaru (
						pihak2_id_lama bigint(20) unsigned NOT NULL,
						pihak2_id_baru bigint(20) unsigned NOT NULL
					) ENGINE=MyISAM;";
		
		if($this->patching->exe_script($sql1)){
			$this->nativesession->set('update_progress', 4); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query sql.'));
			return;
		}


		//--table pihak dan perkara_pihak1---
		$ms_perkara5 = "IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'v_pihak') BEGIN
    					DROP VIEW dbo.v_pihak
						END";
		
		if(exe_sqlserver($conn,$ms_perkara5)){
			$this->nativesession->set('update_progress', 5); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara5.'));
			return;
		}
		$ms_perkara5a= "CREATE VIEW v_pihak AS
						SELECT  
							MODT_ID					as id, 
							1						as jenis_pihak_id,
							MODT_NAMA				as nama,
							MODT_TMPT_LAHIR		as tempat_lahir,
							(case
								when MODT_KELAMIN=1 then 'L'
								when MODT_KELAMIN=2 then 'P'
								ELSE
								'L'
							END)		as jenis_kelamin,

							MODT_ALAMAT				as alamat,
							MODT_PEKERJAAN			as pekerjaan,
							MODT_NIP 				as nrp,
							MODT_PANGKAT 			as pangkat,
							'T'						as difabel
						FROM MS_ODITUR";
		
		if(exe_sqlserver($conn,$ms_perkara5a)){
			$this->nativesession->set('update_progress', 5); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara5a.'));
			return;
		}

		$ms_perkara5b = "SELECT * FROM v_pihak";
		$ms_perkara5b_exe = exe_sqlserver($conn,$ms_perkara5b);
		$jml_data = odbc_num_rows($ms_perkara5b_exe);
		if($jml_data>0){
				
		while($row = odbc_fetch_array($ms_perkara5b_exe)){
			//$this->load->helper('text');
			$data5['id']=$row['id'];
			$data5['jenis_pihak_id']=$row['jenis_pihak_id'];
			$data5['nama']=$row['nama'];
			$data5['tempat_lahir']=$row['tempat_lahir'];
			$data5['jenis_kelamin']=$row['jenis_kelamin'];
			$data5['alamat']=$row['alamat'];
			$data5['pekerjaan']='Tentara Nasional Indonesia';
			$data5['diinput_oleh']='System';
			$data5['diinput_tanggal']=date("Y-m-d H:i:s", time());

			$data5_a['pihak_id']=$row['id'];
			$data5_a['NIP']=$row['nrp'];
			$data5_a['pangkat']=$row['pangkat'];
			$data5_a['diinput_oleh']='System';
			$data5_a['diinput_tanggal']=date("Y-m-d H:i:s", time());


			$my_perkara5b = $this->patching->replace_data('pihak',$data5);
			$my_perkara5b_1 = $this->patching->replace_data('pihak_jaksa',$data5_a);
		}
		if($my_perkara5b && $my_perkara5b_1){
			$this->nativesession->set('update_progress', 5); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query my_perkara5b.'));
			return;
		}
		}
		//--

		$list_perkara_id=$this->patching->get_list_perkara_id()->result();
		$cek_perkara_id=$list_perkara_id[0]->perkara_id;

		$ms_perkara6 = "IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'v_perkara_pihak1') BEGIN
    					DROP VIEW dbo.v_perkara_pihak1
						END";
		
		if(exe_sqlserver($conn,$ms_perkara6)){
			$this->nativesession->set('update_progress', 6); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara6.'));
			return;
		}

		$ms_perkara6a= "CREATE VIEW v_perkara_pihak1 AS
						SELECT  
						ROW_NUMBER() OVER( ORDER BY dr.DATA_ID )	as id, 
						dr.DATA_ID									as perkara_id, 
						1											as urutan,   
						dr.MODT_ID									as pihak_id, 
						1											as jenis_pihak_id, 
						mo.MODT_PANGKAT + ' ' + mo.MODT_NAMA		as nama, 
						mo.MODT_ALAMAT								as alamat,
						mo.MODT_PANGKAT								as pangkat,
						mo.MODT_NIP									as nrp						
					FROM DATA_REGISTER as dr 
					LEFT JOIN MS_ODITUR as mo on dr.MODT_ID = mo.MODT_ID 
					WHERE dr.MODT_ID <> 0";
		
		if(exe_sqlserver($conn,$ms_perkara6a)){
			$this->nativesession->set('update_progress', 6); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara6a.'));
			return;
		}

		$ms_perkara6b = "SELECT * from v_perkara_pihak1 where perkara_id in (".$cek_perkara_id.")";
		$ms_perkara6b_exe = exe_sqlserver($conn,$ms_perkara6b);
		$jml_data = odbc_num_rows($ms_perkara6b_exe);
		if($jml_data>0){
				
		while($row = odbc_fetch_array($ms_perkara6b_exe)){
			//$this->load->helper('text');
			$data6['id']=$row['id'];
			$data6['perkara_id']=$row['perkara_id'];
			$data6['urutan']=$row['urutan'];
			$data6['pihak_id']=$row['pihak_id'];
			$data6['jenis_pihak_id']=$row['jenis_pihak_id'];
			$data6['nama']=$row['nama'];
			$data6['alamat']=$row['alamat'];
			$data6['diinput_oleh']='System';
			$data6['diinput_tanggal']=date("Y-m-d H:i:s", time());

			//$data6['pangkat']=$row['pangkat'];

			//$data6_a['pihak_id']=$row['pihak_id'];
			//$data6_a['NIP']=$row['nrp'];

			$my_perkara6b = $this->patching->replace_data('perkara_pihak1',$data6);
		}
		if($my_perkara6b){
			$this->nativesession->set('update_progress', 6); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query my_perkara6b.'));
			return;
		}
		}

		//--- tabel pihak dan perkara_pihak2
		$ms_perkara7 = "IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'v_pihak2') BEGIN
    					DROP VIEW dbo.v_pihak2
						END";
		
		if(exe_sqlserver($conn,$ms_perkara7)){
			$this->nativesession->set('update_progress', 7); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara7.'));
			return;
		}




		$ms_perkara8 = "IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'v_perkara_pihak2') BEGIN
    					DROP VIEW dbo.v_perkara_pihak2
						END";
		
		if(exe_sqlserver($conn,$ms_perkara8)){
			$this->nativesession->set('update_progress', 8); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara8.'));
			return;
		}

		$ms_perkara8a= "CREATE VIEW v_perkara_pihak2 AS
						SELECT  
							ROW_NUMBER() OVER( ORDER BY DATA_ID )	as id,
							DATA_ID 			as id_pihak_lama,
							DREG_ID				as perkara_id, 
							ROW_NUMBER()OVER(Partition By DREG_ID Order By DATA_ID) as urutan,
							1					as jenis_pihak_id,  
							DTER_NAMA			as nama,
							'-1'				as jenis_indentitas,
							DTER_NRP			as nomor_indentitas, 
							DTER_ALAMAT			as alamat,
							DTER_PANGKAT		as pangkat,
							DTER_JABATAN		as jabatan,
							DTER_KESATUAN		as kesatuan,
							DTER_TEMPAT_LAHIR	as tempat_lahir,
							(case
								when DTER_KELAMIN='False' then 'L'
								when DTER_KELAMIN='True' then 'P'
								ELSE 'L'
							END)				as jenis_kelamin,
							DTER_JABATAN+' '+DTER_KESATUAN			as pekerjaan,
							'T'						as difabel  
						FROM DATA_TERDAKWA";
		
		if(exe_sqlserver($conn,$ms_perkara8a)){
			$this->nativesession->set('update_progress', 8); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara8a.'));
			return;
		}


		$ms_perkara8b = "SELECT * from v_perkara_pihak2 where perkara_id in (".$cek_perkara_id.")";
		$ms_perkara8b_exe = exe_sqlserver($conn,$ms_perkara8b);
		$jml_data = odbc_num_rows($ms_perkara8b_exe);
		if($jml_data>0){				

			$maxid=$this->patching->get_maxid_pihak()->result();
			$maxid_pihak=$maxid[0]->maxid_pihak;

		while($row = odbc_fetch_array($ms_perkara8b_exe)){
			$maxid_pihak++;
				
			$id=$maxid_pihak;
			$data7['id']=$maxid_pihak;
			$data7['jenis_pihak_id']=$row['jenis_pihak_id'];
			$data7['nama']=ascii_to_entities($row['nama']);
			$data7['jenis_indentitas']=$row['jenis_indentitas'];
			$data7['nomor_indentitas']=ascii_to_entities($row['nomor_indentitas']);
			$data7['tempat_lahir']=ascii_to_entities($row['tempat_lahir']);
			$data7['jenis_kelamin']=$row['jenis_kelamin'];
			$data7['alamat']=ascii_to_entities($row['alamat']);
			$data7['pekerjaan']='Tentara Nasional Indonesia';
			$data7['diinput_oleh']='System';
			$data7['diinput_tanggal']=date("Y-m-d H:i:s", time());


			$data8['id']=$row['id'];
			$data8['perkara_id']=$row['perkara_id'];
			$data8['urutan']=$row['urutan'];
			$data8['pihak_id']=$maxid_pihak;
			$data8['jenis_pihak_id']=$row['jenis_pihak_id'];
			$data8['nama']=ascii_to_entities($row['nama']);
			$data8['alamat']=ascii_to_entities($row['alamat']);
			$data8['pangkat']=ascii_to_entities($row['pangkat']);
			$data8['jabatan']=ascii_to_entities($row['jabatan']);
			$data8['kesatuan']=ascii_to_entities($row['kesatuan']);
			$data8['diinput_oleh']='System';
			$data8['diinput_tanggal']=date("Y-m-d H:i:s", time());


			$data8c['pihak2_id_lama']=$row['id_pihak_lama'];
			$data8c['pihak2_id_baru']=$maxid_pihak;

			$my_perkara7a = $this->patching->replace_data('pihak',$data7);
			$my_perkara8b = $this->patching->replace_data('perkara_pihak2',$data8);
			$my_perkara8c = $this->patching->replace_data('pihak2_idlama_idbaru',$data8c);
			
		}		
		
		if($my_perkara7a && $my_perkara8b && $my_perkara8c){
			$this->nativesession->set('update_progress', 8); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query my_perkara7a,my_perkara8b.'));
			return;
		}
		}

		//--pihak - kuasa
		$ms_perkara9 = "IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'v_perkara_pengacara') BEGIN
    					DROP VIEW dbo.v_perkara_pengacara
						END";
		
		if(exe_sqlserver($conn,$ms_perkara9)){
			$this->nativesession->set('update_progress', 9); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara9.'));
			return;
		}

		$ms_perkara9a= "CREATE VIEW v_perkara_pengacara AS						
						SELECT
							ROW_NUMBER() OVER (ORDER BY dt.DATA_ID)	AS id,
							dt.DATA_ID 								as idpihak2lama,
							dt.DREG_ID								as perkara_id,
							dt.DTER_NRP								as nomor_indentitas,
							2										AS pihak_ke,
							1										as jenis_pihak_id,
							ROW_NUMBER()OVER(Partition By dt.DREG_ID Order By dt.DATA_ID) as urutan,
							dk.DATA_ID								AS pengacara_id,
							dk.DKUASA_NAMA							AS nama,
							dk.DKUASA_NIP							AS nomor_induk,
							dk.DKUASA_PANGKAT						AS pangkat,
							dk.DKUASA_ALAMAT						AS alamat,
							dk.DKUASA_TEMPAT_LAHIR					as tempat_lahir,
							(case
								when dk.DKUASA_KELAMIN='True' then 'L'
								when dk.DKUASA_KELAMIN='False' then 'P'
								ELSE
								'L'
							END) as jenis_kelamin,	
							dk.DKUASA_PEKERJAAN						as pekerjaan,
							'T'										as difabel,
							'Y'										AS aktif
						from DATA_TERDAKWA as dt 
						LEFT JOIN DATA_REGISTER as dr on dr.DATA_ID=dt.DREG_ID
						left join DATA_KUASA as dk on dk.KEY_ID=dt.DATA_ID
						where dk.DATA_ID is not null

					";
		
		if(exe_sqlserver($conn,$ms_perkara9a)){
			$this->nativesession->set('update_progress', 9); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara9a.'));
			return;
		}


		$ms_perkara9b = "SELECT * from v_perkara_pengacara where perkara_id in (".$cek_perkara_id.")";
		$ms_perkara9b_exe = exe_sqlserver($conn,$ms_perkara9b);
		
		$jml_data = odbc_num_rows($ms_perkara9b_exe);
		if($jml_data>0){

			$maxid=$this->patching->get_maxid_pihak()->result();
			$maxid_pihak=$maxid[0]->maxid_pihak;
		
		while($row = odbc_fetch_array($ms_perkara9b_exe)){

			$maxid_pihak++;

			//$idpihakbaru=$this->patching->get_id_pihakbaru($row['idpihak2lama'])->result();


            $idpihakbaru=$this->patching->get_id_pihakbaru($row['idpihak2lama']);
			if($idpihakbaru->num_rows>0){
				$idpihakbaru = $idpihakbaru->result(); 
				$pihak_id_baru=$idpihakbaru[0]->pihak2_id_baru;	

			$data9a['id']=$row['id'];
			$data9a['perkara_id']=$row['perkara_id'];
			$data9a['pihak_ke']=$row['pihak_ke'];
			$data9a['pihak_id']=$pihak_id_baru;
			$data9a['urutan']=$row['urutan'];
			$data9a['pengacara_id']=$maxid_pihak;
			$data9a['jenis_pihak_id']=$row['jenis_pihak_id'];
			$data9a['nama']=$row['nama'];
			$data9a['alamat']=$row['alamat'];
			$data9a['diinput_oleh']='System';
			$data9a['diinput_tanggal']=date("Y-m-d H:i:s", time());		
}				
			$id=$maxid_pihak;
			$data9['id']=$maxid_pihak;
			$data9['jenis_pihak_id']=$row['jenis_pihak_id'];
			$data9['nama']=$row['nama'];
			$data9['tempat_lahir']=$row['tempat_lahir'];
			$data9['jenis_kelamin']=$row['jenis_kelamin'];
			$data9['alamat']=$row['alamat'];
			$data9['pekerjaan']=$row['pekerjaan'];
			$data9['diinput_oleh']='System';
			$data9['diinput_tanggal']=date("Y-m-d H:i:s", time());
						
			$data9b['pihak_id']=$maxid_pihak;
			$data9b['nomor_induk']=$row['nomor_induk'];
			$data9b['alamat_kantor']=$row['alamat'];
			$data9b['pangkat']=$row['pangkat'];
			$data9b['jabatan']=$row['pekerjaan'];
			//$data9b['diinput_oleh']='System';
			//$data9b['diinput_tanggal']=date("Y-m-d H:i:s", time());


			$my_perkara9 = $this->patching->replace_data('pihak',$data9);
			$my_perkara9a = $this->patching->replace_data('perkara_pengacara',$data9a);
			$my_perkara9b = $this->patching->replace_data('pihak_pengacara',$data9b);
		}		
		
		if($my_perkara9 && $my_perkara9a && $my_perkara9b){
			$this->nativesession->set('update_progress', 9); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query $my_perkara9,my_perkara9a,my_perkara9b.'));
			return;
		}
		}


		//--penahanan terdakwa
		$ms_perkara10 = "IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'v_penahanan_terdakwa') BEGIN
    					DROP VIEW dbo.v_penahanan_terdakwa
						END";
		
		if(exe_sqlserver($conn,$ms_perkara10)){
			$this->nativesession->set('update_progress', 10); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara10.'));
			return;
		}

		$ms_perkara10a= "CREATE VIEW v_penahanan_terdakwa AS						
						SELECT 
							ROW_NUMBER() OVER (ORDER BY dp.DATA_ID)	AS id,
							ROW_NUMBER()OVER(Partition By dt.DREG_ID Order By dp.DPEN_TGL_MULAI) as urutan,
							dt.DREG_ID				as perkara_id,
							dp.KEY_ID				as pihak_id_lama,							
							(case ROW_NUMBER()OVER(Partition By dt.DREG_ID Order By dp.DPEN_TGL_MULAI)
								WHEN 1 THEN 15
								WHEN 2 THEN 16
								WHEN 3 THEN 17
								WHEN 4 THEN 18
								WHEN 5 THEN 19
								WHEN 6 THEN 20
								WHEN 7 THEN 21
								WHEN 8 THEN 22
								WHEN 9 THEN 23
								WHEN 10 THEN 24
								WHEN 11 THEN 25
								WHEN 12 THEN 26
								WHEN 13 THEN 27
								WHEN 14 THEN 28
								WHEN 15 THEN 29
								WHEN 16 THEN 30
							END)					as jenis_penahanan_id,						
							
							(case dp.DPEN_JENIS
								  when 1 then 1
								  when 2 then 2
								  when 3 then 5
								  else 1	
							end)					as status_penahanan_id,

							4						as jenis_tahanan_id,
							CONVERT(CHAR(10), dp.DPEN_TGL_TAPHAN, 120) as tanggal_surat,
							dp.DPEN_NO_TAPHAN		AS nomor_surat,
							CONVERT(CHAR(10), dp.DPEN_TGL_MULAI, 120) as mulai,
							CONVERT(CHAR(10), dp.DPEN_TGL_SELESAI, 120) as sampai,
							(CONVERT(CHAR(10), dp.DPEN_TGL_MULAI, 120)+' s/d '+CONVERT(CHAR(10), dp.DPEN_TGL_SELESAI, 120)) as waktu_penahanan,
							datediff(day,dp.DPEN_TGL_MULAI,dp.DPEN_TGL_SELESAI) as lama_penahanan
						from DATA_PENAHANAN as dp
						LEFT JOIN DATA_TERDAKWA as dt on dp.KEY_ID=dt.DATA_ID	

					";
		
		if(exe_sqlserver($conn,$ms_perkara10a)){
			$this->nativesession->set('update_progress', 10); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara10a.'));
			return;
		}


		$ms_perkara10b = "SELECT * from v_penahanan_terdakwa where perkara_id in (".$cek_perkara_id.")";
		$ms_perkara10b_exe = exe_sqlserver($conn,$ms_perkara10b);
		$jml_data = odbc_num_rows($ms_perkara10b_exe);
		if($jml_data>0){				

		while($row = odbc_fetch_array($ms_perkara10b_exe)){		
			$idpihakbaru=$this->patching->get_id_pihakbaru($row['pihak_id_lama']);
			if($idpihakbaru->num_rows>0){
 			$idpihakbaru=$idpihakbaru->result();
			$pihak_id_baru=$idpihakbaru[0]->pihak2_id_baru;		
			
			$data10['id']=$row['id'];
			$data10['perkara_id']=$row['perkara_id'];
			$data10['pihak_id']=$pihak_id_baru;
			$data10['jenis_penahanan_id']=$row['jenis_penahanan_id'];
			$data10['status_penahanan_id']=$row['status_penahanan_id'];
			$data10['jenis_tahanan_id']=$row['jenis_tahanan_id'];
			$data10['tanggal_surat']=$row['tanggal_surat'];
			$data10['nomor_surat']=$row['nomor_surat'];
			$data10['mulai']=$row['mulai'];
			$data10['sampai']=$row['sampai'];
			$data10['waktu_penahanan']=$row['waktu_penahanan'];
			$data10['lama_penahanan']=$row['lama_penahanan'];
			$data10['pejabat_penahan']='-';
			$data10['diinput_oleh']='System';
			$data10['diinput_tanggal']=date("Y-m-d H:i:s", time());
}

			$my_perkara10 = $this->patching->replace_data('penahanan_terdakwa',$data10);
		}		
		
		if($my_perkara10){
			$this->nativesession->set('update_progress', 10); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query $my_perkara10'));
			return;
		}
		}

		//--perkara_penetapan
		$ms_perkara11 = "IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'v_perkara_penetapan') BEGIN
    					DROP VIEW dbo.v_perkara_penetapan
						END";
		
		if(exe_sqlserver($conn,$ms_perkara11)){
			$this->nativesession->set('update_progress', 11); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara11.'));
			return;
		}

		$ms_perkara11a= "CREATE VIEW v_perkara_penetapan AS						
						SELECT 
						dm.DREG_ID as perkara_id, 
						(SELECT convert(varchar(10), dm.DMAJ_TGL_TAPKIM, 120)) as penetapan_majelis_hakim, 
						dm.DMAJ_NO_TAPKIM as nomor_sk_penetapan_majelis_hakim, 
						'' as sk_penetapan_majelis_hakim_dok, 
						CAST(dm.DMAJ_KETUA_ID as varchar(4)) + ',' + CAST(dm.DMAJ_ANGGOTA1_ID as varchar (4)) + ',' + CAST(dm.DMAJ_ANGGOTA2_ID as varchar (4)) as majelis_hakim_id, 
						(SELECT mh1.MHKM_PANGKAT + ' ' + mh.MHKM_NAMA where dm.DMAJ_KETUA_ID = mh.MHKM_ID) +'</br>'
						+(SELECT mh1.MHKM_PANGKAT + ' ' + mh1.MHKM_NAMA where dm.DMAJ_ANGGOTA1_ID = mh1.MHKM_ID)+'<br/>'
						+(SELECT mh2.MHKM_PANGKAT + ' ' + mh2.MHKM_NAMA where dm.DMAJ_ANGGOTA2_ID = mh2.MHKM_ID) as majelis_hakim_nama, 
						+'Hakim Ketua : '+(SELECT mh1.MHKM_PANGKAT + ' ' + mh.MHKM_NAMA where dm.DMAJ_KETUA_ID = mh.MHKM_ID)
						+'</br>Hakim Anggota 1'+(SELECT mh1.MHKM_PANGKAT + ' ' + mh1.MHKM_NAMA where dm.DMAJ_ANGGOTA1_ID = mh1.MHKM_ID)
						+'</br>Hakim Anggota 2'+(SELECT mh2.MHKM_PANGKAT + ' ' + mh2.MHKM_NAMA where dm.DMAJ_ANGGOTA2_ID = mh2.MHKM_ID) as majelis_hakim_text, 
						(SELECT convert(varchar(10), dm.DMAJ_TGL_TAPKIM, 120)) as penetapan_panitera_pengganti, 

						+'TAP/'+''+(RTRIM(dr.NO_PERK)+'-'+cast((SELECT MKOD_KODE FROM MS_KODE WHERE dr.KODE_ID = MS_KODE.MKOD_ID) COLLATE DATABASE_DEFAULT as varchar(50))+
							'/'+cast((select MSET_VALUE from MS_SETTING where MSET_KEY='KODENOPERK') COLLATE DATABASE_DEFAULT as varchar(50))+
							'/'+cast((SELECT MMAT_NAMA FROM MS_MATRA WHERE dr.MATRA_ID =MS_MATRA.MMAT_ID) COLLATE DATABASE_DEFAULT as varchar(50))+
							(case 
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=1 then +'/I/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=2 then +'/II/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=3 then +'/III/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=4 then +'/IV/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=5 then +'/V/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=6 then +'/VI/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=7 then +'/VII/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=8 then +'/VIII/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=9 then +'/IX/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=10 then +'/X/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=11 then +'/XI/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=12 then +'/XII/'
							end)
							+cast(DATEPART(YEAR,dr.DREG_TGL_DAFTAR) as char(4))) as nomor_sk_penetapan_panitera_pengganti, 
							
							dm.DMAJ_PANITERA_ID		AS panitera_pengganti_id,
							(select MPAN_NAMA from MS_PANITERA where dm.DMAJ_PANITERA_ID=MPAN_ID) as panitera_pengganti_text, 
							(convert(varchar(10), dr.DREG_TGL_TAPSID,120))		as penetapan_hari_sidang, 
							(convert(varchar(10), (select MIN(DSID_TANGGAL) FROM DATA_SIDANG AS ds where ds.DREG_ID=dm.DREG_ID),120)) as sidang_pertama

						FROM DATA_MAJELIS as dm 
						LEFT JOIN MS_HAKIM as mh on dm.DMAJ_KETUA_ID = mh.MHKM_ID 
						LEFT JOIN MS_HAKIM as mh1 on dm.DMAJ_ANGGOTA1_ID = mh1.MHKM_ID 
						LEFT JOIN MS_HAKIM as mh2 on dm.DMAJ_ANGGOTA2_ID = mh2.MHKM_ID 
						LEFT JOIN DATA_REGISTER as dr on dm.DREG_ID = dr.DATA_ID
						WHERE dm.DMAJ_TGL_TAPKIM is not null

					";
		
		if(exe_sqlserver($conn,$ms_perkara11a)){
			$this->nativesession->set('update_progress', 11); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara11a.'));
			return;
		}


		$ms_perkara11b = "SELECT * from v_perkara_penetapan where perkara_id in (".$cek_perkara_id.")";
		$ms_perkara11b_exe = exe_sqlserver($conn,$ms_perkara11b);
		
		$jml_data = odbc_num_rows($ms_perkara11b_exe);
		if($jml_data>0){
		
		while($row = odbc_fetch_array($ms_perkara11b_exe)){		
			//$this->load->helper('text');
			$data11['perkara_id']=$row['perkara_id'];
			$data11['penetapan_majelis_hakim']=$row['penetapan_majelis_hakim'];			
			$data11['majelis_hakim_id']=$row['majelis_hakim_id'];
			$data11['majelis_hakim_nama']=$row['majelis_hakim_nama'];
			$data11['majelis_hakim_text']=$row['majelis_hakim_text'];

			$data11['penetapan_panitera_pengganti']=$row['penetapan_panitera_pengganti'];			
			$data11['panitera_pengganti_id']=$row['panitera_pengganti_id'];

			$data11['penetapan_hari_sidang']=$row['penetapan_hari_sidang'];
			$data11['sidang_pertama']=$row['sidang_pertama'];
			$data11['diinput_oleh']='System';
			$data11['diinput_tanggal']=date("Y-m-d H:i:s", time());

			
			$this->patching->replace_data('perkara_penetapan',$data11);
			
			if(!empty($row['penetapan_majelis_hakim'])){
			$update_perkara ="UPDATE perkara SET 
							  tahapan_terakhir_id=12,
							  tahapan_terakhir_text='Penetapan',
							  proses_terakhir_id=20,
							  proses_terakhir_text='Penetapan Majelis Hakim/Hakim'
							  WHERE perkara_id=".$row['perkara_id']."";
			
			if($this->patching->exe_script($update_perkara)){
				$data11_a['perkara_id']=$row['perkara_id'];
				$data11_a['tahapan_id']=12;
				$data11_a['tahapan_nama']='Penetapan';
				$data11_a['proses_id']=20;
				$data11_a['proses_nama']='Penetapan Majelis Hakim/Hakim';
				$data11_a['tanggal']=$row['penetapan_majelis_hakim'];
				$data11_a['diinput_oleh']='System';
				$data11_a['diinput_tanggal']=date("Y-m-d H:i:s", time());
				$this->patching->replace_data('perkara_proses',$data11_a);
			}
			}

			if(!empty($row['penetapan_panitera_pengganti'])){
			$update_perkara1 ="UPDATE perkara SET 
							  tahapan_terakhir_id=12,
							  tahapan_terakhir_text='Penetapan',
							  proses_terakhir_id=30,
							  proses_terakhir_text='Penunjukan Panitera Pengganti'
							  WHERE perkara_id=".$row['perkara_id']."";
			
			if($this->patching->exe_script($update_perkara1)){
				$data11_b['perkara_id']=$row['perkara_id'];
				$data11_b['tahapan_id']=12;
				$data11_b['tahapan_nama']='Penetapan';
				$data11_b['proses_id']=30;
				$data11_b['proses_nama']='Penunjukan Panitera Pengganti';
				$data11_b['tanggal']=$row['penetapan_panitera_pengganti'];
				$data11_b['diinput_oleh']='System';
				$data11_b['diinput_tanggal']=date("Y-m-d H:i:s", time());
				$this->patching->replace_data('perkara_proses',$data11_b);
			}
			}

			if(!empty($row['penetapan_hari_sidang'])){
			$update_perkara2 ="UPDATE perkara SET 
							  tahapan_terakhir_id=12,
							  tahapan_terakhir_text='Penetapan',
							  proses_terakhir_id=80,
							  proses_terakhir_text='Penetapan Hari Sidang Pertama'
							  WHERE perkara_id=".$row['perkara_id']."";
			
			if($this->patching->exe_script($update_perkara2)){
				$data11_c['perkara_id']=$row['perkara_id'];
				$data11_c['tahapan_id']=12;
				$data11_c['tahapan_nama']='Penetapan';
				$data11_c['proses_id']=80;
				$data11_c['proses_nama']='Penetapan Hari Sidang Pertama';
				$data11_c['tanggal']=$row['penetapan_hari_sidang'];
				$data11_c['diinput_oleh']='System';
				$data11_c['diinput_tanggal']=date("Y-m-d H:i:s", time());				
				$this->patching->replace_data('perkara_proses',$data11_c);
			}
			}
			$my_perkara11=TRUE;
		}		
		
		if($my_perkara11){

			$this->nativesession->set('update_progress', 11); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query $my_perkara11'));
			return;
		}
		}

		//--hakim_pn
		$ms_perkara12 = "IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'v_hakim_pn') BEGIN
    					DROP VIEW dbo.v_hakim_pn
						END";
		
		if(exe_sqlserver($conn,$ms_perkara12)){
			$this->nativesession->set('update_progress', 12); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara12.'));
			return;
		}

		$ms_perkara12a= "CREATE VIEW v_hakim_pn AS						
						SELECT
							MHKM_ID						AS id,
							1							as status_hakim_id,
							MHKM_NIP					as nip,
							MHKM_NAMA					as nama,
							MHKM_PANGKAT+' '+MHKM_NAMA	as nama_gelar,
							'Y'							as aktif
						FROM MS_HAKIM where MHKM_NAMA is not null
					";
		
		if(exe_sqlserver($conn,$ms_perkara12a)){
			$this->nativesession->set('update_progress', 12); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara12a.'));
			return;
		}


		$ms_perkara12b = "SELECT * from v_hakim_pn";
		$ms_perkara12b_exe = exe_sqlserver($conn,$ms_perkara12b);
		$jml_data = odbc_num_rows($ms_perkara12b_exe);
		if($jml_data>0){
				
		while($row = odbc_fetch_array($ms_perkara12b_exe)){		
			//$this->load->helper('text');
			$data12['id']=$row['id'];
			$data12['status_hakim_id']=$row['status_hakim_id'];
			$data12['nip']=$row['nip'];
			$data12['nama']=$row['nama'];
			$data12['nama_gelar']=$row['nama_gelar'];
			$data12['aktif']=$row['aktif'];		
			$data12['diinput_oleh']='System';
			$data12['diinput_tanggal']=date("Y-m-d H:i:s", time());
			$my_perkara12 = $this->patching->replace_data('hakim_pn',$data12);
		}		
		
		if($my_perkara12){
			$this->nativesession->set('update_progress', 12); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query $my_perkara12'));
			return;
		}
		}

		//-- perkara_hakim_pn		
		$ms_perkara13 = "IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'v_perkara_hakim_pn') BEGIN
    					DROP VIEW dbo.v_perkara_hakim_pn
						END";
		
		if(exe_sqlserver($conn,$ms_perkara13)){
			$this->nativesession->set('update_progress', 13); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara13.'));
			return;
		}

		$ms_perkara13a= "CREATE VIEW v_perkara_hakim_pn AS						
						SELECT
								ROW_NUMBER() OVER (ORDER BY dm.DATA_ID) AS id,
								dm.DREG_ID				AS perkara_id,
								10						AS tahapan_id,
								(SELECT convert(varchar(10), dm.DMAJ_TGL_TAPKIM, 120)) as tanggal_penetapan,
								(RTRIM(dr.NO_PERK)+'/PEN-MH/'+cast(DATEPART(YEAR,dm.DMAJ_TGL_TAPKIM) as char(4))+
								cast((select MSET_VALUE from MS_SETTING where MSET_KEY='KODENOPERK' AND MSET_TYPE=1 AND MSET_TYPE IS NOT NULL) 
								COLLATE DATABASE_DEFAULT as varchar(50))) as nomor_sk_penetapan,

								URUTAN				as urutan,
								JABATAN_HAKIM_ID	as jabatan_hakim_id,
								JABATAN_HAKIM_NAMA	as jabatan_hakim_nama,
								HAKIM_ID			as hakim_id,
								(select MHKM_NIP from MS_HAKIM where MHKM_ID=HAKIM_ID) AS hakim_nip,
								(select MHKM_NAMA from MS_HAKIM where MHKM_ID=HAKIM_ID) AS hakim_nama,
								'Y'					as aktif
						from DATA_MAJELIS as dm
						CROSS APPLY
						(
						  select '1','1',
							case 
								when dm.DMAJ_ANGGOTA1_ID is null and dm.DMAJ_ANGGOTA2_ID is null then 
								'Hakim Tunggal'
								else
								'Hakim Ketua'
							end
						, dm.DMAJ_KETUA_ID union all
						  select '2','2','Hakim Anggota', dm.DMAJ_ANGGOTA1_ID union all
						  select '3','2','Hakim Anggota', dm.DMAJ_ANGGOTA2_ID 
						) c (URUTAN, JABATAN_HAKIM_ID,JABATAN_HAKIM_NAMA,HAKIM_ID)
						LEFT JOIN DATA_REGISTER as dr on dr.DATA_ID=dm.DREG_ID
						WHERE HAKIM_ID IS NOT NULL;

					";
		
		if(exe_sqlserver($conn,$ms_perkara13a)){
			$this->nativesession->set('update_progress', 13); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara13a.'));
			return;
		}


		$ms_perkara13b = "SELECT * from v_perkara_hakim_pn where hakim_nama is not null and perkara_id in (".$cek_perkara_id.")";
		$ms_perkara13b_exe = exe_sqlserver($conn,$ms_perkara13b);
		$jml_data = odbc_num_rows($ms_perkara13b_exe);
		if($jml_data>0){
				
		while($row = odbc_fetch_array($ms_perkara13b_exe)){		
			//$this->load->helper('text');
			$data13['id']=$row['id'];
			$data13['perkara_id']=$row['perkara_id'];
			$data13['tahapan_id']=$row['tahapan_id'];
			$data13['tanggal_penetapan']=$row['tanggal_penetapan'];
			$data13['nomor_sk_penetapan']=$row['nomor_sk_penetapan'];
			$data13['urutan']=$row['urutan'];
			$data13['jabatan_hakim_id']=$row['jabatan_hakim_id'];
			$data13['jabatan_hakim_nama']=$row['jabatan_hakim_nama'];
			$data13['hakim_id']=$row['hakim_id'];
			$data13['hakim_nip']=$row['hakim_nip'];
			$data13['hakim_nama']=$row['hakim_nama'];
			$data13['aktif']=$row['aktif'];
			$data13['diinput_oleh']='System';
			$data13['diinput_tanggal']=date("Y-m-d H:i:s", time());
			
			$my_perkara13 = $this->patching->replace_data('perkara_hakim_pn',$data13);
		}		
		
		if($my_perkara13){
			$this->nativesession->set('update_progress', 13); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query $my_perkara13'));
			return;
		}
		}

		//--panitera_pn
		$ms_perkara14 = "IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'v_panitera_pn') BEGIN
    					DROP VIEW dbo.v_panitera_pn
						END";
		
		if(exe_sqlserver($conn,$ms_perkara14)){
			$this->nativesession->set('update_progress', 18); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara14.'));
			return;
		}

		$ms_perkara14a= "CREATE VIEW v_panitera_pn AS						
						SELECT
							MPAN_ID						AS id,
							MPAN_NIP					as nip,
							MPAN_NAMA					as nama,
							MPAN_PANGKAT+' '+MPAN_NAMA	as nama_gelar,
							'Y'							as aktif
						FROM MS_PANITERA
					";
		
		if(exe_sqlserver($conn,$ms_perkara14a)){
			$this->nativesession->set('update_progress', 20); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara14a.'));
			return;
		}


		$ms_perkara14b = "SELECT * from v_panitera_pn";
		$ms_perkara14b_exe = exe_sqlserver($conn,$ms_perkara14b);
		$jml_data = odbc_num_rows($ms_perkara14b_exe);
		if($jml_data>0){
				
		while($row = odbc_fetch_array($ms_perkara14b_exe)){		
			//$this->load->helper('text');
			$data14['id']=$row['id'];
			$data14['nip']=$row['nip'];
			$data14['nama']=$row['nama'];
			$data14['nama_gelar']=$row['nama_gelar'];
			$data14['aktif']=$row['aktif'];		
			$data14['diinput_oleh']='System';
			$data14['diinput_tanggal']=date("Y-m-d H:i:s", time());

			$my_perkara14 = $this->patching->replace_data('panitera_pn',$data14);
		}		
		
		if($my_perkara14){
			$this->nativesession->set('update_progress', 25); 
			session_write_close();
			session_start();
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query $my_perkara14'));
			return;
		}
		}

		//-- perkara_panitera_pn		
		$ms_perkara15 = "IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'v_perkara_panitera_pn') BEGIN
    					DROP VIEW dbo.v_perkara_panitera_pn
						END";
		
		if(exe_sqlserver($conn,$ms_perkara15)){
			$this->nativesession->set('update_progress', 27); 
			session_write_close();
			session_start();

		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara15.'));
			return;
		}

		$ms_perkara15a = " CREATE VIEW v_perkara_panitera_pn AS						
							SELECT 
							ROW_NUMBER() OVER( ORDER BY dm.DATA_ID) as id,  
							dm.DREG_ID as perkara_id, 
							10 as tahapan_id,  
							(SELECT convert(varchar(10), dm.DMAJ_TGL_TAPKIM, 120)) as tanggal_penetapan,

							+'TAP/'+''+(RTRIM(dr.NO_PERK)+'-'+cast((SELECT MKOD_KODE FROM MS_KODE WHERE dr.KODE_ID = MS_KODE.MKOD_ID) COLLATE DATABASE_DEFAULT as varchar(50))+
								'/'+cast((select MSET_VALUE from MS_SETTING where MSET_KEY='KODENOPERK') COLLATE DATABASE_DEFAULT as varchar(50))+
								'/'+cast((SELECT MMAT_NAMA FROM MS_MATRA WHERE dr.MATRA_ID =MS_MATRA.MMAT_ID) COLLATE DATABASE_DEFAULT as varchar(50))+
								(case 
									when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=1 then +'/I/'
									when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=2 then +'/II/'
									when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=3 then +'/III/'
									when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=4 then +'/IV/'
									when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=5 then +'/V/'
									when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=6 then +'/VI/'
									when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=7 then +'/VII/'
									when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=8 then +'/VIII/'
									when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=9 then +'/IX/'
									when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=10 then +'/X/'
									when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=11 then +'/XI/'
									when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=12 then +'/XII/'
								end)
								+'/'+cast(DATEPART(YEAR,dr.DREG_TGL_DAFTAR) as char(4))) as nomor_sk_penetapan, 
							1 as urutan, 
							dm.DMAJ_PANITERA_ID		as panitera_id, 
							'' as panitera_kode,  
							CAST(msp.MPAN_NIP AS VARCHAR(20)) as panitera_nip,  
							msp.MPAN_PANGKAT + ' '+ msp.MPAN_NAMA as panitera_nama,  
							'' as diganti_oleh_id,  
							'Y' as aktif

							FROM DATA_MAJELIS as dm
							LEFT JOIN MS_PANITERA as msp on msp.MPAN_ID = dm.DMAJ_PANITERA_ID 
							LEFT JOIN DATA_REGISTER as dr on dm.DREG_ID=dr.DATA_ID
												";
		
		if(exe_sqlserver($conn,$ms_perkara15a)){
			$this->nativesession->set('update_progress', 30); 
			session_write_close();
			session_start();

		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara13a.'));
			return;
		}


		$ms_perkara15b = "SELECT * from v_perkara_panitera_pn where panitera_nama is not null and perkara_id in (".$cek_perkara_id.")";
		$ms_perkara15b_exe = exe_sqlserver($conn,$ms_perkara15b);
		$jml_data = odbc_num_rows($ms_perkara15b_exe);
		if($jml_data>0){
		
		while($row = odbc_fetch_array($ms_perkara15b_exe)){		
			//$this->load->helper('text');
			$data15['id']=$row['id'];
			$data15['perkara_id']=$row['perkara_id'];
			$data15['tahapan_id']=$row['tahapan_id'];
			$data15['tanggal_penetapan']=$row['tanggal_penetapan'];
			$data15['nomor_sk_penetapan']=$row['nomor_sk_penetapan'];
			$data15['urutan']=$row['urutan'];
			$data15['panitera_id']=$row['panitera_id'];
			//$data15['panitera_nip']=ascii_to_entities($row['[panitera_nip]']);
			$data15['panitera_nama']=$row['panitera_nama'];
			$data15['aktif']=$row['aktif'];
			$data15['diinput_oleh']='System';
			$data15['diinput_tanggal']=date("Y-m-d H:i:s", time());
			
			$my_perkara15 = $this->patching->replace_data('perkara_panitera_pn',$data15);
		}		
		
		if($my_perkara15){
			$this->nativesession->set('update_progress', 35); 
			session_write_close();
			session_start();

		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query $my_perkara15'));
			return;
		}
		}

		//--perkara_jadwal_sidang
		$ms_perkara16 = "IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'v_perkara_jadwal_sidang') BEGIN
    					DROP VIEW dbo.v_perkara_jadwal_sidang
						END";
		
		if(exe_sqlserver($conn,$ms_perkara16)){
			$this->nativesession->set('update_progress', 38); 
			session_write_close();
			session_start();

		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara16.'));
			return;
		}

		$ms_perkara16a = "  CREATE VIEW v_perkara_jadwal_sidang AS						
							SELECT 
								ROW_NUMBER() OVER( ORDER BY DATA_ID)	as id, 
								DREG_ID									as perkara_id,  
								'T'										as verzet, 
								'T'										as keberatan, 
								ROW_NUMBER()OVER(PARTITION BY DREG_ID ORDER BY convert(varchar(10), DSID_TANGGAL, 120)) as urutan,  
								(SELECT convert(varchar(10), DSID_TANGGAL, 120)) as tanggal_sidang,  
								(CASE
									WHEN (SELECT SUBSTRING(DSID_PUKUL_MULAI,1,1)) = 'p' 
								THEN
								'09:00:00' 
								WHEN (SELECT SUBSTRING(DSID_PUKUL_MULAI,2,1)) = '.' 
								THEN
								'09:00:00'
								WHEN (SELECT SUBSTRING(DSID_PUKUL_MULAI,4,1)) = '.' 
								THEN
								'09:00:00'
								WHEN (SELECT SUBSTRING(DSID_PUKUL_MULAI,5,1)) = 'w' 
								THEN
								'09:00:00'
								WHEN (SELECT SUBSTRING(DSID_PUKUL_MULAI,1,1)) = 's' 
								THEN
								'09:00:00'
								WHEN DSID_PUKUL_MULAI IS NOT NULL and len(DSID_PUKUL_MULAI)>=5 and len(LEFT(DSID_PUKUL_MULAI,2)+':'+(SUBSTRING(DSID_PUKUL_MULAI, 4,2))+':00')=8 
									THEN replace((LEFT(DSID_PUKUL_MULAI,2)+':'+(SUBSTRING(DSID_PUKUL_MULAI, 4,2))+':00'),' ','0')	
									ELSE
										'00:00:00'
								END)									as jam_sidang, 
								(CASE 
								WHEN (SELECT SUBSTRING(DSID_PUKUL_SELESAI,1,1)) = 'p' 
								THEN
								'09:00:00' 
								WHEN (SELECT SUBSTRING(DSID_PUKUL_SELESAI,2,1)) = '.' 
								THEN
								'09:00:00'
								WHEN (SELECT SUBSTRING(DSID_PUKUL_SELESAI,4,1)) = '.' 
								THEN
								'09:00:00'
								WHEN (SELECT SUBSTRING(DSID_PUKUL_SELESAI,5,1)) = 'w' 
								THEN
								'09:00:00'
								WHEN (SELECT SUBSTRING(DSID_PUKUL_SELESAI,1,1)) = 's' 
								THEN
								'09:00:00' 
									WHEN DSID_PUKUL_SELESAI IS NOT NULL and len(DSID_PUKUL_SELESAI)>=5 and len(LEFT(DSID_PUKUL_SELESAI,2)+':'+(SUBSTRING(DSID_PUKUL_SELESAI, 4,2))+':00')=8 
									THEN replace((LEFT(DSID_PUKUL_SELESAI,2)+':'+(SUBSTRING(DSID_PUKUL_SELESAI, 4,2))+':00'),' ','0')
									ELSE
										'00:00:00' 
								END)									as sampai_jam,   
								''										as agenda_id,  
								DSID_AGENDA								as agenda, 
								''										as ruangan_id, 
								''										as ruangan, 
								'T'										as sidang_keliling, 
								''										as dihadiri_oleh, 
								''										as ditunda, 
								''										as alasan_ditunda, 
								1										as sidang_ditempat
							FROM DATA_SIDANG WHERE DSID_TANGGAL IS NOT NULL							";
		
		if(exe_sqlserver($conn,$ms_perkara16a)){
			$this->nativesession->set('update_progress', 40); 
			session_write_close();
			session_start();

		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara16a.'));
			return;
		}


		$ms_perkara16b = "SELECT * from v_perkara_jadwal_sidang where tanggal_sidang is not null and perkara_id in (".$cek_perkara_id.")";
		$ms_perkara16b_exe = exe_sqlserver($conn,$ms_perkara16b);
		$jml_data = odbc_num_rows($ms_perkara16b_exe);
		if($jml_data>0){
				
		while($row = odbc_fetch_array($ms_perkara16b_exe)){		
			//$this->load->helper('text');
			$data16['id']=$row['id'];
			$data16['perkara_id']=$row['perkara_id'];
			$data16['verzet']=$row['verzet'];
			$data16['keberatan']=$row['keberatan'];
			$data16['urutan']=$row['urutan'];
			$data16['tanggal_sidang']=$row['tanggal_sidang'];
			$data16['jam_sidang']='09:00'; 
			$data16['sampai_jam']=$row['sampai_jam'];
			$data16['agenda']=$row['agenda'];
			$data16['sidang_keliling']=$row['sidang_keliling'];
			$data16['alasan_ditunda']=$row['alasan_ditunda'];
			$data16['sidang_ditempat']=$row['sidang_ditempat'];
			$data16['diinput_oleh']='System';
			$data16['diinput_tanggal']=date("Y-m-d H:i:s", time());

			$this->patching->replace_data('perkara_jadwal_sidang',$data16);

			if(!empty($row['tanggal_sidang'])){
			$update_perkara_sdg ="UPDATE perkara SET 
							  	  tahapan_terakhir_id=14,
							 	  tahapan_terakhir_text='Persidangan',
							 	  proses_terakhir_id=200,
							 	  proses_terakhir_text='Persidangan'
							 	  WHERE perkara_id=".$row['perkara_id']."";
			
			if($this->patching->exe_script($update_perkara_sdg)){
				$data11_s['perkara_id']=$row['perkara_id'];
				$data11_s['tahapan_id']=14;
				$data11_s['tahapan_nama']='Persidangan';
				$data11_s['proses_id']=200;
				$data11_s['proses_nama']='Persidangan';
				$data11_s['tanggal']=$row['tanggal_sidang'];
				$data11_s['diinput_oleh']='System';
				$data11_s['diinput_tanggal']=date("Y-m-d H:i:s", time());

				$this->patching->replace_data('perkara_proses',$data11_s);
			}
			}
			$my_perkara16=TRUE;
		}		
		
		if($my_perkara16){			
			$this->nativesession->set('update_progress', 43); 
			session_write_close();
			session_start();

		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query $my_perkara16'));
			return;
		}
		}

		//-- perkara_penuntutan		
		$ms_perkara17 = "IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'v_perkara_penuntutan') BEGIN
    					DROP VIEW dbo.v_perkara_penuntutan
						END";
		
		if(exe_sqlserver($conn,$ms_perkara17)){
			$this->nativesession->set('update_progress', 51); 
			session_write_close();
			session_start();

		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara17.'));
			return;
		}

		$ms_perkara17a = "  CREATE VIEW v_perkara_penuntutan AS						
							SELECT 
								DREG_ID				as perkara_id,
								convert(varchar(10), DTUN_TGL, 120) as tanggal_penuntutan, 
								DTUN_ISI			as isi_penuntutan, 
								DTUN_PASAL			AS pasal_penuntutan, 
								DTUN_BB				AS bb_penuntutan,
								DTUN_STATUS_TER		AS status_terdakwa, 
								DTUN_TIND_PID		AS tindakan_pidana
							FROM DATA_TUNTUTAN  					
						";
		
		if(exe_sqlserver($conn,$ms_perkara17a)){
			$this->nativesession->set('update_progress', 54); 
			session_write_close();
			session_start();

		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara17a.'));
			return;
		}


		$ms_perkara17b = "SELECT * from v_perkara_penuntutan where tanggal_penuntutan is not null and perkara_id in (".$cek_perkara_id.")";
		$ms_perkara17b_exe = exe_sqlserver($conn,$ms_perkara17b);

		$jml_data = odbc_num_rows($ms_perkara17b_exe);
		if($jml_data>0){		
		
		while($row = odbc_fetch_array($ms_perkara17b_exe)){		
			//$this->load->helper('text');
			$data17['perkara_id']=$row['perkara_id'];
			$data17['tanggal_penuntutan']=$row['tanggal_penuntutan'];
			$tuntutan_reg=ascii_to_entities($row['isi_penuntutan']);
			$tuntutan=str_replace(array("\pard","\par"), array("</br>","</br>"), $tuntutan_reg);
			$tuntutan_br=preg_replace('(\'"{\\*?\\\\.+(;})|\\s?\\\\[A-Za-z0-9]+|\\s?{\\s?\\\\[A-Za-z0-9]+\\s?|\\s?}\\s?"\')','',$tuntutan, -1, $count);
			$cari=array("Courier New;}","Arial Narrow;}","Arial Narrow;}","Times New Roman;}","Calibri;}","Calibri;}","Times New Roman;}};}","Normal;}","{\* Default Paragraph Font;}","Body Text;}","{\* Body Text Text;}","List Paragraph;}","No Spacing;}}{\*","-720\'02\'00.;}\'01;}}","-360\'02\'01.;}\'01;}}","-180\'02\'02.;}\'01;}}","-360\'02\'03.;}\'01;}}","-360\'02\'04.;}\'01;}}","-180\'02\'05.;}\'01;}}","-360\'02\'06.;}\'01;}}","-360\'02\'07.;}\'01;}}","-180\'02\'08.;}\'01;}}","\'02\'00.;}\'01;}}","-360\'02\'07.;}","Arial;}","};;}","Body Text Indent 3;}{\* Body Text Indent 3 Text;}","No Spacing;}}","Wingdings;}","Symbol;}};;}","header;}{\* header Text;}-240","Body Text Indent 2;}{\* Body Text Indent 2 Text;}","Body Text Indent;}{\* Body Text Indent Text;}","Body Text,Char;}{\* Body Text,Char Text;}","{\* page number;}","{\* Strong;}","Body Text,Char Char,Char Char1,Char Char Char,Body Text Char1,Char Char2,Body Text Char Char,Char Char1 Char;}{\* Body Text,Char Char,Char Char1,Char Char Char,Body Text Char1,Char Char2,Body Text Char Char,Char Char1 Char Text;}}","};}","Symbol;}","-360\'01-;};}}","-360\'01o;};}}","-360\'01 ?;};}}","-360\'01o;};}}","-360\'02\'06.;}\'01;}","Body Text 2;}","{\* Body Text 2 Text;}-3420 -360 }","};;;}"," {\* Body Text 2 Text;}}","-3420 }","header;}","{\* header Text;}}","{\* \'02\'00);}\'01;}}","{\* } }","}{\*","-705","      }","}","{\* Body Text 2 Text;",";;;;","{\* Body Text 2 Text;","\'02\'00);\'01;","{\*","\'02\'00.;\'0","-240","{\* header Text; ","header Text;","Body Text,","Char","Char;","Char","Text;","-360\'02\'02);\'01;","-360\'02\'08.;\'01;","-1080\'01\'01;\'01;","-360\'02\'06.;{","-1080","heading 1;","heading 1 Text;","{\* header Text;","{\* Body Text 2 Text;","Subtitle;","Subtitle Text;","Plain Text;","Plain Text Text;","footer;","footer Text;","Block Text;","-1080","-285","-360\'02\'02.;\'01;","heading 7;","heading 7 -360","-420","-360\'02\'05.;\'01;",", 1,  ,Body Text 1, 2,Body Text  , 1 ;  , 1,  ,Body Text 1, 2,Body Text  , 1","-2160","-720\'01\'00;\'01;","-690\'02\'01.;\'01;","-330",",, ;  ,,  -720  No Spacing;","-180{");
			$ganti=array('','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
			$tuntutan_clean=str_replace($cari, $ganti, $tuntutan_br);
			$data17['isi_penuntutan']=$tuntutan_clean;

			$data17['diinput_oleh']='System';
			$data17['diinput_tanggal']=date("Y-m-d H:i:s", time());

			$my_perkara17 = $this->patching->replace_data('perkara_penuntutan',$data17);
		}		
		
		if($my_perkara17){
			$this->nativesession->set('update_progress', 57); 
			session_write_close();
			session_start();

		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query $my_perkara17'));
			return;
		}
		}

		//-- perkara_putusan		
		$ms_perkara18 = "IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'v_perkara_putusan') BEGIN
    					DROP VIEW dbo.v_perkara_putusan
						END";
		
		if(exe_sqlserver($conn,$ms_perkara18)){
			$this->nativesession->set('update_progress', 60); 
			session_write_close();
			session_start(); 

		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara18.'));
			return;
		}

		$ms_perkara18a = "  CREATE VIEW v_perkara_putusan AS						
							SELECT 
								dp.DREG_ID					as perkara_id,
								CONVERT(CHAR(10), dp.DPUT_TGL, 120) AS tanggal_putusan,
								dp.DPUT_AMAR				as amar_putusan,
								dp.DPUT_PASAL				as pasal_putusan,
								dp.DPUT_BB					as bb_putusan,
								dp.DPUT_SIKAP_ODT			as sikap_odt,
								dp.DPUT_KET					aS keterangan,
								pttd.PUTUSAN_TERDAKWA		as putusan_terdakwa									
							FROM DATA_PUTUSAN as dp
							LEFT JOIN (
							SELECT 
									DISTINCT m.DREG_ID,
									(SELECT STUFF(
												(SELECT '</br>'+ PUTUSAN_TERDAKWA
												 FROM ( SELECT 
															  dt.DREG_ID,
															  (case 
																	when dpt.DPUT_TAMBAHAN IS NOT NULL then
																	(CAST(dpt.DPUT_POKOK AS VARCHAR(8000))+'Tambahan :'+CAST(dpt.DPUT_TAMBAHAN AS VARCHAR(8000)))+', dengan biaya perkara :'+CAST(dpt.DPUT_BIAYA AS CHAR(20))
																	else
																	CAST(dpt.DPUT_POKOK AS VARCHAR(8000))
															  end) as PUTUSAN_TERDAKWA
														FROM DATA_PUT_TER as dpt
														LEFT JOIN DATA_TERDAKWA as dt on dt.DATA_ID=dpt.KEY_ID
														WHERE dpt.DPUT_POKOK IS NOT NULL) md 
														WHERE md.DREG_ID = m.DREG_ID
													   FOR XML PATH(''), TYPE).value('.', 'NVARCHAR(MAX)'), 1, 5, '') 
													) as PUTUSAN_TERDAKWA

								FROM ( SELECT 
												  dt.DREG_ID,
												  (case 
														when dpt.DPUT_TAMBAHAN IS NOT NULL then
														(CAST(dpt.DPUT_POKOK AS VARCHAR(8000))+'Tambahan :'+CAST(dpt.DPUT_TAMBAHAN AS VARCHAR(8000)))+', dengan biaya perkara :'+CAST(dpt.DPUT_BIAYA AS CHAR(20))
														else
														CAST(dpt.DPUT_POKOK AS VARCHAR(8000))
												  end) as PUTUSAN_TERDAKWA
											FROM DATA_PUT_TER as dpt
											LEFT JOIN DATA_TERDAKWA as dt on dt.DATA_ID=dpt.KEY_ID
											WHERE dpt.DPUT_POKOK IS NOT NULL
										) as m

							) as pttd on dp.DREG_ID=pttd.DREG_ID
							where dp.DPUT_TGL is not null						
							";
		
		if(exe_sqlserver($conn,$ms_perkara18a)){
			$this->nativesession->set('update_progress', 63); 
			session_write_close();
			session_start();

		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara18a.'));
			return;
		}


		$ms_perkara18b = "SELECT * from v_perkara_putusan where tanggal_putusan is not null and perkara_id in (".$cek_perkara_id.")";
		$ms_perkara18b_exe = exe_sqlserver($conn,$ms_perkara18b);

		$jml_data = odbc_num_rows($ms_perkara18b_exe);
		if($jml_data>0){
		
		while($row = odbc_fetch_array($ms_perkara18b_exe)){		
			//$this->load->helper('text');
			$data18['perkara_id']=$row['perkara_id'];
			$data18['tanggal_putusan']=$row['tanggal_putusan'];
			$pasal=str_replace(array("\pard","\par"), array("</br>","</br>"), ascii_to_entities($row['putusan_terdakwa']));
			$amar=str_replace(array("\pard","\par"), array("</br>","</br>"), ascii_to_entities($row['amar_putusan']));;
			$amar_putusan=$pasal." ".$amar;
			$amar_putusan_br=preg_replace('(\'"{\\*?\\\\.+(;})|\\s?\\\\[A-Za-z0-9]+|\\s?{\\s?\\\\[A-Za-z0-9]+\\s?|\\s?}\\s?"\')','',$amar_putusan, -1, $count);
			$cari=array("Courier New;}","Arial Narrow;}","Arial Narrow;}","Times New Roman;}","Calibri;}","Calibri;}","Times New Roman;}};}","Normal;}","{\* Default Paragraph Font;}","Body Text;}","{\* Body Text Text;}","List Paragraph;}","No Spacing;}}{\*","-720\'02\'00.;}\'01;}}","-360\'02\'01.;}\'01;}}","-180\'02\'02.;}\'01;}}","-360\'02\'03.;}\'01;}}","-360\'02\'04.;}\'01;}}","-180\'02\'05.;}\'01;}}","-360\'02\'06.;}\'01;}}","-360\'02\'07.;}\'01;}}","-180\'02\'08.;}\'01;}}","\'02\'00.;}\'01;}}","-360\'02\'07.;}","Arial;}","};;}","Body Text Indent 3;}{\* Body Text Indent 3 Text;}","No Spacing;}}","Wingdings;}","Symbol;}};;}","header;}{\* header Text;}-240","Body Text Indent 2;}{\* Body Text Indent 2 Text;}","Body Text Indent;}{\* Body Text Indent Text;}","Body Text,Char;}{\* Body Text,Char Text;}","{\* page number;}","{\* Strong;}","Body Text,Char Char,Char Char1,Char Char Char,Body Text Char1,Char Char2,Body Text Char Char,Char Char1 Char;}{\* Body Text,Char Char,Char Char1,Char Char Char,Body Text Char1,Char Char2,Body Text Char Char,Char Char1 Char Text;}}","};}","Symbol;}","-360\'01-;};}}","-360\'01o;};}}","-360\'01 ?;};}}","-360\'01o;};}}","-360\'02\'06.;}\'01;}","Body Text 2;}","{\* Body Text 2 Text;}-3420 -360 }","};;;}"," {\* Body Text 2 Text;}}","-3420 }","header;}","{\* header Text;}}","{\* \'02\'00);}\'01;}}","{\* } }","}{\*","-705","      }","}","{\* Body Text 2 Text;",";;;;","{\* Body Text 2 Text;","\'02\'00);\'01;","{\*","\'02\'00.;\'0","-240","{\* header Text; ","header Text;","Body Text,","Char","Char;","Char","Text;","-360\'02\'02);\'01;","-360\'02\'08.;\'01;","-1080\'01\'01;\'01;","-360\'02\'06.;{","-1080","heading 1;","heading 1 Text;","{\* header Text;","{\* Body Text 2 Text;","Subtitle;","Subtitle Text;","Plain Text;","Plain Text Text;","footer;","footer Text;","Block Text;","-1080","-285","-360\'02\'02.;\'01;","heading 7;","heading 7 -360","-420","-360\'02\'05.;\'01;",", 1,  ,Body Text 1, 2,Body Text  , 1 ;  , 1,  ,Body Text 1, 2,Body Text  , 1","-2160","-720\'01\'00;\'01;","-690\'02\'01.;\'01;","-330",",, ;  ,,  -720  No Spacing;","-180{");
			$ganti=array('','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
			$putusan_clean=str_replace($cari, $ganti, $amar_putusan_br);
			$data18['amar_putusan']=$putusan_clean;
			$data18['diinput_oleh']='System';
			$data18['diinput_tanggal']=date("Y-m-d H:i:s", time());

			$this->patching->replace_data('perkara_putusan',$data18);

			if(!empty($row['tanggal_putusan'])){
			$update_perkara_p ="UPDATE perkara SET 
							  	  tahapan_terakhir_id=15,
							 	  tahapan_terakhir_text='Putusan',
							 	  proses_terakhir_id=210,
							 	  proses_terakhir_text='Putusan'
							 	  WHERE perkara_id=".$row['perkara_id']."";
			
			if($this->patching->exe_script($update_perkara_p)){
				$data11_p['perkara_id']=$row['perkara_id'];
				$data11_p['tahapan_id']=15;
				$data11_p['tahapan_nama']='Putusan';
				$data11_p['proses_id']=210;
				$data11_p['proses_nama']='Putusan';
				$data11_p['tanggal']=$row['tanggal_putusan'];
				$data11_p['diinput_oleh']='System';
				$data11_p['diinput_tanggal']=date("Y-m-d H:i:s", time());

				$this->patching->replace_data('perkara_proses',$data11_p);
			}
			}
			$my_perkara18=TRUE;
		}		
		
		if($my_perkara18){
			$this->nativesession->set('update_progress', 65); 
			session_write_close();
			session_start();

		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query $my_perkara18'));
			return;
		}
		}

		//--perkara_putusan_sela
/*		$ms_perkara19 = "IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'v_perkara_putusan_sela') BEGIN
    					DROP VIEW dbo.v_perkara_putusan_sela
						END";
		
		if(exe_sqlserver($conn,$ms_perkara19)){
			$this->nativesession->set('update_progress', 70); 
			session_write_close();
			session_start();

		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara19.'));
			return;
		}

		$ms_perkara19a = "  CREATE VIEW v_perkara_putusan_sela AS						
							SELECT 
								ROW_NUMBER() OVER( ORDER BY DATA_ID)	as id, 
								DREG_ID									as perkara_id,
								CONVERT(CHAR(10), DPUT_TGL, 120)		as tanggal_putusan_sela,
								DPUT_AMAR								as amar_sela  

							FROM DATA_PUTUSAN_SELA WHERE DPUT_TGL IS NOT NULL					
							";
		
		if(exe_sqlserver($conn,$ms_perkara19a)){
			$this->nativesession->set('update_progress', 75); 
			session_write_close();
			session_start();

		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara19a.'));
			return;
		}


		$ms_perkara19b = "SELECT * from v_perkara_putusan_sela where tanggal_putusan_sela is not null and perkara_id in (".$cek_perkara_id.")";
		$ms_perkara19b_exe = exe_sqlserver($conn,$ms_perkara19b);
		
		$jml_data = odbc_num_rows($ms_perkara19b_exe);
		if($jml_data>0){
		while($row = odbc_fetch_array($ms_perkara19b_exe)){		
			//$this->load->helper('text');
			$data19['putusansela_id']=$row['id'];
			$data19['perkara_id']=$row['perkara_id'];
			$data19['tanggal_putusan_sela']=$row['tanggal_putusan_sela'];
			$data19['amar_sela']=ascii_to_entities($row['amar_sela']);
			$data19['diinput_oleh']='System';
			$data19['diinput_tanggal']=date("Y-m-d H:i:s", time());

			$my_perkara19 = $this->patching->replace_data('perkara_putusan_sela',$data19);
		}		
		
		if($my_perkara19){
			$this->nativesession->set('update_progress', 77); 
			session_write_close();
			session_start();

		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query $my_perkara19'));
			return;
		}
		}
*/
		//--perkara_barang_bukti
		$ms_perkara20 = "IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'v_perkara_barang_bukti') BEGIN
    					DROP VIEW dbo.v_perkara_barang_bukti
						END";
		
		if(exe_sqlserver($conn,$ms_perkara20)){
			$this->nativesession->set('update_progress', 80); 
			session_write_close();
			session_start();

		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara20.'));
			return;
		}

		$ms_perkara20a="CREATE VIEW v_perkara_barang_bukti AS						
						SELECT 
							ROW_NUMBER() OVER( ORDER BY DATA_ID)	as id, 
							DATA_ID									as perkara_id,
							(RTRIM(NO_PERK)+'-'+cast((SELECT MKOD_KODE FROM MS_KODE WHERE KODE_ID =MS_KODE.MKOD_ID) COLLATE DATABASE_DEFAULT as varchar(50))+
							'/'+cast((select MSET_VALUE from MS_SETTING where MSET_KEY='KODENOPERK') COLLATE DATABASE_DEFAULT as varchar(50))+
							'/'+cast((SELECT MMAT_NAMA FROM MS_MATRA WHERE MATRA_ID =MS_MATRA.MMAT_ID) COLLATE DATABASE_DEFAULT as varchar(50))+
							(case 
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=1 then +'/I/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=2 then +'/II/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=3 then +'/III/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=4 then +'/IV/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=5 then +'/V/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=6 then +'/VI/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=7 then +'/VII/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=8 then +'/VIII/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=9 then +'/IX/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=10 then +'/X/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=11 then +'/XI/'
								when cast(DATEPART(MONTH,DREG_TGL_DAFTAR) as char(2))=12 then +'/XII/'
							end)
							+'/'+cast(DATEPART(YEAR,DREG_TGL_DAFTAR) as char(4))) as nomor_perkara,
							CONVERT(CHAR(10), DREG_TGL_TERIMA_BERKAS, 120)		as tanggal_penerimaan,
							(CAST(DREG_BB as varchar(133)))		as jenis_barang_bukti	
						FROM DATA_REGISTER WHERE LEN(cast(DREG_BB as varchar(8000)))>0;					
							";
		
		if(exe_sqlserver($conn,$ms_perkara20a)){
			$this->nativesession->set('update_progress', 85); 
			session_write_close();
			session_start();

		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara20a.'));
			return;
		}


		$ms_perkara20b = "SELECT * from v_perkara_barang_bukti where perkara_id in (".$cek_perkara_id.")";
		$ms_perkara20b_exe = exe_sqlserver($conn,$ms_perkara20b);
		
		$jml_data = odbc_num_rows($ms_perkara20b_exe);
		if($jml_data>0){
		while($row = odbc_fetch_array($ms_perkara20b_exe)){		
			//$this->load->helper('text');
			$data20['id']=$row['id'];
			$data20['perkara_id']=$row['perkara_id'];
			$data20['nomor_perkara']=$row['nomor_perkara'];
			$data20['tanggal_penerimaan']=$row['tanggal_penerimaan'];
			$data20['jenis_barang_bukti']=ascii_to_entities($row['jenis_barang_bukti']);
			$data20['diinput_oleh']='System';
			$data20['diinput_tanggal']=date("Y-m-d H:i:s", time());

			$my_perkara20 = $this->patching->replace_data('perkara_barang_bukti',$data20);
		}		
		
		if($my_perkara20){
			$this->nativesession->set('update_progress', 87); 
			session_write_close();
			session_start();

		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query $my_perkara20'));
			return;
		}
		}

		//--perkara_matra
		$ms_perkara21 = "IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'v_perkara_matra') BEGIN
    					DROP VIEW dbo.v_perkara_matra
						END";
		
		if(exe_sqlserver($conn,$ms_perkara21)){
			$this->nativesession->set('update_progress', 95); 
			session_write_close();
			session_start();

		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara21.'));
			return;
		}

		$ms_perkara21a="CREATE VIEW v_perkara_matra AS						
						SELECT 
							DATA_ID					as perkara_id, 
							MATRA_ID				as matra, 
							DREG_BERKAS_DARI		as berkas_dari, 
							CONVERT(CHAR(10), DREG_TGL_KEJADIAN, 120) as tanggal_kejadian, 
							DREG_TEMPAT_KEJADIAN	as tempat_kejadian, 
							CONVERT(CHAR(10), DREG_TGL_SKEPPER, 120) as tanggal_skeppera, 
							DREG_NO_SKEPPER			as nomor_skeppera, 
							(CAST (DREG_PEJABAT_SKEPPER as varchar(50)))	as pejabat_skeppera,
							CONVERT(CHAR(10), DREG_TGL_DAKWAAN, 120) as tanggal_surat_dakwaan, 
							DREG_NO_DAKWAAN			as nomor_surat_dakwaan
						FROM DATA_REGISTER 						
							";
		
		if(exe_sqlserver($conn,$ms_perkara21a)){
			$this->nativesession->set('update_progress', 95); 
			session_write_close();
			session_start();

		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query ms_perkara21a.'));
			return;
		}

		$ms_perkara21b = "SELECT * from v_perkara_matra where perkara_id in (".$cek_perkara_id.")";
		$ms_perkara21b_exe = exe_sqlserver($conn,$ms_perkara21b);
		
		$jml_data = odbc_num_rows($ms_perkara21b_exe);
		if($jml_data>0){
		while($row = odbc_fetch_array($ms_perkara21b_exe)){					
			$data21['perkara_id']=$row['perkara_id'];
			$data21['matra']=$row['matra'];
			$data21['berkas_dari']=ascii_to_entities($row['berkas_dari']);
			$data21['tanggal_kejadian']=ascii_to_entities($row['tanggal_kejadian']);
			$data21['tempat_kejadian']=ascii_to_entities($row['tempat_kejadian']);
			$data21['tanggal_skeppera']=$row['tanggal_skeppera'];
			$data21['nomor_skeppera']=ascii_to_entities($row['nomor_skeppera']);
			$data21['pejabat_skeppera']=ascii_to_entities($row['pejabat_skeppera']);
			$data21['tanggal_surat_dakwaan']=$row['tanggal_surat_dakwaan'];
			$data21['nomor_surat_dakwaan']=ascii_to_entities($row['nomor_surat_dakwaan']);
			$data21['diinput_oleh']='System';
			$data21['diinput_tanggal']=date("Y-m-d H:i:s", time());

			$my_perkara21 = $this->patching->replace_data('perkara_matra',$data21);
		}		
		
		if($my_perkara21){
			$this->nativesession->set('update_progress', 100);
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error query $my_perkara21'));
			return;
		}
		}		
		session_write_close();
		session_start();

		echo json_encode(array('st'=>1,'msg'=>'Migrasi Berhasil.'));
		return;

		$this->patching->exe_script('SET FOREIGN_KEY_CHECKS=1;');
		$this->patching->exe_script('SET autocommit = 1;');
		$this->patching->exe_script('commit;');	
	
	}


//$this->load->libraries('rtfelement');






function rtf2text($text) {


    // Create empty stack array.
    $document = "";
    $stack = array();
    $j = -1;
    // Read the data character-by- character…
    for ($i = 0, $len = strlen($text); $i < $len; $i++) {
        $c = $text[$i];

        // Depending on current character select the further actions.
        switch ($c) {
            // the most important key word backslash
            case "\\":
                // read next character
                $nc = $text[$i + 1];

                // If it is another backslash or nonbreaking space or hyphen,
                // then the character is plain text and add it to the output stream.
                if ($nc == '\\' && $this->rtf_isPlainText($stack[$j])) $document .= '\\';
                elseif ($nc == '~' && $this->rtf_isPlainText($stack[$j])) $document .= ' ';
                elseif ($nc == '_' && $this->rtf_isPlainText($stack[$j])) $document .= '-';
                // If it is an asterisk mark, add it to the stack.
                elseif ($nc == '*') $stack[$j]["*"] = true;
                // If it is a single quote, read next two characters that are the hexadecimal notation
                // of a character we should add to the output stream.
                elseif ($nc == "'") {
                    $hex = substr($text, $i + 2, 2);
                    if ($this->rtf_isPlainText($stack[$j]))
                        $document .= html_entity_decode("&#".hexdec($hex).";");
                    //Shift the pointer.
                    $i += 2;
                // Since, we’ve found the alphabetic character, the next characters are control word
                // and, possibly, some digit parameter.
                } elseif ($nc >= 'a' && $nc <= 'z' || $nc >= 'A' && $nc <= 'Z') {
                    $word = "";
                    $param = null;

                    // Start reading characters after the backslash.
                    for ($k = $i + 1, $m = 0; $k < strlen($text); $k++, $m++) {
                        $nc = $text[$k];
                        // If the current character is a letter and there were no digits before it,
                        // then we’re still reading the control word. If there were digits, we should stop
                        // since we reach the end of the control word.
                        if ($nc >= 'a' && $nc <= 'z' || $nc >= 'A' && $nc <= 'Z') {
                            if (empty($param))
                                $word .= $nc;
                            else
                                break;
                        // If it is a digit, store the parameter.
                        } elseif ($nc >= '0' && $nc <= '9')
                            $param .= $nc;
                        // Since minus sign may occur only before a digit parameter, check whether
                        // $param is empty. Otherwise, we reach the end of the control word.
                        elseif ($nc == '-') {
                            if (empty($param))
                                $param .= $nc;
                            else
                                break;
                        } else
                            break;
                    }
                    // Shift the pointer on the number of read characters.
                    $i += $m - 1;

                    // Start analyzing what we’ve read. We are interested mostly in control words.
                    $toText = "";
                    switch (strtolower($word)) {
                        // If the control word is "u", then its parameter is the decimal notation of the
                        // Unicode character that should be added to the output stream.
                        // We need to check whether the stack contains \ucN control word. If it does,
                        // we should remove the N characters from the output stream.
                        case "u":
                            $toText .= html_entity_decode("&#x".dechex($param).";");
                            $ucDelta = @$stack[$j]["uc"];
                            if ($ucDelta > 0)
                                $i += $ucDelta;
                        break;
                        // Select line feeds, spaces and tabs.
                        case "par": case "page": case "column": case "line": case "lbr":
                            $toText .= "\n"; 
                        break;
                        case "emspace": case "enspace": case "qmspace":
                            $toText .= " "; 
                        break;
                        case "tab": $toText .= "\t"; break;
                        // Add current date and time instead of corresponding labels.
                        case "chdate": $toText .= date("m.d.Y"); break;
                        case "chdpl": $toText .= date("l, j F Y"); break;
                        case "chdpa": $toText .= date("D, j M Y"); break;
                        case "chtime": $toText .= date("H:i:s"); break;
                        // Replace some reserved characters to their html analogs.
                        case "emdash": $toText .= html_entity_decode("&mdash;"); break;
                        case "endash": $toText .= html_entity_decode("&ndash;"); break;
                        case "bullet": $toText .= html_entity_decode("&#149;"); break;
                        case "lquote": $toText .= html_entity_decode("&lsquo;"); break;
                        case "rquote": $toText .= html_entity_decode("&rsquo;"); break;
                        case "ldblquote": $toText .= html_entity_decode("&laquo;"); break;
                        case "rdblquote": $toText .= html_entity_decode("&raquo;"); break;
                        // Add all other to the control words stack. If a control word
                        // does not include parameters, set &param to true.
                        default:
                            $stack[$j][strtolower($word)] = empty($param) ? true : $param;
                        break;
                    }
                    // Add data to the output stream if required.
                    if ($this->rtf_isPlainText($stack[$j]))
                        $document .= $toText;
                }

                $i++;
            break;
            // If we read the opening brace {, then new subgroup starts and we add
            // new array stack element and write the data from previous stack element to it.
            case "{":
                array_push($stack, $stack[$j++]);
            break;
            // If we read the closing brace }, then we reach the end of subgroup and should remove 
            // the last stack element.
            case "}":
                array_pop($stack);
                $j--;
            break;
            // Skip “trash”.
            case '\0': case '\r': case '\f': case '\n': break;
            // Add other data to the output stream if required.
            default:
                if ($this->rtf_isPlainText($stack[$j]))
                    $document .= $c;
            break;
        }
    }
    // Return result.
    return $document;
}
	
}




