<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manage_testing_dev extends CI_Controller {

	function init(){
		#prevent direct access to page
		#the user should only access the page through menu
		if($this->nativesession->get_flash_session('security')===FALSE){
			redirect('main');
		}
		$sec = $this->nativesession->get_flash_session('security');

		if($this->session->userdata('is_logged_in')===FALSE){
			redirect('login');
		}
	}

	function index(){
		$functions = $this->nativesession->get_flash_session('function');
		$enc = $this->nativesession->get_flash_session('enc');

		$this->init();

		if($functions == 'sort'){
			$col = $this->nativesession->get_flash_session('col');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->sort($col,$enc,$keyword);
		}elseif($functions == 'type'){
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$idalurperkara);
		}elseif($functions == 'page'){
			$page = $this->nativesession->get_flash_session('page');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$column_sorted = $this->nativesession->get_flash_session('col');
			$this->showData($keyword,$column_sorted,$page);
		}elseif($functions == 'search'){
			$keyword ='';
			if($this->nativesession->is_flash_session('keyword')){
				$keyword = $this->nativesession->get_flash_session('keyword');
				$this->session->set_userdata('keyword',$keyword);
			}else{
				$this->session->set_userdata('keyword','');
			}
			$page = $this->nativesession->get_flash_session('page');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($keyword);
		}else{
			$this->session->set_userdata('asc_desc','ASC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData();
		}

	}

	function sort($col=null,$enc=null,$keyword=null){
		if($this->session->userdata('asc_desc')){
			if($this->session->userdata('asc_desc')=="DESC"){
				$this->session->set_userdata('asc_desc','ASC');
			}else{
				$this->session->set_userdata('asc_desc','DESC');
			}
		}else{
			$this->session->set_userdata('asc_desc','ASC');
		}
		$this->showData($keyword,$col,0);
	}

	function showData($keyword='',$col=31,$start_page=0){
		if($this->nativesession->is_flash_session('keyword') AND empty($keyword)){
			$keyword = $this->nativesession->get_flash_session('keyword');
		}
		
		$asc_desc = $this->session->userdata('asc_desc');
		$this->load->model('testing_dev/testing_dev');
		if($start_page>0){
			$begin_limit = ($start_page-1)*1500;
		}else{
			$begin_limit = 0;
			$start_page = 1;
		}
		$query = $this->testing_dev->get_bugs_list($col,$asc_desc,$begin_limit,$keyword);
		
		$data['bugs_list'] = $query;
		if($this->session->userdata('total_rows')){
			if($this->session->userdata('total_rows')==-1){
				$data['total_rows'] = $this->testing_dev->fecth_data_num();
				$this->session->set_userdata('total_rows',$data['total_rows']);
			}else{
				$data['total_rows'] = $this->session->userdata('total_rows');
			}
		}else{
			$data['total_rows'] = $this->testing_dev->fecth_data_num();
			$this->session->set_userdata('total_rows',$data['total_rows']);
		}
		
		


		$data['page_active'] = $begin_limit;
		$data['page_title'] = 'DAFTAR BUGS & ERROR APLIKASI SIPP ';
		
		$data['main_body'] = 'testing_dev/testing_dev';
		$data['enc'] = "-";
		
		$data['page_number'] = $start_page;
		$data['page_url'] = 'testing_dev_list';
		$data['keyword'] = $keyword;
		$data['column_sorted'] = $col;
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body');
	}

	function initckeditor($readonly=FALSE){
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '850px';
		$this->ckeditor->config['height'] = '250px';
		if($readonly==TRUE){
			$this->ckeditor->config['readOnly'] = 'true';
		}
	}

	function add(){
		$data['status_penanganan'] = '';
		$data['deskripsi_error'] = '';
		$this->initckeditor();
		$this->load->vars($data);
		$this->load->view('testing_dev/popup_bug_report');
	}
	
	function update($enc){

		$id = $this->encrypt->decode(base64_decode($enc));
		if(!is_numeric($id)){
			show_404();
		}

		$data['status_penanganan'] = '';
		$data['deskripsi_error'] = '';

		$data['enc'] = $enc;

		$this->load->model('testing_dev/testing_dev','devel');
		$result = $this->devel->getData($id);
		if($result!=''){
			if($result->num_rows>0){
				foreach ($result->result() as $row) {
					$data['deskripsi_error'] = $row->error_msg;
					$data['respond_msg'] = $row->error_msg;
					$data['solution'] = $row->error_msg;
					$data['tglLapor'] = $this->tanggalhelper->convertDayDate($row->date);
					$data['try_by'] = $row->try_by;
					if($row->error_type==1){
						$data['error_type'] = 'Aplikasi';
					}elseif($row->error_type==2){
						$data['error_type'] = 'Bisnis Proses';
					}elseif($row->error_type==3){
						$data['error_type'] = 'Template';
					}elseif($row->error_type==1){
						$data['error_type'] = 'ERROR; ERROR TYPE NOT FOUND';
					}


				}
			}
		}else{
			show_404();
		}
		$this->initckeditor();
		$this->load->vars($data);
		$this->load->view('testing_dev/popup_bug_report_handling');
	}
	
	function validate_input(){
		if(empty($_POST)){
			show_404();
		}

		$this->form_validation->set_rules('tgl_percobaan', 'Tanggal Percobaan', 'trim|required|xss_clean');
		$this->form_validation->set_rules('jenis_error', 'Jenis Bugs/Error', 'trim|xss_clean|required|numeric');
		$this->form_validation->set_rules('deskripsi_error_text', 'Deskripsi Bugs/Error', 'trim|required|xss_clean');
		$this->form_validation->set_rules('nama', 'Dicoba Oleh', 'trim|required|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$tgl = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_percobaan',TRUE));
			if($tgl==false){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Data Not Valid'));
				return;
			}
			if($this->input->post('jenis_error',TRUE)<0 OR $this->input->post('jenis_error',TRUE)>3){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Data Not Valid'));
				return;
			}
			$data = array(
               'date' => $tgl,
               'try_by' => $this->input->post('nama',TRUE),
               'error_type' => $this->input->post('jenis_error',TRUE),
               'error_msg' => $this->input->post('deskripsi_error_text',TRUE)
            );
			$this->load->model('testing_dev/testing_dev','devel');
			$status = $this->devel->addData($data);
			if($status===TRUE){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Saat Simpan Kedatabase'));
				return;
			}
		}
	}

	function validate_update(){
		if(empty($_POST)){
			show_404();
		}

		$id = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($id) AND intval($id)<1){
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Data Not Valid'));
			return;
		}

		$this->form_validation->set_rules('status_perbaikan', 'Status Perbaikan', 'trim|required|xss_clean|numeric');
		$this->form_validation->set_rules('ditangani_oleh', 'Ditangani Oleh', 'trim|xss_clean|required|numeric');
		$this->form_validation->set_rules('status_text', 'Respond Message', 'trim|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$ditangani_oleh = $this->input->post('ditangani_oleh',TRUE);
			if($ditangani_oleh<1){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Data Not Valid'));
				return;
			}
			$handby = $this->input->post('ditangani_oleh',TRUE);
			if($handby==8){
				$handling_by = 'Tri';
			}elseif($handby==7){
				$handling_by = 'Roby';
			}elseif($handby==6){
				$handling_by = 'Puji';
			}elseif($handby==5){
				$handling_by = 'Dodon';
			}elseif($handby==4){
				$handling_by = 'Didik';
			}elseif($handby==3){
				$handling_by = 'Catur';
			}elseif($handby==2){
				$handling_by = 'Atria';
			}elseif($handby==1){
				$handling_by = 'Adit';
			}
			$data = array(
               	'status' => $this->input->post('status_perbaikan',TRUE),
               	'handling_by' => $handling_by,
               	'respond_msg' => $this->input->post('status_text',TRUE),
               	'update_by' => $this->session->userdata('username'),
				'update_datetime' => date("Y-m-d h:i:s",time())
            );
			$this->load->model('testing_dev/testing_dev','devel');
			$status = $this->devel->updateData($data,$id);
			if($status===TRUE){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Saat Simpan Kedatabase'));
				return;
			}
		}
	}
}

?>