<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manage_template_amar extends CI_Controller {
	function index(){
		$functions = $this->nativesession->get_flash_session('function');
		$enc = $this->nativesession->get_flash_session('enc');

		#prevent direct access to page
		#the user should only access the page through menu
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		if($functions == 'sort'){
			$col = $this->nativesession->get_flash_session('col');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->sort($col,$enc,$keyword);
		}elseif($functions == 'type'){
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$idalurperkara);
		}elseif($functions == 'page'){
			$page = $this->nativesession->get_flash_session('page');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$column_sorted = $this->nativesession->get_flash_session('col');
			$this->showData($keyword,$column_sorted,$page);
		}elseif($functions == 'search'){
			$keyword =$this->nativesession->get_flash_session('keyword');
			if($keyword){
				$keyword = $this->nativesession->get_flash_session('keyword');
				$this->session->set_userdata('keyword',$keyword);
			}else{
				$this->session->set_userdata('keyword','');
			}
			$page = $this->nativesession->get_flash_session('page');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($keyword);
		}else{
			$this->session->set_userdata('asc_desc','ASC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData();
		}

	}

	function sort($col=null,$enc=null,$keyword=null){
		if($this->session->userdata('asc_desc')){
			if($this->session->userdata('asc_desc')=="DESC"){
				$this->session->set_userdata('asc_desc','ASC');
			}else{
				$this->session->set_userdata('asc_desc','DESC');
			}
		}else{
			$this->session->set_userdata('asc_desc','ASC');
		}
		$this->showData($keyword,$col,0);
	}

	function showData($keyword='',$col=2,$start_page=0){
		$tmp = $this->nativesession->get_flash_session('keyword');
		if( !empty($tmp) AND empty($keyword)){
			$keyword = $tmp;
		}
		$satker =$this->session->userdata('jenis_pengadilan');	
		$asc_desc = $this->session->userdata('asc_desc');
		$this->load->model('template/template_amar_m','template');
		$data['jenis_perkara'] = $this->template->cekjenisperkara($satker);
		if($start_page>0){
			$begin_limit = ($start_page-1)*50;
		}else{
			$begin_limit = 0;
			$start_page = 1;
		}
		$query = $this->template->get_template_list($col,$asc_desc,$begin_limit,$keyword);
		$data['users_list'] = $query;
		if($this->session->userdata('total_rows')){
			if($this->session->userdata('total_rows')==-1){
				$data['total_rows'] = $this->template->fecth_data_num();
				$this->session->set_userdata('total_rows',$data['total_rows']);
			}else{
				$data['total_rows'] = $this->session->userdata('total_rows');
			}
		}else{
			$data['total_rows'] = $this->template->fecth_data_num();
			$this->session->set_userdata('total_rows',$data['total_rows']);
		}
		
		$data['page_active'] = $begin_limit;
		$data['page_title'] = 'DAFTAR TEMPLATE AMAR';
		
		$data['main_body'] = 'template/template_amar_putusan_list';
		$data['enc'] = "-";
		
		$data['page_number'] = $start_page;
		$data['page_url'] = 'ruangan_sidang_list';
		$data['keyword'] = $keyword;
		$data['column_sorted'] = $col;
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-','RemoveFormat','-', 'Blockquote',
					'-','JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '100%';
		$this->ckeditor->config['height'] = '250px';
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body');
	}

	function info(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$this->load->model('template/template_amar_m','template');
		if($this->input->post('enc',TRUE)){
			$id = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			if(!empty($id)){
				$query = $this->template->get_template_info($id);
				if($query->num_rows>0){
					foreach ($query->result() as $row) {
						echo json_encode(array(
							'st'=>1,
							'idH'=>$row->id,
							'sela'=>$row->sela,
							'alur_perkara_id'=>$row->alur_perkara_id,
							'jenis_perkara_id'=>$row->jenis_perkara_id,
							'nama'=>$row->nama,
							'ket'=>$row->template,
							'aktif'=>$row->aktif
							)
						);
					}
				}
			}else{
				echo json_encode(array('st'=>0));
			}
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Invalid Argument'));
		}
	}

	function validate_input(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$this->load->model('template/template_amar_m','template');
		$id = $this->input->post('idH',TRUE);
		$update = FALSE;
		$status = FALSE;
		if(!empty($id) AND $id>0){
			$this->form_validation->set_rules('idH', 'ID Template', 'trim|required|xss_clean|numeric');
			$update = TRUE;
		}else{
			$row = $this->template->get_last_id();
			$id = $row->id+1;
		}

		$this->form_validation->set_rules('nama', 'Nama Template', 'trim|xss_clean');
		$this->form_validation->set_rules('aktif', 'Status Aktif', 'trim|required|xss_clean|numeric');
		$this->form_validation->set_rules('template_amar_text', 'Template', 'trim|xss_clean');

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
		}else{
			$aktif = ($this->input->post('aktif',TRUE)==1)? 'Y':'T';
			$data = array(
               'nama' => $this->input->post('nama',TRUE),
               'aktif' => $aktif,
               'sela' => $this->input->post('sela',TRUE),
			   'jenis_perkara_id' => $this->input->post('jenis_perkara',TRUE),
               'template' => $this->input->post('template_amar_text',TRUE)
            );
            if($update){
            	$data['diperbaharui_oleh'] = $this->session->userdata('username');
				$data['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
				$status = $this->template->update_data($data,$id);
            }else{
            	$data['id'] = $id;
            	$data['diinput_oleh'] = $this->session->userdata('username');
				$data['diinput_tanggal'] = date("Y-m-d h:i:s",time());
				$status = $this->template->add_data($data);
            }
			if($status===TRUE){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
			}else{
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Saat Simpan Kedatabase'));
			}
		}
	}
	
	
}

?>