<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manage_reminder_perkara extends CI_Controller {

	function init(){
		#prevent direct access to page
		#the user should only access the page through menu
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}
		$sec = $this->nativesession->get_flash_session('security');

		if($this->session->userdata('is_logged_in')==FALSE){

			redirect('login');
		}
	}

	function index(){
		$functions = $this->nativesession->get_flash_session('function');
		$enc = $this->nativesession->get_flash_session('enc');

		$this->init();
		
		if($functions == 'sort'){
			$col = $this->nativesession->get_flash_session('col');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->sort($col,$enc,$keyword);
		}elseif($functions == 'type'){
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$idalurperkara);
		}elseif($functions == 'page'){
			$page = $this->nativesession->get_flash_session('page');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$column_sorted = $this->nativesession->get_flash_session('col');
			$this->showData($keyword,$column_sorted,$page);
		}elseif($functions == 'search'){
			$keyword ='';
			if($this->nativesession->is_flash_session('keyword')){
				$keyword = $this->nativesession->get_flash_session('keyword');
				$this->session->set_userdata('keyword',$keyword);
			}else{
				$this->session->set_userdata('keyword','');
			}
			$page = $this->nativesession->get_flash_session('page');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($keyword);
		}else{
			$this->nativesession->set('tahapan', '');
			$this->nativesession->set('proses', '');
			$this->nativesession->set('jenis_perkara', '');
			$this->session->set_userdata('asc_desc','ASC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData();
		}

	}

	function sort($col=null,$enc=null,$keyword=null){
		if($this->session->userdata('asc_desc')){
			if($this->session->userdata('asc_desc')=="DESC"){
				$this->session->set_userdata('asc_desc','ASC');
			}else{
				$this->session->set_userdata('asc_desc','DESC');
			}
		}else{
			$this->session->set_userdata('asc_desc','ASC');
		}
		$this->showData($keyword,$col,0);
	}

	function filter(){
		$tahapan = $this->input->post('tahapan',TRUE);
		if($tahapan>0){
			$this->nativesession->set('tahapan', $tahapan);
		}else{
			$this->nativesession->set('tahapan', '');
		}
		

		$proses = $this->input->post('proses',TRUE);
		if($proses>0){
			$this->nativesession->set('proses', $proses);
		}else{
			$this->nativesession->set('proses', '');
		}

		$jenis_perkara = $this->input->post('jenis_perkara',TRUE);
		if($jenis_perkara>0){
			$this->nativesession->set('jenis_perkara', $jenis_perkara);
		}else{
			$this->nativesession->set('jenis_perkara', '');
		}

		#

		$this->session->set_userdata('asc_desc','ASC');
		$this->session->set_userdata('total_rows',-1);
		$this->showData();
	}


	function showData($keyword='',$col=1,$start_page=0){
		if($this->nativesession->is_flash_session('keyword') AND empty($keyword)){
			$keyword = $this->nativesession->get_flash_session('keyword');
		}
		
		#initiated filter
		$tahapan = $this->nativesession->get('tahapan');
		$proses = $this->nativesession->get('proses');
		$jenis_perkara = $this->nativesession->get('jenis_perkara');

		$asc_desc = $this->session->userdata('asc_desc');
		$this->load->model('reminder/reminder_perkara','reminder');
		if($start_page>0){
			$begin_limit = ($start_page-1)*50;
		}else{
			$begin_limit = 0;
			$start_page = 1;
		}
		$query = $this->reminder->get_reminder_list($col,$asc_desc,$begin_limit,$keyword,$tahapan,$proses,$jenis_perkara);
		
		$data['reminder_list'] = $query;

		$data['tahapan'] = $this->reminder->get_list_tahapan();
		$data['jenis_perkara'] = $this->reminder->get_list_perkara();
		$data['proses'] = $this->reminder->get_list_proses();

		$data['tahapan_opt'] = $tahapan;
		$data['jenis_perkara_opt'] = $jenis_perkara;
		$data['proses_opt'] = $proses;

		if($this->session->userdata('total_rows')){
			if($this->session->userdata('total_rows')==-1){
				$data['total_rows'] = $this->reminder->fecth_data_num();
				$this->session->set_userdata('total_rows',$data['total_rows']);
			}else{
				$data['total_rows'] = $this->session->userdata('total_rows');
			}
		}else{
			$data['total_rows'] = $this->reminder->fecth_data_num();
			$this->session->set_userdata('total_rows',$data['total_rows']);
		}
		
		$data['page_active'] = $begin_limit;
		$data['page_title'] = 'REFERENSI PROSES ALUR PERKARA';
		
		$data['main_body'] = 'reminder/reminder_perkara';
		$data['enc'] = "-";
		
		$data['page_number'] = $start_page;
		$data['page_url'] = 'proses_alur_perkara_list';
		$data['keyword'] = $keyword;
		$data['column_sorted'] = $col;
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body');
	}

	function info(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong> UNAUTHORIZED.<br /> Please Refresh the browser or Tekan F9'));
			return; 
		}
		$this->load->model('reminder/reminder_perkara','reminder');
		if($this->input->post('enc',TRUE)){
			$id = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			if(!empty($id)){
				$query = $this->reminder->get_reminder_info($id);
				if($query->num_rows>0){
					foreach ($query->result() as $row) {
						echo json_encode(array(
							'st'=>1,
							'idH'=>$row->id,
							'jenis'=>$row->jenis_perkara,
							'tahapan'=>$row->tahapan_nama,
							'proses'=>$row->proses_nama,
							'batas'=>$row->batas_waktu,
							'satuan'=>$row->satuan,
							'aktif'=>$row->aktif,
							'dari_proses'=>$row->dari_proses_id,
							'reminder'=>$row->reminder
							)
						);
					}
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Invalid Argument'));
				}
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Invalid Argument'));
			}
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Invalid Argument'));
		}
	}

	function validate_input(){
		if(empty($_POST)){
			show_404();
		}
		$this->load->model('reminder/reminder_perkara','reminder');
		$id = $this->input->post('idH',TRUE);
		$status = FALSE;
		if(!empty($id) AND $id>0){
			$this->form_validation->set_rules('idH', 'REFERENSI ALUR', 'trim|required|xss_clean|numeric');
		}else{
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil. Please Refresh your browser.'));
			return;
		}

		$this->form_validation->set_rules('tahapan_pop', 'Tahapan', 'trim|required|xss_clean');
		$this->form_validation->set_rules('proses_pop', 'Proses', 'trim|xss_clean|required');
		$this->form_validation->set_rules('jenis_perkara_pop', 'Jenis Perkara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('dari_proses', 'Terhitung Dari', 'trim|required|xss_clean');
		$this->form_validation->set_rules('aktif', 'Aktif', 'trim|required|xss_clean|numeric');
		$this->form_validation->set_rules('reminder', 'Pesan Pengingat', 'trim|xss_clean|required|numeric');
		$this->form_validation->set_rules('satuan', 'Satuan', 'trim|xss_clean|required|numeric');
		$this->form_validation->set_rules('batas', 'Batas Waktu', 'trim|xss_clean|numeric');

		$satuan = $this->input->post('satuan',TRUE);
		$bataswaktu = $this->input->post('batas',TRUE);
		if($this->input->post('batas',TRUE)==''){
			$bataswaktu = NULL;
			$satuan='';
		}

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
		}else{
			$aktif = ($this->input->post('aktif',TRUE)==1)? 'Y':'T';
			$data = array(
               'batas_waktu' => $bataswaktu,
               'satuan' => $satuan,
               'reminder' => $this->input->post('reminder',TRUE),
               'dari_proses_id' => $this->input->post('dari_proses',TRUE),
               'aktif' => $aktif,
               'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
            );
			$status = $this->reminder->update_data($data,$this->input->post('idH',TRUE));
			if($status===TRUE){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
			}else{
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Saat Simpan Kedatabase'));
			}
		}
	}
}

?>