<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manage_register_anak_blm_12tahun extends CI_Controller {
	
	function index(){
		$functions = $this->nativesession->get_flash_session('function');
		$enc = $this->nativesession->get_flash_session('enc');

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		if($functions == 'sort'){
			$col = $this->nativesession->get_flash_session('col');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->sort($col,$enc,$keyword);
		}elseif($functions == 'type'){
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$idalurperkara);
		}elseif($functions == 'page'){
			$page = $this->nativesession->get_flash_session('page');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$column_sorted = $this->nativesession->get_flash_session('col');
			$this->showData($keyword,$column_sorted,$page);
		}elseif($functions == 'search'){
			$keyword ='';
			if($this->nativesession->is_flash_session('keyword')){
				$keyword = $this->nativesession->get_flash_session('keyword');
				$this->session->set_userdata('keyword',$keyword);
			}else{
				$this->session->set_userdata('keyword','');
			}
			$page = $this->nativesession->get_flash_session('page');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($keyword);
		}else{
			$this->session->set_userdata('asc_desc','ASC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData();
		}

	}

	function sort($col=null,$enc=null,$keyword=null){
		if($this->session->userdata('asc_desc')){
			if($this->session->userdata('asc_desc')=="DESC"){
				$this->session->set_userdata('asc_desc','ASC');
			}else{
				$this->session->set_userdata('asc_desc','DESC');
			}
		}else{
			$this->session->set_userdata('asc_desc','ASC');
		}
		$this->showData($keyword,$col,0);
	}

	function showData($keyword='',$col=2,$start_page=0){
		if($this->nativesession->is_flash_session('keyword') AND empty($keyword)){
			$keyword = $this->nativesession->get_flash_session('keyword');
		}
			
		$asc_desc = $this->session->userdata('asc_desc');
		$this->load->model('diversi/register_diversi_blm_12tahun_m','register_diversi');
		if($start_page>0){
			$begin_limit = ($start_page-1)*50;
		}else{
			$begin_limit = 0;
			$start_page = 1;
		}
		$query = $this->register_diversi->get_register_anak_blm_12tahun($col,$asc_desc,$begin_limit,$keyword);
		
		$data['register_list'] = $query;
		if($this->session->userdata('total_rows')){
			if($this->session->userdata('total_rows')==-1){
				$data['total_rows'] = $this->register_diversi->fecth_data_num();
				$this->session->set_userdata('total_rows',$data['total_rows']);
			}else{
				$data['total_rows'] = $this->session->userdata('total_rows');
			}
		}else{
			$data['total_rows'] = $this->register_diversi->fecth_data_num();
			$this->session->set_userdata('total_rows',$data['total_rows']);
		}
		$data['page_active'] = $begin_limit;
		$data['page_title'] = 'DAFTAR ANAK BELUM 12 (DUA BELAS) TAHUN';

		$data['main_body'] = 'diversi/belum_12tahun/register_anak_blm_12tahun_v';
		$data['enc'] = "-";

		$data['page_number'] = $start_page;
		$data['page_url'] = 'register_anak_blm_12tahun';
		$this->nativesession->set('url_requested',$data['page_url']);
		$data['keyword'] = $keyword;
		$data['column_sorted'] = $col;
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body');
	}


	function add_register(){
		$data['page_title'] = 'TAMBAH - REGISTER  ANAK BELUM 12 (DUA BELAS) TAHUN';
		$data['main_body'] = 'diversi/belum_12tahun/new_register_blm_12tahun_v';
		$data['act'] = "add";
		$data['page_url'] = 'diversi/belum_12tahun/new_register_blm_12tahun_v';
		$data['previous'] = '../register_anak_blm_12tahun';
		$this->nativesession->set('url_requested',$data['page_url']);
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body');
		
	}

	function edit_register($enc_register){
		$id_register=$this->encrypt->decode(base64_decode($enc_register));
		$this->db->where('id',$id_register);
		$query=$this->db->get('diversi_register_blm_12tahun');
		$result=$query->result();
		 $data['data']=array('no_urut'=>$result[0]->no_urut,
	 						 'nomor_permohonan'=>$result[0]->nomor_permohonan,
	 						 'tgl_permohonan'=>$this->tanggalhelper->convertToInputDate($result[0]->tgl_permohonan),
	 						 'nomor_penetapan'=>$result[0]->nomor_penetapan,
	 						 'tgl_penetapan'=>$this->tanggalhelper->convertToInputDate($result[0]->tgl_penetapan),
	 						 'nomor_lap_kemasyarakatan'=>$result[0]->nomor_lap_kemasyarakatan,
	 						 'tgl_lap_kemasyarakatan'=>$this->tanggalhelper->convertToInputDate($result[0]->tgl_lap_kemasyarakatan),
	 						 'nomor_kep_penyidik'=>$result[0]->nomor_kep_penyidik,
	 						 'tgl_kep_penyidik'=>$this->tanggalhelper->convertToInputDate($result[0]->tgl_kep_penyidik),
	 						 'isi_kep_penyidik'=>$result[0]->isi_kep_penyidik,
	 						 'tgl_tindak_pidana'=>$this->tanggalhelper->convertToInputDate($result[0]->tgl_tindak_pidana),
	 						 'uraian_tindak_pidana'=>$result[0]->uraian_tindak_pidana);

		$data['page_title'] = 'EDIT - REGISTER  ANAK BELUM 12 (DUA BELAS) TAHUN';
		$data['main_body'] = 'diversi/belum_12tahun/new_register_blm_12tahun_v';
		$data['act'] = "edit";
		$data['page_url'] = 'diversi/belum_12tahun/new_register_blm_12tahun_v';
		$data['previous'] = '../../register_anak_blm_12tahun';
		$this->nativesession->set('url_requested',$data['page_url']);
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body');
		
	}

	function validateInput(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$this->form_validation->set_rules('nomor_penetapan','Nomor Penetapan','trim|required|xss_clean');	
		$this->form_validation->set_rules('no_urut','Nomor Urut','trim|required|xss_clean');	
		$this->form_validation->set_rules('nomor_kep_penyidik','Nomor Keputusan Penyidik','trim|required|xss_clean');	
		$this->form_validation->set_rules('nomor_lap_kemasyarakatan','Nomoe Lap. Kemasyarakatan','trim|required|xss_clean');	
		$this->form_validation->set_rules('tgl_kep_penyidik','Tanggal Keputusan Penyidik','trim|required|xss_clean');	
		$this->form_validation->set_rules('tgl_penetapan','Tanggal Penetapan','trim|required|xss_clean');
		$this->form_validation->set_rules('tgl_lap_kemasyarakatan','Tanggal Laporan Kemasyarakatan','trim|required|xss_clean');		
		$this->form_validation->set_rules('tgl_tindak_pidana','Tanggal Tindak Pidana','trim|required|xss_clean');
		$this->form_validation->set_rules('nomor_permohonan','Nomor Permohonan','trim|required|xss_clean');
		$this->form_validation->set_rules('tgl_permohonan','Tanggal Permohonan','trim|required|xss_clean');
		$this->form_validation->set_rules('uraian_tindak_pidana','Uraian Tindak Pidana','trim|required|xss_clean');
		$this->form_validation->set_rules('isi_kep_penyidik','Isi Keputusan Peyidik','trim|required|xss_clean');
		$act=$this->input->post('act',TRUE);
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));

		}else{
				$data = array(
						'id'=>$this->input->post('no_urut',TRUE),
						'isi_kep_penyidik'=>$this->input->post('isi_kep_penyidik',TRUE),
						'nomor_penetapan'=>$this->input->post('nomor_penetapan',TRUE),
						'no_urut'=>$this->input->post('no_urut',TRUE),
						'nomor_kep_penyidik'=>$this->input->post('nomor_kep_penyidik',TRUE),
						'nomor_lap_kemasyarakatan'=>$this->input->post('nomor_lap_kemasyarakatan',TRUE),
						'nomor_permohonan'=>$this->input->post('nomor_permohonan',TRUE),
						'uraian_tindak_pidana'=>$this->input->post('uraian_tindak_pidana',TRUE),
						'tgl_kep_penyidik'=>$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_kep_penyidik',TRUE)),
						'tgl_penetapan'=>$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_penetapan',TRUE)),
						'tgl_lap_kemasyarakatan'=>$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_lap_kemasyarakatan',TRUE)),
						'tgl_tindak_pidana'=>$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_tindak_pidana',TRUE)),
						'tgl_permohonan'=>$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_permohonan',TRUE))
		            );
					if ($act=='add'){
						if ($this->db->insert('diversi_register_blm_12tahun',$data)){
							echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
							return;
						}else{
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Saat Simpan Kedatabase'));
							return;
						}	
					}else if ($act=='edit') {
						$this->db->where('id',$this->input->post('no_urut',TRUE));
						if ($this->db->update('diversi_register_blm_12tahun',$data)){
							echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
							return;
						}else{
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Saat Simpan Kedatabase'));
							return;
						}
					}
					
		}
		
	}


	function popup_hapus_register($enc_register){
		$register_id=$this->encrypt->decode(base64_decode($enc_register));
		$query=$this->db->query("SELECT nomor_penetapan FROM diversi_register_blm_12tahun WHERE id=".$register_id);
		$data['nomor_penetapan']=$query->row()->nomor_penetapan;
		$data['enc_register']=$enc_register;
		$this->load->view('diversi/belum_12tahun/popup_hapus_register',$data);
	}

	function hapus_register($enc_register){
		$register_id=$this->encrypt->decode(base64_decode($enc_register));
		$this->db->query('DELETE FROM diversi_register_blm_12tahun WHERE id='.$register_id);
		$this->db->query('DELETE FROM diversi_anak_blm_12tahun WHERE register_id='.$register_id);
		redirect('register_anak_blm_12tahun');
	}

	function get_nomor_register(){
		$manual = $this->input->post('val',true);
		if($manual==1){
			$query=$this->db->query("SELECT max(no_urut) as last FROM diversi_register_blm_12tahun ");
			$last_id=$query->row()->last+1;
			$this->load->model('diversi/register_diversi','register_diversi');
			$format_no = '/Pen.Kep-Anak/'.date(Y).'/PN '.$this->register_diversi->getKodePN(); 
			$new_nomor    = $last_id.$format_no;
			if(!empty($last_id)){
				echo json_encode(array('st'=>1,'no_urut'=>$last_id,'new_nomor'=>$new_nomor));
				return;
			}			
		}else{
			return;
		}
	}

	function searchPage(){
		if(empty($_POST)){
			show_404();
		}
		$keyword = $this->input->post('keyword_pihak',TRUE);
		$column = $this->input->post('search_field',TRUE);
		$this->nativesession->set_flash_session('security', TRUE);
		$this->nativesession->set_flash_session('keyword_pihak', $keyword);
		$this->nativesession->set_flash_session('column', $column);
		echo json_encode(array('st'=>1));
	}

	
}

?>