<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manage_pesan_keluar extends CI_Controller {

	function index(){
		$functions = $this->nativesession->get_flash_session('function');
		$enc = $this->nativesession->get_flash_session('enc');

		#prevent direct access to page
		#the user should only access the page through menu
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}
		$sec = $this->nativesession->get_flash_session('security');

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		
		if($functions == 'sort'){
			$col = $this->nativesession->get_flash_session('col');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->sort($col,$enc,$keyword);
		}elseif($functions == 'type'){
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc);
		}elseif($functions == 'page'){
			$page = $this->nativesession->get_flash_session('page');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$column_sorted = $this->nativesession->get_flash_session('col');
			$this->showData($keyword,$column_sorted,$page);
		}elseif($functions == 'search'){
			$keyword ='';
			if($this->nativesession->is_flash_session('keyword')){
				$keyword = $this->nativesession->get_flash_session('keyword');
				$this->session->set_userdata('keyword',$keyword);
			}else{
				$this->session->set_userdata('keyword','');
			}
			$page = $this->nativesession->get_flash_session('page');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($keyword);
		}else{
			$this->session->set_userdata('asc_desc','DESC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData();
		}

	}

	function sort($col=null,$enc=null,$keyword=null){
		if($this->session->userdata('asc_desc')){
			if($this->session->userdata('asc_desc')=="DESC"){
				$this->session->set_userdata('asc_desc','ASC');
			}else{
				$this->session->set_userdata('asc_desc','DESC');
			}
		}else{
			$this->session->set_userdata('asc_desc','ASC');
		}
		$this->showData($keyword,$col,0);
	}

	function showData($keyword='',$col=1,$start_page=0){
		if($this->nativesession->is_flash_session('keyword') AND empty($keyword)){
			$keyword = $this->nativesession->get_flash_session('keyword');
		}
			
		$asc_desc = $this->session->userdata('asc_desc');
		$this->load->model('pesan/pesan_keluar','pesan');
		if($start_page>0){
			$begin_limit = ($start_page-1)*50;
		}else{
			$begin_limit = 0;
			$start_page = 1;
		}
		$userid = $this->session->userdata('userid');
		$query = $this->pesan->get_pesan_keluar_list($col,$asc_desc,$begin_limit,$keyword,$userid);
		$user_list =$this->pesan->get_list_user();
		$data['pesan_keluar_list'] = $query;
		$data['user_list'] = $user_list;
		if($this->session->userdata('total_rows')){
			if($this->session->userdata('total_rows')==-1){
				$data['total_rows'] = $this->pesan->fecth_data_num();
				$this->session->set_userdata('total_rows',$data['total_rows']);
			}else{
				$data['total_rows'] = $this->session->userdata('total_rows');
			}
		}else{
			$data['total_rows'] = $this->pesan->fecth_data_num();
			$this->session->set_userdata('total_rows',$data['total_rows']);
		}
		
		$data['page_active'] = $begin_limit;
		$data['page_title'] = 'DAFTAR PESAN KELUAR';
		
		$data['main_body'] = 'pesan/pesan_keluar_list';
		$data['enc'] = "-";
		$data['enc_key'] = base64_encode($this->encrypt->encode('secure'));
		
		$data['page_number'] = $start_page;
		$data['page_url'] = 'pesan_keluar_list';
		$data['keyword'] = $keyword;
		$data['column_sorted'] = $col;

		#configurasi CKeditor, this editior has been costumize for SIPP need.
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '800px';
		$this->ckeditor->config['height'] = '200px';

		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body');
	}

	function info(){
		if(empty($_POST)){
			show_404();
		}
		$this->load->model('pesan/pesan_keluar','pesan');
		if($this->input->post('enc',TRUE)){
			$id = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			if(!empty($id)){
				$query = $this->pesan->get_pesan_detil($id);
				if($query->num_rows>0){
					foreach ($query->result() as $row) {
						echo json_encode(array(
							'st'=>1,
							'idH'=>base64_encode($this->encrypt->encode($row->id)),
							'kepada'=>$row->kepada,
							'subject'=>$row->subjek,
							'pesan'=>$row->isi_pesan,
							'tanggal'=>$row->tanggal_kirim
							)
						);
					}
				}
			}else{
				echo json_encode(array('st'=>0));
			}
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Invalid Argument'));
		}
	}

	function del(){
		if(empty($_POST)){
			show_404();
		}
		$this->load->model('pesan/pesan_keluar','pesan');
		if($this->input->post('enc',TRUE)){
			$id = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			if(!empty($id)){
				$status = $this->pesan->update_data($id);
				if($status===TRUE){
					echo json_encode(array('st'=>1,'msg'=>'Pesan Berhasil Dihapus'));
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Saat Simpan Kedatabase.'));
				}
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Invalid Argument. Please Try Again'));
			}
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Invalid Argument. Please Try Again'));
		}
	}

	function validate_input(){
		if(empty($_POST)){
			show_404();
		}
		$delete = FALSE;
		$this->load->model('pesan/pesan_keluar','pesan');
		$this->form_validation->set_rules('destination', 'Tujuan Pesan', 'trim|required|xss_clean');
		$this->form_validation->set_rules('subject', 'Perihal Pesan', 'trim|xss_clean|required');
		$this->form_validation->set_rules('message', 'Pesan', 'trim|xss_clean|required');

		if($this->input->post('status_hakim',TRUE)=='1'){
			$this->form_validation->set_rules('nip', 'NIP HAKIM', 'trim|required|xss_clean|numeric|min_length[9]|max_length[18]|is_unique[hakim_pt.nip]');
		}
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil'.validation_errors()));
		}else{
			$message = '<i>'.$this->session->userdata('username').', '.date("Y-m-d h:i:s",time()).'</i>: <br />'.$this->input->post('message',TRUE);
			$data = array(
               'dari_userid' => $this->session->userdata('userid'),
               'ke_userid' => $this->input->post('destination',TRUE),
               'subjek' => $this->input->post('subject',TRUE),
               'isi_pesan' => $message,
               'tanggal_kirim' => date("Y-m-d h:i:s",time()),
               'status' => 1
            );
            $data['diinput_oleh'] = $this->session->userdata('username');
			$data['diinput_tanggal'] = date("Y-m-d h:i:s",time());
			$status = $this->pesan->add_data($data);
            
			if($status===TRUE){
				echo json_encode(array('st'=>1,'msg'=>'Pesan Berhasil Dikirim'));
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Saat Simpan Kedatabase.'));
			}
		}
	}
}

?>