<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class ManagePenyitaan extends CI_Controller {
	function index(){
		if($this->nativesession->get_flash_session('security')===FALSE){
			redirect('main');
		}
		$sec = $this->nativesession->get_flash_session('security');

		if($this->session->userdata('is_logged_in')===FALSE){
			redirect('login');
		}
		$enc = $this->nativesession->get_flash_session('enc');
		$idalurperkara = $this->encrypt->decode(base64_decode($enc));
		$tmp = explode(',', $idalurperkara);
		if(count($tmp>1)){
			foreach ($tmp as $key) {
				if(!is_numeric($key)){
					show_404();
					exit();
				}
			}
		}else{
			show_404();
			exit();
		}
		$functions = $this->nativesession->get_flash_session('function');
		
		if($functions == 'sort'){
			$col = $this->nativesession->get_flash_session('col');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->sort($col,$enc,$keyword);
		}elseif($functions == 'type'){
			$this->session->set_userdata('asc_desc','DESC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$idalurperkara);
		}elseif($functions == 'page'){
			$page = $this->nativesession->get_flash_session('page');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$column_sorted = $this->nativesession->get_flash_session('col');
			$this->showData($enc,$idalurperkara,$column_sorted,$page,$keyword);
		}elseif($functions == 'search'){
			$keyword ='';
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->session->set_userdata('keyword',$keyword);

			$page = $this->nativesession->get_flash_session('page');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$idalurperkara,3,$page,$keyword);
		}else{
			$this->session->set_userdata('asc_desc','DESC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc, $idalurperkara);
		}
	}

	function sort($col=null,$enc=null,$keyword=null){
		if($this->session->userdata('asc_desc')){
			if($this->session->userdata('asc_desc')=="DESC"){
				$this->session->set_userdata('asc_desc','ASC');
			}else{
				$this->session->set_userdata('asc_desc','DESC');
			}
		}else{
			$this->session->set_userdata('asc_desc','ASC');
		}
		$idalurperkara = $this->encrypt->decode(base64_decode($enc));
		$this->showData($enc,$idalurperkara,$col,0,$keyword);
	}

	function showData($enc='',$idalurperkara='',$col=3,$start_page=0,$keyword=''){
		$asc_desc = $this->session->userdata('asc_desc');
		if($start_page>0){
			$begin_limit = ($start_page-1)*50;
		}else{
			$begin_limit = 0;
			$start_page = 1;
		}
		$data['page_url'] = 'penyitaan/penyitaan_list';
		$this->load->model('penyitaan/list_penyitaan', 'penyitaan');
		$data['penyitaan'] = $this->penyitaan->getListPenyitaan(9,'DESC',$begin_limit,$idalurperkara,$keyword);
		if($this->session->userdata('total_rows')){
			if($this->session->userdata('total_rows')==-1){
				$data['total_rows'] = $this->penyitaan->fecth_data_num($idalurperkara,$keyword);
				$this->session->set_userdata('total_rows',$data['total_rows']);
			}else{
				$data['total_rows'] = $this->session->userdata('total_rows');
			}
		}else{
			$data['total_rows'] = $this->penyitaan->fecth_data_num($idalurperkara,$keyword);
			$this->session->set_userdata('total_rows',$data['total_rows']);
		}
		$data['list_perkara'] = $this->penyitaan->getNomorPerkara($idalurperkara);
		$data['page_active'] = $begin_limit;

		$data['page_title'] = 'REGISTER PENYITAAN KEPAILITAN';$data['main_body'] = 'penyitaan/penyitaan_list';
		$data['enc'] = $enc;
		$data['enc_alurperkara'] = base64_encode($this->encrypt->encode($idalurperkara));
		$data['idalurperkara'] = $idalurperkara;
		$data['enc_act'] = base64_encode($this->encrypt->encode('add'));
		$data['curr_date'] = date('d/m/Y');
		$data['page_number'] = $start_page;
		$data['page_url'] = 'penyitaan/penyitaan_list';
		$data['keyword'] = $keyword;
		$data['column_sorted'] = $col;
		$data['url_requested'] = $this->nativesession->get_flash_session('url_requested');
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body');
	}

	function fetchData(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Page'));
			return;
		}
		$enc = $this->input->post('val',TRUE);
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('val',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$act = $this->input->post('act',TRUE);

		$this->load->model('penyitaan/list_penyitaan', 'penyitaan');
		$text = '<td style="padding:0px;padding-left:5px;" id="parapihak">';
		if($act=='add'){
			$exsist = $this->penyitaan->isPerkaraExist($idperkara);
			if($exsist==TRUE){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Sudah Terdaftar.'));
				return;
			}elseif($exsist=='-1'){
				echo json_encode(array('st'=>0,'msg'=>'Something Bad Happen.'));
				return;
			}
			$parapihak = $this->penyitaan->getParaPihak($idperkara);
			$text .= $parapihak;
			$text .= '</td>';
			$enc_act = base64_encode($this->encrypt->encode('add'));
			echo json_encode(array(
				'st'=>1,
				'parapihak'=> $text,
				'enc' => $enc,
				'enc_act' => $enc_act
				));
			return;
		}elseif($act=='updt'){
			$data = $this->penyitaan->getDetilPerkara($idperkara);
			if($data->num_rows>0){
				foreach ($data->result() as $row) {
					$parapihak = $row->para_pihak;
					$no = $row->nomor_perkara;
					$penSita = $row->penetapan_sita;
					$pelSita = $row->pelaksanaan_sita;
					$jeniSita = $row->jenis_sita_nama;
					$jeniBarang = $row->jenis_barang;
					$disita = $row->disita_dari;
					$penyimpanan = $row->penyimpanan_barang;
					$penPengakatan = $row->penetapan_pengangkatan_sita;
					$pelPengangkatan = $row->pelaksanaan_pengangkatan_sita;
					$catatatn = $row->catatan_penyitaan;
				}
				$enc_act = base64_encode($this->encrypt->encode('updt'));
				$text .= $parapihak;
				$text .= '</td>';
				echo json_encode(array(
						'st'=>1,
						'parapihak'=> $text,
						'enc' => $enc,
						'enc_act' => $enc_act,
						'no'=> $no,
						'penSita'=> $this->tanggalhelper->convertToInputDate($penSita),
						'pelSita'=> $this->tanggalhelper->convertToInputDate($pelSita),
						'jeniSita'=> $jeniSita,
						'jeniBarang'=> $jeniBarang,
						'disita'=> $disita,
						'penyimpanan'=> $penyimpanan,
						'penPengakatan'=> $this->tanggalhelper->convertToInputDate($penPengakatan),
						'pelPengangkatan'=> $this->tanggalhelper->convertToInputDate($pelPengangkatan),
						'catatatn'=> $catatatn
					));
			}else{
				echo json_encode(array(
						'st'=>0,
						'msg'=> 'Perkara Tidak Ditemukan'
					));
			}
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Something Bad Happen, Please refresh your browser'));
			return;
		}
	}

	function validateInput(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Page'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->form_validation->set_rules('no_perkara', 'Nomor Perkara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('pen_sita', 'Tanggal Penetapan Sita', 'trim|required|exact_length[10]|xss_clean');
		$this->form_validation->set_rules('pel_sita', 'Tanggal Pelaksanaan Sita', 'trim|required|exact_length[10]|xss_clean');
		$this->form_validation->set_rules('disita_dari', 'Disita Dari', 'trim|required|min_length[5]|xss_clean');
		$this->form_validation->set_rules('jenis_sita', 'Jenis Sita', 'trim|required|min_length[10]|xss_clean');
		$this->form_validation->set_rules('penyimpanan_barang', 'Penyimpanan Barang', 'trim|required|min_length[10]|xss_clean');
		
		$pen_pengangkatan_sita = $this->input->post('pen_pengangkatan_sita',TRUE);
		if(!empty($pen_pengangkatan_sita)){
			$this->form_validation->set_rules('pen_pengangkatan_sita', 'Tanggal Penetapan Pengangakatan Sita', 'trim|exact_length[10]|xss_clean');
		}
		
		$pel_pengangkatan_sita = $this->input->post('pel_pengangkatan_sita',TRUE);
		if(!empty($pel_pengangkatan_sita)){
			$this->form_validation->set_rules('pel_pengangkatan_sita', 'Tanggal Pelaksanaan Pengangakatan Sita', 'trim|exact_length[10]|xss_clean');
		}
		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}

		$pen_sita = $this->tanggalhelper->convertToMysqlDate($this->input->post('pen_sita',TRUE));

		$dayname = $this->tanggalhelper->getDayName($pen_sita);
		if($dayname=='Saturday' OR $dayname=='Sunday'){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Sita Dihari Libur, Sabtu dan Minggu.'));
			return;
		}

		$curr_date = date('Y-m-d');
		$todayDate = date('m/d/Y');
		$selisih = $this->tanggalhelper->getSelisihHari($pen_sita,$curr_date);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Sita Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
			return;
		}

		$pel_sita = $this->tanggalhelper->convertToMysqlDate($this->input->post('pel_sita',TRUE));
		$dayname = $this->tanggalhelper->getDayName($pel_sita);
		if($dayname=='Saturday' OR $dayname=='Sunday'){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Sita Dihari Libur, Sabtu dan Minggu.'));
			return;
		}

		$selisih = $this->tanggalhelper->getSelisihHari($pen_sita,$pel_sita);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pelaksanaan Sita Tidak Boleh Kurang Dari Tanggal Penetapan Sita'));
			return;
		}
		$this->load->model('penyitaan/list_penyitaan', 'penyitaan');
		$alur_perkara_id = $this->penyitaan->getAlurPerkara($idperkara);
		if(empty($alur_perkara_id) OR intval($alur_perkara_id)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$data = array(
			'perkara_id' => $idperkara,
			'alur_perkara_id' => $alur_perkara_id,
			'penetapan_sita' => $pen_sita,
			'pelaksanaan_sita' => $pel_sita,
			'jenis_sita_nama' => $this->input->post('jenis_sita',TRUE),
			'jenis_barang' => $this->input->post('jenis_barang',TRUE),
			'disita_dari' => $this->input->post('disita_dari',TRUE),
			'penyimpanan_barang' => $this->input->post('penyimpanan_barang',TRUE),
			'catatan_penyitaan' => $this->input->post('keterangan',TRUE)
		);
		
		if(!empty($pen_pengangkatan_sita)){
			$pen_pengangkatan_sita = $this->tanggalhelper->convertToMysqlDate($pen_pengangkatan_sita);
			$dayname = $this->tanggalhelper->getDayName($pen_pengangkatan_sita);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Pengangakatan Sita Dihari Libur, Sabtu dan Minggu.'));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($pel_sita,$pen_pengangkatan_sita);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Pengangakatan Sita Tidak Boleh Kurang Dari Tanggal Pelaksanaan Sita'));
				return;
			}
			$data['penetapan_pengangkatan_sita'] = $pen_pengangkatan_sita;
		}

		if(!empty($pel_pengangkatan_sita)){
			$pel_pengangkatan_sita = $this->tanggalhelper->convertToMysqlDate($pel_pengangkatan_sita);
			$dayname = $this->tanggalhelper->getDayName($pel_pengangkatan_sita);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pelaksanaan Pengangakatan Sita Dihari Libur, Sabtu dan Minggu.'));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($pel_sita,$pel_pengangkatan_sita);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pelaksanaan Pengangakatan Sita Tidak Boleh Kurang Dari Tanggal Pelaksanaan Sita'));
				return;
			}
			$data['pelaksanaan_pengangkatan_sita'] = $pel_pengangkatan_sita;
		}

		$act = $this->input->post('enc_act',TRUE);
		$act = $this->encrypt->decode(base64_decode($act));

		if($act=='add'){
			$exsist = $this->penyitaan->isPerkaraExist($idperkara);
			if($exsist==TRUE){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Sudah Terdaftar.'));
				return;
			}elseif($exsist=='-1'){
				echo json_encode(array('st'=>0,'msg'=>'Something Bad Happen.'));
				return;
			}
			$data['diinput_oleh'] = $this->session->userdata('username');
			$data['diinput_tanggal'] = date("Y-m-d h:i:s",time());
			$result = $this->penyitaan->add_data($data);
		}elseif($act=='updt') {
			$result = $this->penyitaan->update_data($data,$idperkara);
			$data['diperbaharui_oleh'] = $this->session->userdata('username');
			$data['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error Task, Please Refresh Your Browser.'));
			return;
		}
		
		if($result){
			echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
	}

	function validateDelete(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Page'));
			return;
		}
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->load->model('penyitaan/list_penyitaan', 'penyitaan');
		$result = $this->penyitaan->del_data($idperkara);
		if($result){
			echo json_encode(array('st'=>1,'msg'=>'Penghapusan Berhasil.'));
		return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Tidak Berhasil..'));
			return;
		}

	}
	function searchPage(){
		if(empty($_POST)){
			show_404();
		}
		$keyword = $this->input->post('keyword_pihak',TRUE);
		$column = $this->input->post('search_field',TRUE);
		$this->nativesession->set_flash_session('security', TRUE);
		$this->nativesession->set_flash_session('keyword_pihak', $keyword);
		$this->nativesession->set_flash_session('column', $column);
		echo json_encode(array('st'=>1));
	}
}