<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class ManagePenyegelan extends CI_Controller {
	function index(){
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}
		$sec = $this->nativesession->get_flash_session('security');

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$enc = $this->nativesession->get_flash_session('enc');
		$idalurperkara = $this->encrypt->decode(base64_decode($enc));

		$functions = $this->nativesession->get_flash_session('function');
		
		if($functions == 'sort'){
			$col = $this->nativesession->get_flash_session('col');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->sort($col,$enc,$keyword);
		}elseif($functions == 'type'){
			$this->session->set_userdata('asc_desc','DESC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$idalurperkara);
		}elseif($functions == 'page'){
			$page = $this->nativesession->get_flash_session('page');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$column_sorted = $this->nativesession->get_flash_session('col');
			$this->showData($enc,$idalurperkara,$column_sorted,$page,$keyword);
		}elseif($functions == 'search'){
			$keyword ='';
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->session->set_userdata('keyword',$keyword);

			$page = $this->nativesession->get_flash_session('page');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$idalurperkara,3,$page,$keyword);
		}else{
			$this->session->set_userdata('asc_desc','DESC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc);
		}
	}

	function sort($col=null,$enc=null,$keyword=null){
		if($this->session->userdata('asc_desc')){
			if($this->session->userdata('asc_desc')=="DESC"){
				$this->session->set_userdata('asc_desc','ASC');
			}else{
				$this->session->set_userdata('asc_desc','DESC');
			}
		}else{
			$this->session->set_userdata('asc_desc','ASC');
		}
		$idalurperkara = $this->encrypt->decode(base64_decode($enc));
		$this->showData($enc,$idalurperkara,$col,0,$keyword);
	}

	function showData($enc='',$idalurperkara='',$col=3,$start_page=0,$keyword=''){
		$asc_desc = $this->session->userdata('asc_desc');
		if($start_page>0){
			$begin_limit = ($start_page-1)*50;
		}else{
			$begin_limit = 0;
			$start_page = 1;
		}
		$data['page_url'] = 'penyegelan/penyegelan_list';
		$this->load->model('penyegelan/list_penyegelan', 'penyegelan');
		$data['penyegelan'] = $this->penyegelan->getListPenyitaan(9,'DESC',$begin_limit,$idalurperkara,$keyword);
		if($this->session->userdata('total_rows')){
			if($this->session->userdata('total_rows')==-1){
				$data['total_rows'] = $this->penyegelan->fecth_data_num();
				$this->session->set_userdata('total_rows',$data['total_rows']);
			}else{
				$data['total_rows'] = $this->session->userdata('total_rows');
			}
		}else{
			$data['total_rows'] = $this->penyegelan->fecth_data_num();
			$this->session->set_userdata('total_rows',$data['total_rows']);
		}
		$data['list_perkara'] = $this->penyegelan->getNomorPerkara(3);
		$data['page_active'] = $begin_limit;
		$data['idalurperkara'] = 3;
		$data['page_title'] = 'REGISTER PENYITAAN PENYEGELAN';
		$data['main_body'] = 'penyegelan/penyegelan_list';
		$data['enc'] = $enc;
		$data['enc_alurperkara'] = base64_encode($this->encrypt->encode(3));
		$data['enc_act'] = base64_encode($this->encrypt->encode('add'));
		$data['curr_date'] = date('d/m/Y');
		$data['page_number'] = $start_page;
		$data['page_url'] = 'penyegelan/penyegelan_list';
		$data['keyword'] = $keyword;
		$data['column_sorted'] = $col;
		$data['url_requested'] = $this->nativesession->get_flash_session('url_requested');
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body');
	}

	function fetchNoUrut(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Page'));
			return;
		}
		$this->load->model('penyegelan/list_penyegelan', 'penyegelan');
		$noUrut = $this->penyegelan->getNoUrut();
		if(!empty($noUrut)){
			echo json_encode(array('st'=>1,'noUrut'=>$noUrut));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Browser'));
			return;
		}
			
	}
	function fetchData(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Page'));
			return;
		}
		$enc = $this->input->post('val',TRUE);
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('val',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$act = $this->input->post('act',TRUE);

		$this->load->model('penyegelan/list_penyegelan', 'penyegelan');
		$text = '<td style="padding:0px;padding-left:5px;" id="parapihak">';
		if($act=='add'){
			#$exsist = $this->penyegelan->isPerkaraExist($idperkara);
			$exsist = FALSE;
			if($exsist==TRUE){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Sudah Terdaftar.'));
				return;
			}elseif($exsist=='-1'){
				echo json_encode(array('st'=>0,'msg'=>'Something Bad Happen.'));
				return;
			}
			$parapihak = $this->penyegelan->getParaPihak($idperkara);
			$text .= $parapihak;
			$text .= '</td>';
			$enc_act = base64_encode($this->encrypt->encode('add'));
			echo json_encode(array(
				'st'=>1,
				'parapihak'=> $text,
				'enc' => $enc,
				'enc_act' => $enc_act
				));
			return;
		}elseif($act=='updt'){
			$data = $this->penyegelan->getDetilPerkara($idperkara);
			if($data->num_rows>0){
				foreach ($data->result() as $row) {
					$parapihak = $row->para_pihak;
					$no = $row->nomor_perkara;
					$noUrut = $row->nomor_urut_register;
					$penSegel = $row->penetapan_penyegelan;
					$pelSegel = $row->pelaksanaan_penyegelan;
					$jeniBarang = $row->jenis_barang;
					$disita = $row->disita_dari;
					$penyimpanan = $row->penyimpanan_barang;
					$penPengakatan = $row->penetapan_pengangakatan_penyegelan;
					$pelPengangkatan = $row->pelaksanaan_pengangakatan_penyegelan;
					$catatatn = $row->catatan_penyegelan;
				}
				$enc_act = base64_encode($this->encrypt->encode('updt'));
				$text .= $parapihak;
				$text .= '</td>';
				echo json_encode(array(
						'st'=>1,
						'noUrut' => $noUrut,
						'parapihak'=> $text,
						'enc' => $enc,
						'enc_act' => $enc_act,
						'no'=> $no,
						'penSegel'=> $this->tanggalhelper->convertToInputDate($penSegel),
						'pelSegel'=> $this->tanggalhelper->convertToInputDate($pelSegel),
						'jeniBarang'=> $jeniBarang,
						'disita'=> $disita,
						'penyimpanan'=> $penyimpanan,
						'penPengakatan'=> $this->tanggalhelper->convertToInputDate($penPengakatan),
						'pelPengangkatan'=> $this->tanggalhelper->convertToInputDate($pelPengangkatan),
						'catatatn'=> $catatatn
					));
			}else{
				echo json_encode(array(
						'st'=>0,
						'msg'=> 'Perkara Tidak Ditemukan'
					));
				return;
			}
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Something Bad Happen, Please refresh your browser'));
			return;
		}
	}

	function validateInput(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Page'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->form_validation->set_rules('no_urut', 'Nomor Urut Register', 'trim|required|numeric|xss_clean');
		$this->form_validation->set_rules('no_perkara', 'Nomor Perkara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('pen_segel', 'Tanggal Penetapan Sita', 'trim|required|exact_length[10]|xss_clean');
		$this->form_validation->set_rules('pel_segel', 'Tanggal Pelaksanaan Sita', 'trim|required|exact_length[10]|xss_clean');
		$this->form_validation->set_rules('disita_dari', 'Disita Dari', 'trim|required|min_length[5]|xss_clean');
		$this->form_validation->set_rules('penyimpanan_barang', 'Penyimpanan Barang', 'trim|required|min_length[10]|xss_clean');
		
		$pen_pengangkatan_segel= $this->input->post('pen_pengangkatan_segel',TRUE);
		if(!empty($pen_pengangkatan_segel)){
			$this->form_validation->set_rules('pen_pengangkatan_segel', 'Tanggal Penetapan Pengangakatan Penyegelan', 'trim|exact_length[10]|xss_clean');
		}
		
		$pel_pengangkatan_segel = $this->input->post('pel_pengangkatan_segel',TRUE);
		if(!empty($pel_pengangkatan_segel)){
			$this->form_validation->set_rules('pel_pengangkatan_segel', 'Tanggal Pelaksanaan Pengangakatan Penyegelan', 'trim|exact_length[10]|xss_clean');
		}
		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}

		$pen_segel = $this->tanggalhelper->convertToMysqlDate($this->input->post('pen_segel',TRUE));

		$dayname = $this->tanggalhelper->getDayName($pen_segel);
		if($dayname=='Saturday' OR $dayname=='Sunday'){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Penyegelan Dihari Libur, Sabtu dan Minggu.'));
			return;
		}

		$curr_date = date('Y-m-d');
		$todayDate = date('m/d/Y');
		$selisih = $this->tanggalhelper->getSelisihHari($pen_segel,$curr_date);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Penyegelan Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
			return;
		}

		$pel_segel = $this->tanggalhelper->convertToMysqlDate($this->input->post('pel_segel',TRUE));
		$dayname = $this->tanggalhelper->getDayName($pel_segel);
		if($dayname=='Saturday' OR $dayname=='Sunday'){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Penyegelan Dihari Libur, Sabtu dan Minggu.'));
			return;
		}

		$selisih = $this->tanggalhelper->getSelisihHari($pen_segel,$pel_segel);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pelaksanaan Penyegelan Tidak Boleh Kurang Dari Tanggal Penetapan Sita'));
			return;
		}
		$this->load->model('penyegelan/list_penyegelan', 'penyegelan');
		$data = array(
			'perkara_id' => $idperkara,
			'nomor_urut_register' => $this->input->post('no_urut',TRUE),
			'penetapan_penyegelan' => $pen_segel,
			'pelaksanaan_penyegelan' => $pel_segel,
			'jenis_barang' => $this->input->post('jenis_barang',TRUE),
			'disita_dari' => $this->input->post('disita_dari',TRUE),
			'penyimpanan_barang' => $this->input->post('penyimpanan_barang',TRUE),
			'catatan_penyegelan' => $this->input->post('keterangan',TRUE)
		);
		
		if(!empty($pen_pengangkatan_segel)){
			$pen_pengangkatan_segel = $this->tanggalhelper->convertToMysqlDate($pen_pengangkatan_segel);
			$dayname = $this->tanggalhelper->getDayName($pen_pengangkatan_segel);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Pengangakatan Penyegelan Dihari Libur, Sabtu dan Minggu.'));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($pel_segel,$pen_pengangkatan_segel);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Pengangakatan Penyegelan Tidak Boleh Kurang Dari Tanggal Pelaksanaan Penyegelan'));
				return;
			}
			$data['penetapan_pengangakatan_penyegelan'] = $pen_pengangkatan_segel;
		}

		if(!empty($pel_pengangkatan_segel)){
			$pel_pengangkatan_segel= $this->tanggalhelper->convertToMysqlDate($pel_pengangkatan_segel);
			$dayname = $this->tanggalhelper->getDayName($pel_pengangkatan_segel);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pelaksanaan Pengangakatan Penyegelan Dihari Libur, Sabtu dan Minggu.'));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($pel_segel,$pel_pengangkatan_segel);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pelaksanaan Pengangakatan Penyegelan Tidak Boleh Kurang Dari Tanggal Pelaksanaan Penyegelan'));
				return;
			}
			$data['pelaksanaan_pengangakatan_penyegelan'] = $pel_pengangkatan_segel;
		}

		$act = $this->input->post('enc_act',TRUE);
		$act = $this->encrypt->decode(base64_decode($act));

		if($act=='add'){
			$exsist = $this->penyegelan->isPerkaraExist($idperkara);
			if($exsist==TRUE){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Sudah Terdaftar.'));
				return;
			}elseif($exsist=='-1'){
				echo json_encode(array('st'=>0,'msg'=>'Something Bad Happens.'));
				return;
			}
			$data['diinput_oleh'] = $this->session->userdata('username');
			$data['diinput_tanggal'] = date("Y-m-d h:i:s",time());
			$result = $this->penyegelan->add_data($data);
		}elseif($act=='updt') {
			$result = $this->penyegelan->update_data($data,$idperkara);
			$data['diperbaharui_oleh'] = $this->session->userdata('username');
			$data['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error Task, Please Refresh Your Browser.'));
			return;
		}
		
		if($result){
			echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Data Tidak Berhasil Disimpan.'));
			return;
		}
	}

	function validateDelete(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Page'));
			return;
		}
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$this->load->model('penyegelan/list_penyegelan', 'penyegelan');
		$result = $this->penyegelan->del_data($idperkara);
		if($result){
			echo json_encode(array('st'=>1,'msg'=>'Penghapusan Berhasil.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Tidak Berhasil..'));
			return;
		}

	}
	function searchPage(){
		if(empty($_POST)){
			show_404();
		}
		$keyword = $this->input->post('keyword_pihak',TRUE);
		$column = $this->input->post('search_field',TRUE);
		$this->nativesession->set_flash_session('security', TRUE);
		$this->nativesession->set_flash_session('keyword_pihak', $keyword);
		$this->nativesession->set_flash_session('column', $column);
		echo json_encode(array('st'=>1));
	}

	function viewDetil(){
		$segment = $this->uri->segment_array();
		if(count($segment)!=3){
			show_404();
		}
		$idperkara = $this->encrypt->decode(base64_decode($this->uri->segment(3)));
		if(!is_numeric($idperkara) OR intval($idperkara)<0){
			show_404();
		}
		$this->load->model('penyegelan/list_penyegelan', 'penyegelan');
		$data['dataSegel'] = $this->penyegelan->getDetilPerkara($idperkara);
		$this->load->vars($data);
		$this->load->view('penyegelan/penyegelan_view');
	}
}