<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class ManageActioPauliana extends CI_Controller {
	function index(){
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$enc = $this->nativesession->get_flash_session('enc');
		$idalurperkara = $this->encrypt->decode(base64_decode($enc));

		$functions = $this->nativesession->get_flash_session('function');
		if($functions == 'sort'){
			$col = $this->nativesession->get_flash_session('col');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->sort($col,$enc,$keyword);
		}elseif($functions == 'type'){
			$this->session->set_userdata('asc_desc','DESC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$idalurperkara);
		}elseif($functions == 'page'){
			$page = $this->nativesession->get_flash_session('page');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$column_sorted = $this->nativesession->get_flash_session('col');
			$this->showData($enc,$idalurperkara,$column_sorted,$page,$keyword);
		}elseif($functions == 'search'){
			$keyword ='';
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->session->set_userdata('keyword',$keyword);

			$page = $this->nativesession->get_flash_session('page');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$idalurperkara,3,$page,$keyword);
		}else{
			$this->session->set_userdata('asc_desc','DESC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc);
		}
	}

	private function sort($col=null,$enc=null,$keyword=null){
		if($this->session->userdata('asc_desc')){
			if($this->session->userdata('asc_desc')=="DESC"){
				$this->session->set_userdata('asc_desc','ASC');
			}else{
				$this->session->set_userdata('asc_desc','DESC');
			}
		}else{
			$this->session->set_userdata('asc_desc','ASC');
		}
		$idalurperkara = $this->encrypt->decode(base64_decode($enc));
		$this->showData($enc,$idalurperkara,$col,0,$keyword);
	}

	private function showData($enc='',$idalurperkara='',$col=3,$start_page=0,$keyword=''){
		$asc_desc = $this->session->userdata('asc_desc');
		if($start_page>0){
			$begin_limit = ($start_page-1)*50;
		}else{
			$begin_limit = 0;
			$start_page = 1;
		}
		$data['page_url'] = 'actio_pauliana/actio_pauliana_list';
		$this->load->model('actio_pauliana/list_actio_pauliana', 'actio');
		$data['actio'] = $this->actio->getListActio(9,'DESC',$begin_limit,$idalurperkara,$keyword);
		if($this->session->userdata('total_rows')){
			if($this->session->userdata('total_rows')==-1){
				$data['total_rows'] = $this->actio->fecth_data_num();
				$this->session->set_userdata('total_rows',$data['total_rows']);
			}else{
				$data['total_rows'] = $this->session->userdata('total_rows');
			}
		}else{
			$data['total_rows'] = $this->actio->fecth_data_num();
			$this->session->set_userdata('total_rows',$data['total_rows']);
		}
		$data['list_perkara'] = $this->actio->getNomorPerkara(3);
		$data['page_active'] = $begin_limit;

		$data['page_title'] = 'REGISTER PENYITAAN ACTIO PAULIANA';
		$data['main_body'] = 'actio_pauliana/actio_pauliana_list';
		$data['enc'] = $enc;
		$data['idalurperkara'] = 3;
		$data['enc_alurperkara'] = base64_encode($this->encrypt->encode(3));
		$data['enc_act'] = base64_encode($this->encrypt->encode('add'));
		$data['curr_date'] = date('d/m/Y');
		$data['page_number'] = $start_page;
		$data['page_url'] = 'actio_pauliana/actio_pauliana_list';
		$data['keyword'] = $keyword;
		$data['column_sorted'] = $col;
		$data['url_requested'] = $this->nativesession->get_flash_session('url_requested');
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body');
	}

	function fetchData(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Page'));
			return;
		}
		$enc = $this->input->post('val',TRUE);
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('val',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$act = $this->input->post('act',TRUE);

		$this->load->model('actio_pauliana/list_actio_pauliana', 'actio');
		if($act=='add'){
			$exsist = $this->actio->isPerkaraExist($idperkara);
			$exsist=FALSE;
			if($exsist==TRUE){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Sudah Terdaftar.'));
				return;
			}elseif($exsist=='-1'){
				echo json_encode(array('st'=>0,'msg'=>'Something Bad Happen.'));
				return;
			}
			$dataPerkara = $this->actio->getInfoPerkara($idperkara);
			if($dataPerkara!=''){
				if($dataPerkara->num_rows>0){
					foreach ($dataPerkara->result() as $row) {
						$tglPutusan = $this->tanggalhelper->convertDayDate($row->tanggal_putusan);
						$noPerkara = $row->nomor_perkara;
						$tglPendaftaran = $this->tanggalhelper->convertDayDate($row->tanggal_pendaftaran);
						$tglMinutasi = $this->tanggalhelper->convertDayDate($row->tanggal_minutasi);
					}
				}else{
					echo json_encode(array('st'=>0,'msg'=> 'Perkara Tidak Ditemukan'));
					return;
				}
			}else{
					echo json_encode(array('st'=>0,'msg'=> 'Perkara Tidak Ditemukan'));
					return;
				}
			$enc_act = base64_encode($this->encrypt->encode('add'));
			echo json_encode(array(
				'st'=>1,
				'tglPutusan'=> $tglPutusan,
				'tglPendaftaran'=> $tglPendaftaran,
				'tglMinutasi'=> $tglMinutasi,
				'enc' => $enc,
				'enc_act' => $enc_act
				));
			return;
		}elseif($act=='updt'){
			$data = $this->actio->getInfoActio($idperkara);
			if($data->num_rows>0){
				foreach ($data->result() as $row) {
					$tglPutusan = $this->tanggalhelper->convertDayDate($row->tanggal_putusan);
					$noPerkara = $row->nomor_perkara;
					$tglPendaftaran = $this->tanggalhelper->convertDayDate($row->tanggal_pendaftaran);
					$tglMinutasi = $this->tanggalhelper->convertDayDate($row->tanggal_minutasi);
					$alamat = $row->alamat;
					$nama = $row->nama;
					$enc_pihak = $row->idpihak;
					$pekerjaan = $row->pekerjaan;
					$tglPenActio = $this->tanggalhelper->convertToInputDate($row->tanggal_pendaftaran_actio);
					$catatatn = $row->catatan_pendaftaran;
				}
				$enc_act = base64_encode($this->encrypt->encode('updt'));
				$enc_pihak = base64_encode($this->encrypt->encode($enc_pihak));
				echo json_encode(array(
						'st'=>1,
						'enc' => $enc,
						'enc_act' => $enc_act,
						'noPerkara' => $noPerkara,
						'tglPutusan'=> $tglPutusan,
						'tglPendaftaran'=> $tglPendaftaran,
						'tglPendaftaran'=> $tglPendaftaran,
						'tglMinutasi'=> $tglMinutasi,
						'enc_pihak'=> $enc_pihak,
						'alamat'=> $alamat,
						'nama'=> $nama,
						'pekerjaan'=> $pekerjaan,
						'tglPenActio'=> $tglPenActio,
						'catatatn'=> $catatatn
					));
			}else{
				echo json_encode(array(
						'st'=>0,
						'msg'=> 'Perkara Tidak Ditemukan'
					));
				return;
			}
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Something Bad Happen, Please refresh your browser'));
			return;
		}
	}

	function validateInput(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Page'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->form_validation->set_rules('no_perkara', 'Nomor Perkara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tgl_pendaftaran_actio', 'Tanggal Pendaftaran Actio Pauliana', 'trim|required|exact_length[10]|xss_clean');
		$this->form_validation->set_rules('fullname', 'Nama Pemohon', 'trim|required|xss_clean');
		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}

		$tglPendaftaran = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pendaftaran_actio',TRUE));

		$dayname = $this->tanggalhelper->getDayName($tglPendaftaran);
		if($dayname=='Saturday' OR $dayname=='Sunday'){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pendaftaran Actio Pauliana Dihari Libur, Sabtu dan Minggu.'));
			return;
		}

		$curr_date = date('Y-m-d');
		$todayDate = date('m/d/Y');
		$selisih = $this->tanggalhelper->getSelisihHari($tglPendaftaran,$curr_date);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pendaftaran Actio Pauliana Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
			return;
		}
		$this->load->model('actio_pauliana/list_actio_pauliana', 'actio');
		$tglPendaftaranPerkara = $this->actio->getTglPendaftaranKepailitan($idperkara);
		if(empty($tglPendaftaranPerkara)){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pendaftaran Perkara Kepailitan Tidak Ditemukan'));
			return;
		}

		$selisih = $this->tanggalhelper->getSelisihHari($tglPendaftaranPerkara,$tglPendaftaran);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pendaftaran Actio Pauliana Tidak Boleh Kurang Dari Tanggal Pendaftaran Perkara Kepailitan'));
			return;
		}

		$idpihak = $this->encrypt->decode(base64_decode($this->input->post('enc_pihak',TRUE)));

		if(empty($idpihak) OR intval($idpihak)<0){
			echo json_encode(array('st'=>0,'msg'=>'Pihak Tidak DItemukan. Silahkan Memilih Pihak Kembali atau Refresh Your Browser.'));
			return;
		}
		$data = array(
			'perkara_id' => $idperkara,
			'tanggal_pendaftaran_actio' => $tglPendaftaran,
			'pemohon_id' => $idpihak,
			'catatan_pendaftaran' => trim($this->input->post('keterangan',TRUE))
		);
		
		$act = $this->input->post('enc_act',TRUE);
		$act = $this->encrypt->decode(base64_decode($act));

		if($act=='add'){
			$exsist = $this->actio->isPerkaraExist($idperkara);
			if($exsist==TRUE){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Sudah Terdaftar.'));
				return;
			}elseif($exsist=='-1'){
				echo json_encode(array('st'=>0,'msg'=>'Something Bad Happened.'));
				return;
			}
			$data['diinput_oleh'] = $this->session->userdata('username');
			$data['diinput_tanggal'] = date("Y-m-d h:i:s",time());
			$result = $this->actio->add_data($data);
		}elseif($act=='updt') {
			$result = $this->actio->update_data($data,$idperkara);
			$data['diperbaharui_oleh'] = $this->session->userdata('username');
			$data['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error Task, Please Refresh Your Browser.'));
			return;
		}
		
		if($result){
			echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Data Tidak Berhasil Disimpan.'));
			return;
		}
	}

	function validateDelete(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Page'));
			return;
		}
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$this->load->model('actio_pauliana/list_actio_pauliana', 'actio');
		$result = $this->actio->del_data($idperkara);
		if($result){
			echo json_encode(array('st'=>1,'msg'=>'Penghapusan Berhasil.'));
		return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Tidak Berhasil..'));
			return;
		}

	}
	function searchPage(){
		if(empty($_POST)){
			show_404();
		}
		$keyword = $this->input->post('keyword_pihak',TRUE);
		$column = $this->input->post('search_field',TRUE);
		$this->nativesession->set_flash_session('security', TRUE);
		$this->nativesession->set_flash_session('keyword_pihak', $keyword);
		$this->nativesession->set_flash_session('column', $column);
		echo json_encode(array('st'=>1));
		return;
	}

	function viewDetil(){
		$segment = $this->uri->segment_array();
		if(count($segment)!=3){
			show_404();
		}
		$idperkara = $this->encrypt->decode(base64_decode($this->uri->segment(3)));
		if(!is_numeric($idperkara) OR intval($idperkara)<0){
			show_404();
		}
		$this->load->model('actio_pauliana/list_actio_pauliana', 'actio');
		$data['dataActio'] = $this->actio->getDetilPerkara($idperkara);
		$this->load->vars($data);
		$this->load->view('actio_pauliana/actio_pauliana_view');
	}
}