<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Laporan_pid_mil extends CI_Controller {

	function index($enc){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		if(count($segment)!=4){
			show_404();
		}
		
		$this->show($segment[3]);
	}


	function show($enc){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$idalurperkara = $this->encrypt->decode(base64_decode($enc));

		$this->load->model('report/report');
		$year = array(date("Y",time()));
		$tahun_sekarang = date("Y",time());
		$min_tahun = $tahun_sekarang;
		 $query = $this->report->get_tahun($idalurperkara);
		 if($query->num_rows==1){
		 	foreach ($query->result() as $row) {
		 		$min_tahun = $row->years;
		 	}
		 }
		$tmp = $tahun_sekarang;
		if($min_tahun<$tahun_sekarang AND !empty($min_tahun)){
			while (TRUE) {
				$tmp--;
				if($tmp<$min_tahun){
					break;
				}
				array_push($year, $tmp);
			}
		}

		//$idalurperkara='';
		$list_perkara='';
		$data['list_perkara'] = $list_perkara;
		$data['jenis_laporan'] = $this->fetch_jenis_laporan($idalurperkara);
		$data['rekap_laporan'] = $this->fetch_rekap_laporan($idalurperkara);
		$data['tahun'] = $year;
		if($idalurperkara==120){
			$data['page_title'] = 'LAPORAN PIDANA MILITER KEJAHATAN BIASA';	
		}else{
			$data['page_title'] = 'LAPORAN PIDANA MILITER PELANGGARAN';
		}
		

		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('laporan/laporan_pidana_militer');
		$this->load->view('footer');
	}

	function fetch_jenis_laporan($idalurperkara){
		if($idalurperkara==120){
		   $jenis_laporan = array(
				array('nama'=>'LAPORAN KLASIFIKASI PERKARA',
					'id' => '120',
					'lap_pidmil' => '1',
					'tahapan' => '10'),
				array('nama'=>'LAPORAN KEADAAN PERKARA',
					'id' => '120',
					'lap_pidmil' => '2',
					'tahapan' => '10'),
				array('nama'=>'LAPORAN KEUANGAN HASIL PROSES',
					'id' => '120',
					'lap_pidmil' => '3',
					'tahapan' => '10'),
				array('nama'=>'LAPORAN KINERJA HAKIM DAN PANITERA`',
					'id' => '120',
					'lap_pidmil' => '4',
					'tahapan' => '10'),
				array('nama'=>'LAPORAN PERKARA KEJAHATAN YANG MENGAJUKAN UPAYA HUKUM',
					'id' => '120',
					'lap_pidmil' => '5',
					'tahapan' => '10'),	
				);
			
		}elseif($idalurperkara){
  		   	$jenis_laporan = array(
				array('nama'=>'LAPORAN KLASIFIKASI PERKARA PIDANA (PELANGGARAN)',
					'id' => '121',
					'lap_pidmil' => '1',
					'tahapan' => '10'),
				array('nama'=>'LAPORAN KEADAAN PERKARA PIDANA (PELANGGARAN)',
					'id' => '121',
					'lap_pidmil' => '2',
					'tahapan' => '10'),
				array('nama'=>'LAPORAN KEUANGAN HASIL PROSES',
					'id' => '121',
					'lap_pidmil' => '3',
					'tahapan' => '10'),				
				array('nama'=>'LAPORAN KINERJA HAKIM DAN PANITERA',
					'id' => '121',
					'lap_pidmil' => '4',
					'tahapan' => '10'),		
				array('nama'=>'LAPORAN PERKARA PELANGGARAN YANG MENGAJUKAN UPAYA HUKUM',
					'id' => '121',
					'lap_pidmil' => '5',
					'tahapan' => '10'),	
				);
		}
	return $jenis_laporan;
	}

	function fetch_rekap_laporan($idalurperkara){
		if($idalurperkara==120){
			$rekap_laporan = array(
				array('nama'=>'LAPORAN PERIODIK KLASIFIKASI PERKARA PIDANA (KEJAHATAN) BIASA',
					'id' => '1',
					'idalur' => '120',
					'tahapan' => '10'),
				array('nama'=>'LAPORAN PERIODIK KEADAAN PERKARA (KEJAHATAN) BIASA',
					'id' => '2',
					'idalur' => '120',
					'tahapan' => '10'),
				array('nama'=>'LAPORAN REKAPITULASI KEADAAN PERKARA (KEJAHATAN) BIASA TAHUNAN',
					'id' => '3',
					'idalur' => '120',
					'tahapan' => '10'),	
				array('nama'=>'LAPORAN PERIODIK KEUANGAN PERKARA (KEJAHATAN) BIASA PER TAHUN',
					'id' => '4',
					'idalur' => '120',
					'tahapan' => '10'),												
				array('nama'=>'LAPORAN PERIODIK PERKARA KEJAHATAN YANG MENGAJUKAN UPAYA HUKUM',
					'id' => '5',
					'idalur' => '120',
					'tahapan' => '10'),
				array('nama'=>'DAFTAR NOMINATIF PERKARA KEJAHATAN TINGKAT PERTAMA SISA AWAL',
					'id' => '6',
					'idalur' => '120',
					'tahapan' => '10'),
				array('nama'=>'DAFTAR NOMINATIF PERKARA KEJAHATAN TINGKAT PERTAMA MASUK',
					'id' => '7',
					'idalur' => '120',
					'tahapan' => '10'),
				array('nama'=>'DAFTAR NOMINATIF PERKARA KEJAHATAN TINGKAT PERTAMA PUTUS',
					'id' => '8',
					'idalur' => '120',
					'tahapan' => '10'),
				array('nama'=>'DAFTAR NOMINATIF PERKARA KEJAHATAN TINGKAT PERTAMA SISA AKHIR',
					'id' => '9',
					'idalur' => '120',
					'tahapan' => '10'),		
				array('nama'=>'DAFTAR NOMINATIF PERKARA KEJAHATAN UPAYA HUKUM BANDING',
					'id' => '10',
					'idalur' => '120',
					'tahapan' => '10'),		
				array('nama'=>'DAFTAR NOMINATIF PERKARA KEJAHATAN UPAYA HUKUM KASASI',
					'id' => '11',
					'idalur' => '120',
					'tahapan' => '10'),		
				array('nama'=>'DAFTAR NOMINATIF PERKARA KEJAHATAN UPAYA HUKUM PENINJAUAN KEMBALI',
					'id' => '12',
					'idalur' => '120',
					'tahapan' => '10'),		
				array('nama'=>'DAFTAR NOMINATIF PERKARA KEJAHATAN UPAYA HUKUM GRASI',
					'id' => '13',
					'idalur' => '120',
					'tahapan' => '10'),		

				/*							
				array('nama'=>'DAFTAR NOMINATIF PERKARA TINGKAT BANDING SISA AWAL',
					'id' => '99',
					'idalur' => '120',
					'tahapan' => '10'),								
				array('nama'=>'DAFTAR NOMINATIF PERKARA TINGKAT BANDING SISA MASUK',
					'id' => '100',
					'idalur' => '120',
					'tahapan' => '10'),
				*/												
				);
		}elseif($idalurperkara==121){
			$rekap_laporan = array(
				array('nama'=>'LAPORAN PERIODIK KLASIFIKASI PERKARA PIDANA (PELANGGARAN)',
					'id' => '1',
					'idalur' => '121',
					'tahapan' => '10'),
				array('nama'=>'LAPORAN PERIODIK KEADAAN PERKARA PIDANA (PELANGGARAN)',
					'id' => '2',
					'idalur' => '121',
					'tahapan' => '10'),				
				array('nama'=>'LAPORAN REKAPITULASI KEADAAN PERKARA PIDANA (PELANGGARAN) TAHUNAN',
					'id' => '3',
					'idalur' => '121',
					'tahapan' => '10'),			
				array('nama'=>'LAPORAN PERIODIK KEUANGAN PERKARA PIDANA (PELANGGARAN) PER TAHUN',
					'id' => '4',
					'idalur' => '121',
					'tahapan' => '10'),
				array('nama'=>'LAPORAN PERIODIK PERKARA PELANGGARAN YANG MENGAJUKAN UPAYA HUKUM',
					'id' => '5',
					'idalur' => '121',
					'tahapan' => '10'),	
				array('nama'=>'DAFTAR NOMINATIF PERKARA PELANGGARAN TINGKAT PERTAMA SISA AWAL',
					'id' => '6',
					'idalur' => '121',
					'tahapan' => '10'),
				array('nama'=>'DAFTAR NOMINATIF PERKARA PELANGGARAN TINGKAT PERTAMA MASUK',
					'id' => '7',
					'idalur' => '121',
					'tahapan' => '10'),
				array('nama'=>'DAFTAR NOMINATIF PERKARA KEJAHATAN TINGKAT PERTAMA PUTUS',
					'id' => '8',
					'idalur' => '121',
					'tahapan' => '10'),
				array('nama'=>'DAFTAR NOMINATIF PERKARA KEJAHATAN TINGKAT PERTAMA SISA AKHIR',
					'id' => '9',
					'idalur' => '121',
					'tahapan' => '10'),
				array('nama'=>'DAFTAR NOMINATIF PERKARA KEJAHATAN UPAYA HUKUM BANDING',
					'id' => '10',
					'idalur' => '121',
					'tahapan' => '10'),		
				);


		}
	return $rekap_laporan;
	}

}