<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Kurator_list extends CI_Controller {
	function index(){
		#add authorization check hak akses di pihak
		#
		if($this->session->userdata('is_logged_in')===FALSE){
			redirect('login');
		}
		$pageNumber = $this->nativesession->get_flash_session('pageNumber_pihak');
		if(empty($pageNumber)){
			$pageNumber = 1;
			$begin = 0;
		}else{
			$begin = ($pageNumber-1)*30;
		}
		$segment = $this->uri->segment_array();
		$data['enc'] = 'gdhjagdjagjs';
		$data['enc_id'] = '';
		$data['enc_anak'] = '';

		$keyword = $this->nativesession->get_flash_session('keyword_pihak');
		$this->load->model('pihak/list_kurator', 'pihak');
		$data['pihak'] = $this->pihak->getListKurator(1,'DESC',$begin,$keyword);
		$data['total_rows'] = $this->pihak->fecth_data_num();
		$data['page_number'] = $pageNumber;
		$data['current_date'] = date('d/m/Y');
		$data['counter'] = $begin;
		$data['keyword'] = $keyword;
		$data['agama'] = $this->pihak->getListAgama();
		$data['pendidikan'] = $this->pihak->getListPendidikan();
		$data['page_title'] = 'REGISTER KURATOR';
		$data['main_body'] = 'pihak/kurator_list';
		$data['page_url'] = 'pihak/kurator_list';
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_edit');
	}

	
	function fetchPihak($status=0){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Page'));
			return;
		}
		$idPihak = $this->encrypt->decode(base64_decode($this->input->post('val',TRUE)));
		if(is_numeric($idPihak)){
			if($idPihak>0){
				$this->load->model('pihak/list_kurator', 'pihak');
				$result = $this->pihak->getInfoPihak($idPihak);
				if($result!=''){
					if($result->num_rows()>0){
						foreach ($result->result() as $row) {
							$id = base64_encode($this->encrypt->encode($row->id));
							$nama = $row->nama;
							$alamat = $row->alamat;
							$pekerjaan = $row->pekerjaan;
							$tglLahir = $row->tanggal_lahir;
							$tempatLahir = $row->tempat_lahir;
							$jenisPihak = $row->jenis_pihak;
							$IDJenisPihak = $row->jenis_pihak_id;
							$jenisIdentitas = $row->jenis_indentitas;
							$noIdentitas = $row->nomor_indentitas;
							$golDarah = $row->golongan_darah;
							$agama = $row->agama;
							$IDAgama = $row->agama_id;
							$IDStatusKawin = $row->status_kawin_id;
							if($row->jenis_kelamin=='L'){
								$sex = 'Laki Laki';
								$IDSex = 1;
							}elseif($row->jenis_kelamin=='P'){
								$sex = 'Perempuan';
								$IDSex = 2;
							}else{
								$sex='';
								$IDSex = 0;
							}
							$wargaNegara = $row->warga_negara;
							$IDWargaNegara = $row->warga_negara_id;
							$kawin = $row->status_kawin;
							$pendidikan = $row->pendidikan;
							$IDPendidikan = $row->pendidikan_id;
							$keterangan = $row->keterangan;
							if(!empty($tglLahir)){
								$umur = $this->tanggalhelper->getSelisihTahun($tglLahir,date('Y-m-d'));
							}else{
								$umur = "";
							}
							#tanggal_ijin,nomor_ijin,tanggal_penyumpahan,tanggal_pendaftaran_pn
							$tglIzin = $this->tanggalhelper->convertToInputDate($row->tanggal_ijin);
							$noIzin = $row->nomor_ijin;
							$tglSumpah = $this->tanggalhelper->convertToInputDate($row->tanggal_penyumpahan);
							$tglPendaftaran = $this->tanggalhelper->convertToInputDate($row->tanggal_pendaftaran_pn);
							$alamatKantor = $row->alamat_kantor;
							$noTlpKantor = $row->telepon_kantor;
							$faxKantor = $row->fax_kantor;
							$mulaiIzin = $this->tanggalhelper->convertToInputDate($row->mulai_ijin);
							$endIzin = $this->tanggalhelper->convertToInputDate($row->sampai_ijin);

						}
						
						
						echo json_encode(array(
							'st'=>1,
							'enc_pihak'=>$id,
							'nama'=>$nama,
							'jenisPihak'=>$jenisPihak,
							'IDJenisPihak'=>$IDJenisPihak,
							'tempatLahir'=>$tempatLahir,
							'tglLahir'=>$this->tanggalhelper->convertToInputDate($tglLahir),
							'umur'=>$umur,
							'sex'=>$sex,
							'IDSex'=>$IDSex,
							'pekerjaan'=>$pekerjaan,
							'kawin'=>$kawin,
							'statusKawin'=>$kawin,
							'IDStatusKawin'=>$IDStatusKawin,
							'pendidikan'=>$pendidikan,
							'IDPendidikan'=>$IDPendidikan,
							'keterangan'=>$keterangan,
							'jenisIdentitas'=>$jenisIdentitas,
							'noIdentitas'=>$noIdentitas,
							'agama'=>$agama,
							'IDAgama'=>$IDAgama,
							'wargaNegara'=>$wargaNegara,
							'IDWargaNegara'=>$IDWargaNegara,
							'alamat'=>$alamat,
							'golDarah'=>$golDarah,
							'enc_act' =>base64_encode($this->encrypt->encode('updt')),
							'tglIzin' => $tglIzin,
							'noIzin' => $noIzin,
							'tglSumpah' => $tglSumpah,
							'tglPendaftaran' => $tglPendaftaran,
							'alamatKantor' => $alamatKantor,
							'noTlpKantor' => $noTlpKantor,
							'faxKantor' => $faxKantor,
							'mulaiIzin' => $mulaiIzin,
							'endIzin' => $endIzin
							));
						return;
					}
				}
			}
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error, Please Refresh Your Page'));
			return;
		}
	}


	function validateInput(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$nama = trim($this->input->post('kurator_fullname',TRUE));
		$_POST['kurator_fullname'] = str_replace(' ', '', $_POST['kurator_fullname']);
		
		$tempatLahir = trim($this->input->post('kurator_tempat_lahir',TRUE));
		$_POST['kurator_tempat_lahir'] = str_replace(' ', '', $_POST['kurator_tempat_lahir']);

		$this->form_validation->set_rules('kurator_fullname', 'Nama Lengkap', 'trim|required|alpha|xss_clean|valid_naming');
		$this->form_validation->set_rules('kurator_tempat_lahir', 'Tempat Lahir', 'trim|required|alpha|min_length[5]|xss_clean');
		$this->form_validation->set_rules('kurator_tgl_lahir', 'Tanggal Lahir', 'trim|required|exact_length[10]|xss_clean');
		$this->form_validation->set_rules('kurator_umur', 'Umur Pihak', 'trim|numeric|xss_clean');
		
		$this->form_validation->set_rules('kurator_jenis_identitas', 'Jenis Identitas', 'trim|numeric|xss_clean');
		$this->form_validation->set_rules('kurator_no_identitas', 'No Identitas', 'trim|xss_clean');
		
		$this->form_validation->set_rules('kurator_jenis_kelamin', 'Jenis Kelamin', 'trim|required|numeric|xss_clean');
		$this->form_validation->set_rules('kurator_agama', 'Agama', 'trim|required|numeric|xss_clean');
		$this->form_validation->set_rules('kurator_alamat', 'Alamat', 'trim|required|min_length[15]|xss_clean');
		$this->form_validation->set_rules('kurator_alamat_kantor', 'Alamat Kantor', 'trim|required|min_length[15]|xss_clean');
		
		$this->form_validation->set_rules('kurator_status_kawin', 'Status Kawin', 'trim|required|numeric|xss_clean');
		$this->form_validation->set_rules('kurator_pendidikan', 'Tingkat Pendidikan', 'trim|required|numeric|xss_clean');
		$this->form_validation->set_rules('kurator_keterangan', 'kurator_keterangan', 'trim|xss_clean');
		$this->form_validation->set_rules('kurator_email', 'Alamat Email', 'trim|valid_email|xss_clean');
		$this->form_validation->set_rules('kurator_no_tlp', 'No Telepon', 'trim|numeric|min_length[5]|xss_clean');
		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{

			$sex = $this->input->post('kurator_jenis_kelamin',TRUE);
			if($sex<1 AND $sex>3){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Jenis Kelamin Tidak Diketahui.'));
				return;
			}

			if($sex==1){
				$sex='L';
			}elseif ($sex==2) {
				$sex='P';
			}

			$agama = $this->input->post('kurator_agama',TRUE);
			if($agama<1 AND $agama>7){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Agama Tidak Diketahui.'));
				return;
			}

			$pekerjaan = 'Kurator';
			/*
			if($pekerjaan<1 AND $pekerjaan>88){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Jenis Pekerjaan Tidak Diketahui.'));
				return;
			}*/

			$statusKawin = $this->input->post('kurator_status_kawin',TRUE);
			if($statusKawin<1 AND $statusKawin>4){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Status Kawin Tidak Diketahui.'));
				return;
			}

			$pendidikan = $this->input->post('kurator_pendidikan',TRUE);
			if($pendidikan<1 AND $pendidikan>11){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tingkat Pendidikan Tidak Diketahui.'));
				return;
			}


			$act = $this->input->post('act',TRUE);
			$tglLahir = $this->tanggalhelper->convertToMysqlDate($this->input->post('kurator_tgl_lahir',TRUE));
			$umur=$this->input->post('kurator_umur',TRUE);
			if($umur>100 OR $umur<5){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Periksa Kembali Umur Pihak.'.$umur));
				return;
			}

			$curr_date = date('Y-m-d');
			$selisih = $this->tanggalhelper->getSelisihHari($tglLahir,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Periksa Kembali Tanggal Lahir.'));
				return;
			}
			$data_pihak = array(
					'nama' => $nama,
					'jenis_pihak_id' => 1,
					'jenis_indentitas' => $this->input->post('kurator_jenis_identitas',TRUE),
					'nomor_indentitas' => $this->input->post('kurator_no_identitas',TRUE),
					'tempat_lahir' => $tempatLahir,
					'tanggal_lahir' => $tglLahir,
					'jenis_kelamin' => $sex,
					'golongan_darah' => $this->input->post('kurator_gol_darah',TRUE),
					'alamat' => trim($this->input->post('kurator_alamat',TRUE)),
					'agama_id' => $agama,
					'status_kawin' => $statusKawin,
					'pekerjaan' => 'Kurator',
					'pendidikan_id' => $pendidikan,
					'telepon' => trim($this->input->post('kurator_no_tlp',TRUE)),
					'email' => trim($this->input->post('kurator_email',TRUE)),
					'keterangan' => trim($this->input->post('kurator_keterangan',TRUE)),
					'warga_negara_id' => 98
				);
			$dataKurator = array(
				'nama' => trim($nama),
				'alamat_kantor' => trim($this->input->post('kurator_alamat',TRUE)),
				'telepon_kantor' => trim($this->input->post('kurator_no_tlp_office',TRUE)),
				'fax_kantor' => trim($this->input->post('kurator_no_fax',TRUE)),
				'tanggal_ijin' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_izin',TRUE)),
				'nomor_ijin' => trim($this->input->post('kurator_no_induk',TRUE)),
				'mulai_ijin' => $this->tanggalhelper->convertToMysqlDate($this->input->post('mulai_izin',TRUE)),
				'sampai_ijin' => $this->tanggalhelper->convertToMysqlDate($this->input->post('end_izin',TRUE)),
				'tanggal_penyumpahan' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_sumpah',TRUE)),
				'tanggal_pendaftaran_pn' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pendaftaran_pn',TRUE))
			);
			if($act==="add"){
				$data_pihak['diinput_oleh'] = $this->session->userdata('username');
				$data_pihak['diinput_tanggal'] = date("Y-m-d h:i:s",time());
				$dataKurator['diinput_oleh'] = $this->session->userdata('username');
				$dataKurator['diinput_tanggal'] = date("Y-m-d h:i:s",time());
				$this->load->model('pihak/list_kurator', 'pihak');
				$query = $this->pihak->add_data($data_pihak,$dataKurator);
				if($query==TRUE){
					echo json_encode(array('st'=>1,'msg'=>'Berhasil<br /> Data Berhasil Disimpan.'));
					return;
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Error<br /> Coba Ulangi Kembali. Error Code 198'));
					return;
				}
			}elseif ($act==="updt") {
				$idPihak = $this->encrypt->decode(base64_decode($this->input->post('kurator_id',TRUE)));
				if(!is_numeric($idPihak) OR empty($idPihak)){
					echo json_encode(array('st'=>0,'msg'=>'Error:<br /> System Error, Please refresh your browser.Error Code 199'));
				}else{
					$data_pihak['diperbaharui_oleh'] = $this->session->userdata('username');
					$data_pihak['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
					$dataKurator['diperbaharui_oleh'] = $this->session->userdata('username');
					$dataKurator['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
					$this->load->model('pihak/list_kurator', 'pihak');
					$query = $this->pihak->update_data($data_pihak,$dataKurator,$idPihak);
					if($query==TRUE){
						echo json_encode(array('st'=>1,'msg'=>'Berhasil<br /> Data Berhasil Disimpan.'));
						return;
					}else{
						echo json_encode(array('st'=>0,'msg'=>'Error<br /> Coba Ulangi Kembali. Error Code 198'));
						return;
					}
				}
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> System Errorss, Please refresh your browser.Error Code 199'.$act));
			}
		}
	}

	function setPage(){
		if(empty($_POST)){
			show_404();
		}
		$pageNumber = $this->input->post('pageNumber',TRUE);
		$keyword = $this->input->post('keyword',TRUE);
		if(is_numeric($pageNumber) AND $pageNumber>0){
			$this->nativesession->set_flash_session('security', TRUE);
			$this->nativesession->set_flash_session('pageNumber_pihak', $pageNumber);
			$this->nativesession->set_flash_session('keyword_pihak', $keyword);
			echo json_encode(array('st'=>1));
		}else{
			show_404();
		}
	}

	function searchPage(){
		if(empty($_POST)){
			show_404();
		}
		$keyword = $this->input->post('keyword_pihak',TRUE);
		$column = $this->input->post('search_field',TRUE);
		$this->nativesession->set_flash_session('security', TRUE);
		$this->nativesession->set_flash_session('keyword_pihak', $keyword);
		$this->nativesession->set_flash_session('column', $column);
		echo json_encode(array('st'=>1));
	}
}