<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Detil_pk extends CI_Controller {
	function index(){
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$idperkara = $this->nativesession->get_flash_session('perkara_id');
		$this->session->set_userdata('perkaraid',$idperkara);

		if(!is_numeric($idperkara)){
			show_404();
		}
		$view = $this->nativesession->get_flash_session('view');
		if($view==TRUE){
			$this->show_data_detil($idperkara);
		}else{
			$this->show_data($idperkara);
		}
	}

	function show_data_detil($idperkara){
		$data['page_title'] = 'INFORMASI DETIL - PERMOHONAN PENINJAUAN KEMBALI';
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['main_history'] = $this->nativesession->get('main_url_requested');
		$data['history'] = $this->nativesession->get_flash_session('url_requested');
		$this->load->model('perkara/pk','pk');
		$data['infopk'] = $this->pk->fetchpk($idperkara);
		$data['infopkdetil'] = $this->pk->fetchpkDetil($idperkara);
		$data['infomediasi'] = $this->pk->getDataMediasipk($idperkara);
		$data['alur_perkara_id']=$this->tanggalhelper->getIDAlurPerkara($idperkara);
		$data['idjenisperkara'] = $this->tanggalhelper->getIDJenisPerkara($idperkara);


		$this->load->vars($data);
		$this->load->view('perkara_tab/pk');
	}

	function show_data($idperkara){
		$data['page_title'] = 'INFORMASI DETIL - PERMOHONAN PENINJAUAN KEMBALI';
		$this->load->model('perkara/pk','pk');
		
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['main_body'] = 'perkara/detil_pk';
		$data['main_history'] = $this->nativesession->get('main_url_requested');
		$data['history'] = $this->nativesession->get_flash_session('url_requested');
		$data['infopk'] = $this->pk->fetchpk($idperkara);
		$data['infopkdetil'] = $this->pk->fetchpkDetil($idperkara);
		$data['infomediasi'] = $this->pk->getDataMediasipk($idperkara);
		$data['jadwal_pemeriksaan'] = $this->pk->get_jadwal_pemeriksaan($idperkara);
		$data['jumlah_pemeriksaan'] = $data['jadwal_pemeriksaan']->num_rows();

		$queryUrutanPemeriksaan = $this->pk->get_urutan_adwal_sidang($idperkara);
		$data['urutan_jadwal'] = $queryUrutanPemeriksaan->row()->urutan;
		$this->load->model('api/dirput_model','dirput');
                	$put_dirput = $this->dirput->putusan_dirput($idperkara,'perkara_pk','amar_putusan_pk_dok');        

		$alurperdatakhusus=array(3,4,5,6,7,8);
	       	if (in_array($this->tanggalhelper->getIDAlurPerkara($idperkara), $alurperdatakhusus)){
			$data['alur_perkara_id']=3;
		} else {
			$data['alur_perkara_id']=$this->tanggalhelper->getIDAlurPerkara($idperkara);
		}
		$data['alur_perkara_id']=$this->tanggalhelper->getIDAlurPerkara($idperkara);
		$data['perkaraid']=$idperkara;
		$data['dirput'] = $this->dirput->create_dirput($idperkara);
		$data['doc_referensi'] = $this->dirput->doc_ref($this->session->userdata('jenis_pengadilan'),4,$data['alur_perkara_id']);
		$data['surat_pengantar'] = $this->dirput->ambil_pengantar($idperkara,4);
                	$data['pengajuan'] = $this->dirput->ambil_pengajuan($idperkara,4);
		$data['perkaraid_pk']=$idperkara;
                	$data['putusanpk'] = $put_dirput[0]['file_id'];
		$data['jenispengadilan_pk']=$this->session->userdata('jenis_pengadilan');
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '850px';
		$this->ckeditor->config['height'] = '150px';
                	$this->ckeditor->config['readOnly'] ='true';
		
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}


	public function penetapan_majelis_pemeriksa(){
		$this->load->model('perkara/pk','model');
		$segment= $this->uri->segment_array();
		$perkara_id = $segment[3];
		
		$queryHakim = $this->model->getDataHakimPN();
		$hakim = array();
		$hakim[""] = "Pilih";
		foreach ($queryHakim->result() as $row) {
			$hakim[$row->id] = $row->nama_gelar; 
		}


		$query = $this->model->get_data_pk($perkara_id);
		$data['tanggal_penetapan'] = (!empty($query->row()->penetapan_majelis_hakim_pk) ? $this->tanggalhelper->convertToInputDate($query->row()->penetapan_majelis_hakim_pk) : "");
		
		$tmp = explode(',', $query->row()->hakim_id_pk);
		if(count($tmp)>2){
			$data['hakim1'] = $tmp[0];
			$data['hakim2'] = $tmp[1];
			$data['hakim3'] = $tmp[2];
		}else{
			$data['hakim1'] = $query->row()->hakim_id_pk;
		}


		$data['tanggal_sekarang'] = date('d/m/Y');
		$data['hakim_pn'] = $hakim;
		$data['perkara_id'] = $perkara_id;
		$data['alur_perkara_id'] = $this->tanggalhelper->getIDAlurPerkara($perkara_id);

		$this->load->view('perkara/pk/penetapan_majelis_pemeriksa',$data);
	}


	public function simpan_penetapan_majelis_pemeriksa(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		if(empty($_POST)){
			show_404();
		}
		$this->form_validation->set_rules('tgl_penetapan', 'Tanggal Penetapan', 'trim|required|xss_clean');
		$this->form_validation->set_rules('hakim1', 'Hakim', 'trim|required|xss_clean');		
		$this->form_validation->set_rules('perkara_id', 'Data Perkara', 'trim|required|xss_clean');
		$alur_perkara_id = $this->input->post('alur_perkara_id',TRUE);
		if($alur_perkara_id>100){
			$this->form_validation->set_rules('hakim2', 'Hakim', 'trim|xss_clean');
			$this->form_validation->set_rules('hakim3', 'Hakim', 'trim|xss_clean');
		}
		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$this->load->model('perkara/pk','model');
			$tgl_penetapan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_penetapan'));
			$hakim1 = $this->input->post('hakim1');
			$hakim2 = $this->input->post('hakim2');
			$hakim3 = $this->input->post('hakim3');
			$perkara_id = $this->input->post('perkara_id');

			$queryHakim1 = $this->model->get_data_hakim_pn_id($hakim1);
			if($alur_perkara_id>100){
				$queryHakim2 = $this->model->get_data_hakim_pn_id($hakim2);
				$queryHakim3 = $this->model->get_data_hakim_pn_id($hakim3);
			}
			

			if(!empty($hakim2)){
				$namaHakim1 = "Hakim Ketua: ".$queryHakim1->row()->nama_gelar;
				$namaHakim2 = "Hakim Anggota: ".$queryHakim2->row()->nama_gelar;
				$namaHakim3 = "Hakim Anggota: ".$queryHakim3->row()->nama_gelar;

				$hakim_nama = $namaHakim1."<br/>".$namaHakim2."<br/>".$namaHakim3;
				$hakim_id = $hakim1.",".$hakim2.",".$hakim3;
			} else {
				$namaHakim1 = "Hakim: ".$queryHakim1->row()->nama_gelar;
				$hakim_nama = $namaHakim1;
				$hakim_id = $hakim1;
			}

			$dataPK = array("hakim_nama_pk"=>$hakim_nama,
				"penetapan_majelis_hakim_pk"=>$tgl_penetapan,
				"hakim_id_pk"=>$hakim_id,
				"diperbaharui_oleh"=>$this->session->userdata('username'),
				"diperbaharui_tanggal"=>date('Y-m-d H:i:s'));

			$query = $this->model->update_pemeriksaan_pk($perkara_id,$dataPK);
			if($query==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			} else {
				echo json_encode(array('st'=>0,'msg'=>'Data Gagal Disimpan'));
				return;
			}

		}
	}


	public function penetapan_pemeriksaan_pk(){
		$this->load->model('perkara/pk','model');
		$segment = $this->uri->segment_array();
		$data['enc_id'] = $segment[2];
		$perkara_id = $data['enc_id'];

		$queryPK = $this->model->get_data_pk($perkara_id);
		$data['tanggal_penetapan'] = (!empty($queryPK->row()->penetapan_pemeriksaan_pk) ? $this->tanggalhelper->convertToInputDate($queryPK->row()->penetapan_pemeriksaan_pk) : "");

		$queryJadwal = $this->model->get_jadwal_pemeriksaan_pertama($perkara_id);
		$data['tanggal_sidang'] = (!empty($queryJadwal->row()->tanggal_pemeriksaan) ? $this->tanggalhelper->convertToInputDate($queryJadwal->row()->tanggal_pemeriksaan) : "");
		$data['mulai_jam'] = substr($queryJadwal->row()->mulai_jam,0,5);

		$data['perkara_id'] = $perkara_id;

		$queryRuang = $this->model->get_ruang_sidang();
		$ruang = array();
		$ruang[''] = "Pilih";
		foreach ($queryRuang->result() as $row) {
			$ruang[$row->id] = $row->nama; 
		}
		$data['ruang_sidang'] = $ruang;

		$data['current_date'] =date('d/m/Y');
		$this->load->view('perkara/pk/penetapan_pemeriksaan_pk',$data);
	}


	public function hapus_penetapan_pemeriksaan_pk(){
		$this->load->model('perkara/pk','model');
		$segment = $this->uri->segment_array();
		$perkara_id= $segment[3];

		$dataPemeriksaan = array('penetapan_pemeriksaan_pk' => NULL,
					'pemeriksaan_pk' =>NULL,
					'diperbaharui_oleh'=>$this->session->userdata('username'),
					'diperbaharui_tanggal'=>date('Y-m-d H:i:s'));

		$query = $this->model->update_pemeriksaan_pk($perkara_id,$dataPemeriksaan);
		if($query==TRUE){
			$query = $this->model->hapus_pemeriksaan_pk($perkara_id,'1');
			if($query==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Dihapus'));
				return;
			} else {
				echo json_encode(array('st'=>0,'msg'=>'Data Gagal Dihapus'));
				return;
			}
		} else {
			echo json_encode(array('st'=>0,'msg'=>'Data Gagal Dihapus'));
			return;
		}
	}



	public function simpan_penetapan_pemeriksaan_pk(){
		$this->form_validation->set_rules('tanggal_penetapan', 'Tanggal Penetapan Sidang', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tanggal_sidang', 'Tanggal Sidang Pertama', 'trim|required|xss_clean');
		$this->form_validation->set_rules('mulai_jam', 'Jam Sidang Pertama', 'trim|required|xss_clean');
		$this->form_validation->set_rules('ruang_sidang', 'Ruang Pemeriksaan', 'trim|required|xss_clean');
		$this->form_validation->set_rules('perkara_id', 'Data Perkara', 'trim|required|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{

			$this->load->model('perkara/pk','model');

			$tanggal_penetapan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_penetapan'));
			$tanggal_sidang = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_sidang'));
			$mulai_jam = $this->input->post('mulai_jam');
			$perkara_id = $this->input->post('perkara_id');
			$ruang_sidang = $this->input->post('ruang_sidang');


			$queryRuang = $this->model->get_ruang_sidang_id($ruang_sidang);
			$ruangan = $queryRuang->row()->nama;


			$dataPK = array('penetapan_pemeriksaan_pk' =>$tanggal_penetapan ,
				 'pemeriksaan_pk' =>$tanggal_sidang);
			$query = $this->model->update_pemeriksaan_pk($perkara_id,$dataPK);
			if($query==TRUE){
				$cekQuery = $this->model->get_jadwal_pemeriksaan_pertama($perkara_id);
				$pemeriksaan_id = $cekQuery->row()->id;
				if(empty($pemeriksaan_id)){

					$dataPemeriksaan = array('perkara_id' =>$perkara_id , 
							'urutan' =>'1',
							'agenda' => 'Pemeriksaan Peninjauan Kembali',
							'tanggal_pemeriksaan' =>$tanggal_sidang,
							'mulai_jam' =>$mulai_jam,
							'ruangan_id' =>$ruangan_id,
							'ruangan' =>$ruangan,
							'diinput_oleh'=>$this->session->userdata('username'),
							'diinput_tanggal'=>date('Y-m-d H:i:s'));

					$query = $this->model->insert_jadwal_pemeriksaan($dataPemeriksaan);

				} else {
					

					$dataPemeriksaan = array('agenda' => 'Pemeriksaan Peninjauan Kembali',
							'tanggal_pemeriksaan' =>$tanggal_sidang,
							'mulai_jam' =>$mulai_jam,
							'ruangan_id' =>$ruangan_id,
							'ruangan' =>$ruangan,
							'diperbaharui_oleh'=>$this->session->userdata('username'),
							'diperbaharui_tanggal'=>date('Y-m-d H:i:s'));

					$query = $this->model->update_jadwal_pemeriksaan($perkara_id,$pemeriksaan_id,$dataPemeriksaan);
				}

				if($query==TRUE){
					echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
					return;
				} else {
					echo json_encode(array('st'=>0,'msg'=>'Data Berhasil Gagal Disimpan'));
					return;
				}
			}
		}

	}


	public function edit_jadwal_pemeriksaan(){
		$this->load->model('perkara/pk','model');
		$segment = $this->uri->segment_array();
		$data['perkara_id'] = $segment[2];
		$data['urutan'] = $segment[3];
		
		$query = $this->model->edit_jadwal_pemeriksaan($data['perkara_id'],$data['urutan']);
		$data['agenda'] = (!empty($query->row()->agenda) ? $query->row()->agenda : "");
		$data['tanggal_pemeriksaan'] = (!empty($query->row()->tanggal_pemeriksaan) ? $this->tanggalhelper->convertDayDate($query->row()->tanggal_pemeriksaan) : "");
		$data['mulai_jam'] = (!empty($query->row()->mulai_jam) ? substr($query->row()->mulai_jam,0,5) : "");
		$data['sampai_jam'] = (!empty($query->row()->sampai_jam) ? substr($query->row()->sampai_jam,0,5) : "");
		$data['ruangan'] = (!empty($query->row()->ruangan) ? $query->row()->ruangan : "");
		$data['ruangan_id'] = (!empty($query->row()->ruangan_id) ? $query->row()->ruangan_id : "");
		$data['urutan'] = (!empty($query->row()->urutan) ? $query->row()->urutan : "");
		$data['jadwal_id'] = (!empty($query->row()->id) ? base64_encode($this->encrypt->encode($query->row()->id)) : "");


		$data['perkara_id'] = base64_encode($this->encrypt->encode($data['perkara_id']));
		$data['tanggal_sekarang'] = date('d/m/Y');
		$queryRuang = $this->model->get_ruang_sidang();
		$ruang = array();
		$ruang[''] = "Pilih";
		foreach ($queryRuang->result() as $row) {
			$ruang[$row->id] = $row->nama; 
		}
		$data['ruang_sidang'] = $ruang;


		$this->load->view('perkara/pk/edit_jadwal_pemeriksaan_pk',$data);
	}


	public function edit_pendapat_pu(){
		$this->load->model('perkara/pk','model');
		$segment = $this->uri->segment_array();
		$data['perkara_id'] = $segment[3];
				
		$query = $this->model->get_data_pk($data['perkara_id']);

		$data['pendapat_jaksa'] = (!empty($query->row()->pendapat_jaksa) ? $this->tanggalhelper->convertToInputDate($query->row()->pendapat_jaksa) : "");
		$data['isi_pendapat_jaksa'] = (!empty($query->row()->isi_pendapat_jaksa) ? $query->row()->isi_pendapat_jaksa : "");

		$data['tanggal_sekarang'] = date('d/m/Y');

		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '810px';
		$this->ckeditor->config['height'] = '250px';
		
		$this->load->view('perkara/pk/edit_pendapat_pu_tampil',$data);
	}


	public function simpan_pendapat_pu(){
		$this->form_validation->set_rules('tanggal_jaksa', 'Tanggal Sidang Pertama', 'trim|required|xss_clean');
		$this->form_validation->set_rules('jaksa_text', 'Jadwal Pemeriksaan', 'trim|required|xss_clean');
		$this->form_validation->set_rules('perkara_id', 'Data Perkara', 'trim|required|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$this->load->model('perkara/pk','model');
			
			$perkara_id = $this->input->post('perkara_id');
			$tanggal_jaksa = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_jaksa'));

			$jaksa = trim($this->input->post('jaksa_text',TRUE));
			$jaksa = strip_tags($jaksa);
			$jaksa = htmlentities($jaksa, null, 'utf-8');
			$jaksa = str_replace("&nbsp;", " ", $jaksa);

			$data_jadwal = array("pendapat_jaksa"=>$tanggal_jaksa,
				"isi_pendapat_jaksa"=>$jaksa,
				"diperbaharui_oleh"=>$this->session->userdata('username'),
				"diperbaharui_tanggal"=>date('Y-m-d H:i:s'));

			$query = $this->model->update_pemeriksaan_pk($perkara_id,$data_jadwal);
			if($query==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			} else {
				echo json_encode(array('st'=>0,'msg'=>'Data Berhasil Gagal Disimpan'));
				return;
			}
		}
	}


	public function edit_pendapat_hakim(){
		$this->load->model('perkara/pk','model');
		$segment = $this->uri->segment_array();
		$data['perkara_id'] = $segment[3];
				
		$query = $this->model->get_data_pk($data['perkara_id']);

		$data['pendapat_hakim'] = (!empty($query->row()->pendapat_hakim) ? $this->tanggalhelper->convertToInputDate($query->row()->pendapat_hakim) : "");
		$data['isi_pendapat_hakim'] = (!empty($query->row()->isi_pendapat_hakim) ? $query->row()->isi_pendapat_hakim : "");

		$data['tanggal_sekarang'] = date('d/m/Y');

		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '810px';
		$this->ckeditor->config['height'] = '250px';
		
		$this->load->view('perkara/pk/edit_pendapat_hakim_tampil',$data);
	}


	public function simpan_pendapat_hakim(){
		$this->form_validation->set_rules('tanggal_hakim', 'Tanggal Pendapat Hakim', 'trim|required|xss_clean');
		$this->form_validation->set_rules('hakim_text', 'Data Pendapat Hakim', 'trim|required|xss_clean');
		$this->form_validation->set_rules('perkara_id', 'Data Perkara', 'trim|required|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$this->load->model('perkara/pk','model');
			
			$perkara_id = $this->input->post('perkara_id');
			$tanggal_hakim = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_hakim'));

			$hakim = trim($this->input->post('hakim_text',TRUE));
			$hakim = strip_tags($hakim);
			$hakim = htmlentities($hakim, null, 'utf-8');
			$hakim = str_replace("&nbsp;", " ", $hakim);

			$data_jadwal = array("pendapat_hakim"=>$tanggal_hakim,
				"isi_pendapat_hakim"=>$hakim,
				"diperbaharui_oleh"=>$this->session->userdata('username'),
				"diperbaharui_tanggal"=>date('Y-m-d H:i:s'));

			$query = $this->model->update_pemeriksaan_pk($perkara_id,$data_jadwal);
			if($query==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			} else {
				echo json_encode(array('st'=>0,'msg'=>'Data Berhasil Gagal Disimpan'));
				return;
			}
		}
	}


	public function hapus_pemeriksaan_pk(){
		$this->load->model('perkara/pk','model');
		$segment = $this->uri->segment_array();
		$perkara_id =  $this->encrypt->decode(base64_decode($segment[3]));
		$urutan = $segment[4];

		$query = $this->model->hapus_pemeriksaan_pk($perkara_id,$urutan);
		if($query==TRUE){
			echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Dihapus'));
			return;
		} else {
			echo json_encode(array('st'=>0,'msg'=>'Data Berhasil Gagal Dihapus'));
			return;
		}
	}




	public function simpan_edit_pemeriksaan(){
		$this->form_validation->set_rules('mulai_jam', 'Tanggal Sidang Pertama', 'trim|required|xss_clean');
		$this->form_validation->set_rules('sampai_jam', 'Jam Mulai Pemeriksaan', 'trim|required|xss_clean');
		$this->form_validation->set_rules('agenda', 'Jam Akhir Pemeriksaan', 'trim|required|xss_clean');
		$this->form_validation->set_rules('ruang_sidang', 'Agenda Pemeriksaan', 'trim|required|xss_clean');
		$this->form_validation->set_rules('keterangan', 'Tempat Pemeriksaan', 'trim|required|xss_clean');
		$this->form_validation->set_rules('jadwal_id', 'Jadwal Pemeriksaan', 'trim|required|xss_clean');
		$this->form_validation->set_rules('perkara_id', 'Data Perkara', 'trim|required|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$this->load->model('perkara/pk','model');
			$mulai_jam = $this->input->post('mulai_jam');
			$sampai_jam = $this->input->post('sampai_jam');
			$agenda = $this->input->post('agenda');
			$ruangan_id = $this->input->post('ruang_sidang');
			$keterangan = $this->input->post('keterangan');
			$jadwal_id = $this->encrypt->decode(base64_decode($this->input->post('jadwal_id')));
			$perkara_id = $this->encrypt->decode(base64_decode($this->input->post('perkara_id')));

			$queryRuang = $this->model->get_ruang_sidang_id($ruangan_id);
			$ruangan = $queryRuang->row()->nama;

			$data_jadwal = array("mulai_jam"=>$mulai_jam,
				"sampai_jam"=>$sampai_jam,
				"agenda"=>$agenda,
				"ruangan_id"=>$ruangan_id,
				"ruangan"=>$ruangan,
				"keterangan"=>$keterangan,
				"diperbaharui_oleh"=>$this->session->userdata('username'),
				"diperbaharui_tanggal"=>date('Y-m-d H:i:s'));

			$query = $this->model->update_jadwal_pemeriksaan($perkara_id,$jadwal_id,$data_jadwal);
			if($query==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			} else {
				echo json_encode(array('st'=>0,'msg'=>'Data Berhasil Gagal Disimpan'));
				return;
			}
		}
	}



	public function tunda_jadwal_pemeriksaan(){
		$this->load->model('perkara/pk','model');
		$segment = $this->uri->segment_array();
		$perkara_id = $segment[2];
		$urutan = $segment[3];
		
		$query = $this->model->edit_jadwal_pemeriksaan($perkara_id,$urutan);
		$data['agenda'] = (!empty($query->row()->agenda) ? $query->row()->agenda : "");
		$data['tanggal_pemeriksaan'] = (!empty($query->row()->tanggal_pemeriksaan) ? $this->tanggalhelper->convertDayDate($query->row()->tanggal_pemeriksaan) : "");
		$data['mulai_jam'] = (!empty($query->row()->mulai_jam) ? substr($query->row()->mulai_jam,0,5) : "");
		$data['sampai_jam'] = (!empty($query->row()->sampai_jam) ? substr($query->row()->sampai_jam,0,5) : "");
		$data['ruangan_id'] = (!empty($query->row()->ruangan_id) ? $query->row()->ruangan_id : "");
		$data['jadwal_id'] = (!empty($query->row()->id) ? $query->row()->id : "");
		$data['alasan_ditunda'] = (!empty($query->row()->alasan_ditunda) ? $query->row()->alasan_ditunda : "");

		$data['perkara_id'] = base64_encode($this->encrypt->encode($perkara_id));
		$data['urutan'] =  base64_encode($this->encrypt->encode($urutan));

		$data['tanggal_sekarang'] = date('d/m/Y');

		$queryRuang = $this->model->get_ruang_sidang();
		$ruang = array();
		$ruang[''] = "Pilih";
		foreach ($queryRuang->result() as $row) {
			$ruang[$row->id] = $row->nama; 
		}
		$data['ruang_sidang'] = $ruang;

		$this->load->view('perkara/pk/tunda_jadwal_pemeriksaan_pk',$data);
	}


	public function simpan_tunda_pemeriksaan(){
		$this->form_validation->set_rules('jadwal_id', 'Data Sidang', 'trim|required|xss_clean');
		$this->form_validation->set_rules('perkara_id', 'Data Perkara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('jam_mulai_sebelum', 'Jam Mulai Pemeriksaan Sebelumnya', 'trim|required|xss_clean');
		$this->form_validation->set_rules('jam_selesai_sebelum', 'Jam Selesai Pemeriksaan Sebelumnya', 'trim|required|xss_clean');
		$this->form_validation->set_rules('agenda_sebelum', 'Agenda Sidang Pemeriksaan Sebelumnya', 'trim|required|xss_clean');
		$this->form_validation->set_rules('ruang_sidang_sebelum', 'Ruang Sidang Pemeriksaan Sebelumnya', 'trim|required|xss_clean');
		$this->form_validation->set_rules('alasan_tunda', 'Alasan Tunda Sidang Pemeriksaan', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tgl_sidang', 'Tanggal Tunda Sidang Pemeriksaan', 'trim|required|xss_clean');
		$this->form_validation->set_rules('jam_mulai_sesudah', 'Jam Tunda Pemeriksaan', 'trim|required|xss_clean');
		$this->form_validation->set_rules('agenda_sesudah', 'Agenda Tunda Pemeriksaan', 'trim|required|xss_clean');
		$this->form_validation->set_rules('ruang_sidang_sesudah', 'Agenda Tunda Pemeriksaan', 'trim|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$this->load->model('perkara/pk','model');

			$jadwal_id = $this->encrypt->decode(base64_decode($this->input->post('jadwal_id')));
			$perkara_id = $this->encrypt->decode(base64_decode($this->input->post('perkara_id')));
			$jam_mulai_sebelum = $this->input->post('jam_mulai_sebelum');
			$jam_selesai_sebelum = $this->input->post('jam_selesai_sebelum');
			$agenda_sebelum = $this->input->post('agenda_sebelum');
			$ruang_sidang_sebelum = $this->input->post('ruang_sidang_sebelum');
			$alasan_tunda = $this->input->post('alasan_tunda');
			$tgl_sidang = $this->input->post('tgl_sidang');
			$jam_mulai_sesudah = $this->input->post('jam_mulai_sesudah');
			$agenda_sesudah = $this->input->post('agenda_sesudah');
			$ruang_sidang_sesudah = $this->input->post('ruang_sidang_sesudah');

			$queryRuangLama = $this->model->get_ruang_sidang_id($ruang_sidang_sebelum);
			$ruangan_lama = $queryRuangLama->row()->nama;

			$queryRuangBaru = $this->model->get_ruang_sidang_id($ruang_sidang_sesudah);
			$ruangan_baru = $queryRuangBaru->row()->nama;
			
			$queryUrutan = $this->model->get_urutan_adwal_sidang($perkara_id);
			$urutan_baru = $queryUrutan->row()->urutan+1;

			$data_jadwal_lama = array("mulai_jam"=>$jam_mulai_sebelum,
				"sampai_jam"=>$jam_selesai_sebelum,
				"agenda"=>$agenda_sebelum,
				"ruangan_id"=>$ruang_sidang_sebelum,
				"ruangan"=>$ruangan_lama,
				"alasan_ditunda"=>$alasan_tunda,
				"diperbaharui_oleh"=>$this->session->userdata('username'),
				"diperbaharui_tanggal"=>date('Y-m-d H:i:s'));

			$queryUpdate = $this->model->update_jadwal_pemeriksaan($perkara_id,$jadwal_id,$data_jadwal_lama);

			if($queryUpdate==TRUE){
				$data_jadwal_baru = array("mulai_jam"=>$jam_mulai_sesudah,
					"perkara_id"=>$perkara_id,
					"urutan"=>$urutan_baru,
					"tanggal_pemeriksaan"=>$this->tanggalhelper->convertToMysqlDate($tgl_sidang),
					"agenda"=>$agenda_sesudah,
					"ruangan_id"=>$ruang_sidang_sesudah,
					"ruangan"=>$ruangan_baru,
					"ditunda"=>'Y',
					"diinput_oleh"=>$this->session->userdata('username'),
					"diinput_tanggal"=>date('Y-m-d H:i:s'));

				$queryInsert = $this->model->insert_jadwal_pemeriksaan($data_jadwal_baru);
				
				if($queryInsert==TRUE){
					echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
					return;
				} else {
					echo json_encode(array('st'=>0,'msg'=>'Data Gagal Disimpan'));
					return;
				}
			} else {
				echo json_encode(array('st'=>0,'msg'=>'Data Gagal Disimpan'));
				return;
			}

		}

	}


	


	



	function parapihak(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc_id'] = $segment[3];
		$data['id'] = $this->encrypt->decode(base64_decode($segment[3]));
		if(empty($data['id']) OR intval($data['id'])<1){
			show_404();
		}
		$data['history'] = base_url(uri_string());
		$this->load->model('perkara/pk','pk');
		$data['infopihak'] = $this->pk->getPihakpk($data['id']);
		$this->load->vars($data);
		$this->load->view('perkara/pk/edit_para_pihak');
	}

	function saveparapihak(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}
		$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
		if(empty($id) OR intval($id)<1){
			echo json_encode(array('st'=>0,'msg'=>'Permohonan PK Tidak Ditemukan.'));
			return;
		}

		$diwakilkan = $this->input->post('diwakilkan',TRUE);
		if(empty($diwakilkan) OR !is_numeric($diwakilkan)){
			echo json_encode(array('st'=>0,'msg'=>'Something Not Right With The Data.'));
			return;
		}
		if($diwakilkan==1){
			$diwakilkan = 'Y';
			$this->form_validation->set_rules('fullname', 'Nama Pemohon', 'trim|required|xss_clean');
		}else{
			$diwakilkan = 'T';
		}
		$this->form_validation->set_rules('diwakilkan', 'Status Diwakilkan', 'trim|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$datapihak = array(
				'id' => $id,
				'pihak_diwakili' => $diwakilkan,
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);
			$idpihak = $this->encrypt->decode(base64_decode($this->input->post('enc_pihak',TRUE)));

			if(empty($idpihak) OR intval($idpihak)<1){
				echo json_encode(array('st'=>0,'msg'=>'Something Not Right With Your Data.'));
				return;
			}
			$this->load->model('perkara/pk','pk');
			$pihak = $this->pk->getDataPihak($idpihak);
			if($pihak!=""){
				if($pihak->num_rows>0){
					foreach ($pihak->result() as $row) {
						$datapihak['pemohon_id'] = $row->id;
						$datapihak['pemohon_nama'] = $row->nama;
						$datapihak['pemohon_alamat'] = $row->alamat;
						$datapihak['pemohon_pekerjaan'] = $row->pekerjaan;
					}
				}
			}

			if($diwakilkan=='Y'){
				$infopihak = $this->pk->getPihakpk($id);
				if($infopihak!=''){
					if($infopihak->num_rows>0){
						foreach ($infopihak->result() as $row) {
							$namapihak = $row->pihak_nama;
							$statusasal = $row->pihak_asal_text;
						}
					}
					$datapihak['pemohon_pk'] = $datapihak['pemohon_nama'].' Kuasa Dari '.$statusasal.':<br>'.$namapihak;
					$tglsuratkuasa = $this->input->post('tgl_surat_kuasa',TRUE);
					if(!empty($tglsuratkuasa)){
						$datapihak['pemohon_tanggal_surat'] = $this->tanggalhelper->convertToMysqlDate($tglsuratkuasa);
					}
					if($this->input->post('no_kuasa',TRUE))
						$datapihak['pemohon_nomor_surat'] = $this->input->post('no_kuasa',TRUE);
				}
			}
			$result = $this->pk->update_data($datapihak,$id);
			if($result==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DISIMPAN.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL Melakukan Penyimpanan.'));
				return;
			}
		}
	}

	function permohonan(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc_id'] = $segment[3];
		$data['id'] = $this->encrypt->decode(base64_decode($segment[3]));
		$data['enc'] = $segment[2];
		$idperkara = $this->encrypt->decode(base64_decode($segment[2]));
		if(empty($data['id']) OR intval($data['id'])<1){
			show_404();
		}
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}

		$data['history'] = base_url(uri_string());
		$data['current_date'] =date('d/m/Y');
		$this->load->model('perkara/pk','pk');

		$data['infopihak'] = $this->pk->getPihakpk($data['id']);
		$data['tgl_bht'] = $this->pk->getPutusanpkBHT($idperkara);
		$idalurperkara = $this->pk->getAlurPerkara($idperkara);
		$data['enc_alur']=base64_encode($this->encrypt->encode($idalurperkara));

		$stpihak = $this->pk->getStatusPihak($idalurperkara);
		if($stpihak!=''){
			if($stpihak->num_rows>0){
				foreach ($stpihak->result() as $row) {
					$statuspihak[$row->pihak_ke] = $row->nama;
				}
			}
		}
		$data['statuspihak'] = $statuspihak;
		$data['idalurperkara'] = $idalurperkara;
		$this->load->vars($data);
		$this->load->view('perkara/pk/edit_permohonan_pk');
	}

	function savepermohonan(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}
		$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
		if(empty($id) OR intval($id)<1){
			echo json_encode(array('st'=>0,'msg'=>'Permohonan PK Tidak Ditemukan.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->form_validation->set_rules('tgl_pendaftaran', 'Tanggal Permohonan PK', 'trim|required|xss_clean|exact_length[10]');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$tglPendaftaran = $this->input->post("tgl_pendaftaran",TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			if($this->session->userdata('jenis_pengadilan')==3){
				$tgl_bht = $this->input->post("tgl_bht",TRUE);
				if(empty($tgl_bht)){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Perkara Belum Berkekuatan Hukum Tetap (BHT). Silakan isi tanggal BHT'));
					return;
				}
			}


			$tglPendaftaran = $this->tanggalhelper->convertToMysqlDate($tglPendaftaran);
			if($tglPendaftaran==FALSE){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPendaftaran,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Permohonan Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}


			$dayname = $this->tanggalhelper->getDayName($tglPendaftaran);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Permohonan Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglcabut = '';
			$tglPutusanPN = '';
			$this->load->model('perkara/pk','pk');
			$dataputusan = $this->pk->getTanggalPutusan($idperkara);
			if($dataputusan->num_rows>0){
				foreach ($dataputusan->result() as $row) {
					$tglPutusanPN = $row->tanggal_putusan;
					$tglcabut = $row->tanggal_cabut;
				}
			}
			if(!empty($tglcabut)){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Dapat Dimohonkan pk Karena Telah Dicabut.'));
				return;
			}

			if(empty($tglPutusanPN)){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Dapat Dimohonkan pk Karena Belum Putus.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusanPN,$tglPendaftaran);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pendaftaran Tidak Boleh Kurang Dari Tanggal Putusan'));
				return;
			}


			$datapihak = array(
				'permohonan_pk' => $tglPendaftaran,
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);
			$result = $this->pk->update_data($datapihak,$id);

			$datapk = $this->pk->getPihakpk($id);
			$idstatus = "";
			$urutan ="";
			if($datapk->num_rows>0){
				foreach ($datapk->result() as $row) {
					$idstatus = $row->status_pihak_id;
					$urutan = $row->urutan_pk;
				}
			}
			if(!empty($idstatus) AND !empty($urutan)){
				if($idstatus==1 AND $urutan==1){
					$datapihak = array(
						'permohonan_pk' => $tglPendaftaran,
						'diperbaharui_oleh' => $this->session->userdata('username'),
						'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);
					$result = $this->pk->update_data_pk($datapihak,$idperkara);
				}
			}
			if($result==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DISIMPAN.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN PENYIMPANAN.'));
				return;
			}
		}
	}

	function cabut(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc_id'] = $segment[3];
		$data['id'] = $this->encrypt->decode(base64_decode($segment[3]));
		$data['enc'] = $segment[2];
		$idperkara = $this->encrypt->decode(base64_decode($segment[2]));
		if(empty($data['id']) OR intval($data['id'])<1){
			show_404();
		}
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}

		$data['history'] = base_url(uri_string());
		$data['current_date'] =date('d/m/Y');
		$this->load->model('perkara/pk','pk');
		$data['infopihak'] = $this->pk->getPihakpk($data['id']);
		$this->load->vars($data);
		$this->load->view('perkara/pk/cabut_permohonan_pk');
	}

	function savecabut(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}

		$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
		if(empty($id) OR intval($id)<1){
			echo json_encode(array('st'=>0,'msg'=>'Permohonan PK Tidak Ditemukan.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->form_validation->set_rules('tgl_cabut', 'Tanggal Pencabutan Perkara', 'trim|required|xss_clean|exact_length[10]');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$tglCabut = $this->input->post('tgl_cabut',TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tglCabut = $this->tanggalhelper->convertToMysqlDate($tglCabut);
			if($tglCabut==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglCabut,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pencabutan Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}


			$dayname = $this->tanggalhelper->getDayName($tglCabut);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pencabutan Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusanPN = '';
			$this->load->model('perkara/pk','pk');
			$dataputusan = $this->pk->getTanggalPutusan($idperkara);
			if($dataputusan->num_rows>0){
				foreach ($dataputusan->result() as $row) {
					$tglPutusanPN = $row->tanggal_putusan;
				}
			}


			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusanPN,$tglCabut);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pencabutan Tidak Boleh Kurang Dari Tanggal Putusan PN'));
				return;
			}


			$datapihak = array(
				'tanggal_cabut' => $tglCabut,
				'keterangan' => $this->input->post('keterangan',TRUE),
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);
			$result = $this->pk->update_data($datapihak,$id);

			$datapk = $this->pk->getPihakpk($id);
			$idstatus = '';
			$urutan ='';
			if($datapk->num_rows>0){
				foreach ($datapk->result() as $row) {
					$idstatus = $row->status_pihak_id;
					$urutan = $row->urutan_pk;
				}
			}
			if(!empty($idstatus) AND !empty($urutan)){
				if($idstatus==1 AND $urutan==1){
					$datapihak = array(
						'tanggal_cabut' => $tglCabut,
						'minutasi_pk' => $tglCabut,
						'diperbaharui_oleh' => $this->session->userdata('username'),
						'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);
					$result = $this->pk->update_data_pk($datapihak,$idperkara);
				}
			}
			if($result==TRUE){
				$this->pk->update_proses($idperkara,521,'Pencabutan Perkara Peninjauan Kembali');
				$this->pk->addPerkaraProses($idperkara,521,'Pencabutan Perkara Peninjauan Kembali',$tglCabut);
				$this->pk->updatePerkaraProses($idperkara);
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DISIMPAN.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN PENYIMPANAN.'));
				return;
			}
		}
	}

	function edittanggal(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc_id'] = $segment[3];
		$data['id'] = $this->encrypt->decode(base64_decode($segment[3]));
		$data['enc'] = $segment[2];
		$idperkara = $this->encrypt->decode(base64_decode($segment[3]));
		if(empty($data['id']) OR intval($data['id'])<1){
			show_404();
		}
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}
		$func = $segment[4];
		if(empty($func) OR intval($func)<1){
			show_404();
		}
		$data['enc_func'] = base64_encode($this->encrypt->encode($segment[4]));
		$data['openinput'] = 2;
		$this->load->model('perkara/pk','pk');
		$infopihaks = $this->pk->getPihakpk($data['id']);
		if($infopihaks!=''){
			if($infopihaks->num_rows>0){
				foreach ($infopihaks->result() as $row) {
					$data['namapihak'] = $row->pihak_nama;
					$data['statuspk'] = $row->status_pihak_text.' Ke-'.$row->urutan_pk;
					$data['noperkarapn'] = $row->nomor_perkara_pn;
					$data['tglpermohonan'] = $this->tanggalhelper->convertToInputDate($row->permohonan_pk);
					$data['idpihak'] = base64_encode($this->encrypt->encode($row->pihak_id));
					$data['idperkara'] = base64_encode($this->encrypt->encode($row->perkara_id));
				}
			}
		}else{
			show_404();
		}
		if($func==1){
			$data['title'] = "Edit - Tanggal Pemberitahuan Permohonan PK";
			$data['subtitle'] = 'Tanggal Pemberitahuan Permohonan';
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($infopihaks->row()->pemberitahuan);
		}elseif($func==2){
			$data['title'] = "Edit - Tanggal Penerimaan Memori PK";
			$data['subtitle'] = 'Tanggal Penerimaan Memori';
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($infopihaks->row()->pen_memori);
		}elseif($func==3){
			$data['title'] = "Edit - Tanggal Penyerahan Memori PK";
			$data['subtitle'] = 'Tanggal Penyerahan Memori';
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($infopihaks->row()->peny_memori);
		}elseif($func==4){
			$data['title'] = "Edit - Tanggal Penerimaan Kontra Memori PK";
			$data['subtitle'] = 'Tanggal Penerimaan Kontra';
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($infopihaks->row()->pen_kontra);
		}elseif($func==5){
			$data['title'] = "Edit - Tanggal Penyerahan Kontra Memori PK";
			$data['subtitle'] = 'Tanggal Penyerahan Kontra';
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($infopihaks->row()->peny_kontra);
		}elseif($func==8){
			$data['title'] = "Edit - Tanggal Pemberitahuan Putusan PK";
			$data['subtitle'] = 'Tanggal Pemberitahuan Putusan';
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($infopihaks->row()->pen_putus);
		}elseif($func==8){
			$data['title'] = "Edit - Tanggal Pemberitahuan Putusan PK";
			$data['subtitle'] = 'Tanggal Pemberitahuan Putusan';
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($infopihaks->row()->pen_putus);
		}elseif($func==7){
			$result = $this->pk->getDatapk($idperkara);
			if($result!=''){
				if($result->num_rows>0){
					foreach ($result->result() as $row) {
						$data['idperkara'] = base64_encode($this->encrypt->encode($row->perkara_id));
						$data['tanggal'] = $this->tanggalhelper->convertToInputDate($row->pengiriman_berkas_pk);
						$data['input_area'] = $row->nomor_surat_pengiriman_berkas_pk;
					}
				}else{
					show_404();
				}
			}else{
				show_404();
			}
			$data['title'] = "Edit - Tanggal Pengiriman Berkas PK";
			$data['subtitle'] = 'Tanggal Pengiriman Berkas';
			$data['openinput'] = 1;
			$data['inputsubtitle'] = 'Nomor Surat Pengiriman Berkas PK';
		}else{
			show_404();
		}
		$data['history'] = base_url(uri_string());
		$data['current_date'] =date('d/m/Y');

		$this->load->vars($data);
		$this->load->view('perkara/pk/edit_tanggal');
	}

	function savetanggal(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}

		$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
		if(empty($id) OR intval($id)<1){
			echo json_encode(array('st'=>0,'msg'=>'Permohonan PK Tidak Ditemukan.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$func = $this->encrypt->decode(base64_decode($this->input->post('enc_func',TRUE)));
		if(empty($func) OR intval($func)<1){
			echo json_encode(array('st'=>0,'msg'=>'Something Wrong With Your Data.'));
			return;
		}

		$this->form_validation->set_rules('tanggal', 'Tanggal', 'trim|required|xss_clean|exact_length[10]');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$tanggal = $this->input->post('tanggal',TRUE);

			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tanggal = $this->tanggalhelper->convertToMysqlDate($tanggal);
			if($tanggal==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tanggal);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$this->load->model('perkara/pk','pk');
			$tglpermohonan = $this->pk->getPermohonanPK($idperkara);
			$selisih = $this->tanggalhelper->getSelisihHari($tglpermohonan,$tanggal);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Tidak Boleh Kurang Dari Tanggal Permohonan'));
				return;
			}

			$tglPutusanPN = '';
			$this->load->model('perkara/pk','pk');
			$dataputusan = $this->pk->getTanggalPutusan($idperkara);
			if($dataputusan->num_rows>0){
				foreach ($dataputusan->result() as $row) {
					$tglPutusanPN = $row->tanggal_putusan;
				}
			}

			if(empty($tglPutusanPN)){
				echo json_encode(array('st'=>0,'msg'=>'Tanggal Putusan Tingkat Pertama Tidak Diketemukan.'));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusanPN,$tanggal);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Tidak Boleh Kurang Dari Tanggal Putusan PN'));
				return;
			}



			$datapihak = array(
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);
			$datapk = $datapihak;
			$tglputusanpk = $this->pk->getTanggalPutusanpk($idperkara);
			if($func==1){
				if(!empty($tglputusanpk)){
					$selisih = $this->tanggalhelper->getSelisihHari($tglputusanpk,$tanggal);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Permohonan PK Tidak Boleh Kurang Dari Tanggal Putusan pk'));
						return;
					}
				}
				$datapihak['pemberitahuan_pk'] = $tanggal;
				$datapk['pemberitahuan_pk'] = $tanggal;
				$dataproses['status_pk_id'] = 520;
				$dataproses['status_pk_text'] = 'Pemberitahuan PK';
			}elseif($func==2){
				if(!empty($tglputusanpk)){
					$selisih = $this->tanggalhelper->getSelisihHari($tglputusanpk,$tanggal);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penerimaan Memori PK Tidak Boleh Kurang Dari Tanggal Putusan pk'));
						return;
					}
				}
				$datapihak['penerimaan_memori_pk'] = $tanggal;
				$datapk['penerimaan_memori_pk'] = $tanggal;
				$dataproses['status_pk_id'] = 521;
				$dataproses['status_pk_text'] = 'Penerimaan Memori PK';
			}elseif($func==3){
				if(!empty($tglputusanpk)){
					$selisih = $this->tanggalhelper->getSelisihHari($tglputusanpk,$tanggal);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penyerahan Memori PK Tidak Boleh Kurang Dari Tanggal Putusan pk'));
						return;
					}
				}
				$datapihak['penyerahan_memori_pk'] = $tanggal;
				$datapk['penyerahan_memori_pk'] = $tanggal;
				$dataproses['status_pk_id'] = 522;
				$dataproses['status_pk_text'] = 'Penyerahan Memori PK';
			}elseif($func==4){
				if(!empty($tglputusanpk)){
					$selisih = $this->tanggalhelper->getSelisihHari($tglputusanpk,$tanggal);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penerimaan Kontra PK Tidak Boleh Kurang Dari Tanggal Putusan pk'));
						return;
					}
				}
				$datapihak['penerimaan_kontra_pk'] = $tanggal;
				$datapk['penerimaan_kontra_pk'] = $tanggal;
				$dataproses['status_pk_id'] = 530;
				$dataproses['status_pk_text'] = 'Penerimaan Penyerahan Jawaban PK';
			}elseif($func==5){
				if(!empty($tglputusanpk)){
					$selisih = $this->tanggalhelper->getSelisihHari($tglputusanpk,$tanggal);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penyerahan Kontra pk Tidak Boleh Kurang Dari Tanggal Putusan pk'));
						return;
					}
				}
				$datapihak['penyerahan_kontra_pk'] = $tanggal;
				$datapk['penyerahan_kontra_pk'] = $tanggal;
				$dataproses['status_pk_id'] = 540;
				$dataproses['status_pk_text'] = 'Penyerahan Jawaban PK';
			}elseif($func==8){
				if(empty($tglputusanpk)){
					echo json_encode(array('st'=>0,'msg'=>'Perkara Belum dinyatakan Putus.'));
					return;
				}
				$selisih = $this->tanggalhelper->getSelisihHari($tglputusanpk,$tanggal);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Putusan pk Tidak Boleh Kurang Dari Tanggal Putusan pk'));
					return;
				}
				$datapihak['pemberitahuan_putusan_pk'] = $tanggal;
				$datapk['pemberitahuan_putusan_pk'] = $tanggal;
				$dataproses['status_pk_id'] = 571;
				$dataproses['status_pk_text'] = 'Pemberitahuan Putusan PK';
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Something Wrong With Your Data.'));
				return;
			}
			$result = $this->pk->update_data($datapihak,$id);
			$result = $this->pk->update_data_pk($datapk,$idperkara);
			if($result==TRUE){
				$this->pk->update_proses($idperkara,$dataproses['status_pk_id'],$dataproses['status_pk_text']);
				$this->pk->update_proses($idperkara,$dataproses['status_pk_id'],$dataproses['status_pk_text']);
				$this->pk->addPerkaraProses($idperkara,$dataproses['status_pk_id'],$dataproses['status_pk_text'],$tanggal);
				$this->pk->updatePerkaraProses($idperkara);
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DISIMPAN.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN PENYIMPANAN.'));
				return;
			}
		}
	}

	function hapus_tanggal_pk(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
		if(empty($id) OR intval($id)<1){
			echo json_encode(array('st'=>0,'msg'=>'Permohonan PK Tidak Ditemukan.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$func = $this->encrypt->decode(base64_decode($this->input->post('enc_func',TRUE)));
		if(empty($func) OR intval($func)<1){
			echo json_encode(array('st'=>0,'msg'=>'Something Wrong With Your Data.'));
			return;
		}

		if($func==1){
				$yang_dihapus = 'Pemberitahuan PK';
				$dataproses['status_pk_id'] = 520;
				$kolom = 'pemberitahuan_pk';
			}elseif($func==2){
				$yang_dihapus = 'Penerimaan Memori PK';
				$dataproses['status_pk_id'] = 521;
				$kolom = 'penerimaan_memori_pk';
			}elseif($func==3){
				$yang_dihapus = 'Penyerahan Memori PK';
				$dataproses['status_pk_id'] = 522;
				$kolom = 'penyerahan_memori_pk';
			}elseif($func==4){
				$yang_dihapus = 'Penerimaan Jawaban PK';
				$dataproses['status_pk_id'] = 530;
				$kolom = 'penerimaan_kontra_pk';
			}elseif($func==5){
				$yang_dihapus = 'Penyerahan Jawaban PK';
				$dataproses['status_pk_id'] = 540;
				$kolom = 'penyerahan_kontra_pk';
			}elseif($func==7){
				$yang_dihapus = 'Pengiriman Berkas PK';
				$dataproses['status_pk_id'] = 550;
				$kolom = 'pengiriman_berkas_pk';
			}elseif($func==8){
				$yang_dihapus = 'Pemberitahuan Putusan PK';
				$dataproses['status_pk_id'] = 571;
				$kolom = 'pemberitahuan_putusan_pk';
			}else{
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Permintaan Tidak Diketahui.'));
				return;
			}

		$diperbaharui = array(
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);

		$this->load->model('perkara/pk','pk');
		if($this->pk->hapus_tgl_pk($id,$idperkara,$kolom,$dataproses,$diperbaharui,$func)){
			echo json_encode(array('st'=>1,'msg'=>'Penghapusan Tanggal '.$yang_dihapus.'  Berhasil'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'));
			return;
		}
	}

	function saveberkas(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$func = $this->encrypt->decode(base64_decode($this->input->post('enc_func',TRUE)));
		if(empty($func) OR intval($func)<1){
			echo json_encode(array('st'=>0,'msg'=>'Something Wrong With Your Data.'));
			return;
		}

		$this->form_validation->set_rules('tanggal', 'Tanggal', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('input_area', 'Nomor Pengiriman Berkas pk', 'trim|required|xss_clean|min_length[5]');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$tanggal = $this->input->post('tanggal',TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tanggal = $this->tanggalhelper->convertToMysqlDate($tanggal);
			if($tanggal==FALSE){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pengiriman Berkas Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tanggal);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$this->load->model('perkara/pk','pk');
			$tglpermohonan = $this->pk->getPermohonanPK($idperkara);
			$selisih = $this->tanggalhelper->getSelisihHari($tglpermohonan,$tanggal);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Tidak Boleh Kurang Dari Tanggal Permohonan'));
				return;
			}

			$tglPutusanPN = '';
			$this->load->model('perkara/pk','pk');
			$dataputusan = $this->pk->getTanggalPutusan($idperkara);
			if($dataputusan->num_rows>0){
				foreach ($dataputusan->result() as $row) {
					$tglPutusanPN = $row->tanggal_putusan;
				}
			}

			if(empty($tglPutusanPN)){
				echo json_encode(array('st'=>0,'msg'=>'Tanggal Putusan Tingkat Pertama Tidak Diketemukan.'));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusanPN,$tanggal);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Tidak Boleh Kurang Dari Tanggal Putusan PN'));
				return;
			}


			$datapihak = array(
				'pengiriman_berkas_pk' => $tanggal,
				'nomor_surat_pengiriman_berkas_pk' => $this->input->post('input_area',TRUE),
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);

			$result = $this->pk->update_data_pk($datapihak,$idperkara);

			if($result==TRUE){
				$this->pk->update_proses($idperkara,550,'Pengiriman Berkas PK');
				$this->pk->addPerkaraProses($idperkara,550,'Pengiriman Berkas PK',$tanggal);
				$this->pk->updatePerkaraProses($idperkara);
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DISIMPAN.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN PENYIMPANAN.'));
				return;
			}
		}
	}

	function putusan(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc'] = $segment[2];
		$idperkara = $this->encrypt->decode(base64_decode($segment[2]));
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}

		$data['history'] = base_url(uri_string());
		$data['current_date'] =date('d/m/Y');
		$data['amar'] = '';

		$this->load->model('perkara/pk','pk');
		$data['listHakim'] = $this->pk->getDataHakimMA();
		$data['listPanitera'] = $this->pk->getDataPaniteraMA();
		$datapk = $this->pk->getDatapk($idperkara);
		if($datapk!=''){
			if($datapk->num_rows>0){
				foreach ($datapk->result() as $row) {
					$data['idperkara'] = base64_encode($this->encrypt->encode($row->perkara_id));
					$data['noperkarapn'] = $row->nomor_perkara_pn;
					$data['input_area'] = $row->nomor_putusan_pk;
					$data['tglpermohonan'] = $this->tanggalhelper->convertDayDate($row->permohonan_pk);
					$data['amar'] = $row->amar_putusan_pk;
					$data['tanggal'] = $this->tanggalhelper->convertToInputDate($row->putusan_pk);
					$data['tgl_arsip'] = $this->tanggalhelper->convertToInputDate($row->minutasi_pk);
					$data['tgl_berkas'] = $this->tanggalhelper->convertToInputDate($row->penerimaan_berkas_pk);
					$data['tglputusan'] = $this->tanggalhelper->convertToInputDate($row->putusan_pn);
					$data['hakim1'] =$row->hakim1_pk_id;
					$data['hakim2'] =$row->hakim2_pk_id;
					$data['hakim3'] =$row->hakim3_pk_id;
					$data['hakim4'] =$row->hakim4_pk_id;
					$data['hakim5'] =$row->hakim5_pk_id;
					$data['panitera'] =$row->panitera_pengganti_pk_id;
					$data['statusputusan'] =$row->status_putusan_pk_id;
				}
			}else{
				show_404();
			}
		}else{
			show_404();
		}

		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '850px';
		$this->ckeditor->config['height'] = '250px';
		$this->load->vars($data);
		$this->load->view('perkara/pk/edit_putusan');
	}

	function saveputusan(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->form_validation->set_rules('tanggal', 'Tanggal Putusan pk', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('input_area', 'Nomor Pengiriman Berkas pk', 'trim|required|xss_clean|min_length[5]');
		#$this->form_validation->set_rules('tgl_arsip', 'Tanggal Pengarsipan Berkas pk', 'trim|required|xss_clean|exact_length[10]');
		#$this->form_validation->set_rules('tgl_berkas', 'Tanggal Penerimaan Kembali Berkas pk', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('amar_text', 'Amar Putusan', 'trim|required|xss_clean|min_length[50]');
		$this->form_validation->set_rules('st_putusan', 'Status Putusan', 'trim|required|numeric|xss_clean|');
		$this->form_validation->set_rules('hakim_ketua', 'Hakim Ketua', 'trim|required|xss_clean|');
		$this->form_validation->set_rules('panitera', 'Panitera Pengganti', 'trim|required|xss_clean|');

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{

			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tanggal = $this->input->post('tanggal',TRUE);
			$tanggal = $this->tanggalhelper->convertToMysqlDate($tanggal);
			if($tanggal==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan Peninjauan Kembali Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tanggal);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Putusan pk Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusanPN = '';
			$this->load->model('perkara/pk','pk');
			$dataputusan = $this->pk->getTanggalPutusan($idperkara);
			if($dataputusan->num_rows>0){
				foreach ($dataputusan->result() as $row) {
					$tglPutusanPN = $row->tanggal_putusan;
				}
			}

			if(empty($tglPutusanPN)){
				echo json_encode(array('st'=>0,'msg'=>'Tanggal Putusan Tingkat Pertama Tidak Diketemukan.'));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusanPN,$tanggal);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan pk Tidak Boleh Kurang Dari Tanggal Putusan PN'));
				return;
			}


			$amar = trim($this->input->post('amar_text',TRUE));
			$amar = strip_tags($amar);
			$amar = htmlentities($amar, null, 'utf-8');
			$amar = str_replace("&nbsp;", " ", $amar);
			if(strlen($amar)<50){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Amar Putusan Tidak Boleh kurang dari 50 Karakter'));
				return;
			}

			$st_putusan = trim($this->input->post('st_putusan',TRUE));
			if(!is_numeric($st_putusan) OR intval($st_putusan)<1){
				if($st_putusan>4){
					echo json_encode(array('st'=>0,'msg'=>'Status Putusan Tidak Ditemukan.'));
					return;
				}
				echo json_encode(array('st'=>0,'msg'=>'Status Putusan Tidak Ditemukan.'));
				return;
			}
			if($st_putusan==1)
				$st_putusan_text = 'Diperbaiki';
			elseif($st_putusan==2)
				$st_putusan_text = 'Dikuatkan';
			elseif($st_putusan==3)
				$st_putusan_text = 'Dibatalkan';
			elseif($st_putusan==4)
				$st_putusan_text = 'Tidak Diterima';
			elseif($st_putusan==5)
				$st_putusan_text = 'Ditolak';

			$datapk = array(
				'amar_putusan_pk' => $amar,
				'putusan_pk' => $tanggal,
				'status_putusan_pk_id' => $st_putusan,
				'status_putusan_pk_text' => $st_putusan_text,
				'nomor_putusan_pk' => $this->input->post('input_area',TRUE),
				'nomor_perkara_pk' => $this->input->post('input_area',TRUE),
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);

			$tglArsip = $this->input->post('tgl_arsip',TRUE);
			if(!empty($tglArsip)){
				$tglArsip = $this->tanggalhelper->convertToMysqlDate($tglArsip);
				if($tglArsip==false){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
					return;
				}

				$dayname = $this->tanggalhelper->getDayName($tglArsip);
				if($dayname=='Saturday' OR $dayname=='Sunday'){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pengarsipan Berkas pk Dihari Libur, Sabtu dan Minggu.'));
					return;
				}

				$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$tglArsip);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pengarsipan Berkas pk Tidak Boleh Kurang Dari Tanggal Putusan pk'));
					return;
				}
				$datapk['minutasi_pk'] = $tglArsip;
			}
			$tglTerimaBerkas = $this->input->post('tgl_berkas',TRUE);
			if(!empty($tglTerimaBerkas)){
				$tglTerimaBerkas = $this->tanggalhelper->convertToMysqlDate($tglTerimaBerkas);
				if($tglTerimaBerkas==false){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
					return;
				}

				$dayname = $this->tanggalhelper->getDayName($tglTerimaBerkas);
				if($dayname=='Saturday' OR $dayname=='Sunday'){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penerimaan Kembali Berkas pk Dihari Libur, Sabtu dan Minggu.'));
					return;
				}

				$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$tglTerimaBerkas);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penerimaan Kembali Berkas pk Tidak Boleh Kurang Dari Tanggal Putusan pk'));
					return;
				}
				$datapk['penerimaan_berkas_pk'] = $tglTerimaBerkas;
			}

			$tmpid = '';
			$listHakim = $this->pk->getDataHakimMA();
			$hakim = $this->input->post('hakim_ketua',TRUE);
			if(!empty($hakim)){
				$idhakimketua = $this->encrypt->decode(base64_decode($hakim));
				if(!is_numeric($idhakimketua) OR intval($idhakimketua)<1){
					echo json_encode(array('st'=>0,'msg'=>'Hakim Ketua Tidak Ditemukan.'));
					return;
				}
				$datapk['hakim1_pk_id'] = $idhakimketua;
				$nama = $this->parseName($listHakim,$idhakimketua);
				if(empty($nama)){
					echo json_encode(array('st'=>0,'msg'=>'Hakim Ketua Tidak Ditemukan.'));
					return;
				}
				$datapk['hakim1_pk'] = $nama;
				$datapk['majelis_hakim_pk'] = 'Hakim Ketua : '.$nama;
				$tmpid[0] = $idhakimketua;
			}

			$hakim = $this->input->post('hakim_anggota_1',TRUE);
			if(!empty($hakim)){
				$idhakim1 = $this->encrypt->decode(base64_decode($hakim));
				if(!is_numeric($idhakim1) OR intval($idhakim1)<1){
					echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 1 Tidak Ditemukan.'));
					return;
				}
				if(empty($idhakimketua)){
					echo json_encode(array('st'=>0,'msg'=>'Hakim Ketua Belum Dipilih.'));
					return;
				}
				$datapk['hakim2_pk_id'] = $idhakim1;
				$nama = $this->parseName($listHakim,$idhakim1);
				if(empty($nama)){
					echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 1 Tidak Ditemukan.'));
					return;
				}
				if(in_array($idhakim1, $tmpid)){
					echo json_encode(array('st'=>0,'msg'=>'Duplikasi Data Hakim. Mohon Memilih Hakim Yang Sesuai'));
					return;
				}
				$tmpid[1] = $idhakim1;
				$datapk['hakim2_pk'] = $nama;
				$datapk['majelis_hakim_pk'] .= '<br>'.'Hakim Anggota 1 : '.$nama;
			}

			$hakim = $this->input->post('hakim_anggota_2',TRUE);
			if(!empty($hakim)){
				$idhakim2 = $this->encrypt->decode(base64_decode($hakim));
				if(!is_numeric($idhakim2) OR intval($idhakim2)<1){
					echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 2 Tidak Ditemukan.'));
					return;
				}
				if(empty($idhakimketua)){
					echo json_encode(array('st'=>0,'msg'=>'Hakim Ketua Belum Dipilih.'));
					return;
				}
				if(empty($idhakim1)){
					echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 1 Belum Dipilih.'));
					return;
				}
				$datapk['hakim3_pk_id'] = $idhakim2;
				$nama = $this->parseName($listHakim,$idhakim2);
				if(empty($nama)){
					echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 2 Tidak Ditemukan.'));
					return;
				}
				if(in_array($idhakim2, $tmpid)){
					echo json_encode(array('st'=>0,'msg'=>'Duplikasi Data Hakim. Mohon Memilih Hakim Yang Sesuai'));
					return;
				}
				$tmpid[2] = $idhakim2;
				$datapk['hakim3_pk'] = $nama;
				$datapk['majelis_hakim_pk'] .= '<br>'.'Hakim Anggota 2 : '.$nama;
			}

			$hakim = $this->input->post('hakim_anggota_3',TRUE);
			if(!empty($hakim)){
				$idhakim3 = $this->encrypt->decode(base64_decode($hakim));
				if(!is_numeric($idhakim3) OR intval($idhakim3)<1){
					echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 3 Tidak Ditemukan.'));
					return;
				}
				if(empty($idhakimketua)){
					echo json_encode(array('st'=>0,'msg'=>'Hakim Ketua Belum Dipilih.'));
					return;
				}
				if(empty($idhakim1)){
					echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 1 Belum Dipilih.'));
					return;
				}
				if(empty($idhakim2)){
					echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 2 Belum Dipilih.'));
					return;
				}
				$datapk['hakim4_pk_id'] = $idhakim3;
				$nama = $this->parseName($listHakim,$idhakim3);
				if(empty($nama)){
					echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 3 Tidak Ditemukan.'));
					return;
				}
				if(in_array($idhakim3, $tmpid)){
					echo json_encode(array('st'=>0,'msg'=>'Duplikasi Data Hakim. Mohon Memilih Hakim Yang Sesuai'));
					return;
				}
				$tmpid[3] = $idhakim3;

				$datapk['hakim4_pk'] = $nama;
				$datapk['majelis_hakim_pk'] .= '<br>'.'Hakim Anggota 3 : '.$nama;
			}

			$hakim = $this->input->post('hakim_anggota_5',TRUE);
			if(!empty($hakim)){
				$idhakim4 = $this->encrypt->decode(base64_decode($hakim));
				if(!is_numeric($idhakim4) OR intval($idhakim4)<1){
					echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 4 Tidak Ditemukan.'));
					return;
				}
				if(empty($idhakimketua)){
					echo json_encode(array('st'=>0,'msg'=>'Hakim Ketua Belum Dipilih.'));
					return;
				}
				if(empty($idhakim1)){
					echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 1 Belum Dipilih.'));
					return;
				}
				if(empty($idhakim2)){
					echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 2 Belum Dipilih.'));
					return;
				}
				if(empty($idhakim3)){
					echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 3 Belum Dipilih.'));
					return;
				}
				$datapk['hakim5_pk_id'] = $idhakim4;
				$nama = $this->parseName($listHakim,$idhakim4);
				if(empty($nama)){
					echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 4 Tidak Ditemukan.'));
					return;
				}
				if(in_array($idhakim4, $tmpid)){
					echo json_encode(array('st'=>0,'msg'=>'Duplikasi Data Hakim. Mohon Memilih Hakim Yang Sesuai'));
					return;
				}
				$tmpid[4] = $idhakim4;
				$datapk['hakim5_pk'] = $nama;
				$datapk['majelis_hakim_pk'] .= '<br>'.'Hakim Anggota 4 : '.$nama;
			}

			$listPanitera = $this->pk->getDataPaniteraMA();
			$panitera = $this->input->post('panitera',TRUE);
			if(!empty($panitera)){
				$idpanitera = $this->encrypt->decode(base64_decode($panitera));
				if(!is_numeric($idpanitera) OR intval($idpanitera)<1){
					echo json_encode(array('st'=>0,'msg'=>'Panitera Pengganti Tidak Ditemukan.'));
					return;
				}
				$datapk['panitera_pengganti_pk_id'] = $idpanitera;
				$nama = $this->parseName($listPanitera,$idpanitera);
				if(empty($nama)){
					echo json_encode(array('st'=>0,'msg'=>'Panitera Pengganti Tidak Ditemukan.'));
					return;
				}
				$datapk['panitera_pengganti_pk'] = $nama;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Panitera Pengganti Belum Dipilih.'));
				return;
			}

			$result = $this->pk->update_data_pk($datapk,$idperkara);

			if($result==TRUE){
				$this->pk->update_proses($idperkara,570,'Putusan PK');
				$this->pk->addPerkaraProses($idperkara,570,'Putusan PK',$tanggal);
				$this->pk->updatePerkaraProses($idperkara);
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DISIMPAN.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN PENYIMPANAN.'));
				return;
			}
		}
	}

	function parseName($list,$idpihak){
		if($list!=''){
			if($list->num_rows>0){
				foreach ($list->result() as $val) {
					if($val->id==$idpihak){
						return $val->nama_gelar;
					}
				}
			}
		}

		return '';
	}

	function confirmationhapusperkara(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc'] = $segment[2];
		$idperkara = $this->encrypt->decode(base64_decode($segment[2]));
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}

		$this->load->vars($data);
		$this->load->view('perkara/pk/hapus_permohonan_pk');
	}

	function hapuspermohonan(){
		try {
			if(empty($_POST)){
				show_404();
			}

			if($this->session->userdata('is_logged_in')==FALSE){
				echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
				return;
			}

			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			if(!is_numeric($idperkara) OR intval($idperkara)<1){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
				return;
			}
			$this->load->model('perkara/pk','pk');
			$result = $this->pk->deletePermohonan($idperkara);
			$this->pk->deletePerkaraProses($idperkara,510);
			if($result==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DIHAPUS.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN DISIMPAN.'));
				return;
			}
		} catch (Exception $e) {

		}
	}

	function editpertimbanganpk(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc'] = $segment[2];
		$idperkara = $this->encrypt->decode(base64_decode($segment[2]));
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}

		$data['history'] = base_url(uri_string());
		$data['current_date'] =date('d/m/Y');
		$data['amar'] = '';

		$this->load->model('perkara/pk','pk');
		$data['listHakimPN'] = $this->pk->getDataHakimPN();
		$data['listHakim'] = $this->pk->getDataHakimMA();
		$data['listPanitera'] = $this->pk->getDataPaniteraMA();
		$datapk = $this->pk->getDatapk($idperkara);

		if($datapk!=''){
			if($datapk->num_rows>0){
				foreach ($datapk->result() as $row) {
					$data['idperkara'] = base64_encode($this->encrypt->encode($row->perkara_id));
					$data['alur_perkara_id'] = base64_encode($this->encrypt->encode($row->alur_perkara_id));
					$data['noperkarapn'] = $row->nomor_perkara_pn;
					$data['tglpermohonan'] = $this->tanggalhelper->convertDayDate($row->permohonan_pk);
					$data['tgl_penetapan'] = $this->tanggalhelper->convertToInputDate($row->penetapan_pemeriksaan_pk);
					$data['tgl_pemeriksaan'] = $this->tanggalhelper->convertToInputDate($row->pemeriksaan_pk);
					$data['tgl_jaksa'] = $this->tanggalhelper->convertToInputDate($row->pendapat_jaksa);
					$data['tgl_hakim'] = $this->tanggalhelper->convertToInputDate($row->pendapat_hakim);
					$data['jaksa'] =$row->isi_pendapat_jaksa;
					$data['hakim'] =$row->isi_pendapat_hakim;
					$data['penetapan_majelis_hakim'] = $row->penetapan_majelis_hakim_pk;
					$data['tgl_sumpah'] =$this->tanggalhelper->convertToInputDate($row->tanggal_penyumpahan);
					if(!empty($row->hakim_id_pk)){
					$majelis_pemeriksa = $row->hakim_id_pk;
					$tmp = explode(',', $majelis_pemeriksa);
					if(count($tmp)>2){
						$data['idketua'] = $tmp[0];
						$data['idAnggota1'] = $tmp[1];
						$data['idAnggota2'] = $tmp[2];
					}else{
						$data['idketua'] = $row->hakim_id_pk;
					}
				}else{
					$data['idketua'] = '';
					$data['idAnggota1'] = '';
					$data['idAnggota2'] = '';
				}
				}
			}else{
				show_404();
			}
		}else{
			show_404();
		}

		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '850px';
		$this->ckeditor->config['height'] = '250px';

		$idalurperkara = $this->tanggalhelper->getIDAlurPerkara($idperkara);
		$this->load->vars($data);
		if($idalurperkara>100)
			$this->load->view('perkara/pk/edit_pertimbangan');
		elseif($idalurperkara<100)
			$this->load->view('perkara/pk/edit_pertimbangan_perdata');
	}

	function savepertimbanganpk(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$alurPerkaraId = $this->encrypt->decode(base64_decode($this->input->post('enc_alur',TRUE)));
		if(!is_numeric($alurPerkaraId) OR intval($alurPerkaraId)<1){
			echo json_encode(array('st'=>0,'msg'=>'Alur Perkara Tidak Ditemukan.'));
			return;
		}

		$this->form_validation->set_rules('tgl_pen_majelis', 'Tanggal Penetapan Majelis', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('tanggal_pen', 'Tanggal Penetapan Pemeriksaan Peninjauan Kembali', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('tanggal_pem', 'Tanggal Pemeriksaan Peninjauan Kembali', 'trim|required|xss_clean|exact_length[10]');
		if($alurPerkaraId>100){
			$this->form_validation->set_rules('tanggal_jaksa', 'Tanggal Pendapat Jaksa', 'trim|required|xss_clean|exact_length[10]');
			$this->form_validation->set_rules('jaksa_text', 'Pendapat Jaksa', 'trim|required|xss_clean|min_length[50]');
			$this->form_validation->set_rules('tanggal_hakim', 'Tanggal Pendapat Hakim', 'trim|required|xss_clean|exact_length[10]');
		}
		if($alurPerkaraId<100){
			$this->form_validation->set_rules('tanggal_sumpah', 'Tanggal Penyumpahan', 'trim|required|xss_clean|exact_length[10]');
		}

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{

			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tanggal_pen = $this->input->post('tanggal_pen',TRUE);
			$tanggal_pen = $this->tanggalhelper->convertToMysqlDate($tanggal_pen);
			if($tanggal_pen==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Penetapan Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tanggal_pen,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Pemeriksaan Peninjauan Kembali Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tanggal_pen);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Pemeriksaan Peninjauan Kembali Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			####
			$tanggal_pem = $this->input->post('tanggal_pem',TRUE);
			$tanggal_pem = $this->tanggalhelper->convertToMysqlDate($tanggal_pem);
			if($tanggal_pem==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Penetapan Pemeriksaan Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tanggal_pem,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemeriksaan Peninjauan Kembali Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tanggal_pem);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pemeriksaan Peninjauan Kembali Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			####
			if($alurPerkaraId>100){
				$tanggal_jaksa = $this->input->post('tanggal_jaksa',TRUE);
				$tanggal_jaksa = $this->tanggalhelper->convertToMysqlDate($tanggal_jaksa);
				if($tanggal_jaksa==false){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Pendapat Jaksa Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
					return;
				}

				$selisih = $this->tanggalhelper->getSelisihHari($tanggal_jaksa,$curr_date);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pendapat Jaksa Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
					return;
				}

				$dayname = $this->tanggalhelper->getDayName($tanggal_jaksa);
				if($dayname=='Saturday' OR $dayname=='Sunday'){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pendapat Jaksa Dihari Libur, Sabtu dan Minggu.'));
					return;
				}

				####
				$tanggal_hakim = $this->input->post('tanggal_hakim',TRUE);
				$tanggal_hakim = $this->tanggalhelper->convertToMysqlDate($tanggal_hakim);
				if($tanggal_hakim==false){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Pendapat Hakim Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
					return;
				}

				$selisih = $this->tanggalhelper->getSelisihHari($tanggal_hakim,$curr_date);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pendapat Hakim Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
					return;
				}

				$dayname = $this->tanggalhelper->getDayName($tanggal_hakim);
				if($dayname=='Saturday' OR $dayname=='Sunday'){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pendapat Hakim Dihari Libur, Sabtu dan Minggu.'));
					return;
				}
			}elseif($alurPerkaraId<100){
				$tanggal_jaksa = NULL;
				$tanggal_hakim = NULL;
			}

			if($alurPerkaraId<100){
				####
				$tanggal_sumpah = $this->input->post('tanggal_sumpah',TRUE);
				$tanggal_sumpah = $this->tanggalhelper->convertToMysqlDate($tanggal_sumpah);
				if(!empty($tanggal_sumpah) && $tanggal_sumpah==false){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Sumpah Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
					return;
				}

				$selisih = $this->tanggalhelper->getSelisihHari($tanggal_sumpah,$curr_date);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pendapat Hakim Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
					return;
				}

				$dayname = $this->tanggalhelper->getDayName($tanggal_sumpah);
				if($dayname=='Saturday' OR $dayname=='Sunday'){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pendapat Hakim Dihari Libur, Sabtu dan Minggu.'));
					return;
				}
			}elseif($alurPerkaraId>100){
				$tanggal_sumpah = NULL;
			}

			if($alurPerkaraId>100){
				$jaksa = trim($this->input->post('jaksa_text',TRUE));
				$jaksa = strip_tags($jaksa);
				$jaksa = htmlentities($jaksa, null, 'utf-8');
				$jaksa = str_replace("&nbsp;", " ", $jaksa);

				if(strlen($jaksa)<50){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Pendapat Jaksa Tidak Boleh kurang dari 50 Karakter'));
					return;
				}

				$hakim = trim($_POST['hakim']);
				$hakim = strip_tags($hakim);
				$hakim = htmlentities($hakim, null, 'utf-8');
				$hakim = str_replace("&nbsp;", " ", $hakim);

				if(strlen($hakim)<50){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Pendapat Hakim Tidak Boleh kurang dari 50 Karakter'));
					return;
				}
			}elseif($alurPerkaraId<100){
				$jaksa = NULL;
				$hakim = NULL;
			}

			$datapk = array(
				'penetapan_pemeriksaan_pk' => $tanggal_pen,
				'pemeriksaan_pk' => $tanggal_pen,
				'pendapat_jaksa' => $tanggal_jaksa,
				'isi_pendapat_jaksa' => $jaksa,
				'pendapat_hakim' => $tanggal_hakim,
				'isi_pendapat_hakim' => $hakim,
				'tanggal_penyumpahan' => $tanggal_sumpah,
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);
			$this->load->model('perkara/pk','pk');

			$tglPenetapan = $this->input->post('tgl_pen_majelis', TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tglPenetapan = $this->tanggalhelper->convertToMysqlDate($tglPenetapan);
			if($tglPenetapan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Penetapan Majelis/Hakim Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPenetapan,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglPenetapan);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$hakimKetua = $this->encrypt->decode(base64_decode($this->input->post('h_ketua', TRUE)));
			$hakimAnggota1 = $this->encrypt->decode(base64_decode($this->input->post('h_anggota1', TRUE)));
			$hakimAnggota2 = $this->encrypt->decode(base64_decode($this->input->post('h_anggota2', TRUE)));
			$majelis_hakim = $this->input->post('majelis_hakim',TRUE);

			if(intval($hakimKetua)<0){
				echo json_encode(array('st'=>0,'msg'=>'Error, Identitas Hakim Ketua Tidak Ditemukan.'));
				return;
			}elseif(empty($hakimKetua)){
				echo json_encode(array('st'=>0,'msg'=>'Error, Pilih Hakim Ketua.'));
				return;
			}
			$hakimKetuaNama = $this->pk->getHakimNama($hakimKetua);

			if($majelis_hakim==1){
				if(intval($hakimAnggota1)<0){
					echo json_encode(array('st'=>0,'msg'=>'Error, Identitas Hakim Anggota I Tidak Ditemukan.'));
					return;
				}elseif(empty($hakimAnggota1)){
					echo json_encode(array('st'=>0,'msg'=>'Error, Pilih Hakim Anggota I.'));
					return;
				}

				$hakimAnggota1Nama = $this->pk->getHakimNama($hakimAnggota1);

				if(intval($hakimAnggota2)<0){
					echo json_encode(array('st'=>0,'msg'=>'Error, Identitas Hakim Anggota II Tidak Ditemukan.'));
					return;
				}elseif(empty($hakimAnggota2)){
					echo json_encode(array('st'=>0,'msg'=>'Error, Pilih Hakim Anggota II.'));
					return;
				}

				$hakimAnggota2Nama = $this->pk->getHakimNama($hakimAnggota2);

				if($hakimKetua==$hakimAnggota1 OR $hakimKetua== $hakimAnggota2 OR $hakimAnggota1==$hakimAnggota2){
					echo json_encode(array('st'=>0,'msg'=>'Error, Tidak Dapat Memilih Hakim Yang Sama.'));
					return;
				}

				$majelisHakimText = 'Hakim Ketua: '.$hakimKetuaNama.'</br>Hakim Anggota 1: '.$hakimAnggota1Nama.'</br>Hakim Anggota 2: '.$hakimAnggota2Nama;
				$majelisHakimID = $hakimKetua.','.$hakimAnggota1.','.$hakimAnggota2;
				$majelisHakimNamaText = $hakimKetuaNama.'</br>'.$hakimAnggota1Nama.'</br>'.$hakimAnggota2Nama;

			}elseif($majelis_hakim==2){
				$majelisHakimText = 'Hakim: '.$hakimKetuaNama;
				$majelisHakimID = $hakimKetua;
				$majelisHakimNamaText = $hakimKetuaNama;
			}

			$dataPenetapan = array(
				'penetapan_majelis_hakim'=>$tglPenetapan,
				'majelis_hakim_id'=>$majelisHakimID,
				'majelis_hakim_nama'=>$majelisHakimNamaText,
				'majelis_hakim_text'=>$majelisHakimText,
				'diperbaharui_oleh'=>$this->session->userdata('username'),
				'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
				);
			$datapk['penetapan_majelis_hakim_pk'] =$tglPenetapan;
			$datapk['hakim_id_pk'] = $majelisHakimID;
			$datapk['hakim_nama_pk'] =$majelisHakimText;

			$tahapan = 40;
			if($majelis_hakim==1){
				$datahakim=array(
					array(
						'perkara_id'=>$idperkara,
						'tahapan_id' => $tahapan,
						'tanggal_penetapan' =>$tglPenetapan,
						'urutan' => 1,
						'jabatan_hakim_id' => 1,
						'jabatan_hakim_nama' => 'Hakim Ketua',
						'hakim_id' => $hakimKetua,
						'hakim_nama' => $hakimKetuaNama,
						'aktif' => 'Y',
						'diinput_oleh'=>$this->session->userdata('username'),
						'diinput_tanggal'=>date('Y-m-d H:i:s')
						),
					array(
						'perkara_id'=>$idperkara,
						'tahapan_id' => $tahapan,
						'tanggal_penetapan' =>$tglPenetapan,
						'urutan' => 2,
						'jabatan_hakim_id' => 2,
						'jabatan_hakim_nama' => 'Hakim Anggota',
						'hakim_id' => $hakimAnggota1,
						'hakim_nama' => $hakimAnggota1Nama,
						'aktif' => 'Y',
						'diinput_oleh'=>$this->session->userdata('username'),
						'diinput_tanggal'=>date('Y-m-d H:i:s')
						),
					array(
						'perkara_id'=>$idperkara,
						'tahapan_id' => $tahapan,
						'tanggal_penetapan' =>$tglPenetapan,
						'urutan' => 3,
						'jabatan_hakim_id' => 2,
						'jabatan_hakim_nama' => 'Hakim Anggota',
						'hakim_id' => $hakimAnggota2,
						'hakim_nama' => $hakimAnggota2Nama,
						'aktif' => 'Y',
						'diinput_oleh'=>$this->session->userdata('username'),
						'diinput_tanggal'=>date('Y-m-d H:i:s')
						)
					);
			}elseif($majelis_hakim==2){
				$datahakim=array(
					array(
						'perkara_id'=>$idperkara,
						'tahapan_id' => $tahapan,
						'tanggal_penetapan' =>$tglPenetapan,
						'urutan' => 1,
						'jabatan_hakim_id' => 1,
						'jabatan_hakim_nama' => 'Hakim',
						'hakim_id' => $hakimKetua,
						'hakim_nama' => $hakimKetuaNama,
						'aktif' => 'Y',
						'diinput_oleh'=>$this->session->userdata('username'),
						'diinput_tanggal'=>date('Y-m-d H:i:s')
						)
					);
			}


			$result = $this->pk->update_data_pk($datapk,$idperkara,$datahakim);
			if($result==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DISIMPAN.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN PENYIMPANAN.'));
				return;
			}
		}
	}

	/*06-12-2016*/
	function hapus_putusan_pk(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$this->load->model('perkara/pk','pk');
		$tgl_pemberitahuan = $this->pk->getInfoTglPemberitahuanPts($idperkara);
		if(!empty($tgl_pemberitahuan)){
			echo json_encode(array('st'=>0,'msg'=>'Data Putusan Tidak Bisa Dihapus, Tanggal Pemberitahuan Putusan PK Sudah Diisi. Hapus dulu tanggal pemberitahuan putusan PK'));
			return;
		}

		$datakasasi = array(
				'putusan_pk' => NULL,
				'nomor_perkara_pk' => NULL,
				'nomor_putusan_pk' => NULL,
				'status_putusan_pk_id' => NULL,
				'status_putusan_pk_text' => NULL,
				'amar_putusan_pk' => NULL,
				'hakim1_pk_id' => NULL,
				'hakim1_pk' => NULL,
				'hakim2_pk_id' => NULL,
				'hakim2_pk' => NULL,
				'hakim3_pk_id' => NULL,
				'hakim3_pk' => NULL,
				'hakim4_pk_id' => NULL,
				'hakim4_pk' => NULL,
				'hakim5_pk_id' => NULL,
				'hakim5_pk' => NULL,
				'majelis_hakim_pk' => NULL,
				'panitera_pengganti_pk_id' => NULL,
				'panitera_pengganti_pk' => NULL,
				'minutasi_pk' => NULL,
				'penerimaan_berkas_pk' => NULL,
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);

		if($this->pk->hapus_putusan($idperkara,$datakasasi)){
			echo json_encode(array('st'=>1,'msg'=>'Penghapusan Data Putusan PK Berhasil'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'));
			return;
		}
	}

}
