<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class detil_perkara_hapus extends CI_Controller {
	function confirmationhapusperkara(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc'] = $segment[2];
		$idperkara = $this->encrypt->decode(base64_decode($segment[2]));
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}

		$data['encalur'] = $segment[3];
		$idalur = $this->encrypt->decode(base64_decode($segment[3]));
		if(empty($idalur) OR intval($idalur)<1){
			show_404();
		}
		$this->load->vars($data);
		$this->load->view('perkara/hapus_perkara');
	}

	function hapus_perkara(){
		try {
			if(empty($_POST)){
				show_404();
			}

			if($this->session->userdata('is_logged_in')==FALSE){
				echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
				return;
			}

			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			if(!is_numeric($idperkara) OR intval($idperkara)<1){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
				return;
			}
			$idalur = $this->encrypt->decode(base64_decode($this->input->post('encalur',TRUE)));
			if(!is_numeric($idalur) OR intval($idalur)<1){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
				return;
			}
			
			if ($idalur>=111 && $idalur<=121){
				$from="datum";
			}else{
				$from="datumpdt";
			}
			// ===== Script ini disesuaikan dengan yang ada di fileupload_c =====
			$this->load->model('fileupload/fileupload_m');
			$idkirim=$idperkara;
			//$from="datum";
			$namadokumen=$this->fileupload_m->get_nama_dok($idkirim,$from);

			//check file and directory to delete
			$arrdirectory=explode('/',$namadokumen);
			array_pop($arrdirectory);
			$direktori=implode("/",$arrdirectory);
			$arrparentdirectory=explode('/',$direktori);
			array_pop($arrparentdirectory);
			$parentdirektori=implode("/",$arrparentdirectory);
			
			//delete the file
			@unlink($namadokumen);
			//delete the directories if empty. if at least one file inside, this script is passed automaticaly
			@rmdir($direktori); 
			@rmdir($parentdirektori); 

			// ===================================================================

			
			$this->load->model('perkara/info_perkara','perkara');
			$result = $this->perkara->hapus_perkara_pn($idperkara);
			
			if($result==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DIHAPUS.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN DISIMPAN.'));
				return;
			}
		} catch (Exception $e) {
			
		}
	}
}
/* End of file detil_perkara_hapus.php */
/* Location: ./application/controllers/detil_perkara_hapus.php */