<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Detil_eksekusi_ht extends CI_Controller {
	function index(){
		#prevent direct access to page
		#the user should only access the page through menu
		if($this->nativesession->get_flash_session('security')===FALSE){
			redirect('main');
		}
		$sec = $this->nativesession->get_flash_session('security');

		if($this->session->userdata('is_logged_in')===FALSE){
			redirect('login');
		}

		$htid = $this->nativesession->get_flash_session('ht_id');
		if(!is_numeric($htid)){
			show_404();
		}
		$this->show_data($htid);
	}

	function show_data($htid){

		$this->load->model('perkara/new_eksekusi_ht','eksekusi');
		$data = $this->parseData($this->eksekusi->get_detil_eksekusi($htid));
		$data['pemohon'] = $this->eksekusi->get_pemohon_eksekusi($htid);
		$data['termohon'] = $this->eksekusi->get_termohon_eksekusi($htid);
		
		$data['ht_id']=base64_encode($this->encrypt->encode($htid));
		$data['page_title'] = 'INFORMASI DETIL PERMOHONAN EKSEKUSI HAK TANGGUNGAN';
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['main_body'] = 'perkara/detil_eksekusi_ht';
		$data['main_history']=$this->nativesession->get('main_url_requested');
		$data['refresh']=$this->nativesession->get('url_requested');
		$data['tgl_sekarang'] = date('d/m/Y');
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}


	function parseData($info_perkara_eksekusi_ht){
		if($info_perkara_eksekusi_ht!=''){
			if($info_perkara_eksekusi_ht->num_rows>0){
				foreach ($info_perkara_eksekusi_ht->result() as $row) {
					$data['tgl_permohonan_eksekusi'] = $row->permohonan_eksekusi;
					$data['pemohon_eksekusi'] = $row->pemohon_eksekusi;
					
					$data['eksekusi_putusan_id'] = $row->eksekusi_putusan_id;
					$data['eksekusi_nomor_perkara'] = $row->eksekusi_nomor_perkara;
					$data['eksekusi_amar_putusan'] = $row->eksekusi_amar_putusan;
					$data['penetapan_teguran_eksekusi'] = $row->penetapan_teguran_eksekusi;
					$data['nomor_penetapan_teguran_eksekusi'] = $row->nomor_penetapan_teguran_eksekusi;
					$data['pelaksanaan_teguran_eksekusi'] = $row->pelaksanaan_teguran_eksekusi;
					$data['penetapan_sita_eksekusi'] = $row->penetapan_sita_eksekusi;
					$data['nomor_penetapan_sita_eksekusi'] = $row->nomor_penetapan_sita_eksekusi;
					$data['pelaksanaan_sita_eksekusi'] = $row->pelaksanaan_sita_eksekusi;
					$data['jurusita_id'] = $row->jurusita_id;
					$data['jurusita_nama'] = $row->jurusita_nama;
					$data['penetapan_perintah_eksekusi_lelang'] = $row->penetapan_perintah_eksekusi_lelang;
					$data['pelaksanaan_eksekusi_lelang'] = $row->pelaksanaan_eksekusi_lelang;
					$data['penyerahan_hasil_lelang'] = $row->penyerahan_hasil_lelang;
					$data['penetapan_perintah_eksekusi_rill'] = $row->penetapan_perintah_eksekusi_rill;
					$data['pelaksanaan_eksekusi_rill'] = $row->pelaksanaan_eksekusi_rill;
					$data['penetapan_noneksekusi'] = $row->penetapan_noneksekusi;
					$data['alasan_eksekusi'] = $row->alasan_eksekusi;
					$data['catatan_eksekusi'] = $row->catatan_eksekusi;
					$data['jenis_ht_text'] = $row->jenis_ht_text;
					$data['tgl_sertifikat'] = $row->tgl_sertifikat;
					$data['no_sertifikat'] = $row->no_sertifikat;
				}
			}
		}
		return $data;
	}


	function edit_eksekusi(){
		#prevent direct access to page
		#the user should only access the page through menu
		if($this->nativesession->get_flash_session('security')===FALSE){
			redirect('main');
		}
		$sec = $this->nativesession->get_flash_session('security');

		if($this->session->userdata('is_logged_in')===FALSE){
			redirect('login');
		}

		$htid = $this->nativesession->get_flash_session('ht_id');
		if(!is_numeric($htid)){
			show_404();
		}
		$this->edit_data_eksekusi($htid);
	}


	function edit_data_eksekusi($htid){
		$this->load->model('perkara/new_eksekusi_ht','eksekusi');
		$data = $this->parseData($this->eksekusi->get_detil_eksekusi($htid));
		$data['pemohon'] = $this->eksekusi->get_pemohon_eksekusi($htid);
		$data['termohon'] = $this->eksekusi->get_termohon_eksekusi($htid);
		
		$data['ht_id']=base64_encode($this->encrypt->encode($htid));

		$data['jurusita']= $this->eksekusi->get_jurusita();
		
		$data['page_title'] = 'EDIT PERMOHONAN EKSEKUSI';
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['main_body'] = 'perkara/edit_eksekusi_ht';
		$data['main_history']=$this->nativesession->get('main_url_requested');
		$data['refresh']=$this->nativesession->get('url_requested');
		$data['tgl_sekarang'] = date('d/m/Y');

		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '100%';
		$this->ckeditor->config['height'] = '300px';


		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}

	#25-11-2017
	function cabut(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();		
		$data['enc'] = $segment[3];
		$ht_id = $this->encrypt->decode(base64_decode($segment[3]));		
		if(empty($ht_id) OR intval($ht_id)<1){
			show_404();
		}

		$data['main_history']=$this->nativesession->get('main_url_requested');
		$data['previous']=$this->nativesession->get_flash_session('url_requested');
		$data['current_date'] =date('d/m/Y'); 
		$data_eksekusi = $this->db->query("SELECT * FROM perkara_eksekusi_ht WHERE ht_id=".$ht_id);
		$pemohon_eksekusi = $this->db->query("SELECT * FROM perkara_eksekusi_detil_ht WHERE ht_id=".$ht_id." AND status_pihak_id=1");
		if($data_eksekusi->num_rows>0 AND !empty($data_eksekusi)){
			foreach ($data_eksekusi->result() as $row) {
				$data['nomor_eks'] = $row->eksekusi_nomor_perkara;
				$data['tanggal_permohonan'] = $this->templatehelper->convertKeTglIndo($row->permohonan_eksekusi);
				$data['tanggal_cabut'] = $this->tanggalhelper->convertToInputDate($row->tanggal_cabut_ht);
				$data['tgl_permohonan'] = $row->permohonan_eksekusi;
			}
		}else{
			$data['nomor_eks'] = '-';
			$data['tanggal_permohonan'] = '-';
			$data['tanggal_cabut'] = '';
			$data['tgl_permohonan'] = '';
		}
		if($pemohon_eksekusi->num_rows>0 AND !empty($pemohon_eksekusi)){
				$data['pemohon_eks'] = $row->pihak_nama;
		}else{
				$data['pemohon_eks'] = '-';
		}
		$this->load->vars($data);
		$this->load->view('perkara/cabut_permohonan_eksekusi_ht');
	}

	function validate_cabut(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->form_validation->set_rules('tgl_cabut', 'Tanggal Pencabutan Eksekusi', 'trim|xss_clean|exact_length[10]');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$tglCabut = $this->input->post('tgl_cabut',TRUE);
			if(!empty($tglCabut)){
				$tglCabut = $this->tanggalhelper->convertToMysqlDate($tglCabut);
				if($tglCabut==false){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
					return;
				}

				//$curr_date = date('d/m/Y');
				$curr_date = date('Y-m-d');
				$todayDate = date('d/m/Y');

				$selisih = $this->tanggalhelper->getSelisihHari($tglCabut,$curr_date);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pencabutan Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
					return;
				}

				$dayname = $this->tanggalhelper->getDayName($tglCabut);
				if($dayname=='Saturday' OR $dayname=='Sunday'){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pencabutan Dihari Libur, Sabtu dan Minggu.'));
					return;
				}			
				
				$tgl_permohonan = $this->input->post('tgl_permohonan',TRUE);
				$selisih = $this->tanggalhelper->getSelisihHari($tgl_permohonan,$tglCabut);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pencabutan Tidak Boleh Kurang Dari Tanggal Permohonan Eksekusi'));
					return;
				}
				$status_eksekusi_text = 'Pencabutan Permohonan Eksekusi';
			}else{
				$tglCabut = NULL;
				$status_eksekusi_text = NULL;
			}
			

			
			$data = array(
				'status_eksekusi_text' => $status_eksekusi_text,
				'tanggal_cabut_ht' => $tglCabut,
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);	
			$this->load->model('perkara/new_eksekusi_ht','eksekusi');					
			$result = $this->eksekusi->edit_perkara_eksekusi($data,$idperkara);
			if($result===FALSE){
				echo json_encode(array('st'=>0,'msg'=>'Gagal Menyimpan'));
				return;
			}
			echo json_encode(array('st'=>1,'msg'=>'Berhasil Disimpan'));
			return;
		}
	}
	#end

	function detil_pihak_ht(){
		$segment = $this->uri->segment_array();
		$htid = $this->encrypt->decode(base64_decode($this->uri->segment(2)));
		$idpihak = $this->encrypt->decode(base64_decode($this->uri->segment(3)));
		
		$this->detil_pihak_ht_form($htid,$idpihak);

	}

	function detil_pihak_ht_form($htid,$idpihak){
		$data['ht_id']= base64_encode($this->encrypt->encode($htid));
		$data['id_pihak']= base64_encode($this->encrypt->encode($idpihak));
		$data['tgl_sekarang'] = date('d/m/Y');

		$this->load->model('perkara/new_eksekusi_ht','eksekusi');

		$detil_pihak_ht = $this->eksekusi->get_detil_pihak_ht($idpihak);
		if($detil_pihak_ht!=''){
			if($detil_pihak_ht->num_rows()>0){
				foreach ($detil_pihak_ht->result() as $row) {
					$data['id'] = $row->id;
					$data['nama'] = $row->nama;
					$data['tempat_lahir'] = $row->tempat_lahir;
					$data['tanggal_lahir'] = $row->tanggal_lahir;
					$data['alamat'] = $row->alamat;
					$data['rtrw'] = $row->rtrw;
					$data['kelurahan'] = $row->kelurahan;
					$data['kecamatan'] = $row->kecamatan;
					$data['kabupaten'] = $row->kabupaten;
					$data['telepon'] = $row->telepon;
					$data['pekerjaan'] = $row->pekerjaan;
					$data['nomor_indentitas'] = $row->nomor_indentitas;
					$data['jenis_kelamin'] = $row->jenis_kelamin;
					$data['agama_nama'] = $row->agama_nama;
					$data['status_kawin'] = $row->status_kawin;
					$data['jenis_pihak'] = $row->jenis_pihak_id;
			}
			}else{
				$this->error_page->show_error_msg('Error Found','Tidak ada Pihak');
				exit();
			}
		}else{
			$this->error_page->show_error_msg('Error Found','Something the right happen. Mediasi ID Not Found. Error Code = 188');
			exit();
		}

		$this->load->vars($data);
		$this->load->view('perkara/detil_pihak_ht');
	}




	function validateInput(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$this->form_validation->set_rules('tgl_penetapan_teguran', 'Tanggal Penetapan Teguran', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('nomor_penetapan_teguran', 'Nomor Penetapan Teguran', 'trim|xss_clean');
		$this->form_validation->set_rules('tgl_pelaksanaan_teguran', 'Tanggal Pelaksanaan Teguran', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('tgl_penetapan_sita', 'Tanggal Penetapan Sita Eksekusi', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('nomor_penetapan_sita', 'Nomor Penetapan Sita Eksekusi', 'trim|xss_clean');
		$this->form_validation->set_rules('tgl_pelaksanaan_eksekusi', 'Tanggal Pelaksanaan Eksekusi', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('jurusita', 'Jurusita', 'trim|xss_clean');
		$this->form_validation->set_rules('tgl_penetapan_eksekusi_lelang', 'Tanggal Penetapan Eksekusi Lelang', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('tgl_pelaksanaan_eksekusi_lelang', 'Tanggal Pelaksanaan Eksekusi Lelang', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('tgl_penyerahan_hasil_lelang', 'Tanggal Penyerahan Hasil Lelang', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('tgl_penetapan_eksekusi_riil', 'Tanggal Penetapan Eksekusi Riil', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('tgl_pelaksanaan_eksekusi_riil', 'Tanggal Pelaksanaan Eksekusi Riil', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('tgl_penetapan_non_eksekusi', 'Tanggal Penetapan Non-Eksekusi', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('alasan_eksekusi_text', 'Alasan Eksekusi', 'trim|xss_clean|min_length[5]');
		$this->form_validation->set_rules('catatan_eksekusi', 'Keterangan', 'trim|xss_clean|min_length[5]');

		$d_jurusita=$this->input->post('jurusita',TRUE);
		
		if($d_jurusita!=''){
			$p_jurusita=explode(';',$d_jurusita);
			$id_jurusita=$p_jurusita[0];
			$nama_jurusita=$p_jurusita[1];
		}else{
			$id_jurusita='';
			$nama_jurusita='';
		}

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$htid = $this->encrypt->decode(base64_decode($this->input->post('htid',TRUE)));
			
			$alasan_eksekusi = trim($this->input->post('alasan_eksekusi_text',TRUE));
			$alasan_eksekusi = str_replace("&nbsp;", " ", $alasan_eksekusi);
			if(!is_numeric($htid)){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Perkara Tidak ditemukan. Code Error = 194.'));
				return;
			}else{

				$this->load->model('perkara/new_eksekusi_ht','eksekusi');

				
				$data = array(
						'penetapan_teguran_eksekusi' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_penetapan_teguran',TRUE)),
						'nomor_penetapan_teguran_eksekusi' => $this->input->post('nomor_penetapan_teguran',TRUE),
						'pelaksanaan_teguran_eksekusi' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pelaksanaan_teguran',TRUE)),						
						'penetapan_sita_eksekusi' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_penetapan_sita',TRUE)),						
						'nomor_penetapan_sita_eksekusi' => $this->input->post('nomor_penetapan_sita',TRUE),
						'pelaksanaan_sita_eksekusi' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pelaksanaan_eksekusi',TRUE)),						
						'jurusita_id' => $id_jurusita,
						'jurusita_nama' => $nama_jurusita,
						'penetapan_perintah_eksekusi_lelang' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_penetapan_eksekusi_lelang',TRUE)),						
						'pelaksanaan_eksekusi_lelang' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pelaksanaan_eksekusi_lelang',TRUE)),						
						'penyerahan_hasil_lelang' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_penyerahan_hasil_lelang',TRUE)),						
						'penetapan_perintah_eksekusi_rill' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_penetapan_eksekusi_riil',TRUE)),						
						'pelaksanaan_eksekusi_rill' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pelaksanaan_eksekusi_riil',TRUE)),						
						'penetapan_noneksekusi' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_penetapan_non_eksekusi',TRUE)),						
						'alasan_eksekusi' => $alasan_eksekusi,
						'catatan_eksekusi' => $this->input->post('catatan_eksekusi',TRUE),
						'diinput_oleh' => $this->session->userdata('username'),
						'diinput_tanggal' => date("Y-m-d h:i:s",time())
					);


				$result = $this->eksekusi->edit_perkara_eksekusi($data,$htid);

				if($result===FALSE){
					echo json_encode(array('st'=>0,'msg'=>'GAGAL Menyimpan'));
					return;
				}
				echo json_encode(array('st'=>1,'msg'=>'sukses'));
				return;
			}
		}
	}


	function validateInputPemohon(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$this->form_validation->set_rules('nama_pemohon', 'Nama Pemohon, Pekerjaan dan Alamat wajib tidak boleh kosong', 'trim|required|xss_clean');
		$this->form_validation->set_rules('enc_pemohon', 'Pemohon Wajib memilih data pemohon dari referensi pihak, data', 'trim|required|xss_clean');

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$htid = $this->encrypt->decode(base64_decode($this->input->post('ht_id',TRUE)));
			$pihak_id = $this->encrypt->decode(base64_decode($this->input->post('enc_pemohon',TRUE)));
			
	
			if(!is_numeric($htid)){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Perkara Tidak ditemukan. Code Error = 194.'));
				return;
			}else{

				$this->load->model('perkara/new_eksekusi_ht','eksekusi');
				$cek_pihak=$this->eksekusi->get_pihak_eksekusi_ht($htid,$pihak_id);
				$adapihak=$cek_pihak->row()->pemohon_ada;
				if($adapihak==1){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Pihak sudah digunakan dalam perkara ini'));
						return;
				}
				
				$data = array(
						'ht_id' => $htid,
						'pihak_id' => $pihak_id,
						'pihak_nama' => $this->input->post('nama_pemohon',TRUE),
						'alur_perkara_id' => 0,
						'status_pihak_id' => 1,
						'status_pihak_text' => 'Pemohon',
						'permohonan_eksekusi' => $this->input->post('permohonan_eksekusi',TRUE),
						'diinput_oleh' => $this->session->userdata('username'),
						'diinput_tanggal' => date("Y-m-d h:i:s",time())
					);


				$result = $this->eksekusi->add_perkara_eksekusi_detil_ht($data);

				if($result===FALSE){
					echo json_encode(array('st'=>0,'msg'=>'GAGAL Menyimpan'));
					return;
				}
				echo json_encode(array('st'=>1,'msg'=>'sukses'));
				return;
			}
		}
	}


	function validateInputTermohon(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$this->form_validation->set_rules('nama_termohon', 'Nama Pemohon, Pekerjaan dan Alamat wajib tidak boleh kosong', 'trim|required|xss_clean');
		$this->form_validation->set_rules('enc_termohon', 'Pemohon Wajib memilih data pemohon dari referensi pihak, data', 'trim|required|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$htid = $this->encrypt->decode(base64_decode($this->input->post('ht_id',TRUE)));
			$pihak_id = $this->encrypt->decode(base64_decode($this->input->post('enc_termohon',TRUE)));
			
	
			if(!is_numeric($htid)){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Perkara Tidak ditemukan. Code Error = 194.'));
				return;
			}else{

				$this->load->model('perkara/new_eksekusi_ht','eksekusi');
				$cek_pihak=$this->eksekusi->get_pihak_eksekusi_ht($htid,$pihak_id);
				$adapihak=$cek_pihak->row()->pemohon_ada;
				if($adapihak==1){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Pihak sudah digunakan dalam perkara ini'));
						return;
				}

				
				$data = array(
						'ht_id' => $htid,
						'pihak_id' => $pihak_id,
						'pihak_nama' => $this->input->post('nama_termohon',TRUE),
						'alur_perkara_id' => 0,
						'status_pihak_id' => 2,
						'status_pihak_text' => 'Termohon',
						'permohonan_eksekusi' => $this->input->post('permohonan_eksekusi',TRUE),
						'diinput_oleh' => $this->session->userdata('username'),
						'diinput_tanggal' => date("Y-m-d h:i:s",time())
					);


				$result = $this->eksekusi->add_perkara_eksekusi_detil_ht($data);

				if($result===FALSE){
					echo json_encode(array('st'=>0,'msg'=>'GAGAL Menyimpan'));
					return;
				}
				echo json_encode(array('st'=>1,'msg'=>'sukses'));
				return;
			}
		}
	}

	function hapus_pihak_eksekusi_ht(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$id_pihak = $this->encrypt->decode(base64_decode($this->input->post('id_pihak')));
		if(!is_numeric($id_pihak) OR !intval($id_pihak)>0){
			echo json_encode(array('st'=>0,'msg'=>'Tidak ditemukan Pihak yang akan dihapus.'));
			return;
		}

		$ht_id = $this->encrypt->decode(base64_decode($this->input->post('ht_id')));
		if(!is_numeric($ht_id) OR !intval($ht_id)>0){
			echo json_encode(array('st'=>0,'msg'=>'Tidak ada Perkara.'));
			return;
		}
		
		$this->load->model('perkara/new_eksekusi_ht','eksekusi');
		if($this->eksekusi->hapus_pihak_ht($ht_id,$id_pihak)){
			echo json_encode(array('st'=>1,'msg'=>'Pihak telah dihapus'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'));
			return;
		}
	}		


	function confirmationhapusperkara(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc'] = $segment[2];
		$ht_id = $this->encrypt->decode(base64_decode($segment[2]));
		if(empty($ht_id) OR intval($ht_id)<1){
			show_404();
		}

		$this->load->vars($data);
		$this->load->view('perkara/hapus_perkara_eksekusi_ht');
	}

	function del_perkara_eksekusi(){
		try {
			if(empty($_POST)){
				show_404();
			}

			if($this->session->userdata('is_logged_in')==FALSE){
				echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
				return;
			}

			$ht_id = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			if(!is_numeric($ht_id) OR intval($ht_id)<1){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
				return;
			}
			$this->load->model('perkara/new_eksekusi_ht','eksekusi');
			$result = $this->eksekusi->hapus_perkara_eks_ht($ht_id);
			
			if($result==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DIHAPUS.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN DISIMPAN.'));
				return;
			}
		} catch (Exception $e) {
			
		}
	}

}