<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class data_relaas_c extends CI_Controller {
	//dipake : redirect_popup.php
	function popup_input_relaas($idperkara=null,$idjadwal=null){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['curr_date'] = date('d/m/Y');
		if($idperkara==null){
			$data['enc']=$this->nativesession->get_flash_session('enc');
		}else{
			$data['enc']=$idperkara;	
		}
		if($idjadwal==null){
			$data['idjadwal']=$this->nativesession->get_flash_session('encjadwalsidang');	
			$data['encjadwalsidang']=$this->nativesession->get_flash_session('encjadwalsidang');	
		}else{
			$data['idjadwal']=$idjadwal;
			$data['encjadwalsidang']=$idjadwal;;	
		}
				
		$this->load->model('jadwalsidang/jadwal_sidang_m');

		$idjadwal=$this->encrypt->decode(base64_decode($data['idjadwal']));
        if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
            show_404();
            exit();
        }

		$idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }

        $detil_sidang_id=$this->jadwal_sidang_m->get_detil_jadwal($idjadwal);
        foreach ($detil_sidang_id as $row) {
        	$data['tanggal_sidang']=$row->tanggal_sidang;
        	$data['agenda']=$row->agenda;
        }
		$data['panitera_pengganti']=$this->jadwal_sidang_m->get_pp($idperkara);
        $data['alur_perkara_id']=$this->tanggalhelper->getIDAlurPerkara($idperkara);
        $data['list_pihak_direlaas']=$this->jadwal_sidang_m->list_pihak_relaas($idperkara,$idjadwal); 
        $data['previous']=$this->nativesession->set_flash_session('popup_relas',current_url()); 
		$data['namahalaman']="PELAKSANAAN PANGGILAN / RELAAS";
		$this->load->view('data_persidangan/pelaksanaan_relaas_v',$data);
	}

	//dipake : pelaksanaan_relaas_v.php
	function input_data(){
		if(empty($_POST)){
			show_404();
		}

		$this->load->model('jadwalsidang/jadwal_sidang_m');
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$idjadwal = $this->encrypt->decode(base64_decode($this->input->post('sidang_id')));
		if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
			echo json_encode(array('st'=>0,'msg'=>'Sidang Tidak Ditemukan.'));
			return;
		}

		$tgl_pelaks=$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pelaks',TRUE));
		$temu=$this->input->post('temu',TRUE);
		$ketrelaas=$this->input->post('ketrelaas',TRUE);
		$tgl_sidang=$this->input->post('tgl_sidang',TRUE);
		if($tgl_pelaks>$tgl_sidang){
			echo json_encode(array('st'=>0,'msg'=>'Tidak boleh input tanggal pelaksanaan relaas kurang dari tanggal sidang'));
			return;
		}
		
		$pihakid=$this->input->post('pihakid',TRUE);
		$namahalaman=$this->input->post('namahalaman',TRUE);
		
		$data_insert = array(
			'perkara_id'=>$idperkara,
			'sidang_id'=>$idjadwal,
			'tanggal_relaas'=>$tgl_pelaks,
			'ket_temu'=>$temu,
			'ket_hasil_relaas'=>$ketrelaas,
			'pihak_id'=>$pihakid,
			'jurusita_id'=>$this->session->userdata('userid'),
			'diinput_oleh' => $this->session->userdata('username'),
			'diinput_tanggal' => date("Y-m-d h:i:s",time())
		);

		$data_update = array(
			'tanggal_relaas'=>$tgl_pelaks,
			'ket_temu'=>$temu,
			'ket_hasil_relaas'=>$ketrelaas,
			'diperbaharui_oleh' => $this->session->userdata('username'),
			'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
		);
		if($ketrelaas!=""){
			$cek_relaas=$this->jadwal_sidang_m->cek_hasil_relaas($idperkara,$idjadwal,$pihakid);
			if($cek_relaas>0){
				$result=$this->jadwal_sidang_m->update_hasil_relaas($data_update,$idperkara,$idjadwal,$pihakid,$namahalaman);
				if($result){
					echo json_encode(array('st'=>1));
					return;					
				}else{
					echo json_encode(array('st'=>0));
					return;
				}	
			}else{
				$result=$this->jadwal_sidang_m->insert_hasil_relaas($data_insert,$namahalaman);	
				if($result){
					echo json_encode(array('st'=>1));
					return;					
				}else{
					echo json_encode(array('st'=>0));
					return;
				}				
			}
		}else{
			return;
		}
	}
}
?>
