<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class c_template_tun_skum extends CI_Controller {

    function __construct()
    {
        parent::__construct();
        $this->load->model('generate_template/peradilan_tun/m_skum','skum');
    }

    function index() {
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login');
        }    
        $this->load->view('dashboard', FALSE);
    }

    function popup_bukti_bayar(){
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login');
        }      

        $tahapan_id=$this->encrypt->decode(base64_decode($this->uri->segment('3')));
        if(!is_numeric($tahapan_id) OR !intval($tahapan_id)>0){
            show_404();
            exit();
        }

        $data['enc']=$this->uri->segment('4');
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }

        $data['getlisttransaksi']=$this->skum->getlisttransaksi($idperkara,$tahapan_id);      

        $data['judul']='Bukti Bayar Panjar Perkara - SKUM';
        $this->load->view('generate_template/tun/popup_skum', $data, FALSE);
    }

	 function cetak(){

        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }       

        $perkara_id=$this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
        $perkara_biaya_id=$this->input->post('transaksi',TRUE);

        $data['getdataskum'] = $this->skum->getdataskum($perkara_id,$perkara_biaya_id);
        $data['getsatker'] = $this->skum->getsatker($idperkara,'1');
        $data['getalamatsatker'] = $this->skum->getalamatsatker($idperkara,'1');
        $data['getkasir'] = $this->skum->getkasir($idperkara,'1');
		$data['getpanitera'] = $this->skum->getpanitera($idperkara,'1');

        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        $data['template']=$this->template2->getDataDocumentTemplate('9','10','10','15','');

        $this->load->view('generate_template/tun/cetak_skum', $data, FALSE);
    }
}
        