<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class C_template_mil_grasi extends CI_Controller {

	public function __construct() {
        parent::__construct();
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        } 
        $this->load->model('generate_template/m_template_mil_grasi','template');
    }

    function get_contens($filemaster){
        $url = base_url("resources/template/akta/pidana_militer/".$filemaster.".rtf");
        $Template = file_get_contents($url);
        return $Template;
    }

    function popup($enc=0,$enc_grasi=0, $enc_terdakwa=0, $enc_pemohon=0){
        $data['enc']=$enc;
        $data['enc_grasi']=$enc_grasi;
        $data['enc_terdakwa']=$enc_terdakwa;
        $data['enc_pemohon']=$enc_pemohon;
        $data['perkara_id']=$this->encrypt->decode(base64_decode($enc));
        $data['grasi_id']=$this->encrypt->decode(base64_decode($enc_grasi));
        $data['terdakwa_id']=$this->encrypt->decode(base64_decode($enc_terdakwa));
        $data['pemohon_id']=$this->encrypt->decode(base64_decode($enc_pemohon));
        $data['data_putusan']=$this->template->getDataPutusan($data['perkara_id']);
        $data['penandatangan']=$this->template->getDataPejabat();
        $this->load->view('generate_template/popup_mil_grasi', $data, FALSE);
    }

    function cetak_akta_grasi(){
        $perkara_id=$this->encrypt->decode(base64_decode($this->input->post('enc')));
        $grasi_id=$this->encrypt->decode(base64_decode($this->input->post('enc_grasi')));
        $terdakwa_id=$this->encrypt->decode(base64_decode($this->input->post('enc_terdakwa')));
        $pemohon_id=$this->encrypt->decode(base64_decode($this->input->post('enc_pemohon')));
        
        $data=array();
        $nomor_perkara=$this->tanggalhelper->getNomorPerkara($perkara_id);
        $data['idput'] = $this->input->post('putusan',TRUE);
        $idput=$this->encrypt->decode(base64_decode($data['idput']));
        if(!is_numeric($idput) OR !intval($idput)>0){
            show_404();
            exit();
        }

        $this->load->model('perkara/grasi','perkara');
        $rowGrasi = $this->template->mDetilGrasi($grasi_id);
        if($rowGrasi->num_rows()==0){
            echo json_encode(array('st'=>0,'msg'=>'Kesalahan, Refresh Browser'));
            return;
        } else {
            #
            $data['id'] = base64_encode($this->encrypt->encode($rowGrasi->row()->id));
            $data['perkara_id'] = base64_encode($this->encrypt->encode($rowGrasi->row()->perkara_id));
            $data['nomor_perkara_pn'] = $rowGrasi->row()->nomor_perkara_pn;
            $data['putusan_pn'] = $this->perkara->parsingTanggalView($rowGrasi->row()->putusan_pn);
            $data['nomor_perkara_banding'] = $rowGrasi->row()->nomor_perkara_banding;
            $data['putusan_banding'] = $this->perkara->parsingTanggalView($rowGrasi->row()->putusan_banding);
            $data['nomor_perkara_kasasi'] = $rowGrasi->row()->nomor_perkara_kasasi;
            $data['putusan_kasasi'] = $this->perkara->parsingTanggalView($rowGrasi->row()->putusan_kasasi);
            $data['nomor_perkara_pk'] = $rowGrasi->row()->nomor_perkara_pk;
            $data['putusan_pk'] = $this->perkara->parsingTanggalView($rowGrasi->row()->putusan_pk);
            $permohonan_grasi = $this->perkara->parsingTanggalView($rowGrasi->row()->permohonan_grasi);
            $permohoan_grasi_sql=$rowGrasi->row()->permohonan_grasi;
            $terdakwa_nama = $this->templatehelper->standradnaming($rowGrasi->row()->terdakwa_nama);
            $pangkat_terdakwa = $this->templatehelper->standradnaming($rowGrasi->row()->pangkat_terdakwa);
            $nrp_terdakwa = $rowGrasi->row()->nrp_terdakwa;
            $jabatan_terdakwa = $rowGrasi->row()->jabatan_terdakwa;
            $kesatuan_terdakwa = $rowGrasi->row()->kesatuan_terdakwa;
            $tempat_lahir_terdakwa = $this->templatehelper->standradnaming($rowGrasi->row()->tempat_lahir_terdakwa);
            $tanggal_lahir_terdakwa = $this->perkara->parsingTanggalView($rowGrasi->row()->tanggal_lahir_terdakwa);
            $jenis_kelamin_terdakwa = $rowGrasi->row()->jenis_kelamin_terdakwa;
            if ($jenis_kelamin_terdakwa=="L"){
                $jenis_kelamin_terdakwa="Laki-laki";
            }else{
                $jenis_kelamin_terdakwa="Perempuan";
            }
            $agama_terdakwa = $rowGrasi->row()->agama_terdakwa;
            $alamat_terdakwa = $this->templatehelper->standradnaming($rowGrasi->row()->alamat_terdakwa);
            $data['permohonan_penundaan_pidana'] = $this->perkara->parsingTanggalView($rowGrasi->row()->permohonan_penundaan_pidana);
            $data['terdakwa_id'] = base64_encode($this->encrypt->encode($rowGrasi->row()->terdakwa_id));
            
            $pemohon_id = $rowGrasi->row()->pemohon_id;
            $pemohon_nama = $this->templatehelper->standradnaming($rowGrasi->row()->pemohon_nama);
            $pemohon_pekerjaan = $this->templatehelper->standradnaming($rowGrasi->row()->pemohon_pekerjaan);
            $pemohon_alamat = $rowGrasi->row()->pemohon_alamat;
            $pemohon_pangkat = $rowGrasi->row()->pemohon_pangkat;
            $pemohon_jabatan = $rowGrasi->row()->pemohon_jabatan;
            $pemohon_nrp = $rowGrasi->row()->pemohon_nrp;
            $pemohon_kesatuan = $rowGrasi->row()->pemohon_kesatuan;
            $pemberitahuan_putusan_grasi = $this->perkara->parsingTanggalView($rowGrasi->row()->pemberitahuan_putusan_grasi);
            $pemberitahuan_putusan_grasi_sql = $rowGrasi->row()->pemberitahuan_putusan_grasi;
            $nomor_putusan_grasi= $rowGrasi->row()->nomor_putusan_grasi;
            $tanggal_putusan_grasi = $this->perkara->parsingTanggalView($rowGrasi->row()->tanggal_putusan_grasi);
            $data['pemohon_grasi'] = $rowGrasi->row()->pemohon_grasi;
            $data['pemberitahuan_putusan_tetap'] = $this->perkara->parsingTanggalView($rowGrasi->row()->pemberitahuan_putusan_tetap);
            $data['menjalani_pidana_pengganti'] = $this->perkara->parsingSeleksi('1',$rowGrasi->row()->menjalani_pidana_pengganti);
            $data['terpidana_dalam_tahanan'] = $this->perkara->parsingSeleksi('1',$rowGrasi->row()->terpidana_dalam_tahanan);
            $data['denda_dibayar'] = $this->perkara->parsingSeleksi('1',$rowGrasi->row()->denda_dibayar);
            $data['barang_rampasan'] = $this->perkara->parsingSeleksi('2',$rowGrasi->row()->barang_rampasan);
            $data['tanggal_pertimbangan_hakim'] = $this->perkara->parsingTanggalView($rowGrasi->row()->tanggal_pertimbangan_hakim);
            $data['isi_perimbangan_hakim'] = $rowGrasi->row()->isi_perimbangan_hakim;
            $data['pengiriman_berkas_grasi_ke_kejaksaan'] = $this->perkara->parsingTanggalView($rowGrasi->row()->pengiriman_berkas_grasi_ke_kejaksaan);
            $data['no_pengiriman_berkas_grasi_ke_kejaksaan'] = $rowGrasi->row()->no_pengiriman_berkas_grasi_ke_kejaksaan;
            $data['pengiriman_berkas_grasi_ke_ma'] = $this->perkara->parsingTanggalView($rowGrasi->row()->pengiriman_berkas_grasi_ke_ma);
            $data['pengiriman_pertimbangan_hakim_grasi'] = $this->perkara->parsingTanggalView($rowGrasi->row()->pengiriman_pertimbangan_hakim_grasi);
            $data['tanggal_penerimaan_kembali_berkas_grasi'] = $this->perkara->parsingTanggalView($rowGrasi->row()->tanggal_penerimaan_kembali_berkas_grasi);
            
            $data['status_putusan_grasi_id'] = $rowGrasi->row()->status_putusan_grasi_id;
            $data['status_putusan_grasi_text'] = $rowGrasi->row()->status_putusan_grasi_text;
            $data['amar_putusan_grasi'] = $rowGrasi->row()->amar_putusan_grasi;
            $data['pemberitahuan_putusan_grasi'] = $this->perkara->parsingTanggalView($rowGrasi->row()->pemberitahuan_putusan_grasi);
            $data['pemberitahuan_tembusan_grasi'] = $this->perkara->parsingTanggalView($rowGrasi->row()->pemberitahuan_tembusan_grasi);
            $data['catatan_putusan_grasi'] = $rowGrasi->row()->catatan_putusan_grasi;
        }

        $idpembuatakta=$this->input->post('penandatangan_id');
        $list_pembuat_akta=$this->template->getDataPejabat();
        foreach ($list_pembuat_akta->result() as $row) {
            if ($row->id==$idpembuatakta){
                $nama_pangkat_korp_panitera=$this->templatehelper->standradnaming($row->pw)." ".$row->pangkat;
                $nrp_panitera=$row->nip;
                $nama_panitera=$this->templatehelper->standradnaming($row->pw);
                $pangkat_panitera = $row->pangkat;
            }
        }

        $info_pn=$this->template->getDataPN()->row();
        $kode_pn=$info_pn->KodePN;
        if ($kode_pn!=''){
            $kode_pn1=explode(".", $kode_pn);
            $kode_pn1=$kode_pn1[1];
        }
        $nama_pn=$info_pn->NamaPN;
        $kota_pn1=explode(" ",$nama_pn);
        $kota_pn1=$kota_pn1[count($kota_pn1)-1];
        $kota_pn=$this->templatehelper->ucname($kota_pn1);
        $expl_template = explode("_", $this->input->post('jenistemplate', TRUE));
        $info_document=$this->template->getDataDocumentTemplate('120','60', $expl_template[0],$expl_template[1],'')->row();
        $data['kdtemplate']=$info_document->kdtemplate;
        $Template= $this->get_contens($data['kdtemplate']);
        $expl_no_perkara=explode("/", $nomor_perkara);
        if (count($expl_no_perkara)>1){
            $matra=$expl_no_perkara[2];
            $noreg=$expl_no_perkara[0];
        }
        if ($permohoan_grasi_sql!='' AND $permohoan_grasi_sql!='0000-00-00'){
            $explode=explode("-", $permohoan_grasi_sql);
            if(count($explode)>1){
                $bln=$explode[1];
                $thn=$explode[0];
                $hari_permohonan=$this->templatehelper->getHari($permohoan_grasi_sql);
            }
        }
        $bln_pemberitahuan_put_grasi='';
        $thn_pemberitahuan_put_grasi='';
        $hari_pemberitahuan='';
        if ($pemberitahuan_putusan_grasi_sql!='' AND $pemberitahuan_putusan_grasi_sql!='0000-00-00'){
            $explode=explode("-", $pemberitahuan_putusan_grasi_sql);
            if(count($explode)>1){
                $bln_pemberitahuan_put_grasi=$explode[1];
                $thn_pemberitahuan_put_grasi=$explode[0];
                $hari_pemberitahuan=$this->templatehelper->getHari($pemberitahuan_putusan_grasi_sql);
            }
        }

        $info_putusan_upaya_hukum=$this->template->getDataPutusan($perkara_id, $idput);
        $tgl_putus_upaya_hukum=$this->templatehelper->convertKeTglIndo($info_putusan_upaya_hukum->row()->tglPutus);
        $tgl_bht_upaya_hukum=($info_putusan_upaya_hukum->row()->tanggal_bht);

        $Template = str_replace('#bulan#',''.$bln.'',$Template);
        $Template = str_replace('#tahun#',''.$thn.'',$Template);
        $Template = str_replace('#bulan_pemberitahuan#',''.$bln_pemberitahuan_put_grasi.'',$Template);
        $Template = str_replace('#tahun_pemberitahuan#',''.$thn_pemberitahuan_put_grasi.'',$Template);
        $Template = str_replace('#nomor_putusan_grasi#',''.$nomor_putusan_grasi.'',$Template);
        $Template = str_replace('#tanggal_putusan_grasi#',''.$tanggal_putusan_grasi.'',$Template);
        $data_oditur=$this->template->getDataOditur($perkara_id);
        if ($data_oditur->num_rows()>0){
            $Template = str_replace('#nama_oditur#',''.$this->templatehelper->standradnaming($data_oditur->row()->nama).'',$Template);
            $Template = str_replace('#pangkat_oditur#',''.$data_oditur->row()->pangkat.'',$Template);
            $Template = str_replace('#nrp_oditur#',''.$data_oditur->row()->nrp.'',$Template);
            $Template = str_replace('#jabatan_oditur#',''.$data_oditur->row()->jabatan.'',$Template);
            $Template = str_replace('#kode_oditur#',''.$this->templatehelper->standradnaming($data_oditur->row()->kesatuan).'',$Template);
        }

        if (empty($tgl_bht_upaya_hukum)){
            $tgl_bht_upaya_hukum='\highlight7 [harap isi tanggal pemberitahuan putusan/tanggal] bht\highlight0 ';
            $nomor_akta_bht='\highlight7 [harap isi tanggal pemberitahuan putusan/tanggal bht]\highlight0 ';
        }else{
            $explode=explode("-", $info_putusan_upaya_hukum->row()->tanggal_bht);
            if(count($explode)>1){
                $bln=$explode[1];
                $thn=$explode[0];
                $hari_permohonan=$this->templatehelper->getHari($permohoan_grasi_sql);
            }
            if ($idput==1){
                $nomor_akta_bht='AMKHT/#no_register#/PM.#kode_pn1#/#matra#/#bulan#/#tahun#';
            }else{
                $nomor_akta_bht='ABHT/#no_register#/PM.#kode_pn1#/#matra#/#bulan#/#tahun#';
            }    
        }
        $Template = str_replace('#tanggal_bht#',''.$this->templatehelper->convertKeTglIndo($tgl_bht_upaya_hukum).'',$Template);
        $Template = str_replace('#nomor_bht#',''.$nomor_akta_bht.'',$Template);
        $Template = str_replace('#bulan#',''.$bln.'',$Template);
        $Template = str_replace('#tahun#',''.$thn.'',$Template);

        $Template = str_replace('#nomor_perkara#',''.$nomor_perkara.'',$Template);
        $Template = str_replace('#no_register#',''.$noreg.'',$Template);
        $Template = str_replace('#matra#',''.$matra.'',$Template);
        
        $Template = str_replace('#kode_pn#',''.$kode_pn.'',$Template);
        $Template = str_replace('#kode_pn1#',''.$kode_pn1.'',$Template);
        $Template = str_replace('#kota_pn1#',''.$kota_pn1.'',$Template);
        $Template = str_replace('#kota_pn#',''.$kota_pn.'',$Template);
        $Template = str_replace('#tanggal_permohonan#',''.$permohonan_grasi.'',$Template);
        $Template = str_replace('#hari_permohonan#',''.$hari_permohonan.'',$Template);
        $Template = str_replace('#tanggal_pemberitahuan#',''.$pemberitahuan_putusan_grasi.'',$Template);
        $Template = str_replace('#hari_pemberitahuan#',''.$hari_pemberitahuan.'',$Template);

        $Template = str_replace('#nama_terdakwa#',''.$terdakwa_nama.'',$Template);
        $Template = str_replace('#pangkat_terdakwa#',''.$pangkat_terdakwa.'',$Template);
        $Template = str_replace('#nrp_terdakwa#',''.$nrp_terdakwa.'',$Template);
        $Template = str_replace('#jabatan_terdakwa#',''.$jabatan_terdakwa.'',$Template);
        $Template = str_replace('#kesatuan_terdakwa#',''.$kesatuan_terdakwa.'',$Template);
        $Template = str_replace('#tempat_lahir_terdakwa#',''.$tempat_lahir_terdakwa.'',$Template);
        $Template = str_replace('#tanggal_lahir_terdakwa#',''.$tanggal_lahir_terdakwa.'',$Template);
        $Template = str_replace('#alamat_terdakwa#',''.$alamat_terdakwa.'',$Template);
        $Template = str_replace('#jenis_kelamin_terdakwa#',''.$jenis_kelamin_terdakwa.'',$Template);
        $Template = str_replace('#agama_terdakwa#',''.$agama_terdakwa.'',$Template);

        if (trim($pemohon_pekerjaan=='Tentara Nasional Indonesia')){
            $atribut_pemohon  ='Pangkat/NRP\tab :\tab '.$pemohon_pangkat.' \ '.$pemohon_nrp.'\par ';
            $atribut_pemohon .='Jabatan\tab :\tab '.$pemohon_jabatan.'\par ';
            $atribut_pemohon .='Kesatuan\tab :\tab '.$pemohon_kesatuan.'\par ';
            $Template = str_replace('#NRP#','NRP.',$Template);
            $Template = str_replace('#pemohon_pangkat#',''.$pemohon_pangkat.'',$Template);
            $Template = str_replace('#pemohon_nrp#',''.$pemohon_nrp.'',$Template);
        }else{
            $data_pemohon=$this->template->getDataPihak($pemohon_id);
            $pemohon_tempat_lahir=$data_pemohon->tempat_lahir;
            $pemohon_tanggal_lahir=$data_pemohon->tanggal_lahir;
            $pemohon_jenis_kelamin=($data_pemohon->jenis_kelamin=='L')?'Laki-laki':'Perempuan';
            $pemohon_warga_negara=$data_pemohon->warga_negara;
            $pemohon_agama=$data_pemohon->agama_nama;
            $pemohon_alamat=$data_pemohon->alamat;
            $atribut_pemohon  ='Pekerjaan\tab :\tab '.$pemohon_pekerjaan.'\par ';
            $atribut_pemohon  .='Tempat/tanggal lahir\tab :\tab '.$pemohon_tempat_lahir.' / '.$this->perkara->parsingTanggalView($pemohon_tanggal_lahir).'\par ';
            $atribut_pemohon  .='Jenis kelamin\tab :\tab '.$pemohon_jenis_kelamin.'\par ';
            $atribut_pemohon  .='Kewarganegaraan\tab :\tab '.$pemohon_warga_negara.'\par ';
            $atribut_pemohon  .='Agama\tab :\tab '.$pemohon_agama.'\par ';
            $atribut_pemohon  .='Tempat tinggal\tab :\tab '.$pemohon_alamat.'\par ';
            $Template = str_replace('#NRP#','',$Template);
            $Template = str_replace('#pemohon_pangkat#','',$Template);
            $Template = str_replace('#pemohon_nrp#','',$Template);
        }
        
        $Template = str_replace('#pemohon_nama#',''.$pemohon_nama.'',$Template);
        $Template = str_replace('#atribut_pemohon#',$atribut_pemohon,$Template);    
        $Template = str_replace('#pemohon_kesatuan#',''.$pemohon_kesatuan.'',$Template);
        $Template = str_replace('#pemohon_jabatan#',''.$pemohon_jabatan.'',$Template);

        $Template = str_replace('#nama_panitera#',''.$nama_panitera.'',$Template);
        $Template = str_replace('#pangkat_panitera#',''.$pangkat_panitera.'',$Template);
        $Template = str_replace('#nrp_panitera#',''.$nrp_panitera.'',$Template);
        $Template = str_replace('#nama_pangkat_korp_panitera#',''.$nama_pangkat_korp_panitera.'',$Template);
        
        $nomor_putusan_upaya_hukum=$info_putusan_upaya_hukum->row()->nomorPerkara;
        $pengadilan_upaya_hukum=$info_putusan_upaya_hukum->row()->tahapan;
        $pengadilan_upaya_hukum=$this->templatehelper->standradnaming($pengadilan_upaya_hukum);
        $Template = str_replace('#tgl_putus_upaya_hukum#',''.$tgl_putus_upaya_hukum.'',$Template);
        $Template = str_replace('#nomor_putusan_upaya_hukum#',''.$nomor_putusan_upaya_hukum.'',$Template);
        $Template = str_replace('#pengadilan_upaya_hukum#',''.$pengadilan_upaya_hukum.'',$Template);
        
        $data=array();
        $data['nomor_perkara']=$nomor_perkara;
        $data['Template']=$Template;
        $data['namafile']=str_replace(" ","_",$info_document->namatemplate);
        $this->load->view('generate_template/cetak_mil_grasi',$data,FALSE); 
        
    }
}