<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class C_delegasi extends CI_Controller {
	public function __construct() {
        parent::__construct();
		$this->load->model('api/m_delegasi','delegasi_api');
		$this->load->model('delegasi/d_delegasi_m');
    }
    function index() {

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}else{
			$this->dashboard_delegasi();
		}
	}

	function dashboard_delegasi(){
		$data['previous']=$this->nativesession->set_flash_session('previous',current_url());
		$data['delegasi_blm_dikirim']=$this->d_delegasi_m->delegasi_blm_terkirim();
		$statistik_keluar = $this->d_delegasi_m->statistik_d_keluar();
		foreach ($statistik_keluar->result() as $row) {
			$data['k_blm_kirim']=$row->blm_kirim;
			$data['k_sdh_kirim']=$row->sdh_kirim;
			$data['k_sdh_dilaksanakan']=$row->sdh_dilaksanakan;
			$data['k_blm_dilaksanakan']=$row->blm_dilaksanakan;
			$data['k_total_k']=$row->jml_keluar;
		}

		$statistik_masuk = $this->d_delegasi_m->statistik_d_masuk();
		foreach ($statistik_masuk->result() as $row) {
			$data['m_sdh_dilaksanakan']=$row->sdh_dilaksanakan;
			$data['m_blm_dilaksanakan']=$row->blm_dilaksanakan;
			$data['m_total_k']=$row->jml_masuk;
		}
		$data['iddelegasi'] = '';
        $this->load->view('header');
        $this->load->view('delegasi/d_delegasi',$data);
        $this->load->view('footer');

	}

	function show_hasil_pencarian(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		
		$search=$this->input->post('search',TRUE);

		if($search!=""){
			$cari_delegasi_k=$this->d_delegasi_m->hasil_cari_k($search);
			$cari_delegasi_m=$this->d_delegasi_m->hasil_cari_m($search);
			
			if($cari_delegasi_k->num_rows()>0 || $cari_delegasi_m->num_rows()>0){
				if($cari_delegasi_k->num_rows()>0){
					$hslcari = "<div class='box'>
			             			<div class='box-header with-border'>
			              			<h3 class='box-title red'><strong>Hasil Pencarian Delegasi Keluar</strong<small></small></h3>
			            			</div>";
						$hslcari .= "<div class='box-body'>
							              <table class='table table-bordered table-hover' style='font-size: 14px;'>
							                <tr>
							                  <th style='width: 5%'>No.</th>
							                  <th style='width: 40%'>Nomor Perkara<br>Pihak</th>
							                  <th style='width: 13%'>Status Delegasi</th>
							                  <th style='width: 30%'>Pengadilan Tujuan</th>
							                  <th style='width: 5%'>Detil</th>
							                </tr>";
							    			$i=1;
										    foreach ($cari_delegasi_k->result() as $row) {
										    	if($row->status_kirim==0){
										    		$status_delegasi="<font color='red'>Belum dikirim</font>";
										    	}else if($row->status_kirim==1){
										    		$status_delegasi="<font color='orange'>Sudah Dikirim</font>";
										    	}else if($row->status_kirim==2){
										    		$status_delegasi="<font color='green'>Sudah Dilaksanakan</font>";
										    	}
										    	$hslcari.= "<tr>";
										    	$hslcari.= "<td height='30'>".$i."</td>";
										    	$hslcari.= "<td height='30'>".$row->nomor_perkara."<br>".$row->pihak."</td>";
										    	$hslcari.= "<td height='30'>".$status_delegasi."</td>";
										    	$hslcari.= "<td height='30'>".$row->pn_tujuan_text."</td>";
										    	$hslcari.= '<td height="30"><a class="btn btn-warning btn-sm" href="'.base_url('manage_delegasi_perkara/detil_delegasi/'.base64_encode($this->encrypt->encode(2))."/".base64_encode($this->encrypt->encode($row->id))."/".base64_encode($this->encrypt->encode($row->id_pn_asal))."/".base64_encode($this->encrypt->encode($row->id_pn_tujuan))).'"><i class="fa fa-send"></i> Detil </a></td>';
										    	$hslcari.= "</tr>";
										    	$i++;
										    };          			
							    $hslcari .= "</div>";

						$hslcari.= "</table>";
	
				}else{
					$hslcari = "";
				}

				if($cari_delegasi_m->num_rows()>0){
					$hslcari .= "<div class='box'>
			             			<div class='box-header with-border'>
			              			<h3 class='box-title red'><strong>Hasil Pencarian Delegasi Masuk</strong<small></small></h3>
			            			</div>";
						$hslcari .= "<div class='box-body'>
							              <table class='table table-bordered table-hover' style='font-size: 14px;'>
							                <tr>
							                  <th style='width: 5%'>No.</th>
							                  <th style='width: 40%'>Nomor Perkara<br>Pihak</th>
							                  <th style='width: 13%'>Status Delegasi</th>
							                  <th style='width: 30%'>Pengadilan Asal</th>
							                  <th style='width: 5%'>Detil</th>
							                </tr>";
							    			$i=1;
										    foreach ($cari_delegasi_m->result() as $row1) {
										    	if($row1->id_status_delegasi<=0){
										    		$status_delegasi="<font color='red'>Belum Dilaksanakan</font>";
										    	}else if($row1->id_status_delegasi>0){
										    		$status_delegasi="<font color='green'>Sudah Dilaksanakan</font>";
										    	}										    	
										    	$hslcari.= "<tr>";
										    	$hslcari.= "<td height='30'>".$i."</td>";
										    	$hslcari.= "<td height='30'>".$row1->nomor_perkara."<br>".$row1->pihak."</td>";
										    	$hslcari.= "<td height='30'>".$status_delegasi."</td>";
										    	$hslcari.= "<td height='30'>".$row1->pn_asal_text."</td>";
										    	$hslcari.= '<td height="30"><a class="btn btn-warning btn-sm" href="'.base_url('manage_delegasi_perkara/detil_delegasi/'.base64_encode($this->encrypt->encode(1))."/".base64_encode($this->encrypt->encode($row1->id))."/".base64_encode($this->encrypt->encode($row1->id_pn_asal))."/".base64_encode($this->encrypt->encode($row1->id_pn_tujuan))).'"><i class="fa fa-send"></i> Detil </a></td>';
										    	$hslcari.= "</tr>";
										    	$i++;
										    };          			
							    $hslcari .= "</div>";

						$hslcari.= "</table>";
	
				}else{
					$hslcari .= "";
				}

			echo json_encode(array('st'=>1,'hasil_cari'=>$hslcari));
			return;
			}
		}else{

			echo json_encode(array('st'=>0));
			return;
		}
		
	}














	function dashboard(){
		$tmp=base_url();
		$tmp=str_replace('http://','',$tmp);
		$tmp2=str_replace('https://','',$tmp);
		$ip=explode('/',$tmp2);
		$data['is_connect']=$this->check_connection();
		$data['ip_sipp']=$ip[0];
  		$data['main_body']='delegasi/iframe';
  		$this->load->vars($data);
  		$this->load->view('header');
  		$this->load->view('body/body_new');
	
	}

	function check_connection(){
	 	$connected = @fsockopen("www.google.com"); 
	    if ($connected){
	        $is_conn = true; 
	        fclose($connected);
	    }else{
	        $is_conn = false;
	    }
	    return $is_conn;
	}

	function session_connect($value=0,$sesion){
		if ($value==0){
			$this->session->set_userdata('is_connect',FALSE);
		}else if ($value==1){
			$this->session->set_userdata('is_connect',TRUE);
		}
		echo json_encode($value);
		return;
	}


	function send_identity() {
		$query=$this->delegasi->get_username();
		// $data_online=$this->user_online->get_user_online()->result_object();
  //   	$session_id=$data_online[0]->session_id;
    	$userid	=$data_online[0]->userid;
		if ($query->num_rows >= 1) {
			$data=$query->result_object();
			$IDPN=$data[0]->IDPN;
			$kode_satker=$data[0]->kode_satker;
			// $NamaPN='pengadilan negeri';
			$user_sipp_ma=$data[0]->user_sipp_ma;
			$pwd_sipp_ma=$data[0]->pwd_sipp_ma;
		}
	   // $val="IDPN='".$IDPN."&kode_satker=".$kode_satker."&NamaPN=".$NamaPN."&user_sipp_ma=".$user_sipp_ma."&pwd_sipp_ma=".$pwd_sipp_ma;
		$var="v4r_user=".$user_sipp_ma."&v4r_pw5=".$pwd_sipp_ma;
        $curl = curl_init();

		curl_setopt_array($curl, array(
		  CURLOPT_URL => "http://192.168.78.78/sipp_delegasi/api/delegasi/auth_sipp?".$var,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => "",
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 30,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => "GET",
		));

		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		if ($err) {
		  // echo "cURL Error #:" . $err;
			echo json_encode($err);
		} else {
	 		echo json_encode(json_decode($response));
		}

    }
}
