<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class addpemkes extends CI_Controller {
	function index(){
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$idperkara = $this->nativesession->get_flash_session('perkara_id');
		if(!is_numeric($idperkara)){
			show_404();
		}
		$this->show_data($idperkara);
	}

	function show_data($idperkara){
		$this->load->model('pemkes/data_pemkes', 'pemkes');

		$data['pihak_ke'] = $this->nativesession->get_flash_session('pihakke');

		$data['enc_id'] =$this->nativesession->get_flash_session('enc_id',TRUE);
		$idperkarapemkes = $this->encrypt->decode(base64_decode($data['enc_id']));
		$data['enc_pemkesid'] = base64_encode($this->encrypt->encode($idperkarapemkes));

		$action = $this->nativesession->get_flash_session('action');
		$data['enc_act'] = base64_encode($this->encrypt->encode($action));
		if($action=='add1'){
			$nama_tabel = 'pembimbing_masyarakat';
			$urutan= $this->pemkes->geturutanpemkes($nama_tabel,$idperkara);
			if($urutan<1){
				$this->error_page->show_error_msg('Error Found','Something Not Right Happen. Error Code = 197');
			}
			$data['urutan'] = $urutan;
			$data['title'] = 'TAMBAH DATA PEMBIMBING KEMASYARAKATAN';
		}elseif($action=='add2'){
			$nama_tabel = 'pekerja_sosial_profesional';
			$urutan= $this->pemkes->geturutanpemkes($nama_tabel,$idperkara);
			if($urutan<1){
				$this->error_page->show_error_msg('Error Found','Something Not Right Happen. Error Code = 197');
			}
			$data['urutan'] = $urutan;
			$data['title'] = 'TAMBAH DATA PEKERJA SOSIAL PROFESIONAL';
		}elseif($action=='add3'){
			$nama_tabel = 'perwakilan_masyarakat';
			$urutan= $this->pemkes->geturutanpemkes($nama_tabel,$idperkara);
			if($urutan<1){
				$this->error_page->show_error_msg('Error Found','Something Not Right Happen. Error Code = 197');
			}
			$data['urutan'] = $urutan;
			$data['title'] = 'TAMBAH DATA PERWAKILAN MASYARAKAT';
		}elseif($action=='edit1'){			
			$data['title'] = 'UBAH DATA PEMBIMBING KEMASYARAKATAN';
		}elseif($action=='edit2'){			
			$data['title'] = 'UBAH DATA PEKERJA SOSIAL PROFESIONAL';
		}elseif($action=='edit3'){			
			$data['title'] = 'UBAH DATA PERWAKILAN MASYARAKAT';
		}else{
			$this->error_page->show_error_msg('Error Found','Something the right happen. Error Code = 196');
		}
		if($action=='edit1' OR $action=='edit2' OR $action=='edit3'){
			$data['urutan'] = $this->nativesession->get_flash_session('urutan');
			$idpihak = $this->nativesession->get_flash_session('pihak_id');
			$data = $this->fetchPihak($idpihak,$data);
			$data['enc_pihak'] = base64_encode($this->encrypt->encode($idpihak));
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$this->load->vars($data);
		$this->load->view('pemkes/pemkes');
	}

	function fetchPihak($idpemkes,$data){
		if(is_numeric($idpemkes)){
			if($idpemkes>0){
				$this->load->model('pemkes/data_pemkes', 'pemkes');
				$result = $this->pemkes->getDetilInfopemkes($idpemkes);
				if($result!=''){
					if($result->num_rows()>0){
						foreach ($result->result() as $row) {
							$data['enc_pemkesid'] = base64_encode($this->encrypt->encode($row->id));
							$data['nama'] = $row->nama;
							$data['alamat'] = $row->alamat;
							$data['pekerjaan'] = $row->pekerjaan;
							$data['tglLahir'] = $this->tanggalhelper->convertToInputDate($row->tanggal_lahir);
							$data['tempatLahir'] = $row->tempat_lahir;
							$data['jenisPihak'] = $row->jenis_pihak;
							$data['jenisIdentitas'] = $row->jenis_indentitas;
							$data['noIdentitas'] = $row->nomor_indentitas;
							$data['golDarah'] = $row->golongan_darah;
							$data['agama'] = $row->agama;
							if($row->jenis_kelamin=='L'){
								$data['sex'] = 'Laki Laki';
							}elseif($row->jenis_kelamin=='P'){
								$data['sex'] = 'Perempuan';
							}
							$data['wargaNegara'] = $row->warga_negara;
							$data['kawin']	= $row->status_kawin;
							$data['pendidikan'] = $row->pendidikan;
							$data['keterangan'] = $row->keterangan;
							if(!empty($row->tanggal_lahir)){
								$data['umur'] = $this->tanggalhelper->getSelisihTahun($row->tanggal_lahir,date('Y-m-d'));
							}else{
								$data['umur'] = "";
							}
						}
						return $data;
					}
				}else{
					$this->error_page->show_error_msg('Error Found','Something the right happen. Pihak Not Found. Error Code = 192');
					exit();
				}
			}
		}else{
			$this->error_page->show_error_msg('Error Found','Something the right happen. Error Code = 191');
			exit();
		}
	}

	function validateInput(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		
		$this->form_validation->set_rules('no_urut', 'Nomor Urut Pihak', 'trim|required|numeric|xss_clean');
		$this->form_validation->set_rules('fullname', 'Nama Pihak', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tempat_lahir', 'Tempat Lahir', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tgl_lahir', 'Tanggal Lahir', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('umur', 'Umur Pihak', 'trim|required|numeric|xss_clean');
		$this->form_validation->set_rules('warga_negara', 'Warga Negara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('alamat', 'Alamat Pihak', 'trim|required|xss_clean');
		$this->form_validation->set_rules('pekerjaan', 'Pekerjaan Pihak', 'trim|required|xss_clean');
		$this->form_validation->set_rules('statusKawin', 'Status Perkawinan', 'trim|required|xss_clean');
		$this->form_validation->set_rules('pendidikan', 'Pendidikan Terakhir', 'trim|required|xss_clean');

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}

		$idpemkes = $this->encrypt->decode(base64_decode($this->input->post('enc_pemkes',TRUE)));
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		
		//var_dump($idpemkes);
		$this->form_validation->set_rules('no_urut', 'Nomor Urut', 'trim|required|numeric|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			if(!is_numeric($idpemkes) OR $idpemkes<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Pihak Tidak ditemukan. Code Error = 195.'));
				return;
			}else{
				if(!is_numeric($idperkara) OR $idperkara<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Perkara Tidak ditemukan. Code Error = 194.'));
					return;
				}else{
					$this->load->model('pemkes/data_pemkes', 'pemkes');
					$data = array(
						'perkara_id' => $idperkara,
						'urutan' => $this->input->post('no_urut',TRUE),
						'pihak_id' => $idpemkes,
						'keterangan' => trim($this->input->post('keterangan',TRUE))						
					);
					$act = $this->encrypt->decode(base64_decode($this->input->post('act',TRUE)));
					if($act=='add1' OR $act=='edit1'){
						$pihak_ke = "pembimbing_masyarakat";	
					}elseif($act=='add2' OR $act=='edit2'){
						$pihak_ke = "pekerja_sosial_profesional";
					}elseif($act=='add3' OR $act=='edit3'){
						$pihak_ke = "perwakilan_masyarakat";
					}
					
					if($act=='add1' OR $act=='add2' OR $act=='add3') {
						$isexist = $this->pemkes->checkperkarapihakexistence($idperkara,$idpemkes,$pihak_ke);
						if($isexist->num_rows>0){							
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Pembimbing Masyarakat telah terdaftar.'));
							return;
						}
						$data['diinput_oleh'] = $this->session->userdata('username');
						$data['diinput_tanggal'] = date("Y-m-d h:i:s",time());
						$addData = $this->pemkes->add_data($data,$pihak_ke);
					}elseif($act=='edit1' OR $act=='edit2' OR $act=='edit3') {
						$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
						if($id<1){
							echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Terjadi kesalahan pada DATABASE.err'));
							return;
						}
						$data['diperbaharui_oleh'] = $this->session->userdata('username');
						$data['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
						$addData = $this->pemkes->updt_data_pihak($id,$data,$pihak_ke);
						if($addData==FALSE){
							echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Terjadi kesalahan pada DATABASE.'));
							return;
						}elseif (intval($addData)==5) {
							echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Pihak Telah Terdaftar pada perkara yang sama.'));
							return;
						}
					}else{
						echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Something Bad Happen. Error Code = 190.'.$act));
						return;
					}
					
					if($addData==TRUE){						
						echo json_encode(array('st'=>1,'msg'=>'Pihak Berhasil ditambahkan.'));
						return;
					}
					echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Terjadi kesalahan pada DATABASE.'));
				}
			}
		}
	}

	function validateDelete(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$act = $this->encrypt->decode(base64_decode($this->input->post('act',TRUE)));
		if($act=='edit1'){
			$table = 'perkara_pihak_pembimbing_masyarakat';
		}elseif($act=='edit2'){
			$table = 'perkara_pihak_pekerja_sosial_profesional';
		}elseif($act=='edit3'){
			$table = 'perkara_pihak_perwakilan_masyarakat';
		}
		if($act=='edit1' OR $act=="edit2" OR $act=="edit3"){
			$this->load->model('pemkes/data_pemkes', 'pemkes');
			$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			$pihakke = trim($this->input->post('pihak_ke',TRUE));
			$delData = $this->pemkes->del_data($id,$table);
			if($delData==TRUE){				
				echo json_encode(array('st'=>1,'msg'=>'Pihak Berhasil Dihapus.'));
				return;				
			}
			echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Pihak Tidak Berhasil Dihapus. Terjadi kesalahan pada DATABASE.'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Something Bad Happen. Error Code = 189.'));
			return;
		}
	}


}