<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class addJaksa extends CI_Controller {
	function index(){
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$idperkara = $this->nativesession->get_flash_session('perkara_id');
		if(!is_numeric($idperkara)){
			show_404();
		}
		$this->show_data($idperkara);
	}

	function show_data($idperkara){
		$data['pihak_ke'] = $this->nativesession->get_flash_session('pihakke');
		$data['enc_id'] =$this->nativesession->get_flash_session('enc_id',TRUE);
		$action = $this->nativesession->get_flash_session('action');
		$this->load->model('jaksa/data_jaksa', 'jaksa');
		$data['enc_act'] = base64_encode($this->encrypt->encode($action));
		$idperkarajaksa = $this->encrypt->decode(base64_decode($data['enc_id']));
		$data['enc_jaksaid'] = base64_encode($this->encrypt->encode($idperkarajaksa));
		$alurperkaraid = $this->tanggalhelper->getIDAlurPerkara($idperkara);
		if($action=='add'){
			$urutan= $this->jaksa->getUrutanJaksa($data['pihak_ke'],$idperkara);
			if($urutan<1){
				$this->error_page->show_error_msg('Error Found','Something Not Right Happen. Error Code = 197');
			}
			$data['urutan'] = $urutan;
			$data['title'] = 'TAMBAH DATA '.strtoupper($this->nativesession->getStatusPihak(10,$alurperkaraid,$data['pihak_ke']));;
		}elseif($action=='edit'){
			$data['urutan'] = $this->nativesession->get_flash_session('urutan');
			$idpihak = $this->nativesession->get_flash_session('pihak_id');
			$data['title'] = 'UBAH DATA '.strtoupper($this->nativesession->getStatusPihak(10,$alurperkaraid,$data['pihak_ke']));;
			$data = $this->fetchPihak($idpihak,$data);
		}else{
			$this->error_page->show_error_msg('Error Found','Something the right happen. Error Code = 196');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$this->load->vars($data);
		$this->load->view('jaksa/jaksa');
	}

	function fetchPihak($idjaksa,$data){
		if(is_numeric($idjaksa)){
			if($idjaksa>0){
				$this->load->model('jaksa/data_jaksa', 'jaksa');
				$result = $this->jaksa->getDetilInfoJaksa($idjaksa);
				if($result!=''){
					if($result->num_rows()>0){
						foreach ($result->result() as $row) {
							$data['enc_jaksa'] = base64_encode($this->encrypt->encode($row->id));
							$data['nama'] = $row->nama;
							$data['alamat'] = $row->alamat;
							$data['pekerjaan'] = $row->pekerjaan;
							$data['tglLahir'] = $this->tanggalhelper->convertToInputDate($row->tanggal_lahir);
							$data['tempatLahir'] = $row->tempat_lahir;
							$data['jenisPihak'] = $row->jenis_pihak;
							$data['jenisIdentitas'] = $row->jenis_indentitas;
							$data['noIdentitas'] = $row->nomor_indentitas;
							$data['golDarah'] = $row->golongan_darah;
							$data['agama'] = $row->agama;
							if($row->jenis_kelamin=='L'){
								$data['sex'] = 'Laki Laki';
							}elseif($row->jenis_kelamin=='P'){
								$data['sex'] = 'Perempuan';
							}
							$data['wargaNegara'] = $row->warga_negara;
							$data['kawin']	= $row->status_kawin;
							$data['pendidikan'] = $row->pendidikan;
							$data['keterangan'] = $row->keterangan;
							if(!empty($row->tanggal_lahir)){
								$data['umur'] = $this->tanggalhelper->getSelisihTahun($row->tanggal_lahir,date('Y-m-d'));
							}else{
								$data['umur'] = "";
							}
						}
						return $data;
					}
				}else{
					$this->error_page->show_error_msg('Error Found','Something the right happen. Pihak Not Found. Error Code = 192');
					exit();
				}
			}
		}else{
			$this->error_page->show_error_msg('Error Found','Something the right happen. Error Code = 191');
			exit();
		}
	}

	function validateInput(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		
		$this->form_validation->set_rules('no_urut', 'Nomor Urut Pihak', 'trim|required|numeric|xss_clean');
		$this->form_validation->set_rules('fullname', 'Nama Pihak', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tempat_lahir', 'Tempat Lahir', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tgl_lahir', 'Tanggal Lahir', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('umur', 'Umur Pihak', 'trim|required|numeric|xss_clean');
		$this->form_validation->set_rules('warga_negara', 'Warga Negara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('alamat', 'Alamat Pihak', 'trim|required|xss_clean');
		#$this->form_validation->set_rules('pekerjaan', 'Pekerjaan Pihak', 'trim|required|xss_clean');
		$this->form_validation->set_rules('statusKawin', 'Status Perkawinan', 'trim|required|xss_clean');
		$this->form_validation->set_rules('pendidikan', 'Pendidikan Terakhir', 'trim|required|xss_clean');

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}
		$idjaksa = $this->encrypt->decode(base64_decode($this->input->post('enc_jaksa',TRUE)));
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		$pihak_ke = 1;
		$this->form_validation->set_rules('no_urut', 'Nomor Urut', 'trim|required|numeric|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			if(!is_numeric($idjaksa) OR $idjaksa<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Pihak Tidak ditemukan. Code Error = 195.'));
				return;
			}else{
				if(!is_numeric($idperkara) OR $idperkara<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Perkara Tidak ditemukan. Code Error = 194.'));
					return;
				}else{
					$this->load->model('jaksa/data_jaksa', 'jaksa');
					$data = array(
						'perkara_id' => $idperkara,
						'urutan' => $this->input->post('no_urut',TRUE),
						'pihak_id' => $idjaksa,
						'keterangan' => trim($this->input->post('keterangan',TRUE)),
						'diinput_oleh' => $this->session->userdata('username'),
						'diinput_tanggal' => date("Y-m-d h:i:s",time())
					);
					$act = $this->encrypt->decode(base64_decode($this->input->post('act',TRUE)));
					if ($act=='add') {
						$isexist = $this->jaksa->isPihakberpekara($idjaksa,$idperkara);
						if($isexist->num_rows>0){
							$nama ='';
							$status = '';
							foreach ($isexist->result() as $row) {
								$nama = $row->nama;
								$status = $row->status_perkara;
							}
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> '.$nama.' Telah terdaftar sebagai '.$status.' diperkara ini'));
							return;
						}
						$addData = $this->jaksa->add_data($data);
					}elseif ($act=='edit') {
						$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
						if($id<1){
							echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Terjadi kesalahan pada DATABASE.err'));
							return;
						}
						$addData = $this->jaksa->updt_data_pihak($id,$data,$pihak_ke);
						if($addData==FALSE){
							echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Terjadi kesalahan pada DATABASE.'));
							return;
						}elseif (intval($addData)==5) {
							echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Pihak Telah Terdaftar pada perkara yang sama.'));
							return;
						}
					}else{
						echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Something Bad Happen. Error Code = 190.'.$act));
						return;
					}
					
					if($addData==TRUE){
						$data_pihak = array(
						'diperbaharui_oleh' => $this->session->userdata('username'),
						'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
						);
						$updtData = $this->jaksa->update_data($data_pihak,$idperkara,$pihak_ke);
						if($updtData==TRUE){
							echo json_encode(array('st'=>1,'msg'=>'Pihak Berhasil ditambahkan.'));
							return;
						}
					}
					echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Terjadi kesalahan pada DATABASE.'));
				}
			}
		}
	}

	function validateDelete(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$act = $this->encrypt->decode(base64_decode($this->input->post('act',TRUE)));
		if($act=='edit'){
			$this->load->model('jaksa/data_jaksa', 'jaksa');
			$id = $this->encrypt->decode(base64_decode($this->input->post('enc_idjaksa',TRUE)));
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			$pihakke = trim($this->input->post('pihak_ke',TRUE));
			$delData = $this->jaksa->del_data($id,$pihakke);
			if($delData==TRUE){
				$data_perkara = array(
					'diperbaharui_oleh' => $this->session->userdata('username'),
					'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);
				$updtData = $this->jaksa->update_data($data_perkara,$idperkara,$pihakke);
				if($updtData==TRUE){
					echo json_encode(array('st'=>1,'msg'=>'Pihak Berhasil Dihapus.'));
					return;
				}
			}
			echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Pihak Tidak Berhasil Dihapus. Terjadi kesalahan pada DATABASE.'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Something Bad Happen. Error Code = 189.'));
			return;
		}
	}


}