<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Add_register_diversi extends CI_Controller {
	function index($id_diversi=null,$act=null){
		if($this->nativesession->get_flash_session('security')===FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')===FALSE){
			redirect('login');
		}
		$this->show_data($this->encrypt->decode(base64_decode($id_diversi)),$this->encrypt->decode(base64_decode($act)));
	}
	function show_data($id_diversi=null,$act=null){
		$data['page_title'] = 'TAMBAH KESEPAKATAN DIVERSI ';
		$data['main_body'] = 'diversi/new_kesepakatan_diversi';
		if($act=='edit'){
			$data['previous'] = base_url().'detil_diversi/'.base64_encode($this->encrypt->encode($id_diversi));	
		}else{
			$data['previous'] = base_url().'manage_register_diversi';	
		}
		$data['id'] = base64_encode($this->encrypt->encode($id_diversi));
		$data['tgl_sekarang'] = date('d/m/Y');
		$this->load->model('diversi/register_diversi','register_diversi');
		$data['no_urut_diversi']   = $this->register_diversi->get_last_nomor_diversi()+1;
		$data['format_no_diversi'] = '/Pen.Div/'.date(Y).'/PN '.$this->register_diversi->getKodePN(); 
		$data['new_no_diversi']    = $data['no_urut_diversi'].$data['format_no_diversi'];
		if($act=='edit'){
			$data['page_title'] = 'EDIT KESEPAKATAN DIVERSI ';
			$detil_diversi    = $this->register_diversi->get_detil_diversi($id_diversi);
			if($detil_diversi->num_rows()>0){
				foreach ($detil_diversi->result() as $row) {
					$data['no_urut'] = $row->no_urut;
					$data['tgl_diterima_permohonan'] = $row->tgl_permohonan_diversi;
					$data['no_diversi'] = $row->no_diversi;
					$data['pemohon_diversi'] = $row->pemohon_diversi;
					$data['no_reg_penyidik'] = $row->no_reg_penyidik;
					$data['no_reg_penuntut'] = $row->no_reg_penuntut_umum;
					$data['no_perkara'] 	 = $row->no_perkara;
					$data['perkara_id']      = $row->perkara_id;
					$data['no_berita_acara'] = $row->no_berita_acara;
					$data['tgl_berita_acara'] = $row->tgl_berita_acara;
					$data['pasal_sangkaan_dakwaan'] = $row->pasal_sangkaan_dakwaan;
					$data['tgl_kesepakatan_diversi'] = $row->tgl_kesepakatan_diversi;
					$data['isi_kesepakatan_diversi'] = $row->isi_kesepakatan_diversi;
					$data['tgl_penetapan_kpn'] = $row->tgl_penetapan_kpn;
					$data['tgl_pengiriman_penetapan_kpn'] = $row->tgl_pengiriman_penetapan_kpn;
					$data['amar'] = $row->amar;
					$data['tgl_pelaksanan_isi_diversi'] = $row->tgl_pelaksanan_isi_diversi;
				}
			}
		}
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '800px';
		$this->ckeditor->config['height'] = '200px';
		
		$data['act']=$act;
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}

	function get_nomor_perkara_diversi(){
		$manual = $this->input->post('val',true);
		if($manual==1){
			$this->load->model('diversi/register_diversi','register_diversi');
			$no_urut_diversi   = $this->register_diversi->get_last_nomor_diversi()+1;
			$format_no_diversi = '/Pen.Div/'.date(Y).'/PN '.$this->register_diversi->getKodePN(); 
			$new_no_diversi    = $no_urut_diversi.$format_no_diversi;
			if(!empty($no_urut_diversi)){
				echo json_encode(array('st'=>1,'no_urut_diversi'=>$no_urut_diversi,'new_no_diversi'=>$new_no_diversi));
				return;
			}			
		}else{
			return;
		}
	}

	function get_info_perkara_sppa(){
		$no_perkara = $this->input->post('no_perkara',true);
		if(!empty($no_perkara)){
			$this->load->model('diversi/register_diversi','register_diversi');
			$info_perkara_sppa   = $this->register_diversi->get_info_sppa($no_perkara);
			if($info_perkara_sppa->num_rows>0){
				foreach ($info_perkara_sppa->result() as $row) {
					$perkara_id 		= $row->perkara_id;
					$tgl_pendaftaran 	= $row->tanggal_pendaftaran;
					$nama_anak 			= $row->nama_anak;
					$jenis_perkara 		= $row->jenis_perkara_nama;
					$tahapan_terakhir 	= $row->tahapan_terakhir_text;
				}
			
				$info_sppa = "<div id='info_perkara'>Tanggal Pendaftaran : ".$this->tanggalhelper->convertDate($tgl_pendaftaran)."<br>
							  Nama Anak        : ".$nama_anak."<br>
							  Jenis perkara    : ".$jenis_perkara."<br>
							  Tahapan Terakhir : ".$tahapan_terakhir."</div>"; 
			}else{
				$info_sppa = "<div id='info_perkara'><font color='red'>Cek kembali nomor perkara ini, data tidak ditemukan</font></div>";
			}
			echo json_encode(array('st'=>1,'perkara_id'=>$perkara_id,'info_sppa'=>$info_sppa));
			return;

		}else{
			echo json_encode(array('st'=>0,'msg'=>'Isi dulu kolom nomor perkara..!'));
			return;
		}
	}

	function auto_complete($keyword){
		$data = $this->db->query('select perkara_id,nomor_perkara from perkara where alur_perkara_id = 118 AND nomor_perkara like \''.$keyword.'%\' limit 20');
		foreach($data->result() as $row)
		{
			$arr['query'] = $keyword;
			$arr['suggestions'][] = array(
				'value'	=>$row->nomor_perkara
			);
		}
		// minimal PHP 5.2
		echo json_encode($arr);
	}	
	function validateInput(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		if(empty($_POST)){
			show_404();
		}

		$this->load->model('diversi/register_diversi','register_diversi');
		$tgl_diterima_permohonan 	= $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_diterima_permohonan',TRUE));
		$no_urut_diversi 	= $this->input->post('no_urut_diversi',TRUE);
		$no_diversi 		= $this->input->post('no_diversi',TRUE);
		$dimohononkan_oleh	= $this->input->post('dimohonkan_oleh',TRUE);
		$act	= $this->input->post('act',TRUE);
		$tahun_nomor 		= substr($tgl_diterima_permohonan, 0,4);
		if($dimohononkan_oleh==1){
			$no_reg_penyidik 	= $this->input->post('no_reg_penyidik',true);			
			$no_reg_penuntut 	= null;
			$no_perkara 		= null;
			$perkara_id 		= null;
		}else if($dimohononkan_oleh==2){
			$no_reg_penyidik 	= null;
			$no_reg_penuntut 	= $this->input->post('no_reg_penuntut',true);			
			$no_perkara 		= null;
			$perkara_id 		= null;		
		}/*else if($dimohononkan_oleh==3){
			$no_perkara 		= $this->input->post('no_perkara',true);
			$perkara_id = $this->input->post('perkara_id',true);
			$no_reg_penyidik 	= null;
			$no_reg_penuntut 	= null;						
		}*/
		if($act=='edit'){
			$id		= $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			$no_berita_acara	= $this->input->post('no_berita_acara',TRUE);
			$tgl_berita_acara	= $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_berita_acara',TRUE));
			$pasal_sangkaan_dakwaan_text	= $this->input->post('pasal_sangkaan_dakwaan_text',TRUE);
			$tgl_kesepakatan_diversi	= $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_kesepakatan_diversi',TRUE));
			$isi_kesepakatan_diversi_text	= $this->input->post('isi_kesepakatan_diversi_text',TRUE);
			$tgl_penetapan_kpn	= $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_penetapan_kpn',TRUE));
			$tgl_pengiriman_penetapan_kpn	= $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pengiriman_penetapan_kpn',TRUE));
			$amar_text	= $this->input->post('amar_text',TRUE);
			$tgl_pelaksanan_isi_diversi	= $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pelaksanan_isi_diversi',TRUE));
		}

		if($act!='edit'){
		$cek_diversi=$this->register_diversi->cek_no_diversi($no_diversi,$tahun_nomor);
		$cek_no_urut=$this->register_diversi->cek_no_urut_diversi($no_urut_diversi,$tahun_nomor);
		if($cek_diversi==1){
			echo json_encode(array('st'=>0,'msg'=>'Nomor Diversi sudah ada dalam register'));
			return;
		}
		if($cek_no_urut==1){
			echo json_encode(array('st'=>0,'msg'=>'Nomor Urut Diversi sudah ada dalam register'));
			return;
		}
		}
		
		$this->form_validation->set_rules('no_diversi', 'Nomer Diversi', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tgl_diterima_permohonan', 'Tanggal Diterima Permohonan', 'trim|required|xss_clean|exact_length[10]');

		$curr_date = date('Y-m-d');
		$id_diversi = $this->register_diversi->last_id_diversi();
	
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
		}else{
			if($act=='edit'){
				$data = array(
						'tgl_permohonan_diversi' => $tgl_diterima_permohonan,
						'pemohon_diversi' => $dimohononkan_oleh,
						'no_reg_penyidik' => $no_reg_penyidik,
						'no_reg_penuntut_umum' => $no_reg_penuntut,

						'no_berita_acara' => $no_berita_acara,
						'tgl_berita_acara' => $tgl_berita_acara,
						'tgl_kesepakatan_diversi' => $tgl_kesepakatan_diversi,
						'tanggal_penetapan_kpn' => $tgl_penetapan_kpn,
						'tgl_pengiriman_penetapan_kpn' => $tgl_pengiriman_penetapan_kpn,
						'tgl_pelaksanaan_isi_diversi' => $tgl_pelaksanan_isi_diversi,
						'pasal_sangkaan_dakwaan' => $pasal_sangkaan_dakwaan_text,
						'isi_kesepakatan_diversi' => $isi_kesepakatan_diversi_text,
						'amar' => $amar_text,

						'diperbaharui_oleh' => $this->session->userdata('username'),
						'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);			
				$result = $this->register_diversi->update_diversi($data,$id);
			}else{
						$data = array(
						'id' => $id_diversi,
						'no_urut' => $no_urut_diversi,
						'no_diversi' => $no_diversi,
						'tgl_permohonan_diversi' => $tgl_diterima_permohonan,
						'pemohon_diversi' => $dimohononkan_oleh,
						'no_reg_penyidik' => $no_reg_penyidik,
						'no_reg_penuntut_umum' => $no_reg_penuntut,
/*						'no_perkara' => $no_perkara,
						'perkara_id' => $perkara_id,
*/						'diinput_oleh' => $this->session->userdata('username'),
						'diinput_tanggal' => date("Y-m-d h:i:s",time())
					);			
				$result = $this->register_diversi->add_diversi($data);
			}


			if($result===FALSE){
				echo json_encode(array('st'=>0,'msg'=>'GAGAL Menyimpan'));
				return;
			}else{
				echo json_encode(array('st'=>1,'msg'=>'Berhasil Menyimpan'));
				return;
			}
		}
	}

	function popup_hapus_register($enc_register){
		$register_id=$this->encrypt->decode(base64_decode($enc_register));
		$query=$this->db->query("SELECT no_diversi FROM diversi_register WHERE id=".$register_id);
		$data['no_diversi']=$query->row()->no_diversi;
		$data['enc_register']=$enc_register;
		$this->load->view('diversi/popup_hapus_register',$data);
	}

	function hapus_register($enc_register){
		$register_id=$this->encrypt->decode(base64_decode($enc_register));
		$this->db->query('DELETE FROM diversi_register WHERE id='.$register_id);
		redirect('manage_register_diversi');
	}

	function parsePihak($listpihak,$idpihak){
		foreach ($listpihak as $key) {
			$idpihakpemohon = $this->encrypt->decode(base64_decode($key));
			if($idpihak==$idpihakpemohon){
				return TRUE;
			}
		}
		return FALSE;
	}

}