<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Add_perdata_eksekusi extends CI_Controller {
	function index(){
		#prevent direct access to page
		#the user should only access the page through menu
		if($this->nativesession->get_flash_session('security')===FALSE){
			redirect('main');
		}
		$sec = $this->nativesession->get_flash_session('security');

		if($this->session->userdata('is_logged_in')===FALSE){
			redirect('login');
		}

		$param_alur = $this->nativesession->get_flash_session('alur_perkara_id');
		$pecah_alur=explode(',', $param_alur);
		if(count($pecah_alur)==2){
			$idalurperkara=$pecah_alur[0];	
		}else if(count($pecah_alur)==1){
		$idalurperkara=$param_alur;
		}else{
			$idalurperkara=$param_alur;
		}

		$idtahapan = $this->nativesession->get_flash_session('tahapan_id');
		$this->show_data($idalurperkara,$idtahapan);
	}
	function show_data($idalurperkara,$idtahapan){

		$data['page_title'] = 'TAMBAH PERMOHONAN EKSEKUSI ';#.strtoupper($this->perkara->getJenisPerkara($idalurperkara));
		$data['main_body'] = 'perkara/new_perdata_eksekusi';
		$data['previous'] = $this->nativesession->get_flash_session('url_requested');
		$data['tgl_sekarang'] = date('d/m/Y');
		$data['alur_perkara_id']=base64_encode($this->encrypt->encode($idalurperkara));
		$data['lang_nomor_perkara']=$this->nativesession->getLangguage('nomor_perkara');
		$data['lang_pengadilan_negeri']=$this->nativesession->getLangguage('pengadilan_negeri');		
		$this->load->model('perkara/new_eksekusi','eksekusi');
		$biaya_pendaftaran = $this->eksekusi->get_biaya_pendaftaran();

		$no_urut_eks = $this->eksekusi->getNomorUrutRegisterEks($idalurperkara,date("Y-m"));
		$no_urut_eksht = $this->eksekusi->getNomorUrutRegisterEksHt($idalurperkara,date("Y-m"));

		if($no_urut_eks>$no_urut_eksht){
			$data['no_urut']=$no_urut_eks;
		}else{
			$data['no_urut']=$no_urut_eksht;
		}

		$no_perkara_eks = $this->eksekusi->getNomorPerkaraEks($idalurperkara,date("Y"));
		$no_perkara_eksht = $this->eksekusi->getNomorPerkaraEksHt(date("Y"));

		if($no_perkara_eks>$no_perkara_eksht){
			$no_urut_perkara=$no_perkara_eks;
		}else{
			$no_urut_perkara=$no_perkara_eksht;
		}

		$format_no_eksekusi='Pdt.Eks';
		$tahun_perkara=date('Y');		
		$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
		$kode_pengadilan = $this->eksekusi->getKodePN();
		if($jenis_pengadilan==1){
			$kode_pengadilan='PN '.$kode_pengadilan;
		}else if($jenis_pengadilan==4){
			$kode_pengadilan=$kode_pengadilan;
		}
		$data['no_urut_perkara']=$no_urut_perkara;
		$data['no_perkara_eksekusi_auto']=$no_urut_perkara.'/'.$format_no_eksekusi.'/'.$tahun_perkara.'/'.$kode_pengadilan;
		$data['no_perkara_eksekusi_man']='/'.$format_no_eksekusi.'/'.$tahun_perkara.'/'.$kode_pengadilan;

		if($biaya_pendaftaran->num_rows>0){
			$data['pendaftaran'] = $biaya_pendaftaran->row()->jumlah;
		}

		$biaya_atk = $this->eksekusi->get_biaya_atk();
		if($biaya_atk->num_rows>0){
			$data['atk'] = $biaya_atk->row()->jumlah;
		}

		if($idalurperkara=='1,7,8'){
			$data['idalurperkara'] = 95;
		}

		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}

	function show_cari_eksekusi(){
		if(empty($_POST)){ show_404(); }

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu'));
			return;
		}

		$nomor_perkara = trim($this->input->post('val',FALSE));
		if(empty($nomor_perkara)){
			echo json_encode(array('st'=>0,'msg'=>'Silahkan Isikan Nomor Perkara Terlebih Dahulu'));
			return;
		}

		$cek_alur=$this->encrypt->decode(base64_decode($this->input->post('enc_alur',TRUE)));

		$this->load->model('perkara/new_eksekusi','eksekusi');

		$row_perkara =  $this->eksekusi->getPerkara($nomor_perkara);
		if($row_perkara->num_rows==1){
			$perkara_id = $row_perkara->row()->perkara_id;
			$alurperkaraid = $row_perkara->row()->alur_perkara_id;
		}elseif($row_perkara->num_rows>1){
			echo json_encode(array('st'=>0,'msg'=>'Error; Ditemukan Lebih dari satu nomor perkara '.$nomor_perkara.' yang anda masukan'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error Nomor Perkara Tidak Ditemukan'));
			return;
		}
		#16042016 didik
		if($this->session->userdata('jenis_pengadilan')!=3){			
			$match = FALSE;
			$is_alur = strpos($cek_alur,',');
			if($is_alur!==false){
				$tmp = explode(',', $cek_alur);
				if(count($tmp)>1){
					for ($i=0; $i < count($tmp); $i++) { 
						if($alurperkaraid==$tmp[$i])
							$match = TRUE;
					}
				}
			}elseif($alurperkaraid==$cek_alur){
					$match = TRUE;				
			}						
		}
		#29-11-2015 didik
		$jenis_perkara =  $this->eksekusi->getNomorPerkara($perkara_id);
		if($jenis_perkara->num_rows>0){
			$jenisPerkara = $jenis_perkara->row()->jenis_perkara_id;
			$jenisPerkaraNama = $jenis_perkara->row()->jenis_perkara_nama;
		}
		if($jenisPerkara==341 OR $jenisPerkara==346 OR $jenisPerkara==347 OR $jenisPerkara==352 OR $jenisPerkara==358 OR $jenisPerkara==360 OR $jenisPerkara==624){
			echo json_encode(array('st'=>0,'msg'=>'Perkara tersebut adalah '.$jenisPerkaraNama.' tidak bisa untuk dimohonankan eksekusi'));
			return;
		}

		$perkaraBHT = $this->eksekusi->getPerkaraBHT($perkara_id);
		if($perkaraBHT->num_rows>0){
			$tanggal_bht = $perkaraBHT->row()->tanggal_bht;
		}

		if(($alurperkaraid==15 OR $alurperkaraid==16) AND empty($tanggal_bht)){
			echo json_encode(array('st'=>0,'msg'=>'Perkara tersebut belum BHT, tidak bisa untuk dimohonkan eksekusi'));
			return;
		}

		$cek_eksekusi=$this->eksekusi->getPerkaraEksekusi($perkara_id);
		$sudaheksekusi = $cek_eksekusi->row()->ada_eksekusi;
		if($sudaheksekusi==1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tersebut sudah ada dalam daftar permohonan eksekusi'));
			return;
		}

		$putusan_pn = $this->eksekusi->data_putusan_pn($perkara_id);

		if($putusan_pn->num_rows>0){
			$tgl_putusan_pn = $this->tanggalhelper->convertToInputDate($putusan_pn->row()->tanggal_putusan);
			$amar_pn = $putusan_pn->row()->amar_putusan;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tersebut Belum Putus'));
			return;
		}


		$putusan_banding = $this->eksekusi->data_banding($perkara_id);
		if($putusan_banding->num_rows>0){
			$nomor_perkara_banding = $putusan_banding->row()->nomor_perkara_banding;
			$tgl_putusan_banding = $this->tanggalhelper->convertToInputDate($putusan_banding->row()->putusan_banding);
			$amar_banding = $putusan_banding->row()->amar_putusan_banding;
			if(!empty($tgl_putusan_banding)){
			}
		} else {
			$nomor_perkara_banding = "";
			$tgl_putusan_banding = "";
			$amar_banding="";
		}
				
		$putusan_kasasi = $this->eksekusi->data_kasasi($perkara_id);
		
		if($putusan_kasasi->num_rows>0){
			$nomor_perkara_kasasi = $putusan_kasasi->row()->nomor_perkara_kasasi;
			$tgl_putusan_kasasi = $this->tanggalhelper->convertToInputDate($putusan_kasasi->row()->putusan_kasasi);
			$amar_kasasi = $putusan_kasasi->row()->amar_putusan_kasasi;
			if(!empty($tgl_putusan_kasasi)){
			}
		} else {
			$nomor_perkara_kasasi = "";
			$tgl_putusan_kasasi = "";
			$amar_kasasi="";
		}


		$putusan_pk = $this->eksekusi->data_pk($perkara_id);
		if($putusan_pk->num_rows>0){
			$nomor_perkara_pk = $putusan_pk->row()->nomor_perkara_pk;
			$tgl_putusan_pk =$this->tanggalhelper->convertToInputDate($putusan_pk->row()->putusan_pk);
			$amar_pk = $putusan_pk->row()->amar_putusan_pk;
			if(!empty($tgl_putusan_pk)){
			}
		} else {
			$nomor_perkara_pk = "";
			$tgl_putusan_pk = "";
			$amar_pk="";
		}

		$penggugatHtml ='<td style="padding:0px;padding-left:5px;" id="td_penggugat">';
		$parapenggugat = $this->eksekusi->data_penggugat($perkara_id);
		$y=1;
		if($parapenggugat->num_rows>0){
			foreach ($parapenggugat->result() as $row) {
				$penggugatHtml .=' <input class="c_penggugat" type="checkbox" value="'.$row->pihak_id.';'.$row->nama.'" id="penggugat'.$y.'" name="penggugat[]">'.$row->nama.'<br>';
				$y++;
			}
		}
		$penggugatHtml .='</td>';

		$tergugatHtml ='<td style="padding:0px;padding-left:5px;" id="td_tergugat">';
		$paratergugat = $this->eksekusi->data_tergugat($perkara_id);
		$y=1;
		if($paratergugat->num_rows>0){
			foreach ($paratergugat->result() as $row) {
				$tergugatHtml .=' <input class="c_tergugat" type="checkbox" value="'.$row->pihak_id.';'.$row->nama.'" id="tergugat'.$y.'" name="tergugat[]">'.$row->nama.'<br>';
				$y++;
			}
		}

		$tergugatHtml .='</td>';

		echo json_encode(array(
			'st'=>1,
			'msg'=>'Perkara ditemukan ',
			'tgl_putusan_pn'=>$tgl_putusan_pn,
			'nomor_perkara_banding'=>$nomor_perkara_banding,
			'tgl_putusan_banding'=>$tgl_putusan_banding,
			'nomor_perkara_kasasi'=>$nomor_perkara_kasasi,
			'tgl_putusan_kasasi'=>$tgl_putusan_kasasi,
			'nomor_perkara_pk'=>$nomor_perkara_pk,
			'tgl_putusan_pk'=>$tgl_putusan_pk,
			'perkara_id'=>base64_encode($this->encrypt->encode($perkara_id)),
			'alur_perkara_id'=>base64_encode($this->encrypt->encode($alurperkaraid)),	
			'amarpnHtml' => $amar_pn,
			'amarbandingHtml' => $amar_banding,
			'amarkasasiHtml' => $amar_kasasi,
			'amarpkHtml' => $amar_pk,
			'penggugatHtml' => $penggugatHtml,
			'tergugatHtml' => $tergugatHtml,			
		));
		return;
		}


	function get_nomor_perkara_eksekusi(){
		$idalurperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		$is_generate = $this->input->post('val',TRUE);
		$this->load->model('perkara/new_eksekusi','eksekusi');

		$no_urut_eks = $this->eksekusi->getNomorUrutRegisterEks($idalurperkara,date("Y-m"));
		$no_urut_eksht = $this->eksekusi->getNomorUrutRegisterEksHt($idalurperkara,date("Y-m"));

		if($no_urut_eks>$no_urut_eksht){
			$no_urut_reg_eks=$no_urut_eks;
		}else{
			$no_urut_reg_eks=$no_urut_eksht;
		}

		$no_perkara_eks = $this->eksekusi->getNomorPerkaraEks($idalurperkara,date("Y"));
		$no_perkara_eksht = $this->eksekusi->getNomorPerkaraEksHt(date("Y"));

		if($no_perkara_eks>$no_perkara_eksht){
			$no_urut_perkara=$no_perkara_eks;
		}else{
			$no_urut_perkara=$no_perkara_eksht;
		}

		$format_no_eksekusi='Pdt.Eks';
		$tahun_perkara=date('Y');		
		$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
		$kode_pengadilan = $this->eksekusi->getKodePN();
		if($jenis_pengadilan==1){
			$kode_pengadilan='PN '.$kode_pengadilan;
		}else if($jenis_pengadilan==3){
			$kode_pengadilan='PTUN.'.$kode_pengadilan;
		}else if($jenis_pengadilan==4){
			$kode_pengadilan='PA.'.$kode_pengadilan;
		}

		
		if($is_generate==1){
			$no_eksekusi = $no_perkara_eksekusi_auto=$no_urut_perkara.'/'.$format_no_eksekusi.'/'.$tahun_perkara.'/'.$kode_pengadilan;
			$no_urut_reg = $no_urut_reg_eks;
			echo json_encode(array('st'=>1,'msg'=>$no_eksekusi,'nourutregister'=>$no_urut_reg));
		}else{
			echo json_encode(array('st'=>0,'msg'=>"Error, Please refresh your Page",'nourutregister'=>"Error, Please refresh your Page"));
		}
	
	}


	function validateInput(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		if(empty($_POST)){
			show_404();
		}
		$this->load->model('perkara/new_eksekusi','eksekusi');
		
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('idperkara',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$cek_eksekusi=$this->eksekusi->getPerkaraEksekusi($idperkara);
		$sudaheksekusi = $cek_eksekusi->row()->ada_eksekusi;
		if($sudaheksekusi==1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tersebut sudah ada dalam daftar permohonan eksekusi'));
			return;
		}
		
		$idalurperkara = $this->encrypt->decode(base64_decode($this->input->post('alurperkaraid',TRUE)));
		if(!is_numeric($idalurperkara) OR intval($idalurperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Something Bad Happened, Please Refresh Your Browser.'));
			return;
		}

		$this->form_validation->set_rules('nomor_perkara_pn', 'Nomor Perkara PN', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tgl_putusan_pn', 'Tanggal Putusan PN', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('nomor_perkara_banding', 'Nomor Perkara Banding', 'trim|xss_clean');
		$this->form_validation->set_rules('tgl_putusan_banding', 'Tanggal Putusan Banding', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('nomor_perkara_kasasi', 'Nomor Perkara Kasasi', 'trim|xss_clean');
		$this->form_validation->set_rules('tgl_putusan_kasasi', 'Tanggal Putusan kasasi', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('nomor_perkara_pk', 'Nomor Perkara PK', 'trim|xss_clean');
		$this->form_validation->set_rules('tgl_putusan_pk', 'Tanggal Putusan PK', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('listdataput', 'Putusan Eksekusi', 'trim|required|xss_clean');		
		$this->form_validation->set_rules('no_perkara_mhn_eksekusi', 'Nomor Perkara di Mohonkan Eksekusi', 'trim|required|xss_clean');				
		$this->form_validation->set_rules('amar_yg_dieksekusi', 'Amar yang Eksekusi', 'trim|required|xss_clean');				
		$this->form_validation->set_rules('tgl_permohonan_eksekusi', 'Tanggal Permohonan Eksekusi', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('nama_pemohon', 'Nama Pemohon Eksekusi', 'trim|required|xss_clean');		
		$this->form_validation->set_rules('tgl_surat_kuasa', 'Tanggal Surat Kuasa', 'trim|xss_clean');		
		$this->form_validation->set_rules('no_surat_kuasa', 'Nomor Surat Kuasa', 'trim|xss_clean');		

		$this->form_validation->set_rules('panjar', 'Biaya Panjar Perkara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('pendaftaran', 'Biaya Pendaftaran Perkara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('atk', 'Biaya Alat Tulis Kantor', 'trim|required|xss_clean');
		if($this->session->userdata('jenis_pengadilan')!=3){
			$this->form_validation->set_rules('no_urut_eksekusi', 'Nomor Urut Register Eksekusi', 'trim|required|xss_clean');
			$this->form_validation->set_rules('no_perkara_eksekusi_auto', 'Nomor Eksekusi', 'trim|required|xss_clean');
			$this->form_validation->set_rules('no_urut_perkara_eks_manual', 'Nomor Perkara Manual Eksekusi', 'trim|required|xss_clean');		
			$this->form_validation->set_rules('no_perkara_eksekusi_man', 'Nomor Eksekusi', 'trim|required|xss_clean');
		}
		
		$is_generate=$this->input->post('generate',TRUE);
		$no_urut_reg_eksekusi=$this->input->post('no_urut_eksekusi',TRUE);
		$no_perkara_eksekusi_auto=$this->input->post('no_perkara_eksekusi_auto',TRUE);
		$no_urut_perkara_eks_manual=$this->input->post('no_urut_perkara_eks_manual',TRUE);
		$no_perkara_eksekusi_man=$this->input->post('no_perkara_eksekusi_man',TRUE);

		$tgl_permohonan_eks=substr($this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_permohonan_eksekusi',TRUE)),0,7);

		$cek_no_urut_eks = $this->eksekusi->cek_nomor_urut_eks($no_urut_reg_eksekusi,$tgl_permohonan_eks);
		$cek_no_urut_eksht = $this->eksekusi->cek_nomor_urut_eksht($no_urut_reg_eksekusi,$tgl_permohonan_eks);

		if($cek_no_urut_eks==1 || $cek_no_urut_eksht==1){
			echo json_encode(array('st'=>0,'msg'=>'Nomor Urut pada bulan permohonan ini sudah ada'));
			return;
		}



		if($is_generate==1){
			$no_perkara_eksekusi=$no_perkara_eksekusi_auto;
		}else if($is_generate==0){
			$no_perkara_eksekusi=$no_urut_perkara_eks_manual.''.$no_perkara_eksekusi_man;
		}

		$cek_nomor_perkara_eks = $this->eksekusi->cek_nomor_perkara_eks($no_perkara_eksekusi);
		$cek_nomor_perkara_eksht = $this->eksekusi->cek_nomor_perkara_eksht($no_perkara_eksekusi);

		if($cek_nomor_perkara_eks==1 || $cek_nomor_perkara_eksht==1){
			echo json_encode(array('st'=>0,'msg'=>'Nomor Register Eksekusi :'.$no_perkara_eksekusi.' sudah ada dalam register'));
			return;
		}


		$curr_date = date('Y-m-d');

		$pihak_penggugat = $this->input->post('penggugat',TRUE);
		$pihak_tergugat = $this->input->post('tergugat',TRUE);

		$cek_tgl_permohonan=$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_permohonan_eksekusi',TRUE));
		$cek_tgl_put_pn=$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_putusan_pn',TRUE));

		$cekselisihinihari = $this->tanggalhelper->getSelisihHari($cek_tgl_permohonan,$curr_date);
		$cekselisihpermohonan = $this->tanggalhelper->getSelisihHari($cek_tgl_put_pn,$cek_tgl_permohonan);
		
		if($cek_tgl_permohonan!=''){
			if($cekselisihinihari<0 || $cekselisihpermohonan<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Cek Tanggal Permohonan Eksekusi, tidak boleh lebih dari hari ini atau kurang dari Tanggal Putusan PN'));
				return;
			}
		}


		if(($pihak_penggugat==0 || $pihak_penggugat=='') && ($pihak_tergugat==0 || $pihak_tergugat=='') ){
			echo json_encode(array('st'=>0,'msg'=>'Pihak belum ada yang dipilih.'));
			return;
		}

		$id_tergugat='';$nama_tergugat='';

		if($pihak_tergugat!='' || $pihak_tergugat!=0){
		 	$aa_tergugat=implode(';', $pihak_tergugat);
		 	$ax_tergugat=explode(';', $aa_tergugat);
		 	$ac_tergugat=count($ax_tergugat);
		 	
		 	for ($i=0;$i<$ac_tergugat;$i++){
		 		if ($i!=0){
		 			if($i % 2 ==0){
		 				$id_tergugat .= ','.$ax_tergugat[$i];		
			 		}else{
			 			if ($i!=1){
			 				$nama_tergugat .= ',';
			 			}
			 			$nama_tergugat .= $ax_tergugat[$i];
			 		}	
		 		}else{
		 			$id_tergugat .= $ax_tergugat[$i];	
		 		}

		 	}
	 	}
		$id_penggugat='';$nama_penggugat='';
		if($pihak_penggugat!='' || $pihak_penggugat!=0){
		 	$aa_penggugat=implode(';', $pihak_penggugat);
		 	$ax_penggugat=explode(';', $aa_penggugat);
		 	$ac_penggugat=count($ax_penggugat);
		 	
		 	for ($i=0;$i<$ac_penggugat;$i++){
		 		if ($i!=0){
		 			if($i % 2 ==0){
		 				$id_penggugat .= ','.$ax_penggugat[$i];		
			 		}else{
			 			if ($i!=1){
			 				$nama_penggugat .= ',';
			 			}
			 			$nama_penggugat .= $ax_penggugat[$i];
			 		}	
		 		}else{
		 			$id_penggugat .= $ax_penggugat[$i];	
		 		}

		 	}
	 	}

		if(($pihak_penggugat!=0 or $pihak_penggugat!='')){
			$pihak_pemohon_eksekusi='1';
			$kuasadari='Kuasa dari Penggugat :';
			$yangikuasakan=$nama_penggugat;
		}else{
			$pihak_pemohon_eksekusi='2';
			$kuasadari='Kuasa dari Tergugat :';
			$yangikuasakan=$nama_tergugat;
		}

		$idpemohon=$this->encrypt->decode(base64_decode($this->input->post('enc_pemohon',TRUE)));

		$pemohon = $this->input->post('nama_pemohon',TRUE);
		if(!empty($pemohon)){
			if($idpemohon==$id_penggugat){
				$pemohon_eksekusi=$pemohon.' (Penggugat)';	
			}else if($idpemohon==$id_tergugat){
				$pemohon_eksekusi=$pemohon.' (Tergugat)';	
			}else{
				$pemohon_eksekusi=$pemohon.' ('.$kuasadari.' '.$yangikuasakan.')';	
			}
		}


	
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
		}else{
			$this->load->model('perkara/new_eksekusi','eksekusi');
			
			$datapihak = '';
			$i=0;

			$listpihakpenggugat = $this->eksekusi->data_penggugat($idperkara);		
			if($listpihakpenggugat!=''){
				if($listpihakpenggugat->num_rows>0){
					$pihak_list = $this->input->post('penggugat',TRUE);
					if(empty($pihak_list)){
						$diwakili='T';
						$idpemohon='';
						$nama_pemohon='';
						$pekerjaan_pemohon='';
						$alamat_pemohon='';
						$pemohoneksekusi='';
						$statuspihakid=2;
						$statuspihaktext='Termohon';
						$tglpermohonan=NULL;
					}else{
						$diwakili='Y';
						$idpemohon=$this->encrypt->decode(base64_decode($this->input->post('enc_pemohon',TRUE)));
						$nama_pemohon=$this->input->post('nama_pemohon',TRUE);
						$pekerjaan_pemohon=$this->input->post('pekerjaan_pemohon',TRUE);
						$alamat_pemohon=$this->input->post('alamat_pemohon',TRUE);
						$pemohoneksekusi=$pemohon_eksekusi;
						$statuspihakid=1;
						$statuspihaktext='Pemohon';
						$tglpermohonan=$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_permohonan_eksekusi',TRUE));
					}

					
					foreach ($listpihakpenggugat->result() as $row) {
							if(preg_match('/'.$row->pihak_id.'/',$id_penggugat)){
								$pihak = array(
										'perkara_id' => $idperkara,
										'alur_perkara_id' => $idalurperkara,
										'status_pihak_id' => $statuspihakid,
										'status_pihak_text' => $statuspihaktext,
										'permohonan_eksekusi' => $tglpermohonan,
										'pihak_asal' => 1,
										'pihak_asal_text' => 'Penggugat',
										'pihak_id' => $row->pihak_id,
										'pihak_nama' => $row->nama,
										'pihak_diwakili' => $diwakili,
										'pemohon_id' => $idpemohon,
										'pemohon_nama' => $nama_pemohon,
										'pemohon_pekerjaan' => $pekerjaan_pemohon,
										'pemohon_alamat' => $alamat_pemohon,
										'pemohon_tanggal_surat' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_surat_kuasa',TRUE)),
										'pemohon_nomor_surat' => $this->input->post('no_surat_kuasa',TRUE),
										'pemohon_eksekusi' => $pemohoneksekusi,
										'diinput_oleh' => $this->session->userdata('username'),
										'diinput_tanggal' => date("Y-m-d h:i:s",time())
								);
							}else{
							$pihak = array(
									'perkara_id' => $idperkara,
									'alur_perkara_id' => $idalurperkara,
									'status_pihak_id' => 2,
									'status_pihak_text' => 'Termohon',
									'permohonan_eksekusi' => NULL,
									'pihak_asal' => 1,
									'pihak_asal_text' => 'Penggugat',
									'pihak_id' => $row->pihak_id,
									'pihak_nama' => $row->nama,
									'pihak_diwakili' => 'T',
									'pemohon_id' => NULL,
									'pemohon_nama' => '',
									'pemohon_pekerjaan' => '',
									'pemohon_alamat' => '',
									'pemohon_tanggal_surat' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_surat_kuasa',TRUE)),
									'pemohon_nomor_surat' => $this->input->post('no_surat_kuasa',TRUE),									
									'pemohon_eksekusi' => '',
									'diinput_oleh' => $this->session->userdata('username'),
									'diinput_tanggal' => date("Y-m-d h:i:s",time())
							);

							}
							$datapihak[$i] = $pihak;
							$i++;

					}
				}
			}

			$listpihaktergugat = $this->eksekusi->data_tergugat($idperkara);		
			if($listpihaktergugat!=''){
				if($listpihaktergugat->num_rows>0){

					$pihak_list = $this->input->post('tergugat',TRUE);
					if(empty($pihak_list)){
						$diwakili='T';
						$idpemohon='';
						$nama_pemohon='';
						$pekerjaan_pemohon='';
						$alamat_pemohon='';
						$pemohoneksekusi='';
						$statuspihakid=2;
						$statuspihaktext='Termohon';
						$tglpermohonan=NULL;
					}else{
						$diwakili='Y';
						$idpemohon=$this->encrypt->decode(base64_decode($this->input->post('enc_pemohon',TRUE)));
						$nama_pemohon=$this->input->post('nama_pemohon',TRUE);
						$pekerjaan_pemohon=$this->input->post('pekerjaan_pemohon',TRUE);
						$alamat_pemohon=$this->input->post('alamat_pemohon',TRUE);
						$pemohoneksekusi=$pemohon_eksekusi;
						$statuspihakid=1;
						$statuspihaktext='Pemohon';
						$tglpermohonan=$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_permohonan_eksekusi',TRUE));
					}

					
					foreach ($listpihaktergugat->result() as $row) {
							if(preg_match('/'.$row->pihak_id.'/',$id_tergugat)){
							$pihak = array(
									'perkara_id' => $idperkara,
									'alur_perkara_id' => $idalurperkara,
									'status_pihak_id' => $statuspihakid,
									'status_pihak_text' => $statuspihaktext,
									'permohonan_eksekusi' => $tglpermohonan,
									'pihak_asal' => 2,
									'pihak_asal_text' => 'Tergugat',
									'pihak_id' => $row->pihak_id,
									'pihak_nama' => $row->nama,
									'pihak_diwakili' => $diwakili,
									'pemohon_id' => $idpemohon,
									'pemohon_nama' => $nama_pemohon,
									'pemohon_pekerjaan' => $pekerjaan_pemohon,
									'pemohon_alamat' => $alamat_pemohon,
									'pemohon_tanggal_surat' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_surat_kuasa',TRUE)),
									'pemohon_nomor_surat' => $this->input->post('no_surat_kuasa',TRUE),									
									'pemohon_eksekusi' => $pemohoneksekusi,
									'diinput_oleh' => $this->session->userdata('username'),
									'diinput_tanggal' => date("Y-m-d h:i:s",time())
							);
							}else{
							$pihak = array(
									'perkara_id' => $idperkara,
									'alur_perkara_id' => $idalurperkara,
									'status_pihak_id' => 2,
									'status_pihak_text' => 'Termohon',
									'permohonan_eksekusi' => NULL,
									'pihak_asal' => 2,
									'pihak_asal_text' => 'Tergugat',
									'pihak_id' => $row->pihak_id,
									'pihak_nama' => $row->nama,
									'pihak_diwakili' => 'T',
									'pemohon_id' => NULL,
									'pemohon_nama' => '',
									'pemohon_pekerjaan' => '',
									'pemohon_alamat' => '',
									'pemohon_tanggal_surat' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_surat_kuasa',TRUE)),
									'pemohon_nomor_surat' => $this->input->post('no_surat_kuasa',TRUE),									
									'pemohon_eksekusi' => '',
									'diinput_oleh' => $this->session->userdata('username'),
									'diinput_tanggal' => date("Y-m-d h:i:s",time())
							);

							}
							$datapihak[$i] = $pihak;
							$i++;

					}
				}
			}


				$data = array(
						'perkara_id' => $idperkara,
						'alur_perkara_id' => $idalurperkara,
						'nomor_perkara_pn' => $this->input->post('nomor_perkara_pn',TRUE),
						'putusan_pn' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_putusan_pn',TRUE)),
						'nomor_perkara_banding' => $this->input->post('nomor_perkara_banding',TRUE),
						'putusan_banding' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_putusan_banding',TRUE)),
						'nomor_perkara_kasasi' => $this->input->post('nomor_perkara_kasasi',TRUE),
						'putusan_kasasi' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_putusan_kasasi',TRUE)),
						'nomor_perkara_pk' => $this->input->post('nomor_perkara_pk',TRUE),
						'putusan_pk' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_putusan_pk',TRUE)),
						'eksekusi_putusan' => $this->input->post('listdataput',TRUE),
						'eksekusi_nomor_perkara' => $this->input->post('no_perkara_mhn_eksekusi',TRUE),
						'eksekusi_amar_putusan' => $this->input->post('amar_yg_dieksekusi',TRUE),
						'pihak_pemohon_eksekusi' => $pihak_pemohon_eksekusi,
						'permohonan_eksekusi' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_permohonan_eksekusi',TRUE)),						
						'pemohon_eksekusi' => $pemohon_eksekusi,
						'nomor_urut_perkara_eksekusi' => $no_urut_reg_eksekusi,
						'nomor_register_eksekusi' => $no_perkara_eksekusi,
						'diinput_oleh' => $this->session->userdata('username'),
						'diinput_tanggal' => date("Y-m-d h:i:s",time())
					);			




			$data_biaya = '';
			if($idalurperkara<100){
				$panjar = str_replace('.','',$this->input->post('panjar',TRUE));
				$pendaftaran = str_replace('.','',$this->input->post('pendaftaran',TRUE));
				$atk = str_replace('.','',$this->input->post('atk',TRUE));
					if($panjar<($pendaftaran+$atk)){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Biaya Panjar Tidak Boleh Kurang dari Biaya Pendaftaran ditambah Biaya ATK'));
						return;
					}elseif ($panjar==0) {
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Biaya Panjar Tidak Boleh Kosong'));
						return;
					}
					$data_biaya = array(
						array(
							
							'id_pembiayaan' => 1,
							'perkara_id' => $idperkara,
							'tahapan_id' => 50,
							'kategori_id' => 1,
							'jenis_biaya_id' => 6,
							'urutan' => 1,
							'jenis_transaksi' => 1,
							'tanggal_transaksi' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_permohonan_eksekusi',TRUE)),						
							'uraian' => 'Panjar Biaya Eksekusi',
							'jumlah' => $panjar,
							'diinput_oleh' => $this->session->userdata('username'),
							'diinput_tanggal' => date("Y-m-d h:i:s",time())
						),
						array(
							
							'id_pembiayaan' => 1,
							'perkara_id' => $idperkara,
							'tahapan_id' => 50,
							'kategori_id' => 11,
							'jenis_biaya_id' => 64,
							'urutan' => 2,
							'jenis_transaksi' => -1,
							'tanggal_transaksi' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_permohonan_eksekusi',TRUE)),						
							'uraian' => 'Biaya Pendaftaran Eksekusi',
							'jumlah' => $pendaftaran,
							'diinput_oleh' => $this->session->userdata('username'),
							'diinput_tanggal' => date("Y-m-d h:i:s",time())
						),
						array(
							
							'id_pembiayaan' => 1,
							'perkara_id' => $idperkara,
							'tahapan_id' => 50,
							'kategori_id' => 12,
							'jenis_biaya_id' => 200,
							'urutan' => 3,
							'jenis_transaksi' => -1,
							'tanggal_transaksi' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_permohonan_eksekusi',TRUE)),						
							'uraian' => 'Biaya ATK/Proses',
							'jumlah' => $atk,
							'diinput_oleh' => $this->session->userdata('username'),
							'diinput_tanggal' => date("Y-m-d h:i:s",time())
						)
					);
			}

			$result = $this->eksekusi->add_perkara_eksekusi($data);
			$result = $this->eksekusi->add_perkara_eksekusi_detil($datapihak);
			$result = $this->eksekusi->add_perkara_biaya($data_biaya);

			if($result===FALSE){
				echo json_encode(array('st'=>0,'msg'=>'GAGAL Menyimpan'));
				return;
			}else{
				echo json_encode(array('st'=>1,'msg'=>'Berhasil Menyimpan'));
				return;
			}
		}
	}

	function validateInputEdit(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		if(empty($_POST)){
			show_404();
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('idperkara',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$idalurperkara = $this->encrypt->decode(base64_decode($this->input->post('alurperkaraid',TRUE)));
		if(!is_numeric($idalurperkara) OR intval($idalurperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Something Bad Happened, Please Refresh Your Browser.'));
			return;
		}


		$this->form_validation->set_rules('nomor_perkara_pn', 'Nomor Perkara PN', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tgl_putusan_pn', 'Tanggal Putusan PN', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('nomor_perkara_banding', 'Nomor Perkara Banding', 'trim|xss_clean');
		$this->form_validation->set_rules('tgl_putusan_banding', 'Tanggal Putusan Banding', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('nomor_perkara_kasasi', 'Nomor Perkara Kasasi', 'trim|xss_clean');
		$this->form_validation->set_rules('tgl_putusan_kasasi', 'Tanggal Putusan kasasi', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('nomor_perkara_pk', 'Nomor Perkara PK', 'trim|xss_clean');
		$this->form_validation->set_rules('tgl_putusan_pk', 'Tanggal Putusan PK', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('listdataput', 'Putusan Eksekusi', 'trim|required|xss_clean');		
		$this->form_validation->set_rules('no_perkara_mhn_eksekusi', 'Nomor Perkara di Mohonkan Eksekusi', 'trim|required|xss_clean');				
		
		$this->form_validation->set_rules('tgl_permohonan_eksekusi', 'Tanggal Permohonan Eksekusi', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('nama_pemohon', 'Nama Pemohon Eksekusi', 'trim|required|xss_clean');		
		$this->form_validation->set_rules('tgl_surat_kuasa', 'Tanggal Surat Kuasa', 'trim|xss_clean');		
		$this->form_validation->set_rules('no_surat_kuasa', 'Nomor Surat Kuasa', 'trim|xss_clean');		

		$pihak_penggugat = $this->input->post('penggugat',TRUE);
		$pihak_tergugat = $this->input->post('tergugat',TRUE);

		if(($pihak_penggugat==0 || $pihak_penggugat=='') && ($pihak_tergugat==0 || $pihak_tergugat=='') ){
			echo json_encode(array('st'=>0,'msg'=>'Pihak belum ada yang dipilih.'));
			return;
		}

		$tgl_putusan_pn = $this->tanggalhelper->getTanggalPutusan($idperkara);
		if(empty($tgl_putusan_pn)){
			echo json_encode(array('st'=>0,'msg'=>'Tidak Dapat Mendaftarkan Permohonan Eksekusi. Perkara Belum Dinyatakan Putus.'));
			return;
		}

		$curr_date = date('Y-m-d');
		$todayDate = date('d/m/Y');
		$tgl_permohonan_eksekusi = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_permohonan_eksekusi',TRUE));
			
		if($tgl_permohonan_eksekusi==false){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
			return;
		}

		$selisih = $this->tanggalhelper->getSelisihHari($tgl_permohonan_eksekusi,$curr_date);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Permohonan Eksekusi Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
			return;
		}

		$dayname = $this->tanggalhelper->getDayName($tgl_permohonan_eksekusi);
		if($dayname=='Saturday' OR $dayname=='Sunday'){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Permohonan Eksekusi Dihari Libur, Sabtu dan Minggu.'));
			return;
		}

		$selisih = $this->tanggalhelper->getSelisihHari($tgl_putusan_pn,$tgl_permohonan_eksekusi);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Permohonan Eksekusi Tidak Boleh Kurang Dari Tanggal Putusan PN'));
			return;
		}

		$tgl_putusan_banding = $this->input->post('tgl_putusan_banding',TRUE);
		if(!empty($tgl_putusan_banding)){
			$tgl_putusan_banding = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_putusan_banding',TRUE));
			if($tgl_putusan_banding==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tgl_putusan_banding,$tgl_permohonan_eksekusi);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Permohonan Eksekusi Tidak Boleh Kurang Dari Tanggal Putusan Banding'));
				return;
			}
		}

		$tgl_putusan_kasasi = $this->input->post('tgl_putusan_kasasi',TRUE);
		if(!empty($tgl_putusan_kasasi)){
			$tgl_putusan_kasasi = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_putusan_kasasi',TRUE));
			if($tgl_putusan_kasasi==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tgl_putusan_kasasi,$tgl_permohonan_eksekusi);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Permohonan Eksekusi Tidak Boleh Kurang Dari Tanggal Putusan Kasasi'));
				return;
			}
		}

		$tgl_putusan_pk = $this->input->post('tgl_putusan_pk',TRUE);
		if(!empty($tgl_putusan_pk)){
			$tgl_putusan_pk = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_putusan_pk',TRUE));
			if($tgl_putusan_pk==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tgl_putusan_pk,$tgl_permohonan_eksekusi);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Permohonan Eksekusi Tidak Boleh Kurang Dari Tanggal Putusan Peninjauan Kembali'));
				return;
			}
		}


		$id_tergugat='';$nama_tergugat='';

		if($pihak_tergugat!='' || $pihak_tergugat!=0){
		 	$aa_tergugat=implode(';', $pihak_tergugat);
		 	$ax_tergugat=explode(';', $aa_tergugat);
		 	$ac_tergugat=count($ax_tergugat);
		 	
		 	for ($i=0;$i<$ac_tergugat;$i++){
		 		if ($i!=0){
		 			if($i % 2 ==0){
		 				$id_tergugat .= ','.$ax_tergugat[$i];		
			 		}else{
			 			if ($i!=1){
			 				$nama_tergugat .= ',';
			 			}
			 			$nama_tergugat .= $ax_tergugat[$i];
			 		}	
		 		}else{
		 			$id_tergugat .= $ax_tergugat[$i];	
		 		}

		 	}
	 	}
		$id_penggugat='';$nama_penggugat='';
		if($pihak_penggugat!='' || $pihak_penggugat!=0){
		 	$aa_penggugat=implode(';', $pihak_penggugat);
		 	$ax_penggugat=explode(';', $aa_penggugat);
		 	$ac_penggugat=count($ax_penggugat);
		 	
		 	for ($i=0;$i<$ac_penggugat;$i++){
		 		if ($i!=0){
		 			if($i % 2 ==0){
		 				$id_penggugat .= ','.$ax_penggugat[$i];		
			 		}else{
			 			if ($i!=1){
			 				$nama_penggugat .= ',';
			 			}
			 			$nama_penggugat .= $ax_penggugat[$i];
			 		}	
		 		}else{
		 			$id_penggugat .= $ax_penggugat[$i];	
		 		}

		 	}
	 	}

		if(($pihak_penggugat!=0 or $pihak_penggugat!='')){
			$pihak_pemohon_eksekusi='1';
			$kuasadari='Kuasa dari Penggugat :';
			$yangikuasakan=$nama_penggugat;
		}else{
			$pihak_pemohon_eksekusi='2';
			$kuasadari='Kuasa dari Tergugat :';
			$yangikuasakan=$nama_tergugat;
		}

		$idpemohon=$this->encrypt->decode(base64_decode($this->input->post('enc_pemohon',TRUE)));

		$pemohon = $this->input->post('nama_pemohon',TRUE);
		if(!empty($pemohon)){
			if($idpemohon==$id_penggugat){
				$pemohon_eksekusi=$pemohon.' (Penggugat)';	
			}else if($idpemohon==$id_tergugat){
				$pemohon_eksekusi=$pemohon.' (Tergugat)';	
			}else{
				$pemohon_eksekusi=$pemohon.' ('.$kuasadari.' '.$yangikuasakan.')';	
			}
		}


	
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
		}else{
			$this->load->model('perkara/new_eksekusi','eksekusi');
			
			$datapihak = '';
			$i=0;

			$listpihakpenggugat = $this->eksekusi->data_penggugat($idperkara);		
			if($listpihakpenggugat!=''){
				if($listpihakpenggugat->num_rows>0){

					$pihak_list = $this->input->post('penggugat',TRUE);
					if(empty($pihak_list)){
						$diwakili='T';
						$idpemohon='';
						$nama_pemohon='';
						$pekerjaan_pemohon='';
						$alamat_pemohon='';
						$pemohoneksekusi='';
						$statuspihakid=2;
						$statuspihaktext='Termohon';
						$tglpermohonan=NULL;
					}else{
						$diwakili='Y';
						$idpemohon=$this->encrypt->decode(base64_decode($this->input->post('enc_pemohon',TRUE)));
						$nama_pemohon=$this->input->post('nama_pemohon',TRUE);
						$pekerjaan_pemohon=$this->input->post('pekerjaan_pemohon',TRUE);
						$alamat_pemohon=$this->input->post('alamat_pemohon',TRUE);
						$pemohoneksekusi=$pemohon_eksekusi;
						$statuspihakid=1;
						$statuspihaktext='Pemohon';
						$tglpermohonan=$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_permohonan_eksekusi',TRUE));
					}

					
					foreach ($listpihakpenggugat->result() as $row) {
							if(preg_match('/'.$row->pihak_id.'/',$id_penggugat)){
							$pihak = array(
									'perkara_id' => $idperkara,
									'alur_perkara_id' => $idalurperkara,
									'status_pihak_id' => $statuspihakid,
									'status_pihak_text' => $statuspihaktext,
									'permohonan_eksekusi' => $tglpermohonan,
									'pihak_asal' => 1,
									'pihak_asal_text' => 'Penggugat',
									'pihak_id' => $row->pihak_id,
									'pihak_nama' => $row->nama,
									'pihak_diwakili' => $diwakili,
									'pemohon_id' => $idpemohon,
									'pemohon_nama' => $nama_pemohon,
									'pemohon_pekerjaan' => $pekerjaan_pemohon,
									'pemohon_alamat' => $alamat_pemohon,
									'pemohon_tanggal_surat' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_surat_kuasa',TRUE)),
									'pemohon_nomor_surat' => $this->input->post('no_surat_kuasa',TRUE),
									'pemohon_eksekusi' => $pemohoneksekusi,
									'diperbaharui_oleh' => $this->session->userdata('username'),
									'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
							);
							}else{
							$pihak = array(
									'perkara_id' => $idperkara,
									'alur_perkara_id' => $idalurperkara,
									'status_pihak_id' => 2,
									'status_pihak_text' => 'Termohon',
									'permohonan_eksekusi' => NULL,
									'pihak_asal' => 1,
									'pihak_asal_text' => 'Penggugat',
									'pihak_id' => $row->pihak_id,
									'pihak_nama' => $row->nama,
									'pihak_diwakili' => 'T',
									'pemohon_id' => NULL,
									'pemohon_nama' => '',
									'pemohon_pekerjaan' => '',
									'pemohon_alamat' => '',
									'pemohon_tanggal_surat' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_surat_kuasa',TRUE)),
									'pemohon_nomor_surat' => $this->input->post('no_surat_kuasa',TRUE),									
									'pemohon_eksekusi' => '',
									'diperbaharui_oleh' => $this->session->userdata('username'),
									'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
							);

							}
							$datapihak[$i] = $pihak;
							$i++;

					}
				}
			}

			$listpihaktergugat = $this->eksekusi->data_tergugat($idperkara);		
			if($listpihaktergugat!=''){
				if($listpihaktergugat->num_rows>0){

					$pihak_list = $this->input->post('tergugat',TRUE);
					if(empty($pihak_list)){
						$diwakili='T';
						$idpemohon='';
						$nama_pemohon='';
						$pekerjaan_pemohon='';
						$alamat_pemohon='';
						$pemohoneksekusi='';
						$statuspihakid=2;
						$statuspihaktext='Termohon';
						$tglpermohonan=NULL;
					}else{
						$diwakili='Y';
						$idpemohon=$this->encrypt->decode(base64_decode($this->input->post('enc_pemohon',TRUE)));
						$nama_pemohon=$this->input->post('nama_pemohon',TRUE);
						$pekerjaan_pemohon=$this->input->post('pekerjaan_pemohon',TRUE);
						$alamat_pemohon=$this->input->post('alamat_pemohon',TRUE);
						$pemohoneksekusi=$pemohon_eksekusi;
						$statuspihakid=1;
						$statuspihaktext='Pemohon';
						$tglpermohonan=$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_permohonan_eksekusi',TRUE));
					}

					
					foreach ($listpihaktergugat->result() as $row) {
							if(preg_match('/'.$row->pihak_id.'/',$id_tergugat)){
							$pihak = array(
									'perkara_id' => $idperkara,
									'alur_perkara_id' => $idalurperkara,
									'status_pihak_id' => $statuspihakid,
									'status_pihak_text' => $statuspihaktext,
									'permohonan_eksekusi' => $tglpermohonan,
									'pihak_asal' => 2,
									'pihak_asal_text' => 'Tergugat',
									'pihak_id' => $row->pihak_id,
									'pihak_nama' => $row->nama,
									'pihak_diwakili' => $diwakili,
									'pemohon_id' => $idpemohon,
									'pemohon_nama' => $nama_pemohon,
									'pemohon_pekerjaan' => $pekerjaan_pemohon,
									'pemohon_alamat' => $alamat_pemohon,
									'pemohon_tanggal_surat' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_surat_kuasa',TRUE)),
									'pemohon_nomor_surat' => $this->input->post('no_surat_kuasa',TRUE),									
									'pemohon_eksekusi' => $pemohoneksekusi,
									'diperbaharui_oleh' => $this->session->userdata('username'),
									'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
							);
							}else{
							$pihak = array(
									'perkara_id' => $idperkara,
									'alur_perkara_id' => $idalurperkara,
									'status_pihak_id' => 2,
									'status_pihak_text' => 'Termohon',
									'permohonan_eksekusi' => NULL,
									'pihak_asal' => 2,
									'pihak_asal_text' => 'Tergugat',
									'pihak_id' => $row->pihak_id,
									'pihak_nama' => $row->nama,
									'pihak_diwakili' => 'T',
									'pemohon_id' => NULL,
									'pemohon_nama' => '',
									'pemohon_pekerjaan' => '',
									'pemohon_alamat' => '',
									'pemohon_tanggal_surat' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_surat_kuasa',TRUE)),
									'pemohon_nomor_surat' => $this->input->post('no_surat_kuasa',TRUE),									
									'pemohon_eksekusi' => '',
									'diperbaharui_oleh' => $this->session->userdata('username'),
									'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
							);

							}
							$datapihak[$i] = $pihak;
							$i++;

					}
				}
			}

				$eksekusi_put_id=$this->input->post('listdataput',TRUE);
				if($eksekusi_put_id==10){
					$amardieksekusi=$this->input->post('amarpn',TRUE);
				}else if($eksekusi_put_id==20){
					$amardieksekusi=$this->input->post('amarbanding',TRUE);
				}else if($eksekusi_put_id==30){
					$amardieksekusi=$this->input->post('amarkasasi',TRUE);
				}else if($eksekusi_put_id==40){
					$amardieksekusi=$this->input->post('amarpn',TRUE);
				}

				$data = array(
						'eksekusi_putusan' => $this->input->post('listdataput',TRUE),
						'eksekusi_nomor_perkara' => $this->input->post('no_perkara_mhn_eksekusi',TRUE),
						'eksekusi_amar_putusan' => $amardieksekusi,
						'pihak_pemohon_eksekusi' => $pihak_pemohon_eksekusi,
						'permohonan_eksekusi' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_permohonan_eksekusi',TRUE)),						
						'pemohon_eksekusi' => $pemohon_eksekusi,
						'diperbaharui_oleh' => $this->session->userdata('username'),
						'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);			
			$result = $this->eksekusi->update_perkara_eksekusi($data,$idperkara);
			$result = $this->eksekusi->dele_perkara_eksekusi_detil($idperkara);
			$result = $this->eksekusi->add_perkara_eksekusi_detil($datapihak);
			if($result===FALSE){
				echo json_encode(array('st'=>0,'msg'=>'GAGAL Menyimpan'));
				return;
			}else{
				echo json_encode(array('st'=>1,'msg'=>'Berhasil Menyimpan'));
				return;
			}
		}
	}


	function parsePihak($listpihak,$idpihak){
		foreach ($listpihak as $key) {
			$idpihakpemohon = $this->encrypt->decode(base64_decode($key));
			if($idpihak==$idpihakpemohon){
				return TRUE;
			}
		}
		return FALSE;
	}

}