<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Add_hkk extends CI_Controller {
	function index(){
		#prevent direct access to page
		#the user should only access the page through menu
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}
		
		$sec = $this->nativesession->get_flash_session('security');

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$aksitmp = $this->nativesession->get_flash_session('aksitmp');
		$idbiaya = $this->nativesession->get_flash_session('idbiaya');
		$this->show_data($aksitmp,$idbiaya);

	}

	function show_data($aksitmp,$idbiaya){
		$this->load->model('jurnal/jurnal_hkk','hkk');
		$data['id_jenis_biaya']='';		
		if($idbiaya!=''){
				$result_data_biaya = $this->hkk->get_data_edit_biaya($idbiaya);
				if($result_data_biaya!=''){
					if($result_data_biaya->num_rows()>0){
						foreach ($result_data_biaya->result() as $row) {
							$data['idbiayaperkara'] = base64_encode($this->encrypt->encode($row->id));
							$data['tgl_transaksi'] = $row->tanggal_transaksi;
							$data['id_jenis_biaya'] = $row->jenis_biaya_id;
							$data['jumlah'] = $row->jumlah;
							$data['uraian'] = $row->uraian;
							$data['keterangan'] = $row->keterangan;

						}
					}else{
						$this->error_page->show_error_msg('Error Found','Tidak ada ID Biaya');
						exit();
					}
				}else{
					$this->error_page->show_error_msg('Error Found','Something the right happen. ID pada Perkara Biaya Not Found');
					exit();
				}
		}

		$data['previous'] = $this->nativesession->get_flash_session('url_requested');
		$data['data_jenis_biaya']=$this->hkk->get_jenis_biaya();		
		$data['page_title'] = '';

		$data['aksi'] = base64_encode($this->encrypt->encode($aksitmp));
		$data['idbiaya'] = base64_encode($this->encrypt->encode($idbiaya));
		
		$data['tahapan'] = 99;
		$data['main_body'] = 'jurnal_perkara/add_form_hkk';
		$data['tgl_sekarang'] = date('d/m/Y');
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}



	function validateInput(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$this->form_validation->set_rules('tgl_transaksi', 'Tanggal Transaksi', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('jenis_biaya', 'Jenis Biaya', 'trim|numeric|required|xss_clean');		
		$this->form_validation->set_rules('uraian', 'Uraian', 'trim|required|xss_clean');
		$this->form_validation->set_rules('jumlah', 'Jumlah', 'trim|required|xss_clean');
		$this->form_validation->set_rules('keterangan', 'Keterangan', 'trim|xss_clean');
		$this->form_validation->set_rules('aksi', 'Aksi', 'trim|xss_clean');
		$this->form_validation->set_rules('idbiayaperkara', 'ID Biaya', 'trim|required|xss_clean');		
		
		$id_pembiayaan = 1;
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
		}else{
				$this->load->model('jurnal/jurnal_hkk','hkk');
				$aksi= $this->encrypt->decode(base64_decode($this->input->post('aksi',TRUE)));
				$idbiayaperkara=intval($this->encrypt->decode(base64_decode($this->input->post('idbiayaperkara',TRUE))));

				$id_jenis_biaya=intval($this->input->post('jenis_biaya',TRUE));
				$detil_jenis_biaya=$this->hkk->get_detil_jenis_biaya($id_jenis_biaya);
				foreach ($detil_jenis_biaya->result() as $row) {
					$jenis_transaksi=$row->jenis_transaksi;
					$idkategori=$row->kategori_id;
					$tahapan=$row->tahapan_id;

				}
				$jenistransaksi=$jenis_transaksi;
				$kategoriid=$idkategori;
				$idtahapan=$tahapan;

				$maxid=$this->hkk->get_maxid_perkara_biaya();
				foreach ($maxid->result() as $row) {
					$maxid_perkara_biaya=$row->maxid;
				}
				$id_perkara_biaya=intval($maxid_perkara_biaya);

				$jumlah_biaya = str_replace('.','',$this->input->post('jumlah',TRUE));
				$data = array(
						'id' => $id_perkara_biaya,
						'id_pembiayaan' => $id_pembiayaan,
						'tahapan_id' => $idtahapan,
						'kategori_id' => $kategoriid,
						'jenis_biaya_id' => $id_jenis_biaya,
						'jenis_transaksi' => $jenistransaksi,
						'urutan' => 0,
						'sisa' => 0,
						'tanggal_transaksi' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_transaksi',TRUE)),
						'uraian' => $this->input->post('uraian',TRUE),
						'jumlah' => $jumlah_biaya,
						'keterangan' => $this->input->post('keterangan',TRUE),
						'diinput_oleh' => $this->session->userdata('username'),
						'diinput_tanggal' => date("Y-m-d h:i:s",time())
					);

				$data_edit = array(
						'kategori_id' => $kategoriid,
						'jenis_biaya_id' => $id_jenis_biaya,
						'jenis_transaksi' => $jenistransaksi,
						'urutan' => 0,
						'sisa' => 0,
						'tanggal_transaksi' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_transaksi',TRUE)),
						'uraian' => $this->input->post('uraian',TRUE),
						'jumlah' => $jumlah_biaya,
						'keterangan' => $this->input->post('keterangan',TRUE),
						'diperbaharui_oleh' => $this->session->userdata('username'),
						'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);

				
				if($aksi==''){
					$result = $this->hkk->add_perkara_biaya($data);
				}elseif($aksi=='edit'){
					$result = $this->hkk->edit_perkara_biaya($data_edit,$idbiayaperkara);
				}

				if($result===FALSE){
					echo json_encode(array('st'=>0,'msg'=>'GAGAL Menyimpan'));
					return;
				}else{
					echo json_encode(array('st'=>1,'msg'=>'Berhasil Simpan'));
					return;
			}	
		}		
	}

	function hapus_hkk_biaya(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idbiaya = $this->encrypt->decode(base64_decode($this->input->post('idbiaya')));
		if(!is_numeric($idbiaya) OR !intval($idbiaya)>0){
			echo json_encode(array('st'=>0,'msg'=>'Tidak ditemukan biaya yang dihapus.'));
			return;
		}
		
		$this->load->model('biaya_perkara/biaya_perkara_m','biaya');
		if($this->biaya->hapus_perkara_biaya($idbiaya)){
			echo json_encode(array('st'=>1,'msg'=>'Biaya telah dihapus'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'));
			return;
		}
	}		
}
