<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Add_barang_bukti extends CI_Controller {
	function index(){
		#prevent direct access to page
		#the user should only access the page through menu

		$sec = $this->nativesession->get_flash_session('security');

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$this->show_data();

	}

	function show_data(){
		$this->load->model('perkara/barang_bukti','barang_bukti');
		if($this->session->userdata('jenis_pengadilan')==2){
			$data['page_title'] = 'TAMBAH - BARANG BUKTI PERKARA KEJAHATAN ';
		}elseif($this->session->userdata('jenis_pengadilan')==4){
			$data['page_title'] = 'TAMBAH - BARANG BUKTI PERKARA JINAYAT ';
		}else{
			$data['page_title'] = 'TAMBAH - BARANG BUKTI PERKARA PIDANA ';
		}
		$data['main_body'] = 'perkara/new_barang_bukti';
		$data['previous'] = $this->nativesession->get_flash_session('url_requested');		
		$data['current_date'] = date('d/m/Y');
		$data['previous']=$this->nativesession->get('main_url_requested');
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}

	function show_data_edit(){
		$segment = $this->uri->segment_array();
		$enc_BB=$this->encrypt->decode(base64_decode($this->uri->segment(3)));
   		if(empty($enc_BB) OR intval($enc_BB)<0){
			show_404();
		}

		$this->load->model('perkara/barang_bukti','barang_bukti');
		if($this->session->userdata('jenis_pengadilan')==2){
			$data['page_title'] = 'EDIT - BARANG BUKTI PERKARA KEJAHATAN';
		}elseif($this->session->userdata('jenis_pengadilan')==4){
			$data['page_title'] = 'EDIT - BARANG BUKTI PERKARA JINAYAT ';
		}else{
			$data['page_title'] = 'EDIT - BARANG BUKTI PERKARA PIDANA ';
		}
		$data['enc_BB']=$this->uri->segment(3);
		
		$data['main_body'] = 'perkara/edit_barang_bukti';
		$data['previous'] = $this->nativesession->get_flash_session('url_requested');
		$data['data_bb']=$this->barang_bukti->getDetilBB($enc_BB);
		if($data['data_bb']->num_rows>0){
			$data['enc'] = base64_encode($this->encrypt->encode($row->perkara_id));
		}else{
			$data['enc'] = '';
		}
		$data['current_date'] = date('d/m/Y');
		$data['previous']=$this->nativesession->get('main_url_requested');
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}

	function edit_bb(){
		$segment = $this->uri->segment_array();
		$data['act'] = $this->uri->segment(2);
		$data['enc'] = $this->uri->segment(3);
		$perkaraid =$this->encrypt->decode(base64_decode($this->uri->segment(3)));
   		if(empty($perkaraid) OR intval($perkaraid)<0){
			show_404();
		}

		$this->load->model('perkara/barang_bukti','barang_bukti');
		if($this->session->userdata('jenis_pengadilan')==2){
			$data['page_title'] = 'EDIT - BARANG BUKTI PERKARA KEJAHATAN';
		}elseif($this->session->userdata('jenis_pengadilan')==4){
			$data['page_title'] = 'EDIT - BARANG BUKTI PERKARA JINAYAT ';
		}else{
			$data['page_title'] = 'EDIT - BARANG BUKTI PERKARA PIDANA ';
		}		
				
		$data['previous'] = $this->nativesession->get_flash_session('url_requested');
		$data_perkara = $this->barang_bukti->getInfoPerkara($perkaraid);
		if($data_perkara->num_rows>0){
			foreach ($data_perkara->result() as $row) {
				$data['nomor_perkara'] = $row->nomor_perkara;
				$data['jenis_perkara'] = $row->jenis_perkara_nama;
				$data['tgl_pendaftaran'] = $this->tanggalhelper->convertDayDate($row->tanggal_pendaftaran);
			}
		}else{
			$data['nomor_perkara'] = '';
			$data['jenis_perkara'] = '';
			$data['tgl_pendaftaran'] = '';
		}
		$data_bb = $this->barang_bukti->getInfoDetilBB($perkaraid);		
		if($data_bb->num_rows>0){
			foreach ($data_bb->result() as $row) {
				$data['enc_BB'] = base64_encode($this->encrypt->encode($row->id));
				$data['tgl_terima'] = $this->tanggalhelper->convertToInputDate($row->tanggal_penerimaan);
				$data['jenis_bb'] = $row->jenis_barang_bukti;
				$data['tempat_penyimpanan'] = $row->tempat_penyimpanan;
				$data['tempat_penyerahan'] = $row->tempat_penyerahan;
				$data['nama_penerima'] = $row->nama_penerima;
				$data['tgl_penyerahan'] = $this->tanggalhelper->convertToInputDate($row->tanggal_penyerahan);
				$data['catatan'] = $row->catatan_barang_bukti;
			}
		}else{
			$data['enc_BB'] = '';
			$data['tgl_terima'] = '';
			$data['jenis_bb'] = '';
			$data['tempat_penyimpanan'] = '';
			$data['tempat_penyerahan'] = '';
			$data['nama_penerima'] = '';
			$data['tgl_penyerahan'] = '';
			$data['catatan'] = '';
		}
		$data['current_date'] = date('d/m/Y');
		$data['previous']=$this->nativesession->get('main_url_requested');
		$this->load->vars($data);
		$this->load->view('perkara_tab/barang_bukti_edit');
	}
	
	function validateInput(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		
		$this->form_validation->set_rules('nomor_perkara', 'Nomor Perkara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('jenis_bb', 'Jenis Dan Uraian Lengkap Barang Bukti', 'trim|required|xss_clean');
		$this->form_validation->set_rules('nama_penerima', 'Nama Penerima', 'trim|required|xss_clean');
		

		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara) <1){
			echo json_encode(array('st'=>0,'msg'=>'Data Perkara Tidak Ditemukan.'));
			return;
		}

		$tglTerima= $this->input->post('tgl_terima',TRUE);
		if(!empty($tglTerima)){
			$tgl_terima = $tglTerima;
		}else{
			$tgl_terima = NULL;
		}
		$noPerkara = $this->input->post('nomor_perkara',TRUE);
		$jenisBB= $this->input->post('jenis_bb',TRUE);
		$penerimaanBB= $this->input->post('nama_penerima',TRUE);
		$tempatPenyimpanan= $this->input->post('tempat_penyimpanan',TRUE);
		$tempatPenyerahan= $this->input->post('tempat_penyerahan',TRUE);
		$tglPenyerahan=$this->input->post('tanggal_penyerahan',TRUE);
		if(!empty($tglPenyerahan)){
			$tgl_penyerahan = $tglPenyerahan;
		}else{
			$tgl_penyerahan = NULL;
		}
		$catatan= $this->input->post('catatan',TRUE);
		$data_bb = array(
				'perkara_id'=>intval($idperkara),
				'nomor_perkara' => $noPerkara,
				'tanggal_penerimaan'=>$this->tanggalhelper->convertToMysqlDate($tgl_terima),
				'jenis_barang_bukti' => $jenisBB,
				'tempat_penyimpanan' => $tempatPenyimpanan,
				'tempat_penyerahan' => $tempatPenyerahan,
				'tanggal_penyerahan'=>$this->tanggalhelper->convertToMysqlDate($tgl_penyerahan),
				'nama_penerima' => $penerimaanBB,
				'catatan_barang_bukti' => $catatan);
		
		$curr_date = date('Y-m-d');
		$todayDate = date('m/d/Y');
		$tglTerima = $this->tanggalhelper->convertToMysqlDate($tglTerima);
		$selisih = $this->tanggalhelper->getSelisihHari($tglTerima,$curr_date);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Terima Barang Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
			return;
		}

		$dayname = $this->tanggalhelper->getDayName($tglTerima);
		if($dayname=='Saturday' OR $dayname=='Sunday'){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penerimaan Dihari Libur, Sabtu dan Minggu.'));
			return;
		}

		$tglpendaftaran = $this->tanggalhelper->getTanggalPendaftaran($idperkara);
		$selisih = $this->tanggalhelper->getSelisihHari($tglpendaftaran,$tglTerima);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Terima Barang Tidak Boleh Kurang dari Tanggal Berkas Dilimpahkan.'));
			return;
		}

		if($this->db->insert('perkara_barang_bukti',$data_bb)){
			echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Database Error, Tambah Perkara Barang Bukti Tidak Berhasil'));
		}	
	}

	function fetchData(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Page'));
			return;
		}

		$nomor_perkara=trim($this->input->post('val',TRUE));
		
		if(empty($nomor_perkara)){
			echo json_encode(array('st'=>0,'msg'=>'Nomor Perkara Masih Kosong.'));
			return;
		}

		$this->load->model('perkara/barang_bukti','barang_bukti');
		$dataPerkara = $this->barang_bukti->fetchData($nomor_perkara);
		if($dataPerkara->num_rows>0){
			foreach ($dataPerkara->result() as $row) {
				$perkara_id = $row->perkara_id;
				$jenis_perkara_nama= $row->jenis_perkara_nama;
				$para_pihak= $row->para_pihak;
			}

			// $cek_bb=$this->barang_bukti->cek_bb($perkara_id);
			// $adabb=$cek_bb->row()->adabb;
			// if($adabb==1){
				// echo json_encode(array('st'=>0,'msg'=>'Perkara ini sudah terdaftar dalam register barang bukti'));
				// return;				
			// }

			echo json_encode(array(
			'st'=>1,
			'enc'=>base64_encode($this->encrypt->encode($perkara_id)),
			'perkara_nama'=>$jenis_perkara_nama,
			'msg'=>'Perkara Ditemukan.'
			));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
	}

	function validateEdit(){
		if(empty($_POST)){
			show_404();
		}
		$data['previous']=base_url(uri_string());

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$enc_BB=$this->encrypt->decode(base64_decode($this->input->post('enc_BB',TRUE)));
		if(!is_numeric($enc_BB) OR intval($enc_BB)<1){
			echo json_encode(array('st'=>0,'msg'=>'Data Barang Bukti Tidak Ditemukan.'));
			return;
		}

		$idperkara=$this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Data Barang Buktiii Tidak Ditemukan.'));
			return;
		}
		

		$this->form_validation->set_rules('nomor_perkara', 'Nomor Perkara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('jenis_bb', 'Jenis Barang Bukti', 'trim|required|xss_clean');
		$this->form_validation->set_rules('nama_penerima', 'Nama Penerima', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tgl_terima', 'Tanggal Penerimaan Barang Bukti', 'trim|required|xss_clean|exact_length[10]');

		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}

		
		$tglTerima= $this->input->post('tgl_terima',TRUE);
		$curr_date = date('Y-m-d');
		$todayDate = date('m/d/Y');
		$tglTerima = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_terima',TRUE));	
		if($tglTerima==false){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
			return;
		}

		$selisih = $this->tanggalhelper->getSelisihHari($tglTerima,$curr_date);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penerimaan Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
			return;
		}
		$dayname = $this->tanggalhelper->getDayName($tglTerima);
		if($dayname=='Saturday' OR $dayname=='Sunday'){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penerimaan Dihari Libur, Sabtu dan Minggu.'));
			return;
		}
		$tglpendaftaran = $this->tanggalhelper->getTanggalPendaftaran($idperkara);
		$selisih = $this->tanggalhelper->getSelisihHari($tglpendaftaran,$tglTerima);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Terima Barang Tidak Boleh Kurang dari Tanggal Berkas Dilimpahkan.'));
			return;
		}
		$noPerkara = $this->input->post('nomor_perkara',TRUE);
		$jenisBB= $this->input->post('jenis_bb',TRUE);
		$penerimaanBB= $this->input->post('nama_penerima',TRUE);
		$tempatPenyimpanan= $this->input->post('tempat_penyimpanan',TRUE);
		$tempatPenyerahan= $this->input->post('tempat_penyerahan',TRUE);

		$tglPenyerahan= $this->input->post('tanggal_penyerahan',TRUE);
		$catatan= $this->input->post('catatan',TRUE);
		$this->db->where('id', $enc_BB);
		$data_bb = array(
				'perkara_id'=>$idperkara,
				'nomor_perkara' => $noPerkara,
				'tanggal_penerimaan'=>$tglTerima,
				'jenis_barang_bukti' => $jenisBB,
				'tempat_penyimpanan' => $tempatPenyimpanan,
				'tempat_penyerahan' => $tempatPenyerahan,
				'nama_penerima' => $penerimaanBB,
				'tanggal_penyerahan' => $this->tanggalhelper->convertToMysqlDate($tglPenyerahan),
				'catatan_barang_bukti' => $catatan);
		
		if(!empty($tglPenyerahan)){
			$tglPenyerahan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_penyerahan',TRUE));	
			if($tglPenyerahan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPenyerahan,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penyerahan Barang Bukti Kepada Penuntut Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}
			$dayname = $this->tanggalhelper->getDayName($tglPenyerahan);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penyerahan Barang Bukti Kepada Penuntut Dihari Libur, Sabtu dan Minggu.'));
				return;
			}
			$data_bb['tanggal_penyerahan'] = $tglPenyerahan;
		}
		if($this->db->update('perkara_barang_bukti',$data_bb)){
			echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Database Error, Tambah Perkara Barang Bukti Tidak Berhasil'));
		}	
	}

	function hapus_barang_bukti(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Tidak ditemukan barang bukti yang dihapus.'));
			return;
		}
		
		$this->load->model('perkara/barang_bukti','barang_bukti');
		if($this->barang_bukti->hapus_bb($idperkara)){
			echo json_encode(array('st'=>1,'msg'=>'Barang bukti telah dihapus'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'));
			return;
		}
	}
}