<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class addSidangPertama_c extends CI_Controller {
	
	function __construct() {
	    parent::__construct();
	    $this->load->model('penetapan/add_sidang_pertama_m');
	}

	function index(){
		}

	function hapus_penetapan_sidang_pertama(){
		$segment = $this->uri->segment_array();
		$enc=$this->input->post('enc',TRUE);
		$idperkara = $this->encrypt->decode(base64_decode($enc));
		$encphs=$this->input->post('encphs',TRUE);
		$idperkaraphs = $this->encrypt->decode(base64_decode($encphs));
		$action=$this->input->post('action',TRUE);
		
		$statusperkara = $this->add_sidang_pertama_m->get_data_perkara($idperkara)->row(0)->proses_terakhir_id;
		if($statusperkara>=201){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Menghapus Perkara, Perkara Telah Dinyatakan Putus.'));
			return;
		}
		
		if($action=='edit'){
			$jumjsidang=$this->add_sidang_pertama_m->get_jum_jsidang($idperkara)->row()->jml;
			if ($jumjsidang>1){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Sudah Terdapat Lebih Dari Satu Jadwal Sidang. Hapus Terlebih Dahulu Data Jadwal Sidang Sampai Hanya Tersisa Jadwal Sidang Pertama.'));
				return;
			}
		}
		
		$namahalaman = $this->input->post('namahalaman',TRUE);	
		$tahapansaatini="12";
		
		if($this->add_sidang_pertama_m->hapus_penetapan_sidang($idperkara,$idperkaraphs,$tahapansaatini,$action,$namahalaman)){
			if($action=='edit'){
				$this->load->model('riwayatperkara/riwayat_perkara_m');
				$this->riwayat_perkara_m->updateproses($idperkara,'200','','',$namahalaman,'2');
				$this->riwayat_perkara_m->updateproses($idperkara,'81','','',$namahalaman,'2');
				$this->riwayat_perkara_m->updateproses($idperkara,'80','','',$namahalaman,'2');
			}
			echo json_encode(array('st'=>1,'msg'=>'Penghapusan Data Penetapan Jadwal Sidang Berhasil'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'));
			return;
		}
	}

	function f_add_sidang(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		
		$data['current_date'] = date('d/m/Y');
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$idperkara=$this->encrypt->decode(base64_decode($data['enc']));
		if (!is_numeric($idperkara) OR $idperkara<0){
			show_404();
			exit();
		}
		
		$data['nomor_perkara'] = $this->add_sidang_pertama_m->get_data_perkara($idperkara)->row()->nomor_perkara;
		$data['alur_perkara_id'] = $this->add_sidang_pertama_m->get_data_perkara($idperkara)->row()->alur_perkara_id;
		$data['tanggal_pendaftaran'] = $this->add_sidang_pertama_m->get_data_perkara($idperkara)->row()->tanggal_pendaftaran;
		$result = $this->add_sidang_pertama_m->get_penetapan_sidang_pertama_detail($idperkara);
		if($result!=''){
			if($result->num_rows()>0){
				foreach ($result->result() as $row) {
					$data['tgl_penetapan_majelis_hakim'] = $row->penetapan_majelis_hakim;
					$data['nama_majelis_hakim'] = $row->majelis_hakim_text;
					$data['tgl_penetapan_panitera_pengganti'] = $row->penetapan_panitera_pengganti;
					$data['nama_panitera_pengganti'] = $row->panitera_pengganti_text;
					$data['tgl_penetapan_jurusita'] = $row->penetapan_jurusita;
					$data['nama_jurusita_text'] = $row->jurusita_text;
				}
			}else{
				$this->error_page->show_error_msg('Error Found','Belum Penetapan');
				exit();
			}
		}else{
			$this->error_page->show_error_msg('Error Found','Something not right happen. Perkara ID Not Found. Error Code = 188');
			exit();
		}
		$data['action'] = 'add';
		$data['namahalaman'] = "Tambah Penetapan Sidang Pertama";
		$this->load->model('jadwalsidang/jadwal_sidang_m');
		if ($queryrs=$this->jadwal_sidang_m->get_ruangan_sidang()){
			$data['ruangansidang']=$queryrs;
		}else{
			$data['ruangansidang']='';
		}
		$this->load->view('perkara_tab/penetapan/edit_sidang_pertama_v', $data);
	}

	function f_edit_sidang($enc=null,$idphs=null){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		
		$data['current_date'] = date('d/m/Y');
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$idperkara = $this->encrypt->decode(base64_decode($data['enc']));
		$data['encphs'] = $this->nativesession->get_flash_session('encphs');
		$idperkaraphs = $this->encrypt->decode(base64_decode($data['encphs']));

		if (!is_numeric($idperkara) OR $idperkara<0){
			show_404();
			exit();
		}
		if (!is_numeric($idperkaraphs) OR $idperkaraphs<0){
			show_404();
			exit();
		}
		$data['nomor_perkara'] = $this->add_sidang_pertama_m->get_data_perkara($idperkara)->row()->nomor_perkara;
		$data['alur_perkara_id'] = $this->add_sidang_pertama_m->get_data_perkara($idperkara)->row()->alur_perkara_id;
		$data['tanggal_pendaftaran'] = $this->add_sidang_pertama_m->get_data_perkara($idperkara)->row()->tanggal_pendaftaran;
		
			$result=$this->add_sidang_pertama_m->get_penetapan_sidang_pertama_detail($idperkara);
			if($result!=''){
				if($result->num_rows()>0){
					foreach ($result->result() as $row) {
						$data['tgl_penetapan_majelis_hakim'] = $row->penetapan_majelis_hakim;
						$data['nama_majelis_hakim'] = $row->majelis_hakim_text;
						$data['tgl_penetapan_panitera_pengganti'] = $row->penetapan_panitera_pengganti;
						$data['nama_panitera_pengganti'] = $row->panitera_pengganti_text;
						$data['tgl_penetapan_jurusita'] = $row->penetapan_jurusita;
						$data['nama_jurusita_text'] = $row->jurusita_text;
						$data['jadwalsidang_id'] = $row->jadwalsidang_id;
						$data['penetapan_hari_sidang'] = $row->penetapan_hari_sidang;
						$data['tgl_sidang_pertama'] = $row->tgl_sidang_pertama;
						$data['jam_sidang_pertama'] = $row->jam_sidang_pertama;
						$data['ruangan_id'] = $row->ruangan_id;
					}
				}else{
					$this->error_page->show_error_msg('Error Found','Belum Penetapan');
					exit();
				}
			}else{
				$this->error_page->show_error_msg('Error Found','Something the right happen. Perkara ID Not Found. Error Code = 188');
				exit();
			}
		$data['action'] = 'edit';
		$data['namahalaman'] = "Edit Penetapan Sidang Pertama";
		$this->load->model('jadwalsidang/jadwal_sidang_m');
		if ($queryrs=$this->jadwal_sidang_m->get_ruangan_sidang()){
			$data['ruangansidang']=$queryrs;
		}else{
			$data['ruangansidang']='';
		}
		$this->load->view('perkara_tab/penetapan/edit_sidang_pertama_v', $data);
	}
	
	function f_validate_input_add(){
		if(empty($_POST)){
			show_404();
		}

		$action=$this->input->post('action',TRUE);

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$this->form_validation->set_rules('tgl_penetapan_sidang_pertama', 'Tanggal Penetapan Sidang Pertama', 'trim|required|xss_clean|callback_f_sidang_pertama_id_check|exact_length[10]');
		$this->form_validation->set_rules('tgl_sidang_pertama', 'Tangggal Sidang Pertama', 'trim|required|xss_clean|callback_f_sidang_pertama_id_check|exact_length[10]');
		$this->form_validation->set_rules('jam_sidang_pertama', 'Jam Sidang Pertama', 'trim|required|xss_clean|callback_f_sidang_pertama_id_check|exact_length[5]');
		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil '.validation_errors()));
			return;
		}else{
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			$tgl_penetapan_sidang_pertama = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_penetapan_sidang_pertama',TRUE));

			if($tgl_penetapan_sidang_pertama==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$selisih = $this->tanggalhelper->getSelisihHari($tgl_penetapan_sidang_pertama,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Sidang Pertama Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
				return;
			}

			$date_penetapan_panitera = $this->input->post('tgl_penetapan_panitera_pengganti',TRUE);
			if($date_penetapan_panitera>$tgl_penetapan_sidang_pertama){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Sidang Pertama Tidak Boleh Kurang dari Tanggal Penetapan Penunjukan Panitera Pengganti '));
				return;
			}

			$idalurperkara = $this->tanggalhelper->getIDAlurPerkara($idperkara);
			if($idalurperkara<100){
				$date_penetapan_jurusita = $this->input->post('tgl_penetapan_jurusita',TRUE);
				if(empty($date_penetapan_jurusita)){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Rekam Penunjukan Jurusita Terlebih Dahulu '));
					return;
				}
				if($date_penetapan_jurusita>$tgl_penetapan_sidang_pertama){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Sidang Pertama Tidak Boleh Kurang dari Tanggal Penetapan Penunjukan Jurusita '));
					return;
				}
			}			

			$dayname = $this->tanggalhelper->getDayName($tgl_penetapan_sidang_pertama);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Sidang Pertama Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tgl_sidang_pertama = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_sidang_pertama',TRUE));
			if($tgl_sidang_pertama==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}
			
			if($tgl_sidang_pertama<$tgl_penetapan_sidang_pertama){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Sidang Tidak Boleh Sebelum Tanggal Penetapan Hari Sidang '));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tgl_sidang_pertama);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Sidang Pertama Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$cek_phs	= $this->add_sidang_pertama_m->cek_perkara_penetapan_hari_sidang($idperkara,$tgl_penetapan_sidang_pertama)->num_rows();
			if($cek_phs>0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Sudah Terdapat Penetapan Hari Sidang Setelah Tanggal : '.$this->tanggalhelper->convertDayDate($tgl_penetapan_sidang_pertama)));
				return;
			}
			
			//$cek_ada_jadwalsidang	= $this->add_sidang_pertama_m->cek_perkara_jadwal_sidang($idperkara,$tgl_sidang_pertama)->num_rows();
			//if($cek_ada_jadwalsidang>0){
			//	echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Sudah Terdapat Jadwal Sidang Setelah Tanggal : '.$this->tanggalhelper->convertDayDate($tgl_sidang_pertama)));
			//	return;
			//}

			$jam_sidang = $this->input->post('jam_sidang_pertama');
			if (empty($jam_sidang)){
				$jam_sidang=NULL;
			}
				
			$data_ruangan	= explode("|",$this->input->post('ruangan'));
			if(!is_numeric($data_ruangan[0]) OR !intval($data_ruangan[0])>0){
				echo json_encode(array('st'=>0,'msg'=>'Ruangan Tidak Ditemukan.'));
				return;
			}else{
				$ruang_sidang		= $data_ruangan[0];
				$nama_ruangan_kirim	= $data_ruangan[1];
			}
			
			$alasan			= $this->input->post('keterangan',TRUE);
			$namahalaman	= $this->input->post('namahalaman',TRUE);
			$datahistoryphs = array(
					'perkara_id'		=> $idperkara,
					'tahapan_id'		=> '12',
					'tanggal_penetapan'	=> $tgl_penetapan_sidang_pertama,
					'tanggal_sidang'	=> $tgl_sidang_pertama
				);
			$datajsidang = array(
					'perkara_id'		=> $idperkara,
					'verzet'			=> 'T',
					'keberatan'			=> 'T',
					'tanggal_sidang'	=> $tgl_sidang_pertama,
					'jam_sidang'		=> $jam_sidang,
					'ruangan'			=> $nama_ruangan_kirim,
					'ruangan_id'		=> $ruang_sidang,
					'agenda'			=> 'SIDANG PERTAMA',
					'sidang_keliling'	=> 'T',
					'ditunda'			=> 'T'
				);
			$datapenetapan = array(
					'penetapan_hari_sidang'	=> $tgl_penetapan_sidang_pertama,
					'sidang_pertama'		=> $tgl_sidang_pertama,
					'diperbaharui_oleh'		=> $this->session->userdata('username'),
					'diperbaharui_tanggal'	=> date('Y-m-d H:i:s')
				);

			if ($action=='add' || $action=='addpenetapankembali'){
				$last_id				= $this->add_sidang_pertama_m->get_last_id();
				$last_id_perkara_phs	= $this->add_sidang_pertama_m->get_last_id_perkara_phs();

				$datajsidang['id']				= $last_id;
				$datajsidang['diinput_oleh']	= $this->session->userdata('username');
				$datajsidang['diinput_tanggal']	= date('Y-m-d H:i:s');
				
				$datahistoryphs['id']				= $last_id_perkara_phs;
				$datahistoryphs['jadwalsidang_id']	= $last_id;
				$datahistoryphs['diinput_oleh']		= $this->session->userdata('username');
				$datahistoryphs['diinput_tanggal']	= date('Y-m-d H:i:s');

				if($action=='add'){
					$datajsidang['urutan']				= $this->add_sidang_pertama_m->get_urutan_jadwal_terakhir($idperkara)->row(0)->last_id;
					$datahistoryphs['keterangan']		= "Penetapan Hari Sidang Pertama";
					$result=$this->add_sidang_pertama_m->insert_jadwal_sidang_pertama($idperkara,$datapenetapan,$datajsidang,$datahistoryphs,$namahalaman);
				}else{
					$dataIdsidangLast	= $this->add_sidang_pertama_m->get_jadwal_sidang_terakhir($idperkara)->row(0)->last_id;
					$datajsidang['urutan']				= $this->add_sidang_pertama_m->get_urutan_jadwal_terakhir($idperkara)->row(0)->last_id;
					$datajsidang['agenda']				= "Penetapan Kembali Hari Sidang";
					$datahistoryphs['keterangan']		= "Penetapan Kembali Hari Sidang Dengan Alasan ".$alasan;
					//$this->add_sidang_pertama_m->update_jadwal_sidang_terakhir($dataIdsidangLast,$datajsidang);
					$result=$this->add_sidang_pertama_m->insert_jadwal_sidang_penetapankembali($idperkara,$datahistoryphs,$datajsidang,$namahalaman,$dataIdsidangLast);
				}
			}elseif ($action=='edit' || $action=='editpenetapankembali'){
				$idperkaraphs	= $this->encrypt->decode(base64_decode($this->input->post('encphs',TRUE)));
				$idjsidang		= $this->add_sidang_pertama_m->get_phs($idperkaraphs)->row(0)->jadwalsidang_id;
				if ($action=='edit'){
					$datahistoryphs['keterangan']		= "Penetapan Hari Sidang Pertama";
					$tgljsidangkedua=$this->add_sidang_pertama_m->get_tgl_jsidang_kedua($idperkara);
					if($tgl_sidang_pertama>=$tgljsidangkedua AND $tgljsidangkedua!=0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Sidang Pertama Tidak Boleh Sama Atau Melebihi Tanggal Sidang Berikutnya Yang Telah Tersimpan.'));
						return;
					}
				}else{
					$datahistoryphs['keterangan']		= "Penetapan Kembali Hari Sidang Dengan Alasan ".$alasan;
				}
				$datajsidang['diperbaharui_oleh']=$this->session->userdata('username');
				$datajsidang['diperbaharui_tanggal']=date('Y-m-d H:i:s');
				$result=$this->add_sidang_pertama_m->edit_jadwal_sidang_pertama($idperkara,$idjsidang,$idperkaraphs,$datapenetapan,$datajsidang,$datahistoryphs,$namahalaman);
			}

			if($result==TRUE){
				$this->load->model('riwayatperkara/riwayat_perkara_m');
				$this->riwayat_perkara_m->updateproses($idperkara,'80',$tgl_penetapan_sidang_pertama,'',$namahalaman,'1');
				$this->riwayat_perkara_m->updateproses($idperkara,'81',$tgl_sidang_pertama,'',$namahalaman,'1');
				echo json_encode(array('st'=>1,'msg'=>'Data Penetapan Berhasil Disimpan'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'));
				return;
			}
		}
	}
	function f_penetapan_kembali_sidang_pertama(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		
		$data['current_date'] = date('d/m/Y');
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$idperkara = $this->encrypt->decode(base64_decode($data['enc']));

		if (!is_numeric($idperkara) OR $idperkara<0){
			show_404();
			exit();
		}
		
		$data['nomor_perkara'] = $this->add_sidang_pertama_m->get_data_perkara($idperkara)->row()->nomor_perkara;
		$data['alur_perkara_id'] = $this->add_sidang_pertama_m->get_data_perkara($idperkara)->row()->alur_perkara_id;
		$data['tanggal_pendaftaran'] = $this->add_sidang_pertama_m->get_data_perkara($idperkara)->row()->tanggal_pendaftaran;

		$result=$this->add_sidang_pertama_m->get_penetapan_sidang_pertama_detail($idperkara);
		if($result!=''){
			if($result->num_rows()>0){
				foreach ($result->result() as $row) {
					$data['tgl_penetapan_majelis_hakim'] = $row->penetapan_majelis_hakim;
					$data['nama_majelis_hakim'] = $row->majelis_hakim_text;
					$data['tgl_penetapan_panitera_pengganti'] = $row->penetapan_panitera_pengganti;
					$data['nama_panitera_pengganti'] = $row->panitera_pengganti_text;
					$data['tgl_penetapan_jurusita'] = $row->penetapan_jurusita;
					$data['nama_jurusita_text'] = $row->jurusita_text;
					$data['jadwalsidang_id'] = $row->jadwalsidang_id;
				}
			}else{
				$this->error_page->show_error_msg('Error Found','Belum Penetapan');
				exit();
			}
			$phssebelum=$this->add_sidang_pertama_m->get_phs_sebelumnya($idperkara)->row(0);
			$data['penetapan_hari_sidang_sebelum'] = $phssebelum->tanggal_penetapan;
			$data['tgl_sidang_pertama_sebelum'] = $phssebelum->tanggal_sidang;
			$data['jam_sidang_pertama_sebelum'] = $phssebelum->jam_sidang;
		}else{
			$this->error_page->show_error_msg('Error Found','Something not right happen. Perkara ID Not Found. Error Code = 188');
			exit();
		}
		$data['action'] = 'addpenetapankembali';
		$data['namahalaman'] = "Tambah Penetapan Kembali Sidang Pertama";
		$this->load->model('jadwalsidang/jadwal_sidang_m');
		if ($queryrs=$this->jadwal_sidang_m->get_ruangan_sidang()){
			$data['ruangansidang']=$queryrs;
		}else{
			$data['ruangansidang']='';
		}
		$this->load->view('perkara_tab/penetapan/penetapan_kembali_sidang_v', $data);
	}

	function f_penetapan_kembali_sidang_pertama_edit(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		
		$data['current_date'] = date('d/m/Y');
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$idperkara = $this->encrypt->decode(base64_decode($data['enc']));
		$data['encphs'] = $this->nativesession->get_flash_session('encphs');
		$idperkaraphs = $this->encrypt->decode(base64_decode($data['encphs']));

		if (!is_numeric($idperkara) OR $idperkara<0){
			show_404();
			exit();
		}
		
		$data['nomor_perkara'] = $this->add_sidang_pertama_m->get_data_perkara($idperkara)->row()->nomor_perkara;
		$data['alur_perkara_id'] = $this->add_sidang_pertama_m->get_data_perkara($idperkara)->row()->alur_perkara_id;
		$data['tanggal_pendaftaran'] = $this->add_sidang_pertama_m->get_data_perkara($idperkara)->row()->tanggal_pendaftaran;

		$result=$this->add_sidang_pertama_m->get_penetapan_sidang_pertama_detail($idperkara);
		if($result!=''){
			if($result->num_rows()>0){
				foreach ($result->result() as $row) {
					$data['tgl_penetapan_majelis_hakim'] = $row->penetapan_majelis_hakim;
					$data['nama_majelis_hakim'] = $row->majelis_hakim_text;
					$data['tgl_penetapan_panitera_pengganti'] = $row->penetapan_panitera_pengganti;
					$data['nama_panitera_pengganti'] = $row->panitera_pengganti_text;
					$data['tgl_penetapan_jurusita'] = $row->penetapan_jurusita;
					$data['nama_jurusita_text'] = $row->jurusita_text;
					$data['jadwalsidang_id'] = $row->jadwalsidang_id;
				}
			}else{
				$this->error_page->show_error_msg('Error Found','Belum Penetapan');
				exit();
			}
			$phssebelum=$this->add_sidang_pertama_m->get_phs_sebelumnya($idperkara)->row(0);
			$phssebelumyangdiedit=$this->add_sidang_pertama_m->get_phs_sebelumnya_yangdiedit($idperkara)->row(0);
			$data['penetapan_hari_sidang_sebelum'] = $phssebelumyangdiedit->tanggal_penetapan;
			$data['tgl_sidang_pertama_sebelum'] = $phssebelumyangdiedit->tanggal_sidang;
			$data['jam_sidang_pertama_sebelum'] = $phssebelumyangdiedit->jam_sidang;
			$data['penetapan_hari_sidang'] = $phssebelum->tanggal_penetapan;
			$data['tgl_sidang_pertama'] = $phssebelum->tanggal_sidang;
			$data['jam_sidang_pertama'] = $phssebelum->jam_sidang;
			$data['ruangan_id'] = $phssebelum->ruangan_id;
			$data['keterangan'] = substr_replace($phssebelum->keterangan,'',0,strlen('Penetapan Kembali Hari Sidang Dengan Alasan '));
		}else{
			$this->error_page->show_error_msg('Error Found','Something not right happen. Perkara ID Not Found. Error Code = 188');
			exit();
		}
		$data['action'] = 'editpenetapankembali';
		$data['namahalaman'] = "Edit Penetapan Kembali Sidang Pertama";
		$this->load->model('jadwalsidang/jadwal_sidang_m');
		if ($queryrs=$this->jadwal_sidang_m->get_ruangan_sidang()){
			$data['ruangansidang']=$queryrs;
		}else{
			$data['ruangansidang']='';
		}
		$this->load->view('perkara_tab/penetapan/penetapan_kembali_sidang_v', $data);
	}	
}