<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class addPihakDiversi extends CI_Controller {
	function index(){
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$data['enc'] = $this->nativesession->get_flash_session('enc');
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));

		if(!is_numeric($idperkara)){
			show_404();
		}
		$this->show_data($idperkara,$end);
	}

	function show_data($idperkara,$enc=null){
		$data['current_date'] = date('d/m/Y');
		$data['pihak_ke'] = $this->nativesession->get_flash_session('pihakke');
		$data['popup'] = $this->nativesession->get_flash_session('popup');
		$this->nativesession->set_flash_session('popup', $data['popup']);
		$data['enc_id'] =$this->nativesession->get_flash_session('enc_id',TRUE);
		$action = $this->nativesession->get_flash_session('action');
		$this->load->model('diversi/data_pihak_diversi', 'pihak');
		$alurperkaraid = $this->pihak->getAlurPerkaraId($idperkara);
		$data['idalurperkara'] = $alurperkaraid;
		$data['idperkara'] = $idperkara;
		$data['alurperkaraid'] = base64_encode($this->encrypt->encode($alurperkaraid));
		$data['enc_act'] = base64_encode($this->encrypt->encode($action));
		$data['pihak_ke_text'] = $this->nativesession->getStatusPihak(10,$alurperkaraid,$data['pihak_ke'],$this->session->userdata('jenis_pengadilan'),$this->tanggalhelper->getIDJenisPerkara($idperkara));
		if($action=='add'){
			$urutan= $this->pihak->getUrutanPihak($data['pihak_ke'],$idperkara);
			if($urutan<1){
				$this->error_page->show_error_msg('Error Found','Something the right happen. Error Code = 197');
			}
			$data['urutan'] = $urutan;
			if($data['pihak_ke']==20){
				$data['title'] = 'TAMBAH DATA PIHAK ANAK';
				$data['pihak_list'] = 'pihak_list';
			}else if($data['pihak_ke']==21){
				$data['title'] = 'TAMBAH DATA PIHAK PENUNTUT';
				$data['pihak_list'] = 'jaksa_list_diversi';
			}else if($data['pihak_ke']==22){
				$data['title'] = 'TAMBAH DATA PIHAK PENYIDIK';
				$data['pihak_list'] = 'penyidik_list_diversi';
			}else if($data['pihak_ke']==23){
				$data['title'] = 'TAMBAH DATA PIHAK KORBAN';
				$data['pihak_list'] = 'pihak_list';
			}else if($data['pihak_ke']==26){
				$data['title'] = 'TAMBAH DATA PIHAK PEMBIMBING KEMASYARAKATAN BAPAS';
				$data['pihak_list'] = 'pk_bapas_list_diversi';
			}


			$data['tergabung_ke'] = '';
			$data['id_intervensi'] = '';
			$data['intervensi_nama'] = '';
			$data['tanggal_izin_intervensi'] = '';
		}elseif($action=='edit'){
			$data['urutan'] = $this->nativesession->get_flash_session('urutan');
			$idpihak = $this->nativesession->get_flash_session('pihak_id');
			if($data['pihak_ke']==20){
				$data['title'] = 'EDIT DATA PIHAK ANAK';
				$data['pihak_list'] = 'pihak_list';
			}else if($data['pihak_ke']==21){
				$data['title'] = 'EDIT DATA PIHAK PENUNTUT';
				$data['pihak_list'] = 'jaksa_list_diversi';
			}else if($data['pihak_ke']==22){
				$data['title'] = 'EDIT DATA PIHAK PENYIDIK';
				$data['pihak_list'] = 'penyidik_list_diversi';
			}else if($data['pihak_ke']==23){
				$data['title'] = 'EDIT DATA PIHAK KORBAN';
				$data['pihak_list'] = 'pihak_list';
			}else if($data['pihak_ke']==26){
				$data['title'] = 'EDIT DATA PIHAK PEMBIMBING KEMASYARAKATAN BAPAS';
				$data['pihak_list'] = 'pk_bapas_list_diversi';
			}
			$data = $this->fetchPihak($idpihak,$data);
			$data['tergabung_ke'] = '';
			$data['id_intervensi'] = '';
			$data['intervensi_nama'] = '';
			$data['tanggal_izin_intervensi'] = '';
			
			if($this->session->userdata('jenis_pengadilan')==2){
				if($data['pihak_ke']==13 || $data['pihak_ke']==2){
					$this->load->model('pihak/data_pihak', 'pihak');
					$result = $this->pihak->getInfoMiliter($idpihak,$idperkara,$data['pihak_ke']);
					if($result!=''){
						if($result->num_rows()>0){
							foreach ($result->result() as $row) {
								$data['pangkat'] = $row->pangkat;
								$data['nrp'] = $row->nrp;
								$data['jabatan'] = $row->jabatan;
								$data['kesatuan'] = $row->kesatuan;
							}
						}
					}
				}
			}
			if($data['pihak_ke']==13){
				$data['saksi_pihak_ke']=$this->pihak->getInfoPembawaSaksi($idperkara,$idpihak);
				$data['jenis_saksi']=$this->pihak->getJenisSaksi($idperkara,$idpihak);
			}

		}else{
			$this->error_page->show_error_msg('Error Found','Something the right happen. Error Code = 196');
		}
		$data['enc']=base64_encode($this->encrypt->encode($idperkara));
		$this->load->vars($data);
		$this->load->view('diversi/pihak_diversi');
	}

	function fetchPihak($idPihak,$data){
		if(is_numeric($idPihak)){
			if($idPihak>0){
				$this->load->model('pihak/data_pihak', 'pihak');
				if($data['pihak_ke']!=2)
					$result = $this->pihak->getDetilInfoPihak($idPihak);
				else
					$result = $this->pihak->getDetilInfoPihakTerdakwa($idPihak);
					
				if($result!=''){
					if($result->num_rows()>0){
						foreach ($result->result() as $row) {
							$data['enc_pihak'] = base64_encode($this->encrypt->encode($row->id));
							$data['nama'] = $row->nama;
							$data['alamat'] = $row->alamat;
							$data['pekerjaan'] = $row->pekerjaan;
							$data['tglLahir'] = $this->tanggalhelper->convertToInputDate($row->tanggal_lahir);
							$data['tempatLahir'] = $row->tempat_lahir;
							$data['jenisPihak'] = $row->jenis_pihak;
							$data['jenisIdentitas'] = $row->jenis_indentitas;
							$data['noIdentitas'] = $row->nomor_indentitas;
							$data['golDarah'] = $row->golongan_darah;
							$data['agama'] = $row->agama;
							//$data['saksi_pihak_ke'] = $row->saksi_pihak_ke;
							if($row->jenis_kelamin=='L'){
								$data['sex'] = 'Laki Laki';
							}elseif($row->jenis_kelamin=='P'){
								$data['sex'] = 'Perempuan';
							}
							$data['wargaNegara'] = $row->warga_negara;
							$data['kawin']	= $row->status_kawin;
							$data['pendidikan'] = $row->pendidikan;
							$data['keterangan'] = $row->keterangan;
							if($data['pihak_ke']==2){
								$data['pangkat'] = $row->pangkat;
								$data['nrp'] = $row->nrp;
								$data['kesatuan'] = $row->kesatuan;
								$data['jabatan'] = $row->jabatan;
							}
							
							if(!empty($row->tanggal_lahir)){
								$data['umur'] = $this->tanggalhelper->getSelisihTahun($row->tanggal_lahir,date('Y-m-d'));
							}else{
								$data['umur'] = "";
							}
						}
						return $data;
					}
				}else{
					$this->error_page->show_error_msg('Error Found','Something the right happen. Pihak Not Found. Error Code = 192');
					exit();
				}
			}
		}else{
			$this->error_page->show_error_msg('Error Found','Something the right happen. Error Code = 191');
			exit();
		}
	}

	function validateInput(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}		
		
		$idpihak = $this->encrypt->decode(base64_decode($this->input->post('enc_pihak',TRUE)));
		if(!is_numeric($idpihak) OR $idpihak<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Pihak Tidak ditemukan. Code Error = 195.'));
			return;
		}
		$pihak_ke = trim($this->input->post('pihak_ke',TRUE));		
		if(!is_numeric($pihak_ke) AND $pihak_ke<1 AND $pihak_ke>15){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Value Error. Code Error = 193.'));
			return;
		}

		$this->form_validation->set_rules('no_urut', 'Nomor Urut Pihak', 'trim|required|numeric|xss_clean');
		$this->form_validation->set_rules('pihak', 'Pihak', 'trim|required|xss_clean');
		$this->form_validation->set_rules('fullname', 'Nama Pihak', 'trim|required|xss_clean');
		$this->form_validation->set_rules('alamat', 'Alamat Pihak', 'trim|required|max_length[500]|xss_clean');

		$this->load->model('diversi/data_pihak_diversi', 'pihak');
		//$jenispihak = $this->pihak->getJenisPihak($idpihak);
		
		if($this->session->userdata('jenis_pengadilan')!=3){
			if(($jenispihak==1 OR $jenispihak ==0) AND $pihak_ke!=2 AND $pihak_ke!=4 AND $pihak_ke!=13){
				if($jenispihak==1 OR $jenispihak==2){
					$this->form_validation->set_rules('tempat_lahir', 'Tempat Lahir', 'trim|required|xss_clean');
					$this->form_validation->set_rules('tgl_lahir', 'Tanggal Lahir', 'trim|required|xss_clean|exact_length[10]');
					$this->form_validation->set_rules('umur', 'Umur Pihak', 'trim|required|numeric|xss_clean');
					$this->form_validation->set_rules('warga_negara', 'Warga Negara', 'trim|required|xss_clean');
					$this->form_validation->set_rules('pekerjaan', 'Pekerjaan Pihak', 'trim|required|xss_clean');
					$this->form_validation->set_rules('statusKawin', 'Status Perkawinan', 'trim|required|xss_clean');
					$this->form_validation->set_rules('pendidikan', 'Pendidikan Terakhir', 'trim|required|xss_clean');
				}
			}
		}

		if($this->session->userdata('jenis_pengadilan')==3){
			if(($jenispihak==1 OR $jenispihak ==0) AND $pihak_ke!=2 AND $pihak_ke!=4 AND $pihak_ke!=13){
				if($jenispihak==1 OR $jenispihak==2){					
					$this->form_validation->set_rules('tempat_lahir', 'Tempat Lahir', 'trim|xss_clean');
					$this->form_validation->set_rules('tgl_lahir', 'Tanggal Lahir', 'trim|xss_clean');
					$this->form_validation->set_rules('umur', 'Umur Pihak', 'trim|numeric|xss_clean');
					$this->form_validation->set_rules('statusKawin', 'Status Perkawinan', 'trim|xss_clean');
					$this->form_validation->set_rules('pendidikan', 'Pendidikan Terakhir', 'trim|xss_clean');
				}
			}
		}

		$act = $this->encrypt->decode(base64_decode($this->input->post('act',TRUE)));
		if($this->session->userdata('jenis_pengadilan')==2){
			if($pihak_ke==13 || $pihak_ke==2){
				$this->form_validation->set_rules('pangkat', 'Pangkat', 'trim|max_length[100]|xss_clean');
				$this->form_validation->set_rules('nrp', 'NRP', 'trim|max_length[50]|xss_clean');
				$this->form_validation->set_rules('jabatan', 'Jabatan', 'trim|max_length[100]|xss_clean');
				$this->form_validation->set_rules('kesatuan', 'Kesatuan', 'trim|max_length[100]|xss_clean');
			}
		}

	
		//$alurperkaraid = $this->encrypt->decode(base64_decode($this->input->post('safs1',TRUE)));
		if ($alurperkaraid=='118' && ($pihak_ke!=6 and $pihak_ke!=13)){
			if ($this->input->post('umur',TRUE)<12 OR $this->input->post('umur',TRUE)>21){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil - Umur Anak Tidak Boleh Kurang dari 12 Tahun dan lebih dari 18 Tahun (Pasal 1 point 4 UU SPPA). Pasal 20, Dalam hal tindak pidana dilakukan oleh Anak sebelum genap berumur 18 (delapan belas) tahun dan diajukan ke sidang pengadilan setelah Anak yang bersangkutan melampaui batas umur 18 (delapan belas) tahun, tetapi belum mencapai umur 21 (dua puluh satu) tahun, Anak tetap diajukan ke sidang Anak.'));
				return;
			}
		}
		
		//$this->form_validation->set_rules('no_urut', 'Nomor Urut', 'trim|required|numeric|xss_clean');
		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			if(!is_numeric($idpihak) OR $idpihak<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Pihak Tidak ditemukan. Code Error = 195.'));
				return;
			}else{
				$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
				if(!is_numeric($idperkara) OR $idpihak<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Perkara Tidak ditemukan. Code Error = 194.'));
					return;
				}else{

					$idalurperkara = $this->tanggalhelper->getIDAlurPerkara($idperkara);
					if($pihak_ke==2 AND $idalurperkara>100){
						$jenispihak = $this->pihak->getJenisPihak($idpihak);
						if(!empty($jenispihak)){
							if($jenispihak>2){
								echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Badan Hukum Atau Pemerintah.'));
								return;
							}
						}
					}
					if($pihak_ke==20){
						$data_diversi = array(
							'diversi_register_id' => $idperkara,
							'urutan' => $this->input->post('no_urut',TRUE),
							'pihak_anak' => $idpihak						
						);							
					}else if($pihak_ke==21){
						$data_diversi = array(
							'diversi_register_id' => $idperkara,
							'urutan' => $this->input->post('no_urut',TRUE),
							'pihak_id' => $idpihak						
						);
					}else if($pihak_ke==22){
						$data_diversi = array(
							'diversi_register_id' => $idperkara,
							'urutan' => $this->input->post('no_urut',TRUE),
							'pihak_id' => $idpihak						
						);
					}elseif($pihak_ke==23){
						$data_diversi = array(
							'diversi_register_id' => $idperkara,
							'urutan' => $this->input->post('no_urut',TRUE),
							'pihak_anak' => $idpihak						
						);							
					}elseif($pihak_ke==26){
						$data_diversi = array(
							'diversi_register_id' => $idperkara,
							'urutan' => $this->input->post('no_urut',TRUE),
							'pihak_id' => $idpihak						
						);							
					}

					if ($act=='add') {
						$isexist = $this->pihak->isPihakberpekara($idpihak,$idperkara);
						if($isexist->num_rows()>0){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> '.$nama.' Anak telah terdaftar..'));
							return;
						}
						$data_diversi['diinput_oleh'] = $this->session->userdata('username');
						$data_diversi['diinput_tanggal'] = date("Y-m-d h:i:s",time());	
						$addData = $this->pihak->add_data($data_diversi,$pihak_ke);
						if($addData==true){
								echo json_encode(array('st'=>1,'msg'=>'Pihak Berhasil ditambahkan.'));
								return;							
						}
					}elseif ($act=='edit') {
						$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
						if($id<1){
							echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Terjadi kesalahan pada DATABASE.err'));
							return;
						}
						$data_diversi['diperbaharui_oleh'] = $this->session->userdata('username');
						$data_diversi['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
						$addData = $this->pihak->updt_data_pihak($id,$data_diversi,$pihak_ke);
						if($addData==true){
								echo json_encode(array('st'=>1,'msg'=>'Pihak Berhasil ditambahkan.'));
								return;							
						}else{
							echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Terjadi kesalahan pada DATABASE.'));
							return;						}
					}else{
						echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Something Bad Happen. Error Code = 190.'.$act));
						return;
					}
					
									
					//echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Terjadi kesalahan pada DATABASE.'));
				}
			}
		}
	}

	function validateDelete(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$act = $this->encrypt->decode(base64_decode($this->input->post('act',TRUE)));
		if($act=='edit'){
			$this->load->model('diversi/data_pihak_diversi', 'pihak');
			$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			$pihakke = trim($this->input->post('pihak_ke',TRUE));
			//$idpihak = $this->pihak->getIDPihak($idperkara,$id,$pihakke);
			$delData = $this->pihak->del_data($id,$pihakke);
			if($delData==TRUE){
					echo json_encode(array('st'=>1,'msg'=>'Pihak Berhasil Dihapus.'));
					return;				
				//$this->pihak->del_data_pengacara($idpihak,$pihakke,$idperkara);
/*				$data_perkara = array(
					'diperbaharui_oleh' => $this->session->userdata('username'),
					'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);
				$updtData = $this->pihak->update_data($data_perkara,$idperkara,$pihakke);
				if($updtData==TRUE){
					echo json_encode(array('st'=>1,'msg'=>'Pihak Berhasil Dihapus.'));
					return;
				}*/
			}
			echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Pihak Tidak Berhasil Dihapus. Terjadi kesalahan pada DATABASE.'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Something Bad Happen. Error Code = 189.'));
			return;
		}
	}

	function petitumIntervensi($enc,$enc_pihak){
		if($this->session->userdata('is_logged_in')===FALSE){
			redirect('login');
		}

		$data['enc'] = $enc;
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
		if(!is_numeric($idperkara)){
			show_404();
		}

		$data['enc_pihak'] = $enc_pihak;
		
        $idpihak=$this->encrypt->decode(base64_decode($data['enc_pihak']));
		if(!is_numeric($idpihak)){
			show_404();
		}
		$this->load->model('pihak/data_pihak', 'pihak');
		$result = $this->pihak->getInfoPihakIntervensi($idperkara,$idpihak);
		if($result->num_rows>0){
			foreach ($result->result() as $row) {
				$data['nama'] = $row->nama;
				$data['isi_petitum'] = $row->isi_petitum;
			}
		}
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '850px';
		$this->ckeditor->config['height'] = '250px';

		$this->load->vars($data);
		$this->load->view('perkara_tab/form_petitum_intervensi');
	}

	function validatePetitumIntervensi(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$this->load->model('pihak/data_pihak', 'pihak');
		$idpihak = $this->encrypt->decode(base64_decode($this->input->post('enc_pihak',TRUE)));
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));

		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'DATA PERKARA INVALID.'));
			return;
		}
		
		if(!is_numeric($idpihak) OR intval($idpihak)<1){
			echo json_encode(array('st'=>0,'msg'=>'DATA PIHAK INVALID.'));
			return;
		}

		$amar = trim($this->input->post('isi_petitum_text',TRUE));
		if(strlen($amar)<50){
			echo json_encode(array('st'=>0,'msg'=>'Mohon Memasukan isi petitum secara lengkap.'));
			return;
		}
		$data = array(
			'isi_petitum'=>$amar,
			'diperbaharui_oleh' => $this->session->userdata('username'),
			'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
		);
		$updtData = $this->pihak->update_petitum($idperkara,$idpihak,$data);
		if($updtData==TRUE){
			echo json_encode(array('st'=>1,'msg'=>'Isi Petitum Berhasil Disimpan.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Isi Petitum Tidak Berhasil Disimpan.'));
			return;
		}
	}

	function cek_tanggal($tgl){
		$curr_date = date('Y-m-d');
		$todayDate = date('d/m/Y');

		$tgl = $this->tanggalhelper->convertToMysqlDate($tgl);
		if($tgl==false){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
			return;
		}

		$selisih = $this->tanggalhelper->getSelisihHari($tgl,$curr_date);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Izin Intervensi Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
			return;
		}

		$dayname = $this->tanggalhelper->getDayName($tgl);
		if($dayname=='Saturday' OR $dayname=='Sunday'){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Izin Intervensi Dihari Libur, Sabtu dan Minggu.'));
			return;
		}

	}
}