<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class addPihakAnakBlm12Tahun extends CI_Controller {
	function index(){
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$data['enc'] = $this->nativesession->get_flash_session('enc');
        $register_id=$this->encrypt->decode(base64_decode($data['enc']));

		if(!is_numeric($register_id)){
			show_404();
		}
		$this->show_data($register_id);
	}

	function show_data($register_id){
		$data['current_date'] = date('d/m/Y');
		$data['pihak_ke'] = $this->nativesession->get_flash_session('pihakke');
		$data['popup'] = $this->nativesession->get_flash_session('popup');
		$this->nativesession->set_flash_session('popup', $data['popup']);
		$data['enc_id'] = $this->nativesession->get_flash_session('enc_id',TRUE);
		$action = $this->nativesession->get_flash_session('action');
		$this->load->model('pihak/data_pihak', 'pihak');
		$data['enc_act'] = base64_encode($this->encrypt->encode($action));
		$data['history'] = $this->nativesession->get_flash_session('url_requested');
		if($action=='add'){
			$query_last_urutan=$this->db->query("SELECT max(urutan) as last FROM diversi_anak_blm_12tahun WHERE register_id=".$register_id);
			$data['urutan'] =$query_last_urutan->row()->last+1;;
			$data['title'] = 'TAMBAH DATA ANAK BELUM 12 TAHUN ';
		}elseif($action=='edit'){
			$idpihak = $this->nativesession->get_flash_session('pihak_id');
			$current_urutan=$this->db->query("SELECT urutan FROM diversi_anak_blm_12tahun WHERE register_id=".$register_id." AND pihak_anak=".$idpihak);
			$data['urutan'] =$current_urutan->row()->urutan;
			$data['title'] = 'UBAH DATA ANAK BELUM 12 TAHUN';
			$data = $this->fetchPihak($idpihak,$data);

		}else{
			$this->error_page->show_error_msg('Error Found','Something the right happen. Error Code = 196');
		}
		$data['enc_register']=base64_encode($this->encrypt->encode($register_id));
		$data['enc_pihak']=base64_encode($this->encrypt->encode($idpihak ));
		$this->load->vars($data);
		$this->load->view('diversi/belum_12tahun/pilih_anak');
	}

	function fetchPihak($idPihak,$data){
		if(is_numeric($idPihak)){
			if($idPihak>0){
				$this->load->model('pihak/data_pihak', 'pihak');
				if($data['pihak_ke']!=2)
					$result = $this->pihak->getDetilInfoPihak($idPihak);
				else
					$result = $this->pihak->getDetilInfoPihakTerdakwa($idPihak);
					
				if($result!=''){
					if($result->num_rows()>0){
						foreach ($result->result() as $row) {
							$data['enc_pihak'] = base64_encode($this->encrypt->encode($row->id));
							$data['nama'] = $row->nama;
							$data['alamat'] = $row->alamat;
							$data['pekerjaan'] = $row->pekerjaan;
							$data['tglLahir'] = $this->tanggalhelper->convertToInputDate($row->tanggal_lahir);
							$data['tempatLahir'] = $row->tempat_lahir;
							$data['jenisPihak'] = $row->jenis_pihak;
							$data['jenisIdentitas'] = $row->jenis_indentitas;
							$data['noIdentitas'] = $row->nomor_indentitas;
							$data['golDarah'] = $row->golongan_darah;
							$data['agama'] = $row->agama;
							//$data['saksi_pihak_ke'] = $row->saksi_pihak_ke;
							if($row->jenis_kelamin=='L'){
								$data['sex'] = 'Laki Laki';
							}elseif($row->jenis_kelamin=='P'){
								$data['sex'] = 'Perempuan';
							}
							$data['wargaNegara'] = $row->warga_negara;
							$data['kawin']	= $row->status_kawin;
							$data['pendidikan'] = $row->pendidikan;
							$data['keterangan'] = $row->keterangan;
							if($data['pihak_ke']==2){
								$data['pangkat'] = $row->pangkat;
								$data['nrp'] = $row->nrp;
								$data['kesatuan'] = $row->kesatuan;
								$data['jabatan'] = $row->jabatan;
							}
							
							if(!empty($row->tanggal_lahir)){
								$data['umur'] = $this->tanggalhelper->getSelisihTahun($row->tanggal_lahir,date('Y-m-d'));
							}else{
								$data['umur'] = "";
							}
						}
						return $data;
					}
				}else{
					$this->error_page->show_error_msg('Error Found','Something the right happen. Pihak Not Found. Error Code = 192');
					exit();
				}
			}
		}else{
			$this->error_page->show_error_msg('Error Found','Something the right happen. Error Code = 191');
			exit();
		}
	}

	function validateInput(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}		
		$act = $this->encrypt->decode(base64_decode($this->input->post('act',TRUE)));
		$idpihak = $this->encrypt->decode(base64_decode($this->input->post('enc_pihak',TRUE)));
		if(!is_numeric($idpihak) OR $idpihak<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Pihak Tidak ditemukan. Code Error = 195.'));
			return;
		}
		// $this->form_validation->set_rules('enc_id', 'Pihak', 'trim|required|xss_clean');
		$this->form_validation->set_rules('fullname', 'Nama Pihak', 'trim|required|xss_clean');
		$this->form_validation->set_rules('alamat', 'Alamat Pihak', 'trim|required|max_length[500]|xss_clean');
		$this->form_validation->set_rules('umur', 'Umur', 'trim|required|xss_clean');
		if ($this->input->post('umur',TRUE) >= 12 ) {
			echo json_encode(array('st'=>0,'msg'=>'<strong> Peringatan : </strong><br />Pilih data yang umurnya kecil dari 12 Tahun..'));
			return;
		}

		// $this->load->model('pihak/data_pihak', 'pihak');
		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			if(!is_numeric($idpihak) OR $idpihak<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Pihak Tidak ditemukan. Code Error = 195.'));
				return;
			}else{
				$register_id = $this->encrypt->decode(base64_decode($this->input->post('enc_register',TRUE)));
				$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
				$urutan = $this->input->post('urutan',TRUE);
				if(!is_numeric($register_id) OR $idpihak<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Pihak Tidak ditemukan. Code Error = 194.'));
					return;
				}else{

					$data = array(
						'urutan' =>$urutan,
						'register_id' =>$register_id,
						'pihak_anak' => $idpihak					
					);
					
					if ($act=='add') {
						// $isexist = $this->pihak->isPihakberpekara($idpihak,$idperkara);
						// if($isexist->num_rows>0){
						// 	$nama ='';
						// 	$status = '';
						// 	foreach ($isexist->result() as $row) {
						// 		$nama = $row->nama;
						// 		$status = $row->status_perkara;
						// 	}
						// 	echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> '.$nama.' Telah terdaftar sebagai '.$status.' diperkara ini'));
						// 	return;
						// }
						// $data['diinput_oleh'] = $this->session->userdata('username');
						// $data['diinput_tanggal'] = date("Y-m-d h:i:s",time());										
						if($this->db->insert('diversi_anak_blm_12tahun',$data)){
							echo json_encode(array('st'=>1,'msg'=>'Sukses.<br> Anak berhasil ditambahkan'));
							return;
						}else {
							echo json_encode(array('st'=>0,'msg'=>'Error.<br> tidak tersimpan'));
							return;
						}
					}elseif ($act=='edit') {
						$this->db->where('id',$id);				
						if($this->db->update('diversi_anak_blm_12tahun',$data)){
							echo json_encode(array('st'=>1,'msg'=>'Sukses.<br> Data berhasil disimpan'));
							return;
						}else {
							echo json_encode(array('st'=>0,'msg'=>'Error.<br> tidak tersimpan'));
							return;
						}
					}else{
						echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Something Bad Happen. Error Code = 190.'.$act));
						return;
					}
					
					echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Terjadi kesalahan pada DATABASE.'));
				}
			}
		}
	}

	function validateDelete(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$act = $this->encrypt->decode(base64_decode($this->input->post('act',TRUE)));
		if($act=='edit'){
			$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
			$this->db->where('id',$id);				
			if($this->db->delete('diversi_anak_blm_12tahun',$data)){
				echo json_encode(array('st'=>1,'msg'=>'Sukses.<br> Data berhasil dihapus'));
				return;
			}else {
				echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Pihak Tidak Berhasil Dihapus. Terjadi kesalahan pada DATABASE.'));
				return;
			}
		}else{
			echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Something Bad Happen. Error Code = 189.'));
			return;
		}
	}

	

	function cek_tanggal($tgl){
		$curr_date = date('Y-m-d');
		$todayDate = date('d/m/Y');

		$tgl = $this->tanggalhelper->convertToMysqlDate($tgl);
		if($tgl==false){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
			return;
		}

		$selisih = $this->tanggalhelper->getSelisihHari($tgl,$curr_date);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Izin Intervensi Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
			return;
		}

		$dayname = $this->tanggalhelper->getDayName($tgl);
		if($dayname=='Saturday' OR $dayname=='Sunday'){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Izin Intervensi Dihari Libur, Sabtu dan Minggu.'));
			return;
		}

	}
}