<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class addPengacara extends CI_Controller {
	function index(){
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$idperkara = $this->nativesession->get_flash_session('perkara_id');
		if(!is_numeric($idperkara)){
			show_404();
		}
		$this->show_data($idperkara);
	}


	function show_data($idperkara){
		$alurperkaraid = $this->tanggalhelper->getIDAlurPerkara($idperkara);
		$data['idperkara'] = $idperkara;
		$data['pihak_ke'] = $this->nativesession->get_flash_session('pihakke');
		$data['pihak_ke_text'] = $this->nativesession->getStatusPihak(10,$alurperkaraid,$data['pihak_ke']);
		$data['enc_id'] =$this->nativesession->get_flash_session('enc_id',TRUE);
		$action = $this->nativesession->get_flash_session('action');
		$this->load->model('pengacara/data_pengacara', 'pengacara');
		$data['para_pihak'] = $this->pengacara->getInfoParaPihak($idperkara,$data['pihak_ke']);
		$data['enc_act'] = base64_encode($this->encrypt->encode($action));

		$idperkarapengacara = $this->encrypt->decode(base64_decode($this->nativesession->get_flash_session('enc_pihak',TRUE)));
		
		$data['enc_pengacaraid'] = base64_encode($this->encrypt->encode($idperkarapengacara));
		$idData = $this->encrypt->decode(base64_decode(($data['enc_id'])));
		$data['act'] = $action;
		if($action=='add'){
			$urutan= $this->pengacara->getUrutanPengacara($data['pihak_ke'],$idperkara);
			if($urutan<1){
				$this->error_page->show_error_msg('Error Found','Something Not Right Happen. Error Code = 197');
			}
			$data['urutan'] = $urutan;
			$data['title'] = 'TAMBAH DATA '.strtoupper($this->nativesession->getStatusPihak(10,$alurperkaraid,($data['pihak_ke']+6),$this->session->userdata('jenis_pengadilan'),$this->tanggalhelper->getIDJenisPerkara($idperkara)));

		}elseif($action=='edit'){
			$data['urutan'] = $this->nativesession->get_flash_session('urutan');
			$idpihak = $this->nativesession->get_flash_session('pihak_id');
			$data['title'] = 'UBAH DATA '.strtoupper($this->nativesession->getStatusPihak(10,$alurperkaraid,($data['pihak_ke']+6),$this->session->userdata('jenis_pengadilan'),$this->tanggalhelper->getIDJenisPerkara($idperkara)));;
			$data['para_pihak'] = $this->pengacara->getPihakDiwakilkan($idData);
			$data = $this->fetchPihak($idperkarapengacara,$data);
		}else{
			$this->error_page->show_error_msg('Error Found','Something the right happen. Error Code = 196');
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$this->load->vars($data);
		$this->load->view('pengacara/pengacara');
	}

	function fetchPihak($idData,$data){
		if(is_numeric($idData)){
			if($idData>0){
				$this->load->model('pengacara/data_pengacara', 'pengacara');
				$result = $this->pengacara->getDetilInfoPengacara($idData,$data['idperkara']);
				if($result!=''){
					if($result->num_rows()>0){
						foreach ($result->result() as $row) {
							#$data['enc_iddata'] = base64_encode($this->encrypt->encode($row->id));
							#$data['enc_pengacaraid'] = base64_encode($this->encrypt->encode($idPengacara));
							$data['nama'] = $row->nama;
							$data['wongedan'] = $row->id;
							$data['alamat'] = $row->alamat;
							$data['pekerjaan'] = $row->pekerjaan;
							$data['tglLahir'] = $this->tanggalhelper->convertToInputDate($row->tanggal_lahir);
							$data['tempatLahir'] = $row->tempat_lahir;
							$data['jenisPihak'] = $row->jenis_pihak;
							$data['jenisIdentitas'] = $row->jenis_indentitas;
							$data['noIdentitas'] = $row->nomor_indentitas;
							$data['golDarah'] = $row->golongan_darah;
							$data['agama'] = $row->agama;
							if($row->jenis_kelamin=='L'){
								$data['sex'] = 'Laki Laki';
							}elseif($row->jenis_kelamin=='P'){
								$data['sex'] = 'Perempuan';
							}
							$data['wargaNegara'] = $row->warga_negara;
							$data['kawin']	= $row->status_kawin;
							$data['pendidikan'] = $row->pendidikan;
							$data['keterangan'] = $row->keterangan;
							if(!empty($row->tanggal_lahir)){
								$data['umur'] = $this->tanggalhelper->getSelisihTahun($row->tanggal_lahir,date('Y-m-d'));
							}else{
								$data['umur'] = "";
							}
							$data['aktif'] = $row->aktif;
							$data['aktif_mulai'] = $row->aktif_mulai;
							$data['aktif_sampai'] = $row->aktif_sampai;
							$data['nomor_kuasa'] = $row->nomor_kuasa;
							$data['tanggal_kuasa'] = $row->tanggal_kuasa;
						}
						return $data;
					}
				}else{
					$this->error_page->show_error_msg('Error Found','Something the right happen. Pihak Not Found. Error Code = 192');
					exit();
				}
			}
		}else{
			$this->error_page->show_error_msg('Error Found','Something the right happen. Error Code = 191');
			exit();
		}
	}

	function validateInput(){
		if(empty($_POST)){
			show_404();
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		
		$this->form_validation->set_rules('no_urut', 'Nomor Urut Pihak', 'trim|required|numeric|xss_clean');
		$this->form_validation->set_rules('fullname', 'Nama Pihak', 'trim|required|xss_clean');
		$this->form_validation->set_rules('warga_negara', 'Warga Negara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('alamat', 'Alamat Pihak', 'trim|required|xss_clean');
		$this->form_validation->set_rules('nmr_kuasa', 'Nomor Surat Kuasa', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tgl_kuasa', 'Tanggal Kuasa', 'trim|required|xss_clean|exact_length[10]');

		if ($this->session->userdata('jenis_pengadilan')!=3){
			$this->form_validation->set_rules('tempat_lahir', 'Tempat Lahir', 'trim|required|xss_clean');
			$this->form_validation->set_rules('tgl_lahir', 'Tanggal Lahir', 'trim|required|xss_clean|exact_length[10]');
			$this->form_validation->set_rules('umur', 'Umur Pihak', 'trim|required|numeric|xss_clean');
			#$this->form_validation->set_rules('pekerjaan', 'Pekerjaan Pihak', 'trim|required|xss_clean');
			$this->form_validation->set_rules('statusKawin', 'Status Perkawinan', 'trim|required|xss_clean');
			$this->form_validation->set_rules('pendidikan', 'Pendidikan Terakhir', 'trim|required|xss_clean');
			$this->form_validation->set_rules('begin_aktif', 'Tanggal Mulai Berlaku KTA', 'trim|required|xss_clean|exact_length[10]');
		}

		if ($this->session->userdata('jenis_pengadilan')==3){
			$this->form_validation->set_rules('tempat_lahir', 'Tempat Lahir', 'trim|xss_clean');
			$this->form_validation->set_rules('tgl_lahir', 'Tanggal Lahir', 'trim|xss_clean|exact_length[10]');
			$this->form_validation->set_rules('umur', 'Umur Pihak', 'trim|numeric|xss_clean');
			$this->form_validation->set_rules('statusKawin', 'Status Perkawinan', 'trim|xss_clean');
			$this->form_validation->set_rules('pendidikan', 'Pendidikan Terakhir', 'trim|xss_clean');
			$this->form_validation->set_rules('begin_aktif', 'Tanggal Mulai Berlaku KTA', 'trim|xss_clean|exact_length[10]');
			$this->form_validation->set_rules('end_aktif', 'Tanggal Akhir Berlaku KTA', 'trim|xss_clean|exact_length[10]');
		}
		

		if ($this->session->userdata('jenis_pengadilan')!=2){
			$this->form_validation->set_rules('end_aktif', 'Tanggal Akhir Berlaku KTA', 'trim|required|xss_clean|exact_length[10]');
		}

		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}
		$pihak_list = $this->input->post('para_pihak',TRUE);
		if(empty($pihak_list)){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Pilih Pihak Yang diWakili'));
			return;
		}
		$idpengacara = $this->encrypt->decode(base64_decode($this->input->post('enc_pengacara',TRUE)));
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) AND $idperkara<1){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Perkara NOT FOUND'));
			return;
		}
		$pihak_ke = trim($this->input->post('pihak_ke',TRUE));
		if(!is_numeric($pihak_ke) AND $pihak_ke<1 AND $pihak_ke>4){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Value Error. Code Error = 193.'));
			return;
		}
		$this->form_validation->set_rules('no_urut', 'Nomor Urut', 'trim|required|numeric|xss_clean');
		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			if(!is_numeric($idpengacara) OR $idpengacara<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Pihak Tidak ditemukan. Code Error = 195.'));
				return;
			}else{
				if(!is_numeric($idperkara) OR $idperkara<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Perkara Tidak ditemukan. Code Error = 194.'));
					return;
				}else{
						$aktifMulai = $this->input->post('begin_aktif',TRUE);
						$aktifMulai = $this->tanggalhelper->convertToMysqlDate($aktifMulai);
					
					if($aktifMulai==false){
						if ($this->session->userdata('jenis_pengadilan')!=3 ){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
							return;
						}
					}

					if ($this->session->userdata('jenis_pengadilan')!=2){
						$aktifSelesai = $this->input->post('end_aktif',TRUE);
					}else{
						$aktifSelesai = $this->input->post('begin_aktif',TRUE);
					}

					$aktifSelesai = $this->tanggalhelper->convertToMysqlDate($aktifSelesai);
					

					if($aktifSelesai==false){
						if ($this->session->userdata('jenis_pengadilan')!=3 ){
							echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/02/2015.'));
							return;
						}
					}

					$this->load->model('pengacara/data_pengacara', 'pengacara');
					$isPihakAlreadyRegistered = $this->pengacara->isPihakAlreadyThere($idperkara,$idpengacara);
					if($isPihakAlreadyRegistered){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Pihak Yang Dipilih Telah Menjadi Pihak Berperkara di Perkara ini.'));
						return;
					}
					$data = array(
						'perkara_id' => $idperkara,
						'pihak_ke' => $pihak_ke,
						'urutan' => $this->input->post('no_urut',TRUE),
						'pengacara_id' => $idpengacara,
						'aktif' => $this->input->post('aktif',TRUE),
						'aktif_mulai' => $aktifMulai,
						'aktif_sampai' => $aktifSelesai,
						'nomor_kuasa' => $this->input->post('nmr_kuasa',TRUE),
						'tanggal_kuasa' =>$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_kuasa',TRUE)),
						'keterangan' => trim($this->input->post('keterangan',TRUE)),
						'diinput_oleh' => $this->session->userdata('username'),
						'diinput_tanggal' => date("Y-m-d h:i:s",time())
					);
					$idalurperkara = $this->tanggalhelper->getIDAlurPerkara($idperkara);
					$statuspengacara = $this->nativesession->getStatusPihak(10,$idalurperkara,$pihak_ke+6);
					$act = $this->encrypt->decode(base64_decode($this->input->post('act',TRUE)));
					if ($act=='add') {
						foreach ($pihak_list as $pihak) {
							$data['pihak_id'] = $this->encrypt->decode(base64_decode($pihak));

							# validate pengacara terhadap pihak
							$isthere = $this->pengacara->isPengacaraAlreadyThere($idperkara,$idpengacara,$data['pihak_id']);
							if($isthere){
								echo json_encode(array('st'=>0,'msg'=>$statuspengacara.' Sudah Terdaftar Mewakili Pihak Yang dipilih'));
								return;
							}
							if($pihak_ke==1){
								$isthere = $this->pengacara->isPengacaraAlreadyAssign($idperkara,$idpengacara,2);
								if($isthere){
									echo json_encode(array('st'=>0,'msg'=>$statuspengacara.' Sudah Terdaftar Mewakili Pihak Lain Diperkara Yang Sama'));
									return;
								}
							
								$isthere = $this->pengacara->isPengacaraAlreadyAssign($idperkara,$idpengacara,3);
								if($isthere){
									echo json_encode(array('st'=>0,'msg'=>$statuspengacara.' Sudah Terdaftar Mewakili Pihak Lain Diperkara Yang Sama'));
									return;
								}
							
								$isthere = $this->pengacara->isPengacaraAlreadyAssign($idperkara,$idpengacara,4);
								if($isthere){
									echo json_encode(array('st'=>0,'msg'=>$statuspengacara.' Sudah Terdaftar Mewakili Pihak Lain Diperkara Yang Sama'));
									return;
								}
							}

							if($pihak_ke==2){
								$isthere = $this->pengacara->isPengacaraAlreadyAssign($idperkara,$idpengacara,1);
								if($isthere){
									echo json_encode(array('st'=>0,'msg'=>$statuspengacara.' Sudah Terdaftar Mewakili Pihak Lain Diperkara Yang Sama'));
									return;
								}															
							}
							if($pihak_ke==3){
								if ($idalurperkara!=9){									
									$isthere = $this->pengacara->isPengacaraAlreadyAssign($idperkara,$idpengacara,1);
									if($isthere){
										echo json_encode(array('st'=>0,'msg'=>$statuspengacara.' Sudah Terdaftar Mewakili Pihak Lain Diperkara Yang Sama'));
										return;
									}
									
								}
							}
							
							if($pihak_ke==4){								
								$isthere = $this->pengacara->isPengacaraAlreadyAssign($idperkara,$idpengacara,1);
								if($isthere){
									echo json_encode(array('st'=>0,'msg'=>$statuspengacara.' Sudah Terdaftar Mewakili Pihak Lain Diperkara Yang Sama'));
									return;
								}
							}
							$addData = $this->pengacara->add_data($data);
						}
					}elseif ($act=='edit') {
						$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
						if($id<1){
							echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Terjadi kesalahan pada DATABASE.'));
							return;
						}
						if($pihak_ke==1){
								$isthere = $this->pengacara->isPengacaraAlreadyAssign($idperkara,$idpengacara,2);
								if($isthere){
									echo json_encode(array('st'=>0,'msg'=>$statuspengacara.' Sudah Terdaftar Mewakili Pihak Lain Diperkara Yang Sama'));
									return;
								}

								$isthere = $this->pengacara->isPengacaraAlreadyAssign($idperkara,$idpengacara,3);
								if($isthere){
									echo json_encode(array('st'=>0,'msg'=>$statuspengacara.' Sudah Terdaftar Mewakili Pihak Lain Diperkara Yang Sama'));
									return;
								}

								$isthere = $this->pengacara->isPengacaraAlreadyAssign($idperkara,$idpengacara,4);
								if($isthere){
									echo json_encode(array('st'=>0,'msg'=>$statuspengacara.' Sudah Terdaftar Mewakili Pihak Lain Diperkara Yang Sama'));
									return;
								}
							}
							if($pihak_ke==2){
								$isthere = $this->pengacara->isPengacaraAlreadyAssign($idperkara,$idpengacara,1);
								if($isthere){
									echo json_encode(array('st'=>0,'msg'=>$statuspengacara.' Sudah Terdaftar Mewakili Pihak Lain Diperkara Yang Sama'));
									return;
								}							
							}
							if($pihak_ke==3){								
								$isthere = $this->pengacara->isPengacaraAlreadyAssign($idperkara,$idpengacara,1);
								if($isthere){
									echo json_encode(array('st'=>0,'msg'=>$statuspengacara.' Sudah Terdaftar Mewakili Pihak Lain Diperkara Yang Sama'));
									return;
								}								
							}
							if($pihak_ke==4){								
								$isthere = $this->pengacara->isPengacaraAlreadyAssign($idperkara,$idpengacara,1);
								if($isthere){
									echo json_encode(array('st'=>0,'msg'=>$statuspengacara.' Sudah Terdaftar Mewakili Pihak Lain Diperkara Yang Sama'));
									return;
								}
							}
						foreach ($pihak_list as $pihak) {
							$data['pihak_id'] = $this->encrypt->decode(base64_decode($pihak));
							$addData = $this->pengacara->updt_data_pengacara($id,$data);
						}
						
						if($addData==FALSE){
							echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Terjadi kesalahan pada DATABASE.'));
							return;
						}
					}else{
						echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Something Bad Happen. Error Code = 190.'.$act));
						return;
					}
					
					if($addData==TRUE){
						$data_pihak = array(
						'diperbaharui_oleh' => $this->session->userdata('username'),
						'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
						);
						$updtData = $this->pengacara->update_data($data_pihak,$idperkara,$pihak_ke);
						if($updtData==TRUE){
							echo json_encode(array('st'=>1,'msg'=>$statuspengacara.' Berhasil ditambahkan.'));
							return;
						}
					}
					echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Terjadi kesalahan pada DATABASE.'));
				}
			}
		}
	}

	function validateDelete(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$act = $this->encrypt->decode(base64_decode($this->input->post('act',TRUE)));
		if($act=='edit'){
			$this->load->model('pengacara/data_pengacara', 'pengacara');
			$idpengacara = $this->encrypt->decode(base64_decode($this->input->post('enc_idpengacara',TRUE)));
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			$pihakke = trim($this->input->post('pihak_ke',TRUE));
			$delData = $this->pengacara->del_data($idpengacara,$pihakke,$idperkara);
			if($delData==TRUE){
				$data_perkara = array(
					'diperbaharui_oleh' => $this->session->userdata('username'),
					'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);
				$updtData = $this->pengacara->update_data($data_perkara,$idperkara,$pihakke);
				if($updtData==TRUE){
					echo json_encode(array('st'=>1,'msg'=>$statuspengacara.' Berhasil Dihapus.'));
					return;
				}
			}
			echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> '.$statuspengacara.' Tidak Berhasil Dihapus. Terjadi kesalahan pada DATABASE.'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Something Bad Happen. Error Code = 189.'));
			return;
		}
	}


}