<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class addOrtuDiversi extends CI_Controller {
	function index(){

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$idperkara = $this->nativesession->get_flash_session('perkara_id');

		if(!is_numeric($idperkara)){
			show_404();
		}
		$jenisdata = $this->nativesession->get_flash_session('pihakke');
		if($jenisdata==24){
			$this->show_data($idperkara,$jenisdata);
		}elseif($jenisdata==25){
			$this->show_data_korban($idperkara,$jenisdata);
		}
		
	}


	function show_data($idperkara,$jenisdata){
		$data['jenis_pihak'] = 0;
		$data['jenis_data'] = $jenisdata;
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$this->load->model('diversi/orangtua_wali_diversi','ortuwali');
		$data['list_anak'] = $this->ortuwali->getInfoPerkaraAnak($idperkara);
		$this->load->view('diversi/orangtuawali_diversi',$data,FALSE);
	}

	function show_data_korban($idperkara,$jenisdata){
		$data['jenis_pihak'] = 1;
		$data['jenis_data'] = $jenisdata;
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$this->load->model('diversi/orangtua_wali_diversi','ortuwali');
		$data['list_anak'] = $this->ortuwali->getInfoKorbanAnak($idperkara);
		$this->load->view('diversi/orangtuawali_diversi',$data,FALSE);
	}

	function show_data_wali_saksi(){
		$segment = $this->uri->segment_array();
		$data['enc'] = $this->uri->segment(3);
		$data['enc_pihak'] = $this->uri->segment(4);
		$data['act'] = $this->uri->segment(5);
		$data['jenis_pihak'] = 2;
		$this->load->model('pihak/orangtua_wali','ortuwali');
		$this->load->model('pihak/list_pihak', 'pihak');
		$idperkara = $this->encrypt->decode(base64_decode($data['enc']));	
		$idanak = $this->encrypt->decode(base64_decode($data['enc_pihak']));
		$data_anak_saksi = $this->ortuwali->getDataPihakOrtu($idperkara,$idanak);			
		if(!empty($data_anak_saksi)){
			if($data_anak_saksi->num_rows()>0){
				foreach ($data_anak_saksi->result() as $row) {
					$id_ortu = $row->id_orang_tua;
					$data['enc_ortu'] = base64_encode($this->encrypt->encode($row->id_orang_tua));
				}
				$data_ortu = $this->ortuwali->getInfoPihak($id_ortu);
				foreach ($data_ortu->result() as $ortu) {
					$data['nama'] = $ortu->nama;
					$data['tempat_lahir'] = $ortu->tempat_lahir;
					$data['tgl_lahir'] = $this->tanggalhelper->convertToInputDate($ortu->tanggal_lahir);
					$data['jenis_identitas'] = $ortu->jenis_identitas;
					$data['nomor_identitas'] = $ortu->nomor_identitas;
					$data['telepon'] = $ortu->telepon;
					$data['email'] = $ortu->email;
					$data['alamat'] = $ortu->alamat;
					$data['jenis_kelamin'] = $ortu->jenis_kelamin;
					$data['agama'] = $ortu->agama_id;
					$data['warga_negara'] = $ortu->warga_negara;
					$data['pekerjaan'] = $ortu->pekerjaan;					
				}
			}
		}else{
			$data['nama'] = '';
			$data['tempat_lahir'] = '';
			$data['tgl_lahir'] = '';
			$data['jenis_identitas'] = '';
			$data['nomor_identitas'] = '';
			$data['telepon'] = '';
			$data['email'] = '';
			$data['alamat'] = '';
			$data['jenis_kelamin'] = '';
			$data['agama'] = '';
			$data['warga_negara'] = '';
			$data['pekerjaan'] = '';
		}		
		
		$data['current_date'] = date('d/m/Y');		
		$data['list_jenis_pihak'] = $this->pihak->getListJenisPihak();
		$data['country'] = $this->pihak->getListCountry();
		$data['agama'] = $this->pihak->getListAgama();
		$data['identitas'] = $this->pihak->getListIdentitas();
		$this->load->vars($data);
		$this->load->view('pihak/form_ortu_add');
	}

	function validateDelete($jenis_anak){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		$idanak = $this->encrypt->decode(base64_decode($this->input->post('enc_anak',TRUE)));

		if(!is_numeric($idperkara) OR empty($idperkara)){
			echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Data Perkara Tidak Ditemukan. Silahkan Refresh'));
			return;
		}
		if(!is_numeric($idanak) OR empty($idanak)){
			echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Data Terdakwa Tidak Ditemukan. Silahkan Refresh'));
			return;
		}
		$this->load->model('diversi/orangtua_wali_diversi','ortuwali');
		if($jenis_anak==24){
			$delData = $this->ortuwali->del_data($idperkara,$idanak);	
		}else if($jenis_anak==25){
			$delData = $this->ortuwali->del_data_korban($idperkara,$idanak);	
		}
		
		if($delData==TRUE){
			echo json_encode(array('st'=>1,'msg'=>'Data Orang Tua/Wali Berhasil Dihapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'ERROR.<br> Something Bad Happen.'));
			return;
		}
	}

	function validateInput(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$nama = trim($this->input->post('pihak_fullname',TRUE));
		$_POST['pihak_fullname'] = str_replace(' ', '', $_POST['pihak_fullname']);
		
		$tempatLahir = trim($this->input->post('pihak_tempat_lahir',TRUE));
		$_POST['pihak_tempat_lahir'] = str_replace(' ', '', $_POST['pihak_tempat_lahir']);

		$tglLahir = $this->input->post('pihak_tgl_lahir',TRUE);
		if(!empty($tglLahir))
			$tglLahir = $this->tanggalhelper->convertToMysqlDate($this->input->post('pihak_tgl_lahir',TRUE));
		else
			$tglLahir = NULL;		
						
		$this->form_validation->set_rules('pihak_fullname', 'Nama Lengkap', 'trim|required|xss_clean|valid_naming');
		$this->form_validation->set_rules('pihak_alamat', 'Alamat', 'trim|required|min_length[15]|max_length[500]|xss_clean');
		$this->form_validation->set_rules('pihak_jenis_kelamin', 'Jenis Kelamin', 'trim|required|xss_clean');
		$this->form_validation->set_rules('pihak_warga_negara', 'Warga Negara', 'trim|required|numeric|xss_clean');
		$this->form_validation->set_rules('pihak_pekerjaan', 'Pekerjaan', 'trim|required|min_length[5]|xss_clean');
		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$act = $this->input->post('act',TRUE);
			$jenisPihak = $this->input->post('jenis_pihak',TRUE);
			if($jenisPihak!=2){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Jenis Pihak Tidak Diketahui.'));
				return;
			}
			$sex = $this->input->post('pihak_jenis_kelamin',TRUE);
			if($sex<1 AND $sex>3){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Jenis Kelamin Tidak Diketahui.'));
				return;
			}
			if($sex==1){
				$sex='L';
			}elseif ($sex==2) {
				$sex='P';
			}
			$agama = $this->input->post('pihak_agama',TRUE);
			if($agama<1 AND $agama>7){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Agama Tidak Diketahui.'));
				return;
			}
			$pekerjaan = $this->input->post('pihak_pekerjaan',TRUE);
			$umur=$this->input->post('pihak_umur',TRUE);
			if(!empty($umur)){
				if($umur>100 OR $umur<5){
					echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Periksa Kembali Umur Pihak.'.$umur));
					return;
				}
			}
			$curr_date = date('Y-m-d');
			$selisih = $this->tanggalhelper->getSelisihHari($tglLahir,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Periksa Kembali Tanggal Lahir.'));
				return;
			}

			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			$idanak = $this->encrypt->decode(base64_decode($this->input->post('enc_pihak',TRUE)));
			$idortu = $this->encrypt->decode(base64_decode($this->input->post('enc_ortu',TRUE)));

				$data_pihak = array(
					'nama' => $nama,
					'jenis_pihak_id' => 1,
					'jenis_indentitas' => $this->input->post('pihak_jenis_identitas',TRUE),
					'nomor_indentitas' => $this->input->post('pihak_no_identitas',TRUE),
					'tempat_lahir' => (empty($tempatLahir))? NULL:$tempatLahir,
					'tanggal_lahir' => (empty($tglLahir))? NULL:$tglLahir,
					'jenis_kelamin' => $sex,
					'alamat' => trim($this->input->post('pihak_alamat',TRUE)),
					'agama_id' => (empty($agama))? NULL:$agama,
					'pekerjaan' => trim($pekerjaan),
					'telepon' => trim($this->input->post('pihak_no_tlp',TRUE)),
					'email' => trim($this->input->post('pihak_email',TRUE)),
					'warga_negara_id' => $this->input->post('pihak_warga_negara',TRUE)
				);
				$data_ortu = array(
					'id_anak' => $idanak,
					'id_orang_tua' => $idortu,
					'perkara_id' => $idperkara,
					'jenis_pihak_anak' => 2
					);																			
			
			
			if($act==="add"){
				$data_pihak['diinput_oleh'] = $this->session->userdata('username');
				$data_pihak['diinput_tanggal'] = date("Y-m-d h:i:s",time());
				$this->load->model('pihak/orangtua_wali','ortuwali');
				$query = $this->ortuwali->add_data($data_pihak,$data_ortu);
				if($query==TRUE){
					echo json_encode(array('st'=>1,'msg'=>'Berhasil<br /> Data Berhasil Disimpan.'));
					return;
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Error<br /> Coba Ulangi Kembali. Error Code 198'));
					return;
				}
			}elseif ($act==="edit") {
				$idortu = $this->encrypt->decode(base64_decode($this->input->post('enc_ortu',TRUE)));			
				if(!is_numeric($idortu) OR empty($idortu)){
					echo json_encode(array('st'=>0,'msg'=>'Error:<br /> System Error, Please refresh your browser.Error Code 199'.$act));
				}else{
					$data_pihak['diperbaharui_oleh'] = $this->session->userdata('username');
					$data_pihak['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
					$this->load->model('pihak/orangtua_wali','ortuwali');
					$query = $this->ortuwali->update_data($data_pihak,$idortu,$data_ortu);
					if($query==TRUE){
						echo json_encode(array('st'=>1,'msg'=>'Berhasil<br /> Data Berhasil Disimpan.'));
						return;
					}else{
						echo json_encode(array('st'=>0,'msg'=>'Error<br /> Coba Ulangi Kembali. Error Code 198'));
						return;
					}
				}
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> System Error, Please refresh your browser.Error Code 199#'.$act));
			}
		}
	}
}