<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class addMajelis_c extends CI_Controller {
	
	function __construct() {
	    parent::__construct();
	    $this->load->model('penetapan/add_majelis_m');
	}
	function index(){
		
	}

	function f_validate_input_add(){
		$post=$this->input->post();
		if(empty($post)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		if ($this->session->userdata('jenis_pengadilan')==9){
			$this->form_validation->set_rules('jenis_acara', 'Jenis Acara', 'trim|required|xss_clean');
		}
		$this->form_validation->set_rules('tgl_penetapan_majelis', 'Tanggal Penetapan Majelis', 'trim|required|xss_clean|exact_length[10]');
		if ($this->input->post('pilihan_majelis')==='majelis'){
			$this->form_validation->set_rules('hakim_ketua', 'Hakim Ketua', 'numeric|required|xss_clean|callback_f_hakim_id_check');
			$this->form_validation->set_rules('hakim_anggota1', 'Hakim Anggota 1', 'numeric|required|xss_clean|callback_f_hakim_id_check');
			$this->form_validation->set_rules('hakim_anggota2', 'Hakim Anggota 2', 'numeric|required|xss_clean|callback_f_hakim_id_check');
		}else{
			$this->form_validation->set_rules('hakim_tunggal', 'Hakim Tunggal', 'numeric|required|xss_clean|callback_f_hakim_id_check');
		}

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil '.validation_errors()));
			return;
		}else{
			//insert data;
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			$date_daftar_perkara = $this->add_majelis_m->get_tanggal_pelimpahan($idperkara)->tanggal_pendaftaran;
			
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$jenis_acara = $this->input->post('jenis_acara', TRUE);
			$tgl_penetapan_majelis = $this->input->post('tgl_penetapan_majelis', true);
			$tgl_penetapan_majelis = $this->tanggalhelper->convertToMysqlDate($tgl_penetapan_majelis);

			if($tgl_penetapan_majelis==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($tgl_penetapan_majelis,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Majelis Hakim Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($date_daftar_perkara,$tgl_penetapan_majelis);
			if($date_daftar_perkara>$tgl_penetapan_majelis){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Majelis Hakim Tidak Boleh Kurang dari Tanggal Pendaftaran Perkara.'));
				return;
			}


			$dayname = $this->tanggalhelper->getDayName($tgl_penetapan_majelis);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Majelis Hakim Dihari Libur, Sabtu dan Minggu.'));
				return;
			}


			if ($this->input->post('pilihan_majelis', TRUE)==='majelis'){
				$this->hakim_id = $this->input->post('hakim_ketua').",".$this->input->post('hakim_anggota1', TRUE).",".
						$this->input->post('hakim_anggota2', TRUE);
				if (intval($this->input->post('hakim_anggota3', TRUE))<>0){
					$this->hakim_id .= ",".$this->input->post('hakim_anggota3', TRUE);	
				}
				if (intval($this->input->post('hakim_anggota4', TRUE))<>0){
					$this->hakim_id .= ",".$this->input->post('hakim_anggota4', TRUE);	
				}
			}else{
				$this->hakim_id = $this->input->post('hakim_tunggal', TRUE);

			}

			$keterangan = $this->input->post('keterangan');
			if('keterangan'==''){
				$keterangan=null;
			}
			$this->keterangan = $keterangan;
			
			$namahalaman = $this->input->post('namahalaman',TRUE);
			$this->add_majelis_m->insert_penetapan_majelis($idperkara, $jenis_acara, $tgl_penetapan_majelis, $this->hakim_id, $namahalaman);
			$this->load->model('riwayatperkara/riwayat_perkara_m');
			$this->riwayat_perkara_m->updateproses($idperkara,'20',$tgl_penetapan_majelis,'',$namahalaman,1);
			echo json_encode(array('st'=>1,'msg'=>'Data Penetapan Berhasil Disimpan'));
			return;
		};
	}

	function f_validate_input_edit(){
		$post=$this->input->post();
		if(empty($post)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		if ($this->session->userdata('jenis_pengadilan')==9){
			$this->form_validation->set_rules('jenis_acara', 'Jenis Acara', 'trim|required|xss_clean');
		}
		$this->form_validation->set_rules('tgl_penetapan_majelis', 'Tanggal Penetapan Majelis', 'trim|required|xss_clean');
		if ($this->input->post('pilihan_majelis')==='majelis'){
			$this->form_validation->set_rules('hakim_ketua', 'Hakim Ketua', 'numeric|required|xss_clean|callback_f_hakim_id_check');
			$this->form_validation->set_rules('hakim_anggota1', 'Hakim Anggota 1', 'numeric|required|xss_clean|callback_f_hakim_id_check');
			$this->form_validation->set_rules('hakim_anggota2', 'Hakim Anggota 2', 'numeric|required|xss_clean|callback_f_hakim_id_check');
		}else{
			$this->form_validation->set_rules('hakim_tunggal', 'Hakim Tunggal', 'numeric|required|xss_clean|callback_f_hakim_id_check');
		}

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil '.validation_errors()));
			return;
		}else{
			//Edit data;
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));

			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');
			
			$date_daftar_perkara = $this->add_majelis_m->get_tanggal_pelimpahan($idperkara)->tanggal_pendaftaran;

			$jenis_acara = $this->input->post('jenis_acara', TRUE);
			$tgl_penetapan_majelis = $this->input->post('tgl_penetapan_majelis');
			$tgl_penetapan_majelis = $this->tanggalhelper->convertToMysqlDate($tgl_penetapan_majelis);

			if($tgl_penetapan_majelis==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($tgl_penetapan_majelis,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Majelis Hakim Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($date_daftar_perkara,$tgl_penetapan_majelis);
			if($date_daftar_perkara>$tgl_penetapan_majelis){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Majelis Hakim Tidak Boleh Kurang dari Tanggal Pendaftaran Perkara.'));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tgl_penetapan_majelis);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Majelis Hakim Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			if ($this->input->post('pilihan_majelis', TRUE)==='majelis'){
				$this->hakim_id = $this->input->post('hakim_ketua').",".$this->input->post('hakim_anggota1', TRUE).",".
						$this->input->post('hakim_anggota2', TRUE);
				if (intval($this->input->post('hakim_anggota3', TRUE))<>0){
					$this->hakim_id .= ",".$this->input->post('hakim_anggota3', TRUE);	
				}
				if (intval($this->input->post('hakim_anggota4', TRUE))<>0){
					$this->hakim_id .= ",".$this->input->post('hakim_anggota4', TRUE);	
				}
			}else{
				$this->hakim_id = $this->input->post('hakim_tunggal', TRUE);
			}
			$majelis_sebelumnya_id = $this->input->post('majelis_sebelumnya_id', TRUE);
			$tanggalinput = $this->add_majelis_m->get_jumlah_tanggal_input($idperkara);
			if($tanggalinput==FALSE){
				echo json_encode(array('st'=>0,'msg'=>'Data Penetapan Majelis Tidak Ditemukan'));
				return;
			}

			$keterangan = $this->input->post('keterangan');
			if('keterangan'==''){
				$keterangan=null;
			}
			$this->keterangan = $keterangan;


			$namahalaman = $this->input->post('namahalaman',TRUE);
			$this->load->model('riwayatperkara/riwayat_perkara_m');
			$jml_row=$tanggalinput->num_rows();
			if($jml_row > 1){
				$tanggal_penetapan_sebelumnya=$tanggalinput->row($jml_row-1)->tanggal_penetapan;
				$selisih = $this->tanggalhelper->getSelisihHari($tanggal_penetapan_sebelumnya,$tgl_penetapan_majelis);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Majelis Hakim Tidak Boleh Sebelum '.$this->tanggalhelper->convertDayDate($tanggal_penetapan_sebelumnya)));
					return;
				}else{
					$this->add_majelis_m->edit_penetapan_majelis($idperkara, $jenis_acara, $tgl_penetapan_majelis, $this->hakim_id, $majelis_sebelumnya_id, 1, $namahalaman);
					$this->riwayat_perkara_m->updateproses($idperkara,'21',$tgl_penetapan_majelis,'',$namahalaman,1);
				}
			}else{
				$this->add_majelis_m->edit_penetapan_majelis($idperkara, $jenis_acara, $tgl_penetapan_majelis, $this->hakim_id, $majelis_sebelumnya_id, 0, $namahalaman);
				$this->riwayat_perkara_m->updateproses($idperkara,'20',$tgl_penetapan_majelis,'',$namahalaman,1);
			}
			echo json_encode(array('st'=>1,'msg'=>'Data Penetapan Berhasil Disimpan'));
			return;
		}
	}
	
	function f_validate_input_penunjukan(){
		$post=$this->input->post();
		if(empty($post)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		if ($this->session->userdata('jenis_pengadilan')==9){
			$this->form_validation->set_rules('jenis_acara', 'Jenis Acara', 'trim|required|xss_clean');
		}
		$this->form_validation->set_rules('tgl_penetapan_majelis', 'Tanggal Penetapan Majelis', 'trim|required|xss_clean');
		if ($this->input->post('pilihan_majelis')==='majelis'){
			$this->form_validation->set_rules('hakim_ketua', 'Hakim Ketua', 'numeric|required|xss_clean|callback_f_hakim_id_check');
			$this->form_validation->set_rules('hakim_anggota1', 'Hakim Anggota 1', 'numeric|required|xss_clean|callback_f_hakim_id_check');
			$this->form_validation->set_rules('hakim_anggota2', 'Hakim Anggota 2', 'numeric|required|xss_clean|callback_f_hakim_id_check');
		}else{
			$this->form_validation->set_rules('hakim_tunggal', 'Hakim Tunggal', 'numeric|required|xss_clean|callback_f_hakim_id_check');
		}

		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil '.validation_errors()));
			return;
		}else{
			//simpan update;
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');
			
			$this->jenis_acara = $this->input->post('jenis_acara', TRUE);
			$date_penetapan_before = $this->add_majelis_m->get_penetapan_hakim_pertama($idperkara)->penetapan_majelis_hakim;
			$this->tgl_penetapan_majelis = $this->input->post('tgl_penetapan_majelis', true);
			$this->tgl_penetapan_majelis = $this->tanggalhelper->convertToMysqlDate($this->tgl_penetapan_majelis);

			if($this->tgl_penetapan_majelis==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($this->tgl_penetapan_majelis,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Majelis Hakim Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
				return;
			}
			$selisih =$this->tanggalhelper->getSelisihHari($date_penetapan_before,$this->tgl_penetapan_majelis);
			if($date_penetapan_before>$this->tgl_penetapan_majelis){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Kembali Majelis Hakim Tidak Boleh Kurang dari Tanggal Penetapan Pertama.'));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($this->tgl_penetapan_majelis);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Majelis Hakim Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			if ($this->input->post('pilihan_majelis')==='majelis'){
				$this->hakim_id = $this->input->post('hakim_ketua').",".$this->input->post('hakim_anggota1').",".
						$this->input->post('hakim_anggota2');
				if (intval($this->input->post('hakim_anggota3'))<>0){
					$this->hakim_id .= ",".$this->input->post('hakim_anggota3');	
				}
				if (intval($this->input->post('hakim_anggota4'))<>0){
					$this->hakim_id .= ",".$this->input->post('hakim_anggota4');	
				}
			}else{
				$this->hakim_id = $this->input->post('hakim_tunggal');
			}

			$keterangan = $this->input->post('keterangan');

			if('keterangan'==''){
				$keterangan=null;
			}
			$this->keterangan = $keterangan;


			$namahalaman = $this->input->post('namahalaman',TRUE);
			$this->add_majelis_m->update_perkara_penetapan($idperkara,$namahalaman);
			$this->load->model('riwayatperkara/riwayat_perkara_m');
			$this->riwayat_perkara_m->updateproses($idperkara,'21',$this->tgl_penetapan_majelis,'',$namahalaman,1);
			echo json_encode(array('st'=>1,'msg'=>'Data Penetapan Berhasil Disimpan'));
			return;
		};
	}
	
	function f_hakim_id_check($str){
		if (intval($str)==0){
			$this->form_validation->set_message('f_hakim_id_check', '%s Tidak Boleh Kosong');
			return FALSE;
		}else{
			return TRUE;
		}
	}
	
	function f_add_majelis(){
		if($this->nativesession->is_flash_session('security')===FALSE){
			redirect('main');
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			redirect('login');
		}
		
		$data['current_date'] = date('d/m/Y');
		$data['perkara_id'] = $this->nativesession->get_flash_session('perkara_id');
		if (!is_numeric($data['perkara_id']) OR $data['perkara_id']<0){
			show_404();
			exit();
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		
		$data['perkara'] = $this->add_majelis_m->get_no_perkara($data['perkara_id']);
		$data['idalurperkara'] = $this->tanggalhelper->getIDAlurPerkara($data['perkara_id']);
		$list = array('0'=>'Pilih Nama Hakim');
		$res = $this->add_majelis_m->get_data_hakim_aktif();
		foreach ($res as $row){
			$list[$row['id']] = $row['nama_gelar'];
		};
		$data['data_hakim']=$list;
		$data['tanggal_pelimpahan'] = $this->add_majelis_m->get_tanggal_pelimpahan($data['perkara_id']);
		$data['action'] = 'add';
		if($data['idalurperkara']==8){
			$data['namahalaman']="TAMBAH PENETAPAN HAKIM";
		}else{
			$data['namahalaman']="TAMBAH PENETAPAN HAKIM/MAJELIS HAKIM";
		}
		$this->load->view('perkara_tab/penetapan/edit_majelis_v', $data);
	}
	
	function f_edit_majelis(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		
		$data['current_date'] = date('d/m/Y');
		$data['perkara_id'] = $this->nativesession->get_flash_session('perkara_id');
		$data['idalurperkara'] = $this->tanggalhelper->getIDAlurPerkara($data['perkara_id']);
		if (!is_numeric($data['perkara_id']) OR $data['perkara_id']<0){
			show_404();
			exit();
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		
		$data['perkara'] = $this->add_majelis_m->get_no_perkara($data['perkara_id']);
		$list = array('0'=>'Pilih Nama Hakim');
		$res = $this->add_majelis_m->get_data_hakim_aktif();
		foreach ($res as $row){
			$list[$row['id']] = $row['nama_gelar'];
		};
		$data['data_hakim']=$list;
		$data['tanggal_pelimpahan'] = $this->add_majelis_m->get_tanggal_pelimpahan($data['perkara_id']);
		$data['action'] = 'edit';
		$data['data_majelisku'] = $this->add_majelis_m->get_data_majelis($data['perkara_id']);
		
		$data['data_majelis_detail'] = $this->add_majelis_m->get_data_majelis_detail($data['perkara_id']);
		$data['cek_status'] = $this->add_majelis_m->getStatusHakim($data['perkara_id']);
		if($data['idalurperkara']==8){
			$data['namahalaman']="EDIT PENETAPAN HAKIM";
		}else{
			$data['namahalaman']="EDIT PENETAPAN HAKIM/MAJELIS HAKIM";
		}
		$this->load->view('perkara_tab/penetapan/edit_majelis_v', $data);
	}
	
	function f_penetapan_kembali(){
		if($this->nativesession->is_flash_session('security')===FALSE){
			redirect('main');
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			redirect('login');
		}
		
		$data['current_date'] = date('d/m/Y');
		$data['perkara_id'] = $this->nativesession->get_flash_session('perkara_id');
		if (!is_numeric($data['perkara_id']) OR $data['perkara_id']<0){
			show_404();
			exit();
		}
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		
		$data['perkara'] = $this->add_majelis_m->get_no_perkara($data['perkara_id']);
		$data['idalurperkara'] = $this->tanggalhelper->getIDAlurPerkara($data['perkara_id']);
		$list = array('0'=>'Pilih Nama Hakim');
		$res = $this->add_majelis_m->get_data_hakim_aktif();
		foreach ($res as $row){
			$list[$row['id']] = $row['nama_gelar'];
		};
		$data['data_hakim']=$list;
		$data['tanggal_pelimpahan'] = $this->add_majelis_m->get_tanggal_pelimpahan($data['perkara_id']);
		$data['data_majelis'] = $this->add_majelis_m->get_data_majelis($data['perkara_id']);
		$data['data_majelis_detail'] = $this->add_majelis_m->get_data_majelis_detail($data['perkara_id']);
		if($data['idalurperkara']==8){
			$data['namahalaman']="TAMBAH PENETAPAN KEMBALI HAKIM";
		}else{
			$data['namahalaman']="TAMBAH PENETAPAN KEMBALI HAKIM/MAJELIS HAKIM";
		}
		$this->load->view('perkara_tab/penetapan/penetapan_kembali_majelis_v', $data);
	}

	function del_penetapan(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$idperkara = $this->nativesession->get_flash_session('perkara_id');
		if (!is_numeric($idperkara) OR intval($idperkara)<1){
			show_404();
			exit();
		}

		$tanggalinput = $this->add_majelis_m->get_jumlah_tanggal_input($idperkara);
		if($tanggalinput==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Data Penetapan Majelis Tidak Ditemukan'));
			return;
		}
		$dohapus = FALSE;
		$namahalaman = $this->input->post('namahalaman',TRUE);			
		if($tanggalinput->num_rows ==1){
			$tglpenetapan = $this->add_majelis_m->get_tanggal_penetapan($idperkara);
			if($tglpenetapan!=FALSE){
				if($tglpenetapan->num_rows>0){
					foreach ($tglpenetapan->result() as $row) {
						$tglpenetapanpanitera = $row->penetapan_panitera_pengganti;
						$tglpenetapanjurusita = $row->penetapan_jurusita;
						$tglpenetapansidang = $row->penetapan_hari_sidang;
					}
					if(!empty($tglpenetapansidang)){
						echo json_encode(array('st'=>0,'msg'=>'Data Penetapan Majelis Tidak Dapat Dihapus. Tanggal Sidang Pertama Sudah Ditentukan.'));
						return;
					}
					if(!empty($tglpenetapanjurusita)){
						echo json_encode(array('st'=>0,'msg'=>'Data Penetapan Majelis Tidak Dapat Dihapus. Jurusita Telah Ditentukan.'));
						return;
					}

					if(!empty($tglpenetapanpanitera)){
						echo json_encode(array('st'=>0,'msg'=>'Data Penetapan Majelis Tidak Dapat Dihapus. Panitera Pengganti Telah Ditentukan.'));
						return;
					}
				}

				$jumlahsidang = $this->add_majelis_m->get_jumlah_sidang($idperkara);
				if($jumlahsidang>0){
					echo json_encode(array('st'=>0,'msg'=>'Data Penetapan Majelis Tidak Dapat Dihapus. Perkara Telah Memasuki Proses Persidangan.'));
					return;
				}else{
					$tahapan = $this->add_majelis_m->get_tahapan($idperkara);
					if($tahapan>12){
						echo json_encode(array('st'=>0,'msg'=>'Data Penetapan Majelis Tidak Dapat Dihapus. Perkara Telah Memasuki Proses Persidangan.'));
						return;
					}
				}
				$hapusdata = $this->add_majelis_m->hapus_all_penetapan($idperkara,$namahalaman);
				if($hapusdata){
					$this->load->model('riwayatperkara/riwayat_perkara_m');
					$this->riwayat_perkara_m->updateproses($idperkara,'20','','',$namahalaman,2);
					echo json_encode(array('st'=>1,'msg'=>'Data Penetapan Berhasil Dihapus'));
					return;
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Gagal Menghapus Penetapan Majelis Hakim'));
					return;
				}
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Something Wrong with The Database.'));
				return;
			}
		}else{
			$i=0;
			$ids = array();
			$idUpdate = array();
			$urutan=0;
			$tanggal_sebelumnya='';
			$tanggalinput = $this->add_majelis_m->get_tanggal_input($idperkara);
			foreach ($tanggalinput->result() as $row) {
				if ($row->aktif=='Y'){
					$ids[] = $row->id;
				}else{
					if ($tanggal_sebelumnya=='' || $tanggal_sebelumnya==$row->tanggal){
						$idUpdate[] = $row->id;	
						$urutan=$row->urutan;
					}else{
						if ($urutan==1){
							break;
						}else{
							$idUpdate[] = $row->id;	
							$urutan=$row->urutan;
						}
					}
					$tanggal_sebelumnya=$row->tanggal;
				}
				$i++;
			}
			
			$hapusdata = $this->add_majelis_m->hapus_penetapan($idperkara,$ids,$idUpdate,$namahalaman);
			$datasebelum=$this->add_majelis_m->get_data_majelis_detail($idperkara);
			if($hapusdata){
				$this->load->model('riwayatperkara/riwayat_perkara_m');
				$this->riwayat_perkara_m->updateproses($idperkara,'21','','',$namahalaman,2);
				if($tanggalinput->num_rows >2){
					$this->riwayat_perkara_m->updateproses($idperkara,'21',$datasebelum[0]['tanggal_penetapan'],'',$namahalaman,1);
				}
				echo json_encode(array('st'=>1,'msg'=>'Data Penetapan Berhasil Dihapus'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Gagal Menghapus Penetapan Majelis Hakim'));
				return;
			}
		}
	}
}