<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class addKeberatan_c extends CI_Controller {

	function index(){
		
	}

	function f_validate_input_add(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$this->form_validation->set_rules('tgl_pendaftaran_keberatan', 'Tanggal Pendaftaran Keberatan', 'trim|required|xss_clean|exact_length[10]');
		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			
			$this->load->model('keberatan/keberatan_m');
			$perkaraid = ($this->encrypt->decode(base64_decode($this->input->post('enc', TRUE))));
			$tgl_putusan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_putusan', TRUE));
			$tgl_pendaftaran_keberatan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pendaftaran_keberatan', TRUE));
			if ($tgl_pendaftaran_keberatan<$tgl_putusan){
				echo json_encode(array('st'=>0,'msg'=>'Tanggal Pendaftaran Keberatan Tidak Boleh sebelum Tanggal Putusan'));
				exit();
			}

			$todayDate = date('d/m/Y');
			$curr_date = date('Y-m-d');

			$selisih = $this->tanggalhelper->getSelisihHari($tgl_pendaftaran_keberatan,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pendaftaran Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}


			$dayname = $this->tanggalhelper->getDayName($tgl_pendaftaran_keberatan);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pendaftaran Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$data_pihak = array();
			$data_termohon = array();
			$parapihakkeberatan = '';
			$jumlahPemohon = 0;
			$pihak1_list = $this->input->post('para_pihak1',TRUE);
			if(!empty($pihak1_list)){
				$i=0;
				foreach ($pihak1_list as $key) {
					$urutan = $this->input->post('pihak_'.$key,TRUE);
					$pihakdetil = $this->keberatan_m->get_info_pihak($key);
					if($pihakdetil->num_rows>0){
						foreach ($pihakdetil->result() as $row) {
							$nama = $row->nama;
							$alamat = $row->alamat;
						}
					}else{
						echo json_encode(array('st'=>0,'msg'=>'Informasi Pihak Pemohon Tidak Ditemukan'));
						return;
					}
					
					if(empty($urutan) OR intval($urutan)<1){
						echo json_encode(array('st'=>0,'msg'=>'Mohon Memilih Urutan Pemohon '.$nama));
						return;
					}
					
					$data_pihak[$i] = array(
						'perkara_id' => $perkaraid,
						'pihak_id' => $key,
						'tanggal_permohonan' => $tgl_pendaftaran_keberatan,
						'urutan_keberatan' => $urutan,
						'status_pihak_id' => 1,
						'status_pihak_text' => 'Pemohon',
						'pihak_asal' => 1,
						'pihak_asal_text' => 'Penggugat',
						'nama' => $nama,
						'alamat' => $alamat,
						'diinput_oleh'=>$this->session->userdata('username'),
						'diinput_tanggal'=>date('Y-m-d H:i:s')
						);
					$i++;
					$parapihakkeberatan .= 'Pemohon Ke-'.$i.':</br> '.$nama.' (Penggugat)</br></br>';
					$jumlahPemohon = $i;
				}
			}else{
				$parapihak = $this->keberatan_m->get_para_pihak($perkaraid,1);
				if($parapihak->num_rows>0){
					$i=0;
					foreach ($parapihak->result() as $row) {
						$data_termohon[$i] = array(
							'perkara_id' => $perkaraid,
							'pihak_id' => $row->pihak_id,
							'urutan_keberatan' => ($i+1),
							'status_pihak_id' => 3,
							'status_pihak_text' => 'Termohon',
							'pihak_asal' => 1,
							'pihak_asal_text' => 'Penggugat',
							'nama' => $row->nama,
							'alamat' => $row->alamat,
							'diinput_oleh'=>$this->session->userdata('username'),
							'diinput_tanggal'=>date('Y-m-d H:i:s')
						);
						$i++;
						$parapihakkeberatan .= 'Termohon Ke-'.$i.':</br> '.$row->nama.' (Penggugat)</br></br>';
					}
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Data Para Pihak Tidak ditemukan, Please refresh your browser'));
					return;
				}
			}
			if($jumlahPemohon>0){
				# ada pemohon dari penggugat
				$parapihak = $this->keberatan_m->get_para_pihak($perkaraid,1);
				if($parapihak->num_rows>$jumlahPemohon){
					foreach ($parapihak->result() as $row) {
						if($this->isAlreadyThere($data_pihak,$row->pihak_id)==FALSE){
							$data_termohon[$i] = array(
								'perkara_id' => $perkaraid,
								'pihak_id' => $row->pihak_id,
								'urutan_keberatan' => ($i+1),
								'status_pihak_id' => 5,
								'status_pihak_text' => 'Turut Termohon',
								'pihak_asal' => 1,
								'pihak_asal_text' => 'Penggugat',
								'nama' => $row->nama,
								'alamat' => $row->alamat,
								'diinput_oleh'=>$this->session->userdata('username'),
								'diinput_tanggal'=>date('Y-m-d H:i:s')
							);
							$i++;
							$parapihakkeberatan .= 'Turut Termohon Ke-'.$i.':</br> '.$row->nama.' (Penggugat)</br></br>';
						}
					}
				}
			}
			$jumlahPemohon = 0;
			$pihak2_list = $this->input->post('para_pihak2',TRUE);
			if(!empty($pihak2_list)){
				$i=0;
				foreach ($pihak2_list as $key) {
					$urutan = $this->input->post('pihak_'.$key,TRUE);
					$pihakdetil = $this->keberatan_m->get_info_pihak($key);
					if($pihakdetil->num_rows>0){
						foreach ($pihakdetil->result() as $row) {
							$nama = $row->nama;
							$alamat = $row->alamat;
						}
					}else{
						echo json_encode(array('st'=>0,'msg'=>'Informasi Pihak Pemohon Tidak Ditemukan'));
						return;
					}
					
					if(empty($urutan) OR intval($urutan)<1){
						echo json_encode(array('st'=>0,'msg'=>'Mohon Memilih Urutan Pemohon '.$nama));
						return;
					}
					
					$data_pihak[$i] = array(
						'perkara_id' => $perkaraid,
						'pihak_id' => $key,
						'tanggal_permohonan' => $tgl_pendaftaran_keberatan,
						'urutan_keberatan' => $urutan,
						'status_pihak_id' => 1,
						'status_pihak_text' => 'Pemohon',
						'pihak_asal' => 2,
						'pihak_asal_text' => 'Tergugat',
						'nama' => $nama,
						'alamat' => $alamat,
						'diinput_oleh'=>$this->session->userdata('username'),
						'diinput_tanggal'=>date('Y-m-d H:i:s')
						);
					$i++;
					$parapihakkeberatan .= 'Pemohon Ke-'.$i.':</br> '.$nama.' (Tergugat)</br></br>';
					$jumlahPemohon = $i;
				}
			}else{
				$parapihak = $this->keberatan_m->get_para_pihak($perkaraid,2);
				if($parapihak->num_rows>0){
					$x=1;
					foreach ($parapihak->result() as $row) {
						$data_termohon[$i] = array(
							'perkara_id' => $perkaraid,
							'pihak_id' => $row->pihak_id,
							'urutan_keberatan' => $i,
							'status_pihak_id' => 3,
							'status_pihak_text' => 'Termohon',
							'pihak_asal' => 2,
							'pihak_asal_text' => 'Tergugat',
							'nama' => $row->nama,
							'alamat' => $row->alamat,
							'diinput_oleh'=>$this->session->userdata('username'),
							'diinput_tanggal'=>date('Y-m-d H:i:s')
						);
						$i++;
						$parapihakkeberatan .= 'Termohon Ke-'.$x.':</br> '.$row->nama.' (Tergugat)</br></br>';
						$x++;
					}
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Data Para Pihak Tidak ditemukan, Please refresh your browser'));
					return;
				}
			}

			if($jumlahPemohon>0){
				# ada pemohon dari penggugat
				$parapihak = $this->keberatan_m->get_para_pihak($perkaraid,2);
				if($parapihak->num_rows>$jumlahPemohon){
					foreach ($parapihak->result() as $row) {
						if($this->isAlreadyThere($data_pihak,$row->pihak_id)==FALSE){
							$data_termohon[$i+1] = array(
								'perkara_id' => $perkaraid,
								'pihak_id' => $row->pihak_id,
								'urutan_keberatan' => ($i),
								'status_pihak_id' => 5,
								'status_pihak_text' => 'Turut Termohon',
								'pihak_asal' => 2,
								'pihak_asal_text' => 'Tergugat',
								'nama' => $row->nama,
								'alamat' => $row->alamat,
								'diinput_oleh'=>$this->session->userdata('username'),
								'diinput_tanggal'=>date('Y-m-d H:i:s')
							);
							$i++;
							$parapihakkeberatan .= 'Turut Termohon Ke-'.$i.':</br> '.$row->nama.' (Tergugat)</br></br>';
						}
					}
				}
			}

			$data = array(
					'perkara_id'=>$perkaraid, 
					'tanggal_pendaftaran_keberatan'=>$tgl_pendaftaran_keberatan,
					'pemohon_keberatan'=>$parapihakkeberatan,
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
				);
			$tahapan_id=17;$tahapan_nama='Keberatan';$proses_id=281;$proses_nama='Pendaftaran Keberatan';$tanggal=$tgl_pendaftaran_keberatan;
			$result = $this->keberatan_m->add_keberatan($perkaraid, $data, $tahapan_id, $tahapan_nama, $proses_id, $proses_nama, $tanggal);
			$result = $this->keberatan_m->add_pihak_keberatan($perkaraid,$data_pihak,$data_termohon);
			
			if($result){
				echo json_encode(array('st'=>1,'msg'=>'Data Permohonan Keberatan Berhasil Disimpan '));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Data Permohonan Keberatan Tidak Berhasil Disimpan '));
				return;
			}
		}
	}

	function isAlreadyThere($optionPihak,$idpihak){
		foreach ($optionPihak as $key => $val) {
	        if($val['pihak_id']==$idpihak){
	            return TRUE;
	        }
	    }
	    return FALSE;
	}

	function isThere($parapihak,$idpihak,$statuspihak){
		foreach ($parapihak->result() as $raws) {
			if($raws->pihak_id==$idpihak AND $raws->status_pihak_id==$statuspihak){
				return TRUE;
			}
		}
		return FALSE;
	}

	function f_validate_add_pihak(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$this->form_validation->set_rules('tgl_pendaftaran_keberatan', 'Tanggal Pendaftaran Keberatan', 'trim|required|xss_clean|exact_length[10]');
		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			
			$this->load->model('keberatan/keberatan_m');
			$perkaraid = ($this->encrypt->decode(base64_decode($this->input->post('enc', TRUE))));
			$tgl_putusan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_putusan', TRUE));
			$tgl_pendaftaran_keberatan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pendaftaran_keberatan', TRUE));
			if ($tgl_pendaftaran_keberatan<$tgl_putusan){
				echo json_encode(array('st'=>0,'msg'=>'Tanggal Pendaftaran Keberatan Tidak Boleh sebelum Tanggal Putusan'));
				exit();
			}

			$todayDate = date('d/m/Y');
			$curr_date = date('Y-m-d');

			$selisih = $this->tanggalhelper->getSelisihHari($tgl_pendaftaran_keberatan,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pendaftaran Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}


			$dayname = $this->tanggalhelper->getDayName($tgl_pendaftaran_keberatan);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pendaftaran Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$data_pihak = array();
			$data_update = array();
			$parapihakkeberatan = '';
			$pihak1_list = $this->input->post('para_pihak1',TRUE);

			$pihakKeberatan = $this->keberatan_m->getListParaPihak($perkaraid);
			$i=0;
			if(!empty($pihak1_list)){
				foreach ($pihak1_list as $key) {
					$urutan = $this->input->post('pihak_'.$key,TRUE);
					if($pihakKeberatan->num_rows>0){
						if($this->isThere($pihakKeberatan,$key,5)==TRUE){
							$data_update[$i] = array(
								'perkara_id' => $perkaraid,
								'pihak_id' => $key,
								'tanggal_permohonan' => $tgl_pendaftaran_keberatan,
								'urutan_keberatan' => $urutan,
								'status_pihak_id' => 1,
								'status_pihak_text' => 'Pemohon',
								'diperbaharui_oleh'=>$this->session->userdata('username'),
								'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
							);
							$i++;
						}
						if($this->isThere($pihakKeberatan,$key,3)==TRUE){
							$data_update[$i] = array(
								'perkara_id' => $perkaraid,
								'pihak_id' => $key,
								'tanggal_permohonan' => $tgl_pendaftaran_keberatan,
								'urutan_keberatan' => $urutan,
								'status_pihak_id' => 4,
								'status_pihak_text' => 'Termohon/Pemohon',
								'diperbaharui_oleh'=>$this->session->userdata('username'),
								'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
							);
							$i++;
						}
					}else{
						echo json_encode(array('st'=>0,'msg'=>'Informasi Pihak Pemohon Tidak Ditemukan'));
						return;
					}
					
					if(empty($urutan) OR intval($urutan)<1){
						echo json_encode(array('st'=>0,'msg'=>'Mohon Memilih Urutan Pemohon '));
						return;
					}
				}
			}else{
				foreach ($pihakKeberatan->result() as $row) {
					if($row->status_pihak_id==1){
						$data_update[$i] = array(
							'perkara_id' => $perkaraid,
							'pihak_id' => $row->pihak_id,
							'status_pihak_id' => 2,
							'status_pihak_text' => 'Pemohon/Termohon',
							'diperbaharui_oleh'=>$this->session->userdata('username'),
							'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
						);
						$i++;
					}elseif ($row->status_pihak_id==5) {
							$data_update[$i] = array(
								'perkara_id' => $perkaraid,
								'pihak_id' => $row->pihak_id,
								'status_pihak_id' => 3,
								'status_pihak_text' => 'Termohon',
								'diperbaharui_oleh'=>$this->session->userdata('username'),
								'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
							);
							$i++;
					}
				}
			}


			$pihak2_list = $this->input->post('para_pihak2',TRUE);

			if(!empty($pihak2_list)){
				
				foreach ($pihak2_list as $key) {
					$urutan = $this->input->post('pihak_'.$key,TRUE);
					if($pihakKeberatan->num_rows>0){
						if($this->isThere($pihakKeberatan,$key,5)==TRUE){
							$data_update[$i] = array(
								'perkara_id' => $perkaraid,
								'pihak_id' => $key,
								'tanggal_permohonan' => $tgl_pendaftaran_keberatan,
								'urutan_keberatan' => $urutan,
								'status_pihak_id' => 1,
								'status_pihak_text' => 'Pemohon',
								'diperbaharui_oleh'=>$this->session->userdata('username'),
								'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
							);
							$i++;
						}
						if($this->isThere($pihakKeberatan,$key,3)==TRUE){
							$data_update[$i] = array(
								'perkara_id' => $perkaraid,
								'pihak_id' => $key,
								'tanggal_permohonan' => $tgl_pendaftaran_keberatan,
								'urutan_keberatan' => $urutan,
								'status_pihak_id' => 4,
								'status_pihak_text' => 'Termohon/Pemohon',
								'diperbaharui_oleh'=>$this->session->userdata('username'),
								'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
							);
							$i++;
						}
					}else{
						echo json_encode(array('st'=>0,'msg'=>'Informasi Pihak Pemohon Tidak Ditemukan'));
						return;
					}
					
					if(empty($urutan) OR intval($urutan)<1){
						echo json_encode(array('st'=>0,'msg'=>'Mohon Memilih Urutan Pemohon '));
						return;
					}
				}
			}else{
				foreach ($pihakKeberatan->result() as $row) {
					if($row->status_pihak_id==1){
						$data_update[$i] = array(
							'perkara_id' => $perkaraid,
							'pihak_id' => $row->pihak_id,
							'status_pihak_id' => 2,
							'status_pihak_text' => 'Pemohon/Termohon',
							'diperbaharui_oleh'=>$this->session->userdata('username'),
							'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
						);
						$i++;
					}elseif ($row->status_pihak_id==5) {
						$data_update[$i] = array(
							'perkara_id' => $perkaraid,
							'pihak_id' => $row->pihak_id,
							'status_pihak_id' => 3,
							'status_pihak_text' => 'Termohon',
							'diperbaharui_oleh'=>$this->session->userdata('username'),
							'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
						);
						$i++;
					}
				}
			}

			$result = $this->keberatan_m->update_pihak_keberatan($data_update);
			
			if($result){
				echo json_encode(array('st'=>1,'msg'=>'Tambah Data Pihak Pemohonan Keberatan Berhasil Disimpan '));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Data Permohonan Keberatan Tidak Berhasil Disimpan '));
				return;
			}
		}
	}

	function f_validate_input_edit(){
		if(empty($_POST)){
			show_404();
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$perkaraid = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($perkaraid) OR intval($perkaraid)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		

		$this->form_validation->set_rules('tgl_pendaftaran_keberatan', 'Tanggal Pendaftaran Keberatan', 'trim|required|xss_clean');

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$this->load->model('keberatan/keberatan_m');
			$perkaraid = ($this->encrypt->decode(base64_decode($this->input->post('enc', TRUE))));
			$tgl_putusan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_putusan', TRUE));
			$tgl_pendaftaran_keberatan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pendaftaran_keberatan', TRUE));
			if ($tgl_pendaftaran_keberatan<$tgl_putusan){
				echo json_encode(array('st'=>0,'msg'=>'Tanggal Pendaftaran Tidak Boleh sebelum Tanggal Putusan'));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tgl_pendaftaran_keberatan);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pendaftaran Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$data_pihak = array();
			$data_termohon = array();
			$parapihakkeberatan = '';
			$pihak1_list = $this->input->post('para_pihak1',TRUE);
			if(!empty($pihak1_list)){
				$i=0;
				foreach ($pihak1_list as $key) {
					$urutan = $this->input->post('pihak_'.$key,TRUE);
					$pihakdetil = $this->keberatan_m->get_info_pihak($key);
					if($pihakdetil->num_rows>0){
						foreach ($pihakdetil->result() as $row) {
							$nama = $row->nama;
							$alamat = $row->alamat;
						}
					}else{
						echo json_encode(array('st'=>0,'msg'=>'Informasi Pihak Pemohon Tidak Ditemukan'));
						return;
					}
					
					if(empty($urutan) OR intval($urutan)<1){
						echo json_encode(array('st'=>0,'msg'=>'Mohon Memilih Urutan Pemohon '.$nama));
						return;
					}
					
					$data_pihak[$i] = array(
						'perkara_id' => $perkaraid,
						'pihak_id' => $key,
						'tanggal_permohonan' => $tgl_pendaftaran_keberatan,
						'urutan_keberatan' => $urutan,
						'status_pihak_id' => 1,
						'status_pihak_text' => 'Pemohon',
						'pihak_asal' => 1,
						'pihak_asal_text' => 'Penggugat',
						'nama' => $nama,
						'alamat' => $alamat,
						'diinput_oleh'=>$this->session->userdata('username'),
						'diinput_tanggal'=>date('Y-m-d H:i:s')
						);
					$i++;
					$parapihakkeberatan .= 'Pemohon Ke-'.$i.'. '.$nama.' (Penggugat)</br>';
				}
			}else{
				$parapihak = $this->keberatan_m->get_para_pihak($perkaraid,1);
				if($parapihak->num_rows>0){
					$i=0;
					foreach ($parapihak->result() as $row) {
						$data_termohon[$i] = array(
							'perkara_id' => $perkaraid,
							'pihak_id' => $row->pihak_id,
							'urutan_keberatan' => ($i+1),
							'status_pihak_id' => 3,
							'status_pihak_text' => 'Termohon',
							'pihak_asal' => 1,
							'pihak_asal_text' => 'Penggugat',
							'nama' => $row->nama,
							'alamat' => $row->alamat,
							'diinput_oleh'=>$this->session->userdata('username'),
							'diinput_tanggal'=>date('Y-m-d H:i:s')
						);
						$i++;
					}
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Data Para Pihak Tidak ditemukan, Please refresh your browser'));
					return;
				}
			}

			$pihak2_list = $this->input->post('para_pihak2',TRUE);
			if(!empty($pihak2_list)){
				$i=0;
				foreach ($pihak2_list as $key) {
					$urutan = $this->input->post('pihak_'.$key,TRUE);
					$pihakdetil = $this->keberatan_m->get_info_pihak($key);
					if($pihakdetil->num_rows>0){
						foreach ($pihakdetil->result() as $row) {
							$nama = $row->nama;
							$alamat = $row->alamat;
						}
					}else{
						echo json_encode(array('st'=>0,'msg'=>'Informasi Pihak Pemohon Tidak Ditemukan'));
						return;
					}
					
					if(empty($urutan) OR intval($urutan)<1){
						echo json_encode(array('st'=>0,'msg'=>'Mohon Memilih Urutan Pemohon '.$nama));
						return;
					}
					
					$data_pihak[$i] = array(
						'perkara_id' => $perkaraid,
						'pihak_id' => $key,
						'tanggal_permohonan' => $tgl_pendaftaran_keberatan,
						'urutan_keberatan' => $urutan,
						'status_pihak_id' => 1,
						'status_pihak_text' => 'Pemohon',
						'pihak_asal' => 2,
						'pihak_asal_text' => 'Tergugat',
						'nama' => $nama,
						'alamat' => $alamat,
						'diinput_oleh'=>$this->session->userdata('username'),
						'diinput_tanggal'=>date('Y-m-d H:i:s')
						);
					$i++;
					$parapihakkeberatan .= 'Pemohon Ke-'.$i.'. '.$nama.' (Tergugat)</br>';
				}
			}else{
				$parapihak = $this->keberatan_m->get_para_pihak($perkaraid,2);
				if($parapihak->num_rows>0){
					$i=0;
					foreach ($parapihak->result() as $row) {
						$data_termohon[$i] = array(
							'perkara_id' => $perkaraid,
							'pihak_id' => $row->pihak_id,
							'urutan_keberatan' => ($i+1),
							'status_pihak_id' => 3,
							'status_pihak_text' => 'Termohon',
							'pihak_asal' => 2,
							'pihak_asal_text' => 'Tergugat',
							'nama' => $row->nama,
							'alamat' => $row->alamat,
							'diinput_oleh'=>$this->session->userdata('username'),
							'diinput_tanggal'=>date('Y-m-d H:i:s')
						);
						$i++;
					}
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Data Para Pihak Tidak ditemukan, Please refresh your browser'));
					return;
				}
			}

			$data = array(
					'perkara_id'=>$perkaraid, 
					'tanggal_pendaftaran_keberatan'=>$tgl_pendaftaran_keberatan,
					'pemohon_keberatan'=>$parapihakkeberatan,
					'diperbaharui_oleh'=>$this->session->userdata('username'),
					'diperbaharui_tanggal'=>date('Y-m-d H:i:s')
				);
			$tahapan_id=17;$tahapan_nama='Keberatan';$proses_id=281;$proses_nama='Pendaftaran Keberatan';$tanggal=$tgl_pendaftaran_keberatan;
			$result = $this->keberatan_m->edit_keberatan($perkaraid, $data, $tahapan_id, $tahapan_nama, $proses_id, $proses_nama, $tanggal);
			$result = $this->keberatan_m->add_pihak_keberatan($perkaraid,$data_pihak,$data_termohon);
			
			if($result==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'DATA Berhasil Disimpan'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'DATA Tidak Berhasil Disimpan'));
				return;
			}
		}	
	}

	function validatePost(){
		$this->load->library('SIPPFileHelper');
		$nomor_perkara = ($this->input->post('nomor_perkara'));
		$perkara_id = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		$splitnoperkara=explode("/",$nomor_perkara);
		$arr = explode("/", $nomor_perkara);
		$tgldaftar = $this->tanggalhelper->getTanggalPendaftaran($perkara_id);

		$splittgldaftar=explode("-",$tgldaftar);
		$direktori="resources/file/doc/".$splittgldaftar[0]."/".$splittgldaftar[1]."/";
		@mkdir($direktori,0755,true);

		$namafile = $_FILES['edoc_amar_putusan']['name'];
		$extension=pathinfo($namafile);
		$extension=$extension['extension'];
		$fileName=$splitnoperkara[3]."_".$splitnoperkara[2]."_".$splitnoperkara[1]."_".$splitnoperkara[0]."_putusan_keberatan.".$extension;

		$uploaddir = $direktori;
		$this->load->model('keberatan/keberatan_m');
		$q=("update perkara_keberatan set amar_putusan_keberatan_dok='".$fileName."' where perkara_id='".$perkara_id."';");
		$this->keberatan_m->exec_simple_query($q);

		$uploadfile = $uploaddir . $fileName;

		$isOK = $this->sippfilehelper->isAcceptableFile($uploadfile);

		if($isOK==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'File Format E-Document Tidak Diizinkan. System Hanya Mengizinkan File dengan Format: Ms. Word, PDF, RTF, PNG.\n'));
			return;
		}
		if (move_uploaded_file($_FILES['edoc_amar_putusan']['tmp_name'], $uploadfile)) {
			chmod($direktori, 0755);
			chmod($uploadfile, 0644);
		    echo json_encode(array('st'=>1,'msg'=>'File is valid, and was successfully uploaded.'));
			return;
		} else {
			chmod($direktori, 0755);
		    echo json_encode(array('st'=>0,'msg'=>'Gagal Melakukan Upload!\n'));
			return;
		}
	}

	function validateDelete(){
		if(empty($_POST)){
			show_404();
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$this->load->model('keberatan/keberatan_m','keberatan');
		$delData = $this->keberatan->deleteData($idperkara);
		if($delData){
			echo json_encode(array('st'=>1,'msg'=>'Permohonan keberatan Berhasil DiHapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Gagal.'));
			return;
		}
	}

	function validateTanggalPermohonan(){
		if(empty($_POST)){
			show_404();
		}
	}
}