<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class AddArsip_c extends CI_Controller {
	function index(){
		$this->load->model('arsip/arsip_m', 'arsip');
		$data['previous'] = $this->nativesession->get_flash_session('url_requested');
		$data['today']=date('d/m/Y');		
		$data['enc']='';
		$data['no_ruang']='';
		$data['no_lemari']='';
		$data['no_rak']='';
		$data['no_berkas']='';
		$data['nomor_arsip']='';
		$data['perkara_id']='';
		$data['nomor_perkara']='';
		$data['tanggal_masuk_arsip']=date('d/m/Y');
		$data['nama_penerima']='';
		$data['nama_penyerah']='';
		$data['status']=0;
		$data['keterangan']='';
		$data['act']='add';
		$data['edoc_arsip']='';
		$this->load->view('arsip_list/form_arsip_v',$data);
	}

	function edit_detail($enc){
		$this->load->model('arsip/arsip_m', 'arsip');

		$segment = $this->uri->segment_array();
		$arsip_id=$this->encrypt->decode(base64_decode($this->uri->segment(3)));
		$data['enc']=$this->uri->segment(3);
		$arsip_detail=$this->arsip->get_arsip_detail($arsip_id);
		$data['no_ruang']=$arsip_detail->no_ruang;
		$data['no_lemari']=$arsip_detail->no_lemari;
		$data['no_rak']=$arsip_detail->no_rak;
		$data['no_berkas']=$arsip_detail->no_berkas;
		$data['nomor_arsip']=$arsip_detail->nomor_arsip;
		$data['perkara_id']=$arsip_detail->perkara_id;
		$data['nomor_perkara']=$arsip_detail->nomor_perkara;
		$data['tanggal_masuk_arsip']=$arsip_detail->tanggal_masuk_arsip;
		$data['nama_penerima']=$arsip_detail->nama_penerima;
		$data['nama_penyerah']=$arsip_detail->nama_penyerah;
		$data['status']=$arsip_detail->status;
		$data['keterangan']=$arsip_detail->keterangan;
		$data['today']=date('d/m/Y');
		$data['act']='edit';
		$no_ruang = str_replace(' ', '_', $data['no_ruang']);
		$no_lemari = str_replace(' ', '_', $data['no_lemari']);
		$no_rak = str_replace(' ', '_', $data['no_rak']);
		$no_berkas = str_replace(' ', '_', $data['no_berkas']);
		$nomor_perkara=trim($data['nomor_perkara']);
		$nomor_perkara=str_replace("/", "_", $nomor_perkara);
		$nomor_perkara = str_replace(' ', '_', $nomor_perkara);
		$nomor_perkara=str_replace(".", "_", $nomor_perkara);
		$filename="dokumen_arsip/".$no_ruang."/".$no_lemari."/".$no_rak."/".$no_berkas."/Arsip_".$nomor_perkara.".*";
		$data['filename']=$filename;
		$data['edoc_arsip']=glob ($filename);
		$this->load->view('arsip_list/form_arsip_v',$data);	
	}

	function add_pinjaman($arsip_id){
		$this->load->model('arsip/arsip_m', 'arsip');
		$data['today']=date('d/m/Y');
		$data['tanggal_pinjam']=date('d/m/Y');
		$data['tanggal_kembali']=date('d/m/Y');
		$data['petugas_peminjam']='';
		$data['lama_hari']=0;
		$data['keterangan']='';
		$data['enc']=$this->uri->segment(3);
		$data['enc_pjm']=0;
		$data['act']='add';
		$this->load->view('arsip_list/form_pinjaman_v',$data);
	}

	function edit_pinjaman(){
		$this->load->model('arsip/arsip_m', 'arsip');
		$data['enc']=$this->uri->segment(3);
		$data['enc_pjm']=$this->uri->segment(4);
		$arsip_id=$this->encrypt->decode(base64_decode($data['enc']));
		$pinjaman_id=$this->encrypt->decode(base64_decode($data['enc_pjm']));
		$data['today']=date('d/m/Y');
		$res=$this->arsip->get_riwayat_peminjaman($arsip_id, $pinjaman_id);
		$pinjaman_detail=$res[0];
		$data['tanggal_pinjam']=($pinjaman_detail->tanggal_pinjam);
		$data['tanggal_kembali']=($pinjaman_detail->tanggal_kembali);
		$data['petugas_peminjam']=$pinjaman_detail->petugas_peminjam;
		$data['lama_hari']=($data['tanggal_kembali']=='0000-00-00' OR $data['tanggal_kembali']=='' OR empty($data['tanggal_kembali']))?"-":(floor(strtotime($data['tanggal_kembali'])-strtotime($data['tanggal_pinjam']))/(60*60*24));
		$data['keterangan']=$pinjaman_detail->keterangan;

		$data['act']='edit';
		$this->load->view('arsip_list/form_pinjaman_v',$data);
	}
}