<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class New_PK extends CI_Model{
	
	function getJenisPerkara($idalurperkara){
		if(empty($idalurperkara)) return 'ERROR';
		try {
			$this->db->where('id',$idalurperkara);
			$result = $this->db->get('alur_perkara');
			if($result->num_rows>0){
				return $result->row()->nama;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return 'ERROR';
		}
	}

	function getTanggalPutusan($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->select('tanggal_putusan,tanggal_cabut');
			return $this->db->get('perkara_putusan');
		} catch (Exception $e) {
			return '';
		}
	}

	function getPermohonanBandingPihak($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->select('permohonan_pk');
			return $this->db->get('perkara_pk_detil');
		} catch (Exception $e) {
			return '';
		}
	}

	function getInfoPutusan($nomorperkara){
		try {
			$this->db->where('nomor_perkara',$nomorperkara);
			$this->db->select('tanggal_putusan,perkara_id,alur_perkara_id,tanggal_bht');
			return $this->db->get('v_perkara');
		} catch (Exception $e) {
			return '';
		}
	}

	function getPihak($idperkara,$pihakke){
		try {
			return $this->db->query('SELECT p.pihak_id, p.nama,p.alamat, 
				permohonan_pk,status_pihak_id,pihak_asal,
				status_pihak_text,urutan_pk AS urutan
				FROM perkara_pihak'.$pihakke.' AS p
				LEFT JOIN perkara_pk_detil AS b
				ON p.pihak_id = b.pihak_id AND b.perkara_id='.$idperkara.' 
				WHERE p.perkara_id = '.$idperkara.'
				ORDER BY permohonan_pk;');
		} catch (Exception $e) {
			return '';
		}
	}

	function getPemohon($idpihak){
		try {
			$this->db->where('id',$idpihak);
			$this->db->select('id,nama,alamat,pekerjaan');
			return $this->db->get('pihak');
		} catch (Exception $e) {
			return '';
		}
	}


	function getNomorPerkara($idperkara){
		try {
			$query = $this->db->query("SELECT nomor_perkara FROM perkara WHERE perkara_id = ".$idperkara);
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					return $row->nomor_perkara;
				}
	    	}else{
	    		return 0;
	    	}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getTanggalBanding($idperkara){
		try {
			$query = $this->db->query("SELECT putusan_banding FROM perkara_banding WHERE perkara_id = ".$idperkara);
			if($query->num_rows==1){
				foreach ($query->result() as $row) {
					return $row->putusan_banding;
				}
	    	}else{
	    		return 0;
	    	}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getTanggalKasasi($idperkara){
		try {
			$query = $this->db->query("SELECT putusan_kasasi FROM perkara_kasasi WHERE perkara_id = ".$idperkara);
			if($query->num_rows==1){
				foreach ($query->result() as $row) {
					return $row->putusan_kasasi;
				}
	    	}else{
	    		return 0;
	    	}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getStatusPihak($idalurperkara){
		try {
			$this->db->where('tahapan_id',10);
			$this->db->where('aktif','Y');
			$this->db->where('alur_perkara_id',$idalurperkara);
			$this->db->select('pihak_ke,nama');
			return $this->db->get('status_pihak');
		} catch (Exception $e) {
			return '';
		}
	}

	function getBiayaPerkara($idalurperkara,$idtahapan){
		if(empty($idalurperkara)) return '';
		if($idtahapan<10) return '';
		try {
			return $this->db->query("SELECT id, kode,nama,b.jumlah 
				FROM biaya_perkara AS b, jenis_biaya AS j
				WHERE b.jenis_biaya_id = j.id AND b.alur_perkara_id IN (".$idalurperkara.") AND tahapan_id = 40 AND id IN (64,200);");
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	
	
	function isPerkaraExist($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->select('perkara_id');
			$query = $this->db->get('perkara_pk');
			if($query->num_rows>0){
				return TRUE;
			}else{
				return FALSE;
			}
		} catch (Exception $e) {
			log_message('error', $e);
			return -1;
		}
	}

	

	function getJenisPerkaraNama($id){
		if(empty($id)) return '';
		try {
			$this->db->where('id',$id);
			$this->db->select('kode,nama,nama_lengkap');
			return $this->db->get('jenis_perkara');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}

	function add_audittrail($action,$title,$descrip,$tablename){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => 'Add Perkara Perdata',
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			
		}
	}

	function update_data($datapihak){
		try {
			foreach ($datapihak as $data) {
				$this->db->where('perkara_id',$data['perkara_id']);
				$this->db->where('pihak_id', $data['pihak_id']);
				$this->db->update('perkara_pk_detil', $data['pihak']);
			}
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function insertNewData($datapihak){
		try {
			foreach ($datapihak as $data) {
				$this->db->insert('perkara_pk_detil', $data);
			}
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function addDataKeuangan($datakeuangan,$nomorperkara){
		try {
			foreach ($datakeuangan as $data) {
				$id = $this->db->query("SELECT IFNULL(max(id)+1,1) as id FROM perkara_biaya;")->row()->id;
				if($id>0){
					$data['id'] = $id;
					$this->db->insert('perkara_biaya', $data);
				}
			}
			$title = "Tambah Data Keuangan Perkara [Nomor Perkara=<b>".$nomorperkara."</b>]<br />Tambah table <b>Perkara_Biaya</b> dari halaman <b>Jurnal Keuangan Perkara</b> dengan Primary Key [perkara_id=".$data['perkara_id']."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("INSERT",$title,$descrip,'perkara_biaya');
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function add_data($data,$datakeuangan,$datapihak){
		try {
			$this->db->insert('perkara_pk', $data);
			$title = "Tambah Data Permohonan PK [Nomor Perkara=<b>".$data['nomor_perkara_pn']."</b>]<br />Tambah table <b>perkara_pk</b> dari halaman <b>Permohonan PK</b> dengan Primary Key [perkara_id=".$data['perkara_id']."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("INSERT",$title,$descrip,'perkara_pk');
			$nomor_perkara_pn = $data['nomor_perkara_pn'];
			$pemohon = $data['pemohon_pk'];
			if($data['alur_perkara_id']<100){
				foreach ($datakeuangan as $data) {
					$id = $this->db->query("SELECT IFNULL(max(id)+1,1) as id FROM perkara_biaya;")->row()->id;
					if($id>0){
						$data['id'] = $id;
						$this->db->insert('perkara_biaya', $data);
					}
					$tanggal = $data['tanggal_transaksi'];
				}
				$title = "Tambah Data Keuangan Perkara [Nomor Perkara=<b>".$nomor_perkara_pn."</b>]<br />Tambah table <b>Perkara_Biaya</b> dari halaman <b>Jurnal Keuangan Perkara</b> dengan Primary Key [perkara_id=".$data['perkara_id']."]";
				$descrip = $this->fetch_description($title,$data);
				$this->add_audittrail("INSERT",$title,$descrip,'perkara_biaya');
			}else{
				$tanggal = $data['permohonan_pk'];
			}
			
			foreach ($datapihak as $data) {
				if($data['status_pihak_id']==1 AND $data['pihak_diwakili']=='Y'){
					$data['pemohon_pk'] = $pemohon;
				}
				$this->db->insert('perkara_pk_detil', $data);
			}
			$this->db->simple_query("CALL perkara_proses_update(".$data['perkara_id'].", 40, 'Peninjauan Kembali', 510, 'Permohonan PK', '".$tanggal."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			$this->db->simple_query("CALL perkara_update_status(".$data['perkara_id'].");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function updatePerkaraStatus($idperkara){
		try {
			$this->db->query('UPDATE perkara SET tahapan_terakhir_id = 40,tahapan_terakhir_text = "Peninjauan Kembali",
				proses_terakhir_id = 510,proses_terakhir_text = "Permohonan PK" WHERE perkara_id ='.$idperkara);
		} catch (Exception $e) {
			
		}
	}

}