<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
#07-10-2015
class Pemeriksaan_persiapan extends CI_Controller {

	function konfirmasiHapusPemeriksaan(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc'] = $segment[2];
		$IDPerkara = $this->encrypt->decode(base64_decode($segment[2]));
		if(empty($IDPerkara) OR intval($IDPerkara)<1){
			show_404();
		}

		$this->load->vars($data);
		$this->load->view('perkara/hapus_pemeriksaan_persiapan');
	}


	function hapusPemeriksaan(){
		try {
			if(empty($_POST)){ show_404(); }
			if($this->session->userdata('is_logged_in')==FALSE){
				echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
				return;
			}

			$IDPerkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			if(!is_numeric($IDPerkara) OR intval($IDPerkara)<1){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
				return;
			}

			$this->load->model('perkara/pemeriksaan_persiapan_m','perkara');
			$this->perkara->hapusPemeriksaan($IDPerkara);
			$this->db->simple_query("CALL perkara_proses_delete(".$IDPerkara.",42);");
			$this->db->simple_query("CALL perkara_update_status(".$IDPerkara.");");
			if($this->perkara->hapusPemeriksaanProses($IDPerkara)){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Dihapus.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Gagal Melakukan Penghapusan Data Pemeriksaan Persiapan.'));
				return;
			}
		} catch (Exception $e) {
			
		}

	}

	
	function hapusPemeriksaanProses(){
		if(empty($_POST)){ show_404(); }
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$this->load->model('perkara/pemeriksaan_persiapan_m','perkara');


		$IDPerkara = $this->encrypt->decode(base64_decode($this->input->post('IDPerkara')));
		if(!is_numeric($IDPerkara) OR !intval($IDPerkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$IDPemeriksaanProses = $this->encrypt->decode(base64_decode($this->input->post('IDPersiapanProses')));
		if(!is_numeric($IDPemeriksaanProses) OR !intval($IDPemeriksaanProses)>0){
			echo json_encode(array('st'=>0,'msg'=>'Jadwal Pemeriksaan Tidak Ditemukan.'));
			return;
		}
		
		if($this->perkara->hapusDataPersiapanProses($IDPemeriksaanProses)){
			echo json_encode(array('st'=>1,'msg'=>'Berhasil Dihapus'));
		} else {
			echo json_encode(array('st'=>0,'msg'=>'Database Error'));
		}
	}
	

	function tunda_pemeriksaan_proses(){
		$IDperkara = $this->encrypt->decode(base64_decode($this->nativesession->get_flash_session('enc')));
		$IDPersiapanProses = $this->nativesession->get_flash_session('IDPersiapanProses');
		$this->load->model('perkara/pemeriksaan_persiapan_m','perkara');
		$urutanKU = $this->perkara->getUrutanProses($IDperkara);
		foreach($urutanKU->result() as $row){
			$data['urutanBaru'] = $row->urutan+1;
		}
		$dataPemeriksaanProses = $this->perkara->getPerkaraPersiapanProses($IDPersiapanProses,$IDperkara);
		foreach($dataPemeriksaanProses->result() as $row){
			$data['IDPersiapanProses'] = base64_encode($this->encrypt->encode($row->id));
			$data['IDPerkara'] = base64_encode($this->encrypt->encode($row->perkara_id));
			$data['urutan'] = $row->urutan;
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($row->tanggal_musyawarah);
			$data['tanggal_sebelumnya'] = $this->tanggalhelper->convertDayDate($row->tanggal_musyawarah);
			$data['agenda'] = $row->agenda_musyawarah;
			$data['waktu'] = substr($row->waktu_musyawarah,0,5);
            $data['dihadiri_oleh'] = $row->dihadiri_oleh;
			$data['keterangan'] = $row->keterangan;
		}
		$this->load->vars($data);
		$this->load->view('perkara_tab/pemeriksaan_persiapan/pemeriksaan_proses_tunda');
	}


	function validateTundaPemeriksaanPersiapan(){
		if(empty($_POST)){ show_404(); }
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$this->load->model('perkara/pemeriksaan_persiapan_m','perkara');

        $this->form_validation->set_rules('agendasblm', 'Agenda Proses Pemeriksaan Persiapan', 'trim|required|xss_clean');		
		$this->form_validation->set_rules('tgl_sidang', 'Tanggal Proses Pemeriksaan Persiapan', 'trim|required|exact_length[10]|xss_clean');
		$this->form_validation->set_rules('waktu_pelaksanaan', 'Waktu Proses Pemeriksaan Persiapan', 'trim|required|xss_clean');
		$this->form_validation->set_rules('agenda', 'Agenda Proses Pemeriksaan Persiapan', 'trim|required|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$this->load->model('perkara/pemeriksaan_persiapan_m','perkara');
			$IDPersiapanProsesLama = $this->encrypt->decode(base64_decode($this->input->post('IDPersiapanProsesLama')));
			$IDperkara = $this->encrypt->decode(base64_decode($this->input->post('IDPerkara')));
			$urutanBaru = $this->input->post('urutanBaru');
			$tanggal = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_sidang'));
			$waktu = $this->input->post('waktu_pelaksanaan');
			$agenda = trim($this->input->post('agenda'));
			$keterangan = trim($this->input->post('keterangan'));
			$agendaLama = trim($this->input->post('agendasblm'));
			$dihadiri_oleh = $this->input->post('dihadiri_oleh');

			$dataUpdateLama = array(
				'agenda_musyawarah'=> $agendaLama,
				'dihadiri_oleh' => $dihadiri_oleh,
				'diperbaharui_oleh'=> $this->session->userdata('username'),
				'diperbaharui_tanggal'=> date("Y-m-d h:i:s",time())
				);

			$dataBaru = array(
				'perkara_id'=> $IDperkara,
				'urutan'=> $urutanBaru,
				'tanggal_musyawarah'=> $tanggal,
				'agenda_musyawarah'=> $agenda,
				'waktu_musyawarah'=> $waktu,
				'keterangan'=> $keterangan,
				'diinput_oleh' => $this->session->userdata('username'),
				'diinput_tanggal' => date("Y-m-d h:i:s",time())
				);


			$this->perkara->updatePerkaraPersiapanProses($IDperkara,$IDPersiapanProsesLama,$dataUpdateLama);
			if($this->perkara->addPemeriksaanProses($dataBaru)){
				echo json_encode(array('st'=>1,'msg'=>'Berhasil Disimpan'));
			} else {
				echo json_encode(array('st'=>0,'msg'=>'Database Error'));
			}
		}
	}






	function edit_pemeriksaan_proses(){
		$IDperkara = $this->encrypt->decode(base64_decode($this->nativesession->get_flash_session('enc')));
		$IDPersiapanProses = $this->nativesession->get_flash_session('IDPersiapanProses');
		$this->load->model('perkara/pemeriksaan_persiapan_m','perkara');
		$pemeriksaanPersiapan = $this->perkara->getPemeriksaanPersiapan($IDperkara);
		foreach ($pemeriksaanPersiapan->result() as $row){
			$data['tanggalPenetapanPemeriksaan'] = $this->tanggalhelper->convertToInputDate($row->tanggal_penetapan_persiapan);
		}

		$dataPemeriksaanProses = $this->perkara->getPerkaraPersiapanProses($IDPersiapanProses,$IDperkara);
		foreach($dataPemeriksaanProses->result() as $row){
			$data['IDPersiapanProses'] = base64_encode($this->encrypt->encode($row->id));
			$data['IDPerkara'] = base64_encode($this->encrypt->encode($row->perkara_id));
			$data['urutan'] = $row->urutan;
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($row->tanggal_musyawarah);
			$data['agenda'] = $row->agenda_musyawarah;
			$data['waktu'] = substr($row->waktu_musyawarah,0,5);
			$data['dihadiri_oleh'] = $row->dihadiri_oleh;
			$data['keterangan'] = $row->keterangan;
		}
		$this->load->vars($data);
		$this->load->view('perkara_tab/pemeriksaan_persiapan/pemeriksaan_proses_edit');
	}

	function validateEditPemeriksaanPersiapan(){
		if(empty($_POST)){ show_404(); }
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		
		$this->form_validation->set_rules('tgl_musyawarah', 'Tanggal Proses Pemeriksaan Persiapan', 'trim|required|exact_length[10]|xss_clean');
		$this->form_validation->set_rules('waktu_pelaksanaan', 'Waktu Proses Pemeriksaan Persiapan', 'trim|required|xss_clean');
		$this->form_validation->set_rules('agenda', 'Agenda Proses Pemeriksaan Persiapan', 'trim|required|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$this->load->model('perkara/pemeriksaan_persiapan_m','perkara');
			$IDperkara = $this->encrypt->decode(base64_decode($this->input->post('IDPerkara')));
			$IDPersiapanProses = $this->encrypt->decode(base64_decode($this->input->post('IDPersiapanProses')));
			$tanggal = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_musyawarah'));
			$waktu = $this->input->post('waktu_pelaksanaan');
			$agenda = trim($this->input->post('agenda'));
			$keterangan = trim($this->input->post('keterangan'));
			$dihadiri_oleh = trim($this->input->post('dihadiri_oleh'));

			$data = array(
				'tanggal_musyawarah'=> $tanggal,
				'agenda_musyawarah'=> $agenda,
				'waktu_musyawarah'=> $waktu,
				'dihadiri_oleh' => $dihadiri_oleh,
				'keterangan'=>$keterangan,
				'diperbaharui_oleh'=> $this->session->userdata('username'),
				'diperbaharui_tanggal'=> date("Y-m-d h:i:s",time())
			);

			
			if($this->perkara->updatePerkaraPersiapanProses($IDperkara,$IDPersiapanProses,$data)){
				echo json_encode(array('st'=>1,'msg'=>'Berhasil Disimpan'));
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Database Error'));
			}	
		}
	}


	function show_pemeriksaan(){
		$idperkara = $this->nativesession->get_flash_session('perkara_id');
		$this->load->model('perkara/pemeriksaan_persiapan_m', 'perkara');
		$data['tanggalPendaftaran'] = $this->perkara->getTanggalPendaftaran($idperkara);
		$data['curr_date'] = date('d/m/Y');
		$data['enc'] = base64_encode($this->encrypt->encode($idperkara));
		$this->load->vars($data);
		$this->load->view('perkara_tab/pemeriksaan_persiapan/pemeriksaan_persiapan_show');
	}

	function edit_pemeriksaan(){
		$idperkara = $this->nativesession->get_flash_session('perkara_id');
		$this->load->model('perkara/pemeriksaan_persiapan_m', 'perkara');
		$pemeriksaanPersiapan = $this->perkara->getPemeriksaanPersiapan($idperkara);
		foreach ($pemeriksaanPersiapan->result() as $row){
			$data['tanggalPenetapanPemeriksaan'] = $this->tanggalhelper->convertToInputDate($row->tanggal_penetapan_persiapan);
			$data['petitum'] = $row->petitum;
		}

		$data['tanggalPendaftaran'] = $this->perkara->getTanggalPendaftaran($idperkara);

		$data['curr_date'] = date('d/m/Y');
		$data['enc'] = base64_encode($this->encrypt->encode($idperkara));
		
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '850px';
		$this->ckeditor->config['height'] = '250px';

		$this->load->vars($data);
		$this->load->view('perkara_tab/pemeriksaan_persiapan/pemeriksaan_persiapan_edit');
		
	}

	
	function validatePemeriksaanEdit(){
		if(empty($_POST)){ show_404(); }
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$this->load->model('perkara/pemeriksaan_persiapan_m','perkara');
		$this->form_validation->set_rules('tgl_penetapan', 'Tanggal Penetapan', 'trim|required|exact_length[10]|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		} else {
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
			$tanggalPenetapan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_penetapan'));
			$petitum = trim($this->input->post('petitum_text',TRUE));
			$petitum = str_replace("&nbsp;", " ", $petitum);

			if(strlen($petitum)<50){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Boleh kurang dari 50 Karakter'));
				return;
			} else {
				$dataProses = array(
					'tanggal_penetapan_persiapan' => $tanggalPenetapan,
					'petitum' => $petitum,
					'diperbaharui_oleh' => $this->session->userdata('username'),
					'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
				);

				if($this->perkara->updatePemeriksaanPersiapan($idperkara,$dataProses)){
					echo json_encode(array('st'=>1,'msg'=>'Berhasil Disimpan'));
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Database Error'));
				}	
			}
		}

	}

	function validatePemeriksaan(){
		if(empty($_POST)){ show_404(); }
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$this->load->model('perkara/pemeriksaan_persiapan_m', 'perkara');
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		$this->form_validation->set_rules('tgl_penetapan', 'Tanggal Penetapan', 'trim|required|exact_length[10]|xss_clean');
		$this->form_validation->set_rules('tgl_sidang_pertama', 'Tanggal Musyawarah Pertama', 'trim|required|exact_length[10]|xss_clean');
		$this->form_validation->set_rules('jam_sidang_pertama', 'Waktu Musyawarah Pertama', 'trim|required|exact_length[5]|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			$tanggal_penetapan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_penetapan'));
			$tanggal_sidang_pertama = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_sidang_pertama'));
			$waktu_sidang_pertama = $this->input->post('jam_sidang_pertama');
			$dataPersiapan = array(
				'perkara_id' => $idperkara,
				'petitum' => '',
				'tanggal_penetapan_persiapan' => $tanggal_penetapan,
				'diinput_oleh' => $this->session->userdata('username'),
				'diinput_tanggal' => date("Y-m-d h:i:s",time())
			);

			$dataProses = array(
				'perkara_id' => $idperkara,
				'tanggal_musyawarah' => $tanggal_sidang_pertama,
				'urutan' => '1',
				'agenda_musyawarah' => 'Pemeriksaan Persiapan',
				'waktu_musyawarah' => $waktu_sidang_pertama,
				'diinput_oleh' => $this->session->userdata('username'),
				'diinput_tanggal' => date("Y-m-d h:i:s",time())
			);

			$this->perkara->addPemeriksaanPersiapan($dataPersiapan,$tanggal_penetapan,$idperkara);
			
			if($this->perkara->addPemeriksaanProses($dataProses)){
				echo json_encode(array('st'=>1,'msg'=>'Berhasil Disimpan'));
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Database Error'));
			}	

		}
		
	}


	
}
