<?php
function parse_day_to_year($vonis){
	$result = array();
	$month = (int)($vonis/30);
	$year = (int) ($month/12);
	$month = (int) ($month%12);
	$total = (int)($year*12*30+$month*30);
	$day = intval($vonis-$total);
	$result['year'] = $year;
	$result['month'] = $month;
	$result['day'] = $day;
	return $result;
}
function fetchStatusPutusanText($data,$idpihak){
	$status ='';
	foreach ($data->result() as $row) {
		if($row->id==$idpihak){
			$satuan = $row->satuan;
			$infohukuman = '';
			if($satuan==1){
				$infohukuman = parse_day_to_year($row->durasi_nominal);
				$year = '';$month = '';$day = '';
				if(!empty($infohukuman['year'])){
					$year = $infohukuman['year'].' Tahun ';
				}
				if(!empty($infohukuman['month'])){
					$month = $infohukuman['month'].' Bulan ';
				}
				if(!empty($infohukuman['day'])){
					$day = $infohukuman['day'].' Hari';
				}
				$infohukuman = '('.$year.$month.$day.')';
			}elseif($satuan==2 && ($row->status_putusan_id)!=68){
				$infohukuman = 'Rp.'.number_format($row->durasi_nominal,2,',','.');
			}else{
				$infohukuman = (!empty($row->durasi_nominal))? '('.$row->durasi_nominal.')':'';
			}
			$status .= $row->status_putusan_text.' '.$infohukuman.'<br>';
		}
	}
	return $status;
}
if($putusan !=''){
	if($putusan->num_rows>0){
		foreach ($putusan->result() as $row) {
			$tanggal_putusan = $this->tanggalhelper->convertDayDate($row->tanggal_putusan);
			$tglANKUM = $this->tanggalhelper->convertDayDate($row->pemberitahuan_putusan_ankum);
			$tglPEPERA = $this->tanggalhelper->convertDayDate($row->pemberitahuan_putusan_pepera);
			$amar = $row->amar_putusan;
			$status_putusan_id = $row->status_putusan_id;
			$status_putusan_nama = $row->status_putusan_nama;
			$cektglminutasi = $row->tanggal_minutasi;
			$tanggal_minutasi = $this->tanggalhelper->convertDayDate($row->tanggal_minutasi);
			if($idalurperkara<9 OR $idalurperkara==114){				
				$verstek = $row->putusan_verstek;								
			}
			if($idalurperkara<100){
				$sumber_hukum_put = $row->sumber_hukum_nama;
			}
			$penetapan_hakim_pengawas =  $this->tanggalhelper->convertDayDate($row->penetapan_hakim_pengawas);
			$nomor_penetapan_hakim_pengawas = $row->nomor_penetapan_hakim_pengawas;
			$hakim_pengawas_nama = $row->hakim_pengawas_nama;
			$kurator_nama = $row->kurator_nama;
			$nilai_ganti_sengketa = $row->nilai_ganti_kerugian;
			$tanggal_berita_putusan = $this->tanggalhelper->convertDayDate($row->tanggal_berita_putusan);
			$tanggal_surat_kabar_putusan = $this->tanggalhelper->convertDayDate($row->tanggal_surat_kabar_putusan);
			$nama_surat_kabar_putusan = $row->nama_surat_kabar_putusan;
			$kirim_salinan_putusan_penyidik =  $this->tanggalhelper->convertDayDate($row->kirim_salinan_putusan_penyidik);
			$catatan_putusan = $row->catatan_putusan;
			$amar_putusan_dok = $row->amar_putusan_dok;
			$status_putusan_id=$row->status_putusan_id;
		}
	}
}
$isEditable = FALSE;
$canCetakDokumen = $this->authorization->HasRuleCetakDokumenPerkara($idperkara);
if($idalurperkara==2){
	$status = 'Penetapan';
}else{
	$status = 'Putusan';
}
?>
<div style="font-size:14px;">
	<table id='infoPerkara' style="font-size:14px;" border="0">
		<col width="15%">
		<col width="">
		<col width="300px">
		<col width="200px" >
		<tbody>
			<tr>
				<td id='first-child'>Tanggal <?php echo $status;?></td>
				<td><?php echo (!empty($tanggal_putusan)? $tanggal_putusan:'');?></td>
				<td style="text-align:right;">
				<?php 
					if ( $this->authorization->HasRuleEditPemberitahuanPutusan($idalurperkara, $idperkara) OR ($idalurperkara==9 AND $this->authorization->HasRuleFormHakimPanitera($idperkara))){?>
					[ <a href="#" onClick="popup_form('<?php echo base_url("add_pemberitahuan/".$enc."/update");?>')">Edit Pemberitahuan <?php echo $status;?></a> ]
				<?php } ?>
				</td>
				<td style="text-align:right;">
				<?php if ($this->authorization->HasRuleFormHakimPanitera($idperkara)){
						$isEditable = TRUE;
						$userGroup = $this->session->userdata('idgroup');
						if($userGroup==20 OR $userGroup==500 OR $userGroup==410 OR $userGroup==420 OR $userGroup==430 OR $userGroup==440 OR $userGroup==450 OR $userGroup==460 
							OR $userGroup==470 OR $userGroup==480 OR $userGroup==1000 OR $userGroup==1010 OR $userGroup==1020 OR $userGroup==1030) {
							if(empty($cektglminutasi) OR $cektglminutasi==''){
				?>
							[ <a href="#" onClick="popup_form('<?php echo base_url("add_putusan_akhir/".$enc."/update");?>')">Edit <?php echo $status;?> Akhir</a> ]
				<?php 		}
						}elseif($this->session->userdata('idgroup')==1 OR $this->session->userdata('idgroup')==10){
				?>
							[ <a href="#" onClick="popup_form('<?php echo base_url("add_putusan_akhir/".$enc."/update");?>')">Edit <?php echo $status;?> Akhir</a> ]
				<?php       }
					} ?>
				</td>
			</tr>
			<?php if($idalurperkara<100 AND $idalurperkara!=9 AND $idalurperkara!=2 OR $idalurperkara==114){ ?>
			<tr>
				<td id="first-child">Putusan Verstek</td>
				<td colspan="3"><?php echo ($verstek=='Y')? 'Ya':'Tidak';?></td>
			</tr>
			<?php }
				if($idalurperkara<100){ ?>
			<tr>
				<td id="first-child">Sumber Hukum</td>
				<td colspan="3"><?php echo (!empty($sumber_hukum_put)? $sumber_hukum_put:'');?></td>
			</tr>
			<?php } ?>
			<tr>
				<td id="first-child">Status <?php echo $status;?></td>			
				<td colspan="3">
					<?php
					if($idalurperkara>100 AND $idalurperkara!=119 AND $idalurperkara!=123){
						if($status_putusan!=''){
							if($status_putusan->num_rows>0){
					?>
					<div class="cssTable">
						<table id="tableinfo" style="margin:0px;padding:0px;">
							<col width="5%">
							<col width="55%">
							<col width="20%">
							<col width="40%">
							<tbody>
								<tr>
									<td>No</td>
									<td>Nama</td>
									<td>Tanggal Putusan</td>
									<td>Putusan</td>
								</tr>
							<?php
								$i=0;
								$repeat = True;
								$idss = 0;
								foreach ($status_putusan->result() as $rows) {
									if($idss!=$rows->id){
													$repeat = False;
													$i++;
													$idss = $rows->id;
												}else{
													$repeat = True;
												}
									if($repeat==False){
										echo "<tr>";
											$status_putusan_terdakwa = fetchStatusPutusanText($status_putusan,$rows->id);
											echo "<td>".$i."</td>";
											echo "<td>".$rows->nama."</td>";
											echo "<td>".$this->tanggalhelper->convertDayDate($rows->tanggal_putusan)."</td>";
											echo "<td>".$status_putusan_terdakwa."</td>";
										echo "</tr>";
									}
									if(empty($idss)){
										$idss = $rows->id;
									}
								}?>
							</tbody>
						</table>
					</div>
				<?php
						}
					}
				}else{
					echo $status_putusan_nama;
				}
				?>
				</td>
			</tr>
			<?php if($this->session->userdata('jenis_pengadilan')==4 AND ($this->tanggalhelper->getIDJenisPerkara($idperkara)==347 OR $this->tanggalhelper->getIDJenisPerkara($idperkara)==346) and $status_putusan_id == 62){ ?>
			<tr id="faktor_tr">
				<td id="first-child">Faktor Penyebab Perceraian</td>
				<td colspan="3"><?php echo (!empty($faktor_penyebab)? $this->templatehelper->standradnaming($faktor_penyebab):'');?></td>
			</tr>
			<?php } ?>
			<?php if($this->session->userdata('jenis_pengadilan')==4 AND ($this->tanggalhelper->getIDJenisPerkara($idperkara)==347 and $status_putusan_id == 62)){ ?>
			<tr id="keadaan_tr">
				<td id="first-child">Keadaan Istri</td>
				<td colspan="3"><?php echo (!empty($keadaan_istri)? $keadaan_istri:'');?></td>
			</tr>
			<?php } ?>
			<?php
			if($idalurperkara!=2 AND $idalurperkara<9){
			?>
				<tr>
					<td id="first-child">Nilai Ganti Kerugian (Rp.)</td>
					<td colspan="3"><?php echo (!empty($nilai_ganti_sengketa)? number_format($nilai_ganti_sengketa,0,",","."):'0');?></td>
				</tr>
			<?php
			}
			?>
			<tr>
				<td id="first-child"><?php echo $this->nativesession->getLangguage('amar');?> <?php echo $status;?></td>			
				<td colspan="3" class='wrapword'><?php echo (!empty($amar)? $amar:'');?></td>
			</tr>
			<tr>
				<td id="first-child">E-Doc <?php echo $status;?></td>	
				<td colspan="2">
				<?php 
				$pola=substr($amar_putusan_dok, 0,2);
				if($pola=='PN' or $pola=='pn'){
					$info_tgl_daftar=explode('-', $tgl_pendaftaran);
					$thn=$info_tgl_daftar[0];
					$bln=$info_tgl_daftar[1];
					$prefix='resources/file/doc/'.$thn.'/'.$bln.'/'.$amar_putusan_dok;
					$baseurl=$prefix;
				}else{
					$baseurl=$amar_putusan_dok;	
				}								
                if (($baseurl) and (file_exists($baseurl))){
                    echo "<a target='_new' href='$baseurl'>Unduh Dokumen</a>";
                }else{
                    echo "<span style='color:red;font-weight:bold'>Dokumen Belum Ada</span>";
                }
				?>
				</td>
				<?php if ($this->authorization->HasRuleFormHakimPanitera($idperkara)){
						$isEditable = TRUE;
						if($userGroup==20 OR $userGroup==500 OR $userGroup==410 OR $userGroup==420 OR $userGroup==430 OR $userGroup==440 OR $userGroup==450 OR $userGroup==460 
							OR $userGroup==470 OR $userGroup==480 OR $userGroup==1000 OR $userGroup==1010 OR $userGroup==1020 OR $userGroup==1030) {						
							if(empty($cektglminutasi) OR $cektglminutasi==''){
				?>
				<td style="text-align:right;">
					[ <a href="#" onClick="popup_form('<?php echo base_url("fileupload/".$enc."/put");?>')">Edit E-Doc</a> ]
				</td>
				<?php 		}
						}elseif($this->session->userdata('idgroup')==1 OR $this->session->userdata('idgroup')==10){
				?>
				<td style="text-align:right;">
					[ <a href="#" onClick="popup_form('<?php echo base_url("fileupload/".$enc."/put");?>')">Edit E-Doc</a> ]
				</td>
				<?php       }
					} ?>
				<?php /* if ($this->session->userdata('idgroup')==1 OR $this->session->userdata('idgroup')==10 OR $this->session->userdata('idgroup')==20){?>
				<td style="text-align:right;">
					[ <a href="#" onClick="popup_form('<?php echo base_url("fileupload/".$enc."/put");?>')">Edit E-Doc</a> ]
				</td>
				<?php }*/ ?>
			</tr>
			<?php if ($this->session->userdata('idgroup')==1 OR $this->session->userdata('idgroup')==10 OR $this->session->userdata('idgroup')==20){
			?>
			<tr>
				<td id="first-child">Cetak Dokumen <?php echo $status;?></td>			
				<td colspan="3">
			<?php if ($canCetakDokumen){ 
					if(($alur_perkara_id==='1')||($alur_perkara_id==='3')||($alur_perkara_id==='4')||($alur_perkara_id==='5')||($alur_perkara_id==='6')||($alur_perkara_id==='7')||
						($alur_perkara_id==='8')||($alur_perkara_id==='111')||($alur_perkara_id==='118')||($alur_perkara_id==='120')||($alur_perkara_id==='121')||(($alur_perkara_id==='119')&&(($status_putusan_id==='30')||($status_putusan_id==='31')||($status_putusan_id==='32'))))
					{
				?>
                    <span class="custom-dropdown custom-dropdown--emerald">
                    <select onchange="pilih_cetak(this)" style="width:200px;z-index:99999" class="custom-dropdown__select custom-dropdown__select--white">
                    <option value='1'>Pilih Dokumen <?php echo $status;?></option>
                    <?php
                    if ($alur_perkara_id==='111')
					{
                    ?>
						<option value="<?php echo base_url("c_template_putusan_pidana/popup_putusan_pidana_format_biasa_bebas/".$enc);?>">Putusan Pidana Umum (Format Biasa Bebas)</option>
						<option value="<?php echo base_url("c_template_putusan_pidana/popup_putusan_pidana_format_biasa_terbukti/".$enc);?>">Putusan Pidana Umum (Format Biasa Terbukti)</option>
						<option value="<?php echo base_url("c_template_putusan_pidana/popup_putusan_pidana_format_biasa_lepas/".$enc);?>">Putusan Pidana Umum (Format Biasa Lepas)</option>
						<option value="cetakPutusanFormatPUtidakDiterima()">Putusan Pidana Umum (Format Penuntutan Penuntut Umum tidak dapat diterima)</option>
                    <?php
                    }
                    elseif ($alur_perkara_id==='118')
					{
                    ?>
                    	<option value="<?php echo base_url("c_template_putusan_pidana/popup_putusan_pidana_anak_format_biasa_terbukti/".$enc);?>">Putusan Pidana Anak (Format Biasa Terbukti)</option>
                    <?php
                    }
                    elseif (($alur_perkara_id==='119')&&($status_putusan_id==='31'))
					{
					?>
						<option value="cetakPutusanPraPidGugur()">Putusan Pra Peradilan Format Gugur</option>
					<?php
					}
                    elseif (($alur_perkara_id==='119')&&(($status_putusan_id==='30')))
					{
					?>
						<option value="cetakPutusanPraPidKabul()">Putusan Pra Peradilan Format Kabul</option>
					<?php
                    }
                    elseif (($alur_perkara_id==='119')&&(($status_putusan_id==='32')))
					{
					?>
						<option value="cetakPutusanPraPidTolak()">Putusan Pra Peradilan Format Tolak</option>
					<?php
                    }
                    elseif (($alur_perkara_id==='1')||($alur_perkara_id==='7'))
					{
                    ?>
	                    
                        <option value='pdt1()'>Putusan Perdata Kabul</option>
                        <option value='pdt2()'>Putusan Perdata Tolak Gugatan</option>
                        <option value='pdt3()'>Putusan Perdata Gugatan</option>
                        <option value='pdt4()'>Putusan Perdata (Format Gugur)</option>
                        <option value='pdt5()'>Putusan Perdata (Format Verstek)</option>
                        <option value='pdt6()'>Putusan Perdata (Format Verzet-Kabul Perlawanan)</option>
                        <option value='pdt7()'>Putusan Perdata (Format Rekonvensi)</option>
                        <option value='pdt8()'>Putusan Perdata (Format Rekonvensi Tidak Ada Hubungan)</option>
                        <option value='pdt9()'>Putusan Perdata (Format Intervensi Vrijwaring)</option>   
                        <option value='pdt10()'>Putusan Perdata (Format Intervensi Tussenkomst)</option>
                        <option value='pdt11()'>Putusan Perdata (Format Intervensi Voeging)</option>
                        <option value='pdt12()'>Putusan Perdata (Format Putusan Provisi)</option>
                        <option value='pdt13()'>Putusan Perdata (Format Putusan Sela tentang Eksepsi Kewenangan Dikabulkan)</option>
                        <option value='pdt14()'>Putusan Perdata - Berita Acara (Format Putusan Sela tentang Eksepsi Kewenangan Ditolak)</option>
                        <option value='pdt15()'>Putusan Perdata - Berita Acara (Format Putusan Sela Tentang Sumpah Discoir)</option>
                        <option value='pdt16()'>Putusan Perdata - Berita Acara (Format Putusan Sela Tentang Sumpah Supletoir)</option>
                        <option value='pdt17()'>Putusan Perdata - Berita Acara (Permohonan Pasal 225HIR - 295RBg)</option>
                        <option value='pdt18()'>Putusan Perdata (Permohonan Pasal 225HIR - 295RBg)</option>
                    <?php
                    }
                    elseif ($alur_perkara_id=='8')
					{
                    ?>
	                    <option value="<?php echo base_url("c_template_putusan_perdata/popup_putusan_perdata_s/".$enc);?>">Putusan Perdata Sederhana</option>
                    <?php
                    }
                    elseif ($alur_perkara_id=='3')
					{
                    ?>
						<option value="<?php echo base_url("c_template_putusan_perdata/popup_putusan_pdt_pailit/".$enc);?>">Putusan Perdata Pailit</option>
					<?php 
					}
					elseif ($alur_perkara_id=='4')
					{
					?>
						<option value="<?php echo base_url("c_template_putusan_perdata/popup_putusan_pdt_pkpu/".$enc);?>">Putusan Perdata Perdata PKPU</option>
                    <?php
                    }
                    elseif ($alur_perkara_id==='5')
					{
                    ?>
						<option value="<?php echo base_url("c_template_putusan_perdata/popup_putusan_pdt_hki/".$enc);?>">Putusan Perdata Perdata HKI</option>
                    <?php
                    }
					elseif ($alur_perkara_id==='6')
					{
                    ?>
						<option value="<?php echo base_url("c_template_putusan_perdata/popup_putusan_pdt_phi/".$enc);?>">Putusan Perdata Perdata PHI</option>
                    <?php
                    }
                    elseif ($alur_perkara_id==='120')
					{
                    ?>
						<option value="<?php echo base_url("c_template_putusan_mil/popup_putusan_mil/".$enc."/1");?>">Putusan Akhir</option>
						<option value="<?php echo base_url("c_template_putusan_mil/popup_putusan_mil/".$enc."/2");?>">Petikan Putusan</option>
                    <?php
                	}
                	else if ($alur_perkara_id=='121')
                	{
                	?>
                		<option value="<?php echo base_url("c_template_putusan_mil/popup_putusan_mil/".$enc."/1");?>">Putusan Akhir</option>
       				}                  
                    <?php
                    	}
					}else if ($alur_perkara_id=='9') {
						switch ($status_putusan_id) {
						 	case '33':
						 		$idtemplate='2';
						 		break;
						 	case '34':
						 		$idtemplate='3';
						 		break;
						 	case '35':
						 		$idtemplate='4';
						 		break;
						 	case '38':
						 		$idtemplate='5';
						 		break;
						 	default :
						 		$idtemplate='';
						 		break;
						 }
						 if ($idtemplate!='') {                	
							?>						 	
                			<a href="<?php echo base_url('c_template_putusan_tun/cetak_putusan_tun/'.$enc.'/'.$idtemplate);?>"> [ Cetak Template Putusan - <?php echo $status_putusan_nama;?>]</a>
                    		<?php
						} else {
							echo "Template Belum Ada ";
						}             			
					} else if ($alur_perkara_id=='15' or $alur_perkara_id=='16' ){
						?>
						<a href="#" onClick="popup_form('<?php echo base_url("c_template_putusan_agama/popup_putusan/".$enc.'/'.$alur_perkara_id.'/'.$status_putusan_id);?>')"><img src="<?php echo base_url();?>resources/img/nm_icon_doc.gif"></a>
						
						<?php
					} else {
						?>
						<a>Tidak ada Template</a>
						<?php
					}
                    ?>
                    </select>
                    </span>
                    <?php } ?>
				</td>
			</tr>
			<?php } ?>
			<?php
			if($idalurperkara==3){
			?>
			<tr>
				<td id="first-child">Tanggal Penetapan Hakim Pengawas</td>
				<td colspan="3" style="padding:0px;padding-left:5px;"><?php echo (!empty($penetapan_hakim_pengawas)? $penetapan_hakim_pengawas:'');?></td>
			</tr>
			<tr>
				<td id="first-child">Nomor Penetapan Hakim Pengawas</td>
				<td colspan="3" style="padding:0px;padding-left:5px;"><?php echo (!empty($nomor_penetapan_hakim_pengawas)? $nomor_penetapan_hakim_pengawas:'');?></td>
			</tr>
			<tr>
				<td id="first-child">Hakim Pengawas</td>
				<td colspan="3" style="padding:0px;padding-left:5px;"><?php echo (!empty($hakim_pengawas_nama)? $hakim_pengawas_nama:'');?></td>
			</tr>
			<tr>
				<td id="first-child">Kurator</td>
				<td colspan="3" style="padding:0px;padding-left:5px;"><?php echo (!empty($kurator_nama)? $kurator_nama:'');?></td>
			</tr>
			<tr>
				<td id="first-child">Tanggal pengumuman dalam Berita Negara RI</td>
				<td colspan="3" style="padding:0px;padding-left:5px;"><?php echo (!empty($tanggal_berita_putusan)? $tanggal_berita_putusan:'');?></td>
			</tr>
			<tr>
				<td id="first-child">Tanggal dimuat dalam Surat Kabar</td>
				<td colspan="3" style="padding:0px;padding-left:5px;"><?php echo (!empty($tanggal_surat_kabar_putusan)? $tanggal_surat_kabar_putusan:'');?></td>
			</tr>
			<tr>
				<td id="first-child">Nama Surat Kabar</td>
				<td colspan="3" style="padding:0px;padding-left:5px;"><?php echo (!empty($nama_surat_kabar_putusan)? $nama_surat_kabar_putusan:'');?></td>
			</tr>
			<?php
				}
			?>			
			<tr>
				<td id="first-child" style="vertical-align:top;">Pemberitahuan <?php echo $status;?></td>			
				<td colspan="3">
					<?php
						if($pihak_pertama!=''){
							if($pihak_pertama->num_rows>0){
					?>
							<div class="cssTable">
								<table id="tableinfo" style="margin:0px;padding:0px;">
									<col width="20%">
									<col width="55%">
									<col width="25%">
									<?php
									if($this->session->userdata('idgroup')==1 OR $this->session->userdata('idgroup')==10 OR $this->session->userdata('idgroup')==600){
										if(($alur_perkara_id==='15' || $alur_perkara_id==='16' ) && $canCetakDokumen){
											echo '<col width="20%">';
										}?>
										<?php
										if(($alur_perkara_id==='1' || $alur_perkara_id==='9' ) && $canCetakDokumen){
											echo '<col width="20%">';
										}
									}
									?>
									<tbody>
										<tr>
											<td>Status</td>
											<td>Nama</td>
											<td>Tanggal Pemberitahuan <?php echo $status;?></td>
											<?php 
											if($this->session->userdata('idgroup')==1 OR $this->session->userdata('idgroup')==10 OR $this->session->userdata('idgroup')==600){
												if(($alur_perkara_id==='1' || $alur_perkara_id==='9') && $canCetakDokumen){
													echo '<td>Cetak Dokumen Relaas</td>';
												}else if(($alur_perkara_id==='15' || $alur_perkara_id==='16' ) && $canCetakDokumen){
													echo '<td>Cetak Dokumen</td>';
												}
											}
											?>
										</tr>
									<?php
										$i=1;
										foreach ($pihak_pertama->result() as $row) {
											echo '<tr>';
												echo '<td>'.$this->nativesession->getStatusPihak(10,$idalurperkara,1).' ';echo ($pihak_pertama->num_rows>1)?$row->urutan:'';echo '</td>';
												echo '<td>'.$row->nama.'</td>';
												$tgl = (!empty($row->tanggal_pemberitahuan_putusan))? $this->tanggalhelper->convertDayDate($row->tanggal_pemberitahuan_putusan):'-';
												echo '<td style="text-align:center">'.$tgl.'</td>';
												?>
												<?php
												if(($alur_perkara_id==='1' || $alur_perkara_id==='9' ||  $alur_perkara_id==='15'|| $alur_perkara_id==='16') && $canCetakDokumen && ($this->session->userdata('idgroup')==1 OR $this->session->userdata('idgroup')==10 OR $this->session->userdata('idgroup')==600)){
													echo "<td align=center>";
													//if (!empty($row->tanggal_pemberitahuan_putusan) && $row->tanggal_pemberitahuan_putusan!='0000-00-00'){
														if ($alur_perkara_id==='1'){?>
											                    <span class="custom-dropdown custom-dropdown--emerald">
																	<select onchange="pilih_cetak(this)" style="width:150px;z-index:99999" class="custom-dropdown__select custom-dropdown__select--white">
																		<option value='1'>Pilih Dokumen</option>
																		<option value="<?php echo base_url("c_template_perdata_pemberitahuan_putusan/pemberitahuan_putusan_pdt/".$enc);?>">Relaas Pemberitahuan Putusan Perdata Penggugat</option>
																		<option value="<?php echo base_url("c_template_perdata_pemberitahuan_putusan/pemberitahuan_putusan_pdt_kuasa_penggugat/".$enc);?>">Relaas Pemberitahuan Putusan Kuasa Penggugat</option>
																	</select>										                    
											                    </span>
													<?php 
														}elseif($alur_perkara_id==='9'){
															$idpihak = base64_encode($this->encrypt->encode($row->pihak_id));
													?>
											                    <a href="<?php echo base_url("c_template_perdata_pemberitahuan_putusan/cetak_pemberitahuan_putusan_tun/".$enc."/".$idpihak."/1");?>">										                    	
											                    	<img src="<?php echo base_url();?>resources/img/nm_icon_doc.gif">
											                    </a>
											                    <?php 
														}elseif($alur_perkara_id==='15'|| $alur_perkara_id==='16'){
														$idpihak = base64_encode($this->encrypt->encode($row->pihak_id));
													?>
											                    <a href="#" onClick="popup_form('<?php echo base_url("c_template_agama_perdata_pemberitahuan_putusan/popup_pemberitahuan_putusan_tergugat/".$enc."/".$idpihak."/1");?>')">           	
											                    <img src="<?php echo base_url();?>resources/img/nm_icon_doc.gif">
											                    </a>
											                   <?php /* <a href="#" onClick="popup_form('<?php echo base_url("c_template_agama_perdata_pemberitahuan_putusan/popup_pemberitahuan_putusan_tergugat_delegasi/".$enc."/".$idpihak."/1");?>')">           	
											                    [ Delegasi ]
											                    </a> */ ?> 
													<?php }
													//}else{ echo "Tanggal kosong, belum dapat cetak dokumen";}
													echo "</td>";
												}?>
											</tr>
											<?php
										}?>
									</tbody>
								</table>
							</div>
							<?php
							}
						}
							?>	
						<br>
						<?php
						if($pihak_kedua!=''){
							if($pihak_kedua->num_rows>0){
									?>
							<div class="cssTable">
								<table id="tableinfo" style="margin:0px;padding:0px;">
									<col width="20%">
									<col width="55%">
									<col width="25%">
									<?php
									if($this->session->userdata('idgroup')==1 OR $this->session->userdata('idgroup')==10 OR $this->session->userdata('idgroup')==600){
										if(($alur_perkara_id==='15' || $alur_perkara_id==='16' ) && $canCetakDokumen){
											echo '<col width="20%">';
										}?>
										<?php
										if(($alur_perkara_id==='1' || $alur_perkara_id==='9' ) && $canCetakDokumen){
												echo '<col width="20%">';
										}
									}?>
									<tbody>
										<tr>
											<td>Status</td>
											<td>Nama</td>
											<td>Tanggal Pemberitahuan <?php echo $status;?></td>
											<?php
											if($this->session->userdata('idgroup')==1 OR $this->session->userdata('idgroup')==10 OR $this->session->userdata('idgroup')==600){
												if(($alur_perkara_id==='1' || $alur_perkara_id==='9') && $canCetakDokumen){
													echo '<td>Cetak Dokumen Relaas</td>';
												}else if(($alur_perkara_id==='15') && $canCetakDokumen){
													echo '<td>Cetak Dokumen</td>';
												}
											}?>
										</tr>
									<?php
										$i=1;
										foreach ($pihak_kedua->result() as $row) {
											echo '<tr>';
												echo '<td>'.$this->nativesession->getStatusPihak(10,$idalurperkara,2).' ';echo ($pihak_kedua->num_rows>1)?$row->urutan:'';echo '</td>';
												echo '<td>'.$row->nama.'</td>';
												$tgl = (!empty($row->tanggal_pemberitahuan_putusan))? $this->tanggalhelper->convertDayDate($row->tanggal_pemberitahuan_putusan):'-';
												echo '<td style="text-align:center">'.$tgl.'</td>';
												?>
												<?php 
												if(($alur_perkara_id==='1' || $alur_perkara_id==='9' || $alur_perkara_id==='15' ) && $canCetakDokumen && ($this->session->userdata('idgroup')==1 OR $this->session->userdata('idgroup')==10 OR $this->session->userdata('idgroup')==600) ){
													echo "<td align='center'>";
													//if (!empty($row->tanggal_pemberitahuan_putusan) && $row->tanggal_pemberitahuan_putusan!='0000-00-00'){
														if ($alur_perkara_id==='1'){?>
															<span class="custom-dropdown custom-dropdown--emerald">
																<select onchange="pilih_cetak(this)" style="width:150px;z-index:99999" class="custom-dropdown__select custom-dropdown__select--white">
																	<option value='1'>Pilih Dokumen</option>
																	<option value="<?php echo base_url("c_template_perdata_pemberitahuan_putusan/pemberitahuan_putusan_pdt_tergugat/".$enc);?>">Relaas Pemberitahuan Putusan Perdata Tergugat</option>
																	<option value="<?php echo base_url("c_template_perdata_pemberitahuan_putusan/pemberitahuan_putusan_pdt_kuasa_tergugat/".$enc);?>">Relaas Pemberitahuan Putusan Kuasa Tergugat</option>
																</select>
															</span>
													<?php 
														}elseif($alur_perkara_id==='9'){
															$idpihak = base64_encode($this->encrypt->encode($row->pihak_id));
													?>
																<a href="<?php echo base_url("c_template_perdata_pemberitahuan_putusan/cetak_pemberitahuan_putusan_tun/".$enc."/".$idpihak."/2");?>">										                    	
																	<img src="<?php echo base_url();?>resources/img/nm_icon_doc.gif">
																</a>
																        <?php 
														}elseif($alur_perkara_id==='15'){
															$idpihak = base64_encode($this->encrypt->encode($row->pihak_id));
													?>
											                    <a href="#" onClick="popup_form('<?php echo base_url("c_template_agama_perdata_pemberitahuan_putusan/popup_pemberitahuan_putusan_tergugat/".$enc."/".$idpihak."/2");?>')">           	
											                 	<img src="<?php echo base_url();?>resources/img/nm_icon_doc.gif">
											                    </a>
											                   <?php /*  <a href="#" onClick="popup_form('<?php echo base_url("c_template_agama_perdata_pemberitahuan_putusan/popup_pemberitahuan_putusan_tergugat_delegasi/".$enc."/".$idpihak."/2");?>')">           	
											                    [ Delegasi ]
											                    </a> */ ?>
													<?php }
													//}else{echo "Tanggal kosong, belum dapat cetak dokumen";}
													echo "</td>";
												} ?>
											</tr>
											<?php
											}?>
										</tbody>
									</table>
								</div>
							<?php
								}
							}
							?>
							<br>
						<?php
						if($pihak_ketiga!=''){
							if($pihak_ketiga->num_rows>0){
									?>
							<div class="cssTable">
								<table id="tableinfo" style="margin:0px;padding:0px;">
									<col width="20%">
									<col width="55%">
									<col width="25%">
									<?php
									if($this->session->userdata('idgroup')==1 OR $this->session->userdata('idgroup')==10 OR $this->session->userdata('idgroup')==600){
										if($alur_perkara_id==='1' && $canCetakDokumen){
												echo '<col width="20%">';
										}
									}?>
									<tbody>
										<tr>
											<td>Status</td>
											<td>Nama</td>
											<td>Tanggal Pemberitahuan Putusan</td>
											<?php
											if($this->session->userdata('idgroup')==1 OR $this->session->userdata('idgroup')==10 OR $this->session->userdata('idgroup')==600){
												if($alur_perkara_id==='1' && $canCetakDokumen){
														echo '<td>Cetak Dokumen Relaas x</td>';
												}
											}?>
										</tr>
									<?php
										$i=1;
										foreach ($pihak_ketiga->result() as $row) {
											$status_intervensi = '';
											if($this->session->userdata('jenis_pengadilan')==3){
												if($row->tergabung_ke_pihak==1)
													$status_intervensi = 'Penggugat II ';
												if($row->tergabung_ke_pihak==2)
													$status_intervensi = 'Tergugat II ';
											}
												
											echo '<tr>';
												echo '<td>'.$status_intervensi.$this->nativesession->getStatusPihak(10,$idalurperkara,3).' ';echo ($pihak_ketiga->num_rows>1)?$row->urutan:'';echo '</td>';
												echo '<td>'.$row->nama.'</td>';
												$tgl = (!empty($row->tanggal_pemberitahuan_putusan))? $this->tanggalhelper->convertDayDate($row->tanggal_pemberitahuan_putusan):'-';
												echo '<td style="text-align:center">'.$tgl.'</td>';
												?>
												<?php 
												if($alur_perkara_id==='1' && $canCetakDokumen && ($this->session->userdata('idgroup')==1 OR $this->session->userdata('idgroup')==10 OR $this->session->userdata('idgroup')==600)){
													echo "<td align=center>";
													if (!empty($row->tanggal_pemberitahuan_putusan) && $row->tanggal_pemberitahuan_putusan!='0000-00-00'){
															if ($alur_perkara_id==='1'){?>
																<span class="custom-dropdown custom-dropdown--emerald">
																	<select onchange="pilih_cetak(this)" style="width:150px;z-index:99999" class="custom-dropdown__select custom-dropdown__select--white">
																		<option value='1'>Pilih Dokumen</option>
																		<option value="<?php echo base_url("c_template_perdata_pemberitahuan_putusan/pemberitahuan_putusan_pdt_tergugat/".$enc);?>">Relaas Pemberitahuan Putusan Perdata Tergugat</option>
																		<option value="<?php echo base_url("c_template_perdata_pemberitahuan_putusan/pemberitahuan_putusan_pdt_kuasa_tergugat/".$enc);?>">Relaas Pemberitahuan Putusan Kuasa Tergugat</option>
																	</select>
																</span>
														<?php }
														}else{echo "Tanggal kosong, belum dapat cetak dokumen";} 
													echo "</td>";
												}?>
											</tr>
											<?php
											}?>
										</tbody>
									</table>
								</div>
							<?php
								}
							}
							?>
								<br>
						<?php
						if($pihak_keempat!=''){
							if($pihak_keempat->num_rows>0){
									?>
							<div class="cssTable">
								<table id="tableinfo" style="margin:0px;padding:0px;">
									<col width="20%">
									<col width="55%">
									<col width="25%">
									<?php
									if($alur_perkara_id==='1' && $canCetakDokumen){
											echo '<col width="20%">';
									}?>
									<tbody>
										<tr>
											<td>Status</td>
											<td>Nama</td>
											<td>Tanggal Pemberitahuan Putusan</td>
											<?php
											if($alur_perkara_id==='1' && $canCetakDokumen){
													echo '<td>Cetak Dokumen Relaas</td>';
											}?>
										</tr>
									<?php
										$i=1;
										foreach ($pihak_keempat->result() as $row) {
											echo '<tr>';
												echo '<td>'.$this->nativesession->getStatusPihak(10,$idalurperkara,4).' ';echo ($pihak_keempat->num_rows>1)?$row->urutan:'';echo '</td>';
												echo '<td>'.$row->nama.'</td>';
												$tgl = (!empty($row->tanggal_pemberitahuan_putusan))? $this->tanggalhelper->convertDayDate($row->tanggal_pemberitahuan_putusan):'-';
												echo '<td style="text-align:center">'.$tgl.'</td>';
												?>
												<?php 
												if($alur_perkara_id==='1' && $canCetakDokumen){
													echo "<td align='center'>";
													if (!empty($row->tanggal_pemberitahuan_putusan) && $row->tanggal_pemberitahuan_putusan!='0000-00-00'){
													if ($alur_perkara_id==='1'){?>
														<span class="custom-dropdown custom-dropdown--emerald">
															<select onchange="pilih_cetak(this)" style="width:150px;z-index:99999" class="custom-dropdown__select custom-dropdown__select--white">
																<option value='1'>Pilih Dokumen</option>
																<option value="<?php echo base_url("c_template_perdata_pemberitahuan_putusan/pemberitahuan_putusan_pdt_tergugat/".$enc);?>">Relaas Pemberitahuan Putusan Perdata Tergugat</option>
																<option value="<?php echo base_url("c_template_perdata_pemberitahuan_putusan/pemberitahuan_putusan_pdt_kuasa_tergugat/".$enc);?>">Relaas Pemberitahuan Putusan Kuasa Tergugat</option>
															</select>
														</span>
												<?php }
													}else{echo "Tanggal kosong, belum dapat cetak dokumen";} 
													echo "</td>";
												}?>
											</tr>
											<?php
											}?>
										</tbody>
									</table>
								</div>
							<?php
								}
							}
							echo "<br>";
							if($idalurperkara==120 OR $idalurperkara=121){
							?>
							<div class="cssTable">
								<table id="tableinfo" style="margin:0px;padding:0px;">
									<col width="75%">
									<col width="25%">
									<tbody>
										<tr>
											<td>Status</td>
											<td>Tanggal Pemberitahuan Putusan</td>
										</tr>
										<tr>
											<td>Atasan Yang Berhak Menghukum</td>
											<td style="text-align:center"><?php echo $tglANKUM; ?></td>
										</tr>
										<tr>
											<td>Perwira Penyerah Perkara</td>
											<td style="text-align:center"><?php echo $tglPEPERA; ?></td>
										</tr>
									</tbody>
								</table>
							</div>
							<?php } ?>
				</td>
			</tr>
				<?php
				if($idalurperkara>100 AND $idalurperkara!=119 AND $idalurperkara!=123){
				?>
			<tr>
				<td id="first-child" style="vertical-align:top;">Menerima Putusan</td>
				<td colspan="3">
				<?php
					if($pihak_pertama!=''){
						if($pihak_pertama->num_rows>0){
							?>
						<div class="cssTable">
							<table id="tableinfo" style="margin:0px;padding:0px;">
									<col width="20%">
									<col width="55%">
									<col width="25%">
									<?php
									if($alur_perkara_id==='120' && $canCetakDokumen){
											echo '<col width="20%">';
									}?>
								<tbody>
									<tr>
										<td>Status</td>
										<td>Nama</td>
										<td>Tanggal Menerima Putusan</td>
										<?php
										if($alur_perkara_id==='120' && $canCetakDokumen){
													echo '<td>Akta Menerima Putusan</td>';
											}?>
									</tr>
								<?php
								$i=1;
								foreach ($pihak_pertama->result() as $row) {
									echo '<tr>';
										echo '<td>'.$this->nativesession->getStatusPihak(10,$idalurperkara,1).' ';echo ($pihak_pertama->num_rows>1)?$row->urutan:'';echo '</td>';
										echo '<td>'.$row->nama.'</td>';
										$tgl = (!empty($row->tanggal_menerima_putusan))? $this->tanggalhelper->convertDayDate($row->tanggal_menerima_putusan):'-';
										echo '<td style="text-align:center">'.$tgl.'</td>';
										if ($alur_perkara_id==='120' && $canCetakDokumen){
											echo "<td align='center'>";									                    
											if (!empty($row->tanggal_menerima_putusan) && $row->tanggal_menerima_putusan!='0000-00-00'){
												if ($alur_perkara_id==='120'){
													$idpihak = base64_encode($this->encrypt->encode($row->id));
													?>
											        	<a href="<?php echo base_url("c_template_putusan_mil/cetak_akta_menerima_putusan/".$enc."/".$idpihak."/1");?>">										                              	
											            	<img src="<?php echo base_url();?>resources/img/nm_icon_doc.gif">
											            </a>
													<?php
												}
											}else{echo "Tanggal kosong, belum dapat cetak dokumen";} 
											echo "</td>";
										}
									echo '</tr>';
								}?>
								</tbody>
							</table>
						</div>
						<?php
						}
					}
					?>
					<br>
					<?php
					if($pihak_kedua!=''){
						if($pihak_kedua->num_rows>0){
							?>
						<div class="cssTable">
							<table id="tableinfo" style="margin:0px;padding:0px;">
									<col width="20%">
									<col width="55%">
									<col width="25%">
									<?php
									if($alur_perkara_id==='120' && $canCetakDokumen){
											echo '<col width="20%">';
									}?>
								<tbody>
									<tr>
										<td>Status</td>
										<td>Nama</td>
										<td>Tanggal Menerima Putusan</td>
										<?php
										if($alur_perkara_id==='120' && $canCetakDokumen){
													echo '<td>Akta Menerima Putusan</td>';
											}?>
									</tr>
								<?php
								$i=1;
								foreach ($pihak_kedua->result() as $row) {
									echo '<tr>';
										echo '<td>'.$this->nativesession->getStatusPihak(10,$idalurperkara,2).' ';echo ($pihak_kedua->num_rows>1)?$row->urutan:'';echo '</td>';
										echo '<td>'.$row->nama.'</td>';
										$tgl = (!empty($row->tanggal_menerima_putusan))? $this->tanggalhelper->convertDayDate($row->tanggal_menerima_putusan):'-';
										echo '<td style="text-align:center">'.$tgl.'</td>';
										if ($alur_perkara_id==='120' && $canCetakDokumen){
											echo "<td align='center'>";
											if (!empty($row->tanggal_menerima_putusan) && $row->tanggal_menerima_putusan!='0000-00-00'){
												if ($alur_perkara_id==='120'){
													$idpihak = base64_encode($this->encrypt->encode($row->id));
													?>																			                    
											        	<a href="<?php echo base_url("c_template_putusan_mil/cetak_akta_menerima_putusan/".$enc."/".$idpihak."/2");?>">										                              	
											            	<img src="<?php echo base_url();?>resources/img/nm_icon_doc.gif">
											            </a>													
													<?php
												}
											}else{echo "Tanggal kosong, belum dapat cetak dokumen";} 
											echo "</td>";
										}
									echo '</tr>';
								}?>
								</tbody>
							</table>
						</div>
						<?php
						}
					}?>
				</td>
			</tr>
			<tr>
			<td id="first-child" style="vertical-align:top;">Kirim Salinan Putusan</td>
				<td colspan="3">
				<?php
					if($pihak_pertama!=''){
						if($pihak_pertama->num_rows>0){
				?>
						<div class="cssTable">
							<table id="tableinfo" style="margin:0px;padding:0px;">
									<col width="20%">
									<col width="55%">
									<col width="25%">
								<tbody>
									<tr>
										<td>Status</td>
										<td>Nama</td>
										<td>Tanggal Kirim Salinan</td>
									</tr>
								<?php
								$i=1;
								foreach ($pihak_pertama->result() as $row) {														
									echo '<tr>';
										echo '<td>'.$this->nativesession->getStatusPihak(10,$idalurperkara,1).' ';echo ($pihak_pertama->num_rows>1)?$row->urutan:'';echo '</td>';
										echo '<td>'.$row->nama.'</td>';
										$tgl = (!empty($row->tanggal_kirim_salinan_putusan))? $this->tanggalhelper->convertDayDate($row->tanggal_kirim_salinan_putusan):'-';
										echo '<td style="text-align:center">'.$tgl.'</td>';
									echo '</tr>';
								}?>
								</tbody>
							</table>
						</div>
				<?php
						}
					}?>	
				<br>
				<?php
					if($pihak_kedua!=''){
						if($pihak_kedua->num_rows>0){
				?>
						<div class="cssTable">
							<table id="tableinfo" style="margin:0px;padding:0px;">
									<col width="20%">
									<col width="55%">
									<col width="25%">
								<tbody>
									<tr>
										<td>Status</td>
										<td>Nama</td>
										<td>Tanggal Menerima Salinan</td>
									</tr>
								<?php
									$i=1;
									foreach ($pihak_kedua->result() as $row) {
										$status = ($idalurperkara<100)? 'Tergugat':'Terdakwa';
										echo '<tr>';
											echo '<td>'.$status.' '.$row->urutan.'</td>';
											echo '<td>'.$row->nama.'</td>';
											$tgl = (!empty($row->tanggal_kirim_salinan_putusan))? $this->tanggalhelper->convertDayDate($row->tanggal_kirim_salinan_putusan):'-';
											echo '<td style="text-align:center">'.$tgl.'</td>';
										echo '</tr>';
									}?>
								</tbody>
							</table>
						</div>
				<?php
						}
					}?>			
			</td>
		</tr>
		<tr>
			<td id="first-child" style="vertical-align:top;">Kirim Salinan Putusan Kepada Penyidik</td>
			<td colspan="3" style="padding:0px;padding-left:5px;"><?php echo (!empty($kirim_salinan_putusan_penyidik)? $kirim_salinan_putusan_penyidik:'');?></td>
		</tr>
		<?php
		}
		?>
		<tr>
			<td id="first-child">Tanggal Minutasi</td>
			<td colspan="3" style="padding:0px;padding-left:5px;"><?php echo (!empty($tanggal_minutasi)? $tanggal_minutasi:'');?></td>
		</tr>
		<tr>
			<td id="first-child">Keterangan</td>
			<td colspan="3" style="padding:0px;padding-left:5px;"><?php echo (!empty($catatan_putusan)? $catatan_putusan:'');?></td>
		</tr>
		
		</tbody>
	</table>
</div>
<script type="text/javascript">
var status_putusan = '<?php echo $status_putusan_id;?>';
if(status_putusan==62){
	$('#faktor_tr').show();
	$('#keadaan_tr').show();
}
function cetakPutusanFormatPUtidakDiterima(){
    window.open('<?php echo base_url("c_template_putusan_pidana/cetak_putusan_pidana_penuntutan_tidak_diterima/".$enc);?>','_blank');
}
function cetakPutusanPraPidGugur() {
	window.open('<?php echo base_url("c_template_putusan_pidana_pra/cetak_putusan_pra_format_gugur/".$enc);?>','_blank');
}
function cetakPutusanPraPidKabul() {
	window.open('<?php echo base_url("c_template_putusan_pidana_pra/cetak_putusan_pra_kabul_tolak/".$enc."/1");?>','_blank');
}
function cetakPutusanPraPidTolak() {
	window.open('<?php echo base_url("c_template_putusan_pidana_pra/cetak_putusan_pra_kabul_tolak/".$enc."/1");?>','_blank');
}
function pdt1() {
	window.open('<?php echo base_url("c_template_putusan_perdata/cetak_putusan_pdt/".$enc."/1");?>','_blank');
}
function pdt2() {
	window.open('<?php echo base_url("c_template_putusan_perdata/cetak_putusan_pdt/".$enc."/2");?>','_blank');
}
function pdt3() {
	window.open('<?php echo base_url("c_template_putusan_perdata/cetak_putusan_pdt/".$enc."/3");?>','_blank');
}
function pdt4() {
	window.open('<?php echo base_url("c_template_putusan_perdata/cetak_putusan_pdt/".$enc."/4");?>','_blank');
}
function pdt5() {
	window.open('<?php echo base_url("c_template_putusan_perdata/cetak_putusan_pdt/".$enc."/5");?>','_blank');
}
function pdt6() {
	window.open('<?php echo base_url("c_template_putusan_perdata/cetak_putusan_pdt/".$enc."/6");?>','_blank');
}
function pdt7() {
	window.open('<?php echo base_url("c_template_putusan_perdata/cetak_putusan_pdt/".$enc."/7");?>','_blank');
}
function pdt8() {
	window.open('<?php echo base_url("c_template_putusan_perdata/cetak_putusan_pdt/".$enc."/8");?>','_blank');
}
function pdt9() {
	window.open('<?php echo base_url("c_template_putusan_perdata/cetak_putusan_pdt/".$enc."/9");?>','_blank');
}
function pdt10() {
	window.open('<?php echo base_url("c_template_putusan_perdata/cetak_putusan_pdt/".$enc."/10");?>','_blank');
}
function pdt11() {
	window.open('<?php echo base_url("c_template_putusan_perdata/cetak_putusan_pdt/".$enc."/11");?>','_blank');
}
function pdt12() {
	window.open('<?php echo base_url("c_template_putusan_perdata/cetak_putusan_pdt/".$enc."/12");?>','_blank');
}
function pdt13() {
	window.open('<?php echo base_url("c_template_putusan_perdata/cetak_putusan_pdt/".$enc."/13");?>','_blank');
}
function pdt14() {
	window.open('<?php echo base_url("c_template_putusan_perdata/cetak_putusan_pdt/".$enc."/14");?>','_blank');
}
function pdt15() {
	window.open('<?php echo base_url("c_template_putusan_perdata/cetak_putusan_pdt/".$enc."/15");?>','_blank');
}
function pdt16() {
	window.open('<?php echo base_url("c_template_putusan_perdata/cetak_putusan_pdt/".$enc."/16");?>','_blank');
}
function pdt17() {
	window.open('<?php echo base_url("c_template_putusan_perdata/cetak_putusan_pdt/".$enc."/17");?>','_blank');
}
function pdt18() {
	window.open('<?php echo base_url("c_template_putusan_perdata/cetak_putusan_pdt/".$enc."/18");?>','_blank');
}
function pdt19() {
	window.open('<?php echo base_url("c_template_putusan_perdata/cetak_putusan_pdt/".$enc."/19");?>','_blank');
}

function pilih_cetak(ele){
	if (ele.value=='cetakPutusanFormatPUtidakDiterima()'){
		cetakPutusanFormatPUtidakDiterima();
	}else if (ele.value=='cetakPutusanPraPidGugur()'){
		cetakPutusanPraPidGugur();
	}else if (ele.value=='cetakPutusanPraPidKabul()'){
		cetakPutusanPraPidKabul();
	}else if (ele.value=='cetakPutusanPraPidTolak()'){
		cetakPutusanPraPidTolak();
	}else if (ele.value=='pdt1()'){
		pdt1();
	}else if (ele.value=='pdt2()'){
		pdt2();
	}else if (ele.value=='pdt3()'){
		pdt3();
	}else if (ele.value=='pdt4()'){
		pdt4();
	}else if (ele.value=='pdt5()'){
		pdt5();
	}else if (ele.value=='pdt6()'){
		pdt6();
	}else if (ele.value=='pdt7()'){
		pdt7();
	}else if (ele.value=='pdt8()'){
		pdt8();
	}else if (ele.value=='pdt9()'){
		pdt9();
	}else if (ele.value=='pdt10()'){
		pdt10();
	}else if (ele.value=='pdt11()'){
		pdt11();
	}else if (ele.value=='pdt12()'){
		pdt12();
	}else if (ele.value=='pdt13()'){
		pdt13();
	}else if (ele.value=='pdt14()'){
		pdt14();
	}else if (ele.value=='pdt15()'){
		pdt15();
	}else if (ele.value=='pdt16()'){
		pdt16();
	}else if (ele.value=='pdt17()'){
		pdt17();
	}else if (ele.value=='pdt18()'){
		pdt18();
	}else if (ele.value=='pdt19()'){
		pdt19();
	}
	else if (ele.value!=1) {
		popup_form(ele.value);
		$(ele).val('1');
	} 
}
function doDownload(param){
	window.open("<?php echo base_url('managePutusanAkhir/doDownload/');?>"+'/'+param)
}

<?php if($idalurperkara==9){ ?>
    function cetakPemberitahuanPtsPenggugat(){  
            window.open('<?php echo base_url("c_template_perdata_pemberitahuan_putusan/cetak_pemberitahuan_putusan_tun/".$enc);?>','_self'); 
    };
    function cetakPemberitahuanPtsTergugat(){  
            window.open('<?php echo base_url("c_template_perdata_pemberitahuan_putusan/cetak_pemberitahuan_putusan_tun/".$enc);?>','_self'); 
    };
<?php } ?>

closeLoading();
</script>
