<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Perkara_list_delegasi extends CI_Controller {
	function index(){
		$enc = $this->encrypt->decode(base64_decode($this->nativesession->get_flash_session('enc')));
		
		$functions = $this->nativesession->get_flash_session('function');	
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		if($functions == 'sort'){
			$col = $this->nativesession->get_flash_session('col');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->sort($enc,$col,$enc,$keyword);
		}elseif($functions == 'type'){
			$this->session->set_userdata('asc_desc','DESC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc);
		}elseif($functions == 'page'){
			$page = $this->nativesession->get_flash_session('page');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$where=$this->nativesession->get_flash_session('where');
			$this->nativesession->set_flash_session('where', $where);
			$column_sorted = $this->nativesession->get_flash_session('col');
			$this->showData($enc,$column_sorted,$page,$keyword,$where);
			print_r($enc);
		}elseif($functions == 'search'){
			$keyword ='';
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->session->set_userdata('keyword',$keyword);
			$page = $this->nativesession->get_flash_session('page');
			$column_sorted = $this->nativesession->get_flash_session('col');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$column_sorted,$page,$keyword);
		}else{
			$this->session->set_userdata('asc_desc','DESC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData();
		}
	}



	function sort($enc,$col=null,$enc=null,$keyword=null){

		if($this->session->userdata('asc_desc')){
			if($this->session->userdata('asc_desc')=="DESC"){
				$this->session->set_userdata('asc_desc','ASC');
			}else{
				$this->session->set_userdata('asc_desc','DESC');
			}
		}else{
			$this->session->set_userdata('asc_desc','ASC');
		}
	
		$this->showData($idalur,$enc,$col,0,$keyword);
	}


	function showData($enc=NULL,$col=3,$start_page=0,$keyword='',$where=''){
		
		$asc_desc = $this->session->userdata('asc_desc');
		$this->load->model('perkara/delegasi');
		if($start_page>0){
			$begin_limit = ($start_page-1)*50;
		}else{
			$begin_limit = 0;
			$start_page = 1;
		}
		if ($where==''){
			$query = $this->delegasi->getPerkaraListDelegasi($enc,$col,$asc_desc,$begin_limit,$keyword);	
		}else{
			$query = $this->eksekusi->getPerkaraListDelegasi($enc,$col,$asc_desc,$begin_limit,$where);
		}

		if($start_page>0){
			$begin_limit = ($start_page-1)*50;
		}else{
			$begin_limit = 0;
			$start_page = 1;
		}
		
		$data['list_perkara'] = $query;

		if($this->session->userdata('total_rows')){
			if($this->session->userdata('total_rows')==-1){
				$data['total_rows'] = $this->delegasi->fecth_data_num($keyword);
				$this->session->set_userdata('total_rows',$data['total_rows']);
			}else{
				$data['total_rows'] = $this->session->userdata('total_rows');
			}
		}else{
			$data['total_rows'] = $this->delegasi->fecth_data_num($keyword);
			$this->session->set_userdata('total_rows',$data['total_rows']);
		}
		
		
		if ($enc==1) {
			$data['page_title'] = 'DAFTAR DELEGASI MASUK';
		}elseif($enc==2){
			$enc=2;
			$data['page_title'] = 'DAFTAR DELEGASI KELUAR';
		}else{
			$enc=2;
			$data['page_title'] = 'DAFTAR DELEGASI KELUAR';
		}
		$data['page_active'] = $begin_limit;
		$data['page_number'] = $start_page;
		$data['page_url'] = 'perkara_list_delegasi';
		if(!empty($keyword))
			$data['keyword'] = base64_encode($this->encrypt->encode($keyword));
		else
			$data['keyword'] = $keyword;

		$data['column_sorted'] = $col;
		$history = $this->nativesession->get_flash_session('url_requested');
		$data['main_history'] = $history;
		$data['idalur'] = $enc;
		$data['enc'] = $enc;
		$data['main_body'] = 'perkara_list/perkara_list_delegasi';
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body');
	}
}
