<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Detil_banding extends CI_Controller {
	function index(){
		#prevent direct access to page
		#the user should only access the page through menu
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$idperkara = $this->nativesession->get_flash_session('perkara_id');
		if(!is_numeric($idperkara)){
			show_404();
		}
		$view = $this->nativesession->get_flash_session('view');
		if($view==TRUE){
			$this->show_data_detil($idperkara);
		}else{
			$this->show_data($idperkara);
		}	
	}

	function show_data_detil($idperkara){
		$data['page_title'] = 'INFORMASI DETIL - PERMOHONAN BANDING';
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['main_history'] = $this->nativesession->get('main_url_requested');
		$data['history'] = $this->nativesession->get_flash_session('url_requested');		
		$this->load->model('perkara/banding','banding');
		$data['infobanding'] = $this->banding->fetchBanding($idperkara);
		$data['infobandingdetil'] = $this->banding->fetchBandingDetil($idperkara);
		$data['infomediasi'] = $this->banding->getDataMediasiBanding($idperkara);		
		$data['alur_perkara_id']=$this->tanggalhelper->getIDAlurPerkara($idperkara);
		$this->load->model('mediasi/jadwal_mediasi_m');
				
		$i=1;
		foreach($data['infomediasi']->result() as $row){			
			$jadwalmediasi="jadwalmediasi".$i;
			$mediasiid=$row->mediasi_id;			
			$listdata[$jadwalmediasi]=$this->jadwal_mediasi_m->get_data_jadwal_mediasi($mediasiid);
			$i++;
		}
		if(!empty($listdata)){
			$data['listjadwalmediasi']=$listdata; 
		}
		$this->load->vars($data);
		$this->load->view('perkara_tab/banding');
	}

	function show_data($idperkara){		
		$data['page_title'] = 'INFORMASI DETIL - PERMOHONAN BANDING';
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['main_body'] = 'perkara/detil_banding';
		$data['main_history'] = $this->nativesession->get('main_url_requested');
		$data['history'] = $this->nativesession->get_flash_session('url_requested');		
		$this->load->model('perkara/banding','banding');
		$data['infobanding'] = $this->banding->fetchBanding($idperkara);
		$data['infobandingdetil'] = $this->banding->fetchBandingDetil($idperkara);
		$data['infomediasi'] = $this->banding->getDataMediasiBanding($idperkara);		
		$data['alur_perkara_id']=$this->tanggalhelper->getIDAlurPerkara($idperkara);
		$data['perkaraid']=$idperkara;
		$this->load->model('mediasi/jadwal_mediasi_m');
		
		$i=1;
		foreach($data['infomediasi']->result() as $row){			
			$jadwalmediasi="jadwalmediasi".$i;
			$mediasiid=$row->mediasi_id;			
			$listdata[$jadwalmediasi]=$this->jadwal_mediasi_m->get_data_jadwal_mediasi($mediasiid);
			$i++;
		}
		if(!empty($listdata)){
			$data['listjadwalmediasi']=$listdata; 
		}
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}
	/*18082015*/
	function mediasi(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();						
		$data['enc'] = $segment[2];
		$data['idperkara'] = $this->encrypt->decode(base64_decode($segment[2]));						
		if(empty($data['idperkara']) OR intval($data['idperkara'])<1){
			show_404();
		}
		$func = $segment[3];		
		if($func!='tambah' AND $func!='edit'){
			show_404();
		}
		$data['enc_id'] = '';
		if($func=='edit'){
			$data['enc_id'] = $segment[4];
		}		
		$data['enc_act'] = base64_encode($this->encrypt->encode($func));		
		$data['history'] = base_url(uri_string());
		$data['current_date'] =date('d/m/Y');
		$this->load->model('perkara/banding','banding');
		$data['infomediasi'] = $this->banding->getDataMediasiBanding($data['idperkara']);			
		$data['listmediator'] = $this->banding->getDataMediator();				
		$databanding = $this->banding->getDataBanding($data['idperkara']);
		if($databanding!=''){
			if($databanding->num_rows>0){
				foreach ($databanding->result() as $row) {
					$data['idperkara'] = base64_encode($this->encrypt->encode($row->perkara_id));
					$data['noperkarapn'] = $row->nomor_perkara_pn;
					$data['tglpermohonan'] = $this->tanggalhelper->convertDayDate($row->permohonan_banding);
					$data['amar'] = $row->amar_putusan_banding;
					$data['tanggal'] = $this->tanggalhelper->convertToInputDate($row->putusan_banding);
					$data['statusputusan'] =$row->status_putusan_banding_id;
				}
			}else{
				show_404();
			}
		}else{
			show_404();
		}
		
		if($func=='edit'){
			if(($data['infomediasi'])!=''){
				if($data['infomediasi']->num_rows>0){
					foreach ($data['infomediasi']->result() as $row) {					
						$data['idperkara'] = base64_encode($this->encrypt->encode($row->perkara_id));
						$data['idmediasi'] = base64_encode($this->encrypt->encode($row->mediasi_id));
						$data['tglpermohonanmediasi'] = $this->tanggalhelper->convertToInputDate($row->tgl_permohonan_uh);
						$data['tanggal_penetapan'] = $this->tanggalhelper->convertToInputDate($row->penetapan_penunjukan_mediator);
						$data['tgl_pemberitahuan'] = $this->tanggalhelper->convertToInputDate($row->tgl_pemberitahuan_ke_ptma);
						$data['idmediator'] = $row->mediator_id;											
					}
				}else{
					show_404();
				}
			}else{
				show_404();
			}			 
		}
		$this->load->vars($data);
		$this->load->view('perkara/banding/edit_mediasi_banding');
	}

	function hasilmediasi(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();						
		$data['enc'] = $segment[2];
		$data['idperkara'] = $this->encrypt->decode(base64_decode($segment[2]));						
		if(empty($data['idperkara']) OR intval($data['idperkara'])<1){
			show_404();
		}
		$func = $segment[3];		
		if($func!='tambah' AND $func!='edit'){
			show_404();
		}
		$data['enc_id'] = '';
		if($func=='edit'){
			$data['enc_id'] = $segment[4];
		}		
		$data['enc_act'] = base64_encode($this->encrypt->encode($func));		
		$data['history'] = base_url(uri_string());
		$data['current_date'] =date('d/m/Y');
		$this->load->model('perkara/banding','banding');
		$data['infomediasi'] = $this->banding->getDataMediasiBanding($data['idperkara']);			
		$data['listmediator'] = $this->banding->getDataMediator();		
		if(!empty($data['infomediasi'])){
			foreach ($data['infomediasi']->result() as $row) {
				$data['keterangan'] = $row->catatan_mediasi;
			}
		}
		echo $data['keterangan'];
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '850px';
		$this->ckeditor->config['height'] = '250px';
		
		if($func=='edit'){
			if(($data['infomediasi'])!=''){
				if($data['infomediasi']->num_rows>0){
					foreach ($data['infomediasi']->result() as $row) {					
						$data['idperkara'] = base64_encode($this->encrypt->encode($row->perkara_id));
						$data['idmediasi'] = base64_encode($this->encrypt->encode($row->mediasi_id));						
						$data['tgl_lapor'] = $this->tanggalhelper->convertToInputDate($row->tgl_laporan_mediator);
						$data['tgl_pengiriman_kesepakatan'] = $this->tanggalhelper->convertToInputDate($row->tgl_kirim_kesepakatan_ke_ptma);						
						$data['tgl_perdamaian_cabut'] = $this->tanggalhelper->convertToInputDate($row->akta_perdamaian);
						$data['nama_mediator'] = $row->mediator_text;
						$data['hasilmediasi'] = $row->hasil_mediasi;
						$data['isi_kesepakatan'] = $row->isi_akta_perdamaian;					
					}
				}else{
					show_404();
				}
			}else{
				show_404();
			}			 
		}
		$this->load->vars($data);
		$this->load->view('perkara/banding/edit_hasil_mediasi_banding');
	}

	function savemediasi(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$act = $this->encrypt->decode(base64_decode($this->input->post('enc_act',TRUE)));		
		if($act !='tambah' AND $act !='edit'){
			echo json_encode(array('st'=>0,'msg'=>'Something Wrong With Your Data.'));
			return;
		}

		if($act=='edit'){
			$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
			if(!is_numeric($id) OR intval($id)<1){
				echo json_encode(array('st'=>0,'msg'=>'Something Wrong With Your Data.'));
				return;
			}
			$mediasi_id = $this->encrypt->decode(base64_decode($this->input->post('mediasi_id',TRUE)));
			if(!is_numeric($mediasi_id) OR intval($mediasi_id)<1){
				echo json_encode(array('st'=>0,'msg'=>'Something Wrong With Your Data.'));
				return;
			}
		}	

		$this->form_validation->set_rules('tglpermohonanmediasi', 'Tanggal Permohonan Mediasi', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('tanggal_penetapan', 'Tanggal Penetapan Mediator', 'trim|required|xss_clean|exact_length[10]');				
		$this->form_validation->set_rules('mediator', 'Nama Mediator', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tgl_pemberitahuan', 'Tanggal Pemberitahuan ke MA', 'trim|required|xss_clean|exact_length[10]');
		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');			
			$tanggalPermohonan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tglpermohonanmediasi',TRUE));
			$tanggalPenetapan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_penetapan',TRUE));
			$tanggalPemberitahuan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pemberitahuan',TRUE));			
			
			if(!empty($tanggalPermohonan) AND $tanggalPermohonan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Permohonan Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			if(!empty($tanggalPenetapan) AND $tanggalPenetapan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Penetapan Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}
			if(!empty($tanggalPemberitahuan) AND $tanggalPemberitahuan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Pemberitahuan Ke MA Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}			

			$selisihPermohonan = $this->tanggalhelper->getSelisihHari($tanggalPermohonan,$curr_date);
			if($selisihPermohonan<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Permohonan Mediasi Banding Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}
			$this->load->model('perkara/banding','banding');
			$databanding = $this->banding->getDataBanding($idperkara);
			if($databanding!=''){
				if($databanding->num_rows>0){
					foreach ($databanding->result() as $row) {						
						$tglpermohonanbanding = $row->permohonan_banding;						
					}
				}
			}			
			if(!empty($tanggalPermohonan) AND $tanggalPermohonan<$tglpermohonanbanding){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Permohonan Mediasi Tidak Boleh Kurang dari Tanggal Permohonan Banding'));
				return;
			}			
			$selisihPenetapan = $this->tanggalhelper->getSelisihHari($tanggalPenetapan,$curr_date);
			if($selisihPenetapan<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Mediator Banding Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}
			if(!empty($tanggalPenetapan) AND $tanggalPenetapan<$tanggalPermohonan){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Mediator Tidak Boleh Kurang dari Tanggal Permohonan'));
				return;
			}
			$selisihPemberitahuan = $this->tanggalhelper->getSelisihHari($tanggalPemberitahuan,$curr_date);
			if($selisihPemberitahuan<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan ke MA Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}
			if(!empty($tanggalPemberitahuan) AND $tanggalPemberitahuan<$tanggalPenetapan){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan ke MA Tidak Boleh Kurang dari Tanggal Penetapan Mediator'));
				return;
			}			
			
			$dayname = $this->tanggalhelper->getDayName($tanggalPermohonan);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Permohonan Mediasi Banding Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusanPN = '';
			$this->load->model('perkara/banding','banding');
			$dataputusan = $this->banding->getTanggalPutusan($idperkara);
			if($dataputusan->num_rows>0){
				foreach ($dataputusan->result() as $row) {
					$tglPutusanPN = $row->tanggal_putusan;
				}
			}
		
			if(empty($tglPutusanPN)){
				echo json_encode(array('st'=>0,'msg'=>'Tanggal Putusan Tingkat Pertama Tidak Diketemukan.'));
				return;
			}			
			
			$datamediasi = array(
				'perkara_id' => $idperkara,
				'tahapan_id' => 20,
				'dimulai_mediasi' => $tanggalPenetapan,
				'jenis_mediasi' => 2,
				'is_mediasi' => 1,
				'tgl_permohonan_uh' => $tanggalPermohonan,
				'penetapan_penunjukan_mediator' => $tanggalPenetapan,
				'tgl_pemberitahuan_ke_ptma' => $tanggalPemberitahuan,				
			);			

			$idmediator=trim($this->input->post('mediator',TRUE));			
			if(!is_numeric($idmediator)){
				echo json_encode(array('st'=>0,'msg'=>'Nama Mediator Tidak Ditemukan'));
				return;
			}
			$datamediasi['mediator_id']=$idmediator;
			$datamediator = $this->banding->infoMediator($datamediasi['mediator_id']);
			if($datamediator->num_rows>0){
				foreach ($datamediator->result() as $row) {					
					$datamediasi['status_mediator'] = $row->status_mediator;
					$datamediasi['mediator_text'] = $row->nama_gelar;
				}
			}					
			
			if($act=='tambah'){
				$maxid=$this->banding->get_maxid_mediasi();
				foreach ($maxid->result() as $row){
					$maxid_mediasi=$row->maxid;
				}
				$id_mediasi_akhir=intval($maxid_mediasi)+1;
				$datamediasi['mediasi_id'] = $id_mediasi_akhir;	
				$urutanmax =$this->banding->get_urutan_jadwal_mediasi_terakhir($id_mediasi_akhir);
				$urutanjadwal =  $urutanmax->row()->urutan + 1;

				$idmax = $this->banding->get_id_jadwal_mediasi_terakhir();
				$idjadwalberikutnya=$idmax->row()->id + 1;
				$jadwalmediasi= array(
					'id' => $idjadwalberikutnya,
					'mediasi_id' => $id_mediasi_akhir,
					'urutan' => $urutanjadwal,
					'tanggal_mediasi' => $tanggalPenetapan,
					'tempat' => 'Ditentukan Kemudian'
				);				
			}

			
			if($act=='edit'){
				$datamediasi['diperbaharui_tanggal'] = $this->session->userdata('username');
				$datamediasi['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
				$result = $this->banding->update_data_mediasi($datamediasi,$id);				
			}else if($act=='tambah'){
				$datamediasi['diinput_oleh'] = $this->session->userdata('username');
				$datamediasi['diinput_tanggal'] = date("Y-m-d h:i:s",time());
				$result = $this->banding->add_data_mediasi($datamediasi);
				$jadwalmediasi['diinput_oleh'] = $this->session->userdata('username');
				$jadwalmediasi['diinput_tanggal'] = date("Y-m-d h:i:s",time());
				$result = $this->banding->add_data_jadwal_mediasi($jadwalmediasi);				
			}
			
			if($result==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DISIMPAN.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN PENYIMPANAN.'));
				return;
			}
		}
	}

	function savehasilmediasi(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$act = $this->encrypt->decode(base64_decode($this->input->post('enc_act',TRUE)));		
		if($act !='tambah' AND $act !='edit'){
			echo json_encode(array('st'=>0,'msg'=>'Something Wrong With Your Data.'));
			return;
		}

		if($act=='edit'){
			$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
			if(!is_numeric($id) OR intval($id)<1){
				echo json_encode(array('st'=>0,'msg'=>'Something Wrong With Your Data.'));
				return;
			}
			$mediasi_id = $this->encrypt->decode(base64_decode($this->input->post('mediasi_id',TRUE)));
			if(!is_numeric($mediasi_id) OR intval($mediasi_id)<1){
				echo json_encode(array('st'=>0,'msg'=>'Something Wrong With Your Data.'));
				return;
			}
		}	
		
		$this->form_validation->set_rules('tgl_lapor', 'Tanggal Laporan Mediator', 'trim|xss_clean|exact_length[10]');		
		$this->form_validation->set_rules('st_hasil', 'Hasil Mediasi', 'trim|required|xss_clean|');
		$this->form_validation->set_rules('tgl_pengiriman_kesepakatan', 'Tanggal Pengiriman Kesepakatan', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('tgl_perdamaian_cabut', 'Tanggal Akta Perdamaian', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('isi_kesepakatan_text', 'Isi Kesepakatan Mediasi', 'trim|xss_clean|min_length[50]');
		$this->form_validation->set_rules('keterangan', 'Keterangan', 'trim|xss_clean|min_length[50]');
		
		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');						
			$tanggalLaporan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_lapor',TRUE));
			$tanggalKirimKesepakatan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pengiriman_kesepakatan',TRUE));			
			$tanggalPerdamaian = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_perdamaian_cabut',TRUE));
						
			if(!empty($tanggalLaporan) AND $tanggalLaporan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Laporan Mediator Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}
			if(!empty($tanggalKirimKesepakatan) AND $tanggalKirimKesepakatan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Kirim Kesepakatan Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}			
			if(!empty($tanggalPerdamaian) AND $tanggalPerdamaian==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Akta Perdamaian Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$this->load->model('perkara/banding','banding');			
			$infotglputusmediasi=$this->banding->getDataMediasiBanding($idperkara);
			if($infotglputusmediasi!=''){
				if($infotglputusmediasi->num_rows>0){
					foreach ($infotglputusmediasi->result() as $row) {						
						$tglputusmediasi = $row->keputusan_mediasi;
						$tanggalPemberitahuan = $row->tgl_pemberitahuan_ke_ptma;						
					}
				}
			}			
			
			$selisihLaporan = $this->tanggalhelper->getSelisihHari($tanggalLaporan,$curr_date);
			if($selisihLaporan<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Laporan oleh Mediator Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}
			if(!empty($tanggalLaporan) AND $tanggalLaporan<$tanggalPemberitahuan){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Laporan oleh Mediator Tidak Boleh Kurang dari Tanggal Pemberitahuan Ke MA'));
				return;
			}						
			
			$selisihKirimKesepakatan = $this->tanggalhelper->getSelisihHari($tanggalKirimKesepakatan,$curr_date);
			if($selisihKirimKesepakatan<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Kirim Kesepakatan Mediasi Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}
			if(!empty($tanggalKirimKesepakatan) AND $tanggalKirimKesepakatan<$tglputusmediasi){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Kirim Kesepakatan Mediasi Tidak Boleh Kurang dari Tanggal Putusan Mediasi'));
				return;
			}
			$selisihPerdamaian = $this->tanggalhelper->getSelisihHari($tanggalPerdamaian,$curr_date);
			if($selisihPerdamaian<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Perdamaian Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}
			if(!empty($tanggalPerdamaian) AND $tanggalPerdamaian<$tglputusmediasi){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Kirim Akta Perdamaian Tidak Boleh Kurang dari Tanggal Putusan Mediasi'));
				return;
			}					

			if(!empty($tanggalLaporan)){
				$datamediasi = array();								
				$datamediasi['tgl_laporan_mediator'] = $tanggalLaporan;

				$st_hasil = trim($this->input->post('st_hasil',TRUE));
				if($st_hasil!='Y' AND $st_hasil!='T' AND $st_hasil!='S' AND $st_hasil!='D'){
					echo json_encode(array('st'=>0,'msg'=>'Hasil Mediasi Tidak Ditemukan.'));
					return;
				}
				$datamediasi['hasil_mediasi'] = $st_hasil;
				if($st_hasil=='Y' || $st_hasil=='S'){					
					$amar = trim($this->input->post('isi_kesepakatan_text',TRUE));
					$amar = strip_tags($amar);
					$amar = htmlentities($amar, null, 'utf-8');
					$amar = str_replace("&nbsp;", " ", $amar);
					if(strlen($amar)<50){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Isi Kesepakatan Tidak Boleh kurang dari 50 Karakter'));
						return;
					}
					$datamediasi['isi_akta_perdamaian'] = $amar;
					$datamediasi['tgl_kirim_kesepakatan_ke_ptma'] = $tanggalKirimKesepakatan;
					$datamediasi['akta_perdamaian'] = $tanggalPerdamaian;
					$datamediasi['catatan_mediasi'] = '';
				}else if($st_hasil=='T' || $st_hasil=='D'){
					$keterangan = trim($this->input->post('keterangan',TRUE));
					$datamediasi['isi_akta_perdamaian'] = '';
					$datamediasi['tgl_kirim_kesepakatan_ke_ptma'] = $tanggalKirimKesepakatan;
					$datamediasi['akta_perdamaian'] = NULL;
					$datamediasi['catatan_mediasi'] = $keterangan;
				}				
			}
			
			if($act=='edit'){
				$datamediasi['diperbaharui_tanggal'] = $this->session->userdata('username');
				$datamediasi['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
				$result = $this->banding->update_data_mediasi($datamediasi,$id);				
			}else if($act=='tambah'){
				$datamediasi['diinput_oleh'] = $this->session->userdata('username');
				$datamediasi['diinput_tanggal'] = date("Y-m-d h:i:s",time());
				$result = $this->banding->add_data_mediasi($datamediasi);								
			}
			
			if($result==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DISIMPAN.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN PENYIMPANAN.'));
				return;
			}
		}
	}

	function validateEdit(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		$idmediasi = $this->encrypt->decode(base64_decode($this->input->post('encmediasi')));
		$idjadwalmediasi = $this->encrypt->decode(base64_decode($this->input->post('encjadwalmediasi')));

		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Data Perkara Tidak Ditemukan.'));
			return;
		}
		if(!is_numeric($idmediasi) OR !intval($idmediasi)>0){
			echo json_encode(array('st'=>0,'msg'=>'Data Mediasi Tidak Ditemukan.'));
			return;
		}
		if(!is_numeric($idjadwalmediasi) OR !intval($idjadwalmediasi)>0){
			echo json_encode(array('st'=>0,'msg'=>'Data Jadwal Mediasi Tidak Ditemukan.'));
			return;
		}
		
		$this->form_validation->set_rules('tempat', 'Tempat Pelaksanaan Mediasi', 'required|trim|xss_clean|max_length[500]|min_length[1]');

		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{

			$tanggal_mediasi=$this->input->post('tgl_mediasi',TRUE); 
			$tanggal_mediasi=$this->tanggalhelper->convertToMysqlDate($tanggal_mediasi);
			$tanggal_mediasi_sebelum=$this->input->post('tgljadwalmediasisblm',TRUE); 

			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$selisih = $this->tanggalhelper->getSelisihHari($tanggal_mediasi_sebelum,$tanggal_mediasi);
			if($selisih<=0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Sebelum Atau Tepat Pada Tanggal Mediasi Sebelumnya'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tanggal_mediasi,$curr_date);
			if($selisih<=0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Mediasi Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			if($tanggal_mediasi==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$tglpenetapansidangpertama=$this->tanggalhelper->getTanggalPenetapanSidangPertama($idperkara);
			
			if(empty($tglpenetapansidangpertama)){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Sidang Pertama Tidak Ditemukan.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglpenetapansidangpertama,$tanggal_mediasi);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Mediasi <u>Tidak Boleh Kurang</u> dari Tanggal Penetapan Sidang Pertama.'));
				return;
			}
			$dayname = $this->tanggalhelper->getDayName($tanggal_mediasi);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Mediasi Pada Hari Libur, Sabtu dan Minggu.'));
				exit();
			}

			$data_ruangan=$this->input->post('tempat',TRUE);

			$data=array(
				'tanggal_mediasi'=>$tanggal_mediasi,
				'tempat'=>$data_ruangan,
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
				);

			$this->load->model('perkara/banding','banding');
			$this->banding->update_jadwal_mediasi($idjadwalmediasi,$data,$idmediasi);
			echo json_encode(array('st'=>1,'msg'=>'Perubahan Data Mediasi Berhasil'));
			return;
		}
	}

	function validateTunda(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		$idmediasi = $this->encrypt->decode(base64_decode($this->input->post('encmediasi')));
		$idjadwalmediasi = $this->encrypt->decode(base64_decode($this->input->post('encjadwalmediasi')));

		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Data Perkara Tidak Ditemukan.'));
			return;
		}
		if(!is_numeric($idmediasi) OR !intval($idmediasi)>0){
			echo json_encode(array('st'=>0,'msg'=>'Data Mediasi Tidak Ditemukan.'));
			return;
		}
		if(!is_numeric($idjadwalmediasi) OR !intval($idjadwalmediasi)>0){
			echo json_encode(array('st'=>0,'msg'=>'Data Jadwal Mediasi Tidak Ditemukan.'));
			return;
		}

		$this->form_validation->set_rules('tempatsblm', 'Tempat Pelaksanaan Mediasi Sebelumnya', 'required|trim|xss_clean|max_length[500]|min_length[1]');
		$this->form_validation->set_rules('tempat', 'Tempat Pelaksanaan Mediasi', 'required|trim|xss_clean|max_length[500]|min_length[1]');
		$this->form_validation->set_rules('tgl_mediasi', 'Tanggal Mediasi', 'required|trim|xss_clean|exact_length[10]');
		
		$tanggaldipilih=$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_mediasi',TRUE));
		if($tanggaldipilih==false){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Sidang Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
			return;
		}

		$tanggalsebelum=$this->tanggalhelper->convertToMysqlDate($this->input->post('tglmediasisblm',TRUE));
		if($tanggalsebelum==false){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
			return;
		}

		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$selisih = $this->tanggalhelper->getSelisihHari($tanggalsebelum,$tanggaldipilih);
			if($selisih<=0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Sebelum Atau Tepat Pada Tanggal Sidang Sebelumnya.'));
				return;
			}

			$tanggal_mediasi=$tanggaldipilih;
			$tglpenetapansidangpertama=$this->tanggalhelper->getTanggalPenetapanSidangPertama($idperkara);
			
			if(empty($tglpenetapansidangpertama)){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Sidang Pertama Tidak Ditemukan.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglpenetapansidangpertama,$tanggal_mediasi);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Sidang Tidak Boleh Kurang dari Tanggal Penetapan Sidang Pertama.'));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tanggaldipilih);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Sidang Pada Hari Libur, Sabtu dan Minggu.'));
				return;
			}

			$this->load->model('perkara/banding','banding');

			$urutanmaxid=$this->banding->get_urutan_jadwal_mediasi_terakhir($idmediasi);
			$urutanBaru =  $urutanmaxid->row()->urutan + 1;
			$idmax = $this->banding->get_id_jadwal_mediasi_terakhir();
			$idjadwalberikutnya=$idmax->row()->id + 1;
			
			$data_ruangan_sebelumnya=$this->input->post('tempatsblm',TRUE);
			$data_ruangan=$this->input->post('tempat',TRUE);

			$data_update = array(
				'tempat'=>$data_ruangan_sebelumnya,
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);

			$data_insert = array(
				'id'=>$idjadwalberikutnya,
				'mediasi_id'=>$idmediasi,
				'urutan'=>$urutanBaru,
				'tanggal_mediasi'=>$tanggal_mediasi,
				'tempat'=>$data_ruangan,
				'diinput_oleh' => $this->session->userdata('username'),
				'diinput_tanggal' => date("Y-m-d h:i:s",time())
			);

			$data_update_tgl_kesepakatan = array(
				'keputusan_mediasi'=>$tanggal_mediasi,
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);

			$this->banding->tunda_mediasi($data_insert,$data_update,$data_update_tgl_kesepakatan,$idmediasi);						

			echo json_encode(array('st'=>1,'msg'=>'Pengisian Data Tundaan Mediasi Berhasil'));
			return;
		}
	}

	function editjadwalmediasi(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$data['curr_date'] = date('d/m/Y');

		$data['enc']=$this->nativesession->get_flash_session('enc');
		$data['encmediasi']=$this->nativesession->get_flash_session('encmediasi');
		$data['encjadwalmediasi']=$this->nativesession->get_flash_session('encjadwalmediasi');

		$idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }

		$idmediasi=$this->encrypt->decode(base64_decode($data['encmediasi']));
        if(!is_numeric($idmediasi) OR !intval($idmediasi)>0){
            show_404();
            exit();
        }

		$idjadwalmediasi=$this->encrypt->decode(base64_decode($data['encjadwalmediasi']));
        if(!is_numeric($idjadwalmediasi) OR !intval($idjadwalmediasi)>0){
            show_404();
            exit();
        }

		$this->load->model('perkara/banding','banding');		
		if ($query=$this->banding->get_detil_jadwal_mediasi($idjadwalmediasi)){
			$data['detjmediasi']=$query;
		}		
		$this->load->view('perkara/banding/jadwal_mediasi_banding',$data);
	}

	function tundajadwalmediasi(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$data['curr_date'] = date('d/m/Y'); // ini didunakan untuk validasi tanggal

		$data['enc']=$this->nativesession->get_flash_session('enc');
		$data['encmediasi']=$this->nativesession->get_flash_session('encmediasi');
		$data['encjadwalmediasi']=$this->nativesession->get_flash_session('encjadwalmediasi');

		$idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }

		$idmediasi=$this->encrypt->decode(base64_decode($data['encmediasi']));
        if(!is_numeric($idmediasi) OR !intval($idmediasi)>0){
            show_404();
            exit();
        }

		$idjadwalmediasi=$this->encrypt->decode(base64_decode($data['encjadwalmediasi']));
        if(!is_numeric($idjadwalmediasi) OR !intval($idjadwalmediasi)>0){
            show_404();
            exit();
        }

		$this->load->model('perkara/banding','banding');        
		if ($query=$this->banding->get_detil_jadwal_mediasi($idjadwalmediasi)){
			$data['detjmediasi']=$query;
		}		
		$this->load->view('perkara/banding/jadwal_mediasi_banding_tunda',$data);
	}

	function hapus_jadwal_mediasi(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$idjadwalmediasi = $this->encrypt->decode(base64_decode($this->input->post('encjadwalmediasi')));
		if(!is_numeric($idjadwalmediasi) OR !intval($idjadwalmediasi)>0){
			echo json_encode(array('st'=>0,'msg'=>'Jadwal Mediasi Tidak Ditemukan.'));
			return;
		}
		
		$this->load->model('perkara/banding','banding');
		if($this->banding->hapus_jadwal_mediasi($idjadwalmediasi)){			
			echo json_encode(array('st'=>1,'msg'=>'Penghapusan Data Jadwal Mediasi Berhasil'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'));
			return;
		}
	}
	/*18082015*/

	function parapihak(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc_id'] = $segment[3];
		$data['id'] = $this->encrypt->decode(base64_decode($segment[3]));
		if(empty($data['id']) OR intval($data['id'])<1){
			show_404();
		}
		$data['current_date'] =date('d/m/Y');
		$data['history'] = base_url(uri_string());
		$this->load->model('perkara/banding','banding');
		$data['infopihak'] = $this->banding->getPihakBanding($data['id']);
		$this->load->vars($data);
		$this->load->view('perkara/banding/edit_para_pihak');
	}

	function saveparapihak(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}
		$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
		if(empty($id) OR intval($id)<1){
			echo json_encode(array('st'=>0,'msg'=>'Permohonan Banding Tidak Ditemukan.'));
			return;
		}

		$diwakilkan = $this->input->post('diwakilkan',TRUE);
		if(empty($diwakilkan) OR !is_numeric($diwakilkan)){
			echo json_encode(array('st'=>0,'msg'=>'Something Not Right With The Data.'));
			return;
		}
		if($diwakilkan==1){
			$diwakilkan = 'Y';
			$this->form_validation->set_rules('fullname', 'Nama Pemohon', 'trim|required|xss_clean');
			$this->form_validation->set_rules('tgl_surat_kuasa', 'Tanggal Surat Kuasa', 'required|trim|xss_clean|exact_length[10]');
		}else{
			$diwakilkan = 'T';
		}
		$this->form_validation->set_rules('diwakilkan', 'Status Diwakilkan', 'trim|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$datapihak = array(
				'id' => $id,
				'pihak_diwakili' => $diwakilkan,
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);
			$idpihak = $this->encrypt->decode(base64_decode($this->input->post('enc_pihak',TRUE)));
			
			if(empty($idpihak) OR intval($idpihak)<1){
				echo json_encode(array('st'=>0,'msg'=>'Something Not Right With Your Data.'));
				return;
			}
			$this->load->model('perkara/banding',"banding");
			$pihak = $this->banding->getDataPihak($idpihak);
			if($pihak!=''){
				if($pihak->num_rows>0){
					foreach ($pihak->result() as $row) {
						$datapihak['pemohon_id'] = $row->id;
						$datapihak['pemohon_nama'] = $row->nama;
						$datapihak['pemohon_alamat'] = $row->alamat;
						$datapihak['pemohon_pekerjaan'] = $row->pekerjaan;
					}
				}
			}

			if($diwakilkan=='Y'){
				$infopihak = $this->banding->getPihakBanding($id);
				if($infopihak!=''){
					if($infopihak->num_rows>0){
						foreach ($infopihak->result() as $row) {
							$namapihak = $row->pihak_nama;
							$statusasal = $row->pihak_asal_text;
						}
					}
					$datapihak['pemohon_banding'] = $datapihak['pemohon_nama'].' Kuasa Dari '.$statusasal.':<br>'.$namapihak;
					$tglsuratkuasa = $this->input->post('tgl_surat_kuasa',TRUE);
					if(!empty($tglsuratkuasa)){
						$datapihak['pemohon_tanggal_surat'] = $this->tanggalhelper->convertToMysqlDate($tglsuratkuasa);
					}
					if($this->input->post('no_kuasa',TRUE))
						$datapihak['pemohon_nomor_surat'] = $this->input->post('no_kuasa',TRUE);
				}	
			}
			$result = $this->banding->update_data($datapihak,$id);
			if($result==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DISIMPAN.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL Melakukan Penyimpanan.'));
				return;
			}
		}
	}

	function permohonan(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc_id'] = $segment[3];
		$data['id'] = $this->encrypt->decode(base64_decode($segment[3]));
		$data['enc'] = $segment[2];
		$idperkara = $this->encrypt->decode(base64_decode($segment[2]));
		if(empty($data['id']) OR intval($data['id'])<1){
			show_404();
		}
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}

		$data['history'] = base_url(uri_string());
		$data['current_date'] =date('d/m/Y'); 
		$this->load->model('perkara/banding','banding');

		$data['infopihak'] = $this->banding->getPihakBanding($data['id']);
		$idalurperkara = $this->banding->getAlurPerkara($idperkara);
		$data['enc_alur']=base64_encode($this->encrypt->encode($idalurperkara));
		
		$stpihak = $this->banding->getStatusPihak($idalurperkara);
		if($stpihak!=''){
			if($stpihak->num_rows>0){
				foreach ($stpihak->result() as $row) {
					$statuspihak[$row->pihak_ke] = $row->nama;
				}
			}
		}
		$data['statuspihak'] = $statuspihak;
		$data['idalurperkara'] = $idalurperkara;
		$this->load->vars($data);
		$this->load->view('perkara/banding/edit_permohonan_banding');
	}

	function savepermohonan(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}
		$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
		if(empty($id) OR intval($id)<1){
			echo json_encode(array('st'=>0,'msg'=>'Permohonan Banding Tidak Ditemukan.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->form_validation->set_rules('tgl_pendaftaran', 'Tanggal Pendaftaran', 'trim|required|xss_clean|exact_length[10]');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$tglPendaftaran = $this->input->post('tgl_pendaftaran',TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tglPendaftaran = $this->tanggalhelper->convertToMysqlDate($tglPendaftaran);
			if($tglPendaftaran==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPendaftaran,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pendaftaran Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglPendaftaran);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pendaftaran Dihari Libur, Sabtu dan Minggu.'));
				return;
			}
 
			$tglcabut = '';
			$tglPutusanPN = '';
			$this->load->model('perkara/banding','banding');
			$dataputusan = $this->banding->getTanggalPutusan($idperkara);
			if($dataputusan->num_rows>0){
				foreach ($dataputusan->result() as $row) {
					$tglPutusanPN = $row->tanggal_putusan;
					$tglcabut = $row->tanggal_cabut;
				}
			}
			if(!empty($tglcabut)){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Dapat Dimohonkan Banding Karena Telah Dicabut.'));
				return;
			}

			if(empty($tglPutusanPN)){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Dapat Dimohonkan Banding Karena Belum Putus.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusanPN,$tglPendaftaran);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Permohonan Tidak Boleh Kurang Dari Tanggal Putusan'));
				return;
			}

			
			$datapihak = array(
				'permohonan_banding' => $tglPendaftaran,
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);
			$result = $this->banding->update_data($datapihak,$id);

			$databanding = $this->banding->getPihakBanding($id);
			$idstatus = '';
			$urutan ='';
			if($databanding->num_rows>0){
				foreach ($databanding->result() as $row) {
					$idstatus = $row->status_pihak_id;
					$urutan = $row->urutan_banding;
				}
			}
			if(!empty($idstatus) AND !empty($urutan)){
				if($idstatus==1 AND $urutan==1){
					$datapihak = array(
						'permohonan_banding' => $tglPendaftaran,
						'diperbaharui_oleh' => $this->session->userdata('username'),
						'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);
					$result = $this->banding->update_data_banding($datapihak,$idperkara);
				}
			}
			if($result==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DISIMPAN.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN PENYIMPANAN.'));
				return;
			}
		}
	}

	function cabut(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc_id'] = $segment[3];
		$data['id'] = $this->encrypt->decode(base64_decode($segment[3]));
		$data['enc'] = $segment[2];
		$idperkara = $this->encrypt->decode(base64_decode($segment[2]));
		if(empty($data['id']) OR intval($data['id'])<1){
			show_404();
		}
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}

		$data['history'] = base_url(uri_string());
		$data['current_date'] =date('d/m/Y'); 
		$this->load->model('perkara/banding','banding');
		$data['infopihak'] = $this->banding->getPihakBanding($data['id']);
		$this->load->vars($data);
		$this->load->view('perkara/banding/cabut_permohonan_banding');
	}

	function savecabut(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}

		$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
		if(empty($id) OR intval($id)<1){
			echo json_encode(array('st'=>0,'msg'=>'Permohonan Banding Tidak Ditemukan.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->form_validation->set_rules('tgl_cabut', 'Tanggal Pencabutan Perkara', 'trim|required|xss_clean|exact_length[10]');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$tglCabut = $this->input->post('tgl_cabut',TRUE);
			$tglCabut = $this->tanggalhelper->convertToMysqlDate($tglCabut);
			if($tglCabut==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			//$curr_date = date('d/m/Y');
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$selisih = $this->tanggalhelper->getSelisihHari($tglCabut,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pencabutan Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglCabut);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pencabutan Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusanPN = '';
			$this->load->model('perkara/banding','banding');
			$dataputusan = $this->banding->getTanggalPutusan($idperkara);
			if($dataputusan->num_rows>0){
				foreach ($dataputusan->result() as $row) {
					$tglPutusanPN = $row->tanggal_putusan;
				}
			}
			
			//echo $tglPutusanPN;
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusanPN,$tglCabut);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pencabutan Tidak Boleh Kurang Dari Tanggal Putusan PN'));
				return;
			}

			
			$datapihak = array(
				'tanggal_cabut' => $tglCabut,
				'keterangan' => $this->input->post('keterangan',TRUE),
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);
			$result = $this->banding->update_data($datapihak,$id);
			$databanding = $this->banding->getPihakBanding($id);
			$idstatus = '';
			$urutan ='';
			if($databanding->num_rows>0){
				foreach ($databanding->result() as $row) {
					$idstatus = $row->status_pihak_id;
					$urutan = $row->urutan_banding;
				}
			}
			$pihakbanding = $this->banding->getListPihakBanding($idperkara);
			if(!empty($pihakbanding)){
				if($pihakbanding->num_rows>0){
					foreach ($pihakbanding->result() as $row) {
						$idstatus = $row->status_pihak_id;
						$urutan = $row->urutan_banding;
					}
				}
			}

			$isAllCabut = $this->banding->isAllCabut($idperkara);

			if($isAllCabut->num_rows>0){
				$datapihak = array(
						'tanggal_cabut' => $tglCabut,
						'status_banding_id' => 391,
						'minutasi_banding' => $tglCabut,
						'status_banding_text' => 'Pencabutan Perkara Banding',
						'diperbaharui_oleh' => $this->session->userdata('username'),
						'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);
				$result = $this->banding->update_data_banding($datapihak,$idperkara);
				
			}
			$result = $this->banding->addPerkaraProses($idperkara,'391','Pencabutan Perkara Banding',$tglCabut);
			$result = $this->banding->updatePerkaraProses($idperkara);
			if($result==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DISIMPAN.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN PENYIMPANAN.'));
				return;
			}
		}
	}

	function edittanggal(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc_id'] = $segment[3];
		$data['id'] = $this->encrypt->decode(base64_decode($segment[3]));
		$data['enc'] = $segment[2];
		$idperkara = $this->encrypt->decode(base64_decode($segment[3]));
		if(empty($data['id']) OR intval($data['id'])<1){
			show_404();
		}
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}
		$func = $segment[4];
		if(empty($func) OR intval($func)<1){
			show_404();
		}
		$data['enc_func'] = base64_encode($this->encrypt->encode($segment[4]));
		$data['openinput'] = 2;
		$this->load->model('perkara/banding','banding');
		$infopihaks = $this->banding->getPihakBanding($data['id']);
		if($infopihaks!=''){
			if($infopihaks->num_rows>0){
				foreach ($infopihaks->result() as $row) {
					$data['namapihak'] = $row->pihak_nama;
					$data['statusbanding'] = $row->status_pihak_text.' Ke-'.$row->urutan_banding;
					$data['noperkarapn'] = $row->nomor_perkara_pn;
					$data['tglpermohonan'] = $this->tanggalhelper->convertToInputDate($row->permohonan_banding);
					$data['idpihak'] = base64_encode($this->encrypt->encode($row->pihak_id));
					$data['idperkara'] = base64_encode($this->encrypt->encode($row->perkara_id));
				}
			}
		}else{
			show_404();
		}
		if($func==1){
			$data['title'] = "EDIT - TANGGAL PEMBERITAHUAN PERMOHONAN BANDING";
			$data['subtitle'] = 'Tanggal Pemberitahuan Permohonan';
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($infopihaks->row()->pemberitahuan);
		}elseif($func==2){
			$data['title'] = "EDIT - TANGGAL PENERIMAAN MEMORI BANDING";
			$data['subtitle'] = 'Tanggal Penerimaan Memori';
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($infopihaks->row()->pen_memori);
		}elseif($func==3){
			$data['title'] = "EDIT - TANGGAL PENYERAHAN MEMORI BANDING";
			$data['subtitle'] = 'Tanggal Penyerahan Memori';
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($infopihaks->row()->peny_memori);
		}elseif($func==4){
			$data['title'] = "EDIT - TANGGAL PENERIMAAN KONTRA MEMORI BANDING";
			$data['subtitle'] = 'Tanggal Penerimaan Kontra';
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($infopihaks->row()->pen_kontra);
		}elseif($func==5){
			$data['title'] = "EDIT - TANGGAL PENYERAHAN KONTRA MEMORI BANDING";
			$data['subtitle'] = 'Tanggal Penyerahan Kontra';
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($infopihaks->row()->peny_kontra);
		}elseif($func==6){
			$data['title'] = "EDIT - TANGGAL PEMBERITAHUAN INZAGE";
			$data['subtitle'] = 'Tanggal Pemberitahuan Inzage';
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($infopihaks->row()->pen_inzage);
		}elseif($func==8){
			$data['title'] = "EDIT - TANGGAL PEMBERITAHUAN PUTUSAN BANDING";
			$data['subtitle'] = 'Tanggal Pemberitahuan Putusan';
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($infopihaks->row()->pen_putus);
		}elseif($func==7){
			$result = $this->banding->getDataBanding($idperkara);
			if($result!=''){
				if($result->num_rows>0){
					foreach ($result->result() as $row) {
						$data['idperkara'] = base64_encode($this->encrypt->encode($row->perkara_id));
						$data['tanggal'] = $this->tanggalhelper->convertToInputDate($row->pengiriman_berkas_banding);
						$data['input_area'] = $row->nomor_surat_pengiriman_berkas_banding;
					}
				}else{
					show_404();
				}
			}else{
				show_404();
			}
			$data['title'] = "EDIT - TANGGAL PENGIRIMAN BERKAS BANDING";
			$data['subtitle'] = 'Tanggal Pengiriman Berkas';
			$data['openinput'] = 1;
			$data['inputsubtitle'] = 'Nomor Surat Pengiriman Berkas Banding';
		}else{
			show_404();
		}
		$data['history'] = base_url(uri_string());
		$data['current_date'] =date('d/m/Y'); 
		
		$this->load->vars($data);
		$this->load->view('perkara/banding/edit_tanggal');
	}

	function savetanggal(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}

		$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
		if(empty($id) OR intval($id)<1){
			echo json_encode(array('st'=>0,'msg'=>'Permohonan Banding Tidak Ditemukan.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$func = $this->encrypt->decode(base64_decode($this->input->post('enc_func',TRUE)));
		if(empty($func) OR intval($func)<1){
			echo json_encode(array('st'=>0,'msg'=>'Something Wrong With Your Data.'));
			return;
		}

		$this->form_validation->set_rules('tanggal', 'Tanggal', 'trim|required|xss_clean|exact_length[10]');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$tanggal = $this->input->post('tanggal',TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tanggal = $this->tanggalhelper->convertToMysqlDate($tanggal);
			if($tanggal==FALSE){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tanggal);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusanPN = '';
			$this->load->model('perkara/banding','banding');
			$dataputusan = $this->banding->getTanggalPutusan($idperkara);
			if($dataputusan->num_rows>0){
				foreach ($dataputusan->result() as $row) {
					$tglPutusanPN = $row->tanggal_putusan;
				}
			}
		
			if(empty($tglPutusanPN)){
				echo json_encode(array('st'=>0,'msg'=>'Tanggal Putusan Tingkat Pertama Tidak Diketemukan.'));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusanPN,$tanggal);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Tidak Boleh Kurang Dari Tanggal Putusan PN'));
				return;
			}

			$tgl_permohonan_banding =$this->banding->getDataBanding($idperkara);
			if($tgl_permohonan_banding->num_rows>0){
				foreach ($tgl_permohonan_banding->result() as $row) {
					$tgl_mohon_banding = $row->permohonan_banding;
				}
			}
			if(empty($tgl_mohon_banding)){
				echo json_encode(array('st'=>0,'msg'=>'Tanggal Permohonan Banding Tidak Diketemukan.'));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($tgl_mohon_banding,$tanggal);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Tidak Boleh Kurang Dari Tanggal Permohonan Banding'));
				return;
			}

			$datapihak = array(
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);
			$databanding = $datapihak;
			$tglputusanbanding = $this->banding->getTanggalPutusanBanding($idperkara);
			if($func==1){
				if(!empty($tglputusanbanding)){
					$selisih = $this->tanggalhelper->getSelisihHari($tglputusanbanding,$tanggal);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Permohonan Banding Tidak Boleh Kurang Dari Tanggal Putusan Banding'));
						return;
					}
				}
				$datapihak['pemberitahuan_permohonan_banding'] = $tanggal;
				$databanding['pemberitahuan_permohonan_banding'] = $tanggal;
				$dataproses['status_banding_id'] = 301;
				$dataproses['status_banding_text'] = 'Pemberitahuan Permohonan Banding';
			}elseif($func==2){
				if(!empty($tglputusanbanding)){
					$selisih = $this->tanggalhelper->getSelisihHari($tglputusanbanding,$tanggal);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penerimaan Memori Banding Tidak Boleh Kurang Dari Tanggal Putusan Banding'));
						return;
					}
				}
				$datapihak['penerimaan_memori_banding'] = $tanggal;
				$databanding['penerimaan_memori_banding'] = $tanggal;
				$dataproses['status_banding_id'] = 310;
				$dataproses['status_banding_text'] = 'Penerimaan Memori Banding';
			}elseif($func==3){
				if(!empty($tglputusanbanding)){
					$selisih = $this->tanggalhelper->getSelisihHari($tglputusanbanding,$tanggal);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penyerahan Memori Banding Tidak Boleh Kurang Dari Tanggal Putusan Banding'));
						return;
					}
				}
				$datapihak['penyerahan_memori_banding'] = $tanggal;
				$databanding['penyerahan_memori_banding'] = $tanggal;
				$dataproses['status_banding_id'] = 320;
				$dataproses['status_banding_text'] = 'Penyerahan Memori Banding';
			}elseif($func==4){
				if(!empty($tglputusanbanding)){
					$selisih = $this->tanggalhelper->getSelisihHari($tglputusanbanding,$tanggal);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penerimaan Kontra Banding Tidak Boleh Kurang Dari Tanggal Putusan Banding'));
						return;
					}
				}
				$datapihak['penerimaan_kontra_banding'] = $tanggal;
				$databanding['penerimaan_kontra_banding'] = $tanggal;
				$dataproses['status_banding_id'] = 330;
				$dataproses['status_banding_text'] = 'Penerimaan Kontra Memori Banding';
			}elseif($func==5){
				if(!empty($tglputusanbanding)){
					$selisih = $this->tanggalhelper->getSelisihHari($tglputusanbanding,$tanggal);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penyerahan Kontra Banding Tidak Boleh Kurang Dari Tanggal Putusan Banding'));
						return;
					}
				}
				$datapihak['penyerahan_kontra_banding'] = $tanggal;
				$databanding['penyerahan_kontra_banding'] = $tanggal;
				$dataproses['status_banding_id'] = 340;
				$dataproses['status_banding_text'] = 'Penyerahan Kontra Memori Banding';
			}elseif($func==6){
				if(!empty($tglputusanbanding)){
					$selisih = $this->tanggalhelper->getSelisihHari($tglputusanbanding,$tanggal);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Inzage Banding Tidak Boleh Kurang Dari Tanggal Putusan Banding'));
						return;
					}
				}
				$datapihak['pemberitahuan_inzage'] = $tanggal;
				$datapihak['pemberitahuan_inzage'] = $tanggal;
				$dataproses['status_banding_id'] = 350;
				$dataproses['status_banding_text'] = 'Permberitahuan Untuk Memeriksa Berkas(Inzage)';
			}elseif($func==8){
				if(empty($tglputusanbanding)){
					echo json_encode(array('st'=>0,'msg'=>'Perkara Belum dinyatakan Putus.'));
					return;
				}
				$selisih = $this->tanggalhelper->getSelisihHari($tglputusanbanding,$tanggal);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Putusan Banding Tidak Boleh Kurang Dari Tanggal Putusan Banding'));
					return;
				}
				$datapihak['pemberitahuan_putusan_banding'] = $tanggal;
				$databanding['pemberitahuan_putusan_banding'] = $tanggal;
				$dataproses['status_banding_id'] = 400;
				$dataproses['status_banding_text'] = 'Pemberitahuan Putusan Banding';
			}else{
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Permintaan Tidak Diketahui.'));
				return;
			}
			$result = $this->banding->update_data($datapihak,$id);
			$result = $this->banding->update_data_banding($databanding,$idperkara);
			if($result==TRUE){
				$this->banding->update_proses($idperkara,$dataproses['status_banding_id'],$dataproses['status_banding_text']);
				$this->banding->addPerkaraProses($idperkara,$dataproses['status_banding_id'],$dataproses['status_banding_text'],$tanggal);
				$this->banding->updatePerkaraProses($idperkara);
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DISIMPAN.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN PENYIMPANAN.'));
				return;
			}
		}
	}

	function saveberkas(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$func = $this->encrypt->decode(base64_decode($this->input->post('enc_func',TRUE)));
		if(empty($func) OR intval($func)<1){
			echo json_encode(array('st'=>0,'msg'=>'Something Wrong With Your Data.'));
			return;
		}

		$this->form_validation->set_rules('tanggal', 'Tanggal', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('input_area', 'Nomor Pengiriman Berkas Banding', 'trim|required|xss_clean|min_length[5]');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$tanggal = $this->input->post('tanggal',TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');
			
			$tanggal = $this->tanggalhelper->convertToMysqlDate($tanggal);			
			if($tanggal==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$curr_date);			
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}			

			$dayname = $this->tanggalhelper->getDayName($tanggal);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusanPN = '';
			$this->load->model('perkara/banding','banding');
			$dataputusan = $this->banding->getTanggalPutusan($idperkara);
			if($dataputusan->num_rows>0){
				foreach ($dataputusan->result() as $row) {
					$tglPutusanPN = $row->tanggal_putusan;
				}
			}
		
			if(empty($tglPutusanPN)){
				echo json_encode(array('st'=>0,'msg'=>'Tanggal Putusan Tingkat Pertama Tidak Diketemukan.'));
				return;
			}
			
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusanPN,$tanggal);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Tidak Boleh Kurang Dari Tanggal Putusan PN'));
				return;
			}

			
			$datapihak = array(
				'pengiriman_berkas_banding' => $tanggal,
				'nomor_surat_pengiriman_berkas_banding' => $this->input->post('input_area',TRUE),
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);

			$result = $this->banding->update_data_banding($datapihak,$idperkara);
			if($result==TRUE){
				$this->banding->update_proses($idperkara,370,'Pengiriman Berkas Banding');
				$this->banding->addPerkaraProses($idperkara,370,'Pengiriman Berkas Banding',$tanggal);
				$this->banding->updatePerkaraProses($idperkara);
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DISIMPAN.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN PENYIMPANAN.'));
				return;
			}
		}
	}

	function putusan(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc'] = $segment[2];
		$idperkara = $this->encrypt->decode(base64_decode($segment[2]));
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}

		$data['history'] = base_url(uri_string());
		$data['current_date'] =date('d/m/Y'); 
		$data['amar'] = '';
		$data['perkaraid'] = $idperkara;

		$this->load->model('perkara/banding','banding');
		$data['listHakim'] = $this->banding->getDataHakimPT();
		$data['listPanitera'] = $this->banding->getDataPaniteraPT();
		$databanding = $this->banding->getDataBanding($idperkara);
		if($databanding!=''){
			if($databanding->num_rows>0){
				foreach ($databanding->result() as $row) {
					$data['idperkara'] = base64_encode($this->encrypt->encode($row->perkara_id));
					$data['noperkarapn'] = $row->nomor_perkara_pn;
					$data['input_area'] = $row->nomor_putusan_banding;
					$data['tglpermohonan'] = $this->tanggalhelper->convertDayDate($row->permohonan_banding);
					$data['amar'] = $row->amar_putusan_banding;
					$data['tanggal'] = $this->tanggalhelper->convertToInputDate($row->putusan_banding);
					$data['tgl_arsip'] = $this->tanggalhelper->convertToInputDate($row->minutasi_banding);
					$data['tgl_berkas'] = $this->tanggalhelper->convertToInputDate($row->penerimaan_kembali_berkas_banding);
					$data['tglputusan'] = $this->tanggalhelper->convertToInputDate($row->putusan_pn);
					$data['hakim1'] =$row->hakim1_banding_id;
					$data['hakim2'] =$row->hakim2_banding_id;
					$data['hakim3'] =$row->hakim3_banding_id;
					$data['hakim4'] =$row->hakim4_banding_id;
					$data['hakim5'] =$row->hakim5_banding_id;
					$data['panitera'] =$row->panitera_pengganti_banding_id;
					$data['statusputusan'] =$row->status_putusan_banding_id;
				}
			}else{
				show_404();
			}
		}else{
			show_404();
		}
		
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '850px';
		$this->ckeditor->config['height'] = '250px';
		$this->load->vars($data);
		$this->load->view('perkara/banding/edit_putusan');
	}

	function saveputusan(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->form_validation->set_rules('tanggal', 'Tanggal Putusan Banding', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('input_area', 'Nomor Pengiriman Berkas Banding', 'trim|required|xss_clean|min_length[5]');
		#$this->form_validation->set_rules('tgl_arsip', 'Tanggal Pengarsipan Berkas Banding', 'trim|required|xss_clean|exact_length[10]');
		#$this->form_validation->set_rules('tgl_berkas', 'Tanggal Penerimaan Kembali Berkas Banding', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('amar_text', 'Amar Putusan', 'trim|required|xss_clean|min_length[50]');
		$this->form_validation->set_rules('st_putusan', 'Status Putusan', 'trim|required|numeric|xss_clean|');
		
		$idalurperkara = $this->tanggalhelper->getIDAlurPerkara($idperkara);
		if($idalurperkara==118){
			$this->form_validation->set_rules('hakim_tunggal', 'Hakim Tunggal', 'trim|required|xss_clean|');
		}else{
			$this->form_validation->set_rules('hakim_ketua', 'Hakim Ketua', 'trim|required|xss_clean|');
		}
		
		$this->form_validation->set_rules('panitera', 'Panitera Pengganti', 'trim|required|xss_clean|');
		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			//$tanggal = $this->input->post('tanggal',TRUE);
			$tanggal = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal',TRUE));
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan Banding Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}
			//$tanggal = $this->tanggalhelper->convertToMysqlDate($tanggal);
			if($tanggal==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tanggal);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Putusan Banding Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusanPN = '';
			$this->load->model('perkara/banding','banding');
			$dataputusan = $this->banding->getTanggalPutusan($idperkara);
			if($dataputusan->num_rows>0){
				foreach ($dataputusan->result() as $row) {
					$tglPutusanPN = $row->tanggal_putusan;
				}
			}
		
			if(empty($tglPutusanPN)){
				echo json_encode(array('st'=>0,'msg'=>'Tanggal Putusan Tingkat Pertama Tidak Diketemukan.'));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusanPN,$tanggal);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan Banding Tidak Boleh Kurang Dari Tanggal Putusan PN'));
				return;
			}


			$amar = trim($this->input->post('amar_text',TRUE));
			$amar = strip_tags($amar);
			$amar = htmlentities($amar, null, 'utf-8');
			$amar = str_replace("&nbsp;", " ", $amar);
			if(strlen($amar)<50){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Amar Putusan Tidak Boleh kurang dari 50 Karakter'));
				return;
			}

			$st_putusan = trim($this->input->post('st_putusan',TRUE));
			if(!is_numeric($st_putusan) OR intval($st_putusan)<1){
				echo json_encode(array('st'=>0,'msg'=>'Status Putusan Tidak Ditemukan.'));
				return;
			}
			if($st_putusan==1){
				$st_putusan_text = 'Diperbaiki';
			}elseif($st_putusan==2){
				$st_putusan_text = 'Dikuatkan';
			}elseif($st_putusan==3){
				$st_putusan_text = 'Dibatalkan';
			}elseif($st_putusan==4){
				$st_putusan_text = 'Tidak Diterima';
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Status Putusan Tidak Ditemukan.'));
				return;
			}
			
			$databanding = array(
				'amar_putusan_banding' => $amar,
				'putusan_banding' => $tanggal,
				'status_putusan_banding_id' => $st_putusan,
				'status_putusan_banding_text' => $st_putusan_text,
				'nomor_putusan_banding' => $this->input->post('input_area',TRUE),
				'nomor_perkara_banding' => $this->input->post('input_area',TRUE),
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);

			$tglArsip = $this->input->post('tgl_arsip',TRUE);
			if(!empty($tglArsip)){
				$tglArsip = $this->tanggalhelper->convertToMysqlDate($tglArsip);
				if($tglArsip==false){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
					return;
				}

				$dayname = $this->tanggalhelper->getDayName($tglArsip);
				if($dayname=='Saturday' OR $dayname=='Sunday'){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pengarsipan Berkas Banding Dihari Libur, Sabtu dan Minggu.'));
					return;
				}

				$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$tglArsip);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pengarsipan Berkas Banding Tidak Boleh Kurang Dari Tanggal Putusan Banding'));
					return;
				}
				$databanding['minutasi_banding'] = $tglArsip;
			}
			$tglTerimaBerkas = $this->input->post('tgl_berkas',TRUE);
			if(!empty($tglTerimaBerkas)){
				$tglTerimaBerkas = $this->tanggalhelper->convertToMysqlDate($tglTerimaBerkas);
				if($tglTerimaBerkas==false){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
					return;
				}

				$dayname = $this->tanggalhelper->getDayName($tglTerimaBerkas);
				if($dayname=='Saturday' OR $dayname=='Sunday'){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penerimaan Kembali Berkas Banding Dihari Libur, Sabtu dan Minggu.'));
					return;
				}

				$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$tglTerimaBerkas);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penerimaan Kembali Berkas Banding Tidak Boleh Kurang Dari Tanggal Putusan Banding'));
					return;
				}
				$databanding['penerimaan_kembali_berkas_banding'] = $tglTerimaBerkas;
			}

			$tmpid = '';
			$listHakim = $this->banding->getDataHakimPT();
			$hakimtunggal = $this->input->post('hakim_tunggal',TRUE);
			if(!empty($hakimtunggal)){
				$idhakimketua = $this->encrypt->decode(base64_decode($hakimtunggal));
				if(!is_numeric($idhakimketua) OR intval($idhakimketua)<1){
					echo json_encode(array('st'=>0,'msg'=>'Hakim Tunggal Tidak Ditemukan.'));
					return;
				}
				$databanding['hakim1_banding_id'] = $idhakimketua;
				$nama = $this->parseName($listHakim,$idhakimketua);
				if(empty($nama)){
					echo json_encode(array('st'=>0,'msg'=>'Hakim Tunggal Tidak Ditemukan.'));
					return;
				}
				$databanding['hakim1_banding'] = $nama;
				$databanding['majelis_hakim_banding'] = 'Hakim Tunggal : '.$nama;
				$tmpid[0] = $idhakimketua;
			}else{
				$hakim = $this->input->post('hakim_ketua',TRUE);
				if(!empty($hakim)){
					$idhakimketua = $this->encrypt->decode(base64_decode($hakim));
					if(!is_numeric($idhakimketua) OR intval($idhakimketua)<1){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Ketua Tidak Ditemukan.'));
						return;
					}
					$databanding['hakim1_banding_id'] = $idhakimketua;
					$nama = $this->parseName($listHakim,$idhakimketua);
					if(empty($nama)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Ketua Tidak Ditemukan.'));
						return;
					}
					$databanding['hakim1_banding'] = $nama;
					$databanding['majelis_hakim_banding'] = 'Hakim Ketua : '.$nama;
					$tmpid[0] = $idhakimketua;
				}

				$hakim = $this->input->post('hakim_anggota_1',TRUE);
				if(!empty($hakim)){
					$idhakim1 = $this->encrypt->decode(base64_decode($hakim));
					if(!is_numeric($idhakim1) OR intval($idhakim1)<1){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 1 Tidak Ditemukan.'));
						return;
					}
					if(empty($idhakimketua)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Ketua Belum Dipilih.'));
						return;
					}
					$databanding['hakim2_banding_id'] = $idhakim1;
					$nama = $this->parseName($listHakim,$idhakim1);
					if(empty($nama)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 1 Tidak Ditemukan.'));
						return;
					}
					if(in_array($idhakim1, $tmpid)){
						echo json_encode(array('st'=>0,'msg'=>'Duplikasi Data Hakim. Mohon Memilih Hakim Yang Sesuai'));
						return;
					}
					$tmpid[1] = $idhakim1;
					$databanding['hakim2_banding'] = $nama;
					$databanding['majelis_hakim_banding'] .= '<br>'.'Hakim Anggota 1 : '.$nama;
				}

				$hakim = $this->input->post('hakim_anggota_2',TRUE);
				if(!empty($hakim)){
					$idhakim2 = $this->encrypt->decode(base64_decode($hakim));
					if(!is_numeric($idhakim2) OR intval($idhakim2)<1){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 2 Tidak Ditemukan.'));
						return;
					}
					if(empty($idhakimketua)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Ketua Belum Dipilih.'));
						return;
					}
					if(empty($idhakim1)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 1 Belum Dipilih.'));
						return;
					}
					$databanding['hakim3_banding_id'] = $idhakim2;
					$nama = $this->parseName($listHakim,$idhakim2);
					if(empty($nama)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 2 Tidak Ditemukan.'));
						return;
					}
					if(in_array($idhakim2, $tmpid)){
						echo json_encode(array('st'=>0,'msg'=>'Duplikasi Data Hakim. Mohon Memilih Hakim Yang Sesuai'));
						return;
					}
					$tmpid[2] = $idhakim2;
					$databanding['hakim3_banding'] = $nama;
					$databanding['majelis_hakim_banding'] .= '<br>'.'Hakim Anggota 2 : '.$nama;
				}

				$hakim = $this->input->post('hakim_anggota_3',TRUE);
				if(!empty($hakim)){
					$idhakim3 = $this->encrypt->decode(base64_decode($hakim));
					if(!is_numeric($idhakim3) OR intval($idhakim3)<1){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 3 Tidak Ditemukan.'));
						return;
					}
					if(empty($idhakimketua)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Ketua Belum Dipilih.'));
						return;
					}
					if(empty($idhakim1)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 1 Belum Dipilih.'));
						return;
					}
					if(empty($idhakim2)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 2 Belum Dipilih.'));
						return;
					}
					$databanding['hakim4_banding_id'] = $idhakim3;
					$nama = $this->parseName($listHakim,$idhakim3);
					if(empty($nama)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 3 Tidak Ditemukan.'));
						return;
					}
					if(in_array($idhakim3, $tmpid)){
						echo json_encode(array('st'=>0,'msg'=>'Duplikasi Data Hakim. Mohon Memilih Hakim Yang Sesuai'));
						return;
					}
					$tmpid[3] = $idhakim3;

					$databanding['hakim4_banding'] = $nama;
					$databanding['majelis_hakim_banding'] .= '<br>'.'Hakim Anggota 3 : '.$nama;
				}

				$hakim = $this->input->post('hakim_anggota_4',TRUE);
				if(!empty($hakim)){
					$idhakim4 = $this->encrypt->decode(base64_decode($hakim));
					if(!is_numeric($idhakim4) OR intval($idhakim4)<1){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 4 Tidak Ditemukan.'));
						return;
					}
					if(empty($idhakimketua)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Ketua Belum Dipilih.'));
						return;
					}
					if(empty($idhakim1)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 1 Belum Dipilih.'));
						return;
					}
					if(empty($idhakim2)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 2 Belum Dipilih.'));
						return;
					}
					if(empty($idhakim3)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 3 Belum Dipilih.'));
						return;
					}
					$databanding['hakim5_banding_id'] = $idhakim4;
					$nama = $this->parseName($listHakim,$idhakim4);
					if(empty($nama)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 4 Tidak Ditemukan.'));
						return;
					}
					if(in_array($idhakim4, $tmpid)){
						echo json_encode(array('st'=>0,'msg'=>'Duplikasi Data Hakim. Mohon Memilih Hakim Yang Sesuai'));
						return;
					}
					$tmpid[4] = $idhakim4;
					$databanding['hakim5_banding'] = $nama;
					$databanding['majelis_hakim_banding'] .= '<br>'.'Hakim Anggota 4 : '.$nama;
				}
			}
			$listPanitera = $this->banding->getDataPaniteraPT();
			$panitera = $this->input->post('panitera',TRUE);
			if(!empty($panitera)){
				$idpanitera = $this->encrypt->decode(base64_decode($panitera));
				if(!is_numeric($idpanitera) OR intval($idpanitera)<1){
					echo json_encode(array('st'=>0,'msg'=>'Panitera Pengganti Tidak Ditemukan.'));
					return;
				}
				$databanding['panitera_pengganti_banding_id'] = $idpanitera;
				$nama = $this->parseName($listPanitera,$idpanitera);
				if(empty($nama)){
					echo json_encode(array('st'=>0,'msg'=>'Panitera Pengganti Tidak Ditemukan.'));
					return;
				}
				$databanding['panitera_pengganti_banding'] = $nama;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Panitera Pengganti Belum Dipilih.'));
				return;
			}

			$result = $this->banding->update_data_banding($databanding,$idperkara);
			
			if($result==TRUE){
				$this->banding->update_proses($idperkara,390,'Putusan Banding');
				$this->banding->addPerkaraProses($idperkara,390,'Putusan Banding',$tanggal);
				$this->banding->updatePerkaraProses($idperkara);
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DISIMPAN.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN PENYIMPANAN.'));
				return;
			}
		}
	}

	function parseName($list,$idpihak){
		if($list!=''){
			if($list->num_rows>0){
				foreach ($list->result() as $val) {
					if($val->id==$idpihak){
						return $val->nama_gelar;
					}
				}
			}
		}

		return '';
	}
	function confirmationhapusperkara(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc'] = $segment[2];
		$idperkara = $this->encrypt->decode(base64_decode($segment[2]));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo "string";
			show_404();
		}

		$this->load->vars($data);
		$this->load->view('perkara/banding/hapus_permohonan_banding');
	}

	function hapuspermohonan(){
		try {
			if(empty($_POST)){
				show_404();
			}

			if($this->session->userdata('is_logged_in')==FALSE){
				echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
				return;
			}

			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			if(!is_numeric($idperkara) OR intval($idperkara)<1){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
				return;
			}
			$result=TRUE;
			$this->load->model('perkara/banding','banding');
			$this->banding->deletePermohonan($idperkara);
			#$this->banding->deletePerkaraProses($idperkara,290);
			if($result==TRUE){
				#$this->banding->update_proses($idperkara,390,'Putusan Banding');
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DIHAPUS.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN MENGHAPUS.'));
				return;
			}
		} catch (Exception $e) {
			
		}
	}
}