<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Add_lalulintas extends CI_Controller {
	function index(){
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$idalurperkara = $this->nativesession->get_flash_session('alur_perkara_id');
		$idtahapan = $this->nativesession->get_flash_session('tahapan_id');
		$this->show_data($idalurperkara,$idtahapan);
	}

	function show_data($idalurperkara,$idtahapan){
		$this->load->model('perkara/lalulintas','perkara');
		$data['page_title'] = 'TAMBAH - DATA PERKARA '.strtoupper($this->perkara->getJenisPerkara($idalurperkara));
		$data['idalurperkara'] = $idalurperkara;
		if (!$this->authorization->HasRuleAddPendaftaran($idalurperkara)){
			show_404();
		}
		$data['hakim_list'] = $this->perkara->getListHakimPN();
		$data['panitera_list'] = $this->perkara->getListPaniteraPN();
		$data['ruangan_sidang'] = $this->perkara->getListRuangSidang();
		$data['main_body'] = 'perkara/new_lalulintas';
		$data['previous'] = $this->nativesession->get_flash_session('url_requested');
		$data['curr_date'] = date('d/m/Y');
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}

	function uploadFileExcel(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		chmod('resources/tmp/',0777);
		$fileName = $_FILES['import']['name'];
		$config['upload_path'] = 'resources/tmp/';
		$config['file_name'] = $fileName;
		$config['allowed_types'] = 'xls|xlsx';
		$config['max_size']	= 16777216;

		$this->load->library('upload');
		$this->upload->initialize($config);

		if(! $this->upload->do_upload('import') )
		$this->upload->display_errors();
		$media = $this->upload->data('import');
		$inputFileName = 'resources/tmp/'.$media['file_name'];
		$this->nativesession->set_flash_session('inputFileName',$inputFileName);
		echo json_encode(array('st'=>1,'msg'=>'File Uploaded'));
		return;

	}
	function validateInput(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		

		$this->load->library(array('PHPExcel','PHPExcel/IOFactory'));
		$this->load->model('perkara/lalulintas','perkara');
		$this->load->model('perkara/new_perdata','perdata');

		$this->form_validation->set_rules('previous', 'ID Previous', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tanggal_pelimpahan', 'Tanggal Pelimpahan', 'trim|required|exact_length[10]|xss_clean');
		$this->form_validation->set_rules('tanggal_penetapan_sidang', 'Tanggal Penetapan Sidang', 'trim|required|exact_length[10]|xss_clean');
		$this->form_validation->set_rules('tanggal_sidang', 'Tanggal Sidang', 'trim|required|exact_length[10]|xss_clean');
		$this->form_validation->set_rules('ruang_sidang', 'Ruang Sidang', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tanggal_penetapan_hakim', 'Tanggal Penetapan Hakim', 'trim|required|exact_length[10]|xss_clean');
		$this->form_validation->set_rules('hakim', 'Hakim', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tanggal_penetapan_panitera', 'Tanggal Penetapan Panitera', 'trim|required|exact_length[10]|xss_clean');
		$this->form_validation->set_rules('panitera', 'Panitera', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tilang_oleh', 'Tilang Oleh', 'trim|required|xss_clean');
		$this->form_validation->set_rules('jumlah_perkara', 'Jumlah Perkara Tilang', 'trim|numeric|required|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Kesalahan : Tidak Berhasil | '.validation_errors().'<br/>'));
			return;
		} else {
			if($this->input->post('tanggal_pelimpahan',TRUE) > $this->input->post('tanggal_penetapan_hakim')){
				echo json_encode(array('st'=>0,'msg'=>'Kesalahan : Tanggal Penetapan Hakim tidak boleh sebelum dari Tanggal Pendaftaran'));
				return;
			}

			if($this->input->post('tanggal_pelimpahan',TRUE) > $this->input->post('tanggal_penetapan_panitera')){
				echo json_encode(array('st'=>0,'msg'=>'Kesalahan : Tanggal Penunjukan Panitera tidak boleh sebelum dari Tanggal Pendaftaran'));
				return;
			}

			if($this->input->post('tanggal_pelimpahan',TRUE) > $this->input->post('tanggal_penetapan_sidang')){
				echo json_encode(array('st'=>0,'msg'=>'Kesalahan : Tanggal Penetapan Hari Sidang tidak boleh sebelum dari Tanggal Pendaftaran'));
				return;
			}

			if($this->input->post('tanggal_pelimpahan',TRUE) > $this->input->post('tanggal_sidang')){
				echo json_encode(array('st'=>0,'msg'=>'Kesalahan : Tanggal Sidang tidak boleh sebelum dari Tanggal Pendaftaran'));
				return;
			}

			if($this->input->post('tanggal_penetapan_hakim') > $this->input->post('tanggal_penetapan_panitera')){
				echo json_encode(array('st'=>0,'msg'=>'Kesalahan : Tanggal Penunjukan Panitera tidak boleh sebelum dari Tanggal Penetapan Hakim'));
				return;
			}

			if($this->input->post('tanggal_penetapan_hakim') > $this->input->post('tanggal_penetapan_sidang')){
				echo json_encode(array('st'=>0,'msg'=>'Kesalahan : Tanggal Penetapan Hari Sidang tidak boleh sebelum dari Tanggal Penetapan Hakim'));
				return;
			}

			if($this->input->post('tanggal_penetapan_hakim') > $this->input->post('tanggal_sidang')){
				echo json_encode(array('st'=>0,'msg'=>'Kesalahan : Tanggal Sidang tidak boleh sebelum dari Tanggal Penetapan Hakim'));
				return;
			}

			if($this->input->post('tanggal_penetapan_panitera') > $this->input->post('tanggal_penetapan_sidang')){
				echo json_encode(array('st'=>0,'msg'=>'Kesalahan : Tanggal Penetapan Hari Sidang tidak boleh sebelum dari Tanggal Penetapan Hakim'));
				return;
			}

			if($this->input->post('tanggal_penetapan_panitera') > $this->input->post('tanggal_sidang')){
				echo json_encode(array('st'=>0,'msg'=>'Kesalahan : Tanggal Sidang tidak boleh sebelum dari Tanggal Penetapan Hakim'));
				return;
			}


			$tanggal_pelimpahan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_pelimpahan',TRUE));
	        $tahun_pelimpahan = date('Y', strtotime($tanggal_pelimpahan));
	        $tanggal_bulan_pelimpahan = date('Y-m', strtotime($tanggal_pelimpahan));
	        $tanggal_penetapan_hakim =  $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_penetapan_hakim'));
	        $ruang_sidang = explode("|",$this->input->post('ruang_sidang'));
	        $id_ruang_sidang = intval($ruang_sidang[0]);
	        $nama_ruang_sidang = $ruang_sidang[1];
	        $hakim = explode("|",$this->input->post('hakim'));
	        $id_hakim = intval($hakim[0]);
	        $nama_hakim = trim($hakim[1]);
	        $tanggal_penetapan_panitera = $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_penetapan_panitera'));
	        $panitera = explode("|", $this->input->post('panitera'));
	        $id_panitera = intval($panitera[0]);
	        $nama_panitera = $panitera[1];	
	        $tanggal_penetapan_sidang =  $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_penetapan_sidang'));
	        $tanggal_sidang =  $this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_sidang'));
	        $tilang_oleh = $this->input->post('tilang_oleh');
	        $jumlah_perkara = $this->input->post('jumlah_perkara');
	        $kodePN = $this->perdata->getKodePN();
	        $alur_perkara = $this->perkara->getAlurPerkara('114');
	        $kode_perkara = $alur_perkara->row()->kode;
	        $nama_perkara = $alur_perkara->row()->nama;
	        $nip_hakim = intval($this->db->query("SELECT nip AS nip_hakim FROM hakim_pn WHERE id=$id_hakim")->row()->nip_hakim);
			$kode_hakim = $this->db->query("SELECT kode AS kode_hakim FROM hakim_pn WHERE id=$id_hakim")->row()->kode_hakim;
			$nip_panitera = intval($this->db->query("SELECT nip AS nip_panitera FROM panitera_pn WHERE id=$id_panitera")->row()->nip_panitera);
			$kode_panitera = $this->db->query("SELECT kode AS kode_panitera FROM panitera_pn WHERE id=$id_panitera")->row()->kode_panitera;

			
			$inputFileName = $this->nativesession->get_flash_session('inputFileName');
			
			try {
				$inputFileType = IOFactory::identify($inputFileName);
				$objReader = IOFactory::createReader($inputFileType);
				$objPHPExcel = $objReader->load($inputFileName);
			} catch(Exception $e) {
				echo json_encode(array('st'=>0,'msg'=>'Kesalahan : File Not Found'));
				return;
			}

			
			$data_perkara=array();
			$data_proses_pendaftaran=array();
			$data_lalulintas=array();
			$data_pihak=array();
			$data_pihak2=array();
			$data_penetapan=array();
			$data_sidang=array();
			$data_putusan=array();
			$data_pemberitahuan_putusan=array();
			$data_putusan_terdakwa=array();
			$data_proses_hakim=array();
			$data_proses_panitera=array();
			$data_proses_sidang=array();
			$data_proses_putusan=array();
			$data_proses_minutasi=array();
			$data_hakim=array();
			$data_panitera=array();

			$sheet = $objPHPExcel->getSheet(0);
			$highestRow = $jumlah_perkara+1;
			$highestColumn = $sheet->getHighestColumn();

			$perkara_id = intval($this->db->query("SELECT IFNULL(max(perkara_id)+1,1) as perkara_id FROM perkara;")->row()->perkara_id);
			$pihak_id = intval($this->db->query("SELECT IFNULL(max(id)+1,1) as pihak_id FROM pihak;")->row()->pihak_id);
			$pihak2_id = intval($this->db->query("SELECT IFNULL(max(id)+1,1) as pihak2_id FROM perkara_pihak2;")->row()->pihak2_id);
			$sidang_id = intval($this->db->query("SELECT IFNULL(max(id)+1,1) as sidang_id FROM perkara_jadwal_sidang;")->row()->sidang_id);

			for ($row = 2; $row <= $highestRow; $row++){  				 				
	            	$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row,
													NULL,
													TRUE,
													FALSE);

	            $nomor_urut = intval($rowData[0][0]);
	            $nomor_seri = trim($rowData[0][1]);
	            $nomor_perkara = intval($rowData[0][2]);
	            $nama_pelanggar = trim($rowData[0][3]);
	            $alamat = trim($rowData[0][4]);
	            $pasal = trim($rowData[0][5]);
	            $nomor_polisi = trim($rowData[0][6]);
	            $bb = trim($rowData[0][7]);
	            $jenis_kendaraan = trim($rowData[0][8]);
	            $verstek = trim($rowData[0][9]);
	            $denda = intval($rowData[0][10]);
	            $subsider = intval($rowData[0][11]);
	            #$biaya_perkara = $rowData[0][12];

	            $bukti = explode("|",$bb);
	            $id_bb = $bukti[0];

	            $kendaraan = explode("|",$jenis_kendaraan);
	            $id_kendaraan = $kendaraan[0];
	            
	            $nama_bb = $this->perkara->getNamaBarangBukti($id_bb);
	            $nama_kendaraan = $this->perkara->getNamaKendaraan($id_kendaraan);

	            if($bb!==''){
	            	$bukti = explode("|",$bb);
	            	$id_bb = intval($bukti[0]);
	            	$nama_bb = $bukti[1];
	            } else {
	            	echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Pelanggar <b>'.$nama_pelanggar.'</b>, Barang Bukti Kosong'.validation_errors()));
					return;
	            }

	            if($jenis_kendaraan!==''){
	            	$kendaraan = explode("|",$jenis_kendaraan);
	            	$id_kendaraan = intval($kendaraan[0]);
	            	$nama_kendaraan = $kendaraan[1];
	            } else {
	            	echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Pelanggar <b>'.$nama_pelanggar.'</b>, Nama Kendaraan Kosong'.validation_errors()));
					return;
	            }
	            
	            #Nomor Urut
	            if($nomor_urut==''){
	            	echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Pelanggar <b>'.$nama_pelanggar.'</b>, Nomor Urut Kosong'.validation_errors()));
					return;
	            }
	            
	            if($nomor_seri==''){
	            	echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Pelanggar <b>'.$nama_pelanggar.'</b>, Nomor Seri Tilang Kosong'.validation_errors()));
					return;
	            }
	            
	            #Nomor Perkara
	            if($nomor_perkara==''){
	            	echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Pelanggar <b>'.$nama_pelanggar.'</b>, Nomor Perkara Kosong'.validation_errors()));
					return;
	            }
	            #Nama Pelangar
	            if($nama_pelanggar==''){
	            	echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Pelanggar <b>'.$nama_pelanggar.'</b>, Nama Pelanggar Kosong'.validation_errors()));
					return;
	            }
	            #Alamat
	            if($alamat==''){
	            	echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Pelanggar <b>'.$nama_pelanggar.'</b>, Alamat Kosong'.validation_errors()));
					return;
	            }
	            #Pasal Dakwaan
	            if($pasal==''){
	            	echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Pelanggar <b>'.$nama_pelanggar.'</b>, Pasal Kosong'.validation_errors()));
					return;
	            }
	           
	            #Status Verstek
	            if($verstek==''){
	            	echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Pelanggar <b>'.$nama_pelanggar.'</b>, Status Verstek Kosong'.validation_errors()));
					return;
	            }
	            #Jumlah Denda
	            if((empty($denda))AND($denda!=0)){
	            	echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Pelanggar <b>'.$nama_pelanggar.'</b>, Jumlah Denda Kosong'.validation_errors()));
					return;
	            }
	            #Subsider
	            if((empty($subsider))AND($subsider!=0)){
	            	echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Pelanggar <b>'.$nama_pelanggar.'</b>, Status Subsider Kosong'.validation_errors()));
					return;
	            }
	            
	            $nomor_perkara_fix = $nomor_perkara."/".$kode_perkara."/".$tahun_pelimpahan."/PN ".$kodePN;

	            $isPerkaraExists = $this->perdata->isNomorPerkaraExist($nomor_perkara_fix);
	            if($isPerkaraExists===TRUE){
					echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Nomor Perkara Sudah Ada Didalam System'));
					return;
				}

				$nomor_urut_register = $this->perdata->getNomorUrutRegister('114',$tanggal_bulan_pelimpahan);
				$nomor_urut_perkara = $this->perdata->getNomorUrutPerkara('114',$tahun_pelimpahan);
				$para_pihak = "Pelanggar:<br/>".$this->templatehelper->standradnaming($nama_pelanggar);
				

				#PN.BDG_2011_PID.B_0001
				$tmp = explode("/",$nomor_perkara_fix);
				$nomor_urut_perkara = $nomor_perkara;
				$tmpIndexs = $nomor_perkara;
				if($tmpIndexs<10){
					$tmpIndexs = '000'.$tmpIndexs;
				}elseif($tmpIndexs>9 and $tmpIndexs <1000){
					$tmpIndexs = '00'.$tmpIndexs;
				}
				$nomorIndexs = $tmp[3].'_'.$tmp[2].'_'.$tmp[1].'_'.$tmpIndexs;

				#Tabel Perkara
				$data_perkara[] = array(
   					'perkara_id' => $perkara_id,
   					'alur_perkara_id' => '114',
   					'tanggal_pendaftaran' => $tanggal_pelimpahan,
   					'tanggal_surat' => $tanggal_pelimpahan,
   					'jenis_perkara_id' => '161',
   					'jenis_perkara_kode' => 'LL',
   					'jenis_perkara_nama' => $nama_perkara,
   					'jenis_perkara_text' => $nama_perkara,
   					'nomor_urut_register' => $nomor_urut_register,
   					'nomor_urut_perkara' => $nomor_urut_perkara,
   					'nomor_perkara' => $nomor_perkara_fix,
   					'nomor_indeks' => $nomorIndexs,
   					'pihak2_text' => $this->templatehelper->standradnaming($nama_pelanggar),
   					'para_pihak' => $para_pihak,
   					'pihak_dipublikasikan' => 'Y',
   					'dakwaan' => $pasal,
   					'tahapan_terakhir_id' => '15',
   					'tahapan_terakhir_text' => 'Putusan',
   					'proses_terakhir_id' => '220',
   					'proses_terakhir_text' => 'Pembuatan Minutasi',
   					'diinput_oleh' => $this->session->userdata('username'),
					'diinput_tanggal' => date("Y-m-d h:i:s",time()) 
				);

				#Tabel Perkara LaluLintas
				$data_lalulintas[] = array(
 					'perkara_id'=> $perkara_id,
 					'ditilang_oleh'=> $tilang_oleh,
 					'nomor_tilang'=> $nomor_seri,
 					'jenis_kendaraan_id'=> $id_kendaraan,
 					'nomor_polisi'=> $nomor_polisi,
 					'bukti_tilang_id'=> $id_bb,
 					'diinput_oleh'=> $this->session->userdata('username'),
 					'diinput_tanggal'=> date("Y-m-d h:i:s",time())
				);

				#Tabel Pihak
				$data_pihak[]=array(
					'id'=> $pihak_id,
					'jenis_pihak_id'=> '1',
					'nama'=> $this->templatehelper->standradnaming($nama_pelanggar),
					'alamat'=> $this->templatehelper->standradnaming($alamat),
					'diinput_oleh'=> $this->session->userdata('username'),
					'diinput_tanggal'=> date("Y-m-d h:i:s",time())
				);

				#Tabel Perkara Pihak2
				$data_pihak2[]=array(
					'id'=> $pihak2_id,
					'perkara_id'=> $perkara_id,
					'urutan'=> '1',
					'pihak_id'=> $pihak_id,
					'jenis_pihak_id'=> '1',
					'nama'=> $this->templatehelper->standradnaming($nama_pelanggar),
					'alamat'=> $this->templatehelper->standradnaming($alamat),
					'diinput_oleh'=> $this->session->userdata('username'),
					'diinput_tanggal'=> date("Y-m-d h:i:s",time())
				);


				#Tabel Hakim
				$data_hakim[]=array(
					'perkara_id' => $perkara_id,
					'tanggal_penetapan' => $tanggal_penetapan_hakim,
					'urutan' => '1',
					'jabatan_hakim_id' => '3',
					'jabatan_hakim_nama' => 'Hakim Tunggal',
					'hakim_id' => $id_hakim,
					'hakim_kode' => $kode_hakim,
					'hakim_nip' => $nip_hakim,
					'hakim_nama' => $this->templatehelper->standradnaming($nama_hakim),
					'diinput_oleh' => $this->session->userdata('username'),
					'diinput_tanggal' => date("Y-m-d h:i:s",time())
				);

				#Tabel Panitera
				$data_panitera[]=array(
					'perkara_id' => $perkara_id,
					'tanggal_penetapan' => $tanggal_penetapan_panitera,
					'panitera_id' => $id_panitera,
					'panitera_kode' => $kode_panitera,
					'panitera_nip' => $nip_panitera,
					'panitera_nama' => $this->templatehelper->standradnaming($nama_panitera),
					'diinput_oleh' => $this->session->userdata('username'),
					'diinput_tanggal' => date("Y-m-d h:i:s",time())
				);
					
				#Tabel Penetapan
				$data_penetapan[]=array(
					'perkara_id' => $perkara_id,
					'penetapan_majelis_hakim' => $tanggal_penetapan_hakim,
					'majelis_hakim_id' => $id_hakim,
					'majelis_hakim_kode' => '',
					'majelis_hakim_nama' => $this->templatehelper->standradnaming($nama_hakim),
					'majelis_hakim_text' => "Hakim Tunggal:".$this->templatehelper->standradnaming($nama_hakim)."",
					'penetapan_panitera_pengganti' => $tanggal_penetapan_panitera,
					'panitera_pengganti_id' => $id_panitera,
					'panitera_pengganti_text' => $this->templatehelper->standradnaming($nama_panitera),
					'penetapan_hari_sidang' => $tanggal_penetapan_sidang,
					'sidang_pertama' => $tanggal_sidang,
					'diinput_oleh' => $this->session->userdata('username'),
					'diinput_tanggal' => date("Y-m-d h:i:s",time())
				);

				#Tabel Sidang Pertama/Persidangan
				$data_sidang[]=array(
					'id' => $sidang_id,
					'perkara_id' => $perkara_id,
					'tanggal_sidang' => $tanggal_sidang,
					'jam_sidang' => '09:00:00',
					'agenda' => 'Sidang Pertama / Putusan',
					'ruangan_id' => $id_ruang_sidang,
					'ruangan' => $nama_ruang_sidang,
					'diinput_oleh' => $this->session->userdata('username'),
					'diinput_tanggal' => date("Y-m-d h:i:s",time())
				);


				#Tabel Putusan
				$data_putusan[]=array(
					'perkara_id' => $perkara_id,
					'tanggal_putusan' => $tanggal_sidang,
					'putusan_verstek' => $verstek,
					'amar_putusan' => "Pidana Denda Rp ".number_format($denda).", Subsider Kurungan ".$subsider." Hari",
					'tanggal_minutasi' => $tanggal_sidang,
					'pemberitahuan_putusan' => $tanggal_sidang,
					'pemberitahuan_putusan_pihak2' => $tanggal_sidang,
					'diinput_oleh' => $this->session->userdata('username'),
					'diinput_tanggal' => date("Y-m-d h:i:s",time())
				);

				#Tabel Pemberitahuan Putusan
				$data_pemberitahuan_putusan[]=array(
					'perkara_id' => $perkara_id,
					'putusan_akhir' => '2',
					'pihak' => '2',
					'pihak_id' => $pihak_id,
					'tanggal_pemberitahuan_putusan' => $tanggal_sidang,
					'tanggal_menerima_putusan' => $tanggal_sidang
				);

				#Tabel Putusan Terdakwa
				$data_putusan_terdakwa1[]=array(
					'pihak2_id' => $pihak2_id,
					'perkara_id' => $perkara_id,
					'pihak_id' => $pihak_id,
					'status_putusan_id' => '16',
					'tanggal_putusan' => $tanggal_sidang,
					'status_putusan_text' => "Pidana Denda (Rp ".number_format($denda)."), Subsider Kurungan ( ".$subsider." Hari )",
					'durasi_nominal' => $denda,
					'satuan' => '2',
					'diinput_oleh' => $this->session->userdata('username'),
					'diinput_tanggal' => date("Y-m-d h:i:s",time())
				);

				#Tabel Putusan Terdakwa
				$data_putusan_terdakwa2[]=array(
					'pihak2_id' => $pihak2_id,
					'perkara_id' => $perkara_id,
					'pihak_id' => $pihak_id,
					'status_putusan_id' => '24',
					'tanggal_putusan' => $tanggal_sidang,
					'status_putusan_text' => "Subsider Kurungan ( ".$subsider." Hari )",
					'durasi_nominal' => $subsider,
					'satuan' => '1',
					'diinput_oleh' => $this->session->userdata('username'),
					'diinput_tanggal' => date("Y-m-d h:i:s",time())
				);


				#Tabel Pendaftaran
				$data_proses_pendaftaran[]=array(
					'perkara_id'=> $perkara_id,
					'tahapan_id'=> '10',
					'tahapan_nama'=> 'Pendaftaran',
					'proses_id'=> '10',
					'proses_nama'=> 'Pendaftaran Perkara',
					'tanggal'=> $tanggal_pelimpahan,
					'urutan'=> '1',
					'diinput_oleh'=> $this->session->userdata('username'),
					'diinput_tanggal'=> date("Y-m-d h:i:s",time())
				);


				#Proses Penetapan Hakim
				$data_proses_hakim[]=array(
					'perkara_id'=> $perkara_id,
					'tahapan_id'=> '12',
					'tahapan_nama'=> 'Penetapan',
					'proses_id'=> '20',
					'proses_nama'=> 'Penetapan Majelis Hakim/Hakim',
					'tanggal'=> $tanggal_penetapan_hakim,
					'urutan'=> '2',
					'diinput_oleh'=> $this->session->userdata('username'),
					'diinput_tanggal'=> date("Y-m-d h:i:s",time())
				);

				#Proses Penetapan Panitera
				$data_proses_panitera[]=array(
					'perkara_id'=> $perkara_id,
					'tahapan_id'=> '12',
					'tahapan_nama'=> 'Penetapan',
					'proses_id'=> '30',
					'proses_nama'=> 'Penunjukan Panitera Pengganti',
					'tanggal'=> $tanggal_penetapan_panitera,
					'urutan'=> '3',
					'diinput_oleh'=> $this->session->userdata('username'),
					'diinput_tanggal'=> date("Y-m-d h:i:s",time())
				);

				#Proses Penetapan Hari Sidang
				$data_proses_sidang[]=array(
					'perkara_id'=> $perkara_id,
					'tahapan_id'=> '12',
					'tahapan_nama'=> 'Penetapan',
					'proses_id'=> '80',
					'proses_nama'=> 'Penetapan Hari Sidang Pertama',
					'tanggal'=> $tanggal_penetapan_sidang,
					'urutan'=> '4',
					'diinput_oleh'=> $this->session->userdata('username'),
					'diinput_tanggal'=> date("Y-m-d h:i:s",time())
				);

				#Proses Putusan
				$data_proses_putusan[]=array(
					'perkara_id'=> $perkara_id,
					'tahapan_id'=> '15',
					'tahapan_nama'=> 'Putusan',
					'proses_id'=> '210',
					'proses_nama'=> 'Putusan',
					'tanggal'=> $tanggal_sidang,
					'urutan'=> '5',
					'diinput_oleh'=> $this->session->userdata('username'),
					'diinput_tanggal'=> date("Y-m-d h:i:s",time())
				);

				#Proses Minutasi
				$data_proses_minutasi[]=array(
					'perkara_id'=> $perkara_id,
					'tahapan_id'=> '15',
					'tahapan_nama'=> 'Putusan',
					'proses_id'=> '220',
					'proses_nama'=> 'Pembuatan Minutasi',
					'tanggal'=> $tanggal_sidang,
					'urutan'=> '6',
					'diinput_oleh'=> $this->session->userdata('username'),
					'diinput_tanggal'=> date("Y-m-d h:i:s",time())
				);

				$perkara_id++;
				$pihak_id++;
				$pihak2_id++;
				$sidang_id++;
			}

				$this->db->insert_batch('perkara',$data_perkara); 
				$this->db->insert_batch('perkara_proses',$data_proses_pendaftaran);
				$this->db->insert_batch('perkara_lalulintas',$data_lalulintas); 
				$this->db->insert_batch('pihak',$data_pihak); 
				$this->db->insert_batch('perkara_pihak2',$data_pihak2); 
				$this->db->insert_batch('perkara_hakim_pn',$data_hakim);
				$this->db->insert_batch('perkara_panitera_pn',$data_panitera);
				$this->db->insert_batch('perkara_penetapan',$data_penetapan);
				$this->db->insert_batch('perkara_proses',$data_proses_hakim);
				$this->db->insert_batch('perkara_proses',$data_proses_panitera);
				$this->db->insert_batch('perkara_proses',$data_proses_sidang); 
				$this->db->insert_batch('perkara_jadwal_sidang',$data_sidang); 
				$this->db->insert_batch('perkara_putusan',$data_putusan);
				$this->db->insert_batch('perkara_proses',$data_proses_putusan); 
				$this->db->insert_batch('perkara_proses',$data_proses_minutasi); 
				$this->db->insert_batch('perkara_putusan_pemberitahuan_putusan',$data_pemberitahuan_putusan); 
				$this->db->insert_batch('perkara_putusan_terdakwa',$data_putusan_terdakwa1); 
				$this->db->insert_batch('perkara_putusan_terdakwa',$data_putusan_terdakwa2); 
				
			}
			delete_files('resources/tmp/', TRUE);
			chmod('resources/tmp/',0755);
			echo json_encode(array('st'=>1,'msg'=>'DATA Perkara Lalu Lintas Berhasil Didaftarkan.'));
			return;
	}
}

?>