<?php
$modelClass =& get_instance();
$modelClass->load->model('update/update','patching');
$this->load->dbforge();

$this->db->query("DROP VIEW IF EXISTS v_menu;");
$this->db->query("DROP VIEW IF EXISTS v_lalulintas;");
$this->db->query("DROP VIEW IF EXISTS v_perkara_pihak1;");
$this->db->query("DROP VIEW IF EXISTS v_perkara_pihak2;");
$this->db->query("ALTER TABLE perkaraprosesweb CHANGE proses proses VARCHAR(200) NULL;");
$this->db->query("REPLACE INTO sys_menu_rule (menuid,ruleid) VALUES (1000,62),(1001,63),(1002,64);");

$this->db->query("DROP VIEW IF EXISTS viewperkaraputusanterdakwa;");
$this->db->query("CREATE VIEW viewperkaraputusanterdakwa AS 
              SELECT 
                      p.id AS ID,
                      p.perkara_id AS IDPerkara,
                      pp.status_putusan_id AS IDStatusPutusan,
                      (CASE
                        WHEN (v_perkara.pihak_dipublikasikan = 'T') THEN concat('Terdakwa',p.urutan) 
                    WHEN (v_perkara.alur_perkara_id = 118) THEN concat('Anak Berhadapan Dengan Hukum ',p.urutan) ELSE p.nama 
                      END) AS nama,
                      pp.durasi_nominal AS durasiNominal,
                      v_perkara.tanggal_putusan AS tglPutusan,
                      s.nama AS statusPutusan,
                      pp.satuan AS satuan 
              FROM
                  perkara_pihak2 p 
                LEFT JOIN perkara_putusan_terdakwa pp 
                ON pp.perkara_id = p.perkara_id AND pp.pihak2_id = p.id
                LEFT JOIN status_putusan s ON s.id = pp.status_putusan_id
                LEFT JOIN v_perkara ON v_perkara.perkara_id = pp.perkara_id
                  WHERE v_perkara.alur_perkara_id >100
                  ORDER BY p.urutan;");

$this->db->query("DROP VIEW IF EXISTS viewperkaraputusanweb;");
$this->db->query("CREATE VIEW viewperkaraputusanweb AS 
            SELECT
          put.perkara_id                     AS IDPerkara,
          put.tanggal_putusan                AS tglPutusan,
          put.putusan_verstek                AS isVerstek,
          s.nama                             AS sumberHukum,
          put.status_putusan_id              AS IDStatusPutusan,
          sp.nama                            AS statusPutusan,
          put.tanggal_cabut                  AS tglCabut,
          put.tanggal_gugur                  AS tglGugur,
          (CASE
            WHEN p.alur_perkara_id = 118 THEN 'Disamarkan'
            WHEN p.jenis_perkara_id IN (64,98,242,346,347,248,312,349,350,352) THEN 'Disamarkan'
            ELSE    put.amar_putusan 
            END) AS amar,
          put.penetapan_hakim_pengawas       AS tglPenetapanHakimPengawas,
          put.nomor_penetapan_hakim_pengawas AS noPenetapanHakimPengawas,
          put.hakim_pengawas_id              AS IDHakimPengawas,
          put.pengurus_id                    AS IDPengurus,
          put.tanggal_penetapan_kreditur     AS tglPenetapanKreditur,
          put.panitia_kreditur               AS panitiaKreditur,
          put.kurator_id                     AS IDKurator,
          put.tanggal_berita_putusan         AS tglMediaBerita,
          put.nama_media_berita_putusan      AS namaMediaBerita,
          put.tanggal_surat_kabar_putusan    AS tglSuratKabar,
          put.nama_surat_kabar_putusan       AS namaSuratKabar,
          put.tanggal_minutasi               AS tglMinutasi,
          put.kirim_salinan_putusan_penyidik AS TglKirimSalinanPenyidik,
          put.catatan_putusan                AS catatan_putusan,
          put.nilai_ganti_kerugian           AS nilai_ganti_kerugian
        FROM perkara_putusan AS put
            LEFT JOIN sumber_hukum AS s
              ON s.id = put.sumber_hukum_id
           LEFT JOIN status_putusan AS sp
             ON sp.id = put.status_putusan_id
           LEFT JOIN perkara AS p
            ON p.perkara_id = put.perkara_id;");

$this->db->query("DROP VIEW IF EXISTS viewperkarapenuntutanweb;");
$this->db->query("CREATE VIEW viewperkarapenuntutanweb AS 
            SELECT
            pp.perkara_id         AS IDPerkara,
            pp.tanggal_penuntutan AS tglPenuntutan,
            IF(p.alur_perkara_id = 118,'Disamarkan', pp.isi_penuntutan)     AS isiTuntutan
            FROM perkara_penuntutan AS pp
            LEFT JOIN perkara AS p
            ON pp.perkara_id = p.perkara_id;");

$this->db->query("DROP VIEW IF EXISTS viewbandingweb;");
$this->db->query("CREATE VIEW viewbandingweb AS 
        SELECT
                b.id                               AS ID,
                b.perkara_id                       AS IDPerkara,
                (CASE
                  WHEN b.alur_perkara_id = 118 AND b.pihak_asal = 2 THEN 'ANAK BERHADAPAN DENGAN HUKUM'
                  WHEN p.jenis_perkara_id IN (64,98,242,346,347,248,312,349,350,352) THEN 'disamarkan'
                  ELSE b.pihak_nama
                  END) AS nama,
                b.status_pihak_id                  AS IDStatusPihak,
                CONCAT(IFNULL(b.status_pihak_text,''),' (',b.pihak_asal_text,')') AS statusPihak,
                (CASE
                  WHEN b.alur_perkara_id = 118 AND b.pihak_asal = 2 THEN 'ANAK BERHADAPAN DENGAN HUKUM'
                  WHEN p.jenis_perkara_id IN (64,98,242,346,347,248,312,349,350,352) THEN 'disamarkan'
                  ELSE b.pihak_nama
                  END)                      AS pihakNama,
                b.pihak_diwakili                   AS pihakDiwakili,
                b.pemohon_nama                     AS pemohonNama,
                b.permohonan_banding               AS tglPermohonan,
                b.pemberitahuan_permohonan_banding AS tglPemberitahuanPermohonan,
                b.penerimaan_memori_banding        AS tglPenerimaanMemori,
                b.penyerahan_memori_banding        AS tglPenyerahanMemori,
                b.penerimaan_kontra_banding        AS tglPenerimaanKontra,
                b.penyerahan_kontra_banding        AS tglPenyerahanKontra,
                b.pemberitahuan_inzage             AS tglPemberitahuanInzage,
                b.pelaksanaan_inzage               AS tglPelaksanaanInzage,
                b.pemberitahuan_putusan_banding    AS tglPemberitahuanPutusanBanding,
                b.tanggal_cabut                    AS tglCabut,
                b.keterangan                       AS keterangan
        FROM perkara_banding_detil AS b
        LEFT JOIN perkara AS p
        ON p.perkara_id = b.perkara_id;");


$this->db->query("DROP VIEW IF EXISTS viewkasasiweb;");
$this->db->query("CREATE VIEW viewkasasiweb AS 
SELECT
                k.id                           AS ID,
                k.perkara_id                   AS IDPerkara,
                (CASE
                  WHEN p.jenis_perkara_id IN (248,312) AND k.pihak_asal = 2 THEN 'ANAK BERHADAPAN DENGAN HUKUM'
                  WHEN p.jenis_perkara_id IN (64,98,242,346,347,349,350,352) THEN 'disamarkan'
                  ELSE k.pihak_nama
                  END) AS nama,
                k.status_pihak_id              AS IDStatusPihak,
                CONCAT(IFNULL(k.status_pihak_text,''),' (',k.pihak_asal_text,')') AS statusPihak,
                (CASE
                  WHEN p.jenis_perkara_id IN (248,312) AND k.pihak_asal = 2 THEN 'ANAK BERHADAPAN DENGAN HUKUM'
                  WHEN p.jenis_perkara_id IN (64,98,242,346,347,349,350,352) THEN 'disamarkan'
                  ELSE k.pihak_nama
                  END)                  AS pihak_nama,
                k.pihak_diwakili               AS pihak_diwakili,
                k.pemohon_nama                 AS pemohon_nama,
                k.permohonan_kasasi            AS tglPermohonan,
                k.pemberitahuan_kasasi         AS tglPemberitahuanPermohonan,
                k.penerimaan_memori_kasasi     AS tglPenerimaanMemori,
                k.penyerahan_memori_kasasi     AS tglPenyerahanMemori,
                k.penerimaan_kontra_kasasi     AS tglPenerimaanKontra,
                k.penyerahan_kontra_kasasi     AS tglPenyerahanKontra,
                k.pemberitahuan_inzage_kasasi  AS tglPemberitahuanInzage,
                k.pelaksanaan_inzage_kasasi    AS tglPelaksanaanInzage,
                k.pemberitahuan_putusan_kasasi AS tglPemberitahuanPutusanKasasi,
                k.tanggal_cabut                AS tglCabut
        FROM perkara_kasasi_detil AS k
        LEFT JOIN perkara AS p
        ON p.perkara_id = k.perkara_id;");


$this->db->query("DROP VIEW IF EXISTS viewpkweb;");
$this->db->query("CREATE  VIEW viewpkweb AS 
        SELECT
           pk.id AS ID,
           pk.perkara_id AS IDPerkara,
          (CASE
                  WHEN p.jenis_perkara_id IN (248,312) AND pk.pihak_asal = 2 THEN 'ANAK BERHADAPAN DENGAN HUKUM'
                  WHEN p.jenis_perkara_id IN (64,98,242,346,347,349,350,352) THEN 'disamarkan'
                  ELSE pk.pihak_nama
                  END) AS nama,
           pk.status_pihak_id AS IDStatusPihak,
           CONCAT(IFNULL(pk.status_pihak_text,''),' (',pk.pihak_asal_text,')') AS statusPihak,
            (CASE
                  WHEN p.jenis_perkara_id IN (248,312) AND pk.pihak_asal = 2 THEN 'ANAK BERHADAPAN DENGAN HUKUM'
                  WHEN p.jenis_perkara_id IN (64,98,242,346,347,349,350,352) THEN 'disamarkan'
                  ELSE pk.pihak_nama
                  END) AS pihak_nama,
           pk.pihak_diwakili AS pihak_diwakili,
           pk.pemohon_nama AS pemohon_nama,
           pk.permohonan_pk AS tglPermohonan,
           pk.pemberitahuan_pk AS tglPemberitahuanPermohonan,
           pk.penerimaan_memori_pk AS tglPenerimaanMemori,
           pk.penyerahan_memori_pk AS tglPenyerahanMemori,
           pk.penerimaan_kontra_pk AS tglPenerimaanKontra,
           pk.penyerahan_kontra_pk AS tglPenyerahanKontra,
           pk.pemberitahuan_inzage_pk AS tglPemberitahuanInzage,
           pk.pelaksanaan_inzage_pk AS tglPelaksanaanInzage,
           pk.pemberitahuan_putusan_pk AS tglPemberitahuanPutusan,
           pk.tanggal_cabut AS tglCabut
        FROM perkara_pk_detil AS pk
        LEFT JOIN perkara AS p
        ON p.perkara_id = pk.perkara_id;");


$this->db->query("DELETE FROM sys_group_rule WHERE groupid = 901;");
$this->db->query("DELETE FROM sys_group_rule WHERE groupid = 900 AND ruleid = 22;");

$this->db->query("REPLACE INTO sys_group_rule (groupid,ruleid) VALUES (901,25),(901,26),(901,27),(901,28);");

$this->db->query("UPDATE sys_groups SET name = 'Panitera/Wakil Panitera' WHERE groupid = 30;");

$isthere = FALSE;
$result = $this->db->query("SHOW INDEXES FROM eksekusidetilweb WHERE Key_name = 'PRIMARY'");
if(!empty($result)){
    if($result->num_rows>0){
        $isthere = TRUE;
    }
}
if(!$isthere){
    $this->db->query("TRUNCATE TABLE eksekusidetilweb;");
    $this->db->query("ALTER TABLE eksekusidetilweb ADD PRIMARY KEY (IDPerkara);");
    $this->db->query("CALL updateTable();");
}
    


$this->db->query("ALTER TABLE delegasi_proses_masuk   
	CHANGE tgl_resi tgl_resi DATE NULL  AFTER document_mime,
	CHANGE catatan catatan VARCHAR(100) NULL  AFTER biaya,
	CHANGE diinput_oleh diinput_oleh VARCHAR(30) NULL  AFTER catatan;");

$this->db->query("UPDATE jenis_perkara SET nama_lengkap ='Pidana Lingkungan Hidup' WHERE id = 392;");
$this->db->query("DELETE FROM jenis_alur_perkara WHERE jenis_perkara_id = 392;");

$this->db->query("REPLACE INTO jenis_perkara (id,nama, nama_lengkap, format_nomor) VALUES
('600','Pencemaran Air','Lingkungan Hidup/Pencemaran Air','#nomor_urut_perkara#/G/LH/#tahun#/PTUN.#kode_pn#'),
('601','Pencemaran Udara dan Gangguan (Kebisingan,Getaran dan Kebauan)','Lingkungan Hidup/Pencemaran Udara dan Gangguan (Kebisingan,Getaran dan Kebauan)','#nomor_urut_perkara#/G/LH/#tahun#/PTUN.#kode_pn#'),
('602','Pencemaran Tanah','Lingkungan Hidup/Pencemaran Tanah','#nomor_urut_perkara#/G/LH/#tahun#/PTUN.#kode_pn#'),
('603','Pencemaran Laut','Lingkungan Hidup/Pencemaran Laut','#nomor_urut_perkara#/G/LH/#tahun#/PTUN.#kode_pn#'),
('604','Kerusakan Terumbu Karang, Hutan Bakau(Mangrove), Lautan dan Pesisir','Lingkungan Hidup/Kerusakan Terumbu Karang, Hutan Bakau(Mangrove), Lautan dan Pesisir','#nomor_urut_perkara#/G/LH/#tahun#/PTUN.#kode_pn#'),
('605','Kebakaran Hutan','Lingkungan Hidup/Kebakaran Hutan','#nomor_urut_perkara#/G/LH/#tahun#/PTUN.#kode_pn#'),
('606','Penebangan Kayu','Lingkungan Hidup/Penebangan Kayu','#nomor_urut_perkara#/G/LH/#tahun#/PTUN.#kode_pn#'),
('607','Perubahan Kawasan Alam/Tata Ruang','Lingkungan Hidup/Perubahan Kawasan Alam/Tata Ruang','#nomor_urut_perkara#/G/LH/#tahun#/PTUN.#kode_pn#'),
('608','Satwa Liar (Penangkapan,Perdagangan dll)','Lingkungan Hidup/Satwa Liar (Penangkapan,Perdagangan dll)','#nomor_urut_perkara#/G/LH/#tahun#/PTUN.#kode_pn#'),
('609','Tanaman Yang Dilindungi','Lingkungan Hidup/Tanaman Yang Dilindungi','#nomor_urut_perkara#/G/LH/#tahun#/PTUN.#kode_pn#'),
('610','Kerusakan Lingkungan Akibat Kegiatan Pertambangan(Mineral,Batu Bara), Minyak dan Gas Bumi','Lingkungan Hidup/Kerusakan Lingkungan Akibat Kegiatan Pertambangan(Mineral,Batu Bara), Minyak dan Gas Bumi','#nomor_urut_perkara#/G/LH/#tahun#/PTUN.#kode_pn#'),
('611','Konservasi Sumber Daya Alam','Lingkungan Hidup/Konservasi Sumber Daya Alam','#nomor_urut_perkara#/G/LH/#tahun#/PTUN.#kode_pn#'),
('612','Limbah Bahan Beracun Berbahaya (B3)','Lingkungan Hidup/Limbah Bahan Beracun Berbahaya (B3)','#nomor_urut_perkara#/G/LH/#tahun#/PTUN.#kode_pn#'),
('613','Reklamasi Pantai','Lingkungan Hidup/Reklamasi Pantai','#nomor_urut_perkara#/G/LH/#tahun#/PTUN.#kode_pn#'),
('614','Pembuangan Limbah','Lingkungan Hidup/Pembuangan Limbah','#nomor_urut_perkara#/G/LH/#tahun#/PTUN.#kode_pn#'),
('615','Penangkapan Ikan (dengan racun, bahan peledak/bom ikan)','Lingkungan Hidup/Penangkapan Ikan (dengan racun, bahan peledak/bom ikan)','#nomor_urut_perkara#/G/LH/#tahun#/PTUN.#kode_pn#'),
('616','Perubahan Iklim','Lingkungan Hidup/Perubahan Iklim','#nomor_urut_perkara#/G/LH/#tahun#/PTUN.#kode_pn#'),
('617','Hal-hal yang mengakibatkan kerusakan dan pencemaran lingkungan','Lingkungan Hidup/Hal-hal yang mengakibatkan kerusakan dan pencemaran lingkungan','#nomor_urut_perkara#/G/LH/#tahun#/PTUN.#kode_pn#');");


$this->db->query("REPLACE INTO jenis_alur_perkara (alur_perkara_id,jenis_perkara_id) VALUES 
(9,600),(9,601), (9,6029), (9,603),(9,604),(9,605),(9,606),(9,607),(9,608),(9,609),
(9,610),(9,611),(9,612),(9,613),(9,614),(9,615),(9,616),(9,617);");

$this->db->query("REPLACE INTO sys_groups (groupid,parent_id,level,lft,rgt,name,description) VALUES
(444,440,6,36,37,'Meja III Perdata Khusus PHI','Meja III Perdata Khusus PHI'),
(454,450,6,44,45,'Meja III Perdata Khusus Niaga','Meja III Perdata Khusus Niaga');");

$this->db->query("UPDATE sys_menus SET title = 'Bantahan (Derden Verzet)' WHERE id = '2013';");

$this->db->query("UPDATE pengadilan_negeri SET kode_pn = 'PA.Jepr' WHERE id = '484'; ");
$this->db->query("UPDATE pengadilan_negeri SET kode = '402571', alamat = 'Jl. Negara Kandangan Km.3,5 No.160 Negara Kandangan' WHERE id = '568'; ");
$this->db->query("UPDATE pengadilan_negeri SET nama = 'PENGADILAN AGAMA PALU' WHERE id = '700';");
$this->db->query("UPDATE pengadilan_negeri SET kode = '307300', nama = 'PENGADILAN AGAMA LUWUK', alamat = 'Jl. Komplex perkantoran Bukit Halimun' WHERE id = '701'; ");
$this->db->query("UPDATE pengadilan_negeri SET alamat = 'Jl. Pulau Kalimantan No.30, Kelurahan Gebangrejo, Kecamatan Poso Kota' WHERE id = '702'; ");

$this->db->query("UPDATE pihak SET status_kawin = 1 WHERE status_kawin = 'Kawin';");
$this->db->query("UPDATE pihak SET status_kawin = 2 WHERE status_kawin = 'Belum Kawin';");
$this->db->query("UPDATE pihak SET status_kawin = 4 WHERE status_kawin = 'Janda/Duda' AND Jenis_kelamin = 'P'");
$this->db->query("UPDATE pihak SET status_kawin = 3 WHERE status_kawin = 'Janda/Duda' AND Jenis_kelamin = 'L'");
$this->db->query("UPDATE pihak SET status_kawin = NULL WHERE status_kawin = 'Janda/Duda' AND Jenis_kelamin NOT IN  ('L','P');");

$this->db->query("ALTER TABLE pihak CHANGE status_kawin status_kawin CHAR(1) NULL  COMMENT '1.Kawin; 2.Belum Kawin; 3.Duda; 4.Janda';");

$this->db->query("REPLACE INTO status_putusan (id, jenis_perkara_id, nama, keterangan, aktif, urutan, satuan, jenis_pengadilan) VALUES
(68,2,'Cambuk','1','Y','4','2','4'),
(69,2,'Denda','2','Y','2','2','4'),
(70,2,'Kerja Sosial','3','Y','4','1','4'),
(71,2,'Pembinaan Oleh Negara','4','Y','3','3','4'),
(72,2,'Pemutusan Perkawinan','5','Y','3','3','4'),
(73,2,'Pencabutan Izin dan Pencabutan Hak','6','Y','4','3','4'),
(74,2,'Pengembalian Kepada Orang Tua/Wali','7','Y','3','3','4'),
(75,2,'Penjara','8','Y','1','1','4'),
(76,2,'Perampasan Barang-Barang Tertentu ','9','Y','4','3','4'),
(77,2,'Restitusi','10','Y','2','4','4'),
(78,2,'Restitusi Oleh Orang Tua/Wali','11','Y','2','4','4');");


$this->db->query("REPLACE INTO proses_alur_perkara (id, alur_perkara_id, tahapan_id, tahapan_nama, proses_id, proses_nama, batas_waktu, satuan, dari_proses_id, nama_tabel_dari, nama_kolom_dari, nama_tabel_ke, nama_kolom_ke, aktif, reminder) VALUES 
      (4000, 15, 10, 'Pendaftaran', '10', 'Pendaftaran Perkara', NULL, NULL, NULL, NULL, 'tanggal_pendaftaran', 'perkara', 'tanggal_pendaftaran', 'Y', '0'),
      (4001, 15, 12, 'Penetapan', '20', 'Penetapan Majelis Hakim/Hakim', '3', '1', '10', 'perkara', 'tanggal_pendaftaran', 'perkara_penetapan', 'penetapan_majelis_hakim', 'Y', '1'),
      (4002, 15, 12, 'Penetapan', '21', 'Penetapan Kembali Majelis Hakim/Hakim', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', '0'),
      (4003, 15, 12, 'Penetapan', '30', 'Penunjukan Panitera Pengganti', '3', '1', '10', 'perkara', 'tanggal_pendaftaran', 'perkara_penetapan', 'penetapan_panitera_pengganti', 'Y', '0'),
      (4004, 15, 12, 'Penetapan', '31', 'Penunjukan Kembali Panitera Pengganti', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', '0'),
      (4005, 15, 12, 'Penetapan', '40', 'Penunjukan Jurusita', NULL, NULL, NULL, NULL, NULL, 'perkara_penetapan', 'penetapan_jurusita', 'Y', '0'),
      (4006, 15, 12, 'Penetapan', '41', 'Penunjukan Kembali Jurusita', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', '0'),
      (4007, 15, 12, 'Penetapan', '80', 'Penetapan Hari Sidang Pertama', '3', '1', '20', 'perkara_penetapan', 'penetapan_majelis_hakim', 'perkara_penetapan', 'penetapan_hari_sidang', 'Y', '1'),
      (4008, 15, 12, 'Penetapan', '81', 'Sidang pertama', NULL, NULL, NULL, NULL, 'penetapan_panitera_pengganti', 'perkara_penetapan', 'sidang_pertama', 'Y', '0'),
      (4009, 15, 13, 'Mediasi', '110', 'Penetapan Mediator', '1', '1', '81', 'perkara_penetapan', 'sidang_pertama', 'perkara_mediasi', 'penetapan_penunjukan_mediator', 'Y', '0'),
      (4010, 15, 13, 'Mediasi', '120', 'Penetapan Tanggal Mediasi', '2', '1', '110', 'perkara_mediasi', 'penetapan_penunjukan_mediator', 'perkara_mediasi', 'penetapan_tanggal_mediasi', 'Y', '0'),
      (4011, 15, 13, 'Mediasi', '121', 'Mulai Mediasi', NULL, NULL, NULL, NULL, NULL, 'perkara_mediasi', 'dimulai_mediasi', 'Y', '0'),
      (4012, 15, 13, 'Mediasi', '130', 'Kesepakatan Mediasi', '61', '1', '121', 'perkara_mediasi', 'dimulai_mediasi', 'perkara_mediasi', 'keputusan_mediasi', 'Y', '1'),
      (4013, 15, 13, 'Mediasi', '150', 'Mediasi Tidak Berhasil', NULL, NULL, NULL, NULL, NULL, 'perkara_mediasi', 'mediasi_gagal', 'Y', '0'),
      (4014, 15, 13, 'Mediasi', '151', 'Mediasi Tidak Dapat Dilaksanakan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', '0'),
      (4015, 15, 13, 'Mediasi', '180', 'Mediasi Berhasil', NULL, NULL, NULL, NULL, NULL, 'perkara_mediasi', 'mediasi_berhasil', 'Y', '0'),
      (4016, 15, 13, 'Mediasi', '181', 'Mediasi Berhasil Sebagian', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', '0'),
      (4017, 15, 13, 'Mediasi', '190', 'Penetapan Akta Perdamaian', NULL, NULL, NULL, NULL, NULL, 'perkara_mediasi', 'akta_perdamaian', 'Y', '0'),
      (4018, 15, 14, 'Persidangan', '200', 'Persidangan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', '1'),
      (4019, 15, 15, 'Putusan', '210', 'Putusan', '5', '3', '150', 'perkara_mediasi', 'mediasi_gagal', 'perkara_putusan', 'tanggal_putusan', 'Y', '1'),
      (4020, 15, 15, 'Putusan', '211', 'Pencabutan Perkara', NULL, NULL, NULL, NULL, NULL, 'perkara_putusan', 'tanggal_cabut', 'Y', '0'),
      (4021, 15, 15, 'Putusan', '212', 'Pernyataan Gugur', NULL, NULL, NULL, NULL, NULL, 'perkara_putusan', 'tanggal_gugur', 'Y', '0'),
      (4022, 15, 15, 'Putusan', '218', 'Pemberitahuan Putusan', NULL, NULL, NULL, NULL, NULL, 'perkara_putusan', 'pemberitahuan_putusan', 'Y', '0'),
      (4023, 15, 15, 'Putusan', '220', 'Pembuatan Minutasi', '14', '2', '210', 'perkara_putusan', 'tanggal_putusan', 'perkara_putusan', 'tanggal_minutasi', 'Y', '1'),
      (4024, 15, 16, 'Verzet', '240', 'Pendaftaran Perlawanan(Verzet)', '14', '1', '230', 'perkara_putusan', 'pemberitahuan_putusan', 'perkara_verzet', 'tanggal_pendaftaran_verzet', 'Y', '0'),
      (4025, 15, 16, 'Verzet', '241', 'Penetapan Majelis Hakim Verzet', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', '0'),
      (4026, 15, 16, 'Verzet', '242', 'Penetapan Panitera Pengganti Verzet', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', '0'),
      (4027, 15, 16, 'Verzet', '243', 'Penetapan Jurusita Verzet', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', '0'),
      (4028, 15, 16, 'Verzet', '250', 'Penetapan Jadwal Sidang Verzet', NULL, NULL, NULL, NULL, NULL, 'perkara_verzet', 'tanggal_penetapan_sidang_verzet', 'Y', '0'),
      (4029, 15, 16, 'Verzet', '260', 'Sidang Pertama Perlawanan', NULL, NULL, NULL, NULL, NULL, 'perkara_verzet', 'tanggal_sidang_pertama_verzet', 'Y', '0'),
      (4030, 15, 16, 'Verzet', '261', 'Persidangan Verzet', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', '0'),
      (4031, 15, 16, 'Verzet', '270', 'Putusan Perlawanan Verzet', NULL, NULL, NULL, NULL, NULL, 'perkara_verzet', 'putusan_verzet', 'Y', '0'),
      (4032, 15, 16, 'Verzet', '280', 'Pemberitahuan Hasil Putusan Verzet', NULL, NULL, NULL, NULL, NULL, 'perkara_verzet', 'pemberitahuan_putusan_verzet', 'Y', '0'),
      (4033, 15, 18, 'Ikrar Talak', '290', 'Penetapan Majelis Hakim Ikrar Talak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', '0'),
      (4034, 15, 18, 'Ikrar Talak', '291', 'Penunjukan Panitera Pengganti Ikrar Talak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', '0'),
      (4035, 15, 18, 'Ikrar Talak', '292', 'Penetapan Jurusita Ikrar Talak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', '0'),
      (4036, 15, 18, 'Ikrar Talak', '293', 'Penetapan Hari Sidang Ikrar Talak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', '0'),
      (4037, 15, 18, 'Ikrar Talak', '294', 'Panggilan Sidang Ikrar Talak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', '0'),
      (4038, 15, 18, 'Ikrar Talak', '295', 'Penetapan Ikrar Talak', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', '0'),
      (4039, 15, 19, 'Akta Cerai', '296', 'Pembuatan Akta Cerai', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', '0'),
      (4040, 15, 19, 'Akta Cerai', '297', 'Penyerahan Akta Cerai', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', '0'),
      (4041, 15, 20, 'Banding', '300', 'Permohonan Banding', '14', '1', '210', 'perkara_putusan', 'tanggal_putusan', 'perkara_banding', 'permohonan_banding', 'Y', '0'),
      (4042, 15, 20, 'Banding', '301', 'Pemberitahuan Permohonan Banding', '7', '1', '290', 'perkara_banding', 'permohonan_banding', 'perkara_banding', 'pemberitahuan_permohonan_banding', 'Y', '1'),
      (4043, 15, 20, 'Banding', '310', 'Penerimaan Memori Banding', NULL, NULL, NULL, NULL, NULL, 'perkara_banding', 'penerimaan_memori_banding', 'Y', '0'),
      (4044, 15, 20, 'Banding', '320', 'Penyerahan Memori Banding', NULL, NULL, NULL, NULL, NULL, 'perkara_banding', 'penyerahan_memori_banding', 'Y', '0'),
      (4045, 15, 20, 'Banding', '330', 'Penerimaan Kontra Memori Banding', NULL, NULL, NULL, NULL, NULL, 'perkara_banding', 'penerimaan_kontra_banding', 'Y', '0'),
      (4046, 15, 20, 'Banding', '340', 'Penyerahan Kontra Memori Banding', NULL, NULL, NULL, NULL, NULL, 'perkara_banding', 'penyerahan_kontra_banding', 'Y', '0'),
      (4047, 15, 20, 'Banding', '350', 'Permberitahuan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_banding_detil', 'pemberitahuan_inzage', 'Y', '0'),
      (4048, 15, 20, 'Banding', '360', 'Pelaksanaan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_banding_detil', 'pelaksanaan_inzage', 'Y', '0'),
      (4049, 15, 20, 'Banding', '370', 'Pengiriman Berkas Banding', '30', '2', '290', 'perkara_banding', 'permohonan_banding', 'perkara_banding', 'pengiriman_berkas_banding', 'Y', '1'),
      (4050, 15, 20, 'Banding', '380', 'Penerimaan Kembali Berkas Banding', NULL, NULL, NULL, NULL, NULL, 'perkara_banding', 'penerimaan_kembali_berkas_banding', 'Y', '0'),
      (4051, 15, 20, 'Banding', '390', 'Putusan Banding', '3', '3', '290', 'perkara_banding', 'permohonan_banding', 'perkara_banding', 'putusan_banding', 'Y', '1'),
      (4052, 15, 20, 'Banding', '391', 'Pencabutan Perkara Banding', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', '0'),
      (4053, 15, 20, 'Banding', '400', 'Pemberitahuan Putusan Banding', '14', '2', '390', 'perkara_banding', 'putusan_banding', 'perkara_banding', 'pemberitahuan_putusan_banding', 'Y', '1'),
      (4054, 15, 30, 'Kasasi', '410', 'Permohonan Kasasi', '14', '2', '400', 'perkara_banding', 'pemberitahuan_putusan_banding', 'perkara_kasasi', 'permohonan_kasasi', 'Y', '0'),
      (4055, 15, 30, 'Kasasi', '420', 'Pemberitahuan Permohonan Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pemberitahuan_kasasi', 'Y', '0'),
      (4056, 15, 30, 'Kasasi', '430', 'Penerimaan Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_memori_kasasi', 'Y', '0'),
      (4057, 15, 30, 'Kasasi', '440', 'Penyerahan Memori Kasasi', '14', '2', '410', 'perkara_kasasi', 'permohonan_kasasi', 'perkara_kasasi', 'penyerahan_memori_kasasi', 'Y', '1'),
      (4058, 15, 30, 'Kasasi', '450', 'Penerimaan Kontra Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_kontra_kasasi', 'Y', '0'),
      (4059, 15, 30, 'Kasasi', '460', 'Penyerahan Kontra Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penyerahan_kontra_kasasi', 'Y', '0'),
      (4060, 15, 30, 'Kasasi', '461', 'Permberitahuan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pemberitahuan_inzage_pemohon_kasasi', 'Y', '0'),
      (4061, 15, 30, 'Kasasi', '464', 'Pelaksanaan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pelaksanaan_inzage_termohon_kasasi', 'Y', '0'),
      (4062, 15, 30, 'Kasasi', '470', 'Pengiriman Berkas Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pengiriman_berkas_kasasi', 'Y', '0'),
      (4063, 15, 30, 'Kasasi', '480', 'Penerimaan Kembali Berkas Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_berkas_kasasi', 'Y', '0'),
      (4064, 15, 30, 'Kasasi', '490', 'Putusan Kasasi', '6', '3', '410', 'perkara_kasasi', 'permohonan_kasasi', 'perkara_kasasi', 'putusan_kasasi', 'Y', '1'),
      (4065, 15, 30, 'Kasasi', '491', 'Pencabutan Perkara Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'tanggal_cabut', 'Y', '0'),
      (4066, 15, 30, 'Kasasi', '492', 'Tidak Memenuhi Syarat Formil', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'tidak_memenuhi_syarat', 'Y', '0'),
      (4067, 15, 30, 'Kasasi', '500', 'Pemberitahuan Putus Kasasi', '30', '2', '490', 'perkara_kasasi', 'putusan_kasasi', 'perkara_kasasi', 'pemberitahuan_putusan_kasasi', 'Y', '1'),
      (4068, 15, 40, 'Peninjauan Kembali', '510', 'Permohonan PK', NULL, NULL, NULL, NULL, 'pemberitahuan_putusan_kasasi', 'perkara_pk', 'permohonan_pk', 'Y', '0'),
      (4069, 15, 40, 'Peninjauan Kembali', '520', 'Pemberitahuan PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'pemberitahuan_pk', 'Y', '0'),
      (4070, 15, 40, 'Peninjauan Kembali', '521', 'Penerimaan Memori PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_memori_pk', 'Y', '0'),
      (4071, 15, 40, 'Peninjauan Kembali', '522', 'Penyerahan Memori PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penyerahan_memori_pk', 'Y', '0'),
      (4072, 15, 40, 'Peninjauan Kembali', '530', 'Penerimaan Jawaban PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_kontra_pk', 'Y', '0'),
      (4073, 15, 40, 'Peninjauan Kembali', '540', 'Penyerahan Jawaban PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penyerahan_kontra_pk', 'Y', '0'),
      (4074, 15, 40, 'Peninjauan Kembali', '550', 'Pengiriman Berkas PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'pengiriman_berkas_pk', 'Y', '0'),
      (4075, 15, 40, 'Peninjauan Kembali', '560', 'Penerimaan Kembali Berkas PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_berkas_pk', 'Y', '0'),
      (4076, 15, 40, 'Peninjauan Kembali', '570', 'Putusan PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'putusan_pk', 'Y', '0'),
      (4077, 15, 40, 'Peninjauan Kembali', '571', 'Pemberitahuan Putusan PK', '30', '2', '570', 'perkara_pk', 'putusan_pk', 'perkara_pk', 'pemberitahuan_putusan_pk', 'Y', '1'),
      (4078, 15, 50, 'Eksekusi', '600', 'Permohonan Eksekusi', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'permohonan_eksekusi', 'Y', '0'),
      (4079, 15, 50, 'Eksekusi', '605', 'Penetapan Teguran Eksekusi', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_teguran_eksekusi', 'Y', '0'),
      (4080, 15, 50, 'Eksekusi', '610', 'Pelaksaan Penegoran(Aanmaning)', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'pelaksanaan_teguran_eksekusi', 'Y', '0'),
      (4081, 15, 50, 'Eksekusi', '615', 'Penetapan Sita Eksekusi', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_sita_eksekusi', 'Y', '0'),
      (4082, 15, 50, 'Eksekusi', '620', 'Pelaksanaan Sita Eksekusi', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'pelaksanaan_sita_eksekusi', 'Y', '0'),
      (4083, 15, 50, 'Eksekusi', '622', 'Penetapan Perintah Eksekusi Lelang', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_perintah_eksekusi_lelang', 'Y', '0'),
      (4084, 15, 50, 'Eksekusi', '624', 'Pelaksanaan Eksekusi Lelang', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'pelaksanaan_eksekusi_lelang', 'Y', '0'),
      (4085, 15, 50, 'Eksekusi', '626', 'Penyerahan Hasil Eksekusi Lelang', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penyerahan_hasil_lelang', 'Y', '0'),
      (4086, 15, 50, 'Eksekusi', '628', 'Penetapan Perintah Eksekusi Rill', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_perintah_eksekusi_rill', 'Y', '0'),
      (4087, 15, 50, 'Eksekusi', '630', 'Pelaksaan Eksekusi Rill', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'pelaksanaan_eksekusi_rill', 'Y', '0'),
      (4088, 15, 50, 'Eksekusi', '640', 'Penetapan Sita Non Eksekutable', NULL, NULL, NULL, NULL, NULL, 'perkara_eksekusi', 'penetapan_noneksekusi', 'Y', '0'),
      (4089, 16, 10, 'Pendaftaran', '10', 'Pendaftaran Perkara', NULL, NULL, NULL, NULL, 'tanggal_pendaftaran', 'perkara', 'tanggal_pendaftaran', 'Y', '0'),
      (4090, 16, 12, 'Penetapan', '20', 'Penetapan Majelis Hakim/Hakim', '3', '1', '10', 'perkara', 'tanggal_pendaftaran', 'perkara_penetapan', 'penetapan_majelis_hakim', 'Y', '1'),
      (4091, 16, 12, 'Penetapan', '21', 'Penetapan Kembali Majelis Hakim/Hakim', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', '0'),
      (4092, 16, 12, 'Penetapan', '30', 'Penunjukan Panitera Pengganti', '3', '1', '10', 'perkara', 'tanggal_pendaftaran', 'perkara_penetapan', 'penetapan_panitera_pengganti', 'Y', '0'),
      (4093, 16, 12, 'Penetapan', '31', 'Penunjukan Kembali Panitera Pengganti', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', '0'),
      (4094, 16, 12, 'Penetapan', '40', 'Penunjukan Jurusita', NULL, NULL, NULL, NULL, NULL, 'perkara_penetapan', 'penetapan_jurusita', 'Y', '0'),
      (4095, 16, 12, 'Penetapan', '41', 'Penunjukan Kembali Jurusita', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', '0'),
      (4096, 16, 12, 'Penetapan', '80', 'Penetapan Hari Sidang Pertama', '3', '1', '20', 'perkara_penetapan', 'penetapan_majelis_hakim', 'perkara_penetapan', 'penetapan_hari_sidang', 'Y', '1'),
      (4097, 16, 12, 'Penetapan', '81', 'Sidang pertama', NULL, NULL, NULL, NULL, 'penetapan_panitera_pengganti', 'perkara_penetapan', 'sidang_pertama', 'Y', '0'),
      (4098, 16, 14, 'Persidangan', '200', 'Persidangan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Y', '1'),
      (4099, 16, 15, 'Putusan', '210', 'Putusan', '5', '3', '150', 'perkara_mediasi', 'mediasi_gagal', 'perkara_putusan', 'tanggal_putusan', 'Y', '1'),
      (4100, 16, 15, 'Putusan', '211', 'Pencabutan Perkara', NULL, NULL, NULL, NULL, NULL, 'perkara_putusan', 'tanggal_cabut', 'Y', '0'),
      (4101, 16, 15, 'Putusan', '212', 'Pernyataan Gugur', NULL, NULL, NULL, NULL, NULL, 'perkara_putusan', 'tanggal_gugur', 'Y', '0'),
      (4102, 16, 15, 'Putusan', '218', 'Pemberitahuan Putusan', NULL, NULL, NULL, NULL, NULL, 'perkara_putusan', 'pemberitahuan_putusan', 'Y', '0'),
      (4103, 16, 15, 'Putusan', '220', 'Pembuatan Minutasi', '14', '2', '210', 'perkara_putusan', 'tanggal_putusan', 'perkara_putusan', 'tanggal_minutasi', 'Y', '1'),
      (4104, 16, 30, 'Kasasi', '410', 'Permohonan Kasasi', '14', '2', '400', 'perkara_banding', 'pemberitahuan_putusan_banding', 'perkara_kasasi', 'permohonan_kasasi', 'Y', '0'),
      (4105, 16, 30, 'Kasasi', '420', 'Pemberitahuan Permohonan Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pemberitahuan_kasasi', 'Y', '0'),
      (4106, 16, 30, 'Kasasi', '430', 'Penerimaan Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_memori_kasasi', 'Y', '0'),
      (4107, 16, 30, 'Kasasi', '440', 'Penyerahan Memori Kasasi', '14', '2', '410', 'perkara_kasasi', 'permohonan_kasasi', 'perkara_kasasi', 'penyerahan_memori_kasasi', 'Y', '1'),
      (4108, 16, 30, 'Kasasi', '450', 'Penerimaan Kontra Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_kontra_kasasi', 'Y', '0'),
      (4109, 16, 30, 'Kasasi', '460', 'Penyerahan Kontra Memori Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penyerahan_kontra_kasasi', 'Y', '0'),
      (4110, 16, 30, 'Kasasi', '461', 'Permberitahuan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pemberitahuan_inzage_pemohon_kasasi', 'Y', '0'),
      (4111, 16, 30, 'Kasasi', '464', 'Pelaksanaan Untuk Memeriksa Berkas(Inzage)', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pelaksanaan_inzage_termohon_kasasi', 'Y', '0'),
      (4112, 16, 30, 'Kasasi', '470', 'Pengiriman Berkas Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'pengiriman_berkas_kasasi', 'Y', '0'),
      (4113, 16, 30, 'Kasasi', '480', 'Penerimaan Kembali Berkas Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'penerimaan_berkas_kasasi', 'Y', '0'),
      (4114, 16, 30, 'Kasasi', '490', 'Putusan Kasasi', '6', '3', '410', 'perkara_kasasi', 'permohonan_kasasi', 'perkara_kasasi', 'putusan_kasasi', 'Y', '1'),
      (4115, 16, 30, 'Kasasi', '491', 'Pencabutan Perkara Kasasi', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'tanggal_cabut', 'Y', '0'),
      (4116, 16, 30, 'Kasasi', '492', 'Tidak Memenuhi Syarat Formil', NULL, NULL, NULL, NULL, NULL, 'perkara_kasasi', 'tidak_memenuhi_syarat', 'Y', '0'),
      (4117, 16, 30, 'Kasasi', '500', 'Pemberitahuan Putus Kasasi', '30', '2', '490', 'perkara_kasasi', 'putusan_kasasi', 'perkara_kasasi', 'pemberitahuan_putusan_kasasi', 'Y', '1'),
      (4118, 16, 40, 'Peninjauan Kembali', '510', 'Permohonan PK', NULL, NULL, NULL, NULL, 'pemberitahuan_putusan_kasasi', 'perkara_pk', 'permohonan_pk', 'Y', '0'),
      (4119, 16, 40, 'Peninjauan Kembali', '520', 'Pemberitahuan PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'pemberitahuan_pk', 'Y', '0'),
      (4120, 16, 40, 'Peninjauan Kembali', '521', 'Penerimaan Memori PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_memori_pk', 'Y', '0'),
      (4121, 16, 40, 'Peninjauan Kembali', '522', 'Penyerahan Memori PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penyerahan_memori_pk', 'Y', '0'),
      (4122, 16, 40, 'Peninjauan Kembali', '530', 'Penerimaan Jawaban PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_kontra_pk', 'Y', '0'),
      (4123, 16, 40, 'Peninjauan Kembali', '540', 'Penyerahan Jawaban PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penyerahan_kontra_pk', 'Y', '0'),
      (4124, 16, 40, 'Peninjauan Kembali', '550', 'Pengiriman Berkas PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'pengiriman_berkas_pk', 'Y', '0'),
      (4125, 16, 40, 'Peninjauan Kembali', '560', 'Penerimaan Kembali Berkas PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'penerimaan_berkas_pk', 'Y', '0'),
      (4126, 16, 40, 'Peninjauan Kembali', '570', 'Putusan PK', NULL, NULL, NULL, NULL, NULL, 'perkara_pk', 'putusan_pk', 'Y', '0'),
      (4127, 16, 40, 'Peninjauan Kembali', '571', 'Pemberitahuan Putusan PK', '30', '2', '570', 'perkara_pk', 'putusan_pk', 'perkara_pk', 'pemberitahuan_putusan_pk', 'Y', '1'),
      (607,122,10,'Pendaftaran','10','Pendaftaran Perkara',NULL,NULL,NULL,NULL,NULL,'perkara','tanggal_pendaftaran','Y','0'),
      (608,122,12,'Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1'),
      (609,122,12,'Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0'),
      (610,122,12,'Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0'),
      (611,122,12,'Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0'),
      (612,122,12,'Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0'),
      (613,122,12,'Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0'),
      (614,122,12,'Penetapan','80','Penetapan Hari Sidang Pertama','7','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1'),
      (615,122,12,'Penetapan','81','Sidang pertama',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','sidang_pertama','Y','0'),
      (623,122,14,'Persidangan','200','Persidangan',NULL,'',NULL,NULL,NULL,'','','Y','0'),
      (624,122,15,'Putusan','210','Putusan','5','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1'),
      (628,122,15,'Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0'),
      (637,122,15,'Putusan','219','Kirim Salinan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','kirim_salinan_putusan_penyidik','Y','0'),
      (627,122,15,'Putusan','220','Pembuatan Minutasi','14','1','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1'),
      (645,122,20,'Banding','300','Permohonan Banding','14','1','210','perkara_putusan','tanggal_putusan','perkara_banding','permohonan_banding','Y','0'),
      (646,122,20,'Banding','301','Pemberitahuan Permohonan Banding','7','1','290','perkara_banding','permohonan_banding','perkara_banding','pemberitahuan_permohonan_banding','Y','1'),
      (647,122,20,'Banding','310','Penerimaan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_memori_banding','Y','0'),
      (648,122,20,'Banding','320','Penyerahan Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_memori_banding','Y','0'),
      (649,122,20,'Banding','330','Penerimaan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kontra_banding','Y','0'),
      (650,122,20,'Banding','340','Penyerahan Kontra Memori Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penyerahan_kontra_banding','Y','0'),
      (651,122,20,'Banding','350','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0'),
      (652,122,20,'Banding','360','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_banding_detil','pemberitahuan_inzage','Y','0'),
      (655,122,20,'Banding','370','Pengiriman Berkas  Banding','30','2','290','perkara_banding','permohonan_banding','perkara_banding','pengiriman_berkas_banding','Y','1'),
      (656,122,20,'Banding','380','Penerimaan Kembali Berkas Banding',NULL,NULL,NULL,NULL,NULL,'perkara_banding','penerimaan_kembali_berkas_banding','Y','0'),
      (657,122,20,'Banding','390','Putusan Banding','3','3','290','perkara_banding','permohonan_banding','perkara_banding','putusan_banding','Y','1'),
      (1321,122,20,'Banding','391','Pencabutan Perkara Banding',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'T','0'),
      (658,122,20,'Banding','400','Pemberitahuan Putusan Banding','2','1','390','perkara_banding','putusan_banding','perkara_banding','pemberitahuan_putusan_banding','Y','1'),
      (661,122,30,'Kasasi','410','Permohonan Kasasi','14','2','400','perkara_banding','pemberitahuan_putusan_banding','perkara_kasasi','permohonan_kasasi','Y','0'),
      (662,122,30,'Kasasi','420','Pemberitahuan Permohonan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_kasasi','Y','0'),
      (663,122,30,'Kasasi','430','Penerimaan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_memori_kasasi','Y','0'),
      (664,122,30,'Kasasi','440','Penyerahan Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_memori_kasasi','Y','0'),
      (665,122,30,'Kasasi','450','Penerimaan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_kontra_kasasi','Y','0'),
      (666,122,30,'Kasasi','460','Penyerahan Kontra Memori Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penyerahan_kontra_kasasi','Y','0'),
      (667,122,30,'Kasasi','461','Permberitahuan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_inzage_pemohon_kasasi','Y','0'),
      (670,122,30,'Kasasi','464','Pelaksanaan Untuk Memeriksa Berkas(Inzage)',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pelaksanaan_inzage_termohon_kasasi','Y','0'),
      (671,122,30,'Kasasi','470','Pengiriman Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pengiriman_berkas_kasasi','Y','0'),
      (672,122,30,'Kasasi','480','Penerimaan Kembali Berkas Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','penerimaan_berkas_kasasi','Y','0'),
      (673,122,30,'Kasasi','490','Putusan Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','putusan_kasasi','Y','0'),
      (674,122,30,'Kasasi','500','Pemberitahuan Putus Kasasi',NULL,NULL,NULL,NULL,NULL,'perkara_kasasi','pemberitahuan_putusan_kasasi','Y','0'),
      (677,122,40,'Peninjauan Kembali','510','Permohonan PK','14','1','500','perkara_kasasi','pemberitahuan_putusan_kasasi','perkara_pk','permohonan_pk','Y','0'),
      (678,122,40,'Peninjauan Kembali','520','Pemberitahuan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_pk','Y','0'),
      (679,122,40,'Peninjauan Kembali','521','Penerimaan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_memori_pk','Y','0'),
      (680,122,40,'Peninjauan Kembali','522','Penyerahan Memori PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_memori_pk','Y','0'),
      (687,122,40,'Peninjauan Kembali','523','Penerimaan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0'),
      (688,122,40,'Penyerahan Kontra Memori PK','524','Penyerahan Kontra Memori PK',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0'),
      (681,122,40,'Peninjauan Kembali','530','Penerimaan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_kontra_pk','Y','0'),
      (682,122,40,'Peninjauan Kembali','540','Penyerahan Jawaban PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penyerahan_kontra_pk','Y','0'),
      (683,122,40,'Peninjauan Kembali','550','Pengiriman Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pengiriman_berkas_pk','Y','0'),
      (684,122,40,'Peninjauan Kembali','560','Penerimaan Kembali Berkas PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','penerimaan_berkas_pk','Y','0'),
      (685,122,40,'Peninjauan Kembali','570','Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','putusan_pk','Y','0'),
      (686,122,40,'Peninjauan Kembali','571','Pemberitahuan Putusan PK',NULL,NULL,NULL,NULL,NULL,'perkara_pk','pemberitahuan_putusan_pk','Y','0'),
      (700,122,60,'Grasi','650','Permohonan Grasi PN',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','permohonan_grasi','Y','0'),
      (701,122,60,'Grasi','660','Pengiriman salinan permohonan grasi berikut berkas putusan dari PN ke Kejaksaan','7','1','650','perkara_grasi','permohonan_grasi','perkara_grasi','pengiriman_berkas_grasi_ke_kejaksaan','Y','1'),
      (702,122,60,'Grasi','662','Pengiriman salinan permohonan grasi berikut berkas putusan ke MA',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pengiriman_berkas_grasi_ke_kejaksaan','Y','0'),
      (703,122,60,'Grasi','665','Pengiriman pertimbangan berikut berkas perkara dari MA ke Presiden',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pengiriman_pertimbangan_hakim_grasi','Y','0'),
      (704,122,60,'Grasi','670','Penerimaan Kembali Berkas Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','tanggal_penerimaan_kembali_berkas_grasi','Y','0'),
      (705,122,60,'Grasi','680','Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','tanggal_putusan_grasi','Y','0'),
      (706,122,60,'Grasi','690','Pemberitahuan Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pemberitahuan_putusan_grasi','Y','0'),
      (707,122,60,'Grasi','700','Pemberitahuan Tembusan Putusan Grasi',NULL,NULL,NULL,NULL,NULL,'perkara_grasi','pemberitahuan_tembusan_grasi','Y','0'),
      (1494,123,10,'Pendaftaran','10','Pendaftaran Perkara',NULL,NULL,NULL,NULL,NULL,'perkara','tanggal_pendaftaran','Y','0'),
      (1495,123,12,'Penetapan','20','Penetapan Majelis Hakim/Hakim','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_majelis_hakim','Y','1'),
      (1496,123,12,'Penetapan','21','Penetapan Kembali Majelis Hakim/Hakim',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0'),
      (1497,123,12,'Penetapan','30','Penunjukan Panitera Pengganti','3','1','10','perkara','tanggal_pendaftaran','perkara_penetapan','penetapan_panitera_pengganti','Y','0'),
      (1498,123,12,'Penetapan','31','Penunjukan Kembali Panitera Pengganti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0'),
      (1499,123,12,'Penetapan','40','Penunjukan Jurusita',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','penetapan_jurusita','Y','0'),
      (1500,123,12,'Penetapan','41','Penunjukan Kembali Jurusita',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0'),
      (1501,123,12,'Penetapan','80','Penetapan Hari Sidang Pertama','7','1','20','perkara_penetapan','penetapan_majelis_hakim','perkara_penetapan','penetapan_hari_sidang','Y','1'),
      (1502,123,12,'Penetapan','81','Sidang pertama',NULL,NULL,NULL,NULL,NULL,'perkara_penetapan','sidang_pertama','Y','0'),
      (1503,123,14,'Persidangan','200','Persidangan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Y','0'),
      (1504,123,15,'Putusan','210','Putusan','6','3','10','perkara','tanggal_pendaftaran','perkara_putusan','tanggal_putusan','Y','1'),
      (1505,123,15,'Putusan','211','Pencabutan Perkara',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_cabut','Y','0'),
      (1506,123,15,'Putusan','212','Pernyataan Gugur',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','tanggal_gugur','Y','0'),
      (1507,123,15,'Putusan','218','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0'),
      (1508,123,15,'Putusan','220','Pembuatan Minutasi','14','1','210','perkara_putusan','tanggal_putusan','perkara_putusan','tanggal_minutasi','Y','1'),
      (1509,123,15,'Putusan','230','Pemberitahuan Putusan',NULL,NULL,NULL,NULL,NULL,'perkara_putusan','pemberitahuan_putusan','Y','0');");

$this->db->query("DROP TABLE IF EXISTS updates;");
$this->db->query("CREATE TABLE updates (
        id int(11) NOT NULL AUTO_INCREMENT,
        patch_ver varchar(50) NULL,
        source_path varchar(250) NULL,
        stamp timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
        updated tinyint(1) NOT NULL DEFAULT '0',
        updated_stamp datetime DEFAULT NULL,
        PRIMARY KEY (id)
      ) ENGINE=InnoDB;");

$isthere = FALSE;
$result = $this->db->query("SHOW INDEXES FROM template_perkara_bas_detil_tanya_jawab WHERE Key_name = 'PRIMARY'");
if(!empty($result)){
    if($result->num_rows>0){
        $isthere = TRUE;
    }
}
if(!$isthere){
	$this->db->query("ALTER TABLE template_perkara_bas_detil_tanya_jawab   
		ADD COLUMN id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT FIRST,
		CHANGE perkara_id perkara_id BIGINT(20) UNSIGNED NOT NULL, 
		ADD PRIMARY KEY (id),
		ADD CONSTRAINT fk_perkara FOREIGN KEY (perkara_id) REFERENCES perkara(perkara_id);");
}
$this->db->query("ALTER TABLE template_perkara_bas   
  CHANGE perkara_id perkara_id BIGINT(20) UNSIGNED NOT NULL;");

$isthere = FALSE;
$result = $this->db->query("SHOW INDEXES FROM template_perkara_bas WHERE Key_name = 'PRIMARY'");
if(!empty($result)){
    if($result->num_rows>0){
        $isthere = TRUE;
    }
}
if(!$isthere){
	$this->db->query("ALTER TABLE template_perkara_bas  
	  ADD CONSTRAINT fk_perkara_template FOREIGN KEY (perkara_id) REFERENCES perkara(perkara_id) ON DELETE CASCADE;");
}
$isthere = FALSE;
$result = $this->db->query("SHOW INDEXES FROM template_perkara_bas_penutup WHERE Key_name = 'PRIMARY'");
if(!empty($result)){
    if($result->num_rows>0){
        $isthere = TRUE;
    }
}
if(!$isthere){
	$this->db->query("ALTER TABLE template_perkara_bas_penutup   
		CHANGE perkara_id perkara_id BIGINT(20) UNSIGNED NOT NULL,
		ADD CONSTRAINT fk_perkara_bas FOREIGN KEY (perkara_id) REFERENCES perkara(perkara_id) ON DELETE CASCADE;");
}

$isUMum = FALSE;
$result = $this->db->query("SELECT `value` FROM sys_config WHERE id = 83 AND `value`=1;");
if(!empty($result)){
    if($result->num_rows>0){
        $isUMum = TRUE;
    }
}

if($isUMum==TRUE){
  $isThere = $modelClass->patching->isTableExist('perkara_putusan_terdakwa_copy');
  if(empty($isThere)){
      $sql = "CREATE TABLE perkara_putusan_terdakwa_copy LIKE perkara_putusan_terdakwa;";
      $modelClass->patching->exe_script($sql);
      $sql = "REPLACE INTO perkara_putusan_terdakwa_copy SELECT * FROM perkara_putusan_terdakwa;";
      $modelClass->patching->exe_script($sql);
      $sql = "DROP TABLE IF EXISTS perkara_putusan_terdakwa_tmp;";
      $modelClass->patching->exe_script($sql);

      $sql = "CREATE TABLE perkara_putusan_terdakwa_tmp (
                  pihak2_id bigint(20) unsigned NOT NULL,
                  perkara_id bigint(20) unsigned NOT NULL,
                  pihak_id bigint(20) unsigned NOT NULL,
                  tanggal_putusan date DEFAULT NULL,
                  status_putusan_id tinyint(4) NOT NULL,
                  status_putusan_text varchar(75) DEFAULT NULL,
                  durasi_nominal TEXT DEFAULT NULL,
                  satuan tinyint(4) DEFAULT NULL,
                  keterangan_putusan varchar(1000) DEFAULT NULL,
                  diinput_oleh varchar(30) DEFAULT NULL,
                  diinput_tanggal datetime DEFAULT NULL,
                  diperbaharui_oleh varchar(30) DEFAULT NULL,
                  diperbaharui_tanggal datetime DEFAULT NULL,
                  PRIMARY KEY (pihak2_id,perkara_id,status_putusan_id),
                  KEY perkara_id (perkara_id),
                  KEY pihak_id (pihak_id),
                  KEY status_putusan_id (status_putusan_id)
              ) ENGINE=InnoDB;";
      $modelClass->patching->exe_script($sql);

      $sql = "REPLACE INTO perkara_putusan_terdakwa_tmp
              SELECT pihak2_id, perkara_id, pihak_id,tanggal_putusan, status_putusan, s.nama AS status_putusan_text, 
              CASE
                  WHEN status_putusan=13 THEN (pidana_penjara_waktu_tertentu_tahun*12*30)+(pidana_penjara_waktu_tertentu_bulan*30)+pidana_penjara_waktu_tertentu_hari
                  WHEN status_putusan=14 THEN (pidana_kurungan_tahun*12*30)+(pidana_kurungan_bulan*30)+pidana_kurungan_hari
                  WHEN status_putusan=16 THEN pidana_denda_nominal
                  WHEN status_putusan=17 THEN CONCAT(
                   IF(pidana_tambahan_tahun=0,'',concat(pidana_tambahan_tahun, ' Tahun, ')),
                   IF(pidana_tambahan_bulan=0,'',concat(pidana_tambahan_bulan, ' Bulan  ')),
                   IF(pidana_tambahan_hari=0,'',concat(pidana_tambahan_hari, ' Hari ')))
                  WHEN status_putusan=23 THEN (subsider_penjara_tahun*12*30)+(subsider_penjara_bulan*30)+subsider_penjara_hari
                  WHEN status_putusan=24 THEN (subsider_kurungan_tahun*12*30)+(subsider_kurungan_bulan*30)+subsider_kurungan_hari
                  WHEN status_putusan=25 THEN subsider_denda_nominal
                  ELSE 0
              END
                  AS durasi_nominal,
              s.satuan, keterangan_putusan, put.diinput_oleh, put.diinput_tanggal, put.diperbaharui_oleh, put.diperbaharui_tanggal
                  FROM (
                      SELECT SUBSTRING_INDEX(SUBSTRING_INDEX(e.status_putusan_id, ',', n.n), ',', -1) AS status_putusan, e.*
                          FROM perkara_putusan_terdakwa AS e CROSS JOIN (
                                  SELECT a.N + b.N * 10 + 1 n
                                  FROM 
                                      (SELECT 0 AS N UNION ALL SELECT 1 UNION ALL SELECT 2 UNION ALL SELECT 3 UNION ALL SELECT 4 UNION ALL SELECT 5 UNION ALL SELECT 6 UNION ALL SELECT 7           UNION ALL SELECT 8 UNION ALL SELECT 9) a,
                                      (SELECT 0 AS N UNION ALL SELECT 1 UNION ALL SELECT 2 UNION ALL SELECT 3 UNION ALL SELECT 4 UNION ALL SELECT 5 UNION ALL SELECT 6 UNION ALL SELECT 7
                                      UNION ALL SELECT 8 UNION ALL SELECT 9) b
                                      ORDER BY n) n
                              GROUP BY status_putusan, pihak2_id,perkara_id
                      ORDER BY e.pihak2_id, e.status_putusan_id ASC) AS put
                      LEFT JOIN
                          status_putusan AS s
                          ON s.id = put.status_putusan;";
      $modelClass->patching->exe_script($sql);
      $modelClass->dbforge->drop_table('perkara_putusan_terdakwa',TRUE);
      $modelClass->dbforge->rename_table('perkara_putusan_terdakwa_tmp', 'perkara_putusan_terdakwa');
  }else{
      $sql = "DROP TABLE IF EXISTS perkara_putusan_terdakwa_tmp;";
      $modelClass->patching->exe_script($sql);

      $sql = "CREATE TABLE perkara_putusan_terdakwa_tmp (
                  pihak2_id bigint(20) unsigned NOT NULL,
                  perkara_id bigint(20) unsigned NOT NULL,
                  pihak_id bigint(20) unsigned NOT NULL,
                  tanggal_putusan date DEFAULT NULL,
                  status_putusan_id tinyint(4) NOT NULL,
                  status_putusan_text varchar(75) DEFAULT NULL,
                  durasi_nominal TEXT DEFAULT NULL,
                  satuan tinyint(4) DEFAULT NULL,
                  keterangan_putusan varchar(1000) DEFAULT NULL,
                  diinput_oleh varchar(30) DEFAULT NULL,
                  diinput_tanggal datetime DEFAULT NULL,
                  diperbaharui_oleh varchar(30) DEFAULT NULL,
                  diperbaharui_tanggal datetime DEFAULT NULL,
                  PRIMARY KEY (pihak2_id,perkara_id,status_putusan_id),
                  KEY perkara_id (perkara_id),
                  KEY pihak_id (pihak_id),
                  KEY status_putusan_id (status_putusan_id)
              ) ENGINE=InnoDB;";
      $modelClass->patching->exe_script($sql);
      $sql = "REPLACE INTO perkara_putusan_terdakwa_tmp
              SELECT pihak2_id, perkara_id, pihak_id,tanggal_putusan, status_putusan, s.nama AS status_putusan_text, 
              CASE
                  WHEN status_putusan=13 THEN (pidana_penjara_waktu_tertentu_tahun*12*30)+(pidana_penjara_waktu_tertentu_bulan*30)+pidana_penjara_waktu_tertentu_hari
                  WHEN status_putusan=14 THEN (pidana_kurungan_tahun*12*30)+(pidana_kurungan_bulan*30)+pidana_kurungan_hari
                  WHEN status_putusan=16 THEN pidana_denda_nominal
                  WHEN status_putusan=17 THEN CONCAT(
                   IF(pidana_tambahan_tahun=0,'',concat(pidana_tambahan_tahun, ' Tahun, ')),
                   IF(pidana_tambahan_bulan=0,'',concat(pidana_tambahan_bulan, ' Bulan  ')),
                   IF(pidana_tambahan_hari=0,'',concat(pidana_tambahan_hari, ' Hari ')))
                  WHEN status_putusan=23 THEN (subsider_penjara_tahun*12*30)+(subsider_penjara_bulan*30)+subsider_penjara_hari
                  WHEN status_putusan=24 THEN (subsider_kurungan_tahun*12*30)+(subsider_kurungan_bulan*30)+subsider_kurungan_hari
                  WHEN status_putusan=25 THEN subsider_denda_nominal
                  ELSE 0
              END
                  AS durasi_nominal,
              s.satuan, keterangan_putusan, put.diinput_oleh, put.diinput_tanggal, put.diperbaharui_oleh, put.diperbaharui_tanggal
                  FROM (
                      SELECT SUBSTRING_INDEX(SUBSTRING_INDEX(e.status_putusan_id, ',', n.n), ',', -1) AS status_putusan, e.*
                          FROM perkara_putusan_terdakwa_copy AS e CROSS JOIN (
                                  SELECT a.N + b.N * 10 + 1 n
                                  FROM 
                                      (SELECT 0 AS N UNION ALL SELECT 1 UNION ALL SELECT 2 UNION ALL SELECT 3 UNION ALL SELECT 4 UNION ALL SELECT 5 UNION ALL SELECT 6 UNION ALL SELECT 7           UNION ALL SELECT 8 UNION ALL SELECT 9) a,
                                      (SELECT 0 AS N UNION ALL SELECT 1 UNION ALL SELECT 2 UNION ALL SELECT 3 UNION ALL SELECT 4 UNION ALL SELECT 5 UNION ALL SELECT 6 UNION ALL SELECT 7
                                      UNION ALL SELECT 8 UNION ALL SELECT 9) b
                                      ORDER BY n) n
                              GROUP BY status_putusan, pihak2_id,perkara_id
                      ORDER BY e.pihak2_id, e.status_putusan_id ASC) AS put
                      LEFT JOIN
                          status_putusan AS s
                          ON s.id = put.status_putusan;";
      $modelClass->patching->exe_script($sql);
      $modelClass->dbforge->drop_table('perkara_putusan_terdakwa',TRUE);
      $modelClass->dbforge->rename_table('perkara_putusan_terdakwa_tmp', 'perkara_putusan_terdakwa');
  }
}


$this->db->query("UPDATE sys_config SET `value` = '3.1.1-1' WHERE id = 80;");
$update = TRUE;


?>