<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class View_laporan extends CI_Controller {
	function rekap(){
		if(empty($_POST)){
			show_404();
		}

		$event = trim($this->input->post('events',TRUE));
		$th_name = trim($this->input->post('th_name',TRUE));
		$tahun = trim($this->input->post('tahun_opt',TRUE));
		$type = trim($this->input->post('jenis',TRUE));
		$tahapan = trim($this->input->post('tahapan',TRUE));
		$status = FALSE;
		if(is_numeric($event)){
			if($event>0 AND $event<=12){
				$this->nativesession->set_flash_session('event','rekap_bulan');
				$this->nativesession->set_flash_session('month',$event);
				$status = TRUE;
			}
		}elseif($event=='tab'){
			$this->nativesession->set_flash_session('event','tab');
			$status = TRUE;
		}elseif($event=='graph'){
			$this->nativesession->set_flash_session('event','graph');
			$status = TRUE;
		}

		$this->nativesession->set_flash_session('idalurperkara',$th_name);

		if(is_numeric($tahun)){
			if($tahun>=0){
				$this->nativesession->set_flash_session('tahun',$tahun);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($type)){
			if($type>0 AND $type<=6){
				$this->nativesession->set_flash_session('type',$type);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($tahapan)){
			if($tahapan==10 OR $tahapan==20 OR $tahapan==30 OR $tahapan==40 OR $tahapan==50 OR $tahapan==60 OR $tahapan==88 OR $tahapan==99){
				$this->nativesession->set_flash_session('tahapan',$tahapan);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		if($status===TRUE){
			$this->nativesession->set_flash_session('view','view_rekap_perkara');
			echo json_encode(array('st'=>1,'msg'=>'Done'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Invalid Argument'));
		}
	}

	function rekap_bulan(){
		if(empty($_POST)){
			show_404();
		}

		$event = trim($this->input->post('events',TRUE));
		$th_name = trim($this->input->post('th_name',TRUE));
		$tahun = trim($this->input->post('tahun_opt',TRUE));
		$type = trim($this->input->post('jenis',TRUE));
		$tahapan = trim($this->input->post('tahapan',TRUE));
		$bulan = trim($this->input->post('bulan',TRUE));
		$status = FALSE;
		if(is_numeric($event)){
			if($event>0 AND $event<=12){
				$this->nativesession->set_flash_session('event','rekap_bulan');
				$this->nativesession->set_flash_session('month',$event);
				$status = TRUE;
			}
		}elseif($event=='tab'){
			$this->nativesession->set_flash_session('event','tab');
			$status = TRUE;
		}elseif($event=='graph'){
			$this->nativesession->set_flash_session('event','graph');
			$status = TRUE;
		}

		$this->nativesession->set_flash_session('idalurperkara',$th_name);

		if(is_numeric($tahun)){
			if($tahun>=0){
				$this->nativesession->set_flash_session('tahun',$tahun);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($bulan)){
			if($bulan>=0){
				$this->nativesession->set_flash_session('bulan',$bulan);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($type)){
			if($type>0 AND $type<=6){
				$this->nativesession->set_flash_session('type',$type);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($tahapan)){
			if($tahapan==10 OR $tahapan==20 OR $tahapan==30 OR $tahapan==40 OR $tahapan==50 OR $tahapan==60 OR $tahapan==88 OR $tahapan==99){
				$this->nativesession->set_flash_session('tahapan',$tahapan);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		if($status===TRUE){
			$this->nativesession->set_flash_session('view','view_rekap_perkara_bulan');
			echo json_encode(array('st'=>1,'msg'=>'Done'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Invalid Argument'));
		}
	}

	function laporan(){
		if(empty($_POST)){
			show_404();
		}

		$event = trim($this->input->post('month',TRUE));
		$jenis = trim($this->input->post('jenis',TRUE));
		$tahun = trim($this->input->post('tahun_opt',TRUE));
		$tahapan = trim($this->input->post('tahapan',TRUE));
		$status = FALSE;
		if(is_numeric($event)){
			if($event>0 AND $event<=12){
				$this->nativesession->set_flash_session('event','laporan');
				$this->nativesession->set_flash_session('month',$event);
				$status = TRUE;
			}
		}

		if(is_numeric($tahapan)){
			if($tahapan==10 OR $tahapan==20 OR $tahapan==30 OR $tahapan==40 OR $tahapan==50 OR $tahapan==60 OR $tahapan==88 OR $tahapan==99){
				$this->nativesession->set_flash_session('tahapan',$tahapan);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		$this->nativesession->set_flash_session('idalurperkara',$jenis);
		if(is_numeric($tahun)){
			if($tahun>=0){
				$this->nativesession->set_flash_session('tahun',$tahun);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}

		if($status===TRUE){
			$this->nativesession->set_flash_session('view','view_laporan');
			echo json_encode(array('st'=>1,'msg'=>'Silahkan Membuka Laporan Pada Tab'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Invalid Argument'));
		}
	}

	function index(){
		$act = $this->nativesession->get_flash_session('view');
		if($act==='view_rekap_perkara'){
			$this->view_rekap_perkara();
		}elseif($act==='view_laporan'){
			$this->view_laporan_perkara();
		}elseif($act==='view_rekap_perkara_bulan'){
			$this->view_rekap_perkara_bulan();
		}else{
			show_404();
		}
	}

	function view_rekap_perkara_bulan(){
		$idalurperkara = $this->nativesession->get_flash_session('idalurperkara');
		$tahun = $this->nativesession->get_flash_session('tahun');
		$bulan = $this->nativesession->get_flash_session('bulan');
		$type = $this->nativesession->get_flash_session('type');
		$tahapan = $this->nativesession->get_flash_session('tahapan');
		$data['bulan'] = $bulan;
		$bulan = ($bulan<10)? '0'.$bulan:$bulan;
		$periode = $tahun.'-'.$bulan;
		$this->load->model('report/report','report');
		$data['laporan'] = $this->report->get_stat_perkara_bln($periode,$idalurperkara);
		$data['tahun'] = $tahun;
		$data['idalurperkara'] = $idalurperkara;
		$data['perkara_nama'] = strtoupper($this->report->getJenisPerkara($idalurperkara));
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}
		$data['view_lap'] = 'laporan/view_laporan_perkara_bulan';
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}
	function view_rekap_perkara(){
		$idalurperkara = $this->nativesession->get_flash_session('idalurperkara');
		$tahun = $this->nativesession->get_flash_session('tahun');
		$type = $this->nativesession->get_flash_session('type');
		$tahapan = $this->nativesession->get_flash_session('tahapan');
		if($type==1){
			if($idalurperkara<100){
				$this->load->model('report/report','report');
				$data['view_lap'] = 'laporan/view_rekap_perkara';
			}elseif($idalurperkara>=111 || $idalurperkara<=114){
				$this->load->model('report/report_pid','report');
				$data['view_lap'] = 'laporan/view_rekap_perkara_pid';				
			}
		}elseif($type==2){
			if($tahapan==10){
				$this->load->model('report/report_hakim','report');
				$data['view_lap'] = 'laporan/view_rekap_hakim';
			}elseif($tahapan==20){
				$this->load->model('report/report_hakim_banding','report');
				$data['view_lap'] = 'laporan/view_rekap_hakim_upaya_hukum';
				$data['upaya_hukum'] = 'BANDING';
			}elseif($tahapan==30){
				$this->load->model('report/report_hakim_kasasi','report');
				$data['view_lap'] = 'laporan/view_rekap_hakim_upaya_hukum';
				$data['upaya_hukum'] = 'KASASI';
			}elseif($tahapan==40){
				$this->load->model('report/report_hakim_pk','report');
				$data['view_lap'] = 'laporan/view_rekap_hakim_upaya_hukum';
				$data['upaya_hukum'] = 'PENINJAUAN KEMBALI';
			}
		#puji
		}elseif($type==3){
			if($tahapan==10){
				$this->load->model('report/report_panitera','report');
				$data['view_lap'] = 'laporan/view_rekap_panitera';
			}elseif($tahapan==20){
				$this->load->model('report/report_panitera_banding','report');
				$data['view_lap'] = 'laporan/view_rekap_panitera_upaya_hukum';
				$data['upaya_hukum'] = 'BANDING';
			}elseif($tahapan==30){
				$this->load->model('report/report_panitera_kasasi','report');
				$data['view_lap'] = 'laporan/view_rekap_panitera_upaya_hukum';
				$data['upaya_hukum'] = 'KASASI';
			}elseif($tahapan==40){
				$this->load->model('report/report_panitera_pk','report');
				$data['view_lap'] = 'laporan/view_rekap_panitera_upaya_hukum';
				$data['upaya_hukum'] = 'PANINJAUAN KEMBALI';
			}				
		}elseif($type==4){
			if($tahapan==10){
				$this->load->model('report/report_panitera','report');
				$data['view_lap'] = 'laporan/view_rekap_panitera';
			}			
		}elseif($type==5){
			if($tahapan==10){
				$this->load->model('report/report_penanganan_perkara','report');
				$data['view_lap'] = 'laporan/view_rekap_penanganan_perkara';
			}			
		}elseif($type==6){
			if($tahapan==20){
				$this->load->model('report/report_rekap_upaya_hukum_banding','report');
				$data['view_lap'] = 'laporan/view_rekap_upaya_hukum_banding';
				$data['upaya_hukum'] = 'BANDING';
			}elseif($tahapan==30){
				$this->load->model('report/report_rekap_upaya_hukum_kasasi','report');
				$data['view_lap'] = 'laporan/view_rekap_upaya_hukum_banding';
				$data['upaya_hukum'] = 'KASASI';				
			}elseif($tahapan==40){
				$this->load->model('report/report_rekap_upaya_hukum_pk','report');
				$data['view_lap'] = 'laporan/view_rekap_upaya_hukum_banding';
				$data['upaya_hukum'] = 'PENINJAUAN KEMBALI';				
			}elseif($tahapan==50){
				$this->load->model('report/report_rekap_upaya_hukum_eksekusi','report');
				$data['view_lap'] = 'laporan/view_rekap_upaya_hukum_eksekusi';
				$data['upaya_hukum'] = 'EKSEKUSI';				
			}elseif($tahapan==60){
				$this->load->model('report/report_rekap_upaya_hukum_grasi','report');
				$data['view_lap'] = 'laporan/view_rekap_upaya_hukum_grasi';
				$data['upaya_hukum'] = 'GRASI';				
			}			

		}
		
		$data['rekap'] = $this->report->get_rekap($idalurperkara,$tahun);
		$data['tahun'] = $tahun;
		
		$data['idalurperkara'] = $idalurperkara;
		$data['perkara_nama'] = strtoupper($this->report->getJenisPerkara($idalurperkara));
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}

	function view_laporan_perkara(){
		$idalurperkara = $this->nativesession->get_flash_session('idalurperkara');
		$tahun = $this->nativesession->get_flash_session('tahun');
		$bulan = $this->nativesession->get_flash_session('month');
		$tahapan = $this->nativesession->get_flash_session('tahapan');
		if($tahapan==10){
			if($idalurperkara<100){
				$this->load->model('report/report','report');
				$data['view_lap'] = 'laporan/view_laporan_pn';
			}elseif($idalurperkara==111 or $idalurperkara==115 or $idalurperkara==116 or $idalurperkara==117){
				$this->load->model('report/report_pid','report');
				$data['view_lap'] = 'laporan/view_laporan_pn_pidb';
			}elseif($idalurperkara==112){
				$this->load->model('report/report_pid','report');
				$data['view_lap'] = 'laporan/view_laporan_pn_pids';
			}elseif($idalurperkara==113){
				$this->load->model('report/report_pid','report');
				$data['view_lap'] = 'laporan/view_laporan_pn_pidc';
			}elseif($idalurperkara==114){
				$this->load->model('report/report_pid','report');
				$data['view_lap'] = 'laporan/view_laporan_pn_pidl';
			}elseif($idalurperkara==118){
				$this->load->model('report/report_pid_anak','report');
				$data['view_lap'] = 'laporan/view_laporan_pn_pida';
			}elseif($idalurperkara==119){
				$this->load->model('report/report_prapid','report');
				$data['view_lap'] = 'laporan/view_laporan_pn_prapid';
			}
			$data['idalurperkara']=$idalurperkara;
			$data['perkara_nama'] = strtoupper($this->report->getJenisPerkara($idalurperkara));
		}elseif($tahapan==20){
			if($idalurperkara<100){
				$this->load->model('report/report_banding','report');
				$data['view_lap'] = 'laporan/view_laporan_banding';
			}elseif($idalurperkara>=111 || $idalurperkara<=114){
				$this->load->model('report/report_banding_pid','report');
				$data['view_lap'] = 'laporan/view_laporan_banding_pid';				
			}
			$data['perkara_nama'] = strtoupper($this->report->getJenisPerkara($idalurperkara));
		}elseif($tahapan==30){
			$this->load->model('report/report_kasasi','report');
			$data['view_lap'] = 'laporan/view_laporan_kasasi';
			$data['perkara_nama'] = strtoupper($this->report->getJenisPerkara($idalurperkara));
		}elseif($tahapan==40){
			$this->load->model('report/report_pk','report');
			$data['view_lap'] = 'laporan/view_laporan_pk';
			$data['perkara_nama'] = strtoupper($this->report->getJenisPerkara($idalurperkara));
		}elseif($tahapan==50){
			$this->load->model('report/report_eksekusi','report');
			$data['view_lap'] = 'laporan/view_laporan_eksekusi';
			$data['perkara_nama'] = strtoupper($this->report->getJenisPerkara($idalurperkara));
		}elseif($tahapan==60){
			$this->load->model('report/report_grasi','report');
			$data['view_lap'] = 'laporan/view_laporan_grasi';
			$data['perkara_nama'] = strtoupper($this->report->getJenisPerkara($idalurperkara));
		}elseif($tahapan==88){
			$this->load->model('report/report_keuangan','report');
			$data['view_lap'] = 'laporan/view_laporan_keuangan';
		}elseif($tahapan==99){
			$this->load->model('report/report_hhk','report');
			$data['view_lap'] = 'laporan/view_laporan_hhk';
		}
		if($tahapan>=10 AND ($idalurperkara=='1,2' OR $idalurperkara=='3,4' OR $idalurperkara=='15,16')){
			$data['perkara_nama'] ='PERDATA';
		}elseif($tahapan>=10 AND ($idalurperkara=='111,112,113,114,115,116,117,118,119')){
			$data['perkara_nama'] ='PIDANA';
		}
		$data['tahun'] = $tahun;
		$data['bulan'] = $bulan;
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}

		$bln = ($bulan<10)? '0'.$bulan:$bulan;
		$data['period'] = $tahun.'-'.$bln;
		if($tahapan==88){
			$saldo=$this->report->get_saldo_awal($data['period']);
			foreach ($saldo->result() as $row) {
					$data['saldo_awal']=$row->saldo_awal;
					$data['tgl_saldo_awal']=$row->tgl_saldo_awal;
					$data['period_saldo_awal']=substr($data['tgl_saldo_awal'],0,7);
				}	
			$data['laporan'] = $this->report->get_lap_perkara($data['period'],$idalurperkara,$data['period_saldo_awal']);
		}else{
			$data['laporan'] = $this->report->get_lap_perkara($data['period'],$idalurperkara);
		}		
		$data['stat'] = $this->report->get_stat_perkara($data['period'],$idalurperkara);
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}
}